/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderSwitchPayload;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.instruction.BuilderSwitchElement;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;

public class BuilderPackedSwitchPayload
extends BuilderSwitchPayload
implements PackedSwitchPayload {
    public static final Opcode OPCODE = Opcode.PACKED_SWITCH_PAYLOAD;
    @Nonnull
    protected final List<? extends BuilderSwitchElement> switchElements;

    public BuilderPackedSwitchPayload(int startKey, @Nullable List<? extends Label> switchElements) {
        super(OPCODE);
        this.switchElements = switchElements == null ? ImmutableList.of() : Lists.transform(switchElements, (Function)new Function<Label, BuilderSwitchElement>(startKey){
            int key;
            {
                this.key = n;
            }

            @Nullable
            public BuilderSwitchElement apply(@Nullable Label target) {
                if (!$assertionsDisabled && target == null) {
                    throw new AssertionError();
                }
                return new BuilderSwitchElement(BuilderPackedSwitchPayload.this, this.key++, target);
            }
        });
    }

    @Override
    @Nonnull
    public List<? extends SwitchElement> getSwitchElements() {
        return this.switchElements;
    }

    @Override
    public int getCodeUnits() {
        return 4 + this.switchElements.size() * 2;
    }

    @Override
    public Format getFormat() {
        return BuilderPackedSwitchPayload.OPCODE.format;
    }
}

