/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import org.jf.dexlib2.analysis.AnalyzedInstruction;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.instruction.InlineIndexInstruction;
import org.jf.dexlib2.iface.instruction.VariableRegisterInstruction;
import org.jf.dexlib2.immutable.ImmutableMethod;
import org.jf.dexlib2.immutable.ImmutableMethodParameter;
import org.jf.dexlib2.immutable.util.ParamUtil;

public abstract class InlineMethodResolver {
    public static final int STATIC = 8;
    public static final int VIRTUAL = 1;
    public static final int DIRECT = 2;

    @Nonnull
    public static InlineMethodResolver createInlineMethodResolver(int odexVersion) {
        if (odexVersion == 35) {
            return new InlineMethodResolver_version35();
        }
        if (odexVersion == 36) {
            return new InlineMethodResolver_version36();
        }
        throw new RuntimeException(String.format("odex version %d is not supported yet", odexVersion));
    }

    protected InlineMethodResolver() {
    }

    @Nonnull
    private static Method inlineMethod(int accessFlags, @Nonnull String cls, @Nonnull String name, @Nonnull String params, @Nonnull String returnType) {
        ImmutableList paramList = ImmutableList.copyOf(ParamUtil.parseParamString(params));
        return new ImmutableMethod(cls, name, (ImmutableList<? extends ImmutableMethodParameter>)paramList, returnType, accessFlags, null, null);
    }

    @Nonnull
    public abstract Method resolveExecuteInline(@Nonnull AnalyzedInstruction var1);

    private static class InlineMethodResolver_version35
    extends InlineMethodResolver {
        private final Method[] inlineMethods = new Method[]{InlineMethodResolver.access$0(8, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), InlineMethodResolver.access$0(1, "Ljava/lang/String;", "charAt", "I", "C"), InlineMethodResolver.access$0(1, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), InlineMethodResolver.access$0(1, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), InlineMethodResolver.access$0(1, "Ljava/lang/String;", "length", "", "I"), InlineMethodResolver.access$0(8, "Ljava/lang/Math;", "abs", "I", "I"), InlineMethodResolver.access$0(8, "Ljava/lang/Math;", "abs", "J", "J"), InlineMethodResolver.access$0(8, "Ljava/lang/Math;", "abs", "F", "F"), InlineMethodResolver.access$0(8, "Ljava/lang/Math;", "abs", "D", "D"), InlineMethodResolver.access$0(8, "Ljava/lang/Math;", "min", "II", "I"), InlineMethodResolver.access$0(8, "Ljava/lang/Math;", "max", "II", "I"), InlineMethodResolver.access$0(8, "Ljava/lang/Math;", "sqrt", "D", "D"), InlineMethodResolver.access$0(8, "Ljava/lang/Math;", "cos", "D", "D"), InlineMethodResolver.access$0(8, "Ljava/lang/Math;", "sin", "D", "D")};

        @Override
        @Nonnull
        public Method resolveExecuteInline(@Nonnull AnalyzedInstruction analyzedInstruction) {
            InlineIndexInstruction instruction = (InlineIndexInstruction)analyzedInstruction.instruction;
            int inlineIndex = instruction.getInlineIndex();
            if (inlineIndex < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid inline index: " + inlineIndex);
            }
            return this.inlineMethods[inlineIndex];
        }
    }

    private static class InlineMethodResolver_version36
    extends InlineMethodResolver {
        private final Method[] inlineMethods;
        private final Method indexOfIMethod = InlineMethodResolver.access$0(1, "Ljava/lang/String;", "indexOf", "I", "I");
        private final Method indexOfIIMethod = InlineMethodResolver.access$0(1, "Ljava/lang/String;", "indexOf", "II", "I");
        private final Method fastIndexOfMethod = InlineMethodResolver.access$0(2, "Ljava/lang/String;", "fastIndexOf", "II", "I");
        private final Method isEmptyMethod = InlineMethodResolver.access$0(1, "Ljava/lang/String;", "isEmpty", "", "Z");

        public InlineMethodResolver_version36() {
            Method[] methodArray = new Method[29];
            methodArray[0] = InlineMethodResolver.inlineMethod(8, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V");
            methodArray[1] = InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "charAt", "I", "C");
            methodArray[2] = InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I");
            methodArray[3] = InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z");
            methodArray[6] = InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "length", "", "I");
            methodArray[7] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "I", "I");
            methodArray[8] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "J", "J");
            methodArray[9] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "F", "F");
            methodArray[10] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "D", "D");
            methodArray[11] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "min", "II", "I");
            methodArray[12] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "max", "II", "I");
            methodArray[13] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "sqrt", "D", "D");
            methodArray[14] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "cos", "D", "D");
            methodArray[15] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "sin", "D", "D");
            methodArray[16] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "floatToIntBits", "F", "I");
            methodArray[17] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "floatToRawIntBits", "F", "I");
            methodArray[18] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "intBitsToFloat", "I", "F");
            methodArray[19] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "doubleToLongBits", "D", "J");
            methodArray[20] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "doubleToRawLongBits", "D", "J");
            methodArray[21] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "longBitsToDouble", "J", "D");
            methodArray[22] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "I", "I");
            methodArray[23] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "J", "J");
            methodArray[24] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "F", "F");
            methodArray[25] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "D", "D");
            methodArray[26] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "min", "II", "I");
            methodArray[27] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "max", "II", "I");
            methodArray[28] = InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "sqrt", "D", "D");
            this.inlineMethods = methodArray;
        }

        @Override
        @Nonnull
        public Method resolveExecuteInline(@Nonnull AnalyzedInstruction analyzedInstruction) {
            InlineIndexInstruction instruction = (InlineIndexInstruction)analyzedInstruction.instruction;
            int inlineIndex = instruction.getInlineIndex();
            if (inlineIndex < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid method index: " + inlineIndex);
            }
            if (inlineIndex == 4) {
                int parameterCount = ((VariableRegisterInstruction)((Object)instruction)).getRegisterCount();
                if (parameterCount == 2) {
                    return this.indexOfIMethod;
                }
                if (parameterCount == 3) {
                    return this.fastIndexOfMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            if (inlineIndex == 5) {
                int parameterCount = ((VariableRegisterInstruction)((Object)instruction)).getRegisterCount();
                if (parameterCount == 3) {
                    return this.indexOfIIMethod;
                }
                if (parameterCount == 1) {
                    return this.isEmptyMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            return this.inlineMethods[inlineIndex];
        }
    }
}

