/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcode;

public class Opcodes {
    private final Opcode[] opcodesByValue = new Opcode[256];
    private final HashMap<String, Opcode> opcodesByName = Maps.newHashMap();

    public Opcodes(int api) {
        Opcode[] opcodeArray = Opcode.values();
        int n = opcodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Opcode opcode = opcodeArray[n2];
            if (!opcode.format.isPayloadFormat && api <= opcode.getMaxApi() && api >= opcode.getMinApi()) {
                this.opcodesByValue[opcode.value] = opcode;
                this.opcodesByName.put(opcode.name.toLowerCase(), opcode);
            }
            ++n2;
        }
    }

    @Nullable
    public Opcode getOpcodeByName(String opcodeName) {
        return this.opcodesByName.get(opcodeName.toLowerCase());
    }

    @Nullable
    public Opcode getOpcodeByValue(int opcodeValue) {
        switch (opcodeValue) {
            case 256: {
                return Opcode.PACKED_SWITCH_PAYLOAD;
            }
            case 512: {
                return Opcode.SPARSE_SWITCH_PAYLOAD;
            }
            case 768: {
                return Opcode.ARRAY_PAYLOAD;
            }
        }
        return this.opcodesByValue[opcodeValue];
    }
}

