/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class PathUtil {
    private PathUtil() {
    }

    public static File getRelativeFile(File baseFile, File fileToRelativize) throws IOException {
        if (baseFile.isFile()) {
            baseFile = baseFile.getParentFile();
        }
        return new File(PathUtil.getRelativeFileInternal(baseFile.getCanonicalFile(), fileToRelativize.getCanonicalFile()));
    }

    public static String getRelativePath(String basePath, String pathToRelativize) throws IOException {
        File baseFile = new File(basePath);
        if (baseFile.isFile()) {
            baseFile = baseFile.getParentFile();
        }
        return PathUtil.getRelativeFileInternal(baseFile.getCanonicalFile(), new File(pathToRelativize).getCanonicalFile());
    }

    static String getRelativeFileInternal(File canonicalBaseFile, File canonicalFileToRelativize) {
        ArrayList<String> basePath = PathUtil.getPathComponents(canonicalBaseFile);
        ArrayList<String> pathToRelativize = PathUtil.getPathComponents(canonicalFileToRelativize);
        if (!basePath.get(0).equals(pathToRelativize.get(0))) {
            return canonicalFileToRelativize.getPath();
        }
        StringBuilder sb = new StringBuilder();
        int commonDirs = 1;
        while (commonDirs < basePath.size() && commonDirs < pathToRelativize.size()) {
            if (!basePath.get(commonDirs).equals(pathToRelativize.get(commonDirs))) break;
            ++commonDirs;
        }
        boolean first = true;
        int i = commonDirs;
        while (i < basePath.size()) {
            if (!first) {
                sb.append(File.separatorChar);
            } else {
                first = false;
            }
            sb.append("..");
            ++i;
        }
        first = true;
        i = commonDirs;
        while (i < pathToRelativize.size()) {
            if (first) {
                if (sb.length() != 0) {
                    sb.append(File.separatorChar);
                }
                first = false;
            } else {
                sb.append(File.separatorChar);
            }
            sb.append(pathToRelativize.get(i));
            ++i;
        }
        if (sb.length() == 0) {
            return ".";
        }
        return sb.toString();
    }

    private static ArrayList<String> getPathComponents(File file) {
        ArrayList<String> path = new ArrayList<String>();
        while (file != null) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                path.add(0, file.getPath());
            } else {
                path.add(0, file.getName());
            }
            file = parentFile;
        }
        return path;
    }
}

