/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.baksmaliOptions;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.util.SyntheticAccessorResolver;
import org.jf.util.ClassFileNameHandler;
import org.jf.util.IndentingWriter;

public class baksmali {
    public static boolean useLocalsDirective = false;
    public static boolean useSequentialLabels = false;

    public static boolean disassembleDexFile(DexFile dexFile, boolean useLocalsDirective, baksmaliOptions options) {
        boolean errorOccurred;
        baksmali.useLocalsDirective = useLocalsDirective;
        if (options.registerInfo != 0 || options.deodex) {
            try {
                Object extraClassPathEntries = options.extraClassPathEntries != null ? options.extraClassPathEntries : ImmutableList.of();
                options.classPath = ClassPath.fromClassPath(options.bootClassPathDirs, (Iterable)Iterables.concat(options.bootClassPathEntries, (Iterable)extraClassPathEntries), (DexFile)dexFile, (int)options.apiLevel);
            }
            catch (Exception ex) {
                System.err.println("\n\nError occured while loading boot class path files. Aborting.");
                ex.printStackTrace(System.err);
                System.exit(1);
            }
        }
        List classDefs = Ordering.natural().sortedCopy((Iterable)dexFile.getClasses());
        if (!options.noAccessorComments) {
            options.syntheticAccessorResolver = new SyntheticAccessorResolver((Iterable)classDefs);
        }
        return !(errorOccurred = false);
    }

    private static boolean disassembleClass(ClassDef classDef, ClassFileNameHandler fileNameHandler, baksmaliOptions options) {
        String classDescriptor = classDef.getType();
        if (classDescriptor.charAt(0) != 'L' || classDescriptor.charAt(classDescriptor.length() - 1) != ';') {
            System.err.println("Unrecognized class descriptor - " + classDescriptor + " - skipping class");
            return false;
        }
        File smaliFile = fileNameHandler.getUniqueFilenameForClass(classDescriptor);
        ClassDefinition classDefinition = new ClassDefinition(options, classDef);
        Writer writer = null;
        try {
            File smaliParent = smaliFile.getParentFile();
            if (!(smaliParent.exists() || smaliParent.mkdirs() || smaliParent.exists())) {
                System.err.println("Unable to create directory " + smaliParent.toString() + " - skipping class");
                return false;
            }
            if (!smaliFile.exists() && !smaliFile.createNewFile()) {
                System.err.println("Unable to create file " + smaliFile.toString() + " - skipping class");
                return false;
            }
            try {
                BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(smaliFile), "UTF8"));
                writer = new IndentingWriter((Writer)bufWriter);
                classDefinition.writeTo((IndentingWriter)writer);
            }
            catch (Exception ex) {
                System.err.println("\n\nError occured while disassembling class " + classDescriptor.replace('/', '.') + " - skipping class");
                ex.printStackTrace();
                smaliFile.delete();
                return false;
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable ex) {
                    System.err.println("\n\nError occured while closing file " + smaliFile.toString());
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }
}

