/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.ReferenceFormatter;
import org.jf.baksmali.Renderers.LongRenderer;
import org.jf.dexlib2.ReferenceType;
import org.jf.dexlib2.VerificationError;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.instruction.FieldOffsetInstruction;
import org.jf.dexlib2.iface.instruction.FiveRegisterInstruction;
import org.jf.dexlib2.iface.instruction.InlineIndexInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.RegisterRangeInstruction;
import org.jf.dexlib2.iface.instruction.ThreeRegisterInstruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;
import org.jf.dexlib2.iface.instruction.VtableIndexInstruction;
import org.jf.dexlib2.iface.instruction.WideLiteralInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.instruction.formats.UnknownInstruction;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.util.IndentingWriter;

public class InstructionMethodItem<T extends Instruction>
extends MethodItem {
    @Nonnull
    protected final MethodDefinition methodDef;
    @Nonnull
    protected final T instruction;

    public InstructionMethodItem(@Nonnull MethodDefinition methodDef, int codeAddress, @Nonnull T instruction) {
        super(codeAddress);
        this.methodDef = methodDef;
        this.instruction = instruction;
    }

    @Override
    public double getSortOrder() {
        return 100.0;
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        boolean invalidReference = false;
        if (this.instruction instanceof ReferenceInstruction) {
            try {
                Reference reference = ((ReferenceInstruction)this.instruction).getReference();
            }
            catch (DexBackedDexFile.InvalidItemIndex ex) {
                invalidReference = true;
                writer.write("#invalid ");
                writer.write(ReferenceType.toString((int)this.instruction.getOpcode().referenceType));
                writer.write(" index: ");
                writer.printSignedIntAsDec(ex.getInvalidIndex());
                writer.write("\n#");
            }
        }
        switch (this.instruction.getOpcode().format) {
            case Format10t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeTargetLabel(writer);
                return true;
            }
            case Format10x: {
                if (this.instruction instanceof UnknownInstruction) {
                    writer.write("#unknown opcode: 0x");
                    writer.printUnsignedLongAsHex((long)((UnknownInstruction)this.instruction).getOriginalOpcode());
                    writer.write(10);
                }
                this.writeOpcode(writer);
                return true;
            }
            case Format11n: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeLiteral(writer);
                return true;
            }
            case Format11x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                return true;
            }
            case Format12x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                return true;
            }
            case Format20bc: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeVerificationErrorType(writer);
                writer.write(", ");
                this.writeReference(writer);
                return true;
            }
            case Format20t: 
            case Format30t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeTargetLabel(writer);
                return true;
            }
            case Format21c: 
            case Format31c: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeReference(writer);
                return true;
            }
            case Format21ih: 
            case Format21lh: 
            case Format21s: 
            case Format31i: 
            case Format51l: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeLiteral(writer);
                return true;
            }
            case Format21t: 
            case Format31t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeTargetLabel(writer);
                return true;
            }
            case Format22b: 
            case Format22s: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeLiteral(writer);
                return true;
            }
            case Format22c: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeReference(writer);
                return true;
            }
            case Format22cs: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeFieldOffset(writer);
                return true;
            }
            case Format22t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeTargetLabel(writer);
                return true;
            }
            case Format22x: 
            case Format32x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                return true;
            }
            case Format23x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeThirdRegister(writer);
                return true;
            }
            case Format35c: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRegisters(writer);
                writer.write(", ");
                this.writeReference(writer);
                return true;
            }
            case Format35mi: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRegisters(writer);
                writer.write(", ");
                this.writeInlineIndex(writer);
                return true;
            }
            case Format35ms: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRegisters(writer);
                writer.write(", ");
                this.writeVtableIndex(writer);
                return true;
            }
            case Format3rc: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRangeRegisters(writer);
                writer.write(", ");
                this.writeReference(writer);
                return true;
            }
            case Format3rmi: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRangeRegisters(writer);
                writer.write(", ");
                this.writeInlineIndex(writer);
                return true;
            }
            case Format3rms: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRangeRegisters(writer);
                writer.write(", ");
                this.writeVtableIndex(writer);
                return true;
            }
        }
        assert (false);
        return false;
    }

    protected void writeOpcode(IndentingWriter writer) throws IOException {
        writer.write(this.instruction.getOpcode().name);
    }

    protected void writeTargetLabel(IndentingWriter writer) throws IOException {
        throw new RuntimeException();
    }

    protected void writeRegister(IndentingWriter writer, int registerNumber) throws IOException {
        this.methodDef.registerFormatter.writeTo(writer, registerNumber);
    }

    protected void writeFirstRegister(IndentingWriter writer) throws IOException {
        this.writeRegister(writer, ((OneRegisterInstruction)this.instruction).getRegisterA());
    }

    protected void writeSecondRegister(IndentingWriter writer) throws IOException {
        this.writeRegister(writer, ((TwoRegisterInstruction)this.instruction).getRegisterB());
    }

    protected void writeThirdRegister(IndentingWriter writer) throws IOException {
        this.writeRegister(writer, ((ThreeRegisterInstruction)this.instruction).getRegisterC());
    }

    protected void writeInvokeRegisters(IndentingWriter writer) throws IOException {
        FiveRegisterInstruction instruction = (FiveRegisterInstruction)this.instruction;
        int regCount = instruction.getRegisterCount();
        writer.write(123);
        switch (regCount) {
            case 1: {
                this.writeRegister(writer, instruction.getRegisterC());
                break;
            }
            case 2: {
                this.writeRegister(writer, instruction.getRegisterC());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterD());
                break;
            }
            case 3: {
                this.writeRegister(writer, instruction.getRegisterC());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                break;
            }
            case 4: {
                this.writeRegister(writer, instruction.getRegisterC());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterF());
                break;
            }
            case 5: {
                this.writeRegister(writer, instruction.getRegisterC());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterF());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterG());
            }
        }
        writer.write(125);
    }

    protected void writeInvokeRangeRegisters(IndentingWriter writer) throws IOException {
        RegisterRangeInstruction instruction = (RegisterRangeInstruction)this.instruction;
        int regCount = instruction.getRegisterCount();
        if (regCount == 0) {
            writer.write("{}");
        } else {
            int startRegister = instruction.getStartRegister();
            this.methodDef.registerFormatter.writeRegisterRange(writer, startRegister, startRegister + regCount - 1);
        }
    }

    protected void writeLiteral(IndentingWriter writer) throws IOException {
        LongRenderer.writeSignedIntOrLongTo(writer, ((WideLiteralInstruction)this.instruction).getWideLiteral());
    }

    protected void writeFieldOffset(IndentingWriter writer) throws IOException {
        writer.write("field@0x");
        writer.printUnsignedLongAsHex((long)((FieldOffsetInstruction)this.instruction).getFieldOffset());
    }

    protected void writeInlineIndex(IndentingWriter writer) throws IOException {
        writer.write("inline@");
        writer.printSignedIntAsDec(((InlineIndexInstruction)this.instruction).getInlineIndex());
    }

    protected void writeVtableIndex(IndentingWriter writer) throws IOException {
        writer.write("vtable@");
        writer.printSignedIntAsDec(((VtableIndexInstruction)this.instruction).getVtableIndex());
    }

    protected void writeReference(IndentingWriter writer) throws IOException {
        try {
            ReferenceFormatter.writeReference(writer, this.instruction.getOpcode().referenceType, ((ReferenceInstruction)this.instruction).getReference());
        }
        catch (DexBackedDexFile.InvalidItemIndex ex) {
            writer.write(ReferenceType.toString((int)this.instruction.getOpcode().referenceType));
            writer.write("@");
            writer.printSignedIntAsDec(ex.getInvalidIndex());
        }
    }

    protected void writeVerificationErrorType(IndentingWriter writer) throws IOException {
        int verificationError = ((Instruction20bc)this.instruction).getVerificationError();
        writer.write(VerificationError.getVerificationErrorName((int)verificationError));
    }
}

