enum {
	XGUI_NONE = 0,
	XGUI_STATIC,
	XGUI_BUTTON,
	XGUI_BUTTON_CONFIRM,
	XGUI_CHECKBOX,
	XGUI_PICTURE
}; 

SDL_Texture* xgui_load_jpg(const char* filename, SDL_Renderer* renderer);
SDL_Texture* xgui_load_png(const char* filename, SDL_Renderer* renderer);

void xgui_init(const char* dir, SDL_Renderer* renderer);
void xgui_done(void);
void xgui_update(int w, int h, int mouse_x, int mouse_y, int mouse_button);
void xgui_render(SDL_Renderer* renderer, int w, int h);
void xgui_enable(bool e);
bool xgui_is_enabled(void);
SDL_Rect xgui_put_char(SDL_Renderer* renderer, int w, int h, int sx, int sy, char c);
SDL_Rect xgui_put_str(SDL_Renderer* renderer, int w, int h, int sx, int sy, const char* str);
void xgui_clear(void);
int xgui_add(int type, int page, int x, int y, const char* text);
void xgui_visible(int id, bool visible);
void xgui_pos(int id, int x, int y);
bool xgui_is_down(int id);
void xgui_set_check(int id, bool check);
int xgui_is_checked(int id);
void xgui_set_text(int id, const char* text);
void xgui_picture_load(int id, SDL_Renderer* renderer, const char* filename);
void xgui_select_page(int page);