FILE *logFile = NULL;

void log_open(const char *name)
{
	logFile = fopen(name, "wt");
}

void log_add(const char *format,...)
{
	va_list argList;

	if (!logFile) return;
	
	va_start(argList, format);
	vfprintf(logFile, format, argList);
	va_end(argList);
	
	fflush(logFile);
}

void log_close(void)
{
	if (!logFile) return;
	
	fclose(logFile);
	
	logFile = NULL;
}
