Scriptname RainmakerMCMScript extends SKI_ConfigBase

GlobalVariable Property RainmakerExp  Auto  
GlobalVariable Property RainmakerLevel  Auto  
GlobalVariable Property RainmakerPerkPoint  Auto  
GlobalVariable Property RainmakerTotalPerkPoint  Auto  
GlobalVariable Property RainmakerNoPerk  Auto
GlobalVariable Property RainmakerExPMultiPlier  Auto
GlobalVariable Property RainmakerNeverEnd  Auto

Perk Property PerkGentleRain  Auto  
Perk Property PerkMercyRain  Auto  
Perk Property PerkObscureRain  Auto  
Perk Property PerkPurpleRain  Auto  
Perk Property PerkRainsNourishment  Auto  
Perk Property PerkRainsInspiration  Auto  
Perk Property PerkRainsFury  Auto  
Perk Property PerkDancerInTheRain  Auto  
Perk Property PerkSinginInTheRain  Auto  
Perk Property PerkSilenceInTheRain  Auto  
Perk Property PerkWarmRain  Auto  
Perk Property PerkRainmancer  Auto  
Perk Property PerkShelterOfTheRain  Auto  
Perk Property PerkHarvestRain  Auto  
Perk Property PerkDissolveIntoTheRain  Auto  
Perk Property PerkCatchTheRainbow  Auto  
Perk Property PerkSoundOfTheRain  Auto  
Perk Property PerkNeverEndingRain  Auto  

SPELL Property SpellTitleNovice  Auto  
SPELL Property SpellTitleApprentice  Auto  
SPELL Property SpellTitleAdept  Auto  
SPELL Property SpellTitleExpert  Auto  
SPELL Property SpellTitleMaster  Auto  

SPELL Property SpellLimitExp  Auto  
SPELL Property SpellPrayingRegen  Auto  
SPELL Property SpellCallingRain  Auto  

MagicEffect Property MagicEffectLimitExp Auto

; -----

String[] RmTitleList
Float ExPMultiplier

; -----

Event OnInit()
	parent.OnInit()

	RmTitleList = new String[6]
	RmTitleList[0] = "$RmTitleNovice"
	RmTitleList[1] = "$RmTitleApprentice"
	RmTitleList[2] = "$RmTitleAdept"
	RmTitleList[3] = "$RmTitleExpert"
	RmTitleList[4] = "$RmTitleMaster"
	RmTitleList[5] = "$Cancel"

	ExPMultiPlier = RainmakerExPMultiPlier.GetValueInt() / 100

endEvent

; -----

Event OnPageReset(String Page)
	If Page == ""
		LoadCustomContent("Rainmaker/title.dds")
		Return
	Else
		UnloadCustomContent()
	EndIf

	If Page == "$RmOptions"

	    SetCursorFillMode(TOP_TO_BOTTOM)
	    SetCursorPosition(0)


	    ; ===OPTIONS========================

	    AddHeaderOption("$RmGameplay")

		AddSliderOptionST("OID_ExPMultiplier", "$RmExpMultiplier", ExpMultiplier, "{1}")

    	AddToggleOptionST("OID_DisablePerk", "$RmDisablePerk", RainmakerNoPerk.GetValueInt())

		AddEmptyOption()

	    ; ===DEBUG========================

	    AddHeaderOption("$RmDebug")

    	AddMenuOptionST("OID_DebugRespec", "$RmRespec", "$RmSelectRank")

    	AddTextOptionST("OID_DebugReset", "$RmReset", "$ClickHere")

		AddEmptyOption()

	    ; ===STATUS========================

	    SetCursorPosition(1)

	    AddHeaderOption("$RmStatus")

		; Set Title Text

		String RmTitle = "-"
		Int RmLevel = RainmakerLevel.GetValueInt()
		If RmLevel == 5
			RmTitle = "$RmTitleMaster"
		ElseIf RmLevel == 4
			RmTitle = "$RmTitleExpert"
		ElseIf RmLevel == 3
			RmTitle = "$RmTitleAdept"
		ElseIf RmLevel == 2
			RmTitle = "$RmTitleApprentice"
		ElseIf RmLevel == 1
			RmTitle = "$RmTitleNovice"
		EndIf
		AddTextOptionST("OID_StatusTitle", "$RmTitlePrefix", RmTitle)

		; Set Exp Progress Text

		AddTextOptionST("OID_StatusProgress", "$RmProgressPrefix", RainmakerExp.GetValueInt() + "%")

		; Set Limit Exp Text

		If !Game.GetPlayer().HasMagicEffect(MagicEffectLimitExp)
			AddTextOption("", "$RmExpNotLimited")
		EndIf

		AddEmptyOption()

	EndIf
EndEvent

; -----

State OID_ExPMultiplier
	event OnSliderOpenST()
		SetSliderDialogStartValue(ExpMultiplier)
		Float DefaultValue = RainmakerExpMultiplier.GetValue() / 100
		SetSliderDialogDefaultValue(DefaultValue)
		SetSliderDialogRange(0, 2.0)
		SetSliderDialogInterval(0.1)
	endEvent

	event OnSliderAcceptST(float value)
		ExpMultiplier = value
		SetSliderOptionValueST(ExpMultiplier, "{1}")
		RainmakerExpMultiplier.SetValueInt(Math.Floor(ExpMultiplier * 100))
	endEvent

	event OnDefaultST()
		ExpMultiplier = RainmakerExpMultiplier.GetValue() / 100
		SetSliderOptionValueST(ExpMultiplier, "{1}")
	endEvent

	event OnHighlightST()
		SetInfoText("$RmExpMultiplierInfo")
	endEvent
EndState

; -----

State OID_DisablePerk
    Event OnHighlightST()
        SetInfoText("$RmDisablePerkInfo")
    EndEvent

    Event OnSelectST()
        If RainmakerNoPerk.GetValue() == 1
            RainmakerNoPerk.SetValue(0)
            SetToggleOptionValueST(0)
        ElseIf RainmakerNoPerk.GetValue() == 0
            RainmakerNoPerk.SetValue(1)
            SetToggleOptionValueST(1)
        EndIf
    EndEvent
EndState

; -----

State OID_StatusTitle
    Event OnHighlightST()
        SetInfoText("$RmStatusTitleInfo")
    EndEvent
EndState

; -----

State OID_StatusProgress
    Event OnHighlightST()
        SetInfoText("$RmStatusProgressInfo")
    EndEvent
EndState

; -----

State OID_DebugRespec
    Event OnHighlightST()
        SetInfoText("$RmRespecInfo")
    EndEvent

    Event OnMenuOpenST()
		SetMenuDialogOptions(RmTitleList)
		SetMenuDialogStartIndex(0)
		SetMenuDialogDefaultIndex(0)
	endEvent

	Event OnMenuAcceptST(Int Index)
		Int TitleIndex = Index
		If TitleIndex == 5 ; Cancel
			Return
		EndIf
		Bool Confirm = ShowMessage("$RmRespecConfirm", true)
		If Confirm

			; Reset

			RainmakerLevel.SetValueInt(0)
			RainmakerPerkPoint.SetValueInt(0)
			RainmakerTotalPerkPoint.SetValueInt(0)
			RainmakerNeverEnd.SetValueInt(0)

    		Actor Player = Game.GetPlayer()

			Player.RemovePerk(PerkGentleRain)
			Player.RemovePerk(PerkMercyRain)
			Player.RemovePerk(PerkObscureRain)
			Player.RemovePerk(PerkPurpleRain)
			Player.RemovePerk(PerkRainsNourishment)
			Player.RemovePerk(PerkRainsInspiration)
			Player.RemovePerk(PerkRainsFury)
			Player.RemovePerk(PerkDancerInTheRain)
			Player.RemovePerk(PerkSinginInTheRain)
			Player.RemovePerk(PerkSilenceInTheRain)
			Player.RemovePerk(PerkWarmRain)
			Player.RemovePerk(PerkRainmancer)
			Player.RemovePerk(PerkShelterOfTheRain)
			Player.RemovePerk(PerkHarvestRain)
			Player.RemovePerk(PerkDissolveIntoTheRain)
			Player.RemovePerk(PerkCatchTheRainbow)
			Player.RemovePerk(PerkSoundOfTheRain)
			Player.RemovePerk(PerkNeverEndingRain)

			Player.RemoveSpell(SpellTitleNovice)  
			Player.RemoveSpell(SpellTitleApprentice)  
			Player.RemoveSpell(SpellTitleAdept)  
			Player.RemoveSpell(SpellTitleExpert)  
			Player.RemoveSpell(SpellTitleMaster)  
			
			Player.DispelSpell(SpellLimitExp)
			Player.DispelSpell(SpellCallingRain)

			; Respec

			Int RmExp = 0
			; Int PerkPoint = 0

			If TitleIndex == 0 ; Novice
				RmExp = 100
			ElseIf TitleIndex == 1 ; Apprentice
				RmExp = 200
			ElseIf TitleIndex == 2 ; Adept
				RmExp = 400
			ElseIf TitleIndex == 3 ; Expert
				RmExp = 600
			ElseIf TitleIndex == 4 ; Master
				RmExp = 900
			EndIf

			RainmakerExp.SetValueInt(RmExp)

			SetMenuOptionValueST(RmTitleList[TitleIndex])

			ShowMessage("$RmRespecNote", false)
		EndIf
	EndEvent
EndState

; -----

State OID_DebugReset
    Event OnHighlightST()
        SetInfoText("$RmResetInfo")
    EndEvent

    Event OnSelectST()
    	Bool Confirm = ShowMessage("$RmResetConfirm", true)
    	If Confirm
    		Actor Player = Game.GetPlayer()

			RainmakerExp.SetValueInt(0)
			RainmakerLevel.SetValueInt(0)
			RainmakerPerkPoint.SetValueInt(0)
			RainmakerTotalPerkPoint.SetValueInt(0)
			RainmakerNoPerk.SetValueInt(0)
			RainmakerExPMultiPlier.SetValueInt(100)
			RainmakerNeverEnd.SetValueInt(0)

			Player.RemovePerk(PerkGentleRain)
			Player.RemovePerk(PerkMercyRain)
			Player.RemovePerk(PerkObscureRain)
			Player.RemovePerk(PerkPurpleRain)
			Player.RemovePerk(PerkRainsNourishment)
			Player.RemovePerk(PerkRainsInspiration)
			Player.RemovePerk(PerkRainsFury)
			Player.RemovePerk(PerkDancerInTheRain)
			Player.RemovePerk(PerkSinginInTheRain)
			Player.RemovePerk(PerkSilenceInTheRain)
			Player.RemovePerk(PerkWarmRain)
			Player.RemovePerk(PerkRainmancer)
			Player.RemovePerk(PerkShelterOfTheRain)
			Player.RemovePerk(PerkHarvestRain)
			Player.RemovePerk(PerkDissolveIntoTheRain)
			Player.RemovePerk(PerkCatchTheRainbow)
			Player.RemovePerk(PerkSoundOfTheRain)
			Player.RemovePerk(PerkNeverEndingRain)
			Player.RemoveSpell(SpellTitleNovice)  
			Player.RemoveSpell(SpellTitleApprentice)  
			Player.RemoveSpell(SpellTitleAdept)  
			Player.RemoveSpell(SpellTitleExpert)  
			Player.RemoveSpell(SpellTitleMaster) 
			Player.DispelSpell(SpellLimitExp)
			Player.DispelSpell(SpellCallingRain)
			Return
		EndIf
    EndEvent
EndState