Scriptname CallRainScript extends activemagiceffect  

; -----

Actor Property PlayerRef Auto

Spell Property PrayerSpell Auto

Furniture Property zzSRPrayerMat Auto

Sound Property MAGFail Auto
Sound Property SoundPray  Auto  

Perk Property PerkGentleRain  Auto  
Perk Property PerkMercyRain  Auto  
Perk Property PerkObscureRain  Auto  
Perk Property PerkPurpleRain  Auto  
Perk Property PerkRainsNourishment  Auto  
Perk Property PerkRainsInspiration  Auto  
Perk Property PerkRainsFury  Auto  
Perk Property PerkDancerInTheRain  Auto  
Perk Property PerkSinginInTheRain  Auto  
Perk Property PerkSilenceInTheRain  Auto  
Perk Property PerkWarmRain  Auto  
Perk Property PerkRainmancer  Auto  
Perk Property PerkShelterOfTheRain  Auto  
Perk Property PerkHarvestRain  Auto  
Perk Property PerkDissolveIntoTheRain  Auto  
Perk Property PerkCatchTheRainbow  Auto  
Perk Property PerkSoundOfTheRain  Auto  
Perk Property PerkNeverEndingRain  Auto  

SPELL Property SpellTitleNovice  Auto  
SPELL Property SpellTitleApprentice  Auto  
SPELL Property SpellTitleAdept  Auto  
SPELL Property SpellTitleExpert  Auto  
SPELL Property SpellTitleMaster  Auto  

SPELL Property SpellLimitExp  Auto  
MagicEffect Property MagicEffectLimitExp  Auto  

SPELL Property SpellPrayingRegen  Auto  

GlobalVariable Property RainmakerExp  Auto  
GlobalVariable Property RainmakerExpMultiplier  Auto  
GlobalVariable Property RainmakerLevel  Auto  
GlobalVariable Property RainmakerPerkPoint  Auto  
GlobalVariable Property RainmakerTotalPerkPoint  Auto  
GlobalVariable Property RainmakerDebug  Auto
GlobalVariable Property RainmakerNoPerk  Auto
GlobalVariable Property RainmakerNeverEnd  Auto

Weather Property CloudWeather  Auto
Weather Property LightRainWeather  Auto  
Weather Property RainWeather  Auto  
Weather Property HeavyRainWeather  Auto  
Weather Property StormWeather  Auto  

Message Property MessageFailSnow Auto
Message Property MessagePraying Auto
Message Property MessageRefreshing Auto
Message Property MessageFinishPraying Auto
Message Property MessageSkillAdvanced Auto

Message Property MessageTitleNovice Auto
Message Property MessageTitleApprentice Auto
Message Property MessageTitleAdept Auto
Message Property MessageTitleExpert Auto
Message Property MessageTitleMaster Auto
Message Property MessageTitleEx1 Auto
Message Property MessageTitleEx2 Auto
Message Property MessageTitleEx3 Auto
Message Property MessageTitleEx4 Auto
Message Property MessageAwardMaster Auto

Message Property MessageLearnPerk  Auto  
Message Property MessageLearnAdvancedPerk  Auto  

Message Property MessagePerkGentleRain  Auto  
Message Property MessagePerkMercyRain  Auto  
Message Property MessagePerkObscureRain  Auto  
Message Property MessagePerkPurpleRain  Auto  
Message Property MessagePerkRainsNourishment  Auto  
Message Property MessagePerkRainsInspiration  Auto  
Message Property MessagePerkRainsFury  Auto  
Message Property MessagePerkDancerInTheRain  Auto  
Message Property MessagePerkSinginInTheRain  Auto  
Message Property MessagePerkSilenceInTheRain  Auto  
Message Property MessagePerkWarmRain  Auto  
Message Property MessagePerkRainmancer  Auto  
Message Property MessagePerkShelterOfTheRain  Auto  
Message Property MessagePerkHarvestRain  Auto  
Message Property MessagePerkDissolveIntoTheRain  Auto  
Message Property MessagePerkCatchTheRainbow  Auto  
Message Property MessagePerkSoundOfTheRain  Auto  
Message Property MessagePerkNeverEndingRain  Auto  
Message Property MessageDontLearnPerk Auto

; -----

Actor CasterActor
ObjectReference CreatedObject
Weather NextWeather

Int UpdateCount = 0  
Int CurrentRainLevel = 0  
Int RainPower = 0  
Int RmLevel = 0
Int RmExp = 0
Bool CanGainExp = false
Bool Refreshing = false
Bool Override = false
Bool Accelerate = false

; -----

Event OnEffectStart(Actor akTarget, Actor akCaster)
	CasterActor = akCaster

	Weather CurrentWeather = Weather.GetCurrentWeather()
	Int WeatherClass = CurrentWeather.GetClassification()
	RmExp = RainmakerExp.GetValueInt()
	RmLevel = RainmakerLevel.GetValueInt()

	; Cancel if it is snowing and don't have Warm Rain perk
	If WeatherClass == 3 && !CasterActor.HasPerk(PerkWarmRain)
		MessageFailSnow.Show()
		MAGFail.Play(CasterActor)
		PlayerRef.DispelSpell(PrayerSpell)
		Return
	Endif

	; Debug: Make sure Override is correctly set
	If RainmakerNeverEnd.GetValue()
		Override = true
	Else
		Override = false
	EndIf

	; Release Override
	If CasterActor.HasPerk(PerkNeverEndingRain) && !Override
		Weather.ReleaseOverride()
		Debug.Notification("Debug: This rain should not end")
	EndIf

	; Play Praying Idle
	CreatedObject = akTarget.PlaceAtMe(zzSRPrayerMat, abInitiallyDisabled = true)
	Float CasterAngle = akCaster.GetAngleZ()
	CreatedObject.MoveTo(akCaster, 0, 0, 0)
	CreatedObject.SetAngle(0, 0, CasterAngle)
	CreatedObject.Enable()
	CreatedObject.Activate(akTarget, true)
	;SoundPray.Play(CasterActor)

	; You can gain exp if it is not raining or you have not gain exp for a while
	If RmLevel < 5 && (WeatherClass != 2 || !CasterActor.HasMagicEffect(MagicEffectLimitExp))
		CanGainExp = true
	Endif

	; First attempt
	; Cast Heavy Rain if it is already raining.
	If WeatherClass == 2
		CurrentRainLevel = 2
		NextWeather = HeavyRainWeather
	; Cast Light Rain otherwise.
	Else
		CurrentRainLevel = 1
		NextWeather = Weather.FindWeather(2)
		If NextWeather == NONE
			NextWeather = LightRainWeather
		Endif
	Endif
	MessagePraying.Show()
	If Override
		NextWeather.SetActive(true)
		Debug.Notification("Debug: This rain should not end")
	Else
		NextWeather.SetActive(false)
	EndIf

	PlayerRef.AddSpell(SpellPrayingRegen, false)

	RegisterForUpdate(0.5)

EndEvent

; -----

Event OnEffectFinish(Actor akTarget, Actor akCaster)

	Weather CurrentWeather = Weather.GetCurrentWeather()
	Int WeatherClass = CurrentWeather.GetClassification()

	While akTarget.GetSitState() != 0
		Utility.Wait(0.5)
	EndWhile

	Game.DisablePlayerControls(False, False, False, False, False, True)
	Utility.Wait(0.01)
	Game.EnablePlayerControls(False, False, False, False, False, True)

	; Level up before exp gain (for respec)
	While RmExp >= 100
		RainmakerLevelUp()
		If !RainmakerNoPerk.GetValueInt()
			RainmakerLearnPerk()
		EndIf
		RmExp -= 100
	EndWhile

	; Gain Rainmaker Experience
	If WeatherClass == 2 && CanGainExp
		MessageSkillAdvanced.Show()
		Int AddExp = 0
		If RmLevel == 0 ; to Novice
			AddExp = 100
		ElseIf RmLevel == 1 ; to Apprentice
			AddExp = 34
		ElseIf RmLevel == 2 ; to Adept
			AddExp = 19
		ElseIf RmLevel == 3 ; to Expert
			AddExp = 9
		ElseIf RmLevel == 4 ; to Master
			AddExp = 8
		ElseIf RmLevel >= 5
			AddExp = 0
		EndIf
		If CasterActor.HasMagicEffect(MagicEffectLimitExp)
			AddExp /= 2
		Else
			SpellLimitExp.Cast(CasterActor, CasterActor)
		Endif
		AddExp = Math.Ceiling(AddExp * RainmakerExpMultiPlier.GetValueInt() / 100)
		RmExp += AddExp
	Endif

	; Level up
	If RmExp >= 100
		RainmakerLevelUp()
		If !RainmakerNoPerk.GetValueInt()
			RainmakerLearnPerk()
		EndIf
		RmExp = 0
	EndIf
	
	RainmakerExp.SetValueInt(RmExp)

	; Dispel Effects
	PlayerRef.RemoveSpell(SpellPrayingRegen)
	CreatedObject.Disable(true)
	Utility.Wait(5.0)
	CreatedObject.Delete()
	PlayerRef.DispelSpell(PrayerSpell)

EndEvent

; -----

Event OnUpdate()
	
	UpdateCount += 1

	; Cease Praying
	Int Sit = CasterActor.GetSitState()
	CasterActor.GetCombatState()	;bugfix
	If CasterActor.GetCombatState() != 0 || Sit == 0 || Sit == 4
		PlayerRef.DispelSpell(PrayerSpell)
	EndIf

	Float CurrentTransition = Weather.GetCurrentWeatherTransition()
	Weather CurrentWeather = Weather.GetCurrentWeather()
	Int WeatherClass = CurrentWeather.GetClassification()

	; Return if the weather is in transition
	If UpdateCount % 10 == 0 && RainmakerDebug.GetValue()
		Debug.Notification("Debug: Weather Transition " + CurrentTransition * 100 + "%")
	Endif
	If CurrentTransition != 1.0 || UpdateCount < 2
		Return
	Endif

	; Add Refreshing state if it is raining
	If !Refreshing && WeatherClass == 2
		MessageRefreshing.Show()
		Refreshing = true
	Endif

	RainPower += 1
	If RmLevel >= 2
		RainPower += 1
	EndIf

	; It is not raining (the weather was in transition to non-rain weather when praying started )
	If WeatherClass != 2
		MessagePraying.Show()
		CurrentRainLevel = 1
		RainPower = 0
		NextWeather = Weather.FindWeather(2)
		If NextWeather == NONE
			NextWeather = LightRainWeather
		Endif
		If Override
			NextWeather.SetActive(true)
		Else
			NextWeather.SetActive(false)
		EndIf

	; It is raining
	ElseIf CurrentRainLevel == 1 && RainPower > 20
		MessagePraying.Show()
		CurrentRainLevel = 2
		RainPower = 0
		If Override
			HeavyRainWeather.SetActive(true)
		Else
			HeavyRainWeather.SetActive(false)
		EndIf

	; It is raining heavily
	Elseif CurrentRainLevel == 2 && RainPower > 20
		MessagePraying.Show()
		CurrentRainLevel = 3
		RainPower = 0
		If Override
			StormWeather.SetActive(true)
		Else
			StormWeather.SetActive(false)
		EndIf

	; It is stormy
	Elseif CurrentRainLevel == 3
		MessageFinishPraying.Show()
		CurrentRainLevel = 99

	Endif

EndEvent

; -----

Function RainmakerLevelUp()
	Int TotalPerkPoint = RainmakerTotalPerkPoint.GetValueInt()
	TotalPerkPoint += 1
	If TotalPerkPoint == 9
		RmLevel = 5
		MessageTitleMaster.Show()
		MessageAwardMaster.Show()
		CasterActor.AddSpell(SpellTitleMaster, false)
		CasterActor.RemoveSpell(SpellTitleExpert)  
	ElseIf TotalPerkPoint == 8
		MessageTitleEx4.Show()
	ElseIf TotalPerkPoint == 7
		MessageTitleEx3.Show()
	ElseIf TotalPerkPoint == 6
		RmLevel = 4
		MessageTitleExpert.Show()
		CasterActor.AddSpell(SpellTitleExpert, false)
		CasterActor.RemoveSpell(SpellTitleAdept)
	Elseif TotalPerkPoint == 5
		MessageTitleEx2.Show()
	Elseif TotalPerkPoint == 4
		RmLevel = 3
		MessageTitleAdept.Show()
		CasterActor.AddSpell(SpellTitleAdept, false)
		CasterActor.RemoveSpell(SpellTitleApprentice)
	Elseif TotalPerkPoint == 3
		MessageTitleEx1.Show()
	ElseIf TotalPerkPoint == 2
		RmLevel = 2
		MessageTitleApprentice.Show()
		CasterActor.AddSpell(SpellTitleApprentice, false)
		CasterActor.RemoveSpell(SpellTitleNovice)  
	ElseIf TotalPerkPoint == 1
		RmLevel = 1
		MessageTitleNovice.Show()
		CasterActor.AddSpell(SpellTitleNovice, false)
	EndIf
	RainmakerLevel.SetValueInt(RmLevel)
	RainmakerExp.SetValueInt(RmExp)
	RainmakerTotalPerkPoint.SetValueInt(TotalPerkPoint)
EndFunction

Function RainmakerLearnPerk(Int aiMessage = 0, Int aiButton = 0, Bool abMenu = True)
	Int TotalPerkPoint = RainmakerTotalPerkPoint.GetValueInt()
	Int BasicPerksLeft = 6 - TotalPerkPoint
	Int AdvancedPerksLeft = 9 - TotalPerkPoint
	Bool PerkMenu = BasicPerksLeft > 0
	Bool AdvPerkMenu = TotalPerkPoint > 3 && AdvancedPerksLeft > 0

	While PerkMenu
		If aiButton == -1 ; As above, can prevent problems if recycling aiButton
		ElseIf aiMessage == 0
			aiButton = MessageLearnPerk.Show(BasicPerksLeft)
			If aiButton == 0
				aiButton = MessagePerkGentleRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkGentleRain)
					PerkMenu = false
				EndIf
			ElseIf aiButton == 1
				aiButton = MessagePerkMercyRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkMercyRain)
					PerkMenu = false
				EndIf
			ElseIf aiButton == 2
				aiButton = MessagePerkObscureRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkObscureRain)
					PerkMenu = false
				EndIf
			ElseIf aiButton == 3
				aiButton = MessagePerkPurpleRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkPurpleRain)
					PerkMenu = false
				EndIf
			ElseIf aiButton == 4
				aiButton = MessagePerkRainsNourishment.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkRainsNourishment)
					PerkMenu = false
				EndIf
			ElseIf aiButton == 5
				aiButton = MessagePerkRainsInspiration.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkRainsInspiration)
					PerkMenu = false
				EndIf
			ElseIf aiButton == 6
				aiButton = MessagePerkShelterOfTheRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkShelterOfTheRain)
					PerkMenu = false
				EndIf
			ElseIf aiButton == 7
				aiButton = MessagePerkDancerInTheRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkDancerInTheRain)
					PerkMenu = false
				EndIf
			ElseIf aiButton == 8
				aiButton = MessagePerkSinginInTheRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkSinginInTheRain)
					PerkMenu = false
				EndIf
			ElseIf aiButton == 9
				aiButton = MessagePerkSilenceInTheRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkSilenceInTheRain)
					PerkMenu = false
				EndIf
			EndIf
		EndIf
	EndWhile

	While AdvPerkMenu
		If aiButton == -1 ; As above, can prevent problems if recycling aiButton
		ElseIf aiMessage == 0
			aiButton = MessageLearnAdvancedPerk.Show(AdvancedPerksLeft)
			If aiButton == 0
				aiButton = MessagePerkWarmRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkWarmRain)
					AdvPerkMenu = false
				EndIf
			ElseIf aiButton == 1
				aiButton = MessagePerkRainmancer.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkRainmancer)
					AdvPerkMenu = false
				EndIf
			ElseIf aiButton == 2
				aiButton = MessagePerkRainsFury.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkRainsFury)
					AdvPerkMenu = false
				EndIf
			ElseIf aiButton == 3
				aiButton = MessagePerkHarvestRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkHarvestRain)
					AdvPerkMenu = false
				EndIf
			ElseIf aiButton == 4
				aiButton = MessagePerkDissolveIntoTheRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkDissolveIntoTheRain)
					AdvPerkMenu = false
				EndIf
			ElseIf aiButton == 5
				aiButton = MessagePerkCatchTheRainbow.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkCatchTheRainbow)
					AdvPerkMenu = false
				EndIf
			ElseIf aiButton == 6
				aiButton = MessagePerkSoundOfTheRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkSoundOfTheRain)
					AdvPerkMenu = false
				EndIf
			ElseIf aiButton == 7
				aiButton = MessagePerkNeverEndingRain.Show()
				If aiButton == 1
					CasterActor.AddPerk(PerkNeverEndingRain)
					AdvPerkMenu = false
				EndIf
			ElseIf aiButton == 8
				aiButton = MessageDontLearnPerk.Show()
				If aiButton == 1
					AdvPerkMenu = false
				EndIf
			EndIf
		EndIf
	EndWhile
EndFunction