﻿/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Photoshop Character Components Exporter V1.0
// Dated: 1st October 2018
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// TEST PSD: T:\three_kingdoms\resource\UI\_TEMPLATES\characters\generic\water\male\3k_main_ancillary_armour_light_armour_earth_metal_and_water_common

// Imports central metadata into 'JSON_data' variable
#include  "t:/common/artist_resources/photoshop/presets/character_ui_metadata.json"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
function st_template_folders_item() 
{
    // Imported data from the character_ui_template_data.json.
    // File contains a list of character templates (e.g. bust, bobbleheads etc..).
    // Each template has a source and target root associated with it and it's these
    // folder locations we store in here.
    this.name = "",
    this.source_folder = "",
    this.export_folder = ""
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
function st_char_component() 
{
    // Component = data containing the layer and metadata for a character body part/accessory   
    this.is_master = false;
    this.filename = "";
    this.path = "";
    this.z_order_list = [];   // Order the components are drawn in
    this.offset_list = []; // X & Y offset positional vector, from the document's center, for each component
    this.layer_list = []; // Layer component is under
    this.bounds = []; //contains the bounding rectangle around the component
    this.center = []; // center of the layer bounds
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
function st_pivot_item() 
{
    // pivot = A component offset pivot item.
    // Pivots are stored under the [pivots] layerset. The layer names are then associated with the
    // component layers by name. Forward slashes in a pivot layer indicate a layerset and act as
    // a pseudo folder search.    
    this.name = "";   // Name of the pivot layer (used for searching)
    this.x = 0;          // Pivot X position in uv space (i.e 0-1 would be within the components bounds)
    this.y = 0;          // Pivot Y position in uv space (i.e 0-1 would be within the components bounds)
 }

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
function _units_handler()
{
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.as_pixels = function as_pixels(value)   //units_funcs
    {
         // Ensures any units extracted from a document are in pixels
        if (value.type != undefined)
        {
            return ( parseFloat(UnitValue(value.value, value.type).as('px')) );
        }
        return value;
    }

}
var units_funcs = new _units_handler()

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
function _layer_handler()
{
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_layer_path_by_layer = function get_layer_path_by_layer(doc, layer)    //layer_funcs
    {
        app.activeDocument = doc;
        
        // Get layer path using layer
        var keep_going = true;
        var layer_path = "";

        while (keep_going)
        {
            var layer_path = "/" + layer.name + layer_path;
            
            if (layer.parent.parent.parent != undefined)
            {
                layer = layer.parent;
            }
            else
            {
                keep_going = false;
            }
        }
        return layer_path;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.layers_match = function layers_match(layer_a, layer_b)
    {
        var match_found = false;
        if (layer_b.typename =="LayerSet")
        {
            // If layer_a is a layerset then we step back through layer_b's parent layers to see if a match can be found.
             var keep_going = true;
             var current_layer = layer_a;
             while (keep_going)
             {
                 if (current_layer.parent == layer_b)
                 {
                     match_found = true;
                     keep_going = false;
                 }
                 else
                 {
                     if (current_layer.parent.typename == "LayerSet")
                     {
                        current_layer = current_layer.parent;
                     }
                     else
                     {
                         keep_going = false;
                     }
                 }
             }
        }
        else
        {
            match_found = (layer_a == layer_b);
        }
        return match_found;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_selected_layers = function get_selected_layers(doc)
    {
        // Grabs the selected layers
        var resultLayers=new Array();
        try
        {
            var idGrp = stringIDToTypeID( "groupLayersEvent" );
            var descGrp = new ActionDescriptor();
            var refGrp = new ActionReference();
            refGrp.putEnumerated(charIDToTypeID( "Lyr " ),charIDToTypeID( "Ordn" ),charIDToTypeID( "Trgt" ));
            descGrp.putReference(charIDToTypeID( "null" ), refGrp );
            executeAction( idGrp, descGrp, DialogModes.NO );
            
            for (var ix=0 ; ix < doc.activeLayer.layers.length ; ix++)
            {
                var layer_item = doc.activeLayer.layers[ix];
                var layer_path = this.get_layer_path_by_layer( doc, layer_item );
                var vis = false;
                if (layer_item.visible)
                {
                    vis = true;
                }               
                resultLayers.push( {"layer": layer_item, "path": layer_path, "visibility": vis})
            }
            
            var id8 = charIDToTypeID( "slct" );
            var desc5 = new ActionDescriptor();
            var id9 = charIDToTypeID( "null" );
            var ref2 = new ActionReference();
            var id10 = charIDToTypeID( "HstS" );
            var id11 = charIDToTypeID( "Ordn" );
            var id12 = charIDToTypeID( "Prvs" );
            ref2.putEnumerated( id10, id11, id12 );
            desc5.putReference( id9, ref2 );
            executeAction( id8, desc5, DialogModes.NO );
        } 
        catch (err) 
        {
        }
        return resultLayers;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.delete_hidden_layers = function delete_hidden_layers(doc, layer_list, preserve_name, path_filter_name)
    {
        for (var layer_index = 0 ; layer_index <layer_list.length ; layer_index++)
        {
            var layer_item = layer_list[layer_index];
            if (layer_item["layer"].typename != "LayerSet")
            {
                if (layer_item["layer"].name.indexOf(preserve_name)==-1 || layer_item["path"].indexOf(path_filter_name)==-1)
                {
                    layer_list[layer_index]["layer"].remove()
                }
            }
        }
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.layer_name_exists = function layer_name_exists(nm) 
    {  
        function cTID(s) { return app.charIDToTypeID(s); };  
      
        try {  
        var desc5 = new ActionDescriptor();  
        var ref4 = new ActionReference();  
        ref4.putName( cTID('Lyr '),  nm);  
        desc5.putReference( cTID('null'), ref4 );  
        desc5.putBoolean( cTID('MkVs'), false );  
        executeAction( cTID('slct'), desc5, DialogModes.NO );  
        return true;  

        } catch (e) {  
        return false;  
        } 
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.collect_layers = function collect_layers (theParent, all_layers)
    {
        var thePath = theParent["path"];
        for (var m = theParent["layer"].layers.length - 1; m >= 0; m--)
        {
            var theLayer = theParent["layer"].layers[m];
            if (theLayer.typename == "LayerSet")
            {
                var layer_item = {"layer": theParent["layer"].layers[m], "path": (thePath+theParent["layer"].layers[m].name+"/"), "visibility": theParent["layer"].layers[m].visible}
                all_layers.push(layer_item);
                this.collect_layers(layer_item, all_layers)
            }
            else
            {
                all_layers.push({"layer": theParent["layer"].layers[m], "path": (thePath+theParent["layer"].layers[m].name), "visibility": theParent["layer"].layers[m].visible});
            }
        }
        return all_layers
    }


    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.dup_layer_by_name = function dup_layer_by_name(doc) 
    {
        var returned_value = null;
        var layer = doc.activeLayer //layers[name];
        
        if (layer != undefined)
        {
            doc.activeLayer= layer; 
            
            var desc143 = new ActionDescriptor();  
                var ref73 = new ActionReference();  
                ref73.putClass( charIDToTypeID('Dcmn') );  
            desc143.putReference( charIDToTypeID('null'), ref73 );  
            desc143.putString( charIDToTypeID('Nm  '), activeDocument.activeLayer.name );  
                var ref74 = new ActionReference();  
                ref74.putEnumerated( charIDToTypeID('Lyr '), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') );  
            desc143.putReference( charIDToTypeID('Usng'), ref74 );  
            executeAction( charIDToTypeID('Mk  '), desc143, DialogModes.NO );  
            
            doc.close(SaveOptions.DONOTSAVECHANGES);
            returned_value = app.activeDocument;
        }
        return returned_value;
    }; 

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.select_layer_by_name = function select_layer_by_name(doc, name, path)
    {
        var returned_val = false;
        var keep_going = true;
        var parent_layers = [];
        var parent_paths = [];
    
        var el = 0;
        while (el < doc.layers.length)
        {
            parent_layers.push(doc.layers[el]);
            if (doc.layers[el].typename == "LayerSet")
            {
                parent_paths.push("/" + doc.layers[el].name + "/");
            }
            else
            {
                parent_paths.push("/" + doc.layers[el].name);
                if (doc.layers[el].name.indexOf(name) != -1)
                {
                    doc.activeLayer = doc.layers[el];
                    returned_val = true;
                    keep_going = false;
                }                 
            }
        
            if (keep_going)
            {
                el++
            }
            else
            {
                el = doc.layers.length +1
            }
        }

        while (keep_going)
        {
            var new_parent_list = [];
            var new_paths = [];
            var i = 0;
            while (i < parent_layers.length)
            {
                if (parent_layers[i].typename == "LayerSet")
                {
                    var el = 0;
                    while (el < parent_layers[i].layers.length)
                    {
                        var new_path = parent_paths[i];
                        if (parent_layers[i].layers[el].typename == "LayerSet")
                        {
                            new_path = new_path + parent_layers[i].layers[el].name + "/";
                            new_parent_list.push(parent_layers[i].layers[el]);
                            new_paths.push (new_path);
                        }
                        else
                        {  
                            new_path = new_path + parent_layers[i].layers[el].name;
                            if (new_path.indexOf(name) != -1 && new_path.indexOf("metal") !=-1)
                            {                     
                                doc.activeLayer = parent_layers[i].layers[el];
                                returned_val = true;
                                keep_going = false;
                                el = parent_layers[i].layers.length +1;
                            }                           
                            
                        }
                        el++;
                    }
                }
            
                if (keep_going)
                {
                    i++;
                }
                else
                {
                    i = parent_layers.length +1 ;
                }
                
            }

            if (new_parent_list.length > 0)
            {
                parent_layers = [];
                parent_paths= [];
                for (var el = 0 ; el < new_parent_list.length ; el++)
                {
                    parent_layers.push(new_parent_list[el]);
                    parent_paths.push(new_paths[el]);
                }
            }
            else
            {
                keep_going = false;
            }  
        }
        return returned_val;
    };

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_layer_path  = function get_layer_path(doc, layer)
    {
            var final_str = "" ; //layer.name;
            var keep_going = true
            while (keep_going)
            {
                if (layer.parent.typename == "LayerSet")
                {
                    final_str = layer.parent.name +"/" + final_str;
                    layer = layer.parent;
                }
                else
                {
                    keep_going = false;
                }
            }

            return final_str;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.select_layer_by_name_FAST = function select_layer_by_name_FAST(doc, name, path)
    {
        var layer_found = false;
        var keep_going = true;
        var layer_path = "";
	    var returned_path = "";
		
        while (keep_going)
        {
            var layer_exists = this.layer_name_exists(name);
            if (layer_exists)
            {
                var layer = doc.activeLayer;
                layer_path = this.get_layer_path(doc, layer);
                if (layer_path.indexOf(path) != -1)
                {
				  returned_path = layer_path;
                    layer_found = true;
                    keep_going = false;
                }
                else
                {
                    layer.name = (Math.random()).toString();
                }
            }
            else
            {
                keep_going = false;
            }
        }
        
        return [layer_found, returned_path];
    }


    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_all_layers = function get_all_layers( doc, with_path, include_layer_sets, include_ref )   //layer_funcs
    {
        var returned_layers = new Array();
        var all_layers =  this.collect_layers({"layer": doc, "path": "/", "visibility": false}, new Array());      
        
        for (var layer_id=0 ; layer_id < all_layers.length ; layer_id++)
        {
            var add_item = true;
            var layer_item = all_layers[layer_id];
            if (include_ref == false)
            {
                if (layer_item["path"].indexOf("[ref]") == -1)
                {
                    add_item = false;
                }
            }
            if (include_layer_sets == false)
            {
                if (layer_item["layer"].typename == "LayerSet")
                {
                    add_item = false;
                }
            }
            if (add_item)
            {
                if (layer_item["layer"].typename == "ArtLayer")
                {
                    var bounds = layer_item.layer.bounds;
                    var layer_item_bounds = [units_funcs.as_pixels(bounds[0]), units_funcs.as_pixels(bounds[1]), units_funcs.as_pixels(bounds[2]), units_funcs.as_pixels(bounds[3])];
                    if ( (bounds[0] + bounds[1] + bounds[2] + bounds[3]) == 0 )
                    {
                        add_item = false;
                    }
                }  
            }
            if (add_item)
            {
                returned_layers.push(layer_item);
            }
        }
        return returned_layers;
    }    
    
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_all_layers_OLD = function get_all_layers_OLD( doc, with_path, include_layer_sets, include_ref )   //layer_funcs
    {
        app.activeDocument = doc;
        
        // Grab all the documents layers (regardless of layer groups)
        var returned_layer_list = [];
        
        var layerSets_list = [doc];
        var keep_going = true;
        
        while (keep_going)
        {
            var new_layerSets_list = [];
            
            for (var lyrSet_id = 0; lyrSet_id < layerSets_list.length; lyrSet_id++)  
            {  
                var layerSet_item = layerSets_list[lyrSet_id];
                
                for (var lyr_id = 0; lyr_id < layerSet_item.layers.length; lyr_id++)  
                {
                    var layer_item = layerSet_item.layers[lyr_id];
                    
                    if (layer_item.typename == "ArtLayer")
                    { 
                        var layer_item_bounds = [units_funcs.as_pixels(layer_item.bounds[0]), units_funcs.as_pixels(layer_item.bounds[1]), units_funcs.as_pixels(layer_item.bounds[2]), units_funcs.as_pixels(layer_item.bounds[3])];
                        if ( (layer_item_bounds[0] + layer_item_bounds[1] + layer_item_bounds[2] + layer_item_bounds[3]) > 0 )
                        {
                            var layer_path = this.get_layer_path_by_layer( doc, layer_item );
                            if (with_path)
                            {
                                var vis = false;
                                if (layer_item.visible)
                                {
                                    vis = true;
                                }
                                returned_layer_list.push( {"layer": layer_item, "path": layer_path, "visibility": vis} );
                             }
                            else
                            {
                                returned_layer_list.push( layer_item );
                            }
                        }
                    }
                    else
                    {
                        if (layer_item.typename == "LayerSet")
                        {
                            var add_new_layerset = true;
                            if (layer_item.name == "[ref]")
                            {
                                if (!include_ref)
                                {
                                     add_new_layerset = false
                                }
                            }
                            if (add_new_layerset)
                            {
                                new_layerSets_list.push(layer_item);
                                
                                if (include_layer_sets)
                                {
                                    var layer_path = this.get_layer_path_by_layer( doc, layer_item);
                                    if (with_path)
                                    {
                                        var vis = false;
                                        if (layer_item.visible)
                                        {
                                            vis = true;
                                        }                               
                                        returned_layer_list.push( {"layer": layer_item, "path": (layer_path +"/"), "visibility": vis} );
                                     }
                                    else
                                    {
                                        returned_layer_list.push( layer_item );
                                    }                           
                                }
                            }
                        }
                    }
                }
            }  
          
            if (keep_going)
            {
                if (new_layerSets_list.length > 0)
                {
                    layerSets_list = new_layerSets_list.slice();
                }
                else
                {
                    keep_going = false;
                }
            }     
        }

        return returned_layer_list;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_layer_by_name = function get_layer_by_name(doc, name_str, layerset_only)    //layer_funcs
    {
        app.activeDocument = doc;
        
        // Get layer by name
        var returned_layer_data = undefined;

        var layer_list = this.get_all_layers( doc, true, layerset_only );
        for (var lyr_id = 0; lyr_id < layer_list.length; lyr_id++)  
        {
           if (layerset_only)
           {
               if (layer_list[lyr_id]["layer"].typename == "LayerSet")
               {
                   if ( layer_list[lyr_id]["path"].indexOf(name_str) !=-1 )
                   {
                      returned_layer_data = layer_list[lyr_id];
                      lyr_id = layer_list.length;             
                   }          
               }
           }
           else
           {
               if ( layer_list[lyr_id]["path"].indexOf(name_str) !=-1 )
               {
                  returned_layer_data = layer_list[lyr_id];
                  lyr_id = layer_list.length;
               }
            }
        }
        return returned_layer_data;
    }


    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.set_layers_visibility = function set_layers_visibility(doc, layer_list, is_visible, filter_str, only_layer_sets, partical_string_match, only_layers) //layer_funcs
    {
        // Add a ~ character to the search string if it ends with an artlayer name i.e. no forward slash
        
        if (partical_string_match != true)
        {
            if (filter_str.length > 0)
            {
                if (filter_str[filter_str.length-1] != "/")
                {
                    filter_str += "~";
                }
            }
        }

        app.activeDocument = doc;
        for (var lyr_id = 0; lyr_id < layer_list.length; lyr_id++)  
        {
            var lyr = layer_list[lyr_id];
            var lyr_full_path = lyr["path"];
            
            if (lyr_full_path[lyr_full_path.length-1] != "/")
            {
                lyr_full_path += "~";
            }
     
            if (lyr_full_path.indexOf( filter_str ) != -1)
            {
                // Process layersets here
                if (only_layer_sets)
                {
                    if (lyr["layer"].typename == "LayerSet")
                    {
                        lyr["layer"].visible = is_visible;
                    }
                }
                else
                {              
                    if (only_layers)
                    {
                        if (lyr["layer"].typename != "LayerSet")
                        {
                            lyr["layer"].visible = is_visible;
                        }                        
                    }
                    else
                    {
                        lyr["layer"].visible = is_visible;
                    }
                }
            }

        }

    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_layer_offset = function get_layer_offset(doc, layer)   //layer_funcs
    {
        // Calculate the layer's center position to the center of the PSD.
        var width = units_funcs.as_pixels(layer.bounds[2]) - units_funcs.as_pixels(layer.bounds[0]);
        var height = units_funcs.as_pixels(layer.bounds[3]) - units_funcs.as_pixels(layer.bounds[1]); 
        var mid_x = units_funcs.as_pixels(layer.bounds[0]) + (width / 2.0);
        var mid_y = units_funcs.as_pixels(layer.bounds[1]) + (height / 2.0);
        
        var doc_mid_x = units_funcs.as_pixels(doc.width) / 2.0;
        var doc_mid_y = units_funcs.as_pixels(doc.height) / 2.0;
        
        var offset_x = mid_x - doc_mid_x;
        var offset_y = mid_y - doc_mid_y;   
        
        return [offset_x, offset_y];
    }

    ///////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////// 
    this.get_layer_center = function get_layer_center (bounds)  //layer_funcs
    {
        // Calculate the center of the layer based on the layers bounds (i.e. the frame around the layer's pixels).
        var x_mid = bounds[0] + ((bounds[2] - bounds[0]) / 2.0)
        var y_mid = bounds[1] + ((bounds[3] - bounds[1]) / 2.0)    
        return [x_mid, y_mid]
    }
      
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_layerset_names = function get_layerset_names(layersets)  //layer_funcs
    {
        // Gather the name of each layerset and return as an array
        var returned_array = [];
        for (var layerset_id = 0; layerset_id <= layersets.length-1 ; layerset_id++)
        {   
            returned_array.push(layersets[layerset_id].name);
        }
        return returned_array;
    }

}
var layer_funcs = new  _layer_handler();  

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
function _p4_handler() 
{
    this.temp_p4_file = "t:/p4_temp.txt";
    this.photoshop_exporter_exe = "t:/shared_tools/art_tools/bin/app_launcher/app_launcher.exe photoshop_exporter";
    this.p4_files = [];
    this.dependent_files = [
        "t:/common/ImageMetadataAdd/ImageMetadataAdd/bin/Release/...",
        "t:/common/artist_resources/photoshop/presets/character_ui_metadata.json"
    ];
	this.exported_file_changelist = "default";

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.create_json_file = function create_json_file (root_path, change_description)   //p4_funcs
    {
        // Create the file handler json file.
        var file = new File(export_funcs.temp_json_file);

        file.open("w");
        
        file.write ("{\n");
        file.write ("    \"image_list\": {\n");
        file.write ("        \"changelist\": \"" + change_description + "\",\n");
        file.write ("        \"files\": {\n");
        for (var file_id = 0 ; file_id <= this.p4_files.length-1 ; file_id++)
        {
            var temp_filename = this.p4_files[file_id]["source"];
            var dest_filename = this.p4_files[file_id]["dest"];

            temp_filename = temp_filename.replace (/\\/g, "/");
            dest_filename = dest_filename.replace (/\\/g, "/");
            
            temp_filename = temp_filename.replace ("//", "/");
            dest_filename = dest_filename.replace ("//", "/");
            
            //Remove the dollar sign from the composite name
            temp_filename = temp_filename.replace("$", "");
            dest_filename = dest_filename.replace("$", "");
            
            if (file_id < (this.p4_files.length-1))
            {
                file.write ("            \"" + temp_filename + "\": \"" + dest_filename + "\",\n");
            }
            else
            {
                file.write ("            \"" + temp_filename + "\": \"" + dest_filename + "\"\n");
            }
        }
        file.write ("        }\n");
        file.write ("    }\n");
        file.write ("}\n");    
        
        file.close();
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
	this.get_changelist = function get_changelist()
	{
		// Parse the p4_log.txt file to extract the changelist number
		var p4_file = (this.p4_files[0]["dest"]).replace("$", "");
		var cmd = "p4 opened \""+p4_file+"\" > \"t:/temp/p4_log.txt\"";
		system(cmd);

		// Extract the changelist from the 'p4 open ...' output data
		var file = new File("t:\\temp\\p4_log.txt"); 
		file.open("r");   
		var p4_file_data = file.read();
		file.close();
		
		var change_id = "default"
		var pos = p4_file_data.indexOf(" change ");
		if (pos !=-1)
		{
			p4_file_data = p4_file_data.substring((pos+8), p4_file_data.length);
			pos = p4_file_data.indexOf(" ");
			change_id = p4_file_data.substring(0, pos);
		}	
	
		this.exported_file_changelist = change_id

		file.close();
	}

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.add_files_to_perforce = function add_files_to_perforce(doc_name, root_path)   //p4_funcs
    {
        // Put the exported files through the file handler to add them correctly to Perforce
        var change_description = "Photoshop > Character Exporter > " + doc_name;
        
        this.create_json_file (root_path, change_description);
        
        // Run the file handler on the resulting temp.json file
       app.system( this.photoshop_exporter_exe + " --config " + export_funcs.temp_json_file);
	   this.get_changelist();
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
	this.make_unique_array = function make_unique_array(arry)
	{
		var new_array = [];
		for (var i=0 ; i<arry.length ; i++)
		{
			var add_it = true;
			for (var el=0 ; el<new_array.length ; el++)
			{
				if (arry[i] == new_array[el])
				{
					add_it = false;
				}
			}
			
			if (add_it)
			{
				new_array.push(arry[i]);
			}
		}
		return new_array;
	}

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.mark_for_delete_unused_panel_files = function mark_for_delete_unused_panel_files(all_panel_files)   //p4_funcs
    {

		all_panel_files = this.make_unique_array(all_panel_files);
		
		var cmd = "p4 delete -c "+((this.exported_file_changelist).toString())+" "
		var delete_counter = 0;
		var items_to_delete = [];

		for (var i=0 ; i < all_panel_files.length ; i++)
		{
			var delete_item = true;
			var panel_file = (all_panel_files[i].toLowerCase()).replace(/\\/g, "/");
			
			var el=0;
			while (el < this.p4_files.length)
			{
				var p4_file = (this.p4_files[el]["dest"].toLowerCase()).replace("$", "");
				if ( panel_file == p4_file)
				{
					delete_item = false;
					el = this.p4_files.length+1
				}
				el++
			}
			if (delete_item)
			{
				var del_file = new File(panel_file);
				
				// If the file is read-only we can assume it's checked into Perforce & therefore added to the 'mark for delete' perforce command string.
				// Local files will be just deleted.

				if (del_file.readonly == true)
				{		
					var p4_panel_file = all_panel_files[i].replace(/\\/g, "/");
					cmd += ("\""+p4_panel_file+"\" ");		
					delete_counter+=1;
				}
				else
				{
//					del_file.remove();
//alert("local delete:\n"+panel_file);					
				}

			}
		}
		if (delete_counter > 0)
		{
			app.system(cmd);
		}
	}

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.p4_files_opened_by_other_user = function p4_files_opened_by_other_user(file_list)   //p4_funcs
    {
        // Check if files are checked out by another user.
        // Returns 'false' if none are checked out.
        var checked_out_files = false;
        var checked_out_list = [];
        var p4_opened = "p4 opened -a ";

        export_funcs.delete_file(this.temp_p4_file);
        
        for (var file_id = 0 ; file_id <= file_list.length-1 ; file_id++)
        {
            var filename = file_list[file_id];
            p4_opened += "\"" + filename + "\" ";
        }
        p4_opened += (" > " + this.temp_p4_file);
        
        app.system(p4_opened);
        
        var temp_file = File(this.temp_p4_file);
        temp_file.open("r");   
        var checked_out_files = temp_file.read();

/*
        if (checked_out_files.indexOf(" edit change ") != -1)
        {   
            var error_message = "Error! The following files are checked out by another user;\n\n";
            error_message += checked_out_files;
            error_message += "\nOperation cancelled.\n";
            alert(error_message);
           checked_out_files = true;
        }   
 */   
        return checked_out_files
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.sync_dependent_files = function sync_dependent_files ()   //p4_funcs
    {
        // Sync all files this script depend on
        var p4_sync = "p4 sync ";
        for (var file_id = 0 ; file_id <= this.dependent_files.length-1 ; file_id++)
        {
           p4_sync += "\"" + this.dependent_files[file_id] + "\" ";
        }
        app.system(p4_sync);
    }

}
var p4_funcs = new _p4_handler();  

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
function _component_handler()
{    
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_component_id = function get_component_id (components, layer)    //component_funcs
    {
        // Search through the master components. If 'layer' matches then we return the master component array position.
        var returned_id = null;
        var component_id = 0;
        while (component_id < components.length)
        {
            if (layer.name == components[component_id].filename && components[component_id].is_master) 
            {
                returned_id = component_id; 
                component_id = components.length + 1;
            }
            component_id++;
        }
        return returned_id;
    }     

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.build_component_data = function build_component_data (doc, components, layerset, layerset_path)    //component_funcs
    {
        // Add the 'layerset' to the 'components' list.
        // Note: Master components may contain multiple references. 
        for (var layer_id = 0; layer_id <= layerset.layers.length-1 ; layer_id++)
        {   
            var is_master = false;
            var layer_item = layerset.layers[layer_id];       
            
            if (layer_item.typename == "ArtLayer")
            {
                var layer_bounds = units_funcs.as_pixels(layer_item.bounds[0]) + units_funcs.as_pixels(layer_item.bounds[1]) + units_funcs.as_pixels(layer_item.bounds[2]) + units_funcs.as_pixels(layer_item.bounds[3]);
                
                if (layer_item.parent.name != "[ref]" && layer_item.parent.name != "[pivots]" && layer_bounds > 0)
                {
                    // if the parent layerset name is "[panel]" then the layer is a master layer
                    if (layer_item.parent.name == "[panel]")
                    {
                        is_master = true
                    }
                
                    if (is_master)
                    {
                        var component = new st_char_component();
                        component.is_master = true;
                        component.path = layerset_path;
                        component.filename = layer_item.name;
                        component.layer_list.push(layer_item);             
                        var layer_offset = layer_funcs.get_layer_offset (doc, layer_item);
                        component.bounds = [units_funcs.as_pixels(layer_item.bounds[0]), units_funcs.as_pixels(layer_item.bounds[1]), units_funcs.as_pixels(layer_item.bounds[2]), units_funcs.as_pixels(layer_item.bounds[3])];
                        component.center = layer_funcs.get_layer_center(component.bounds);
                        component.offset_list.push(layer_offset);
                        component.z_order_list.push(0);
                        
                        components.push(component);
                    }
                    else
                    {
                        var layer_path = layerset_path + "/" +layer_item.name;
                        var component_id = this.get_component_id(components, layer_item);
                        if (component_id == null) 
                        {
                            var component = new st_char_component();
                            component.is_master = false;
                            component.path = layerset_path;
                            component.filename = layer_item.name;
                            component.layer_list.push(layer_item);     //will only ever be one item in the layer_list as it's not a master component
                            component.bounds = [units_funcs.as_pixels(layer_item.bounds[0]), units_funcs.as_pixels(layer_item.bounds[1]), units_funcs.as_pixels(layer_item.bounds[2]), units_funcs.as_pixels(layer_item.bounds[3])];
                            component.center = layer_funcs.get_layer_center(component.bounds);
                            var layer_offset = layer_funcs.get_layer_offset (doc, layer_item);
                            component.offset_list.push(layer_offset);                  
                            
                            component.z_order_list.push(layer_id);     //will only ever be one item in the z_order_list as it's not a master component
                            components.push(component);                   
                        }
                        else
                        {
                            components[component_id].layer_list.push(layer_item);     //master component will potentially hold multiple component references
                            components[component_id].z_order_list.push(layer_id);  
                            var layer_offset = layer_funcs.get_layer_offset (doc, layer_item);
                            components[component_id].offset_list.push(layer_offset);                           
                        }
                    }
                }
            }
        }    

        return components;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.create_component_list = function create_component_list (doc)    //component_funcs
    {
        // Construct the component list by digging through the layersets, building a flat list of master & unique components.
        // Note:
        // Master component - This is a component that may contain multiple references to layers based off the master component's layer name as a search key.
        // Unique component - A component is a layer holding a character element (e.g. a leg, torso etc..). The component data consists of the layer, its name & layerset 'path'. Also included is the pivot offset and bounding rectangle around the layer pixels.
        var components = [];
        
        var keep_going = true;
        
        var parent_layersets = doc.layerSets;
        var parent_paths = [];
     
        parent_paths = layer_funcs.get_layerset_names(parent_layersets);

        var layerset_depth_count = 0; //The current folder 'depth' i.e. how many folders down the hierarchy a layerset is
        
        while (keep_going) 
        {
            var child_layersets = [];
            var child_paths = [];
            
            for (var parent_layerset_id = 0 ; parent_layerset_id <= parent_layersets.length-1 ; parent_layerset_id++)
            {
                var parent_layerset = parent_layersets[parent_layerset_id];     
                var parent_path = parent_paths[parent_layerset_id];
                
                var parent_child_layersets = parent_layerset.layerSets;
      
                 // Process each of the layersets' layers and update the components array data accordingly
                 components = this.build_component_data (doc, components, parent_layerset, parent_path);    
      
                for (var child_layerset_id = 0; child_layerset_id <= parent_child_layersets.length-1 ; child_layerset_id++)
                {
                    child_layersets.push(parent_child_layersets[child_layerset_id]);
                    var child_path = parent_path + "/" + parent_child_layersets[child_layerset_id].name

                    // If the layerset's first character is a $ symbol then we make this the composite_name
                    if (parent_child_layersets[child_layerset_id].name[0] == "$")
                    {
                        export_funcs.composite_name = parent_child_layersets[child_layerset_id].name;
                        export_funcs.composite_name = export_funcs.composite_name.substring(1, export_funcs.composite_name.length);                  
                    }

                    child_paths.push(child_path);
                }
            }

            if (child_layersets.length > 0)
            {
                parent_layersets = child_layersets.slice();
                parent_paths = child_paths.slice();
            }
            else
            {
                keep_going = false;
            }
            layerset_depth_count +=1 ;
        }

        return components
    }

}
var  component_funcs = new  _component_handler();  

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
function _export_handler()
{
    this.composite_name = "";
    this.temp_root_path = "t:/temp/";
    this.temp_batch_file = "t:/temp.bat";
    this.temp_json_file = "t:/temp.json";
    this.metadata_add_exe = "t:/common/ImageMetadataAdd/ImageMetadataAdd/bin/Release/ImageMetadataAdd.exe";

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.prepare_doc = function prepare_doc (doc)  //export_funcs
    {
        // Ensure the target document is set up correctly before export. e.g. Only one layer selected.
        var topLayer = app.activeDocument.layers[0];  
        app.activeDocument.activeLayer = topLayer;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.validate_doc = function (doc, components, root_path)  //export_funcs
    {
        // Pre-validation of the target document to ensure any issues are captured before the export process begins.
        var export_data = true;    
        root_path = root_path.toLowerCase();
        
        // Check a [panel] layerset exists
        if (components.length > 0)
        {
            export_data = false;
            for (var comp_id = 0 ; comp_id <= components.length-1 ; comp_id++)
            {
                var comp = components[comp_id];
                var comp_path = comp.path.toLowerCase();
                if (comp_path.indexOf("[panel]/") != -1)
                {
                    export_data = true;
                }
            }
        }

        if (export_data == false)
        {
            alert ("Error! Missing [panel] layer group.\n\nOperation cancelled.\n");
        }

        // Check the root path is pointing to t: and working_data
        export_data = false;
        if (root_path.indexOf("t:/") != -1 && root_path.indexOf("/working_data/") != -1)
        {
            export_data = true;
        }
        else
        {
            alert ("Error! Export path isn't pointing to the working_data folder on t:\n\nOperation cancelled.\n");      
        }

        // Further checks to make
        // * Check if the active document is saved to disk and that it's read and write

        return export_data;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.create_png_metadata = function create_png_metadata (filename, component, scale, pivot_offset,  padding, batch_file)  //export_funcs
    {
        // Each exported component png has metadata created and the resulting cmd line is added to the master batch file
        var bounds = component.bounds;

        if (component.layer_list.length > 0)
        {
            var metadata_str = "";
            var offset = component.offset_list[0]
       
            offset[0] = Math.round(offset[0] * scale)
            offset[1] = Math.round(offset[1] * scale) 
           
            bounds[0] = parseFloat(bounds[0])
            bounds[1] = parseFloat(bounds[1])
            bounds[2] = parseFloat(bounds[2])
            bounds[3] = parseFloat(bounds[3])
      
            bounds[0] = (bounds[0] - padding) * scale
            bounds[1] = (bounds[1] - padding) * scale
            bounds[2] = (bounds[2] + padding) * scale
            bounds[3] = (bounds[3] + padding) * scale      

            pivot_offset[0] = Math.round (pivot_offset[0] * scale)
            pivot_offset[1] = Math.round (pivot_offset[1] * scale)
            
            pivot_offset[0] = pivot_offset[0] - bounds[0]
            pivot_offset[1] = pivot_offset[1] - bounds[1]

            pivot_offset[0] /= (bounds[2] - bounds[0])
            pivot_offset[1] /= (bounds[3] - bounds[1])
     
            pivot_offset[0] = (pivot_offset[0]).toFixed(4)
            pivot_offset[1] = (pivot_offset[1]).toFixed(4)

            for (var item_id = 0 ; item_id <= component.layer_list.length-1 ; item_id++)
            {
                var parent_name = component.layer_list[item_id].parent.name.toLowerCase()
                var z_order = component.z_order_list[item_id]

                // If this isn't the first entry of a master component then we process it
                if (!(component.is_master && item_id == 0))
                {
                    metadata_str += ("[type:" + parent_name + ";x:" + offset[0] + ";y:" + offset[1] + ";z-order:" + z_order + ";pivot_x:" + pivot_offset[0] + ";pivot_y:" + pivot_offset[1] + ";]");
                }
            }
            batch_file.write ( this.metadata_add_exe + " \"" + filename + "\" \"" + metadata_str + "\"\n" );
        }
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_pivot_data = function get_pivot_data (doc)  //export_funcs
    {
        // Pivot offsets are gathered from the layers under the [pivots] layerset.
        // Note: Pivot layers are optional. By default a component's pivot is set to it's center i.e. [0.5, 0.5]
        var pivot_list = [];
        var pivot_layer = null;
        try
        {
            pivot_layer = doc.layerSets.getByName("[pivots]");
        }
        catch(e)
        {
        }

        if (pivot_layer != null)
        {
            for (var layer_id = 0; layer_id <= pivot_layer.layers.length-1 ; layer_id++)
            {
                var layer = pivot_layer.layers[layer_id];
                var layer_bounds = [units_funcs.as_pixels(layer.bounds[0]), units_funcs.as_pixels(layer.bounds[1]), units_funcs.as_pixels(layer.bounds[2]), units_funcs.as_pixels(layer.bounds[3])];
                var mid_x = layer_bounds[0] + ((layer_bounds[2] - layer_bounds[0]) / 2)
                var mid_y = layer_bounds[1] + ((layer_bounds[3] - layer_bounds[1]) / 2)          
                
                var pivot_item = new st_pivot_item();
                pivot_item.name = (layer.name.toLowerCase()) + ".png";
                pivot_item.x = Math.round (mid_x);
                pivot_item.y = Math.round (mid_y);
                pivot_list.push(pivot_item);
            }
        
            // Sort layers based on their forward-slash count
            pivot_list.sort(function(a, b) {
                var name_a = a.name.split("/");
                var name_b = b.name.split("/");
                if (a.name == "[master]")
                {
                    return 1
                }
            
                if (b.name == "[master]")
                {
                    return -1
                }
            
                if (name_a.length < name_b.length)
                {
                    return -1
                }
                 if (name_a.length > name_b.length)
                {
                    return 1
                }

                return 0
            });
        
        }
        return pivot_list;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_pivot_offset = function (name, pivot_data, center)  //export_funcs
    {
        //Try and match a pivot (pivot_data[x].name) to the 'name' string.
        var pivot_offset = [center[0], center[1] ]; //Default to the center of the sprite
        for (var pivot_data_id = 0 ; pivot_data_id <= pivot_data.length-1 ; pivot_data_id++)
        { 
            var pivot_item = pivot_data[pivot_data_id];
            if ((name.indexOf(pivot_item.name)) != -1)
            {
                pivot_offset[0] = pivot_item.x;
                pivot_offset[1] = pivot_item.y;
            }
            else
            {
               if (pivot_item.name == "[master].png")
               {
                   pivot_offset[0] = pivot_item.x;
                   pivot_offset[1] = pivot_item.y;               
               }
            }
         } 
         return pivot_offset;
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.save_doc = function save_doc(doc, filename, type, close_after_save)  //export_funcs
    {
        //Create the folder for the final exporter png image to be saved to
        var folder = Folder( File(filename).path );
        if (!folder.exists) 
        {
           folder.create();
        }

        // If the file isn't being copied to the temp folder then we need to ensure it's checked out
        if (filename.indexOf(this.temp_root_path) == -1)
        {
            var p4_cmd = "p4 edit \"" + filename + "\""
            app.system(p4_cmd);
        }

        var filename = new File(filename)
        //Save new document to the target location
        switch (type)
        {
            case "png":
                var pngOptions = new PNGSaveOptions();
                pngOptions.interlaced = false;     
                pngOptions.compression=9;
                doc.saveAs(filename, pngOptions, true,Extension.LOWERCASE);        
                break;
                
            default:
                var psdSaveOptions = new PhotoshopSaveOptions();
                psdSaveOptions.embedColorProfile = true;
                psdSaveOptions.alphaChannels = true;
                doc.saveAs(filename, psdSaveOptions, false,Extension.LOWERCASE);  
                break;
        }

        //Close the temp document without saving the changes
        if (close_after_save)
        {
            doc.close (SaveOptions.DONOTSAVECHANGES);          
        }
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.export_templates = function export_templates(dialog, composite_name, composite_path, scale_factor)  //export_funcs
    {         
        var export_successful = true;
        var returned_files = [];
        var debug_str = "";
        var source_root = JSON_data["template_data"]["root_folders"]["parent_source_folder"];
        var export_root = JSON_data["template_data"]["root_folders"]["parent_export_folder"];   
        
        var composite_path_folders = composite_path.split("/");
  
        // loop through the template folders
        var file_list = [];
        for (var temp_id = 0 ; temp_id <= JSON_data["template_data"]["folders"].length-1 ; temp_id++)
        {
            var src_folder = JSON_data["template_data"]["folders"][temp_id]["source_folder"];
            var filename = source_root + src_folder;
            file_list.push(filename);
        }

        // Check the template files aren't checked-out by other user(s)
        var checked_out_files = p4_funcs.p4_files_opened_by_other_user(file_list);
           
        if (checked_out_files != true)
        {                
           // Sync the source master PSD template file
           var p4_sync = "p4 sync ";
           for (var file_id = 0 ; file_id <= file_list.length-1 ; file_id++)
           {
               p4_sync += "\"" + file_list[file_id] + "\" ";
           }
           app.system(p4_sync);
       
           // Gather all the UI template listbox selected items
           var selected_template_items = new Array()
           if (dialog.grp_settings.template_list.selection != null)
           {
               for (var sel_id = 0 ; sel_id < dialog.grp_settings.template_list.selection.length ; sel_id++)
               {
                   selected_template_items.push(dialog.grp_settings.template_list.selection[sel_id]);
               }
            }
        
           // Open the source PSD file and resave it to TEMP (add to p4_funcs.p4_files list with original location)
           for (var temp_id = 0 ; temp_id <= JSON_data["template_data"]["folders"].length-1 ; temp_id++)
           {
               if (selected_template_items.join(",").indexOf(JSON_data["template_data"]["folders"][temp_id]["source_folder"]) != -1)
               {
                   var src_filename = source_root + JSON_data["template_data"]["folders"][temp_id]["source_folder"];
                   var temp_filename = this.temp_root_path + JSON_data["template_data"]["folders"][temp_id]["source_folder"];

                   //Open template PSD file     
                   var temp_src_file = new File( src_filename );

                   var temp_doc = import_funcs.open_doc( temp_src_file, false, false);     
                   
                    var path_filter_name = composite_name;
                    
                    if ( composite_path.indexOf("/male/") != -1 || composite_path.indexOf("/female/") != -1) 
                    {
                        path_filter_name = composite_path_folders[1] + "/" + composite_path_folders[2] + "/";
                    }                  
                   
 //CODE HERE!!!!!
                   //var comp_layer = layer_funcs.layer_name_exists(composite_name);  //layer_funcs.get_layer_by_name( temp_doc, composite_name, false );
//                   var comp_layer = layer_funcs.layer_name_exists(path_filter_name);  //layer_funcs.get_layer_by_name( temp_doc, composite_name, false );
                   var comp_layer = layer_funcs.select_layer_by_name_FAST(temp_doc, composite_name, path_filter_name);

                   if (comp_layer[0])
                   {
                        // Extract target layer(s) into a new document and close the original master template PSD
                        temp_doc = layer_funcs.dup_layer_by_name(temp_doc);              
  
                        // Hide all-but the relevant component layers. 

                        var layers = layer_funcs.get_all_layers( temp_doc, true, true, true ); //all layers including [ref]
                        
                        layer_funcs.set_layers_visibility( temp_doc, layers, true, "", true );  // Sets all layersets visibility to true                     
                        layer_funcs.set_layers_visibility( temp_doc, layers, false, "", false, true, true ); // Sets all the artlayers visibility to false                            
                        layer_funcs.set_layers_visibility( temp_doc, layers, true, path_filter_name, false, true, true); // Sets target component layer(s) visibility to true        
     
                        //import_funcs.update_smart_objects(false); // Now update the smart objects on just the remaining target layers (false == only selected layers)
                        var layer_path = comp_layer[1];
					
                        for (var i=0 ; i < layers.length ; i++)
                        {
                            if ((layers[i]["layer"]).name == composite_name)
                            {
                                if (layers[i]["layer"].visible)
                                {
                                    temp_doc.activeLayer = layers[i]["layer"]; //select composite layer
                                                                   
                                    //import_funcs.update_smart_objects(false); // Now update the smart objects on just the remaining target layers (false == only selected layers)
                                    //layer_path = layers[i]["path"];
                                    //var pieces = layer_path.split("/");
                                   // var path_str = "";
                                    //for (idx = 0 ; idx < (pieces.length-1) ; idx++)
                                    //{
                                    //    path_str += (pieces[idx] + "/");
                                    //}
                                
                                    //layer_path = path_str;
                                 }
                            }
                            else
                            {
                                if (layers[i]["layer"].typename !="LayerSet")                                           
                                {
                                    layers[i]["layer"].visible = false ; //hide wrongly named layer                    
                                }
                            }
                        }
                       
                       // Duplicate document, collapse the stack and save the file to TEMP/[folders][name]/Large folder (add to p4_list with original location)
                       var doc_width = temp_doc.width.value.toString() + "px";
                       var doc_height = temp_doc.height.value.toString() + "px";
                       var dupe_temp_doc = app.documents.add( doc_width , doc_height, 72, "tmp_template.psd", NewDocumentMode.RGB, DocumentFill.TRANSPARENT);   //temp_doc.duplicate();
                       app.activeDocument = temp_doc;
                       temp_doc.activeLayer.duplicate(dupe_temp_doc);
                       app.activeDocument = dupe_temp_doc;
                       dupe_temp_doc.activeLayer = dupe_temp_doc.layers[0];
                       import_funcs.update_smart_objects(false); 
                       
                       temp_doc.close(SaveOptions.DONOTSAVECHANGES);

                       //dupe_temp_doc.mergeVisibleLayers(); 
				   
                       var export_filename = export_root + JSON_data["template_data"]["folders"][temp_id]["dest_folder"] + layer_path + "large/" + composite_name + ".png";
                       var temp_export_filename = this.temp_root_path + JSON_data["template_data"]["folders"][temp_id]["dest_folder"] + layer_path + "large/" + composite_name + ".png";

                       //Ensure the outer visible pixels are of an extremely low opacity to avoid the white border pixel issue
                       var layer = dupe_temp_doc.activeLayer;
                       dupe_temp_doc.activeLayer.duplicate();
                       var pixel_width = 100.0 + (((1.0 / dupe_temp_doc.width) * 100.0) *10);
                       var pixel_height = 100.0 + (((1.0 / dupe_temp_doc.height) * 100.0) *10);
                       layer.resize( pixel_width, pixel_height, AnchorPosition.MIDDLECENTER);
                       layer.opacity = 1;

                       this.save_doc( dupe_temp_doc, temp_export_filename, "png", false );                           
                       returned_files.push( {"source": temp_export_filename, "dest": export_filename} );                 

                       // Resize document to 'large panel' scale factor,save to TEMP folder and then close the document.
                       export_filename = export_root + JSON_data["template_data"]["folders"][temp_id]["dest_folder"] + layer_path + composite_name + ".png";
                       temp_export_filename = this.temp_root_path + JSON_data["template_data"]["folders"][temp_id]["dest_folder"] + layer_path + composite_name + ".png";

                       var new_width = Math.round (units_funcs.as_pixels(dupe_temp_doc.width) * scale_factor);
                       var new_height =Math.round (units_funcs.as_pixels(dupe_temp_doc.height) * scale_factor);
                       dupe_temp_doc.resizeImage((new_width.toString()+"px"), (new_height.toString()+"px"), null, ResampleMethod.BICUBIC, 0);
              
                       this.save_doc( dupe_temp_doc, temp_export_filename, "png", true );            
                       returned_files.push( {"source": temp_export_filename, "dest": export_filename} );         
                   }
                   else
                   {
                       temp_doc.close(SaveOptions.DONOTSAVECHANGES);
                       alert ("Error! The following template file didn't contain composite layer name '" + composite_name + "'\n\n" + src_filename +"\n\nFile not skipped!\n\n");
                   }
               }
           }      
       
        }
        else  
        {
            export_successful = false;
        }
     
        return [export_successful, returned_files];
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.get_current_panel_files = function get_current_panel_files (small_panel_folder, large_panel_folder)
    {
		var returned_paths = [];
		var panel_list = [small_panel_folder, large_panel_folder];

/*
		var panel_pos = panel_list[0].indexOf("small_panel");
		if (panel_pos !=-1)
		{
			panel_list[0] = panel_list[0].substring(0, panel_pos+12);
		}
		
		var panel_pos = panel_list[1].indexOf("large_panel");
		if (panel_pos !=-1)
		{
			panel_list[1] = panel_list[1].substring(0, panel_pos+12);
		}
*/

		for (var panel_id = 0 ; panel_id <= panel_list.length-1 ; panel_id++)
		{
			var panel_folder = panel_list[panel_id];
			var cmd = "dir /s \"" + panel_folder +"\" >T:\\TEMP\\panel_folders.txt";
			app.system(cmd);
		
			//Parse panel_folders.txt file
			var batch_file = new File("T:/TEMP/panel_folders.txt");
			batch_file.open("r"); 
			var lines = batch_file.read();
			lines = lines.split("\n");
			
			var i = 0;
			var root = ""
			while (i < lines.length)
			{
				var lne = lines[i];
				var dir_pos = lne.indexOf("Directory of ");
				if ( dir_pos != -1)
				{
					root = lne.substring((dir_pos+13), lne.length) + "\\"
				}
				else
				{
					if (root != "")
					{
						if (lne.indexOf(".png") != -1)
						{
							lne = lne.split(" ");
							png_file = root + lne[(lne.length-1)];
							returned_paths.push(png_file);
						}
					}
				}
				i++;
			}
		}

		return returned_paths
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
	this.revert_current_panel_files = function revert_current_panel_files(small_panel_folder, large_panel_folder)
	{
		var cmd = "p4 revert \""+small_panel_folder+"\" \""+large_panel_folder+"\""
		app.system(cmd);
	}

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.process_composite = function process_composite (doc, components, panel_dir, scale, padding, pivot_data, batch_file, selected_layers_only, selected_layers, process_existing_panel_files)  //export_funcs
    {
        // Main function for exporting and processing the layers.
        
        //Returned exported file list
        var returned_file_list = [];
	    var current_panel_files = [];
		
        // Scale the padding value so when the document is scaled down the padding returns to it's target size
        padding = padding / scale; 
         
		// Revert panel files (preparing for deleting reduntant png files later)
		var comp_path = JSON_data["composite_data"]["root_folders"]["export_path"] + (components[0].path.replace("$", "").toLowerCase());
		var panel_pos = comp_path.indexOf("[panel]");
		comp_path = comp_path.substring(0, panel_pos);
		
		if (process_existing_panel_files)
		{
			 var large_panel_folder = (comp_path+"small_panel/...") //.toLowerCase();
			 var small_panel_folder = (comp_path+"large_panel/...") //.toLowerCase();				 
			 this.revert_current_panel_files(small_panel_folder, large_panel_folder);
		}
		
	   var processed_panel_folders = [];
        for (var component_id = 0 ; component_id <= components.length-1 ; component_id++)
        {
            app.activeDocument = doc;
            var component = components[component_id];
            
            var panel_folder = JSON_data["composite_data"]["root_folders"]["export_path"] + (component.path.replace("$", "" ).toLowerCase()) ;
		  // panel_folder = panel_folder.toLowerCase();
		   
		   // Add all the current local panel files under the same folder the associated with the component come from.
		   if (process_existing_panel_files)
		   {
			   var large_panel_folder = (panel_folder.replace("[panel]", "large_panel")) //.toLowerCase();
			   
			   var add_it = true;
			   var i = 0;
			   while (i < processed_panel_folders.length)
			   {
					if (processed_panel_folders[i] == large_panel_folder)
					{
						add_it = false;
						i = processed_panel_folders.length +1
					}
					i++;
			   }
			   
			   if (add_it)
			   {
					var small_panel_folder = (panel_folder.replace("[panel]", "small_panel")) //.toLowerCase();
					var new_current_panel_files = this.get_current_panel_files(small_panel_folder, large_panel_folder);
					current_panel_files = current_panel_files.concat(new_current_panel_files);
					processed_panel_folders.push(large_panel_folder);
				}
		   }
	   
            var layer = component.layer_list[0];

            var layer_visibility = layer.visible;
            var pivot_offset_layer_name = (component.path + "/" + component.filename + ".png").toLowerCase();
            var pivot_offset = this.get_pivot_offset (  pivot_offset_layer_name , pivot_data, component.center  );
     
             // Switch out the '[panel]' folder string for the panel_dir string and drop to lowercase
            component.path = component.path.toLowerCase();
            component.path = component.path.replace("[panel]", panel_dir);
            
            // Convert filename to lowercase
            component.filename = component.filename.toLowerCase();
            
            // Ensure the filename doesn't contain spaces (no spaces = -1)
            if (component.filename.indexOf(' ') < 0)
            {
                var can_export = true;
                
                if (selected_layers_only)
                {
                    can_export = false;
                    if (component.layer_list.length > 1)
                    {
                        // If more than one layer is associated with the component and 'selected layers' is ticked we scan through the components
                        // associated layers to see if one or more of the selected layer exists within the list. If it doesn't then we don't export.                       
                        for (var layer_id = 0 ; layer_id < component.layer_list.length ; layer_id++)
                        {                            
                            for (var sel_layer_id = 0 ; sel_layer_id < selected_layers.length ; sel_layer_id++)
                            {
                                var layers_match = layer_funcs.layers_match(component.layer_list[layer_id], selected_layers[sel_layer_id]["layer"]);
                                if (layers_match)
                                {
                                    can_export = true;
                                    layer_id = component.layer_list.length;
                                }
                            }
                        }
                    }
                    else
                    {   
                        // If the 'selected layer' UI box is ticked and the component layer isn't selected then we don't process and export it.
                        for (var sel_layer_id = 0 ; sel_layer_id < selected_layers.length ; sel_layer_id++)
                        {
                            var layers_match = layer_funcs.layers_match(component.layer_list[0], selected_layers[sel_layer_id]["layer"]);
                            if (layers_match)
                            {
                                can_export = true;
                                layer_id = component.layer_list.length;
                            }
                        }
                    }
                }
            
                if (can_export)
                {
                    // Build full png image filepath
                    var filename = JSON_data["composite_data"]["root_folders"]["export_path"] + component.path + "/" + component.filename + ".png";

                    // Add to returned file list
                    var temp_filename = this.temp_root_path + component.path + "/" + component.filename + ".png";               
                    temp_filename = temp_filename.replace("$", "");
                    
                    var p4_item = { "source": temp_filename, "dest": filename };
                    returned_file_list.push( p4_item );
         
                    // Copy the component's layer to the clipboard           
                    layer.copy(); 

                    // Create a new document set to the size of the bounding area around the component layer                
                    var layer_bounds = [units_funcs.as_pixels(layer.bounds[0]), units_funcs.as_pixels(layer.bounds[1]), units_funcs.as_pixels(layer.bounds[2]), units_funcs.as_pixels(layer.bounds[3])];
                    var temp_width = (layer_bounds[2] - layer_bounds[0]) + padding;
                    var temp_height = (layer_bounds[3] - layer_bounds[1]) + padding;

                    var new_doc = app.documents.add((temp_width.toString()+"px"), (temp_height.toString()+"px"), 72, component.filename, NewDocumentMode.RGB, DocumentFill.TRANSPARENT);

                    //Add an empty layer and paste the content of the clipboard inside
                    var target_layer = new_doc.artLayers.add();
                    new_doc.paste();     
  

                    // Scale the canvas if it's anything other than 1.0
                    if (scale != 1.0)
                    {
                        var new_width = Math.round ( (units_funcs.as_pixels(new_doc.width) * scale) + 0.5);
                        var new_height =Math.round ( (units_funcs.as_pixels(new_doc.height) * scale) + 0.5);
                        new_doc.resizeImage((new_width.toString()+"px"), (new_height.toString()+"px"), null, ResampleMethod.BICUBIC, 0);
                    }

                   //Ensure the outer visible pixels are of an extremely low opacity to avoid the white border pixel issue

                   target_layer.duplicate();
                   var pixel_width = 100.0 + (((1.0 / new_doc.width) * 100.0) *10);
                   var pixel_height = 100.0 + (((1.0 / new_doc.height) * 100.0) *10);
                   target_layer.resize( pixel_width, pixel_height, AnchorPosition.MIDDLECENTER);
                   target_layer.opacity = 1;  

                    //Create the folder for the final exporter png image to be saved to
                    var folder_str = JSON_data["composite_data"]["root_folders"]["export_path"] + component.path;
                    folder_str = folder_str.replace("$", "");
                    var folder = Folder(folder_str);      
                    if (!folder.exists) 
                    {
                        folder.create();
                    }

                    //Save new document to the target location and then close it
                    this.save_doc(new_doc, temp_filename, "png", true)

                    // Restore original layer visibility
                    layer.visible = layer_visibility;
              
                    // Bake the offset metadata into the exported png file
                    var metadata = this.create_png_metadata(temp_filename, component, scale, pivot_offset, padding, batch_file);
                   
                 } 
            }
        }

        app.activeDocument = doc;
 
        return [returned_file_list, current_panel_files];
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.delete_file = function delete_file(filename)  //export_funcs
    {
        // Delete a file
        app.system("del \Q \""+ filename +"\"");
    }
 
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.garbage_collect = function garbage_collect()  //export_funcs
    {
        // Delete any old temp folders and files
        app.system("RMDIR \"" + this.temp_root_path + "\" /S /Q");
        this.delete_file( this.temp_json_file );
        this.delete_file( this.temp_batch_file );
        this.delete_file( p4_funcs.temp_p4_file );
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.process_document = function process_document (dialog, root_path, small_panel_scale, large_panel_scale, padding)  //export_funcs
    {
        // Flush out any legacy temp files
        this.garbage_collect();        

        // Main central function for processing the target document.
        p4_funcs.p4_files = [];
        var small_panel_dir = "small_panel";
        var process_doc = true;
        
        var doc = null;
        try{
            doc = app.activeDocument;
        }
        catch (err) {
            alert ("Error! No document open!\n\nOperation cancelled.\n");
            process_doc = false
        }

        if (process_doc)
        {
            
             //Grab selected layers if the 'selected layer' UI tickbox is ticked
            var selected_layers_only = false;
            var selected_layers = [];

            if (dialog.grp_settings.selected_layers_only.enabled)
            {
                selected_layers_only = dialog.grp_settings.selected_layers_only.value;

                if (selected_layers_only) 
                {
                     selected_layers = layer_funcs.get_selected_layers(doc) ; //grab just the selected layers
                }             
            }
        
            // Ensure the root path consists of forward slashes and there's one present at the end of the string
            root_path = root_path.replace (/\\/g, "/")
            if (root_path[0] != "/") 
            {
                root_path += "/";
            }

            var doc_name = (doc.name).split(".");
            doc_name = doc_name[0];

            // Set up the document so the process runs correctly (i.e. selecting only one layer)
            this.prepare_doc();   

            //Array containing component data
            var components = [];

            // Process large panel files
            if (dialog.grp_settings.export_composite.value)
            {
                components = component_funcs.create_component_list (doc); 
            }
     
            // Run tests on the current active PSD to ensure it's set up correct
            var can_export = this.validate_doc(doc, components, root_path);
     
            if (can_export)
            {   
			 //Holds a list of all the local panel filepaths. Used later to mark and redundant files for delete in Perforce.
			 var local_panel_files = [];
			 
               // Grab all composite layers
               var layers = layer_funcs.get_all_layers( doc, true, true, true ) ; //grab all layers and layersets

               // Save current active composite doc to the temp folder
               var doc_path = (doc.fullName.fsName).toString().replace(/\\/g, '/');              
               var doc_temp_path = this.temp_root_path + doc.fullName.name;     
               this.save_doc(doc, doc_temp_path, "psd", false);
               var p4_item = { "source": doc_temp_path, "dest": doc_path };
               p4_funcs.p4_files.push( p4_item );

               // Hide all-but the layers under the 'NORM' layer set. Also hide weapon if one exists.
               // PSD is then saved.
               app.activeDocument = doc;
 
                // Save the document if exporting templates is enabled
                if (dialog.grp_settings.export_templates.value)
                {
                   layer_funcs.set_layers_visibility( doc, layers, false, "", false);  // Set all layers visibilities to false                
                   layer_funcs.set_layers_visibility( doc, layers, true, "", true );  // Set all layersets visibilities to true  
                        
                   layer_funcs.set_layers_visibility( doc, layers, false,  "[ref]", false, true); // hide any [ref] layerset & layers            
                   layer_funcs.set_layers_visibility( doc, layers, true, "/NORM/", false, true ); //unhide layers living under the 'NORM' layerset

                   var hidden_norm_layers = ["WEAPON", "MOUTH", "EYES", "EXTRA"];
                   for (var hide_id = 0 ; hide_id <hidden_norm_layers.length ; hide_id++)
                   {
                        layer_funcs.set_layers_visibility( doc, layers, false, ("/NORM/" + hidden_norm_layers[hide_id]), false, true ); //Hide the layer (if it exists)
                   }            
                    this.save_doc(doc, doc_path, "psd", false);
                }
         
               // Export composite (active doc)
               if (dialog.grp_settings.export_composite.value)
               {
                    // Set-up png metadata baking batch file
                    var batch_filename = this.temp_batch_file;
                    var batch_file = new File(batch_filename);
                    batch_file.open("w");           
                    
                    // Grab any pivot layer data
                    var pivot_data = this.get_pivot_data(doc);  

                    // Create a temp folder
                    app.system("MD \"" + this.temp_root_path + "\"");
                  
                    returned_files = this.process_composite (doc, components, "large_panel", large_panel_scale, padding, pivot_data, batch_file, selected_layers_only, selected_layers, true);
                    p4_funcs.p4_files = p4_funcs.p4_files.concat(returned_files[0]);
				  local_panel_files = local_panel_files.concat(returned_files[1]);

                    // Process small panel files
                    components = component_funcs.create_component_list (doc);   
                    returned_files = this.process_composite (doc, components, small_panel_dir, small_panel_scale, padding, pivot_data, batch_file, selected_layers_only, selected_layers, false);
                    p4_funcs.p4_files = p4_funcs.p4_files.concat(returned_files[0]);
				  
                    // Call png metadata baking batch file (adds the temp json and batch file to be deleted too - saves on one more system call)
                    // Files processed = p4_funcs.p4_files
                    batch_file.close();
                    system(batch_filename);
                }

                // Grab the composite name
                //function get_layer_by_name(doc, name_str, layerset_only) 
                var lyr = layer_funcs.get_layer_by_name(doc, "/$", true);  
                var composite_name = (lyr["layer"].name).substring(1, lyr["layer"].name.length);

                // Grab the composite name from the composite PSD layers and export the templates.
                if (dialog.grp_settings.export_templates.value)
                {
                    returned_files = this.export_templates(dialog, composite_name, lyr["path"], 0.625);
                    p4_funcs.p4_files = p4_funcs.p4_files.concat(returned_files[1]);
                }
    
                // Run file handler on output files (copied from temp folder and added to Perforce changelist)
                if (p4_funcs.p4_files.length > 0)
                {
                   p4_funcs.add_files_to_perforce(composite_name, root_path);
				   if (selected_layers_only == false)
				   {
					  p4_funcs.mark_for_delete_unused_panel_files(local_panel_files);
					}
                }
                
                // Set the original composite document as the active one
                app.activeDocument = doc;
                
                // Close the composite document and re-open it to restore its original set-up (e.g. layer visibility)
                doc.close(SaveOptions.DONOTSAVECHANGES);
                app.open(new File(doc_path));
                
                // Delete the old temp folder files
               this.garbage_collect();               
                
                alert ("Export complete!");
            }
        }
    }

}
var  export_funcs = new  _export_handler();  

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
function _import_handler()
{
    this.metadata_file = "t:/common/artist_resources/photoshop/presets/character_ui_metadata.json";

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.update_smart_objects = function update_smart_objects(all_layers)
    {
        var idplacedLayerUpdateAllModified
        if (all_layers)
        {
            idplacedLayerUpdateAllModified = stringIDToTypeID( "placedLayerUpdateAllModified" );
        }
        else
        {
            idplacedLayerUpdateAllModified = stringIDToTypeID( "placedLayerUpdateModified" );
        }
    
        try {
            executeAction( idplacedLayerUpdateAllModified, undefined, DialogModes.NO );
        } catch(e) {
        }   
    }

    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    this.open_doc = function open_doc(filename, update_smart_objects, update_all_layers)  //import_funcs
    {
        var doc = app.open( filename ); 
        if (update_smart_objects)
        {
            //this.garbage_collect();   
            // Update all modified content
            this.update_smart_objects(update_all_layers);
        }
        return doc;
    }

}
var import_funcs = new  _import_handler();

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Main function
function main ()
{
    // Sync dependent files
    p4_funcs.sync_dependent_files();
    
    //UI set-up
    var dialog = new Window( 'dialog', "Export Character Components", undefined, {closeButton:true});

        // UI > Settings
        dialog.grp_settings = dialog.add('panel', [-20, 0, 380, 265], "Settings");
             dialog.grp_settings.export_templates = dialog.grp_settings.add('checkbox', [140, 5, 300, 25], "Export Templates");
             dialog.grp_settings.export_templates.value = true;       
  
            dialog.grp_settings.template_list = dialog.grp_settings.add("listBox", [5, 30, 391, 160], undefined, {multiselect: true});
            for (var i=0 ; i<JSON_data["template_data"]["folders"].length ; i++)
            {
                dialog.grp_settings.template_list.add ("item", JSON_data["template_data"]["folders"][i]["source_folder"]);
                dialog.grp_settings.template_list.items[i].selected = true;
            }
 
             dialog.grp_settings.export_composite = dialog.grp_settings.add('checkbox', [140, 170, 305, 190], "Export Composite");
             dialog.grp_settings.export_composite.value = true;       
 
             dialog.grp_settings.selected_layers_only = dialog.grp_settings.add('checkbox', [132, 195, 300, 213], "Selected Layers Only");
             dialog.grp_settings.selected_layers_only.value = false;       
             
             dialog.grp_settings.open_settings_file = dialog.grp_settings.add('button', [70, 225, 320, 235], "View Settings File..."); 


         // UI > Process
        dialog.grp_process = dialog.add('panel', [-20, 0, 380, 100], "Process");                  
            dialog.grp_process.ok = dialog.grp_process.add('button', [30,15, 370, 80], "Process Active Document", {name:'process'}); 


    ///////////////////////////////////////////////////////////////////////////////
    dialog.grp_settings.export_composite.onClick = function(){
        dialog.grp_settings.selected_layers_only.enabled = dialog.grp_settings.export_composite.value;
    }

    dialog.grp_settings.export_templates.onClick = function(){
        dialog.grp_settings.template_list.enabled = dialog.grp_settings.export_templates.value;
    }

    dialog.grp_settings.open_settings_file.onClick = function(){
        var myfile = File("C:/Program Files (x86)/Notepad++/notepad++.exe");
        if (myfile.exists)
        {
            app.system("\"C:/Program Files (x86)/Notepad++/notepad++.exe\" " + import_funcs.metadata_file);
        }
        else
        {
            app.system("notepad " + import_funcs.metadata_file);
        }
    }
    
    dialog.grp_process.ok.onClick = function(){  
        var small_panel_scale = JSON_data["composite_data"]["small_panel_scale"];
        var large_panel_scale = JSON_data["composite_data"]["large_panel_scale"];
        var padding = JSON_data["composite_data"]["padding"];
        
        var process = true;
        var error_txt = "Error! Couldn't process PSD due to the following reasons;\n\n"
 
        if ((small_panel_scale > 1.0) || (small_panel_scale <= 0.0))
        {
            process = false;
            error_txt += "  * 'Small Panel Scale' value must be above 0.0 and no more than 1.0\n";
        }
    
        if ((large_panel_scale > 1.0) || (large_panel_scale <= 0.0))
        {
            process = false;
            error_txt += "  * 'Large Panel Scale' value must be above 0.0 and no more than 1.0\n";
        }
 
        if (process)
        {
            var root_path = JSON_data["composite_data"]["root_folders"]["export_path"];
            dialog.close();
            export_funcs.process_document (dialog, root_path, small_panel_scale, large_panel_scale, padding);             
        }
        else
        {
            error_txt += "\n\nOperation Cancelled.\n";
            alert(error_txt);
        }              
    }

    ///////////////////////////////////////////////////////////////////////////////
    export_funcs.garbage_collect();      // Clean up and legacy temp folders
    dialog.show();
}

main();

