/*------------------------------------------------------------------------------*
 * File Name: Wksheet.h															*
 * Creation: CPY 4/2/2001														*
 * Purpose: Origin C header	for Worksheet class and other related functions		*
 * Copyright (c) OriginLab Corp.2001											*
 * All Rights Reserved															*
 * EJP 02-06-2004 v7.5817 QA70-5894 ALLOW_VIEWING_ALL_IMPORTED_IMAGES			*
 * EJP 09-01-2004 v8.0127 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP					*
 * EJP 2005-04-21 v8.0225 QA70-7634 OC_SETNAME_RENAME_CLEANUP					*
 * EJP 2005-05-19 v8.0235 QA70-7716 CLEANUP_OC_SET_NUM_COLS						*
 * EJP 2005-05-25 v8.0241 QA70-7218 NEW_MATRIX_WORKBOOK							*
 * EJP 2005-06-30 v8.0261 QA70-7821 MATRIXLAYER_OBJ_MANAGEMENT_METHODS			*
 * EJP 2005-07-13 v8.0268 QA70-7881 OC_MATRIX_OBJECT_IMAGE_ACCESS				*
 * EJP 2005-10-31 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ							*
 * ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 * EJP 2006-03-29 v8.0382 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE			*
 * EJP 2006-04-21 v8.0398 QA70-8616 GET_PROFILE_SPANNING_OBJECTS				*
 * EJP 2006-09-13 v8.0481 QA70-8972 CLEAN_OC_MATRIXLAYER_SETVIEWIMAGE			*
 * TD 10-20-06 QA70-9071 NOTES_PAGE_EMBEDDED_IN_WKS_CELLS						*
 * EJP 2006-10-30 v8.0502 QA70-9073 ADD_XUNITS_AND_XLONGNAME_ARGS_TO_EVENSAMPLING
 * SY 2006-11-14 v8.0510 SPC_IN_DATASHEET_WITH_TREE								*
 * EJP 2007-02-13 v8.0562 QA70-9369 GET_XLONGNAME_AND_XUNIT						*
 * SY 2007-02-19 QA70-9387 v8.0566 MOVE_COLUMN_UNDO								*
 * Hong 03/31/07 v8.0594 MORE_SELECT_OPTION_FOR_CLEAR_LABEL						*
 * SY 2007-05-22 QA70-9575 v8.0624 PRINT_OPTIONS_FOR_WKS_PRINT					*
 * Hong 05/28/07 v8.0628 OPTION_FOR_MISSING_VALUE_WHEN_PERCENT_TEXT				*
 * ML CPY 6/12/07 QA70-9908 PERCENT_TEXT_NEED_MORE_OPTIONS						*
 * Sim 07-05-2007 SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1
 * ML 7/12/2007 OPTIONALLY_NOT_TO_SET_COLUMN_NAMES_FROM_TAGNAMES				*
 * Hong 07/19/07 QA80-10080 v8.0663 ACCESS_MATRIXOBJECT_VIEW_MODE_FROM_OC		*
 * Hong 07/20/07 QA80-9828-P7 v8.0664 FIX_REIMPORT_BINARY_DIADEM_DUPLICATE_STORAGE_INFO
 * EJP 2007-07-27 v8.0670 QA70-10123 OC_GETDIB_CRASH							*
 * ML 11/14/2007 QA70-10619 P1 DELETING_COLUMNS_WITHOUT_DESTROYING_OPERATION	*
 * Folger 01/15/08 QA70-10819 SET_SUBFORMAT_WITH_SPECIFY_FORMAT_BEFORE_SET_FORMAT
 * Folger 01/15/08 QA70-10819 GET_SET_CUSTOM_DISPLAY_FORMAT					*
 * Folger 01/16/08 QA70-10819 MAKE_SET_FORMAT_UNDOABLE							*
 * ML 3/14/2008 IMPORTING_EXCEL_USING_EXCEL									*
 * Hong 03/17/08 QA80-11162 ALLOW_OC_AUTO_SIZE_COMMENT_HEIGHT					*
 * EJP 2008-04-08 v8.0840 QA80-11237 MAP_ROI_MATRIX_RECT_TO_IMAGE_RECT			*
 *	RVD 7/30/2008 qa70-11914 SAMPLE_INTERVAL_UNDO								*
 *	ML 10/24/2008 QA70-12327 CROSSTABBING										*
 *	Kyle 11/20/2008 QA80-12610-P1 ADD_WORKSHEET_METHOD_MOVESHORTNAMES			*
 *	AW 12/10/2008 QA80-12748 ADD_NEW_METHODS_FRO_RECORDSET						*
 *	TD 01-22-2009 QA80-12333_S2 EXPOSE_AND_USE_CopyMatrixObj_FROM_OC			*
 *	YuI 01/26/09 QA70-13023 MATRIX_FIT_IN_IMAGE_FORM_PROBLEMS					*
 *	Folger 02/03/09 QA80-13032 SUPPORT_COPY_LAYER_SCALE_FOR_COPY_IMAGE_DATA		*
 *	YuI 02/27/09 QA70-13194 SET_OUTPUT_COMMENT_MUST_BE_UNDOABLE					*
 *	Folger 04/20/09 QA80-13420 MORE_WORK_ON_GENERAL_XF_BASED_PLOTTING_MECHANISM	*
 *	ML 4/28/2009 QA70-13529 EXCEL_NAMED_RANGE_ACCESS							*
 *	ML 4/30/2009 QA70-13530 EXCEL_PICTURE_OBJECTS_ACCESS						*
 *	Hong 04/27/09 QA80-8454 SUPPORT_MORE_WKS_DATA_MANIPULATION_CAPABILITIES		*
 *	Hong 05/08/09 ADD_IFDEF_FOR_SR6												*
 *	Hong 06/02/09 QA80-12755 EXTRACT_WKS_ADD_START_COL_SUPPORT					*
 *	Kyle 07/09/2009 QA80-13908-S1 COLUMN_SUPPORT_SET_AS_CATEGORICAL_FROM_OC		*
 *	Folger 07/14/09 QA80-13933 PIVOT_TABLE_FAILS_TO_COPY_SOURCE_COLUMN_FORMAT_TO_DEST
 *	Folger 08/28/09 QA80-14228 WORKSHEET_CLEARDATA_NEEDS_ROW_OFFSET_SUPPORT		*
 *	Folger 08/28/09 QA80-14228 WORKSHEET_COPYTO_NEEDS_DEST_ROW_OFFSET_SUPPORT	*
 *	Folger 09/08/09 UNSTACK_SUPPORT_SPECIFY_OTHER_COLUMNS						*
 *	Folger 10/15/09 QA81-13904-P3 SET_MATRIX_XY_COORDINATES_FAILS_TO_UNDO		*
 *	Kyle 10/15/2009 QA80-14475 OC_WORKSHEET_ADD_DELETE_ROWS_METHOD				*
 *	EJP 2009-10-15 QA81-14476 OC_DATASETOBJ_GETSET_MASK							*
 *	Kyle 10/20/2009 QA80-14475-P4 OC_WORKSHEET_REORDER							*
 *	Kyle 10/20/2009 QA80-14475-P4 WORKSHEET_SETNUMROWS_SUPPORT_UNDO				*
 *	Folger 10/23/09 QA81-14477-P1 WMERGEXY_FAILS_TO_UNDO_ROWS_ADDED				*
 *	Sim 11-04-2009 QA81-14476-P3 SUPPORT_SET_RANGE_FOR_OC_SET_MASK				*
 *	RVD 10/5/2009 qa70-14413 WKS_EXPORT_XLS										*
 *	Kenny 11/19/2009 QA81-14679-P1 IMPROVE_XF_WRCOPY_TO_SUPPORT_APPENDING_DATA_BY_ROW*
 *	YuI 12/14/09 QA70-13806 VIRTUAL_MATRIX_IMPLEMENTATION						*
 *	Kenny 01/07/2010 QA81-14928 XF_WSTACK_COL_SUPPORT_INCLUDING_SPECIFIC_NON_STACK_COLUMNS*
 *	Hong 01/20/10 QA80-14785 IMPROVE_IMPORT_SPEED_FOR_TDM_STRING_COL			*
 *	ML 2/5/2010 QA70-15083 SETTING_STRINGS_FROM_ADO_SPEC_CODEPAGE				*
 *	EJP 2010-02-09 QA81-15082 SUPPORT_GETTING_OPERATION_FROM_WHOLE_SHEET_RANGE	*
 *	EJP 2010-06-15 ORG-259 CONTEXT_MENU_FOR_MATRIX_THUMBNAILS, move MoveColumns and SwapColumns from Worksheet to Datasheet class
 *	TD ML 07-13-2010 ORG-519_P2 VIRTUAL_MATRIX_OC_INTERFACE						*
 *	Kyle 07/26/2010 ORG-234-P5 APPLY_PALETTE_TO_MTRIX_OBJECT_IMAGE				*
 *	Kyle 08/05/2010 ORG-723-P1 STRETCH_AND_REVERSE_ORDER_PALETTE_OPTION_IN_COLORMAP
 *	Folger 08/18/10 ORG-815 VIRTUAL_MATRIX_TRANSPOSE_STATUS_WRONG				*
 *	Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
 *	Folger 10/28/2010 ORG-1311-S2 COLMOVE_SUPPORT_MOVE_COLUMNS_TO_SPECIFIED_INDEX
 *	Kyle 11/30/2010 ORG-1591-P2 OC_APPLY_PALETTE_SUPPORT_UNDO					*
 *	Bill 12/08/2010 ORG-1571-S1 IMPROVEMENT_ON_HIDE/UNHIDE_COLUMNS				*
 *	Hong 12/29/10 ORG-1882-S2 STACK_COL_SUPPORT_MULTI_IDENTIFIER				*
 *	Folger 01/13/2011 ORG-1917-S1 UNSTACK_NEW_GUI_DESIGN						*
 *	Folger 01/19/2011 ORG-2052 PIVOT_TABLE_ALLOW_EXTRA_COLUMN_ROW_SOURCE_ADDED_TO_RESULT_SHEET
 *	Hong 02/09/11 ORG-1918-S1 WSTACKCOL_REARRANGE_GUI							*
 *	Kit 02/28/2011 ORG-2308-P2 ADD_NEW_GET_MATRIX_OBJ_INTERFACE					*
 *	Sophy 3/8/2011 ORG-2252-P1 PROPER_TRANSPOSE_ALL_OBJECTS_IN_MATRIXLAYER		*
 *	Folger 04/13/2011 ORG-2620-P1 BETTER_AUTOSIZE_FOR_INSERT_GRAPH				*
 *	Bill 05/31/2011 ORG-2698 COLUMN_SUPPORT_IS_AS_CATEGORICAL_FROM_OC			*
 *	Folger 07/20/2011 ORG-3261-S1 MATRIX_PARAM_NAMES_ALLOW_CUSTOMIZE			*
 *	Folger 08/18/2011 ORG-3247-S1 OC_ACCESS_ABOUT_LOOSE_DATASET_LABELS			*
 *	Folger 08/18/2011 ORG-3537 OC_NAMED_RANGE_SUPPORT							*
 *	Sophy 9/6/2011 ORG-3715-P1 OCCOLUMN_SETEVENSAMPLING_TOO_SLOW				*
 *	Sophy 10/24/2011 ORG-3908-S1 NILIBDDC_COMPILE_ISSUE_IN_ORIGIN9_64BIT		*
 *	Folger 12/22/2011 ORG-4678-P1 ORIGIN_CRASH_AFTER_UNDO_SET_AS_CATEGORICAL_IN_64BIT
 *	Bill 12/31/2011 ORG-4453-P1 WORK_BOOK_CONTINUOUSLY_REFRESH_AFTER_HIDE_MANY_ROWS_OR_COLS
 *	Folger 01/12/2012 ORG-4827-P1 WKS_TRANSPOSE_SUPPORT_COMPACT_ROWS_AND_COLS	*
 *	Zech 01/09/2012 ORG-3527 ADD_COLUMN_FILTER_QUERY							*
 *	Zech 02/21/2012 ORG-5111 ADD_TOP_N_FILTER_INTERFACE							*
 *	Zech 03/06/2012 ORG-3527-S2 IMPROVE_COLUMN_FILTER_ON_SUPPORTING_DIFFERENT_FILTER_TYPES
 *	Folger 03/13/2012 ORG-5121-S5 GET_DATAINFO_TITLE_FROM_OC					*
 *	Zech 03/28/2012 ORG-5375-S2 ADD_OC_INTERFACE_TO_GET_DISTINCT_VALUES			*
 *	Zech 02/20/2012 ORG-5029-P1 IGNORE_HIDDEN_ROW_SHOULD_BE_PROCESSED_AS_A_KIND_OF_MASK
 *	Zech 04/23/2012 ORG-5529-S1 ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
 *	Folger 05/11/2012 ORG-5668-S2 COLUMN_FILTER_SPECIFY_THISCOL					*
 *	Zech 05/14/2012 ORG-5668-S1 OC_METHOD_GET_COMMAND_STRING_FOR_CHECK_LIST_COLUMN_FILTER
 *	Zech 05/16/2012 ORG-5524-P1 COLUMN_FILTER_SUPPORT_UNDO						*
 *	Zech 05/30/2012 ORG-5819-S1 IMPROVE_METHODS_TO_GET_COLUMN_FILTER_FORMAT		*
 *	Zech 06/07/2012 ORG-5703-P2 ADD_OC_METHOD_IS_ROW_SHOWN_FOR_WKS				*
 *	Zech 06/08/2012 ORG-5154-P6 ADD_OC_METHOD_TO_ENABLE_DISABLE_FILTER			*
 *	Folger 07/02/2012 ORG-6101-P1 SAVE_AS_ANALYSIS_TEMPLATE_IGNORE_HIDDEN_ROWS	*
 *	Zech 07/12/2012 ORG-6205-P1 BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT		*
 *	Folger 08/13/2012 ORG-6536-P1 DATE_TIME_VALUES_FAILED_TO_BE_AUTOFILLED		*
 *	Zech 08/28/2012 ORG-6622-P1 WORKSHEET_QUERY_IGNORE_HIDDEN_ROW				*
 *	Zech 09/07/2012 ORG-6716-P1 DATA_INFO_DLG_SHOULD_GET_INDEX_IGNORE_HIDDEN	*
 *------------------------------------------------------------------------------*/
 
#ifndef _WKSHEET_H
#define _WKSHEET_H

#include <common.h> // must always include this, has printf etc

#ifndef _STRING_H //string.h is big, so we should not even load if not needed 
#include <string.h> // most likely you will also need strings
#endif //!_STRING_H

#include <OC_const.h> // consts used in Origin internal functions
#include <Collection.h> //Contains declaration of the template class Collection

#ifndef _GRAPH_H // graph.h is big, avoid loading if possible
#include <graph.h> // graph, plot and graphic objects
#endif //!_GRAPH_H

/**+
http://ocwiki.originlab.com/index.php?title=Category:Datasheet_(class)
*/
class Datasheet : public Layer
{
public:

// Last Update : 2006.6.7 Cheney 
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-Datasheet
*/
	Datasheet();	// Construct an unnattached Datasheet

// Last Update : 2006.6.7 Cheney 
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-Datasheet
*/
	Datasheet(Layer & layer); // Construct a Datasheet from a Layer Object


// Last Update : 2006.6.7 Cheney
// CPY 6/20/06 moved from  Worksheet to here
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-Attach
*/
	BOOL	Attach(LPCSTR lpcszWksName); // Attach worksheet object to a real Origin worksheet


// Last Update : 2006.6.7 Cheney 	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-GetNumCols
*/
	///---Sim 07-05-2007 SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1
	//UINT	GetNumCols(); // Get the number of columns in a Datasheet or Matrix.
	int		GetNumCols(); // Get the number of columns in a Datasheet or Matrix.
	///---END SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1

// Last Update : 2006.6.7 Cheney 
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-GetNumRows
*/
	///---Sim 07-05-2007 SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1
	//UINT	GetNumRows(); // Get the number of rows in a worksheet or matrix.
	int		GetNumRows(); // Get the number of rows in a worksheet or matrix.
	///---END SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1

// Last Update : 2006.6.7 Cheney 
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-SetNumRows
*/
	///Kyle 10/20/2009 QA80-14475-P4 WORKSHEET_SETNUMROWS_SUPPORT_UNDO
	//BOOL	SetNumRows(uint nRows); // Set the number of rows in a Datasheet.
	BOOL	SetNumRows(uint nRows, BOOL bUndo = false); // Set the number of rows in a Datasheet.
	///End WORKSHEET_SETNUMROWS_SUPPORT_UNDO


//// Last Update : 2004.12.20 GRD
///**
	//Remarks:
		//Sets (Renames) the name of the worksheet in a workbook.
		//You can also use this function to bring up the rename dialog for a sheet, 
		//by passing a NULL lpcszName.
	//Keywords:
		//name; worksheet;
	//Example1: 
		//int	Datasheet_SetName_Ex1()
		//{
			//Layer		lay= Project.ActiveLayer();		// gets the active worksheet from Excel
			//Worksheet	wks;
			//wks = (Worksheet)lay;
			//if (wks)
			//{
				//return (BOOL) wks.SetName("ActiveData");
			//}
		//}
	//Parameters:
		//lpcszName = [input] New sheet name, or NULL to enter rename dialog	
	//Return: 
		//TRUE for succes, FALSE for failure
	//SeeAlso:
		//Datasheet::GetName
 //*/
	///// EJP 2005-04-21 v8.0225 QA70-7634 OC_SETNAME_RENAME_CLEANUP
	/////BOOL	SetName(LPCSTR lpcszName); // Sets the name of a worksheet or matrix layer
	///// end OC_SETNAME_RENAME_CLEANUP

// Last Update : 2008.2.14 Iris
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-SetReportTree
*/
	/// ML 7/12/2007 OPTIONALLY_NOT_TO_SET_COLUMN_NAMES_FROM_TAGNAMES
	//int	 SetReportTree(TreeNode &tr, int nBegin = 0); // General report generation function.
	int	 SetReportTree(TreeNode &tr, int nBegin = 0, DWORD dwOptions = 0);
	/// end OPTIONALLY_NOT_TO_SET_COLUMN_NAMES_FROM_TAGNAMES

// Last Update : 2008.02.15 Iris
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-GetReportTree
*/
	BOOL GetReportTree(TreeNode& tr, uint* pReportUID = NULL, int nReport = 0, int nType = GRT_TYPE_RESULTS, BOOL bTranslate = FALSE);

// Last Update : 2008.02.15 Iris
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-Create
*/
	BOOL	Create(LPCSTR lpcszTemplate = NULL, int nOption = CREATE_VISIBLE); // Create a visible worksheet from ORIGIN.OTW

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-Create
*/
	BOOL	Create(LPCSTR lpcszTemplate, LPCSTR lpcszSheetName, int nOption = CREATE_VISIBLE); // Create a visible worksheet from ORIGIN.OTW

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-Reset
*/
	BOOL	Reset( BOOL bReduceSize = TRUE ); // Reset Matrix or Worksheet

// Last Updata : 03-02-2007 Sim ADD_PARTIAL_COLUMN_OPTIONS
// Last Update : 2006.4.13 Cheney
// Last update: /// ML 1/16/2007 QA70-9272 CLEARING_OPERATION_OUTPUTS_ON_CLEARING_INPUT_WORKSHEET
/// TD 11-15-04 QA70-6970 MORE_ON_NEW_WORKBOOK_MENU
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-ClearData
*/
	///------ Folger 08/28/09 QA80-14228 WORKSHEET_CLEARDATA_NEEDS_ROW_OFFSET_SUPPORT
	//BOOL ClearData(DWORD dwOptions = CWOD_SHRINK_COLS, int nC1 = 0, int nC2 = -1); // Clear worksheet of data and reduce number of rows (or optionally NOT reduce)
	BOOL ClearData(DWORD dwOptions = CWOD_SHRINK_COLS, int nC1 = 0, int nC2 = -1, int nR1 = 0); // Clear worksheet of data and reduce number of rows (or optionally NOT reduce)
	///------ End WORKSHEET_CLEARDATA_NEEDS_ROW_OFFSET_SUPPORT
/// end MORE_ON_NEW_WORKBOOK_MENU

// Last Update : 2008.02.15 Iris
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-FindCol
*/
	DataObject FindCol(LPCSTR lpcszColLabel, int nColBegin = 0, BOOL bCaseSensitive = false, BOOL bFullMatch = true, int nColEnd = -1, BOOL bAllowShortName = true);


	// Last Update : 2006.1.3 Cheney
	/// ML 1/13/2006 XVARIABLEBASE_TO_VC
	/**$
	Remarks:
		Read-only display string "[BookName]SheetName"
	Keywords:
		string; book and sheet name;
	Example1:
		int Datasheet_StrBookSheet_Ex1()
		{
			Worksheet wks = Project.ActiveLayer();
			if(wks)
			{
				printf("active layer sheet name is %s", wks.m_strBookSheet);
			}
			return 0;
		}
	*/
	string			m_strBookSheet;

	// Last Update : 2008.02.15 Iris
	/**$
	Remarks:
		Construct range string of worksheet or matrix by the specified range from parameters
	Parameters:
		lpcstrColName1 = the name of the column from
		lpcstrColName2 = the name of the column to
		iBeginRow = the index of selected row from, 0 offset
		iEndRow = the index of selected row to, -1 means the last row
	Return:
		The range string
	Example1:
		int Datasheet_MakeRangeString_Ex1()
		{
			Worksheet wks = Project.ActiveLayer();
			if(wks)
			{
				string strRange = wks.MakeRangeString("A"); // this range string is selected whole column A
				out_str(strRange);
				
				strRange = wks.MakeRangeString("A", "B", 0, 12);
				out_str(strRange);	
			}
			return 0;
		}
	*/
	string			MakeRangeString(LPCSTR lpcstrColName1, LPCSTR lpcstrColName2 = NULL, int iBeginRow = -1, int iEndRow = -1);
	/// end XVARIABLEBASE_TO_VC

// Last Update : 2006.12.31 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-GetLinkTable
*/
	BOOL GetLinkTable(Grid& grid, GraphObject& grTable = NULL);


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-FindLinkObjects
*/
	int FindLinkObjects(vector<uint> &uids);
	
// Last Update : 2008.02.15 Iris
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-SetMissingValue
*/
	int SetMissingValue(int nType, LPVOID pVal, int nC1 = 0, int nC2 = -1);

// Last Update : 2006.12.31 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-FindFirstEmpty
*/
	int FindFirstEmpty(int nC1 = 0, BOOL bContiguous = true);

// Last Update : 2007.4.13 Cheney
///Arvin 01/30/07 QA70-9316 WORKBOOK_TRANSPOSE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-Transpose
	*/
	///------ Folger 01/12/2012 ORG-4827-P1 WKS_TRANSPOSE_SUPPORT_COMPACT_ROWS_AND_COLS
	//int Transpose(BOOL bSel = false, int nExchangeLabel = RCLT_INVALID, BOOL bInsertCol = true, BOOL bUndo = false);
	int Transpose(BOOL bSel = false, int nExchangeLabel = RCLT_INVALID, BOOL bInsertCol = true, BOOL bUndo = false, BOOL bCompactRowCol = FALSE);
	///------ End WKS_TRANSPOSE_SUPPORT_COMPACT_ROWS_AND_COLS
///end WORKBOOK_TRANSPOSE

// Last Update : 2006.6.7 Cheney
//------ CPY 9/24/02 v7.0404 QA70-2658 ASCII_IMPORT_FROM_OC
// requires Origin 7 SR3 or later
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-ImportASCII
*/
/// Hong 07/20/07 QA80-9828-P7 v8.0664 FIX_REIMPORT_BINARY_DIADEM_DUPLICATE_STORAGE_INFO
	//int ImportASCII(LPCSTR lpcszFilename, ASCIMP &stAscImp, ASCIMPRESULT* pResult = NULL, TreeNode& trInfo = NULL); // Import ASCII file into worksheet by using a ASCIMP struct that will define how to import the data
	int ImportASCII(LPCSTR lpcszFilename, ASCIMP &stAscImp, ASCIMPRESULT* pResult = NULL, TreeNode& trInfo = NULL, DWORD dwCtrl = 0); // Import ASCII file into worksheet by using a ASCIMP struct that will define how to import the data
/// end FIX_REIMPORT_BINARY_DIADEM_DUPLICATE_STORAGE_INFO

// Last Update : 2006.12.31 Cheney
/// SY 2006-11-14 v8.0510 SPC_IN_DATASHEET_WITH_TREE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-ImportSPC
*/
	int ImportSPC(LPCSTR lpcszFilename, TreeNode& trInfo = NULL, DWORD dwOption = 0);
/// end SPC_IN_DATASHEET_WITH_TREE

// Last Update : 2006.4.13 Cheney
/// EJP 09-01-2004 v8.0127 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP, added pResult
/**$
    Remarks:
	    Import ASCII file into worksheet using automatic procedure.
	Keywords:
		import; ASCII;
	Example1:
		// Prompt for datafile to be imported into active worksheet
		int	Datasheet_ImportASCII_Ex4()
		{
			Worksheet wks = Project.ActiveLayer();
			if(wks)
			{
				string strFile = GetOpenBox("*.dat");
				return wks.ImportASCII(strFile);
			}
			else
				return -99;
		}
	Parameters: 
		lpcszFilename = [input] A full path ASCII file name
		bRenameWks = [input] if true, rename the worksheet to the file name, might need to be fitted for worksheet naming requirement.
							 Its default value is false.
		nMode = [input] Data target modes { ASCIMP_MODE_REPLACE_DATA | ASCIMP_MODE_APPEND_COLS | ASCIMP_MODE_APPEND_ROWS }.
						Its default value is ASCIMP_MODE_REPLACE_DATA.
		bRenameCols = [input] if true, rename the columns using labels from the file.
							  Its default value is false.
		pResult = [output] if not NULL, Pointer to an ASCIMPRESULT struct.
						   Its default value is NULL.
		trInfo = [output] if not NULL, will get file's infomation. default is NULL.
		dwCtrl = [input]  additional options from the IMPASC_* enumeration.
	Return: 
		TRUE on success, otherwise FALSE
	SeeAlso:
		
 */
/// EJP 09-01-2004 v8.0127 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
/// BOOL ImportASCII(LPCSTR lpcszFilename, BOOL bRenameWks=FALSE, int nMode = ASCIMP_MODE_REPLACE_DATA, BOOL bRenameCols=FALSE);
/// Hong 07/20/07 QA80-9828-P7 v8.0664 FIX_REIMPORT_BINARY_DIADEM_DUPLICATE_STORAGE_INFO
	//BOOL ImportASCII(LPCSTR lpcszFilename, BOOL bRenameWks = FALSE, int nMode = ASCIMP_MODE_REPLACE_DATA, BOOL bRenameCols = FALSE, ASCIMPRESULT* pResult = NULL, TreeNode& trInfo = NULL); // Import ASCII file into worksheet using automatic procedure
	BOOL ImportASCII(LPCSTR lpcszFilename, BOOL bRenameWks = FALSE, int nMode = ASCIMP_MODE_REPLACE_DATA, BOOL bRenameCols = FALSE, ASCIMPRESULT* pResult = NULL, TreeNode& trInfo = NULL, DWORD dwCtrl = 0); // Import ASCII file into worksheet using automatic procedure
/// end FIX_REIMPORT_BINARY_DIADEM_DUPLICATE_STORAGE_INFO
/// end IMPORT_INFO_STORAGE_CLEANUP

/// last comment update by Hong 07/23/08 v8.0907 IMPROVE_IMPORT_EXCEL_ERROR_MESSAGE
//---- CPY 12/24/07 QA70-10867 IMPORT_EXCEL_INTO_EXISTING_SHEET
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-ImportExcel
*/
	int ImportExcel(LPCSTR lpcszFile, int nSheet, XLSReadCntrl* pst);
//---- end IMPORT_EXCEL_INTO_EXISTING_SHEET
	int ExportExcel(LPCSTR lpcszFile);	/// RVD 10/5/2009 qa70-14413 WKS_EXPORT_XLS

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-Cell
*/
	double Cell(int nRow, int nCol);
// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-SetCell
*/
	BOOL SetCell(int nRow, int nCol, double value); // Set the numeric value of a cell in the worksheet

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-SetCell
*/
	BOOL SetCell(int nRow, int nCol, LPCSTR lpcszText, BOOL bConsiderNumeric = true); // Set the string value of a cell in the worksheet
// Last Update : 2004.12.29 GRD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-SetCell
*/
	BOOL SetCell(int nRow, int nCol, LPCSTR lpcszName, const TreeNode& tr); // ut a copy of the XML tree into a cell
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-SetCell
*/
	BOOL SetCell(int nRow, int nCol, Image& img, DWORD dwAttachInfo = 0); 

// Last Update : 2006.12.31 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Datasheet-TCell
*/
	///------ Folger 08/13/2012 ORG-6536-P1 DATE_TIME_VALUES_FAILED_TO_BE_AUTOFILLED
	//string TCell(int nRow, int nCol, int nOption = TCELL_VALUE, DWORD* pdwExtraInfo = NULL);
	string TCell(int nRow, int nCol, int nOption = TCELL_VALUE, DWORD* pdwExtraInfo = NULL, double* prValue = NULL);
	///------ End DATE_TIME_VALUES_FAILED_TO_BE_AUTOFILLED

// Last Update : 2006.12.31 Cheney
	/**$
	 */
	BOOL	SaveRangeUndo(int r1, int c1, int r2, int c2);

	/// SY 2007-05-22 QA70-9575 v8.0624 PRINT_OPTIONS_FOR_WKS_PRINT
/**$
	Remarks: 
		Get print option settings from Datasheet
	Keywords:
	Example1: 
	Parameters: 
		tr = [output] containing printing options on output.
	Return: 
		true on successful, false on failure
	SeeAlso:
		SetPrintOptions
 */
	BOOL GetPrintOptions(TreeNode &tr);

/**$
	Remarks: 
		Set Datasheet's print option settings
	Keywords:
	Example1: 
	Parameters: 
		tr = [input] TreeNode containing option settting information to set printing settings
	Return: 
		true on successful, false on failure
	SeeAlso:
		GetPrintOptions
 */
	BOOL SetPrintOptions(TreeNode &tr);
	/// end PRINT_OPTIONS_FOR_WKS_PRINT

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-MoveColumns
*/
	/// SY 2007-02-19 QA70-9387 v8.0566 MOVE_COLUMN_UNDO
	///	BOOL MoveColumns(int nStartLocation, int nNumCols, int nOperation);
	///------ Folger 10/28/2010 ORG-1311-S2 COLMOVE_SUPPORT_MOVE_COLUMNS_TO_SPECIFIED_INDEX
	//BOOL MoveColumns(int nStartLocation, int nNumCols, int nOperation, BOOL bUndo = FALSE);
	BOOL MoveColumns(int nStartLocation, int nNumCols, int nOperation, BOOL bUndo = FALSE, int nIndex = -1);
	///------ End COLMOVE_SUPPORT_MOVE_COLUMNS_TO_SPECIFIED_INDEX
	/// end MOVE_COLUMN_UNDO


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SwapColumns
*/
	/// SY 2007-02-19 QA70-9387 v8.0566 MOVE_COLUMN_UNDO
	///	BOOL SwapColumns(int nRight, int nLeft); // Swap positions of two columns in Worksheet
	BOOL SwapColumns(int nRight, int nLeft, BOOL bUndo = FALSE);
	/// end MOVE_COLUMN_UNDO

	///------ Folger 08/19/2011 ORG-3537 OC_NAMED_RANGE_SUPPORT
	#ifdef	NEW_NAMED_RANGE_FEATURE
	/**$
		Get all the named ranges defined in the Worksheet or Matrixsheet
	Parameters:
		vsNames=[output]The actual names assigned to the named range, one can also obtain this by constructing the NamedRange object
	Returns:
		total number of named ranages returned, <0 for error codes
	*/
	int		GetNamedRangeNames(vector<string>& vsNames = NULL);
	#endif	/// NEW_NAMED_RANGE_FEATURE
	///------ End OC_NAMED_RANGE_SUPPORT

	///------ Folger 03/13/2012 ORG-5121-S5 GET_DATAINFO_TITLE_FROM_OC
	/**$
	*/
	void	GetDataInfoTitle(string& str, int nType, int nIndex, LPCTSTR lpcszFormat = NULL, const vector<double>* parrCoors = NULL);
	///------ End GET_DATAINFO_TITLE_FROM_OC

	///------ Folger 07/02/2012 ORG-6101-P1 SAVE_AS_ANALYSIS_TEMPLATE_IGNORE_HIDDEN_ROWS
	/**$
	*/
	void	ResetRowColHides(BOOL bCol);

	/**$
	*/
	BOOL	HasFilter(WKSHASFILTER dwCtrls = WKSHASFILTER_NONE);
	///------ End SAVE_AS_ANALYSIS_TEMPLATE_IGNORE_HIDDEN_ROWS

};	// END OF class Datasheet : public Layer

/// TD 11-08-06 QA70-9109 COLLECTION_OF_EMBEDDED_PAGES

/**+
http://ocwiki.originlab.com/index.php?title=Category:CollectionEmbeddedPages_(class)
*/
// Last Update : 2006.12.31 Cheney
class CollectionEmbeddedPages
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CollectionEmbeddedPages-CollectionEmbeddedPages
	*/
	CollectionEmbeddedPages();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CollectionEmbeddedPages-CollectionEmbeddedPages
	*/
	CollectionEmbeddedPages(Worksheet &wks, DWORD dwExcludeBits = 0);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CollectionEmbeddedPages-Attach
	*/
	BOOL Attach(Worksheet &wks, DWORD dwExcludeBits = 0);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CollectionEmbeddedPages-Count
	*/
	///---Sim 07-05-2007 SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1
	//UINT Count();
	int		Count();
	///---END SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CollectionEmbeddedPages-Item
	*/
	Page Item(int nIndex);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CollectionEmbeddedPages-Item
	*/
	Page Item(LPCSTR lpcszName);
};

/// end COLLECTION_OF_EMBEDDED_PAGES

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=Category:Worksheet_(class)
*/
class Worksheet : public Datasheet 
{
public:

// Last Update : 2008.2.18 Iris
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Worksheet
*/
	Worksheet(LPCTSTR lpcszWksName); // Construct a worksheet object and attach to named worksheet window


// Last Update : 2004.12.21 GRD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Worksheet
*/
	Worksheet(Layer & layer); // Construct a worksheet object and attach to the given layer


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-AddCol
*/
	int	AddCol(LPCSTR lpcszColName = NULL, BOOL bUndo = FALSE); // Return index of newly added column (0 offset) or -1 if add column fails

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-AddCol
*/
	int		AddCol(LPCSTR lpcszColName, string& strColNameCreated, BOOL bUndo = FALSE); // Add with Enumerate new columns by name

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-PasteData
*/
	BOOL	PasteData(LPCTSTR lpcszText, int nRow = -1, int nCol = 0, int nRepaintMode = 0); // Paste specified, tab-delimited text into a worksheet

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetASCIMP
*/
	BOOL	GetASCIMP(ASCIMP &stAscImp);  

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetASCIMP
*/
	BOOL	SetASCIMP(ASCIMP &stAscImp);  

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ExportASCII
*/
	int ExportASCII(LPCSTR lpcszFilename, DWORD dwCntrl, char cSeparator = '\t', int nR1 = 0, int nC1 = 0, int nR2 = -1, int nC2 = -1); // Export worksheet to an ASCII file


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-InsertRow
*/
	///------ Folger 10/23/09 QA81-14477-P1 WMERGEXY_FAILS_TO_UNDO_ROWS_ADDED
	//BOOL InsertRow(int nPos); // Insert an empty row in the worksheet
	BOOL InsertRow(int nPos, BOOL bUndo = FALSE); // Insert an empty row in the worksheet
	///------ End WMERGEXY_FAILS_TO_UNDO_ROWS_ADDED


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-DeleteRow
*/
	BOOL DeleteRow(int nPos); // Delete a row in the worksheet


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-AppendRows
*/
	BOOL AppendRows(int nRows = 1 ); // Append rows to the worksheet


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-DeleteCol
*/
	/// ML 11/14/2007 QA70-10619 P1 DELETING_COLUMNS_WITHOUT_DESTROYING_OPERATION
	//BOOL DeleteCol(int nCol); // Delete a column in the worksheet
	BOOL		DeleteCol(int nCol, DWORD dwCtrls = 0); 
	/// end DELETING_COLUMNS_WITHOUT_DESTROYING_OPERATION

	/// Bill 12/08/2010 ORG-1571-S1 IMPROVEMENT_ON_HIDE/UNHIDE_COLUMNS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ShowCol
	*/
	///Bill 12/31/2011 ORG-4453-P1 WORK_BOOK_CONTINUOUSLY_REFRESH_AFTER_HIDE_MANY_ROWS_OR_COLS
	//void		ShowCol(int nCol, BOOL bShow);
	void		ShowCol(int nCol, int nNumCols, BOOL bShow);
	/// End WORK_BOOK_CONTINUOUSLY_REFRESH_AFTER_HIDE_MANY_ROWS_OR_COLS

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ShowRow
	*/
	/// Bill 12/31/2011 ORG-4453-P1 WORK_BOOK_CONTINUOUSLY_REFRESH_AFTER_HIDE_MANY_ROWS_OR_COLS
	//void		ShowRow(int nRow, BOOL bShow);
	void		ShowRow(int nRow, int nNumRows, BOOL bShow);
	/// End WORK_BOOK_CONTINUOUSLY_REFRESH_AFTER_HIDE_MANY_ROWS_OR_COLS
	/// End	IMPROVEMENT_ON_HIDE/UNHIDE_COLUMNS

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-DeleteRange
*/
	BOOL DeleteRange(int nRowBegin, int nColBegin, int nRowEnd, int nColEnd, BOOL bInsertNotDelete = false); // Delete a range of data in the worksheet

	
// Last Update : 2006.12.31 Cheney
//----- CPY 3/20/09 QA70-13316 WKS_GET_SEL_DOC_INCONSISTENT_WITH_CODE
//	int	GetSelection(int &r1, int &c1, int &r2, int &c2, string *pstrAddress = NULL); // Retrieves the current selection from the worksheet (deprecated)
//-----
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetSelection
*/
	int	GetSelection(int &c1, int &c2, int &r1, int &r2, string *pstrAddress = NULL);
	
// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetSelectedRange
*/
	int	GetSelectedRange(int &r1, int &c1, int &r2, int &c2, string *pstrAddress = NULL); // Retrieves the current selection from the worksheet

	
// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetSelectedRange
*/
	BOOL    SetSelectedRange(vector<int> &vR1, vector<int> &vC1 = NULL, vector<int> &vR2= NULL, vector<int> &vC2 = NULL, BOOL bData = true);


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetSelectedRange
*/
	int	GetSelectedRange(vector<int> &vR1, vector<int> &vC1, vector<int> &vR2, vector<int> &vC2, string *pstrAddress = NULL); // Retrieves current multiple selection ranges from the worksheet

	
// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-DeleteSelection
*/
	BOOL		DeleteSelection(BOOL bUndo); // Deletes the current selection from a worksheet.Deletes the current selection from a worksheet.


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetAsLabel
*/
	BOOL	SetAsLabel(UINT nType, int index, BOOL bUndo = FALSE, BOOL bLabel = FALSE, BOOL bAppend = FALSE);
	

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-CheckAddLabelByType
*/
	int	CheckAddLabelByType(UINT nType, int iPos = -1, BOOL bUndo = FALSE, BOOL bColHeaders = true);

// Last Update : 2007.4.13 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ClearLabelsContent
*/
	/// Hong 03/31/07 v8.0594 MORE_SELECT_OPTION_FOR_CLEAR_LABEL
	//BOOL	ClearLabelsContent(BOOL bColHeaders, UINT nType, int nPos = -1);
	BOOL	ClearLabelsContent(UINT nType, int nPos = -1, int nC1 = 0, int nC2 = -1, BOOL bColHeaders = TRUE);
	/// end MORE_SELECT_OPTION_FOR_CLEAR_LABEL
	
///Kyle 11/20/2008 QA80-12610-P1 ADD_WORKSHEET_METHOD_MOVESHORTNAMES
/**$
		move short names to another col label and reset short names
	Parameters:
  		lpcszNewNamePrefix = [input] NULL to use generic Excel type names, otherwise a prefix string. Must be no longer then 3 letters and must be legal col shortname prefix.
  		vsOldContents = [output] contents in the col label that are replaced.
  		nLabelType = [input] -1 to indicate reset SN only, no destination to move SN
  	Return:
  		0 for successed and a negative number for failed, especially -2 for length of new shortname overflowing
*/
	int MoveShortNames(LPCSTR lpcszNewNamePrefix, BOOL bUndo = false, vector<string>& vsOldContents = NULL, int nLabelType = RCLT_LONG_NAME);
///End ADD_WORKSHEET_METHOD_MOVESHORTNAMES


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-IsLabelTypeShown
*/
	BOOL		IsLabelTypeShown(UINT nType, int* pnPos = NULL, BOOL bColHeaders = true);


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-HideLabelByType
*/
	BOOL	HideLabelByType(UINT nType, BOOL bUndo = FALSE, BOOL bColHeaders = true);

/// Hong 03/17/08 QA80-11162 ALLOW_OC_AUTO_SIZE_COMMENT_HEIGHT
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-AutoSizeRow
*/
	BOOL AutoSizeRow(int nRow = RCLT_COMMENT, int nLabel = 1, BOOL bUndo = false, DWORD dwCntrl = AS_NOWIDTH | AS_INVALIDATE);
/// end ALLOW_OC_AUTO_SIZE_COMMENT_HEIGHT

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-IsHeaderShown
*/
	BOOL		IsHeaderShown(BOOL bCol = TRUE); // Determine if Row or Column Headers are shown


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ShowHeaders
*/
	BOOL		ShowHeaders(BOOL bShow = TRUE, BOOL bCol = TRUE); //Show or hide the Row or Column headers.


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-IsLabelCategoryNamesShown
*/
	BOOL		IsLabelCategoryNamesShown();


// Last Update 2005.02.25 GRD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ShowLabelCategoryNames
*/
	BOOL		ShowLabelCategoryNames(BOOL bDisplay); // Show or Hide display of row header labels


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-IsGridLinesShown
*/
	BOOL	IsGridLinesShown(BOOL &bShowVert, BOOL &bShowHoriz); // Reveal if vertical (Column) or horizontal (Row) grid lines are being shown in a worksheet


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ShowGridLines
*/
	BOOL	ShowGridLines(BOOL bShowVert = TRUE, BOOL bShowHoriz = TRUE); // Show or Hide the display of vertical (Column) or horizontal (Row) grid lines in a workbook

	// Last Update : 2006.12.31 Cheney
	/// TD 10-20-06 QA70-9071 NOTES_PAGE_EMBEDDED_IN_WKS_CELLS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-EmbedNote
	*/
	BOOL	EmbedNote(int nRow, int nCol, Note &note, DWORD dwEmbedInfo = 0);
	/// end NOTES_PAGE_EMBEDDED_IN_WKS_CELLS
	
	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-EmbedGraph
	*/
	BOOL	EmbedGraph(int nRow, int nCol, GraphPage &gp, DWORD dwEmbedInfo = 0);
	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-EmbedMatrix
*/
   BOOL    EmbedMatrix(int nRow, int nCol, MatrixPage &mp, DWORD dwEmbedInfo = 0);
	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetEmbeddingParams
	*/
	BOOL	GetEmbeddingParams(int nRow, int nCol, DWORD& dwEmbedParams, BOOL bColLabels = FALSE);

	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetEmbeddingParams
	*/
	BOOL	SetEmbeddingParams(int nRow, int nCol, DWORD dwEmbedParams, BOOL bSet = TRUE, BOOL bColLabels = FALSE);

// Last Update : 2006.12.31 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-DetachGraph
*/
	BOOL	DetachGraph(int nRow, int nCol, BOOL bColLabel = FALSE);



/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-RemoveEmbedding
*/
	BOOL	RemoveEmbedding(int nRow, int nCol, BOOL bColLabel = FALSE, BOOL bUndo = TRUE);


// Last Update : 2006.12.31 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-AttachPicture
*/
	BOOL	AttachPicture(int nRow, int nCol, LPCSTR lpcszFileName, DWORD dwEmbedInfo = 0);

// Last Update : 2006.12.31 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetEmbeddedGraphs
*/
	int	GetEmbeddedGraphs(StringArray &names, DWORD dwExcludeBits = 0);

// Last Update : 2006.12.31 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetLabelType
*/
	int	GetLabelType(int nLabelIndex, BOOL bColLabel = true);

// Last Update : 2007.06.27 Folger
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetLabelRow
*/
	int	GetLabelRow(int nLabelType, BOOL bColLabel = true);
	
///**
	//Remarks:
		//
	//Keywords:
		//
	//Example1:
		//
	//Parameters:
		//nRow = [input] Row index from zero
		//nCol = [input] Column index from zero
	//Return:
		//
	//SeeAlso:
		//
 //*/
	///// EJP 2005-05-25 v8.0241 QA70-7218 NEW_MATRIX_WORKBOOK, move to OriginObject
    /////OperationBase   &GetSrcOperation(int nRow = -1, int nCol = -1);
    ///// end NEW_MATRIX_WORKBOOK

    
// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-FindColIndex
*/
	int	FindColIndex(int nRefCol, int nColDesignation, DWORD dwCntrl = 0);

// Last Update : 2007.4.13 Cheney
/**$
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:
		nTable = [input] 
	Return:
		
	SeeAlso:
		
 */
	BOOL		Print(int nTable);
    // Last Update : 2008.5.13 Sophy
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetPrintArea
	*/
	BOOL		SetPrintArea(const ORANGE* pRange);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetPrintArea
	*/
	BOOL		GetPrintArea(ORANGE* pRange);

// Last Update : 2005.02.25 GRD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetSelectedColumns
*/
	BOOL	GetSelectedColumns(vector<int> &v); // Fill a vector with column indexes where column is completely or partially selected
	

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-UpdateOrigin
*/
	BOOL UpdateOrigin(); // Updates the underlying Origin worksheet from Excel


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-InsertCol
*/
	/// RVD 7/30/2008 qa70-11914 SAMPLE_INTERVAL_UNDO
	//BOOL InsertCol(int nPos, LPCSTR lpcszColName, string &strColNameCreated); // Insert new column into worksheet
	BOOL InsertCol(int nPos, LPCSTR lpcszColName, string &strColNameCreated, BOOL bUndo = FALSE);
	/// end SAMPLE_INTERVAL_UNDO

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetCell
*/
	BOOL GetCell(int nRow, int nCol, string& strText); // Get cell value as a string
	

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetCell
*/
	BOOL GetCell(int nRow, int nCol, string& strName, TreeNode& tr);

	/// ML 3/14/2008 IMPORTING_EXCEL_USING_EXCEL
	/**$
	*/
	BOOL	PutData(_VARIANT &varArray, int nr1 = 0, int nc1 = 0);
	/// end IMPORTING_EXCEL_USING_EXCEL



#ifdef	ORIGIN_COM_SUPPORT
// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-PutSPCBlob
*/
	BOOL	PutSPCBlob(_VARIANT &varBlob, int nRow = -1, int nCol = 0, int nRepaintMode = 0);

/// --- AW 12/10/2008 QA80-12748 ADD_NEW_METHODS_FRO_RECORDSET
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-WriteRecordset
*/
int WriteRecordset(Object &object, DWORD dwCntrl = LAYWKSETRECORDSET_REPLACE, int nRowBegin = 0, int nNumRows = -1, int nColBegin = 0, int nNumCols = -1);

/// ML 2/5/2010 QA70-15083 SETTING_STRINGS_FROM_ADO_SPEC_CODEPAGE
///
//http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ReadRecordset
//
//int ReadRecordset(Object &object, DWORD dwCntrl = LAYWKGETRECORDSET_BY_COLUMN_INDEX_WITH_COLUMN_RENAMING, int nRowBegin = 0, int nNumRows = -1, int nColBegin = 0);	
///// --- END ADD_NEW_METHODS_FRO_RECORDSET
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ReadRecordset
*/
int ReadRecordset(Object &object, DWORD dwCntrl = LAYWKGETRECORDSET_BY_COLUMN_INDEX_WITH_COLUMN_RENAMING, int nRowBegin = 0, int nNumRows = -1, int nColBegin = 0,
				  POSTREADRS postReadRS = NULL);	
/// end SETTING_STRINGS_FROM_ADO_SPEC_CODEPAGE
	
///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-PutRecordset
*/
	BOOL	PutRecordset(	Object &objrs,
							int nRowBegin = 0,
							int nNumRows = -1,
							int nColBegin = 0,
							int nOptions = LAYWKGETRECORDSET_BY_COLUMN_INDEX
							, int *pnErrorCode = NULL		/// ML 1/25/2008 QA70-10972-P4 ADO_EXCEPTION_ON_EMPTY_RECORDSET
							, POSTREADRS postReadRS = NULL	/// ML 2/5/2010 QA70-15083 SETTING_STRINGS_FROM_ADO_SPEC_CODEPAGE
							); // Put data from a recordset into an Origin worksheet


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-PutRecordset
*/
	BOOL	PutRecordset(	_VARIANT &varobjrs,
							int nRowBegin = 0,
							int nNumRows = -1,
							int nColBegin = 0,
							int nOptions = LAYWKGETRECORDSET_BY_COLUMN_INDEX
							, int *pnErrorCode = NULL		/// ML 1/25/2008 QA70-10972-P4 ADO_EXCEPTION_ON_EMPTY_RECORDSET
							, POSTREADRS postReadRS = NULL	/// ML 2/5/2010 QA70-15083 SETTING_STRINGS_FROM_ADO_SPEC_CODEPAGE
							); // Put data from a recordset into an Origin worksheet


#endif //#ifdef	ORIGIN_COM_SUPPORT


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-CreateCopy
*/
	BOOL	CreateCopy(Worksheet &wksSource, int nOption = CREATE_VISIBLE_SAME, DWORD dwCtrl = DCTRL_COPY_DEFAULT);	// Create a copy of an existing worksheet


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Open
*/
	BOOL	Open(LPCSTR lpcszFileName, int nOption = CREATE_VISIBLE);

// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ShowLabels
*/
	void	ShowLabels(BOOL bShow = TRUE); // Show [Hide] column labels


// Last Update : 2006.6.7 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Type
*/
	BOOL	Type(DWORD dwTarget, LPCTSTR lpcszNotesWindow = NULL, int numCols = 5, int nTab = 0, int nRepeatCol = 0, TreeNode &trRanges = NULL);

//Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetRange
*/
	BOOL GetRange( int& iR1, int& iR2, int iC1 = 0, int iC2 = -1, int nAdjustLowerIndex = GDR_SKIP_NON_NUMERIC, int nAdjustUpperIndex = GDR_SKIP_NON_NUMERIC);
//	BOOL GetRange( int& iR1, int& iR2, int iC1 = 0, int iC2 = -1, BOOL bExcludeMissingValues = TRUE);


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetRange
*/
	BOOL SetRange( int iR1, int iR2, int iC1 = 0, int iC2 = -1 ); 


//Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetBounds
*/
	BOOL GetBounds( int& iR1, int iC1, int& iR2, int iC2, BOOL bExcludeMissingValues = TRUE);


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetBounds
*/
	 BOOL SetBounds( int iR1 = 0, int iC1 = 0, int iR2 = -1, int iC2 = -1 );


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetUpperBound
*/
	BOOL SetUpperBound( int iR2, int iC1 = 0, int iC2 = -1 );


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetLowerBound
*/
	BOOL SetLowerBound( int iR1, int iC1 = 0, int iC2 = -1 );


// Last Updated 2005.03.16 GRD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Columns
*/
	Collection<Column> Columns; // The Collection of all Columns in a Worksheet



// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Columns
*/
	Column	Columns(int nCol = -1);	// Access the Columns collection by index


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Columns
*/
	Column	Columns(LPCSTR lpcszName);	// Access the Columns collection by name


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetColDesignations
*/
	BOOL	SetColDesignations(LPCSTR lpcszDesignations, BOOL bRepeat = TRUE, int nC1 = 0, int nC2 = -1);

// Last Update : 2006.12.31 Cheney
	/// TD 11-08-06 QA70-9109 COLLECTION_OF_EMBEDDED_PAGES
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-EmbeddedPages
	*/
	CollectionEmbeddedPages			EmbeddedPages;

	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-EmbeddedPages
	*/
	Page							EmbeddedPages(int nIndex);
	
	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-EmbeddedPages
	*/
	Page							EmbeddedPages(LPCSTR lpcszName);
	
	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetNumEmbeddedPages
	*/
	int								GetNumEmbeddedPages();
	/// end COLLECTION_OF_EMBEDDED_PAGES


// 
#ifdef 	 _CURVE_BASE
// Comment last updated by Joseph 07/26/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetCurve
*/
	curvebase&	GetCurve(int nColx, int nColy); // Create a curve object based on two datasets


// Comment last updated by Joseph 07/26/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetCurve
*/
	curvebase&	GetCurve(int nColy);
#endif// _CURVE_BASE


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetColDesignations
*/
	string	GetColDesignations(); // Get the column designations for a worksheet in string form


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetColDesignations
*/
	void	GetColDesignations(string& strDesignations); // Gets column designations for entire worksheet


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetColFormats
*/
	BOOL	SetColFormats(LPCSTR lpcszFormats, BOOL bRepeat = TRUE); // Sets the column formats in a worksheet.


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetColFormats
*/
	string	GetColFormats(); // Gets the column formats of all the columns in the worksheet


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetColFormats
*/
	void	GetColFormats(string& strFormats); // Gets the column formats of all the columns in the worksheet.


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Sort
*/
	BOOL Sort(int wByColNum = 0,
		BOOL wOrder = SORT_ASCENDING,
        BOOL bMissingValuesSmall = TRUE,
        int iFromRow = 0,
        int iFromCol = 0,
        int iToRow = -1,
        int iToCol = -1); // Sort the specified columns in a worksheet


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Sort
*/
	BOOL Sort(	const vector<int>& vSortByCols,
				const vector<BOOL>& vOrder,
				BOOL bMissingValuesSmall = TRUE,
				int iFromRow = 0,
				int iFromCol = 0,
				int iToRow = -1,
				int iToCol = -1	); // Perform a nested sort of the specified columns in a worksheet 


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-MakeGroupEntriesAndRowMap
*/
	BOOL MakeGroupEntriesAndRowMap(	int r1,
									int r2,
									matrix<ushort> &mEntries,
									vector<ushort> &vRowMap,
									const vector<ushort> &vCols); // Provides categorical information for the worksheet

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-ExtractOneGroup
*/
	BOOL ExtractOneGroup(	vector &v,
							int nCol,
							const vector<ushort>& vRowMap,
							int r1Map,
							int r1,
							int r2,
							ushort nGroupIndex); // 

//added dwCntrl CPY 11/15/08 QA70-12589 WXT_XF_NEED_DEFAULT_NOT_TO_ACTIVATE_OUTPUT
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Extract
*/
	/// Hong 06/02/09 QA80-12755 EXTRACT_WKS_ADD_START_COL_SUPPORT
#ifdef		_NEW_WKS_EXTRACT_NOT_WIPE_OUT_OPERATIONS_
	BOOL Extract(Worksheet& wksDest, const vector<uint>& vnRowIndices, const vector<uint>& vnColIndices, DWORD dwCntrl = DCTRL_COPY_MAKE_ACTIVATE | DCTRL_COPY_KEEP_SHEET_NAME, int nDestC1 = 0, int nDestC2 = -1);
#else		//_NEW_WKS_EXTRACT_NOT_WIPE_OUT_OPERATIONS_
	/// end EXTRACT_WKS_ADD_START_COL_SUPPORT
 	BOOL Extract(Worksheet& wksDest, const vector<uint>& vnRowIndices, const vector<uint>& vnColIndices, DWORD dwCntrl = DCTRL_COPY_MAKE_ACTIVATE | DCTRL_COPY_KEEP_SHEET_NAME);
#endif		//_NEW_WKS_EXTRACT_NOT_WIPE_OUT_OPERATIONS_ /// Hong 06/02/09 QA80-12755 EXTRACT_WKS_ADD_START_COL_SUPPORT
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-CopyTo
	*/
	///------ Folger 08/28/09 QA80-14228 WORKSHEET_COPYTO_NEEDS_DEST_ROW_OFFSET_SUPPORT
	//int	CopyTo(Worksheet& wksDest, int nC1, int nC2, int nR1, int nR2, int nDestC1, int nLNRow = -1, DWORD dwCntrl = CPYT_EXTERN_UPDATE_ORIGIN);
	/// Kenny 11/19/2009 QA81-14679-P1 IMPROVE_XF_WRCOPY_TO_SUPPORT_APPENDING_DATA_BY_ROW
	//int	CopyTo(Worksheet& wksDest, int nC1, int nC2, int nR1, int nR2, int nDestC1, int nLNRow = -1, DWORD dwCntrl = CPYT_EXTERN_UPDATE_ORIGIN, int nDestR1 = 0);
	int	CopyTo(Worksheet& wksDest, int nC1, int nC2, int nR1, int nR2, int nDestC1, int nLNRow = -1, DWORD dwCntrl = CPYT_EXTERN_UPDATE_ORIGIN, int nDestR1 = 0, vector<int>* pvnLabelTypes = NULL);
	/// End QA81-14679-P1 IMPROVE_XF_WRCOPY_TO_SUPPORT_APPENDING_DATA_BY_ROW
	///------ End WORKSHEET_COPYTO_NEEDS_DEST_ROW_OFFSET_SUPPORT

	/// Hong 04/27/09 QA80-8454 SUPPORT_MORE_WKS_DATA_MANIPULATION_CAPABILITIES
#ifdef		MORE_WKS_DATA_MANIPULATION_CAPABILITIES
	// Comment last updated by Kenny on 1/7/2010
	/**$
	Parameters:
		vnColIndices = [Input] column indices to stack. pass NULL to indicate the whole sheet.
		dwCntrl = [Input] enumeration of WKSSTACKCOL_*
		nIdentifier = [Input] to specify column label(RCLT_*) or sheet name(-1) as grouping identifer. See RCLT_* in oc_const.h.
		pvnOtherColIndices = [Input] Specify which columns should be also included, NULL means all the other non-stacked columns.
	*/
	/// Kenny 01/07/2010 QA81-14928 XF_WSTACK_COL_SUPPORT_INCLUDING_SPECIFIC_NON_STACK_COLUMNS
	//int StackColumns(Worksheet& wksDest, const vector<uint>& vnColIndices, int nNumSeries = 1, DWORD dwCntrl = 0, int nIdentifier = RCLT_LONG_NAME);
	int StackColumns(Worksheet& wksDest, 
					const vector<uint>& vnColIndices, 
					int nNumSeries = 1, 
					DWORD dwCntrl = 0, 
					/// Hong 12/29/10 ORG-1882-S2 STACK_COL_SUPPORT_MULTI_IDENTIFIER
					//int nIdentifier = RCLT_LONG_NAME,
					const vector<int>* pvnIdentifiers = NULL,
					/// end STACK_COL_SUPPORT_MULTI_IDENTIFIER
					const vector<uint>* pvnOtherColIndices = NULL
					/// Hong 02/09/11 ORG-1918-S1 WSTACKCOL_REARRANGE_GUI
					, LPCSTR lpcszGroupColLN = NULL, LPCSTR lpcszDataColLN = NULL
					/// end WSTACKCOL_REARRANGE_GUI
					);
	/// End QA81-14928 XF_WSTACK_COL_SUPPORT_INCLUDING_SPECIFIC_NON_STACK_COLUMNS

	/**$
	Parameters:
		dwCntrl = [Input] enumeration of WKSUNSTACKCOL_*
		nLabel = [Input] to specify put grouping data to specified column label type. See RCLT_* in oc_const.h.
	*/
	///------ Folger 09/08/09 UNSTACK_SUPPORT_SPECIFY_OTHER_COLUMNS
	//int UnstackColumns(Worksheet& wksDest, const vector<uint>& vnDataColIndices, const vector<uint>& vnGroupColIndices, DWORD dwCntrl = 0, int nLabel = RCLT_COMMENT);
	int UnstackColumns(Worksheet& wksDest, const vector<uint>& vnDataColIndices, const vector<uint>& vnGroupColIndices, DWORD dwCntrl = 0, int nLabel = RCLT_COMMENT, const vector<uint>* pvnOtherColIndices = NULL
		///------ Folger 01/13/2011 ORG-1917-S1 UNSTACK_NEW_GUI_DESIGN
		, LPUnstackColMore	lpMore = NULL
		///------ End UNSTACK_NEW_GUI_DESIGN
		);
	///------ End UNSTACK_SUPPORT_SPECIFY_OTHER_COLUMNS
	
	/**$
	Parameters:
		vnSrc1ColIndices = [Input] column indices in wksSrc1 to join. pass NULL to indicate the whole sheet.
		vnSrc2ColIndices = [Input] column indices in wksSrc2 to join. pass NULL to indicate the whole sheet.
		dwCntrl = [Input] enumeration of WKSJOINROWS_*
	*/
	int JoinRows(Worksheet& wksSrc1, Worksheet& wksSrc2, const vector<uint>& vnSrc1ColIndices, const vector<uint>& vnSrc2ColIndices, DWORD dwCntrl = 0, int nSrc1MatchCol = 0, int nSrc2MatchCol = 0);
#endif		//MORE_WKS_DATA_MANIPULATION_CAPABILITIES
	/// end SUPPORT_MORE_WKS_DATA_MANIPULATION_CAPABILITIES

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SelectRows
*/
	/// Zech 08/28/2012 ORG-6622-P1 WORKSHEET_QUERY_IGNORE_HIDDEN_ROW
	//int SelectRows(LPCSTR lpcszCondition, vector<uint>& vnRowIndices, int r1 = 0, int r2 = -1, int nMax = -1, LPCSTR lpcszBeforeLoopScript = NULL, LPCSTR lpcszBeforeIfScript = NULL, LPCSTR lpcszAfterIfScript = NULL);
	int SelectRows(LPCSTR lpcszCondition, vector<uint>& vnRowIndices, int r1 = 0, int r2 = -1, int nMax = -1, LPCSTR lpcszBeforeLoopScript = NULL, LPCSTR lpcszBeforeIfScript = NULL, LPCSTR lpcszAfterIfScript = NULL, DWORD dwCntrl = 0);
	/// END WORKSHEET_QUERY_IGNORE_HIDDEN_ROW
	

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-IsWriteProtected
*/
	BOOL	IsWriteProtected(int nBegin = 0, int nEnd = -1);


// Last Update : 2006.6.8 Cheney
//------ CPY 8/9/2007 QA70-10199 WKS_SET_SIZE_NEED_MORE_OPTIONS changed from BOOL bClearData to dwCntrl
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetSize
*/
	BOOL SetSize(int nNumRows, int nNumCols, DWORD dwCntrl = 0);


	

/**$
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:
		nRow = [input] 
		nCol = [input] 
	Return:
		
	SeeAlso:
		
*/
	/// EJP 2010-02-09 QA81-15082 SUPPORT_GETTING_OPERATION_FROM_WHOLE_SHEET_RANGE
	///UINT GetIncomingOperation(int nRow, int nCol);
	UINT GetIncomingOperation(int nRow, int nCol, bool bCheckHierarchical = false);
	/// end SUPPORT_GETTING_OPERATION_FROM_WHOLE_SHEET_RANGE


	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetEvenSampling
	*/
	/// EJP 2006-10-30 v8.0502 QA70-9073 ADD_XUNITS_AND_XLONGNAME_ARGS_TO_EVENSAMPLING
	///int SetEvenSampling(double x0, double xstep, Column& cc= NULL);
	/// RVD 7/30/2008 qa70-11914 SAMPLE_INTERVAL_UNDO
	//int SetEvenSampling(double x0, double xInc, Column& cc= NULL, LPCSTR lpcszXUnits = NULL, LPCSTR lpcszXLongName = NULL);
	int SetEvenSampling(double x0, double xInc, Column& cc= NULL, LPCSTR lpcszXUnits = NULL, LPCSTR lpcszXLongName = NULL, BOOL bUndo = FALSE);
	/// end SAMPLE_INTERVAL_UNDO
	/// end ADD_XUNITS_AND_XLONGNAME_ARGS_TO_EVENSAMPLING

	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetScript
	*/
	void SetScript(LPCSTR lpcszScript, DWORD dwCntrl, LPCSTR lpcszRangeCheckChange = NULL);
	
	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-GetScript
	*/
	BOOL GetScript(string& strScript, DWORD& dwCntrl, string& strRangeCheckChange);

	//BOOL DoRename();
	
	// Last Update : 2006.12.31 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-SetCells
	*/
	BOOL SetCells(const vector<string>& vsValues, int nRow = -1, int nC1 = 0, BOOL bConsiderNumeric = true);

	/// ML 10/24/2008 QA70-12327 CROSSTABBING
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-CrossTab
	*/
	int CrossTab(int nvRow, int nvCol, int nData, matrix &m, vector<string> *pvsRowVals, vector<string> *pvsColVals, int nStatsType = CT_COUNT, DWORD dwCntrl = 0
		///------ Folger 01/19/2011 ORG-2052 PIVOT_TABLE_ALLOW_EXTRA_COLUMN_ROW_SOURCE_ADDED_TO_RESULT_SHEET
		, LPWksCrossTabMore pMore = NULL
		///------ End PIVOT_TABLE_ALLOW_EXTRA_COLUMN_ROW_SOURCE_ADDED_TO_RESULT_SHEET
		);
	/// end CROSSTABBING

	///------ Folger 04/20/09 QA80-13420 MORE_WORK_ON_GENERAL_XF_BASED_PLOTTING_MECHANISM
	#ifdef		__XF_BASED_PLOTTING_MECHANISM__
	int		MakeLineSeriesData(vector& vSeries, vector& vValues, vector<int>& vnCols, int nR1, int nR2, vector<string>* pvsLabels = NULL);
	#endif		/// __XF_BASED_PLOTTING_MECHANISM__
	///------ End MORE_WORK_ON_GENERAL_XF_BASED_PLOTTING_MECHANISM

#ifdef		WKS_MORE_EXCEL_INFO_ACCESS	// Hong 05/08/09 ADD_IFDEF_FOR_SR6
	/// ML 4/28/2009 QA70-13529 EXCEL_NAMED_RANGE_ACCESS
	/**$
			It finds the named range with the supplied name in the Excel sheet.
		Parameters:
			lpcszName=[input]the name of the named range to search for.
			porng=[output,optional]receives the row-column range if found.
		Returns:
			0 if found.
	*/
	int		GetXLNamedRange(LPCSTR lpcszName, ORANGE *porng = NULL);

	/**$
			Creates a named range with the the supplied name in the Excel sheet.
		Parameters:
			lpcszName=[input]the name of the named range to create.
			porng=[input]the row-column range to use for defining the named range
		Returns:
			0 if success.
	*/
	int		CreateXLNamedRange(LPCSTR lpcszName, const ORANGE *porng);

	/**$
			Finds all the named ranges in the Excel sheet.
		Parameters:
			parrNames=[output,optional]the names of all the named ranges in the Excel sheet.
		Returns:
			the count if success.
	*/
	int		GetXLNamedRanges(StringArray *parrNames = NULL);
	/// end EXCEL_NAMED_RANGE_ACCESS
	
	/// ML 4/30/2009 QA70-13530 EXCEL_PICTURE_OBJECTS_ACCESS
	/**$
			Finds out if the named picture object exists in the Excel sheet.
		Parameters:
			lpcszName=[input]the name of the named picture object to find.
		Returns:
			0 if found, otherwise a negative number.
	*/
	int		HasXLNamedPictureObject(LPCSTR lpcszName);

	/**$
			Create a named picture object in the Excel sheet. If it already exists, it will be reinitialized with the supplied
			picture file.
		Parameters:
			lpcszName=[input]the name of the named picture object to create.
			lpcszPictureFile=[input]the picture file to use for initialization.
			porngPos=[input,optional]the row/column range to use for positioning and sizing. If r2 < r1 or c2 < c1, then only
						the left and top will be used for the positioning. If the named picture object already exists, then
						this argument is not used; instead the old position/size is used.
		Returns:
			0 if created, otherwise a negative number.
	*/
	int		CreateXLNamedPictureObject(LPCSTR lpcszName, LPCSTR lpcszPictureFile, const ORANGE *porngPos = NULL);
	/// end EXCEL_PICTURE_OBJECTS_ACCESS
#endif		//WKS_MORE_EXCEL_INFO_ACCESS	// Hong 05/08/09 ADD_IFDEF_FOR_SR6

	///Kyle 10/15/2009 QA80-14475 OC_WORKSHEET_ADD_DELETE_ROWS_METHOD
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-DeleteRows
	*/
	int DeleteRows(const vector<uint>& vRowsToDel, int nC1 = 0, int nC2 = -1, DWORD dwCntrl = 0);
	///End OC_WORKSHEET_ADD_DELETE_ROWS_METHOD

	///Kyle 10/20/2009 QA80-14475-P4 OC_WORKSHEET_REORDER
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Worksheet-Reorder
	*/
	BOOL Reorder(const vector<uint>& vnOrder, int nC1 = 0, int nC2 = -1, BOOL bUndo = FALSE);
	///End OC_WORKSHEET_REORDER

	///------ Folger 04/13/2011 ORG-2620-P1 BETTER_AUTOSIZE_FOR_INSERT_GRAPH
	/**$
	*/
	BOOL AutosizeLinkedCell(int nRow, int nCol);
	///------ End BETTER_AUTOSIZE_FOR_INSERT_GRAPH
	
	/// Zech 01/09/2012 ORG-3527 ADD_COLUMN_FILTER_QUERY
	/**#
	This function runs the filter and make some changes in the worksheet 
	according to the argument.
		Example1:
			// The rows with the value NOT (less than 3 and larger than 1) in the first column will be hidden.
			void Test()
			{
				Worksheet wks = Project.ActiveLayer();
				wks.RunFilter();
			}
		Parameters:
			nAction		=	[input] Action type.
			nRowBegin	=	[input] The begin of the filter range
			nRowEnd		=	[input] The end of the filter range	
			bUndo		=	[input] If make this operation undoable
		Return:
			Returns 0 when succeed
	*/
	int RunFilter(int nAction = QUERY_FILTER_ACT_HIDE_NOT_MATCHED, int nRowBegin = 0, int nRowEnd = -1, bool bUndo = false, DWORD dwCntrl = 0, ColumnUpdateFilterCondition* pExcludeColCondition = NULL);
	/// END ADD_COLUMN_FILTER_QUERY
	
	/// Zech 02/20/2012 ORG-5029-P1 IGNORE_HIDDEN_ROW_SHOULD_BE_PROCESSED_AS_A_KIND_OF_MASK
	/**$
	*/
	BOOL	IsIgnoreHiddenRow();	
	/// END IGNORE_HIDDEN_ROW_SHOULD_BE_PROCESSED_AS_A_KIND_OF_MASK
	
	/// Zech 04/23/2012 ORG-5529-S1 ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
	/**$
	*/
	void	SetIgnoreHiddenRow(bool bIgnore);
	/// END ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
	
	/// Zech 06/07/2012 ORG-5703-P2 ADD_OC_METHOD_IS_ROW_SHOWN_FOR_WKS
	/**$
	*/
	BOOL	IsRowShown(int nRow);
	/// END ADD_OC_METHOD_IS_ROW_SHOWN_FOR_WKS

	/// Zech 09/07/2012 ORG-6716-P1 DATA_INFO_DLG_SHOULD_GET_INDEX_IGNORE_HIDDEN
	/**$
	*/
	int		GetIndexFromShownRowIndex(int nIndex, int nBeginIndex = 0, int nEndIndex = -1);
	/// END DATA_INFO_DLG_SHOULD_GET_INDEX_IGNORE_HIDDEN
};	// END OF class Worksheet : public Datasheet 



// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=Category:MatrixLayer_(class)
*/
class MatrixLayer : public Datasheet 
{
public:
// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-MatrixLayer
*/
	MatrixLayer(const char* MatrixName); // Constructor for the MatrixLayer class

	
// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-MatrixLayer
*/
	MatrixLayer(Layer & layer); // Construct a MatrixLayer from a Layer object

// Last Update : 2008.5.13 Sophy
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-SetDataDisplay
*/
	BOOL SetDataDisplay(int nDisplay, uint numOfDigits, uint numOfDecimals);


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-GetCellWidth
*/
	/// EJP 2005-05-19 v8.0235 QA70-7716 CLEANUP_OC_SET_NUM_COLS
	///uint GetCellWidth(); // Get the matrix cell width
	int GetCellWidth(); // Get the matrix cell width
	/// end CLEANUP_OC_SET_NUM_COLS

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-SetCellWidth
*/
	/// EJP 2005-05-19 v8.0235 QA70-7716 CLEANUP_OC_SET_NUM_COLS
	///BOOL SetCellWidth(uint nCellWidth); // Set the matrix cell width
	BOOL SetCellWidth(int nCellWidth); // Set the matrix cell width
	/// end CLEANUP_OC_SET_NUM_COLS

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-GetInternalDataType
*/
	UINT GetInternalDataType();

// Last Update : 2006.12.31 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-GetInternalData
*/
	UINT GetInternalData();

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-SetInternalDataType
*/
	BOOL SetInternalDataType(UINT nType, DWORD dwFlags = OCD_RESET_VIEW | OCD_RESTORE);

// Last Update : 2008.5.13 Sophy	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-SetInternalData
*/
	BOOL SetInternalData(UINT iType, BOOL bSaveData=TRUE, BOOL bSetViewData = TRUE);


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-SetNumCols
*/
	/// EJP 2005-05-19 v8.0235 QA70-7716 CLEANUP_OC_SET_NUM_COLS
	///BOOL SetNumCols(uint nCols); // Set the number of columns in a MatixLayer.
	///Kyle 10/20/2009 QA80-14475-P4 WORKSHEET_SETNUMROWS_SUPPORT_UNDO
	//BOOL SetNumCols(int nCols); // Set the number of columns in a MatixLayer.
	BOOL SetNumCols(int nCols, BOOL bUndo = false);
	///End WORKSHEET_SETNUMROWS_SUPPORT_UNDO
	/// end CLEANUP_OC_SET_NUM_COLS


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-CreateCopy
*/
	BOOL	CreateCopy(MatrixLayer &matlayerSource, int nOption = CREATE_VISIBLE_SAME, DWORD dwCtrl = DCTRL_COPY_DEFAULT);


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-HasImage
*/
	BOOL HasImage(); // Check if MatrixLayer has associated image


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-HasData
*/
	BOOL HasData(); // Check if MatrixLayer has data that represent the image


// Last Update : 2006.12.31 Cheney	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-SetViewImage
*/
	/// EJP 2006-09-13 v8.0481 QA70-8972 CLEAN_OC_MATRIXLAYER_SETVIEWIMAGE
	///	/// EJP 02-06-2004 v7.5817 QA70-5894 ALLOW_VIEWING_ALL_IMPORTED_IMAGES
	///	///BOOL SetViewImage(BOOL bSetViewImage = TRUE); // nView and nIndex for Origin 8 and later only
	///	BOOL SetViewImage(BOOL bSetViewImage = TRUE, int nView = IMGV_DATA, int nIndex = 0, int nOption = -1);
	///	/// end ALLOW_VIEWING_ALL_IMPORTED_IMAGES
	BOOL SetViewImage(BOOL bSetViewImage = TRUE, BOOL bAllObjs = TRUE, int nImgIndex = 0, int nOption = -1);
	/// end CLEAN_OC_MATRIXLAYER_SETVIEWIMAGE


	///Sophy 3/8/2011 ORG-2252-P1 PROPER_TRANSPOSE_ALL_OBJECTS_IN_MATRIXLAYER
	/**$
		This function transpose the data in all matrix objects in the layer.
	*/
	BOOL Transpose();
	///end PROPER_TRANSPOSE_ALL_OBJECTS_IN_MATRIXLAYER
#ifdef	ORIGIN_COM_SUPPORT
// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-PutSPCBlob
*/
	BOOL	PutSPCBlob(_VARIANT &varBlob);
#endif //#ifdef	ORIGIN_COM_SUPPORT


// Last Update : 2006.6.8 Cheney	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-Open
*/
	BOOL	Open(LPCSTR lpcszFileName, int nOption = CREATE_VISIBLE);


// Last Update : 2008.5.13 Sophy
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-CopyImage
*/
	BOOL	CopyImage(MatrixLayer SrcLayer, int left, int top, int right, int bottom, BOOL bUndo = TRUE);


// Last Update : 2008.5.13 Sophy
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-CopyImage
*/
	BOOL	CopyImage(MatrixLayer SrcLayer, GraphObject grObject, BOOL bUndo = TRUE);

// Last Update : 2008.5.13 Sophy
/**$
	Remarks:
		Get matrix object of matrix layer by index
	Keywords:
		Matrix object;
	Example1:
		void	MatrixLayer_MatrixObjects_Ex1()
		{
			MatrixPage mp = Project.MatrixPages(0);
			if(!mp)
				return;
			
			MatrixLayer ml = mp.Layers(0);
			MatrixObject mo = ml.MatrixObjects(); //get acyive matrix object
			
			mp.AddLayer(); //add new layer
			int nCount = mp.Layers.Count();
			MatrixLayer mlNew = mp.Layers(nCount - 1);
			matrix& mat = mlNew.MatrixObjects().GetDataObject();
			mat = mo.GetDataObject(); //copy data to new layers acyive matrix object
			if( mat )
				printf("Success to get matrix object!");
			else
				printf("Fail to get matrix object!");
		}
	Parameters:
		ObjIndex = [input] matrix object's index. default is -1, means active matrix object
	Return:
		return matrix object got by index. if it is invalid, will be NULL
	SeeAlso:
		
 */
	MatrixObject			  MatrixObjects(int ObjIndex = -1);


// Last Update : 2011.2.28 Kit
/**$
	Remarks:
		Get matrix object of matrix layer by name
	Keywords:
		Matrix object;
	Example1:
		void	MatrixLayer_MatrixObjects_Ex1()
		{
			MatrixPage mp = Project.MatrixPages(0);
			if(!mp)
				return;
			
			MatrixLayer ml = mp.Layers(0);
			MatrixObject mo = ml.MatrixObjects("1"); //get the matrix object which name is "1"
			
			if( mo )
				printf("Success to get matrix object!");
			else
				printf("Fail to get matrix object!");
		}
	Parameters:
		lpcszName = [input] matrix object's name.
	Return:
		return matrix object got by name. if it is invalid, will be NULL
	SeeAlso:
		
 */
	MatrixObject			  MatrixObjects(LPCTSTR lpcszName);
///-----End ADD_NEW_GET_MATRIX_OBJ_INTERFACE

// Last Update : 2006.12.31 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-MatrixObjects
*/
	Collection<MatrixObject>  MatrixObjects;

	
// Last Update : 2008.5.13 Sophy
/// EJP 2005-06-30 v8.0261 QA70-7821 MATRIXLAYER_OBJ_MANAGEMENT_METHODS
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-Insert
*/
	int Insert(uint nNumObjs, int nPos = -1, int nType = -1, int nRows = 5, int nCols = 5);

	
// Last Update : 2008.5.13 Sophy
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-Delete
*/
	BOOL Delete(int nPos, uint nNumObjs = 1);

	
// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-SetSize
*/
	BOOL SetSize(int nNumObjs = 1, int nNumRows = -1, int nNumCols = -1, DWORD dwCntrl = OCD_RESTORE | OCD_INITDATA);

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-GetActive
*/
	int GetActive();

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixLayer-SetActive
*/
	BOOL SetActive(int nIndex);
	/// end MATRIXLAYER_OBJ_MANAGEMENT_METHODS


/// EJP 2006-04-21 v8.0398 QA70-8616 GET_PROFILE_SPANNING_OBJECTS
/**#
		Get profile of cell, from all MatrixOjbects, at specified row and column. 
	Parameters:
		nRow = [input] zero based index of the row that contains the cell 
		nCol = [input] zero based index of the column that contains the cell 
		vData = [output] vector to receive the cell values 
	Return:
		Size of vector for success, -1 for failure 
	Example:
		void MatrixLayer_CellProfile_Ex1()
		{
		    MatrixPage mp = Project.MatrixPages(0);
		    if(!mp)
		        return;
		 
		    MatrixLayer ml(mp.GetName());
		 
		    vector vData;
		    int nRet = ml.CellProfile(0, 0, vData);
		    if( -1 == nRet )
		        printf("Failed to get cell profile");
		}		
*/
	int CellProfile(int nRow, int nCol, vectorbase& vData);

/**#
		Get profile of the specified row from all MatrixOjbects. 
	Parameters:
		nRow = [input] zero based index of the row to get 
		mData = [output] matrix to receive the rows 
	Return:
		Size of matrix for success, -1 for failure 
	Example:
		void MatrixLayer_RowProfile_Ex1()
		{
		    MatrixPage mp = Project.MatrixPages(0);
		    if(!mp)
		        return;
		 
		    MatrixLayer ml(mp.GetName());
		 
		    matrix mat;
		    int nRet = ml.RowProfile(0, mat);
		    if( -1 == nRet )
		        printf("Failed to get row profile");
		}
*/
	int RowProfile(int nRow, matrixbase& mData);

/**#
		Get profile of the specified column from all MatrixOjbects. 
	Parameters:
		nCol = [input] zero based index of the column to get 
		mData = [output] matrix to receive the columns 
	Return:
		Size of matrix for success, -1 for failure 
	Example:
		void MatrixLayer_ColProfile_Ex1()
		{
		    MatrixPage mp = Project.MatrixPages(0);
		    if(!mp)
		        return;
		 
		    MatrixLayer ml(mp.GetName());
		 
		    matrix mat;
		    int nRet = ml.ColProfile(0, mat);
		    if( -1 == nRet )
		        printf("Failed to get column profile");
		}
*/
	int ColProfile(int nCol, matrixbase& mData);
	/// end GET_PROFILE_SPANNING_OBJECTS

	string		GetAxesLongName(BOOL bYAxes = TRUE); // Get the long name of a column

	BOOL		SetAxesLongName(LPCSTR lpcszLongName, BOOL bYAxes = TRUE); // Sets the long name of a column
	
	string		GetAxesComments(BOOL bYAxes = TRUE); // Get the comments in a column label
	
	BOOL		SetAxesComments(LPCSTR lpcszComments, BOOL bYAxes = TRUE); // Sets the comments in a column label
	
	string		GetAxesUnits(BOOL bYAxes = TRUE); // Get the units in a column label
	
	BOOL		SetAxesUnits(LPCSTR lpcszUnits, BOOL bYAxes = TRUE); // Set the units in a column label

	///------ Folger 07/20/2011 ORG-3261-S1 MATRIX_PARAM_NAMES_ALLOW_CUSTOMIZE
	/**$
	*/
	BOOL		GetParamNames(string& strFirst, string& strSecond);
	///------ End MATRIX_PARAM_NAMES_ALLOW_CUSTOMIZE
};	// END OF class MatrixLayer : public Datasheet 


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=Category:Column_(class)
*/
class Column : public DataObject
{
public:
// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-Column
*/
	Column(); // Default constructor for Column class

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-Column
*/
	Column(LPCTSTR lpcszWksName, UINT iColNum); // Constructor that creates an Column object when given a column number in a named worksheet.


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-Column
*/
	Column(Worksheet &wks, UINT iColNum); // Constructor that creates a Column object when given a column number and a worksheet object. 


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-Column
*/
	Column(DataObject& colOriginal); // Reference copy constructor


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-Attach
*/
	BOOL Attach(LPCSTR lpcszWksName, UINT iColNum);	// Attach the column object to a Worksheet column by worksheet name nad column number

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-Attach
*/
	BOOL Attach(Worksheet &wks, UINT iColNum); // Attach the column object to a Worksheet column using a worksheet object and column number

///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetDigitMode
*/
	int GetDigitMode(); // Gets the display mode used for numbers in a column


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetDigitMode
*/
	BOOL SetDigitMode(int iDigitMode); // Sets the display mode used for numbers in a column

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetDigits
*/
	int GetDigits(); // Get the digit value for numeric display mode


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetDigits
*/
	BOOL SetDigits(int iDigits); // Set the digit value for the numeric display mode


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetFormat
*/
	int GetFormat(); // Get the column format


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetFormat
*/
	//------ Folger 01/16/08 QA70-10819 MAKE_SET_FORMAT_UNDOABLE
	//BOOL SetFormat(int iFormat); // Set the column format
	BOOL SetFormat(int iFormat, int nSubformat = -1, BOOL bUndo = FALSE); // Set the column format
	//------


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetJustify
*/
	int GetJustify(); // Get the column justification


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetJustify
*/
	BOOL SetJustify(int iJustify); // Set the column justification


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetLabel
*/
	int	GetLabel(string &strLabel); // Get the column label by reference


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetLabel
*/
	string	GetLabel(); // Get the column labels


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetLabel
*/
	BOOL SetLabel(LPCSTR lpcstrLabel); // Set the column label


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetExtendedLabel
*/
	BOOL		SetExtendedLabel(LPCSTR lpcszLabel, int nn, BOOL bByType = TRUE); // Sets the extended label by type of extended label.


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetExtendedLabel
*/
	BOOL		GetExtendedLabel(string &str, int nn, BOOL bByType = TRUE); // Gets the extended label by type of extended label

///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetLongName
*/
	string		GetLongName(); // Get the long name of a column


// Last Updated 2005.03.25 GRD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetLongName
*/
	BOOL		SetLongName(LPCSTR lpcszLongName); // Sets the long name of a column


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetComments
*/
	string		GetComments(); // Get the comments in a column label


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetComments
*/
	/// YuI 02/27/09 QA70-13194 SET_OUTPUT_COMMENT_MUST_BE_UNDOABLE
	//	BOOL		SetComments(LPCSTR lpcszComments); // Sets the comments in a column label
	BOOL		SetComments(LPCSTR lpcszComments, BOOL bUndo = FALSE); // Sets the comments in a column label
	/// end SET_OUTPUT_COMMENT_MUST_BE_UNDOABLE

	
///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetUnits
*/
	string		GetUnits(); // Get the units in a column label

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetUnits
*/
	BOOL	SetUnits(LPCSTR lpcszUnits); // Set the units in a column label


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetParameters
*/
	BOOL		SetParameters(const vector<string> &vstr); // Sets the Parameters in a column label

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetParameters
*/
	BOOL		GetParameters(vector<string> &vstr); // Gets the Parameters in a column label


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetParameter
*/
	BOOL		SetParameter(LPCTSTR lpcszParam, int index = 0); // Sets one parameter in a column label

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetParameter
*/
	BOOL		GetParameter(string &str, int index = 0); // Get one parameter value.from column label


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetName
*/
	int GetName(string &strName); // Get the column short name.


//// Last Updated 2005.03.25 GRD
///**
	//Remarks: 
		//Set the column short name
		//Rules for column names will be enforced so the final name may be different than the assigned name
		//If a final name (after Origin 'fixes' the name) matches an existing name, nothing is done
	//Keywords:
		//
	//Example1:
		//// Create a worksheet with 'bad' short names
		//void	Column_SetName_Ex1()
		//{
			//Worksheet wks;
			//wks.Create("Origin", CREATE_VISIBLE);
			//string strName = "Short Name 1";
			//BOOL b = wks.Columns(0).SetName(strName);
			//printf("Actual name is %s\n", wks.Columns(0).GetName());
			//strName = "Short Name 2";
			//b = wks.Columns(1).SetName(strName);
			//printf("Actual name is %s\n", wks.Columns(1).GetName());
		//}
	//Parameters: 
		//lpcstrName = [input] pointer to a null-terminated string to be used as the column name
	//Return: 
		//TRUE, set the column name successfully, FALSE, unsuccessful.
			//the error may simply be that Origin modified the name which is now in 
			//strColName any more disastrous error should set the string to null
	//SeeAlso:
		//Column::GetName
//*/
	///// EJP 2005-04-21 v8.0225 QA70-7634 OC_SETNAME_RENAME_CLEANUP
	/////BOOL SetName(LPCSTR lpcstrName); // Set the column short name
	///// end OC_SETNAME_RENAME_CLEANUP


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetSubFormat
*/
	int GetSubFormat(); // Get the SubFormat used by a column


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetSubFormat
*/
	//------ Folger 01/15/08 QA70-10819 SET_SUBFORMAT_WITH_SPECIFY_FORMAT_BEFORE_SET_FORMAT
	//BOOL SetSubFormat(int iSubFormat);
	BOOL SetSubFormat(int iSubFormat, int iFormatToUse = -1);
	//------

///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetTextMaxLen
*/
	int GetTextMaxLen(); // Get the text width of a column


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetTextMaxLen
*/
	BOOL SetTextMaxLen(int iTWidth); // Set the text width of the column


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetType
*/
	int GetType(); // Get the type designator of a column (X, Y, Z, YErr, XErr, L or disregard)


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetType
*/
	BOOL SetType(int iType); // Set the type designator of a column (X, Y, Z, YErr, XErr, L or disregard)

///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetWidth
*/
	int GetWidth(); // Get the display width of a column in number of characters


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetWidth
*/
	BOOL SetWidth(int iWidth = -1); // Set the display column width of a column in number of characters

// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetInternalData
*/
	BOOL SetInternalData(UINT iType); // Set the column internal data type


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetInternalData
*/
	UINT GetInternalData(); // Get the column internal data type


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetDataObject
*/
	vectorbase& GetDataObject(); // Get the Dataset associated with a column as a vectorbase class reference


// Last Update : 2006.6.8 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetUpperBound
*/
	BOOL SetUpperBound( int iR2 ); // Set the ending row display indices


// Comment last updated by Joseph 07/26/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetLowerBound
*/
	BOOL SetLowerBound( int iR1 ); // Set the begining row display indices




///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetNumRows
*/
	int GetNumRows(); // Get the number of rows in a Column.


// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetNumRows
*/
	BOOL SetNumRows(int nRows); // Set the number of rows in a Column.



// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetLowerBound
*/
 	int		GetLowerBound();


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetUpperBound
*/
 	int		GetUpperBound();


// Comment last updated by Joseph 07/26/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetLastDependentColumnOffset
*/
	int		GetLastDependentColumnOffset(DWORD dwCntrl);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetStringArray
	*/
	/// Zech 05/30/2012 ORG-5703-P2 GET_DATA_FROM_RANGE_SUPPORT_IGNORE_HIDDEN
	//BOOL GetStringArray(vector<string>& as, int nRow1=0, int nRow2=-1, BOOL bFullPrecision = true, BOOL bMissingAsBlank = true);
	BOOL GetStringArray(vector<string>& as, int nRow1=0, int nRow2=-1, BOOL bFullPrecision = true, BOOL bMissingAsBlank = true, DWORD dwCntrl = 0);
	/// END GET_DATA_FROM_RANGE_SUPPORT_IGNORE_HIDDEN
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Column-PutStringArray
	*/
	BOOL PutStringArray(const vector<string>& as, int nRow1=0, BOOL bCheckConvertNumeric = false);


///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-IsWriteProtected
*/
	BOOL	IsWriteProtected(); // Determine if a column is write protected

/// EJP 2007-02-13 v8.0562 QA70-9369 GET_XLONGNAME_AND_XUNIT
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-IsEvenSampling
*/
	BOOL IsEvenSampling(double* px0=NULL, double* pxInc=NULL, string* pStrXUnits = NULL, string* pStrXLongName = NULL);
/// end GET_XLONGNAME_AND_XUNIT

	/// YuI 06/12/07 QA70-9913 XYRNAGE_EVEN_SAMPLING_PROPER_SUPPORT
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetEvenSampling
*/
	/// RVD 7/30/2008 qa70-11914 SAMPLE_INTERVAL_UNDO
	//BOOL	SetEvenSampling(double dX0, double dXInc, LPCSTR lpcszXUnits = NULL, LPCSTR lpcszXLongName = NULL, LPCSTR lpcszDispFormat = NULL);
	///Sophy 9/6/2011 ORG-3715-P1 OCCOLUMN_SETEVENSAMPLING_TOO_SLOW
	//BOOL	SetEvenSampling(double dX0, double dXInc, LPCSTR lpcszXUnits = NULL, LPCSTR lpcszXLongName = NULL, LPCSTR lpcszDispFormat = NULL, BOOL bUndo = FALSE);
	BOOL	SetEvenSampling(double dX0, double dXInc, LPCSTR lpcszXUnits = NULL, LPCSTR lpcszXLongName = NULL, LPCSTR lpcszDispFormat = NULL, BOOL bUndo = FALSE, BOOL bUpdateDepCols = TRUE);
	///end OCCOLUMN_SETEVENSAMPLING_TOO_SLOW
	/// end SAMPLE_INTERVAL_UNDO
	
	/// end XYRNAGE_EVEN_SAMPLING_PROPER_SUPPORT
	
	//------ Folger 01/15/08 QA70-10819 GET_SET_CUSTOM_DISPLAY_FORMAT
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Column-GetCustomDisplay
	*/
	string		GetCustomDisplay();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetCustomDisplay
	*/
	BOOL		SetCustomDisplay(LPCSTR lpcszDisplay, bool bUndo = false);
	//------
	
	///Kyle 07/09/2009 QA80-13908-S1 COLUMN_SUPPORT_SET_AS_CATEGORICAL_FROM_OC, for 81
#ifdef __SET_COLUMN_AS_CATEGORICAL_FROM_OC__
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Column-SetAsCategorical
	*/
	///------ Folger 12/22/2011 ORG-4678-P1 ORIGIN_CRASH_AFTER_UNDO_SET_AS_CATEGORICAL_IN_64BIT
	//int SetAsCategorical(int nType);
	int SetAsCategorical(int nType, BOOL bUndo = FALSE);
	///------ End ORIGIN_CRASH_AFTER_UNDO_SET_AS_CATEGORICAL_IN_64BIT
#endif //__SET_COLUMN_AS_CATEGORICAL_FROM_OC__
	///End COLUMN_SUPPORT_SET_AS_CATEGORICAL_FROM_OC

	/// Bill 05/31/2011 ORG-2698 COLUMN_SUPPORT_IS_AS_CATEGORICAL_FROM_OC
	/**$
	*/
	bool IsAsCategorical();
	/// End COLUMN_SUPPORT_IS_AS_CATEGORICAL_FROM_OC

	///------ Folger 07/14/09 QA80-13933 PIVOT_TABLE_FAILS_TO_COPY_SOURCE_COLUMN_FORMAT_TO_DEST
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Column-CopyDataFormat
	*/
	void		CopyDataFormat(Column& colSrc, BOOL bForceSubformatUpdate = TRUE);
	///------ End PIVOT_TABLE_FAILS_TO_COPY_SOURCE_COLUMN_FORMAT_TO_DEST
	
	/// Hong 01/20/10 QA80-14785 IMPROVE_IMPORT_SPEED_FOR_TDM_STRING_COL
	/**$
	*/
	///Sophy 10/24/2011 ORG-3908-S1 NILIBDDC_COMPILE_ISSUE_IN_ORIGIN9_64BIT
	//BOOL		ImportTDMStringValues(pfnDDC_GetValues& pfnGetDataValues, DWORD channel, DWORD dwDataSize, pfnDDC_FreeMemory& pfnFreeMemory);
	BOOL		ImportTDMStringValues(pfnDDC_GetValues& pfnGetDataValues, DWORD_PTR channel, size_t dwDataSize, pfnDDC_FreeMemory& pfnFreeMemory);
	///end NILIBDDC_COMPILE_ISSUE_IN_ORIGIN9_64BIT
	/// end IMPROVE_IMPORT_SPEED_FOR_TDM_STRING_COL
	
	///Sophy 9/9/2010 ORG-1014 XF_SUPPORT_REVERSE_COLUMN_DATA
#ifdef	__OC_COLUMN_REVERSE__
	/**
		This function is use to reverse a range of rows within a column.
		Example1:
			void	Column_Reverse()
			{
				Worksheet wks = Project.ActiveLayer();
				if ( wks && wks.GetNumCols() > 0 )
				{
					Column col(wks, 0);
					//reverse cell(6) to cell(10)
					col.Reverse(5,9);
				}
			}
		Parameters:
			nR1 = [input] row index of the first cell in the column.
			nR2 = [input] row index of the last cell in the column.
		Return:
			Returns TRUE if successful, or else return FALSE.
	*/
	///Sophy 12/16/2010 ORG-1014-P1 COLUMN_DATA_REVERSE_UNDO_SUPPORT
	//BOOL		Reverse(int nR1 = 0, int nR2 = -1);
	BOOL		Reverse(int nR1 = 0, int nR2 = -1, BOOL bUndo = FALSE);
	///end COLUMN_DATA_REVERSE_UNDO_SUPPORT
#endif	//__OC_COLUMN_REVERSE__
	///end XF_SUPPORT_REVERSE_COLUMN_DATA

	///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	/**$
	*/
	BOOL		HasCellLinks(vector<int>* parrRows = NULL);
	///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	
	/// Zech 03/06/2012 ORG-3527-S2 IMPROVE_COLUMN_FILTER_ON_SUPPORTING_DIFFERENT_FILTER_TYPES
	///// Zech 01/09/2012 ORG-3527 ADD_COLUMN_FILTER_QUERY
	///**#
		//This Function filters away the rows which does not match to the condition. The filters in
		//the same Worksheet will effect each other.
		//Example1:
			//// The rows with the value NOT (less than 3 and larger than 1) in the first column will be filtered away, after\
			//running wks.Runfilter.
			//void Test()
			//{
				//Worksheet wks = Project.ActiveLayer();
				//Column col(wks, 0);
				//col.Filter("_THISCOL < 3 AND _THISCOL > 1");
			//}
		//Parameters:
			//lpcszQuery		=	[input] Query string, using NULL to reset the filter of this column. 
			//
				//
								//A query string should be:
				//
								//Syntax:
								//Condition0 (AND/OR Condition1 AND/OR Condition2 ...)
								//
								//Condition should be:
								//_THISCOL Symbol Value
								//
								//Symbols for One Condition:
								//"==", "!=", "<", ">", "<=", ">=", "LIKE", "NOT LIKE"
								//
								//Symbols for Combining Conditions:
								//"AND" , "&&", "OR", "||"
								//
								//Special Keywords:
								//"_THISCOL" 				default keyword for lpcszThisName,
														//means the element in this column.
								//"LIKE" / "NOT LIKE"		using wildcard to search string, e.g., "_THISCOL LIKE \"*Data*\"".
			//lpcszThisName	=	[input] The keyword stans for the eement in this column. 
										//Using keyword "_THISCOL" when it is NULL.
			//nRowBegin		=	[input] The begin of rows which need to be query.
			//nRowEnd			=	[input] The end of rows which need to be query.
		//Return:
			//Returns TRUE if Query string is parsed correctly.
	//*/
	//BOOL		Filter(LPCSTR lpcszQuery, LPCSTR lpcszThisName = NULL);
	///// END ADD_COLUMN_FILTER_QUERY
	//
	///// Zech 02/21/2012 ORG-5111 ADD_TOP_N_FILTER_INTERFACE
	///**#
		//This Function filters out the top N items or top N percent of items in the column. When using this
		//setting, the setting of Filter would not be used.
		//Example1:
			//// The top 10 items in this column would be filter out after running wks.Runfilter();
			//void Test()
			//{
				//Worksheet wks = Project.ActiveLayer();
				//Column col(wks, 0);
				//col.TopNFilter(10, false);
			//}
		//Parameters:
			//num			=	[input] The number to be filtered out
			//bPercent	=	[input] Means whether using percentage or the count of itmes
		//Return.
			//Return FALSE if input is invalid
	//*/
	//BOOL		TopNFilter(double num, BOOL bPercentage);
	//
	///**#
		//This Function filters out the bottom N items or bottom N percent of items in the column. When using this
		//setting, the setting of Filter would not be used.
		//Example1:
			//// The bottom 10 items in this column would be filter out after running wks.Runfilter();
			//void Test()
			//{
				//Worksheet wks = Project.ActiveLayer();
				//Column col(wks, 0);
				//col.BottomNFilter(10, false);
			//}
		//Parameters:
			//num			=	[input] The number to be filtered out
			//bPercent	=	[input] Means whether using percentage or the count of itmes
		//Return.
			//Return FALSE if input is invalid
	//*/
	//BOOL		BottomNFilter(double num, BOOL bPercentage);
	///// END ADD_TOP_N_FILTER_INTERFACE
	/// Zech 05/16/2012 ORG-5524-P1 COLUMN_FILTER_SUPPORT_UNDO
	//BOOL	SetFilter(int nType, LPVOID data);
	BOOL	SetFilter(int nType, LPVOID data, BOOL bUndo = FALSE);
	/// END COLUMN_FILTER_SUPPORT_UNDOE
	BOOL	GetFilter(int &nType, const LPVOID* data);
	void	ResetFilter(BOOL bDelete);
	/// END IMPROVE_COLUMN_FILTER_ON_SUPPORTING_DIFFERENT_FILTER_TYPES
	
	/// Zech 03/28/2012 ORG-5375-S2 ADD_OC_INTERFACE_TO_GET_DISTINCT_VALUES
	/**$
		Return value as COLDISTINCTVALUE
	*/
	int		GetDistinctValues(vector<string> &vsValuse, vector<uint>* pvCounts = NULL, BOOL bOnlyGetShownValues = FALSE);
	/// END ADD_OC_INTERFACE_TO_GET_DISTINCT_VALUES

	///------ Folger 05/11/2012 ORG-5668-S2 COLUMN_FILTER_SPECIFY_THISCOL
	/**$
	*/
	void	SetFilterThisCol(LPCSTR lpcsz);

	/**$
	*/
	LPCSTR	GetFilterThisCol();
	///------ End COLUMN_FILTER_SPECIFY_THISCOL
	
	/// Zech 05/14/2012 ORG-5668-S1 OC_METHOD_GET_COMMAND_STRING_FOR_CHECK_LIST_COLUMN_FILTER
	/**$
	*/
	BOOL 	GetFilterQueryString(string &strQuery, LPCSTR lpcszThisCol = NULL);
	BOOL	GetFilterQueryString(string &strQuery, int nType, LPVOID data, LPCSTR lpcszThisCol = NULL);
	/// END OC_METHOD_GET_COMMAND_STRING_FOR_CHECK_LIST_COLUMN_FILTER
	
	/// Zech 05/30/2012 ORG-5819-S1 IMPROVE_METHODS_TO_GET_COLUMN_FILTER_FORMAT
	/**$
	*/
	int		GetFilterFormat();
	/// END IMPROVE_METHODS_TO_GET_COLUMN_FILTER_FORMAT

	/// Zech 06/08/2012 ORG-5154-P6 ADD_OC_METHOD_TO_ENABLE_DISABLE_FILTER
	/**$
	*/
	BOOL	IsFilterDisabled();

	/**$
	*/
	void	DisableFilter(BOOL bDisable);
	/// END ADD_OC_METHOD_TO_ENABLE_DISABLE_FILTER
	
	/// Zech 07/12/2012 ORG-6205-P1 BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
	BOOL	GetFilterQueryInfo(string* pstrQuery, string* pstrPrescript, int nType, LPVOID data, LPCSTR lpcszThisCol = NULL);
	/// END BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
	
};	// END OF class Column : public DataObject


// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=Category:DatasetObject_(class)
*/
class DatasetObject : public OriginObject
{
public:
	///Comments last updated by Joseph on 12/23/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DatasetObject-DatasetObject
	*/
	DatasetObject();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DatasetObject-DatasetObject
	*/
	DatasetObject(LPCSTR lpcszName);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DatasetObject-DatasetObject
	*/
	DatasetObject(OriginObject &obj);

	// Last Update : 2007.4.21 Cheney
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DatasetObject-PercentText
	*/
	/// ML CPY 6/12/07 QA70-9908 PERCENT_TEXT_NEED_MORE_OPTIONS
	///// Hong 05/28/07 v8.0628 OPTION_FOR_MISSING_VALUE_WHEN_PERCENT_TEXT
	////int PercentText();
	//int PercentText(BOOL bSkipMissingValue = TRUE);
	///// end OPTION_FOR_MISSING_VALUE_WHEN_PERCENT_TEXT
	int PercentText(DWORD dwCntrl = PT_SKIP_MISSING, int i1 = 0, int i2 = -1);
	/// end PERCENT_TEXT_NEED_MORE_OPTIONS
	/// Hong 03/08/08 v8.0820 OC_SUPPORT_CELL_GET_SET_DATE_FORMAT_FOR_EXCEL_IMPORT
	/**#
	Remarks:		
	Example1:		
	Parameters:	
		i1 = [input] row index to start the procedure
		i2 = [input] row index(exclusive) to end the procedure, -1 if to go to the end
	Return:		
	*/
	bool SetFormat(int nFormat, int nSubFormat = -1, int i1 = 0, int i2 = -1);
	/**#
	Remarks:		
	Example1:		
	Parameters:		
		i1 = [input] row index to start the procedure
		i2 = [input] row index(exclusive) to end the procedure, -1 if to go to the end
	Return:		
	*/
	int GetFormat(int nIndex = 0);
	/// end OC_SUPPORT_CELL_GET_SET_DATE_FORMAT_FOR_EXCEL_IMPORT
	
	/// YuI 01/26/09 QA70-13023 MATRIX_FIT_IN_IMAGE_FORM_PROBLEMS
	/**#
	Remarks:		
		Finds the minimum and maximum value of the DatasetObject
	Example1:		
	Parameters:		
	Return:		
		TRUE if succesfull, FALSE otherwise
	*/
	BOOL	GetMinMax(double& dMin, double& dMax);
	/// end MATRIX_FIT_IN_IMAGE_FORM_PROBLEMS

	/// EJP 2009-10-15 QA81-14476 OC_DATASETOBJ_GETSET_MASK
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DatasetObject-GetMask
	*/
	int GetMask(vector<byte>& vMask);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DatasetObject-SetMask
	*/
	///---Sim 11-04-2009 QA81-14476-P3 SUPPORT_SET_RANGE_FOR_OC_SET_MASK
	//int SetMask(vector<byte>& vMask, bool bReplace = false);
	int SetMask(vector<byte>& vMask, bool bReplace = false, bool bUndo = false, int r1 = 0, int r2 = -1);
	///---END QA81-14476-P3 SUPPORT_SET_RANGE_FOR_OC_SET_MASK

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DatasetObject-SetMask
	*/
	///---Sim 11-04-2009 QA81-14476-P3 SUPPORT_SET_RANGE_FOR_OC_SET_MASK
	//int SetMask(int nBegin, int nEnd, bool bReplace = false);
	int SetMask(int nBegin, int nEnd, bool bReplace = false, bool bUndo = false);
	///---END QA81-14476-P3 SUPPORT_SET_RANGE_FOR_OC_SET_MASK
	/// end OC_DATASETOBJ_GETSET_MASK
	//---- EJP 2009-10-19 QA81-14498 OC_DATASETOBJ_GETMISSING
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DatasetObject-GetNANUMRows
	*/
	int GetNANUMRows(vector<uint>& vnRows, bool bSkipText=false, bool bSkipBlank=false, int i1 = 0, int i2 = -1);
	//---- end OC_DATASETOBJ_GETMISSING

	///------ Folger 08/18/2011 ORG-3247-S1 OC_ACCESS_ABOUT_LOOSE_DATASET_LABELS
	BOOL	SetLabel(LPCSTR lpcszLabel, int nType, BOOL bX);
	BOOL	GetLabel(string& strLabel, int nType, BOOL bX);
	///------ End OC_ACCESS_ABOUT_LOOSE_DATASET_LABELS
};

///------ Folger 08/18/2011 ORG-3537 OC_NAMED_RANGE_SUPPORT
#ifdef	NEW_NAMED_RANGE_FEATURE
class NamedRange : public DatasetObject
{
public:
	NamedRange();

	string		GetLongName();
};
#endif	/// NEW_NAMED_RANGE_FEATURE
///------ End OC_NAMED_RANGE_SUPPORT


// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=Category:MatrixObject_(class)
*/
class MatrixObject : public DataObject
{
public:
// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-MatrixObject
*/
	MatrixObject(); // Default constructor


// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-MatrixObject
*/
	MatrixObject(MatrixLayer & mLayer, UINT nObjectIndex); // Construct a MatrixObject from an existing MatrixLayer

// Comment last updated by Joseph 07/26/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-MatrixObject
*/
	MatrixObject(LPCTSTR MatrixName, UINT nObjectIndex); // Construct a MatrixObject based on a string	

// Comment last updated by Joseph 07/26/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-MatrixObject
*/
	MatrixObject(DataObject& OriginalObj);	// Copy constructor -- refers to the same internal object as colOriginal

///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-MatrixObject
*/
	MatrixObject(LPCSTR lpcszDatasetName);


// Last Update : 2006.6.9 Cheney
/**#
	Remarks:
		It initializes the MatrixObject from the MatrixLayer and Index of one of the MatrixLayer. 
		The dataset must be attached to a matrix, or this initialization will produce invalid MatrixObject.
	Keywords:
		attach
	Example1:
		void MatrixObject_Attach_Ex1()
		{
			MatrixPage mp = Project.MatrixPages(0);
			if(!mp)
				return;
			
			MatrixLayer  ml(mp.GetName());	
			MatrixObject mObj;
			mObj.Attach(ml,0);
		}
	Parameters:
		mlayer = [input] matrix layer attaches to. 
		nObjectIndex = [input] Index of one of the matrix layers in the MatrixLayer 
	Return:
		TRUE on success and FALSE on failure.
	SeeAlso:
		Datasheet::Attach, Column::Attach
 */
	BOOL		Attach(MatrixLayer &mlayer, UINT nObjectIndex);    

// Last Update : 2006.6.9 Cheney
/**#
	Remarks:
		It initializes the MatrixObject from the MatrixLayer' name and Index of one of the MatrixLayer.
		The dataset must be attached to a matrix, or this initialization will produce invalid MatrixObject.
	Keywords:
		attach
	Example1:
		void MatrixObject_Attach_Ex2()
		{
			MatrixPage mp = Project.MatrixPages(0);
			if(!mp)
				return;
			
			MatrixObject mObj;
			mObj.Attach(mp.GetName(), 0);
		}
	Parameters:
		MatrixName = [input] name of the MatrixLayer. 
		nObjectIndex = [input] Index of one of the matrix layers in the MatrixLayer 
	Return:
		TRUE on success and FALSE on failure.
	SeeAlso:
		Datasheet::Attach, Column::Attach
 */
	BOOL		Attach(LPCTSTR MatrixName, UINT nObjectIndex);  

//Comment last updated by Joseph 2007.07.26
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-Attach
*/
	BOOL		Attach(LPCSTR lpcszDatasetName);


	/// YuI 12/14/09 QA70-13806 VIRTUAL_MATRIX_IMPLEMENTATION
	#ifdef __VIRTUAL_MATRIX__
	///------ Folger 08/18/10 ORG-815 VIRTUAL_MATRIX_TRANSPOSE_STATUS_WRONG
	//BOOL		Attach(Worksheet& wks, LPCSTR lpcszName);
	//BOOL		Attach(DataRange& rg);
	/**$
	*/
	BOOL		Attach(Worksheet& wks, LPCSTR lpcszName, DWORD dwCntrl = 0);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-Attach
	*/
	BOOL		Attach(DataRange& rg, DWORD dwCntrl = 0);
	///------ End VIRTUAL_MATRIX_TRANSPOSE_STATUS_WRONG
	/**$
	*/
	BOOL		GetAxesLongName(string& strX, string& strY);
	/**$
	*/
	BOOL		SetAxesLongName(LPCSTR lpcszX, LPCSTR lpcszY);
	#endif // __VIRTUAL_MATRIX__	
	/// end VIRTUAL_MATRIX_IMPLEMENTATION
// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetFormat
*/
	BOOL		SetFormat(int nFormat);  // only supports OKCOLTYPE_NUMERIC                        

///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetFormat
*/
	int			GetFormat(); // Gets the data format of the matrix

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetDigitMode
*/
	int			GetDigitMode(); // Gets the digit mode of the matrix


// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetDigitMode
*/
	BOOL		SetDigitMode(int nDigitMode); // Sets the digit mode of the matrix

///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetDigits
*/
	int	GetDigits(); // Gets the number of digits of a particular digit mode of the matrix

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetDigits
*/
	BOOL	SetDigits(int nDigits); // Sets the number of digits of a particular digit mode of the matrix.

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetColumnWidth
*/
	int	GetColumnWidth(); // Gets the width of a matrix column

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetColumnWidth
*/
	BOOL	SetColumnWidth(int nColWidth); // Sets the width of a matrix column.


// Last Updated 2003.03.23 GRD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetInternalData
*/
	BOOL	SetInternalData(UINT iType, BOOL bSaveData = TRUE, BOOL bSetViewData = TRUE); // Set the Matrix internal data storage type


// Last Updated 2005.03.23 GRD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetInternalData
*/
	int	GetInternalData(); // Get internal data type


// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetNumRows
*/
	int			GetNumRows(); // Gets the number of rows in a matrix

///Comments last updated by Joseph on 12/23/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetNumCols
*/
	int			GetNumCols(); // Gets the number of columns in a matrix


// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetDataObject
*/
	matrixbase&  GetDataObject();

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetImageMask
*/
	BOOL	GetImageMask(matrix<byte>& mMask);


//Comment last updated by Joseph 07/26/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetImageMask
*/
	BOOL	SetImageMask(matrix<byte>& mMask);

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetRegionPoints
*/
	int GetRegionPoints(const vector& vRegionX, const vector& vRegionY, vectorbase& vZ, vector<int>& vI = NULL, vector<int>& vJ = NULL);

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetXY
*/
	///------ Folger 10/15/09 QA81-13904-P3 SET_MATRIX_XY_COORDINATES_FAILS_TO_UNDO
	//BOOL SetXY(double dXMin, double dYMin, double dXMax, double dYMax); // Set matrix object xy mapping coordinates
	BOOL SetXY(double dXMin, double dYMin, double dXMax, double dYMax, BOOL bUndo = FALSE); // Set matrix object xy mapping coordinates
	///------ End SET_MATRIX_XY_COORDINATES_FAILS_TO_UNDO

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetXY
*/
	/// TD ML 07-13-2010 ORG-519_P2 VIRTUAL_MATRIX_OC_INTERFACE
	//void GetXY(double& dXMin, double& dYMin, double& dXMax, double& dYMax); // Get matrix object xy mapping coordinates
	BOOL GetXY(double& dXMin, double& dYMin, double& dXMax, double& dYMax); // Get matrix object xy mapping coordinates
	BOOL GetXY(vector &vXScale, vector& vYScale = NULL); // Get virtual matrix xy mapping scales
	/// end VIRTUAL_MATRIX_OC_INTERFACE

// Last Update : 2006.6.9 Cheney	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetNumCols
*/
	BOOL	SetNumCols(uint nCols);

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetNumRows
*/
	BOOL	SetNumRows(uint nRows);

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetSize
*/
	BOOL SetSize(uint nNumRows, uint nNumCols, DWORD dwCntrl = OCD_RESTORE | OCD_INITDATA);

//Comment last updated by Joseph 07/26/07
/// EJP 2005-07-13 v8.0268 QA70-7881 OC_MATRIX_OBJECT_IMAGE_ACCESS
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetDIB
*/
	/// EJP 2007-07-27 v8.0670 QA70-10123 OC_GETDIB_CRASH
	///HDIB GetDIB(LPCSTR lpcszName = NULL);
	HDIB GetDIB(LPCSTR lpcszName = NULL, BOOL bCvtDataIfNoImage = TRUE);
	/// end OC_GETDIB_CRASH

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetDIB
*/
	BOOL SetDIB(HDIB hDIB, LPCSTR lpcszName = NULL, BOOL bCheckDim = FALSE);
	
///------ Folger 02/03/09 QA80-13032 SUPPORT_COPY_LAYER_SCALE_FOR_COPY_IMAGE_DATA
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-HasImage
*/
	BOOL HasImage();
///------ End SUPPORT_COPY_LAYER_SCALE_FOR_COPY_IMAGE_DATA

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-HasData
*/
	/// EJP 2006-03-29 v8.0382 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
	///BOOL HasData();
	BOOL HasData(BOOL bIncludeGrayScale = TRUE);
	/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE
/// end OC_MATRIX_OBJECT_IMAGE_ACCESS

///Comments last updated by Joseph on 12/23/2006
/// EJP 2005-10-31 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetLeadBitmap
*/
	LPVOID GetLeadBitmap(); // not copy, access internal

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetLeadBitmap
*/
/// YuI 06/08/09 QA70-13748_P1 IMAGE_CROP_CORRUPTS_DATA_MODE
//	BOOL SetLeadBitmap(LPVOID pLBmp, BOOL bMakeCopy = true, BOOL bResetZoom = false);
BOOL SetLeadBitmap(LPVOID pLBmp, BOOL bMakeCopy = true, BOOL bResetZoom = false, DWORD dwCtrl = 0);
/// end IMAGE_CROP_CORRUPTS_DATA_MODE
/// end LEAD_BITMAP_GR_OBJ

/// Hong 07/19/07 QA80-10080 v8.0663 ACCESS_MATRIXOBJECT_VIEW_MODE_FROM_OC
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-IsImageView
*/
	BOOL IsImageView();
/// end ACCESS_MATRIXOBJECT_VIEW_MODE_FROM_OC


	/// EJP 2008-04-08 v8.0840 QA80-11237 MAP_ROI_MATRIX_RECT_TO_IMAGE_RECT
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-CopyToClipboard
	*/
	BOOL CopyToClipboard(RECT* pRect);
	/// end MAP_ROI_MATRIX_RECT_TO_IMAGE_RECT

	/// TD 01-22-2009 QA80-12333_S2 EXPOSE_AND_USE_CopyMatrixObj_FROM_OC 
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-CopyToMatrix
	*/
	BOOL CopyToMatrix(MatrixObject &mo, RECT* pRect, BOOL bUndo = FALSE);
	/// end EXPOSE_AND_USE_CopyMatrixObj_FROM_OC

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetLabel
	*/
	int		GetLabel(string &strLabel); // Get the matrix object label by reference

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetLabel
	*/
	string	GetLabel(); // Get the matrix object labels

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetLabel
	*/
	BOOL 	SetLabel(LPCSTR lpcstrLabel); // Set the matrix object label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetExtendedLabel
	*/
	BOOL	SetExtendedLabel(LPCSTR lpcszLabel, int nn, BOOL bByType = TRUE); // Sets the extended label by type of extended label.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetExtendedLabel
	*/
	BOOL	GetExtendedLabel(string &str, int nn, BOOL bByType = TRUE); // Gets the extended label by type of extended label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetLongName
	*/
	string	GetLongName(); // Get the long name of a matrix object

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetLongName
	*/
	BOOL	SetLongName(LPCSTR lpcszLongName); // Sets the long name of a column

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetComments
	*/
	string	GetComments(); // Get the comments in a matrix object label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetComments
	*/
	BOOL	SetComments(LPCSTR lpcszComments, BOOL bUndo = FALSE); // Sets the comments in a matrix object label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetUnits
	*/	
	string	GetUnits(); // Get the units in a matrix object label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetUnits
	*/	
	BOOL	SetUnits(LPCSTR lpcszUnits); // Set the units in a matrix object label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetParameters
	*/
	BOOL	SetParameters(const vector<string> &vstr); // Sets the Parameters in a matrix object label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetParameters
	*/
	BOOL	GetParameters(vector<string> &vstr); // Gets the Parameters in a matrix object label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-SetParameter
	*/
	BOOL	SetParameter(LPCTSTR lpcszParam, int index = 0); // Sets one parameter in a matrix object label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetParameter
	*/
	BOOL	GetParameter(string &str, int index = 0); // Get one parameter value.from matrix object label

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixObject-GetName
	*/
	int 	GetName(string &strName); // Get the matrix object short name.

	///Kyle 07/26/2010 ORG-234-P5 APPLY_PALETTE_TO_MTRIX_OBJECT_IMAGE
	BOOL	HasPalette();
	
	/**#
		This function apply the palette to the matrix object
	Parameters:
		lpcszPal = [input]full path palette file name
		dwCntrl = [input]control bits, see MATOBJPALETTE
		bUndo = [input]
	Return:
		Returns MOPALERROR_NO_ERROR on successful and a non-zero error code on failure, see MATOBJPALERROR
	*/
	///Kyle 11/30/2010 ORG-1591-P2 OC_APPLY_PALETTE_SUPPORT_UNDO
	//int			ApplyPalette(LPCSTR lpcszPal, DWORD dwCntrl = MOPAL_USE_ORIGINAL);
	int			ApplyPalette(LPCSTR lpcszPal, DWORD dwCntrl = MOPAL_USE_ORIGINAL, BOOL bUndo = FALSE);
	///End OC_APPLY_PALETTE_SUPPORT_UNDO
	///End APPLY_PALETTE_TO_MTRIX_OBJECT_IMAGE

	///Kyle 08/05/2010 ORG-723-P1 STRETCH_AND_REVERSE_ORDER_PALETTE_OPTION_IN_COLORMAP
	/**#
		get colormap palette info
	Return:
		Returns 0 on successful or a negative number on failure if image matrix or there is no colormap.
	*/
	int			GetPaletteInfo(string& strPal, DWORD& dwCntrl);
	///End STRETCH_AND_REVERSE_ORDER_PALETTE_OPTION_IN_COLORMAP

	///Sophy 7/26/2010 ORG-427-P3 AUTO_CHECK_INIT_VIRTUAL_SERIES_NAME
	/**$
		This function only used internally to check update virtual series's short name, return TRUE if not changed, return FALSE if auto renamed.
	*/
	#ifdef __VIRTUAL_MATRIX__
	BOOL		CheckUpdateVSName(string& strName);
	#endif	//__VIRTUAL_MATRIX__
	///end AUTO_CHECK_INIT_VIRTUAL_SERIES_NAME
	
};	// END OF class MatrixObject : public DataObject


// Origin internal functions
// all function prototypes from here on must be implemented from within the Origin OK DLL

#pragma dll(@OK)
// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSPCMainHeader_(global_function)
*/
	BOOL	GetSPCMainHeader(LPCSTR lpcszWksName, int nCol, OSPCMAINHeader *SPCMainHeader);

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSPCSubHeader_(global_function)
*/
	BOOL	GetSPCSubHeader(LPCSTR lpcszWksName, int nCol, OSPCSUBHeader *SPCSubHeader, int nIndex);

// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSPCLog_(global_function)
*/
	string	GetSPCLog(LPCSTR lpcszWksName, int nCol);	// Get SPC log information from worksheet

#endif //!_WKSHEET_H
