/*------------------------------------------------------------------------------*
 * File Name: time.h															*
 * Creation: AW 10/21/2003														*
 * Purpose: Origin C header	for basic io functions								*
 * Copyright (c) OriginLab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 11/21/2011 ORG-4423-P1 TIMIE_T_SHOULD_BE_64_BIT_SINCE_86				*
 *	Folger 11/21/2011 ORG-4423-P2 USE_SAME_C_RUNTIME_IN_BOTH_OC_AND_VC			*
 *------------------------------------------------------------------------------*/

#ifndef _TIME_H
#define _TIME_H   

///------ Folger 11/21/2011 ORG-4423-P1 TIMIE_T_SHOULD_BE_64_BIT_SINCE_86
#if		_OC_VER >= 0x0900
typedef __int64 time_t;
#else	/// _OC_VER >= 0x0900
///------ End TIMIE_T_SHOULD_BE_64_BIT_SINCE_86 
typedef long time_t; 
///------ Folger 11/21/2011 ORG-4423-P1 TIMIE_T_SHOULD_BE_64_BIT_SINCE_86
#endif	/// _OC_VER >= 0x0900
///------ End TIMIE_T_SHOULD_BE_64_BIT_SINCE_86
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tm
*/
typedef struct {
        int tm_sec;     /* seconds after the minute - [0,59] */
        int tm_min;     /* minutes after the hour - [0,59] */
        int tm_hour;    /* hours since midnight - [0,23] */
        int tm_mday;    /* day of the month - [1,31] */
        int tm_mon;     /* months since January - [0,11] */
        int tm_year;    /* years since 1900 */
        int tm_wday;    /* days since Sunday - [0,6] */
        int tm_yday;    /* days since January 1 - [0,365] */
        int tm_isdst;   /* daylight savings time flag */
        }tm, TM;

extern int _daylight;

extern long _timezone;

extern char *_tzname[2];



// basic time functions

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:gmtime_(global_function)
*/
TM* gmtime( const time_t *timer );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:localtime_(global_function)
*/
TM* localtime( const time_t *timer );


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:gettimeSetting_(global_function)
*/
void gettimeSetting();  


#pragma dll(msvcrt, system)


///------ Folger 11/21/2011 ORG-4423-P2 USE_SAME_C_RUNTIME_IN_BOTH_OC_AND_VC
/// Since vs2010 using new C Runtime which will have time, difftime or mktime function inline, so we will
/// not be able to GetProcAddress of them in VC, that will lead to linking error. So better we not
/// allow OC to use them directly but from OUTL.
// /**+
// http://ocwiki.originlab.com/index.php?title=OriginC:time_(global_function)
// */
// time_t time( time_t *timer );
// 
// 
// /**+
// http://ocwiki.originlab.com/index.php?title=OriginC:difftime_(global_function)
// */
// double difftime( time_t timer1, time_t timer0 ); 
// 
// 
// /**+
// http://ocwiki.originlab.com/index.php?title=OriginC:mktime_(global_function)
// */
// time_t mktime( TM *timeptr );
///------ End USE_SAME_C_RUNTIME_IN_BOTH_OC_AND_VC



/**+
http://ocwiki.originlab.com/index.php?title=OriginC:_tzset_(global_function)
*/
void _tzset( void );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:asctime_(global_function)
*/
char* asctime( TM *timeptr );


#pragma dll(@OUTL)

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tm_to_systemtime_(global_function)
*/
void tm_to_systemtime(TM* pTM, SYSTEMTIME * pSysTime);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:systemtime_to_tm_(global_function)
*/
void systemtime_to_tm(TM* pTM, SYSTEMTIME * pSysTime);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_time_to_tm_(global_function)
*/
void convert_time_to_tm(time_t* pTime, TM* pTM);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_time_to_local_(global_function)
*/
void convert_time_to_local(time_t* pTime, TM* pLocalTM);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_time_setting_(global_function)
*/
void get_time_setting(int* pdaylight, long* ptimezone, char* tzname[2]);

///------ Folger 11/21/2011 ORG-4423-P2 USE_SAME_C_RUNTIME_IN_BOTH_OC_AND_VC
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:time_(global_function)
*/
time_t time( time_t *timer );


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:difftime_(global_function)
*/
double difftime( time_t timer1, time_t timer0 ); 


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:mktime_(global_function)
*/
time_t mktime( TM *timeptr );
///------ End USE_SAME_C_RUNTIME_IN_BOTH_OC_AND_VC

#endif //_TIME_H
