/*------------------------------------------------------------------------------*
 * File Name: string.h															*
 * Creation: CPY 4/2/2001														*
 * Purpose: Origin C header	for string class and other related functions		*
 * Copyright (c) OriginLab Corp.2001											*
 * All Rights Reserved															*
 *	Kenny 01/28/2012 ORG-4752-S1 CODE_BUILDER_SUPPORT_BREAKPOINT_MANAGEMENT		*
 *	Folger 04/24/2012 ORG-5547-P1 OC_STRING_FIND_REPLACE_SUPPORT_CASE_INSENSITIVE
 *------------------------------------------------------------------------------*/

#ifndef _STRING_H
#define _STRING_H

#include <common.h> // must always include this
#include <OC_const.h> // consts used in Origin internal functions


//Comments last updated by Sophy on 6/24/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:StringArray
*/
typedef vector<string> StringArray;

// Comments last updated by Frank on 08/09/05
/**+
http://ocwiki.originlab.com/index.php?title=Category:string_(class)
*/
class string  
{

public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-string
	*/
	string( );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-string
	*/
	string( LPCSTR lpcszSrc );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-string
	*/
	string( char ch, int nRepeat = 1 );	
		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-string
	*/
	string( LPCTSTR lpch, int nLength );

#ifdef	ORIGIN_COM_SUPPORT
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-string
	*/
	string( _VARIANT var );
	
#endif //#ifdef	ORIGIN_COM_SUPPORT

#if  _OC_VER > 0x0703
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-SetBytes
	*/
 	BOOL     SetBytes(vector<byte>& vb);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-GetBytes
	*/
 	BOOL     GetBytes(vector<byte>& vb);
#endif // _OC_VER > 0x0703
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Write
	*/
	void	Write( int iDestination );// 0 = ScriptWindow
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-WriteLine
	*/
	void	WriteLine( int iDestination );// will add \r\n automatically

	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Format
	*/
	void	Format( LPCSTR lpcszFormat, ... );
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-GetLength
	*/
	int		GetLength( );		

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-TrimLeft
	*/
	void	TrimLeft( );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-TrimLeft
	*/
	void	TrimLeft( char chTarget );
	
// Comments last updated by Joe on 06/27/2006	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-TrimLeft
	*/
	void	TrimLeft( LPCSTR lpszTargets );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-TrimRight
	*/
	void	TrimRight( );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-TrimRight
	*/
	void    TrimRight( char chTarget );

// Comments last updated by Joe on 06/27/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-TrimRight
	*/
	void	TrimRight( LPCSTR lpszTargets );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Left
	*/
	string  Left( int nCount );	
		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Right
	*/
	string  Right( int nCount );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Compare
	*/
	int		Compare( LPCSTR lpsz );	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-CompareNoCase
	*/
	int		CompareNoCase( LPCSTR lpsz );
	
	///------ Folger 04/24/2012 ORG-5547-P1 OC_STRING_FIND_REPLACE_SUPPORT_CASE_INSENSITIVE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Find
	*/
	//int		Find( char ch );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Find
	*/
	//int		Find( LPCSTR lpszSub );
	///------ End OC_STRING_FIND_REPLACE_SUPPORT_CASE_INSENSITIVE
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Find
	*/
	///------ Folger 04/24/2012 ORG-5547-P1 OC_STRING_FIND_REPLACE_SUPPORT_CASE_INSENSITIVE
	//int		Find( char ch, int nStart );
	int		Find( char ch, int nStart = 0 );
	///------ End OC_STRING_FIND_REPLACE_SUPPORT_CASE_INSENSITIVE
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Find
	*/
	///------ Folger 04/24/2012 ORG-5547-P1 OC_STRING_FIND_REPLACE_SUPPORT_CASE_INSENSITIVE
	//int		Find( LPCSTR lpszSub, int nStart );
	int		Find(LPCSTR lpcszSub, int nStart = 0, BOOL bCaseSensitive = TRUE);
	///------ End OC_STRING_FIND_REPLACE_SUPPORT_CASE_INSENSITIVE
		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-ReverseFind
	*/
	int		ReverseFind( char ch );	

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Insert
	*/
	int		Insert( int nIndex, char ch );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Insert
	*/
	int		Insert( int nIndex, LPCTSTR pstr );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Delete
	*/
	int     Delete( int nIndex, int nCount = 1 );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-MakeLower
	*/
	void	MakeLower( );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-MakeUpper
	*/
	void	MakeUpper( );
		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Mid
	*/
	string  Mid( int nFirst, int nCount );
	
	// last update by Sim 04-14-2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Mid
	*/
	string  Mid( int nFirst );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-GetAt
	*/
	char	GetAt( int nIndex ); 

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-SetAt
	*/
	void	SetAt( int nIndex, char ch );
		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-GetToken
	*/
	string	GetToken( int nToken, char chDelimiter = 0 );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-GetNumTokens
	*/
	int		GetNumTokens( char chDelimiter = 0 );

	// Comments last updated by Hong on 04/04/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-GetTokens
	*/
	int		GetTokens( StringArray& saTokens, char chDelimiter = 0 );
	
#if _OC_VER >= 0x0800
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-GetTokens
	*/
	int		GetTokens( vector &vTokens, char chDelimiter = 0 );

	// last update by Sim 04-14-2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Count
	*/
	int		Count(int cChar);
#endif

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-SetTokens
	*/
	int SetTokens(StringArray& saTokens, char chDelimiter = '\t');

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-FindToken
	*/
	int FindToken(LPCSTR lpcszToken, char chDelimiter = 0);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Empty
	*/
	void	Empty( );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-IsEmpty
	*/
	BOOL	IsEmpty( ); 

	// last update by Sim 04-14-2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-SpanIncluding
	*/
	string	SpanIncluding( LPCSTR lpszCharSet );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-SpanExcluding
	*/
	string	SpanExcluding( LPCSTR lpszCharSet );

	/// last update by Sim 04-14-2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Replace
	*/
	int		Replace( char chOld, char chNew );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Replace
	*/
	///------ Folger 04/24/2012 ORG-5547-P1 OC_STRING_FIND_REPLACE_SUPPORT_CASE_INSENSITIVE
	//int		Replace( LPCSTR lpszOld, LPCSTR lpszNew );
	int		Replace( LPCSTR lpszOld, LPCSTR lpszNew, BOOL bCaseSensitive = TRUE );
	///------ End OC_STRING_FIND_REPLACE_SUPPORT_CASE_INSENSITIVE
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Replace
	*/
	int		Replace( LPCSTR lpszOneOf, char chNew );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Remove
	*/
	int		Remove( char ch );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-FindOneOf
	*/
	int		FindOneOf( LPCSTR lpszCharSet );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-GetBuffer
	*/
	char*	GetBuffer( int nMinBufLength );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-GetBufferSetLength
	*/
	char*	GetBufferSetLength( int nNewLength );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-ReleaseBuffer
	*/
	void	ReleaseBuffer( int nNewLength = -1 );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-Match
	*/
	BOOL Match( LPCSTR strPattern, BOOL bCaseSensitive = FALSE );

	// last update by Sim 04-14-2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-IsPath
	*/
	BOOL	IsPath( ); 
	
	// last update by Sim 04-14-2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-IsFile
	*/
	BOOL	IsFile( );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:string-MakeValidCName
	*/
	void MakeValidCName(char cPrefixIf1stCharNumber=0);
};

/// Kenny 01/28/2012 ORG-4752-S1 CODE_BUILDER_SUPPORT_BREAKPOINT_MANAGEMENT
// These functions are used in OC debugger for trace point
#pragma labtalk(0)

string ToString(int val);

string ToString(bool val);

string ToString(double val);

string ToString(const string& val);

string ToString(LPCTSTR val);

string ToString(void* val);

string ToString(const OriginObject& val);
/// End CODE_BUILDER_SUPPORT_BREAKPOINT_MANAGEMENT


////////////////////////////////////////////////////////////////////
#pragma dll(kernel32, system)

// GJL 11/18/02 v7.0437 ADD_ANSI_C_STRING_FUNCS1
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:lstrcpy_(global_function)
*/
LPSTR WINAPI lstrcpy(LPSTR lpString1, LPCSTR lpString2);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:lstrcat_(global_function)
*/
LPSTR WINAPI lstrcat(LPSTR lpString1, LPCSTR lpString2);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:lstrlen_(global_function)
*/
int	WINAPI lstrlen(LPCSTR lpString);
		
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:lstrcpyn_(global_function)
*/
LPSTR WINAPI lstrcpyn(LPSTR lpString1, LPCSTR lpString2, int iMaxLength);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:lstrcmp_(global_function)
*/
int	WINAPI lstrcmp(LPCSTR lpString1, LPCSTR lpString2);
	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:lstrcmpi_(global_function)
*/
int WINAPI lstrcmpi(LPCSTR lpString1, LPCSTR lpString2);

///Sophy 7/7/2010 ORG-441 ADD_MORE_STANDARD_C_API
/**$
	see http://msdn.microsoft.com/en-us/library/aa383751(VS.85).aspx
*/
typedef HANDLE HLOCAL;
/**$
	see http://msdn.microsoft.com/en-us/library/aa366723(VS.85).aspx
*/
HLOCAL WINAPI LocalAlloc(UINT uFlags, size_t uBytes);
/**$
	see http://msdn.microsoft.com/en-us/library/aa366742(VS.85).aspx
*/
HLOCAL WINAPI LocalReAlloc(HLOCAL hMem, size_t uBytes, UINT uFlags);
/**$
	see http://msdn.microsoft.com/en-us/library/aa366730(VS.85).aspx
*/
HLOCAL WINAPI LocalFree(HLOCAL hMem);
///end ADD_MORE_STANDARD_C_API
////////////////////////////////////////////////////////////////////

#pragma dll(msvcrt, system)

//comment last updated by Joseph 07/30/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strcpy_(global_function)
*/
LPSTR strcpy(LPSTR lpString1, LPCSTR lpString2);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strcat_(global_function)
*/
LPSTR strcat(LPSTR lpString1, LPCSTR lpString2);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strlen_(global_function)
*/
int	strlen(LPCSTR lpString);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strncpy_(global_function)
*/
LPSTR strncpy(LPSTR lpString1, LPCSTR lpString2, int iMaxLength);

// last update by Sim 04-14-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strcmp_(global_function)
*/
int	strcmp(LPCSTR lpString1, LPCSTR lpString2);

// last update by Sim 04-14-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:_stricmp_(global_function)
*/
int _stricmp(LPCSTR lpString1, LPCSTR lpString2);

// last update by Sim 04-14-2007
/**$ >Character and String Manipulation
		The stricmp (alias stricmp) function compares  lowercase versions of two character strings.
	Example1:
		void stricmp_ex1()
		{
			string	str1 = "hello world!";
			int 	cmp = stricmp(str1, "hello world!");	// cmp equals 0.
			out_int("cmp = ", cmp);
		}
	Parameters:
		lpString1=[input] Pointer to the first null-terminated string to be compared. 
		lpString2=[input] Pointer to the second null-terminated string to be compared.
	Return:
		If the string pointed to by lpString1 is less than the string pointed to by lpString2, the return value is negative. 
		If the string pointed to by lpString1 is greater than the string pointed to by lpString2, the return value is positive. 
		If the strings are equal, the return value is zero.
	SeeAlso:
		_stricmp
*/
int stricmp(LPCSTR lpString1, LPCSTR lpString2);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strchr_(global_function)
*/
LPSTR	strchr(LPCSTR lpcszStr, int cc); // Find the first occurrence of a character in a string.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strrchr_(global_function)
*/
LPSTR	strrchr(LPCSTR lpcszStr, int cc); // Scan a string for the last occurrence of a character.

// last update by Sim 04-14-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strncat_(global_function)
*/
LPSTR	strncat( LPSTR lpszDestination, LPCSTR lpcszSource, size_t count ); // Append the first N characters of one string to a second string.

///Sophy 7/7/2010 ORG-441 ADD_MORE_STANDARD_C_API
/**$
	See http://msdn.microsoft.com/en-us/library/bb759969(VS.85).aspx
*/
LPSTR	strdup(LPCSTR lpcszStr);
///end ADD_MORE_STANDARD_C_API

/// Kenny 03/28/2012 ORG-5188-P1 CODE_BUILDER_WATCH_WINDOW_IMPROVEMENT
LPSTR	_strdup(LPCSTR lpcszSrc);
/// End CODE_BUILDER_WATCH_WINDOW_IMPROVEMENT

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strncmp_(global_function)
*/
int 	strncmp( LPCSTR lpcszString1, LPCSTR lpcszString2, size_t count ); // Compare the first N characters of two strings.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strspn_(global_function)
*/
size_t	 strspn( LPCSTR lpcszString, LPCSTR lpcszCharSet ); // Find a prefix substring in a string consisting entirely of characters in a specified character set.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strcspn_(global_function)
*/
size_t	strcspn( LPCSTR lpcszString, LPCSTR lpcszCharSet ); // Find a prefix substring in a string not containing any characters in a specified character set.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strpbrk_(global_function)
*/
LPSTR	strpbrk( LPCSTR lpcszString, LPCSTR lpcszCharSet ); // Scan strings for characters in a specified character set.

// last update by Sim 04-14-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strstr_(global_function)
*/
LPSTR	 strstr( LPCSTR lpcszString, LPCSTR lpcszSubString ); // Find a substring.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strerror_(global_function)
*/
LPSTR	strerror( int iErrNum ); // Get a system error message (strerror) or print a user-supplied error message (_strerror).

// last update by Sim 04-14-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:strtok_(global_function)
*/
LPSTR	strtok( LPCSTR lpszStrToken, LPCSTR lpcszDelimit ); // Find the next token in a string.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:memcpy_(global_function)
*/
LPVOID	memcpy(LPVOID lpDestination, const LPVOID lpSource, UINT uSize); // Copy characters between buffers.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:memset_(global_function)
*/
LPVOID	memset(LPVOID lpMem, int nValue, UINT uSize); // Set buffers to a specified character.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:memcmp_(global_function)
*/
int		memcmp(LPCVOID lpMem1, LPCVOID lpMem2, UINT uSize); // Compares characters between two buffers.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:memmove_(global_function)
*/
LPVOID	memmove( LPVOID dest, LPCVOID src, size_t count ); // Move contents of one buffer to another.

// Comments last updated by Frank on 08/09/05
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:memchr_(global_function)
*/
LPVOID	memchr( LPCVOID buf, int c, size_t count ); // Find a pointer to first occurrence of character.
// End GJL 11/18/02 v7.0437 ADD_ANSI_C_STRING_FUNCS1

// Comments last updated by Frank on 08/09/05
// GJL 11/18/02 v7.0437 ADD_ANSI_C_STRING_FUNCS2
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sscanf_(global_function)
*/
int sscanf( LPCSTR lpcszBuffer, LPCSTR lpcszFormat, ... ); // Read data from a string according to a standard C format specification.

// Comments last updated by Frank on 08/09/05
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sprintf_(global_function)
*/
int sprintf( LPSTR lpszBuffer, LPCSTR lpcszFormat, ... ); // Write data into a string according to a standard C format specification.
// End GJL 11/18/02 v7.0437 ADD_ANSI_C_STRING_FUNCS2

#endif //!_STRING_H
