/*------------------------------------------------------------------------------*
 * File Name: stats_types.h 													*
 * Creation: GJL/SDB 2/16/04													*
 * Purpose: OriginC header file	containing structures for statistics tools.		*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Echo 3/30/04 MODIFY_DOF_TYPE													*
 * Danice 4/5/04 v8.0850 TWO_SAMPLE_TTEST_NEED									*
 * Echo 4/5/04 v8.0850 CHANGE_CHISQVAR2SAMPLERESULT_STRUCTURE					*
 * Echo 4/6/04 v8.0851 ADD_CHISQVAR2SAMPLERESULT_STRUCTURE						*
 * Jean 05/06/04 MODIFY_DEFINE_STRUCTURE										*
 *	CPY 7/17/04 FIT_PARAM_ARRAY_NEED_SIZE										*
 *	Max 9/09/04 MODIFY_FIXINTERCEPT												*
 *	Max 10/13/04 ADD_FOR_KOLMOGOROV_SMIRNOV_TEST								*
 *	Max 03/13/05 ADD_STATISTIC_FOR_MEAN_COMPARISON								*
 *	Echo 3/22/05 v8.0207 QA70-6204 ADD_GSD										*
 *	Kevin 09/01/05 CHANGE_STATISTICS_NAME										*
 *	ML 9/1/2005 PER_DATASET_FITTING_STATISTICS									*
 *  Human 10/14/05 ADD_FOR_OCMATH_SURVIV_WEIBULL_SIMPLE                         *
 *	Kevin 11/10/05 CHANGE_PARAMETER_ORDER										*
 *	Max 11/11/05 ADD_ENUM_FOR_REPEATED_MEASURE_ANOVA							*
 *	Max 11/11/05 ADD_STRUCTURE_FOR_RM_ANOVA										*
 *	Max 11/11/05 ADD_DOF_STATISTIC_FOR_MEAN_COMPARISON							*
 *	Max 11/12/05 CHANGE_ENUM_ORDER_FOR_MEANS_COMPARISON							*
 *	Max 5/18/06 MODIFY_ENUM_INTERPOLATE_MEANING									*
 *	Echo 5/31/06 REORDER_DESC_STATS_RES											*
 *	Echo 8/22/06 USE_STANDARD_NAME												*
 *	Max 9/5/06 ADD_ENUM_FOR_INPUT_DATA_FORM										*
 *	Max 9/13/06 MODIFY_ORDER_OF_INTERPOLATE										*
 *	Cheney 2006-9-19 ADD_PLOT_TYPE_IN_FIT_OPTION								*	
 *	ML 3/1/2007 ADDING_QUANTITIES_FOR_STATS_PER_DATASET							*
 *	Arvin 08/10/07 QA70-10197 ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
 *	Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE										*
 *	Kyle 11/18/2008 QA80-12591 ADD_MORE_OPTION_FOR_INPUT_DATA_TYPE_IN_FITTING_TOOLS
 *	Hong 09/09/09 QA80-14287 FREQUENCY_COUNT_ADD_MIN_MAX_COUNT					*
 *	Kyle 11/10/2010 ORG-1090 IMPROVE_PROTOTYPE_TO_ALLOW_SIZE_CHECKING			*
 *	Folger 06/17/2011 ORG-2097-S1 STANDARD_ERROR_FOR_DERIVED_PARAMS				*
 *------------------------------------------------------------------------------*/

#ifndef _STATS_TYPES_H
#define _STATS_TYPES_H

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///////////////////////  Statistics Definitions and Enums   //////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

#ifndef _MSC_VER	// Not in VC, so must be Origin C
#include "..\Originlab\DataIDs.h" /// AW 04/30/04
	//#define _id(_ID)	 _id(_ID)	//CPY 4/29/04
#else // _MSC_VER
	#define _id(_ID)	 // //CPY 4/29/04
	#define uint UINT
#endif // _MSC_VER

///-------------Iris 4/6/04 Remove from OC stats_utils.h file
///Echo 9/15/04 Set error code as negative to avoid conficting with nag error codes
// Define Stats constants NOT needing localization
#define STATS_NO_ERROR					0
#define STATS_FALSE						-1
#define STATS_ERROR_INVALID_LICENSE		-11 //------------CPY 5/30/2005 QA70-7770 PRO_ONLY_FUNCTIONS_SUPPORT
#define STATS_PARAMS_ARRAY_TOO_SMALL	-98		//--- CPY 7/17/04 FIT_PARAM_ARRAY_NEED_SIZE
#define STATS_ERROR_ARRAY_TOO_SMALL		-99		///Kyle 11/10/2010 ORG-1090 IMPROVE_PROTOTYPE_TO_ALLOW_SIZE_CHECKING
#define STATS_WARNING_AT_LEAST_ONE_TIE	-100	//Echo 8/17/04 add for wilicon rank sum test
#define STATS_ERROR_HYPOTHESIS				-101
#define STATS_ERROR_SHAPIRO_WILK			-103
#define STATS_WARNING_CANNOT_FIND_ALPHA		-104 //Zeck 7/26/2011 cannot find alpha in the table of Chen Shapiro's test 
#define STATS_ERROR_BAD_WEIGHT				-108 //Echo 5/11/04 Add for bad weights that are less than 0
#define STATS_ERROR_BAD_PARAM				-110 //Echo 5/6/04 Add for illegal parameter which does not in enum{}
#define STATS_ERROR_EA_LEVELS				-112 //Echo 5/6/04 Add for ocmath_dummy_vars
#define STATS_ERROR_PAIRED_SD_IS_0			-120	//Echo 5/5/04
#define STATS_WARNING_LILLIEFORS_OUT_RANGE	-145 //Lilliefors Stats is out range of Lilliefors table
#define STATS_ERROR_REGRESSION_X_RANGE		-150
#define STATS_ERROR_SETTING					-151
#define STATS_ERROR_CALLING_IMSL			-153
#define	STATS_ERROR_INPUT_SIZE				-155
#define STATS_INPUT_NULL_POINTER			-156///Iris 4/6/04
#define STATS_ERROR_CHI_HYPOTVALUE			-157
#define STATS_ERROR_GET_RANGE           	-158
#define STATS_ERROR_TOO_MANY_DATA_PTS		-166 
//---
#define STATS_ERROR_TOO_FEW_DATA_PTS		-165 //CPY 4/12/04
#define STATS_ERROR_DOF_ZERO				-170 //CPY 4/12/04
#define STATS_ERROR_SUM_WEIGHT_ZERO			-172 //CPY 4/12/04
#define STATS_ERROR_WEIGHT_DIFF_SIZE		-174 //CPY 4/12/04
#define STATS_ERROR_DATA_DIFF_SIZE			-175 //Echo 4/13/04
#define STATS_ERROR_VARIANCE_ZERO			-178 //CPY 4/12/04
#define STATS_ERROR_SVD_FAIL				-179 //Jay 4/28/04
#define STATS_ERROR_RANK_DEFICIENT			-180 //Jay 4/28/04
#define STATS_ERROR_ALL_ELEMENT_EQUAL		-185 //Echo 4/30/04 for normality test
#define STATS_ERROR_POWER_TOO_SMALL			-186 //Sonic 5/14/04
#define STATS_ERROR_SAMPLESIZE_TOO_LARGE	-187 //Sonic 5/14/04
#define STATS_ERROR1_ANOVA2_POWER			-190 //Echo 6/16/04 for ANOVA2_power
#define STATS_ERROR2_ANOVA2_POWER			-192 //Echo 6/16/04 for ANOVA2_power
#define STATS_ERROR_CONVERGENCE_FAIL		-194 //Echo 7/1/04 for non central cdfs
#define STATS_ERROR_INVALID_CONF_LEVEL		-196 //Annie 7/8/04 for confidence level or significance level not between 0 & 1 
#define STATS_ERROR_INVALID_CENSOR			-198 //Echo 7/9/04 created for suvival analysis functions
#define STATS_ERROR_UNSORT_DATA				-200 //Echo 7/14/04 add for Shapiro_Wilk function
#define STATS_ERROR_OCMATH					-202 //error in the quoted ocmath function
#define	STATS_ERROR_BAD_POWER				-204
#define STATS_ERROR_ALL_STATE_SAME			-206
#define STATS_ERROR_ELLIPSE					-207 //Human 9/30/05 add for ocmath_ellipse
#define	STATS_ERROR_NE_G08CB_SAMPLE			584		//same as NE_G08CB_SAMPLE in nag_errlist.h
//---
#define	STATS_ERROR_TOO_FEW_GROUPS			-208 //Max 11/11/05 for ANOVA factors less than 2
#define STATS_ERROR_UNBALANCED_DESIGN		-209 //Max 11/11/05 for unbalanced design
#define STATS_ERR_GROUP_NUM					-211 //Echo 4/19/06
#define STATS_ERROR_DATA_PTS_LESS_THAN_PARA_NUM	-212 //Max 1/15/07 for multiple regression
#define	STATS_ANOVA2_UNBALANCED_DESIGN		-214
#define STATS_TOO_MANY_TIES					-218
#define	STATS_ERROR_CALC_COV_CORR_MATRIX	-219 ///Arvin 01/25/08 QA70-10923 CALC_CONFIDENCE_AND_PREDICTION_BANDS_OF_POLYNOMIAL_FIT
#define	STATS_ERROR_INVALID_DISTRIBUTION	-220

#define ANOVA2_MIN_DATA_SIZE	4
#define	ANOVA2_MIN_FACTOR_SUBJECT	2

#define	NPHK_MAX_GROUP	10000
//Sonic   4/15/04   No need to use it ,use STATS_ERROR_SETTING  instead
//#define STATS_ERROR_ENUM_TYPE_NOT_FOUND 179 //Sonic 4/14/04
//---
///END Stellar 4/02/04 ADD_NEW_ERROR
#define AN2_MIN_VALUES_PER_CELL		1

//---- CPY 9/27/05 OCMATH_COMPILE_PROBLEM
//#include	"..\..\..\Module\ONAG8\ONAG8INCL.h" //Added by Ben 09/27/05 For PROB_TAIL
//----

///Echo 5/11/07	add nums for power analysis in two way anova
enum
{
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	//One-Way ANOVA also need this enumeration
	//ANOVA2_POWER_ACTUAL =		0x01,
	//ANOVA2_POWER_HYPOTHESIS =	0x02,
	ANOVA_POWER_ACTUAL =		0x01,
	ANOVA_POWER_HYPOTHESIS =	0x02,
	///end CLEAN_ANOVA_TOOLS_CODE	
};
//---- CPY 4/5/04 moved here from stats_utils.h due to moving codes from LLOC into LLVC in ocmath
// Hypothesis test tail types
enum
{
	TAILED_TEST_TWO = 0,
	TAILED_TEST_UPPER,
	TAILED_TEST_LOWER,
	// Ben 9/28/05 Add Tail Type
	TAILED_TEST_TWO_SIGN_IF,
	TAILED_TEST_TWO_CONFID,
	TAILED_TEST_CENTRAL,
	//discrete distribution
	TAILED_TEST_DISC_LOWER,
	TAILED_TEST_DISC_UPPER,
	TAILED_TEST_DISC_POINT

};
//----

//---- Ben 09/27 Add Tail Type
enum
{
	DISC = 0,
	NONDISC
};


//---- CPY 9/27/05 OCMATH_COMPILE_PROBLEM
/*
///Ben 09/27/05 move forest's codes from nrutil_nr.h here
typedef enum tagProbTail
{
	//continuous distribution
	TAIL_CONT_LOWER = Nag_LowerTail,//Prob(X <= t)
	TAIL_CONT_UPPER = Nag_UpperTail,//Prob(X >= t)
	TAIL_CONT_TWO_SIGN_IF = Nag_TwoTailSignif,
	TAIL_CONT_TWO_CONFID = Nag_TwoTailConfid,
	TAIL_CONT_TWO = Nag_TwoTail, 
	TAIL_CONT_CENTRAL = Nag_Central,
	//discrete distribution
	TAIL_DISC_LOWER,//Prob(X <= k)
	TAIL_DISC_UPPER,//Prob(X > k)
	TAIL_DISC_POINT//Prob(X = k)
}PROB_TAIL;
///End Ben Move
*/

// enums for one way ANOVA table
enum
{
	ANOVA_MODEL = 0,
	ANOVA_ERR,
	ANOVA_TOTAL
};

// Max 04/08/05 Add enums for two way ANOVA table
enum
{
	ANOVA2_FactorA = 0,
	ANOVA2_FactorB,
	ANOVA2_Interaction,
	ANOVA2_MODEL,
	ANOVA2_ERR,
	ANOVA2_TOTAL	
};

/// Max 11/12/05 CHANGE_ENUM_ORDER_FOR_MEANS_COMPARISON
// Echo 5/5/04 Add two enums for ANOVA function
// Max 03/14/05 Add four more enums for ANOVA function
// types of confidence level for the simultaneous interval estimation in ANOVA
/*
enum
{
	ANOVA_BONFERRON = 1,	// The Bonferroni method is used
	ANOVA_TUKEY,			// The Tukey method is used
	ANOVA_SCHEFFE,			// The Scheffe method is used
	ANOVA_SIDAK,			//the Dunn-Sidak method is used
	ANOVA_FISHER ,			//the Fisher's LSD method is used
	ANOVA_BONHOLM,			//the Bonferroni-Holm method is used
	ANOVA_SIDAKHOLM,		//the Sidak-Holm method is used
	ANOVA_DUNNETT,			//the Dunnett method is used
};
*/
enum
{
	ANOVA_TUKEY = 1,		// The Tukey method is used
	ANOVA_BONFERRON,		// The Bonferroni method is used
	ANOVA_SIDAK,			// The Dunn-Sidak method is used
	ANOVA_FISHER ,			// The Fisher's LSD method is used
	ANOVA_SCHEFFE,			// The Scheffe method is used
	ANOVA_DUNNETT,			// The Dunnett method is used
	ANOVA_BONHOLM,			// The Bonferroni-Holm method is used
	ANOVA_SIDAKHOLM,		// The Sidak-Holm method is used
	ANOVA_LAST_ITEM,		// The size of this enumeration, number of means comparison methods
};
/// End CHANGE_ENUM_ORDER_FOR_MEANS_COMPARISON

// Types of statsic of the test for equal variance in ANOVA
enum
{
	ANOVA_LEVENE = 1,	// The Levene stastic | | is used
	ANOVA_LEVENESQ,		// The Levene Squared stastic ()^2 is used
	ANOVA_BROWN ,		// The Brown=Forsythe stastic is used
	ANOVA_CHISQ,		// The Chi-Square stastic is used	

};

// Echo 5/5/04 Move here from ocmath.h because all enum should be put in stats_type.h
// Define the macro of norm types for general norm function of matrix of nRows x nCols
enum 
{	
	NORM_LARGEST_SUM = 1, 	// The largest column sum of matrix or the 1-norm
	NORM_LARGEST_SINGULAR,	// The largest SVD of matrix 
	NORM_INFINITY, 			// The largest row sum of matrix
	NORM_FROBEBINUS 		// The Frobenius-norm of matrix, sqrt(sum(diag(pData'*pData)))
};

// Echo 5/6/04 Add for the ocmath_dummy_vars in ocStats.h
enum
{
	DUMMY_FIRSTLEVEL,	// The contrasts relative to the Firstlevel are computed.
	DUMMY_LASTLEVEL,	// The contrasts relative to the Last level are computed.
	DUMMY_ALLLEVELS,	// A complete set of dummy variables is computed.
};

// Echo 5/11/04 Add for multiple regression
enum
{
	MULREG_DOF,		// Degrees of freedom for the model
	MULREG_EDOF,	// Degrees of freedom for error
	MULREG_TDOF,	// Total(corrected) degree of freedom
	MULREG_ESS,		// Sum of squares for the model
	MULREG_RSS,		// Sum of squares for the error
	MULREG_TSS,		// Total(corrected) sum of squares
	MULREG_MMS,		// Model mean square
	MULREG_EMS,		// Error mean square
	MULREG_F,		// Overall F-statistic
	MULREG_P,		// P-value
	MULREG_RSQ,		// R square
	MULREG_ADJRSQ,	// Adjusted R square
	MULREG_SD,		// Estimate of the standard deviation
	MULREG_YMEAN,	// Overall mean of y
	MULREG_ENORM,	// Norm of error
	MULREG_Size,	// Size of this enum
};

// Echo 6/7/04 Add for descriptive statistics
enum
{
	DS_SAS1_DOF,
	DS_SAS2_N,
	DS_SAS3_WDF,
	DS_SAS4_WGT,
	DS_NAG,	
};

// Echo 6/9/04 Move from stats_utils.h
// Percentile interpolation types
/// Max 9/13/06 MODIFY_ORDER_OF_INTERPOLATE (To keep consistent with SAS)
/// Max 5/18/06 MODIFY_ENUM_INTERPOLATE_MEANING
/*
enum 
{
	INTERPOLATE_WEIGHT_AVER_LEFT = 0,	// Weighted average aimed at x(n + 1)p
	INTERPOLATE_WEIGHT_AVER_RIGHT, 		// Weighted average aimed at xnp
	INTERPOLATE_NEAREST_NEIGHBOR,		// Observation numbered closest to np
	INTERPOLATE_EDF,					// Empirical distribution function, No Interpolation
	INTERPOLATE_EDF_AVER,				// Empirical distribution function with averaging
	INTERPOLATE_TUKEY					// Tukey Hinges, only avaiable in Quantile
};
*/
/*
enum 
{
	INTERPOLATE_WEIGHT_AVER_RIGHT = 0,	// Weighted average aimed at x(n + 1)p
	INTERPOLATE_WEIGHT_AVER_LEFT, 		// Weighted average aimed at xnp
	INTERPOLATE_NEAREST_NEIGHBOR,		// Observation numbered closest to np
	INTERPOLATE_EDF,					// Empirical distribution function, No Interpolation
	INTERPOLATE_EDF_AVER,				// Empirical distribution function with averaging
	INTERPOLATE_TUKEY,					// Tukey Hinges, only avaiable in Quartile
	INTERPOLATE_LAST_ITEM				// Size of this enumeration, number of interpolation methods
};
/// END MODIFY_ENUM_INTERPOLATE_MEANING
*/
enum 
{
	INTERPOLATE_EDF_AVER = 0,			// Empirical distribution function with averaging
	INTERPOLATE_NEAREST_NEIGHBOR,		// Observation numbered closest to np
	INTERPOLATE_EDF,					// Empirical distribution function, No Interpolation
	INTERPOLATE_WEIGHT_AVER_RIGHT,		// Weighted average aimed at x(n + 1)p
	INTERPOLATE_WEIGHT_AVER_LEFT, 		// Weighted average aimed at xnp
	INTERPOLATE_TUKEY,					// Tukey Hinges, only avaiable in Quartile
	INTERPOLATE_LAST_ITEM				// Size of this enumeration, number of interpolation methods
};
/// END MODIFY_ORDER_OF_INTERPOLATE

// stats_linear_fit enum
enum
{
	INTERCEPT = 0,
	SLOPE
};
/** >Fitting
*/
typedef struct tagRegCalcInternal
{
	double dSumWeight;
	double dSxx;
	double dSxy;
	double dSyy;
	double dxAve;
	double dyAve;
} RegCalcInternal;

/// Max 10/13/04 ADD_FOR_KOLMOGOROV_SMIRNOV_TEST
enum
{
	PARA_ESTIMATED = 0,
	PARA_SUPPLIED
};
/// End ADD_FOR_KOLMOGOROV_SMIRNOV_TEST

//Define for the Boundary type of of frequency counts
enum
{
	FC_STEPSIZE = 0,
	FC_NUMINTERVALS,
};

//Define threshold method in roc curve
enum
{
	ROC_INTERPOLATION = 0,
	ROC_SPEED_MODE,
	ROC_USER_DEFINED,
};

//Commetnts last updated by Echo on 8/18/05
/**$
	Remark:
		Use to define what kind of diagnotic residual to compute
	Keywords: 
		ocmath_diagnostic_residuals
*/
enum
{
	DIAGRESID_STAD,	//standardized residuals
	DIAGRESID_STUD, //studentized residuals
	DIAGRESID_STUDDEL//studentized deleted residuals
};

/// Human 10/14/05 ADD_FOR_OCMATH_SURVIV_WEIBULL_SIMPLE
enum
{
	WBS_INTERCEPT = 0,
	WBS_SCALE,
	WBS_WEIBULL_SCALE,
	WBS_WEIBULL_SHAPE
};
/// END ADD_FOR_OCMATH_SURVIV_WEIBULL_SIMPLE

///Echo 11/03/05 ADD_FOR_SURVIVAL_FUNCTION_COMPARISON
/**$
	Remark:
		Use to define what method to used in survival function comparison
	Keywords: 
		ocmath_surviv_fn_comp
*/
enum
{
	SA_SFCOMP_LOGRANK = 0,	//Log rank
	SA_SFCOMP_BRESLOW,		//Breslow
	SA_SFCOMP_TARONEWARE	//Tarone-Ware
};
///END ADD_FOR_SURVIVAL_FUNCTION_COMPARISON

/**$
	Remark:
		Use to define survival plot type
*/
enum
{
		SURV_PLOT_SF,
		SURV_PLOT_OMSF,
		SURV_PLOT_LSF,
		SURV_PLOT_HAZARD,
};


///Max 11/11/05 ADD_ENUM_FOR_REPEATED_MEASURE_ANOVA

// ANOVA table elements for OCSTATEX_RM_ANOVA_ONE_WAY
enum
{
	RMANOVAONEWAY_INTERCEPT = 0,
	RMANOVAONEWAY_BETWEEN_SUBJECT_ERROR,
	RMANOVAONEWAY_WITHIN_SUBJECT_FACTOR_SPHERIC,
	RMANOVAONEWAY_WITHIN_SUBJECT_FACTOR_GG,
	RMANOVAONEWAY_WITHIN_SUBJECT_FACTOR_HF,
	RMANOVAONEWAY_WITHIN_SUBJECT_FACTOR_LB,
	RMANOVAONEWAY_WITHIN_SUBJECT_ERROR_SPHERIC,
	RMANOVAONEWAY_WITHIN_SUBJECT_ERROR_GG,
	RMANOVAONEWAY_WITHIN_SUBJECT_ERROR_HF,
	RMANOVAONEWAY_WITHIN_SUBJECT_ERROR_LB,
	RMANOVAONEWAY_LAST_ITEM					// The size of this enumeration, size of row elements for ANOVA table of RM ANOVA one way
};

// ANOVA table elements for OCSTATEX_RM_ANOVA_TWO_WAY_ONE_RV
enum
{
	RMANOVATWOWAYONERV_INTERCEPT = 0,
	RMANOVATWOWAYONERV_BETWEEN_SUBJECT_FACTOR,
	RMANOVATWOWAYONERV_BETWEEN_SUBJECT_ERROR,
	RMANOVATWOWAYONERV_WITHIN_SUBJECT_FACTOR_SPHERIC,
	RMANOVATWOWAYONERV_WITHIN_SUBJECT_FACTOR_GG,
	RMANOVATWOWAYONERV_WITHIN_SUBJECT_FACTOR_HF,
	RMANOVATWOWAYONERV_WITHIN_SUBJECT_FACTOR_LB,
	RMANOVATWOWAYONERV_INTERACTION_SPHERIC,
	RMANOVATWOWAYONERV_INTERACTION_GG,
	RMANOVATWOWAYONERV_INTERACTION_HF,
	RMANOVATWOWAYONERV_INTERACTION_LB,
	RMANOVATWOWAYONERV_WITHIN_SUBJECT_ERROR_SPHERIC,
	RMANOVATWOWAYONERV_WITHIN_SUBJECT_ERROR_GG,
	RMANOVATWOWAYONERV_WITHIN_SUBJECT_ERROR_HF,
	RMANOVATWOWAYONERV_WITHIN_SUBJECT_ERROR_LB,
	RMANOVATWOWAYONERV_LAST_ITEM					// The size of this enumeration, size of row elements for ANOVA table of RM ANOVA two way with one RV
};

// ANOVA table elements for OCSTATEX_RM_ANOVA_TWO_WAY_TWO_RV
enum
{
	RMANOVATWOWAYTWORV_INTERCEPT = 0,
	RMANOVATWOWAYTWORV_BETWEEN_SUBJECT_ERROR,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORA_SPHERIC,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORA_GG,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORA_HF,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORA_LB,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORA_ERROR_SPHERIC,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORA_ERROR_GG,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORA_ERROR_HF,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORA_ERROR_LB,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORB_SPHERIC,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORB_GG,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORB_HF,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORB_LB,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORB_ERROR_SPHERIC,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORB_ERROR_GG,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORB_ERROR_HF,
	RMANOVATWOWAYTWORV_WITHIN_SUBJECT_FACTORB_ERROR_LB,
	RMANOVATWOWAYTWORV_INTERACTION_SPHERIC,
	RMANOVATWOWAYTWORV_INTERACTION_GG,
	RMANOVATWOWAYTWORV_INTERACTION_HF,
	RMANOVATWOWAYTWORV_INTERACTION_LB,
	RMANOVATWOWAYTWORV_INTERACTION_ERROR_SPHERIC,
	RMANOVATWOWAYTWORV_INTERACTION_ERROR_GG,
	RMANOVATWOWAYTWORV_INTERACTION_ERROR_HF,
	RMANOVATWOWAYTWORV_INTERACTION_ERROR_LB,
	RMANOVATWOWAYTWORV_LAST_ITEM					// The size of this enumeration, size of row elements for ANOVA table of RM ANOVA two way with two RV
};

// Multivariate test elements
enum
{
	MTEST_PILLAI = 0,
	MTEST_WILK,
	MTEST_HOTELLING,
	MTEST_ROY,
	MTEST_LAST_ITEM		// The size of this enumeration, size of row elements for Multivariate test table
};

///End ADD_ENUM_FOR_REPEATED_MEASURE_ANOVA


///Type of confidence ellipse
enum
{
		ELLIPSE_PREDICTION = 0,
		ELLIPSE_MEAN
};


/// Max 9/5/06 ADD_ENUM_FOR_INPUT_DATA_FORM
/// Type of input data form(indexed/grouping & raw)
enum
{
	INDEXED_FORM_INPUT_DATA = 0,
	RAW_FORM_INPUT_DATA
};
///End ADD_ENUM_FOR_INPUT_DATA_FORM


//Type of plot type of hypothesis tests
enum
{
	HYPO_TEST_HISTOGRAM = 1,
	HYPO_TEST_BOX,	
};

//Type of algorithm used in Shapiro-Wilk Normality test
enum
{
	SHAPIRO_WILK_R94 = 0,
	SHAPIRO_WILK_AS181,
};

//Type of third range of survival input data
enum
{
	SA_NONE = 0,
	SA_GROUP,
	SA_COVARIATE,
};

enum
{
	CORR_EXCLUDE_MISSING_PAIRWISE,
	CORR_EXCLUDE_MISSING_LISTWISE,
};
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///////////////////////          Statistics Structs         //////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

// *** Begin Structures for Descriptive Statistics *** 

///Echo 5/31/06 REORDER_DESC_STATS_RES
//typedef struct tagDescStatResults
//{
	//int 	_id(IDE_SAMPLE_SIZE)		N;
	//int		_id(IDE_NUM_MISSING)		Missing;
	//double	_id(IDE_SUM)				Sum;
	//double	_id(IDE_MEAN)				Mean;
	//double	_id(IDE_MODE)				Mode;
	//double	_id(IDE_GEO_MEAN)			GeoMean;
	//double	_id(IDE_GEO_SD)				GeoSD;///Echo 3/22/05 v8.0207 QA70-6204 ADD_GSD
/////Kevin 09/01/05 CHANGE_STATISTICS_NAME
	////double	_id(IDE_LCI)				LCI;
	////double	_id(IDE_UCI)				UCI;
	//double	_id(IDE_LCL)				LCL;
	//double	_id(IDE_UCL)				UCL;
/////End CHANGE_STATISTICS_NAME
	//double	_id(IDE_SD)					SD;
	//double	_id(IDE_SD_X_2)				SDx2;
	//double	_id(IDE_SD_X_3)				SDx3;
	//double	_id(IDE_SEM)				SEM;
	//double	_id(IDE_VARIANCE)			Variance;
	//double	_id(IDE_COV)				COV;
	//double	_id(IDE_SKEWNESS)			Skewness;
	//double	_id(IDE_KURTOSIS)			Kurtosis;
	//double	_id(IDE_MAD)				MAD;
	//double	_id(IDE_UNCORSUMSQ)			UncorSumSq;
	//double	_id(IDE_CORSUMSQ)			CorSumSq;
	//double	_id(IDE_WEIGHTSUM)			WeightSum;
//} DescStatResults;

typedef struct tagDescStatResults
{
	int 	_id(IDE_SAMPLE_SIZE)		N;
	int		_id(IDE_NUM_MISSING)		Missing;
	double	_id(IDE_MEAN)				Mean;
	double	_id(IDE_SD)					SD;
	double	_id(IDE_SEM)				SEM;
	double	_id(IDE_LCL)				LCL;
	double	_id(IDE_UCL)				UCL;
	double	_id(IDE_VARIANCE)			Variance;
	double	_id(IDE_SUM)				Sum;
	double	_id(IDE_SKEWNESS)			Skewness;
	double	_id(IDE_KURTOSIS)			Kurtosis;
	double	_id(IDE_UNCORSUMSQ)			UncorSumSq;
	double	_id(IDE_CORSUMSQ)			CorSumSq;
	double	_id(IDE_COV)				COV;
	double	_id(IDE_MAD)				MAD;
	double	_id(IDE_SD_X_2)				SDx2;
	double	_id(IDE_SD_X_3)				SDx3;
	double	_id(IDE_GEO_MEAN)			GeoMean;
	double	_id(IDE_GEO_SD)				GeoSD;
	double	_id(IDE_MODE)				Mode;
	double	_id(IDE_WEIGHTSUM)			WeightSum;
} DescStatResults;
///END REORDER_DESC_STATS_RES



typedef struct tagDescStatOptions
{
	int		_id(IDE_VAR_DIVISOR)		VarDivisor;
	bool 	_id(IDE_SAMPLE_SIZE)		N;
	bool	_id(IDE_NUM_MISSING)		Missing;
	bool	_id(IDE_SUM)				Sum;
	bool	_id(IDE_MEAN)				Mean;
	bool	_id(IDE_MODE)				Mode;
	bool	_id(IDE_GEO_MEAN)			GeoMean;
	bool	_id(IDE_GEO_SD)				GeoSD;
	bool	_id(IDE_LCL)				LCL;
	bool	_id(IDE_UCL)				UCL;
	bool	_id(IDE_SD)					SD;
	bool	_id(IDE_SD_X_2)				SDx2;
	bool	_id(IDE_SD_X_3)				SDx3;
	bool	_id(IDE_SEM)				SEM;
	bool	_id(IDE_VARIANCE)			Variance;
	bool	_id(IDE_COV)				COV;
	bool	_id(IDE_SKEWNESS)			Skewness;
	bool	_id(IDE_KURTOSIS)			Kurtosis;
	bool	_id(IDE_MAD)				MAD;
	bool	_id(IDE_UNCORSUMSQ)			UncorSumSq;
	bool	_id(IDE_CORSUMSQ)			CorSumSq;
	bool	_id(IDE_WEIGHTSUM)			WeightSum;
} DescStatOptions;


typedef struct tagRangeResults
{
	double	_id(IDE_MIN)				Min;
	double	_id(IDE_MAX)				Max;
	int		_id(IDE_IMIN)				iMin;
	int		_id(IDE_IMAX)				iMax;
	double	_id(IDE_RANGE)				Range;
} RangeResults;

typedef struct tagQuantileOptions
{
	int		_id(IDE_INTERPOLATE)		Interpolate;
	int		_id(IDE_VAR_DIVISOR)		VarDivisor;///DSC 9/20/05 QA70-8113 ADD_IDE_VAR_DIVISOR
	bool	_id(IDE_MIN)				Min;
	bool	_id(IDE_IMIN)				iMin;
	//bool	_id(IDE_P25)				Q25;///Echo 8/22/06 USE_STANDARD_NAME
	bool	_id(IDE_P25)				Q1;
	bool	_id(IDE_MEDIAN)				Median;
	//bool	_id(IDE_P75)				Q75;
	bool	_id(IDE_P75)				Q3;///Echo 8/22/06 USE_STANDARD_NAME
	bool	_id(IDE_MAX)				Max;
	bool	_id(IDE_IMAX)				iMax;
	bool	_id(IDE_IQR)				IQR;
	bool	_id(IDE_RANGE)				Range;
} QuantileOptions;

typedef struct tagQuantileResults
{
	double	_id(IDE_MIN)				Min;
	int		_id(IDE_IMIN)				iMin;
	//double	_id(IDE_P25)			Q25;
	double	_id(IDE_P25)				Q1;///Echo 8/22/06 USE_STANDARD_NAME
	double	_id(IDE_MEDIAN)				Median;
	//double	_id(IDE_P75)			Q75;
	double	_id(IDE_P75)				Q3;///Echo 8/22/06 USE_STANDARD_NAME
	double	_id(IDE_MAX)				Max;
	int		_id(IDE_IMAX)				iMax;
	double	_id(IDE_IQR)				IQR;
	double	_id(IDE_RANGE)				Range;
} QuantileResults;
// *** End Structures for Descriptive Statistics *** 

// *** Begin Structures for Frequency Count *** 
typedef struct tagFreqCountOptions
{
	double 	_id(IDE_FC_BIN_START)			FromMin;		// Starting bin or minimum value
	double	_id(IDE_FC_BIN_END)				ToMax;			// Ending bin or maximum value 
	double	_id(IDE_FC_BIN_INC)				StepSize;		// Bin size
	bool 	_id(IDE_FC_OUTLIER_LT)			IncludeLTMin;	// Include Outliers LT min in first bin
	bool	_id(IDE_FC_OUTLIER_GT)			IncludeGEMax;	// Include Outliers GE max in last bin
	/// Hong 09/09/09 QA80-14287 FREQUENCY_COUNT_ADD_MIN_MAX_COUNT
	bool	_id(IDE_FC_MIN)					IncludeMin;	// Include min
	bool	_id(IDE_FC_MAX)					IncludeMax;	// Include max
	/// end FREQUENCY_COUNT_ADD_MIN_MAX_COUNT
} FreqCountOptions;
// *** End Structures for Frequency Count ***

///Arvin 08/10/07 QA70-10197 ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
//error bar as weight options
enum
{
	ERRBARWEIGHT_NO_WEIGHTING,
	ERRBARWEIGHT_DIRECT_WEIGHTING,
	ERRBARWEIGHT_INSTRUMENTAL,
};
///end ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR

// *** Begin Structures for Regression and NLSF *** 
/** >Fitting
*/
typedef struct tagLROptions
{
	///Max 9/09/04 MODIFY_FIXINTERCEPT
	//bool	_id(IDE_LR_THROUGH_ZERO)		ThroughZero;		// Force line through 0
	///End MODIFY_FIXINTERCEPT
	bool	_id(IDE_LR_FIX_SLOPE)			FixSlope;			// Fixed value of slope (Note: cannot fix slope and thru zero at same time, should return error from LLOC)
	double	_id(IDE_LR_FIX_SLOPE_AT)		FixSlopeAt;			// Fixed value of slope (Note: cannot fix slope and thru zero at same time, should return error from LLOC)
	///Arvin 08/10/07 QA70-10197 ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
	//bool 	_id(IDE_FIT_ERROR_BARS)			ErrBarWeight;		// Use Errors for weight
	int 	_id(IDE_FIT_ERROR_BARS)			ErrBarWeight;		// Use Errors for weight
	///end ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
	bool	_id(IDE_FIT_REDUCED_CHISQR)		UseReducedChiSq;	// Use Reduced Chi-square
	double	_id(IDE_FIT_CONF_PERCENT)		Confidence;			// Confidence value for parameter U/L
	bool	_id(IDE_FIT_APPARENT_SCALE)		ApparentFit;		// use apparent scale
	bool	_id(IDE_LR_FIX_INTCPT)			FixIntercept;		// Force intercept to be fixed
	double	_id(IDE_LR_FIX_INTCPT_AT)		FixInterceptAt;		// Fixed value of intercept
	//bool 	_id(IDE_LR_USE_RANGE)			UseDataXRange;		// true uses data range, false uses X1, X2
	//double	_id(IDE_LR_X1)				X1;					// Default X minimum
	//double	_id(IDE_LR_X2)				X2;					// Default X maximum
} LROptions;

typedef struct tagNLSFOptions
{
	double 	_id(IDE_NLSF_TOLERANCE)			Tolerance;			// Tolerance value
	uint	_id(IDE_NLSF_ITERATIONS)		Iterations;			// Max number of iterations
} NLSFOptions;

///Iris 7/29/05 UPDATE_FITTED_CURVE_OPTIONS
/*
typedef struct tagFitResultCurveOptions
{
	bool	_id(IDE_FIT_USE_DATA_X)		UsedataX;			// ignore N, SpanXAxis and RangeMargin, just use data's X
	bool    _id(IDE_FIT_USE_DATA_XY)	UseDataXY;			// just use input data's X and Y
	uint	_id(IDE_FIT_X_POINTS)		N;					// Number of points in fit curve
	uint    _id(IDE_FIT_Y_POINTS)		NY;					// Number of points in Y Axis of fit curve
	double  _id(IDE_FIT_X_MIN)			XMin;				// The mininum data of X
	double  _id(IDE_FIT_X_MAX)			XMax;				// The maximum data of X
	double  _id(IDE_FIT_Y_MIN)			YMin;				// The mininum data of Y
	double  _id(IDE_FIT_Y_MAX)			YMax;				// The maximum data of Y
	bool	_id(IDE_FIT_RANGE_FULL_X)	SpanXAxis;			// fit curve will use entire X range in plot
	bool    _id(IDE_FIT_RANGE_FULL_XY)  SpanYAxis;			// fit curve will use entire Y range in plot
	double	_id(IDE_FIT_RANGE_MARGIN)	RangeMargin;		// X range as full range with Margin in percent 
	int		_id(IDE_FIT_CURVE_COLOR)	CurveColor;			// index into Origin's color palette
	bool	_id(IDE_FIT_CONF_BANDS)		ConfBands;			// Create confidence bands - if not set, then matrix will have empty columns
	bool	_id(IDE_FIT_PRED_BANDS)		PredBands;			// Create prediction bands - if not set, then matrix will have empty columns
	double	_id(IDE_FIT_CONF_PERCENT)	Confidence;			// Confidence value to be used
	bool	_id(IDE_FIT_RESIDUALS)		Residuals;			// Create residuals
} FitResultCurveOptions;
*/
typedef struct tagFitResultCurveOptions
{
	int		_id(IDE_FIT_CURVE_COLOR)		CurveColor;			// index into Origin's color palette
	int		_id(IDE_FIT_DATA_TYPE_BRANCH) 	DataType;			// select data type, same as x data; uniform linear; uniform log
	uint	_id(IDE_FIT_X_POINTS)			N;					// Number of points in fit curve
	int 	_id(IDE_FIT_RANGE_BRANCH)		Range;				// the range type, can be range margin; span to axis; custom
	double  _id(IDE_FIT_X_MIN)				Min;				// The mininum data of X
	double  _id(IDE_FIT_X_MAX)				Max;				// The maximum data of X
	double	_id(IDE_FIT_RANGE_MARGIN)		RangeMargin;		// X range as full range with Margin in percent 
	bool	_id(IDE_FIT_CONF_BANDS)			ConfBands;			// Create confidence bands - if not set, then matrix will have empty columns
	bool	_id(IDE_FIT_PRED_BANDS)			PredBands;			// Create prediction bands - if not set, then matrix will have empty columns
	double	_id(IDE_FIT_CONF_PERCENT)		Confidence;			// Confidence value to be used
	///Cheney 2006-9-19 ADD_PLOT_TYPE_IN_FIT_OPTION	
	int	    _id(IDE_FIT_PLOT_TYPE)			PlotType;			// Plot Type
	///end ADD_PLOT_TYPE_IN_FIT_OPTION
	/// Iris 02/07/2007 v8.0556 HOW_PLOT_AND_HOW_LEGEND_NOT_EFFECT_ON_PREVIEW
	/*
	/// Iris 01/24/2007 v8.0546 CONTROL_HOW_PLOT_FIT_CURVE_ON_SOURCE_GRAPH
	int		_id(IDE_FIT_PLOT_FIT_CURVE)		HowPlotFit;			// how plot fit curve on original graph. PLOT_NONE, PLOT_FIT_CURVE, PLOT_FIT_CURVE_WITH_RAW_DATA
	int		_id(IDE_FIT_UPDATE_LEGEND)		UpdateLegend;		// If update legend after plot fit curve
	///end CONTROL_HOW_PLOT_FIT_CURVE_ON_SOURCE_GRAPH
	*/
	///end HOW_PLOT_AND_HOW_LEGEND_NOT_EFFECT_ON_PREVIEW
} FitResultCurveOptions;

enum
{
	PLOT_NONE,
	PLOT_FIT_CURVE,
	PLOT_FIT_CURVE_WITH_RAW_DATA, //Fit Curve + Raw Data / Mean SD / Mean SD(this item only for Concatenate)
	
	PLOT_LAST_ITEM
};

//the options of DataType in FitResultCurveDataOptions
enum
{
	/// Iris 11/21/06 DEFAULT_X_SHOULD_BE_UNIFORM_LIENAR
	//FIT_CURVE_SAME_AS_DATA = 0,
	//FIT_CURVE_UNIFORM_LINEAR,
	FIT_CURVE_UNIFORM_LINEAR = 0,
	FIT_CURVE_UNIFORM_LOG,
	FIT_CURVE_SAME_AS_DATA,
	FIT_CURVE_SAME_AS_SOURCE_GRAPH,		///Kyle 11/18/2008 QA80-12591 ADD_MORE_OPTION_FOR_INPUT_DATA_TYPE_IN_FITTING_TOOLS
	///end DEFAULT_X_SHOULD_BE_UNIFORM_LIENAR
};

//the options of Range in FitResultCurveDataOptions	
enum
{
	FIT_CURVE_RANGE_MARGIN = 0,
	FIT_CURVE_SPAN_AXIS,
	FIT_CURVE_CUSTOM,
};

typedef struct tagFitResultCurveDataOptions
{
	int		_id(IDE_FIT_DATA_TYPE_BRANCH) 	DataType;			// select data type, same as x data; uniform linear; uniform log
	uint	_id(IDE_FIT_X_POINTS)			N;					// Number of points in fit curve
	int 	_id(IDE_FIT_RANGE_BRANCH)		Range;				// the range type, can be range margin; span to axis; custom
	double  _id(IDE_FIT_X_MIN)				Min;				// The mininum data of X
	double  _id(IDE_FIT_X_MAX)				Max;				// The maximum data of X
	double	_id(IDE_FIT_RANGE_MARGIN)		RangeMargin;		// X range as full range with Margin in percent 
} FitResultCurveDataOptions;

///end UPDATE_FITTED_CURVE_OPTIONS
/** >Fitting
*/
typedef struct tagFitParameter
{
	double	_id(IDE_PARAM_VALUE)		Value;			// Parameter value
	bool	_id(IDE_PARAM_FIX)			Fix;			// Parameter fix
	double	_id(IDE_PARAM_ERROR)		Error;			// Parameter error
	double	_id(IDE_PARAM_TVALUE)		tValue;			// Parameter tValue
///Kevin 11/10/05 CHANGE_PARAMETER_ORDER	
	double	_id(IDE_PARAM_PROB)			Prob;			// Parameter probability
///End CHANGE_PARAMETER_ORDER
///Kevin 09/01/05 CHANGE_STATISTICS_NAME
	//double	_id(IDE_PARAM_LCI)			LCI;			// Paramater lower confidence limit
	//double	_id(IDE_PARAM_UCI)			UCI;			// Parameter upper confidence limit
	double	_id(IDE_PARAM_LCL)			LCL;			// Paramater lower confidence limit
	double	_id(IDE_PARAM_UCL)			UCL;			// Parameter upper confidence limit
///End CHANGE_STATISTICS_NAME
///Kevin 11/10/05 CHANGE_PARAMETER_ORDER	
	//double	_id(IDE_PARAM_PROB)			Prob;			// Parameter probability
///End CHANGE_PARAMETER_ORDER
	double	_id(IDE_PARAM_DEPENDENCY)	Dependency;		// Parameter dependency
	double	_id(IDE_PARAM_CONF_INT)		ConfInterval;	// Parameter confidence interval
} FitParameter;


typedef struct tagFitDerivedParameter
{
	double	_id(IDE_PARAM_VALUE)		Value;			// Parameter value
	///------ Folger 06/17/2011 ORG-2097-S1 STANDARD_ERROR_FOR_DERIVED_PARAMS
	double	_id(IDE_PARAM_ERROR)		Error;			// Parameter error
	///------ End STANDARD_ERROR_FOR_DERIVED_PARAMS
	///Cheney 2007-11-6 QA70-10659 ADD_LCL_UCL_FOR_DERIVED_PARAMS
	//I add it but comment it now, because its algorithm is not clear now
	//double	_id(IDE_PARAM_LCL)			LCL;			// Paramater lower confidence limit
	//double	_id(IDE_PARAM_UCL)			UCL;			// Parameter upper confidence limit
	///end ADD_LCL_UCL_FOR_DERIVED_PARAMS
}FitDerivedParameter;

/** >Fitting
*/
typedef struct tagRegStats
{
	double	_id(IDE_FIT_NUM_POINTS)			N;				// Number of points
	double	_id(IDE_FIT_DOF)				DOF;			// Degrees of freedom
	//double	_id(IDE_FIT_CHI_SQUARE)		ChiSq;			// Chi^2  same as SSR
	double	_id(IDE_FIT_REDUCED_CHI_SQUARE) ReducedChiSq;			// Chi^2/DOF
	double	_id(IDE_FIT_SSR)				SSR;			// Regression sum of squares, same as ChiSq, Chi^2
	double	_id(IDE_FIT_CORRELATION)		Correlation;	// Correlation between factors
	//double	_id(IDE_FIT_COD)				COD;			// Coefficient of Determination (R^2) see RSqCOD
	double	_id(IDE_FIT_RVALUE)				Rvalue;			// R Value
	double	_id(IDE_FIT_RSQUARE_COD)		RSqCOD;			// Coefficient of determination	(R^2)
	double	_id(IDE_FIT_ADJ_RSQUARE)		AdjRSq;			// Adjusted residuel sum of squares
	double	_id(IDE_FIT_ROOT_MSE)			RMSESD;			// Root-MSE (SD)
	double	_id(IDE_FIT_NORM_REDIDUALS)		NormResiduals;	// Norm of Residuals, as the largest singular value of the residuals
} RegStats;

/// ML 9/1/2005 PER_DATASET_FITTING_STATISTICS
// NLSF per dataset statistics
typedef struct tagRegStatsPerDataset
{
	double	_id(IDE_FIT_SSR)				SSR;			// Regression sum of squares
	/// ML 3/1/2007 ADDING_QUANTITIES_FOR_STATS_PER_DATASET
	double	_id(IDE_FIT_RVALUE)				Rvalue;			// R Value
	/// end ADDING_QUANTITIES_FOR_STATS_PER_DATASET
	double	_id(IDE_FIT_RSQUARE_COD)		RSqCOD;			// Coefficient of determination	(R^2)
} RegStatsPerDataset;
/// end PER_DATASET_FITTING_STATISTICS


//NLSF produces RegStats, and in addition, it provides these
//additional info about the fitting
typedef struct tagNLSFFitInfo
{
	double	_id(IDE_NLSF_MU_FINAL)			MuFinal;		// Final MU value reached
	double	_id(IDE_NLSF_MU_MIN)			MuMin;			// Smallest MU value reached
	double	_id(IDE_NLSF_DERIV_STEP)		DerivStep;		// Parameter change amount for calculating derivatives
	double	_id(IDE_NLSF_PARAM_CHANGE)		ParaChange;		// Parameters changed
	double	_id(IDE_NLSF_TOLERANCE)			Tolerance;		// Tolerance value
	double	_id(IDE_NLSF_CONFIDENCE)		Confidence;		// Confidence value used
	int		_id(IDE_NLSF_ITERATIONS)		Iterations;		// Iterations performed
	double	_id(IDE_NLSF_RANGE1)			Range1;			// Beginning range
	double	_id(IDE_NLSF_RANGE2)			Range2;			// Ending range
	double	_id(IDE_NLSF_STEP)				Step;			// Step value
	int		_id(IDE_NLSF_CONSTRAINTS)		Constr;			// Number of constraints
	int		_id(IDE_NLSF_EFF_CONSTRAINTS)	EffConstr;		// Number of effective constraints
} NLSFFitInfo;



typedef struct tagRegANOVARow
{
	double	_id(IDE_FIT_ANOVA_DOF)			DOF;			// Degrees of freedom
	double	_id(IDE_FIT_ANOVA_SUM_SQUARES)	SSq;			// Sum of squares
	double	_id(IDE_FIT_ANOVA_MEAN_SQUARE)	MeanSq;			// Mean square
} RegANOVARow;
/** >Fitting
*/
typedef struct tagRegANOVA
{
	RegANOVARow	_id(IDE_ANOVA_TABLE)	AnovaTable[3];	// ANOVA Table
	double	_id(IDE_ANOVA_FVALUE)		Fvalue;			// F Value
	double	_id(IDE_ANOVA_PVALUE)		Pvalue;			// P Value
} RegANOVA;
// *** End Structures for Regression and NLSF *** 

// *** Begin Structures for t-Tests ***
//#ifndef __AFX_H__		///Danice 4/5/04 v8.0850 TWO_SAMPLE_TTEST_NEED
typedef struct tagHypotTestOptions
{
	int		_id(IDE_TEST_TYPE)			TestType;	     // Type of test (sometimes not used, varies by test)
	double	_id(IDE_TEST_VALUE)			HypotValue;	     // Hypothesis test value
	int		_id(IDE_TAIL_TYPE)			TailType;	     // Perform a two-tailed, upper tailed, or lower tailed test
} HypotTestOptions;

typedef struct tagtTestMean1SampleResults
{
	int 	_id(IDE_TTEST1_SAMPLE_SIZE)		N;             // Sample size
	double	_id(IDE_TTEST1_MEAN)			Mean;		   // Mean of the sample
	double	_id(IDE_TTEST1_SD)				SD;			   // Standard deviation of the sample
	double	_id(IDE_TTEST1_SEM)				SEM;		   // Standard error of the sample mean
	int		_id(IDE_TTEST1_DOF)				DOF;		   // Degrees of Freedom for t-Test
	double	_id(IDE_TTEST1_T_VALUE)			tValue;		   // Student's t-Test statistic
	double	_id(IDE_TTEST1_PROB)			Prob;		   // Probability for t-Test
} tTestMean1SampleResults;

typedef struct tagtTestDescStats
{
	int 	_id(IDE_SAMPLE_SIZE)				N;             // Sample size
	double	_id(IDE_MEAN)						Mean;		   // Mean of the sample
	double	_id(IDE_SD)							SD;			   // Standard deviation of the sample
	double	_id(IDE_SEM)						SEM;		   // Standard error of the sample mean
} tTestDescStats;

typedef struct tagtTestResults
{
	double		_id(IDE_TTEST_RES_DOF)			DOF;		   // Degrees of Freedom for t-Test
	double	_id(IDE_TTEST_RES_T_VALUE)			tValue;		   // Student's t-Test statistic
	double	_id(IDE_TTEST_RES_PROB)				Prob;		   // Probability for t-Test
} tTestResults;

		
typedef struct tagChiSqVar1SampleResults
{
	int		_id(IDE_CHISQ_DOF)				ChiSqDOF;	   // Degrees of Freedom for Chi-Square test
	double	_id(IDE_CHI_SQ_VALUE)		ChiSqValue;	   // Chi-Square test statistic
	double	_id(IDE_CHISQ_PROB)				ChiSqProb;	   // Probability for Chi-Square test
} ChiSqVar1SampleResults;

/** >Statistics>Hypothesis Testing
	Remarks:
		Struct to hold the result of two sample confidence test.
*/
typedef struct tagtTestMean2SampleResults
{
	int 	_id(IDE_TTEST2_SAMPLE_SIZE1)		N1;            // Size of sample 1
	double	_id(IDE_TTEST2_MEAN1)				Mean1;		   // Mean of sample 1
	double	_id(IDE_TTEST2_SD1)					SD1;		   // Standard deviation of sample 1
	double	_id(IDE_TTEST2_SEM1)				SEM1;		   // Standard error of sample 1 mean
	int 	_id(IDE_TTEST2_SAMPLE_SIZE2)		N2;            // Size of sample 2
	double	_id(IDE_TTEST2_MEAN2)				Mean2;		   // Mean of sample 2
	double	_id(IDE_TTEST2_SD2)					SD2;		   // Standard deviation of sample 2
	double	_id(IDE_TTEST2_SEM2)				SEM2;		   // Standard error of sample 2 mean
	double	_id(IDE_TTEST2_DIF_MEAN)		DiffMean;	   // Difference of means of two Samples
	double	_id(IDE_TTEST2_DIF_SEM)		DiffSEM;	   // Difference of SEMs of two Samples
/// Echo 3/30/04 MODIFY_DOF_TYPE
// Change the type of DOF as double because DOF could be double in the algorithm of 2 Sample tTest for unequal variance. 
	//int		_id(IDE_DOF)				DOF;		   // Degrees of Freedom for t-Test
	double	_id(IDE_TTEST2_DOF)				DOF;		   // Degrees of Freedom for t-Test
/// End Echo 3/30/04 MODIFY_DOF_TYPE	
	double	_id(IDE_TTEST2_T_VALUE)			tValue;		   // Student's t-Test statistic
	double	_id(IDE_TTEST2_PROB)				Prob;		   // Probability for t-Test
} tTestMean2SampleResults;

/// Echo 4/5/04 v8.0850 CHANGE_CHISQVAR2SAMPLERESULT_STRUCTURE
// Could not do comparison because no software support chi-square test for variance of 2 sample tTest. In this way, I dicide only use f-test to test the 
// variance for 2 sample ttest.
/** >Statistics>Hypothesis Testing
	Struct to hold f-test result.
*/
typedef struct tagFVarResults
{
	int		_id(IDE_F_DOF_NUM)			FDOFNum;	   // Degrees of Freedom(Numerator) for F test for equality of variance
	int		_id(IDE_F_DOF_DEN)			FDOFDen;	   // Degrees of Freedom(Denominator) for F test for equality of variance
	double  _id(IDE_F_VALUE)			FValue;		   // F test statistic
	double  _id(IDE_F_PROB)				FProb;		   // Probability for F-Test
} FVarResults;

// End Echo 4/5/04 v8.0850 CHANGE_CHISQVAR2SAMPLERESULT_STRUCTURE

/// Echo 4/6/04 v8.0851 ADD_CHISQVAR2SAMPLERESULT_STRUCTURE
// We should add it for now and see what beta testers say...IMSL is pretty trustworthy and it is always easy to remove at last minute but difficult to add.
typedef struct tagChiSqVar2SampleResults
{
	int		_id(IDE_CHISQ2_DOF)				ChiSqDOF;	   // Degrees of Freedom for Chi-Square test
	double	_id(IDE_CHI_SQ2_VALUE)		ChiSqValue;	   // Chi-Square test statistic
	double	_id(IDE_CHISQ2_PROB)				ChiSqProb;	   // Probability for Chi-square test	
} ChiSqVar2SampleResults;
/// End Echo 4/6/04 v8.0851 ADD_CHISQVAR2SAMPLERESULT_STRUCTURE

typedef struct tagPowerResults
{
	double		_id(IDE_POWERS_ALPHA)		Alpha;	   	//Alpha of the hypothesis test
	double	_id(IDE_POWERS_SAMPSIZE)		SampleSize;	//Given Sample size
	double	_id(IDE_POWERS_POWER)			Power;	   // Power values
} PowerResults;

typedef struct tagSAMPResults
{
	double	_id(IDE_SAMPLESIZE_ALPHA)			Alpha;	   	//Alpha of the hypothesis test
	double	_id(IDE_SAMPLESIZE_POWER)			Power;	   // Power values
	double	_id(IDE_SAMPLESIZE_SAMPSIZE)		SampleSize;	//Given Sample size
} SAMPResults;

//#endif // !__AFX_H__	///Danice 4/5/04 v8.0850 TWO_SAMPLE_TTEST_NEED
// *** End Structures for t-Tests ***

// *** Begin Structures for Normality-Tests ***
/** >Statistics>Normality Test
*/
typedef struct tagNormTestResults
{
	int			_id(IDE_NORM_DOF)				DOF;	    // Degrees of Freedom for Normality test
	double		_id(IDE_NORM_TEST_STAT)		TestStat;		// Normality test statistic
	double		_id(IDE_NORM_PROB)				Prob;	    // Probability for Normality test
} NormTestResults;

///Zeck 07/29/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
typedef struct tagNormTestResults2
{
	double		_id(IDE_NORM_TEST_STAT)		TestStat;		// Normality test statistic
	double		_id(IDE_NORM_PROB)				Prob;	    // Probability for Normality test
} NormTestResults2;

typedef struct tagChenShapiroTestResults
{
	double		_id(IDE_NORM_TEST_STAT)		TestStat;		// Chen Shapiro test statistic
	double		_id(IDE_CHEN_CRI_VAL_10)		CriStat10;	// 10% critical value 
	double		_id(IDE_CHEN_CRI_VAL_5)		CriStat5;		// 5% critical value
	double		_id(IDE_CHEN_CRI_VAL)		CriStat;		// Critical value at given level

} ChenShapiroTestResults;

///END NORMALITY_TEST_ADD_THREE_MORE_TESTS

// *** End Structures for Normality-Tests *** 

// *** Begin Structures for One-Way ANOVA ***
/// Jean 05/06/04 MODIFY_DEFINE_STRUCTURE
/*
//---Echo 5/6/04 The structure should be used in both OC and VC. so I comment the #ifndef
//#ifndef _MSC_VER	// ---CPY 4/7/04

typedef struct tagANOVADescStats
{
	vector<int>	_id(IDE_ANOVA_GROUP_SIZES)		Ns;		// Sample size for each group
	vector		_id(IDE_ANOVA_GROUP_MEANS)		Means;	// Mean of the sample for each group
	vector		_id(IDE_ANOVA_GROUP_SDS)		SDs;	// Standard deviation of the sample for each group
	vector		_id(IDE_ANOVA_GROUP_SEMS)		SEMs;	// Standard error of the sample mean for each group
} ANOVADescStats;

//#endif // _MSC_VER	// ---CPY 4/7/04
*/
//MSC_VER can't use vector
typedef struct tagANOVADescStats
{
	int			_id(IDE_ANOVA_GROUP_SIZE)		N;		// Sample size for each group
	double		_id(IDE_ANOVA_GROUP_MEAN)		Mean;	// Mean of the sample for each group
	double		_id(IDE_ANOVA_GROUP_SD)			SD;		// Standard deviation of the sample for each group
	double		_id(IDE_ANOVA_GROUP_SEM)		SEM;	// Standard error of the sample mean for each group
} ANOVADescStats;

//---Echo 4/7/04 
typedef struct tagANOVAStats
{
	double		_id(IDE_ANOVA_RSQ)		RSQ;		// The proportion of variability accounted for the model 
	double		_id(IDE_ANOVA_COV)		COV;		// Coefficient of vairation
	double		_id(IDE_ANOVA_MSESQ)	MSESQ;		// The square root of the Mean Square of Error
	double		_id(IDE_ANOVA_MEAN)		Mean;		// Mean of total
} ANOVAStats; 
//---

//---Echo 5/15/04
/// Iris 10/08/04 Update IDs
/// Max 03/13/05 ADD_STATISTIC_FOR_MEAN_COMPARISON
typedef struct tagMeanCompStats
{
	int			_id(IDE_ANOVA_INDEXCOMP) IndexComp;	//Order of comparison 
	double		_id(IDE_ANOVA_MEANDIFF)	MeanDiff;	//Difference of means of two Samples 
	double		_id(IDE_ANOVA_SEM)		SEM;		//Standard errors of difference of means
	/// Max 11/11/05 ADD_DOF_STATISTIC_FOR_MEAN_COMPARISON
	double		_id(IDE_ANOVA_DOF)		DOF;		//Degress of freedom
	/// End ADD_DOF_STATISTIC_FOR_MEAN_COMPARISON
	double		_id(IDE_ANOVA_STAT)		Stat;		//Statistic for test of difference of means
	double		_id(IDE_ANOVA_PROB)		Prob;		//Probabilities for test of difference of means
	double		_id(IDE_ANOVA_ALPHA)	Alpha;		//Significance level based on the test method 
	long		_id(IDE_ANOVA_SIG)		Sig;		//Indicator shows whether difference of means is significant
///Kevin 09/01/05 CHANGE_STATISTICS_NAME
	//double		_id(IDE_ANOVA_LCI)		LCI;		//Lower confidence limits for difference of means (Holm tests do not provide confidence intervals.)
	//double		_id(IDE_ANOVA_UCI)		UCI;		//Upper confidence limits for difference of means (Holm tests do not provide confidence intervals.)
	double		_id(IDE_ANOVA_LCL)		LCL;		//Lower confidence limits for difference of means (Holm tests do not provide confidence intervals.)
	double		_id(IDE_ANOVA_UCL)		UCL;		//Upper confidence limits for difference of means (Holm tests do not provide confidence intervals.)
///End CHANGE_STATISTICS_NAME
} MeanCompStats;
/*
typedef struct tagMeanCompStats
{
	double		_id(IDE_ANOVA_MEANDIFF)	MeanDiff;	//Difference of means of two Samples 
	double		_id(IDE_ANOVA_SEM)		SEM;		//Standard errors of difference of means
	double		_id(IDE_ANOVA_PROB)		Prob;		//Probabilities for test of difference of means
	double		_id(IDE_ANOVA_LCI)		LCI;		//Lower confidence limits for difference of means
	double		_id(IDE_ANOVA_UCI)		UCI;		//Upper confidence limits for difference of means
} MeanCompStats;
*/
/// END ADD_STATISTIC_FOR_MEAN_COMPARISON
//---  

// *** End Structures for One-Way ANOVA ***


// *** Begin Structures for Two-Way ANOVA ***
typedef struct tagANOVA2DescStats
{
	int			_id(IDE_ANOVA2_SIZE)		N;			// Sample size for each group
	double		_id(IDE_ANOVA2_MEAN)		Mean;		// Mean of the sample for each group
	double		_id(IDE_ANOVA2_SD)			SD;			// Standard deviation of the sample for each group
	double		_id(IDE_ANOVA2_SEM)			SEM;		// Standard error of the sample mean for each group
	double		_id(IDE_ANOVA2_VAR)			VAR;		// Variance of each group
	int			_id(IDE_ANOVA2_MISS)		Missing;	// Number missing in each group
	int			_id(IDE_ANOVA2_NONMISS)		NonMissing; // Number nonmissing in each group
} ANOVA2DescStats;

typedef struct tagANOVA2Table
{
	int			_id(IDE_ANOVA2TABLE_DOF)		DOF;	// Degree of freedom
	double		_id(IDE_ANOVA2TABLE_SSQ)		SSq;	// Sum of Squares
	double		_id(IDE_ANOVA2TABLE_MEANSQ)		MeanSq;	// Mean Square
	double		_id(IDE_ANOVA2TABLE_FVALUE)		FValue;	// F value
	double		_id(IDE_ANOVA2TABLE_PVALUE)		PValue;	// P value
} ANOVA2Table;
// *** End Structures for Two-Way ANOVA ***

// *** Begin Structures for Survival Analysis ***
/** >Statistics>Survival Analysis
*/
typedef struct tagSAEstim
{
	double		_id(IDE_SURVANAL_TIME)		Time;	// Ordered distinct failure times.
	int			_id(IDE_SURVANAL_STATUS)	Status; // Survival Status
	double		_id(IDE_SURVANAL_SURV)		Surv;	// Kaplan-Meier estimate of Survival Probability
	double		_id(IDE_SURVANAL_SD)		SD;		// Estimate of the standard deviation of Survival Probability
	int			_id(IDE_SURVANAL_EVENTS)	Events;	// Cumulative Events(Number failed)
	int			_id(IDE_SURVANAL_REMAIN)	Remain;	// Number remaining
} SAEstim;

typedef struct tagSAQuantEst
{
	double		_id(IDE_SAQUANTEST_PERC)	Perc;	// The 25th, 50th, and 75th Percentiles
	double		_id(IDE_SAQUANTEST_LCL)		LCL;	// Lower confidence limit for percentiles
	double		_id(IDE_SAQUANTEST_UCL)		UCL;	// Upper confidence limit for percentiles
} SAQuantEst;

typedef struct tagSAMeanEst
{
	double		_id(IDE_SAMEANEST_EST)		Estimate;	// The mean estimate
	double		_id(IDE_SAMEANEST_SE)		SE;			//Standard error of mean estimate
	double		_id(IDE_SAMEANEST_LCL)		LCL;		// Lower confidence limit for mean estimate
	double		_id(IDE_SAMEANEST_UCL)		UCL;		// Upper confidence limit for mean estimate
	bool		_id(IDE_SAMEANEST_LIMITED)	Limited;	//Estimated is underestimated if largest observation is censored
} SAMeanEst;

/** >Statistics>Survival Analysis
*/
typedef struct tagSASummary
{
	int			_id(IDE_SURVSUMM_TOTAL)		Total;	// Total number of values
	int			_id(IDE_SURVSUMM_EVENTS)	Events;	// Number of Events
	int			_id(IDE_SURVSUMM_NUMCEN)	NumCen;	// Number of Censored values
	double		_id(IDE_SURVSUMM_PERCEN)	PerCen;	// Percent of Censored values
	
} SASummary;

/** >Statistics>Survival Analysis
*/
typedef struct tagSAFitStats
{
	double		_id(IDE_SAFITSTATS_CRITER)	Criter;		// Value of criterion assessing the overall fit of Cox Hazard model.
	double		_id(IDE_SAFITSTATS_CHISQ)	ChiSq;		// Chi-square statistic for the criterion
	int			_id(IDE_SAFITSTATS_DF)		DOF;		// Degrees of freedom for the criterion
	double		_id(IDE_SAFITSTATS_PROB)	Prob;		// Probability for the criterion
} SAFitStats;

/** >Statistics>Survival Analysis
*/
typedef struct tagSAParaEstim
{
	int			_id(IDE_SAPARAESTIM_DF)		DOF;		// Degrees of freedom of covariate parameter
	double		_id(IDE_SAPARAESTIM_PARAES)	ParaEst;	// Covariate parameter estimate
	double		_id(IDE_SAPARAESTIM_SE)		SE;			// Standard error of covariate parameter estimate
	double		_id(IDE_SAPARAESTIM_LCL)	LCL;		// Lower confidence limit
	double		_id(IDE_SAPARAESTIM_UCL)	UCL;		// Upper confidence limit
	double		_id(IDE_SAPARAESTIM_CHISQ)	ChiSq;		// Chi-Square value for the covariate parameter
	double		_id(IDE_SAPARAESTIM_PROB)	Prob;		// Probability for the covariate parameter
	double		_id(IDE_SAPARAESTIM_HAZARD)	Hazard;		// Hazard value for the covariate parameter
} SAParaEstim;

typedef struct tagSALifeTbl
{
	double		_id(IDE_LIFETBL_TMLCL)		TmLCL;	//Start time of time interval
	double		_id(IDE_LIFETBL_TMUCL)		TmUCL;	//End time of time interval
	int			_id(IDE_LIFETBL_TOTAL)		Total;	//Total number enter the interval 
	int			_id(IDE_LIFETBL_NCENSORED)	NCensored;	//Number of censored observations that fail into the interval
	int			_id(IDE_LIFETBL_NFAILED)	Nfailed;	//Number of death in the interval
	double		_id(IDE_LIFETBL_NRISK)		NRisk;	//Number exposed to the risk (effective sample size) in the interval
	double		_id(IDE_LIFETBL_PROPSURV)	PropSurv;	//Proporting surviving in the interval
	double		_id(IDE_LIFETBL_PROPFAIL)	PropFail;	//Proporting failed in the interval
	double		_id(IDE_LIFETBL_SURV)		Surv;	//Estimate of the survival function at the beginning of the interval
	double		_id(IDE_LIFETBL_FAIL)		Fail;	//Estimate of the cumulative distribution function of the failure time at the beginning of the interval
	double		_id(IDE_LIFETBL_SESURV)		SESurv;	//Stand error estimate of the estimated survival function
	double		_id(IDE_LIFETBL_PDF)		PDF;	//Density function estimated at the midpoint of the interval
	double		_id(IDE_LIFETBL_SEPDF)		SEPDF;	//Standard error estimate of the estimated desity
	double		_id(IDE_LIFETBL_HAZARD)		Hazard;	//Hazard rate estimated at the midpoint of the interval 
	double		_id(IDE_LIFETBL_SEHAZARD)	SEHazard;	//Standard error estimate of the estimated hazard 
} SALifeTbl;

// *** End Structures for Survival Analysis ***

// *** Begin Structures for Correlation Coefficient ***
typedef struct tagCorrStats
{
	int			_id(IDE_CORRSTATS_N)		N;		// Number of observations
	double		_id(IDE_CORRSTATS_MEAN)		Mean;	// Mean of each variable
	double		_id(IDE_CORRSTATS_SD)		SD;		// Standard Deviation of each variable
	double		_id(IDE_CORRSTATS_MIN)		Min;	// Minimum number of each variable
	double		_id(IDE_CORRSTATS_MAX)		Max;	// Maximum number of each variable
} CorrStats;
// *** End Structures for Correlation Coefficient  ***

// *** Begin Structures for Power & SampleSize ***
typedef struct tagPowerOpts
{
	double		_id(IDE_POWEROPTS_MEAN1)	Mean1;	// Mean of data points in 1 sample tTest or mean of data1 in 2 Sample tTest
	double		_id(IDE_POWEROPTS_MEAN2)	Mean2;	// Hypothesis test value in 1 sample tTest or mean of data2 in 2 Sample tTest
	double		_id(IDE_POWEROPTS_SD)		SD;		// Pooled Standard Deviation of data points
} PowerOpts;

typedef struct tagANOVAPowerOpts
{
	double		_id(IDE_ANOVAPOWEROPTS_LEVEL)	Level;	// Number of treatments/levels
	double		_id(IDE_ANOVAPOWEROPTS_CSS)		CSS;	// Corrected sum of squares of mean, which is defined as sum((gmean-tmean)^2),that is TSS/n
	double		_id(IDE_ANOVAPOWEROPTS_SD)		SD;		// Square root of the Mean Squared Error (MSE)
} ANOVAPowerOpts;
// *** End Structures for Power & SampleSize ***


// *** Begin Structures for Non-Parameter Hypothesis Analysis ***
typedef struct tagNPHSummary
{
	int			_id(IDE_NPHSUMM_N)			N;		// Number of observations
	double		_id(IDE_NPHSUMM_SD) 		SD;		// Standard Deviation of each group
	double		_id(IDE_NPHSUMM_SE)	 		SE;		// Standard Error of each group
	double		_id(IDE_NPHSUMM_MEDIAN)		Median;	// Median of each group	
	double		_id(IDE_NPHSUMM_MIN)		Min;	// Minimum value of each group
	double		_id(IDE_NPHSUMM_MAX)		Max;	// Maximum value of each group
} NPHSummary;

typedef struct tagNPHRanks
{
	int			_id(IDE_NPHRANKS_N)				N;			// Number of observations
	double		_id(IDE_NPHRANKS_MEANRANK)		MeanRank;	// Mean Rank of Negative and Positive Ranks
	double		_id(IDE_NPHRANKS_SUMRANK)		SumRank;	// Sum Rank of Negative and Positive Ranks
} NPHRanks;

typedef struct tagNPHFreqs
{
	int			_id(IDE_NPHFREQS_N)				N;		// Number of observations
	double		_id(IDE_NPHFREQS_LEMD)			LEMd;	// Number of obs less than median
	double		_id(IDE_NPHFREQS_GTMD)			GTMd;	// Number of obs greater than median
} NPHFreqs;

typedef struct tagNPHStats
{
	double		_id(IDE_NPHSTATS_STAT)			Stat;	// Value of test statistic
	double		_id(IDE_NPHSTATS_Z)				Z;		// Value of approximate Normal test statistic
	double		_id(IDE_NPHSTATS_DOF)			DOF;	// Degree of freedom
	double		_id(IDE_NPHSTATS_PROB) 			Prob;	// Probablity
} NPHStats;

// *** End Structures for Non-Parameter Hypothesis Analysis ***


// *** Begin Structures for ROC Curve ***

typedef struct tagROCArea
{
	double		_id(IDE_ROCAREA_AREA)			Area;	// Area under the ROC curve
	double		_id(IDE_ROCAREA_SE)				SE;		// Standard error
	double		_id(IDE_ROCAREA_PROB) 			Prob;	// Probablity
///Kevin 09/01/05 CHANGE_STATISTICS_NAME
	//double		_id(IDE_ROCAREA_LCI) 			LCI;	// Lower confidence limit
	//double		_id(IDE_ROCAREA_UCI) 			UCI;	// Upper confidence limit
	double		_id(IDE_ROCAREA_LCL) 			LCL;	// Lower confidence limit
	double		_id(IDE_ROCAREA_UCL) 			UCL;	// Upper confidence limit
///End CHANGE_STATISTICS_NAME
} ROCArea;

typedef struct tagROCCuv
{
	double		_id(IDE_ROCCUV_THRES)			Thres;	//Cutoff values for positive is greater than or equal to 
	double		_id(IDE_ROCCUV_TPP)				TPP;	//True positive probality
	double		_id(IDE_ROCCUV_FPP) 			FPP;	//False positive probability 
} ROCCuv;

// *** End Structures for ROC Curve ***


// *** Begin Structures for Diagnostic redisuals computation ***

typedef struct tagDiagResid
{
	double		_id(IDE_DIAGRESID_RESID)		Resid; //Diagnostic redisuals(standized residuals/studentized residuals/deleted studuentized residuals)
	double		_id(IDE_DIAGRESID_COOK)			Cook; //Cook's D statistic
	double		_id(IDE_DIAGRESID_ATKINSON)		Atkinson;//Atkinson's T statistic
} DiagResid;
// *** End Structures for Diagnostic redisuals computation ***


// *** Begin Structures for Survival Function Comparison ***
/** >Statistics>Survival Analysis
*/
typedef struct tagSFComp
{
	double		_id(IDE_SFCOMP_CHISQ)		ChiSq; //Test Statistic, which has an asymptotic chi-square distribution
	double		_id(IDE_SFCOMP_DF)			DOF; //Degree of freedon
	double		_id(IDE_SFCOMP_PROB)		Prob;//Probability
} SFComp;
// *** End Structures for Survival Function Comparison ***

/// Max 11/11/05 ADD_STRUCTURE_FOR_RM_ANOVA
// *** Begin Structures for RM ANOVA ***

typedef struct tagRMANOVADescStats
{
	//int			_id(IDE_RMANOVA_GROUP_SIZE)		N;		// Sample size for each group
	double		_id(IDE_RMANOVA_GROUP_MEAN)		Mean;	// Mean of the sample for each group
	double		_id(IDE_RMANOVA_GROUP_SEM)		SEM;	// Standard error of the sample mean for each group
	double		_id(IDE_RMANOVA_GROUP_LCL)		LCL;	// Lower confidence limit for group mean
	double		_id(IDE_RMANOVA_GROUP_UCL)		UCL;	// Upper confidence limit for group mean
} RMANOVADescStats;

typedef struct tagRMANOVARow
{
	double	_id(IDE_RMANOVA_SUM_SQUARES)	SSq;			// Sum of squares
	double	_id(IDE_RMANOVA_DOF)			DOF;			// Degrees of freedom
	double	_id(IDE_RMANOVA_MEAN_SQUARE)	MeanSq;			// Mean square
	double	_id(IDE_RMANOVA_FVALUE)			Fvalue;			// F Value
	double	_id(IDE_RMANOVA_PVALUE)			Pvalue;			// P Value
} RMANOVARow;

typedef struct tagRMANOVAOneWay
{
	RMANOVARow	_id(IDE_RMANOVA_TABLE)	AnovaTable[RMANOVAONEWAY_LAST_ITEM];	// ANOVA Table for RM ANOVA one way

} RMANOVAOneWay;

typedef struct tagRMANOVATwoWayOneRV
{
	RMANOVARow	_id(IDE_RMANOVA_TABLE)	AnovaTable[RMANOVATWOWAYONERV_LAST_ITEM];	// ANOVA Table for RM ANOVA two way one repeated factor

} RMANOVATwoWayOneRV;

typedef struct tagRMANOVATwoWayTwoRV
{
	RMANOVARow	_id(IDE_RMANOVA_TABLE)	AnovaTable[RMANOVATWOWAYTWORV_LAST_ITEM];	// ANOVA Table for RM ANOVA two way two repeated factors

} RMANOVATwoWayTwoRV;
// *** End Structures for RM ANOVA ***

typedef struct tagMeanCompMethod
{
	bool _id(IDE_MEANCOMP_TUKEY)		TUKEY;
	bool _id(IDE_MEANCOMP_BONF)			BONF;
	bool _id(IDE_MEANCOMP_DUNNSIDAK)	SIDAK;
	bool _id(IDE_MEANCOMP_FISHLSD)		FISHER;
	bool _id(IDE_MEANCOMP_SCHE)			SCHEFFE;
	bool _id(IDE_MEANCOMP_DUNNE)		DUNNETT;
	bool _id(IDE_MEANCOMP_HOLMBONF)		HOLMBONF;
	bool _id(IDE_MEANCOMP_HOLMSIDAK)	HOLMSIDAK;
} MeanCompMethod;

// *** Begin Structures for Multivariate Test ***

typedef struct tagMultiTestRow
{
	double	_id(IDE_MultiTest_Stat)		Stat;			// Value of multivariate test statistic
	double	_id(IDE_MultiTest_FStat)	FStat;			// Value of F-statistic
	double	_id(IDE_MultiTest_HDOF)		HDOF;			// Hypothesis degrees of freedom
	double	_id(IDE_MultiTest_EDOF)		EDOF;			// Error degrees of freedom
	double	_id(IDE_MultiTest_PVALUE)	Pvalue;			// P Value
} MultiTestRow;

typedef struct tagMultiTestTable
{
	MultiTestRow	_id(IDE_MultiTest_TABLE)	MTestTable[MTEST_LAST_ITEM];	// Multivariate test Table

} MultiTestTable;
// *** End Structures for Multivariate Test ***


// *** Begin Structures for Sphericity Test ***

typedef struct tagSphericityStats
{
	double	_id(IDE_SPHERIC_WSTAT)			WStat;			// Mauchly's W test statistic
	double	_id(IDE_SPHERIC_CHISQ)			Chisq;			// Approximate chi-square value
	double	_id(IDE_SPHERIC_DOF)			DOF;			// Degrees of freedom
	double	_id(IDE_SPHERIC_PVALUE)			Pvalue;			// P value

} SphericityStats;

typedef struct tagEpsilonStats
{
	double	_id(IDE_EPSILON_GG)			GGEpsilon;			// Greenhouse-Geisser adjustment
	double	_id(IDE_EPSILON_HF)			HFEpsilon;			// Huynh-Feldt adjustment
	double	_id(IDE_EPSILON_LB)			LBEpsilon;			// Lower-bound adjustment

} EpsilonStats;
// *** End Structures for Sphericity Test ***

/// End ADD_STRUCTURE_FOR_RM_ANOVA


#endif //_STATS_TYPES_H
