/*------------------------------------------------------------------------------*
 * File Name: statEx_utils.h 													*
 * Creation: 11/23/2005, Max													*
 * Purpose: OriginC header file	for Advanced Statistics Functions				*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Bill 05/12/2011 ORG-2700 FUNCTION_TO_NORMALIZE_MATRIX						*
 *	Bill 06/14/2011 ORG-2698 COMMAND_FUNCTION_FOR_MULTIVARIATE_XF				*
 *------------------------------------------------------------------------------*/

#ifndef _STATEX_UTILS_H
#define _STATEX_UTILS_H
 

#include <ocStatEx.h>
#include <stats_types.h>


////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// Define constants, enums, typedefs, and non-localized strings
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

/// Max 11/15/05 ADD_CONST_VARIABLES_FOR_RM_ANOVA
/*
#define MEANS_COMPARISON_METHODS_NUMBER		8	// number of means comparison methods
#define RM_ANOVA_ONE_WAY_TABLE_SIZE			10	// size of row elements for ANOVA table of RM ANOVA one way
#define RM_ANOVA_TWO_WAY_ONE_RV_TABLE_SIZE	15	// size of row elements for ANOVA table of RM ANOVA two way with one RV 
#define RM_ANOVA_TWO_WAY_TWO_RV_TABLE_SIZE	26	// size of row elements for ANOVA table of RM ANOVA two way with two RV
#define MULTIVARIATE_TEST_TABLE_SIZE		4	// size of row elements for Multivariate test table
*/
/// End ADD_CONST_VARIABLES_FOR_RM_ANOVA



////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// Declare function prototypes
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////
//
//				Repeated Measure ANOVA Functions									
//
/////////////////////////////////////////////////////////////////////////////////
// Category last updated by Echo on 03/23/2007
/** >Statistics>Advanced

*/
int  stats_rm_anova_one_way(const MeanCompMethod& nIntervalType,
							const vector &vData,
				  			int nSizeSubject,
							int nGroupSize,
							double dAlpha, 
							int ncntrl,
							RMANOVADescStats* pDescStats, uint nSizeDescStat,
							RMANOVAOneWay *RMANOVATable, 
							MeanCompStats *pMeanCompStats, uint nSizeMeanComp,
							MultiTestTable *RVMultiStats,
							SphericityStats *RVSphericStats,
							EpsilonStats *RVEpsilonStats);

							
// Category last updated by Echo on 03/23/2007
/** >Statistics>Advanced

*/							
int stats_rm_anova_two_way_one_rv(const MeanCompMethod& nIntervalType,
							int iInteraction,
							const vector &vData,
							const vector<int> &vNonRVData,
							int nSizeSubject,
							int nRVGroupSize,
							int nNonRVGroupSize,
							double dAlpha, 
							int ncntrl1,
							int ncntrl2,
							RMANOVADescStats* pRVDescStats, uint nSizeRVDescStat,
							RMANOVADescStats* pNonRVDescStats, uint nSizeNonRVDescStat,
							RMANOVADescStats* pInterDescStats, uint nSizeInterDescStat,
							RMANOVATwoWayOneRV *RMANOVATable, 
							MeanCompStats *pRVMeanCompStats, uint nSizeRVMeanComp,
							MeanCompStats *pNonRVMeanCompStats, uint nSizeNonRVMeanComp,
							MeanCompStats *pFixNonRVMeanCompStats, uint nSizeFixNonRVMeanComp,
							MeanCompStats *pFixRVMeanCompStats, uint nSizeFixRVMeanComp,
							MultiTestTable *RVMultiStats,
							MultiTestTable *InterMultiStats,
							SphericityStats *RVSphericStats,
							EpsilonStats *RVEpsilonStats);							

							
// Category last updated by Echo on 03/23/2007
/** >Statistics>Advanced

*/
int stats_rm_anova_two_way_two_rv(const MeanCompMethod& nIntervalType,
							int iInteraction,
							const vector &vData,
							int nSizeSubject,
							int nGroupSize,
							int nRV1Levels,
							int nRV2Levels,
							double dAlpha, 
							int ncntrl1,
							int ncntrl2,
							RMANOVADescStats* pRV1DescStats, uint nSizeRV1DescStat,
							RMANOVADescStats* pRV2DescStats, uint nSizeRV2DescStat,
							RMANOVADescStats* pInterDescStats, uint nSizeInterDescStat,
							RMANOVATwoWayTwoRV *RMANOVATable, 
							MeanCompStats *pRV1MeanCompStats, uint nSizeRV1MeanComp,
							MeanCompStats *pRV2MeanCompStats, uint nSizeRV2MeanComp,
							MeanCompStats *pFixRV2MeanCompStats, uint nSizeFixRV2MeanComp,
							MeanCompStats *pFixRV1MeanCompStats, uint nSizeFixRV1MeanComp,
							MultiTestTable *RV1MultiStats,
							MultiTestTable *RV2MultiStats,
							MultiTestTable *InterMultiStats,
							SphericityStats *RV1SphericStats,
							SphericityStats *RV2SphericStats,
							SphericityStats *InterSphericStats,
							EpsilonStats *RV1EpsilonStats,
							EpsilonStats *RV2EpsilonStats,
							EpsilonStats *InterEpsilonStats);
							
/// Bill 05/12/2011 ORG-2700 FUNCTION_TO_NORMALIZE_MATRIX
enum
{
	NORMALIZE_NONE,
	NORMALIZE_STD,
	NORMALIZE_STD_N,
};

bool std_matrix(const matrix & m, const int nMethod, matrix &mNormalize);
/// End FUNCTION_TO_NORMALIZE_MATRIX

/// Bill 06/14/2011 ORG-2698 COMMAND_FUNCTION_FOR_MULTIVARIATE_XF
enum
{
	NO_ERROR = 0,
	ERR_MATRIX_EMPTY,
	ERR_SIZE_NOT_MATCH,
	ERR_NAG_f07aec,	
};

int solve_linear_uppertri_equation(const matrix mA, matrix &mB, const bool bTran = false);

int matrix_prod(const matrix mA, const matrix mB, matrix &mC, bool bTranA = false, bool bTranB = false);

bool get_upper_triangular_mat(const int nSize, const vector & vUpper, matrix &mUpper, bool bRow = false );

bool get_sign_eigenvector( const matrix & mV, vector<int> &vnSign );

bool correct_sign_column(const vector<int> & vnSign, matrix &mV);
/// End COMMAND_FUNCTION_FOR_MULTIVARIATE_XF

/// Bill 06/20/2011 ORG-2697 COMMAND_FUNCTION_FOR_MULTIVARIATE_XF
bool get_corr_cov(const matrix & mX, vector &vMean, matrix &mCov, matrix &mCorr);

bool get_corr_cov_pairwise(const matrix mX, matrix &mC, const bool bCorr);

bool get_basic_stat(const matrix mX, vector &vMean, vector &vStd);

bool solve_eigen_from_symmetric_mat( const matrix mX, vector &vR, matrix &mV);

bool normalize_matrix(matrix &mX, vector &vMean = NULL, vector &vStd = NULL);

bool get_remain_index(const vector<uint> vnInd, const uint nLen, vector<uint> &vnR);

bool get_cov_mat_pairwise( const matrix mX, matrix &mCov );

bool subtract_col_mean(const matrix mX, matrix &mXs, vector &vMean = NULL);

bool get_cov_pairwise(const vector vX, const vector vY, double &dCov);

bool get_remain_index(const vector<uint> vnInd, const uint nLen, vector<uint> &vnR);

bool set_rows(const matrix mbSource, matrix & mbTarget, const vector<uint> vIndices);

bool get_corr_from_cov(const matrix mCov, matrix &mCorr);

bool is_output_to_input(string & strIn, string & strOut);

string report_nag_error(LPCSTR lpcszAnalysizeName);
/// End COMMAND_FUNCTION_FOR_MULTIVARIATE_XF							

#endif // _STATEX_UTILS_H
