/*------------------------------------------------------------------------------*
 * File Name: report_utils.h 													*
 * Creation: Echo 5/10/06 														*
 * Purpose: functions for report tree and report data in X-function				*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Echo 6/19/06 NPH_STATS_OUTPUT_ERROR										    *
 *	Echo 3/17/08 QA70-11268 V8.0825 MW_ADD_EXACT_P								*
 *	Kyle 12/18/2008 ADD_MESSAGE_TO_DISCRIBE_SIGNIFICANCE_RESULT_FOR_CORRELEATION_COEFFICIENT
 *	Kyle 01/05/2009 CORR_OUTPUT_MESSAGE_ABOUT_COLUMNS_MISSING_VALUES			*
 *	Folger 04/22/09 QA80-13420 PARETOCHART_XF_BASED_PLOTTING					*
 *	Kyle 07/09/2009 QA80-13902-S1 FREQUENCY_SUPPORT_FRACTION_AND_PERCENT		*
 *	Kyle 06/30/2010 ORG-209 EXPAND_2D_BINNING_TO_SUPPORT_ADDITIONAL_Y_COLUMN	*
 *	Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL						*
 *	Folger 10/09/2010 ORG-1228-P1 FIT_COMPARE_MODEL_EMPTY_FUNCTION_NAME_FOR_LINEAR_AND_POLYNOMIAL
 *	Kyle 05/11/2011 ORG-2755-P1 IMPROVE_2D_BINNING_TO_CARRY_OVER_META_DATA		*
 *	Bill 06/15/2011 ORG-2697 PCA_XF_PLOTTING_CONTROL							*
 *	Kyle 08/15/2011 ORG-1556 DESCRETE_FREQUENCY_AND_FREQ_COUNT_SUPPORT_MULTI_INPUT_RANGE_AND_GROUPING_RANGE
 *	Kyle 08/31/2011 ORG-3676 DISTRIBUTION_CURVES_OUTPUT_FOR_HISTOGRAM_PLOT		*
 *	Folger 05/23/2012 ORG-5767-P1 CLEAR_WORKSHEET_FAILED_TO_UPDATE_OUTPUT_PLOTS	*
 *	Folger 05/25/2012 ORG-5800-P1 MULTIVARIATE_STATS_TOOL_FAILED_TO_RECALCULATE_IF_SOURCE_BOOK_HIDDEN
 *  Junon  06/08/2012 ORG-6336-S1 GRUBBS_TESTS_SHOULD_OUTPUT_RESULTS_TORESULT_SHEET
 *	Tony 09/21/2012 ORG-6846-P1 SET_ALWAYS_UPDATE_ATTRIB_REPORTDATA_AND_SET_SCORES_DATA_CORRECT	*
 *------------------------------------------------------------------------------*/

#ifndef _REPORT_UTILS_H
#define _REPORT_UTILS_H

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// Define constants, enums, typedefs, and non-localized strings
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

#define REPORT_TABLE   100
#define SURV_PLOT_BEGIN	10
#define HYPO_PLOT_BEGIN 20
#define ELLIPSE_SIZE	50	
#define IDST_RESULT_CURVES	0x01010010
#define	ELLIPSE_REPORT_TABLE 	0x01110010
///Junon 06/08/2012 ORG-6336-S1 GRUBBS_TESTS_SHOULD_OUTPUT_RESULTS_TORESULT_SHEET
#define	LINE_STYLE_SOLID 0
///End  GRUBBS_TESTS_SHOULD_OUTPUT_RESULTS_TORESULT_SHEET
enum
{
	ERR_NO_DATA_SELEC = XF_LOCAL_ERR_BEGIN,
};

enum{
	FITCMP_DESC		 	= 100,
	FITCMP_FTEST		= 200,
	FITCMP_AIC			= 300,
	FITCMP_FIT_PARAMS	= 400,
	FITCMP_FIT_STATS	= 500,
	FITCMP_PREFERED_MODEL	= 600,
};

enum
{
	PLOT_MATTRIX_SCATTER			= 0x01,
	PLOT_MATTRIX_ELLIPSE			= 0x02,
	PLOT_MATTRIX_FIT				= 0x04,
	PLOT_MATTRIX_SMOOTH				= 0x08,		///Jasmine 08/06/2012 ORG-6282-S4 PLOT_MATTRIX_SMOOTH_OPTION 
};


#define	TIME_LS_0	_L("Values of time range that are less than zero are excluded in survival analysis")
//#define STATS_NO_CONCLUSION "There is no enough information to draw conclusion."

#define TEST_STATS_TABLE  "Stat|DF|Prob"
#define TEST_STATS_TABLE2	"Stat|Z|Prob"
#define CONF_LEV_TABLE	"Level|LCL|UCL"
#define PSS_TABLE	"Alpha|SS|Power"
#define NPH_FERQ	"N"
#define NPH_RANK	"N|Mean|Sum"
#define NPH_K_SAMP_STATS	_L("Chi-Square|DF|Prob>Chi-Square")
#define NPH_2_SAMP_STATS	_L("Chi-Square|Z|Prob>Chi-Square")
#define SA_SUMMARY	"Total|Events|Censored|Percent"
#define SA_KM_ESTIM	"Time|Status|Survival|SE|Event|Remain"
#define	SA_KM_QUAN	"Percent|Estim|LCI|UCI"
#define	SA_KM_MEAN	"Estim|SE|LCI|UCI"
#define COX_LIKELIHOOD_ESTIM	"LH|Stat|DF|Prob"
#define COX_PARAM_ESTIM	"DF|Estim|SE|Stat|Prob|Hazard"
#define WEIBULL_PARAM_ESTIM "DF|Estim|SE|LCL|UCL"
#define NPH_MEDIAN_FREQ "N|Grt|Les"
#define F_TEST_STATS	"NumDF|DenDF|Prob"
#define WEIBULL_PARAMS "Intcpt|Scale|WScale|WShape"


////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// Declare function prototypes
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

//bool report_tree_create(ReportTree& outRT, LPCSTR lpsczLabel);
bool report_tree_create(ReportTree& outRT, LPCSTR lpsczLabel, LPCTSTR lpcszInputName = NULL);///Jake 06/07/07 REPORT_TREE_SURPORT_MATRIX

bool add_note(ReportTree& rtOut, LPCSTR lpsczNote);
///Sophy 6/15/2012 ORG-5906-P4 MOVE_SET_NOG_DESC_STATS_OPT_TO_STATS_UTILS
//void set_nph_desc_stats_opt(DescStatOptions& stDescOpt, QuantileOptions& stQuanOpt);
///end MOVE_SET_NOG_DESC_STATS_OPT_TO_STATS_UTILS

bool rt_add_nph_descriptive(ReportTree& outRT, const DescStatResults *pDescStats, const QuantileResults *pQuantiles, const vector<string>& vstrGroup, LPCSTR lpsczColLabel = NULL);

void rt_add_sa_summary(ReportTree& outRT, SASummary stSASumStats, const vector vCensored, LPCSTR lpsczLab = NULL, const int nIndex = 0);

string surv_get_long_name(const int iPlotType, const bool bInGroup = false, LPCSTR lpsczGroup = NULL);

bool  surv_update_report_data(ReportData& outData, const double dConf, const vector& vX, const vector& vY, const vector& vErrors, const int nIndex, const vector<string> vstrGroup, const bool bSF, const bool bHazard, const bool bSFCI = false, const bool bOMSF = false, const bool bLSF = false);

bool survival_rd_plotting(const ReportData& rd, vector<string>& vsLabel, ReportTree& rtPlot, const bool bSF, const bool bHazard, const bool bSFCI = false, const bool  bOMSF = false, const bool bLSF = false, const bool bInOneLayer = false, const bool bCox = true);


void rt_add_nph_ranks(ReportBase& outRT, const NPHRanks *Ranks, const vector<string> &vstrGroup, LPCSTR lpsczCols = NULL);

///Echo 6/19/06 NPH_STATS_OUTPUT_ERROR
///Statistic of NPH K Sample and NPH Two Sample is different
//void rt_add_nph_stats(ReportBase& outRT, const NPHStats &Stats, const vector<string> &vstrGroup, const string& strFooter1, const string& strFooter2, const string& strHYPT, const vector<string>& vstrStatsLabels = NULL);
//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
//void rt_add_nph_stats(ReportBase& outRT, const NPHStats &Stats, const vector<string> &vstrGroup, const string& strFooter1, const string& strFooter2, const string& strHYPT, const vector<string>& vstrStatsLabels = NULL, const bool bNPHTwoSample = true, LPCSTR lpsczCols = NULL);
/// Iris 12/21/2011 ORG-4627-S2 ADD_ASYMP_REPORT_FOR_EXACT_CASE
//void rt_add_nph_stats(ReportBase& outRT, const NPHStats &Stats, const vector<string> &vstrGroup, const string& strFooter1, const string& strFooter2, const string& strHYPT, const vector<string>& vstrStatsLabels = NULL, const bool bNPHTwoSample = true, LPCSTR lpsczCols = NULL,double dAlpha=0.05);
void rt_add_nph_stats(ReportBase& outRT, const NPHStats &Stats, const vector<string> &vstrGroup, const string& strFooter1, const string& strFooter2, const string& strHYPT, const vector<string>& vstrStatsLabels = NULL, const bool bNPHTwoSample = true, LPCSTR lpsczCols = NULL,double dAlpha=0.05, double *pAsympVal = NULL);
///End ADD_ASYMP_REPORT_FOR_EXACT_CASE
//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
void rt_add_nph_freq(ReportBase& outRT, const NPHFreqs *Freqs, const vector<string> &vstrGroup, LPCSTR lpsczColLabels = NULL);

void corr_get_data(const Range& r, vector& vData, vector<int>& vLevels, vector<string>& vstrFactors, int& nNumRanges);
///Kyle 01/05/2009 CORR_OUTPUT_MESSAGE_ABOUT_COLUMNS_MISSING_VALUES
//bool corr_get_data(const Range& r, matrix& mData, vector<string>& vstrFactors, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);
bool corr_get_data(const Range& r, matrix& mData, vector<string>& vstrFactors, vector<string>& vstrFactorsMissingVal = NULL, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);
///End CORR_OUTPUT_MESSAGE_ABOUT_COLUMNS_MISSING_VALUES
///Kyle 12/18/2008 ADD_MESSAGE_TO_DISCRIBE_SIGNIFICANCE_RESULT_FOR_CORRELEATION_COEFFICIENT
//void rt_add_corr_coef_table(ReportTree& outRT, matrix mCorr, matrix mSig, vector<string> vstrFactors, string strTableName, string strFuncName, int nBaseID = IDST_REG_CORR_TABLE);
void rt_add_corr_coef_table(ReportTree& outRT, matrix mCorr, matrix mSig, vector<string> vstrFactors, string strTableName, string strFuncName, int nBaseID = IDST_REG_CORR_TABLE, bool bFlag = false);
///End ADD_MESSAGE_TO_DISCRIBE_SIGNIFICANCE_RESULT_FOR_CORRELEATION_COEFFICIENT

void one_sample_test_set_footer(const int tail, const double dTestMean, LPCSTR lpsczStat, const double dProb, string& strHYPT, string& strConclusion, LPCSTR lpsczColLabel = NULL);

void set_ttest_desc_stats_opt(const DescStatOptions& stDescOpt);

bool rt_add_ttest_desc_stats(ReportTree& outRT, const DescStatResults *pDescStats, const vector<string>& vstrGroup);

void set_ttest_stats_to_vector(const tTestMean2SampleResults stTTStats, vector &vTTStats);

void ttest2_set_footer(const int nTail, const double dTestMean, const tTestMean2SampleResults tRes, string& strHYPT, string& strConclusion);

void rt_add_test_stats(ReportBase& outRT, const int nTail, const vector& vTTStats, LPCSTR strHYPT, LPCSTR strConclusion, LPCSTR lpsczColLabel = NULL, vector<string>* pvStatsLabels = NULL);

void rt_add_ttest2_stats(ReportTree& outRT, const int nTail, const vector& vTTStats, const vector& vStatsUnEql, LPCSTR strHYPT, LPCSTR strConclusion);

bool rt_add_conf_intvl(ReportTree& outRT, const vector& vLevels, const vector& vLCLs, const vector& vUCLs, LPCSTR lpsczTest, LPCSTR lpsczColLabel = NULL);

bool rt_add_ttest_conf_intvl(ReportTree& outRT, const vector& vLevels, const vector& vLCLs, const vector& vUCLs);

void rt_add_ttest_power(ReportTree& outRT, const double dSigLevel, const vector& vSampleSizes, const vector& vPowers, int nActlPower, int nHyptPower, LPCSTR lpsczColLabel = NULL);

// add descriptive statistics for all group
bool rt_add_desc_stats(ReportTree& outRT, const DescStatOptions* pDescOpts, const QuantileOptions* pQuanOpts, const DescStatResults *pDescStats, const QuantileResults *pQuantiles, const vector<string>& vstrGroup, const vector<string>& vstrCols = NULL);

// add descriptive statistics for each group
bool rt_add_desc_stats(ReportTree& outRT, const DescStatOptions* pDescOpts, const QuantileOptions* pQuanOpts, const DescStatResults *pDescStats, const QuantileResults *pQuantiles, LPCSTR lpsczGroup, LPCSTR lpsczColLabel = NULL);
///Kyle 01/05/2009 CORR_OUTPUT_MESSAGE_ABOUT_COLUMNS_MISSING_VALUES
//bool rt_add_corr_desc_stats(ReportTree& outRT, const DescStatResults *pDescStats, const QuantileResults *pQuantiles, const vector<string>& vstrGroup);
bool rt_add_corr_desc_stats(ReportTree& outRT, const DescStatResults *pDescStats, const QuantileResults *pQuantiles, const vector<string>& vstrGroup, LPCSTR lpsczFooter = NULL);
///End CORR_OUTPUT_MESSAGE_ABOUT_COLUMNS_MISSING_VALUES

///Junon 27/07/2012 ORG-6336-S1 GRUBBS_TESTS_SHOULD_OUTPUT_RESULTS_TORESULT_SHEET
bool updata_gtest_legend(GraphLayer& gl, double& alphaValue);

void rt_add_test_stats_Outlier(ReportBase& outRT,  const vector& vTTStats, LPCSTR strConclusion, LPCSTR lpsczColLabel, vector<string>& vTTStatsLabels);

bool add_special_point_legend_str(GraphLayer& gl, int& nSpecialPtIndex,int& nSigOutlier);

bool hypo_test_rd_grubbs_plotting(DataRange& drSourceData,	 const ReportData& rd,   ReportTree& rtPlot, int& nSpecialPtIndex, double& nAddHeigth, int& nSigOutlier);

bool hypo_test_rd_Qtest_plotting(const ReportData& rd,   ReportTree& rtPlot, int& nSpecialPtIndex, int& nSigOutlier, double& alphaValue);

bool add_special_point(DataPlot& dp, int& nSpecialPtIndex, int& nSpecialPtColor, int& nSpecialPtShape, int& nSigOutlier);

bool add_line_plot(const ReportData& rd, GraphLayer& gl, int& nPlotIndex, int& nXColumnIndex, int& nYColumnIndex , int& nLineColor = SYSCOLOR_BLACK, int& nLineStyle = LINE_STYLE_SOLID);
///End GRUBBS_TESTS_SHOULD_OUTPUT_RESULTS_TORESULT_SHEET

bool rt_add_friedman_stats(ReportBase& outRT, const NPHStats &Stats, const vector<string> &vstrGroup, const string& strFooter1, const string& strFooter2, const string& strHYPT);

void get_nph_stats(NPHStats &stStats, vector &vNPHStats, bool bNPHTwoSample = false);

/// Iris 12/21/2011 ORG-4627-S2 ADD_ASYMP_REPORT_FOR_EXACT_CASE
int calc_asymp_value(const int nTailType, const double dZVal, double& dAsympVal);
bool is_exact_pvalue(int nNoneZero);
///End ADD_ASYMP_REPORT_FOR_EXACT_CASE

//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
//bool rt_add_sign_test(ReportBase& outRT, NPHFreqs &stSignFreqs, int nTies, NPHStats &stSiStats, vector<string> &vstrGroup, int nTail);
bool rt_add_sign_test(ReportBase& outRT, NPHFreqs &stSignFreqs, int nTies, NPHStats &stSiStats, vector<string> &vstrGroup, int nTail,double dAlpha);
//bool rt_add_signed_rank(ReportBase& outRT, NPHRanks *pWilcRanks, NPHStats &stWilcStats,  vector<string> &vstrGroup, int nTail);
/// Iris 12/17/2011 ORG-4627-S1 PROVIDE_OPTION_TO_REPORT_PVAL_IN_OUTPUT
//bool rt_add_signed_rank(ReportBase& outRT, NPHRanks *pWilcRanks, NPHStats &stWilcStats,  vector<string> &vstrGroup, int nTail,double dAlpha);
/// Iris 12/21/2011 ORG-4627-S2 ADD_ASYMP_REPORT_FOR_EXACT_CASE
//bool rt_add_signed_rank(ReportBase& outRT, NPHRanks *pWilcRanks, NPHStats &stWilcStats,  vector<string> &vstrGroup, int nTail,double dAlpha, int nNoneZero);
bool rt_add_signed_rank(ReportBase& outRT, NPHRanks *pWilcRanks, NPHStats &stWilcStats,  vector<string> &vstrGroup, int nTail,double dAlpha, int nNoneZero, double dAsympVal);
///End ADD_ASYMP_REPORT_FOR_EXACT_CASE
///End PROVIDE_OPTION_TO_REPORT_PVAL_IN_OUTPUT
//bool rt_add_ks_2_sample(ReportBase& outRT, const vector& vFreqs, NPHStats& stKSStats, const vector<string> &vstrGroup, const int nTail);
/// Iris 12/17/2011 ORG-4627-S1 PROVIDE_OPTION_TO_REPORT_PVAL_IN_OUTPUT
//bool rt_add_ks_2_sample(ReportBase& outRT, const vector& vFreqs, NPHStats& stKSStats, const vector<string> &vstrGroup, const int nTail,double dAlpha);
/// Iris 5/21/2012 ORG-5558-P1 REMOVE_ASYMP_VALUE_FOR_SMALL_SAMPLES_IN_KSTEST2_XF
//bool rt_add_ks_2_sample(ReportBase& outRT, const vector& vFreqs, NPHStats& stKSStats, const vector<string> &vstrGroup, const int nTail,double dAlpha, const bool bExact);
bool rt_add_ks_2_sample(ReportBase& outRT, const vector& vFreqs, NPHStats& stKSStats, const vector<string> &vstrGroup, const int nTail,double dAlpha, const bool bExact, bool bRemoveAsympValForSmallSamples = false);
///End REMOVE_ASYMP_VALUE_FOR_SMALL_SAMPLES_IN_KSTEST2_XF
///End PROVIDE_OPTION_TO_REPORT_PVAL_IN_OUTPUT
////bool rt_add_mann_whitney(ReportBase& outRT, NPHRanks *pMannRanks, NPHStats& stMannStats, const vector<string> &vstrGroup, const int nTail);///Echo 3/17/08 QA70-11268 V8.0825 MW_ADD_EXACT_P
//bool rt_add_mann_whitney(ReportBase& outRT, NPHRanks *pMannRanks, NPHStats& stMannStats, const vector<string> &vstrGroup, const int nTail, const bool bExact = false);
bool rt_add_mann_whitney(ReportBase& outRT, NPHRanks *pMannRanks, NPHStats& stMannStats, const vector<string> &vstrGroup, const int nTail,double dAlpha,const bool bExact = false);
//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
bool move_key_to_center(GraphLayer gl);

int get_plot_number(const TreeNode& trGetN);

bool hypo_test_rd_plotting(const ReportData& rd, const vector<string>& vstrLabel, const int iPlotType, ReportTree& rtPlot);

bool one_data_update_report_data(ReportData& outData, const vector& vData, LPCSTR lpsczLabel, const int nIndex = 0);

bool one_data_add_plot(ReportTable& rtPlot, const ReportData& rd, LPCSTR lpsczLabel, const int iPlotType, const int iPosition, const int nIndex = 0);

bool ttest_update_report_data(ReportData& outData, vector& vData,vector& vLevels,vector<string>& vstrLabel);

bool sa_add_note_time_ls_0(ReportTree& rtOut, const vector& vTime);

/**
		Set output worksheet of sample size/power functions
	Parameters:
		wout = [input] worksheet to be output in the functions
		nCalcType = [input] input flag to determine whether sample size or power in the data.	
		nMoreData = [input] Flag to decide whether get vData from strData or vDataCol
		vDataCol = [input] vector containing sample sizes/powers to compute, only avaiable if nMoreData = 1
		dAlpha = [input] Significance level of the test
		strLabel = [input] Label for comment of output worksheet
*/
//void samplesize_worksheet_setting(const Worksheet wout, const int nCalcType, const int nMoreData,  const vector vData, const double dAlpha, const string strLabel);

bool rt_add_pss_res(ReportTree& outRT, const int nCalcType, const double dAlpha, const vector& vSampleSize, const vector& vPower, const string strFootNote);

string pss_get_err_str(const double dLowestPow);

bool	tree_result_table_add_matrix(TreeNode& trTable, const matrix& mat, const vector<string>& vsColHeaders = NULL, const vector<string>& vsRowHeaders = NULL, bool bClearOld = false);

///------ Folger 05/10/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
//string get_column_name(DataRange& drInput, string strRangeName, int index = 0);
//
//bool 	get_fit_data_label(DataRange& drInput, string& strIndep, string& strDep, bool bFixIntercept = false, int nData = 0);
string get_column_name(DataRange& drInput, string strRangeName, int index = 0, int nLabelType = RCLT_INVALID);
bool 	get_fit_data_label(DataRange& drInput, string& strIndep, string& strDep, bool bFixIntercept = false, int nData = 0, int nLabelType = RCLT_INVALID);
///------ End ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS

/// YuI 11/25/06 BIN_WKS_AUTOUPDATE
bool	rd_init_from_stats_tree(ReportTable& rtTable, TreeNode& trStats);
/// end BIN_WKS_AUTOUPDATE

///Kyle 08/31/2011 ORG-3676 DISTRIBUTION_CURVES_OUTPUT_FOR_HISTOGRAM_PLOT
bool rd_init_distribution_curves(const XYRange& rgIn, ReportTable& rtDist, double dBinMin, double dBinMax, double dBinInc);
///End DISTRIBUTION_CURVES_OUTPUT_FOR_HISTOGRAM_PLOT

///Echo 1/18/06 FIT_COMP
bool fitcmp_check_stats(TreeNode& tr);

bool get_regstats_tr(const TreeNode& trRes, TreeNode& tr);

///Echo 10/8/07 v8.0718 FIT_COM_NEW_DESCRP
bool fitcmp_add_descrp(ReportTree& outRT, TreeNode& trRes1, TreeNode& trRes2, TreeNode& trGUI1, TreeNode&trGUI2, bool bSameModel, vector<string>& vstrFitReport = NULL);									
//bool fitcmp_add_descrp(ReportTree& outRT, TreeNode& trRes1, TreeNode& trRes2, TreeNode& trGUI1, TreeNode&trGUI2, bool bSameModel, bool bParam, bool bFitStats);									
///END FIT_COM_NEW_DESCRP

///Iris 12/25/2009 QA81-14890-S2 REPLACE_MODEL1_MODEL2_TO_REAL_FUNCTION_NAME
/*
void fitcmp_add_ftest(ReportTree& outRT, const double dSSR1, const double dSSR2, const double DF1, const double DF2, bool bSameModel);

void fitcmp_add_fit_params(ReportTree& outRT, TreeNode& trRes1, TreeNode& trRes2, bool bSameModel);

void fitcmp_add_fit_stats(ReportTree& outRT, TreeNode& trRes1, TreeNode& trRes2, bool bSameModel);
*/
void fitcmp_add_ftest(ReportTree& outRT, const double dSSR1, const double dSSR2, const double DF1, const double DF2, bool bSameModel, LPCSTR lpcszModel1 = NULL, LPCSTR lpcszModel2 = NULL, string* pstrCmpConclusion = NULL);

void fitcmp_add_fit_params(ReportTree& outRT, TreeNode& trRes1, TreeNode& trRes2, bool bSameModel, LPCSTR lpcszModel1 = NULL, LPCSTR lpcszModel2 = NULL);

void fitcmp_add_fit_stats(ReportTree& outRT, TreeNode& trRes1, TreeNode& trRes2, bool bSameModel, LPCSTR lpcszModel1 = NULL, LPCSTR lpcszModel2 = NULL);

///------ Folger 10/09/2010 ORG-1228-P1 FIT_COMPARE_MODEL_EMPTY_FUNCTION_NAME_FOR_LINEAR_AND_POLYNOMIAL
//string fitcmp_get_model(TreeNode& trRes1);
string fitcmp_get_model(TreeNode& trRes1, TreeNode& trGUI);
///------ End FIT_COMPARE_MODEL_EMPTY_FUNCTION_NAME_FOR_LINEAR_AND_POLYNOMIAL
///End REPLACE_MODEL1_MODEL2_TO_REAL_FUNCTION_NAME

///Iris 12/25/2009 QA81-14890-S3 SET_TABLE_DEFAULT_CLOSE
void set_table_open(TreeNode& trTable, bool bOpen = true);
///End SET_TABLE_DEFAULT_CLOSE


void fitcmp_get_stats_value(TreeNode& trRes1, TreeNode& trRes2, double* dSSR1, double* dSSR2, double* DF1, double* DF2, double* dN1, double* dN2);

//void fitcmp_update_report_tree(TreeNode& trRes1, TreeNode& trRes2, TreeNode& trGUI1, TreeNode&trGUI2,
								//string strReport1, string strReport2, 
								//bool bFtest, bool bAIC,
								//bool bFitParams, bool bFitStats,
								//bool bSameModel,
								//ReportTree& rtRootTable);
///END FIT_COMP

bool get_multi_data_col_label(const DataRange& drInput, LPCSTR lpsczRangeName, vector<string>& vstrColLabels);

bool scatter_matrix_update_report_data(const matrix& mData, const vector<string> vstrGrpLabel, const double dConfLevel, const bool bEllipse, const bool bFit,ReportData& outData, matrix& mFitStats, 
										bool bSmooth = false);	///Jasmine 08/06/2012 ORG-6282-S4 PLOT_MATTRIX_SMOOTH_OPTION 

bool plotmatrix_rd_plotting(ReportTree& rt, const ReportData& rd, const int nLevels, const matrix& mFitStats, const uint nGraphCntrl, const vector<string>& vstrFactors);
///Jasmine 01/10/2011 ORG-4140 CREATE_SCRATTER_MATRIX_IN_GRAPH_FOR_USER_CUSTOMIZE
#define GROUP_REPORT_TABLE					ELLIPSE_REPORT_TABLE - 10
#define GROUP_REPORT_COLUMN					GROUP_REPORT_TABLE + 1

enum{
	DIAGONAL_CELL_NONE = 0,
	//DIAGONAL_CELL_VAR,		///Jasmine 09/18/2012 ORG-6843-S1 MOVE_VAR_OUT_OF_DIADONAL_LIST_AS_CHECKBOX
	DIAGONAL_CELL_BOX,
	DIAGONAL_CELL_HIST
};

bool plotmatrix_rd_plotting_to_one_graph(	const DataRange& dr, 
											const TreeNode& trGetN,
											const int nLevels, 
											const matrix& mFitStats, 
											const uint nGraphCntrl, 
											const vector<string>& vstrFactors,
											GraphPage& gp,
											int& nRows, 
											int& nCols,
											bool bDataNumChange);	///Jasmine 08/07/2012 ORG-4140-P2 ONLY_REPLOT_WHEN_DATA_NUM_CHANGE
///End CREATE_SCRATTER_MATRIX_IN_GRAPH_FOR_USER_CUSTOMIZE

///------ Folger 04/22/09 QA80-13420 PARETOCHART_XF_BASED_PLOTTING
///Kyle 07/09/2009 QA80-13902-S1 FREQUENCY_SUPPORT_FRACTION_AND_PERCENT
//int		discrite_frequency_update_report_data(ReportData& rd, const Range& irng, int freq, int perc, int cumul, int sensitive, bool bParetoCht = false);
enum
{
	FREQUENCY_NONE,
	FREQUENCY_IN_FRACTION,
	FREQUENCY_IN_PERCENT,
};
#define FREQ_REPORT_TABLE	0x00000010
enum _DISC_FREQS_RES_ID
{
	_DISC_FREQS_DATA	= 0x00010010,
	_DISC_FREQS_FREQS,
	_DISC_FREQS_PERC,
	_DISC_FREQS_CUMUL_PERC,
	
};
///Kyle 08/15/2011 ORG-1556 DESCRETE_FREQUENCY_AND_FREQ_COUNT_SUPPORT_MULTI_INPUT_RANGE_AND_GROUPING_RANGE
//int		discrete_frequency_update_report_data(ReportData& rd, const Range& irng, int freq, int perc, int cumul, int sensitive, int nDataColType = -1);
int		discrete_frequency_update_report_data(ReportData& rd, const Range& irng, int freq, int perc, int cumul, int sensitive, int nDataColType = -1, int nDataForm = SIDT_INVAR);
///End DESCRETE_FREQUENCY_AND_FREQ_COUNT_SUPPORT_MULTI_INPUT_RANGE_AND_GROUPING_RANGE
///End FREQUENCY_SUPPORT_FRACTION_AND_PERCENT
///------ End PARETOCHART_XF_BASED_PLOTTING

/// Iris 6/25/2009 QA80-13289-S1 CENTRLIZE_CODE_FOR_WIND_ROSE_PLOT
enum{
	two_d_stats_min,
	two_d_stats_max,
	two_d_stats_mean,
	two_d_stats_median,
	two_d_stats_sum,
	two_d_stats_count,
	two_d_stats_freq,
};

///Kyle 05/11/2011 ORG-2755-P1 IMPROVE_2D_BINNING_TO_CARRY_OVER_META_DATA
enum{
	two_d_stats_base_x,
	two_d_stats_base_y,
	two_d_stats_base_specific,
};
///End IMPROVE_2D_BINNING_TO_CARRY_OVER_META_DATA

#define TWO_D_BINNING_REPORT_TABLE		0x00000010
enum
{
	TWO_D_BINNING_X	= 0x00010010,
	TWO_D_BINNING_Y_BEGIN,
};

enum{	
	wind_rose_orientation_invalid = -1,
	wind_rose_orientation_from,
	wind_rose_orientation_to
};

/// Hong 09/09/09 QA90-14287 2DBINNING_SUPPORT_HANDLE_MIN_MAX
//void report_2d_binning(ReportData& rd, const XYRange& dr, 
//						int xbin, double xmin, double xmax, int xstepby, double xinc, double xintervals, int xperiodical, double xperiod, int xoutleft, int xoutright, int xorder,
//						int ybin, double ymin, double ymax, int ystepby, double yinc, double yintervals, int yperiodical, double yperiod, int youtleft, int youtright, int yorder, 
//						int stats, int subcount, MatrixObject& mo = NULL, int nOrientation = wind_rose_orientation_invalid);
///Kyle 06/30/2010 ORG-209 EXPAND_2D_BINNING_TO_SUPPORT_ADDITIONAL_Y_COLUMN
//void report_2d_binning(ReportData& rd, const XYRange& dr, 
//						int xbin, double xmin, double xmax, int xstepby, double xinc, double xintervals, int xperiodical, double xperiod, int xoutleft, int xoutright, int xorder,
//						int ybin, double ymin, double ymax, int ystepby, double yinc, double yintervals, int yperiodical, double yperiod, int youtleft, int youtright, int yorder, 
//						int stats, int subcount, MatrixObject& mo = NULL, int nOrientation = wind_rose_orientation_invalid, int xincludemin = 0, int xincludemax = 0, int yincludemin = 0, int yincludemax = 0);
///Kyle 05/11/2011 ORG-2755-P1 IMPROVE_2D_BINNING_TO_CARRY_OVER_META_DATA
//void report_2d_binning(ReportData& rd, const XYRange& dr, const vector& vZ,
//						int xbin, double xmin, double xmax, int xstepby, double xinc, double xintervals, int xperiodical, double xperiod, int xoutleft, int xoutright, int xorder,
//						int ybin, double ymin, double ymax, int ystepby, double yinc, double yintervals, int yperiodical, double yperiod, int youtleft, int youtright, int yorder, 
//						int stats, int subcount, MatrixObject& mo = NULL, int nOrientation = wind_rose_orientation_invalid, int xincludemin = 0, int xincludemax = 0, int yincludemin = 0, int yincludemax = 0);
void report_2d_binning(ReportData& rd, const XYRange& dr, const vector& vZ, int base, const Range& col,
						int xbin, double xmin, double xmax, int xstepby, double xinc, double xintervals, int xperiodical, double xperiod, int xoutleft, int xoutright, int xorder,
						int ybin, double ymin, double ymax, int ystepby, double yinc, double yintervals, int yperiodical, double yperiod, int youtleft, int youtright, int yorder, 
						int stats, int subcount, MatrixObject& mo = NULL, int nOrientation = wind_rose_orientation_invalid, int xincludemin = 0, int xincludemax = 0, int yincludemin = 0, int yincludemax = 0);
///End IMPROVE_2D_BINNING_TO_CARRY_OVER_META_DATA
///End EXPAND_2D_BINNING_TO_SUPPORT_ADDITIONAL_Y_COLUMN
/// end 2DBINNING_SUPPORT_HANDLE_MIN_MAX

void init_two_binning_tree_show(TreeNode& trGetN);
						
///end CENTRLIZE_CODE_FOR_WIND_ROSE_PLOT

/// Iris 7/08/2009 PLOT_PROB_XF
enum
{
	PLOT_PROB_PP,
	PLOT_PROB_QQ
};

bool probability_plot_report_data(ReportData& rd, const Range& irng, int nOption = PLOT_PROB_PP);
///end PLOT_PROB_XF

/// Iris 7/13/2009 QA80-8440 ADD_PLOT_WEIBULL_XF, moved from kaplanmeier XF
void get_surv_plot_data(const int nSurvivEstim, const SAEstim *pSurvivEstim, vector& vX, vector& vY, vector& vErrors);
///end ADD_PLOT_WEIBULL_XF


struct ResultOptions{
	int	 nMatrixType;
	bool bMean;
	bool bStd;
	bool bCorr;
	bool bEigenValues;
	bool bEigenVectors;
	bool bScores;
	int	 nSelComponentPlotType;
	int  nComponentPlotRangeBegin; // if nSelComponentPlotType is Specify Two Components, this means X axis; or else means component range from.
	int  nComponentPlotRangeEnd; // if nSelComponentPlotType is Specify Two Components, this means Y axis; or else means component range to.
	/// Bill 06/15/2011 ORG-2697 PCA_XF_PLOTTING_CONTROL
	bool bScreeplot;
	bool bLplot;
	bool bSplot;
	bool bBiplot;
	int  nNpc;
	/// End PCA_XF_PLOTTING_CONTROL
};

enum {
	PCA_MATRIX_TYPE_CORR = 0,
	PCA_MATRIX_TYPE_COV
};

enum {
	COMPONENT_PLOT_METHOD_SPECIFY_BY_TWO,
	COMPONENT_PLOT_METHOD_SPECIFY_BY_RANGE,
	COMPONENT_PLOT_METHOD_SPECIFY_BY_XY,	
};

enum
{
	PSA_TABLE_STATS = 100,
	PSA_TABLE_CORR_MATRIX = 200,
	PSA_TABLE_EIGENVALUES = 300,
	PSA_TABLE_EIGENVECTORS = 400,
	PSA_TABLE_SCORES = 500,
	PSA_TABLE_SCREE_PLOT_DATA = 600,
	PSA_TABLE_LOADING_PLOT_DATA = 700,
	
	PSA_TABLE_SCREE_PLOT = 5000,
	PSA_TABLE_LOADING_PLOT = 5100,
	PSA_TABLE_SCORE_PLOT = 5200,
	PSA_TABLE_BIPLOT = 5300,
};

enum {
	EIGENVALUES_EIGEN_VALUES = 0,
	EIGENVALUES_PROPORTION,
	EIGENVALUES_CUMULATIVE,
	EIGENVALUES_CHISQ,
	EIGENVALUES_DOF,
	EIGENVALUES_SIGN_LEVEL,
	
	EIGENVALUES_ITEM_COUNTS
};

void close_table(ReportTable & table); /// Bill 10/10/2011 ORG-4035-S3 CLOSE_TABLE_SO_KEY_INFO_WILL_BE_SHOWN_CLEARLY

void output_pca_plot_data(ReportData& rdplot, const vector<string>& vsDataLongNames, const matrix& mPCAStats, const matrix& mLoadings, const ResultOptions& stOptions);

void output_pca_report_table(ReportTree& rt, ReportData& rdPlot, ReportData& rdScoreData, const Range & irng, const vector<string>& vsDataLongNames, int nNumObsers, int nNumVars, int nNumComponents,
					const ResultOptions& stOptions, const matrix& mStats, const matrix& mCorr, const matrix& mPCAStats, const matrix& mLoadings, bool bOutputToInput, int nInputCols, bool bPairWise, bool bHasMissing, bool bLabel);
					
/// Bill 06/22/2011 ORG-2697 PUT_LABEL_IN_REPORT
//void output_pca_report_data(ReportData& rd, const matrix& mScores, int nNumComponents);
///------ Tony 09/21/2012 ORG-6846-P1 SET_ALWAYS_UPDATE_ATTRIB_REPORTDATA_AND_SET_SCORES_DATA_CORRECT
//void output_pca_report_data(ReportData& rd, const matrix& mInput, const matrix& mScores, vector<string> & vsLongName, bool bOutPutToInput, int nNumComponents, vector<string> & vsScoreLabel, const string & strLabelLongName, const string & strComment);
void output_pca_report_data(ReportData& rd, const matrix& mInput, const matrix& mScores, vector<string> & vsLongName, bool bOutPutToInput, int nNumComponents, int nSelComponentPlotType, vector<string> & vsScoreLabels, const string & strLabelLongName, const string & strComment);
///------ End SET_ALWAYS_UPDATE_ATTRIB_REPORTDATA_AND_SET_SCORES_DATA_CORRECT
/// End PUT_LABEL_IN_REPORT

BOOL	plot_pareto_chart(GraphLayer& gl, DataRange& dr, TreeNode& trGetN, BOOL bFromAutoUpdate);

///------ Folger 05/23/2012 ORG-5767-P1 CLEAR_WORKSHEET_FAILED_TO_UPDATE_OUTPUT_PLOTS
bool report_data_GetDataRange(ReportData& rd, DataRange &dr, int nTableID, int nIDX, int *pnIDY, int nCountIDY = 1);
///------ End CLEAR_WORKSHEET_FAILED_TO_UPDATE_OUTPUT_PLOTS

///------ Folger 05/25/2012 ORG-5800-P1 MULTIVARIATE_STATS_TOOL_FAILED_TO_RECALCULATE_IF_SOURCE_BOOK_HIDDEN
void report_set_merge_cell(Worksheet& wks);
///------ End MULTIVARIATE_STATS_TOOL_FAILED_TO_RECALCULATE_IF_SOURCE_BOOK_HIDDEN

#endif // _REPORT_UTILS_H
