/*------------------------------------------------------------------------------*
 * File Name: process.h															*
 * Creation: DSC 8/8/05															*
 * Purpose: Origin C header	for process											*
 * Copyright (c) OriginLab Corp.	2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _PROCESS_H
#define _PROCESS_H

#include <common.h>
//
#pragma dll(msvcrt, system)

#define _P_WAIT         0
#define _P_NOWAIT       1
#define _OLD_P_OVERLAY  2
#define _P_NOWAITO      3
#define _P_DETACH       4

//#ifdef  _MT
#define _P_OVERLAY      2
//#else
//extern int _p_overlay;
//#define _P_OVERLAY      _p_overlay
//#endif  /* _MT */


/** >Processes
Return:
	If mode=_P_WAIT (synchronous mode), the return value is the exit status of the new process. 
	The exit status is 0 if the process terminated normally. 
	You can set the exit status to a nonzero value if the spawned process specifically calls the exit routine with a nonzero argument. 
	If the new process did not explicitly set a positive exit status, a positive exit status indicates an abnormal exit with an abort or an interrupt.
	
	If mode=_P_NOWAIT (asynchronous mode), the return value is the process handle. 

	A return value of 1 indicates an error (the new process is not started). 
	In this case, errno is set to one of the following values:
		E2BIG Argument list exceeds 1024 bytes
		EINVAL mode argument is invalid
		ENOENT File or path is not found
		ENOEXEC Specified file is not executable or has invalid executable-file format
		ENOMEM Not enough memory is available to execute new process

Parameters:
	mode=[in] Execution mode for calling process:
			_P_WAIT (synchronous) the calling process (origin) will wait untill the called process has exited
			_P_NOWAIT (asynchronous) the calling process and the called process run 
			_P_OVERLAY 
			_P_NOWAITO
	cmdname=[in] Path of file to be executed
	arg0=[in] pointer to 0th argument
	arg2=[in] pointer to 2th argument
	etc...
	NOTE: End the argument list with a NULL argument.

Example:
	int spawn_ex1()//_P_NOWAIT
	{
		// Note: This example requires the correct path to notepad.exe on your computer.
		char cmdname[MAXLINE]="C:\\Windows\\notepad.exe";
		int nProcessID = _spawnl(_P_NOWAIT, cmdname, cmdname, NULL);
		// Note: _spawnl(...) returns after the spawned process is started
		return nProcessID;
	}
	
	
	int spawn_ex2()//_P_WAIT
	{	
		// Note: This example requires the correct path to notepad.exe on your computer.
		char cmdname[MAXLINE]="C:\\Windows\\notepad.exe";
		int nExitStatus = _spawnl(_P_WAIT, cmdname, cmdname, NULL);
		// Note: _spawn1(..) does not return until the spawned process exits.
		return nExitStatus;
	}

Remarks:
	arg0 is the name of the application being spawned.
	You must pass at least one argument, arg0 or argv[0], to the spawned process. Can be NULL.
	By convention, this argument is the name of the program as you would type it on the command line. 
	A different value does not produce an error.
	End the argument list with a NULL argument.

*/
int __cdecl _spawnl(int mode, const char *cmdname, const char *arg0, ...);//Create and execute a new process


/* >Processes
Return:
	The functions return the data output. There is no error return.
Parameters:
	mode=[in] execution mode for calling process:
	cmdname=[in] path of file to be executed
	arg0=[in] pointer to 0th argument
	argn=[in] pointer to nth argument
Remarks:
	The _outp, _outpw, and _outpd functions write a byte, a word, and a double word, respectively, to the
	specified output port. The port argument can be any unsigned integer in the range 0  65,535; databyte
	can be any integer in the range 0  255; and dataword can be any value in the range of an integer, an
	unsigned short integer, and an unsigned long integer, respectively.

int _wspawnl( int mode, const wchar_t *cmdname, const wchar_t *arg0, const wchar_t *arg1, ... const wchar_t *argn, NULL );//Create and execute a new process
*/



#endif //_PROCESS_H