/*------------------------------------------------------------------------------*
 * File Name: Page_Utils.h														*
 * Creation: July 25, 2003														*
 * Purpose: Declare page utility functions										*
 * Copyright (c) OriginLab Corp. 2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *  SY 09/01/2004 QA70-6472 v8.0128 IMPORT_INFO_STORAGE_CLEANUP					*
 *  SY 10/13/2004 v8.0147 IMPORT_WIZARD_CLEANUP									*
 * EJP 01-13-2005 v8.0183 QA70-7210 PCLAMP_IMPORT_DIALOG						*
 * EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC						* 
 *	ML 2/17/2006 INTERACTIVE_CONTROL_MENUS										*
 *	EJP 2006-03-14 v8.0375 SUPPORT_ROI_IN_IMAGE_PROCESSING						*  
 *	EJP 2006-05-22 v8.0414 BASIC_OPERATIONS_FOR_MATOBJ							*
 *	Cheney 06/22/06 ADD_FUNCTIONS_ABOUT_CHECK_COLS_IN_RANGE_WITH_SAME_DATATYPE	*
 *	Cheney 06/23/06 SET_COLS_IN_RANGE_TO_SAME_DATATYPE							*
 *	Cheney 06/23/06 CHECK_EACH_SUBRANGE_SAME_ROW_NUM							*
 *	Jasmine 07/12/06 GET_FOLDER_PAGES_NAME										*
 *	CPY 7/14/06 LEGEND_SET_SHOW_CENTRAL_FUNC									*
 *	Jasmine 08/16/06 ADD_SOME_TEMPLATE_FUNC										*
 *	Jasmine 08/24/06 CONSTRUCT_TEMP_ORG_TREE									*
 *	Sim 08-25-2006 COMMON_FUNC_WKS_EMPTY										*
 *	Arvin 9/25/06 CHECK_HAS_IMAGE												*
 *	Jasmine 10/09/06 SET_STFORMAT_DEFAULT										*
 *	Jasmine 10/17/06 BUILT_IN_TEMPLATE_INI_SYSTEM_FOLDER						*
 *  SY 2006-11-06 v8.0505 ADD_SCALER_OBJECT										*
 *	AW 11/07/06 MORE_WORK_ON_SHOW_TIME_COL										*
 *	Jasmine 11/10/06 QA70-9112 GET_EMBEDDED_GRAPHS								*
 *	Jasmine 11/17/06 GET_ALL_EMBEDDED_GRAPHS_IN_FOLDER							*
 *	Jasmine 11/22/06 REMOVE_TEMPLATE_NODE_IF_FILE_INVALID						*
 *	Jasmine 12/07/06 GET_SET_USER_INFO											*
 *	Hong 12/07//06 FIX_SPARK_LINE_DISAPPEAR										*
 *	Jasmine 12/09/06 CHANGE_1ST_POINT_COLOR_BLUE_TO_RED							*
 *	Max 12/21/06 WORKSHEET_COPY													*
 *	Jasmine 01/08/07 MODIFICATION_GET_SET_USER_INFO								*
 *	Jasmine 01/11/07 OPEN_REPORT_TREE_BROWSER									*
 *	Jasmine 01/18/07 ADD_REPORT_TREE_FILTER_STRING								*
 *	Jasmine 01/19/07 ADD_OPTION_TO_ALLOW_EMPTY_PARAM_VALUE						*
 *	ML 2/26/2007 LAYER_CONTENTS_SETTING_ACTIVE_LAYER_NODE_EXPANDED_OTHER_COLLAPSED_ON_SETTREE
 *  Justin on 03/30/2007 MODIFY_FUNCTION_CATEGORY								*
 *	Jake 04/06/07 ADD_CHECKBOX_FOR_SHOW_LONG_AND_SHORT_NAME						*
 *	Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE			*
 *	Cheney 2007-4-30 ADD_TEMLATE_FOR_PREVIEW_WHEN_MULTI_LAYER					*
 *	Sim 05-09-2007 CHANGE_LABEL_TEXT_STYLE										*
 *	Jasmine 05/11/07 ARRANGE_FROM_BOTTOM_TO_TOP_FOR_ONE_COL						*
 *	Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY							*
 *	Sim 05-21-2007 SET_XF_BAR_NAME_ONLY_WITHOUT_SHOW_DIALOG						*
 *	Sim 05-25-2007 IMPROVE_GET_AND_SET_XF_BAR_NAME								*
 *	Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG				*
 *	Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE									*
 *	Folger 06/06/18 STR_ENABLE_EMBED_ATTRIB										*
 *	Folger 06/20/07 SHEET_BROWSER_BUTTON_INGETN									*
 *	Jasmine 06/25/07 UPDATE_ORGANIZER											*
 *	Sim 06-25-2007 UPDATE_ORGANIZER												*
 *	Folger 06/26/07 ADD_NOTIFY													*
 *	Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER			*
 *	Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE									*
 *	Hong 07/24/07 v8.0666 SUPPORT_UPDATE_ONE_FOR_ALL_LEGEND						*
 *	Hong QA80-10064 v8.0672 LEGEND_ADD_ORDER_OPTION_WHEN_RECONSTRUCT			*
 *	Folger 08/06/07 CHECK_WHETHER_DATARANGE_HAS_PLOTTED_IN_SPECIFIC_GRAPH_LAYER	*
 *	Hong 08/08/07 QA80-10064 FIX_LEGEND_COMBINE_FAIL_KEEP_ORIGIN_ORDER			*
 *	Jasmine 08/08/07 QA80-10193 APPLY_SYSTEM_THEME								*
 *	Folger 08/13/07 CHECK_IF_DATAPLOT_IN_DATARANGE								*
 *	Folger 08/14/07 SUPPORT_GET_DATASHEET_DATAOBJECT_FROM_DATASET				*
 *	Folger 08/22/07 LOAD_SYSTEM_USER_GROUP_TEMPLATE_SEPERATELY					*
 *	Folger 08/23/07 GET_GRAPH_TEMPLATE_PREVIEW_IMAGE_FILES_FULL_NAME			*
 *	Folger 09/25/07 TREAT_SERVER_GROUP_AND_LOCAL_GROUP_SEPARATELY				*
 *	Sim 10-12-2007 QA70-10520 CENTRALIZE_MAKE_PAGE_SHORT_LONG_NAME				*
 *	Folger 11/05/07 IMPROVE_XF_DYNADLG_SHOW_CONTROL								*
 *	Folger 11/07/07 LOCALIZE_DELETE_SYSTEM_FILE_BRANCH							*
 *	Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF				*
 *	Sim 12-07-2007 SAVE_REDRAW_STATUS_WHEN_SET_REDRAW							*
 *	Sim 12-18-2007 SPECIFY_ACTIVE_PAGE_AFTER_XF_WIZ_FINISH						*
 *	Folger 12/25/07 NO_NEED_TO_SPECIFY_SHOW_AND_REDRAW_STATUS					*
 *	Hong 12/27/07 QA80-10625 FIX_EXCEL_EMPTY_SHEET_REPLACE_BY_FOLLOWING_SHEET	*
 *	Sim 01-02-2007 FIX_DETECT_EMPTY_BOOK										*
 *	Folger 01/22/08 INDICATE_WHETHER_XF_EVENT_HANDLE_NEEDED						*
 *	Folger 02/02/08 QA80-11046 REMOVE_MAIN_HEADER_LINE_IN_IMPORT_EXCEL			*
 *	Sim 03-14-2008 ALLOW_DESTROY_ATTACHED_PAGE									*
 *	Folger 07/24/08 BETTER_XF_OPERATION_OUTPUT_COMMENTS							*
 *	RVD 7/30/2008 qa70-11914 SAMPLE_INTERVAL_UNDO								*
 *	Kyle 08/29/08 ADD_UTIL_FUNCTION_FOR_XF_BEFORE_EXECUTE						*
 *	Folger 10/22/08 CHECK_AND_PLOT_MATRIX_OBJECT_IN_GRAPH						*
 *	Sim 10-27-2008 v8.961 QA80-12463-P1-P2 SHOW_REOPEN_REMINDER_MESSAGE_ONLY_WHEN_USER_FORCELY_CLOSE_IT
 *	Hong QA80-12551 v8.0967 FIX_FAIL_REPLOT_SCR_PLOT_WHEN_RESET_TO_FULL_RANGE	*
 *	Sophy 11/21/2008 v8.976 QA80-12591-P3 ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT
 *	Jasmine 11/24/08 v978d QA80-12652 DATASHEET_SCROLL_RANGE_INTO_VIEW			*
 *	Kyle 12/10/2008 ADD_SKIP_AUTO_UPDATE_OPTION_TO_FUNCTION_IS_XF_STARTUP		*
 *	Folger 12/11/08 QA80-12764 v8.0985 MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK
 *	Folger 01/14/09 PAGE_SET_ACTIVE_LAYER_SUPPORT_ACTIVE_LAYER_ONLY				*
 *	Jasmine 01/22/09 REARRANGE_OUTER_CHILD_LAYER								*
 *	Jasmine 01/23/09 PLOT_SETUP_NEED_IMPORTED_FILE_INFO_FROM_SHEET				*
 *	Jasmine 02/04/09 QA80-13028 SHOW_USER_DEFIND_CATEGORY_INSTEAD_OF_BUILT_IN_CATEGORY_WHEN_SAVING
 *	Sophy 2/11/2009 QA80-13020-S1 v8.0976c HIDE_CONTOUR_LINES_FOR_3D_FITTING_RESIDUAL_PLOT_AS_CP_SUGGEST	*
 *	Jasmine 03/19/09 QA80-13295-P1 ADD_VARIABLE_FOR_NEW_POS_AFTER_SCOLL			*
 *  Kyle 03/20/2009 ADD_OPTION_TO_SPECIFY_FORMAT_OF_DATA_PLOT					*
 *  Iris 3/20/2009 QA80-13295-P1B CHANGE_SCROLL_VIEW_FUNC_RETURN_VALUES			*
 *	Hong 03/25/09 QA80-12551 RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
 *	Kyle 03/26/2009 ADD_UTIL_FUNCTION_TO_GET_DESCRIPTION_FROM_XYRANGE			*
 *	Sophy 3/2/2009 ADD_SIMPLER_GRAPHLAYER_ARRANGE_METHOD_FOR_CUSTOMER_USE		*
 *	Kenny 06/25/2009 QA80-12996-P5 CLEAR_OVERLAPPED_RANGE_FOR_SAVING_ANALYSIS_TEMPLATE*
 *	Sim 07-14-2009 QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER		*
 *  Iris 7/14/2009 QA80-13941 SUPPORT_MORE_OPTIONS_FOR_WREPLACE_AND_MREPLACE_XF	*
 *	Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN				*
 *	Folger 08/10/09 GENERAL_COLUMN_COPY_UTILS_NEEDED_IN_OC						*
 *	Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
 *	Folger 11/02/09 QA81-14522 SUPPORT_FIND_REPLACE_STR_IN_LABEL_ROWS			*
 *	Folger 11/05/09 OC_ADDPLOT_MAKE_PLOT_SUPPORT_UNDO							*
 *	Folger 11/17/09 QA81-11105 COPY_COL_SUPPORT_UDLS							*
 *	Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC							*
 *	Sim 12-29-2009 QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL				*
 *	Folger 01/21/09 QA81-14995 GADGET_TOOLS_SHOULD_USE_SAME_WORKSHEET_OUTPUT_NOTATION
 *  Iris 1/25/2010 PARETO_CHAR_ADD_LABEL_PLOT									*
 *	Sophy 1/29/2010 QA80-14995-P2 CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS
 *	Sim 02-02-2010 QA81-15063 ADD_CUSTOM_PROPERTIES_INTO_WKS_INFO_TREE			*
 *	Kyle 03/16/2010 QA80-15208 SLIDESHOW_AND_PPTSLIDE_SUPPORT_EMBEDDED_GRAPHS	*
 *	Folger 04/15/10 QA81-15315 NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL
 *	Kyle 08/05/2010 ORG-723-P1 COPY_PALETTE_INFO_FOR_MO2S_AND_MS2O				*
 *	Folger 08/06/10 ORG-502-P5 CONTEXT_MENU_OF_ADD_DELETE_COL_SHOULD_ONLY_SHOW_IN_GRID_TABLE
 *	Folger 08/20/10 ORG-865-P1 INSERT_VARIABLE_LINKING_FAILED_FOR_VIRTUAL_MATRIX_PLOT
 *	Kyle 09/19/2010 ORG-1007-P1 WDELDUP_IMPROVE_SPEED							*
 *	Folger 09/27/2010 ORG-1151-P1 SAVE_AS_ANALYSIS_TEMPLATE_FAILED_TO_CLEAN_GRAPHS_EMEBEDED_IN_WKS
 *	Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
 *	Folger 10/28/2010 ORG-1311-S2 COLMOVE_SUPPORT_MOVE_COLUMNS_TO_SPECIFIED_INDEX
 *	Folger 11/05/2010 ORG-27 NEW_DIGITIZER_GADGET								*
 *	Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
 *  Iris 3/03/2011 ORG-2368-S1 FIX_ADDED_REDUNDANT_PLOT_TO_LEGEND_IN_NLFIT_PREVIEW
 *	Folger 03/18/2011 ORG-2479-S1 MAKE_QUICKFIT_FOLLOW_GENERAL_GADGETS			*
 *	Bill 03/30/2011 ORG-2531 WANT_XF_TO_MODIFY_EMBED_GRAPH_PROPERTIES			*
 *	Kit 04/13/2011 ORG-2614-P1 ADD_DATAPLOT_FAIL_WHEN_USE_PAGE_LN				*
 *	Folger 05/25/2011 ORG-2944-P1 ORIGIN_RUNTIME_ERROR_WHEN_MULTIPLE_PEAK_FIT_ON_GROUPED_PLOTS
 *	Folger 08/05/2011 ORG-3417-P1 FUNCTION_PLOT_2D_USE_COLUMN_OBJ				*
 *	Folger 09/14/2011 ORG-3616-P7 FAILED_TO_GET_BOOK_SHEET_STRING_FOR_MATRIX_BASED_RANGE
 *	Folger 09/15/2011 ORG-3805-P1 SPECIFY_ROW_FAILED_TO_WORK_IN_BATCH_PROCESS	*
 *	Sim 2011-09-28 ORG-3791 FIX_MULTI_FILE_IMP_STRUCTURE_ONLY_WITH_NEW_SHEET_MODE
 *	Folger 12/30/2011 ORG-4727-P1 CHECK_OPERATION_WHEN_DELETE_WKS_FROM_NAVIGATION_DLG
 *	Bill 12/30/2011 ORG-4740 MULTI_VARIATE_ANALYSIS_SHOULD_NOT_SUPPORT_NONADJACENT_RANGE_INPUT
 *	Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC		*
 *	Zech 03/31/2012 ORG-4284-P3 DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER			*
 *	Zech 06/27/2012 ORG-6078-S1 COL_COPY_SUPPORT_IGNORE_HIDDEN_ROW				*
 *	Folger 08/09/2012 COPYCOL_MASK_SUPPORT										*
 *	Folger 08/14/2012 ORG-6381-S1 DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET		*
 *	Philip 08/23/2012 ORG-6619-P1 GRAPH_BROWSER_INCLUDES_EMBEDDED_GRAPHS_IN_LABELS
 *	Folger 08/31/2012 ORG-6569-P1 GET_XY_RANGE_STRING_LOOSE_DATASET_SUPPORT		*
 *------------------------------------------------------------------------------*/

#ifndef _PAGE_UTILS_H
#define _PAGE_UTILS_H

enum {
	// Filter Type values are saved.  Do not change a Type's value.
	// Put additional filter types before _UNKNOWN.
	// Only special Types, such as _IGNORE, should go after _UNKNOWN.
	FILTER_TYPE_ASCII = 0,
	FILTER_TYPE_BINARY,
	FILTER_TYPE_USERDEFINED,
	FILTER_TYPE_XFUNC, /// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	FILTER_TYPE_UNKNOWN,
	FILTER_TYPE_IGNORE = 100, // use with fuIsApplicable
};

/// Iris 12/18/2006 v8.0527 COMBO_TO_SEL_ALL_PAGES_IN_FOLDER_FOR_EXPORT_PAGE
enum
{
	OPTION_ACTIVE_PAGE = 0,
	OPTION_ALL_IN_ACTIVE_FOLDER,
	OPTION_ALL_RECURSIVE_IN_ACTIVE_FOLDER,
	OPTION_ALL_OPEN_IN_ACTIVE_FOLDER,
	OPTION_ALL_EMBEDDED_IN_ACTIVE_FOLDER,
	OPTION_ALL_IN_OPJ,
	OPTION_SPECIFIED	
};
#define STR_PAGE_LIST_SEPARATOR		'\n'
#define STR_LIST_PAGES_OPTION		"All in Active Folder|All in Active Folder (Recursive)|All in Active Folder (Open)|All in Active Folder (Include Embedded)|All in Project|Specified"
///END COMBO_TO_SEL_ALL_PAGES_IN_FOLDER_FOR_EXPORT_PAGE

/// AW 07/20/06 USING_IW_FILTER_C
/// Hong 8/04/06 USE_BETTER_NAME
//#define STR_FILTER_TYPE_ASCII 		"ImportFilter_ASCII"
//#define STR_FILTER_TYPE_BINARY 		"ImportFilter_Binary"
//#define STR_FILTER_TYPE_USERDEFINED "ImportFilter_UserDefined"
//#define STR_FILTER_TYPE_XFUNC 		"ImportFilter_XF"
#define STR_FILTER_TYPE_ASCII 		"ASCII"
#define STR_FILTER_TYPE_BINARY 		"Binary"
#define STR_FILTER_TYPE_USERDEFINED "User defined"
#define STR_FILTER_TYPE_XFUNC 		"XFunction"
#define STR_FILTER_TYPE_UNKNOWN		"unknow"
/// end USE_BETTER_NAME
/// END USING_IW_FILTER_C

///Cheney 2007-8-27 ADD_HINTS_AND_LOCALIZE_NONEPREVIEW_TEMPLATE
#define STR_NONE_PREVIEW_TEMPLATE	"NonePreview" 
///Cheney 2007-10-24 USE_NEW_NONE_PREVIEW_TEMPLATE_FOR_NLFIT
//#define NLSF_NO_PREVIEW_TEMPLATE	"NonePreviewNLFit"
#define NLSF_NO_PREVIEW_TEMPLATE	STR_NONE_PREVIEW_TEMPLATE
///end USE_NEW_NONE_PREVIEW_TEMPLATE_FOR_NLFIT
///end ADD_HINTS_AND_LOCALIZE_NONEPREVIEW_TEMPLATE

//------Folger 07/17/07 ADD_ENUMERATION_FOR_GRAPH_BROWSER
enum
{
	SELECT_MULTIPLE_PAGES	= 0x00000001,
	SHOW_FOLDERS			= 0x00000002,
	ENABLE_EMBEDED			= 0x00000004,
	//SHOW_LAYOUT				= 0x00000008,
	/// Iris 5/04/2009 SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE
	SORT_PAGE	 			= 0x00000008, 
	FILTER_3D_GRAPH			= 0x00000010,
	///end SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE
	CAN_REMOVE_ALL			= 0x00000020,	///Jasmine 05/11/2012 ORG-4971-S2 ALLOW_REMOVE_ALL_LINKED_GRAPHS
};
//------End ADD_ENUMERATION_FOR_GRAPH_BROWSER

#define IS_FILTER_TYPE(i)		(FILTER_TYPE_ASCII <= (i) && (i) < FILTER_TYPE_UNKNOWN)

/// Iris 8/23/06 QA80-7729 GRAPH_BRWOSER_BUTTON_IN_GETN
//typedef BOOL (*FUNC_HWND_STR_BOOL_LPSTR_BOOL_LPSTR_BOOL)(HWND hWndParent, string& strGraphs, bool bMultiplePages = true, LPCSTR lpcszStartPEpath = NULL, bool bShowFolders = true, LPCSTR lpcszExcludeGraph = NULL, bool bEnableEmbed = true);	///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
//------Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
//typedef BOOL (*FUNC_HWND_STR_BOOL_LPSTR_BOOL_BOOL)(HWND hWndParent, string& strGraphs, bool bMultiplePages = true, LPCSTR lpcszStartPEpath = NULL, bool bShowFolders = true, bool bEnableEmbed = true);	///Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE
//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
//typedef BOOL (*FUNC_HWND_STR_LPSTR_DWORD)(HWND hWndParent, string& strPages, LPCSTR lpcszStartPEpath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED);
/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
//typedef BOOL (*FUNC_HWND_STR_LPSTR_DWORD_INT)(HWND hWndParent, string& strPages, LPCSTR lpcszStartPEpath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED, int nPageType = EXIST_GRAPH);
typedef BOOL (*FUNC_HWND_STR_LPSTR_DWORD_INT)(HWND hWndParent, string& strPages, LPCSTR lpcszStartPEpath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED, int nPageType = EXIST_GRAPH, LPCSTR lpcszFilterFuncName = NULL);
///end FILTER_GRAPH_FUNCTION_SUPPORT
//-------End CONTROL_BROWSE_PAGE_TYPE
//------End CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
#define	STR_EXCLUDE_PAGE_ATTRIB			"Exclude"
#define	STR_MULTI_PAGE_ATTRIB			"Multiple"
#define	STR_PAGE_NAME_INC_LONG_NAME_ATTRIB		"IncLongName"
#define STR_ENABLE_EMBED_ATTRIB "enable_embed"		///Folger 06/06/18 STR_ENABLE_EMBED_ATTRIB
//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
//#define STR_SHOW_LAYOUT_ATTRIB "ShowLayout"			//-----Folger 07/18/07 STR_SHOW_LAYOUT_ATTRIB
#define STR_BROWSE_PAGE_TYPE_ATTRIB		"PageType"
//-------End CONTROL_BROWSE_PAGE_TYPE

///end GRAPH_BRWOSER_BUTTON_IN_GETN

///Folger 06/20/07 SHEET_BROWSER_BUTTON_INGETN
///Jasmine 03/14/11 ORG-2375-P2 EXP_WKS_NEED_BROWSE_REPORT_SHEET
//typedef BOOL (*FUNC_VECTORSTR_DWORD_HWND_BOOL)(vector<string> &vsResult, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect = true);
typedef BOOL (*FUNC_VECTORSTR_DWORD_HWND_BOOL)(vector<string> &vsResult, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect = true, bool bIncludeReportSheet = false);
#define	STR_INCLUDE_REPORT_SHEET_ATTRIB			"IncludeReportSheet"
// Comments last updated by Iris on 07/28/2008, added #
/**#
		Open a dialog to select sheets.
	Parameters:
		hWndParent = [input] The handle of the parent window
		vsResult = [output] the sheets name list
		bMutiSelect = [input] to control the ability that select multiple sheets or only one sheet, default true
		bIncludeReportSheet = [input] to control the list includes report sheet or not, default false
	Return:
		true if success		
*/
//BOOL open_sheet_list_dlg(HWND hWndParent, vector<string> &vsResult, bool bMutiSelect = true);
BOOL open_sheet_list_dlg(HWND hWndParent, vector<string> &vsResult, bool bMutiSelect = true, bool bIncludeReportSheet = false);
///End EXP_WKS_NEED_BROWSE_REPORT_SHEET
///End SHEET_BROWSER_BUTTON_INGETN

/// Iris 1/25/2010 PARETO_CHAR_ADD_LABEL_PLOT, moved from nlsf_utils.h
enum{
	LABEL_X_VAL_GUI = 0,//the label text is going to come from x dataset,
	LABEL_Y_VAL_GUI = 1,//the label text is going to come from y dataset,
	LABEL_ROW_NUM_GUI = 2,//the label text is going to be the row number;
	LABEL_XY_VAL_GUI = 3,//the label text is going to be (x, y)
};
///End PARETO_CHAR_ADD_LABEL_PLOT

/**$
*/
bool get_storage_and_section_names(string& strStorage, string& strSection, LPCSTR lpcszStorageSection);

/// Comments last updated by Joseph on 05/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:info_get_section_(global_function)
*/
bool info_get_section(OriginObject& obj, TreeNode& trSection, LPCSTR lpcszStorageSection);

//Commetnts last updated by Joseph on 2007.8.1
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:info_set_section_(global_function)
*/
bool info_set_section(OriginObject& obj, TreeNode& trSection, LPCSTR lpcszStorageSection);

//Commetnts last updated by Joseph on 2007.8.01
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_get_info_var_value_(global_function)
*/
bool page_get_info_var_value(Page& pg, LPCSTR lpcszVarName, string& strVal, LPCSTR lpcszStorageSection=NULL);

//Commetnts last updated by Joseph on 2007.08.01
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_set_info_var_value_(global_function)
*/
bool page_set_info_var_value(Page& pg, LPCSTR lpcszVarName, LPCSTR lpcszVarVal, LPCSTR lpcszStorageSection=NULL, int* pnPreferNodeType = NULL);

//Commetnts last updated by Joseph on 2007.8.01
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_get_info_var_value_(global_function)
*/
bool page_get_info_var_value(Page& pg, LPCSTR lpcszVarName, double& dVal, LPCSTR lpcszStorageSection=NULL);

//Commetnts last updated by Joseph on 2007.08.01
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_set_info_var_value_(global_function)
*/
bool page_set_info_var_value(Page& pg, LPCSTR lpcszVarName, double dVal, LPCSTR lpcszStorageSection=NULL);

//Commetnts last updated by Joseph on 2007.08.01
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_get_storage_str_(global_function)
*/
bool page_get_storage_str(Page& pg, LPCSTR lpcszName, string &strValue);

//Commetnts last updated by Joseph on 2007.08.01
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_set_storage_str_(global_function)
*/
bool page_set_storage_str(Page& pg, LPCSTR lpcszName, LPCSTR lpcstrValue);

//--- CPY 7/14/06 LEGEND_SET_SHOW_CENTRAL_FUNC
/// Iris 07/19/2007 RELATIVE_CHANGE_SINCE_SUPPORTED_MORE_AUTO_LEGEND_MODE
//enum {ALM_COMMENT, ALM_RANGE, ALM_LONGNAME_UNITS, ALM_PARAM1};
enum {ALM_COMMENT, ALM_RANGE, ALM_LONGNAME_UNITS, ALM_USER_PARAM1, ALM_LONGNAME, ALM_SHORTNAME, ALM_PARAM1, ALM_CUSTOM};
///end RELATIVE_CHANGE_SINCE_SUPPORTED_MORE_AUTO_LEGEND_MODE

#define		GO_LEGEND_NAME		"Legend"

//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:legend_append_plot_(global_function)
*/
bool legend_append_plot(GraphLayer& gl, int nPlot, LPCSTR lpcszExtraFormat = NULL, LPCSTR lpcszSep = NULL); //The seperator string may not be "\r\n" as Iris said, default is "\r\n"

/// Iris 7/05/2012 ORG-5831-P1 FIX_FAIL_TO_UPDATE_SECOND_FITTED_CURVE_WHEN_NLFIT_ON_DOUBLEY_PLOT
/**$
*/
bool check_append_other_layer_dataplot(GraphPage& gp, DataPlot& dpToAdd, int nRefPlotIndex = 0, bool bInsertAfterRef = false, LPCSTR lpcszExtraFormat = NULL, LPCSTR lpcszSep = NULL);
///End FIX_FAIL_TO_UPDATE_SECOND_FITTED_CURVE_WHEN_NLFIT_ON_DOUBLEY_PLOT

/**$
*/
bool legend_delete_plot(GraphLayer& gl, int nPlot);

/**$
*/
int get_page_legend_mode(GraphPage& gp, string* pstrCustomFormat = NULL);

/**$
*/
bool set_page_legend_mode(GraphPage& gp, int nMode, LPCSTR lpcszCustomFormat = NULL);
/**$
*/
bool set_page_legend_auto_update(GraphPage& gp, bool bSet);//----- CPY 8/7/2007 QA70-10175 SET_LEGEND_TEXT_ALSO_MIGHT_NEED_TO_TURN_OFF_AUTO_UPDATE


/// Iris 07/20/2007 IMPROVE_LEGEND_UPDATE, moved from graph_utils
/**$
*/
///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
//string construct_one_legend_LT_text(const GraphObject& goLegend, const GraphLayer& gl, int nPlot, LPCSTR lpcszExtraFormat = NULL);
string construct_one_legend_LT_text(const GraphObject& goLegend, const GraphLayer& gl, int nPlot, LPCSTR lpcszExtraFormat = NULL, int nUnit = -1);
///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
///end IMPROVE_LEGEND_UPDATE

//Commetnts last updated by Joseph on 2007.08.01
/// Hong 07/24/07 v8.0666 SUPPORT_UPDATE_ONE_FOR_ALL_LEGEND
/**$
	determine if Graph Page's legend is "One legend for all"
	Parameters:
		pg = [input]the page to determine
		nLayerIndex = [modify] layer index which contain legend, return -1 if not "One legend for all"
	Return:
		If Graph Page's legend is "One legend for all", then return true, otherwise false.
	Example:
		void  is_page_one_legend_for_all_ex()
		{
			GraphPage gp = Project.Pages();		
			int nIndex;
		    bool bRet = is_page_one_legend_for_all(gp, nIndex);		    
		}
*/
bool is_page_one_legend_for_all(GraphPage& gp, int& nLayerIndex = NULL);
/// end SUPPORT_UPDATE_ONE_FOR_ALL_LEGEND

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:legend_update_(global_function)
*/
/// Hong 07/24/07 v8.0666 SUPPORT_UPDATE_ONE_FOR_ALL_LEGEND
//bool legend_update(GraphLayer& gl, int nLegendMode = -1, bool bCreate = true, bool bReconstruct = true, LPCSTR lpcszCustomFormat = NULL);
/// Hong QA80-10064 v8.0672 LEGEND_ADD_ORDER_OPTION_WHEN_RECONSTRUCT
//bool legend_update(GraphLayer& gl, int nLegendMode = -1, bool bCreate = true, bool bReconstruct = true, LPCSTR lpcszCustomFormat = NULL, bool bOneforAll = false);
/// Iris 3/03/2011 ORG-2368-S1 FIX_ADDED_REDUNDANT_PLOT_TO_LEGEND_IN_NLFIT_PREVIEW
//bool legend_update(GraphLayer& gl, int nLegendMode = -1, bool bCreate = true, bool bReconstruct = true, LPCSTR lpcszCustomFormat = NULL, bool bOneforAll = false, bool bAscending = true);
bool legend_update(GraphLayer& gl, int nLegendMode = -1, bool bCreate = true, bool bReconstruct = true, LPCSTR lpcszCustomFormat = NULL, bool bOneforAll = false, bool bAscending = true, bool bOnlyAppendNewPlots = false);
///End FIX_ADDED_REDUNDANT_PLOT_TO_LEGEND_IN_NLFIT_PREVIEW
/// end LEGEND_ADD_ORDER_OPTION_WHEN_RECONSTRUCT
/// end SUPPORT_UPDATE_ONE_FOR_ALL_LEGEND
//--- end LEGEND_SET_SHOW_CENTRAL_FUNC

/**$
*/
bool	legend_check_remove_invalid_plot(GraphObject& go, vector<uint> &vnExistedPlots = NULL);

/**$
*/
bool	find_remove_plot_in_legend(GraphLayer& gl, int nPlot);

/// Hong 08/08/07 QA80-10064 FIX_LEGEND_COMBINE_FAIL_KEEP_ORIGIN_ORDER
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:legend_combine_(global_function)
*/
bool legend_combine(GraphPage& gp, int nLayerHasLegend = 0, bool bAscending = true);
/// end FIX_LEGEND_COMBINE_FAIL_KEEP_ORIGIN_ORDER

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:gpage_get_plots_(global_function)
*/
int	gpage_get_plots(const GraphPage &pg, TreeNode &tr);
// tree attributes that will be added for additional layer info
#define		STR_LAYER_TYPE_BITS				"LayerTypeBits"
/// ML 2/26/2007 LAYER_CONTENTS_SETTING_ACTIVE_LAYER_NODE_EXPANDED_OTHER_COLLAPSED_ON_SETTREE
//#define		STR_ACTIVE_LAYER			"ActiveLayer"	// attribute in resulting tr if applicable
/// end LAYER_CONTENTS_SETTING_ACTIVE_LAYER_NODE_EXPANDED_OTHER_COLLAPSED_ON_SETTREE
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_active_layer_index_(global_function)
*/
int page_active_layer_index(Page& pg);

// we need to indicate function to be diff from dataset, but there is no such EXIST type in 
// Origin, so we will steal another EXIST const that is not being used
#define EXIST_FUNC_PLOT		EXIST_PLOT

/// Comments last updated by Cloud on 03/20/2007
/**$
*/
int	get_plot_type_info(int nPlotID, int nPageType, DWORD dwTargetLayer, DWORD& dwAuxTypeInfo, DWORD& dwAuxPlotInfo, string& strColPattern);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:add_plots_to_layer_(global_function)
*/
int		add_plots_to_layer(GraphLayer &lay, int nPlotType, LPCSTR lpcszWksName, vector<string> &vsCols, vector<uint> &vpdesig, DWORD dwCntrl = DPEDTVIEW_HIDE_LIMITS);

///Jasmine 12/14/09 QA81-14845-P3 ACCESS_FILE_INFO_WITH_PLOT_NOTATION
#define STR_PLOT_INDEX_ATTRIB			"PlotIndex"
///End ACCESS_FILE_INFO_WITH_PLOT_NOTATION

///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
//same as page_graph_get_info_tree but only get info tree from one plot
bool dataplot_get_info_tree(const DataPlot& dp, TreeNode& trNode);
///End SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK

//Commetnts last updated by Joseph on 2007.08.01
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_graph_get_info_tree_(global_function)
*/
bool page_graph_get_info_tree(GraphLayer gl, TreeNode& trNode);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_get_picture_(global_function)
*/
bool page_get_picture(GraphPageBase& pgSrc, PictureHolder& phDst, LPCSTR lpcszType=NULL, int nRes = 36, bool bSaveInPage = true);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_active_page_(global_function)
*/
Page get_active_page(bool bAllowGraph = true);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_is_active_(global_function)
*/
bool page_is_active(const Page& pg);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_set_active_layer_(global_function)
*/
///------ Folger 01/14/09 PAGE_SET_ACTIVE_LAYER_SUPPORT_ACTIVE_LAYER_ONLY
//bool page_set_active_layer(Page& pg, int nLayer, bool bActivePageOnly = true);
bool page_set_active_layer(Page& pg, int nLayer, bool bActiveLayerOnly = true);
///------ End PAGE_SET_ACTIVE_LAYER_SUPPORT_ACTIVE_LAYER_ONLY

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_get_display_name_(global_function)
*/
///-----Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE
//string page_get_display_name(const Page& pg, bool bShortAndLongName = false);
string page_get_display_name(const PageBase& pg, bool bShortAndLongName = false);
///-----End	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE

/**$
	get page short name from display string that might have both short and long names 
*/
string page_short_name_from_display_name(LPCSTR lpcszDisplayName, int& nType);

/// Comments last updated by Cloud on 03/20/2007
/**# >File Management
*/
bool wkbook_find_import_file(LPCSTR lpcszBook, LPCSTR lpcszSheet, LPCSTR lpcszCol, string&strFileFullPath, double& dFileDate);

/**$
		Put data in tree's data branch into page, this function is used in import
	Parameters:
		pgTarget = the target page
		trImpResults = import result holder, containning all data (file info/header info and datas in channel/subfile)
		bRemoveDataFromTree = after put whether delete data from tree trImpResults
	Returns: 
		TRUE if handle and succeed; FALSE otherwise
*/
bool page_put_tree_data_branch(Page& pgTarget, TreeNode& trImpResults, bool bRemoveDataFromTree = false);

/// SY 09/01/2004 QA70-6472 v8.0128 IMPORT_INFO_STORAGE_CLEANUP
#define IMPTREE_NODE_HEADER "Header"
#define IMPTREE_NODE_SUBHEADER IMPTREE_NODE_HEADER
#define IMPTREE_NODE_DATA	"Data"
#define IMPTREE_NODE_LIST	"LIST"
#define IMPTREE_NODE_FMT	"FMT"
#define IMPTREE_NODE_LOG	"MetaData"
/// Kenny 06/25/2009 QA80-12996-P5 CLEAR_OVERLAPPED_RANGE_FOR_SAVING_ANALYSIS_TEMPLATE, share with VC
//#define IMPTREE_NODE_DATA_RANGE "DataRange"
#define IMPTREE_NODE_DATA_RANGE		IFI_DATA_RANGE_NODE_NAME
/// End QA80-12996-P5 CLEAR_OVERLAPPED_RANGE_FOR_SAVING_ANALYSIS_TEMPLATE
/// EJP 01-13-2005 v8.0183 QA70-7210 PCLAMP_IMPORT_DIALOG
#define IMPTREE_NODE_TIME "Time"
#define IMPTREE_NODE_DATATYPE "DataType"
/// end PCLAMP_IMPORT_DIALOG

/// ML 2/17/2006 INTERACTIVE_CONTROL_MENUS
//#define IFI_BINARY_STORAGE_NAME "Files"
//#define IFI_FILE_NODE_ENUM_NAME "File%d"
/// end INTERACTIVE_CONTROL_MENUS
/**$
*/
int page_ifi_get_node_count(LPCSTR lpcszBook);
/**$
*/
bool page_ifi_get_file_node(LPCSTR lpcszBook, TreeNode& trn, int nIndex);
/**$
*/
// return index into file storage, or -1 if not found
// fill trInfo with a Clone copy of the found info tree
int wkbook_find_import_file_info(LPCSTR lpcszBook, LPCSTR lpcszSheet, LPCSTR lpcszCol, TreeNode& trInfo);
/// end IMPORT_INFO_STORAGE_CLEANUP

///Jasmine 01/23/09 PLOT_SETUP_NEED_IMPORTED_FILE_INFO_FROM_SHEET, move from fu_utils
/**$
*/
///---Sim 03-07-2007 QA80-9435 SUPPORT_RELATIVE_DATA_RANGE
DataRange get_and_check_range(TreeNode& trRangeInfo, string strPg = "");
///---END QA80-9435 SUPPORT_RELATIVE_DATA_RANGE

///---Sim 01-29-2007 MORE_UTILS_FUNCTION
/**$
*/
bool is_relative_range(const DataRange& dr1, const DataRange& dr2);
///---END MORE_UTILS_FUNCTION

/**$
*/
int get_file_info_by_range(TreeNode& trFile, const DataRange& dr, int* pnErrCode = NULL);
///---Sim 2011-09-28 ORG-3791 FIX_MULTI_FILE_IMP_STRUCTURE_ONLY_WITH_NEW_SHEET_MODE
/**$
*/
bool is_imported_files_in_range(const DataRange& dr);
///---END ORG-3791 FIX_MULTI_FILE_IMP_STRUCTURE_ONLY_WITH_NEW_SHEET_MODE
///End PLOT_SETUP_NEED_IMPORTED_FILE_INFO_FROM_SHEET

/// SY 10/13/2004 v8.0147 IMPORT_WIZARD_CLEANUP
// Move from App_Utils.c and change function name GetLayerNumbers to page_get_layer_numbers
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_get_layer_numbers_(global_function)
*/
int page_get_layer_numbers(string& strLayerNumbers);


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_insert_label_(global_function)
*/
bool page_insert_label(Layer& gl, const string& strLabel, LPCSTR lpcszName = NULL, int x = 10, int y = 5);


/**$
*/
int		xvars_init_new_wks_data(WorksheetPage &wkbk, Worksheet &wks, LPCSTR lpcszBook, LPCSTR lpcszSheet, LPCSTR lpcszSourceBook, LPCSTR lpcszSourceSheet, int *pnBookType = NULL);

/**$
*/
BOOL	xvars_init_new_matrix_data(MatrixPage &wkbk, MatrixLayer &matsheet, LPCSTR lpcszBook, LPCSTR lpcszSheet = NULL, LPCSTR lpcszSourceBook = NULL, LPCSTR lpcszSourceSheet = NULL, int *pnBookType = NULL);

/**$
*/
BOOL	make_column_range_string(string &str, const Column& cc, int r1 = 1, int r2 = 0);

/**$
*/
int		xvars_init_new_wks_data(WorksheetPage &wkbk, Worksheet &wks, TreeNode &trData, LPCSTR lpcszSourceBook, LPCSTR lpcszSourceSheet, int *pnBookType = NULL);

/**$
*/
BOOL	xvars_init_new_matrix_data(MatrixPage &wkbk, MatrixLayer &matsheet, TreeNode &trData, LPCSTR lpcszSourceBook = NULL, LPCSTR lpcszSourceSheet = NULL, int *pnBookType = NULL);


/**$
*/
BOOL	data_plot_update_xy_data_range_tree(DataPlot& dp, TreeNode& tr);



/**$
*/
void construct_xyz_data_range_node(TreeNode& tr);

/**$
*/
BOOL is_xyz_data_range_node(TreeNode& tr);

/**$
*/
BOOL	get_book_sheet_info(string &strBookName, string &strSheetName, const TreeNode &trvladata);

/**$
*/
BOOL	get_book_sheet_info(string &strBookName, string &strSheetName, LPCSTR lpcszString);

/**$
*/
BOOL	resolve_active_data_plot(TreeNode& tr);

/**$
*/
bool	parse_one_xyrange_formatted_string(LPCSTR lpcszString, string& strBook, string& strSheet);

/**$
*/
string	_get_column_description(Column col);

/**$
*/
string	_get_column_description(int nColIndex);

/**$
*/
bool	is_Col_str(const string &str);


/**$
*/
string  page_get_layer_names(Page& pg, bool bIncHierarchy = true); 


//---- CPY 12/12/2005 GETNGRAPH_BOX_TEMPLATE_FROM_XF
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_load_(global_function)
*/
bool page_load(GraphPage& pg, LPCSTR lpcszTemplate, DWORD dwClicks = NOCLICK_USE_DEFAULT, bool* pbLoadSystemTheme = NULL);	///Jasmine 08/08/07 QA80-10193 APPLY_SYSTEM_THEME, same logic with ApplySystemThemeToPage	
//----

///Jasmine 08/13/2010 ORG-172-S2 CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL
/**$
*/
bool xf_load_nopreview(PageBase& pgTemp, DWORD dwClicks = OC_PREVIEW_NOCLICK_NOZOOMPAN, bool* pbLoadSystemTheme = NULL);
///End CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL

///Sandy add  2007-6-30 set noclick of page
DWORD get_gp_noclick(GraphPage& gp);

bool set_gp_noclick(GraphPage& gp, const DWORD dwClicks);
///end

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_layer_rect_page_units_(global_function)
*/
bool get_layer_rect_page_units(const GraphLayer& grl, int& nLeft, int& nTop, int& nRight, int& nBottom);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:create_rect_object_(global_function)
*/
GraphObject create_rect_object(GraphLayer grl, double left = 0.3, double top = 0.3, double dx = 0.4, double dy = 0.4);


//---- CPY QA70-7820 6/22/05
/// Comments last updated by Cloud on 03/20/2007
/**$
*/
bool get_wks_col(LPCSTR lpcszDataset, Column& cc, Worksheet& wks);

//------ Folger 08/14/07 SUPPORT_GET_DATASHEET_DATAOBJECT_FROM_DATASET
bool get_datasheet_dataobj(LPCSTR lpcszDataset, DataObject &dataObj, Datasheet &ds);
//------ End SUPPORT_GET_DATASHEET_DATAOBJECT_FROM_DATASET

/// Comments last updated by Cloud on 03/20/2007
/**$
*/
//----Jake 04/06/07 ADD_CHECKBOX_FOR_SHOW_LONG_AND_SHORT_NAME	
bool get_plot_info(int nColDesign, DataPlotStrings& dps, string& strBook, string& strSheet, string& strPlot, string& strLongName, string& strCol = NULL, int nRow = -1, string& strVal = NULL, bool& bRealLongName = false);
//----end ADD_CHECKBOX_FOR_SHOW_LONG_AND_SHORT_NAME
//----

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:dataplot_set_colormap_(global_function)
*/
///Sandy 2007-1-30 MODIFY_SETTING_DEFAULT_TO_SUPPORT_NO_CHANGE
//int dataplot_set_colormap(DataPlot& dp, const vector<double>& vzLevels, const vector<uint>& vzColors, uint ncAbove = SYSCOLOR_GRAY, uint ncBelow = SYSCOLOR_BLACK, bool bContourLines = false, bool bLogScale = false);
/// Iris 02/28/2008 v8.0813 NEW_FUNC_TO_SET_CONTOUR_LINES
//int dataplot_set_colormap(DataPlot& dp, const vector<double>& vzLevels, const vector<uint>& vzColors, uint ncAbove = SYSCOLOR_GRAY, uint ncBelow = SYSCOLOR_BLACK, int nModifyContourLines = -1, int nLogScale = -1);
int dataplot_set_colormap(DataPlot& dp, const vector<double>& vZLevels, const vector<uint>& vnFillColors, uint ncAbove = SYSCOLOR_GRAY, uint ncBelow = SYSCOLOR_BLACK, int nModifyContourLines = -1, int nLogScale = -1, const vector<uint>& vnLineColors = NULL, const vector<uint>& vnLineStyles = NULL, const vector<double>& vLineThickness = NULL);
///end NEW_FUNC_TO_SET_CONTOUR_LINES

/// Iris 02/28/2008 v8.0813 NEW_FUNC_TO_SET_CONTOUR_LINES
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:set_contour_lines_(global_function)
*/
///Sophy 2/11/2009 QA80-13020-S1 v8.0976c HIDE_CONTOUR_LINES_FOR_3D_FITTING_RESIDUAL_PLOT_AS_CP_SUGGEST
//int set_contour_lines(DataPlot& dp, const vector<double>& dLevels, const vector<uint>& vnColors, const vector<uint>& vnStyles = NULL, const vector<double>& vThickness = NULL, bool bRemoveFill = true);
int set_contour_lines(DataPlot& dp, const vector<double>& dLevels, const vector<uint>& vnColors, const vector<uint>& vnStyles = NULL, const vector<double>& vThickness = NULL, const vector<uint>& vnShowLines = NULL, bool bRemoveFill = true);
///end HIDE_CONTOUR_LINES_FOR_3D_FITTING_RESIDUAL_PLOT_AS_CP_SUGGEST
///end NEW_FUNC_TO_SET_CONTOUR_LINES

//---------- CPY 3/39/08 SURFACE_FIT_USE_COLOR_CONTOUR_FOR_SRC_DATA
bool rescale_init_colormap(DataPlot& dp, vector* pz, int nSteps = 16, bool bGrayScale = false);
bool setup_fit_contour(DataPlot& dp, vector& zz, int nColor = SYSCOLOR_BLACK);
///Sophy 2/11/2009 QA80-13020-S1 v8.0976c HIDE_CONTOUR_LINES_FOR_3D_FITTING_RESIDUAL_PLOT_AS_CP_SUGGEST
//bool setup_residual_contour(DataPlot& dp, vector& zz, double irl = 20, double orl = 5, int nInnersteps = 8, int nOutSteps = 20) ; 
bool setup_residual_contour(DataPlot& dp, vector& zz, double irl = 20, double orl = 5, int nInnersteps = 8, int nOutSteps = 20, bool bShowLines = true) ; //Sophy, 2/13/2009 If hide lines, it seems residual not plotted on report graph, so keep it show
///end HIDE_CONTOUR_LINES_FOR_3D_FITTING_RESIDUAL_PLOT_AS_CP_SUGGEST
//----------


#define EXIST_FUNCTION				14
#define EXIST_FOLDER				16
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:add_new_window_(global_function)
*/
string add_new_window(Folder &fld = NULL, int nWinType = EXIST_WKS);
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:add_new_folder_(global_function)
*/
string add_new_folder(Folder &fld = NULL);
/**$ >
		MatrixObject copy function
	Parameters:
		moDest = [output] The Destination MatrixObject
		moSrc =  [input] The Source MatrixObject
	Return:
		return true if copy is success.
	Example:
	
*/
/// EJP 2006-05-22 v8.0414 BASIC_OPERATIONS_FOR_MATOBJ
///	/// EJP 2006-03-14 v8.0375 SUPPORT_ROI_IN_IMAGE_PROCESSING
///	///bool matobj_copy(MatrixObject& moDest, const MatrixObject& moSrc);
///	bool matobj_copy(MatrixObject& moDest, const MatrixObject& moSrc,
///		bool bUseROI = true, vector<point> *pROI = NULL);
///	/// end SUPPORT_ROI_IN_IMAGE_PROCESSING
//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:matobj_copy_(global_function)
*/
///Kyle 08/05/2010 ORG-723-P1 COPY_PALETTE_INFO_FOR_MO2S_AND_MS2O
//bool matobj_copy(MatrixObject& moDest, const MatrixObject& moSrc, bool bUseROI = true, vector<point> *pROI = NULL, bool bAllAttr = true);
bool matobj_copy(MatrixObject& moDest, const MatrixObject& moSrc, bool bUseROI = true, vector<point> *pROI = NULL, bool bAllAttr = true, bool bCopyPal = false);
///End COPY_PALETTE_INFO_FOR_MO2S_AND_MS2O

//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:matobj_move_(global_function)
*/
///Kyle 08/05/2010 ORG-723-P1 COPY_PALETTE_INFO_FOR_MO2S_AND_MS2O
//bool matobj_move(MatrixObject& moSrc, MatrixObject& moDest);
bool matobj_move(MatrixObject& moSrc, MatrixObject& moDest, bool bCopyPal = false);
///End COPY_PALETTE_INFO_FOR_MO2S_AND_MS2O

//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:matobj_move_(global_function)
*/
///Kyle 08/05/2010 ORG-723-P1 COPY_PALETTE_INFO_FOR_MO2S_AND_MS2O
//bool matobj_move(MatrixObject& moSrc, MatrixLayer& mlDest);
bool matobj_move(MatrixObject& moSrc, MatrixLayer& mlDest, bool bCopyPal = false);
///End COPY_PALETTE_INFO_FOR_MO2S_AND_MS2O
/// end BASIC_OPERATIONS_FOR_MATOBJ

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:add_new_layer_(global_function)
*/
string add_new_layer(Folder &fld, string &strPageName, int nLayerType = EXIST_WKS);	///-----Frank 11/14/05 ADD_NEW_LAYER_ON_PAGE

enum {PTL_FOLDER, PTL_PAGE, PTL_LAYER, PTL_OBJ};

///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
enum {
	PT_CTRL_SHOW_FULL_RANGE		= 0x0001, 	//show full range string
	PT_CTRL_INCLUDE_SHORTCUT	= 0x0010,	//show shortcut page		///Jasmine 04/26/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	PT_CTRL_SKIP_HIERARCHY		= 0x0100, 	//skip hierarchy sheet
};
///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
struct ProjectTreeOptions
{
	bool bGetEmbeddedGraph; // get tree from embedded graph pages.
	bool bSortPages;		// sort page list
	bool bFilter3DGraph;	// filter out 3D graphs
	vector<string> vsExcludePages; // the pages want to exclude in project tree
	DWORD dwCtrl;			//PT_CTRL_*, control whether to show full range string in project tree ///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
};

//Commetnts last updated by Joseph on 2007.5.22
/**$
	Add current project to tree. Can be folder, page, layer, column. 
	Parameters:
		tr = [output] store the project info. 
		nLevel = Tree add levele, if equal PTL_PAGE will add the page nPage1 and npage2 special. 
				Values available for this parameter are {PTL_FOLDER, PTL_PAGE, PTL_LAYER, PTL_OBJ}. 
		nPage1 = it will be ignored unless nLevel == PTL_PAGE.if 0, will add all page; else add the page special. 
		nPage2 = it will be ignored unless nLevel == PTL_PAGE and nPage1 is not zero. 
		lpcszStartPEpath = Speficy from which folder to retrieve the project information. 
		stOptions = see struct ProjectTreeOptions.		
	Return:
		true if success, else false. 	
*/
///Jasmine 11/10/06 QA70-9112 GET_EMBEDDED_GRAPHS
//bool get_project_tree(TreeNode& tr, int nLevel = PTL_PAGE, int nPage1 = 0, int nPage2 = 0, LPCSTR lpcszStartPEpath = NULL, bool bGetEmbeddedGraph = false);
bool get_project_tree(TreeNode& tr, int nLevel = PTL_PAGE, int nPage1 = 0, int nPage2 = 0, LPCSTR lpcszStartPEpath = NULL, const ProjectTreeOptions& stOptions = NULL);
///End GET_EMBEDDED_GRAPHS

///Jasmine 12/24/09 QA81-14845-S1 SHOW_SOURCE_DATA_TREE_UNDER_PLOT_NODE
/**$
	Add source data(book, sheet and column/matrix object) of data plot
	Parameters:
		dp = [input] data plot to get tree
		trData = [output] store the source data tree
		dwCtrl = [input] control whether to show full range string in tree
		trDataPlot = [input] plot designation tree
	Return:
		true if success, else false. 
*/
bool get_plot_data_tree(const DataPlot& dp, TreeNode& trData, DWORD dwCtrl, 
						const TreeNode& trDataPlot);	///Jasmine 07/24/2012 ORG-5458-P5 MAKE_PLOT_COLUMNS_SIMILAR_TO_PLOT_DETAIL_DB
///Jasmine 01/18/10 SHARE_CODE_TO_VCOUSOR
/**$
*/
///------ Folger 08/20/10 ORG-865-P1 INSERT_VARIABLE_LINKING_FAILED_FOR_VIRTUAL_MATRIX_PLOT
//bool get_main_dataobj_from_datarange(const DataRange& dr, Datasheet& ds, OriginObject& obj);
bool get_main_dataobj_from_datarange(const DataRange& dr, Datasheet& ds, OriginObject& obj, Array<OriginObject&>& mainObjs = NULL);
///------ End INSERT_VARIABLE_LINKING_FAILED_FOR_VIRTUAL_MATRIX_PLOT
///End SHARE_CODE_TO_VCOUSOR
///End SHOW_SOURCE_DATA_TREE_UNDER_PLOT_NODE

// Comments last updated by Hong on 01/04/06
/**$
*/
int get_page_display_id(int nItemID);

///Jasmine 01/06/10 QA81-14909 WKS_AND_MATRIX_HAVE_NEW_BOOK_AND_COL_ICONS
int get_layer_display_id(int nItemID);
int get_data_object_display_id(int nItemID);
///End WKS_AND_MATRIX_HAVE_NEW_BOOK_AND_COL_ICONS

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:set_show_axis_(global_function)
*/
bool set_show_axis(GraphLayer gl, int nAxis, bool bShow1st=true, bool bShow2nd=false);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_get_image_type_from_type_str_(global_function)
*/
int		page_get_image_type_from_type_str(LPCSTR lpcszType);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:attach_or_create_sheet_(global_function)
*/
///------ Folger 01/21/09 QA81-14995 GADGET_TOOLS_SHOULD_USE_SAME_WORKSHEET_OUTPUT_NOTATION
//bool attach_or_create_sheet(Datasheet& wks, LPCSTR lpcszBookSheetName, int nCreate = CREATE_HIDDEN, bool bMatrixSheet = false);
bool attach_or_create_sheet(Datasheet& wks, LPCSTR lpcszBookSheetName, int nCreate = CREATE_HIDDEN, bool bMatrixSheet = false, BOOL* pbIsNewCreated = NULL);
///------ End GADGET_TOOLS_SHOULD_USE_SAME_WORKSHEET_OUTPUT_NOTATION

///Jasmine 06/02/06
typedef struct
{
	int nXGap;		
	int nYGap;			
	int nLeftMg;			
	int nRightMg;			
	int nTopMg;			
	int nBottomMg;		
} stLayersGridFormat;

int	page_get_layer_count(Page& pg, bool bExcludeLinked = true);
int page_get_layer_count(vector<string>& vsPages, bool bExcludeLinked = true);
bool page_add_to_one_graph(GraphPage& gp, const vector<string> vsPages, bool bKeepOld = true);

/// Iris 01/22/2009 ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH, moved from layermanagement.c
///Kyle 01/08/2009 v8.0994d QA80-12812 SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
#define 	SA_MIN_GAP						2
enum{
	SA_HIDE_OUTER_TITLE			= 0x0001,		// show outer (only left & bottom) titles, always be hide inner titles
	SA_SHOW_INNER_AXIS			= 0x0002,		// show inner axis, if overlap will only show one, otherwise will hide all inner axis if there is no gap,
												// always show outer axis
	SA_SHOW_INNER_TICK_LABEL	= 0x0004,		// show inner tick label if inner axis is shown
												// only one X label and one Y label will be shown
};
void gl_smart_show_object(GraphLayer& gl, const vector<int>& vnAxes, const vector<int>& vnLabels, const vector<int>& vnTitles, const vector<int>& vnMajorTicks = NULL, const vector<int>& vnMinorTicks = NULL, bool bRepaint = false);
///end SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
///end ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH

///Jasmine 02/11/09 SHARE_ERR_MSG_WITH_MERGE_GRAPH
bool arrange_layer_check_spacing(int nRow, int nCol, stLayersGridFormat stFormat, int& nErr);
///End SHARE_ERR_MSG_WITH_MERGE_GRAPH

//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat stFormat);
/// Iris 01/16/2007 v8.0542 REMOVE_AXIS_SCROLLER_BEFORE_MERGE
//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL);///Jasmine 10/09/06 SET_STFORMAT_DEFAULT
/// Iris 01/22/2007 v8.0544 MERGE_GRAPH_NEED_SETUP_PAGE_TO_PORTRAIT
//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL, bool bDelAxisScroll = true);
///Jasmine 02/24/07 BY_DEFAULT_NOT_RESIZE
//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL, bool bPortrait = false, bool bDelAxisScroll = true);
///Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY	
//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL, bool* pbPortrait = NULL, bool bBottomTop = false, bool bDelAxisScroll = true);	///Jasmine 05/11/07 ARRANGE_FROM_BOTTOM_TO_TOP_FOR_ONE_COL
///Jasmine 05/17/07 MOVE_OUT_PORTRAIT_OPTION
//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL, bool* pbPortrait = NULL, bool bBottomTop = false, bool bDelAxisScroll = true, const vector<int>& vnSel = NULL);
///Jasmine 10/31/07 ADD_UNDO_OPTION
//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL, bool bBottomTop = false, bool bDelAxisScroll = true, const vector<int>& vnSel = NULL);
/// Iris 01/22/2009 ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH
//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL, bool bBottomTop = false, bool bDelAxisScroll = true, const vector<int>& vnSel = NULL, bool bUndo = false);
///Jasmine 01/22/09 REARRANGE_OUTER_CHILD_LAYER
//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL, bool bBottomTop = false, bool bDelAxisScroll = true, const vector<int>& vnSel = NULL, bool bLinkToFirstLayer = true, bool bSmartShowObject = false, int nSmartShowObjectType = SA_SHOW_INNER_AXIS, bool bUndo = false);
///Jasmine 01/24/09 bLinkToFirstLayer_SHOULD__BE_OFF_BY_DEFAULT
//bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL, bool bBottomTop = false, bool bDelAxisScroll = true, const vector<int>& vnSel = NULL, bool bLinkToFirstLayer = true, bool bArrangeChild = false, bool bSmartShowObject = false, int nSmartShowObjectType = SA_SHOW_INNER_AXIS, bool bUndo = false);
//Commetnts last updated by Sophy on 6/2/2009
/**$
	The method is too complex, customer is suggested to use graph_arrange_layers
*/
bool page_arrange_layers(GraphPage& gp, int nRow, int nCol, stLayersGridFormat* pstFormat = NULL, bool bReverse = false, bool bDelAxisScroll = true, const vector<int>& vnSel = NULL, bool bLinkToFirstLayer = false, bool bArrangeChild = false, bool bSmartShowObject = false, int nSmartShowObjectType = SA_SHOW_INNER_AXIS, bool bUndo = false);
///End bLinkToFirstLayer_SHOULD__BE_OFF_BY_DEFAULT
///End REARRANGE_OUTER_CHILD_LAYER
///end ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH
///end MERGE_GRAPH_NEED_SETUP_PAGE_TO_PORTRAIT

///Jasmine 01/13/11 ORG-1084 REWRITE_FOR_NEW_FEATURE
/**$
*/
bool page_new_arrange_layers(GraphPage& gp, 
							int nRow, int nCol, 						 
							stLayersGridFormat* pstFormat	= NULL,
							bool bUndo						= false,
							bool bDelAxisScroll 			= false,
							const vector<int>& vnSel		= NULL, 	//if not NULL, only layer with index in vnSel will be arranged in vnSel's order
							bool bLinkToFirstLayer 			= false,
							bool bArrangeChild				= false,	//if true, layer with M_LINK unit will be arranged
							bool bSmartShowObject 			= false,
							int nSmartShowObjectType		= SA_SHOW_INNER_AXIS
							);
///End REWRITE_FOR_NEW_FEATURE

///Sophy 3/2/2009 ADD_SIMPLER_GRAPHLAYER_ARRANGE_METHOD_FOR_CUSTOMER_USE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:graph_arrange_layers_(global_function)
*/
bool graph_arrange_layers(GraphPage& gp, int nRows, int nCols);
///end ADD_SIMPLER_GRAPHLAYER_ARRANGE_METHOD_FOR_CUSTOMER_USE

///Jasmine 09/15/09 QA81-14321 SAVE_SPACING_SETTING_FOR_ARRANGEMENT
/**$
*/
bool load_arrange_spacing_settings(	const GraphPage& gp, int& nCol, int& nRow, 
									int& nXGap, int& nYGap, 
									int& nLeftMargin, int& nRightMargin, int& nTopMargin, int& nBottomMargin);

/**$
*/
bool save_arrange_spacing_settings(	GraphPage& gp, int nCol, int nRow, 
									int nXGap, int nYGap, 
									int nLeftMargin, int nRightMargin, int nTopMargin, int nBottomMargin);
///End SAVE_SPACING_SETTING_FOR_ARRANGEMENT

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_scroll_into_view_(global_function)
*/
bool	wks_scroll_into_view(Worksheet& wks, int nCol, int nOffset = 0, bool bCol = true, bool bCheckInView = true);

///Jasmine 11/24/08 v978d QA80-12652 DATASHEET_SCROLL_RANGE_INTO_VIEW
///Jasmine 03/19/09 QA80-13295-P1 ADD_VARIABLE_FOR_NEW_POS_AFTER_SCOLL
enum{
	SCROLL_TO_TOP 		= -1,
	SCROLL_TO_MIDDLE,
	SCROLL_TO_BOTTOM
};

/// Iris 3/20/2009 QA80-13295-P1B CHANGE_SCROLL_VIEW_FUNC_RETURN_VALUES
enum{
	SCROLL_CHECK_IN_VIEW = -1,  // check already in view, no need do scroll
	SCROLL_FAILED, // sth wrong cause fail to do scroll
	SCROLL_DONE 
};
///end CHANGE_SCROLL_VIEW_FUNC_RETURN_VALUES

/**$
	Parameters:
		r1 and r2 are row index while c1 and c2 are column index. They are 0-offset.
		If both r1(c1) is -1, we will not scroll. 
		Use r1 and r2 to define a range to scroll, r1 = r2 means single row/column.
		r2/c2 = -1 means range is from r1/c1 to the last row/column
				
		nNewPos is one of SCROLL_TO_*
		SCROLL_TO_TOP = scroll r1 to top or c1 to most left
		SCROLL_TO_MIDDLE = scroll the range in the middle of the datasheet if the the whole range can be show, else scroll r1 to top or c1 to most left
		SCROLL_TO_BOTTOM = scroll r2 to bottom or c2 to most right
		
		if bCheckInView =true, and nNewPos = SCROLL_TO_MIDDLE, it scrolls only if not the whole range shows in view
			
*/
//void ds_scroll_into_view(Datasheet& ds, int r1 = -1, int r2 = -1, int c1 = -1, int c2 = -1, bool bCheckInView = true);
/// Iris 3/20/2009 QA80-13295-P1B CHANGE_SCROLL_VIEW_FUNC_RETURN_VALUES
//void ds_scroll_into_view(Datasheet& ds, int r1, int r2, int c1, int c2, int nNewPos = SCROLL_TO_MIDDLE, bool bCheckInView = true);
int ds_scroll_into_view(Datasheet& ds, int r1, int r2, int c1, int c2, int nNewPos = SCROLL_TO_MIDDLE, bool bCheckInView = true);
///end CHANGE_SCROLL_VIEW_FUNC_RETURN_VALUES
///End ADD_VARIABLE_FOR_NEW_POS_AFTER_SCOLL
///End DATASHEET_SCROLL_RANGE_INTO_VIEW

/// this function should NOT be used any more, but should use sheet_find_empty_dataobject instead, keep this function only for old code
// Move from Wks_Utils.c and change function name FindEmptyColumn to wks_find_empty_column
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_find_empty_column_(global_function)
*/
int wks_find_empty_column(Datasheet &wks, int nStartCol=0);
/// Hong 06/28/07 v8.0651 ASCII_SUPPORT_IMPORT_TO_MATRIX_WITH_APPEND_COL
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sheet_find_empty_dataobject_(global_function)
*/
int sheet_find_empty_dataobject(Datasheet& ds, int nStartObj = 0);
/// end ASCII_SUPPORT_IMPORT_TO_MATRIX_WITH_APPEND_COL
/// end IMPORT_WIZARD_CLEANUP

/// Sim 08-25-2006 COMMON_FUNC_WKS_EMPTY
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_sheet_empty_(global_function)
*/
bool is_sheet_empty(Layer &ly);

///---Sim 01-02-2007 FIX_DETECT_EMPTY_BOOK
/**$
*/
bool is_book_empty(Page &pg);
///---END FIX_DETECT_EMPTY_BOOK

//--- CPY 12/25/2007 
/**$
*/
/// Hong 12/27/07 QA80-10625 FIX_EXCEL_EMPTY_SHEET_REPLACE_BY_FOLLOWING_SHEET
//int page_find_empty_sheet(Page& pg);
int page_find_empty_sheet(Page& pg, int nStartIndex = 0);
/// end FIX_EXCEL_EMPTY_SHEET_REPLACE_BY_FOLLOWING_SHEET
//---

//---- CPY 11/3/06 SHEET_IS_EMPTY_IF_NO_COL_MAT_OBJ, change return to bool as I see usage assume it to be bool
/// END COMMON_FUNC_WKS_EMPTY

///---Sim 10-23-2006 SAME_LAYER_FUNCTION
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_same_layer_(global_function)
*/
bool is_same_layer(Layer &ly1, Layer &ly2);
///---END SAME_LAYER_FUNCTION

///Cheney 06/22/06 ADD_FUNCTIONS_ABOUT_CHECK_COLS_IN_RANGE_WITH_SAME_DATATYPE
// Comments last updated by Cheney on 06/22/2006	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:check_cols_in_range_with_same_datatype_(global_function)
*/
bool check_cols_in_range_with_same_datatype(DataRange& dr, int* pType = NULL);
/// end ADD_FUNCTIONS_ABOUT_CHECK_COLS_IN_RANGE_WITH_SAME_DATATYPE

///Cheney 06/23/06 SET_COLS_IN_RANGE_TO_SAME_DATATYPE
// Comments last updated by Cheney on 06/23/2006	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:set_cols_in_range_to_same_datatype_(global_function)
*/
int set_cols_in_range_to_same_datatype(DataRange& dr, int* pType = NULL);
///end SET_COLS_IN_RANGE_TO_SAME_DATATYPE

///Cheney 06/23/06 CHECK_EACH_SUBRANGE_SAME_ROW_NUM
// Comments last updated by Cheney on 06/23/2006	
// Category last updated by Justin on 03/30/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:check_each_subrange_same_row_num_(global_function)
*/
bool check_each_subrange_same_row_num(DataRange& dr);
///end CHECK_EACH_SUBRANGE_SAME_ROW_NUM


//--- CPY QA70-8615-5 7/12/06 REMOVE_COMMENTS_COL_FROM_REPORT
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_set_show_labels_(global_function)
*/
bool wks_set_show_labels(Worksheet& wks, int nLine1 = -1, int nLine2 = -1, int nLine3 = -1, int nLine4 = -1, int nLine5 = -1);
/**$
*/
bool wks_get_show_labels(const Worksheet& wks, vector<int>& vnIDs);

//---- CPY 5/27/07 QA70-9837 GRAPHS_IN_WKS_SHOULD_EXCLUDE_SPARKLINES
///Philip 08/23/2012 ORG-6619-P1 GRAPH_BROWSER_INCLUDES_EMBEDDED_GRAPHS_IN_LABELS
//#define GRAPH_IN_WKS_EXCLUDE_BITS EMBEDGRAPH_IN_LABELS
#define GRAPH_IN_WKS_EXCLUDE_BITS	EMBEDGRAPH_SPARKLINE
///end GRAPH_BROWSER_INCLUDES_EMBEDDED_GRAPHS_IN_LABELS
//----

///---Sim 10-12-2007 QA70-10520 CENTRALIZE_MAKE_PAGE_SHORT_LONG_NAME
string get_page_short_long_name(const PageBase& pg);
///---END QA70-10520 CENTRALIZE_MAKE_PAGE_SHORT_LONG_NAME

///Jasmine 07/12/06 GET_FOLDER_PAGES_NAME
#define PAGE_OPEN 	(PAGE_ACTIVATE + 1)
///---Sim 07-14-2009 QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER
//int get_folder_pages_name(Folder fld, vector<string>& vsGraphs, int nPageType = -1, bool bRecursive = false, int nPageShowState = -1);
//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_folder_pages_name_(global_function)
*/
int get_folder_pages_name(Folder fld, vector<string>& vsGraphs, int nPageType = -1, bool bRecursive = false, int nPageShowState = -1, bool bIncludeShortcut = false);
///---END QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER
///End GET_FOLDER_PAGES_NAME

enum { //get_graph_names nOrder
	GGN_ORDER_BY_SLIDE = 0,
	GGN_ORDER_BY_CURRENT_PE,
	GGN_ASCENDING_BY_LN,
	GGN_ASCENDING_BY_SN,
	GGN_ASCENDING_BY_MODIFIED,
	GGN_DESENDING_BY_MODIFIED,
	GGN_ASCENDING_BY_CREATION,
	GGN_DESENDING_BY_CREATION,
};
enum { //nSkip
	GGNSKIP_HIDDEN_SLIDE,	//follow what is in PE
	GGNSKIP_NO_SKIP,
	GGNSKIP_HIDDEN_NON_SHORTBUT,
};
/**$
*/
///Kyle 03/16/2010 QA80-15208 SLIDESHOW_AND_PPTSLIDE_SUPPORT_EMBEDDED_GRAPHS
//int get_graph_names(Folder& fld, vector<string>& vsNames, bool bRecursive, int nSkip, int nOrder = GGN_ORDER_BY_SLIDE);
int get_graph_names(Folder& fld, vector<string>& vsNames, bool bRecursive, int nSkip, int nOrder = GGN_ORDER_BY_SLIDE, bool bIncludeEmbedded = false);
///End SLIDESHOW_AND_PPTSLIDE_SUPPORT_EMBEDDED_GRAPHS

/**$
*/
int get_sel_page_names(vector<string>& vsNames, int nType, int nOrder = GGN_ORDER_BY_CURRENT_PE);

int get_folder_embedded_graphs(Folder fld, vector<string>& vsGraphs, bool bRecursive = false);///Jasmine 11/17/06 GET_ALL_EMBEDDED_GRAPHS_IN_FOLDER

///Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
/**$
		Get get favorites folder.
	Parameters:
		fldFavor = [output] favorites folder
	Example1:
		void get_favorites_folder_ex1()
		{
			Folder ff;
			if( get_favorites_folder(ff) )
				out_str(ff.GetPath());
		}
		
	Return:
		return true if success, else false.
*/
bool get_favorites_folder(Folder& fldFavor);
///End ADD_FAVORITES_TO_AVAILABLE_DROPDOWN


#define TEMP_LT_VAR_LAST_SEL			"_backupLastSel"	///Jasmine 01/15/10 LAST_SEL_BLOCK_PLOTSETUP_OPEN

///Jasmine 08/16/06 ADD_SOME_TEMPLATE_FUNC
///Jasmine 08/24/06 CONSTRUCT_TEMP_ORG_TREE, should move to UtilSdk.cpp
#define STR_SYSTEM_PATH  		okutil_get_origin_path(ORIGIN_PATH_SYSTEM, NULL, TRUE) 
#define STR_TEMPLATE_XML 		okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE) + "template.xml"
#define STR_GROUP_TEMPLATE_XML 	okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE) + "template.xml"	///Jasmine 07/30/07 #8854 SHOW_TEMPLATE_UNDER_GROUP_FOLDER
#define STR_SERVER_GROUP_TEMPLATE_XML	okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER, NULL, TRUE) + "template.xml"	//------ Folger 09/25/07 TREAT_SERVER_GROUP_AND_LOCAL_GROUP_SEPARATELY
//------ Folger 08/22/07 LOAD_SYSTEM_USER_GROUP_TEMPLATE_SEPERATELY
//bool load_template_tree(Tree& trXML);///Jasmine 11/22/06 REMOVE_TEMPLATE_NODE_IF_FILE_INVALID

#define STR_SYSTEM_TEMPLATE_XML 	okutil_get_origin_path(ORIGIN_PATH_SYSTEM, NULL, TRUE) + "template.xml"
enum
{
	TEMPLATE_LOCATION_SYSTEM_FOLDER,
	TEMPLATE_LOCATION_USER_FOLDER,
	TEMPLATE_LOCATION_GROUP_FOLDER,
	TEMPLATE_LOCATION_SERVER_GROUP_FOLDER,		//------ Folger 09/25/07 TREAT_SERVER_GROUP_AND_LOCAL_GROUP_SEPARATELY
};
//------ Folger 11/07/07 LOCALIZE_DELETE_SYSTEM_FILE_BRANCH
#define STR_DELETE_SECTION_TAGNAME		"branchDelete"
#define STR_DELETE_SECTION				"Deleted System File"
//------ End LOCALIZE_DELETE_SYSTEM_FILE_BRANCH

///Jasmine 02/04/09 QA80-13028 SHOW_USER_DEFIND_CATEGORY_INSTEAD_OF_BUILT_IN_CATEGORY_WHEN_SAVING
#define STR_BUILT_IN_CATEGORY			"Built-in"
///End SHOW_USER_DEFIND_CATEGORY_INSTEAD_OF_BUILT_IN_CATEGORY_WHEN_SAVING

bool load_template_tree(Tree& trXML, int nLocation = TEMPLATE_LOCATION_SYSTEM_FOLDER);
//------ End LOAD_SYSTEM_USER_GROUP_TEMPLATE_SEPERATELY
bool construct_template_organizer_tree();
///End CONSTRUCT_TEMP_ORG_TREE
string page_get_template_category(LPCSTR lpcszTemplateOrganizerTreeFile, LPCSTR lpcszTemplate, int nType);
string page_get_template_category(LPCSTR lpcszTemplate, TreeNode& trBranch);
bool page_delete_template(LPCSTR lpcszTemplateOrganizerTreeFile, LPCSTR lpcszCategory, LPCSTR lpcszTemplate, int nWinType);

//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_get_template_name_(global_function)
*/
string page_get_template_name(Page pg, bool bAddExt = true);
string page_get_template_ext(int nType, string& strType = "");
bool is_built_in_template(int nType, LPCSTR lpcszTemplate, LPCSTR lpcszFile);///Jasmine 10/17/06 BUILT_IN_TEMPLATE_INI_SYSTEM_FOLDER
///End ADD_SOME_TEMPLATE_FUNC


/**$
		Open a dialog to select pages with preview.
	Parameters:
		hWndParent = [input] The handle of the parent window
		strPages = [output] the page name list, seperated by | for multiple selection
		bMultiplePages = [input] to control the ability that select multiple page or only one page
		lpcszStartPEpath = [input] specify the folder to be active if bShowFolders is true, else only show this folder if bShowFolders is false
		bShowFolders = [input] works with lpcszStartPEpath
		lpcszExcludePage = [input] the page name that disappear in folder list.
		bEnableEmbed = [input] to control the show embed checkbox	///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
	Return:
		true if success		
*/
//bool open_page_preview_list_dlg(HWND hWndParent, string& strPages, bool bMultiplePages = true, LPCSTR lpcszStartPEpath = NULL, bool bShowFolders = true, LPCSTR lpcszExcludePage = NULL, bool bEnableEmbed = true);		///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
//------Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
//bool open_page_preview_list_dlg(HWND hWndParent, string& strPages, bool bMultiplePages = true, LPCSTR lpcszStartPEpath = NULL, bool bShowFolders = true, bool bEnableEmbed = true);		///Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE
//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
//bool open_page_preview_list_dlg(HWND hWndParent, string& strPages, LPCSTR lpcszStartPEpath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED);
/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
//bool open_page_preview_list_dlg(HWND hWndParent, string& strPages, LPCSTR lpcszStartPEpath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED, int nPageType = EXIST_GRAPH);
bool open_page_preview_list_dlg(HWND hWndParent, string& strPages, LPCSTR lpcszStartPEpath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED, int nPageType = EXIST_GRAPH, LPCSTR lpcszFilterFuncName = NULL);
///end FILTER_GRAPH_FUNCTION_SUPPORT
//-------End CONTROL_BROWSE_PAGE_TYPE
//------End CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
///Jasmine 01/11/07 OPEN_REPORT_TREE_BROWSER
///Jasmine 01/18/07 ADD_REPORT_TREE_FILTER_STRING
#define	STR_FILTER_ATTRIB			"Filter" 
/**$
		Open a dialog to select report tree.
	Parameters:
		strResults = [output] the report tree name list, seperated by | or \n for multiple selection. This name is the [book]sheet name.
		vuIDs = [output] array of the report tree ids
		nSelMode = [input] the number of report tree to select.
		lpcszFilter = [input] the filter string to specify which kind of report trees to find
		hWndParent = [input] The handle of the parent window
	Return:
		true if success		
*/
bool open_report_tree_browser(string& strResults, vector<uint>& vuIDs, int nSelMode = 0, LPCSTR lpcszFilter = NULL, HWND hWndParent = NULL);
///End ADD_REPORT_TREE_FILTER_STRING
///End OPEN_REPORT_TREE_BROWSER

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:update_plot_type_(global_function)
*/
bool update_plot_type(DataPlot& dp, int nType);

/// Iris 9/12/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
/**$
*/
///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE	
//int	plot_data_range(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL);
//as we can not plot one graph from 2 tables
//when FitNL with Concatenate, I have to put Concatenate data and average data in same table
//then delete average data according to pDelCol.
//if *pDelCol = 2, will not plot 1st and 2nd cols
///Arvin 08/15/07 QA70-10212-P3 NEED_REMOVE_REDUNDANT_PLOTS
//int	plot_data_range(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL, int* pDelCol = NULL, bool bCheckIfPlot = false, DWORD *pdwDataRules = NULL);
int	plot_data_range(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL, int* pDelCol = NULL, bool bCheckIfPlot = false, DWORD *pdwDataRules = NULL, int* pStartPlotIndex = NULL);
///end NEED_REMOVE_REDUNDANT_PLOTS
///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
///End SURFACE_FIT_REPORT_MAT_FIT_DATA

//---- CPY 9/21/06 SPARKLINE_IN_WKS_SUPPORT
/**$
*/
DataPlot plot_col(Worksheet& wks, int nCol, GraphPage& gp, int nPlotType = IDM_PLOT_LINE, bool bRescaleNoRoundAxis = true, LPCSTR lpcszTemplate = NULL, bool bCreateAsHidden = true, bool bUseX = false);
//----

//return name of col.
//return short name if bLongname = false, and long name if true.
//When bLongname = true, if col has no long name,
//return short name if bUseSName = true, else return an empty string.
/**$
*/
string get_column_name(const Column& col, bool bLongname = true, bool bUseSName = true);

///Arvin 9/25/06 CHECK_HAS_IMAGE
/**$
*/
bool has_image(const MatrixLayer& ml);
///end CHECK_HAS_IMAGE

///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
/**$
*/
int plot_wks_one_xy_from_data_range(DataRange& dr, GraphLayer& gl, int nPlotType = IDM_PLOT_LINE, int nXIndex = 0, int nYIndex = 0, bool bCheckIfHasPlot = false);
///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH

/// Iris 9/06/2012 ORG-6745-P1 FIX_REPORT_GRAPH_ISSUE_WHEN_THE_TWO_INPUT_DATA_COME_FROM_SAME_COL
int plot_from_data_plot(DataPlot &dpSource, GraphLayer& gl, DWORD dwOptions, bool bCheckIfHasPlot = false);
///End FIX_REPORT_GRAPH_ISSUE_WHEN_THE_TWO_INPUT_DATA_COME_FROM_SAME_COL

///---Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
/**$
*/
int plot_wks_one_xx_from_data_range(DataRange& dr, GraphLayer& gl, int nPlotType, int nXIndex, bool bCheckIfHasPlot);
///---END ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC

/// Iris 9/26/09 SUPPORT_PREVIEW_FOR_MULT_DEPS_MULTI_INDEPS
/**$
*/
///Cheney 2007-4-30 ADD_TEMLATE_FOR_PREVIEW_WHEN_MULTI_LAYER	
//int plot_combinated_xy(Worksheet& wks, GraphPage& gp, int nPlotID = IDM_PLOT_SCATTER, int nColor = SYSCOLOR_BLACK, bool bRescale = false, bool bArrange = false, int nColFrom = 0, int nColTo = -1);
int plot_combinated_xy(Worksheet& wks, GraphPage& gp, int nPlotID = IDM_PLOT_SCATTER, int nColor = SYSCOLOR_BLACK, bool bRescale = false, bool bArrange = false, LPCSTR lpcszTemplate = NULL, int nColFrom = 0, int nColTo = -1);
///end ADD_TEMLATE_FOR_PREVIEW_WHEN_MULTI_LAYER
///end SUPPORT_PREVIEW_FOR_MULT_DEPS_MULTI_INDEPS

///---Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
/**$
*/
int plot_xx(Worksheet& wks, GraphPage& gp, int nPlotID = IDM_PLOT_SCATTER, int nColor = SYSCOLOR_BLACK, bool bRescale = false, bool bArrange = false, LPCSTR lpcszTemplate = NULL, int nColFrom = 0, int nColTo = -1, int nNumX = 2);
///---END ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC

/// Iris 6/05/2012 ORG-4908-S3 IMPROVE_ODR_RESIDUAL_PLOT_COLOR
//int plot_xy_with_err(Worksheet& wks, GraphLayer& gl, int nPlotID = IDM_PLOT_SCATTER, int nColor = SYSCOLOR_BLACK, bool bRescale = true, int nColFrom = 0, int nColTo = -1, bool bCheckIfHasPlot = false);
int plot_xy_with_err(Worksheet& wks, GraphLayer& gl, int nPlotID = IDM_PLOT_SCATTER, int nColor = SYSCOLOR_BLACK, bool bRescale = true, int nColFrom = 0, int nColTo = -1, bool bCheckIfHasPlot = false, int nYErrPlotColor = SYSCOLOR_BLUE, int nXErrPlotColor = SYSCOLOR_BLUE);
///End IMPROVE_ODR_RESIDUAL_PLOT_COLOR

bool add_end_points(DataPlot& dp, int nColorFirst = SYSCOLOR_RED, int nColorLast = SYSCOLOR_RED, int nSize = 12); //CPY 11/5/06	///Jasmine 12/09/06 CHANGE_1ST_POINT_COLOR_BLUE_TO_RED

#define STR_XF_BAR						"PageXFBar"
#define STR_REMINDER_REOPEN_XFBAR		"ReOpenXFBar"  ///---Sim 10-27-2008 v8.961 QA80-12463-P1-P2 SHOW_REOPEN_REMINDER_MESSAGE_ONLY_WHEN_USER_FORCELY_CLOSE_IT
enum {
	SXFB_CLOSE,
	SXFB_OPEN_CHOOSER,
	SXFB_OPEN_INDEPENDENT,
	SXFB_OPEN_WIZARD
};
/**$
*/
///---Sim 05-21-2007 SET_XF_BAR_NAME_ONLY_WITHOUT_SHOW_DIALOG
//bool show_xf_bar(Page& pg, int nShow, LPCSTR lpcszXFname = NULL);
bool show_xf_bar(Page& pg, int nShow, LPCSTR lpcszXFname = NULL, bool bSetNameOnly = false);
///---END SET_XF_BAR_NAME_ONLY_WITHOUT_SHOW_DIALOG

///Kyle 08/29/08 ADD_UTIL_FUNCTION_FOR_XF_BEFORE_EXECUTE
///Kyle 12/10/2008 ADD_SKIP_AUTO_UPDATE_OPTION_TO_FUNCTION_IS_XF_STARTUP
//bool is_xf_startup(int nGetNDialog, int dwCntrl);
bool is_xf_startup(int nGetNDialog, int dwCntrl, bool bSkipAutoUpdate = false);
///End ADD_SKIP_AUTO_UPDATE_OPTION_TO_FUNCTION_IS_XF_STARTUP
///End ADD_UTIL_FUNCTION_FOR_XF_BEFORE_EXECUTE

///------ Folger 10/29/2010 ORG-1311-S2 COLMOVE_SUPPORT_MOVE_COLUMNS_TO_SPECIFIED_INDEX
bool is_xf_really_before_execute(int nGetNDialog, int dwCntrl);
///------ End COLMOVE_SUPPORT_MOVE_COLUMNS_TO_SPECIFIED_INDEX

//// AW 11/07/06 MORE_WORK_ON_SHOW_TIME_COL
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_has_x_(global_function)
*/
bool wks_has_x(Worksheet& wks); 
//// END MORE_WORK_ON_SHOW_TIME_COL

///justin 11/17/2006 RESET_GRAPHLAYER
//  temp solution, should be repalced by GraphLayer::Reset() 
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:graphlayer_reset_(global_function)
*/
bool graphlayer_reset(GraphLayer& gl);
//end RESET_GRAPHLAYER
///Jasmine 01/08/07 MODIFICATION_GET_SET_USER_INFO
///Jasmine 12/07/06 GET_SET_USER_INFO	
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_user_info_(global_function)
*/
bool get_user_info(OriginObject& obj, LPCSTR lpcszName, TreeNode& trUserInfo);
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:set_user_info_(global_function)
*/
bool set_user_info(OriginObject& obj, string& strName, const TreeNode& trUserInfo);
///End MODIFICATION_GET_SET_USER_INFO

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_user_parameters_(global_function)
*/
///Jasmine 01/19/07 ADD_OPTION_TO_ALLOW_EMPTY_PARAM_VALUE
int get_user_parameters(DataObject& obj, vector<string>& vsNames, vector<string>& vsValues, bool bGetEmpty = false);


//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:set_user_parameters_(global_function)
*/
bool set_user_parameters(DataObject& obj, const vector<string>& vsNames, const vector<string>& vsValues, bool bShowLabel = true);
///End GET_SET_USER_INFO

/// Hong 12/07/06 FIX_SPARK_LINE_DISAPPEAR
//Commetnts last updated by Joseph on 2007.8.01
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_add_show_labels_(global_function)
*/
/// RVD 7/30/2008 qa70-11914 SAMPLE_INTERVAL_UNDO
//bool wks_add_show_labels(Worksheet& wks, const vector<int>& vnType, bool bReplace = false);
bool wks_add_show_labels(Worksheet& wks, const vector<int>& vnType, bool bReplace = false, bool bUndo = false);
/// end SAMPLE_INTERVAL_UNDO
/// end FIX_SPARK_LINE_DISAPPEAR

/// Iris 12/18/2006 v8.0527 COMBO_TO_SEL_ALL_PAGES_IN_FOLDER_FOR_EXPORT_PAGE
//---- Iris 01/04/2007 v8.0536 ADD_ACTIVE_PAGE_INTO_PAGE_OPTION
//int 	get_folder_pages_name(vector<string>& vsGraphs, int nOption, LPCSTR lpcszGraphs = NULL, LPCSTR lpcszRemove = NULL, int nPageType = EXIST_PLOT, bool bIncLongName = false);
///---Sim 07-14-2009 QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER
//int 	get_folder_pages_name(vector<string>& vsPages, int nOption, int nPageOptionOffset = 0, LPCSTR lpcszGraphs = NULL, LPCSTR lpcszRemove = NULL, int nPageType = EXIST_PLOT, bool bIncLongName = false);
int 	get_folder_pages_name(vector<string>& vsPages, int nOption, int nPageOptionOffset = 0, LPCSTR lpcszGraphs = NULL, LPCSTR lpcszRemove = NULL, int nPageType = EXIST_PLOT, bool bIncLongName = false, bool bIncludeShortcut = false);
///---END QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER
/// end ADD_ACTIVE_PAGE_INTO_PAGE_OPTION
#define STR_PAGE_SHORT_LONG_NAME_SEPARATOR " - " //------- CPY 10/11/07 QA70-10520 BAD_CODE_WITH_INFO_NOT_CENTRALIZED_LEAD_TO_FAILED_OK_ENABLED
string 	get_page_short_name_from_page_list(LPCSTR lpcszPages, char chSep = STR_PAGE_LIST_SEPARATOR, int index = 0);
///end COMBO_TO_SEL_ALL_PAGES_IN_FOLDER_FOR_EXPORT_PAGE

/// Max 12/21/06 WORKSHEET_COPY
//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_copy_(global_function)
*/
bool wks_copy(Worksheet& wksDesc, const Worksheet& wksSrc, int nOption = CREATE_VISIBLE, DWORD dwCtrl = DCTRL_COPY_DEFAULT); // = CREATE_VISIBLE_SAME, DCTRL_COPY_DEFAULT
/// END WORKSHEET_COPY

///---Sim 01-22-2006 SET_LABEL_VALUE
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:setLabelValueFromRows_(global_function)
*/
/// Hong 11/02/07 QA80-10622 IMPORT_EXCEL_SUPPORT_MULTILINES_COMMENTS
//bool setLabelValueFromRows(Worksheet& wks, int nShortName = -1, int nLongName = -1, int nUnit = -1, int nComment = -1, bool bRemoveRows = true, bool bShowLabel = true);
//------ Folger 02/02/08 QA80-11046 REMOVE_MAIN_HEADER_LINE_IN_IMPORT_EXCEL
//bool setLabelValueFromRows(Worksheet& wks, int nShortName = -1, int nLongName = -1, int nUnit = -1, int nCommentFrom = -1, bool bRemoveRows = true, bool bShowLabel = true, int nCommentTo = -1);
bool setLabelValueFromRows(Worksheet& wks, int nShortName = -1, int nLongName = -1, int nUnit = -1, int nCommentFrom = -1, bool bRemoveRows = true, bool bShowLabel = true, int nCommentTo = -1, int nMainHeaderLines = 0);
//------
/// end IMPORT_EXCEL_SUPPORT_MULTILINES_COMMENTS
///---END SET_LABEL_VALUE

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_linked_layer_(global_function)
*/
bool	is_linked_layer(GraphLayer &gl);

///Jasmine 02/12/11 ORG-695 ARRANGE_OUTSIDE_CHILD_LAYER
/**$
*/
int is_child_layer_outside_parent(GraphLayer &gl);
///End ARRANGE_OUTSIDE_CHILD_LAYER

/**#
*/
int 	get_linked_parent_layer(GraphLayer &gl);

/**$
	adding a blank sheet to a page, 
*/
bool page_add_result_sheet(Page& pg, Datasheet& wksMatLayer, LPCSTR lpcszSheetName, bool bHierachySheet=true, bool bRemoveExisting=true);

///---Sim 05-09-2007 CHANGE_LABEL_TEXT_STYLE
enum{
	WKS_LABEL_TEXT_CONTROL_ORIGIN_TEXT = 0,
	WKS_LABEL_TEXT_CONTROL_EDIT,
};
// Category last updated by Iris on 07/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_set_label_text_control_(global_function)
*/
bool wks_set_label_text_control(Worksheet& wks, int nLabel, int nStyle );
///---END CHANGE_LABEL_TEXT_STYLE

///---Sim 05-25-2007 IMPROVE_GET_AND_SET_XF_BAR_NAME
/**$
*/
bool set_page_xf_bar(Page& page, LPCSTR lpcszName = NULL, int nMode = 0);

/**$
*/
bool get_page_xf_bar(Page& page, string& strName, int* pnMode = NULL);
///---END IMPROVE_GET_AND_SET_XF_BAR_NAME

///Jasmine 06/25/07 UPDATE_ORGANIZER
#define WM_USER_ON_UPDATE_ORGANIZER			(WM_USER + 1032)
#define WM_USER_ON_REFRESH_ORGANIZER		(WM_USER + 1033)
#define WM_USER_ON_NOTIFY_ORGANIZER			(WM_USER + 1034)		///Folger 06/26/07 ADD_NOTIFY

#define ORGANIZER								"Organizer"
#define ORGHWND									"HWND"
/**$
*/
bool set_organizer_handle(Page& page, HWND hwnd);
/**$
*/
HWND get_organizer_handle(const Page& page);
///End UPDATE_ORGANIZER

///---Sim 06-25-2007 UPDATE_ORGANIZER
//bool refresh_organizer_gui(const Page& page); /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE

//void disable_refresh_organizer();
//void enable_refresh_organizer();

#define UPDATE_FROM_IMPORT	1
///Folger 06/26/07 ADD_NOTIFY
//bool update_organizer_gui(const Page& page, int wParam, int lParam);
bool notify_organizer_gui(const Page& page, int wParam, int lParam);
///End ADD_NOTIFY
///---END UPDATE_ORGANIZER

//------ Folger 08/06/07 CHECK_WHETHER_DATARANGE_HAS_PLOTTED_IN_SPECIFIC_GRAPH_LAYER
// Comments last updated by Iris on 07/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:check_has_plotted_in_graph_(global_function)
*/
///Arvin 08/28/07 QA70-10073-P2 KEEP_CUSTOMIZATION_AFTER_CHANGE_PARAMETER_OR_RECALCULATE_SURFACE_FIT
//int check_has_plotted_in_graph(const DataRange &dr, const GraphLayer &gl, vector<int> &vnPlotIndices = NULL);
/// Hong 03/25/09 QA80-12551 RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
//int check_has_plotted_in_graph(const DataRange &dr, const GraphLayer &gl, vector<int> &vnPlotIndices = NULL, DWORD dwNTypeCntrl = NTYPE_BOOKSHEET_XY_RANGE);
int check_has_plotted_in_graph(const DataRange &dr, const GraphLayer &gl, vector<int> &vnPlotIndices = NULL, DWORD dwNTypeCntrl = NTYPE_BOOKSHEET_XY_RANGE, bool bResetPlotRowRangeIfDiffButNotChecked = false);
/// end RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
///end KEEP_CUSTOMIZATION_AFTER_CHANGE_PARAMETER_OR_RECALCULATE_SURFACE_FIT
//------ End CHECK_WHETHER_DATARANGE_HAS_PLOTTED_IN_SPECIFIC_GRAPH_LAYER

//------ Folger 08/13/07 CHECK_IF_DATAPLOT_IN_DATARANGE
/// Hong QA80-12551 v8.0967 FIX_FAIL_REPLOT_SCR_PLOT_WHEN_RESET_TO_FULL_RANGE
//bool check_plot_in_range(const DataRange &dr, const DataPlot &dp, DWORD dwRules = DRR_GET_DEPENDENT|DRR_NO_FACTORS);
bool check_plot_in_range(const DataRange &dr, const DataPlot &dp, DWORD dwRules = DRR_GET_DEPENDENT|DRR_NO_FACTORS, DWORD dwNTypeCntrl = NTYPE_BOOKSHEET_XY_RANGE | NTYPE_ADD_ROW_RANGE);
/// end FIX_FAIL_REPLOT_SCR_PLOT_WHEN_RESET_TO_FULL_RANGE
//------ End CHECK_IF_DATAPLOT_IN_DATARANGE
typedef enum
{
	PLOT_OUTPUT_FORMAT_THICKNESS = 0x0001,		// thicker thickness
}PLOT_OUTPUT_FORMAT;

///Arvin 08/16/07 QA70-10073 KEEP_OUTPUT_CURVE_CUSTOMIZATION_AFTER_RECALCULATE_FOR_XF
// Comments last updated by Iris on 07/28/2008, added $
/**$
	Remarks:
		Check plot output rang in sourve range corresponding graph layer, if the graph layer haven't had any plot of output range, plot
		output range in the graph layer, or else return.
	Keywords:
		DataRange
	Example1:
		
	Parameters:
		drSource = [input] Source range  
		drOutput = [input] Output range to be plotted 
		pdpOut	 = [output] Pointer to DataPlot of output range
		nPlotType= [input] Plot type
		nPlotColor=[input] Plot color 
		nCntrl   = [input] Plot controls
		bNeedRescale = [input] Rescale option 
		lpcszTag = [input] Optional tag for output to make it invisible to other analyses
	Return:
		returns true or false

*/
/// YuI 03/13/09 QA70-13281 TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING
//	bool xf_check_plot_output_rng_in_source_rng_graph(const DataRange& drSource, const DataRange& drOutput, DataPlot* pdpOut = NULL, int nPlotType = IDM_PLOT_LINE, int nPlotColor = SYSCOLOR_RED, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL, bool bNeedRescale = false);
//Kyle 03/20/2009 ADD_OPTION_TO_SPECIFY_FORMAT_OF_DATA_PLOT
//bool xf_check_plot_output_rng_in_source_rng_graph(const DataRange& drSource, const DataRange& drOutput, DataPlot* pdpOut = NULL, int nPlotType = IDM_PLOT_LINE, int nPlotColor = SYSCOLOR_RED, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL, bool bNeedRescale = false, LPCSTR lpcszTag = NULL);
///------ Folger 11/05/09 OC_ADDPLOT_MAKE_PLOT_SUPPORT_UNDO
//bool xf_check_plot_output_rng_in_source_rng_graph(const DataRange& drSource, const DataRange& drOutput, DataPlot* pdpOut = NULL, int nPlotType = IDM_PLOT_LINE, int nPlotColor = SYSCOLOR_RED, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL, bool bNeedRescale = false, LPCSTR lpcszTag = NULL, DWORD dwPlotFormat = 0);
bool xf_check_plot_output_rng_in_source_rng_graph(const DataRange& drSource, const DataRange& drOutput, DataPlot* pdpOut = NULL, int nPlotType = IDM_PLOT_LINE, int nPlotColor = SYSCOLOR_RED, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL | GAP_UNDO, bool bNeedRescale = false, LPCSTR lpcszTag = NULL, DWORD dwPlotFormat = 0);
///------ End OC_ADDPLOT_MAKE_PLOT_SUPPORT_UNDO
///End ADD_OPTION_TO_SPECIFY_FORMAT_OF_DATA_PLOT
/// end TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING

// Comments last updated by Iris on 07/28/2008, added $
/**$
	Remarks:
		Check plot output rang in graph page whose ID is nXFGraphPageID and created by current xf. If the graph page is not exist, create a new graph page and set its ID as  nXFGraphPageID.
		Then, check plot output range in the gaph page. 
	Keywords:
		DataRange
	Example1:
		
	Parameters:
		drOutput = [input] Output range to be plotted 
		nXFGraphPageID = [input] ID of graph page created by current xf
		pdpOut	 = [output] Pointer to DataPlot of output range
		nPlotType= [input] Plot type
		nPlotColor=[input] Plot color 
		nCntrl   = [input] Plot controls
	Return:
		returns true or false

*/
bool xf_check_plot_output_rng_in_graph(const DataRange& drOutput,int nXFGraphPageID = 0, DataPlot* pdpOut = NULL, int nPlotType = IDM_PLOT_LINE, int nPlotColor = SYSCOLOR_RED, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL);
///end KEEP_OUTPUT_CURVE_CUSTOMIZATION_AFTER_RECALCULATE_FOR_XF

//------ Folger 10/22/08 CHECK_AND_PLOT_MATRIX_OBJECT_IN_GRAPH
/// Hong 03/25/09 QA80-12551 RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
//int	check_origin_object_has_plotted_in_graph(const OriginObject& obj, const GraphLayer &gl, vector<int> &vnPlotIndices = NULL, DWORD dwNTypeCntrl = NTYPE_BOOKSHEET_XY_RANGE);
int		check_origin_object_has_plotted_in_graph(const OriginObject& obj, const GraphLayer &gl, vector<int> &vnPlotIndices = NULL, DWORD dwNTypeCntrl = NTYPE_BOOKSHEET_XY_RANGE, bool bResetPlotRowRangeIfDiffButNotChecked = false);
/// end RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER

bool	xf_check_plot_output_matrix_in_graph(const MatrixObject& mo, GraphLayer& gl, int nXFGraphPageID = 0, DataPlot* pdpOut = NULL, int nPlotType =  IDM_PLOT_MATRIX_IMAGE, LPCSTR lpcszTemplate = "Origin");
//------ End CHECK_AND_PLOT_MATRIX_OBJECT_IN_GRAPH

int find_plot_index_by_key(const GraphLayer& gl, LPCSTR lpcszKey1, LPCSTR lpcszKey2 = NULL, int nPlotFrom = -1, bool bCaseSensitive = false, DWORD dwCntrl = NTYPE_BOOKSHEET_XY_RANGE);

//------ Folger 08/23/07 GET_GRAPH_TEMPLATE_PREVIEW_IMAGE_FILES_FULL_NAME
string get_graph_template_preview_file(LPCSTR lpcszTemplate);
//------ End GET_GRAPH_TEMPLATE_PREVIEW_IMAGE_FILES_FULL_NAME

///Cheney 2007-8-27 ADD_HINTS_AND_LOCALIZE_NONEPREVIEW_TEMPLATE
bool load_text_for_nonepreview(GraphLayer& gl, int nContentID, int nHintsID); 
bool load_text_for_nonepreview_graphpage(GraphPage& gp, int nContentID, int nHintsID);
bool is_nonepreview_template(GraphPage& gp, bool bNLFit = false);
///end ADD_HINTS_AND_LOCALIZE_NONEPREVIEW_TEMPLATE

///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
//if OPERATION_OUTPUT_XYZ_FITTING or OPERATION_OUTPUT_MAT_FITTING, should report fitted
//curve to matrix,
//if OPERATION_OUTPUT_XYZ_FITTING, should not report fitted curve to source book
enum
{
	OPERATION_OUTPUT_GENERAL,
	OPERATION_OUTPUT_XYZ_FITTING,
	OPERATION_OUTPUT_MAT_FITTING,
};
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
//----- CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
//#define	STR_REPORT_MATRIX_DATA		"ReportMatrixData"  // moved here from event_utils.h
///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
//#define	STR_OPERATION_OUTPUT_TYPE		"OperationOutputType"  
#define	STR_OPERATION_OUTPUT_WND_TYPE		"OperationOutputWindowType"  
///end CLEAN_OUTPUT_WND_TYPE_CODE
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
//#define STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(_STRSRC) STR_NONE + STR_TOKEN_SEP + STR_SOURCE_BOOK + _STRSRC + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS
//#define STR_OUTPUT_REPORT_BOOK_COMBO			STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS
///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
//#define STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(_STRSRC) STR_AUTO + STR_TOKEN_SEP + STR_NONE + STR_TOKEN_SEP + STR_SOURCE_BOOK + _STRSRC + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS
//#define STR_OUTPUT_REPORT_BOOK_COMBO			 STR_AUTO + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS
/////end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING

/// Iris 4/07/2008 MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET
#define STR_SPACE	" " 
//#define STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(_STRSRC) 			STR_NONE + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP + STR_SOURCE_BOOK + _STRSRC + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS
#define STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(_STRSRC) 			STR_NONE + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_SPACE + _STRSRC + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS
///END MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET
#define STR_OUTPUT_REPORT_BOOK_COMBO			 			STR_NONE + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS
/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
#define STR_STATS_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(_STRSRC)	STR_NONE + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_SPACE + _STRSRC + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS
#define STR_STATS_OUTPUT_REPORT_BOOK_COMBO						STR_NONE + STR_TOKEN_SEP + STR_SOURCE_BOOK +STR_TOKEN_SEP + STR_NEW +STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS
/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
/// Iris 4/07/2008 MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET
//#define STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(_STRSRC)	STR_NONE + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP +  STR_SOURCE_BOOK + _STRSRC + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS 
#define STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(_STRSRC)	STR_NONE + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP +  STR_SOURCE_BOOK + STR_SPACE + _STRSRC + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS 
///END MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET
#define STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO				STR_NONE + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS 
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
#define STR_XYFITTING_FINDXYOUT_BOOK_COMBO		(STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
#define STR_XYFITTING_FINDXYOUT_SHEET_COMBO		STR_XYFITTING_FINDXYOUT_BOOK_COMBO
#define STR_XYFITTING_RESIDUALOUT_BOOK_COMBO	STR_XYFITTING_FINDXYOUT_BOOK_COMBO
#define STR_XYFITTING_RESIDUALOUT_SHEET_COMBO	(STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP)

/// Iris 3/15/2008 QA80-11244 SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING, report XYZ fitting curve and residuals to worksheet now
//#define STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO 	(STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO 	(STR_NEW + STR_TOKEN_SEP)
//#define STR_XYZFITTING_FINDZOUT_BOOK_COMBO 		(STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_XYZFITTING_FINDZOUT_SHEET_COMBO 	(STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO	(STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_XYZFITTING_FITTEDCURVE_SHEET_COMBO	STR_MATFITTING_REPORTOUT_SHEET_COMBO
#define STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO 	STR_XYFITTING_RESIDUALOUT_BOOK_COMBO
#define STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO 	STR_XYFITTING_RESIDUALOUT_SHEET_COMBO
#define STR_XYZFITTING_FINDZOUT_BOOK_COMBO 	STR_XYFITTING_FINDXYOUT_BOOK_COMBO
#define STR_XYZFITTING_FINDZOUT_SHEET_COMBO	STR_XYFITTING_FINDXYOUT_SHEET_COMBO
///end SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING

#define STR_MATFITTING_REPORTOUT_BOOK_COMBO 	(STR_NONE + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
#define STR_MATFITTING_REPORTOUT_SHEET_COMBO	(STR_NEW + STR_TOKEN_SEP)
///Sophy 6/2/2008 ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
//#define STR_MATFITTING_RESIDUALOUT_BOOK_COMBO	(STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
#define STR_MATFITTING_RESIDUALOUT_BOOK_COMBO	(STR_FIT_CURVE + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
///end ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
#define STR_MATFITTING_RESIDUALOUT_SHEET_COMBO	(STR_NEW + STR_TOKEN_SEP)
#define STR_MATFITTING_FINDZOUT_BOOK_COMBO		(STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
#define STR_MATFITTING_FINDZOUT_SHEET_COMBO		(STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
///Sophy 6/2/2008 ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
//#define STR_MATFITTING_FITTEDCURVE_BOOK_COMBO	(STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
#define STR_MATFITTING_FITTEDCURVE_BOOK_COMBO	(STR_AUTO + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
///end ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
/// Iris 4/07/2008 FIX_TWO_SOURCE_IN_MATRIX_FIT_CURVE_BOOK_COMBO
//#define STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(_STRSRC) 	(STR_SOURCE_BOOK + _STRSRC + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
#define STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(_STRSRC) 	(STR_AUTO + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_SPACE + _STRSRC + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)	
///end FIX_TWO_SOURCE_IN_MATRIX_FIT_CURVE_BOOK_COMBO
#define STR_MATFITTING_FITTEDCURVE_SHEET_COMBO	STR_MATFITTING_REPORTOUT_SHEET_COMBO
///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET

#define STR_PEAKFIT_PEAK_CHARACTER_BOOK_COMBO	(STR_NONE + STR_TOKEN_SEP +  STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
#define STR_PEAKFIT_PEAK_CHARACTER_BOOK_COMBO_WITH_SOURCE(_STRSRC)	(STR_NONE + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_SPACE + _STRSRC + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)

#define STR_XYZ2MAT_OUTPUT_REPORT_BOOK_COMBO				STR_NEW +STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS

// Comments last updated by Iris on 07/28/2008, added $
/**$
	check if Input treenode contain a valid data range from a normal workbook
	Parameters:
		trInput = [input] Input Data node of a typical GUI GetN tree
		pstrBookName = [output] optional str to receive normal book short name, set to empty for all false return
		pstrSheetName = [output] optional str to receive normal sheet short name, set to empty for all false return
	Return:
		false if loose dataset, or Excel book.
*/
///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
//bool is_range_from_normal_book(const TreeNode& trInput, string* pstrBookName=NULL);
/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
//bool is_range_from_normal_book(const TreeNode& trInput, string* pstrBookName=NULL, string* pstrSheetName=NULL);
bool is_range_from_normal_book(const TreeNode& trInput, string* pstrBookName=NULL, string* pstrSheetName=NULL, bool bNotAllowEmptyInput = false);
/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
//-----

///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
// Category last updated by Iris on 07/28/2008
/**# >Internal Origin Objects>Worksheet
	check if Input range is from a normal workbook
	Parameters:
		rgInput = [input] Input Data Range
		pstrBookName = [output] optional str to receive normal book short name, set to empty for all false return
		pstrSheetName = [output] optional str to receive normal sheet short name, set to empty for all false return
	Return:
		false if loose dataset, or Excel book.
*/
/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
//bool is_range_from_normal_book(const DataRange& rgInput, string* pstrBookName=NULL, string* pstrSheetName=NULL);
bool is_range_from_normal_book(const DataRange& rgInput, string* pstrBookName=NULL, string* pstrSheetName=NULL, bool bNotAllowEmptyInput = false);
/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING

/**$
*/
string get_range_source_page_name(const DataRange& drInput, string *pstrLayerName=NULL);///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING ///Jasmine 10/15/07 MOVE_TO_PAGE_UTILS

//----- CPY 10/27/2007 QA70-10605 OC_ACCESS_TO_PAGE_NOTSAVED_BITS
//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_clone_(global_function)
*/
bool page_clone(const GraphPageBase& pgSource, GraphPageBase& pgNew, bool bRemoveScalerObj= true, bool bSetNoClick=true, bool bDisableLTEvents=true);
//-----

//--------- CPY 5/6/08 QA70-11514 LAYOUT_PAGE_EXPORT_NOT_USING_WRONG_TEMP_PAGE_TYPE
// following two functions moved here from grobj_utils.h
#define		X_SCROLL_BAR_NAME			"xScrollbar"
#define		Y_SCROLL_BAR_NAME			"yScrollbar"
#define		X_SCROLL_THUMB_NAME			"xScrollThumb"
#define		Y_SCROLL_THUMB_NAME			"yScrollThumb"
#define		ASTERISK_SCROLL_BAR_NAME			"*Scrollbar"
#define		ASTERISK_SCROLL_THUMB_NAME			"*ScrollThumb"
/// Hong 05/05/07 QA80-9716 ADD_PLOT_CONTROL_XF_FOR_GRAPH_WINDOW
bool remove_axis_scrollbar(GraphLayer& gl, bool bHorizontal = true);
/// end ADD_PLOT_CONTROL_XF_FOR_GRAPH_WINDOW
bool remove_axis_scrollbar(const GraphPageBase& gp); /// Hong 11/05/07 v8.0740 FIX_EXP_GRAPH_FAIL_WITH_AXIS_SCROLLBAR
GraphPageBase clone_graph(LPCSTR lpcszGraphSortName, bool bUseGraphForLayout = true, bool bHideNoPE = true, bool bRemoveScalerObj= true, bool bSetNoClick=true, bool bDisableLTEvetns=true); 
//--------- end LAYOUT_PAGE_EXPORT_NOT_USING_WRONG_TEMP_PAGE_TYPE

//------ Folger 11/05/07 IMPROVE_XF_DYNADLG_SHOW_CONTROL
//------ Folger 12/25/07 NO_NEED_TO_SPECIFY_SHOW_AND_REDRAW_STATUS
//bool page_set_xf_dynadlg_storage(Page &pg, int nHwnd, int nShow, int nRedraw)
bool page_set_xf_dynadlg_storage(Page &pg, OIP nHwnd);
//------

//------ Folger 12/11/08 QA80-12764 v8.0985 MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK
//bool page_xf_dynadlg_shown_control(Page &pg, int &nShow, bool bGet = true);
/// This code aims to fix modify peaks in PA during change parameter, however, CP suggest that
/// when change parameter, not allow any GUI2Graph interaction, simply disable it here
bool page_xf_dynadlg_shown_control(Page &pg, int &nShow, bool bGet = true, bool bMinimizedBeforeHidden = /*true*/false);
//------ End MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK

//------ End IMPROVE_XF_DYNADLG_SHOW_CONTROL
///---Sim 12-07-2007 SAVE_REDRAW_STATUS_WHEN_SET_REDRAW
bool page_xf_dynadlg_redraw_flag_control(Page &pg, int &nRedraw, bool bGet = true);
///---END SAVE_REDRAW_STATUS_WHEN_SET_REDRAW
///---Sim 12-18-2007 SPECIFY_ACTIVE_PAGE_AFTER_XF_WIZ_FINISH
//bool page_xf_dynadlg_send_msg(Page &pg, uint msg, DWORD wParam = 0, DWORD lParam = 0);
bool page_xf_dynadlg_set_active_sheet_after_finish(Page &pg, Layer &layActive);
///---END SPECIFY_ACTIVE_PAGE_AFTER_XF_WIZ_FINISH
///---Sim 03-14-2008 ALLOW_DESTROY_ATTACHED_PAGE
bool page_xf_dynadlg_destroy_created_page(Page &pg, bool bDestroy = true);
///---END ALLOW_DESTROY_ATTACHED_PAGE

//------ Folger 01/22/08 INDICATE_WHETHER_XF_EVENT_HANDLE_NEEDED
bool	page_xf_trivial_event_handle_needed(const Page &pg);
//------

//------ Folger 11/17/07 IS_USE_ORIGIN_CHM
bool is_use_origin_chm();
//------ End IS_USE_ORIGIN_CHM

///Arvin 11/30/07 WRONG_CURVES_COLOR_FOR_REPLICA_IN_SOURCE_GRAPH
bool set_color_by_group_plots(GraphLayer& gl, int nStartPlot, int nEndPlot, int nStartColor = SYSCOLOR_RED);
///end WRONG_CURVES_COLOR_FOR_REPLICA_IN_SOURCE_GRAPH

//------ Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
//we treat subfolder of UFF as "(Unknown)", not "(User)"
string	template_composite_name_from_file_path(LPCSTR lpcszFullFilePath, LPCSTR lpcszSubPath = NULL);
int 	template_get_origin_path_type(LPCSTR lpcszFilePath, BOOL bPreferUser = TRUE);
//------
/**$
	Parameters:
		dminCol = min col width, in fraction of an average character's width, -1 if use default
		dmaxCol = max col width, -1 will use default, and do not set max
		dminRow = min row height, in fraction of an average character's height, -1 if use default
		dmaxRow = max row height, -1 will not set row max
*/
///---Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
//void autosize_rowcol(OriginObject& obj, double dminCol = 1.5, double dmaxCol = 25, double dminRow = -1, double dmaxRow = -1, DWORD dwCntrl = 0, int nMarginH=0, int nMarginW=0, int nColCounts=0);//---- CPY RVD 8/9/05 LIMIT_AUTOSIZ_ROWCOL
void autosize_rowcol(OriginObject& obj, double dminCol = 1.5, double dmaxCol = 25, double dminRow = -1, double dmaxRow = -1, DWORD dwCntrl = 0, int nMarginH=0, int nMarginW=0, int nColCounts=0,
					///---Sim 12-29-2009 QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL
					//DWORD dwCntrlCol = 0, DWORD dwCntrlRow = 0, const vector<int> &vnLabelTypesToSkip = NULL);
					DWORD dwCntrlCol = 0, DWORD dwCntrlRow = 0,
					const vector<int> &vnSpecificLabelTypes = NULL, bool bSkipSpecificLabel = false, bool bLabelOnly = false);
					///---END QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL
///---END QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
/// Hong 01/04/08 QA80-10901 ADD_MANIPUTATE_IN_BOOK_LEVEL
/// end ADD_MANIPUTATE_IN_BOOK_LEVEL

void format_report_table(TreeNode& trTable, bool bTranspose = false, bool bHideHeader = true, bool bAutoFit = true);

bool prepare_report_sheet(Worksheet& wks, LPCSTR lpcszSheetName = NULL);

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
// moved from event_utils
enum{
	WKS_ALL = -1,
	WKS_DATA_SHEET,
	WKS_REPORT_TABLE
};

// Category last updated by Iris on 07/28/2008
/**# >Internal Origin Objects>Page and Layer
		Get sheet list string from the specified page.
	Parameters:
		pg = [input] the input page to find sheets
		nSheetType = [input] sheet type, see WKS_* defined in page_utils.h
	Return:
		return sheet list
*/
string get_sheets_in_book(const Page& pg, int nSheetType = WKS_ALL);

// Category last updated by Iris on 07/28/2008
/**# >Internal Origin Objects>Page and Layer
		Get report/hierarchy sheet list string from the specified page.
	Parameters:
		pg = [input] the input page to find sheets
		iActiveSheet = [output] to return the index of active sheet
	Return:
		return sheet list
*/
string get_report_sheets_in_book(const Page& pg, int& iActiveSheet = NULL);
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

// Category last updated by Iris on 07/28/2008
/**# >Internal Origin Objects>Page and Layer
		Get page names from the current project.
	Parameters:
		vsPagesName = [output] page names vector
		nPageType = [input] page type, like EXIST_WKS, see EXIST_* in oc_const.h
*/
void get_project_pages_name(vector<string> &vsPagesName, uint nPageType  = EXIST_WKS);

/**$
*/
/// Iris 4/01/2008 v8.0834 MOVE_GET_SOURCE_PAGE_NAME_TO_PAGE_UTILS
//#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS bIsNLFitOutputEvent used to make diff way to get Input branch, so directly pass Input branch better
//string get_source_page_name(TreeNode& trGUI, string *pstrLayerName = NULL, bool bIsNLFitOutputEvent = false);
//#else
string get_source_page_name(TreeNode& trGUI, string *pstrLayerName = NULL, TreeNode& trInput = NULL);
//#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS
///end MOVE_GET_SOURCE_PAGE_NAME_TO_PAGE_UTILS

bool	get_graph_layer_by_plot_uid(GraphLayer& gl, DWORD dwPlotUID);

/**$
*/
bool	convert_result_curve_range_to_one_plotted_range(const DataRange& dr, DataRange& drSubRange, int nPlotType = IDM_PLOT_SCATTER, int index = 0, int* pDelCol = NULL);

//------ Folger 07/24/08 BETTER_XF_OPERATION_OUTPUT_COMMENTS
string	get_input_data_range_string(DataRange &inputRange);
//------

///Kyle 03/26/2009 ADD_UTIL_FUNCTION_TO_GET_DESCRIPTION_FROM_XYRANGE
///------ Folger 08/31/2012 ORG-6569-P1 GET_XY_RANGE_STRING_LOOSE_DATASET_SUPPORT
//string get_xy_range_string(const XYRange& irng, string strDesignations, int nIndex = 0);
string get_xy_range_string(const XYRange& irng, string strDesignations, int nIndex = 0, DWORD dwRules = DRR_GET_DEPENDENT);
///------ End GET_XY_RANGE_STRING_LOOSE_DATASET_SUPPORT
///End ADD_UTIL_FUNCTION_TO_GET_DESCRIPTION_FROM_XYRANGE

///Sophy 11/21/2008 v8.976 QA80-12591-P3 ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT
int get_source_data_sheet_type(TreeNode& trInput);
///end ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT

/// Iris 5/18/2009 QA80-13552-P2 IMPROVE_CHECK_3D_LAYER_FUNCITON
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Is_3D_graph_(global_function)
*/
bool is_3D_graph(const GraphLayer& gl);
///end IMPROVE_CHECK_3D_LAYER_FUNCITON

///------ Folger 08/05/2011 ORG-3417-P1 FUNCTION_PLOT_2D_USE_COLUMN_OBJ
/**$
*/
bool is_3DGL_graph(const GraphLayer& gl);
///------ End FUNCTION_PLOT_2D_USE_COLUMN_OBJ

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Graph_add_layer_(global_function)
*/
int	graph_add_layer(GraphPage& gp, bool bBottom = true, bool bLeft = true, bool bTop = false, bool bRight = false, bool bAutoOffset = true, int nLinkTo = -1);
					
/// Iris 7/14/2009 QA80-13941 SUPPORT_MORE_OPTIONS_FOR_WREPLACE_AND_MREPLACE_XF
int 	get_matrix_active_object_index(Datasheet& ds);
///------ Folger 11/02/09 QA81-14522 SUPPORT_FIND_REPLACE_STR_IN_LABEL_ROWS
//bool 	get_sheet_selection(Datasheet& ds, DataRange& dr);
bool get_sheet_selection(Datasheet& ds, DataRange& dr, BOOL bCheckLabelRows = FALSE);
///------ End SUPPORT_FIND_REPLACE_STR_IN_LABEL_ROWS
bool	is_matrix_sheet(Datasheet& ds);
///------ Folger 11/02/09 QA81-14522 SUPPORT_FIND_REPLACE_STR_IN_LABEL_ROWS
//bool 	get_active_sheet_range(Datasheet& ds, int* pnMatrixObjectIndex = NULL, DataRange* pDataRange = NULL);
//bool	get_active_sheet_range_ex(DataRange& dr, bool bPerformInSelectedRange = false, Datasheet* pDatasheet = NULL, bool bGetActiveMatrixObjectOnly = true);
bool 	get_active_sheet_range(Datasheet& ds, int* pnMatrixObjectIndex = NULL, DataRange* pDataRange = NULL, BOOL bCheckLabelRows = FALSE);
bool	get_active_sheet_range_ex(DataRange& dr, bool bPerformInSelectedRange = false, Datasheet* pDatasheet = NULL, bool bGetActiveMatrixObjectOnly = true, BOOL bCheckLabelRows = FALSE);
///------ End SUPPORT_FIND_REPLACE_STR_IN_LABEL_ROWS
///end SUPPORT_MORE_OPTIONS_FOR_WREPLACE_AND_MREPLACE_XF

///------ Folger 08/10/09 GENERAL_COLUMN_COPY_UTILS_NEEDED_IN_OC
enum
{
	COPY_COL_DATA				= 0x00000001,
	COPY_COL_FORMAT				= 0x00000002,
	COPY_COL_LONGNAME			= 0x00000004,
	COPY_COL_UNITS				= 0x00000008,
	COPY_COL_COMMENTS			= 0x00000010,
	COPY_COL_PARAMETERS			= 0x00000020,
	COPY_COL_UDL				= 0x00000040,		///------ Folger 11/17/09 QA81-11105 COPY_COL_SUPPORT_UDLS
	COPY_COL_IGNORE_HIDDEN		= 0x00000100,		/// Zech 06/27/2012 ORG-6078-S1 COL_COPY_SUPPORT_IGNORE_HIDDEN_ROW
	COPY_COL_MASK				= 0x00000200, ///------ Folger 08/09/2012 COPYCOL_MASK_SUPPORT
};
///------ Folger 09/15/2011 ORG-3805-P1 SPECIFY_ROW_FAILED_TO_WORK_IN_BATCH_PROCESS
//bool	copy_col(Column ccSc, Column ccTg, DWORD dwOptions = 0);
bool	copy_col(Column ccSc, Column ccTg, DWORD dwOptions = 0, int nR1 = 0, int nR2 = -1);
///------ End SPECIFY_ROW_FAILED_TO_WORK_IN_BATCH_PROCESS
///------ End GENERAL_COLUMN_COPY_UTILS_NEEDED_IN_OC

///Sophy 1/29/2010 QA80-14995-P2 CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS
bool	check_update_worksheet_name(string& strBooksheetName);
///end CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS
///------ Folger 03/18/2011 ORG-2479-S1 MAKE_QUICKFIT_FOLLOW_GENERAL_GADGETS
int	check_update_worksheet_name(TreeNode& trWks);
///------ End MAKE_QUICKFIT_FOLLOW_GENERAL_GADGETS

///---Sim 02-02-2010 QA81-15063 ADD_CUSTOM_PROPERTIES_INTO_WKS_INFO_TREE
/**$
	lpcszName = NULL means the whole info tree
*/
bool get_import_file_info(const OriginObject& obj, TreeNode& trInfo, LPCSTR lpcszName = NULL);
/**$
	lpcszName = NULL means the whole info tree
*/
bool set_import_file_info(OriginObject& obj, const TreeNode& trInfo, LPCSTR lpcszName = NULL);
///---END QA81-15063 ADD_CUSTOM_PROPERTIES_INTO_WKS_INFO_TREE

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Get_selected_data_plot_(global_function)
*/
int get_selected_data_plot();

///------ Folger 04/15/10 QA81-15315 NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL
void	set_axis_scale_properties(Scale& scale, LPDOUBLE prFrom, LPDOUBLE prTo, LPDOUBLE prInc);
///------ End NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL

///------ Folger 08/06/10 ORG-502-P5 CONTEXT_MENU_OF_ADD_DELETE_COL_SHOULD_ONLY_SHOW_IN_GRID_TABLE
BOOL	pt_in_rect(RECT& rect, POINT pt);
///------ End CONTEXT_MENU_OF_ADD_DELETE_COL_SHOULD_ONLY_SHOW_IN_GRID_TABLE

///Kyle 09/19/2010 ORG-1007-P1 WDELDUP_IMPROVE_SPEED
BOOL	worksheet_delete_rows(Worksheet& wks, const vector<uint>& vnRows, bool bUndo = false);
///End WDELDUP_IMPROVE_SPEED

///------ Folger 09/27/2010 ORG-1151-P1 SAVE_AS_ANALYSIS_TEMPLATE_FAILED_TO_CLEAN_GRAPHS_EMEBEDED_IN_WKS
BOOL	check_make_full_row_range(DataRange& dr);
///------ End SAVE_AS_ANALYSIS_TEMPLATE_FAILED_TO_CLEAN_GRAPHS_EMEBEDED_IN_WKS

///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
BOOL	wks_has_cell_linkes(Worksheet& wks);
///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK

/// Iris 10/21/2010 ORG-1291 ADD_FUNC_TO_FIND_WKS_LABLE_BY_NAME
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Find_user_defined_label_(global_function)
*/
int 	find_user_defined_label(Worksheet& wks, LPCSTR lpcszLabelName);
///End ADD_FUNC_TO_FIND_WKS_LABLE_BY_NAME

///------ Folger 10/28/2010 ORG-1311-S2 COLMOVE_SUPPORT_MOVE_COLUMNS_TO_SPECIFIED_INDEX
int get_num_objects(Datasheet& dats);
///------ End COLMOVE_SUPPORT_MOVE_COLUMNS_TO_SPECIFIED_INDEX

///------ Folger 11/05/2010 ORG-27 NEW_DIGITIZER_GADGET
BOOL	page_get_width_height(Page& pg, int* pnWidth, int* pnHeight);
///------ End NEW_DIGITIZER_GADGET

/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
BOOL	is_obj_connected_to(OriginObject& objSrc, OriginObject& objTarget);
/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH

/// Bill 03/30/2011 ORG-2531 WANT_XF_TO_MODIFY_EMBED_GRAPH_PROPERTIES
DWORD check_cell_embedding_linking(const Worksheet & wks, const int nRow, const int nCol);

void get_ref_cell_location(string strRef, Worksheet & wksSrc, Worksheet & wksDist, int & nRowRef, int & nColRef);

DWORD get_cell_embedding_or_linking_cntrl(Worksheet & wks, int nRow, int nCol);
void set_cell_embedding_or_linking_cntrl(Worksheet & wks, int nRow, int nCol, DWORD dwSetCntrl, DWORD dwClearCntrl);
/// End WANT_XF_TO_MODIFY_EMBED_GRAPH_PROPERTIES

bool	is_use_long_name_when_available();///-----Kit 04/13/2011 ORG-2614-P1 ADD_DATAPLOT_FAIL_WHEN_USE_PAGE_LN

///------ Folger 05/25/2011 ORG-2944-P1 ORIGIN_RUNTIME_ERROR_WHEN_MULTIPLE_PEAK_FIT_ON_GROUPED_PLOTS
int		get_num_of_groupplots(GraphLayer& gl);
///------ End ORIGIN_RUNTIME_ERROR_WHEN_MULTIPLE_PEAK_FIT_ON_GROUPED_PLOTS

int		get_active_page_type();	///-----Kit 08/16/2011 SHARE_CODE

///------ Folger 09/14/2011 ORG-3616-P7 FAILED_TO_GET_BOOK_SHEET_STRING_FOR_MATRIX_BASED_RANGE
BOOL	get_range_book_sheet(string& strBook, string& strSheet, const DataRange& dr, int nIndex = 0);
///------ End FAILED_TO_GET_BOOK_SHEET_STRING_FOR_MATRIX_BASED_RANGE

///------ Folger 12/30/2011 ORG-4727-P1 CHECK_OPERATION_WHEN_DELETE_WKS_FROM_NAVIGATION_DLG
BOOL	page_delete_layers(Page& pg, const vector<int>& vnLayers);
///------ End CHECK_OPERATION_WHEN_DELETE_WKS_FROM_NAVIGATION_DLG

/// Bill 12/30/2011 ORG-4740 MULTI_VARIATE_ANALYSIS_SHOULD_NOT_SUPPORT_NONADJACENT_RANGE_INPUT
BOOL	get_data_from_range(const Range& rng, matrix& my, int * pnErr = NULL, vector<string>& vstrYName = NULL, vector<string>& vstrYLongName = NULL);
/// End MULTI_VARIATE_ANALYSIS_SHOULD_NOT_SUPPORT_NONADJACENT_RANGE_INPUT

/// Iris 2/17/2012 ORG-3911-P2 FIX_CONCATENATED_PLOT_BECOME_RED_IN_FITCURVE_PREVIEW
void	remove_all_dataplots(GraphLayer& gl);
///End FIX_CONCATENATED_PLOT_BECOME_RED_IN_FITCURVE_PREVIEW

/// Iris 4/19/2012 ORG-5481-S1 SURFACE_FIT_FITTED_CURVE_SUPPORT_XYZ_SURFACE_PLOT
bool	is_OGL();
///End SURFACE_FIT_FITTED_CURVE_SUPPORT_XYZ_SURFACE_PLOT

/// Zech 03/31/2012 ORG-4284-P3 DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER
bool	is_page_not_sparkline(const PageBase& gp);
/// END DO_NOT_SHOW_SPARKLINE_IN_GRAPH_BROWSER

/// Iris 6/11/2012 ORG-4908-P10 FIX_IMPLICIT_FIT_WITH_MULTIPLE_DATASETS_ISSUE
bool get_xy_sub_range(DataRange& dr, DataRange& drOneXY, int nXIndex, int nXColType, int nYIndex, int nYColType);
///End FIX_IMPLICIT_FIT_WITH_MULTIPLE_DATASETS_ISSUE

///------ Folger 08/14/2012 ORG-6381-S1 DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET
int get_layer_stack_plot_offset(GraphLayer& gl);
///------ End DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET

#endif // _PAGE_UTILS_H
