 /*-----------------------------------------------------------------------------*
 * File Name: okocUtils.h			 											*
 * Creation: CPY																*
 * Purpose: VC (OKXF) implemented OC functions with access to OK				*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 8/7/2006 INTERMEDIATE_BOOK_BETTER_CREATION								*
 *	RVD 8/7/2006 CAN_NOT_COMPILE												*
 *	CPY 8/16/06 IMP_ASC_XF														*
 *  SY 2007-03-07 QA70-9388 v8.0577 MRU_FOR_TEMPLATE_OGW						*
 *	EJP 2007-05-21 v8.0623 QA70-9796 OC_ACCESS_TO_FDLOG							*
 *	CPY 7/24/2007 QA70-10107 SHOULD_NOT_HARD_CODE_RANGE_CONSTRUCTION_IN_OC_LEVEL*
 *	Sim 09-18-2008 QA80-12203 MOVE_BIN_IMPORT_TO_VC								*
 *	Sim 07-09-2009 QA80-13891 EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT			*
 *	Sim 04-08-2010 QA85-15284 SUPPORT_LT_FITTING_WITH_INTEGRAL					*
 *	EJP 2010-09-15 ORG-1043 ALLOW_DEVELOPERS_TO_CHECK_MODULE_LIC				*
 *	Folger 02/20/2012 ORG-5078-P1 SUPPORT_ADD_CONTINUOUS_COLUMNS_AS_ONE_BLOCK_IN_COLUMN_BROWSER
 *------------------------------------------------------------------------------*/

#ifndef _OK_OC_UTILS_H
#define _OK_OC_UTILS_H

#ifdef __AFX_H__
	#ifdef OKXF_DLL
		#define OKOC_API __declspec(dllexport)
	#else
		#define OKOC_API __declspec(dllimport)
	#endif

#else
	#define OKOC_API
#endif//__AFX_H__

//////////////////////////////////////////////
/// exported function prototypes here
//////////////////////////////////////////////
#ifdef __AFX_H__
	#include "OCtoVC.h"
	extern "C" {
#else
	#pragma dll(okxf.dll)
#endif

enum {DATASET_WKS, DATASET_MATRIX, DATASET_WKS_OR_MATRIX};
/**$
*/
OKOC_API BOOL okoc_find_dataset(LPCSTR lpcszRange, string* pstrDataset, string* pstrBook=NULL, int nWinType = DATASET_WKS_OR_MATRIX, string* pstrSheet=NULL, string* pstrColLongName = NULL);
/**$
*/
OKOC_API int okoc_input_box(string* pstr, LPCSTR lpcszMsg, LPCSTR lpcszTitle = NULL, int nLines = 0, HWND hWndParent=NULL);
/**$
*/
/// ML 8/7/2006 INTERMEDIATE_BOOK_BETTER_CREATION
// CPY 5/2/07 added comments
//Category last updated by Iris 07/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okoc_create_workbook_(global_function)
*/
OKOC_API	BOOL	okoc_create_workbook(Worksheet *pwks, LPCSTR lpcszNamePrefix, LPCSTR lpcszTemplate, int nOption = CREATE_VISIBLE, int nRows = -1, int nCols = -1, int nAutoAddRows = -1, int nLabel1 = -1, int nLabel2 = -1);
/// end INTERMEDIATE_BOOK_BETTER_CREATION

/**$
*/
OKOC_API BOOL okoc_init_ASCIMP(ASCIMP* pAscImp);//---- CPY 8/16/06 IMP_ASC_XF
/**$
*/
OKOC_API int cvt_x_from_step_to_str(double xFrom, double xStep, LPSTR lpBuffer, int nSize);
/**$
*/
OKOC_API BOOL okoc_AddToRecentFileList(LPCTSTR lpszPathName);	/// SY 2007-03-07 QA70-9388 v8.0577 MRU_FOR_TEMPLATE_OGW

//Last update Cheney 2007-7-2
//---- CPY 4/13/07 QA70-9623 CENTRALIZED_MSG_OUT_FOR_OC_AND_INTERNAL
//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okoc_out_msg_(global_function)
*/
OKOC_API int okoc_out_msg(LPCSTR lpcsz, char cMsgType = 'E', BOOL bAddCRLF=true);
/**$
*/
OKOC_API void okoc_out_str(LPCSTR lpcsz, int nLocation = OUTMSG_SCRIPT_WIN_FORCE_OPEN, BOOL bAddCRLF = true);
//----

OKOC_API int okoc_o(LPCSTR lpcszName, int nCmd); /// EJP 2010-09-15 ORG-1043 ALLOW_DEVELOPERS_TO_CHECK_MODULE_LIC

/// EJP 2007-05-21 v8.0623 QA70-9796 OC_ACCESS_TO_FDLOG
enum {FDLOGTYPE_SAVEAS = 0, FDLOGTYPE_OPEN, FDLOGTYPE_MULTIOPEN};
typedef struct {
	int nDialogType; // see FDLOGTYPE_*
	HWND hWndParent;
	BOOL bAddAllFileTypes;
	LPCSTR lpcszGroupName;

	BOOL bAsReadOnly;
	LPCSTR lpcszCheckName;
	int nCheckStatus;
	LPSTR lpszDefaultFileName;
	int nDefaultType;
	LPSTR lpszDefaultTypeExt;
	LPCSTR lpcszCaption;
	BOOL bMultiSel;

	int nColView;
	LPCSTR lpcszComboName;
	int nComboSel;
	int nSort;
	int nColToggle;

	LPCSTR lpcszOptionDlg;
	LPSTR lpszPath;
	int nShowComment;
	
	///---Sim 07-09-2009 QA80-13891 EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT
#ifdef __EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT__
	BOOL bSuppressPrompt; 
#endif // __EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT__
	///---END QA80-13891 EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT

} FDLOGINFO;
/**$
	Prompt the user with a File Open, Save As, or Multi-Open dialog.
	Parameters:
		fdi = File Dialog Info for setting up the dialog.
		saFileNames = String array to receive the chosen file names.
	Return:
		0 for success, non-zero for error
	Example:
		void Example_okoc_file_dialog()
		{
			FDLOGINFO fdi;
			memset(&fdi, 0, sizeof(FDLOGINFO));
			fdi.nDialogType = FDLOGTYPE_OPEN; // Open dialog
			fdi.lpcszGroupName = "Origin"; // Origin file types group
			fdi.bMultiSel = TRUE; // allow multiple file selection

			StringArray saFileNames;
			okoc_file_dialog(&fdi, &saFileNames);
			
			printf("%d files selected.\n", saFileNames.GetSize());
			for( int i = 0; i < saFileNames.GetSize(); i++ )
				printf("%3d  %s\n", i+1, saFileNames[i]);
		}
*/
OKOC_API int okoc_file_dialog(FDLOGINFO* fdi, StringArray* saFileNames);
/// end OC_ACCESS_TO_FDLOG

//---- CPY 5/25/2007 QA70-9839 NLSF8_LT_VAR_FOR_FIT_CALL_BACK
/**$
*/
OKOC_API int okoc_LT_stack_access(int nMsg, LPCSTR lpstr=NULL, double* pVal=NULL);
//----

//----- CPY 7/24/2007 QA70-10107 SHOULD_NOT_HARD_CODE_RANGE_CONSTRUCTION_IN_OC_LEVEL
//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okoc_get_range_str_(global_function)
*/
OKOC_API int okoc_get_range_str(LPCSTR lpcszBookWks, int nCol, string* pstrRange, DWORD dwRule = 0);

enum {
	COR_DIFF_TYPE = 1, // lpcszRange1 is wks and lpcszRange2 is plot
	COR_DIFF_SHEET,
	COR_DIFF_COL,
	COR_DIFF_ROW, // only if bIgnoreRowRange = false
	COR_DIFF_XCOL, // found XY range but X col diff while Y col same
};

//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okoc_compare_obj_ranges_(global_function)
*/
///------ Folger 02/20/2012 ORG-5078-P1 SUPPORT_ADD_CONTINUOUS_COLUMNS_AS_ONE_BLOCK_IN_COLUMN_BROWSER
//OKOC_API int okoc_compare_obj_ranges(LPCSTR lpcszRange1, LPCSTR lpcszRange2, BOOL bIgnoreRowRange = true);
OKOC_API int okoc_compare_obj_ranges(LPCSTR lpcszRange1, LPCSTR lpcszRange2, BOOL bIgnoreRowRange = true, BOOL bCheckSimpleRangeMutipleCols = FALSE);
///------ End SUPPORT_ADD_CONTINUOUS_COLUMNS_AS_ONE_BLOCK_IN_COLUMN_BROWSER
//-----

///---Sim 09-18-2008 QA80-12203 MOVE_BIN_IMPORT_TO_VC
/**$
*/
OKOC_API BOOL okoc_binary_import(LPCSTR lpcszFilename, LPCSTR lpcszRange, CBINIMP* pcbinimp, TreeNode *ptrInfo = NULL, DWORD dwCtrl = 0);
///---END QA80-12203 MOVE_BIN_IMPORT_TO_VC

//-----CPY 09-18-2008 QA80-12203 MOVE_BIN_IMPORT_TO_VC
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okoc_binary_mat_import_(global_function)
*/
OKOC_API int okoc_binary_mat_import(LPCSTR lpcszFilename, LPCSTR lpcszRangeMat, int nCols, int nElemSize, int nSign, BOOL bBigEndian=false, int nOffset = 0, int nRows = -1); 
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okoc_binary_mat_export_(global_function)
*/
OKOC_API int okoc_binary_mat_export(LPCSTR lpcszRangeMat, LPCSTR lpcszPath, LPCSTR lpcszExt, string* pstrActualFilename, LPCSTR lpcszFilenamePrefix = NULL);

///---Sim 04-08-2010 QA85-15284 SUPPORT_LT_FITTING_WITH_INTEGRAL
enum
{
	LT_INTEG_FUNC_INIT_CACHE = 0x0001,
	LT_INTEG_FUNC_DISPOSE_CACHE = 0x0002,
};
/**$
	Access LabTalk integral function.
	Parameters:
		lpcszLTFuncName = [input] name of LT function
		pVal = [output] return value of LT function
		dX = [input] independent variable of the LT function
		pdParams = [input] parameters of the LT function
		nNumParams = [input] number of parameters
		dwCntrl = [input]
					LT_INTEG_FUNC_INIT_CACHE = used in begin of fast call
					LT_INTEG_FUNC_DISPOSE_CACHE = used in end of fast call					
	Return:
		0 if success, < 0 for error codes, some important ones are 
		-1 lpcszLTFuncName is NULL or empty string
		-2 LT function is not exist
		-3 pVal is NULL
		-4 failed to execute LT function
*/
OKOC_API int okoc_lt_integral_func(LPCSTR lpcszLTFuncName, double *pVal, const double dX, const double *pdParams = NULL, int nNumParams = 0, DWORD dwCntrl = 0);
///---END QA85-15284 SUPPORT_LT_FITTING_WITH_INTEGRAL

//-----
#ifdef __AFX_H__
	}
#endif	//__AFX_H__
#endif //_OK_OC_UTILS_H
