/*------------------------------------------------------------------------------*
 *	File Name: 	ocNR.h									 						*
 *	Purpose:	Numerical Recipes Functions ported for Origin C				   	*
 *				This header is used in VC ocMath DLL as well as in OC files		*
 *  Creation:	3/15/2004, CPY													* 
 *  	Copyright Originlab Corp.		2004, 2005								*
 *																				*
 *	Modification log	                                                        *
 *	//Jean 04/20/04 add for solve linear equation								*
 *	Justin 2007-04-02 MODIFY FUNCTION CATEGORY								*
 *------------------------------------------------------------------------------*/      


#ifndef _OC_NR_H
#define _OC_NR_H
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
// function declarations
//////////////////////////////////////////////////////////
#ifdef _MSC_VER	   //VC
	#ifdef OCMATH_EXPORTS
		#define OCMATH_API __declspec(dllexport)
	/// TD 06-19-2008 QA80-10844 TRICTR_IN_VIEWER
	#elif  defined(MIN_OK_VERSION)
		#define OCMATH_API
	/// end QA80-10844 TRICTR_IN_VIEWER
	#else
		#define OCMATH_API __declspec(dllimport)
	#endif
	extern "C" {
#else //_MSC_VER
	#define OCMATH_API
	#pragma dll(ocMath)	// Assoicate all functions below to ocMath.dll which must be in the Origin EXE folder
#endif	//!_MSC_VER


/**
*/
///Echo 8/6/04 NR_FUNCTIONS_NO_NEED
//OCMATH_API	bool	ocmath_ludcmp(double *pData, int n, int *indx, double *d);

/**
*/
///Echo 8/6/04 NR_FUNCTIONS_NO_NEED
//OCMATH_API	bool	ocmath_lubksb(const double *pLUData, int n, int *indx, double *b);


/**
*/
///Echo 8/6/04 NR_FUNCTIONS_NO_NEED
//OCMATH_API	bool	ocmath_svdcmp(double *a, int m, int n, double *w, double *v);


// Category last updated by Justin on 03/26/2007
/** >Analysis>Basic
*/
OCMATH_API	bool	ocmath_svdcmp_2(double **ppa, int m, int n, double *w, double **ppv);


// Category last updated by Justin on 03/26/2007
/** >Analysis>Basic
*/
OCMATH_API	bool	ocmath_svbksb(double *pu, double *pw, double *pv, int m, int n, double *pb, double *px);


// Category last updated by Justin on 03/26/2007
/** >Analysis>Basic
*/
OCMATH_API	bool	ocmath_svbksb_2(double **ppu, double *pw, double **ppv, int m, int n, double *pb, double *px);


/**
*/
typedef void (*OCMATH_SVDFIT_FUN)(double, double*);
///Echo 8/6/04 NR_FUNCTIONS_NO_NEED
//OCMATH_API	bool ocmath_svdfit(double* px, int m, double* py, int n, double* psig, int nsig, double* pa, 
//							   double* pu, double* pv, double* pw, double* chisq, OCMATH_SVDFIT_FUN funcs);

/**
	Kolmogorov-Smirnov test of data against model
*/
typedef double (*OCMATH_KSONE_FUN)(double);
OCMATH_API	bool ocmath_ksone( int n, double* b, OCMATH_KSONE_FUN fun, double* pd, double* pprob ); ///Iris 05/05/04
//OCMATH_API	bool ocmath_ksone( int n, double* b, double fun(const double), double* pd, double* pprob );

/**
	Sample:
		#include <ocNR.h>
		void test_gammq()
		{
			bool bRet;
			double a = 10, x = 10, r;
			
			bRet =  ocmath_gammq(a, x, &r);
			if(bRet)
				out_double("result is: ",r);	
		}
*/
///Echo 8/6/04 NR_FUNCTIONS_NO_NEED
//OCMATH_API	bool ocmath_gammq(double a, double x, double* pR);


///Echo 8/6/04 NR_FUNCTIONS_NO_NEED
//OCMATH_API  bool ocmath_probks(double alam, double* pR);


///Echo 8/6/04 NR_FUNCTIONS_NO_NEED
//OCMATH_API  bool ocmath_fpoly(const double x, double* p, int n);

//Jean 04/20/04 add for solve linear equation
///Echo 8/6/04 NR_FUNCTIONS_NO_NEED
//OCMATH_API bool ocmath_gaussj(double *a, double *b, int n);

///---Echo 4/22/04 
///Echo 8/6/04 NR_FUNCTIONS_NO_NEED
//OCMATH_API bool ocmath_gaussj2(double* a, double* b, int m, int n);
//Forest 07/08/04: combine the above two gaussj functions
//OCMATH_API bool ocmath_gaussj(double* a, double* b, int m, int n = 1);

#ifdef _MSC_VER
	}
#endif	//_MSC_VER


//////////////////////////////////////////////////////////////////////////
#endif _OC_NR_H
