/*------------------------------------------------------------------------------*
 * File Name: ocImgLT.h	 														*
 * Creation: 2010-08-18															*
 * Purpose: header for LeadTools dll function									*
 * Copyright (c) OriginLab Corp. 2010											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 6/23/2011 O9_64bit_LEADTOOLS												*
 * EJP 2011-07-18 ifdef __LEADTOOLS_64bit__ to load 'x' DLLs instead of 'u'.	*
 *	Sophy 11/1/2011 ORG-4194-P1 LEADTOOLS_USE_UNICODE_TCHAR_IN_DLL				*
 *------------------------------------------------------------------------------*/
#pragma PCH

#ifndef _OC_IMG_LT_H
#define _OC_IMG_LT_H

#include <lt_ver.h>

#pragma pack(push, 1)


#if LEADTOOLS_VER == 17

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// OriginLab

#define L_FAR                   /* segmented memory attribute < 64K */
#define L_HUGE                  /* segmented memory attribute > 64K */

#define EXT_FUNCTION    WINAPI
#define L_EXPORT                /* export attribute */
#define L_PASCAL                /* pascal calling convention */
#define L_LTKRN_API

// All return values > 1 are also successful
#define SUCCESS                          1   /** Function successful                               **/
#define FAILURE                          0   /** Function not successful                           **/

#if !defined(_MAX_FNAME)
#define _MAX_FNAME  256 /* max. length of file name component */
#define _MAX_EXT    256 /* max. length of extension component */
#endif // #if !defined(_MAX_FNAME)

typedef struct tagRGBQUAD {
        BYTE    rgbBlue;
        BYTE    rgbGreen;
        BYTE    rgbRed;
        BYTE    rgbReserved;
} RGBQUAD;
typedef RGBQUAD L_FAR* LPRGBQUAD;

typedef char L_CHAR;            /* signed 8-bit integer */
typedef char L_TCHAR;
///Sophy 11/1/2011 ORG-4194-P1 LEADTOOLS_USE_UNICODE_TCHAR_IN_DLL
typedef USHORT L_WCHAR;
///end LEADTOOLS_USE_UNICODE_TCHAR_IN_DLL
typedef unsigned char L_UCHAR;  /* unsigned 8-bit integer */
typedef short L_INT16;          /* signed 16-bit integer */
typedef unsigned short L_UINT16;/* unsigned 16-bit integer */
typedef long L_INT32;           /* signed 32-bit integer */
typedef unsigned long L_UINT32; /* unsigned 32-bit integer */
typedef int L_INT;              /* signed integer 16-bits or larger */
typedef unsigned int L_UINT;        /* unsigned integer 16-bits or larger */
typedef void L_VOID;            /* void */
typedef L_UINT L_BOOL;          /* boolean */
typedef L_UINT L_BITFIELD;      /* bit field */
typedef float  L_FLOAT;         /* floating point number */
typedef double L_DOUBLE;        /* double precision floating point number */
/// ML 6/23/2011 O9_64bit_LEADTOOLS
#ifdef	__NOT32
typedef OULP L_SIZE_T;
typedef OLP L_SSIZE_T;
#else	// !__NOT32
/// end O9_64bit_LEADTOOLS
typedef L_UINT32 L_SIZE_T;
typedef long L_SSIZE_T;
/// ML 6/23/2011 O9_64bit_LEADTOOLS
#endif	// !__NOT32
/// end O9_64bit_LEADTOOLS

typedef COLORREF L_COLORREF;
typedef HANDLE L_HPALETTE;
typedef HBITMAP L_HBITMAP;
typedef HDC L_HDC;
typedef HDIB L_HDIB;
typedef POINT L_POINT;
typedef RECT L_RECT;
typedef RGBQUAD L_RGBQUAD;      /* RGBQUAD structure */

typedef struct tagLOG256PALETTE
{
   L_UINT16 palVersion;
   L_UINT16 palNumEntries;
   PALETTEENTRY palPalEntry[256];
} LOG256PALETTE;

typedef struct tagL_RGBQUAD16
{
   L_UINT16 rgbBlue;
   L_UINT16 rgbGreen;
   L_UINT16 rgbRed;
   L_UINT16 rgbReserved;
} L_RGBQUAD16;

typedef L_VOID CRITICAL_SECTION;
typedef struct tagL_UINT64
{
	L_UINT32 lo;
	L_UINT32 hi;
} L_UINT64; // 64-bit unsigned integer

//typedef LPVOID pLOADFILEOPTION;

#define L_FileInfo L_FileInfoA
#define L_FileInfoMemory L_FileInfoMemoryA
#define L_LoadBitmap L_LoadBitmapA
#define L_LoadBitmapList L_LoadBitmapListA
#define L_SaveBitmap L_SaveBitmapA
#define L_SaveBitmapList L_SaveBitmapListA
#define	L_GetDefaultSaveFileOption	L_GetDefaultSaveFileOptionA	///Sophy 11/1/2011 ORG-4194-P1 LEADTOOLS_USE_UNICODE_TCHAR_IN_DLL

#define L_CHANGE_BITMAP_VIEW_PERSPECTIVE(_pDstBitmap, _pSrcBitmap, _nViewPerspective) \
	L_ChangeBitmapViewPerspective(_pDstBitmap, _pSrcBitmap, sizeof(BITMAPHANDLE), _nViewPerspective)
#define L_CHANGE_FROM_DIB(_pBitmap, _hDIB) \
	L_ChangeFromDIB(_pBitmap, sizeof(BITMAPHANDLE), _hDIB)
#define L_CHANGE_TO_DIB(_pBitmap) \
	L_ChangeToDIB(_pBitmap, DIB_BITMAPINFOHEADER)
#define L_CHANGE_VIEW_PERSPECTIVE(_pDst, _pSrc, _view) \
	L_ChangeBitmapViewPerspective(_pDst, _pSrc, sizeof(BITMAPHANDLE), _view)
#define L_CONVERT_FROM_DIB(_pBitmap, _pInfo, _pBits) \
	L_ConvertFromDIB(_pBitmap, sizeof(BITMAPHANDLE), _pInfo, _pBits)
#define L_COPY_BITMAP(_pBitmapDst, _pBitmapSrc) \
	L_CopyBitmap(_pBitmapDst, _pBitmapSrc, sizeof(BITMAPHANDLE))
#define L_COPY_BITMAP_RECT(_pBitmapDst, _pBitmapSrc, _nCol, _nRow, _uWidth, _uHeight) \
	L_CopyBitmapRect(_pBitmapDst, _pBitmapSrc, sizeof(BITMAPHANDLE), _nCol, _nRow, _uWidth, _uHeight)
#define L_CREATE_BITMAP(_pBitmap, _uMemory, _uWidth, _uHeight, _uBitsPerPixel, _uOrder, _pPalette, _uViewPerspective, _pData, _dwSize) \
	L_CreateBitmap(_pBitmap, sizeof(BITMAPHANDLE), _uMemory, _uWidth, _uHeight, _uBitsPerPixel, _uOrder, _pPalette, _uViewPerspective, _pData, _dwSize)
#define L_FILE_INFO(_pszFile, _pFileInfo, _uFlags, _pLoadOptions) \
	L_FileInfo((LPSTR)_pszFile, _pFileInfo, sizeof(FILEINFO), _uFlags, _pLoadOptions)
#define L_GET_BITMAP_LIST_ITEM(_hList, _uIndex, _pBitmap) \
	L_GetBitmapListItem(_hList, _uIndex, _pBitmap, sizeof(BITMAPHANDLE))
#define	L_GET_DEFAULT_LOAD_FILE_OPTION(_pLoadOptions) \
	L_GetDefaultLoadFileOption(_pLoadOptions, sizeof(LOADFILEOPTION))
#define L_INIT_BITMAP(_pBitmap, nWidth, nHeight, nBitsPerPixel) \
	L_InitBitmap(_pBitmap, sizeof(BITMAPHANDLE), nWidth, nHeight, nBitsPerPixel)
#define L_LOADBITMAP(_pszFile, _pBitmap, _nBitsPerPixel, _nOrder, _pLoadOptions) \
	L_LoadBitmap((LPSTR)_pszFile, _pBitmap, sizeof(BITMAPHANDLE), _nBitsPerPixel, _nOrder, _pLoadOptions, NULL)
#define L_SET_WMF_RESOLUTION(_nRes) \
	L_SetWMFResolution(_nRes, _nRes)

//==========================================================================
// typedef from ltfil header
//==========================================================================

typedef enum
{
   // Page width, height and margins are in pixels
   RASTERIZEDOC_UNIT_PIXEL,
   // Page width, height and margins are in inches
   RASTERIZEDOC_UNIT_INCH,
   // Page width, height and margins are in millimeters
   RASTERIZEDOC_UNIT_MILLIMETER
}
RASTERIZEDOC_UNIT;

typedef enum
{
   PME_MINISWHITE = 0,  // min value is white
   PME_MINISBLACK = 1,  // min value is black
   PME_RGB        = 2,  // RGB color model
   PME_PALETTE    = 3,  // color map indexed
   PME_MASK       = 4,  // $holdout mask
   PME_SEPARATED  = 5,  // !color separations
   PME_YCBCR      = 6,  // !CCIR 601
   PME_CIELAB     = 8,  // !1976 CIE L*a*b*
}
PHOTMTRICINTERP;

typedef struct _FILEINFO
{
   L_UINT uStructSize;           // use sizeof(FILEINFO)
   L_INT Format;                 // File format: FILE_PCX, ...
   L_CHAR Name[_MAX_FNAME+_MAX_EXT];// File name, including the Ext
   L_INT Width;                  // Image width
   L_INT Height;                 // Image height
   L_INT BitsPerPixel;           // Bits per pixel
   L_SSIZE_T SizeDisk;           // Size of file on disk
   L_SSIZE_T SizeMem;            // Size of image in memory
   L_CHAR Compression[20];      // Compression method name
   L_INT ViewPerspective;        // Image view prespective
   L_INT Order;                  // RGB order
   L_INT PageNumber;             // Page number
   L_INT TotalPages;             // Total number of pages present in the file
   L_INT XResolution;
   L_INT YResolution;
   L_UINT Flags;                 // identifies file subtypes: progressive, interlaced
   L_UINT GlobalLoop;            // Global animation loop count 0 = infinity
   L_INT GlobalWidth;            // Global width
   L_INT GlobalHeight;           // Global height
   L_COLORREF GlobalBackground;  // Global background color (see Flags)
   L_RGBQUAD GlobalPalette[256]; // Global palette (see Flags)
   L_SIZE_T IFD;                 // IFD offset (for TIF files only)
   L_INT Layers;                 // The number of layers in the file
   L_INT ColorSpace;             // The colorspace (RGB, CMYK, CIELAB, etc)
   L_INT Channels;               // The number of channels in the file
   L_BOOL bIsDocFile;            // Is this a DOC file?
   L_DOUBLE dDocPageWidth;       // Only valid for DOC files, the width in unit
   L_DOUBLE dDocPageHeight;      // Only valid for DOC files, the height in unit
   RASTERIZEDOC_UNIT uDocUnit;   // Only valid for DOC files, dDocPageWidth and dDocPageHeight unit
}
FILEINFO, *pFILEINFO;

typedef struct _LOADFILEOPTION
{
   L_UINT uStructSize;  // the size of the LOADFILEOPTION - use sizeof(LOADFILEOPTION)
   L_INT XResolution;
   L_INT YResolution;
   L_UINT Flags;
   L_INT Passes;
   L_INT PageNumber;
   L_UINT GlobalLoop;
   L_SIZE_T IFD;
   L_UINT uRedScan;     // the scan index of the red channel (NITF files only)
   L_UINT uGreenScan;   // the scan index of the green channel (NITF files only)
   L_UINT uBlueScan;    // the scan index of the blue channel (NITF files only)
}
LOADFILEOPTION, *pLOADFILEOPTION;


//==========================================================================
// typedef from ltdis header
//==========================================================================

typedef struct _RGNXFORM
{
   L_UINT uViewPerspective;
   L_INT nXScalarNum;
   L_INT nXScalarDen;
   L_INT nYScalarNum;
   L_INT nYScalarDen;
   L_INT nXOffset;
   L_INT nYOffset;
}
RGNXFORM, *pRGNXFORM;


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltkrn.h
#ifdef __LEADTOOLS_64bit__
#pragma dll(ltkrnx)
#else // !__LEADTOOLS_64bit__
#pragma dll(ltkrnu)
#endif // !__LEADTOOLS_64bit__

// flag that you can use to detect when a pixel color is 16 bit grayscale
#define COLORREF_GRAY16              0x04000000L
#define L_IS_COLORREF_GRAY16(clr)    ((clr & 0xFF000000) == COLORREF_GRAY16)
#define L_IS_COLORREF_INDEXED1(clr)  ((clr & 0xFF000000) == 0x01000000L)
#define L_IS_COLORREF_INDEXED2(clr)  ((clr & 0xFF000000) == 0x80000000L)

/*
  define for BITMAPHANDLE
*/

#define ORDER_RGB                0 /* RGB ordering */
#define ORDER_BGR                1 /* BGR ordering */
#define ORDER_GRAY               2 /* Gray pixels */
#define ORDER_RGBORGRAY          3 /* Valid only for L_LoadXXX functions - gray or RGB */
#define ORDER_BGRORGRAY          4 /* Valid only for L_LoadXXX functions - gray or BGR */
#define ORDER_ROMM               5 /* BGR Wide gamut format */
#define ORDER_BGRORGRAYORROMM    6 /* Valid only for L_LoadXXX functions - gray or BGR or ROMM */

typedef struct _BITMAPHANDLE
{
   L_UINT uStructSize;
#ifdef JUNK // replace union with eight byte array
   union
   {
      struct
      {
         L_HANDLE hData;  // internal use
         L_VOID **ppData; // internal use
      }
      Compressed;

      struct
      {
         L_HANDLE hData;  // Internal use
         L_UCHAR* pData;   // Internal use
      }
      Windows;

      struct
      {
         L_HFILE fd;         // Internal use
         L_UINT Available; // Internal use
      }
      File;

      #if !defined(FOR_WINCE)
      struct
      {
         L_HANDLE hData;  // Internal use
         L_UCHAR* pData;   // Internal use
      }
      Tiled;
      #endif //#if !defined(FOR_WINCE)

      struct
      {
         L_HANDLE hData;  // internal use
         L_VOID* pData;    // internal use
      }
      SuperCompressed;
   }
   Addr;
#endif // JUNK
	/// ML 6/23/2011 O9_64bit_LEADTOOLS
	//BYTE Addr[8];
#ifdef		__NOT32
	BYTE Addr[16];		// 16 is the size in 64bit of the compiled-out union above
#else		// !__NOT32
	BYTE Addr[8];
#endif		// !__NOT32
	/// end O9_64bit_LEADTOOLS

   L_INT Width;                 // Image width
   L_INT Height;                // Image height
   L_INT BitsPerPixel;          // Number of bits per pixel
   L_UINT BytesPerLine;         // Bytes per line, rounded by four
   L_SIZE_T CurrentPos;         // Internal use
   L_INT CurrentRow;            // Internal use

   struct _BitFlags
   {
      L_BITFIELD Allocated:1;             // Is the bitmap allocated?
      L_BITFIELD ConventionalMemory:1;    // allocated in conventional memory
      L_BITFIELD DiskMemory:1;            // allocated on disk
      L_BITFIELD ProgressiveAvailable:1;  // progressive format
      L_BITFIELD LockedMemory:1;          // Is memory locked in windows
      L_BITFIELD Interlaced:1;            // Interlaced format
      L_BITFIELD WaitUserInput:1;         // Playback wait for user input
      L_BITFIELD Transparency:1;          // Playback uses transparency
      L_BITFIELD Compressed:1;            // 1 bit RLE compressed data
      L_BITFIELD Signed:1;                // the pixel values are signed
      L_BITFIELD Mirror:1;                // this is a mirror of another image
      L_BITFIELD UseLUT:1;                // use pLUT for image processing
      L_BITFIELD Global:1;                // hData is HGLOBAL
      L_BITFIELD UsePaintLUT:1;           // Use PaintGamma, PaintContrast, PaintIntensity
      L_BITFIELD Tiled:1;                 // Bitmap is stored as tiles
      L_BITFIELD SuperCompressed:1;       // Super compressed data
      L_BITFIELD NoClip:1;                // Do not clip region
      L_BITFIELD Dummy:15;
   }
   Flags;

   L_INT nColors;                // No. of possible colors in the bitmap
   L_RGBQUAD* pPalette;          // Pointer to a L_RGBQUAD array containing the palette

   L_INT ViewPerspective;        // Is TOP_LEFT, BOTTOM_RIGHT, ...
   L_INT Order;                  // Is it ORDER_RGB, ORDER_BGR
   L_SIZE_T Size;                // Size of the bitmap
   L_VOID* pDitherData;          // Internal use
   L_UINT DitheringMethod;       // Which dithering method used
   #if !defined(FOR_WINCE)
   L_VOID* pRgnInfo;             // Internal use
   #endif // #if !defined(FOR_WINCE)
   L_INT XResolution;            // Bitmaps X resolution (DPI)
   L_INT YResolution;            // Bitmaps Y resolution (DPI)
   L_INT Left;                   // Left playback offset
   L_INT Top;                    // Top playback offset
   L_UINT Delay;                 // Playback delay (ms)
   L_COLORREF Background;        // Playback background color
   L_COLORREF Transparency;      // Playback transparent color
   L_UINT DisposalMethod;        // Playback disposal method
   L_INT LowBit;                 // low bit set by L_WindowLevelBitmap
   L_INT HighBit;                // high bit set by L_WindowLevelBitmap
   L_RGBQUAD* pLUT;              // LUT set by L_WindowLevel or L_WindowLevelBitmap
   L_UINT LUTLength;             // no of entries pointed by LUT
   L_SIZE_T DataOffset;          // offset into hData
   L_INT MinVal;                 // min val for a grayscale bitmap
   L_INT MaxVal;                 // max val for a grayscale bitmap
   L_INT PaintLowBit;            // low bit set by L_WindowLevelBitmap
   L_INT PaintHighBit;           // high bit set by L_WindowLevelBitmap
   L_UINT PaintGamma;            // Paint gamma value to be used during painting
   L_INT PaintContrast;          // Paint contrast value to be used during painting
   L_INT PaintIntensity;         // Paint intensity value to be used during painting
   L_UCHAR* pPaintLUT;           // Paint LUT generated from PaintIntensity, PaintGamma, PaintIntensity
   L_VOID* pOverlaysInfo;        // Internal use
   L_INT OriginalFormat;         // Original file format of this bitmap

#if LEADTOOLS_VER >= 16//defined(LEADTOOLS_V16_OR_LATER)
#if !defined(FOR_WINCE)
   L_VOID* pDicomData;           // used by ltdic to store DICOM specific data
   L_SIZE_T uDicomDataLength;    // size of DICOM specific data
   L_UINT32 LUTLength16;         // number of entries pointed by LUT16
   L_RGBQUAD16 *pLUT16;          // 16-bit LUT set by L_WindowLevelExt or L_WindowLevelBitmapExt
   L_UINT16 *pPaintLUT16;        // 16-bit paint LUT generated from PaintIntensity, PaintGamma, PaintIntensity
   CRITICAL_SECTION* pCriticalSection;
   L_UINT64 Size64;              // Size of the bitmap data in bytes; use instead of Size
   L_UINT64 CurrentPos64;        // Internal use
#endif // #if !defined(FOR_WINCE)
#endif // #if defined(LEADTOOLS_V16_OR_LATER)
   L_UINT32 Reserved;            // reserved field, do not use
} BITMAPHANDLE, *pBITMAPHANDLE;

typedef HANDLE HPALETTE;

typedef HANDLE HBITMAPLIST;	//used as a handle to a list of bitmaps.
typedef HBITMAPLIST L_FAR * pHBITMAPLIST; // used as a pointer to an HBITMAPLIST variable.

typedef struct tagBITMAPINFOHEADER{
        DWORD      biSize;
        LONG       biWidth;
        LONG       biHeight;
        WORD       biPlanes;
        WORD       biBitCount;
        DWORD      biCompression;
        DWORD      biSizeImage;
        LONG       biXPelsPerMeter;
        LONG       biYPelsPerMeter;
        DWORD      biClrUsed;
        DWORD      biClrImportant;
} BITMAPINFOHEADER, *LPBITMAPINFOHEADER, *PBITMAPINFOHEADER;

typedef struct tagBITMAPINFO {
    BITMAPINFOHEADER    bmiHeader;
    RGBQUAD             bmiColors[1];
} BITMAPINFO, *LPBITMAPINFO, *PBITMAPINFO;

typedef L_INT (WINAPI *COLORRESCALLBACK) (pBITMAPHANDLE, L_UCHAR L_FAR *, L_INT, LPVOID);


/*
    flags for L_IsGrayScaleBitmap
*/
#define GRAY_NO				0  //Not grayscale.
#define GRAY_ORDEREDNORMAL	1  //Normally ordered grayscale (dark to light).
#define GRAY_ORDEREDINVERSE	2  //Reverse ordered grayscale (light to dark).
#define GRAY_NOTORDERED		3  //Unordered grayscale.

/*
    flags for L_ColorResBitmapList
*/
#define CRF_FIXEDPALETTE		0x01	// Use LEAD's fixed palette.
#define CRF_OPTIMIZEDPALETTE	0x02	// Create an optimized palette.
#define CRF_NETSCAPEPALETTE		0x40	// Use the fixed palette that is employed by Netscape Navigator and by Microsoft Internet Explorer.
#define CRF_USERPALETTE			0x10	// Use the palette specified in the pPalette parameter.
#define CRF_USERHPALETTE		0x0100	// Use the palette specified in the hPalette parameter, without supplying optimized colors. Please note that this cannot Or-ed with CRF_USERPALETTE.
#define CRF_IDENTITYPALETTE		0x08	// Insert the Windows system palette. You can combine this flag with CRF_OPTIMIZEDPALETTE.
#define CRF_FASTMATCHPALETTE	0x20	// Use a predefined table to speed conversion using your own palette. Refer to L_CreateUserMatchTable.
#define CRF_BYTEORDERBGR		0x04	// Use BGR color order. This flag only has meaning when going to 16 bits per pixel or higher.
#define CRF_BYTEORDERRGB		0x00	// Use RGB color. This flag only has meaning when going to 16 bits per pixel or higher.
#define CRF_BYTEORDERGRAY		0x80	// Grayscale.Destination bitmap should be 12 or 16-bit grayscale.  12 and 16-bit grayscale images are only supported in the Document/Medical Imaging editions .
#define CRF_SLOWMATCH			0x0200	// Use with the CRF_OPTIMIZEDPALETTE flag to use a slower but more accurate matching process.
#define CRF_FAVORPURECOLORS		0x0400	// Give colors that occur frequently in the image palette entries of their own in the optimized palette.
#define CRF_NODITHERING			0x00000000	// Use nearest color matching.
#define CRF_FLOYDSTEINDITHERING	0x00010000	// Use Floyd-Steinberg dithering.
#define CRF_STUCKIDITHERING		0x00020000	// Use Stucki dithering.
#define CRF_BURKESDITHERING		0x00030000	// Use Burkes dithering.
#define CRF_SIERRADITHERING		0x00040000	// Use Sierra dithering.
#define CRF_STEVENSONARCEDITHERING	0x00050000	// Use Stevenson Arce dithering.
#define CRF_JARVISDITHERING			0x00060000	// Use Jarvis dithering.
#define CRF_ORDEREDDITHERING	0x00070000		// Use ordered dithering, which is faster but less accurate than other dithering methods.
#define CRF_CLUSTEREDDITHERING	0x00080000		// Use clustered dithering.
#define CRF_BYTEORDERROMM		0x0800			// Use ROMM color. This flag only has meaning when going to 24 or 48 bits per pixel.

// flags for L_RotateBitmap
#define ROTATE_RESIZE      0x0001
#define ROTATE_RESAMPLE    0x0002
#define ROTATE_BICUBIC     0x0004

// flags for L_SizeBitmap and L_ResizeBitmap
#define SIZE_NORMAL        0x0000
#define SIZE_FAVORBLACK    0x0001
#define SIZE_RESAMPLE      0x0002
#define SIZE_BICUBIC       0x0004

// bitmap data colors order
#define ORDER_RGB                0  // RGB ordering
#define ORDER_BGR                1  // BGR ordering
#define ORDER_GRAY               2  // Gray pixels
#define ORDER_RGBORGRAY          3  // Valid only for L_LoadXXX functions - gray or RGB
#define ORDER_BGRORGRAY          4  // Valid only for L_LoadXXX functions - gray or BGR
#define ORDER_ROMM               5  // BGR Wide gamut format
#define ORDER_BGRORGRAYORROMM    6  // Valid only for L_LoadXXX functions - gray or BGR or ROMM

// view perspectives
#define TOP_LEFT        1  // Top-left of image is first in memory
#define BOTTOM_LEFT     4  // Bottom-left of image is first in memory

#define TOP_RIGHT       2  // Top-right of image is first in memory
#define BOTTOM_LEFT180  2  // TOP_RIGHT is BOTTOM_LEFT rotated clockwise by 180 degrees
#define BOTTOM_RIGHT    3  // Bottom-right of image is first in memory
#define TOP_LEFT180     3  // BOTTOM_RIGHT is TOP_LEFT rotated clockwise by 180 degrees

#define RIGHT_TOP       6  // First row is the right side, first column is top side
#define TOP_LEFT90      6  // RIGHT_TOP is TOP_LEFT rotated clockwise by 90 degrees 
#define LEFT_BOTTOM     8  // First row is the left side, first column is top side
#define TOP_LEFT270     8  // LEFT_BOTTOM is TOP_LEFT rotated clockwise by 270 degrees 

#define LEFT_TOP        5  // First row is the left side, first column is the top side
#define BOTTOM_LEFT90   5  // LEFT_TOP is BOTTOM_LEFT rotated clockwise by 90 degrees
#define RIGHT_BOTTOM    7  // First row is the right side, first column is the bottom side
#define BOTTOM_LEFT270  7  // RIGHT_BOTTOM is BOTTOM_LEFT rotated clockwise by 270 degrees

// memory allocation flags
#define TYPE_CONV             0x0001   // Use conventional memory first
#define TYPE_USER             0x0002   // Create a bitmap where the user maintains the data pointer
#define TYPE_TILED            0x0004   // Create tiled bitmap first
#define TYPE_NOTILED          0x0008   // Do not use tiled bitmaps
#define TYPE_DISK             0x0080   // Use Disk (if possible)
#define TYPE_NODISK           0x0100   // Do not use disk
#define TYPE_COMPRESSED       0x0200   // keep 1 bit images compressed in memory
#define TYPE_SUPERCOMPRESSED  0x0400   // keep 24 bit images compressed in memory - slow access

// constants for L_ConvertToDIB
#define DIB_BITMAPINFOHEADER  0
#define DIB_BITMAPV4HEADER    1
#define DIB_BITMAPV5HEADER    2


L_INT EXT_FUNCTION L_InitBitmap(
   pBITMAPHANDLE pBitmap,
   L_UINT uStructSize,
   L_INT nWidth,
   L_INT nHeight,
   L_INT nBitsPerPixel);

L_INT EXT_FUNCTION L_CreateBitmap(
   pBITMAPHANDLE pBitmap,
   L_UINT uStructSize,
   L_UINT uMemory,
   L_UINT uWidth,
   L_UINT uHeight,
   L_UINT uBitsPerPixel,
   L_UINT uOrder,
   L_RGBQUAD* pPalette,
   L_UINT uViewPerspective,
   L_UCHAR* pData,
   L_SIZE_T dwSize);

L_VOID EXT_FUNCTION L_FreeBitmap(
   pBITMAPHANDLE pBitmap);

L_INT EXT_FUNCTION L_FillBitmap(
   pBITMAPHANDLE pBitmap,
   L_COLORREF crFill);

L_INT EXT_FUNCTION L_GrayScaleBitmap(
   pBITMAPHANDLE pBitmap,
   L_INT nBitsPerPixel);

L_INT EXT_FUNCTION L_GrayScaleBitmapEx(
   pBITMAPHANDLE pBitmap,
   L_INT nRedFact,
   L_INT nGreenFact,
   L_INT nBlueFact);

L_INT EXT_FUNCTION L_ChangeFromDIB(
   pBITMAPHANDLE pBitmap,
   L_UINT uStructSize,
   L_HDIB hDIB);

HGLOBAL EXT_FUNCTION L_ChangeToDIB(pBITMAPHANDLE pBitmap, L_UINT uType = DIB_BITMAPINFOHEADER);
HGLOBAL EXT_FUNCTION L_ConvertToDIB(pBITMAPHANDLE pBitmap, L_UINT uType);

L_INT EXT_FUNCTION L_ConvertFromDIB(
	pBITMAPHANDLE pBitmap,
	L_UINT uStructSize,
	BITMAPINFO L_FAR * pInfo,
	L_UCHAR L_FAR * pBits);

L_INT EXT_FUNCTION L_RotateBitmap(
	pBITMAPHANDLE pBitmap,
	L_INT32 nAngle,
	L_UINT uFlags,
	COLORREF crFill);

L_INT EXT_FUNCTION L_ColorResBitmap(
	pBITMAPHANDLE pBitmapSrc,
	pBITMAPHANDLE pBitmapDst,
	L_UINT uStructSize,
	L_INT nBitsPerPixel,
	L_UINT32 uFlags,
	LPRGBQUAD pPalette,
	HPALETTE hPalette,
	L_UINT uColors,
	COLORRESCALLBACK pfnCallback,
	L_VOID L_FAR * pUserData);

L_INT EXT_FUNCTION L_GetBitmapColors(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nIndex,	/* index to the first color to get */
	L_INT nCount,	/* number of colors to get */
	LPRGBQUAD pPalette);	/* array values that make up your palette */

L_INT EXT_FUNCTION L_PutBitmapColors(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle to update */
	L_INT nIndex,	/* index of the first color to update */
	L_INT nCount,	/* number of colors to update */
	LPRGBQUAD pPalette);	/* pointer to your palette */

L_INT EXT_FUNCTION L_SetBitmapListItem(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* index of the bitmap to overwrite */
	pBITMAPHANDLE pBitmap);	/* pointer to the source bitmap handle */

L_INT EXT_FUNCTION L_GetBitmapListItem(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* position of the bitmap in the list */
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uStructSize);	/* size in bytes, of the structure pointed to by pBitmap */

COLORREF EXT_FUNCTION L_TranslateBitmapColor(
	pBITMAPHANDLE pBitmapDst,	/* pointer to the destination bitmap handle */
	pBITMAPHANDLE pBitmapSrc,	/* pointer to the source bitmap handle */
	COLORREF crColor);	/* color in the source bitmap */

L_INT EXT_FUNCTION L_RemoveBitmapListItem(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* position of the bitmap in the list */
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

L_INT EXT_FUNCTION L_InsertBitmapListItem(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* position at which to insert the bitmap */
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

L_INT EXT_FUNCTION L_GetBitmapListCount(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT L_FAR * puCount);	/* address of the variable to be updated */

L_INT EXT_FUNCTION L_DeleteBitmapListItems(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* index of the first bitmap to delete */
	L_UINT uCount);	/* number of bitmaps to delete */

L_INT EXT_FUNCTION L_ColorResBitmapList(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_INT nBitsPerPixel,	/* target bits per pixel */
	L_UINT32 uFlags,	/* processing options */
	LPRGBQUAD pPalette,	/* custom palette to use */
	HPALETTE hPalette,	/* custom palette handle to use */
	L_UINT uColors);	/* number of colors in the palette */

L_INT EXT_FUNCTION L_DestroyBitmapList(
	HBITMAPLIST hList);	/* handle to the list of bitmaps */

L_INT EXT_FUNCTION L_CreateBitmapList(
	pHBITMAPLIST phList);	/* address of the variable to be updated */

L_INT EXT_FUNCTION L_CopyBitmapListItems(
	pHBITMAPLIST phList,	/* address of the variable to be updated */
	HBITMAPLIST hList,	/* handle to an existing list of bitmaps */
	L_UINT uIndex,	/* index of the first bitmap to copy */
	L_UINT uCount);	/* number of bitmaps to copy */

L_INT EXT_FUNCTION L_IsGrayScaleBitmap(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

L_INT EXT_FUNCTION L_ShearBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nAngle,	/* angle of slant */
	L_BOOL fHorizontal,	/* TRUE for horizontal, FALSE for vertical */
	COLORREF crFill);	/* COLORREF value for the fill color */
	
L_INT EXT_FUNCTION L_FlipBitmap(
	pBITMAPHANDLE pBitmap);
	
L_INT EXT_FUNCTION L_ReverseBitmap(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */
	
L_INT EXT_FUNCTION L_TrimBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nCol,	/* x coordinate origin of the rectangle to keep */
	L_INT nRow,	/* y coordinate origin of the rectangle to copy */
	L_UINT uWidth,	/* width of the rectangle to keep (in pixels) */
	L_UINT uHeight);	/* height of the rectangle to keep (in pixels) */

L_INT EXT_FUNCTION L_CopyBitmap(
	pBITMAPHANDLE pBitmapDst,	/* points to the destination bitmap handle */
	pBITMAPHANDLE pBitmapSrc,	/* points to the source bitmap handle */
	L_UINT uStructSize);	/* size in bytes, of the structure pointed to by pBitmapDst */
	
L_INT EXT_FUNCTION L_FileInfoMemory(
	L_CHAR L_FAR* pBuffer,	/* pointer to the file location in memory */
	pFILEINFO pFileInfo,	/* pointer to the LEAD FILEINFO structureFILEINFO */
	L_UINT uStructSize,	/* size in bytes, of the structure pointed to by pFileInfo */
	L_INT32 nBufferSize,	/* size in bytes of the file */
	L_UINT uFlags,	/* flag */
	pLOADFILEOPTION pLoadOptions);	/* pointer to optional extended load options */

HPALETTE EXT_FUNCTION L_DupBitmapPalette(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

L_INT EXT_FUNCTION L_ClearBitmap(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */
	
L_INT EXT_FUNCTION L_CopyBitmapRect(
	pBITMAPHANDLE pBitmapDst,	/* pointer to the destination bitmap handle */
	pBITMAPHANDLE pBitmapSrc,	/* pointer to the source bitmap handle */
	L_UINT uStructSize,	/* size in bytes, of the structure pointed to by pBitmapDst */
	L_INT nCol,	/* x coordinate origin of the rectangle to copy */
	L_INT nRow,	/* Y coordinate origin of the rectangle to copy */
	L_UINT uWidth,	/* width of the rectangle to copy (in pixels) */
	L_UINT uHeight);	/* height of the rectangle to copy (in pixels) */

L_INT EXT_FUNCTION L_ChangeBitmapViewPerspective(
	pBITMAPHANDLE pDstBitmap,
	pBITMAPHANDLE pSrcBitmap,
	L_UINT uStructSize,
	L_INT ViewPerspective);
	
L_INT EXT_FUNCTION L_CopyBitmapPalette(
	pBITMAPHANDLE pBitmapDst,	/* pointer to the destination bitmap handle */
	pBITMAPHANDLE pBitmapSrc);	/* pointer to the source bitmap handle */

L_INT EXT_FUNCTION L_SetBitmapPalette(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	HPALETTE hPalette);	/* handle to a Windows GDI palette */

L_INT EXT_FUNCTION L_SizeBitmap(
   pBITMAPHANDLE pBitmap,
   L_INT nWidth,
   L_INT nHeight,
   L_UINT uFlags);

L_SSIZE_T EXT_FUNCTION L_GetBitmapRow(
	pBITMAPHANDLE pBitmap, /* pointer to the bitmap handle */
	L_UCHAR* pBuffer, /* pointer to the source buffer */
	L_INT nRow, /* number of the row to retrieve */
	L_SIZE_T uBytes); /* number of bytes to retrieve */
	
L_INT EXT_FUNCTION L_PutBitmapRow(
	pBITMAPHANDLE pBitmap, /* pointer to the bitmap handle */
	L_UCHAR L_FAR * pBuffer, /* pointer to the source buffer */
	L_INT nRow, /* number of the row to update */
	L_UINT32 uBytes); /* number of bytes to update */

L_INT EXT_FUNCTION L_PutBitmapRowCol(
	pBITMAPHANDLE pBitmap, /* pointer to the bitmap handle */
	L_UCHAR L_FAR * pBuffer, /* pointer to the source buffer */
	L_INT nRow, /* number of the row to update */
	L_INT nCol, /* column offset within the row to update */
	L_UINT32 uBytes); /* number of bytes to update */	


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltfil.h
#ifdef __LEADTOOLS_64bit__
#pragma dll(ltfilx)
#else // !__LEADTOOLS_64bit__
#pragma dll(ltfilu)
#endif // !__LEADTOOLS_64bit__

// List of file types supported
#define FILE_UNKNOWN_FORMAT               0

#define FILE_PCX                          1    // ZSoft PCX
#define FILE_GIF                          2    // CompuServe GIF
#define FILE_TIF                          3    // Tagged Image File Format
#define FILE_TGA                          4    // Targa
#define FILE_CMP                          5    // LEAD CMP
#define FILE_BMP                          6    // Windows BMP
#define FILE_TIFLZW                       17   // TIF Format with LZW compression
#define FILE_TIFLZW_CMYK                  86   // TIFF LZW compression,     CMYK data
#define FILE_TIFLZW_YCC                   94   // TIFF YCbCr color space, LZW compression

// Flags for L_FileInfo (not to make up FILEINFO.Flags!)
#define FILEINFO_TOTALPAGES   0x00000001  // fill in FILEINFO.TotalPages

// Flags for the SAVEFILEOPTION structure
#define ESO_REVERSEBITS                      0x00000001
#define ESO_NOSUBFILETYPE                    0x00000002
#define ESO_GLOBALBACKGROUND                 0x00000004
#define ESO_GLOBALPALETTE                    0x00000008
#define ESO_INTERLACED                       0x00000010
#define ESO_GLOBALLOOP                       0x00000020
#define ESO_NOPALETTE                        0x00000040  // save grayscale TIF without a palette
#define ESO_SAVEWITHSTAMP                    0x00000080  // save a stamp if format supports it
#define ESO_FIXEDPALETTESTAMP                0x00000100  // save fixed palette stamps
#define ESO_YCCSTAMP                         0x00000200  // save YCbCr stamps
#define ESO_REPLACEPAGE                      0x00000400  // Replace the page specified by PageNumber
#define ESO_INSERTPAGE                       0x00000800  // Insert image before the page specified by PageNumber
#define ESO_JPEGSTAMP                        0x00001000  // save JPEG compressed stamps
#define ESO_DISABLEMMX                       0x00002000  // Do not use MMX optimized code
#define ESO_SAVEOLDJTIF                      0x00004000  // Write old style JTIF files
#define ESO_NOPAGENUMBER                     0x00008000  // Do not save/update the PageNumber tag
#define ESO_DISABLEP3                        0x00010000  // Do not use P3-specific optimized code
#define ESO_USEIFD                           0x00020000  // Use the IFD offset
#define ESO_MOTOROLAORDER                    0x00040000  // When possible, save files in Motorola byte order
#define ESO_WITHOUTTIMESTAMP                 0x00080000  // save without time stamp*/ 

#define ESO_PDF_TEXT_ENCODING_NONE           0x00000000  // PDF, no text encoding
#define ESO_PDF_TEXT_ENCODING_ASCII_BASE85   0x00100000  // PDF, ASCII BASE85 text encoding
#define ESO_PDF_TEXT_ENCODING_ASCII_HEX      0x00200000  // PDF, ASCII HEX text encoding

#define ESO_PDF_TEXT_ENCODING_MASK           0x00300000  // mask of the flags used for PDF text encoding
#define ESO_PAD4                             0x00400000  // Each line is padded to a multiple of 4 bytes (raw data only)
#define ESO_PLT_BEZIER_CURVES                0x00800000  // PLT filter should save bezier curves
#define ESO_PDF_SAVE_USE_BITMAP_DPI          0x01000000  // Use bitmap  DPI in calculating page dimensions when saving a PDF file
#define ESO_PHOTOMETRICINTERPRETATIONVALID   0x02000000
#define ESO_TILEINFOVALID                    0x04000000  // Use TileWidth and TileHeight when saving TIFF files
#define ESO_USEDITHERINGMETHOD               0x08000000  // Use the DitheringMethod in the BITMAPHANDLE
#define ESO_PRESERVEPALETTE                  0x10000000  // Preserve the palette when saving TIFF CCITT files (might decrease compression ratio)
#define ESO_PDF_SAVE_LOW_MEMORY_USAGE        0x20000000  // Try to use less memory when creating a PDF file with JPEG or Fax compression
#define ESO_GENERATEGLOBALPALETTE            0x40000000  // Generate global palette when saving GIF files
#define ESO_USEPREDICTOR                     0x80000000  // Use a predictor when saving LZW data


typedef struct _SAVEFILEOPTION
{
   L_UINT uStructSize;   // the size of the SAVEFILEOPTION - use sizeof(SAVEFILEOPTION)
   L_INT Reserved1;
   L_INT Reserved2;
   L_UINT Flags;
   L_INT Passes;
   L_INT PageNumber;
   L_INT GlobalWidth;
   L_INT GlobalHeight;
   L_UINT GlobalLoop;
   L_COLORREF GlobalBackground;
   L_RGBQUAD GlobalPalette[256];
   L_UINT StampWidth;
   L_UINT StampHeight;
   L_UINT StampBits;
#if !defined(FOR_WINCE)
   // MPEG Specific Options -- Not set by user
   L_BOOL Constrained;
   L_BOOL FieldPic;
   L_INT FrameRate;
   L_INT FramesGOP;
   L_INT PelAspectRatio;
   L_INT ProfileID;
   L_INT LevelID;
   L_INT ChromaFormat;
   L_INT VideoFormat;
   L_INT IntraDcPrec;
   L_INT BitRate;
   L_UCHAR UserInfo[255];     // user defined data to be put in mpeg stream
   // end of the MPEG-specific options
#endif // #if !defined(FOR_WINCE)

   L_SIZE_T IFD;
   L_CHAR szPassword[255];   // password for saving encrypted files
   PHOTMTRICINTERP PhotometricInterpretation;
   L_UINT TileWidth;
   L_UINT TileHeight;
   L_UINT Flags2;             // ESO2_XXX flags
}
SAVEFILEOPTION, *pSAVEFILEOPTION;

L_INT EXT_FUNCTION L_FileInfo(
   L_TCHAR* pszFile,
   pFILEINFO pFileInfo,
   L_UINT uStructSize,
   L_UINT uFlags,
   pLOADFILEOPTION pLoadOptions);
   
L_INT EXT_FUNCTION L_LoadBitmap(
   L_TCHAR* pszFile,
   pBITMAPHANDLE pBitmap,
   L_UINT uStructSize,
   L_INT nBitsPerPixel,
   L_INT nOrder,
   pLOADFILEOPTION pLoadOptions,
   pFILEINFO pFileInfo);

L_INT EXT_FUNCTION L_SaveBitmap(
   L_TCHAR* pszFile,
   pBITMAPHANDLE pBitmap,
   L_INT nFormat,
   L_INT nBitsPerPixel,
   L_INT nQFactor,
   pSAVEFILEOPTION pSaveOptions);

L_INT EXT_FUNCTION L_SaveBitmapList(
   L_TCHAR* lpszFile,
   HBITMAPLIST hList,
   L_INT nFormat,
   L_INT nBits,
   L_INT nQFactor,
   pSAVEFILEOPTION pSaveOptions);

L_INT EXT_FUNCTION L_GetDefaultSaveFileOption(
   pSAVEFILEOPTION pSaveOptions,
   L_UINT uStructSize);

L_INT EXT_FUNCTION L_LoadBitmapList(
   /*L_TCHAR**/LPCSTR lpszFile,
   pHBITMAPLIST phList,
   L_INT nBitsTo,
   L_INT nColorOrder,
   pLOADFILEOPTION pLoadOptions,
   pFILEINFO pFileInfo);

L_INT EXT_FUNCTION L_GetDefaultLoadFileOption(
   pLOADFILEOPTION pLoadOptions,
   L_UINT uStructSize);

   
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltimgclr.h
#ifdef __LEADTOOLS_64bit__
#pragma dll(ltimgclrx)
#else // !__LEADTOOLS_64bit__
#pragma dll(ltimgclru)
#endif // !__LEADTOOLS_64bit__

//--------------L_MathFunctionBitmap Flags---------------------
#define MF_SQR    0x0000
#define MF_LOG    0x0001
#define MF_SQRT   0x0002
#define MF_SIN    0x0003
#define MF_COS    0x0004

//-------------- L_ApplyMathLogicBitmap Flags---------------------
#define AML_VALUE_NOP   0x00000000
#define AML_VALUE_NOT   0x00000010
#define AML_VALUE_0     0x00000020
#define AML_VALUE_1     0x00000030

#define AML_OP_AND      0x00000000
#define AML_OP_OR       0x00000100
#define AML_OP_XOR      0x00000200
#define AML_OP_ADD      0x00000300
#define AML_OP_SUBFACT  0x00000400
#define AML_OP_SUBVALUE 0x00000500
#define AML_OP_ABSDIF   0x00000600
#define AML_OP_MUL      0x00000700
#define AML_OP_DIVFACT  0x00000800
#define AML_OP_DIVVALUE 0x00000900
#define AML_OP_AVG      0x00000A00
#define AML_OP_MIN      0x00000B00
#define AML_OP_MAX      0x00000C00

#define AML_RES_NOP     0x00000000
#define AML_RES_NOT     0x00001000
#define AML_RES_0       0x00002000
#define AML_RES_1       0x00003000

//--------------L_ColorLevelBitmap Flags---------------------
#define LEVEL_RED    0x00000001
#define LEVEL_GREEN  0x00000010
#define LEVEL_BLUE   0x00000100
#define LEVEL_MASTER 0x00001000

//--------------L_AutoColorLevelBitmap Flags---------------------
#define AUTO_LEVEL      0x00000001
#define AUTO_CONTRAST   0x00000002
#define AUTO_INTENSITY  0x00000003
#define AUTO_NOPROCESS  0x00000004

//----------------L_ColorSeparateBitmap/L_ColorMergeBitmap Flags-----------------------
#define COLORSEP_RGB    0x0000   // Use 3 RGB color planes
#define COLORSEP_CMYK   0x0001   // Use 4 CMYK color planes
#define COLORSEP_HSV    0x0002   // Use 3 HSV color planes
#define COLORSEP_HLS    0x0003   // Use 3 HLS color planes
#define COLORSEP_CMY    0x0004   // Use 3 CMY color planes
#define COLORSEP_YUV    0x0005   // Use 3 YUV color planes
#define COLORSEP_XYZ    0x0006   // Use 3 XYZ color planes
#define COLORSEP_LAB    0x0007   // Use 3 XYZ color planes
#define COLORSEP_YCrCb  0x0008   // Use 3 YCrCb color planes
#define COLORSEP_SCT    0x0009   // Use 3 SCT color planes

#define RGB_SPACE    0x0001
#define YUV_SPACE    0x0002
#define GRAY_SPACE   0x0004

//--------------L_ColorThresholdBitmap Flags---------------------
#define CLTH_TYP_BANDPASS     0x00000000
#define CLTH_TYP_BANDREJECT   0x00000001

#define CLTH_MOD_CHANNEL      0x00000000
#define CLTH_MOD_ALL          0x00000010

#define CLTH_VALUE_MIN        0x00000000
#define CLTH_VALUE_MAX        0x00000100
#define CLTH_VALUE_CLAMP      0x00000200

#define CLTH_RGB_SPACE        0x00000000
#define CLTH_HSV_SPACE        0x00000001
#define CLTH_HLS_SPACE        0x00000002
#define CLTH_XYZ_SPACE        0x00000003
#define CLTH_YCrCb_SPACE      0x00000004
#define CLTH_YUV_SPACE        0x00000005
#define CLTH_LAB_SPACE        0x00000006
#define CLTH_CMY_SPACE        0x00000007

//--------------  Internal structure for LVLCLR structure ---------------------
typedef struct _LVLCLRINF
{
   L_INT   uMinInput;
   L_INT   uMaxInput;
   L_INT   uMinOutput;
   L_INT   uMaxOutput;
   L_UINT   uGamma;     // This is value represent a double. 
                        // It should be 100 times the real gamma value.
}
LVLCLRINF, *pLVLCLRINF;

typedef struct _LVLCLR
{
   L_UINT      uStructSize;
   LVLCLRINF   master;
   LVLCLRINF   red;
   LVLCLRINF   green;
   LVLCLRINF   blue;
}
LVLCLR, *pLVLCLR;

//********************** L_BalanceColors Structure**********************
typedef struct _BALANCING
{
   L_UINT   uStructSize;
   L_DOUBLE toRed;
   L_DOUBLE toGreen;
   L_DOUBLE toBlue;
}
BALANCING, *pBALANCING;

//********************** L_ColorThresholdBitmap Structure**********************
typedef struct _COMPDATA
{
   L_UINT   uStructSize;
   L_INT    nMinRange;
   L_INT    nMaxRange;
   L_UINT   uFlags;
}
COMPDATA, *pCOMPDATA;

//********************** L_ColorReplaceBitmap Structure**********************
typedef struct _COLORREPLACE
{
   L_UINT   uStructSize;
   COLORREF crColor;
   L_UINT   uFuzziness;
}
COLORREPLACE, *pCOLORREPLACE, L_FAR *LPCOLORREPLACE;


L_INT EXT_FUNCTION L_ColorLevelBitmap(
   pBITMAPHANDLE  pBitmap,
   pLVLCLR        pLvlClr,
   L_UINT         uFlags);

L_INT  EXT_FUNCTION L_RemapBitmapIntensity (
   pBITMAPHANDLE pBitmap, 
   L_INT  *  pLUT,
   L_UINT uLUTLen,
   L_UINT uFlags);

L_INT EXT_FUNCTION L_DynamicBinaryBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uDim,
   L_UINT         uLocalContrast,
   L_UINT32       uFlags = 0);
   
L_INT EXT_FUNCTION L_ConvertToColoredGray(
   pBITMAPHANDLE  pBitmap,
   L_INT          RedFact,
   L_INT          GreenFact,
   L_INT          BlueFact,
   L_INT          RedGrayFact,
   L_INT          GreenGrayFact,
   L_INT          BlueGrayFact,
   L_UINT32       uFlags = 0);
   
L_INT EXT_FUNCTION L_ApplyMathLogicBitmap(
   pBITMAPHANDLE  pBitmap,
   L_INT          nFactor,
   L_UINT         uFlags);
   
L_INT EXT_FUNCTION L_MathFunctionBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uMType,
   L_UINT         uFactor,
   L_UINT32       uFlags = 0);
   
L_INT EXT_FUNCTION L_InvertBitmap(
   pBITMAPHANDLE pBitmap, 
   L_UINT32       uFlags = 0);
   
L_INT EXT_FUNCTION L_BalanceColors(
   pBITMAPHANDLE  pBitmap,
   BALANCING      *pRedFact,
   BALANCING      *pGreenFact,
   BALANCING      *pBlueFact,
   L_UINT32       uFlags = 0);
   
L_INT EXT_FUNCTION L_ChangeBitmapIntensity(
   pBITMAPHANDLE  pBitmap,
   L_INT          nChange,
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_ChangeBitmapContrast(
   pBITMAPHANDLE  pBitmap,
   L_INT          nChange, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_HistoContrastBitmap(
   pBITMAPHANDLE  pBitmap,
   L_INT          nChange,
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_ChangeBitmapHue(
   pBITMAPHANDLE  pBitmap,
   L_INT          nAngle, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_ChangeBitmapSaturation(
   pBITMAPHANDLE  pBitmap,
   L_INT          nChange,
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_GammaCorrectBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uGamma,
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_GetBitmapHistogram(
   pBITMAPHANDLE  pBitmap,
   L_UINT         *pHisto,
   L_SIZE_T       uHistoLen,
   L_UINT         uFlags);

L_INT EXT_FUNCTION L_HistoEqualizeBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT32       uFlags);
   
L_INT EXT_FUNCTION L_ColorThresholdBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uColorSpace,
   pCOMPDATA      pCompData,
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_IntensityDetectBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uLow,
   L_UINT         uHigh,
   COLORREF       crInColor,
   COLORREF       crOutColor,
   L_UINT         uChannel,
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_AutoColorLevelBitmap(
   pBITMAPHANDLE  pBitmap,
   pLVLCLR        pLvlClr,
   L_UINT         uBlackClip,
   L_UINT         uWhiteClip,
   L_UINT         uFlags);

L_INT EXT_FUNCTION L_AutoBinaryBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_GetBitmapColorCount(
   pBITMAPHANDLE  pBitmap,
   L_UINT         *puCount,
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_ColorReplaceBitmap(
   pBITMAPHANDLE  pBitmap,
   pCOLORREPLACE  pColorReplace,
   L_UINT         uColorCount,
   L_INT          nHue,
   L_INT          nSaturation,
   L_INT          nBrightness,
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_LineProfile(
   pBITMAPHANDLE  pBitmap,
   POINT          FirstPoint,
   POINT          SecondPoint,
   L_INT          **pRed,
   L_INT          **pGreen,
   L_INT          **pBlue,
   L_UINT32       uFlags = 0);
   
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltimgcor.h
#ifdef __LEADTOOLS_64bit__
#pragma dll(ltimgcorx)
#else // !__LEADTOOLS_64bit__
#pragma dll(ltimgcoru)
#endif // !__LEADTOOLS_64bit__

//---------------- Fourier Transform Flags-----------------------
#define FFT_FFT         0x00000001
#define FFT_IFFT        0x00000002
#define FFT_BLUE        0x00000010
#define FFT_GREEN       0x00000020
#define FFT_RED         0x00000030
#define FFT_GRAY        0x00000040
#define FFT_IFFT_MAG    0x00000100
#define FFT_IFFT_PHS    0x00000200
#define FFT_IFFT_BOTH   0x00000300
#define FFT_IFFT_CLIP   0x00001000
#define FFT_IFFT_SCL    0x00002000

//----------------L_GetHistogram, L_RemapBitmapIntensity, and L_AddNoiseBitmap Flags-----------------------
#define CHANNEL_MASTER  0x0000   // All channels
#define CHANNEL_RED     0x0001   // Red channel only
#define CHANNEL_GREEN   0x0002   // Green channel only
#define CHANNEL_BLUE    0x0003   // Blue channel only

#define HIST_ALL_BITS      0x0010
#define HIST_LOWHIGH_BITS  0x0000

//-------------- L_CountLUTColors flags-----------------------------
#define COUNT_LUT_UNSIGNED 0x0001
#define COUNT_LUT_SIGNED   0x0002

//---------------- L_IntensityDetectBitmap Flags-----------------------
#define IDB_CHANNEL_MASTER 0x0000
#define IDB_CHANNEL_RED    0x0001
#define IDB_CHANNEL_GREEN  0x0010
#define IDB_CHANNEL_BLUE   0x0100

#define DSP_FT_MAG      0x00000001
#define DSP_FT_PHS      0x00000002
#define DSP_FT_NORM     0x00000010
#define DSP_FT_LOG      0x00000020

//--------------L_SubtractBackgroundBitmap Flags---------------------
#define SBK_DEPEND      0
#define SBK_1_1         1
#define SBK_1_2         2
#define SBK_1_4         3
#define SBK_1_8         4

#define SBK_BG_DARK     0x00000000
#define SBK_BG_BRIGHT   0x00000001

#define SBK_RES_SHOW    0x00000000
#define SBK_BG_SHOW     0x00000010

//********************** FT functions Structure**********************

typedef struct _COMPLEX
{
   L_DOUBLE r;
   L_DOUBLE i;
}
L_COMPLEX, *pCOMPLEX;

typedef struct _FTARRAY
{
   L_UINT uStructSize;
   L_UINT uWidth;
   L_UINT uHeight;
   L_COMPLEX acxData[1];
}
FTARRAY, *pFTARRAY;


L_INT EXT_FUNCTION L_CountLUTColors(
   RGBQUAD  *pLUT,
   L_UINT   ulLLUTLen,
   L_UINT   *pNumberOfEntries,
   L_INT    *pFirstIndex,
   L_UINT   uFlags);

L_INT EXT_FUNCTION L_MedianFilterBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uDim, 
   L_UINT32       uFlags = 0);
   
L_INT EXT_FUNCTION L_AllocFTArray(
   pBITMAPHANDLE  pBitmap,
   pFTARRAY       *ppFTArray,
   L_UINT         uStructSize, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_FreeFTArray(
   pFTARRAY pFTArray, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_FFTBitmap(
   pBITMAPHANDLE  pBitmap,
   pFTARRAY       pFTArray,
   L_UINT         uFlags);

L_INT EXT_FUNCTION L_FTDisplayBitmap(
   pBITMAPHANDLE  pBitmap,
   pFTARRAY       pFTArray,
   L_UINT         uFlags);

L_INT EXT_FUNCTION L_SubtractBackgroundBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uRollingBall,
   L_UINT         uShrinkSize,
   L_UINT         uBrightnessFactor,
   L_UINT         uFlags);

L_INT EXT_FUNCTION L_AutoTrimBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uThreshold, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_GetAutoTrimRect(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uThreshold,
   RECT           *pRect, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_GetMinMaxBits(
   pBITMAPHANDLE  pBitmap,
   L_INT          *pLowBit,
   L_INT          *pHighBit, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_GetMinMaxVal(
   pBITMAPHANDLE  pBitmap,
   L_INT          *pMinVal,
   L_INT          *pMaxVal, 
   L_UINT32       uFlags = 0);

   
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltdis.h
#ifdef __LEADTOOLS_64bit__
#pragma dll(ltdisx)
#else // !__LEADTOOLS_64bit__
#pragma dll(ltdisu)
#endif // !__LEADTOOLS_64bit__

// region processing
#define L_RGN_AND             0
#define L_RGN_SET             1
#define L_RGN_ANDNOTBITMAP    2
#define L_RGN_ANDNOTRGN       3
#define L_RGN_OR              4
#define L_RGN_XOR             5
#define L_RGN_SETNOT          6

#define L_POLY_WINDING     0
#define L_POLY_ALTERNATE   1



L_BOOL EXT_FUNCTION L_BitmapHasRgn(
   pBITMAPHANDLE pBitmap);
   
L_INT EXT_FUNCTION L_SetBitmapRgnPolygon(
   pBITMAPHANDLE pBitmap,
   pRGNXFORM pXForm,
   L_POINT* pPoints,
   L_UINT uPoints,
   L_UINT uFillMode,
   L_UINT uCombineMode);

L_INT EXT_FUNCTION L_SetBitmapRgnRect(
   pBITMAPHANDLE pBitmap,
   pRGNXFORM pXForm,
   L_RECT* pRect,
   L_UINT uCombineMode);

L_INT EXT_FUNCTION L_ChangeFromDDB(
   L_HDC hDC,
   pBITMAPHANDLE pBitmap,
   L_UINT uStructSize,
   L_HBITMAP hBitmap,
   L_HPALETTE hPalette);

L_HBITMAP EXT_FUNCTION L_ChangeToDDB(
   L_HDC hDC,
   pBITMAPHANDLE pBitmap);

L_INT EXT_FUNCTION L_SetBitmapRgnEllipse(
   pBITMAPHANDLE pBitmap,
   pRGNXFORM pXForm,
   L_RECT* pRect,
   L_UINT uCombineMode);

L_INT EXT_FUNCTION L_FreeBitmapRgn(
   pBITMAPHANDLE pBitmap);

   
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltimgefx.h
#ifdef __LEADTOOLS_64bit__
#pragma dll(ltimgefxx)
#else // !__LEADTOOLS_64bit__
#pragma dll(ltimgefxu)
#endif // !__LEADTOOLS_64bit__

//----------------L_CombineBitmap Flags-----------------------
// flags for L_CombineBitmap
#define CB_SRC_NOP      0x00000000
#define CB_SRC_NOT      0x00000001
#define CB_SRC_0        0x00000002
#define CB_SRC_1        0x00000003
#define CB_DST_NOP      0x00000000
#define CB_DST_NOT      0x00000010
#define CB_DST_0        0x00000020
#define CB_DST_1        0x00000030
#define CB_OP_AND       0x00000000
#define CB_OP_OR        0x00000100
#define CB_OP_XOR       0x00000200
#define CB_OP_ADD       0x00000300
#define CB_OP_SUBSRC    0x00000400
#define CB_OP_SUBDST    0x00000500
#define CB_OP_MUL       0x00000600
#define CB_OP_DIVSRC    0x00000700
#define CB_OP_DIVDST    0x00000800
#define CB_OP_AVG       0x00000900
#define CB_OP_MIN       0x00000A00
#define CB_OP_MAX       0x00000B00
#define CB_RES_NOP      0x00000000
#define CB_RES_NOT      0x00001000
#define CB_RES_0        0x00002000
#define CB_RES_1        0x00003000

#define CB_SRC_MASTER   0x00000000
#define CB_SRC_RED      0x00010000
#define CB_SRC_GREEN    0x00020000
#define CB_SRC_BLUE     0x00030000

#define CB_DST_MASTER   0x00000000
#define CB_DST_RED      0x00100000
#define CB_DST_GREEN    0x00200000
#define CB_DST_BLUE     0x00300000

#define CB_RES_MASTER   0x00000000
#define CB_RES_RED      0x01000000
#define CB_RES_GREEN    0x02000000
#define CB_RES_BLUE     0x03000000
#define CB_OP_ABSDIF    0x00000C00
#define CB_RAWCOMBINE   0x04000000

//----------------L_GetFunctionalLookupTable Flags-----------------------
#define FLT_EXP      0x0000
#define FLT_LN       0x0001
#define FLT_LINEAR   0x0002
#define FLT_SIGMOID  0x0003
#define FLT_SIGNED   0x0010

//-----------------L_SpatialFilterBitmap Flags, Macros, -------------------
#define SPATIALFLTSIZE(dim)   (sizeof(SPATIALFLT) + (sizeof(L_INT) * (((L_INT) (dim) * (L_INT) (dim)) - 1)))
#define MAKEINTFLT(i)         ((pSPATIALFLT)((L_UINT32)((L_UINT16) (i))))

#define FLT_EMBOSS_N          MAKEINTFLT(0)
#define FLT_EMBOSS_NE         MAKEINTFLT(1)
#define FLT_EMBOSS_E          MAKEINTFLT(2)
#define FLT_EMBOSS_SE         MAKEINTFLT(3)
#define FLT_EMBOSS_S          MAKEINTFLT(4)
#define FLT_EMBOSS_SW         MAKEINTFLT(5)
#define FLT_EMBOSS_W          MAKEINTFLT(6)
#define FLT_EMBOSS_NW         MAKEINTFLT(7)

#define FLT_GRADIENT_N        MAKEINTFLT(8)
#define FLT_GRADIENT_NE       MAKEINTFLT(9)
#define FLT_GRADIENT_E        MAKEINTFLT(10)
#define FLT_GRADIENT_SE       MAKEINTFLT(11)
#define FLT_GRADIENT_S        MAKEINTFLT(12)
#define FLT_GRADIENT_SW       MAKEINTFLT(13)
#define FLT_GRADIENT_W        MAKEINTFLT(14)
#define FLT_GRADIENT_NW       MAKEINTFLT(15)

#define FLT_LAPLACE_1         MAKEINTFLT(16)
#define FLT_LAPLACE_2         MAKEINTFLT(17)
#define FLT_LAPLACE_3         MAKEINTFLT(18)
#define FLT_LAPLACE_DIAG      MAKEINTFLT(19)
#define FLT_LAPLACE_HORZ      MAKEINTFLT(20)
#define FLT_LAPLACE_VERT      MAKEINTFLT(21)

#define FLT_SOBEL_HORZ        MAKEINTFLT(22)
#define FLT_SOBEL_VERT        MAKEINTFLT(23)

#define FLT_PREWITT_HORZ      MAKEINTFLT(24)
#define FLT_PREWITT_VERT      MAKEINTFLT(25)

#define FLT_SHIFTDIFF_DIAG    MAKEINTFLT(26)
#define FLT_SHIFTDIFF_HORZ    MAKEINTFLT(27)
#define FLT_SHIFTDIFF_VERT    MAKEINTFLT(28)

#define FLT_LINESEG_HORZ      MAKEINTFLT(29)
#define FLT_LINESEG_VERT      MAKEINTFLT(30)
#define FLT_LINESEG_LTOR      MAKEINTFLT(31)
#define FLT_LINESEG_RTOL      MAKEINTFLT(32)

//----------------L_GetFunctionalLookupTable Flags-----------------------
#define FLT_EXP      0x0000
#define FLT_LN       0x0001
#define FLT_LINEAR   0x0002
#define FLT_SIGMOID  0x0003
#define FLT_SIGNED   0x0010

//--------------L_UserFilterBitmap Flags---------------------
#define UD_SUM 0x0000
#define UD_MAX 0x0001
#define UD_MIN 0x0002

//-----------------L_BinaryFilterBitmap Flags, Macros, -------------------
#define BINARYFLTSIZE(dim)    (sizeof(BINARYFLT) + (sizeof(L_INT) * (((L_INT) (dim) * (L_INT) (dim)) - 1)))
#define MAKEINTBFLT(i)        ((pBINARYFLT)((L_UINT32)((L_UINT16) (i))))

#define BFLT_EROSION_OMNI     MAKEINTBFLT(0)
#define BFLT_EROSION_HORZ     MAKEINTBFLT(1)
#define BFLT_EROSION_VERT     MAKEINTBFLT(2)
#define BFLT_EROSION_DIAG     MAKEINTBFLT(3)
#define BFLT_DILATION_OMNI    MAKEINTBFLT(4)
#define BFLT_DILATION_HORZ    MAKEINTBFLT(5)
#define BFLT_DILATION_VERT    MAKEINTBFLT(6)
#define BFLT_DILATION_DIAG    MAKEINTBFLT(7)

#define BFLT_DONTCARE         256

#define CONTOUR_THIN             0x0000
#define CONTOUR_LINK_BLACKWHITE  0x0001
#define CONTOUR_LINK_GRAY        0x0002
#define CONTOUR_LINK_COLOR       0x0003
#define CONTOUR_APPROX_COLOR     0x0004

//----------------L_EdgeDetectorBitmap Flags-----------------------
#define EDG_SOBEL_VERT    0x0101
#define EDG_SOBEL_HORZ    0x0102
#define EDG_SOBEL_ALL     0x0103

#define EDG_PREWITT_VERT  0x0201
#define EDG_PREWITT_HORZ  0x0202
#define EDG_PREWITT_ALL   0x0203

#define EDG_LAPLACE_1     0x0301
#define EDG_LAPLACE_2     0x0302
#define EDG_LAPLACE_3     0x0303
#define EDG_LAPLACE_DIAG  0x0304
#define EDG_LAPLACE_HORZ  0x0305
#define EDG_LAPLACE_VERT  0x0306

#define EDG_GRADIENT_N    0x0401
#define EDG_GRADIENT_NE   0x0402
#define EDG_GRADIENT_E    0x0403
#define EDG_GRADIENT_SE   0x0404
#define EDG_GRADIENT_S    0x0405
#define EDG_GRADIENT_SW   0x0406
#define EDG_GRADIENT_W    0x0407
#define EDG_GRADIENT_NW   0x0408

//-------------- L_EdgeDetectEffectBitmap Flags---------------------
#define EDGE_SOFT    0
#define EDGE_SOLID   1

//********************** L_SpatialFilterBitmap Structure**********************
typedef struct _SPATIALFLT
{
   L_UINT   uStructSize;
   L_INT    fltDivisor;            // sum divisor
   L_INT    fltBias;               // sum bias
   L_UINT   fltDim;               // filter dimensions
   L_INT    fltMatrix[1];          // array of filter coefficients
}
SPATIALFLT, *pSPATIALFLT;

//********************** L_UserFilterBitmap Structure**********************
typedef struct _USERFLT
{
   L_UINT   uStructSize;
   L_UINT   ufltWidth;
   L_UINT   ufltHeight;
   POINT    ufltCenter;
   L_UINT   ufltDivisor;
   L_INT    nfltOffset;
   L_UINT   ufltFlag;
   L_INT    ufltMatrix[1];
}
USERFLT, *pUSERFLT, L_FAR * LPUSERFLT;

//********************** L_BinaryfilterBitmap Structure**********************
typedef struct _BINARYFLT
{
	L_UINT   uStructSize;
	L_BOOL   bfltMax;       // select maximimum value
	L_UINT   bfltDim;       // filter dimensions
	L_INT    bfltMatrix[1]; // array of filter coefficients
}
BINARYFLT, *pBINARYFLT;


L_INT EXT_FUNCTION L_GetUserLookUpTable(
	L_UINT         *pLookupTable,
	L_UINT         uLookupLen,
	POINT          *apUserPoint,
	L_UINT         uUserPointCount,
	L_UINT         *puPointCount, 
	L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_GetFunctionalLookupTable(
	L_INT *        pLookupTable,
	L_UINT         uLookupLen,
	L_INT          nStart,
	L_INT          nEnd,
	L_INT          nFactor,
	L_UINT         uFlags);
	
L_INT EXT_FUNCTION L_GaussianFilterBitmap(
   pBITMAPHANDLE  pBitmap,
   L_INT          nRadius, 
   L_UINT32       uFlags = 0);
  
L_INT EXT_FUNCTION L_UnsharpMaskBitmap(
   pBITMAPHANDLE  pBitmap,
   L_INT          nAmount,
   L_INT          nRadius,
   L_INT          nThreshold,
   L_UINT         uFlags);
   
L_INT EXT_FUNCTION L_SharpenBitmap(
   pBITMAPHANDLE  pBitmap,
   L_INT          nSharpness, 
   L_UINT32       uFlags = 0);
   
L_INT EXT_FUNCTION L_AverageFilterBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uDim, 
   L_UINT32       uFlags = 0);
   
L_INT EXT_FUNCTION L_ContourFilterBitmap(
   pBITMAPHANDLE  pBitmap,
   L_INT16        nThreshold,
   L_INT16        nDeltaDirection,
   L_INT16        nMaximumError,
   L_INT          nOption, 
   L_UINT32       uFlags = 0);
   
L_INT EXT_FUNCTION L_EdgeDetectorBitmap(
   pBITMAPHANDLE  pBitmap,
   L_INT          nThreshold,
   L_UINT         uFilter, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_EdgeDetectStatisticalBitmap(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uDim,
   L_INT          nThreshold,
   COLORREF       crEdgeColor,
   COLORREF       crBkColor, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_GaussianFilterBitmap(
   pBITMAPHANDLE  pBitmap,
   L_INT          nRadius, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_AlphaBlendBitmap(
   pBITMAPHANDLE pBitmapDst,
   L_INT          nXDst,
   L_INT          nYDst,
   L_INT          nWidth,
   L_INT          nHeight,
   pBITMAPHANDLE  pBitmapSrc,
   L_INT          nXSrc,
   L_INT          nYSrc,
   L_INT          nOpacity, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_CreateFadedMask(
   pBITMAPHANDLE  pBitmap,
   pBITMAPHANDLE  pMaskBitmap,
   L_UINT         uStructSize,
   L_INT          nLength,
   L_INT          nFadeRate,
   L_INT          nStepSize,
   L_INT          nInflate,
   L_UINT         uFlags,
   L_INT          nMaxGray,
   COLORREF       crTransparent);

L_INT EXT_FUNCTION L_FeatherAlphaBlendBitmap(
   pBITMAPHANDLE  pBitmapDst,
   L_INT          nXDst,
   L_INT          nYDst,
   L_INT          nWidth,
   L_INT          nHeight,
   pBITMAPHANDLE  pBitmapSrc,
   L_INT          nXSrc,
   L_INT          nYSrc,
   pBITMAPHANDLE  pBitmapMask,
   L_INT          nXMaskShift,
   L_INT          nYMaskShift, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_AddBitmapNoise(
   pBITMAPHANDLE  pBitmap,
   L_UINT         uRange,
   L_UINT         uChannel, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_SpatialFilterBitmap(
   pBITMAPHANDLE  pBitmap,
   pSPATIALFLT    pFilter, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_UserFilterBitmap(
   pBITMAPHANDLE  pBitmap,
   pUSERFLT       pFilter, 
   L_UINT32       uFlags = 0);

L_INT EXT_FUNCTION L_CombineBitmap(
	pBITMAPHANDLE pBitmapDst,
	L_INT nXDst,
	L_INT nYDst,
	L_INT nWidth,
	L_INT nHeight,
	pBITMAPHANDLE pBitmapSrc,
	L_INT nXSrc,
	L_INT nYSrc,
	L_UINT uMaxedFlags,
	L_UINT32 uFlags = 0);
#define L_CombineBitmapExt L_CombineBitmap

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

#else // !LEADTOOLS_VER == 17

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

#define L_FAR                   /* segmented memory attribute < 64K */
#define L_HUGE                  /* segmented memory attribute > 64K */

typedef struct tagRGBQUAD {
        BYTE    rgbBlue;
        BYTE    rgbGreen;
        BYTE    rgbRed;
        BYTE    rgbReserved;
} RGBQUAD;
typedef RGBQUAD L_FAR* LPRGBQUAD;

typedef char L_CHAR;            /* signed 8-bit integer */
typedef unsigned char L_UCHAR;  /* unsigned 8-bit integer */
typedef short L_INT16;          /* signed 16-bit integer */
typedef unsigned short L_UINT16;/* unsigned 16-bit integer */
typedef long L_INT32;           /* signed 32-bit integer */
typedef unsigned long L_UINT32; /* unsigned 32-bit integer */
typedef int L_INT;              /* signed integer 16-bits or larger */
typedef unsigned int L_UINT;        /* unsigned integer 16-bits or larger */
typedef void L_VOID;            /* void */
typedef L_UINT L_BOOL;          /* boolean */
typedef L_UINT L_BITFIELD;      /* bit field */
typedef float  L_FLOAT;         /* floating point number */
typedef double L_DOUBLE;        /* double precision floating point number */
typedef RGBQUAD L_RGBQUAD;      /* RGBQUAD structure */

///sandy 2006-8-14 
typedef struct tagLOG256PALETTE
{
   L_UINT16 palVersion;
   L_UINT16 palNumEntries;
   PALETTEENTRY palPalEntry[256];
} LOG256PALETTE;




////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltkrn.h

/*
  define for BITMAPHANDLE
*/

#define ORDER_RGB                0 /* RGB ordering */
#define ORDER_BGR                1 /* BGR ordering */
#define ORDER_GRAY               2 /* Gray pixels */
#define ORDER_RGBORGRAY          3 /* Valid only for L_LoadXXX functions - gray or RGB */
#define ORDER_BGRORGRAY          4 /* Valid only for L_LoadXXX functions - gray or BGR */
#define ORDER_ROMM               5 /* BGR Wide gamut format */
#define ORDER_BGRORGRAYORROMM    6 /* Valid only for L_LoadXXX functions - gray or BGR or ROMM */

typedef struct struct_LEAD_Bitmap
{
#if LEADTOOLS_VER == 14
	L_UINT uStructSize;
#endif // !LEADTOOLS_VER == 14
#ifdef JUNK
	union
	{
		struct struct_compressed_memory
		{
			HGLOBAL hData;         /* internal use */
			L_VOID L_HUGE*pData;  /* internal use */
		} Compressed;
		
		struct struct_window_memory
		{                         
			HGLOBAL hData;         /* Internal use */
			L_UCHAR L_FAR *pData;  /* Internal use */
		} Windows;
		
		struct struct_file_memory 
		{                         
			L_INT fd;              /* Internal use */
			L_UINT Available;      /* Internal use */
		} File;
		
		struct struct_tiled_memory
		{                         
			HGLOBAL hData;         /* Internal use */
			L_UCHAR L_FAR *pData;  /* Internal use */
		} Tiled;

		struct struct_supercompressed_memory
		{
			HGLOBAL hData;          /* internal use */
			L_VOID L_HUGE*pData;    /* internal use */
		} SuperCompressed;
	} Addr;
#endif // JUNK
	BYTE Addr[8];

	L_INT Width;                 /* Image width */
	L_INT Height;                /* Image height */
	L_INT BitsPerPixel;          /* Number of bits per pixel */
	L_UINT BytesPerLine;         /* Bytes per line, rounded by four */
	L_UINT32 CurrentPos;         /* Internal use */
	L_INT CurrentRow;            /* Internal use */

#ifdef JUNK
	struct struct_bitmap_flags
	{
		L_BITFIELD Allocated:1;          /* Is the bitmap allocated? */
		L_BITFIELD ConventionalMemory:1; /* allocated in conventional memory */
		L_BITFIELD DiskMemory:1;         /* allocated on disk */
		L_BITFIELD ProgressiveAvailable:1;        /* progressive format */
		L_BITFIELD LockedMemory:1;       /* Is memory locked in windows */
		L_BITFIELD Interlaced:1;         /* Interlaced format */
		L_BITFIELD WaitUserInput:1;      /* Playback wait for user input */
		L_BITFIELD Transparency:1;       /* Playback uses transparency */
		L_BITFIELD Compressed:1;         /* 1 bit RLE compressed data */
		L_BITFIELD Signed:1;             /* the pixel values are signed */
		L_BITFIELD Mirror:1;             /* this is a mirror of another image */
		L_BITFIELD UseLUT:1;             /* use pLUT for image processing */
		L_BITFIELD Global:1;             /* hData is HGLOBAL */
		L_BITFIELD UsePaintLUT:1;        /* Use PaintGamma, PaintContrast, PaintIntensity */
		L_BITFIELD Tiled:1;              /* Bitmap is stored as tiles */
		L_BITFIELD SuperCompressed:1;    /* Super compressed data */
		L_BITFIELD NoClip:1;             /* Do not clip region */
		L_BITFIELD Dummy:15;
	} Flags;
#endif // JUNK
	DWORD Flags;

	L_INT nColors;                /* No. of possible colors in the bitmap */
#if LEADTOOLS_VER == 14
	LPRGBQUAD pPalette;           /* Pointer to a RGBQUAD array containing the palette */
#else // !LEADTOOLS_VER == 14
	HPALETTE hPalette;            /* Handle to a palette */
#endif // !LEADTOOLS_VER == 14
	L_INT ViewPerspective;        /* Is TOP_LEFT, BOTTOM_RIGHT, ... */
	L_INT Order;                  /* Is it ORDER_RGB, ORDER_BGR */
	L_UINT32 Size;                /* Size of the bitmap */
	L_VOID L_FAR *pDitherData;    /* Internal use */
	L_UINT DitheringMethod;       /* Which dithering method used */
	L_VOID L_FAR *pRgnInfo;       /* Internal use */
	L_INT XResolution;            /* Bitmaps X resolution (DPI) */
	L_INT YResolution;            /* Bitmaps Y resolution (DPI) */
	L_INT Left;                   /* Left playback offset */
	L_INT Top;                    /* Top playback offset */
	L_UINT32 Delay;               /* Playback delay (ms) */
	COLORREF Background;          /* Playback background color */
	COLORREF Transparency;        /* Playback transparent color */
	L_UINT DisposalMethod;        /* Playback disposal method */
	L_INT   LowBit;               /* low bit set by L_WindowLevelBitmap */
	L_INT   HighBit;              /* high bit set by L_WindowLevelBitmap */
	RGBQUAD L_HUGE*pLUT;          /* LUT set by L_WindowLevel or L_WindowLevelBitmap */
	L_UINT32 LUTLength;           /* no of entries pointed by LUT */
	L_UINT32 DataOffset;          /* offset into hData */
	L_INT32  MinVal;              /* min val for a grayscale bitmap */
	L_INT32  MaxVal;              /* max val for a grayscale bitmap */
	L_INT    PaintLowBit;         /* low bit set by L_WindowLevelBitmap */
	L_INT    PaintHighBit;        /* high bit set by L_WindowLevelBitmap */
	L_UINT   PaintGamma;          /* Paint gamma value to be used during painting */
	L_INT   PaintContrast;        /* Paint contrast value to be used during painting */
	L_INT   PaintIntensity;       /* Paint intensity value to be used during painting */
	L_UCHAR L_FAR*pPaintLUT;      /* Paint LUT generated from PaintIntensity, PaintGamma, PaintIntensity */
	L_VOID  L_FAR*pOverlaysInfo;  /* Internal use */
	L_UINT32 Reserved;            /* reserved field, do not use */
} BITMAPHANDLE, L_FAR * pBITMAPHANDLE;

typedef HANDLE HPALETTE;

typedef HANDLE HBITMAPLIST;	//used as a handle to a list of bitmaps.
typedef HBITMAPLIST L_FAR * pHBITMAPLIST; // used as a pointer to an HBITMAPLIST variable.

typedef struct tagBITMAPINFOHEADER{
        DWORD      biSize;
        LONG       biWidth;
        LONG       biHeight;
        WORD       biPlanes;
        WORD       biBitCount;
        DWORD      biCompression;
        DWORD      biSizeImage;
        LONG       biXPelsPerMeter;
        LONG       biYPelsPerMeter;
        DWORD      biClrUsed;
        DWORD      biClrImportant;
} BITMAPINFOHEADER, *LPBITMAPINFOHEADER, *PBITMAPINFOHEADER;

typedef struct tagBITMAPINFO {
    BITMAPINFOHEADER    bmiHeader;
    RGBQUAD             bmiColors[1];
} BITMAPINFO, *LPBITMAPINFO, *PBITMAPINFO;


///--------Sandy 2005.10.10   (ltkrn.h)
#if LEADTOOLS_VER == 14
/*
    flags for L_IsGrayScaleBitmap
*/
#define GRAY_NO				0  //Not grayscale.
#define GRAY_ORDEREDNORMAL	1  //Normally ordered grayscale (dark to light).
#define GRAY_ORDEREDINVERSE	2  //Reverse ordered grayscale (light to dark).
#define GRAY_NOTORDERED		3  //Unordered grayscale.

/*
    flags for L_ColorResBitmapList
*/
#define CRF_FIXEDPALETTE		0x01	// Use LEAD's fixed palette.
#define CRF_OPTIMIZEDPALETTE	0x02	// Create an optimized palette.
#define CRF_NETSCAPEPALETTE		0x40	// Use the fixed palette that is employed by Netscape Navigator and by Microsoft Internet Explorer.
#define CRF_USERPALETTE			0x10	// Use the palette specified in the pPalette parameter.
#define CRF_USERHPALETTE		0x0100	// Use the palette specified in the hPalette parameter, without supplying optimized colors. Please note that this cannot Or-ed with CRF_USERPALETTE.
#define CRF_IDENTITYPALETTE		0x08	// Insert the Windows system palette. You can combine this flag with CRF_OPTIMIZEDPALETTE.
#define CRF_FASTMATCHPALETTE	0x20	// Use a predefined table to speed conversion using your own palette. Refer to L_CreateUserMatchTable.
#define CRF_BYTEORDERBGR		0x04	// Use BGR color order. This flag only has meaning when going to 16 bits per pixel or higher.
#define CRF_BYTEORDERRGB		0x00	// Use RGB color. This flag only has meaning when going to 16 bits per pixel or higher.
#define CRF_BYTEORDERGRAY		0x80	// Grayscale.Destination bitmap should be 12 or 16-bit grayscale.  12 and 16-bit grayscale images are only supported in the Document/Medical Imaging editions .
#define CRF_SLOWMATCH			0x0200	// Use with the CRF_OPTIMIZEDPALETTE flag to use a slower but more accurate matching process.
#define CRF_FAVORPURECOLORS		0x0400	// Give colors that occur frequently in the image palette entries of their own in the optimized palette.
#define CRF_NODITHERING			0x00000000	// Use nearest color matching.
#define CRF_FLOYDSTEINDITHERING	0x00010000	// Use Floyd-Steinberg dithering.
#define CRF_STUCKIDITHERING		0x00020000	// Use Stucki dithering.
#define CRF_BURKESDITHERING		0x00030000	// Use Burkes dithering.
#define CRF_SIERRADITHERING		0x00040000	// Use Sierra dithering.
#define CRF_STEVENSONARCEDITHERING	0x00050000	// Use Stevenson Arce dithering.
#define CRF_JARVISDITHERING			0x00060000	// Use Jarvis dithering.
#define CRF_ORDEREDDITHERING	0x00070000		// Use ordered dithering, which is faster but less accurate than other dithering methods.
#define CRF_CLUSTEREDDITHERING	0x00080000		// Use clustered dithering.
#define CRF_BYTEORDERROMM		0x0800			// Use ROMM color. This flag only has meaning when going to 24 or 48 bits per pixel.
#endif
///---------end Sandy----------
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// lttyp.h

#define EXT_FUNCTION    WINAPI
#define L_EXPORT                /* export attribute */
#define L_PASCAL                /* pascal calling convention */



//// Sandy 2005.9.12
#if LEADTOOLS_VER == 14

typedef struct tagLVLCLRINF
{
   L_UINT uMinInput;
   L_UINT uMaxInput;
   L_UINT uMinOutput;
   L_UINT uMaxOutput;
   L_UINT uGamma;
} LVLCLRINF, L_FAR * pLVLCLRINF;

typedef struct tagLVLCLR
{
   L_UINT uStructSize;
   LVLCLRINF master;
   LVLCLRINF red;
   LVLCLRINF green;
   LVLCLRINF blue;
} LVLCLR, L_FAR * pLVLCLR;

typedef struct tagCOMPLEX
{
   L_DOUBLE r;
   L_DOUBLE i;
}L_COMPLEX, L_FAR * LPCOMPLEX;

typedef struct tagBALANCING
{
   L_UINT uStructSize;
   L_DOUBLE toRed;
   L_DOUBLE toGreen;
   L_DOUBLE toBlue;
} BALANCING, L_FAR *pBALANCING;


typedef struct tagFTARRAY
{
   L_UINT uStructSize;
   L_UINT uWidth;
   L_UINT uHeight;
   L_COMPLEX acxData[1];
} FTARRAY, L_FAR * pFTARRAY;


#endif // !LEADTOOLS_VER == 14

typedef struct _RGNXFORM
{
   L_UINT uViewPerspective;
   L_INT nXScalarNum;
   L_INT nXScalarDen;
   L_INT nYScalarNum;
   L_INT nYScalarDen;
   L_INT nXOffset;
   L_INT nYOffset;
} RGNXFORM, L_FAR *pRGNXFORM;
//-----end sandy 2005.9.12

/* 
   flags for L_RotateBitmap
*/
#define ROTATE_RESIZE            0x0001
#define ROTATE_RESAMPLE          0x0002
#define ROTATE_BICUBIC           0x0004

/* 
   flags for L_SizeBitmap
*/
#define SIZE_NORMAL              0x0000
#define SIZE_FAVORBLACK          0x0001
#define SIZE_RESAMPLE            0x0002
#define SIZE_BICUBIC             0x0004

/*
   memory allocation flags
*/
#define TYPE_CONV                0x0001   /* Use conventional memory first */
#define TYPE_USER                0x0002   /* Create a bitmap where the user maintains the data pointer */
#define TYPE_TILED               0x0004   /* Create tiled bitmap first */
#define TYPE_NOTILED             0x0008   /* Do not use tiled bitmaps */
#define TYPE_DISK                0x0080   /* Use Disk (if possible) */
#define TYPE_NODISK              0x0100   /* Do not use disk */
#define TYPE_COMPRESSED          0x0200   /* keep 1 bit images compressed in memory */

/*
   bitmap data colors order
*/
#define ORDER_RGB                 0 /* RGB ordering */
#define ORDER_BGR                 1 /* BGR ordering */
#define ORDER_GRAY                2 /* Gray pixels */
#define ORDER_RGBORGRAY           3 /* Valid only for L_LoadXXX functions - gray or RGB */
#define ORDER_BGRORGRAY           4 /* Valid only for L_LoadXXX functions - gray or BGR */

/*
   view perspectives (from Ltkrn.h)
*/
#define TOP_LEFT              1  /* Top-left of image is first in memory */
#define BOTTOM_LEFT           4  /* Bottom-left of image is first in memory */

#define TOP_RIGHT             2  /* Top-right of image is first in memory */
#define BOTTOM_LEFT180        2  /* TOP_RIGHT is BOTTOM_LEFT rotated clockwise by 180 degrees */
#define BOTTOM_RIGHT          3  /* Bottom-right of image is first in memory */
#define TOP_LEFT180           3  /* BOTTOM_RIGHT is TOP_LEFT rotated clockwise by 180 degrees */ 

#define RIGHT_TOP             6  /* First row is the right side, first column is top side */
#define TOP_LEFT90            6  /* RIGHT_TOP is TOP_LEFT rotated clockwise by 90 degrees */ 
#define LEFT_BOTTOM           8  /* First row is the left side, first column is top side */
#define TOP_LEFT270           8  /* LEFT_BOTTOM is TOP_LEFT rotated clockwise by 270 degrees */ 

#define LEFT_TOP              5  /* First row is the left side, first column is the top side */
#define BOTTOM_LEFT90         5  /* LEFT_TOP is BOTTOM_LEFT rotated clockwise by 90 degrees */
#define RIGHT_BOTTOM          7  /* First row is the right side, first column is the bottom side */
#define BOTTOM_LEFT270        7  /* RIGHT_BOTTOM is BOTTOM_LEFT rotated clockwise by 270 degrees */ 

/*
   constants for L_ConvertToDIB
*/
#define DIB_BITMAPINFOHEADER 0
#define DIB_BITMAPV4HEADER   1
#define DIB_BITMAPV5HEADER   2    

//-----sandy 2005.9.13
#if LEADTOOLS_VER == 14
/*
	Flags for the  L_MathFunctionBitmap  
*/

#define MF_SQR	0// Square  the values.
#define MF_LOG	1// Take the log of the values.
#define MF_SQRT	2// Take the square root of the values.
#define MF_SIN	3// Take the sine of the values.
#define MF_COS	4// Take the cosine of the values. 
/*
	Flags for the  L_ApplyMathLogicBitmap  
*/
#define AML_VALUE_NOP	0x00000000  // No change.
#define AML_VALUE_NOT	0x00000010  // Invert the color, resulting in its complement.
#define AML_VALUE_0		0x00000020	// Change all bits to 0.
#define AML_VALUE_1	 	0x00000030 	// Change all bits to 1.

#define AML_OP_AND		0x00000000	// Combine each pixel component value and nFactor using a bitwise AND (&). 
//(pixel = pixel & nFactor)
#define AML_OP_OR		0x00000100	// Combine each pixel component value and nFactor using a bitwise OR (|).
//(pixel = pixel | nFactor)
#define AML_OP_XOR		0x00000200	// Combine each pixel component value and nFactor using a bitwise XOR (^).
//(pixel = pixel ^ nFactor)
#define AML_OP_ADD		0x00000300	// Add pixel component value to the nFactor clamping the result to the maximum allowed pixel value. 
//(pixel = min(pixel + nFactor, MAX_PIXEL_VALUE) )
#define AML_OP_SUBFACT	0x00000400	// Subtract each pixel component value from the nFactor, clamping the result to the allowed pixel range. 
//(pixel = min(max(nFactor - pixel, MIN_PIXEL_VALUE), MAX_PIXEL_VALUE) )
#define AML_OP_SUBVALUE	0x00000500	// Subtract nFactor from each pixel component value, clamping the result to the allowed pixel range
//(pixel = min(max(pixel  nFactor), MIN_PIXEL_VALUE, MAX_PIXEL_VALUE) )
#define AML_OP_ABSDIF	0x00000600	// Calculate the absolute difference between nFactor and each pixel component value. 
//(pixel = abs(pixel  nFactor)
#define AML_OP_MUL		0x00000700	// Multiply each pixel component value by nFactor/100.
//(pixel = pixel * nFactor / 100)
#define AML_OP_DIVFACT	0x00000800	// Divide each pixel component value by nFactor/100. An error will be returned if nFactor = 0.
//(pixel = pixel * 100 / nFactor)
#define AML_OP_DIVVALUE	0x00000900	// Divide nFactor by each pixel values. If the pixel values are 0, the result set to maximum allowed pixel value. (pixel = pixel ? min(nFactor / pixel, MAX_PIXEL_VALUE) : MAX_PIXEL_VALUE)
#define AML_OP_AVG		0x00000A00	// Use the average of the each pixel component value and nFactor. (pixel = (pixel+nFactor) / 2).
#define AML_OP_MIN		0x00000B00	// Use the lesser of the pixel component values and nFactor:
//(pixel = min(pixel, nFactor) )
#define AML_OP_MAX		0x00000C00	// Use the greater of the pixel component values and nFactor:
//(pixel = max(pixel, nFactor) )

#define AML_RES_NOP		0x00000000	// No change.
#define AML_RES_NOT		0x00001000	// Invert the color, resulting in its complement.
#define AML_RES_0		0x00002000	// Change all bits to 0.
#define AML_RES_1		0x00003000	// Change all bits to 1.

/*
	Flags for the L_CombineBitmap and L_CombineBitmapExt Function
*/

#define CB_SRC_NOP		0x00000000 // No change.
#define CB_SRC_NOT		0x00000001 // Invert the color, resulting in its complement.
#define CB_SRC_0		0x00000002 // Change all bits to 0.
#define CB_SRC_1		0x00000003 // Change all bits to 1.

#define CB_DST_NOP		0x00000000 // No change.
#define CB_DST_NOT		0x00000010 // Invert the color, resulting in its complement.
#define CB_DST_0		0x00000020 // Change all bits to 0.
#define CB_DST_1		0x00000030 // Change all bits to 1.

#define CB_OP_AND		0x00000000 // Combine each set of bytes using a bitwise AND (&).
#define CB_OP_OR		0x00000100 // Combine each set of bytes using a bitwise OR ( | ).
#define CB_OP_XOR		0x00000200 // Combine each set of bytes using a bitwise exclusive OR (^).
#define CB_OP_ADD		0x00000300 // Add the byte values, allowing a maximum of 255.
#define CB_OP_SUBSRC	0x00000400 // Subtract the source from the destination, allowing a minimum of 0.
#define CB_OP_SUBDST	0x00000500 // Subtract the destination from the source, allowing a minimum of 0.
#define CB_OP_MUL		0x00000600 // Multiply the byte values, allowing a maximum of 255. The result is calculated as follows: result = (source * dest) / 255.
#define CB_OP_DIVSRC	0x00000700 // Divide the destination by the source. If source > 0, then the result is calculated as follows: result = min( (dest / source) * 255, 255 ). Otherwise, if source = 0, then result = 255.
#define CB_OP_DIVDST	0x00000800 // Divide the source by the destination. If dest > 0, then the result is calculated as follows: result = min( (source / dest) * 255, 255 ). Otherwise, if dest = 0, then result = 255.
#define CB_OP_AVG		0x00000900 // Use the average of the two values.
#define CB_OP_MIN		0x00000A00 // Use the lesser of the two values.
#define CB_OP_MAX		0x00000B00 // Use the greater of the two values.
#define CB_OP_ABSDIF	0x00000C00 // Calculate the absolute difference between the two values.

#define CB_RES_NOP		0x00000000 // No change.
#define CB_RES_NOT		0x00001000 // Invert the color, resulting in its complement.
#define CB_RES_0		0x00002000 // Change all bits to 0.
#define CB_RES_1		0x00003000 // Change all bits to 1.


#define CB_SRC_MASTER	0x00000000 // perform operation on all Channels.
#define CB_SRC_RED		0x00010000 // perform operation on Red Channel.
#define CB_SRC_GREEN	0x00020000 // perform operation on Green Channel. 
#define CB_SRC_BLUE		0x00030000 // perform operation on Blue Channel.

#define CB_DST_MASTER	0x00000000 // perform operation on all Channels.
#define CB_DST_RED		0x00100000 // perform operation on Red Channel.
#define CB_DST_GREEN	0x00200000 // perform operation on Green Channel. 
#define CB_DST_BLUE		0x00300000 // perform operation on Blue Channel.

#define CB_RES_MASTER	0x00000000 // perform operation on all Channels.
#define CB_RES_RED		0x01000000 // perform operation on Red Channel.
#define CB_RES_GREEN	0x02000000 // perform operation on Green Channel. 
#define CB_RES_BLUE		0x03000000 // perform operation on Blue Channel.


/*
   Flags for the L_FFTBitmap Function
*/
#define FFT_FFT		0x0001 // Convert the image into frequency domain and store the results in the acxData.
#define FFT_IFFT	0x0002 // Construct an image from the frequency components in acxData. The image will be stored in pBitmap. This option will change the values of acxData.

#define FFT_BLUE	0x0010 // Work on the blue channel.
#define FFT_GREEN	0x0020 // Work on the green channel.
#define FFT_RED		0x0030 // Work on the red channel.
#define FFT_GRAY	0x0040 // Work on the master Channel. If this flag is combined with FFT_IFFT, the reconstructed image will be gray.

#define FFT_IFFT_MAG	0x0100 // Construct the image from the frequency magnitude only.
#define FFT_IFFT_PHS	0x0200 // Construct the image from the frequency phase only.
#define FFT_IFFT_BOTH	0x0300 // Construct the image from both magnitude and phase.

#define FFT_IFFT_CLIP	0x1000 // Clip the constructed image values to be between 0 and 255.
#define FFT_IFFT_SCL	0x2000 // Scale the constructed image Valid values are between 0 and 255. 


/*
	Flags for the  L_GetBitmapHistogram Function
*/
#define CHANNEL_MASTER		0x0000 // All channels.
#define CHANNEL_RED	    	0x0001 // Red channel only.
#define CHANNEL_GREEN		0x0002 // Green channel only.
#define CHANNEL_BLUE	    0x0003 // Blue channel only.
#define HIST_LOWHIGH_BITS	0x0000 // Use the only the bits between the LowBit and HighBit values stored in the bitmap handle.
#define HIST_ALL_BITS	    0x0010 // Use all the bits for calculating the histogram (the LowBit and HighBit values from the bitmap handle are ignored.

#endif // !LEADTOOLS_VER == 14
//----end sandy


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltimg.h

/*
	flags for L_ColorLevelBitmap
*/

#define LEVEL_RED	 	0x0001  	// Red channel
#define LEVEL_GREEN	 	0x0010		// Green channel 
#define LEVEL_BLUE		0x0100		// Blue channel 
#define LEVEL_MASTER	0x1000		// All channels

/*
	flags for L_AutoColorLevelBitmap
*/

#define AUTO_LEVEL		0x0001 //Perform leveling on the individual R, G and B channels, treating each of the R, G and B channels as a separate entity. It introduces color cast on the image.
#define AUTO_CONTRAST	0x0002 //Perform leveling on the MASTER channel (the grayscale values of the pixels). No color cast will be introduced.
#define AUTO_INTENSITY	0x0003 //Perform leveling on the RGB channel (the sum of the R, G, and B channels). No color cast will be introduced.
#define AUTO_NOPROCESS	0x0004 //Do not process the bitmap. Just update pLvlClr with the color leveling information used. The color leveling information used depends on which of the other flags was set with AUTO_NOPROCESS. Only one other flag may be set with AUTO_NOPROCESS.
/*
   flags for L_IntensityDetectBitmap
*/
#define IDB_CHANNEL_MASTER	0x0000  // Grayscale Channel.
#define IDB_CHANNEL_RED		0x0001  // Red Channel.
#define IDB_CHANNEL_GREEN	0x0010  // Green Channel.
#define IDB_CHANNEL_BLUE	0x0100  // Blue Channel.
/*
   flags for L_GetFunctionalLookupTable
*/
#define COUNT_LUT_UNSIGNED	0x0001 // Belong to signed image.
#define COUNT_LUT_SIGNED	0x0002 //Belong to unsigned image.
/*
   flags for L_GetFunctionalLookupTable
*/
#define FLT_EXP	    0x0000  // Apply the exponential function.
#define FLT_LN		0x0001  // Apply the natural logarithm function.
#define FLT_LINEAR	0x0002  // Apply the linear function.
#define FLT_SIGMOID	0x0003  // Apply the sigmoid function.
/*
   flags for L_ColorSeparateBitmap/L_ColorMergeBitmap
*/
#define COLORSEP_RGB                 0x00 /* Use 3 RGB color planes. */
#define COLORSEP_CMYK                0x01 /* Use 4 CMYK color planes. */
#define COLORSEP_HSV                 0x02 /* Use 3 HSV color planes. */
#define COLORSEP_HLS                 0x03 /* Use 3 HLS color planes. */
#define COLORSEP_CMY                 0x04 /* Use 3 CMY color planes. */

/*
    structure and flags used by L_SpatialFilterBitmap
*/
typedef struct tagSPATIALFLT
{
   L_UINT uStructSize;    /* size of this structure */
   L_INT fltDivisor;            /* sum divisor */
   L_INT fltBias;               /* sum bias */
   L_UINT fltDim;               /* filter dimensions */
   L_INT fltMatrix[1];          /* array of filter coefficients */
} SPATIALFLT, L_FAR * LPSPATIALFLT;



/*
	List of Spatial Filters
*/
#define SPATIALFLTSIZE(dim) (sizeof(SPATIALFLT) + (sizeof(L_INT) * (((L_INT) (dim) * (L_INT) (dim)) - 1)))  
#define MAKEINTFLT(i) ((LPSPATIALFLT)((L_UINT32)((L_UINT16) (i))))  
#define FLT_EMBOSS_N    MAKEINTFLT(0)  
#define FLT_EMBOSS_NE   MAKEINTFLT(1)  
#define FLT_EMBOSS_E    MAKEINTFLT(2)  
#define FLT_EMBOSS_SE   MAKEINTFLT(3)  
#define FLT_EMBOSS_S    MAKEINTFLT(4)  
#define FLT_EMBOSS_SW   MAKEINTFLT(5)  
#define FLT_EMBOSS_W    MAKEINTFLT(6)  
#define FLT_EMBOSS_NW   MAKEINTFLT(7) 

#define FLT_GRADIENT_N    MAKEINTFLT(8)  
#define FLT_GRADIENT_NE   MAKEINTFLT(9)  
#define FLT_GRADIENT_E    MAKEINTFLT(10)  
#define FLT_GRADIENT_SE   MAKEINTFLT(11)  
#define FLT_GRADIENT_S    MAKEINTFLT(12)  
#define FLT_GRADIENT_SW   MAKEINTFLT(13)  
#define FLT_GRADIENT_W    MAKEINTFLT(14)  
#define FLT_GRADIENT_NW   MAKEINTFLT(15)  
#define FLT_LAPLACE_1     MAKEINTFLT(16)  
#define FLT_LAPLACE_2     MAKEINTFLT(17)  
#define FLT_LAPLACE_3     MAKEINTFLT(18)  
#define FLT_LAPLACE_DIAG  MAKEINTFLT(19)  
#define FLT_LAPLACE_HORZ  MAKEINTFLT(20)  
#define FLT_LAPLACE_VERT  MAKEINTFLT(21)  

#define FLT_SOBEL_HORZ    MAKEINTFLT(22)  
#define FLT_SOBEL_VERT    MAKEINTFLT(23)  
#define FLT_PREWITT_HORZ  MAKEINTFLT(24)  
#define FLT_PREWITT_VERT  MAKEINTFLT(25)  
#define FLT_SHIFTDIFF_DIAG  MAKEINTFLT(26)  
#define FLT_SHIFTDIFF_HORZ  MAKEINTFLT(27)  
#define FLT_SHIFTDIFF_VERT  MAKEINTFLT(28)  
#define FLT_LINESEG_HORZ  MAKEINTFLT(29)  
#define FLT_LINESEG_VERT  MAKEINTFLT(30)  
#define FLT_LINESEG_LTOR  MAKEINTFLT(31)  
#define FLT_LINESEG_RTOL  MAKEINTFLT(32)  	

/*
    structure used by  L_UserFilterBitmap
*/	
typedef struct tagUSERFLT
{
   L_UINT uStructSize;
   L_UINT ufltWidth; 
   L_UINT ufltHeight; 
   POINT   ufltCenter; 
   L_UINT ufltDivisor; 
   L_INT nfltOffset; 
   L_UINT ufltFlag; 
   L_INT ufltMatrix[1]; 
} USERFLT, L_FAR * LPUSERFLT;

#define UD_SUM	0x0000 //Perform sum operation.
#define UD_MAX	0x0001 //Perform maximum operation.
#define UD_MIN	0x0002 //Perform minimum operation. 

///Sandy add 2006-12-2
typedef struct tagBINARYFLT
{
   L_UINT uStructSize;     /* size of this structure. Use the sizeof() macro to calculate it */
   L_BOOL bfltMax;              /* select maximum value */
   L_UINT bfltDim;              /* filter dimensions */
   L_INT bfltMatrix[1];         /* array of filter coefficients */
} BINARYFLT, L_FAR * LPBINARYFLT;

#define SPATIALFLTSIZE(dim) (sizeof(SPATIALFLT) + (sizeof(L_INT) * (((L_INT) (dim) * (L_INT) (dim)) - 1)))  
#define MAKEINTFLT(i) ((LPSPATIALFLT)((L_UINT32)((L_UINT16) (i))))  
#define BFLT_EROSION_OMNI    MAKEINTBFLT(0)  
#define BFLT_EROSION_HORZ    MAKEINTBFLT(1)  
#define BFLT_EROSION_VERT    MAKEINTBFLT(2)  
#define BFLT_EROSION_DIAG    MAKEINTBFLT(3)  
#define BFLT_DILATION_OMNI    MAKEINTBFLT(4)  
#define BFLT_DILATION_HORZ    MAKEINTBFLT(5)  
#define BFLT_DILATION_VERT    MAKEINTBFLT(6)  
#define BFLT_DILATION_DIAG    MAKEINTBFLT(7)  
///end 2006-12-2

//---sandy 2005.9.14---------
#if LEADTOOLS_VER == 14


/*
	flags for L_ContourFilterBitmap
*/
#define CONTOUR_THIN			0  // return after the thinning algorithm 
#define CONTOUR_LINK_BLACKWHITE	1  // return after contour linking, using only black and white 
#define CONTOUR_LINK_GRAY		2  // return after contour linking, using 256 grayscale
#define CONTOUR_LINK_COLOR		3  // return after contour linking, using colors 
#define CONTOUR_APPROX_COLOR	4  // return after line segment approximation, using colors 
/*
    flages for L_EdgeDetectorBitmap
*/
#define EDG_SOBEL_VERT		0x0101 // Detect the vertical edges
#define EDG_SOBEL_HORZ		0x0102 // Detect the horizontal edges
#define EDG_SOBEL_ALL		0x0103 // Detect horizontal & vertical edges 
#define EDG_PREWITT_VERT	0x0201 // Detect the vertical edges
#define EDG_PREWITT_HORZ	0x0202 // Detect the horizontal edges
#define EDG_PREWITT_ALL		0x0203 // Detect horizontal & vertical edges
#define EDG_LAPLACE_1		0x0301 // Detect vertical & horizontal edges 
#define EDG_LAPLACE_2		0x0302 // Detect general edges
#define EDG_LAPLACE_3		0x0303 // Detect general edges. (The filter used for this option is different than the filter used for the EDG_LAPLACE_2 filter.)
#define EDG_LAPLACE_DIAG	0x0304 // Detect the diagonal edges
#define EDG_LAPLACE_HORZ	0x0305 // Detect the horizontal edges
#define EDG_LAPLACE_VERT	0x0306 // Detect the vertical edges
#define EDG_GRADIENT_N		0x0401 // Detect north edges  
#define EDG_GRADIENT_NE		0x0402 // Detect north east edges
#define EDG_GRADIENT_E		0x0403 // Detect east edges
#define EDG_GRADIENT_SE		0x0404 // Detect south east edges
#define EDG_GRADIENT_S		0x0405 // Detect south edges
#define EDG_GRADIENT_SW		0x0406 // Detect south west edges
#define EDG_GRADIENT_W		0x0407 // Detect west edges
#define EDG_GRADIENT_NW		0x0408 // Detect north west edges

/*
	flages for L_FTDisplayBitmap
*/
#define DSP_FT_MAG	0x0001 // Plot harmonics magnitude data.
#define DSP_FT_PHS	0x0002 // Plot harmonics phase data.

#define DSP_FT_NORM	0x0010 // Plot harmonics magnitudes  using the normal linear scale.
#define DSP_FT_LOG	0x0020 // Plot harmonics magnitudes using logarithmic scale.

/*
	flags for L_EdgeDetectEffectBitmap
*/
#define EDGE_SOFT	0 // Generate softer (smoother) edges.
#define EDGE_SOLID	1 // Generate rougher edges.

/*
	flags for L_GetFunctionalLookupTable 
*/
#define FLT_EXP		0x0000 // Apply the exponential function.
#define FLT_LN		0x0001 // Apply the natural logarithm function.
#define FLT_LINEAR	0x0002 // Apply the linear function.
#define FLT_SIGMOID	0x0003 // Apply the sigmoid function.

/*
	flags for L_SubtractBackgroundBitmap 
*/
#define SBK_DEPEND	0 // The Shrink Size depends on the ball size.
#define SBK_1_1		1 // No Resize (Highest accuracy). 
#define SBK_1_2		2 // Resize to half width and height.
#define SBK_1_4		3 // Resize to quarter width and height.
#define SBK_1_8		4 // Resize to eighth width and height (very fast).

#define SBK_BG_DARK		0x00000000 // The background in the current image is darker than the foreground.
#define SBK_BG_BRIGHT	0x00000001 // The background in the current image is brighter than the foreground.

#define SBK_RES_SHOW	0x00000000 // The output bitmap shows the result of the subtraction between the background and the original image.
#define SBK_BG_SHOW		0x00000010 // The output bitmap shows only the background.

/*
	flags for  L_HistoEqualizeBitmap 
*/
#define RGB_SPACE	0x0001 // Linearizes the number of pixels across the RGB color space.(separated channels)
#define YUV_SPACE	0x0002 // Linearizes the number of pixels across the YUV color space.(Best results)
#define GRAY_SPACE	0x0004 // Linearizes the number of pixels per gray level in a gray level representation of the image.

/*
    structure and flags used by L_ColorThresholdBitmap
*/
typedef struct tagCOMPDATA
{
   L_UINT uStructSize;
   L_INT nMinRange;
   L_INT nMaxRange;
   L_UINT uFlags;
}
COMPDATA, L_FAR * LPCOMPDATA;

#define CLTH_TYP_BANDPASS	0x00000000 //  The values falling outside the range are modified.
#define CLTH_TYP_BANDREJECT	0x00000001 //  The values falling inside the range are modified.

#define CLTH_MOD_CHANNEL	0x00000000 //  Each channel component is modified independently.
#define CLTH_MOD_ALL		0x00000010 //  The pixel is rejected the test if one of the component is rejected.

#define CLTH_VALUE_MIN		0x00000000 //  The rejected values are set to 0.
#define CLTH_VALUE_MAX		0x00000100 //  The rejected values are set to the maximum value
#define CLTH_VALUE_CLAMP	0x00000200 //  The rejected component values less that nMin go to the minimum value in the used color space component and the rejected component values greater than nMax go to the maximum value in the used color space component. This works only with the CLTH_MOD_CHANNEL flag.

/*
	flags for  L_ColorThresholdBitmap 
*/
#define CLTH_RGB_SPACE		0x00000000 // RGB color space
#define CLTH_HSV_SPACE		0x00000001 // HSV color space
#define CLTH_HLS_SPACE		0x00000002 // HLS color space
#define CLTH_XYZ_SPACE		0x00000003 // XYZ color space
#define CLTH_YCrCb_SPACE	0x00000004 // YCrCb color space
#define CLTH_YUV_SPACE		0x00000005 // YUV color space
#define CLTH_LAB_SPACE		0x00000006 // LAB color space
#define CLTH_CMY_SPACE		0x00000007 // CMY color space


///Sandy 2006-11-29 add
/*
    COLORREPLACE structure provides information about the replacement color for the L_ColorReplaceBitmap function.
*/
typedef struct _COLORREPLACE
{
   L_UINT uStructSize;
   COLORREF crColor;
   L_UINT uFuzziness;
} COLORREPLACE, L_FAR * LPCOLORREPLACE;
//end add

#endif // !LEADTOOLS_VER == 14


//---------end sandy---------
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltfil.h

typedef LPVOID pLOADFILEOPTION;
//typedef LPVOID pSAVEFILEOPTION;  // comment by sandy after adding struct SAVEFILEOPTION

/*
   list of file types supported
*/
#define FILE_PCX                  1 /* ZSoft PCX */
#define FILE_GIF                  2 /* CompuServe GIF */
#define FILE_TIF                  3 /* Tagged Image File Format */
#define FILE_TGA                  4 /* Targa */
#define FILE_CMP                  5 /* LEAD CMP */
#define FILE_BMP                  6 /* Windows BMP */


/*
   GIF and TIFF with LZW Compression mainly for animation
*/
//----- Iris 4/21/2008 FILE_GIF already define above, duplicate define cause fail to create correct header file
//#define FILE_GIF			2  // CompuServe GIF. Bits per pixel: 1, 2, 3, 4, 5, 6, 7, 8. 
//-----
#define FILE_TIFLZW			17 // Tagged Image File with LZW Compression and RGB color space. Bits per pixel: 1, 2, 3, 4, 5, 6, 7, 8, 16, 24, 32, 48, 64. (48- and 64- bit support are Document/Medical toolkits only) (Supports multi-page)
#define FILE_TIFLZW_CMYK	86 // Tagged Image File with LZW Compression and CMYK color space. Bits per pixel: 24, 32. (Supports multi-page)
#define FILE_TIFLZW_YCC		94 // Tagged Image File with LZW Compression and YCbCr color space. Bits per pixel: 24. (Supports multi-page)

/*
   Flags for L_FileInfo (not to make up FILEINFO.Flags!)
*/
#define FILEINFO_TOTALPAGES            0x00000001  /* fill in FILEINFO.TotalPages */

/*
   structure used by L_FileInfo
*/
typedef struct struct_file_information
{
#if LEADTOOLS_VER == 14
	L_UINT uStructSize;
#endif // LEADTOOLS_VER == 14
   L_INT    Format;              /* File format: FILE_PCX, ... */
   L_CHAR   Name[16];            /* File name, including the Ext */
   L_INT    Width;               /* Image width */
   L_INT    Height;              /* Image height */
   L_INT    BitsPerPixel;        /* Bits per pixel */
   L_INT32  SizeDisk;            /* Size of file on disk */
   L_INT32  SizeMem;             /* Size of image in memory */
   L_CHAR   Compression[20];     /* Compression method name */
   L_INT    ViewPerspective;     /* Image view prespective */
   L_INT    Order;               /* RGB order */
   L_INT    PageNumber;          /* Page number */
   L_INT    TotalPages;          /* Total number of pages present in the file */
   L_INT    XResolution;
   L_INT    YResolution;
   L_UINT32 Flags;               /* identifies file subtypes: progressive, interlaced */
   L_UINT   GlobalLoop;          /* Global animation loop count 0 = infinity */
   L_INT    GlobalWidth;         /* Global width */
   L_INT    GlobalHeight;        /* Global height */
   COLORREF GlobalBackground;    /* Global background color (see Flags) */
   RGBQUAD  GlobalPalette[256];  /* Global palette (see Flags) */
   L_UINT32 IFD;                 /* IFD offset (for TIF files only) */
#if LEADTOOLS_VER == 14
	L_INT Layers;
#endif // LEADTOOLS_VER == 14
} FILEINFO, L_FAR * pFILEINFO;

///Sandy 2006-7-12 ADD_WHEN_USING_LOADBITMAPLIST
typedef struct _LOADFILEOPTION
{
   L_UINT uStructSize; 
   L_INT XResolution;
   L_INT YResolution;
   L_UINT Flags;
   L_INT Passes;
   L_INT PageNumber;
   L_UINT GlobalLoop;
   L_UINT32 IFD;
   L_UINT   uRedScan;
   L_UINT   uGreenScan;
   L_UINT   uBlueScan; 
} LOADFILEOPTION;
///end ADD_WHEN_USING_LOADBITMAPLIST

typedef enum tagPHOTMTRICINTERP
{
   PME_MINISWHITE      =0,  /* Grayscale image, minimum value is white */
   PME_MINISBLACK      =1  ,/* Grayscale image, minimum value is black */
   PME_RGB             =2  ,/* RGB color model */
   PME_PALETTE         =3  ,/* color map indexed (palletized) */
   PME_MASK            =4  ,/* 1-bit transparency mask */
   PME_SEPARATED       =5  ,/* color separations (usually CMYK) */
   PME_YCBCR           =6  ,/* CCIR 601 YcbCr image */
   PME_CIELAB          =8   /* 1976 CIE L*a*b* image */
} PHOTMTRICINTERP;//, L_FAR * pPHOTMTRICINTERP;

#if FOR_UNICODE
#define L_TCHAR TCHAR
#else  
#define L_TCHAR char
#endif //!FOR_UNICODE CPY 10/14/05, found this missing, added
/*
   Flags for L_SaveBitmapList
*/
#define ESO_REVERSEBITS			0x00000001 // Reverses the bit order when writing CCITT Group 3 and 4 files and RAW uncompressed data, so that the least significant bit (LSB) is first.
#define ESO_NOSUBFILETYPE		0x00000002 // Prevents writing a subfile type TIFF tag when writing any TIFF file.
#define ESO_GLOBALBACKGROUND	0x00000004 // Causes a GIF file to be saved with the global background color specified by the GlobalBackground field. 
#define ESO_GLOBALPALETTE		0x00000008 // Causes a GIF file to be saved with the global palette specified by the GlobalPalette field.
#define ESO_INTERLACED			0x00000010 // Causes a GIF file to be saved as an interlaced file.
#define ESO_GLOBALLOOP			0x00000020 // Enables looping when loading an animated file. This flag must be on for the GlobalLoop field to be used.
#define ESO_NOPALETTE			0x00000040 // Causes a TIFF file to be saved as grayscale, without a palette.
#define ESO_SAVEWITHSTAMP		0x00000080 // Causes a CMP, JPEG, or Exif file to be saved with a stamp (thumbnail image), in addition to the normal image.
#define ESO_FIXEDPALETTESTAMP	0x00000100 // Causes a CMP or JPEG stamp image to be saved with a fixed palette.
#define ESO_YCCSTAMP			0x00000200 // Causes an Exif stamp image to be saved with YCbCr color space.
#define ESO_REPLACEPAGE	 		0x00000400 // Replace the page specified by PageNumber.
#define ESO_INSERTPAGE			0x00000800 // Insert the new page before the page specified by PageNumber.
#define ESO_JPEGSTAMP			0x00001000 // Save JPEG compressed stamps.
#define ESO_DISABLEMMX			0x00002000 // Do not use MMX optimized code
#define ESO_SAVEOLDJTIF			0x00004000 // Write old style JTIF files
#define ESO_NOPAGENUMBER		0x00008000 // Do not update and save the PageNumber tag associated with the pages of a multi-page TIFF file.
#define ESO_DISABLEP3			0x00010000 // Do not use P3-specific optimized code.
#define ESO_USEIFD				0x00020000 // Use the IFD offset.
#define ESO_MOTOROLAORDER		0x00040000 // Save files in Motorola byte order when possible.
#define ESO_WITHOUTTIMESTAMP	0x00080000 // Save file without time stamp.
#define ESO_PDF_TEXT_ENCODING_NONE			0x00000000 // No text encoding is used for image data.
#define ESO_PDF_TEXT_ENCODING_ASCII_BASE85	0x00100000 //  PDF, ASCII BASE 85 text encoding is used for image data.
#define ESO_PDF_TEXT_ENCODING_ASCII_HEX		0x00200000 // PDF, ASCII HEX text encoding is used for image data.
#define ESO_PDF_ENCODING_MASK				0x00300000 //  Mask of the flags is used for PDF text encoding.
#define ESO_PDF_SAVE_USE_BITMAP_DPI			0x01000000 // Use the bitmap DPI in calculating page dimensions when saving a PDF file.
#define ESO_PAD4							0x00400000 // Each line is padded to a multiple of 4 bytes. (raw data only)
#define ESO_PLT_BEZIER_CURVES				0x00800000 // PLT filter should save bezier curves.
//#define ESO_PDF_SAVE_USE_BITMAP_DPI			0x01000000 // Use bitmap DPI in calculating page dimensions when saving a PDF file.  Has been defined before.
#define ESO_PHOTOMETRICINTERPRETATIONVALID	0x02000000 // Use PhotometricInterpretation when saving TIFF files.
#define ESO_TILEINFOVALID					0x04000000 // Use the TileWidth and TileHeight members when saving TIFF files.
#define ESO_USEDITHERINGMETHOD				0x08000000 //  Use the DitheringMethod in the BITMAPHANDLE.
#define ESO_PRESERVEPALETTE					0x10000000 //  Preserve the palette when saving TIFF CCITT files (might decrease the compression ratio)
#define ESO_PDF_SAVE_LOW_MEMORY_USAGE		0x20000000 // Try to use less memory when creating a PDF file with JPEG or Fax compression.
#define ESO_USEPREDICTOR					0x80000000 // Use a predictor when saving LZW data. This is for  TIF LZW or Raw LZW data that is 8 bpp or more. This flag is ignored if the LZW data is less than 8 bpp.


typedef struct _SAVEFILEOPTION
{
   L_UINT uStructSize; 
   L_INT    Reserved1;
   L_INT    Reserved2;
   L_UINT Flags;
   L_INT Passes;
   L_INT PageNumber;
   L_INT GlobalWidth;
   L_INT GlobalHeight;
   L_UINT GlobalLoop;
   COLORREF GlobalBackground;
   RGBQUAD GlobalPalette[256];
   L_UINT StampWidth;
   L_UINT StampHeight;
   L_UINT StampBits;
   L_BOOL Constrained;//---- MPEG Specific Options
   L_BOOL FieldPic;
   L_INT FrameRate;
   L_INT FramesGOP;
   L_INT PelAspectRatio;
   L_INT ProfileID;
   L_INT LevelID;
   L_INT ChromaFormat;
   L_INT VideoFormat;
   L_INT IntraDcPrec;
   L_INT32 BitRate;
   L_UCHAR UserInfo[255]; //--- end MPEG Specific
   L_UINT32 IFD;
   L_TCHAR szPassword[255]; 
   PHOTMTRICINTERP PhotometricInterpretation;
   L_UINT TileWidth;
   L_UINT TileHeight;
   L_UINT Flags2;       //---- ESO2_XXX flags
} SAVEFILEOPTION, L_FAR * pSAVEFILEOPTION;

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// ltdis.h

/*
   region processing
*/
#define L_RGN_AND             0
#define L_RGN_SET             1
#define L_RGN_ANDNOTBITMAP    2
#define L_RGN_ANDNOTRGN       3
#define L_RGN_OR              4
#define L_RGN_XOR             5
#define L_RGN_SETNOT          6

#define L_POLY_WINDING        0
#define L_POLY_ALTERNATE      1

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// lterr.h

// All return values > 1 are also successful
#define SUCCESS                          1   /** Function successful                               **/
#define FAILURE                          0   /** Function not successful                           **/

// All return values < 0 are error numbers

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//#pragma dll(ltdlg12n)
//
// Brings up the FileOpen dialog box for getting the filename to open, file information, and applicable options.
//L_INT EXT_FUNCTION L_DlgFileOpen(
//	HWND hWnd,	/* owner of dialog */
//	OPENFILENAME *pOpenFileName,	/* pointer to a Windows OPENFILENAME structure */
//	FILEOPENPARM L_FAR *pFileOpenParm,	/* pointer to an information structure */
//	L_UINT32 uFlags,	/* user interface flags for dialog */
//	LTCOMMDLGHELPCB pfnCallback,	/* pointer to a help callback function */
//	L_VOID L_FAR * pUserData);	/* pointer to more parameters for the callback */

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
#if LEADTOOLS_VER == 14
#pragma dll(ltkrn14n)
#else // !LEADTOOLS_VER == 14
#pragma dll(ltkrn12n)
#endif // !LEADTOOLS_VER == 14

L_INT EXT_FUNCTION L_InitBitmap(
	pBITMAPHANDLE pBitmap,
#if LEADTOOLS_VER == 14
	L_UINT uStructSize,
#endif // LEADTOOLS_VER == 14
	L_INT nWidth,
	L_INT nHeight,
	L_INT nBitsPerPixel);

L_INT EXT_FUNCTION L_CreateBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
#if LEADTOOLS_VER == 14
	L_UINT uStructSize,
#endif // LEADTOOLS_VER == 14
	L_UINT uMemory,	/* flag to request the type of memory to allocate */
	L_UINT uWidth,	/* width of the bitmap in pixels */
	L_UINT uHeight,	/* height of the bitmap in pixels */
	L_UINT uBitsPerPixel,	/* number of bits per pixel */
	L_UINT uOrder,	/* color order for 16-, 24-, 32, 48, and 64-bit bitmaps */
	///LPRGBQUAD pPalette,	/* pointer to the palette that the bitmap will use */
	LPVOID pPalette,
	L_UINT uViewPerspective,	/* where the beginning of the image is stored */
	L_CHAR L_FAR *pData,	/* data pointer */
	L_UINT32 dwSize);	/* size of the data buffer pointed to by pData */

L_VOID EXT_FUNCTION L_FreeBitmap(
	pBITMAPHANDLE pBitmap);
	
///Sandy add 2007-4-30
L_INT EXT_FUNCTION L_FillBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	COLORREF crFill);	/* fill color */


//--- CPY 10/15/05
#define COLORREF_GRAY16              0x04000000L
#define L_IS_COLORREF_GRAY16(clr)    ((clr & 0xFF000000) == COLORREF_GRAY16)
#define L_IS_COLORREF_INDEXED1(clr)  ((clr & 0xFF000000) == 0x01000000L)
#define L_IS_COLORREF_INDEXED2(clr)  ((clr & 0xFF000000) == 0x80000000L)
COLORREF EXT_FUNCTION L_GetPixelColor (pBITMAPHANDLE pBitmap,
                                       L_INT nRow,
                                       L_INT nCol);
//---

L_INT EXT_FUNCTION L_GrayScaleBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nBitsPerPixel);	/* number of bits */

L_INT EXT_FUNCTION L_GrayScaleBitmapEx(
   pBITMAPHANDLE pBitmap,
   L_INT nRedFact,
   L_INT nGreenFact,
   L_INT nBlueFact);

L_INT EXT_FUNCTION L_SizeBitmap(
	pBITMAPHANDLE pBitmap,
	L_INT nWidth,
	L_INT nHeight,
	L_UINT32 uFlags);

L_INT EXT_FUNCTION L_IsGrayScaleBitmap(
	pBITMAPHANDLE pBitmap);

L_INT EXT_FUNCTION L_ChangeFromDIB(
	pBITMAPHANDLE pBitmap,
#if LEADTOOLS_VER == 14
	L_UINT uStructSize,
#endif // LEADTOOLS_VER == 14
	HGLOBAL hDIB);

#if LEADTOOLS_VER == 14
HGLOBAL EXT_FUNCTION L_ChangeToDIB(pBITMAPHANDLE pBitmap, L_UINT uType = DIB_BITMAPINFOHEADER);
HGLOBAL EXT_FUNCTION L_ConvertToDIB(pBITMAPHANDLE pBitmap, L_UINT uType);
#else
HGLOBAL EXT_FUNCTION L_ChangeToDIB(pBITMAPHANDLE pBitmap);
HGLOBAL EXT_FUNCTION L_ConvertToDIB(pBITMAPHANDLE pBitmap);
#endif // LEADTOOLS_VER == 14

L_INT EXT_FUNCTION L_ConvertFromDIB(
	pBITMAPHANDLE pBitmap,
#if LEADTOOLS_VER == 14
	L_UINT uStructSize,
#endif // LEADTOOLS_VER == 14
	BITMAPINFO L_FAR * pInfo,
	L_UCHAR L_FAR * pBits);

L_INT EXT_FUNCTION L_RotateBitmap(
	pBITMAPHANDLE pBitmap,
	L_INT32 nAngle,
	L_UINT uFlags,
	COLORREF crFill);
	
	
//------sandy 2005.9.13  (ltkrn14n)
#if LEADTOOLS_VER == 14
//--- CPY 10/15/05 added
typedef L_INT (WINAPI *COLORRESCALLBACK) (pBITMAPHANDLE, L_UCHAR L_FAR *, L_INT, LPVOID);

L_INT EXT_FUNCTION L_ColorResBitmap(pBITMAPHANDLE pBitmapSrc,
                                     pBITMAPHANDLE pBitmapDst,
                                     L_UINT uStructSize,
                                     L_INT nBitsPerPixel,
                                     L_UINT32 uFlags,
                                     LPRGBQUAD pPalette,
                                     HPALETTE hPalette,
                                     L_UINT uColors,
                                     COLORRESCALLBACK pfnCallback,
                                     L_VOID L_FAR * pUserData);
//--- end CPY 10/15/05

L_INT EXT_FUNCTION L_GetBitmapColors(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nIndex,	/* index to the first color to get */
	L_INT nCount,	/* number of colors to get */
	LPRGBQUAD pPalette);	/* array values that make up your palette */

L_INT EXT_FUNCTION L_PutBitmapColors(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle to update */
	L_INT nIndex,	/* index of the first color to update */
	L_INT nCount,	/* number of colors to update */
	LPRGBQUAD pPalette);	/* pointer to your palette */

L_INT EXT_FUNCTION L_SetBitmapListItem(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* index of the bitmap to overwrite */
	pBITMAPHANDLE pBitmap);	/* pointer to the source bitmap handle */

L_INT EXT_FUNCTION L_GetBitmapListItem(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* position of the bitmap in the list */
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uStructSize);	/* size in bytes, of the structure pointed to by pBitmap */

COLORREF EXT_FUNCTION L_TranslateBitmapColor(
	pBITMAPHANDLE pBitmapDst,	/* pointer to the destination bitmap handle */
	pBITMAPHANDLE pBitmapSrc,	/* pointer to the source bitmap handle */
	COLORREF crColor);	/* color in the source bitmap */

L_INT EXT_FUNCTION L_RemoveBitmapListItem(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* position of the bitmap in the list */
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

L_INT EXT_FUNCTION L_InsertBitmapListItem(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* position at which to insert the bitmap */
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

L_INT EXT_FUNCTION L_GetBitmapListCount(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT L_FAR * puCount);	/* address of the variable to be updated */

L_INT EXT_FUNCTION L_DeleteBitmapListItems(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_UINT uIndex,	/* index of the first bitmap to delete */
	L_UINT uCount);	/* number of bitmaps to delete */

L_INT EXT_FUNCTION L_ColorResBitmapList(
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_INT nBitsPerPixel,	/* target bits per pixel */
	L_UINT32 uFlags,	/* processing options */
	LPRGBQUAD pPalette,	/* custom palette to use */
	HPALETTE hPalette,	/* custom palette handle to use */
	L_UINT uColors);	/* number of colors in the palette */

///Sandy 2006-7-12 MOVE_TO_LTFIL_DLL
//L_INT EXT_FUNCTION L_LoadBitmapList(
	//L_TCHAR L_FAR* lpszFile,	/* name of the file to load */
	//pHBITMAPLIST phList,	/* address of the variable to be updated */
	//L_INT nBitsTo,	/* resulting bitmap pixel depth */
	//L_INT nColorOrder,	/* color order for 16-, 24-, and 32-bit bitmaps */
	//pLOADFILEOPTION pLoadOptions,	/* pointer to optional extended load options */
	//pFILEINFO pFileInfo);	/* pointer to a structure */
///end 

L_INT EXT_FUNCTION L_DestroyBitmapList(
	HBITMAPLIST hList);	/* handle to the list of bitmaps */

L_INT EXT_FUNCTION L_CreateBitmapList(
	pHBITMAPLIST phList);	/* address of the variable to be updated */

L_INT EXT_FUNCTION L_CopyBitmapListItems(
	pHBITMAPLIST phList,	/* address of the variable to be updated */
	HBITMAPLIST hList,	/* handle to an existing list of bitmaps */
	L_UINT uIndex,	/* index of the first bitmap to copy */
	L_UINT uCount);	/* number of bitmaps to copy */

L_INT EXT_FUNCTION L_IsGrayScaleBitmap(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

L_INT EXT_FUNCTION L_ShearBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nAngle,	/* angle of slant */
	L_BOOL fHorizontal,	/* TRUE for horizontal, FALSE for vertical */
	COLORREF crFill);	/* COLORREF value for the fill color */
	
L_INT EXT_FUNCTION L_FlipBitmap(
	pBITMAPHANDLE pBitmap);
	
L_INT EXT_FUNCTION L_ReverseBitmap(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */
	
L_INT EXT_FUNCTION L_TrimBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nCol,	/* x coordinate origin of the rectangle to keep */
	L_INT nRow,	/* y coordinate origin of the rectangle to copy */
	L_UINT uWidth,	/* width of the rectangle to keep (in pixels) */
	L_UINT uHeight);	/* height of the rectangle to keep (in pixels) */

L_INT EXT_FUNCTION L_CopyBitmap(
	pBITMAPHANDLE pBitmapDst,	/* points to the destination bitmap handle */
	pBITMAPHANDLE pBitmapSrc,	/* points to the source bitmap handle */
	L_UINT uStructSize);	/* size in bytes, of the structure pointed to by pBitmapDst */
	
L_INT EXT_FUNCTION L_FileInfoMemory(
	L_CHAR L_FAR* pBuffer,	/* pointer to the file location in memory */
	pFILEINFO pFileInfo,	/* pointer to the LEAD FILEINFO structureFILEINFO */
	L_UINT uStructSize,	/* size in bytes, of the structure pointed to by pFileInfo */
	L_INT32 nBufferSize,	/* size in bytes of the file */
	L_UINT uFlags,	/* flag */
	pLOADFILEOPTION pLoadOptions);	/* pointer to optional extended load options */

HPALETTE EXT_FUNCTION L_DupBitmapPalette(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */
	
	
L_INT EXT_FUNCTION L_ClearBitmap(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */
	
L_INT EXT_FUNCTION L_CopyBitmapRect(
	pBITMAPHANDLE pBitmapDst,	/* pointer to the destination bitmap handle */
	pBITMAPHANDLE pBitmapSrc,	/* pointer to the source bitmap handle */
	L_UINT uStructSize,	/* size in bytes, of the structure pointed to by pBitmapDst */
	L_INT nCol,	/* x coordinate origin of the rectangle to copy */
	L_INT nRow,	/* Y coordinate origin of the rectangle to copy */
	L_UINT uWidth,	/* width of the rectangle to copy (in pixels) */
	L_UINT uHeight);	/* height of the rectangle to copy (in pixels) */

L_INT EXT_FUNCTION L_ChangeBitmapViewPerspective(
	pBITMAPHANDLE pDstBitmap,
	pBITMAPHANDLE pSrcBitmap,
	L_UINT uStructSize,
	L_INT ViewPerspective);
	
///Sandy 2006-12-9 add
L_INT EXT_FUNCTION L_CopyBitmapPalette(
	pBITMAPHANDLE pBitmapDst,	/* pointer to the destination bitmap handle */
	pBITMAPHANDLE pBitmapSrc);	/* pointer to the source bitmap handle */
	

L_INT EXT_FUNCTION L_SetBitmapPalette(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	HPALETTE hPalette);	/* handle to a Windows GDI palette */
//end

#else
L_INT EXT_FUNCTION L_CopyBitmap(
	pBITMAPHANDLE pBitmapDst,	/* points to the destination bitmap handle */
	pBITMAPHANDLE pBitmapSrc);	/* points to the source bitmap handle */

L_INT EXT_FUNCTION L_FileInfoMemory(
	L_CHAR L_FAR * pBuffer,	/* pointer to the file location in memory */
	pFILEINFO pFileInfo,	/* pointer to the LEAD FILEINFO structure */
	L_INT32 nBufferSize,	/* size in bytes of the file */
	L_UINT uFlags,	/* flag */
	pLOADFILEOPTION pLoadOptions);	/* pointer to optional extended load options */
#endif //LEADTOOLS_VER == 14	
	
	

	
	
L_INT EXT_FUNCTION L_CombineBitmap(
	pBITMAPHANDLE pBitmapDst,	/* pointer to the destination bitmap handle */
	L_INT nXDst,	/* x coordinate of the origin of the destination rectangle */
	L_INT nYDst,	/* y coordinate of the origin of the destination rectangle */
	L_INT nWidth,	/* width of the rectangle, measured in pixels */
	L_INT nHeight,	/* height of the rectangle, measured in pixels */
	pBITMAPHANDLE pBitmapSrc,	/* pointer to the source bitmap handle */
	L_INT nXSrc,	/* x coordinate of the origin of the source rectangle */
	L_INT nYSrc,	/* y coordinate of the origin of the source rectangle */
	L_UINT32 uFlags);	/* operation flags */
	

	
//------end sandy 2005.9.13


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
#if LEADTOOLS_VER == 14
#pragma dll(ltimg14n)
#else // !LEADTOOLS_VER == 14
#pragma dll(ltimg12n)
#endif // !LEADTOOLS_VER == 14


///--------- Sandy 2005-9-12
#if LEADTOOLS_VER == 14

L_INT EXT_FUNCTION L_ColorLevelBitmap(
	pBITMAPHANDLE pBitmap,	// pointer to the bitmap handle
	pLVLCLR pLvlClr,	// pointer to a LVLCLR structure
	L_UINT uFlags);	// a flag that indicates the channel being color leveled


L_INT EXT_FUNCTION L_CountLUTColors(
	RGBQUAD L_HUGE * pLUT,	/* lookup table */
	L_UINT32 ulLLUTLen,	/* LUT length */
	L_UINT L_FAR * pNumberOfEntries,	/* pointer to a variable to be updated */
	L_UINT L_FAR * pFirstIndex,	/* pointer to a variable to be updated */
	L_UINT uFlags);	/* flags */


L_INT EXT_FUNCTION L_GetUserLookupTable (
	L_UINT L_FAR * pLookupTable,	/* lookup table */
	L_UINT uLookupLen,	/* lookup table length */
	POINT L_FAR *apUserPoint,	/* array of points */
	L_UINT UserPointCount,	/* number of points in the array */
	L_UINT L_FAR *puPointCount);	/* pointer to a variable to be updated */

L_INT EXT_FUNCTION L_GetFunctionalLookupTable (
	L_INT L_FAR * pLookupTable,	/* lookup table */
	L_UINT uLookupLen,	/* lookup table length */
	L_UINT uStart,	/* first item */
	L_UINT uEnd,	/* last item */
	L_INT nFactor,	/* factor */
	L_UINT uFlag);	/* flag */

L_INT EXT_FUNCTION L_RemapBitmapIntensity(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT L_FAR * pLUT,	/* table of uLUTLen integers containing lookup values */
	L_UINT uLUTLen,	/* length of the lookup table */
	L_UINT uChannel);	/* color plane indicator */

L_INT EXT_FUNCTION L_DynamicBinaryBitmap (
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uDim,	/* dimensions of the neighborhood (uDim x uDim), in pixels */
	L_UINT uLocalContrast);	/*local contrast threshold */

L_INT EXT_FUNCTION L_ConvertToColoredGray(
	pBITMAPHANDLE pBitmapHndl,	/* pointer to a bitmap handle */
	L_INT RedFact,	/* red factor */
	L_INT GreenFact,	/* green factor */
	L_INT BlueFact,	/* blue factor */
	L_INT RedGrayFact,	/* additional red factor */
	L_INT GreenGrayFact,	/* additional green factor */
	L_INT BlueGrayFact);	/* additional blue factor */

L_INT EXT_FUNCTION L_ApplyMathLogicBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nFactor,	/* operation factor */
	L_UINT uFlags);	/* flag */

L_INT EXT_FUNCTION L_MathFunctionBitmap (
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uMType,	/* determines the manipulation function */ 
	L_UINT uFactor);	/* amplitude or frequency Factor */

L_INT EXT_FUNCTION L_InvertBitmap(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

L_INT EXT_FUNCTION L_BalanceColors(
	pBITMAPHANDLE pBitmapHndl,	/* pointer to the bitmap handle */
	BALANCING L_FAR * pRedFact,	/* pointer to a structure */
	BALANCING L_FAR * pGreenFact,	/* pointer to a structure */
	BALANCING L_FAR * pBlueFact);	/* pointer to a structure */

L_INT EXT_FUNCTION L_MedianFilterBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uDim);	/* dimensions of the neighborhood (uDim x uDim), in pixels */

L_INT EXT_FUNCTION L_GaussianFilterBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to a bitmap handle */
	L_INT nRadius);	/* radius of the neighborhood */

L_INT EXT_FUNCTION L_UnsharpMaskBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nAmount,	/* adjustment factor */
	L_INT nRadius,	/* radius of the mask */
	L_INT nThreshold,	/* threshold value */
	L_UINT uFlags);	/* flag */

L_INT EXT_FUNCTION L_SharpenBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nSharpness);	/* amount to change the sharpness */

L_INT EXT_FUNCTION L_AverageFilterBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uDim);	/* size of the averaging neighborhood */

L_INT EXT_FUNCTION L_ContourFilterBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to a bitmap handle */
	L_INT16 nThreshold,	/* threshold value */
	L_INT16 nDeltaDirection,	/* maximum angle */
	L_INT16 nMaximumError,	/* maximum error */
	L_INT nOption);	/* flag that controls the resulting image */

L_INT EXT_FUNCTION L_ChangeBitmapIntensity(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nChange);	/* amount to change the intensity */

L_INT EXT_FUNCTION L_ChangeBitmapContrast(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nChange);	/* amount of contrast change */

L_INT EXT_FUNCTION L_HistoContrastBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nChange);	/* amount of contrast change */

L_INT EXT_FUNCTION L_ChangeBitmapHue(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nAngle);	/* angular amount to change the hue, in degrees */

L_INT EXT_FUNCTION L_ChangeBitmapSaturation(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nChange);	/* amount to change saturation */

L_INT EXT_FUNCTION L_GammaCorrectBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uGamma);	/* unsigned integer that represents the gamma value */

L_INT EXT_FUNCTION L_EdgeDetectorBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uThreshold,	/* threshold value */
	L_UINT uFilter);	/* filter to be used */

L_INT  EXT_FUNCTION L_EdgeDetectStatisticalBitmap(
	pBITMAPHANDLE pBitmap,
	L_UINT uDim,
	L_UINT uThreshold,
	COLORREF crEdgeColor,
	COLORREF crBkColor);
	
L_INT EXT_FUNCTION L_EdgeDetectEffectBitmap(
	pBITMAPHANDLE pBitmap,
	L_UINT uLevel,
	L_UINT uThreshold,
	L_UINT uFlags);
	
L_INT EXT_FUNCTION L_GaussianFilterBitmap(
    pBITMAPHANDLE pBitmap,
    L_INT nRadius);
    
L_INT EXT_FUNCTION L_AllocFTArray(	
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	pFTARRAY L_FAR * ppFTArray,	/* pointer to pointer to FTARRAY structure */
	L_UINT uStructSize);	/* the size of the FTARRAY structure */
	    
L_INT EXT_FUNCTION L_FreeFTArray(
	pFTARRAY pFTArray);	

L_INT EXT_FUNCTION L_FFTBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	pFTARRAY pFTArray,	/*pointer to an FTARRAY structure */
	L_UINT uFlags);	/*flags*/
	
L_INT EXT_FUNCTION L_FTDisplayBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	pFTARRAY pFTArray,	/* pointer to structure */
	L_UINT uFlags);	/* flags */
	
	
L_INT EXT_FUNCTION L_AlphaBlendBitmap(
	pBITMAPHANDLE pBitmapDst,	/* pointer to a bitmap handle */
	L_INT nXDst,	/* x coordinate */
	L_INT nYDst,	/* y coordinate */
	L_INT nWidth,	/* width */
	L_INT nHeight,	/* height */
	pBITMAPHANDLE pBitmapSrc,	/* pointer to a bitmap handle */
	L_INT nXSrc,	/* x coordinate */
	L_INT nYSrc,	/* y coordinate */
	L_INT nOpacity);	/* opacity value */
	
L_INT EXT_FUNCTION L_CreateFadedMask(
	pBITMAPHANDLE pBitmap,/* pointer to the bitmap handle */
	pBITMAPHANDLE pMaskBitmap,	/* pointer to a bitmap handle */
	L_UINT uStructSize,	/* size in bytes, of the structure pointed to by pMaskBitmap */
	L_INT nLength,	/* extent of the fade */
	L_INT nFadeRate,	/* fade rate */
	L_INT nStepSize,	/* step size */
	L_INT nInflate,	/* expansion value */
	L_UINT uFlag,	/* flag */
	L_INT nMaxGray,	/* maximum value of the fade color */
	COLORREF crTransparent);	/* transparent color */
	
L_INT EXT_FUNCTION L_FeatherAlphaBlendBitmap(
	pBITMAPHANDLE pBitmapDst,	/* pointer to the bitmap handle */
	L_INT nXDst,	/* x coordinate */
	L_INT nYDst,	/* y coordinate */
	L_INT nWidth,	/* width */
	L_INT nHeight,	/* height */
	pBITMAPHANDLE pBitmapSrc,	/* pointer to a bitmap handle */
	L_INT nXSrc,	/* x coordinate */
	L_INT nYSrc,	/* y coordinate */
	pBITMAPHANDLE pBitmapMask);	/* pointer to a bitmap handle */
	
L_INT EXT_FUNCTION L_CombineBitmapExt(
	pBITMAPHANDLE pBitmapDst,	/* pointer to the destination bitmap handle */
	L_INT nXDst,	/* x coordinate of the origin of the destination rectangle */
	L_INT nYDst,	/* y coordinate of the origin of the destination rectangle */
	L_INT nWidth,	/* width of the rectangle, measured in pixels */
	L_INT nHeight,	/* height of the rectangle, measured in pixels */
	pBITMAPHANDLE pBitmapSrc,	/* pointer to the source bitmap handle */
	L_INT nXSrc,	/* x coordinate of the origin of the source rectangle */
	L_INT nYSrc,	/* y coordinate of the origin of the source rectangle */
	L_UINT32 uFlag);	/* operation flags */

L_INT EXT_FUNCTION L_GetBitmapHistogram(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT32 L_FAR * pHisto,	/* an array to hold the histogram */
	L_UINT uHistoLen,	/* length of the histogram */
	L_UINT uFlags);	/* flags */
	
L_INT EXT_FUNCTION L_GetFunctionalLookupTable (
	L_INT L_FAR * pLookupTable,	/* lookup table */
	L_UINT uLookupLen,	/* lookup table length */
	L_UINT uStart,	/* first item */
	L_UINT uEnd,	/* last item */
	L_INT nFactor,	/* factor */
	L_UINT uFlag);	/* flag */
	
L_INT EXT_FUNCTION L_RemapBitmapIntensity(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT L_FAR * pLUT,	/* table of uLUTLen integers containing lookup values */
	L_UINT uLUTLen,	/* length of the lookup table */
	L_UINT uChannel);	/* color plane indicator */
	
L_INT EXT_FUNCTION L_SubtractBackgroundBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to bitmap handle */
	L_UINT uRollingBall,	/* ball size */
	L_UINT uShrinkSize,	/* shrink size ratio */
	L_UINT uBrightnessFactor,	/* brightness factor */
	L_UINT uFlags);	/* process flags */
	
L_INT EXT_FUNCTION L_HistoEqualizeBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_INT nFlag);	/* flag */
	
L_INT EXT_FUNCTION L_AutoTrimBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uThreshold);	/* delta value for detecting blank space */
	
L_INT EXT_FUNCTION L_GetAutoTrimRect(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uThreshold,	/* delta value for detecting blank space */
	RECT L_FAR * pRect);	/* address of the variable to be updated */
	
L_INT EXT_FUNCTION L_AddBitmapNoise(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uRange,	/* percentage of coverage */
	L_UINT uChannel);	/* color plane constant */

L_INT EXT_FUNCTION L_ColorThresholdBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uColorSpace,	/* color space  */
	LPCOMPDATA pCompData);	/* pointer to an array of structures */
	
L_INT EXT_FUNCTION L_IntensityDetectBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	L_UINT uLow,	/* lowest intensity to detect */
	L_UINT uHigh,	/* highest intensity to detect */
	COLORREF crInColor,	/* color used to fill the inner segment */
	COLORREF crOutColor,	/* color used to fill the outer segment */
	L_UINT uChannel);	/* channel to be processed */
	
L_INT EXT_FUNCTION L_AutoColorLevelBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	pLVLCLR pLvlClr,	/* pointer to a LVLCLR structure that specifies input level values for all channels */
	L_UINT uBlackClip,	/* percentage of the bitmaps black (Shadow) pixels to clip */
	L_UINT uWhiteClip,	/* percentage of the bitmaps white (Highlight) pixels to clip */
	L_UINT uFlags);	/* a flag that indicates the type of leveling to perform */	
	
L_INT EXT_FUNCTION L_SpatialFilterBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	LPSPATIALFLT pFilter);	/* pointer to the spatial filter to use */
	
L_INT EXT_FUNCTION L_UserFilterBitmap (
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	LPUSERFLT pFilter);	/* pointer to a structure */	
	
L_INT EXT_FUNCTION L_AutoBinaryBitmap(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

///Sandy 2006-12-06 not permission to use
///// add 2006-12-2
//L_INT EXT_FUNCTION L_MaxFilterBitmap(
	//pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	//L_UINT uDim);	/* dimensions of the neighborhood (uDim x uDim), in pixels */
	//
//L_INT EXT_FUNCTION L_MinFilterBitmap(
	//pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	//L_UINT uDim);	/* dimensions of the neighborhood (uDim x uDim), in pixels */
	//
//L_INT EXT_FUNCTION L_BinaryFilterBitmap(
	//pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	//LPBINARYFLT pFilter);	/* pointer to the binary filter to use */
/////end

//--- CPY 11/4/05 these two functions must be called via VC by OC exposed functions
// there must be some problem with passing pointer arrays of pBITMAPHANDLE
/*
L_INT EXT_FUNCTION L_ColorSeparateBitmap(
	pBITMAPHANDLE pBitmap,
	pBITMAPHANDLE L_FAR * ppBitmap,
	L_UINT uStructSize,
	L_UINT32 uFlags);

L_INT EXT_FUNCTION L_ColorMergeBitmap(
	pBITMAPHANDLE pBitmap,
	pBITMAPHANDLE L_FAR * ppBitmap,
	L_UINT uStructSize,
	L_UINT32 uFlags);
*/
#endif // LEADTOOLS_VER == 14	

///------- end Sandy 2005-9-12
	

//--- CPY 10/15/05
L_INT EXT_FUNCTION L_GetBitmapColorCount(pBITMAPHANDLE pBitmap,
                                         L_UINT32 L_FAR *puCount);

L_INT EXT_FUNCTION L_GetMinMaxBits(pBITMAPHANDLE pBitmap,
                                   L_INT L_FAR*pLowBit,
                                   L_INT L_FAR*pHighBit);

L_INT EXT_FUNCTION L_GetMinMaxVal(pBITMAPHANDLE pBitmap,
                                  L_INT L_FAR*pMinVal,
                                  L_INT L_FAR*pMaxVal);
//--- end CPY 10/15/05

/// sandy 2006-11-29
L_INT EXT_FUNCTION L_ColorReplaceBitmap(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	LPCOLORREPLACE pColorReplace,	/* array of COLORREPLACE structures */
	L_UINT uColorCount,	/* number of colors */
	L_INT nHue,	/* angular amount to change the hue, in degrees*/
	L_INT nSaturation,	/* amount to change saturation */
	L_INT nBrightness);	/* amount to change the brightness */
///end sandy

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
#if LEADTOOLS_VER == 14
#pragma dll(ltfil14n)
#else // !LEADTOOLS_VER == 14
#pragma dll(ltfil12n)
#endif // !LEADTOOLS_VER == 14

L_INT EXT_FUNCTION L_FileInfo(
	///L_CHAR L_FAR * pszFile,	/* input file name to query */
	LPCSTR pszFile,
	pFILEINFO pFileInfo,	/* pointer to the FILEINFO structure to be filled */
#if LEADTOOLS_VER == 14
	L_UINT uStructSize, /* size of FILEINFO struct */
#endif // LEADTOOLS_VER == 14
	L_UINT uFlags,	/* flag */
	pLOADFILEOPTION pLoadOptions);	/* pointer to optional extended load options */

L_INT EXT_FUNCTION L_LoadBitmap(
	///L_CHAR L_FAR * pszFile,	/* name of the file to load */
	LPCSTR pszFile,
	pBITMAPHANDLE pBitmap,	/* pointer to the target bitmap handle */
#if LEADTOOLS_VER == 14
	L_UINT uStructSize, /* size of BITMAPHANDLE struct */
#endif // LEADTOOLS_VER == 14
	L_INT nBitsPerPixel,	/* resulting bitmap pixel depth */
	L_INT nOrder,	/* color order for 16-, 24-, 32-, 48, and 64-bit bitmaps */
	pLOADFILEOPTION pLoadOptions,	/* pointer to optional extended load options */
	pFILEINFO pFileInfo);	/* pointer to a structure */

L_INT EXT_FUNCTION L_SaveBitmap(
	///L_CHAR L_FAR * pszFile,
	LPCSTR pszFile,
	pBITMAPHANDLE pBitmap,
	L_INT nFormat,
	L_INT nBitsPerPixel,
	L_INT nQFactor,
	pSAVEFILEOPTION pSaveOptions);

L_INT EXT_FUNCTION L_SaveBitmapList(
	L_TCHAR L_FAR* lpszFile,	/* output file name */
	HBITMAPLIST hList,	/* handle to the list of bitmaps */
	L_INT nFormat,	/* output file format */
	L_INT nBits,	/* resulting file's pixel depth */
	L_INT nQFactor,	/* quality factor */
	pSAVEFILEOPTION pSaveOptions);	/* pointer to optional extended save options */
	
L_INT EXT_FUNCTION L_GetDefaultSaveFileOption(
	pSAVEFILEOPTION pSaveOptions,	/* pointer to a SAVEFILEOPTION structure */
	L_UINT uStructSize);	/* size of the SAVEFILEOPTION structure */
	
///Sandy 2006-7-12 MOVE_TO_LTFIL_DLL
L_INT EXT_FUNCTION L_LoadBitmapList(
	//L_TCHAR L_FAR* lpszFile,	/* name of the file to load */
	LPCSTR pszFile,
	pHBITMAPLIST phList,	/* address of the variable to be updated */
	L_INT nBitsTo,	/* resulting bitmap pixel depth */
	L_INT nColorOrder,	/* color order for 16-, 24-, and 32-bit bitmaps */
	pLOADFILEOPTION pLoadOptions,	/* pointer to optional extended load options */
	pFILEINFO pFileInfo);	/* pointer to a structure */
///end

L_INT EXT_FUNCTION L_GetDefaultLoadFileOption(
	pLOADFILEOPTION pLoadOptions,	/* pointer to a LOADFILEOPTION structure */
	L_UINT uSize);	/* size of the LOADFILEOPTION structure */
	
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
	
///--------- Sandy 2005-9-13
#if LEADTOOLS_VER == 14
#pragma dll(ltdis14n)

L_BOOL EXT_FUNCTION L_BitmapHasRgn(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

L_INT EXT_FUNCTION L_SetBitmapRgnPolygon(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	pRGNXFORM pXForm,		/* pointer to a coordinate-translation structure */
	POINT L_FAR * pPoints,	/* pointer to an array of POINT structures */
	L_UINT uPoints,			/* number of points in the array */
	L_UINT uFillMode,		/* indicates how to handle complex crossing lines */
	L_UINT uCombineMode);	/* action to take regarding the existing region */

L_INT EXT_FUNCTION L_SetBitmapRgnRect(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	pRGNXFORM pXForm,	/* pointer to a coordinate-translation structure */
	RECT L_FAR * pRect,	/* pointer to the rectangular region */
	L_UINT uCombineMode);	/* action to take regarding the existing region */
	
L_INT EXT_FUNCTION L_ChangeFromDDB(
	HDC hDC,	/* handle to the device responsible for the conversion */
	pBITMAPHANDLE pBitmap,	/* address of the LEAD bitmap handle */
	L_UINT uStructSize,	/* size in bytes, of the structure pointed to by pBitmap */
	HBITMAP hBitmap,	/* handle to the DDB to be changed */
	HPALETTE hPalette);	/* handle to the palette */

HBITMAP EXT_FUNCTION L_ChangeToDDB(
	HDC hDC,	/* handle to the device responsible for the conversion */
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */

	
L_INT EXT_FUNCTION L_LineProfile(
	pBITMAPHANDLE pBitmapHndl,	/* pointer to the bitmap handle */
	long FirstPoint,	/* starting point of the line */
	long SecondPoint,	/* end point of the line */
	L_INT L_FAR * L_FAR * pRed,	/* pointer to a pointer */
	L_INT L_FAR * L_FAR * pGreen,	/* pointer to a pointer */
	L_INT L_FAR * L_FAR * pBlue);	/* pointer to a pointer */
	
///Sandy 2006-12-06 ADD
L_INT EXT_FUNCTION L_SetBitmapRgnEllipse(
	pBITMAPHANDLE pBitmap,	/* pointer to the bitmap handle */
	pRGNXFORM pXForm,	/* pointer to a coordinate-translation structure */
	RECT L_FAR * pRect,	/* pointer to the bounding rectangle of the region */
	L_UINT uCombineMode);	/* action to take regarding the existing region */

L_INT EXT_FUNCTION L_FreeBitmapRgn(
	pBITMAPHANDLE pBitmap);	/* pointer to the bitmap handle */
///end

#endif // !LEADTOOLS_VER == 14
///--------- end Sandy 2005-9-13

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
#if LEADTOOLS_VER == 14

#define L_CHANGE_FROM_DIB(_pBitmap, _hDIB) \
	L_ChangeFromDIB(_pBitmap, sizeof(BITMAPHANDLE), _hDIB)
#define L_CHANGE_TO_DIB(_pBitmap) \
	L_ChangeToDIB(_pBitmap, DIB_BITMAPINFOHEADER)
//----- CPY 10/15/05, this macro somehow is problematic, removed
//#define L_COLOR_RES_BITMAP(_pBitmapSrc, _pBitmapDst, _nBitsPerPixel, _uFlags, _pPalette, _hPalette, _uColors, _pfnCallback, _pUserData) \
//	L_ColorResBitmap(_pBitmapSrc, _pBitmapDst, sizeof(BITMAPHANDLE), _nBitsPerPixel, _uFlags, _pPalette, _hPalette, _uColors, _pfnCallback, _pUserData)
//-----
#define L_COPY_BITMAP_RECT(_pBitmapDst, _pBitmapSrc, _nCol, _nRow, _uWidth, _uHeight) \
	L_CopyBitmapRect(_pBitmapDst, _pBitmapSrc, sizeof(BITMAPHANDLE), _nCol, _nRow, _uWidth, _uHeight)
////-----sandy 2005.9.13
#define L_COPY_BITMAP(_pBitmapDst, _pBitmapSrc) \
	L_CopyBitmap(_pBitmapDst, _pBitmapSrc, sizeof(BITMAPHANDLE))
////-----end sandy 2005.9.13

#define L_CREATE_BITMAP(_pBitmap, _uMemory, _uWidth, _uHeight, _uBitsPerPixel, _uOrder, _pPalette, _uViewPerspective, _pData, _dwSize) \
	L_CreateBitmap(_pBitmap, sizeof(BITMAPHANDLE), _uMemory, _uWidth, _uHeight, _uBitsPerPixel, _uOrder, _pPalette, _uViewPerspective, _pData, _dwSize)
#define L_CHANGE_BITMAP_VIEW_PERSPECTIVE(_pDstBitmap, _pSrcBitmap, _nViewPerspective) \
	L_ChangeBitmapViewPerspective(_pDstBitmap, _pSrcBitmap, sizeof(BITMAPHANDLE), _nViewPerspective)
#define L_CONVERT_FROM_DIB(_pBitmap, _pInfo, _pBits) \
	L_ConvertFromDIB(_pBitmap, sizeof(BITMAPHANDLE), _pInfo, _pBits)
#define L_FILE_INFO(_pszFile, _pFileInfo, _uFlags, _pLoadOptions) \
	L_FileInfo(_pszFile, _pFileInfo, sizeof(FILEINFO), _uFlags, _pLoadOptions)
#define L_GET_BITMAP_LIST_ITEM(_hList, _uIndex, _pBitmap) \
	L_GetBitmapListItem(_hList, _uIndex, _pBitmap, sizeof(BITMAPHANDLE))
#define	L_GET_DEFAULT_LOAD_FILE_OPTION(_pLoadOptions) \
	L_GetDefaultLoadFileOption(_pLoadOptions, sizeof(LOADFILEOPTION))
#define L_INIT_BITMAP(_pBitmap, nWidth, nHeight, nBitsPerPixel) \
	L_InitBitmap(_pBitmap, sizeof(BITMAPHANDLE), nWidth, nHeight, nBitsPerPixel)
#define L_LOADBITMAP(_pszFile, _pBitmap, _nBitsPerPixel, _nOrder, _pLoadOptions) \
	L_LoadBitmap(_pszFile, _pBitmap, sizeof(BITMAPHANDLE), _nBitsPerPixel, _nOrder, _pLoadOptions, NULL)
#define L_SET_WMF_RESOLUTION(_nRes) \
	L_SetWMFResolution(_nRes, _nRes)

#define L_CHANGE_VIEW_PERSPECTIVE(_pDst, _pSrc, _view) \
	L_ChangeBitmapViewPerspective(_pDst, _pSrc, sizeof(BITMAPHANDLE), _view)
	
#else // !LEADTOOLS_VER == 14

#define L_CHANGE_FROM_DIB(_pBitmap, _hDIB) \
	L_ChangeFromDIB(_pBitmap, _hDIB)
#define L_CHANGE_TO_DIB(_pBitmap) \
	L_ChangeToDIB(_pBitmap)
//--- CPY 10/15/05, this macro somehow is problematic, removed
//#define L_COLOR_RES_BITMAP(_pBitmapSrc, _pBitmapDst, _nBitsPerPixel, _uFlags, _pPalette, _hPalette, _uColors, _pfnCallback, _pUserData) \
//	L_ColorResBitmap(_pBitmapSrc, _pBitmapDst, _nBitsPerPixel, _uFlags, _pPalette, _hPalette, _uColors, _pfnCallback, _pUserData)
//---
#define L_COPY_BITMAP_RECT(_pBitmapDst, _pBitmapSrc, _nCol, _nRow, _uWidth, _uHeight) \
	L_CopyBitmapRect(_pBitmapDst, _pBitmapSrc, _nCol, _nRow, _uWidth, _uHeight)
#define L_CREATE_BITMAP(_pBitmap, _uMemory, _uWidth, _uHeight, _uBitsPerPixel, _uOrder, _pPalette, _uViewPerspective, _pData, _dwSize) \
	L_CreateBitmap(_pBitmap, _uMemory, _uWidth, _uHeight, _uBitsPerPixel, _uOrder, _pPalette, _uViewPerspective, _pData, _dwSize)
#define L_CHANGE_BITMAP_VIEW_PERSPECTIVE(_pDstBitmap, _pSrcBitmap, _nViewPerspective) \
	L_ChangeBitmapViewPerspective(_pDstBitmap, _pSrcBitmap, _nViewPerspective)
#define L_CONVERT_FROM_DIB(_pBitmap, _pInfo, _pBits) \
	L_ConvertFromDIB(_pBitmap, _pInfo, _pBits)
#define L_FILE_INFO(_pszFile, _pFileInfo, _uFlags, _pLoadOptions) \
	L_FileInfo(_pszFile, _pFileInfo, _uFlags, _pLoadOptions)
#define L_GET_BITMAP_LIST_ITEM(_hList, _uIndex, _pBitmap) \
	L_GetBitmapListItem(_hList, _uIndex, _pBitmap)
#define	L_GET_DEFAULT_LOAD_FILE_OPTION(_pLoadOptions) \
	L_GetDefaultLoadFileOption(_pLoadOptions)
#define L_INIT_BITMAP(_pBitmap, nWidth, nHeight, nBitsPerPixel) \
	L_InitBitmap(_pBitmap, nWidth, nHeight, nBitsPerPixel)
#define L_LOADBITMAP(_pszFile, _pBitmap, _nBitsPerPixel, _nOrder, _pLoadOptions) \
	L_LoadBitmap(_pszFile, _pBitmap, _nBitsPerPixel, _nOrder, _pLoadOptions, NULL)
#define L_SET_WMF_RESOLUTION(_nRes) \
	L_SetWMFResolution(_nRes)

#endif // !LEADTOOLS_VER == 14

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

#endif // !LEADTOOLS_VER == 17

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

#pragma pack(pop)

#endif // !_OC_IMG_LT_H
