/*------------------------------------------------------------------------------*
 *	File Name: 	outils.h														*
 *	Purpose:	OC-string utility functions										*
 *	Author:		TD																*
 *  Date:		2-24-05 														*
 *  Copyright OriginLab Corp. 2000-2005											*
 *																				*
 *	Modification Log															*
 *	DSC 3/4/05  MOVE_OC_THEME_FUNCTIONS_TO_VC									*
 *	ML 3/16/2005 QA70-7498 NEW_GROBJ_BASED_X_VARIABLE_TYPES						*
 *	DSC 3/24/05 CHECK_NEW_FILE													*
 *	RVD 4/15/2005 QA70-7597 v8.0223 MARKER_GROBJ								*
 *	ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC								*
 *	ML 4/28/2005 XFT_GETTING_IO													*
 *	ML 5/9/2005 RETURNING_VALUE_FROM_XFUNCTION									*
 *	RVD 5/9/2005 VOID_BAD_IDEA_MINUS_ONE_IS_ERROR								*
 *	ML 5/3/2005 QA70-7686 X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION					*
 *	YuI 05/11/05 XFUNCTION_ORIGINOBJECT_XVARIABLE								*
 *	ML 5/17/2005 QA70-7686 X_FUNCTION_DRIVEN_MENUS_WITH_TREE					*
 *	DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC									*
 *	ML 6/1/2005 STYLE_LINKS_WITH_OFFSETS										*
 *	DSC 6/27/05	CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME						*
 *	DSC 6/28/05 QA70-7841 CLASS_PATH_IN_REGISTRY								*
 *	DSC 7/7/2005 QA70-7877 COMPOSITE_NAME_DISPLAY_OPTION						*
 *	ML 7/18/2005 FIND_FILE_RETURN_VALUE											*
 *	DSC 8/17/05 FAST_XF_LIST_MATCHING_START_STRING								*
 *	SY 08/23/2005 QA70-8040 v8.0293 SWITCHES_PROCESSING_FUNCTION				*
 *	YuI 08/29/05 QA70-7921 FILE_IMPORTING_XFUCNTIONS							*
 *	DSC 8/31/05 FIND_GRAPHIC_OBJECT_X_FUNCTIONS									*
 *	CPY 9/14/05 QA70-8097 XF_REPORTING_AS_TREE_VAR								*
 *	YuI 09/19/05 QA70-8119 SUPPORT_FOR_OUTPUT_TO_BE_SAME_AS_INPUT				*
 *	DSC 9/13/05 TREE_COUNT_ITEMS_TO_VC											*
 *	DSC 9/21/05 QA70-8131 FIND_MATCHING_STRINGS_IN_ARRAY						*
 *	ML 10/5/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS					*
 *	EJP 2005-10-14 v8.0317 QA70-8166 XML_REPLACEMENT_FOR_OPK					*
 *	DSC 10/11/2005 QA70-8167 FIND_FILES_GET_VERSION_OR_DATE						*
 *	DSC 10/11/2005 QA70-8167 FIND_FILES_FROM_SPECIFIED_LOCATION					*
 *	DSC 10/18/05 QA70-8167 CONSTRUCT_XF_FDF_TREE_FOR_UPDATE						*
 *	YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS		*
 *	DSC 10/25/05 QA70-8218 REGISTER_COM_SERVER									*
 *	CPY 10/26/05 SEPARATE_OUT_CONST_INTO_OC_SYS_H								*
 *	ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION					*
 *	DSC ML 11/23/05 8.0341 QA70-8362 MAKE_UID_FOR_PFM_PEAK						*
 *  SY 01/05/2006 QA80-8451 v8.0354 OC_READ_WRITE_OGS_LIKE_FILE_SECTION			*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *	DSC 1/24/06 QA70-7635 NEW_NAME_OKUTIL_FIND_FILES_FROM_MAP					*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *	DSC 1/23/06 QA70-7635 NEW_FILE_TYPE_EXTERNDATA_ODS_OQS						*
 *  SY 02/01/2006 QA70-8498 v8.0364 TEMPLATE_INFO_INTERNAL_ACCESS				*
 *	DSC 2/3/06 CLEANUP_XFT_LOAD													*
 *	EJP 2006-02-16 v8.0366 MOVE_IMPORT_FILE_INFO_FROM_OC_TO_VC					*
 *	DSC 2/23/06 8.50369 QA70-8462 ADD_ORIGIN_PATH_CUSTOM						*
 *	DSC 3/1/06 v8.0371 FF_FILTER_XF_BY_ARGUMENT_INFO							*
 *	DSC 3/6/06 MAKE_TREE_FROM_MAP												*
 *	DSC 3/15/06	QA70-7540 FIND_SAME_NAMED_FILES_PER_PATH						*
 *	DSC 3/23/06 QA70-8586 CUSTOM_OGS_FILES										*
 *	DSC 4/5/06 ADD_FILE_SIZE_TO_MAP												*
 *	TD 4-12-06 VC_FUNCTIONS_TO_LAUNCH_XFN_GETN									*
 *	DSC 4/18/06 MOVE_OC_FUNCTION_VC												*
 *	EJP 2006-04-19 v8.0396 QA70-7066 EXPORT_ALL_TBARS_AND_BUTTON_GROUPS			*
 *	DSC 4/26/06  TREE_TO_STRING													*
 *	TD 5-19-06 QA70-8579 OC_GENERAL_MECHANISM_TO_SAVE_XFNCTIONS_IN_ORIGIN_FILES	*
 *	TD 6-2-06 QA70-8708 CALLING_BEFORE_EXECUTE_EVENT							*
 *  Hong 7/11/06 PARAM_MISS_DEFAULT_VALUE										*
 *	ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
 *  SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET						*
 *  SY 2006-10-09 QA70-9037 v8.0495 SAVE_AS_DIALOG								*
 *	DSC 10/19/06 GET_FILE_TIME_SIZE_FOR_DIR										*
 *	EJP 2006-10-24 v8.0500 QA70-8754 OC_LOAD_SAVE_PALETTE						*
 *	ML 12/15/2006 ENABLING_IMAGE_MENU_ITEMS_BASED_ON_PRESENCE_OF_IMAGE_INPUT_ARG*
 *  Hong 01/12/07 NO_NEED_DUMP_HIDDEN_TREENODE_FOR_RESULT_TREE					*
 *	EJP 2007-01-12 v8.0541 QA70-9103 NOTIFY_USER_FILE_ALREADY_IN_PKG			*
 *	YuI 01/17/07 QA70-9285 SILENT_XF_INVOCATION									*
 *	DSC 1/22/07 QA70-3263 INTERNATIONAL_VERSION_CHANGING_LANGUAGE_DYNAMICALLY	*
 *	AW 01/29/07 QA80-9310 v8.0550b AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
 *	EJP 2007-02-09 v8.0560 QA70-8548 EXPORT_USER_BUTTON_GROUP_TO_OPX			*
 *	YuI 2/28/07 NEED_TO_SUPPORT_REDUCED_RANGE_STRING_NOTATION					*
 *	YuI 03/01/07 NLSF_INIT_FROM_SELECTION_SHOULD_BE_SMARTER						*
 *	ML 3/19/2007 UNNECESSARY_EVENT_HANDLER_SETTING								*
 *	AW 04/03/07 QA80-9548 v8.0597 XF_LOCALIZATION								*
 *	AW 04/11/07 QA80-9609 v8.0598 MORE_ON_CHANGE_COL_IN_IMPWIZ					*
 *	TD 5-8-07 GETNTREE_THEME_APPLICATION_WITH_RANGES							*
 *	YuI 05/17/07 QA80-9782 XFUNCTION_CREATION_SPEED_IMPROVEMENT					*
 *	DSC 5/23/07 QA70-8451 v8.0625 CREATE_80_EVALUATION_ATTRIBUTE_FOR_DEMO		*
 *	TD 5-30-07 QA80-9845 EXPOSE_CUSTOM_COLORS_TO_OC								*
 *  SY 2007-06-06 QA70-9426 v8.0634 ASSIGN_TREE_VARABILE_FOR_XF_IN_LT			*
 *	ML 6/7/2007 QA70-9883 XFUNCS_FOLDER_SNAPSHOT_MUST_MAKE_ALLOWANCE_FOR_INEXACT_TIME 
 *	YuI 06/08/07 NLSF_INIT_FROM_SELECTION_SHOULD_BE_SMARTER						*
 *	EJP	2007-07-10 v8.0657 QA70-9103 EXTRACT_FILES_FROM_OPX						*
 *	YuI 07/17/07 QA70-10074 FITTER_DATA_COMMON_EIGHT_APPLICATION				*
 *	CPY 7/24/2007 QA70-10107 COMPARE_RANGE_STR_NEED_TO_SUPPORT_XY_RANGE			*
 *	EJP 2007-08-15 v8.0683 QA70-9987 AUTO_INSTALL_OPX_OPK_ON_STARTUP			*
 *	Folger 08/30/07 ADD_PREVIOUS_PATH_TO_MAKE_ADD_TEMPLATE_MORE_FLEXIBLE		*
 *	ML 9/5/2007 QA70-10111 LICENSING_FOR_GROUP_FEATURE							*
 *	Hong 09/08/07 v8.0699 MORE_OPTION_TO_DUMP_MAP_INFO_FOR_COMBO_NODE			*
 *	YuI 09/10/07 QA70-10358 ANOVA_RECALCULATE_FAILS_AFTER_RENAME				*
 *	Folger 09/11/07 CHECK_IF_SERVER_HAS_VALID_LICENSE							*
 *	Folger 09/17/07 CENTRALIZE_GET_SET_GROUP_PATH								*
 *	Folger 09/18/07 CENTRALIZE_OPERATION_ON_GROUP_SERVER_INI					*
 *	YuI 09/18/07 QA70-10331 REPORT_DATA_POLYRANGES_ARE_SCREWED_UP_AFTER_CHANGE_PARAM*
 *	DSC 8/29/07 QA70-6477 QA70-10320 FIND_ORIGIN_PATHS_FROM_REGISTRY			*
 *	Folger 09/19/07 COPY_ESSENTIAL_FILES_WHEN_NEEDED							*
 *	ML 9/21/2007 RESOLVING_UNC_PATH_TO_LOCAL_PATH								*
 *	Folger 09/27/07 SUPPORT_FORCE_DELTE_FILE_IF_READ_ONLY						*
 *	Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML							*
 *	YuI 10/02/07 QA70-10468 CHANGE_PARAM_CANCEL_MESSES_UP_THE_DATA_MARKERS		*
 *	DSC 10/23/07 QA70-10544 8.0732 ALLOW_SUBSTTUTE_ORIGIN_REGISTRY_KEY_FOR_TECH_SUPPORT
 *	EJP 2007-11-01 v8.0739 QA70-10528 CREATE_DEVKIT_FROM_LABTALK				*
 *	ML 10/31/2007 QA70-10630 LOCALIZING_KEYWORDS_FOR_XF_AND_THEMES				*
 *	Folger 11/19/07 ALWAYS_GET_ENGLISH_PDS										*
 *	ML 11/19/2007 QA70-10701 XF_MENU_ITEMS_BASED_ON_GRAPH_TYPE					*
 *	YuI 11/19/07 QA70-10716 GUI_LOCALIZATION_ON_CHANGE_PARAM					*
 *	ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER	*
 *	Folger 11/21/07 TWO_DIRECTION_RPEDEFINED_CONVERSION_IS_NEEDED				*
 *	YuI 11/27/07 QA70-10542 FIND_X_FROM_Y_SHOULD_ALLOW_OUTPUT_COLLISIONS		*
 *	Folger 11/28/07 ALLOW_COPY_AUTO_ATTRIBUTE									*
 *	ML 11/30/2007 QA70-10701 SHOULD_ENABLE_XFMENUITEMS_ON_EMPTY_GRAPHS_IF_NOT_ANALYSIS
 *	YuI 12/05/07 IMPROVING_ERROR_HANDLING_ON_PACKAGE_DEPLOYMENT					*
 *	ML 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE								*
 *	YuI 12/06/07 QA70-10786 IMPROVING_ERROR_HANDLING_ON_PACKAGE_DEPLOYMENT		*
 *	ML 12/11/2007 QA70-10810 LOADING_AND_SAVING_OXF_WITHOUT_LOCALIZING_WHEN_FOR_COMPILATION
 *	Sim 01-11-2008 ACCESS_NLFIT_REPORT_TREE										*
 *	Folger 01/15/08 OKUTIL_GET_ORIGIN75_PATH									*
 *	YuI 01/14/08 QA70-10936 GET_RUNTIME_DESCRIPTION_TWEAK						*
 *	Hong 01/18/08 QA80-10929 ADD_LT_NLFIT_MECHANISM								*
 *	Folger 01/28/08 QA80-10929 EXPOSE_CONVERT_OPERATION_TREE_TO_LABTALK_TREE	*
 *	Folger 01/30/08 QA80-10929 DWORD_OPTION_FOR_OPERATION_TREE_ACCESS			*
 *	Folger 01/31/08 QA80-10929 USE_PARAMETER_NAMES_WHEN_LIST_LABTALK_TREE		*
 *	ML 1/30/2008 QA70-10929 NLFIT_CONVERTING_INPUT_DATA_OPER_TREE_TO_LT_TREE	*
 *	Folger 02/13/08 QA80-10929 ACCESS_FIT_STATUS_FROM_LT_TREE					*
 *	Folger 02/15/08 QA80-11007 MOVE_EXPORT_GRAPH_MAKE_TREE_TO_VC				*
 *	Folger 02/19/08 QA80-10929 OPTIONAL_DWORD_TO_DISPLAY_KEY_AND_NAME			*
 *	Folger 03/10/08 QA80-11192 THEME_LIST_SHOULD_INCLUDE_DEFAULT_INSTEAD_OF_FACTORY_DEFAULT
 *	Sim 03-15-2008 MORE_ACCESS_NLFIT_REPORT_TREE								*
 *	Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
 *	CPY 4/19/08 QA80-11197 REMINDER_MSG_BOX_YES_NO_CANCEL_CLEANUP				*
 *	Sim 05-21-2008 NLFIT_OP_LT_UPPER_LOWER_BOUND_ENABLE							*
 *	TD ML 05-30-2008 QA80-11622 UPDATING_ANOVA_HANDLERS_ON_RECALCULATE_FROM_OPJ	*
 *	YuI 06/06/08 QA70-8966 XF_DRAG_AND_DROP_PROBLEM								*
 *	Folger 07/22/08 QA80-11874 SUPPORT_MERGE_UFF_INI_FROM_SYSTEM_INI			*
 *	Sim 08-14-2008 QA80-12017 ADD_NUMBER_PARA_INFO_ON_NLFIT_RESULT_LT_TREE		*
 *	DSC 2008-08-22 QA70-12980 8.0929 ADD_CHANGE_LANGUAGE_FOR_ALL_USERS_OPTION	*
 *	Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS									*
 *	Folger 11/12/08 QA80-12488 v8.0969 PEAK_CHARACTERISTIC_REPORT_CANNOT_BE_AUTO_UPDATED
 *	Folger 11/13/08 v8.0970 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP*
 *	Kyle 12/03/2008 QA70-9982-S2 OKUTIL_FIND_LT_FUNCTIONS_RETURN_FUNCTION_TYPES_AND_ARGUMENT_TYPES
 *	Hong 12/12/08 QA80-112758-P1 v8.0986 ALLOW_COL_RANGE_BE_USED_IN_DECLARATION	*
 *	Folger 12/12/08 QA80-12773 v8.0986 SUPPORT_SPECIFY_OC_FUNCTION_CATEGORY_IN_LABTALK_PRAGMA
 *	Hong 12/24/08 QA80-12798 v8.0990c THEME_COMPARE_NEED_DISPLAY_REF_VAL_IN_ATTRIB
 *	YuI 12/29/08 QA70-12831 COLUMN_FORMULA_TO_REMEMBER_THE_RANGE				*
 *	Folger 01/08/09 v8.0994d SUPPORT_GETTING_NUMBER_OF_DEFAULT_ARGUMENTS_ABOUT_OCLT_FUNCTION
 *	YuI 02/10/09 QA70-13062 NEED_TO_KEEP_DATA_MARKERS_IF_NO_ANALYSIS_MARKERS_CREATED*
 *	TD 02-16-2009 QA80-13103 OC_ACCESS_TO_TOOLBARS								*
 *	Kyle 03/09/2009 QA80-13228 ADD_FUNCTION_TO_CONVERT_LABELS_STRING_TO_INDICES	*
 *	Hong 03/13/09 QA80-13283 FIX_NLFIT_SECOND_DATASET_OUTPUT_REMOVED_DUE_TO_OUTPUT_INDEX_INTERSECTED
 *	Folger 03/24/09 QA80-13331-P1 CUSTOMIZED_OUTPUT_COLUMN_LONGNAME_FORMAT_SUPPORT
 *	Folger 04/22/09 QA80-10889 SUPPORT_COPY_DATA_FORMAT_AS_NEW_XF_SWITCH		*
 *	TD 02-16-2009 QA80-13103 OC_ACCESS_TO_TOOLBARS								*
 *	Sim 05-20-2009 QA80-13612 MOVE_TEMPLATE_UTILS_FROM_OC_TO_VC					*
 *	EJP 2009-05-20 QA80-13612 ADD_TEMPLATE_TO_LIBRARY_ON_DRAG_DROP				*
 *	YuI 05/22/09 QA70-13659 NO_AUTOFILL_IF_EMBEDDINGS_IN_BEGIN_RANGE			*
 *	YuI 06/11/09 QA70-13772 FAILED_TO_CREATE_MULTIPLE_NEW_COLUMNS				*
 *	YuI 07/09/09 QA70-13915 PROPER_SUPPORT_FOR_OUTPUT_MULTIDATA_XYRANGE			*
 *	Folger 07/23/09 QA80-13420-P2 XF_BASED_PLOTTING_NEEDS_GETN_TREE_AND_AUTO_UPDATE_SUPPORT
 *	Folger 08/19/09 QA80-14168 LABTALK_TREE_NICE_DUMPING						*
 *	Hong 08/24/09 QA80-11920 IMP_CSV_SUPPORT_AUTO_DETECTED_SEPARATOR_BY_DEFAULT	*
 *	Folger 08/25/09 QA80-14087-P10 NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
 *	Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS			*
 *	Folger 08/27/09 QA80-14215 CHANGE_USER_FILES_FOLDER_IN_ORIGIN				*
 *	TD ML 08-27-2009 QA80-13732 CONTEXT_SENSITIVE_CONTEXT_DRIVEN_XFUNCTIONS		*
 *	Kyle 09/18/2009 QA80-14216 SUPPORT_OPENING_SYSTEM_EXPLORER_FROM_OC			*
 *	YuI 09/21/09 QA70-14346_P3 ANNOTATION_SCREWED_UP_IF_TERNARY_IS_SCALED		*
 *	Kenny 09/27/2009 QA81-14241 INSERT_PARAM_NEED_CORRECT_INDICES_AND_CENTRALIZE_CODES*
 *	Kyle 10/10/2009 QA80-14187 REPORT_TREE_COPY_PROPERTY_FROM_SOURCE_COLUMN		*
 *	YuI 10/12/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT							*
 *	TD CP 10-09-2008 QA80-14417_P1 LT_COLOR_INDEX_SHOULD_ONLY_USE_UPTO_LAST_NON_WHITE_CUTOM_COLOR*
 *	Folger 10/19/09 QA81-14145-S1 FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
 *	Kyle 10/20/2009 QA80-14475-P4 VC_CONSTRUCT_ORDER_TO_REORDER_WKS				*
 *	Kyle 10/29/2009 QA80-14187-P1 SUPPORT_COPY_LABELS_FROM_A_SOURCE_COLUMN		*
 *	YuI 10/29/09 QA70-11347 NUMERIC_SHORT_COLUMN_NAME_RANGE_NOTATION_SUPPORT	*
 *	YuI 11/02/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT							*
 *	Folger 11/23/09 QA81-14709 COMMA_AND_DOT_SHOULD_BE_ALLOWED_IN_SHEET_NAME	*
 *	Folger 09/21/09 QA80-14283 GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH
 *	Hong 11/30/09 QA80-14738 ADD_COVARIANCE_CORRELATION_MATRIX_INFO_TO_NLFIT_RES_LT_TREE
 *	YuI 12/14/09 QA70-13806 VIRTUAL_MATRIX_IMPLEMENTATION						*
 *	Kyle 12/29/2009 QA80-14832 QUICKFIT_OC_DETECT_IF_PLOT_VALID_FOR_ANALYSIS	*
 *	Sophy 1/7/2010 ROI_QUICK_FIT_BUTTON_TO_SUPPORT_CHANGE_FIT_FUNCTION			*
 *	Folger 01/19/10 QA81-14980-S2 GET_ANALYSIS_THEME_SHOULD_NOT_INCLUDE_SYSTEM_BY_DEFAULT
 *	Folger 10/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI					*
 *	Folger 01/25/10 QA81-15036 SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER		*
 *	Sophy 1/27/2010 TREE_TO_STR_SUPPORT_SPECIFY_SEPARATOR_FOR_NAME_AND_VALUE	*
 *	Hong 01/28/10 QA80-14995-P2 FIX_OUTPUT_TO_WKS_FAIL_ALL_PUT_TO_ONE_SHEET_IF_NOT_VALID_SHORT_NAME
 *	Hong 02/02/10 QA80-14801 FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION*
 *	Kyle 02/26/2010 QA80-15138 KEEP_MENU_TAG_FOR_HIDE_BUILT_IN_MENU_LIST_TO_INDICATE_THE_POPUP_INDICES_IN_OMC
 *	Folger 04/13/10 QA81-15309 OC_POST_ORIGIN_MESSAGE_SUPPORT					*
 *	TD ML 04-13-2010 QA85-15312 ICON_OVERLAYS_IN_GRIDCONTROL					*
 *	Folger 04/27/10 QA81-15361 PROPER_TRIMMING_AMPERSAND_FOR_XF_VAR_COMBO_THAT_MAKES_MENU_ITEMS
 *	Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *	Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
 *	Sophy 9/21/2010 ORG-441 FAST_DECODE_BASE64_STRING_INTO_NUMERIC_ARRAY_FOR_MZXML_FILE
 *	Kyle 10/18/2010 ORG-1253-S1 REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN
 *	Folger 10/22/2010 ORG-1316-P1 REPORT_GENERATED_BY_NLEND_FAILED_TO_DISPLAY_CORRECT_USED_DEFINED_FUNCTION_NAME
 *	Sophy 10/25/2010 ORG-1296 MOVE_BUILDDBTREE_TO_VC_FOR_SPEEDUP_NEW_DATABASEIMPORT_DLG
 *	Kit 11/15/2010 ORG-1488-S1 MAKE_TIME_FORMAT_SIMILAR_TO_DATE_FORMAT			*
 *	Kyle 12/08/2010 ORG-1685 CONVERT_BETWEEN_TREENODE_AND_INI_STRING			*
 *	Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING		*
 *	Sophy 1/4/2011 ORG-1841-S8 COPY_TO_CLIPBOARD_NEED_PASS_MULTIPLE_PLOTS_DATA_POINTS_AS_VECTOR_ARRAY
 *	EJP 2011-01-04 ORG-1902 INIT_PKG_MGR_FROM_INSTALLED_PKG						*
 *	Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT	*
 *	Folger 01/24/2011 ORG-2026 SUPPORT_GROUPING_COLUMN_SOURCE_THAT_LESS_THAN_THRESHOLD
 *	Sophy 3/16/2011 ORG-2378-S1 EXPOSE_SHOW_I_TO_OC_FOR_SLOW_IMPORT				*
 *	Folger 03/28/2011 ORG-2442-P1 AUTO_INSTALL_NOT_WORK_FOR_OPK_FILE			*
 *	Folger 04/06/2011 ORG-2581-S1 UNSTACK_COLUMN_SUPPORT_PUT_GROUP_INFO_INTO_CUSTOM_LABELS
 *	Sophy 4/19/2011 ORG-2650-P1 SMART_SKIP_COPY_SEQUENCER_FOR_HIGH_VERSION_MATHEMATICA
 *	Folger 05/20/2011 ORG-2786-P1 FIND_X_FROM_Y_TOO_SLOW_IN_QUICKFIT_IF_MANY_PTS_FOR_FITX
 *	Bill 06/09/2011 ORG-260-S1 NEED_FUNCTION_TO_CONVERT_UNIT					*
 *	Kenny 07/06/2011 ORG-3120-P1 NEW_O3DGL_SURFACE_PLOT_GUI_ACCESS				*
 *	Folger 07/19/2011 SUPPORT_LOAD_DLL_WITH_VERSION_FROM_OC						*
 *	Kit 08/08/2011 ORG-3395-S1 REORGANIZE_FILE_IMPORT_MENU						*
 *	Folger 08/12/2011 ORG-3510-S1 DERIVED_PARAM_ERROR_LT_ACCESS					*
 *	Kenny 08/15/2011 ORG-3535-P1 FIND_AND_REPLACE_DIALOG_FLICKERING_WHEN_RESIZE	*
 *	Kit 08/08/2011 ORG-3395-S1 REORGANIZE_FILE_IMPORT_MENU						*
 *	Bill 09/07/2011 ORG-3395 CUSTOMIZE_IMPORT_MENU_DIALOG						*
 *	Folger 10/17/2011 ORG-4107-P1 PROPER_MENU_ITEM_ACCELERATOR_LOCALIZED		*
 *	Kit 10/31/2011 ORG-4063	SUPPORT_OC_REGULAR_EXPRESSION						*
 *	Folger 11/25/2011 ORG-4458-P1 LT_LOCAL_FUNCTION_FAILED_TO_RETURN_PARTIAL_RANGE
 *	Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT						*
 *	Folger 12/16/2011 ORG-3035-P1 AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA		*
 *	Folger 12/21/2011 ORG-4508 MOVE_TIME_CONSUMING_OC_FUNCTION_TO_VC			*
 *	Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC		*
 *	Folger 02/06/2012 ORG-4218-P1 SHARE_GET_DATASET_LIST_LOGIC_TO_OC			*
 *	Sophy 2/24/2012 ORG-5153 PLOTSETUP_REPLACE_NEED_CHECK_KEEP_ROW_RANGE		*
 *	Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
 *	Folger 06/27/2012 ORG-6044-P1 FAILED_TO_USE_SHORT_NAME_FIRST_IN_COLL_FUNCTION_IN_RANGE_NOTATION
 *	Folger 06/27/2012 ORG-6079-S1 ALLOW_MULTIPLE_SAMPLE_OPJS_OPEN_FROM_FILE_MENU*
 *	Sophy 7/19/2012 ORG-6260-S1 MORE_CHECKING_ON_SCAN_USER_DEFINED_FUNCTION_FOR_SCV_MENU
 *	Folger 07/31/2012 ORG-6330-S4 FIND_FILES_FROM_EXT_RECURSIVE_SUPPORT			*
 *	TD CP 08-02-2012 ORG-6022-S1 WAIT_FOR_PAINT_MESSAGE							*
 *	Sophy 9/3/2012 ORG-5935-P2 DISABLE_UNSUPPORTED_CONTEXTMENU_ITEM_ON_OGL_LAYER*
 *	TD CP ML 09/06/2012 ORG-2753 TRANSLUCENT_DHTML_MESSAGE_CONTROL				*
 *	Folger 09/24/2012 ORG-6255-P6 NOT_ALLOW_WKS_MENU_IF_GUI_DISABLED			*
 *------------------------------------------------------------------------------*/

#ifndef _STRING_UTILS_H_
#define _STRING_UTILS_H_

#ifdef __AFX_H__
	#ifndef OKUTIL_AS_EXTDLL
		#pragma message("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$we are NOT in okutil, but some other DLL")
	#else
		#pragma message("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$we are in okutil")
	#endif

	#define OC_API			OKUTIL_EXPORT_IMPORT

	/*
	#define	string			CString
	#define	StringArray		CScriptMocaObject
	/// ML 5/3/2005 QA70-7686 X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION
	#define	IntArray		CScriptMocaObject
	/// end X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION
	/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
	#define TreeNode		OCXmlWrapperBase
	/// end XFUNCTION_TREE_MANIPULATION_IN_VC
	/// TD 9-12-05 QA70-7403 CODEBUILDER_XFN_INTERACTION_TO_VC
	#define	PointArray		CScriptMocaObject
	/// end CODEBUILDER_XFN_INTERACTION_TO_VC

	#define DoubleArray		CScriptMocaObject
	*/
	#include "OCtoVC.h"

//CPY 10/26/05 SEPARATE_OUT_CONST_INTO_OC_SYS_H
//	#define _LOCALIZED(x)	(x)
	extern "C" {
		#pragma message("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$extern C in outils.h")

		/// Kenny 04/12/2012 SUPPRESS_COMPILER_UNNECESSARY_WARNINGS
		// This fill produce the following warning:
		// (level 1) 'identifier1' has C-linkage specified, but returns UDT 'identifier2' which is incompatible with C
		// According to MSDN (Compiler Warning (level 1) C4190 http://msdn.microsoft.com/en-us/library/1e02627y(v=vs.100).aspx),
		// This is can be considered as legal since all calls to these function occur from C++ and the definition of these function is in C++.
		#pragma warning(push)
		#pragma warning(disable : 4190)
		/// End SUPPRESS_COMPILER_UNNECESSARY_WARNINGS
#else
	#define OC_API
	/// TD 9-12-05 QA70-7403 CODEBUILDER_XFN_INTERACTION_TO_VC
	#define	PointArray		vector<point>
	/// end CODEBUILDER_XFN_INTERACTION_TO_VC
	/// ML 5/3/2005 QA70-7686 X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION
	#define	IntArray	vector<int>
	/// end X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION
	/// AW 01/31/07 QA80-9322 GET_VECTOR_STRING_ADD_IN_VECTOR_DWORD
	#define	UIntArray	vector<UINT>
	#define OUIPArray	vector<OUIP>/// TD ML 11-09-2010 NEW_TYPES
	/// END GET_VECTOR_STRING_ADD_IN_VECTOR_DWORD

	#define DoubleArray vector<double>
	///Sophy 1/4/2011 ORG-1841-S8 COPY_TO_CLIPBOARD_NEED_PASS_MULTIPLE_PLOTS_DATA_POINTS_AS_VECTOR_ARRAY
	#define VectorArray			Array<vector&>
	////end COPY_TO_CLIPBOARD_NEED_PASS_MULTIPLE_PLOTS_DATA_POINTS_AS_VECTOR_ARRAY

//CPY 10/26/05 SEPARATE_OUT_CONST_INTO_OC_SYS_H
//	#define _LOCALIZED(x)	_L(x)
	#pragma dll(okUtil80)	// Associate all functions below to okUtil80.dll which must be in the Origin EXE folder
#endif	//__AFX_H__

#define DEF_TABSIZE			3

enum
{
	STC_EXPAND_TABS		= 0x00000001,
	STC_UNEXPAND_TABS	= 0x00000002,
	STC_NL_TO_CRNL		= 0x00000004,
	STC_CRNL_TO_NL		= 0x00000008,
	STC_PREPEND_TAB		= 0x00000010,
	STC_PREPEND_UNTAB   = 0x00000020,
};




OC_API string okutil_code_to_edit(LPCSTR lpcszStr, DWORD dwOptions = 0L, int nTabSize = DEF_TABSIZE);
OC_API string okutil_merge_dataranges(StringArray * pArray);
	


///DSC 2/23/06 8.50369 QA70-8462 ADD_ORIGIN_PATH_CUSTOM
// Comments last updated by Army 07/27/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_set_custom_path_(global_function)
*/
OC_API string okutil_set_custom_path(LPCSTR lpcszNew=NULL, bool bDoUpdate=true);

// Comments last updated by Army 07/27/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_get_custom_path_(global_function)
*/
OC_API string okutil_get_custom_path(bool bDoUpdate=false);
///end ADD_ORIGIN_PATH_CUSTOM

/// DSC 829/07 QA70-6477 FIND_ORIGIN_PATHS_FROM_REGISTRY
//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_get_serial_number_language_(global_function)
*/
OC_API BOOL okutil_get_serial_number_language(string* pstrLanguage=NULL, string* pstrLangAbbreiviation=NULL);
///end FIND_ORIGIN_PATHS_FROM_REGISTRY

///DSC 10/23/07 QA70-10544 8.0732 ALLOW_SUBSTTUTE_ORIGIN_REGISTRY_KEY_FOR_TECH_SUPPORT
//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_make_origin_registry_key_(global_function)
*/
OC_API BOOL  okutil_make_origin_registry_key(string* pstrKey, LPCSTR lpszAppTitle, LPCSTR lpcszSubVersionName=NULL, LPCSTR lpcszSpecialChar=NULL, BOOL bAppendLang=TRUE, LPCSTR lpcszLanguage=NULL);
///end ALLOW_SUBSTTUTE_ORIGIN_REGISTRY_KEY_FOR_TECH_SUPPORT


/// DSC 829/07 QA70-6477 FIND_ORIGIN_PATHS_FROM_REGISTRY
//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_find_path_from_origin_registry_key_(global_function)
*/
OC_API BOOL okutil_find_path_from_origin_registry_key(string* pstrPath, LPCTSTR lpszPathKey, LPCSTR lpszAppTitle, LPCSTR lpcszSubVersionName=NULL, LPCSTR lpcszSpecialChar=NULL, LPCSTR lpcszLanguage=NULL);
/// end FIND_ORIGIN_PATHS_FROM_REGISTRY


//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_get_origin_path_(global_function)
*/
OC_API string okutil_get_origin_path(int nPathType, LPCSTR lpcszSubPath=NULL, BOOL bCheckExistAndDiffFromUserPath = FALSE);

//Comments last updated by Iris 7/28/2008, added $
/**$
		Extract path  and category and return name.
		Opposite of okutil_composite_name_from_components()
	Paramaters:
		lpcszPathCatName = [input] a string with path and optional category info like "System: Sine", "User: (Fitting) My LR Fit"
		pnPathType =[output] If not NULL, will receive the path type from the enum ORIGIN_PATH_TYPE
		pstrCategory = [output] if not NULL, will receive the category string if present, without parentheses.
	Example1:
		void okutil_str_extract_path_type_ex1()
		{	
			string strPathCatName = User: (Fitting) My LR Fit";
			string strName, strCat;
			int nType;
			strName = okutil_str_extract_path_type( strPathCatName, &nType, &strCat);
			// strCat will be "Fitting", not "(Fitting)"
			// nType will be ORIGIN_PATH_USER
			// strName will be "My LR Fit"
		}
	Return:
		Return the name of the function without prefix or category
*/
// OC_API string okutil_str_extract_path_type(LPCSTR lpcszPathCatName, int* pnPathType=NULL, LPSTR lpszCategory=NULL, int nSize = 0); //= NULL = NULL = 0
//OC_API string okutil_str_extract_path_type(LPCSTR lpcszPathCatName, int* pnPathType=NULL, string* pstrCategory = NULL); //= NULL = NULL = 0
/// DSC 3/17/06 ADD_DESCRIPTION_TO_FF_LIST
// OC_API string okutil_separate_composite_name(LPCSTR lpcszCompositeName, int* pnPathType=NULL, string* pstrCategory = NULL, int nDefaultPath = ORIGIN_PATH_SYSTEM); //= NULL = NULL = 0
OC_API string okutil_separate_composite_name(LPCSTR lpcszCompositeName, int* pnPathType=NULL, string* pstrCategory = NULL, int nDefaultPath = ORIGIN_PATH_SYSTEM, string* pstrDescription=NULL);
/// DSC 3/17/06 ADD_DESCRIPTION_TO_FF_LIST
//OC_API string okutil_str_extract_path_type(LPCSTR lpcszPathCatName, int* pnPathType=NULL, LPSTR lpszCategory=NULL, int nSize = 0); //= NULL = NULL = 0


//Comments last updated by Iris 7/28/2008, added $
/**$
		Get the path keyword name "System", "Group", "User" with possible suffix like a colon if desired.
	Paramaters:
		nPathType = [input] a path type from enum ORIGIN_PATH_TYPE
		bPad=[input] whether to pad with parenthesis or not
	Example1:
		void okutil_get_origin_path_keyword_ex1()
		{	
			string strPathKeyWord;
			strPathKeyWord = okutil_get_origin_path_keyword( ORIGIN_PATH_USER, true);
			// now strPathKeyWord is "(User) "
		}
	Return:
		Return string representing the origin folder type, with optional padding.
*/
///DSC 8/5/05 MORE_NEW_COMPOSITE_NAME_FORMAT
// OC_API string okutil_get_origin_path_keyword(int nPathType, LPCSTR lpcszPad = NULL);
OC_API string okutil_get_origin_path_keyword(int nPathType, bool bPad=false);
///end MORE_NEW_COMPOSITE_NAME_FORMAT


OC_API string okutil_theme_get_sub_special_folder(int nThemeType);
OC_API string okutil_theme_get_path(int nPathType = ORIGIN_PATH_USER, int thtype = THTYPE_GRAPH, bool bCheckUnique = false);
OC_API string okutil_theme_get_system_theme_ini_keyname(int nThemeType, string* pstrDefault=NULL);
OC_API string okutil_theme_get_system_theme(int nThemeType);

OC_API string okutil_theme_get_file_extension(int nThemeType);

//Comments last updated by Iris 7/28/2008, added $
/**$
	Gets the full filepath to a theme given the simple name, path type, and theme type
	Parameters:
		lpcszThemeName =[input] the theme's simple name
		thtype = [input]  the theme type from the THEMETYPE enumeration
		nPathType = [input]  the path type from the ORIGIN_PATH_TYPE enumeration
	Rreturn:
		Returns the full file path to the specified theme
*/
OC_API string okutil_theme_get_theme_file_name(LPCSTR lpcszThemeName, int thtype = THTYPE_GRAPH, int nPathType = ORIGIN_PATH_USER);

//Comments last updated by Iris 7/28/2008, added $
/**$
	Gets the theme name from full filepath theme file name
	Parameters:
		lpcszThemeFileName =[input] the theme file name
		pstrCategory = [output] optionally to retrive the category
	Rreturn:
		Returns the theme's simple name, empty string if lpcszThemeFileName is not a valid theme file name
*/
OC_API string okutil_theme_get_theme_name(LPCSTR lpcszThemeFileName, string* pstrCategory = NULL);

//Comments last updated by Iris 7/28/2008, added $
/**$
	Gets the full filepath to the system theme for a given theme type
	Parameters:
		nThemeType =[input] the theme type from the THEMETYPE enumeration
	Rreturn:
		Returns the full file path to the system theme
*/
OC_API string okutil_theme_get_system_theme_file_name(int nThemeType = THTYPE_GRAPH);
///end MOVE_OC_THEME_FUNCTIONS_TO_VC

//string okutil_theme_file_to_display_name(const string& strThemeFile, string* pstrCategory = NULL, int* pnPathType = NULL);
OC_API string okutil_theme_file_to_display_name(LPCSTR lpcszThemeFile, string* pstrCategory = NULL, int* pnPathType = NULL);

/// TD 4-12-06 VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
OC_API void	okutil_theme_update_last_used(LPCSTR lpcszClassName, TreeNode* tr);
OC_API void okutil_theme_set_registry_settings(LPCSTR lpcszClassName, LPCSTR lpcszKey, LPCSTR lpcszVal);
OC_API bool okutil_theme_save_settings(TreeNode *tr, LPCSTR lpcszFilename = NULL, bool bCheckCreatePath = true);
OC_API string okutil_theme_get_commment_to_gui_tree(TreeNode *tr);
OC_API bool	okutil_theme_get_class_option(TreeNode *tr, string *pstrClassOption);
/// end VC_FUNCTIONS_TO_LAUNCH_XFN_GETN


/// TD 5-8-07 GETNTREE_THEME_APPLICATION_WITH_RANGES
/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
//OC_API int	okutil_getn_update_ranges(TreeNode* tr);
OC_API int	okutil_getn_update_ranges(TreeNode* tr, BOOL bUpdateRowRange = false, IntArray* pvnIDs = NULL, StringArray* pvsValues = NULL);
/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
/// end GETNTREE_THEME_APPLICATION_WITH_RANGES

///// -- AW 04/11/07 QA80-9609 v8.0598 MORE_ON_CHANGE_COL_IN_IMPWIZ	
//Comments last updated by Iris 7/28/2008, added $
/**$
	use one char to express the both format and datatype of column
	ch must be upcase.
*/
OC_API BOOL	okutil_coltype_to_char(int nFormat, int nDatatype, char &chRet);
OC_API BOOL	okutil_char_to_coltype(char ch, int& nFormat, int& nDatatype);
///// END MORE_ON_CHANGE_COL_IN_IMPWIZ	

//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_composite_name_from_file_path_(global_function)
*/
OC_API string okutil_composite_name_from_file_path(LPCSTR lpcszFullFilePath, LPCSTR lpcszSubPath = NULL);


///DSC 6/27/05	CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME
OC_API  string okutil_theme_get_settings_file(LPCSTR lpcszThemeDisplayName, LPCSTR lpcszClassName_Option__TableID, int nThemeType=THTYPE_ANALYSIS, string* pstrThemeName=NULL, int* pnScope=NULL, LPCSTR lpcszCategory=NULL);// int* pnTableID=NULL);// =THTYPE_ANALYSIS, =NULL, =NULL, =NULL, =NULL

//OC_API  string okutil_theme_file_from_display_name(LPCSTR lpcszThemeDisplayName, int nThemeType, /* int nPathType, */ /* int nScope, */ 
//											LPCSTR lpcszClassNameWithOption=NULL, /* LPCSTR lpcszCategory, */ int* pnTableID=NULL);

///DSC 7/7/05	CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME
// OC_API int okutil_theme_separate_class_option(LPCSTR lpcszClassOption, string* pstrClassName);
OC_API int okutil_theme_separate_class_option(LPCSTR lpcszClassOption, string* pstrClassName, string* pstrTableID=NULL);
///end	CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME

OC_API int okutil_theme_extract_scope_from_display_name(string& strDisplayName, string* pstrScope = NULL, int* pPathType = NULL);
///end 	CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME


/// YuI 06/06/08 QA70-8966 XF_DRAG_AND_DROP_PROBLEM
OC_API BOOL okutil_get_category_from_pathname(LPCSTR lpcszPathName, string* pstrCategory, int nFileSupportType);
/// end XF_DRAG_AND_DROP_PROBLEM

///DSC 6/28/05 QA70-7841 CLASS_PATH_IN_REGISTRY
OC_API BOOL okutil_get_class_path(LPCSTR lpcszClassName, string* pstrPath = NULL);	
OC_API int okutil_set_class_path(LPCSTR lpcszClassName, LPCSTR lpcszPath);
///end CLASS_PATH_IN_REGISTRY

typedef enum {
	SUPPORTFILE_UNDEF		= 0,
   	SUPPORTFILE_FDF         = 1,  // fitting functions (.FDF)
   	SUPPORTFILE_XF                // X-Functions (.OXF)
} SUPPORTFILE;
#define SUPPORTFILE_START	SUPPORTFILE_FDF
#define SUPPORTFILE_END		SUPPORTFILE_XF

/// ML 7/18/2005 FIND_FILE_RETURN_VALUE
struct FINDFILEMOREINFO
{
	int		nReturnType;
};
/// end FIND_FILE_RETURN_VALUE
#define FF_CATEGORY_FIRST		0x0001
#define FF_CATEGORY_LAST		0x0002
//Comments last updated by Iris 7/28/2008, added $
/**$
	Finds a full pathname of a file. A cashed map is used to speed the search. To update the map, call okutil_find_files_from_map with FF_UPDATE_MAP.
	The User folder is searched first, followed by the group folder, then by the System folder.
	Example1:
		void okutil_find_file_ex1()
		{
			string strFullPath;
			string strSimpleFileName = "Interpolate"; //no extension
			string strCategory;
			DWORD dwUsgCtxts[4] = {IDXF_USGCTXT_WKS_SEL_CHANGE , IDXF_USGCTXT_WKS_SEL_TRACKING, IDXF_USGCTXT_LABTALK, IDXF_USGCTXT_GO};
			int numOfTpes = 4;
			okutil_find_file_from_map(&strFullPath, SUPPORTFILE_XF, ORIGIN_PATH_UNDEF, strSimpleFileName, &strCategory, dwUsgCtxts, numOfTpes);

		}
	Parameters:
		pstrFullpath	=[output] fullpath filename if success, or the empty string if not.
		nFileType		=[input] the file type, from the SUPPORTFILE enumeration.
		nGenLocation	=[input] general location, from the ORIGIN_PATH_TYPE enumeration, ORIGIN_PATH_UNDEF will indicate seaching for all the locations
		lpcszName		=[input] the simple name (no extension) and case insensitive. 
		pstrCategory	=[input/output] the category for the file you want to find, If pstrCategory points to empty string, then it receives the category for the file, or if the file is associated with more than one category, a coma separated list of all categories that contain a file named lpcszName.
						If a list is received, pstrFullpath contains the path associated with the first category in the list.
						If nFileType is SUPPORTFILE_FDF, the same fdf file can be associated with different categories, so it is not necessary to supply the category when calling this function to get the fdf file path.
						If nFileType is SUPPORTFILE_XF, since X-functions in different categories may have the same name, you must either supply the category, or use FF_CATEGORY_FIRST, FF_CATEGORY_LAST in the argument pdwUsgCtxts, or call okutil_find_file_from_map a second time with a category from the list of categories received from the first call..
		pdwUsgCtxts		=[input] DWORD array, containing context types from IDXF_USGCTXT_BEGIN to IDXF_USGCTXT_END, IDXF_USGCTXT_WKS_SEL and IDXF_USGCTXT_GO. Ignored if nFileType not SUPPORTFILE_XF. Can be NULL. The file found must match at least one one of the supplied context.
		numOfTpes 		=[input] size of the array pdwUsgCtxts. 
		dwCatCtrl		=[input] DWORD value used to control what pstrFullpath and pstrCategory receive in the case where no category is input, and more than one category exists for a file. Can be 0x0 (the default), FF_CATEGORY_FIRST or FF_CATEGORY_LAST. 
						If 0x0, then pstrCategory receives a list of categories, and pstrFullpath receives the path associated with first category in the list.
						If FF_CATEGORY_FIRST, then pstrCategory receives the first category in the list, and pstrFullpath receives the path associated with the first category.
						If FF_CATEGORY_LAST, then pstrCategory receives the last category in the list, and pstrFullpath receives the path associated with the last category.
						If there is only one category, or if the category name is supplied, this variable is ignored.
		pstMoreInfo		=[output,optional] optionally receives additional information about the found function.

	Returns:
       ORIGIN_PATH_UNDEF if not found, otherwise return the actual path type id from the ORIGIN_PATH_TYPE enumeration where the file is found.
*/
/// DSC 1/24/06 QA70-7635 NEW_NAME_OKUTIL_FIND_FILES_FROM_MAP
// OC_API int    okutil_find_file(string* pstrFullpath, int nFileType, int nGenLocation = ORIGIN_PATH_UNDEF, LPCSTR lpcszName = NULL, string *pstrCategory = NULL, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, DWORD dwCatCtrl = 0x0, FINDFILEMOREINFO *pstMoreInfo = NULL);
OC_API int    okutil_find_file_from_map(string* pstrFullpath, int nFileType, int nGenLocation = ORIGIN_PATH_UNDEF, LPCSTR lpcszName = NULL, string *pstrCategory = NULL, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, DWORD dwCatCtrl = 0x0, FINDFILEMOREINFO *pstMoreInfo = NULL);
/// end NEW_NAME_OKUTIL_FIND_FILES_FROM_MAP


/// DSC 7/6/05 QA70-7869 MENU_THEME
#define   GFL_GET_FIRST_ONLY		0x01
#define   GFL_PREFER_SYSTEM		0x02
#define   GFL_REMOVE_PATH 	  0x4	///just get filename+ext DSC 1/31/06 QA70-7635 CENTRALIZE_FIND_FILES_CODES
/// OC_API int okutil_get_file_list(StringArray* pcsaFilePaths, StringArray* pcsaDisplayNames, int nPathType, int nThemeType, DWORD dwCtrl=GFL_GET_FIRST_ONLY, LPCSTR lpcszNamePlusExt=NULL);
OC_API int okutil_get_theme_file_list(StringArray* pcsaFilePaths, StringArray* pcsaDisplayNames, int nPathType, int nThemeType, DWORD dwCtrl=GFL_GET_FIRST_ONLY, LPCSTR lpcszNamePlusExt=NULL);
OC_API int okutil_find_theme_file(string* pstrFullpath, int nPathType, int nThemeType, LPCSTR lpcszNamePlusExt, DWORD dwCtrl=0x0);




/// ML 5/3/2005 QA70-7686 X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION
/**#
*/
OC_API	BOOL	okutil_find_file_by_id(int nId, string *pstrFullpath = NULL, string *pstrName = NULL);
/// end X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION

//--------- CPY 6-23-05 QA70-7834 LOAD_DEPENDS_ON_XFCALLS
/**#
*/
OC_API	BOOL	okutil_get_file_info_from_internal_map(LPCSTR kocszFullpath, DWORD* pdwBits);
OC_API	BOOL	okutil_XF_data_from_internal_map(LPCSTR lpszFullpath, BOOL bSet, int* lpnVal);
//---------

/// TD ML 08-27-2009 QA80-13732 CONTEXT_SENSITIVE_CONTEXT_DRIVEN_XFUNCTIONS
/**#
*/
OC_API	BOOL	okutil_XF_get_context(string *pstrContextString);
/// end CONTEXT_SENSITIVE_CONTEXT_DRIVEN_XFUNCTIONS

///DSC 3/24/05 CHECK_NEW_FILE
// Comments last updated by Iris on 07/28/2008
/**#
		find the file and compare its last modified time with given system time		
   Parameters:
		lpcszName		=[input] the simple name,
		lpftCheckTime	= [input/output]	time to compare with file modified time, if the file found is newer, this is updated. If NULL, then file time is returned.
		nFileType		=[input]the file type, from the SUPPORTFILE enumeration.
		pstrFullpath	=[output] If not NULL, then it will receive the full file path found by the function. 
		nGenLocation	=[input]general location, from the ORIGIN_PATH_TYPE enumeration, ORIGIN_PATH_UNDEF will indicate seaching for all the locations
   Returns:
       1 if file found and its last modified time is greater than lpftCheckTime
	   0 if file found, but its last modified time is not greater than lpftCheckTime
	   -1 if file not found
*/
OC_API int	okutil_check_new_file(LPCSTR lpcszName, FILETIME* lpftCheckTime, int nFileType, string* pstrFullpath = NULL, int nGenLocation = ORIGIN_PATH_UNDEF);
///CHECK_NEW_FILE

// Comments last updated by Iris on 07/28/2008
/**$
	Get all files of a given type, or set map dirty. 
	The files found are read from a cashed list called a map for speed. If the map is "dirty", it is updated before it is read.
	To set the map dirty, call this function with control option FF_UPDATE_MAP.
	Example1:
		void okutil_find_files_ex1()
		{	
			// to update the map for file type SUPPORTFILE_XF, 
			// call with FF_UPDATE_MAP set. This will mark the map as dirty.
			int nNumFound = okutil_find_files_from_map(NULL, NULL, SUPPORTFILE_XF, FF_UPDATE_MAP);
			ASSERT(0==nNumFound);
			
			// To receive saNames, or saFiles, or both, do not set FF_UPDATE_MAP.
			// If the map is dirty, it will first be updated. Then the updated map is read to fill saNames, saFiles.
			vector<string> saNames, saFiles;
			nNumFound = okutil_find_files_from_map(&saNames, &saFiles, SUPPORTFILE_XF);
			
			// Calling again, without first setting the map dirty, will give identical results, even if files on the disk have been added or deleted since the previous call.
			nNumFound = okutil_find_files_from_map(&saNames, &saFiles, SUPPORTFILE_XF);
			
			// Calling with FF_REMOVE_DUPLICATE | FF_USE_C_NAMES
			nNumFound = okutil_find_files_from_map(&saNames, &saFiles, SUPPORTFILE_XF, FF_REMOVE_DUPLICATE | FF_USE_C_NAMES);

			// Calling with FF_CATEGORY_LIST
			nNumFound = okutil_find_files_from_map(&saNames, &saFiles, SUPPORTFILE_XF, FF_CATEGORY_LIST);

		}
				

	Parameters:
		psaNames	=[output]  can be NULL, if not NULL receive composite names "User: (Subfolder) filename", unless FF_USE_C_NAMES is used. Then psaNames receives valid C names.
		psaFiles	=[output]  if not NULL receive fullpath filenames
		nFileType	=[input]   the file type, from the SUPPORTFILE enumeration. excluding SUPPORTFILE_UNDEF.
		dwCntrl		=[input]   Can be 0x0, or you can 'OR' together any of the following:
							FF_UPDATE_MAP			will set map to "dirty", then return 0
							FF_REMOVE_DUPLICATE		will get only 1st file of given name among multiple locations in order User, Group, System
							FF_USE_C_NAMES			will convert all file names into valid C names into psaNames
							FF_CATEGORY_LIST		if a file has more than one category, and FF_USE_C_NAMES not defined, then filenames that differ only by category will be represented by one composite name for each file, with the category being a coma delimited list (User: (cat1, cat2) filename), rather than list a separate composite name for each category. (User: (cat1) filename, User: (cat2) filename). If FF_USE_C_NAMES is defined, then FF_CATEGORY_LIST has no effect.
		pdwUsgCtxts	=[input] DWORD array, containing context types from IDXF_USGCTXT_BEGIN to IDXF_USGCTXT_END. Ignored if nFileType not SUPPORTFILE_XF. Can be NULL.
		numOfTpes 	=[input] size of the array pdwUsgCtxts. 

	Returns: the number of files found. If dwCntrl contains FF_UPDATE_MAP, returns 0;
*/
/* ///DSC 10/11/2005 FIND_FILES_FROM_SPECIFIED_LOCATION moved to oc_const.h
#define FF_UPDATE_MAP			0x0001
#define FF_REMOVE_DUPLICATE		0x0002
#define FF_USE_C_NAMES			0x0004
#define FF_CATEGORY_LIST		0x0008
///DSC 7/7/2005 QA70-7877 COMPOSITE_NAME_DISPLAY_OPTION
//#define FF_SHOW_CATEGORY		0x0 //0x0010
//#define FF_SHOW_PATH		    0x0 //0x0020
#define FF_REMOVE_CATEGORY		0x0010
#define FF_REMOVE_PATH		    0x0020
#define FF_ADD_EXT				0x0040 //CPY 8/23/05 
*/
///end COMPOSITE_NAME_DISPLAY_OPTION

///DSC 1/23/06 QA70-7635 NEW_FILE_TYPE_EXTERNDATA_ODS_OQS
//StringArray* psaNames, LPCSTR lpcszWildNamePlusExtWithDot must be specified
OC_API int okutil_find_files(StringArray* psaNames, LPCSTR lpcszWildNamePlusExtWithDot, LPCSTR lpczsSubFolder="", bool bFirstOnly=false, bool bPreferSystem=false, int nPathType=ORIGIN_PATH_UNDEF, bool bRemovePath=false);
OC_API int okutil_find_file(string* psFile, LPCSTR lpcszFileNamePlusExt, LPCSTR lpczsSubFolder="", bool bPreferSystem=false, int nPathType=ORIGIN_PATH_UNDEF);
///end NEW_FILE_TYPE_EXTERNDATA_ODS_OQS

///DSC 10/18/06 GET_FULL_PATH_FROM_RELATIVE_PATH
OC_API string okutil_make_full_path_from_relative_path(LPCSTR lpcszRelativePath, int nPathType=ORIGIN_PATH_CUSTOM);
///end GET_FULL_PATH_FROM_RELATIVE_PATH


OC_API int okutil_find_subfolders(StringArray* saSubFolders, LPCSTR lpcszRootFolder, int nRecursiveLevel);




/// ML 5/3/2005 QA70-7686 X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION
//OC_API int okutil_find_files(StringArray* psaNames, StringArray* psaFiles, int nFileType, DWORD dwCntrl = 0x0, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0);
///DSC 7/7/2005 QA70-7877 COMPOSITE_NAME_DISPLAY_OPTION
// OC_API int okutil_find_files(StringArray* psaNames, StringArray* psaFiles, int nFileType, DWORD dwCntrl = 0x0, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, IntArray *parrIds = NULL);
//OC_API int okutil_find_files(StringArray* psaNames, StringArray* psaFiles, int nFileType, DWORD dwCntrl = FF_REMOVE_DUPLICATE|FF_SHOW_CATEGORY, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, IntArray *parrIds = NULL);
// CPY 7/9/05, default must add path and category, otherwise not enough info
//OC_API int okutil_find_files(StringArray* psaNames, StringArray* psaFiles, int nFileType, DWORD dwCntrl = FF_REMOVE_DUPLICATE | FF_SHOW_CATEGORY | FF_SHOW_PATH, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, IntArray *parrIds = NULL);
//OC_API int okutil_find_files(StringArray* psaNames, StringArray* psaFiles, int nFileType, DWORD dwCntrl = FF_REMOVE_DUPLICATE, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, IntArray *parrIds = NULL);
///end COMPOSITE_NAME_DISPLAY_OPTION

///DSC 10/11/2005 FIND_FILES_FROM_SPECIFIED_LOCATION
// OC_API int okutil_find_files(StringArray* psaNames, StringArray* psaFiles, int nFileType, DWORD dwCntrl = 0x0, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, IntArray *parrIds = NULL);
/**$
	lists x-functions or fdf files. Can specify usage context and location.
	Parameters:
	psaNames = [out]
	psaFiles = [out]
	nFileType = [in]
	dwCntrl = [in] 
		 FF_UPDATE_MAP			
		 FF_GET_VERSION_INSTEAD_OF_DATE  
		 FF_USE_C_NAMES		
		 FF_CATEGORY_LIST
		 FF_REMOVE_CATEGORY
		 FF_REMOVE_PATH
		 FF_ADD_EXT

	pdwUsgCtxts = [in]
	numOfTpes = [in]
	parrIds = [out]
	parrDoubles = [out]	file dates, or versions if 	FF_GET_VERSION_INSTEAD_OF_DATE & dwCntrl
	nLocation = [in]
		
	Return: 
		the number of files found.

  Example:
	void okutil_find_files_from_map_Ex1()
	{
		string strPath("");
		string strCat("");
		StringArray saCompositeNames;
		StringArray saCNames;
		StringArray saFiles;
		
		vector<double> darr;
		
		DWORD dwType = 0x0;//IDXF_USGCTXT_GO;
		
		string stFullpath;
		okutil_find_files_from_map(&saCompositeNames, &saFiles, SUPPORTFILE_XF, FF_UPDATE_MAP);// refresh list
		int n = okutil_find_files_from_map(&saCompositeNames, &saFiles, SUPPORTFILE_XF, FF_REMOVE_CATEGORY|FF_REMOVE_PATH|FF_GET_VERSION_INSTEAD_OF_DATE, NULL, 0, NULL, &darr, ORIGIN_PATH_UNDEF);
			
		for (int ii = 0; ii < saCompositeNames.GetSize(); ii++)
		{
			
			out_str(saCompositeNames[ii]);
			out_str(saFiles[ii]);
			out_double("Version: ", darr[ii]);
		}
	}

  */

#define COMPOSITE_NAME_DESCRIPTION_SEPARATOR " -- "

///DSC 3/1/06 v8.0371 FF_FILTER_XF_BY_ARGUMENT_INFO
#define XF_VARS_SET_COL_VALUES  0x0001 
#define XF_VARS_WKS_SEL			0x0002
#define XF_VARS_GRAPH_SEL		0x0004
///end FF_FILTER_XF_BY_ARGUMENT_INFO

///DSC 3/1/06 v8.0371 FF_FILTER_XF_BY_ARGUMENT_INFO
/// DSC 1/24/06 QA70-7635 NEW_NAME_OKUTIL_FIND_FILES_FROM_MAP  changed okutil_find_file to okutil_find_files_from_map everywhere, and then create a new function called okutil_find_files
// OC_API int okutil_find_files(StringArray* psaNames, StringArray* psaFiles, int nFileType, DWORD dwCntrl = 0x0, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, IntArray *parrIds = NULL,  DoubleArray* parrDoubles = NULL, int nLocation = ORIGIN_PATH_PREFER_USER);
///	DSC 4/5/06 ADD_FILE_SIZE_TO_MAP
OC_API int okutil_find_files_from_map(StringArray* psaNames, StringArray* psaFiles, int nFileType, DWORD dwCntrl = 0x0, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, IntArray *parrIds = NULL,  DoubleArray* parrDoubles = NULL, int nLocation = ORIGIN_PATH_PREFER_USER, DWORD dwArgCtrl=0x0, IntArray* parrSize=NULL);
///end ADD_FILE_SIZE_TO_MAP
/// end	NEW_NAME_OKUTIL_FIND_FILES_FROM_MAP
///end FIND_FILES_FROM_SPECIFIED_LOCATION
///end FF_FILTER_XF_BY_ARGUMENT_INFO

/// DSC 3/15/06	QA70-7540 FIND_SAME_NAMED_FILES_PER_PATH
//OC_API int okutil_find_same_named_files_from_map(StringArray* psaNames, StringArray* psaFiles, StringArray* psaCategories, int nFileType=SUPPORTFILE_XF, int nLocation=ORIGIN_PATH_UNDEF);
OC_API int okutil_find_same_named_files_from_map();
/// end FIND_SAME_NAMED_FILES_PER_PATH


/// end X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION

///DSC 10/19/06 GET_FILE_TIME_SIZE_FOR_DIR
//Comments last updated by Army 07/27/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_get_file_last_write_time_as_julian_(global_function)
*/
OC_API BOOL okutil_get_file_last_write_time_as_julian(LPCSTR lpcszFile, double* lpdLastWriteTime);
OC_API long okutil_get_file_size_from_name(LPCSTR lpcszFile);
///end GET_FILE_TIME_SIZE_FOR_DIR

///DSC 3/23/06 QA70-8586 CUSTOM_OGS_FILES
//Comments last updated by Iris 08/03/2009, no need put to help since already exist get_date_str in help.
/**$ >Date Time
	Remarks:
		This function is to get date time. 
	Example1: 
		void okutil_date_time_str_from_julian_date_Ex1()
		{
			LPCSTR lpcszFile = GetAppPath(FALSE) + "Filter.ini";
			double pdLastWriteTime;
			int iRet = okutil_get_file_last_write_time_as_julian(lpcszFile, &pdLastWriteTime);
			string str = okutil_date_time_str_from_julian_date(pdLastWriteTime);
			out_str(str);// print out str
		}
    Parameters:
        dJulianDate =[input]the julian date.
    Return:
        date time as a string.
*/
OC_API string okutil_date_time_str_from_julian_date(double dJulianDate);
OC_API int okutil_find_ogs_files_from_map(StringArray* psaOGSNames=NULL, StringArray* psaOGSFiles=NULL);
/// AW 07/12/07 QA80-9962 MORE_ON_OGS_DEBUG
//OC_API BOOL okutil_get_ogs_file_info_from_map(LPCSTR lpcszOGSName, string*  pstrFilePath=NULL, string* pstrFileContent=NULL, string* pstrHelp=NULL, StringArray* psaArgsDef=NULL, StringArray* psaArgsDesc=NULL, long* plSize=NULL, double* pdLastModTime=NULL);
OC_API BOOL okutil_get_ogs_file_info_from_map(LPCSTR lpcszOGSName, string*  pstrFilePath=NULL, string* pstrFileContent=NULL, string* pstrHelp=NULL, StringArray* psaArgsDef=NULL, StringArray* psaArgsDesc=NULL, long* plSize=NULL, double* pdLastModTime=NULL, string* pstrSection=NULL);
/// END MORE_ON_OGS_DEBUG
OC_API BOOL okutil_resolve_str_expression(LPCSTR lpcstr, string* pstrRet, BOOL bRetTrueIfNoChange=true, int* lpErr=NULL);
OC_API BOOL okutil_update_ini(LPCSTR lpcszDestINI, LPCSTR lpcszSrcINI, LPCSTR lpcszSectioName, LPCSTR lpcszKeyName = NULL, BOOL bCheckExisted = FALSE); 
///end CUSTOM_OGS_FILES


///DSC 3/6/06 MAKE_TREE_FROM_MAP
//OKUTIL_EXP_FUNC(int)  okuMakeTreeFromMap(OCXmlWrapperBase *ptr, int nFileType, DWORD dwCntrl = 0UL, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, int nLocation = ORIGIN_PATH_UNDEF, DWORD dwArgCtrl=0x0 );
OC_API int okutil_make_tree_from_map(TreeNode *ptr, int nCmdIdBegin, int nFileType, DWORD dwCntrl = FF_ADD_DESCRIPTION | FF_REMOVE_CATEGORY , DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, int nLocation = ORIGIN_PATH_PREFER_USER, DWORD dwArgCtrl=0x0 );
///end MAKE_TREE_FROM_MAP


///DSC 8/17/05 FAST_XF_LIST_MATCHING_START_STRING
OC_API int okutil_find_xf_files(LPCSTR lpcszStart, StringArray* psaNames, StringArray* psaFiles, DWORD *pdwUsgCtxts = NULL, int numOfTpes = 0, IntArray *parrIds = NULL);
///end FAST_XF_LIST_MATCHING_START_STRING

///	DSC 10/18/05 QA70-8167 CONSTRUCT_XF_FDF_TREE_FOR_UPDATE
OC_API BOOL  okutil_create_file_info_tree(TreeNode *ptrInfo);	
OC_API int okutil_get_XF_file_info(LPCSTR lpcszFile, TreeNode *ptrInfo);
///end CONSTRUCT_XF_FDF_TREE_FOR_UPDATE

///DSC 10/25/05 QA70-8218 REGISTER_COM_SERVER
//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_check_register_COM_server_(global_function)
*/
OC_API int okutil_check_register_COM_server(LPCSTR lpcszFulpathFilename, BOOL bRegister=TRUE);
///end REGISTER_COM_SERVER	



///DSC 9/21/05 QA70-8131 FIND_MATCHING_STRINGS_IN_ARRAY
#define OFS_CASE_SENSITIVE 0x1
#define OFS_WILDCHARS_OFF 0x2		// interprete * and ? as literal characters
#define OFS_MATCH_START_STRING 0x4  // ignored when wild chars are being used.
#define OFS_MATCH_WHOLE_STRING 0x8  // ignored when wild chars are being used.
// Comments last updated by DSC on 09/23/2005
// Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_find_strings_(global_function)
*/
OC_API int okutil_find_strings(StringArray* psaFound, StringArray* psaSearch, LPCSTR lpszFindThis, DWORD dwOptions=OFS_MATCH_WHOLE_STRING);
///end FIND_MATCHING_STRINGS_IN_ARRAY




/// DSC 8/31/05 FIND_GRAPHIC_OBJECT_X_FUNCTIONS
///DSC 10/11/2005 FIND_FILES_FROM_SPECIFIED_LOCATION
// OC_API int okutil_find_graphic_object_xf_files(StringArray *pStrArrNames, StringArray *pStrArrFiles, int nWindowType,  DWORD dwCtrl = FF_REMOVE_DUPLICATE);
OC_API int okutil_find_graphic_object_xf_files(StringArray *pStrArrNames, StringArray *pStrArrFiles, int nWindowType, DWORD dwCtrl=0x0, int nLocation= ORIGIN_PATH_PREFER_USER);
///end FIND_FILES_FROM_SPECIFIED_LOCATION
/// end FIND_GRAPHIC_OBJECT_X_FUNCTIONS

//Comments last updated by Iris 7/28/2008, added $
/**$
		construct composite name from path type, category,  and name.
	Paramaters:
		nPathType = [input] a value from the enum ORIGIN_PATH_TYPE.
		lpcszCategory =[input] a categoty name. Can be empty string. Example: "Fitting"
		lpcszFilename = [input] a filename, no extension. Example: My LR Fit"
	Example1:
		void okutil_composite_name_from_components_ex1()
		{	
			string strName="My LR Fit", strCat="Fitting";
			int nType=ORIGIN_PATH_USER;
			string strCompositeName = okutil_composite_name_from_components( nType, strCat, strName);
			// strCompositeName will be "User: (Fitting) My LR Fit"
		}
	Return:
		Return the display name with path prefix name, optional category and file name
*/
//OC_API string okutil_str_construct_path_category_name(int nPathType, LPCSTR lpcszCategory=NULL, LPCSTR lpcszFilename=NULL);
///DSC 7/7/2005 QA70-7877 COMPOSITE_NAME_DISPLAY_OPTION
//OC_API string okutil_composite_name_from_components(int nPathType, LPCSTR lpcszCategory=NULL, LPCSTR lpcszFilename=NULL);

/// DSC 3/17/06 ADD_DESCRIPTION_TO_FF_LIST
// OC_API string okutil_composite_name_from_components(int nPathType, LPCSTR lpcszCategory=NULL, LPCSTR lpcszFilename=NULL, DWORD dwCtrl=0x0);
OC_API string okutil_composite_name_from_components(int nPathType, LPCSTR lpcszCategory=NULL, LPCSTR lpcszFilename=NULL, DWORD dwCtrl=0x0, LPCSTR lpcszDescription=NULL, string* pstrSortableName=NULL);
/// end ADD_DESCRIPTION_TO_FF_LIST
///end COMPOSITE_NAME_DISPLAY_OPTION





//Comments last updated by Iris 7/28/2008, added $
/**$
	Finds a full pathname from a file composite name.
	Example1:
	   	void run_okutil_find_file_from_composite_name_ex1()
		{
			string strFullPath;
			// this example assumes that the file \X-Functions\Miscellaneous\button.OXF	 exists in your origin System, Group or User folder.
			string strCompositeName = "System: (miscellaneous) Button";	//The parts after the colon is not case sensitive.
			int nFileType = SUPPORTFILE_XF;
			int nType = okutil_find_file_from_composite_name(&strFullPath, strCompositeName, nFileType);
			// If "System: (miscellaneous) Button" exists, the return value is ORIGIN_PATH_SYSTEM, and strFullPath will contain the full path.
			// Otherwise, nType will be ORIGIN_PATH_UNDEF, and strFullPath the empty string.
			
			string strNameAlone = "button";// the first 2 parts of the composite name are optional. Here, just the simple name is supplied.
			nType = okutil_find_file_from_composite_name(&strFullPath, strNameAlone, nFileType);
			// Since only the simple file name and nFileType are provided, the function will search in order User, Group, System and return the first file found with simple name "button" and type SUPPORTFILE_XF. 
			// If not found, will return ORIGIN_PATH_UNDEF, and strFullPath the empty string.
		}
	Parameters:
       pstrFullpath 		=[output] fullpath filename if success. Empty string if not.
       lpcszCompositeName	=[input] the composite name.   
       nFileType			=[input] the file type, from the SUPPORTFILE enumeration.
	   nDefaultPath = [input] when lpcszCompositeName does not contain path info, use this as the default
	Returns:
       ORIGIN_PATH_UNDEF if not found, otherwise return the actual Location from the enum ORIGIN_PATH_TYPE where the file is found
*/
OC_API int    okutil_find_file_from_composite_name(string* pstrFullpath, LPCSTR lpcszCompositeName, int nFileType, int nDefaultPath = ORIGIN_PATH_SYSTEM);

/// AW 12/13/05 QA80-8451 v8.0347 ADD_REAAD_SECTION_IN_OC
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_read_file_section_(global_function)
*/
/// SY 01/05/2006 QA80-8451 v8.0354 OC_READ_WRITE_OGS_LIKE_FILE_SECTION
///	OC_API int okutil_read_file_section(LPCSTR lpcszFilename, LPCSTR lpcszSec, string* pstr);
/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
//OC_API int okutil_read_file_section(LPCSTR lpcszFilename, LPCSTR lpcszSecName, string* pstr, string* pstrComments);
OC_API int okutil_read_file_section(LPCSTR lpcszFilename, LPCSTR lpcszSecName, string* pstr, string* pstrComments, bool bWholeSection = false);
/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_write_file_section_(global_function)
*/
OC_API int okutil_write_file_section(LPCSTR lpcszFilename, LPCSTR lpcszSecName, LPCSTR lpcszText, LPCSTR lpcszComments = NULL, int nCommentStyle = 0);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_get_file_sections_(global_function)
*/
OC_API int okutil_get_file_sections(LPCSTR lpcszFilename, StringArray* pvsSectionNames);

OC_API int okutil_read_file_section_keys(LPCSTR lpcszFilename, LPCSTR lpcszSecName, StringArray* pvsKeys, StringArray* pvsValues, StringArray* pvsComments = NULL);

//pvsKeys = NULL or empty will result in an empty section
OC_API int okutil_write_file_section_keys(LPCSTR lpcszFilename, LPCSTR lpcszSecName, StringArray* pvsKeys, StringArray* pvsValues, StringArray* pvsComments = NULL);
/// end OC_READ_WRITE_OGS_LIKE_FILE_SECTION
/// END ADD_REAAD_SECTION_IN_OC

/// SY 02/01/2006 QA70-8498 v8.0364 TEMPLATE_INFO_INTERNAL_ACCESS
//lpcszTemplateOrganizerTreeFile is the Tree file used in Template Organizer
//pvsCategories = list of categories with \ to separate into sub categories
// nWinType = EXIST_WKS etc
OC_API int okutil_get_template_categories(LPCSTR lpcszTemplateOrganizerTreeFile, StringArray* pvsCategories, int nWinType);

//------ Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
////------ Folger 08/30/07 ADD_PREVIOUS_PATH_TO_MAKE_ADD_TEMPLATE_MORE_FLEXIBLE
////OC_API int okutil_add_template(LPCSTR lpcszTemplateOrganizerTreeFile, LPCSTR lpcszCategory, LPCSTR lpcszTemplateFilename, int nWinType);
//OC_API int okutil_add_template(LPCSTR lpcszTemplateOrganizerTreeFile, LPCSTR lpcszCategory, LPCSTR lpcszTemplateFilename, int nWinType, LPCSTR lpcszPathPrev = NULL);
////------ End ADD_PREVIOUS_PATH_TO_MAKE_ADD_TEMPLATE_MORE_FLEXIBLE
OC_API int okutil_add_template(LPCSTR lpcszTemplateOrganizerTreeFile, LPCSTR lpcszCategory, LPCSTR lpcszTemplateFilename, int nWinType);
//------ End NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
/// end TEMPLATE_INFO_INTERNAL_ACCESS


////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
///DSC 3/9/05 QA70-7479 MOVE_TO_OKUTIL_DLL

//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_make_file_path_(global_function)
*/
//bool okutil_make_file_path(string& strFilePath, int nPathType, LPCSTR lpcszSubFolder, LPCSTR lpcszFileName, LPCSTR lpcszExt = NULL, bool bCheckExist = true);
OC_API bool okutil_make_file_path(string* pstrFilePath, int nPathType, LPCSTR lpcszSubFolder, LPCSTR lpcszFileName, LPCSTR lpcszExt = NULL, bool bCheckExist = true);// make filepath from path, name, etc



//Comments last updated by DSC on 3/30/05
//Category last updated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_get_origin_path_type_(global_function)
*/
OC_API int okutil_get_origin_path_type(LPCSTR lpcszFilePath, BOOL bPreferUser = TRUE);


///DSC 9/13/05 TREE_COUNT_ITEMS_TO_VC
OC_API int okutil_tree_count_items(TreeNode  * ptr, int* lpnSections= NULL);
///end TREE_COUNT_ITEMS_TO_VC

/// YuI 03/01/07 NLSF_INIT_FROM_SELECTION_SHOULD_BE_SMARTER
/// YuI 06/08/07 NLSF_INIT_FROM_SELECTION_SHOULD_BE_SMARTER
//	OC_API void	 okutil_get_fitter_data_node_info(TreeNode* trFitterData, int* pNumIndep, int* pNumDep);
OC_API void	 okutil_get_fitter_data_node_info(TreeNode* trFitterData, int* pNumIndep, int* pNumDep, BOOL bRoot = TRUE);
/// end NLSF_INIT_FROM_SELECTION_SHOULD_BE_SMARTER
/// end NLSF_INIT_FROM_SELECTION_SHOULD_BE_SMARTER

/// YuI 09/15/06 NLSF_INPUT_DATA_EXPANDED_GUI
///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
//OC_API BOOL	okutil_create_fitter_data_node_ex(TreeNode* trFitterData, TreeNode* tr, LPCSTR lpcszName, LPCSTR lpcszLabel, StringArray* pIndep, StringArray* pDep, int nDefaultWeightType, BOOL bInitFromSel = FALSE);
OC_API BOOL	okutil_create_fitter_data_node_ex(TreeNode* trFitterData, TreeNode* tr, LPCSTR lpcszName, LPCSTR lpcszLabel, StringArray* pIndep, StringArray* pDep, int nDefaultWeightType, BOOL bInitFromSel = FALSE, BOOL bSupportXError = FALSE);
///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
///---Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
OC_API BOOL	okutil_create_implicit_fitter_data_node_ex(TreeNode* trFitterData, TreeNode* tr, LPCSTR lpcszName, LPCSTR lpcszLabel, StringArray* pVar, int nDefaultWeightType, BOOL bInitFromSel);
///---END ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
OC_API BOOL	okutil_is_fitter_data_node_ready(TreeNode* trFitterData);
OC_API BOOL	okutil_is_fitter_data_node_modified(TreeNode* trFitterData, TreeNode* trPrevFitterData);
/// end NLSF_INPUT_DATA_EXPANDED_GUI

/// YuI 07/17/07 QA70-10074 FITTER_DATA_COMMON_EIGHT_APPLICATION
OC_API BOOL	okutil_fitter_data_set_common_weight_settings(TreeNode* trFitterData, int nSettings);
/// end FITTER_DATA_COMMON_EIGHT_APPLICATION

/// YuI 03/23/05
#define		AREA_WORKBOOK_NAME_BEGIN_CHAR			'['
#define		AREA_WORKBOOK_NAME_END_CHAR				']'
#define		AREA_SHEETNAME_NAME_END_CHAR			'!'
#define		AREA_INTRA_AREA_SEP_CHAR				':'

/// YuI 09/11/06 HOOKING_UP_AUTOUPDATE_FOR_ORIGIN_OBJECT_XVARS
#define	XSTRING_CELL_BEGIN_CHAR		AREA_WORKBOOK_NAME_BEGIN_CHAR
#define	XSTRING_CELL_END_CHAR		AREA_WORKBOOK_NAME_END_CHAR
#define	XSTRING_RANGE_SEPARATOR		AREA_INTRA_AREA_SEP_CHAR
#define	XSTRING_OBJECT_SEPARATOR	AREA_SHEETNAME_NAME_END_CHAR
/// end HOOKING_UP_AUTOUPDATE_FOR_ORIGIN_OBJECT_XVARS

/// ML 1/13/2006 XVARIABLEBASE_TO_VC
#define		AREA_RANGE_SHEETNAME_NAME_END_CHAR		':'
/// end XVARIABLEBASE_TO_VC
//#define		AREA_ROW_COL_PREFIX_CHAR				'$' //CPY 10/22/05 QA70-8158 no longer use Excel abolute notation
/// end YuI
/**$
*/
OC_API	BOOL	okutil_XVarType_to_XVarTypeName(string *pstrXVarTypeName, int nXVarType);

/**$
*/
OC_API	int		okutil_XVarTypeName_to_XVarType(LPCSTR lpcszXVarTypeName);
/// end NEW_GROBJ_BASED_X_VARIABLE_TYPES

// Comments last updated by DSC on 03/30/2005
//Category last udpated by Iris 7/28/2008, added $, is_in_list already in doc
/**$
		Returns true if the test string is in the list. The match can be partial, and case insensitive, is desired. The search can start from any index.
	Example1:
		void okutil_is_in_list_ex1()
		{
			vector<string> vsList = {"aaa", "bbb", "ccc", "ddd", "D", "eee", "fff"};
			string strFind = "D";
				
			//call with function defaults
			bool bIsInList = okutil_is_in_list( strFind, &vsList);
			//the search starts from 'aaa'. It finds "D" and returns true.
			
			//call again with following arguments
			bool bKeyCaseSensitive = false;
			bool bKeyPartialMatch = true;
			int nFirstIndexFound;
			int nStartOffset = 2;
			bIsInList = okutil_is_in_list( strFind, &vsList,  bKeyCaseSensitive, bKeyPartialMatch,  &nFirstIndexFound, nStartOffset);
			// this search begins with "ccc". It finds "ddd" to be a match since bKeyCaseSensitive = false and bKeyPartialMatch = true.
			// nFirstIndexFound is set to 3, and returns true.
		}

	Parameters:
		lpcszTest=[input] the string to search for.
		psaList=[input]	the list to search for the string lpcszTest.
		bCaseSensitive=[input] if true, the search is case sensitive.
		bKeyPartialMatch=[input] if true, the match can be partial meaning that lpcszTest need only match the first part of the string in the list.
		pnFound=[output] the index in the list of the first match. The index starts at 0.
		nStart=[input] the offset index from which to begin the search in the list.
	Return:
		Returns true if found.

*/
OC_API BOOL okutil_is_in_list(LPCSTR lpcszTest, StringArray* psaList, BOOL bCaseSensitive = false, BOOL bKeyPartialMatch = false, int* pnFound = NULL, int nStart = 0); //false, false, NULL, 0

/**#


*/
OC_API void okutil_make_valid_c_name(string* pstr, char cPrefixIf1stCharNumber=0);

/// Hong 01/28/10 QA80-14995-P2 FIX_OUTPUT_TO_WKS_FAIL_ALL_PUT_TO_ONE_SHEET_IF_NOT_VALID_SHORT_NAME
/**#
*/
OC_API BOOL okutil_make_valid_wksheet_name(string* pstr);
/// end FIX_OUTPUT_TO_WKS_FAIL_ALL_PUT_TO_ONE_SHEET_IF_NOT_VALID_SHORT_NAME

// Comments last updated by DSC on 03/30/2005
//Category last udpated by Iris 7/28/2008
#define GT_TRIM_QUOTES			-1
#define GT_TRIM_BOTH_ENDS		-2
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Okutil_get_tokens_(global_function)
*/
OC_API int  okutil_get_tokens(LPCSTR lpcszSrc, StringArray* psaResult, char cDelimiter, int* lpErr, int nTrimQuotes = '"', unsigned int dwCntrl = 0);



/// SY 08/23/2005 QA70-8040 v8.0293 SWITCHES_PROCESSING_FUNCTION
//Comments last updated by Iris 7/28/2008, added $
/**$
		check swithes and their corresponding values and remove from command line
	Parameters:
		lpcmd = [input] command line to be parsed
		psaSwitches = [input] array of all valid switches, '-' character not included
		lpHasVal = [input] array of char to specify if a switch has a value, must be '0' and '1'
		psaVals = [output] resulting array of the values for each given switch. 
			Empty if a switch is not used, otherwise the value following the switch if lpHasVal == '1'
			or the switch itself if lpHasVal == '0'
		psRemaining = [output] command line after all the switches and their values removed
	Example:
		enum {XFSW_THEME, XFSW_INPUT, XFSW_OUTPUT, XFSW_REDIRECT, XFSW_DIALOG, XFSW_HELP};
		void okutil_parse_command_line_ex1(string strCmd = "-d -out test -theme \"c:\\c\\vc32\\test file.oth\" a:=3 b:=4 -r 0")
		{
			//out_str(str);
			vector<string> vsSwitches = {
				"theme",
				"input",
				"output",
				"redirect",
				// following no need for value
				"dialog",
				"help"
			};
			char szHasVals[] = "111100";
			
			vector<string> vsVals;
			string strRemaining;
			LPSTR pstr = strCmd.GetBuffer(strCmd.GetLength() + 10);
			int nRet = okutil_parse_command_line(pstr, &vsSwitches, szHasVals, &vsVals, &strRemaining);
			strCmd.ReleaseBuffer();
			if(nRet >= 0)
			{
				out_str(strRemaining);
				if(!vsVals[XFSW_THEME].IsEmpty())
					printf("Theme is specified:%s\n", vsVals[XFSW_THEME]);
				if(!vsVals[XFSW_OUTPUT].IsEmpty())
					printf("Output tree is specified:%s\n", vsVals[XFSW_OUTPUT]);
		
			}
		}

	Return:
		number of switches found, or
		-1 = switch not followed by value when it should
		-2 = invalid switch found
		-3 = lpHasVal has value other than '0' and '1'
*/
OC_API int okutil_parse_command_line(LPSTR lpcmd, StringArray* psaSwitches, LPCSTR lpHasVal, StringArray* psaVals, string* psRemaining);
/// end SWITCHES_PROCESSING_FUNCTION

/// YuI 08/26/05 XF_SWITCH_RECOGNITION_CENTRALIZATION
/// YuI 01/17/07 QA70-9285 SILENT_XF_INVOCATION
//	enum	{XFSW_THEME, XFSW_INPUT, XFSW_OUTPUT, XFSW_RECALCULATE, XFSW_DIALOG, XFSW_HELP};
///------ Folger 04/22/09 QA80-10889 SUPPORT_COPY_DATA_FORMAT_AS_NEW_XF_SWITCH
//enum	{XFSW_THEME, XFSW_INPUT, XFSW_OUTPUT, XFSW_RECALCULATE, XFSW_DIALOG, XFSW_HELP, XFSW_SILENT};
enum
{
	XFSW_THEME,
	XFSW_INPUT,
	XFSW_OUTPUT,
	XFSW_RECALCULATE,
	XFSW_DIALOG,
	XFSW_HELP,
	XFSW_SILENT,
	XFSW_COPY,
};
///------ End SUPPORT_COPY_DATA_FORMAT_AS_NEW_XF_SWITCH
/// end SILENT_XF_INVOCATION
OC_API int okutil_parse_XF_command_line(LPSTR lpcmd, StringArray* pPresentSwitches, StringArray* pPresentValues, StringArray* pAbsentSwitches, IntArray* pPresentSwitchesIndices, string* psRemaining);
OC_API int okutil_get_XF_switches(StringArray* pSwitches, IntArray* pArgNumber);
/// end XF_SWITCH_RECOGNITION_CENTRALIZATION

/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
/**$
*/
//OC_API int okutil_xft_construct(TreeNode* ptr, LPCSTR lpcszName, StringArray *psaVarTypes = NULL, bool bIsDisableGUIInterface = false);
OC_API bool okutil_xft_construct(TreeNode* ptr, LPCSTR lpcszName, StringArray *psaVarTypes = NULL, bool bIsDisableGUIInterface = false, bool bSkipHelpNodes = false);


/**$
*/
OC_API	string	okutil_xft_get_x_function_attach_types();

/**$
*/
OC_API	void		okutil_xft_prepareVarBranches(TreeNode *ptrVars);

/**$
*/
OC_API	void		okutil_xft_SetFunctionName(TreeNode *ptrFunction, LPCSTR lpcszName, const int *pnPath=NULL);

/**$
*/
OC_API	string		okutil_xft_GetFunctionNameStr(LPCSTR lpcszName, int nFuncFolder = ORIGIN_PATH_SYSTEM);

/**$
*/
OC_API	string		okutil_fo_GetFuncFileName(const TreeNode *ptrFunction, bool bGetFullpath, int* pType = NULL);

/**$
*/
OC_API	void		okutil_fo_SetFuncFileName(TreeNode *ptrFunction, LPCSTR lpcszFilename, bool bFullPathGiven = true);

/**$
*/
OC_API	void		okutil_xft_SetFuncFileName(TreeNode *ptrFunction, LPCSTR lpcszFilename, bool bFullPathGiven = true, bool bCallFO = true);

/**$
*/
OC_API	void		okutil_xft_SetDisplayIcon(TreeNode *ptr, int nResID = -1);

/**$
*/
OC_API	bool		okutil_fo_IsFunction(TreeNode *ptr);

/**$
*/
/// ML 3/19/2007 UNNECESSARY_EVENT_HANDLER_SETTING
//OC_API	void		okutil_xft_ConstructVarTree(TreeNode *ptrVar, LPCTSTR lpcszVarType = NULL, bool bIsDisableGUIInterface = false, bool bSkipHelpNodes = false);
/// YuI 05/17/07 QA80-9782 XFUNCTION_CREATION_SPEED_IMPROVEMENT
//	OC_API	void		okutil_xft_ConstructVarTree(TreeNode *ptrVar, LPCTSTR lpcszVarType = NULL, bool bIsDisableGUIInterface = false, bool bSkipHelpNodes = false, bool bSetEventHandlers = false);
OC_API	void		okutil_xft_ConstructVarTree(TreeNode *ptrVar, LPCTSTR lpcszVarType = NULL, bool bIsDisableGUIInterface = false);
/// end XFUNCTION_CREATION_SPEED_IMPROVEMENT
/// end UNNECESSARY_EVENT_HANDLER_SETTING

/**$
*/
OC_API	int			okutil_xft_get_X_Function_variable_types(StringArray *pvsTypes);

/**$
*/
OC_API	BOOL		okutil_xft_UpdateVar(TreeNode *ptrVar, bool bIsDisableGUIInterface, bool bFromConstruct = false);

//---- CPY 6/1/2007 DOUBLE_OUTPUT_SHOULD_STILL_USE_STR_NODE_IN_DYNA_CNTRL
// I introduced this bug per CPY 5/24/2007 FOLGER_FOUND_DOUBLE_XVAR_SHOWING_TOO_MANY_NUMERIC_DIGITS
// now I see no need to expose this function to OC
//// ------------AW 04/03/07 QA80-9548 v8.0597 XF_LOCALIZATION
//OC_API BOOL okutil_xft_get_combostr_node(TreeNode *ptrVar, TreeNode* ptrComboStr, int nLang = -1, BOOL bChkEmpty = true);
//// ------------END XF_LOCALIZATION
//----

/**$
*/
//OC_API	bool		okutil_xft_check_update_text_box_var_node(TreeNode *ptrNode, bool bReadOnly = false, LPCSTR lpcszCombo = NULL);

/**$
*/
//OC_API	BOOL		okutil_xft_check_update_interactive_var_node(TreeNode *ptrNode, BOOL bNoDropDownButton);


//OC_API	BOOL		okutil_xft_is_xyz_data_range_node(TreeNode *ptr);

/**$
*/
OC_API	void		okutil_xft_construct_xy_data_range_node(TreeNode *ptr);

/**$
*/
OC_API	void		okutil_xft_construct_xyz_data_range_node(TreeNode *ptr);

/**$
*/
//OC_API	void		okutil_xft_disableVarDataInteractive(TreeNode *ptrVar, bool bRollBack = false);

/**$
*/
OC_API	void		okutil_vars_tree_construct_add_create_data_branch(TreeNode *ptr, DWORD dwOptions, int nBranchID);

/**$
*/
///DSC 2/3/06 CLEANUP_XFT_LOAD
//OC_API	bool		okutil_xft_Load(TreeNode *ptrFunction, LPCSTR lpcszFullpathFilename, LPCSTR lpcszName = NULL, bool bSimpleLoading = false, bool bIsDisableGUIInterface = false, bool bSkipHelpNodes = false);
enum {
XFLOAD_EVENT_HANDLERS			= 0x00001000,	// should be on only for F10 dlg
XFLOAD_SET_NAME_FILE			= 0x00002000,
XFLOAD_SKIP_HELP_NODES			= 0x00010000,	// should be on only for F10 dlg?
XFLOAD_NO_PDS_LOCALIZATION		= 0x00020000,	/// ML 12/11/2007 QA70-10810 LOADING_AND_SAVING_OXF_WITHOUT_LOCALIZING_WHEN_FOR_COMPILATION
XFLOAD_DISABLE_GUI_INTERFACE	= 0x00040000,
// common combinations:
XFLOAD_FOR_RUNNING		= (XFLOAD_SET_NAME_FILE | XFLOAD_DISABLE_GUI_INTERFACE | XFLOAD_SKIP_HELP_NODES),

};
OC_API	bool		okutil_xft_Load(TreeNode *ptrFunction, LPCSTR lpcszFullpathFilename, LPCSTR lpcszName = NULL, DWORD dwOpts=0x0);
///end CLEANUP_XFT_LOAD


/// AW 01/31/07 QA80-9322 GET_VECTOR_STRING_ADD_IN_VECTOR_DWORD
OC_API BOOL okutil_make_pointers_array(OUIPArray* arrPtrs, StringArray* vstr);	/// TD ML 11-09-2010 NEW_TYPES
/// END GET_VECTOR_STRING_ADD_IN_VECTOR_DWORD

/// AW 01/29/07 QA80-9310 v8.0550b AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
OC_API	int	okutil_anova_switch_to_indexed_data(TreeNode* ptrInputData, BOOL bTwoWay, BOOL bRM);
OC_API	int	okutil_anova_switch_to_raw_data(TreeNode* ptrInputData, BOOL bTwoWay, BOOL bRM);
/// ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER
OC_API	BOOL	okutil_anova_input_data_labels_proper_language(TreeNode *ptrInputData, BOOL bTwoWay, BOOL bRM);
/// end INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER
/// TD ML 05-30-2008 QA80-11622 UPDATING_ANOVA_HANDLERS_ON_RECALCULATE_FROM_OPJ
OC_API	void	okutil_anova_update_handlers(TreeNode* ptrInputData, BOOL bOneWay, BOOL bRM);
/// end UPDATING_ANOVA_HANDLERS_ON_RECALCULATE_FROM_OPJ

///------ Folger 12/16/2011 ORG-3035-P1 AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
OC_API	BOOL	okutil_anova_update_level_name_from_data(TreeNode* ptrLevel, TreeNode* ptrData);
///------ End AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA


OC_API	int okutil_remove_repeat_item(StringArray *pvsList, bool bRemoveEmpty = true, bool bCaseSensitive = false);
OC_API bool okutil_insert_str_to_str_list(LPCSTR lpcszInsert, string *pstrList, LPCSTR lpcszBefore = NULL, LPCSTR lpcszDelimiter = NULL); // when last argu is not assigned it will be "|"
//OC_API BOOL okutil_rollback_string_tokens_d(DoubleArray* pvVals, string *pstRet, char chDelimiter = ' ');			///Jasmine 04/20/2012 COMMENT_UNUSED_FUNC_WITH_BUG_%d_TURN_DOUBLE_TO_0
OC_API BOOL okutil_rollback_string_tokens(StringArray& saVals, string *pstrRet, char chDelimiter = ' ');
OC_API BOOL okutil_has_select_factorCol();

/// END AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
/// TD 5-30-07 QA80-9845 EXPOSE_CUSTOM_COLORS_TO_OC
/// TD CP 10-09-2008 QA80-14417_P1 LT_COLOR_INDEX_SHOULD_ONLY_USE_UPTO_LAST_NON_WHITE_CUTOM_COLOR
//OC_API BOOL okutil_get_custom_colors(UIntArray* parrColors, BOOL bCvtToOcolor=false);
OC_API BOOL okutil_get_custom_colors(UIntArray* parrColors, BOOL bCvtToOcolor=false, BOOL bIgnoreWhitesAtEnd = FALSE);
/// end LT_COLOR_INDEX_SHOULD_ONLY_USE_UPTO_LAST_NON_WHITE_CUTOM_COLOR
/// end EXPOSE_CUSTOM_COLORS_TO_OC

/**$
*/
OC_API	BOOL		okutil_xft_GetVarsNode(TreeNode *ptrVars, const TreeNode *ptrFunction, StringArray *pvsTypes = NULL);

/**$
*/
OC_API	bool		okutil_xft_DisableGUIInterface(TreeNode *ptrFunction, bool bRollBack = false);

/// ML 4/28/2005 XFT_GETTING_IO
OC_API	int			okutil_xft_get_var_io(TreeNode *ptrVar);
/// end XFT_GETTING_IO

/// ML 5/9/2005 RETURNING_VALUE_FROM_XFUNCTION
// returns XVT_* (for now only void or int) 
OC_API int			oktutil_xft_get_ret_type(TreeNode* ptrFunction);
/// end RETURNING_VALUE_FROM_XFUNCTION



/// DSC 5/02/2005 8.0230 QA75-7404 CONVERT_CONSEC_SPACES_TO_TAB
#define MIN_REPEAT_SPACES 2
OC_API BOOL okutil_check_convert_spaces_to_tab(LPCSTR lpcszSrc, string* pstrResult, int nMinRepeat = MIN_REPEAT_SPACES);
/// end CONVERT_CONSEC_SPACES_TO_TAB

/// YuI 06/11/09 QA70-13772 FAILED_TO_CREATE_MULTIPLE_NEW_COLUMNS
// ok to go into SR6
OC_API BOOL		okutil_get_composite_range_string(TreeNode* ptrNode, string* pstrRange);
OC_API BOOL		okutil_set_composite_range_string(TreeNode* ptrNode, LPCSTR lpcszRange);
/// end FAILED_TO_CREATE_MULTIPLE_NEW_COLUMNS

///DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
OC_API BOOL		okutil_get_predefined_specifiers(LPCSTR lpcsz, TreeNode* pTree);
OC_API int		okutil_cvt_str_to_predefined_type(LPCSTR lpcsz);
/// ML 10/31/2007 QA70-10630 LOCALIZING_KEYWORDS_FOR_XF_AND_THEMES
OC_API	BOOL	okutil_get_localized_string_from_PDS(string *pstr, int nPDS);
OC_API	BOOL	okutil_get_english_string_from_PDS(string *pstr, int nPDS);		//------ Folger 11/19/07 ALWAYS_GET_ENGLISH_PDS
/// end LOCALIZING_KEYWORDS_FOR_XF_AND_THEMES

OC_API	BOOL	okutil_convert_localized_PDS(string *pstr, bool bLocalized = true);		//------ Folger 11/21/07 TWO_DIRECTION_RPEDEFINED_CONVERSION_IS_NEEDED

// OC_API BOOL		okutil_find_files_from_ext(StringArray* pcsaResult, LPCSTR lpcszPath, LPCSTR lpcszExt=NULL, BOOL bCheckExist= FALSE);
OC_API BOOL		okutil_find_files_from_name_or_ext(StringArray* pcsaResult, LPCSTR lpcszPath, LPCSTR lpcszFileNameOrExt=NULL, BOOL bCheckExist= FALSE
	///------ Folger 07/31/2012 ORG-6330-S4 FIND_FILES_FROM_EXT_RECURSIVE_SUPPORT
	, int nRecurseLevel = 0
	///------ End FIND_FILES_FROM_EXT_RECURSIVE_SUPPORT
	);
OC_API int		okutil_theme_find_class_categories(LPCSTR lpcstrClassName, StringArray* psaCategoryName);
/**$
*/
OC_API string	okutil_get_node_label(TreeNode* ptrn, BOOL bGetLabelFirst = TRUE);

//Comments last updated by Iris 7/28/2008
/**$
	The function okutil_theme_get_class_settings() gets a list of all theme files for a given theme type and class name, 
	from each of the User, Group, and System folders. Both display names and full file paths are listed.
	You can include "last used" and "factory default" if desired. It returns the number of themes found.
	This function is used for example to list all relevant themes when you select menu Analysis | Fit Linear. 
	
	Keywords: 
		theme; THEMETYPE
	Example1:
	void okutil_theme_get_class_settings_ex1()
	{
		vector<string> vsFilenames;
		vector<string> vsList;
		string strClassOption = "FitLinear";  
		int thtype = THTYPE_ANALYSIS; //see THEMETYPE enumeration for other theme types such as THTYPE_WORKSHEET, THTYPE_GRAPH, THTYPE_EVENT_ORGANIZER
		
		int nCount = okutil_theme_get_class_settings(strClassOption, &vsFilenames, &vsList, thtype, true, true);
		
		ASSERT(nCount == vsList.GetSize());
		ASSERT(nCount == vsFilenames.GetSize());
	
		for(int ii=0; ii<vsList.GetSize(); ii++)
		{
			out_str(vsList[ii]);	
		}
		for(ii=0; ii<vsFilenames.GetSize(); ii++)
		{
			out_str(vsFilenames[ii]);	
		}
		//out_tree(testTree);	
	
	}
	Parameters:
		lpcszClassname=[input] the class name, for example  FitLinear, FitPolynomial, FitExpDecay, FFTFilters, Smoothing, etc...
		psaFilenames=[output] array to receive the list of full file names of the themes found.
		psaDisplayNames=[output] array to receive the display names of the themes found.
		thtype=[input] the theme type to list. Default is THTYPE_ANALYSIS. See THEMETYPE enumeration for other theme types such as THTYPE_WORKSHEET, THTYPE_GRAPH, THTYPE_EVENT_ORGANIZER
		bIncludeFactory=[input] set to true to include the Factory default theme in the list. Default is false.
		bIncludeLastUsed=[input] set to true to include the Last Used theme in the list.  Default is false.
		bIncludeCommon=[input] set to true to include the Common themes in the list.  Default is true.
		bIncludeWorkbook=[input] set to true to include the Common themes in the workbook
		bIncludeWorksheet=[input] set to true to include the Common themes in the worksheet
	Return:
		Returns the number of themes found
*/
/// SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
///	OC_API int		okutil_theme_get_class_settings(LPCSTR lpcszClassname, StringArray* psaFilenames, StringArray* psaDisplayNames, int thtype = THTYPE_ANALYSIS, BOOL bIncludeFactory = FALSE, BOOL bIncludeLastUsed = FALSE, BOOL bIncludeCommon = TRUE);

//------ Folger 03/10/08 QA80-11192 THEME_LIST_SHOULD_INCLUDE_DEFAULT_INSTEAD_OF_FACTORY_DEFAULT
//OC_API int okutil_theme_get_class_settings(LPCSTR lpcszClassname, StringArray* psaFilenames, StringArray* psaDisplayNames, int thtype = THTYPE_ANALYSIS, BOOL bIncludeFactory = FALSE, BOOL bIncludeLastUsed = FALSE, BOOL bIncludeCommon = TRUE, BOOL bThemebook = FALSE, BOOL bThemesheet = FALSE);
///------ Folger 10/19/09 QA81-14145-S1 FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
//OC_API int okutil_theme_get_class_settings(LPCSTR lpcszClassname, StringArray* psaFilenames, StringArray* psaDisplayNames, int thtype = THTYPE_ANALYSIS, BOOL bIncludeDefault = FALSE, BOOL bIncludeLastUsed = FALSE, BOOL bIncludeCommon = TRUE, BOOL bThemebook = FALSE, BOOL bThemesheet = FALSE);
OC_API int okutil_theme_get_class_settings(LPCSTR lpcszClassname, StringArray* psaFilenames, StringArray* psaDisplayNames, int thtype = THTYPE_ANALYSIS, BOOL bIncludeDefault = FALSE, BOOL bIncludeLastUsed = FALSE, BOOL bIncludeCommon = TRUE, BOOL bThemebook = FALSE, BOOL bThemesheet = FALSE
										   , BOOL bIncludeFolderLastUsed = TRUE
											///------ Folger 01/19/10 QA81-14980-S2 GET_ANALYSIS_THEME_SHOULD_NOT_INCLUDE_SYSTEM_BY_DEFAULT
											, BOOL bInlucdeSystem = FALSE
											///------ End GET_ANALYSIS_THEME_SHOULD_NOT_INCLUDE_SYSTEM_BY_DEFAULT
										   );
///------ End FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
//------

/// end XF_THEME_BOOK_AND_SHEET 
//Comments last updated by Iris 7/28/2008, added $
/**$
	Save theme tree to the specail path and filename.
	Parameters:
		strThemeName = [input] the theme name
		thtype = [input] the theme type, THTYPE_GRAPH etc
		nPathType = [input] theme path type, like THTYPE_SYSTEM etc
		nScope = [input] the scope of analysis, like THTYPESCOPE_ANALYSIS_CLASS etc
		lpcszClassOption = [input] Class name and option
		lpcszCategory = [input] Category name
		pnTableID = [input] Table ID, used only for THTYPE_REPORT_TABLE
	Return:
		true if save successfully else false.
*/					
OC_API string okutil_theme_construct_filename(LPCSTR strThemeName, int thtype, int nPathType = ORIGIN_PATH_USER, int nScope=0, 
						LPCSTR lpcszClassOption=NULL, LPCSTR lpcszCategory=NULL, int* pnTableID=NULL
						///------ Folger 10/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
						, LPCSTR lpcszMoreInfo= NULL
						///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
						);
///end MOVE_GET_CLASS_SETTINGS_TO_VC


/// TD 9-12-05 QA70-7403 CODEBUILDER_XFN_INTERACTION_TO_VC
OC_API bool	okutil_is_col_str(string *pstr);
OC_API bool okutil_is_excel_formatted_string(LPCSTR lpcszStr);
/// ML 1/13/2006 XVARIABLEBASE_TO_VC
//OC_API BOOL okutil_tree_check_get_node(TreeNode * ptrNodeRetun, TreeNode *ptr, LPCSTR lpcszTag, int nID = 0, LPCSTR lpcszAttribName = NULL, LPCSTR lpcszAttribVal = NULL);
/// end XVARIABLEBASE_TO_VC


OC_API BOOL okutil_xvt_get_display_value(TreeNode *ptrVar, string * pstrDisplayVal);


OC_API string	okutil_fo_get_function_name(TreeNode *ptrFunction, bool bIncludePrefix =false);
OC_API BOOL okutil_fo_check_update_function(TreeNode* ptrFunction, StringArray *pArrEditables);


OC_API BOOL okutil_xft_get_var_return_type(TreeNode* ptrFunction, string * pstrType);
OC_API string    okutil_xft_generate_internal_name(TreeNode* ptrFunction, bool bAddPrefix);
OC_API string	okutil_xft_get_function_name(TreeNode* ptrFunction, bool bConvertToCname = false, bool bInternal = false);

OC_API bool	okutil_xft_update_editables(TreeNode* ptrFunction, BOOL bInternal, PointArray *pEditables);
OC_API bool	okutil_xft_get_event_name(TreeNode* ptrFunction, BOOL bInternal, int nEvent, string *pstrEvent);
OC_API BOOL okutil_xft_get_event_body(TreeNode* ptrFunction, int nEvent, string * pstrBody);
/*
OC_API BOOL	okutil_xvt_get_declaration_string(TreeNode *ptrVar, string * pstrDeclaration);
OC_API BOOL	okutil_xft_construct_header_string(TreeNode* ptrFunction, string* pstrResult);
OC_API int	okutil_xft_get_max_event(TreeNode* ptrFunction);
OC_API  BOOL	okutil_xft_construct_declaration_string(TreeNode* ptrFunction, string * pstrDeclaration, bool bInternal = false);
OC_API bool	okutil_xft_construct_implementation_string(TreeNode* ptrFunction, string * pstrInplementation);
OC_API string okutil_xft_get_event_prototype(int nEventId, string *pxfName);
OC_API BOOL okutil_xft_get_event_tree_node(TreeNode* ptrFunction, TreeNode* ptrEvent, int nEvent);
OC_API BOOL	okutil_xft_set_xfunction_event_body(TreeNode* ptrFunction, int nEvent, LPCSTR lpcszBody);
OC_API BOOL okutil_xft_check_update_core_files(LPCSTR lpcszImplementationPath, LPCSTR lpcszFullFunctionString);
*/
OC_API bool okutil_xft_get_source_path(TreeNode* ptrFunction, string * pstrFullPath, BOOL bPrepareFile = FALSE, BOOL bInternal = FALSE, PointArray *pEditables = NULL);
OC_API bool	okutil_xft_prepare_oc_file(TreeNode* ptrFunction, BOOL bInternal = FALSE, PointArray *pEditables = NULL);
/// end CODEBUILDER_XFN_INTERACTION_TO_VC

/// ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION
OC_API bool	okutil_xft_get_op_init_info(LPCSTR lpcszName, int *pnOpt, string *pstr, StringArray *psaOptions, StringArray *psaNames, string *pstr2 = NULL);
/// end INVOKING_OPERATION_FROM_XFUNCTION

OC_API BOOL okutil_xft_is_vec_str_group(TreeNode *ptrVar, string* pstrCombo = NULL) ;//----- CPY 6/21/2006 GETN_STR_GROUP_FOR_XF


/// end XFUNCTION_TREE_MANIPULATION_IN_VC
/// ML 6/7/2007 QA70-9883 XFUNCS_FOLDER_SNAPSHOT_MUST_MAKE_ALLOWANCE_FOR_INEXACT_TIME 
///// TD 10-20-05 QA70-7985 USE_FOLDER_SNAP_SHOTS_TO_TEST_DITRTYNESS
//OC_API int Folder_SnapShot(string *pStrSnapShot, LPCSTR lpcszRootFolder, LPCSTR lpcszSearcString);
///// end USE_FOLDER_SNAP_SHOTS_TO_TEST_DITRTYNESS
/// end XFUNCS_FOLDER_SNAPSHOT_MUST_MAKE_ALLOWANCE_FOR_INEXACT_TIME 

/**$
*/
// OC_API int okutil_parse_arg_str(LPCSTR lpcszArg, StringArray* pvsVals, StringArray* pvsKeys, bool bKeyPartialMatch=true, bool bKeyCaseSensitive=false);
OC_API int okutil_parse_arg_str(LPCSTR lpcszArg, StringArray* pvsVals, StringArray* pvsKeys, BOOL bKeyPartialMatch=true, BOOL bKeyCaseSensitive=false, StringArray* pvsKeysSet=NULL, int nVarOffset = 0);	//true, false, NULL



/// ML 6/1/2005 STYLE_LINKS_WITH_OFFSETS

enum LNKSTLREF {
	LNKSTLREF_INVALID								= 0,
	LNKSTLREF_LABEL_ONLY,
	LNKSTLREF_LABEL_AND_DATA,
	LNKSTLREF_DATA_ONLY,
};

#define			STYLELINK_VALUE_SEP_FROM_OFFSET_INFO			'|'
#define			STYLELINK_OFFSET_INFO_ONEDIR_BEGIN				'('
#define			STYLELINK_OFFSET_INFO_ONEDIR_END				')'

/**$
*/
OC_API bool		okutil_make_linkedstyle_offset_string(bool bAppend, string *pstring, LNKSTLREF nref1, int nOffset1, int nSize1,
													  LNKSTLREF nref2 = LNKSTLREF_INVALID, int nOffset2 = 0, int nSize2 = 0);

/**$
*/
OC_API bool		okutil_parse_onedir_linkedstyle_offset_string(LPCSTR lpcszString, int *pnRef, int *pnOffset, int *pnSize);


/**$
*/
OC_API bool		okutil_repetitive_style_string(TreeNode *tn, int nDim, bool bSet, int *pnPeriod = NULL, int *pnOffset = NULL, int *pnSize = NULL);

/**$
*/
///------ Folger 08/19/09 QA80-14168 LABTALK_TREE_NICE_DUMPING
//#define OTR_USE_LABEL				0x1000
//#define OTR_NO_DISPLAY_LENGTH_LIMIT 0x2000
///// SY 2007-06-06 QA70-9426 v8.0634 ASSIGN_TREE_VARABILE_FOR_XF_IN_LT
/////	#define OTR_DISPLAY_HIDDEN_TREENODE	0x3000	/// Hong 01/12/07 NO_NEED_DUMP_HIDDEN_TREENODE_FOR_RESULT_TREE
//#define OTR_DISPLAY_HIDDEN_TREENODE	0x4000
///// end ASSIGN_TREE_VARABILE_FOR_XF_IN_LT
//OC_API void		okutil_out_tree(TreeNode *tn, int nLevel, LPCSTR lpcszPredix, DWORD dwOptions = 0);
enum
{
	OTR_USE_LABEL					= 0x1000,
	OTR_NO_DISPLAY_LENGTH_LIMIT		= 0x2000,
	OTR_DISPLAY_HIDDEN_TREENODE		= 0x4000,
	OTR_SHOW_LINE_AS_CONNECTOR		= 0x8000,
};
OC_API BOOL		okutil_out_tree(TreeNode *ptn, int nLevel = 0, DWORD dwOptions = OTR_SHOW_LINE_AS_CONNECTOR, string* pstrOut = NULL);
///------ End LABTALK_TREE_NICE_DUMPING

/// end STYLE_LINKS_WITH_OFFSETS

#define		XFMENU_OFFSET_START_THEMES		0
#define		XFMENU_OFFSET_OPENDIALOG		0xe		//14
#define		XFMENU_OFFSET_ADD_AS_TOOL		0xf		//15
#define		XFMENU_OFFSET_MAX_NUM_THEMES	XFMENU_OFFSET_OPENDIALOG
#define		XFMENU_OFFSET_THEME_LASTUSED	0x10	//16

//---- CPY 6-23-05 QA70-7834 LOAD_DEPENDS_ON_XFCALLS
// various XF checkbox that we can find out without loading the XF
enum {
	/// ML 6/28/2005 ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS
	//XFBIT_AUTO_DEPENDENT = 1,
	XFBIT_AUTO_DEPENDENT					= 0x00000001,
	XFBIT_CHECK_MENU						= 0x00000002,
	/// end ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS

	///Sophy 9/3/2012 ORG-5935-P2 DISABLE_UNSUPPORTED_CONTEXTMENU_ITEM_ON_OGL_LAYER
	XFBIT_EXCLUDE_FROM_OGL_GRAPH			= 0x00000004,
	///end DISABLE_UNSUPPORTED_CONTEXTMENU_ITEM_ON_OGL_LAYER
	
	XFBIT_HAS_SCRIPT_SAMPLE					= 0x00000010, //----- CPY 6/7/2007 QA70-9815 XF_LT_SCRIPT_SAMPLE_VIEWER_NEED_FASTER_GET_INFO

	/// ML 12/15/2006 ENABLING_IMAGE_MENU_ITEMS_BASED_ON_PRESENCE_OF_IMAGE_INPUT_ARG
	XFBIT_ARG_IMAGE_INPUT					= 0x00010000,
	XFBIT_ARG_MAT_INPUT						= 0x00020000, //CPY 12/15/06
	/// end ENABLING_IMAGE_MENU_ITEMS_BASED_ON_PRESENCE_OF_IMAGE_INPUT_ARG
	/// ML 11/19/2007 QA70-10701 XF_MENU_ITEMS_BASED_ON_GRAPH_TYPE
	XFBIT_ARG_VECTOR_INPUT					= 0x00040000,
	XFBIT_ARG_DATARANGE_INPUT				= 0x00080000,
	XFBIT_ARG_XYDATARANGE_INPUT				= 0x00100000,
	XFBIT_ARG_XYZDATARANGE_INPUT			= 0x00200000,
	/// end XF_MENU_ITEMS_BASED_ON_GRAPH_TYPE
	/// ML 11/30/2007 QA70-10701 SHOULD_ENABLE_XFMENUITEMS_ON_EMPTY_GRAPHS_IF_NOT_ANALYSIS
	XFBIT_ARG_VECTORCOMPLEX_INPUT			= 0x00400000,
	XFBIT_ARG_XYRANGECOMPLEX_INPUT			= 0x00800000,
	/// end SHOULD_ENABLE_XFMENUITEMS_ON_EMPTY_GRAPHS_IF_NOT_ANALYSIS
};
//----


/// ML 6/28/2005 ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS
// int m_nCheckStatus values/bits:
enum {
	OCXF_CHECKMARK							= 0x00000001,
};
/// end ADDING_GUI_CMD_UPDATE_FOR_XFUNCTIONS



/// ML 10/5/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS
#define			TBL_NAMED_RANGE_ID_NONE					-1
OC_API BOOL okutil_set_spec_tbl_range_name(string *pstr, int nReportId = TBL_NAMED_RANGE_ID_NONE, BOOL bReportIsUID = FALSE,
													  int nTblId = TBL_NAMED_RANGE_ID_NONE, BOOL bTableIsID = FALSE,
													  int nDim1Id = TBL_NAMED_RANGE_ID_NONE, int nDim2Id = TBL_NAMED_RANGE_ID_NONE);
/// end SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS

/// EJP 2007-08-15 v8.0683 QA70-9987 AUTO_INSTALL_OPX_OPK_ON_STARTUP
OC_API int okutil_auto_install_package_files();
/// end AUTO_INSTALL_OPX_OPK_ON_STARTUP

/// EJP 2005-10-14 v8.0317 QA70-8166 XML_REPLACEMENT_FOR_OPK
OC_API int okutil_create_package_tree(TreeNode *ptnPkg);
OC_API int okutil_create_package_file(TreeNode *tnPkg, LPCSTR lpcszPkgFileName, StringArray* psaFileNames);
OC_API int okutil_install_package_file(LPCSTR lpcszPkgFileName, BOOL bPkgExistPrompt = FALSE);
OC_API int okutil_uninstall_package_file(LPCSTR lpcszPkgName);
OC_API int okutil_get_installed_package_names(StringArray* psaNames);
OC_API int okutil_add_folder_to_package(TreeNode *tnPkg, LPCSTR lpcszPath, BOOL bRecursive = TRUE, BOOL bStripStartPath = TRUE);
OC_API int okutil_add_files_to_package(TreeNode *tnPkg, StringArray* psaFileNames);
OC_API int okutil_remove_files_from_package(TreeNode *tnPkg, StringArray* psaFileNames);
OC_API int okutil_get_packed_file_names(TreeNode *tnPkg, StringArray* psaFileNames);
OC_API int okutil_repack_files(TreeNode *tnPkg);
/// end XML_REPLACEMENT_FOR_OPK

/// EJP 2011-01-04 ORG-1902 INIT_PKG_MGR_FROM_INSTALLED_PKG
OC_API int okutil_create_pkg_tree_from_installed_pkg(TreeNode *tnPkg, LPCSTR lpcszPkgName);
/// end INIT_PKG_MGR_FROM_INSTALLED_PKG

/// YuI 12/06/07 QA70-10786 IMPROVING_ERROR_HANDLING_ON_PACKAGE_DEPLOYMENT
OC_API int	okutil_get_package_installation_error_stack(StringArray* psaErrors, BOOL bGetLastErrorOnly = TRUE);
/// end IMPROVING_ERROR_HANDLING_ON_PACKAGE_DEPLOYMENT

/// EJP	2007-07-10 v8.0657 QA70-9103 EXTRACT_FILES_FROM_OPX
OC_API int okutil_extract_package_files(LPCSTR lpcszPkgFileName, LPCSTR lpcszTargetPath);
/// end	EXTRACT_FILES_FROM_OPX

/// EJP 2007-01-12 v8.0541 QA70-9103 NOTIFY_USER_FILE_ALREADY_IN_PKG
OC_API BOOL okutil_is_file_in_pkg(TreeNode *tnPkg, LPCSTR lpcszFileName);
OC_API int okutil_is_files_in_pkg(TreeNode *tnPkg, StringArray* psaFileNames);
/// end NOTIFY_USER_FILE_ALREADY_IN_PKG

/// EJP 2007-02-09 v8.0560 QA70-8548 EXPORT_USER_BUTTON_GROUP_TO_OPX
OC_API int okutil_export_button_group(LPCSTR lpcszOPXFileName, LPCSTR lpcszTBarFileName, StringArray* psaAddFileNames);
/// end EXPORT_USER_BUTTON_GROUP_TO_OPX

/// EJP 2006-04-19 v8.0396 QA70-7066 EXPORT_ALL_TBARS_AND_BUTTON_GROUPS
OC_API BOOL okutil_export_toolbar_settings(LPCSTR lpcszFileName);
/// end EXPORT_ALL_TBARS_AND_BUTTON_GROUPS

/// EJP 2007-11-01 v8.0739 QA70-10528 CREATE_DEVKIT_FROM_LABTALK
OC_API int okutil_repack_package(LPCSTR lpcszPkgFileName);
OC_API int okutil_create_from_template(LPCSTR lpcszTemplateFileName);
/// end CREATE_DEVKIT_FROM_LABTALK

/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
// error enum for parsing range string
typedef enum tagPARSERANGESTRINGRESULT
{
	PRS_SUCCESS										= 0,
	PRS_ERROR_GENERAL								= -1,
	PRS_ERROR_PARETHESIS_MISMATCH					= -2,
	PRS_ERROR_INVALID_PREFIX						= -3,
	PRS_ERROR_EMPTY_OR_INVALID_BOOK_DESCRIPTOR		= -4,
	PRS_ERROR_EMPTY_OR_INVALID_SHEET_DESCRIPTOR		= -5,
	PRS_ERROR_EMPTY_OR_INVALID_OBJECT_DESCRIPTOR	= -6,
	PRS_ERROR_LABTALK_VARIABLE						= -7,
	PRS_ERROR_SAME_INPUT_NOT_FOUND					= -8,
	PRS_ERROR_OBJ_DESCRIPTOR_STILL_PREDEFINED_STR	= -9, ////------- CPY 10/17/2007 QA70-10556 XF_NEW_OUTPUT_BROKEN_DUE_TO_RANGE_GET_EXIST_TYPE_CHANGE
	PRS_ERROR_NAMED_RANGE_NOT_FOUND					= -10, /// Hong 08/17/11 ORG-3511 LT_SUPPORT_NAMED_RANGE
}	PARSERANGESTRINGRESULT;


// the enumeration under PRS_NUMERIC_OBJECT_DESCRIPTOR_COMPLETION_MASK
// describes how to complete string for user friendliness to show in the command log
// for instance "stats 1" will become "stats !Col(1)"
// PRS_SINGLEWORD_KEYWORD_MASK
// this enumeration defines how to treate sigle word if this single word happens to be keyword (like <new>)
// usually it is treated as object descriptor but in case of Worksheet XVariable it is sheet descriptor
// PRS_SINGLEWORD_MASK - this enumeration is how to treat singleword (not a keyword)
// the rest are bits
typedef enum tagPARSERANGESTRINGCNTRL
{
	/// YuI 03/21/06 PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES
	/*
	PRS_NUMERIC_OBJECT_DESCRIPTOR_NONE				= 0x00000001, // if object descriptor is numeric - leave as is
	PRS_NUMERIC_OBJECT_DESCRIPTOR_MAT				= 0x00000002, // if object descriptor is numeric - wrap number with Mat()
	PRS_NUMERIC_OBJECT_DESCRIPTOR_COL				= 0x00000003, // if object descriptor is numeric - wrap number with Col()
	PRS_NUMERIC_OBJECT_DESCRIPTOR_COMPLETION_MASK	= 0x0000000F,
	*/
	/// end PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES

	PRS_SINGLEWORD_KEYWORD_OBJECT					= 0x00000010,
	PRS_SINGLEWORD_KEYWORD_SHEET					= 0x00000020,
	PRS_SINGLEWORD_KEYWORD_BOOK						= 0x00000030,
	PRS_SINGLEWORD_KEYWORD_MASK						= 0x000000F0,
	PRS_SINGLEWORD_OBJECT							= 0x00000100,
	PRS_SINGLEWORD_SHEET							= 0x00000200,
	PRS_SINGLEWORD_BOOK								= 0x00000300,
	PRS_SINGLEWORD_LOOSE_DATASET					= 0x00000400,
	PRS_SINGLEWORD_MASK								= 0x00000F00,
	
	PRS_CVT_PAGE_LONGNAME_TO_SN						= 0x00001000, //----- CPY 2/8/2008 QA70-11068 EXIST_FUNCTION_CHECK_RANGE_STR

	/// YuI 03/21/06 PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES
	PRS_PARSE_MASK									= 0x0000FFFF,

	// C is added to prefix "PRSC" to indicate that these bits refer to completion
	// and not to parsing
	PRSC_NUMERIC_OBJECT_DESCRIPTOR_NONE				= 0x00010000,
	PRSC_NUMERIC_OBJECT_DESCRIPTOR_MAT				= 0x00020000,
	PRSC_NUMERIC_OBJECT_DESCRIPTOR_COL				= 0x00030000,
	PRSC_NUMERIC_OBJECT_DESCRIPTOR_PLOT				= 0x00040000,
	PRSC_NUMERIC_OBJECT_DESCRIPTOR_COMPLETION_MASK	= 0x000F0000,

	PRSC_LEVEL_PAGE									= 0x00100000,
	PRSC_LEVEL_LAYER								= 0x00200000,
	PRSC_LEVEL_OBJECT								= 0x00300000,
	PRSC_LEVEL_MASK									= 0x00F00000,
	PRSC_OMIT_UNNECESARY							= 0x01000000,
	PRSC_DO_NOT_ENCLOSE_INTO_PARETHESIS				= 0x02000000,
	/// YuI 2/28/07 NEED_TO_SUPPORT_REDUCED_RANGE_STRING_NOTATION
	PRSC_FULL_SHEET_IF_NO_OBJECT					= 0x04000000,
	/// end NEED_TO_SUPPORT_REDUCED_RANGE_STRING_NOTATION
	PRSC_COMPLETE_MASK								= 0xFFFF0000,
	/// end PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES

}	PARSERANGESTRINGCNTRL;

/// YuI 03/21/06 PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES
typedef	enum tagCOMPLETERANGESTRIGCNTRL
{
	

}	COMPLETERANGESTRIGCNTRL;
/// end PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES

#define RANGE_STRING_LOOSE_DATA_WORKBOOK_INDICATOR		"??"
OC_API int	okutil_parse_complex_range_string(LPCSTR lpcszString, StringArray* parrPageDescriptor, StringArray* parrLayerDescriptor, StringArray* parrObjectDescriptor, DWORD dwCntrl = PRS_SINGLEWORD_KEYWORD_OBJECT | PRS_SINGLEWORD_BOOK);
// Category last updated by Folger 09/19/2010
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_parse_complete_range_string_(global_function)
*/
OC_API BOOL	okutil_parse_complete_range_string(LPCSTR lpcszString, string* pstrPageDescriptor, string* pstrLayerDescriptor, string* pstrObjectDescriptor, DWORD dwCntrl = PRS_SINGLEWORD_KEYWORD_OBJECT | PRS_SINGLEWORD_BOOK);
/// ML 1/13/2006 XVARIABLEBASE_TO_VC
OC_API	BOOL	okutil_parse_complex_generic_range_string(LPCSTR lpcszVal, StringArray *pstrVals, DWORD dwCntrl);
OC_API	bool	okutil_parse_one_xyrange_formatted_string(LPCSTR lpcszString, string *pstrBook, string *pstrSheet);
OC_API	BOOL	okutil_get_book_sheet_info(string *pstrBookName, string *pstrSheetName, LPCSTR lpcszString);
/// end XVARIABLEBASE_TO_VC

/// YuI 11/19/07 QA70-10716 GUI_LOCALIZATION_ON_CHANGE_PARAM
OC_API	void	okutil_localize_input_data_node_labels(TreeNode* pNode, DWORD dwDataRules);
/// end GUI_LOCALIZATION_ON_CHANGE_PARAM

/// YuI 11/27/07 QA70-10542 FIND_X_FROM_Y_SHOULD_ALLOW_OUTPUT_COLLISIONS
enum {
	OUTPUT_REPORT_SHEET_RNG_INDEX,
	OUTPUT_RESULT_CURVE_SHEET_RNG_INDEX,
	OUTPUT_RESIDUAL_CURVE_SHEET_RNG_INDEX,
	OUTPUT_CALIBRATION_CURVE_SHEET_1_RNG_INDEX,
	OUTPUT_CALIBRATION_CURVE_SHEET_2_RNG_INDEX,
	OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX,
	OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_1,
	OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_2,

	//------ Folger 11/12/08 QA80-12488 v8.0969 PEAK_CHARACTERISTIC_REPORT_CANNOT_BE_AUTO_UPDATED
	OUTPUT_RESULT_PEAK_CHARACTER_RNG_INDEX = 10,

	//------ Folger 11/13/08 v8.0970 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	OUTPUT_RESULT_SUBTRACTED_RNG_INDEX,
	OUTPUT_RESULT_BASELINE_RNG_INDEX,
	//------

	OUTPUT_RESULT_RNG_INDEX_END,
	//------
};

enum {
	/// Hong 03/13/09 QA80-13283 FIX_NLFIT_SECOND_DATASET_OUTPUT_REMOVED_DUE_TO_OUTPUT_INDEX_INTERSECTED
	//OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET  = 1,
	OUTPUT_RESULT_START						= 1,
	OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET	= OUTPUT_RESULT_START,
	/// end FIX_NLFIT_SECOND_DATASET_OUTPUT_REMOVED_DUE_TO_OUTPUT_INDEX_INTERSECTED
	OUTPUT_RESULT_CURVE_RESIDUAL_SHEET,	
	OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET,
	OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET,
	OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET,
	OUTPUT_RESULT_PEAK_CHARACTER_SHEET, /// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	OUTPUT_RESULT_SUBTRACTED_DATA_SHEET,
	OUTPUT_RESULT_BASELINE_DATA_SHEET,
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP

	/// Hong 03/13/09 QA80-13283 FIX_NLFIT_SECOND_DATASET_OUTPUT_REMOVED_DUE_TO_OUTPUT_INDEX_INTERSECTED
	OUTPUT_RESULT_END,
	/// end FIX_NLFIT_SECOND_DATASET_OUTPUT_REMOVED_DUE_TO_OUTPUT_INDEX_INTERSECTED
};
/// Hong 03/13/09 QA80-13283 FIX_NLFIT_SECOND_DATASET_OUTPUT_REMOVED_DUE_TO_OUTPUT_INDEX_INTERSECTED
// [OUTPUT_RESULT_START, OUTPUT_RESULT_END)
#define	WKS_REPORT_OPERATION_DEF_OUTPUT_COUNT		(OUTPUT_RESULT_END - OUTPUT_RESULT_START)
/// end FIX_NLFIT_SECOND_DATASET_OUTPUT_REMOVED_DUE_TO_OUTPUT_INDEX_INTERSECTED


OC_API	int		okutil_get_wks_report_operation_output_slot(int nDataIndex, bool bTableMustBeOutside, int nOutputIndex);
OC_API	BOOL	okutil_is_calibration_range_index(int nRangeIndex);
/// end FIND_X_FROM_Y_SHOULD_ALLOW_OUTPUT_COLLISIONS

/// YuI 03/21/06 PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES
//	OC_API int	okutil_complete_range_string(string* pstrDestination, LPCSTR lpcszSource, );				 
OC_API int	okutil_complete_range_string(string* pstrDestination, LPCSTR lpcszSource, DWORD dwCntrl = PRS_SINGLEWORD_KEYWORD_OBJECT | PRS_SINGLEWORD_BOOK | PRSC_OMIT_UNNECESARY | PRSC_LEVEL_OBJECT);
/// end PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES

// Category last updated by Folger 09/19/2010
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_create_complete_range_string_obj_(global_function)
*/
OC_API void	okutil_create_complete_range_string_obj(string* pstrDestination, LPCSTR lpcszBook, LPCSTR lpcszSheet, LPCSTR lpcszObject, BOOL bMustAddObjSep = false);
OC_API void	okutil_create_complete_range_string_col_row(string* pstrDestination, LPCSTR lpcszBook, LPCSTR lpcszSheet, LPCSTR lpcszC1, int nR1, LPCSTR lpcszC2, int nR2);
OC_API void	okutil_create_complete_range_string_col_row_int(string* pstrDestination, LPCSTR lpcszBook, LPCSTR lpcszSheet, int nC1, int nR1, int nC2, int nR2);

///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
OC_API BOOL okutil_create_complex_generic_range_string(string* pstrResult, StringArray* parrStrings, BOOL bOmitActive = TRUE, BOOL bParethesize = FALSE, int nMinNumberOfParts = -1, BOOL bBookSheetMismatchIfEmptyInTheMiddle = FALSE);
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

// c1 and c2 can be numbers (1-offset) or text
/// YuI 1/18/07 QA70-9281 OC_RANGE_BASED_ACCESS_TO_LABEL_AREA
//	OC_API BOOL okutil_create_range_string(string* pstrDestination, LPCSTR lpcszCol1, int nCell1 = -1, LPCSTR lpcszCol2 = NULL, int nCell2 = -1);
OC_API BOOL okutil_create_range_string(string* pstrDestination, LPCSTR lpcszCol1, int* pCell1 = NULL, LPCSTR lpcszCol2 = NULL, int* pCell2 = NULL);
/// end OC_RANGE_BASED_ACCESS_TO_LABEL_AREA

/// YuI 10/12/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT
OC_API BOOL okutil_create_range_string_ex(string* pstrDestination, LPCSTR lpcszCol1, LPCSTR lpcszRow1, LPCSTR lpcszCol2, LPCSTR lpcszRow2);
OC_API void okutil_create_row_range_string_ex(string* pstrRowRange, LPCSTR lpcszRow1, LPCSTR lpcszRow2);
OC_API BOOL okutil_create_x_range_string(string* pstrXRange, double dFrom, double dTo);
OC_API void okutil_create_x_range_string_ex(string* pstrXRange, LPCSTR lpcszFrom, LPCSTR lpcszTo);
/// end X_RANGE_POLYRANGE_SUPPORT

// "1" -> 1
// "L" -> -2000 OKFCR_FOUND_LABEL_OFFSET
OC_API int okutil_convert_row_index(LPCSTR lpcszRow);  //----- CPY 1/20/2007 QA70-9281 LABEL_REGION_RANGE_RESOLUTION
OC_API int okutil_convert_negative_row_to_label_type(int negativeRowIndex);	   ///Folger 06/27/07 QA70-9281 LABEL_REGION_RANGE_RESOLUTION

///------ Folger 04/06/2011 ORG-2581-S1 UNSTACK_COLUMN_SUPPORT_PUT_GROUP_INFO_INTO_CUSTOM_LABELS
//OC_API BOOL okutil_convert_labels_string_to_indices(LPCSTR lpcszLabels, IntArray * parrIndices);	///Kyle 03/09/2009 QA80-13228 ADD_FUNCTION_TO_CONVERT_LABELS_STRING_TO_INDICES
OC_API BOOL okutil_convert_labels_string_to_indices(LPCSTR lpcszLabels, IntArray * parrIndices, DWORD dwCntrl = 0, LPINT pErr = NULL);
///------ End UNSTACK_COLUMN_SUPPORT_PUT_GROUP_INFO_INTO_CUSTOM_LABELS


// all int must be 0 offset
OC_API BOOL okutil_create_range_string_int(string* pstrDestination, int nC1, int nR1, int nC2, int nR2);
/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS

//-------- CPY 1/26/06 COL_LONG_NAME_FROM_XF, changed return type from BOOL
enum 
{
	PRSR_FORMAT_ERR_LEFT = -3, 
	PRSR_FORMAT_ERR_RIGHT = -2, 
	PRSR_FORMAT_ERR = -1, 
	PRSR_IS_PREDEF_STR = 0, 
	PRSR_IS_RANGE, 
	PRSR_IS_EMPTY,
	/// YuI 10/12/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT
	PRSR_IS_RANGE_X, // range designating X range, not row range, like [x2.5:7.5]
	/// end X_RANGE_POLYRANGE_SUPPORT
};
//--------
// range string in the form of c1[r1]:c2[r2]
OC_API int okutil_parse_range_string(LPCSTR lpcszRange, string* pstrC1, string* pstrR1, string* pstrC2, string* pstrR2, BOOL* pbCol2Empty = NULL, BOOL* pbRow2Empty = NULL);

/// YuI 10/26/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT
// these are usitility function no need to ifdef

// will be true of lpcszR1 is in form "x2.5", lpcszR2 is nueric
OC_API BOOL	okutil_parse_x_range_strings(LPCSTR lpcszR1, LPCSTR lpcszR2, double* pFrom = NULL, double* pTo = NULL, BOOL bReturnFalseIfNoIndicator = TRUE);

OC_API BOOL	okutil_create_row_range_strings(string* pstrR1, string* pstrR2, int nFrom, int nTo);
// will construct pstrR1 in form "x2.5", pstrR2 will be numeric
OC_API BOOL	okutil_create_x_range_strings(string* pstrR1, string* pstrR2, double dFrom, double dTo, BOOL bAddIndicator = TRUE);
OC_API void	okutil_create_x_range_strings_ex(string* pstrR1, string* pstrR2, LPCSTR lpcszFrom, LPCSTR lpcszTo, BOOL bAddIndicator = TRUE);
/// end X_RANGE_POLYRANGE_SUPPORT
//Category last udpated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_parse_row_range_(global_function)
*/
OC_API BOOL okutil_parse_row_range(LPCSTR lpcszRowrange, int* pi1, BOOL* pbAuto1, int* pi2, BOOL* pbAuto2);

///Sophy 2/24/2012 ORG-5153 PLOTSETUP_REPLACE_NEED_CHECK_KEEP_ROW_RANGE
OC_API BOOL	okutil_parse_composite_row_range(LPCSTR lpcszRowRange, int* pi1, int* pi2, BOOL* pbAuto1 = NULL, BOOL* pbAuto2 = NULL, string* pstrLimits = NULL);
OC_API BOOL	okutil_make_composite_row_range(string* pStrRange, int i1, int i2, BOOL bAuto1 = FALSE, BOOL bAuto2 = FALSE, LPCSTR lpcszLimits = NULL);
///end PLOTSETUP_REPLACE_NEED_CHECK_KEEP_ROW_RANGE
/// YuI 11/02/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT
OC_API BOOL okutil_parse_row_range_ex(LPCSTR lpcszR1, LPCTSTR lpcszR2, int* pi1, BOOL* pbAuto1, int* pi2, BOOL* pbAuto2);
/// end X_RANGE_POLYRANGE_SUPPORT
/// YuI 12/29/08 QA70-12831 COLUMN_FORMULA_TO_REMEMBER_THE_RANGE
#define	STR_COL_FORMULAR_ROWRANGE_SEPARATOR	";\r\n#$"
/// Iris 12/28/2010 NEW_LAYER_CONTENTS_DLG_NEED_CREATE_ROWRANGE_STRING_FUNC
//OC_API void okutil_create_row_range_string(string* pstrRowRange, int nI1, int nI2);
OC_API void okutil_create_row_range_string(string* pstrRowRange, int nI1, int nI2, bool bAuto1 = false, bool bAuto2 = false);
///End NEW_LAYER_CONTENTS_DLG_NEED_CREATE_ROWRANGE_STRING_FUNC
OC_API void	okutil_parse_composite_column_formula(LPCSTR lpcszFormula, string* pstrFormula, string* pstrPreScript, int* pBegin, int* pEnd);
/// end COLUMN_FORMULA_TO_REMEMBER_THE_RANGE



/// ML 1/13/2006 XVARIABLEBASE_TO_VC
OC_API	bool	okutil_parse_one_excel_formatted_string(LPCSTR lpcszString, string *pstrBook, string *pstrSheet, int *pnr1 = NULL, string *pc1 = NULL, int *pnr2 = NULL, string *pc2 = NULL);
OC_API	bool	okutil_get_column_description(string *pstrDesc, int nColIndex);

OC_API	string	okutil_make_book_sheet_string(LPCSTR lpcszBook, LPCSTR lpcszSheet, bool bAppendExcl = false);
enum {
	GBKN_CHK_REMOVE_QUOTES	= 0x01,
	GBKN_ALLOW_NO_BOOK		= 0x02,
};
OC_API	bool	okutil_get_book_sheet_names(LPCSTR lpcszBookSheet, string *pstrBook, string *pstrSheet, DWORD dwCntrl = GBKN_CHK_REMOVE_QUOTES);
/// end XVARIABLEBASE_TO_VC





//Category last udpated by Iris 7/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CRQ_TRIM_SPACE_OUTSIDE
*/
/// YuI 10/09/06 RANGE_ASSIGNMENT_QUOTE_REMOVAL_BUG
//	OC_API BOOL okutil_check_remove_quotes(string* pstr, BOOL bTrimSpaces = true, char cEndToRemove = 0);
//-------- CPY 2/16/07 TYPE_STR_ADDING_WITH_SPACES_GOT_TRIMMED
//OC_API BOOL okutil_check_remove_quotes(string* pstr, BOOL bTrimSpaces = true, char cEndToRemove = 0, BOOL* lpResult = NULL);
enum {
	CRQ_TRIM_SPACE_OUTSIDE	= 0x01,
	CRQ_TRIM_SPACE_INSIDE	= 0x02,
	CRQ_SAFER_REMOVE		= 0x10,  // check if after remove there are spaces, so should not remove, etc
	CRQ_DBL_QUOTE_ONLY		= 0x20, //----CPY 7/24/2007 QA70-10107 COMPARE_RANGE_STR_NEED_TO_SUPPORT_XY_RANGE
};
//---- CPY 7/24/2007 QA70-10107 COMPARE_RANGE_STR_NEED_TO_SUPPORT_XY_RANGE
//OC_API BOOL okutil_check_remove_quotes(string* pstr, WORD wTrimSpaces = CRQ_TRIM_SPACE_OUTSIDE|CRQ_TRIM_SPACE_INSIDE, char cEndToRemove = 0, BOOL* lpResult = NULL);
OC_API BOOL okutil_check_remove_quotes(string* pstr, WORD wTrimSpaces = CRQ_DBL_QUOTE_ONLY | CRQ_TRIM_SPACE_OUTSIDE | CRQ_TRIM_SPACE_INSIDE, char cEndToRemove = 0, BOOL* lpResult = NULL);
//---- end COMPARE_RANGE_STR_NEED_TO_SUPPORT_XY_RANGE
//--------
/// end RANGE_ASSIGNMENT_QUOTE_REMOVAL_BUG

/// YuI 10/29/09 QA70-11347 NUMERIC_SHORT_COLUMN_NAME_RANGE_NOTATION_SUPPORT
/**$
	First check if name is mangled numeric and remove mangle if so
	If not mangled numeric proceed to quote removal.

  Return:
	0: if mangled numeric
	same as okutil_check_remove_quotes otherwise
*/
OC_API	int		okutil_check_strip_mangle_remove_quotes(string* pName, WORD wTrimSpaces = CRQ_DBL_QUOTE_ONLY | CRQ_TRIM_SPACE_OUTSIDE | CRQ_TRIM_SPACE_INSIDE, char cEndToRemove = 0, BOOL* lpResult = NULL);


/// YuI 12/14/09 QA70-13806 VIRTUAL_MATRIX_IMPLEMENTATION
// Hong, move out of ifdef to allow easier coding, Hong 08/22/11 ORG-3511 NAMED_RANGE_SUPPORT_ROW_RANGE
enum
{
	MANGLED_NONE = 0,
	MANGLED_NUMERIC_SHORT_NAME,
	MANGLED_RANGE_NAME,
};
#ifdef __VIRTUAL_MATRIX__
OC_API	int		okutil_check_strip_mangle_remove_quotes_ex(string* pName, WORD wTrimSpaces = CRQ_DBL_QUOTE_ONLY | CRQ_TRIM_SPACE_OUTSIDE | CRQ_TRIM_SPACE_INSIDE, char cEndToRemove = 0, BOOL* lpResult = NULL);
#endif // __VIRTUAL_MATRIX__
/// end VIRTUAL_MATRIX_IMPLEMENTATION
/**$
	Check if name is mangled numeric. Strips mangle if it is
	Return:
		TRUE if name is mangled numeric, FALSE otherwise
*/
OC_API	BOOL	okutil_check_strip_mangle_from_numeric_short_name(string* pName, WORD wTrimSpaces = CRQ_TRIM_SPACE_OUTSIDE);

OC_API	BOOL	okutil_check_strip_mangle_from_name(string* pName, WORD wTrimSpaces = CRQ_TRIM_SPACE_OUTSIDE);
/**$
	Check if name is numeric. Add mangle if it is
	Return:
		TRUE if name is numeric and mangle added, FALSE otherwise
*/
OC_API	BOOL	okutil_check_add_mangle_to_numeric_short_name(string* pName, WORD wTrimSpaces = CRQ_TRIM_SPACE_OUTSIDE);

OC_API	void	okutil_add_mangle_to_name(string* pName);
/// end NUMERIC_SHORT_COLUMN_NAME_RANGE_NOTATION_SUPPORT

//------ CPY 7/23/2007 QA70-10083 LONGNAME_AS_LEGEND_FOR_RANGE_STR
/**$
*/
OC_API int okutil_get_sn_legend_from_index(int nIndex, string* pstrSNLegend, LPCSTR lpcszCombo, DWORD dwColNameCntrl);
#ifdef OC_CODES_SUPPORT ///---Sim 2012-5-15 ORG-5421 MAKE_BUILD_ORIGIN_VIEWER_9
/**$
*/
OC_API int okutil_get_index_from_sn_legend(LPCSTR lpcszCombo, LPCSTR lpcszSNLegend, DWORD dwColNameCntrl);
#endif //OC_CODES_SUPPORT ///---Sim 2012-5-15 ORG-5421 MAKE_BUILD_ORIGIN_VIEWER_9
/**$
*/
OC_API void okutil_make_sn_type_ln_str(string* pstrName, LPCSTR lpcszSN, int cTypeChar, LPCSTR lpcszLN);
//------

//Category last udpated by Iris 7/28/2008
/**# >Character and String Manipulation
	add quotes "" around a string if there is exposed space in it
Return:
	true if quotes were added
	false if not needed or error  n that case pErrCode will receive error code
*/
///------ Folger 11/23/09 QA81-14709 COMMA_AND_DOT_SHOULD_BE_ALLOWED_IN_SHEET_NAME
//OC_API BOOL okutil_check_add_quotes(string* pstr, BOOL bTrimSpaces = TRUE, int* pErrCode = NULL);
enum
{
	CHECKADDQUOTES_INCLUDE_DOT						= 0x00000001,
	CHECKADDQUOTES_INCLUDE_COMMA					= 0x00000002,
	CHECKADDQUOTES_NO_CONSIDER_NUMBER_SPECIAL		= 0x00000004,
};
OC_API BOOL okutil_check_add_quotes(string* pstr, BOOL bTrimSpaces = TRUE, int* pErrCode = NULL, DWORD dwCntrl = 0);
///------ End COMMA_AND_DOT_SHOULD_BE_ALLOWED_IN_SHEET_NAME

/**$
*/
OC_API LPCSTR okutil_check_LF_without_CR(LPCSTR lpcstr, string* pstrBuffer);

enum
{
	LTC_FORMAT_ERR = -1,
	LTC_EMPTY = 0,
	LTC_BY_INDEX,
	LTC_BY_NAME,
	LTC_BY_NAME_NO_FUNC,
	LTC_BY_NAME_KEEP_QUOTE,
	LTC_BY_NAME_FIRST_THEN_INDEX, ///------ Folger 06/27/2012 ORG-6044-P1 FAILED_TO_USE_SHORT_NAME_FIRST_IN_COLL_FUNCTION_IN_RANGE_NOTATION
};
//Comments last updated by Iris 7/28/2008, added #
/**#
		convert str to get column index, check wcol(LTexpression), LabTalk String variables, "quoted string" etc
	Parameters:
		pstr = [in/out] pointer to string that can be: col(1), 1, A, str$, wcol(i), col(myLTstrVar$) etc
		pnCol = [out] resulting column index, 0-offset
		pstrRemained = [out] pointer to receive remaining string after ) if present
	Return:
		one of the LTC_EMPTY, LTC_BY_INDEX, LTC_BY_NAME, LTC_BY_NAME_NO_FUNC
*/
OC_API int okutil_check_convert_LT_col(string* pstr, int* pnCol, string* pstrRemained = NULL, int* lpnQuoteChar = NULL);

// return true only if pstr is a valid LT string variable and it is converted, otherwise str is not touched
/// Hong 12/12/08 QA80-112758-P1 v8.0986 ALLOW_COL_RANGE_BE_USED_IN_DECLARATION
//OC_API BOOL okutil_check_convert_LT_str_variable(string* pstr, BOOL bTrimSpaces1st = true, BOOL bRangeVarWithoutSignature = false);
///------ Folger 11/25/2011 ORG-4458-P1 LT_LOCAL_FUNCTION_FAILED_TO_RETURN_PARTIAL_RANGE
//OC_API BOOL okutil_check_convert_LT_str_variable(string* pstr, BOOL bTrimSpaces1st = true, BOOL bRangeVarWithoutSignature = false, BOOL bRangeVarOnlyAllowSingleWholeCol = false);
OC_API BOOL okutil_check_convert_LT_str_variable(string* pstr, BOOL bTrimSpaces1st = true, BOOL bRangeVarWithoutSignature = false, BOOL bCheckRangeVarOnlyAllowSingleWholeCol = false);
///------ End LT_LOCAL_FUNCTION_FAILED_TO_RETURN_PARTIAL_RANGE
/// end ALLOW_COL_RANGE_BE_USED_IN_DECLARATION

// this function differs from okutil_check_convert_LT_str_variable in that it will remove "" if present, 
// regardless of if pstr is a string variable
OC_API int okutil_check_convert_LT_str(string* pstr, BOOL bRemoveQuotesInStrVar = true, BOOL* pbWasLTStrVal = NULL);

OC_API BOOL okutil_is_col_mat_function_name(LPCSTR lpcszName, BOOL bIncludeMat=true, BOOL bIncludePlot=true);	 //---- CPY 12/11/07 COL_LONG_NAME_WITH_PARENTH_FAILED_RESOLVED



///DSC ML 11/23/05 8.0341 QA70-8362 MAKE_UID_FOR_PFM_PEAK
OC_API DWORD okutil_get_uid(BOOL bIncrement);
///end MAKE_UID_FOR_PFM_PEAK

/// EJP 2006-02-16 v8.0366 MOVE_IMPORT_FILE_INFO_FROM_OC_TO_VC
// Category last updated by Hong 07/29/08
/**$ >Internal Origin Objects>Page and Layer
	Set the page.info.import properties.
	Parameters:
		lpcszPageName = name of the page that will receive the import info
		lpcszFile = pointer to the name of the file imported
		iDataType = the type of data
	Return:
		TRUE for success, FALSE for failure
*/
OC_API BOOL okutil_SetPageInfo(LPCSTR lpcszPageName, LPCSTR lpcszFileName, int nDataType);
/// end MOVE_IMPORT_FILE_INFO_FROM_OC_TO_VC

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ftoa_(global_function)
*/
OC_API string ftoa(double dVal, LPCSTR lpcszFmt = NULL);

//Comments last updated by Iris 7/28/2008, added #
/**#
	Get a list of built-in functions from ocmath
	Parameters:
		psaNames = vector<string> of function names
		psaArgs = vector<string> of corresponding function arguments in the form of x,a,b,c
		nCategory = categories, as BFC_CDF, BFC_PDF etc
	Return:
		number of functions or -1 if error
		
*/
///Kyle 12/03/2008 QA70-9982-S2 OKUTIL_FIND_LT_FUNCTIONS_RETURN_FUNCTION_TYPES_AND_ARGUMENT_TYPES
//OC_API int okutil_find_LT_functions(StringArray* psaNames, StringArray* psaArgs, int nCategory);
///------ Folger 12/12/08 QA80-12773 v8.0986 SUPPORT_SPECIFY_OC_FUNCTION_CATEGORY_IN_LABTALK_PRAGMA
//OC_API int okutil_find_LT_functions(StringArray* psaNames, StringArray* psaRetTypes, StringArray* psaArgs, StringArray* psaArgTypes, int nCategory);
///------ Folger 01/08/09 v8.0994d SUPPORT_GETTING_NUMBER_OF_DEFAULT_ARGUMENTS_ABOUT_OCLT_FUNCTION
//OC_API int okutil_find_LT_functions(StringArray* psaNames, StringArray* psaRetTypes, StringArray* psaArgs, StringArray* psaArgTypes, int nCategory, StringArray* pcsaCategories = NULL);
///Sophy 7/19/2012 ORG-6260-S1 MORE_CHECKING_ON_SCAN_USER_DEFINED_FUNCTION_FOR_SCV_MENU
//OC_API int okutil_find_LT_functions(StringArray* psaNames, StringArray* psaRetTypes, StringArray* psaArgs, StringArray* psaArgTypes, int nCategory, StringArray* pcsaCategories = NULL, IntArray* parrNumDefaultArgs = NULL);
OC_API int okutil_find_LT_functions(StringArray* psaNames, StringArray* psaRetTypes, StringArray* psaArgs, StringArray* psaArgTypes, int nCategory, StringArray* pcsaCategories = NULL, IntArray* parrNumDefaultArgs = NULL, DWORD dwCtrl = 0);
///end MORE_CHECKING_ON_SCAN_USER_DEFINED_FUNCTION_FOR_SCV_MENU
///------ End SUPPORT_GETTING_NUMBER_OF_DEFAULT_ARGUMENTS_ABOUT_OCLT_FUNCTION
///------ End SUPPORT_SPECIFY_OC_FUNCTION_CATEGORY_IN_LABTALK_PRAGMA
///End OKUTIL_FIND_LT_FUNCTIONS_RETURN_FUNCTION_TYPES_AND_ARGUMENT_TYPES


/// DSC 4/18/06 MOVE_OC_FUNCTION_VC
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_convert_double_vector_to_string_vector_(global_function)
*/
OC_API int okutil_convert_double_vector_to_string_vector(DoubleArray* pdaDoubles, StringArray* psaStrings, UINT nSize, StringArray* psaFormats=NULL );
///end MOVE_OC_FUNCTION_VC

/// YuI 04/24/06 ANOVA_SHOULD_NOT_SWITCH_TYPE_IF_NOT_NEEDED
//----- CPY 5/30/2007 QA70-9846 COLOR_CONTORL_WITH_CUSTOM_COLOR_SUPPORT
// not needed in OC, so moved into oku function
//OC_API BOOL	okutil_is_system_control_string(LPCSTR lpcszControl, int* pID = NULL, string* pRemainder = NULL);
//-----
/// end ANOVA_SHOULD_NOT_SWITCH_TYPE_IF_NOT_NEEDED


/// ML 1/13/2006 XVARIABLEBASE_TO_VC
#define	XVAR_OIRIGINOBJECT_COLUMN_COLLECTION_DESCRIPTOR			"COL("
#define	XVAR_OIRIGINOBJECT_DATAPLOT_COLLECTION_DESCRIPTOR		"PLOT("
#define	XVAR_OIRIGINOBJECT_GRAPHOBJECT_COLLECTION_DESCRIPTOR	"OBJ("
#define	XVAR_OIRIGINOBJECT_MATRIXOBJECT_COLLECTION_DESCRIPTOR	"MAT("
#define	RANGE_SHORT_NOTATION_SEPARATOR	','
/// end XVARIABLEBASE_TO_VC

/// Hong 7/11/06 PARAM_MISS_DEFAULT_VALUE
/// DSC 4/26/06  TREE_TO_STRING
//OC_API int octree_tree_to_str(TreeNode *tr, string &str, IntArray *vnDisplayFormat , bool bSkipHidden , bool bSimpleTypesOnly , bool bCheckUseLabel , bool bIncludeParentNamePrefix , LPCSTR lpcszDoubleValueFormat ,  bool bIncludeAuxDisplayInfo );
/// Hong 09/08/07 v8.0699 MORE_OPTION_TO_DUMP_MAP_INFO_FOR_COMBO_NODE
//OC_API int octree_tree_to_str(TreeNode *tr, string *str, IntArray *vnDisplayFormat = NULL, bool bSkipHidden = true, bool bSimpleTypesOnly = true, bool bCheckUseLabel = true, bool bIncludeParentNamePrefix = false, LPCSTR lpcszDoubleValueFormat = NULL,  bool bIncludeAuxDisplayInfo = false);
enum{		   
	TREE2STR_SKIP_HIDDEN						= 0x0001,	// not include hidden tree node 
	TREE2STR_SIMPLE_TYPE_ONLY					= 0x0002,	// middle variable, unmeaning for user
	TREE2STR_CHECK_USER_LABEL					= 0x0004,	// check if STR_LABEL_ATTRIB is present and use that instead of tagName in name=value dump
	TREE2STR_INCLUDE_PARENT_NAME_PREFIX			= 0x0008,	// show treenode with parent's name	
	TREE2STR_INCLUDE_AUX_DISPLAY_INFO			= 0x0010,	// show treenode with auxiliary display info
	TREE2STR_INCLUDE_COMBO_MAP_INFO				= 0x0020,	// show treenode with combo map info
	///Sophy 1/27/2010 TREE_TO_STR_SUPPORT_SPECIFY_SEPARATOR_FOR_NAME_AND_VALUE
	TREE2STR_USE_TAB_AS_SEPARATOR				= 0x0040,
	///end TREE_TO_STR_SUPPORT_SPECIFY_SEPARATOR_FOR_NAME_AND_VALUE
};
#define	TREE2STR_DEFAULT	TREE2STR_SKIP_HIDDEN | TREE2STR_SIMPLE_TYPE_ONLY | TREE2STR_CHECK_USER_LABEL

//Comments last updated by Iris 7/29/2008, added $
/**$	
*/
/// Hong 12/24/08 QA80-12798 v8.0990c THEME_COMPARE_NEED_DISPLAY_REF_VAL_IN_ATTRIB
//OC_API int octree_tree_to_str(TreeNode *tr, string *str, IntArray *vnDisplayFormat = NULL, DWORD dwCtrl = TREE2STR_DEFAULT, LPCSTR lpcszDoubleValueFormat = NULL);
OC_API int octree_tree_to_str(TreeNode *tr, string *str, IntArray *vnDisplayFormat = NULL, DWORD dwCtrl = TREE2STR_DEFAULT, LPCSTR lpcszDoubleValueFormat = NULL, 
							  StringArray* psaAttribs = NULL, bool bIncludeAttribsName = false);
/// end THEME_COMPARE_NEED_DISPLAY_REF_VAL_IN_ATTRIB
/// end MORE_OPTION_TO_DUMP_MAP_INFO_FOR_COMBO_NODE
/// end TREE_TO_STRING
/// end PARAM_MISS_DEFAULT_VALUE

/// TD 5-19-06 QA70-8579 OC_GENERAL_MECHANISM_TO_SAVE_XFNCTIONS_IN_ORIGIN_FILES
//Comments last updated by Iris 7/28/2008, added #
/**# >XFunction Attributes 
		Sets and gets local XFunction Attributes
	Parameters:
		lpcszName = name of the Xfunction
		dwAttribute = The Bit attributes to be set/removed
		bSet = When true the bit attributes in dwAttribute are set to the XFunction else they are removed
		nGenLocation = indecates the path where to look for the XFunctions, if(ORIGIN_PATH_UNDEF, default) looks for the first path in the standard prference order which has a function with that name 
	Return:
		returns non-zero if one of the bit attributes in dwAttribute was already set, FALSE otherwise
*/
OC_API bool okutil_xft_set_attribute(LPCSTR lpcszName, DWORD dwAttribute, BOOL bSet, int nGenLocation = ORIGIN_PATH_UNDEF);

//Comments last updated by Iris 7/28/2008, added #
/**# >XFunction Attributes 
		Sets and gets local XFunction Attributes
	Parameters:
		lpcszName = name of the Xfunction
		dwAttribute = The Bit attributes to be checked
		nGenLocation = indecates the path where to look for the XFunctions, if(ORIGIN_PATH_UNDEF, default) looks for the first path in the standard prference order which has a function with that name 
	Return:
		returns non-zero if one of the bit attributes in dwAttribute was already set, FALSE otherwise
*/
OC_API bool okutil_xft_get_attribute(LPCSTR lpcszName, DWORD dwAttribute, int nGenLocation = ORIGIN_PATH_UNDEF);
/// end OC_GENERAL_MECHANISM_TO_SAVE_XFNCTIONS_IN_ORIGIN_FILES

/**$
*/
//---- CPY 1/29/2008 QA70-10966 WIZARD_GETN_SAME_AS_SIMPLE_GETN
//OC_API int okutil_xft_get_event_type(TreeNode* ptrXF);
OC_API int okutil_xft_get_event_type(TreeNode* ptrXF, BOOL bCvtWizToSimpleGetN=true);
//----

/// TD 6-2-06 QA70-8708 CALLING_BEFORE_EXECUTE_EVENT
OC_API string okutil_xft_get_simple_event_name(int nSimpleEventIndex, string *pNameFunction);
/// end CALLING_BEFORE_EXECUTE_EVENT

OC_API int	okutil_get_Origin_file_comment(LPCSTR lpcszFile, string* pstrComment); ///DSC 8/4/06 QA70-8883 SAVE_TEMPLATE_FROM_ORIGINC

/// SY 2006-10-09 QA70-9037 v8.0495 SAVE_AS_DIALOG
enum {
	FDLG_SUPPRESS_WARNING_SAVE_TO_EXISTING     = 0x00010000,
	FDLG_FILENAME_BOX_READ_ONLY                = 0x00020000,
};
// Comments last updated by Army 07/27/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_FileDialog_(global_function)
*/
OC_API BOOL okutil_FileDialog(string *pstrOut, BOOL bSaveAs, StringArray *psaFileTypes = NULL, LPCSTR lpcszInitialDir = NULL, DWORD dwOptions = 0, HWND hWndParent = NULL, LPCSTR lpcszTitle = NULL);
/// end SAVE_AS_DIALOG

/// EJP 2006-10-24 v8.0500 QA70-8754 OC_LOAD_SAVE_PALETTE
OC_API int okutil_palette_save(LPCSTR lpcszFile, UINT nSize, BYTE* pr, BYTE* pg, BYTE* pb);
OC_API int okutil_palette_load(LPCSTR lpcszFile, IntArray* pRGB);
/// end OC_LOAD_SAVE_PALETTE

///DSC 1/22/07 QA70-3263 INTERNATIONAL_VERSION_CHANGING_LANGUAGE_DYNAMICALLY
#define MAX_NUM_LANGS_SUPPORTED		NUM_ORIGIN_LANGUAGE_TYPES_SUPPORTED
///DSC 2008-08-22 QA70-12980 8.0929 ADD_CHANGE_LANGUAGE_FOR_ALL_USERS_OPTION
// OC_API BOOL okutil_set_resource_lang(LPCSTR strNext, LPSTR lpszCurr=NULL, LPSTR lpszPrev=NULL);
//Comments last updated by Army 07/28/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_set_resource_lang_(global_function)
*/
OC_API BOOL okutil_set_resource_lang(LPCSTR strNext, LPSTR lpszCurr=NULL, LPSTR lpszPrev=NULL, BOOL * p_bAllUsers = NULL);
///end ADD_CHANGE_LANGUAGE_FOR_ALL_USERS_OPTION

//Comments last updated by Army 07/28/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_get_current_lang_(global_function)
*/
OC_API char okutil_get_current_lang();
OC_API long okutil_get_serial_number(LPSTR lpszSerialNumber, LPSTR lpszCustomerID, BOOL bCheckValid);


//Comments last updated by Iris 7/28/2008, added #
/**#
	Checks if a language is supported, and gives a list of languages supported by serial number.
	Parameters:
		lpcszLang = [input] can be NULL. Language to test.
		lpszValLangs = [output] can be NULL. Receives string representing all supported languages
				E for E serial number
				JE for J serial number
				GE for G serial number
				CE for C serial number
				EJGC for Evaluation Origin
		bGiveErrMsg = [input] not implemented
	Return:
		TRUE if lpcszLang is supported.
*/
OC_API BOOL okutil_is_language_supported(LPCSTR lpcszLang, LPSTR lpszValLangs = NULL, BOOL bGiveErrMsg = FALSE);
/// end INTERNATIONAL_VERSION_CHANGING_LANGUAGE_DYNAMICALLY

///DSC 5/23/07 QA70-8451 v8.0625 CREATE_80_EVALUATION_ATTRIBUTE_FOR_DEMO
//Comments last updated by Iris 7/28/2008, added #
/**#
	Check if Origin is running as Evaluation or Product.
	Return:
		TRUE if Origin is running as Evaluation.
*/
OC_API BOOL okutil_is_evaluation();
///end CREATE_80_EVALUATION_ATTRIBUTE_FOR_DEMO

/// YuI 03/27/07 PROPER_DISCONTIGUOS_SELECTION_INITIALIZATION
// OC_API this function from octree_utils
enum{
	TREE_COPY_SKIP_HIDDEN						= 0x0001, 
	TREE_COPY_ATTRIB_ENABLE						= 0x0002, 
	TREE_COPY_SKIP_NONDATAID					= 0x0004,
	TREE_COPY_BY_NAME_AND_ORDER					= 0x0008,
		// skip hidden and reset hidden should not be used together
	TREE_COPY_RESET_HIDDEN						= 0x0010,  //----- CPY 4/14/07 COPY_TREE_LOST_VALUE_ON_HIDDEN_NODES
	/// YuI 09/10/07 QA70-10358 ANOVA_RECALCULATE_FAILS_AFTER_RENAME
	TREE_COPY_BY_ORDER_ONLY						= 0x0020,
	/// end ANOVA_RECALCULATE_FAILS_AFTER_RENAME
	TREE_COPY_ATTRIB_AUTO						= 0x0040,		//------ Folger 11/28/07 ALLOW_COPY_AUTO_ATTRIBUTE
	/// YuI 01/14/08 QA70-10936 GET_RUNTIME_DESCRIPTION_TWEAK
	TREE_RESOVE_COMPOSITE_RANGE_STRUCTURE_CONFLICT	= 0x0080
	/// end GET_RUNTIME_DESCRIPTION_TWEAK
};

OC_API int octree_copy_values(TreeNode* ptrSrc, TreeNode* ptrDest, WORD wOptions = TREE_COPY_SKIP_HIDDEN | TREE_COPY_ATTRIB_ENABLE);
/// end PROPER_DISCONTIGUOS_SELECTION_INITIALIZATION


//------ CPY 3/16/2007 QA70-9473 NLFIT_NEEDS_FEEDBACK_TO_USER_AND_ESC_TO_ABORT_FITTING
//Comments last updated by Iris 7/28/2008, added $
/**$
	Start a message display on the lower right corner of the application space
	Parameters:
		lpcszMsg = [input] can be NULL and nLines >0 to initialize,NULL and nLines = 0 to terminate
		nLines = [input] usually 0, >0 to setup size of box (number of lines), if >1 will scroll upon each call with lpcszMsg none-NULL
	Return:
		< 0 for error codes
*/
OC_API int okutil_system_message(LPCSTR lpcszMsg, int nLines = 0);
//------


/// YuI 04/10/07 REVERTING_DATA_SELECTOR_TO_EXPANDED_OLD
/**$
*/
OC_API void okutil_destroy_data_markers(DataRange* pRange);
/// end REVERTING_DATA_SELECTOR_TO_EXPANDED_OLD

/// YuI 05/22/09 QA70-13659 NO_AUTOFILL_IF_EMBEDDINGS_IN_BEGIN_RANGE
/**$
*/
OC_API	DWORD	okutil_check_datarange_for_embedding_linking(DataRange* pRange);
/// end NO_AUTOFILL_IF_EMBEDDINGS_IN_BEGIN_RANGE

/// YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP
/**$
*/
/// YuI 02/10/09 QA70-13062 NEED_TO_KEEP_DATA_MARKERS_IF_NO_ANALYSIS_MARKERS_CREATED
//	OC_API void okutil_destroy_input_data_markers(TreeNode* pInputData);
OC_API void okutil_destroy_input_data_markers(TreeNode* pInputData, BOOL bCheckPresenceOfPlotUID = FALSE);
/// end NEED_TO_KEEP_DATA_MARKERS_IF_NO_ANALYSIS_MARKERS_CREATED

/**$
*/
OC_API void okutil_create_input_data_markers(TreeNode* pInputData);
/// end DATA_MARKERS_REVAMP

/// YuI 10/02/07 QA70-10468 CHANGE_PARAM_CANCEL_MESSES_UP_THE_DATA_MARKERS
/**$
*/
OC_API int okutil_push_data_markers_state_snapshot();

/**$
*/
OC_API int okutil_pop_data_markers_state_snapshot(BOOL bUpdate = TRUE);

/**$
*/
OC_API void okutil_flush_data_markers_state_cache();
/// end CHANGE_PARAM_CANCEL_MESSES_UP_THE_DATA_MARKERS

/// YuI 09/18/07 QA70-10331 REPORT_DATA_POLYRANGES_ARE_SCREWED_UP_AFTER_CHANGE_PARAM
/**$
*/
OC_API void okutil_on_change_operation_output_range(DataRange* pRangeOld, DataRange* pRangeNew);
/// end REPORT_DATA_POLYRANGES_ARE_SCREWED_UP_AFTER_CHANGE_PARAM

/**$
*/
OC_API BOOL okutil_get_even_spaced_x_from_str(LPCSTR lpcsz, double* pxFrom = NULL,  double* pxStep = NULL); //--------- CPY 4/17/07 QA70-9625 EVEN_SPACED_X_PLOL_DEFAULT_TO_USE_COL_SETTINGS. 

//----- CPY 6/15/07 QA70-9929 COLOR_1_OFFSET_FROM_DYNA_CNTRL
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_ocolor_LT_color_convert_(global_function)
*/
OC_API int okutil_ocolor_LT_color_convert(int nn, BOOL bOColorToLT);
//-----

///Sophy 6/3/2011 ORG-2950-P1 NEW_3D_OPENGL_LIGHTING_CONTROL_DLG
OC_API int okutil_convert_ocolor_to_RGB(OCOLOR oColor);
///end NEW_3D_OPENGL_LIGHTING_CONTROL_DLG

//---- CPY 8/7/2007 QA70-10111 COPY_USER_TO_GROUP_PATH_NEED_TO_KNOW_IF_COMPUTER_IS_GROUP
//Comments last updated by Army 07/27/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_is_group_server_(global_function)
*/
OC_API BOOL okutil_is_group_server(string* pstrServerGroupFolderPath=NULL, string* pstrGroupServerComputer = NULL, BOOL bForceRead = true, string* pstrServerGroupFolderLocalPath=NULL);

//---- CPY 9/2/2007 QA70-10324 GROUP_FOLDER_NEED_PROPER_ERR_CHECKING
enum {
	GSERR_ILLEGAL					= -30,

	GSERR_NOT_GROUP_SERVER = -20,
	GSERR_COPY_TO_SERVER_FAILED, // -19
	GSERR_USE_SRV_CPY_TO_SERVER_FAILED, //-18
	GSERR_USE_SRV_MAKE_DIR_ON_GROUP_FAILED, //-17

	GSERR_SERVER_LOCATION_INVALID = -15,
	GSERR_SERVER_INI_READ_FAILED,

	GSERR_PATH_NOT_UNC = -11,
	GSERR_LOCAL_UNC_CONVERT_FAILED, //-10
	GSERR_LOCAL_GROUP_NOT_WRITABLE,	 //-9
	GSERR_LOCAL_LOCATION_INVALID,	 //-8
	GSERR_LOCAL_INI_READ_FAILED,	 //-7
	GSERR_LOCAL_INI_SERVER_NOT_SET,	 //-6
	GSERR_LOCAL_INI_SERVER_DISABLED, //-5


};
//----

//Comments last updated by Army 07/27/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:okutil_set_group_server_(global_function)
*/
OC_API int okutil_set_group_server(LPCSTR lpcszPath, int bServer=0, LPCSTR lpcszLocalPath=NULL);

//Comments last updated by Iris 7/28/2008
/**# >System
	Return:
		1 if a valid group client with proper server path info
		0 if actually a server
		< 0 error codes like GSERR_SERVER_LOCATION_INVALID
*/
OC_API int okutil_is_group_client(string* pstrServerGroupFolderPath=NULL, BOOL bForceRead = true, BOOL bIgnoreDisable=false);

//Comments last updated by Iris 7/28/2008
/**# >System
	get the NetBIOS name of the local computer
	Parameters:
		strName = [output] string to receive computer name
*/
OC_API void okutil_get_computer_name(string* strName);

//Comments last updated by Iris 7/28/2008, added $
/**$
	get Origin path given file name and optionally file type
	This function will search the file from User path, then Group path and finally the EXE path.
	Parameters:
		pstrPath = [output] path that the file is found
		lpcszFileNameExt = [input] file name with extension, with or without subpath, like "origin.ini", "fitfunc\gauss.fdf"
		nFileType = [input] GLOBAL_TEMPLATE_PATH, GLOBAL_LOCALIZED_PATH etc, if GLOBAL_TEMPLATE_PATH is specified, will also look into
		language localization subfolder of the EXE path before trying the EXE path.
		If GLOBAL_LOCALIZED_PATH, will look directly in Localization\<Language Letter> folder, and skip User, Group and EXE folders.
		bCheckLocE = [input] if TRUE, and the search looks in the language localization folder, then also look in the English localization folder last.
	Return:
		true if file is found in one of the search locations
	Example1:
		void find_template_path()
		{
			string strPath;
			if(okutil_search_path_check_group(&strPath, "scatter.otp", GLOBAL_TEMPLATE_PATH))
				out_str(strPath);
		}
	Example2:
		void find_help_file()
		{
			string strPath;
			if(okutil_find_sys_path_with_file(&strPath, "Help\\QuickHelp.txt", GLOBAL_LOCALIZED_PATH, true))
				out_str(strPath);
		}
		
*/
OC_API BOOL okutil_find_sys_path_with_file(string* pstrPath, LPCSTR lpcszFileNameExt, int nFileType = 0, BOOL bCheckLocE = FALSE);

//Comments last updated by Iris 7/28/2008, added $
/**$
	get the localization special folder
*/
OC_API string okutil_get_language_path(BOOL bEnglishOnly = false);
//----

//------ Folger 09/11/07 CHECK_IF_SERVER_HAS_VALID_LICENSE
OC_API BOOL okutil_is_group_files_update_feature_permitted();
//------ End CHECK_IF_SERVER_HAS_VALID_LICENSE

//------ Folger 09/17/07 CENTRALIZE_GET_SET_GROUP_PATH
//---- CPY 9/22/2007 QA70-10384 CODE_CLEANUP
//OC_API BOOL okutil_set_server_group_path(LPCSTR lpcszGroupPath);
//------ Folger 09/19/07 COPY_ESSENTIAL_FILES_WHEN_NEEDED
//OC_API BOOL okutil_copy_essential_files();
//------ End COPY_ESSENTIAL_FILES_WHEN_NEEDED
// bCopyToGroupFolder = false, copy from EXE to UFF GroupShare
// bCopyToGroupFolder = true, then must be a group leader to copy from USF GroupShare to GroupFolder to prepare it for publishing
// return 0 if success, < 0 GSERR_NOT_GROUP_SERVER, etc for error
OC_API	int  okutil_copy_essential_files_upon_change_group_folder(BOOL bCopyToGroupFolder=false);
//---- end QA70-10384 CODE_CLEANUP
//------ End CENTRALIZE_GET_SET_GROUP_PATH
//------ Folger 09/18/07 CENTRALIZE_OPERATION_ON_GROUP_SERVER_INI
//---- CPY 10/16/07 QA70-10441-P6 GROUP_SERVER_SHOULD_BE_REMEMBER_IN_EXE_AS_WELL
//OC_API BOOL okutil_group_server_local_group_path_control(BOOL bGet = TRUE, LPSTR lpszLocalPath = NULL);
OC_API int okutil_check_update_uff_from_cached_group_server_info(LPCSTR lpcszClientPath);
//----
//------ End CENTRALIZE_OPERATION_ON_GROUP_SERVER_INI


/// ML 9/21/2007 RESOLVING_UNC_PATH_TO_LOCAL_PATH
/**$
		Resolves the passed UNC path into the local path, provided the UNC path points at the local machine.
	Parameters:
		pstrLocalPath=[output,optional]if lpcszUNC points at the local machine, it will receive the local path corresponding
								to lpcszUNC, otherwise it is set to empty string.
		lpcszUNC=[input]the UNC path to resolve.
	Example:
		void		test_UNC_to_local(string strUNC = "\\\\somecomputer\\someshare\\insideshare")
		{
			
			string			strLocal;
			int				nn = okutil_resolve_UNC_to_local_path(&strLocal, strUNC);
			printf("nn = %d\t%s\n", nn, strLocal);
		}
	Returns:
		> 0 if success and lpcszUNC poinst at the local machine, 0 if not local, < 0 if any of these errors:
					enum {
						UNCTOLOCERR_GENERAL				= -300,		// any other error	
						UNCTOLOCERR_BAD_UNC_PATH,					// the UNC path is bad
						UNCTOLOCERR_REGISTRY_ACCESS,				// failed registry access
					};
};

*/
OC_API int okutil_resolve_UNC_to_local_path(string *pstrLocalPath, LPCSTR lpcszUNC);
/// end RESOLVING_UNC_PATH_TO_LOCAL_PATH

//Comments last updated by Iris 7/28/2008, added $
/**$
	get the local user's Group Folder without doing any checking
*/
OC_API string okutil_get_user_group_path_no_check();

//------ Folger 09/27/07 SUPPORT_FORCE_DELTE_FILE_IF_READ_ONLY
OC_API BOOL okutil_delete_file(LPCTSTR lpcszFileName, BOOL bForceDelReadOnly = FALSE);
//------ End SUPPORT_FORCE_DELTE_FILE_IF_READ_ONLY




/// ML 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE
/**$
		It saves *pTr into the file with the name lpcszFileName inside the subfolder folder dbg of the user folder, provided
		dwBit ANDs nonzero with the integer value of the system variable lpcszSysVar. If lpcszSysVar is NULL, it assumes
		the name "DBG" (@DBG) for the system variable to test.
		It returns:
			> 0 if it saved.
			= 0	if saving not needed
			< 0	any error
		If pTr is NULL, it will only return the test (>0 or 0) without actual saving.
	Parameters:
		dwBit=[input]the bits to test in the system variable.
		lpcszSysVar=[optional]the system variable whose integra; value is used for testing. If NULL, use "DBG".
		pTr=[optional]
		lpcszFileName=[optional]the file name (with, possibly, relative path prepended) to use.
*/
OC_API	int	okutil_dbg_tree_save(DWORD dwBit, LPCSTR lpcszSysVar = NULL, TreeNode* pTr = NULL, LPCSTR lpcszFileName = NULL);
/// end DBG_TREES_IN_RELEASE

///---Sim 01-11-2008 ACCESS_NLFIT_REPORT_TREE
// must keep all key names be lower text
#define STR_NLFOPT_KEYNAME_VALUE				"p"
#define STR_NLFOPT_KEYNAME_DERIVED_VALUE		"dp"
#define STR_NLFOPT_KEYNAME_FIX					"f"
#define STR_NLFOPT_KEYNAME_SHARED				"s"
#define STR_NLFOPT_KEYNAME_ERROR				"e"
///------ Folger 08/12/2011 ORG-3510-S1 DERIVED_PARAM_ERROR_LT_ACCESS
#define STR_NLFOPT_KEYNAME_DERIVED_ERROR		"edp"
///------ End DERIVED_PARAM_ERROR_LT_ACCESS
#define STR_NLFOPT_KEYNAME_UCL					"u"
#define STR_NLFOPT_KEYNAME_LCL					"l"
#define STR_NLFOPT_KEYNAME_UB					"ub"
#define STR_NLFOPT_KEYNAME_LB					"lb"
///---Sim 05-21-2008 NLFIT_OP_LT_UPPER_LOWER_BOUND_ENABLE
#define STR_NLFOPT_KEYNAME_UBN					"ubon"
#define STR_NLFOPT_KEYNAME_LBN					"lbon"
#define STR_NLFOPT_KEYNAME_UBX					"ubx"
#define STR_NLFOPT_KEYNAME_LBX					"lbx"
///---END NLFIT_OP_LT_UPPER_LOWER_BOUND_ENABLE
#define STR_NLFOPT_KEYNAME_CONF_INTERVAL		"c"
#define STR_NLFOPT_KEYNAME_DEPENDENCY			"d"
#define STR_NLFOPT_KEYNAME_T_VALUE				"t"
#define STR_NLFOPT_KEYNAME_PROB					"prob"
#define STR_NLFOPT_KEYNAME_NAME1				"n"
#define STR_NLFOPT_KEYNAME_NAME2				"names"

//------ Folger 01/31/08 QA80-10929 USE_PARAMETER_NAMES_WHEN_LIST_LABTALK_TREE
#define STR_NLFOPT_KEYNAME_DERIVED_NAME			"ndp"
//------

#define STR_NLFOPT_KEYNAME_REDUCED_CHI_SQ		"chisqr"
#define STR_NLFOPT_KEYNAME_RMSE					"rmse"
#define STR_NLFOPT_KEYNAME_R_SQ_COD				"cod"
#define STR_NLFOPT_KEYNAME_R_VALUE1				"cor"
#define STR_NLFOPT_KEYNAME_R_VALUE2				"r"
#define STR_NLFOPT_KEYNAME_DOF					"dof"
#define STR_NLFOPT_KEYNAME_NUM_ITER				"niter"
#define STR_NLFOPT_KEYNAME_NPOINTS				"pts"
#define STR_NLFOPT_KEYNAME_SSR					"ssr"
#define STR_NLFOPT_KEYNAME_ADJ_R_SQ				"adjr"

#define STR_NLFOPT_KEYNAME_X					"x"
#define STR_NLFOPT_KEYNAME_Y					"y"
#define STR_NLFOPT_KEYNAME_W					"w"

#define STR_NLFOPT_KEYNAME_MODEL				"func"
///---Sim 08-14-2008 QA80-12017 ADD_NUMBER_PARA_INFO_ON_NLFIT_RESULT_LT_TREE
#define STR_NLFOPT_KEYNAME_NUM_FUNC_PARAM		"nfuncparams"
#define STR_NLFOPT_KEYNAME_NUM_DER_PARAM		"nderivparams"
#define STR_NLFOPT_KEYNAME_NUM_DATASET			"nsets"
///---END QA80-12017 ADD_NUMBER_PARA_INFO_ON_NLFIT_RESULT_LT_TREE
//------ Folger 02/13/08 QA80-10929 ACCESS_FIT_STATUS_FROM_LT_TREE
#define STR_NLFOPT_KEYNAME_FIT_STATUS			"fitstatus"
//------
///---Sim 05-22-2008 NLFIT_OP_LT_NUM_REPLICA
#define STR_NLFOPT_KEYNAME_NUM_REPLICA			"replica"
///---END NLFIT_OP_LT_NUM_REPLICA

///---Sim 03-15-2008 MORE_ACCESS_NLFIT_REPORT_TREE
#define STR_NLFOPT_KEYNAME_CONF_CURVER			"confc"
#define STR_NLFOPT_KEYNAME_CONF_PARAM			"confp"
#define STR_NLFOPT_KEYNAME_CONSTR				"constr"
#define STR_NLFOPT_KEYNAME_CONSTR_ENABLE		"constraints"
#define STR_NLFOPT_KEYNAME_MAX_ITER				"maxiter"
#define STR_NLFOPT_KEYNAME_TOLERANCE			"tolerance"
///---END MORE_ACCESS_NLFIT_REPORT_TREE

/// Hong 11/30/09 QA80-14738 ADD_COVARIANCE_CORRELATION_MATRIX_INFO_TO_NLFIT_RES_LT_TREE
#ifdef		__LT_TREE_VECTOR_ALLOW_CELL_ACCESS_BY_INDEX__
#define STR_NLFOPT_KEYNAME_COVARIANCE			"covar"
#define STR_NLFOPT_KEYNAME_CORRELATION			"corr"
#endif		//__LT_TREE_VECTOR_ALLOW_CELL_ACCESS_BY_INDEX__
/// end ADD_COVARIANCE_CORRELATION_MATRIX_INFO_TO_NLFIT_RES_LT_TREE


/**$
// lpCmd = "p1" etc
// lpArg = sub node, NULL if no subnode
// lpValue = double* if EGO_SET_VALUE, GET_VALUE, char* size of at leaset MAXLINE for EGO_GET_STR, SET_STR
// msg = EGO_SET_VALUE etc
*/
//OC_API int okutil_calc_tree_access(TreeNode* ptrCalc, LPSTR lpCmd, LPSTR lpArg, LPREAL8 lpValue, WORD msg);

/**$
*/
//OC_API int okutil_calc_tree_access_numeric(TreeNode* ptrCalc, LPCSTR lpczVar, double *pdValue, BOOL bGet = TRUE);
/**$
*/
//OC_API int okutil_calc_tree_access_string(TreeNode* ptrCalc, LPCSTR lpczVar, string *pstrValue, BOOL bGet = TRUE);

//------ Folger 01/30/08 QA80-10929 DWORD_OPTION_FOR_OPERATION_TREE_ACCESS
enum
{
	NLFIT_PARAMS_CHECK_SHOW					= 0x00000001,
	NLFIT_ACCESS_CALC_ONLY					= 0x00000002,
	NLFIT_GET_VAR_NUM_OVER_ALL_DATASETS		= 0x00000004,
	//------ Folger 02/19/08 QA80-10929 OPTIONAL_DWORD_TO_DISPLAY_KEY_AND_NAME
	NLFIT_DISPLAY_NODE_KEY					= 0x00000008,
	NLFIT_DISPLAY_NODE_NAME					= 0x00000010,
	//------
	///---Sim 03-15-2008 MORE_ACCESS_NLFIT_REPORT_TREE
	NLFIT_ACCESS_NO_GUIDATA					= 0x00000020,
	///---END MORE_ACCESS_NLFIT_REPORT_TREE
	///---Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS
	NLFIT_DISPLAY_NO_PARAMS					= 0x00000040,
	///---END NLFIT_LABTALK_TREE_ACCESS
};
//------

///---Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS
/**$
	return
	 -1, failed
	 0, success to read
	 1, success to write
*/
OC_API int okutil_operation_tree_access(TreeNode* ptrOp, LPSTR lpVar, LPSTR lpArg, LPVOID lpValue, WORD msg, DWORD dwOption = 0);
///---END NLFIT_LABTALK_TREE_ACCESS
/**$
*/
//OC_API int okutil_operation_tree_access_int(TreeNode* ptrOp, LPCSTR lpczVar, int *pnValue, BOOL bGet = TRUE);
/**$
*/
OC_API int okutil_operation_tree_access_numeric(TreeNode* ptrOp, LPCSTR lpczVar, double *pdValue, BOOL bGet = TRUE, DWORD dwOption = 0);
/**$
*/
OC_API int okutil_operation_tree_access_string(TreeNode* ptrOp, LPCSTR lpczVar, string *pstrValue, BOOL bGet = TRUE, DWORD dwOption = 0);
/**$
*/
//------ Folger 01/28/08 QA80-10929 EXPOSE_CONVERT_OPERATION_TREE_TO_LABTALK_TREE
/// ML 1/30/2008 QA70-10929 NLFIT_CONVERTING_INPUT_DATA_OPER_TREE_TO_LT_TREE
//OC_API	BOOL	okutil_operation_tree_to_labtalk_tree(TreeNode *ptrOp, TreeNode *ptrLT, DWORD dwOption = 0);
OC_API	BOOL	okutil_operation_tree_to_labtalk_tree(TreeNode *ptrOp, TreeNode *ptrLT, DWORD dwOption = 0, DWORD dwOperUID = 0);
/// end NLFIT_CONVERTING_INPUT_DATA_OPER_TREE_TO_LT_TREE
//------

enum{
	NLFIT_RT_PARAMS = 1,
	NLFIT_RT_DERIVED_PARAMS,
	NLFIT_RT_STATS,
	NLFIT_RT_DATASETS,
	NLFIT_RT_INPUT_DATASET_X,
	NLFIT_RT_INPUT_DATASET_Y,
	NLFIT_RT_INPUT_DATASET_W,
	NLFIT_RT_NOTES,
	///---Sim 03-15-2008 MORE_ACCESS_NLFIT_REPORT_TREE
	NLFIT_RT_GUIDATA,
	///---Sim 03-15-2008 MORE_ACCESS_NLFIT_REPORT_TREE
	/// Hong 11/30/09 QA80-14738 ADD_COVARIANCE_CORRELATION_MATRIX_INFO_TO_NLFIT_RES_LT_TREE
#ifdef		__LT_TREE_VECTOR_ALLOW_CELL_ACCESS_BY_INDEX__
	NLFIT_RT_COVARIANCE,
	NLFIT_RT_CORRELATION,
#endif		//__LT_TREE_VECTOR_ALLOW_CELL_ACCESS_BY_INDEX__
	/// end ADD_COVARIANCE_CORRELATION_MATRIX_INFO_TO_NLFIT_RES_LT_TREE
};
/**$
	nType = NLFIT_RT_PARAMS, NLFIT_RT_INPUT_DATASET, etc.
*/
//OC_API int okutil_get_calc_tree_number(TreeNode* ptrCalc, int nType);

/**$
	nType = NLFIT_RT_PARAMS, NLFIT_RT_INPUT_DATASET, etc.
*/
OC_API int okutil_get_operation_tree_number(TreeNode* ptrOp, int nType, DWORD dwOption = 0);
///---END 01-11-2008 ACCESS_NLFIT_REPORT_TREE

//------ Folger 01/15/08 OKUTIL_GET_ORIGIN75_PATH
OC_API	BOOL	okutil_get_origin75_path(string *pstr, BOOL bUserPath = true);
//------

/// Hong 01/18/08 QA80-10929 ADD_LT_NLFIT_MECHANISM
OC_API	BOOL	okutil_access_LT_tree_variable(LPCSTR lpcszVarName, TreeNode* ptrLTVar, BOOL bGet = true);
/// end ADD_LT_NLFIT_MECHANISM

/// TD 1-22-2008 QA80-10876 OLOCALIZED_MESSAGEBOX_API
OC_API	int	okutil_MessageBox(HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType);
/// end OLOCALIZED_MESSAGEBOX_API

//------ Folger 02/15/08 QA80-11007 MOVE_EXPORT_GRAPH_MAKE_TREE_TO_VC
OC_API	int	okutil_export_graph_construct_tree(TreeNode *ptr, LPCSTR lpcszVarName, int nPageType);
//------

/// TD CP 08-02-2012 ORG-6022-S1 WAIT_FOR_PAINT_MESSAGE
OC_API	int	okutil_wait_for_message(HWND hWnd, UINT messageFirst, UINT messageLast, BOOL bExitOnEmptyQueue = TRUE, int nTimeOutMilliSecs = -1);
/// end WAIT_FOR_PAINT_MESSAGE

/// TD CP ML 09/06/2012 ORG-2753 TRANSLUCENT_DHTML_MESSAGE_CONTROL
OC_API int		okutil_WinFadeIn(HWND hWnd, int nTimeOut = 3000, BOOL bTrimNonClientArea = TRUE, int nMaxOpacity = 255, int nHalfTimeIn = -1, int nHalfTimeOut = -1);
/// end TRANSLUCENT_DHTML_MESSAGE_CONTROL

//------ Folger 03/14/08 QA80-11192 MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC

#define THEME_TREE_SETTINGS		"Settings"

enum
{
	THEME_DEFAULT_GET,
	THEME_DEFAULT_SET,
	THEME_DEFAULT_RESET,
};
OC_API	BOOL	okutil_access_default_theme(LPCSTR lpcszClassOption, TreeNode *ptrTheme, int nOption = THEME_DEFAULT_GET);
//------

///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
enum
{
	THEME_FOLDER_LAST_USED_GET,
	THEME_FOLDER_LAST_USED_SET,
	THEME_FOLDER_LAST_USED_REMOVE,
};
OC_API	int	okutil_access_folder_last_used_theme(LPCSTR lpcszClassOption, TreeNode *ptrTheme, int nOption = THEME_FOLDER_LAST_USED_GET);
///------ End SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS

//------- CPY 4/19/08 QA80-11197 REMINDER_MSG_BOX_YES_NO_CANCEL_CLEANUP
OC_API int okutil_reminder_msg_box(int nResID, int nOptn, BOOL bTestOnly = false);
//-------

//------ Folger 07/22/08 QA80-11874 SUPPORT_MERGE_UFF_INI_FROM_SYSTEM_INI
OC_API	BOOL	okutil_merge_INI_files(LPCTSTR lpcszTarget, LPCTSTR lpcszSource, BOOL bCreateTarget = FALSE);
//------

///Sophy 12/18/2008 MOVE_CONVERT_STRINGVECTORY_TO_DOUBLEVECTOR_FROM_OC_TO_VC
///------ Folger 01/24/2011 ORG-2026 SUPPORT_GROUPING_COLUMN_SOURCE_THAT_LESS_THAN_THRESHOLD
//OC_API	int okutil_convert_str_vec_to_num_vec(StringArray* saText, DoubleArray* daNumber);
OC_API	int okutil_convert_str_vec_to_num_vec(StringArray* saText, DoubleArray* daNumber, BOOL* pbAllNumeric = NULL);
///------ End SUPPORT_GROUPING_COLUMN_SOURCE_THAT_LESS_THAN_THRESHOLD
///end MOVE_CONVERT_STRINGVECTORY_TO_DOUBLEVECTOR_FROM_OC_TO_VC											 
/// TD 02-16-2009 QA80-13103 OC_ACCESS_TO_TOOLBARS
OC_API BOOL okutil_add_button_group(LPCSTR lpcszGroupName, LPCSTR lpcsziniFile);
/// end OC_ACCESS_TO_TOOLBARS

///------ Folger 03/24/09 QA80-13331-P1 CUSTOMIZED_OUTPUT_COLUMN_LONGNAME_FORMAT_SUPPORT
OC_API	BOOL	okutil_check_convert_output_col_longname(string* pstr, LPCSTR lpcszOutputObjRange);
///------ End CUSTOMIZED_OUTPUT_COLUMN_LONGNAME_FORMAT_SUPPORT
/// TD 02-16-2009 QA80-13103 OC_ACCESS_TO_TOOLBARS
OC_API BOOL okutil_add_button_group(LPCSTR lpcszGroupName, LPCSTR lpcsziniFile);
/// end OC_ACCESS_TO_TOOLBARS

///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
OC_API	int	okutil_get_group_names(StringArray* psaGroups);
OC_API	BOOL	okutil_get_group_files(LPCSTR lpcszGroup, StringArray* psaFiles);
///end TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
///---Sim 05-20-2009 QA80-13612 MOVE_TEMPLATE_UTILS_FROM_OC_TO_VC
OC_API int okutil_template_get_origin_path_type(LPCSTR lpcszFilePath, BOOL bPreferUser = TRUE);
OC_API BOOL okutil_add_template_node(TreeNode* ptrNode, TreeNode* ptrParent, LPCSTR lpcszTempName, LPCSTR lpcszFileName);
///---END QA80-13612 MOVE_TEMPLATE_UTILS_FROM_OC_TO_VC

/// EJP 2009-05-20 QA80-13612 ADD_TEMPLATE_TO_LIBRARY_ON_DRAG_DROP
enum {
	ERR_TEMPL_MISSING_ARG = 1,
	ERR_TEMPL_LOAD_FILE,
	ERR_TEMPL_SAVE_FILE,
	ERR_TEMPL_FILE_NAME,
	ERR_TEMPL_FILE_EXTENSION,
	ERR_TEMPL_MISSING_NODE,
	ERR_TEMPL_ADD_TYPE_NODE,
	ERR_TEMPL_ADD_CATEGORY_NODE,
	ERR_TEMPL_ADD_TEMPLATE_NODE,
	ERR_TEMPL_TYPE_NODE_NOT_FOUND,
	ERR_TEMPL_CATEGORY_NODE_NOT_FOUND,
	ERR_TEMPL_SET_CATEGORY_NODE_PROPERTY,
	ERR_TEMPL_SET_TEMPL_NODE_PROPERTY,
};
// The following function return zero or one of the above error values.
OC_API int okutil_get_templ_type_node(TreeNode* trType, TreeNode* trLib, LPCSTR lpcszFileExt, BOOL bCreate = TRUE);
OC_API int okutil_get_templ_category_node(TreeNode* trCategory, TreeNode* trType, LPCSTR lpcszCategoryName = NULL, BOOL bCreate = TRUE);
OC_API int okutil_add_templ_node(TreeNode* trTempl, TreeNode* trCategory, LPCSTR lpcszFileName, LPCSTR lpcszTemplName = NULL);
OC_API int okutil_install_template_file(LPCSTR lpcszFileName, LPCSTR lpcszTemplName = NULL);
/// end ADD_TEMPLATE_TO_LIBRARY_ON_DRAG_DROP

/// YuI 07/09/09 QA70-13915 PROPER_SUPPORT_FOR_OUTPUT_MULTIDATA_XYRANGE
OC_API BOOL okutil_prepare_multiXY_output_tree(TreeNode* ptrOutput, TreeNode* ptrInput, DWORD dwCntrl);
/// end PROPER_SUPPORT_FOR_OUTPUT_MULTIDATA_XYRANGE

///------ Folger 07/23/09 QA80-13420-P2 XF_BASED_PLOTTING_NEEDS_GETN_TREE_AND_AUTO_UPDATE_SUPPORT
OC_API	BOOL	okutil_last_evaluated_getn_access(TreeNode* ptrGetN, BOOL bGet = TRUE);
///------ End XF_BASED_PLOTTING_NEEDS_GETN_TREE_AND_AUTO_UPDATE_SUPPORT

/// Hong 08/24/09 QA80-11920 IMP_CSV_SUPPORT_AUTO_DETECTED_SEPARATOR_BY_DEFAULT
/**$
	Get windows or orgin numeric format
	Parameter:
		bWindows = [input] get windows or origin numeric format
	Return:
		return value NF_IS_*.
*/
OC_API	int	okutil_get_numeric_format(BOOL bWindows = false);
/// end IMP_CSV_SUPPORT_AUTO_DETECTED_SEPARATOR_BY_DEFAULT

///------ Folger 08/25/09 QA80-14087-P10 NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
OC_API	void	okutil_enable_origin_gui(BOOL bOn);
///------ End NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
///------ Folger 09/24/2012 ORG-6255-P6 NOT_ALLOW_WKS_MENU_IF_GUI_DISABLED
OC_API	BOOL	okutil_is_origin_gui_enabled();
///------ End NOT_ALLOW_WKS_MENU_IF_GUI_DISABLED

///------ Folger 08/27/09 QA80-14215 CHANGE_USER_FILES_FOLDER_IN_ORIGIN
enum
{
	UFF_CHANGE_REGISTRY_GET			= 0,
	UFF_CHANGE_REGISTRY_SET,
	UFF_CHANGE_REGISTRY_REMOVE,
};
OC_API	BOOL	okutil_uff_changed_registry_access(int nCtrnl, DWORD* pdwValue = NULL);
///------ End CHANGE_USER_FILES_FOLDER_IN_ORIGIN

///Kyle 09/18/2009 QA80-14216 SUPPORT_OPENING_SYSTEM_EXPLORER_FROM_OC

/**$
	Open windows Explorer
	Parameter:
		lpcszPath = [input] path to open, will highlight the file if it's a full path file name
	Return:
		return value OPEN_OS_EXPLORER_*.
*/
enum
{
	OPEN_OS_EXPLORER_NO_ERROR			= 0,
	OPEN_OS_EXPLORER_INVALID_PATH,
	OPEN_OS_EXPLORER_API_FAIL,
};

OC_API	int		okutil_open_os_explorer(LPCSTR lpcszPath);
///End SUPPORT_OPENING_SYSTEM_EXPLORER_FROM_OC
/// YuI 09/21/09 QA70-14346_P3 ANNOTATION_SCREWED_UP_IF_TERNARY_IS_SCALED
OC_API	BOOL	okutil_normalize_ternary_coordinates(double* pX, double* pY, double* pZ);
/// end ANNOTATION_SCREWED_UP_IF_TERNARY_IS_SCALED
//------

/// Kenny 09/27/2009 QA81-14241 INSERT_PARAM_NEED_CORRECT_INDICES_AND_CENTRALIZE_CODES
OC_API	int		okutil_cvt_col_label_type_to_char(int nType, int* lpnOffset = NULL);

OC_API	int		okutil_cvt_col_label_char_to_type(int nChar);
/// End QA81-14241 INSERT_PARAM_NEED_CORRECT_INDICES_AND_CENTRALIZE_CODES

///Kyle 10/10/2009 QA80-14187 REPORT_TREE_COPY_PROPERTY_FROM_SOURCE_COLUMN
enum
{
	SRC_COL_PROPERTY_FORMAT		= 0x00000001,
	SRC_COL_PROPERTY_LABELS		= 0x00000002,			///Kyle 10/29/2009 QA80-14187-P1 SUPPORT_COPY_LABELS_FROM_A_SOURCE_COLUMN
};
OC_API	BOOL	okutil_source_column_property(TreeNode* trCol, int* pnColUID, DWORD* pdwCntrl, BOOL bGet = TRUE);
///End REPORT_TREE_COPY_PROPERTY_FROM_SOURCE_COLUMN

///Kyle 10/20/2009 QA80-14475-P4 VC_CONSTRUCT_ORDER_TO_REORDER_WKS
/**$
	construct a order to reorder a vector into two separate groups by pushing some elements to the end
	Parameter:
		pvnOrder = [output] new order
		nTotal = [input] total elements in a queue
		nPush = [input] the block size to push
		nSkip = [input] elements to skip after pushing nPush elements
		nR1 = [input] The first element to be pushed
		nR2 = [input] The last element to be pushed, -1 means the last one in the queue
	Return:
		a negative integer for error; otherwise the number being pushed to the end
*/
OC_API	int		okutil_reorder_push_skip(UIntArray *pvnOrder, int nTotal, int nPush, int nSkip, int nR1 = 0, int nR2 = -1);
///End VC_CONSTRUCT_ORDER_TO_REORDER_WKS

///------ Folger 09/21/09 QA80-14283 GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH
enum
{
	DIALOGEVENTSPECIALBITSOPTIONS_SET			= 0,
	DIALOGEVENTSPECIALBITSOPTIONS_REMOVE,
	DIALOGEVENTSPECIALBITSOPTIONS_REMOVEALL,
	DIALOGEVENTSPECIALBITSOPTIONS_QUERY,
};

enum
{
	DIALOGEVENTSPECIALBITS_GRIDATTACH					= 0x00000001,
	DIALOGEVENTSPECIALBITS_ACTIVE_FRAME_CHANGE			= 0x00000002,	//function/class that set this bit is responsible to clear it
	DIALOGEVENTSPECIALBITS_SELECTION_CHANGE				= 0x00000004,	//function/class that set this bit is responsible to clear it
	DIALOGEVENTSPECIALBITS_DATASET_CHANGE				= 0x00000008,	///Jasmine 07/11/2012 ORG-6076-P4 BLOCK_EVENT_WHEN_IN_HUNT_MODE
	
	DIALOGEVENTSPECIALBITS_FRAME_CHANGE_TEMPORARY		= 0x00000010,	//code that detects this bit is responsible to clear it
	DIALOGEVENTSPECIALBITS_SELECTION_CHANGE_TEMPORARY	= 0x00000020,	//code that detects this bit is responsible to clear it.
	DIALOGEVENTSPECIALBITS_DATASET_CHANGE_TEMPORARY		= 0x00000040,	///Jasmine 07/11/2012 ORG-6076-P4 BLOCK_EVENT_WHEN_IN_HUNT_MODE
};
OC_API	int		okutil_dialog_event_special_bits_access(int nOption, DWORD dwBit = 0);
///------ End GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH

///Kyle 12/29/2009 QA80-14832 QUICKFIT_OC_DETECT_IF_PLOT_VALID_FOR_ANALYSIS
///Sophy 5/14/2012 ORG-5039-P2 XYZ_3D_BAR_ON_OPENGL_GRAPH_FAIL_TO_BE_AS_SELECTION_INPUT
//OC_API	BOOL	okutil_is_good_plot_type_for_analysis(int nPlotID, BOOL bNonXYZ = TRUE, BOOL bXYZ = TRUE);
OC_API	BOOL	okutil_is_good_plot_type_for_analysis(int nPlotID, BOOL bNonXYZ = TRUE, BOOL bXYZ = TRUE, BOOL bOpenGLLayer = FALSE);
///end XYZ_3D_BAR_ON_OPENGL_GRAPH_FAIL_TO_BE_AS_SELECTION_INPUT
///End QUICKFIT_OC_DETECT_IF_PLOT_VALID_FOR_ANALYSIS

///Sophy 1/7/2010 ROI_QUICK_FIT_BUTTON_TO_SUPPORT_CHANGE_FIT_FUNCTION
OC_API	int		okutil_get_favor_nlsf_functions(StringArray* psa);
///end ROI_QUICK_FIT_BUTTON_TO_SUPPORT_CHANGE_FIT_FUNCTION

///------ Folger 01/25/10 QA81-15036 SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
#define		NUM_CHARS_THEME_WITH_ORDER_PREFIX		3
#define		IS_THEME_WITH_ORDER(_lpcszTheme)		(lstrlen(_lpcszTheme) > NUM_CHARS_THEME_WITH_ORDER_PREFIX && '@' == _lpcszTheme[0] && ' ' == _lpcszTheme[2])
#define		THEME_ORDER_CHAR(_lpcszTheme)			(IS_THEME_WITH_ORDER(_lpcszTheme) ? _lpcszTheme[1] : -1)

enum
{
	THEME_ORDER_CATEGORY_INVALID		= 0,
	THEME_ORDER_CATEGORY_NUMERIC,
	THEME_ORDER_CATEGORY_ALPHA_UPPER,
	THEME_ORDER_CATEGORY_ALPHA_LOWER,
};
OC_API	int		okutil_prepare_theme_display_names(StringArray* psaThemes, IntArray* piaCategories = NULL, BOOL bExpandAmpersand = FALSE);

///Sophy 3/2/2012 ORG-5161-P1 THEME_NAME_WITH_AMP_TRIMED_ON_DYNA_DLG_POPUPMENU
OC_API	int		okutil_ampersand_string_for_display(string* pStr, BOOL bExpand = TRUE); //true for expand, else for shrink.
///end THEME_NAME_WITH_AMP_TRIMED_ON_DYNA_DLG_POPUPMENU
///------ End SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER

/// Hong 02/02/10 QA80-14801 FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
/**$
		LabTalk substitution processing
	Parameter:
		pstr = [modified] string to be substituted
		lpcszPageLayerContext = [input] optional page layer context to be used for the substition, can be in [Book]Sheet form, or just window short name
		cntrl = [input] additional options, should set to 0 for now
	Return:
		0 if success, or < 0 error code
	Example:
	// run this when Graph1 is not the active window and it will still properly substitude
	// various LT substitution notations
	void tt(string strRange = "Graph1")
	{
		string str = "%H: %(1), %(page.longname$)";
		
		int ii = okutil_arg_copy(&str, strRange);
		
		if(0==ii)
			printf("%s\n", str);
		else
			out_int("Err = ", ii);
	}
		
*/
OC_API	int		okutil_arg_copy(string* pstr, LPCSTR lpcszPageLayerContext=NULL, USHORT cntrl=0);
/// end FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION

///Kyle 02/26/2010 QA80-15138 KEEP_MENU_TAG_FOR_HIDE_BUILT_IN_MENU_LIST_TO_INDICATE_THE_POPUP_INDICES_IN_OMC
OC_API	BOOL	okutil_omc_convert_hide_list_from_81_sr1(int nWndType, LPCSTR lpcszSrcList, string* pstrDestList);

OC_API	int		okutil_omc_get_current_version();
///End KEEP_MENU_TAG_FOR_HIDE_BUILT_IN_MENU_LIST_TO_INDICATE_THE_POPUP_INDICES_IN_OMC

///------ Folger 04/13/10 QA81-15309 OC_POST_ORIGIN_MESSAGE_SUPPORT
OC_API	BOOL	okutil_post_origin_message(UINT nEvent, UINT wParam = 0, UINT lParam = 0);
///------ End OC_POST_ORIGIN_MESSAGE_SUPPORT

/// TD ML 04-13-2010 QA85-15312 ICON_OVERLAYS_IN_GRIDCONTROL
OC_API  HICON 	okutil_CreateOvelayedIcon(HICON hIconBase, HICON hIconOverLay, int nSize, int nDx = 0, int nDy = 0);
/// end ICON_OVERLAYS_IN_GRIDCONTROL

///------ Folger 04/27/10 QA81-15361 PROPER_TRIMMING_AMPERSAND_FOR_XF_VAR_COMBO_THAT_MAKES_MENU_ITEMS
#define		STR_OPTION_ARG_VAR_ATTRIB		"OptionArgVar"
OC_API	BOOL	okutil_update_str_remove_empersand(string* pstrCombo);
///------ End PROPER_TRIMMING_AMPERSAND_FOR_XF_VAR_COMBO_THAT_MAKES_MENU_ITEMS

///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
OC_API	BOOL	okutil_is_virtual_matrix(LPCSTR lpcszSeriesName);
OC_API	string	okutil_get_virtual_matrix_long_name(LPCSTR lpcszSeriesName);
///end PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG

///Sophy 9/21/2010 ORG-441 FAST_DECODE_BASE64_STRING_INTO_NUMERIC_ARRAY_FOR_MZXML_FILE
/**$
		This function decode a base64-encoded string
	Parameters:
		lpcszSrc = [input] source string containing base64-encoded characters.
		lpszDst = [output] output string containing decoded result.
	Returns:
		Returns the number of bytes in the output string.

*/
OC_API	int		okutil_decode_base64(LPCSTR lpcszSrc, LPSTR lpszDst);
/**$
		This function convert a raw buffer data to numeric items
	Parameters:
		pSrc = [input] buffer that contains raw data.
		nType = [input] the datatype of items wanted, e.g FSI_DOUBLE, FSI_LONG etc.
		nSize = [input] the number of items in pSrc.
		parrDoubles = [input] output vector that contains all data items.
		bLittleEndian = [input] whether the values are arrranged in little-endian order.
*/
OC_API	int		okutil_buffer_to_vector(LPVOID pSrc, int nType, int nSize, DoubleArray* parrDoubles, BOOL bLittleEndian = TRUE);
/**$
		This function convert a raw buffer data to 2 vectors, with options whether to do more conversion, only used in omzXML.h
		I move it to VC level just to speed up the conversion, so should never be documented.
*/
OC_API	int		okutil_buffer_to_vectors(LPVOID pSrc, int nType, int nSize, DoubleArray* parrDoubleMZ, DoubleArray* parrDoubleIntens, BOOL bLittleEndian = TRUE, BOOL bIntPairs = FALSE);
///end FAST_DECODE_BASE64_STRING_INTO_NUMERIC_ARRAY_FOR_MZXML_FILE


///Sophy 9/26/2010 ORG-1142 ADO_IMPORT_SHOULD_ALLOW_SET_COL_FORMAT_FOR_DATE_FIELD
/**$
		This function will get the list of customer date format	from Orgin.ini, if not exist, will return a default list for date format.
*/
OC_API	int		okutil_get_custom_date_format_list(StringArray* psaList);
/**$
		This function will update the item into customer date format list.
		Return 0 on successful, return minus value for error, return positive value when no need to update the list.
*/
OC_API	int		okutil_update_custom_date_last_used(LPCSTR lpcszFormat);
///end ADO_IMPORT_SHOULD_ALLOW_SET_COL_FORMAT_FOR_DATE_FIELD

///-----Kit 11/15/2010 ORG-1488-S1 MAKE_TIME_FORMAT_SIMILAR_TO_DATE_FORMAT
OC_API	int		okutil_get_custom_time_format_list( StringArray* psaList );

OC_API	int		okutil_update_custom_time_last_used( LPCTSTR lpcszFormat );
///-----End MAKE_TIME_FORMAT_SIMILAR_TO_DATE_FORMAT

///Kyle 10/18/2010 ORG-1253-S1 REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN
OC_API	int		okutil_get_installed_origins(DoubleArray* parrVersions, StringArray* psaVersionKeys, StringArray* psaSysFolders = NULL, StringArray* psaUFFs = NULL, DWORD dwCtrl = GETINSTALLEDORG_SORT_BY_VERSION);

OC_API	BOOL	okutil_transfer_user_files_status(BOOL* pbTransferred, BOOL bGet = TRUE);
///End REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN

///------ Folger 10/22/2010 ORG-1316-P1 REPORT_GENERATED_BY_NLEND_FAILED_TO_DISPLAY_CORRECT_USED_DEFINED_FUNCTION_NAME
OC_API	int		okutil_remove_origin_path_keywords(StringArray* parr);
///------ End REPORT_GENERATED_BY_NLEND_FAILED_TO_DISPLAY_CORRECT_USED_DEFINED_FUNCTION_NAME

///Sophy 10/25/2010 ORG-1296 MOVE_BUILDDBTREE_TO_VC_FOR_SPEEDUP_NEW_DATABASEIMPORT_DLG
/**#
*/
OC_API	int		okutil_build_tablelist_from_connection(LPCSTR lpcszConn, TreeNode* ptrTableList);
/**#
*/
OC_API	int		okutil_build_table_fields(LPCSTR lpcszConn, int* tt, LPCSTR lpcszTableName, TreeNode* ptrTableList);
///end MOVE_BUILDDBTREE_TO_VC_FOR_SPEEDUP_NEW_DATABASEIMPORT_DLG

///Kyle 12/08/2010 ORG-1685 CONVERT_BETWEEN_TREENODE_AND_INI_STRING
OC_API	int		okutil_convert_tree_to_ini_str(TreeNode* pTree, string* pstrIniStr);
///End CONVERT_BETWEEN_TREENODE_AND_INI_STRING

///Sophy 12/15/2010 ORG-1397-S2 SPEEDUP_CONVERTING_TREENODE_VALUES_TO_VECTOR
/**$
	This function get treenode's children values into vector, need to loop all children, so do in VC for speed up.
*/
OC_API	int		okutil_get_subnode_values_to_vector(TreeNode* pTrBranch, DoubleArray* parrDoubles, UIntArray* parrMaskedIndices = NULL);
OC_API	int		okutil_get_subnode_values_to_vectorstring(TreeNode* pTrBranch, StringArray* parrStrings);
///end SPEEDUP_CONVERTING_TREENODE_VALUES_TO_VECTOR

///Sophy 1/4/2011 ORG-1841-S8 COPY_TO_CLIPBOARD_NEED_PASS_MULTIPLE_PLOTS_DATA_POINTS_AS_VECTOR_ARRAY
OC_API	int		okutil_copy_data_points(VectorArray* pArr, StringArray* parrHeaders = NULL, int nMaxPoints = -1, string* pResult = NULL);
///end COPY_TO_CLIPBOARD_NEED_PASS_MULTIPLE_PLOTS_DATA_POINTS_AS_VECTOR_ARRAY

///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
/**$
	This function allow OC to control LabTalk variable scope.
	Parameters:
		bPush = [input] if TRUE, enter a new scope, else exit from current scope level.
*/
OC_API	int		okutil_LT_stack(BOOL bPush = TRUE);
///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT

///Sophy 3/16/2011 ORG-2378-S1 EXPOSE_SHOW_I_TO_OC_FOR_SLOW_IMPORT
/**$
	This function allow show current cell index on Origin StatusBar.
*/
OC_API int		okutil_Show_i(int i, int nFreq = SIFREQ_EVERY);
///end EXPOSE_SHOW_I_TO_OC_FOR_SLOW_IMPORT

///------ Folger 03/28/2011 ORG-2442-P1 AUTO_INSTALL_NOT_WORK_FOR_OPK_FILE
OC_API int		okutil_install_opk_file(LPCSTR lpcszFile);
OC_API int		okutil_get_installed_opk_names(StringArray* parr);
OC_API BOOL		okutil_is_opk_installed(LPCSTR lpcszFile);
///------ End AUTO_INSTALL_NOT_WORK_FOR_OPK_FILE

///Sophy 4/19/2011 ORG-2650-P1 SMART_SKIP_COPY_SEQUENCER_FOR_HIGH_VERSION_MATHEMATICA
/**$
	This function get the specified file version, with the format like "%d.%d.%d.%d", where %d stands for and 16 bits integer.
*/
OC_API int		okutil_get_file_version(LPCSTR lpcszFileName, string* pstrVersionInfo);
///end SMART_SKIP_COPY_SEQUENCER_FOR_HIGH_VERSION_MATHEMATICA

///------ Folger 05/20/2011 ORG-2786-P1 FIND_X_FROM_Y_TOO_SLOW_IN_QUICKFIT_IF_MANY_PTS_FOR_FITX
OC_API	BOOL	okutil_polynomial_evaluate(DoubleArray* pvParams, DoubleArray* pvX, DoubleArray* pvY);
///------ End FIND_X_FROM_Y_TOO_SLOW_IN_QUICKFIT_IF_MANY_PTS_FOR_FITX

/// Bill 06/09/2011 ORG-260-S1 NEED_FUNCTION_TO_CONVERT_UNIT
OC_API double okutil_convert_unit(double dNumber, LPCSTR lpcszFrom, LPCSTR lpcszTo);
/// End NEED_FUNCTION_TO_CONVERT_UNIT

/// Kenny 07/06/2011 ORG-3120-P1 NEW_O3DGL_SURFACE_PLOT_GUI_ACCESS
OC_API BOOL		okutil_get_dataset_info(LPCTSTR lpcszDataSetName, LPSIZE lpSize, string* pstrLongName = NULL);
/// End NEW_O3DGL_SURFACE_PLOT_GUI_ACCESS

///------ Folger 07/19/2011 SUPPORT_LOAD_DLL_WITH_VERSION_FROM_OC
OC_API HMODULE	okutil_load_dll(LPCTSTR lpcszDLLFullPath);
///------ End SUPPORT_LOAD_DLL_WITH_VERSION_FROM_OC

///-----Kit 08/08/2011 ORG-3395-S1 REORGANIZE_FILE_IMPORT_MENU
/*
OC_API BOOL	okutil_get_dyn_menu_info(int nWndType, UINT nDropDownID, UINT nMenuPopupType, bool bDynMenuSelProtect, TreeNode *pTrDisplayInfo);

typedef struct tagCusXFMenuInfo
{
	int			nWndType;
	int			nMenuType;
	LPCTSTR		lpcszXFName;
	LPCTSTR		lpcszXFDispName;
	DWORD		dwAuxOptions;
	StringArray *pArrCategories;
}CusXFMenuInfo;
OC_API BOOL	okutil_get_customize_xf_menu_info(const CusXFMenuInfo *pInfo, bool bDynMenuSelProtect, TreeNode *pTrDisInfo);

OC_API BOOL	okutil_save_menu_customize_result(int nWndType, UINT menuPopupType, TreeNode *pTrResult);
OC_API BOOL	okutil_load_menu_customize_result(int nWndType, UINT menuPopupType, TreeNode *pTrResult);

OC_API BOOL	okutil_get_file_type_group_name(LPCTSTR lpcszXFName, string *pstrFileTypeGroupName);
*/

// when we can not find the extension from file group name, we will try to get the extension by default
// the default extension string is separate by char '|' by default
OC_API BOOL okutil_get_xf_extension(LPCTSTR lpcszXFName, StringArray *pstrExtension, char cDefaultExtDlimiter = '|');

OC_API BOOL okutil_get_xf_extension_from_file_type_group_name(LPCTSTR lpcszFileTypeGroup, StringArray *pstrExtension);

///-----End REORGANIZE_FILE_IMPORT_MENU


/// Kenny 08/15/2011 ORG-3535-P1 FIND_AND_REPLACE_DIALOG_FLICKERING_WHEN_RESIZE
OC_API HRESULT okutil_enable_theme_dialog_texture(HWND hwnd, DWORD flags);
/// End FIND_AND_REPLACE_DIALOG_FLICKERING_WHEN_RESIZE

///-----Kit 09/05/2011 ORG-3395-S2 CENTRALIZE_BUILD_CUSTOM_MENU_CODE
OC_API BOOL okutil_get_theme_sub_folder_path(int nThemeType, string *pStrThemeFolder, LPCTSTR lpcszSubfolder = NULL, string *pStrSubFolder = NULL);
///-----End CENTRALIZE_BUILD_CUSTOM_MENU_CODE

/// Bill 09/07/2011 ORG-3395 CUSTOMIZE_IMPORT_MENU_DIALOG
OC_API void okutil_generate_run_xf_with_theme_ltcmd(LPCTSTR lpcszXF, LPCTSTR lpcszTheme, string * pstrLTCmd);
/// End CUSTOMIZE_IMPORT_MENU_DIALOG

///------ Folger 10/17/2011 ORG-4107-P1 PROPER_MENU_ITEM_ACCELERATOR_LOCALIZED
OC_API BOOL okutil_get_virtual_key(string* pstr, LPACCEL lpAccel);
///------ End PROPER_MENU_ITEM_ACCELERATOR_LOCALIZED

///Sophy 10/26/2011 ORG-3092-P2 PROPER_FREE_MEMORY_ALLOCATED_IN_EXTERNAL_DLL
OC_API BOOL	okutil_CRT_free(void* pMemory, int nVersion = -1); //default, use "free" within "msvcrt.dll"
///end PROPER_FREE_MEMORY_ALLOCATED_IN_EXTERNAL_DLL

///-----Kit 10/31/2011 ORG-4063	SUPPORT_OC_REGULAR_EXPRESSION
enum RegexObjFlag
{
	ROF_ECMAScript	= 0x00000001,
	ROF_IgnoreCase	= 0x00000002,
};

OC_API BOOL okutil_create_regex_obj(RegexObjPtr pOCRegObj, LPCTSTR lpcszPattern, DWORD dwFlags = ROF_ECMAScript);
OC_API BOOL	okutil_clean_regex_obj(RegexObjPtr pOCRegObj);

OC_API BOOL okutil_regex_match(RegexObjPtr pOCRegObj, LPCTSTR lpcszContent, RegexMatchResult *pReMatchResults = NULL);
OC_API BOOL okutil_regex_search(RegexObjPtr pOCRegObj, LPCTSTR lpcszContent, RegexMatchResult *pReMatchResults = NULL);
OC_API BOOL okutil_regex_replace(RegexObjPtr pOCRegObj, LPCTSTR lpcszContent, LPCTSTR lpcszReplace, RegexMatchResult *pReMatchResults);
///-----End SUPPORT_OC_REGULAR_EXPRESSION

///------ Folger 12/21/2011 ORG-4508 MOVE_TIME_CONSUMING_OC_FUNCTION_TO_VC
OC_API int okutil_convert_int_vector_to_string_vector(StringArray* ps, IntArray* pn);
OC_API int okutil_convert_string_vector_to_int_vector(IntArray* pn, StringArray* ps, int nNoNumericReplace);
///------ End MOVE_TIME_CONSUMING_OC_FUNCTION_TO_VC

OC_API string	okutil_get_dataset_list();		///------ Folger 02/06/2012 ORG-4218-P1 SHARE_GET_DATASET_LIST_LOGIC_TO_OC

///------ Folger 06/27/2012 ORG-6079-S1 ALLOW_MULTIPLE_SAMPLE_OPJS_OPEN_FROM_FILE_MENU
OC_API void	okutil_get_sample_opjs(StringArray* parrFiles, StringArray* parrDisplayNames);
///------ End ALLOW_MULTIPLE_SAMPLE_OPJS_OPEN_FROM_FILE_MENU

#ifdef __AFX_H__
	/// Kenny 04/12/2012 SUPPRESS_COMPILER_UNNECESSARY_WARNINGS
	#pragma warning(pop)
	/// End SUPPRESS_COMPILER_UNNECESSARY_WARNINGS
	}
#endif	//__AFX_H__

#endif //_STRING_UTILS_H_
