/*------------------------------------------------------------------------------*
 * File Name: mscomm.h															*
 * Creation:  JCG 8/22/2001														*
 * Purpose: Origin C serial communication functions								*
 * Copyright (C) OriginLab Corp.2001											*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/


#ifndef _MSCOMM_
#define _MSCOMM_

#pragma dll(kernel32, system)

// Baud rates at which the communication device operates
#define CBR_110             110
#define CBR_300             300
#define CBR_600             600
#define CBR_1200            1200
#define CBR_2400            2400
#define CBR_4800            4800
#define CBR_9600            9600
#define CBR_14400           14400
#define CBR_19200           19200
#define CBR_38400           38400
#define CBR_56000           56000
#define CBR_57600           57600
#define CBR_115200          115200
#define CBR_128000          128000
#define CBR_256000          256000
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DCB
*/
typedef struct _DCB {
    DWORD DCBlength;     		// sizeof(DCB)                    
    DWORD BaudRate;       		// Baudrate at which running      
    DWORD fBinary:1;     		// Binary Mode (skip EOF check)    
    DWORD fParity:1;     		// Enable parity checking         
    DWORD fOutxCtsFlow:1; 		// CTS handshaking on output       
    DWORD fOutxDsrFlow:1; 		// DSR handshaking on output      
    DWORD fDtrControl:2;  		// DTR Flow control              
    DWORD fDsrSensitivity:1; 	// DSR Sensitivity              
    DWORD fTXContinueOnXoff:1; // Continue TX when Xoff sent 
    DWORD fOutX:1;       		// Enable output X-ON/X-OFF        
    DWORD fInX:1;        		// Enable input X-ON/X-OFF        
    DWORD fErrorChar:1;  		// Enable Err Replacement          
    DWORD fNull:1;       		// Enable Null stripping           
    DWORD fRtsControl:2;  		// Rts Flow control                
    DWORD fAbortOnError:1; 		// Abort all reads and writes on Error 
    DWORD fDummy2:17;     		// Reserved                       
    WORD wReserved;       		// Not currently used              
    WORD XonLim;          		// Transmit X-ON threshold         
    WORD XoffLim;         		// Transmit X-OFF threshold       
    BYTE ByteSize;        		// Number of bits/byte, 4-8        
    BYTE Parity;          		// 0-4=None,Odd,Even,Mark,Space    
    BYTE StopBits;        		// 0,1,2 = 1, 1.5, 2               
    char XonChar;         		// Tx and Rx X-ON character        
    char XoffChar;        		// Tx and Rx X-OFF character       
    char ErrorChar;       		// Error replacement char          
    char EofChar;         		// End of Input character          
    char EvtChar;         		// Received Event character        
    WORD wReserved1;      		// Fill for now.                
} DCB, *LPDCB;
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:COMMTIMEOUTS
*/
typedef struct _COMMTIMEOUTS {
    DWORD ReadIntervalTimeout;          // Maximum time between read chars. 
    DWORD ReadTotalTimeoutMultiplier;   // Multiplier of characters.        
    DWORD ReadTotalTimeoutConstant;     // Constant in milliseconds.        
    DWORD WriteTotalTimeoutMultiplier;  // Multiplier of characters.       
    DWORD WriteTotalTimeoutConstant;    // Constant in milliseconds.        
} COMMTIMEOUTS, *LPCOMMTIMEOUTS;

#define NOPARITY            0
#define ODDPARITY           1
#define EVENPARITY          2
#define MARKPARITY          3
#define SPACEPARITY         4

#define ONESTOPBIT          0
#define ONE5STOPBITS        1
#define TWOSTOPBITS         2

#define	MAXWORD    		 	0xffff      
typedef DWORD  				*LPDWORD;

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetCommState_(global_function)
*/
BOOL WINAPI SetCommState(
    HANDLE hFile,
    LPDCB lpDCB
    );
    
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetCommState_(global_function)
*/
BOOL WINAPI GetCommState(
    HANDLE hFile,
    LPDCB lpDCB
    );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetCommTimeouts_(global_function)
*/
BOOL WINAPI SetCommTimeouts(
    HANDLE hFile,
    LPCOMMTIMEOUTS lpCommTimeouts
    );
    
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetCommTimeouts_(global_function)
*/
BOOL WINAPI GetCommTimeouts(
    HANDLE hFile,
    LPCOMMTIMEOUTS lpCommTimeouts
    );

#endif //_MSCOMM_
