/*------------------------------------------------------------------------------*
 * File Name: image_utils.h	 													*
 * Creation: 2005-07-20															*
 * Purpose: header for image utility functions									*
 * Copyright (c) OriginLab Corp. 2005											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2006-08-31 v8.0474 QA70-8947 ADD_COPYTO_METH_TO_IMAGE_CLASS				*
 * EJP 2006-11-20 v8.0514 FIX_EXPORT_MATRIX_RET_VAL								*
 * EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC						*
 * EJP 2007-02-01 v8.0553 QA70-9329 FILE_EXT_GRP_ALL_TYPES						*
 * Sim 06-21-2007 GET_EXTENSION_LIST_OF_IMAGE_TYPE								*
 * Sim 08-22-2007 MAKE_IMAGE_TYPE_LIST_SORTED_BY_EXT							*
 *	Folger 02/03/09 QA80-13032 SUPPORT_COPY_LAYER_SCALE_FOR_COPY_IMAGE_DATA		*
 *	Kenny 07/21/2009 QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF*
 *	Folger 11/22/2010 ORG-1544 SUPPORT_IMAGE_ROTATION_IN_DIGITIZER				*
 *	Folger 04/23/2012 ORG-2289-P1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
 *------------------------------------------------------------------------------*/

#ifndef _IMAGE_UTILS_H
#define _IMAGE_UTILS_H

#include <ocImgLT.h>
#include <oImgLTex.h>
#define MAX_SIZE_OF_GIF_IMAGE 100
#define MAX_ERROR_CODE_FROM_LT  SUCCESS
#define ERROR_NO_MEMORY_FROM_LT 	 -1
#define ERROR_INV_PARAMETER_FROM_LT  -13

///Sandy 2006-12-19 MOVE_TO_MATDATA_UTILS
/*
///Sandy 2006-6-27 initialize LVLCLR struct 
void color_level_initialize(int nMaxV, LVLCLR& lc);

///Sandy 2006-6-27 set LVLCLR struct with certain channel
int set_color_level_to_LVLCLR(int nMaxLevel, int nChannel, double dBlack, double dWhite, double dGamma, LVLCLR& lc);

///Sandy 2006-6-27 get color level value with certain channel from LVLCLR struct
void get_color_level_from_LVLCLR(int nMaxLevel, int nChannel, LVLCLR& lc, double& dBlack, double& dWhite, double& dGamma);

///Sandy 2006-6-26 show LVLCLR struct to a vector
#define  GET_COLOR_LEVEL(_channel, vcl, xcl)  ( vcl[0] = xcl._channel.uMinInput;\
									    vcl[1] = xcl._channel.uMaxInput;\
									    vcl[2] = xcl._channel.uMinOutput;\
									    vcl[3] = xcl._channel.uMaxOutput;\
									    vcl[4] = xcl._channel.uGamma/100.0;)

#define  SET_COLOR_LEVEL(_channel, vcl, xcl)  ( xcl._channel.uMinInput = vcl[0] ;\
									  xcl._channel.uMaxInput = vcl[1];\
									  xcl._channel.uMinOutput = vcl[2];\
									  xcl._channel.uMaxOutput = vcl[3];\
									  xcl._channel.uGamma =  vcl[4]*100.0;)
*/
 
// ImportImageIntoActivePageDialog is for calling from LabTalk.
// OC equivalent of LabTalk's ImportImage section in ImgFile.OGS.
//int image_dlg_import_to_active_page();

// LoadImageIntoActiveMatrix is for calling from LabTalk.
// OC equivalent of LabTalk's LoadImageIntoMatrix section in ImgFile.OGS.
//int image_import_to_active_matrix(string lpcszFile);

//--- CPY 10/5/05
//int image_import_to_matrix(MatrixLayer& mlTarget, LPCSTR lpcszFile);
//----- CPY 9/4/06 IMPORT_IMAGE_INTO_WKS_CELL
//bool image_import_to_matrix(MatrixObject& mTarget, LPCSTR lpcszFile, int* pErrCode=NULL);
// error codes
enum {
	// the following will return NULL
	IIMP_FILE_NO_FOUND = -1, IIMP_FAILED_GET_FILE_INFO = -2, IIMP_CANNOT_CREATE_LBMP = -3,
	// none-fatal errors, this will still return bitmap
	IIMP_FAILED_CHANGE_TO_TOP_LEFT = 1, 
};

/// Comment last updated by Iris on 7/27/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:image_import_to_matrix_(global_function)
*/
bool image_import_to_matrix(MatrixObject& moTarget, LPCSTR lpcszFile, TreeNode &trFileInfo = NULL, TreeNode &trFilter = NULL, int* pErr = NULL);

///Sophy 6/18/2010 ORg-339 MULTIFRAME_TIFF_IMPORT
/**#
*/
bool image_import_to_matrix(MatrixLayer& mlTarget, LPCSTR lpcszFile, TreeNode& trFileInfo = NULL);
/**#
*/
bool image_frame_counts(LPCSTR lpcszFile, int& nBitmaps);
///end MULTIFRAME_TIFF_IMPORT
/// Comments last updated by Stacy on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:image_import_(global_function)
*/
pBITMAPHANDLE image_import(LPCSTR lpcszFile, FILEINFO* pfi = NULL, int* pErrCode=NULL);
//-----
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:
		hwndParent=[output]
		szFileName=[input]
		lpcszTitle=[intput]
		bOpen=[input]
	Return:
		
	SeeAlso:
		
*/
bool image_file_dlg(HWND hwndParent, string& szFileName, LPCSTR lpcszTitle = NULL, bool bOpen = true);

/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:
		hwndParent=[output]
		saFileName=[input]
		lpcszTitle=[intput]
		bOpen=[input]
		bMultiSel=[input]
	Return:
		
	SeeAlso:
		
*/
bool image_files_dlg(HWND hwndParent, StringArray& saFileName, LPCSTR lpcszTitle = NULL, bool bOpen = true, bool bMultiSel = false);
//----



///Comments last updated by Iris on 7/27/2009
/**$ >Image Processing
	Remarks:
		Read color information from palette file
	Example1:
		bool read_color_map_binary_ex1()
		{
			int nRet;
			short nColors;
			vector<byte> vR, vG, vB;
			string strPalFile = GetAppPath(TRUE) + "\\Palettes\\BLUE.pal";
			nRet = read_color_map_binary(strPalFile, nColors, vR, vG, vB);
			if(nRet != OE_NOERROR)
				return false;
			return true;
		}
	Parameters:
		strPalfile=[input] Palette file path
		nColors=[output] color number in palette file
		vR=[output] vector of Red Color
		vG=[output] vector of Green Color
		vB=[output] vector of Blue Color
	Return:
		return OE_NOERROR for success, otherwise return errors
	SeeAlso:
		
*/
int read_color_map_binary(string strPalfile, short& nColors, vector<byte>& vR, vector<byte>& vG, vector<byte>& vB);							  

///sandy 2006-11-16 add
#define EPTI_LT_VAR "imgexp"

// export an image using current ini settings or prompt user with export options
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:
		image=[input]
		lpcszFileName=[input]
		lpcszFormat=[input] 
		bShowOptions=[input]
	Return:
		
	SeeAlso:
		
*/
bool export_image(Image &image, LPCSTR lpcszFileName, LPCSTR lpcszFormat, BOOL bShowOptions);

// export an image using the specified settings
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:
		image=[input]
		lpcszFileName=[input]
		lpcszFormat=[input]
		nWidth=[input]
		nHeight=[input]
		nBitsPerPixel=[input]
		nCompression=[input]
	Return:
		
	SeeAlso:
		
*/
bool export_image(LPCSTR lpcszFileName, LPCSTR lpcszFormat, Image &image, int nWidth, int nHeight, int nBitsPerPixel, int nCompression = 0);

/// EJP 2006-11-20 v8.0514 FIX_EXPORT_MATRIX_RET_VAL
///bool export_Matrix_to_image(LPCSTR lpcszFileName, LPCSTR lpcszFormat, MatrixObject &mo);
///---Sim 01-03-2007 FIX_GRAY_SCALE_FAIL_TO_WORK
//int export_Matrix_to_image(LPCSTR lpcszFileName, LPCSTR lpcszFormat, MatrixObject &mo);
// Comments last updated by Stacy on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:export_Matrix_to_image_(global_function)
*/
int export_Matrix_to_image(LPCSTR lpcszFileName, LPCSTR lpcszFormat, MatrixObject &mo, int nDPI = 96, bool bGray = false);
///---END FIX_GRAY_SCALE_FAIL_TO_WORK
/// end FIX_EXPORT_MATRIX_RET_VAL

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//----- CPY 9/4/06 IMPORT_IMAGE_INTO_WKS_CELL
// we should not use this anymore after /// YuI 08/30/06 QA70-8944 IMAGE_TYPE_XVARIABLE
/*
//--- CPY 9/8/05
// move to OImgLT.h later
class MatrixObjLeadBitmap
{
public:
	MatrixObjLeadBitmap(MatrixObject& moTarget, bool bUpdateMatrixObjOnDestruct = true, bool bUndo = true)
	{
		m_bFromDIB = false;
		m_bUndo = bUndo;
		m_bDoNotUpdateMatrixObject = bUpdateMatrixObjOnDestruct? false:true;
		m_nInternalType = moTarget.GetInternalDataType();
		m_strMatrixName = moTarget.GetDatasetName();
		if( AttachBitmap(moTarget) )
		{
			m_bModified = true;// assumed modified, can call SetModified(false) if user cancel
			m_bReady = true;
		}
		else
		{
			m_bModified = false;// assumed modified, can call SetModified(false) if user cancel
			m_bReady = false;
		}
	}
	~MatrixObjLeadBitmap()
	{
		if(m_bDoNotUpdateMatrixObject)
			m_bModified = false;
		
		DetachBitmap(m_bModified);
	}
	bool IsValid() {return m_bReady;}
	void SetModified(bool bModified) { m_bModified = bModified;}
protected:
	bool AttachBitmap(MatrixObject& moTarget)
	{
		if( m_bUndo )
			moTarget.PushUndo(0);
		
		int nRet = FAILURE;
		if( moTarget.HasData(FALSE) )
		{
			m_bBitmapFromData = true;

			if( FSI_USHORT != m_nInternalType && FSI_BYTE != m_nInternalType)
				return false; // unsupported matrix type

			m_nNumCols = moTarget.GetNumCols();
			m_nNumRows = moTarget.GetNumRows();

			if(FSI_USHORT == m_nInternalType)
			{
				Matrix<USHORT>& mat = moTarget.GetDataObject();
				/// EJP 2005-11-01 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ
				///nRet = ol_create_bitmap_from_matrix(&m_LBmp, mat, m_nNumCols, m_nNumRows);
				nRet = ol_create_bitmap_from_matrix(m_pLBmp, mat, m_nNumCols, m_nNumRows);
				/// end LEAD_BITMAP_GR_OBJ
			}
			else
			{
				Matrix<BYTE>& mat = moTarget.GetDataObject();
				/// EJP 2005-11-01 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ
				///nRet = ol_create_bitmap_from_byte_matrix(&m_LBmp, mat, m_nNumCols, m_nNumRows);
				nRet = ol_create_bitmap_from_byte_matrix(m_pLBmp, mat, m_nNumCols, m_nNumRows);
				/// end LEAD_BITMAP_GR_OBJ
			}
		}
		else // make LEAD bitmap from matrix DIB
		{
			m_bBitmapFromData = false;

			m_pLBmp = (pBITMAPHANDLE)moTarget.GetLeadBitmap();
			if( m_pLBmp )
			{
				m_nNumCols = m_pLBmp->Width;
				m_nNumRows = m_pLBmp->Height;
				nRet = SUCCESS;//CPY
			}
			else
			{
				HDIB hDib = moTarget.GetDIB();
				if( hDib )
				{
					nRet = L_CHANGE_FROM_DIB(&m_LBmpCopy, hDib);
					if( SUCCESS == nRet )
					{
						m_bFromDIB = true;
						m_nNumCols = m_LBmpCopy.Width;
						m_nNumRows = m_LBmpCopy.Height;
					}
				}
			}
			/// end LEAD_BITMAP_GR_OBJ
		}
		if(SUCCESS == nRet)
		{
			return true;
		}
		else
			out_int("err code = ", nRet);
		return false;
	}
	void DetachBitmap(bool bUpdateMatrixObj)
	{
		if(!IsValid())
			return;
		// check if bmp dim changed
		bool bDimChanged = false;

		/// EJP 2005-11-01 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ
		///if(m_nNumRows != m_LBmp.Height || m_nNumCols != m_LBmp.Width)
		if( m_nNumRows != m_pLBmp->Height || m_nNumCols != m_pLBmp->Width )
		/// end LEAD_BITMAP_GR_OBJ
			bDimChanged = true;	
			
			
		int nRet = FAILURE;
		if( m_bBitmapFromData )
		{
			if(bUpdateMatrixObj)
			{
				if(FSI_USHORT == m_nInternalType)
				{
					Matrix<USHORT> mat(m_strMatrixName);
					
					/// EJP 2005-11-01 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ
					///if(bDimChanged)
					///	mat.SetSize(m_LBmp.Height, m_LBmp.Width);
					///nRet = ol_set_matrix_from_bitmap(mat, &m_LBmp);
					if( bDimChanged )
						mat.SetSize(m_pLBmp->Height, m_pLBmp->Width);
					nRet = ol_set_matrix_from_bitmap(mat, m_pLBmp);
					/// end LEAD_BITMAP_GR_OBJ

					mat.Update(false, REDRAW_REFRESH);
				}
				else
				{
					Matrix<BYTE> mat(m_strMatrixName);
					
					/// EJP 2005-11-01 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ
					///if(bDimChanged)
					///	mat.SetSize(m_LBmp.Height, m_LBmp.Width);
					///nRet = ol_set_byte_matrix_from_bitmap(mat, &m_LBmp);
					if( bDimChanged )
						mat.SetSize(m_pLBmp->Height, m_pLBmp->Width);
					nRet = ol_set_byte_matrix_from_bitmap(mat, m_pLBmp);
					/// end LEAD_BITMAP_GR_OBJ
					
					mat.Update(false, REDRAW_REFRESH);
				}
			}
			else
				nRet = SUCCESS;
				

			/// EJP 2005-11-01 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ
			///L_FreeBitmap(&m_LBmp);
			/// end LEAD_BITMAP_GR_OBJ
		}
		else // set matrix DIB with LEAD bitmap
		{
			if(bUpdateMatrixObj)
			{
				MatrixObject moTarget(m_strMatrixName);
				if( moTarget )
				{
					/// EJP 2005-10-31 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ
					///HDIB hDib = L_CHANGE_TO_DIB(&m_LBmp);
					///if( hDib && moTarget.SetDIB(hDib, NULL, FALSE) )
					if(m_pLBmp)
					{
						if( moTarget.SetLeadBitmap(m_pLBmp, false) )  //CPY 11/5/05, no need to make copy as m_pLBmp was the original pointer
							nRet = SUCCESS;
					}
					else if(m_bFromDIB)
					{
						HDIB hDib = L_CHANGE_TO_DIB(&m_LBmpCopy);
						if( hDib && moTarget.SetDIB(hDib, NULL, FALSE) )
							nRet = SUCCESS;
					}
				}
			}
			else
				nRet = SUCCESS;
		}
		if( nRet != SUCCESS )
		{
			out_int("Err on MatrixObjLeadBitmap destructor, err = ", nRet);
		}
	}
private:
	bool	m_bUndo;
	bool 	m_bReady;
	int		m_nInternalType;
	string	m_strMatrixName;
	UINT	m_nNumCols;
	UINT	m_nNumRows;
	bool	m_bBitmapFromData;
	bool	m_bModified;
	bool	m_bDoNotUpdateMatrixObject;

/// EJP 2005-11-01 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ
///public:
	BITMAPHANDLE	m_LBmpCopy;	//CPY 11/6/05
	bool			m_bFromDIB;
	pBITMAPHANDLE	m_pLBmp;
public:
	pBITMAPHANDLE	GetLBmpPtr() {return m_pLBmp;} //CPY	
/// end LEAD_BITMAP_GR_OBJ

};
*/

/// YuI 08/30/06 QA70-8944 IMAGE_TYPE_XVARIABLE
/// Comments last updated by Joseph on 03/15/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Image_(class)
*/
class	Image	:	public	OriginObject
{
public:
	/**#
	*/
	Image();
	/**#
	*/
	Image(Image& imgSrc);
	/**#
	*/
	Image(MatrixObject& mo);
	/**#
	*/
	Image(Worksheet& wks, int nRow, int nCol);
	/**#
	*/
	Image(Column& col, int nRow);
	/**#
	*/
	Image(LPCSTR lpcszFileName);
	/**#
	*/
	~Image();
	
public:
	/**#
	*/
	BOOL	Init(Image& imgSrc);
	/**#
	*/
	BOOL	Init(MatrixObject& mo);
	/**#
	*/
	BOOL	Init(Worksheet& wks, int nRow, int nCol);
	/**#
	*/
	BOOL	Init(Column& col, int nRow);
	/**#
	*/
	BOOL	Init(LPCSTR lpcszFileName);
	/**#
	*/
	void			SetLBmp(pBITMAPHANDLE pBmp, BOOL bCopy = TRUE);
	// if bTransfer = true, then after call this Image will have no bitmap
	/**#
	*/
	pBITMAPHANDLE	GetLBmp(BOOL bTransfer = false);
	
	/// EJP 2006-08-31 v8.0474 QA70-8947 ADD_COPYTO_METH_TO_IMAGE_CLASS
	/**#
		Remarks:
			Copy the image to a MatrixObject as an image or as data with the option to convert to grayscale.
		Parameters:
			mo = [output] The destination matrix object to receive the image.
			bAsData = [input] Copy to destination as data (TRUE) or as an image (FALSE).
			nGrayBits = [input] Convert copy to grayscale. 0 for no, 8 for 8-bit gray, or 16 for 16-bit gray.
			dwOptions = [input] Specify extra info to be copied. emnu like IMAGE_COPY_SCALE
		Return:
			TRUE for success, FALSE for error.
	*/
	/// EJP 2007-04-09 v8.0598 QA70-8947 IMAGE_COPYTO_SUPPORT_GRAY_CONVERSION
	///BOOL CopyTo(MatrixObject& mo, BOOL bAsData = FALSE);
	///------ Folger 02/03/09 QA80-13032 SUPPORT_COPY_LAYER_SCALE_FOR_COPY_IMAGE_DATA
	//BOOL CopyTo(MatrixObject& mo, BOOL bAsData = FALSE, int nGrayBits = 0);
	BOOL CopyTo(MatrixObject& mo, BOOL bAsData = FALSE, int nGrayBits = 0, DWORD dwOptions = 0);
	///------ End SUPPORT_COPY_LAYER_SCALE_FOR_COPY_IMAGE_DATA
	/// end IMAGE_COPYTO_SUPPORT_GRAY_CONVERSION
	/// end ADD_COPYTO_METH_TO_IMAGE_CLASS
};


/// end IMAGE_TYPE_XVARIABLE


/// Iris 11/17/06 MOVE_EXPORT_PAGE_CODE_AS_GLOBAL_FROM_XF
///---Sim 11-16-2006 MORE_MOVING_FOR_EXPORT
enum
{
	IMAGE_TYPE_DOT,
	IMAGE_TYPE_VEC,
	IMAGE_TYPE_INVALID
};
///---END MORE_MOVING_FOR_EXPORT

enum //Dialog Settings
{
	//---- CPY 4/21/07 XF_DLG_HAS_SYS_ADDED_NODES
	//DLG_FILE_TYPE = 1,
	DLG_FILE_TYPE =	IDE_END_XF_SYS_ADDED_NODES + 1,
	//----
	DLG_FILE_PATH,	
	DLG_PAGE_SETTINGS,
	
	///Joseph 04/13/07 FIX_BUG_ON_DUPLICATE_ID_IN_EXPGRAPH
	//Autoupdate id  = 15, then duplicate
	//DLG_AI_OPTIONS,
	//DLG_AI_OPTIONS = GET_USER_DATAID(DLG_PAGE_SETTINGS + 1), //---- CPY 4/21/07 XF_DLG_HAS_SYS_ADDED_NODES commoneted this out
	///End FIX_BUG_ON_DUPLICATE_ID_IN_EXPGRAPH
	
	DLG_AI_OPTIONS,
	DLG_BMP_OPTIONS,
	DLG_CGM_OPTIONS,
	DLG_DXF_OPTIONS,	
	DLG_EPS_OPTIONS,
	DLG_GIF_OPTIONS, /// EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC	
	DLG_JPG_OPTIONS,
	DLG_PCX_OPTIONS,
	DLG_PNG_OPTIONS,
	DLG_TGA_OPTIONS,
	DLG_PDF_OPTIONS,
	DLG_PSD_OPTIONS,
	DLG_TIF_OPTIONS,
	DLG_XPM_OPTIONS,
	DLG_XWD_OPTIONS,
	DLG_WMF_OPTIONS,
	DLG_LAST_ITEM		
};


enum
{
	IMG_EPS_POSTSCRIPT_BRANCH = 201,
	IMG_EPS_PSLEVEL,
	IMG_EPS_FORMAT,
	IMG_EPS_COLORS,
	IMG_EPS_DESTRASTOPER,
	IMG_EPS_DESTRASTOPERRES,

	IMG_EPS_PREVIEW_BRANCH,
	IMG_EPS_PREVIEW,
	IMG_EPS_RESOLUTION,
	IMG_EPS_COMPRESSION,

	IMG_EPS_FONTS_BRANCH,
	IMG_EPS_FONTTYPE,
	IMG_EPS_EMBED,
	IMG_EPS_TRUETYPE,
	IMG_EPS_VECTORFONTTHICKNESS,
	
	IMG_EPS_LAST_ITEM
};

enum
{	
	IMG_JPG_DOTS_PER_INCH = 301,
	IMG_JPG_BITS_PER_PIXEL,
	IMG_JPG_COMPRESSION,
	
	IMG_JPG_LAST_ITEM
};

enum//TIF image settings
{
	IMG_TIF_DPI = 401,
	IMG_TIF_SPACE,
	IMG_TIF_DEPTH,
	IMG_TIF_COMPRESSION,
	IMG_TIF_GRAYSCALE, /// EJP 2006-10-03 v8.0493 USE_CORRECT_KEY_NAMES_USED_BY_OIMG
	
	IMG_TIF_LAST_ITEM	
};

enum//BMP image settings
{
	IMG_BMP_DPI = 501,
	IMG_BMP_DEPTH,
	
	IMG_BMP_LAST_ITEM
};

enum//PDF image settings
{
	IMG_PDF_BASEOBJECT_BRANCH = 601,
	IMG_PDF_COLORS,
	IMG_PDF_LINEMODE,
	IMG_PDF_FILLMODE,
	IMG_PDF_COMPRESSION_BRANCH,
	IMG_PDF_CLRIMAGECOMPRESSION,
	IMG_PDF_MNIMAGECOMPRESSION,
	IMG_PDF_TEXTCOMPRESSION,
	IMG_PDF_ASCIIENCODING,
	IMG_PDF_FONT,
	IMG_PDF_EMBED,
	IMG_PDF_OUTLINE,
	IMG_PDF_STROKEWIDTH,
	IMG_PDF_SUBSTITUTION,
	IMG_PDF_TRUETYPE,
	IMG_PDF_RASTER,
	IMG_PDF_DESTRASTOPER,
	IMG_PDF_DESTRASTOPERRES,
	IMG_PDF_BACKGROUND,
	
	IMG_PDF_LAST_ITEM
};

/// EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC
enum //GIF image settings
{
	IMG_GIF_DPI = 701, ///---Sim 11-22-2006 INDIVIDUAL_ID_NUMBER
	IMG_GIF_DEPTH,
	IMG_GIF_LAST_ITEM
	
};
/// end IMPROVE_IMG_EXT_TYPE_UTIL_FUNC

/// Iris 11/24/06 v8.0515 SUPPORT_MORE_IMAGE_TYPE
enum //CGM image settings
{
	IMG_CGM_PROFILES = 801,
	IMG_CGM_COLOR_TRANSLATE,
	IMG_CGM_LINE_MODE,
	IMG_CGM_LAST_ITEM
};

enum //DXF image settings
{
	IMG_DXF_PROFILES = 901,
	IMG_DXF_COLOR_TRANSLATE,
	IMG_DXF_UNITS,
	IMG_DXF_LAST_ITEM
};

enum //PCX image settings
{
	IMG_PCX_DPI = 1001, 
	IMG_PCX_DEPTH,
	IMG_PCX_LAST_ITEM	
};

enum //PNG image settings
{
	IMG_PNG_DPI = 1101, 
	IMG_PNG_DEPTH,
	IMG_PNG_COMPRESSION,
	IMG_PNG_LAST_ITEM
};

enum //TGA image settings
{
	IMG_TGA_DPI = 1201, 
	IMG_TGA_DEPTH,
	IMG_TGA_COMPRESSION,
	IMG_TGA_LAST_ITEM
};

enum //PSD image settings
{
	IMG_PSD_DPI = 1301, 
	IMG_PSD_DEPTH,
	IMG_PSD_COMPRESSION,
	IMG_PSD_LAST_ITEM
};

enum //XPM image settings
{
	IMG_XPM_DPI = 1401, 
	IMG_XPM_DEPTH,
	IMG_XPM_COMPRESSION,
	IMG_XPM_LAST_ITEM
};

enum //XWD image settings
{
	IMG_XWD_DPI = 1501, 
	IMG_XWD_DEPTH,
	IMG_XWD_COMPRESSION,
	IMG_XWD_LAST_ITEM
};

enum //WMF image settings
{
	IMG_WMF_DPI = 1601
};

enum
{
	IMG_AI_PROFILE = 1701,
	IMG_AI_COLORS,
	IMG_AI_LINEMODE,
	IMG_AI_BACKGROUND,
	IMG_AI_OPTIMIZE,
	IMG_AI_AIFORMAT,
	IMG_AI_AIVERSION,
	IMG_AI_TIFF,
	IMG_AI_FORMAT,
	IMG_AI_COMPRESSION,
	IMG_AI_RESOLUTION,
	IMG_AI_LENGTH,
	IMG_AI_WIDTH,
	
	IMG_AI_LAST_ITEM
};
///end SUPPORT_MORE_IMAGE_TYPE
	

#define		STR_ATTRIB_IMAGE_TYPE		"ImageType"  
#define		STR_ATTRIB_GRAY_SCALE		"GrayScale"
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
bool export_gui_construct_options_branch(TreeNode& trOptions);
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
bool convert_node_value_from_index_to_str(TreeNode& trNode, LPCSTR lpcszAttrName);
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
bool convert_node_value_from_str_to_index(TreeNode& trNode, LPCSTR lpcszAttrName);

/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
bool	convert_color_depth_from_str_to_num(TreeNode& trNode);
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
bool	convert_color_depth_from_num_to_str(TreeNode& trNode);
///end FIX_GRAY_SCALE_FAIL_TO_WORK

#ifdef JUNK
///---Sim 11-17-2006 MORE_MOVING_FOR_EXPORT
//------- Iris 11/21/06 WANT_NOT_SUPPORT_VECTOR_TYPE_IN_EXP_IMAGE
//string export_get_type_list(int nType = -1, vector<string>* pvsTypes = NULL);
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
string export_get_type_list(int nType = -1, vector<string>* pvsTypes = NULL, bool bIncVecType = true);
//-------
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
string export_get_ext_from_file_type(LPCSTR lpcszType, bool bMakeUpper = false);
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
int	export_check_image_type(LPCSTR lpcszType);
#endif // JUNK

/**$ >Image
	Remarks:
		check whether the path of export file is valid
	Example1:
		void export_check_path_show_warnning_ex1()
		{
			string path = "c:\\ss.jpg";
			export_check_path_show_warnning(path);
		}
	Parameters:
		strPath = [input] the path to check
	Return:
		if success, return true
	SeeAlso:
		
*/
bool export_check_path_show_warnning(string& strPath);

/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
void export_gui_show_options_branch(TreeNode& trImageOptions, LPCSTR lpcszExt);
///---END MORE_MOVING_FOR_EXPORT

///end MOVE_EXPORT_PAGE_CODE_AS_GLOBAL_FROM_XF

/// EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC
enum {
	IFT_EXPORT = 0, // graph, layout
	IFT_EXPORT_MATRIX,
	IFT_IMPORT, // graph, layout
	IFT_IMPORT_MATRIX,
	IFT_RASTER, // all raster formats
	IFT_VECTOR, // all vector formats
	IFT_RASTER_AND_VECTOR, // all raster and vector formats
	IFT_PPT,	/// Iris 01/22/2007 v8.0544 REMOVE_TYPES_NOT_SUPPORT_IN_PPT_FROM_LIST
	IFT_COUNT // must be last enum
};
/// Comment last updated by Cloud on 6/13/2008
/**$ >Image
	Remarks:
		Get the Image group's File Extension Type strings for the specified image types.
		The strings received are in the "[Description] *.Ext" format.
	Example1:
		void get_image_file_types_ex1()
		{
			StringArray sa;
			get_image_file_types(sa);
		}
	Parameters:
		saTypes = [output] string array to receive the strings.
		nCtrl = [input] an IFT_* constant that specifies the image types to get.
	Return: 
		The number of string put into the array or an error number less than zero.
*/
int get_image_file_types(StringArray& saTypes, int nCtrl = IFT_RASTER_AND_VECTOR);

/// Comment last updated by Cloud on 6/13/2008
/**$ >Image
	Remarks:
		Get the Image group's File Extension Type description strings for the specified image types.
		The strings received are in the "Image Type Name (*.Ext)" format.
	Example1:
		void get_image_file_type_descrips_ex1()
		{
			StringArray sa;
			get_image_file_type_descrips(sa);
		}
	Parameters:
		saTypes = [output] string array to receive the strings.
		nCtrl = [input] an IFT_* constant that specifies the image types to get.
	Return: 
		The number of string put into the array or an error number less than zero.
*/
int get_image_file_type_descrips(StringArray& saTypes, int nCtrl = IFT_RASTER_AND_VECTOR);

///---Sim 06-21-2007 GET_EXTENSION_LIST_OF_IMAGE_TYPE
/// Comment last updated by Cloud on 6/13/2008
/**$ >Image
	Remarks:
		Get the Image group's File Extension Name strings for the specified image types.
		The strings received are in the "Ext" format.
	Example1:
		void get_image_file_type_extensions_ex1()
		{
			StringArray sa;
			get_image_file_type_extensions(sa);
		}
	Parameters:
		saExts = [output] string array to receive the strings.
		nCtrl = [input] an IFT_* constant that specifies the image types to get.
	Return: 
		The number of string put into the array or an error number less than zero.
*/
int get_image_file_type_extensions(StringArray& saExts, int nCtrl = IFT_RASTER_AND_VECTOR);
///---END GET_EXTENSION_LIST_OF_IMAGE_TYPE

/// Comment last updated by Cloud on 6/13/2008
/**$ >Image
	Remarks:
		Get the Image group's File Extension Type description string for the specified image type.
		The string received are in the "Image Type Name (*.Ext)" format.
	Example1:
		void get_image_file_type_descrip_ex1()
		{
			string s;
			get_image_file_type_descrip(s, 0);
		}
	Parameters:
		strDescrip = [output] string the file type description.
		index = [input] the index of the file type
		nCtrl = [input] an IFT_* constant that specifies the image types to get from.
	Return: 
		true for success, false for error
*/
bool get_image_file_type_descrip(string& strDescrip, int index, int nCtrl = IFT_RASTER_AND_VECTOR);

/// Comment last updated by Cloud on 6/13/2008
/**$ >Image
	Remarks:
		Get the Image group's File Extension Type description and extension strings for the specified image type.
		The strings received are in the "Image Type Name (*.Ext)" and "Ext" format respectively.
	Example1:
		void get_image_file_type_descrip_and_ext_ex1()
		{
			string des, ext;
			get_image_file_type_descrip_and_ext(des, ext, 0);
		}
	Parameters:
		strDescrip = [output] string the file type description.
		strExt = [output] string the file type extension.
		index = [input] the index of the file type
		nCtrl = [input] an IFT_* constant that specifies the image types to get from.
	Return: 
		true for success, false for error
*/
bool get_image_file_type_descrip_and_ext(string& strDescrip, string& strExt, int index, int nCtrl = IFT_RASTER_AND_VECTOR);

/// Comment last updated by Cloud on 6/13/2008
/**$ >Image
	Remarks:
		Check if the specified extension is in the specified group of imaage types.
	Example1:
		void is_image_file_type_ext_ex1()
		{
			string ext = "BMP";
			if (is_image_file_type_ext(ext, IFT_RASTER_AND_VECTOR))
				printf ("%s is in the group\n", ext);
			else
				printf ("%s is not in the group\n", ext);
		}
	Parameters:
		lpcszExt = [input] pointer to the string containing the extension to check for.
		nCtrl = [input] an IFT_* constant that specifies the image types to get from.
	Return: 
		true if extension is in the group, false if not in the group or an error occured.
*/
bool is_image_file_type_ext(LPCSTR lpcszExt, int nCtrl);
/// end IMPROVE_IMG_EXT_TYPE_UTIL_FUNC

///---Sim 08-22-2007 MAKE_IMAGE_TYPE_LIST_SORTED_BY_EXT
/// Comment last updated by Cloud on 6/13/2008
/**$ >Image
	Remarks:
		Get the Image group's File Extension Type description strings for the specified image types and then sort.
		The strings received are in the "Image Type Name (*.Ext)" format.
	Example1:
		void get_image_file_type_descrips_sorted_by_extension_ex1()
		{
			StringArray sa;
			get_image_file_type_descrips_sorted_by_extension(sa);
		}
	Parameters:
		saTypes = [output] string array to receive the strings.
		nCtrl = [input] an IFT_* constant that specifies the image types to get.
	Return: 
		The number of string put into the array or an error number less than zero.
*/
int get_image_file_type_descrips_sorted_by_extension(StringArray& saTypes, int nCtrl = IFT_RASTER_AND_VECTOR);
/// Comment last updated by Cloud on 6/13/2008
/**$ >Image
	Remarks:
		Get the Image group's File Extension Name strings for the specified image types and then sort.
		The strings received are in the "Ext" format.
	Example1:
		void get_image_file_type_extensions_sorted_ex1()
		{
			StringArray sa;
			get_image_file_type_extensions_sorted(sa);
		}
	Parameters:
		saExts = [output] string array to receive the strings.
		nCtrl = [input] an IFT_* constant that specifies the image types to get.
	Return: 
		The number of string put into the array or an error number less than zero.
*/
int get_image_file_type_extensions_sorted(StringArray& saExts, int nCtrl = IFT_RASTER_AND_VECTOR);
///---END MAKE_IMAGE_TYPE_LIST_SORTED_BY_EXT


///Sandy 2006-12-19 MOVE_TO_MATDATA_UTILS.C/H
/*//Sandy 2006-12-9 PALLETE_NEED_WHEN_8BITS
////int image_convert_from_data(const MatrixObject& moSource, MatrixObject& moLBitmap, double dMin, double dMax, int nBits = 16);
//int image_convert_from_data(const MatrixObject& moSource, MatrixObject& moLBitmap, 
						//double dMin, double dMax, int nBits = 16, const HPALETTE hPalette = NULL);
/////Sandy 2006-12-9 add						
//int image_duplicate_palette(const MatrixObject& mo, HPALETTE& hPalette);
*/


//int image_to_gray(BITMAPHANDLE* pLBmp, int gray);

//int image_to_gray(MatrixObject& mo, int gray);	

//bool is_image_grayscale(BITMAPHANDLE* pLBmp);

//bool is_image_grayscale(MatrixObject& mo);
//
//int auto_level_image(MatrixObject& mo, uint uOptions, bool bGetCL = false, LVLCLR* pCL = NULL);

//int adjust_image_brightness(MatrixObject& mo, int a );

//int image_subtract_background(BITMAPHANDLE* pTargetLBmp, BITMAPHANDLE* pSrcLBmp, UINT uChannel, bool bIsHiBG);

//int image_subtract_background(MatrixObject& moImg, MatrixObject& moSrcImg, UINT uChannel, bool bIsHiBG);
///end				

///---Sim 12-23-2006 PUBLIC_IMPORT_IMAGE_TO_GRAPH_UTILITY_FUNCTION
/// Comments last updated by Stacy on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:image_import_to_active_graph_layer_(global_function)
*/
#ifndef __CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF	/// Kenny 07/21/2009 QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF
bool image_import_to_active_graph_layer(LPCSTR lpcszFile);
/// Kenny 07/21/2009 QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF
#else
bool image_import_to_active_graph_layer(LPCSTR lpcszFile, int nX = -1, int nY = -1);
#endif
/// End QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF
///---END PUBLIC_IMPORT_IMAGE_TO_GRAPH_UTILITY_FUNCTION

/// EJP 2007-02-01 v8.0553 QA70-9329 FILE_EXT_GRP_ALL_TYPES
/**$ >Image
		
	Keywords:
		
	Example1:
		
	Parameters:

	Return:
		
	SeeAlso:
		
*/
bool get_file_group_alltypes(string& strAllTypes, LPCSTR lpcszGroup, LPCSTR lpcszNewType = NULL);
/// end FILE_EXT_GRP_ALL_TYPES

///Comments last updated by Sandy on 2007-3-15
/**$ >Image		
	Keywords:
		GIF, Image Format, Export 
	Example1:
		int save_ml_to_gif_ex1(const MatrixLayer& ml, const string& fname)
		{
			if( true == is_sheet_empty(ml))
				return CER_NO_DATA;
			
			foreach(MatrixObject mo in ml.MatrixObjects)
			{
				
				Image imgi(mo);
				if(!imgi.IsValid())
					return XFERR_INVALID_IMAGE;
			}
			
			return save_ml_to_gif(ml, fname);
			
		}		
	Parameters:
		ml = [input] MatrixLayer that contains multi-image.
		fname = [input] output gif file name(including full path)
	Return:
		return OE_NOERROR for success, otherwise return errors
	SeeAlso:
		
*/
int save_ml_to_gif(MatrixLayer& ml, string& fname);
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
void 	gui_update_export_options_for_eps(TreeNode& tr); // EPS	
void	gui_update_export_options_for_jpg(TreeNode& tr); // JPG	
void	gui_update_export_options_for_tif(TreeNode& tr); // TIF	
void	gui_update_export_options_for_bmp(TreeNode& tr); // BMP	
void	gui_update_export_options_for_pdf(TreeNode& tr); // PDF
void	gui_update_export_options_for_gif(TreeNode& tr); // GIF
void	gui_update_export_options_for_cgm(TreeNode& tr); // CGM
void	gui_update_export_options_for_dxf(TreeNode& tr); // DXF
void	gui_update_export_options_for_pcx(TreeNode& tr); // PCX
void	gui_update_export_options_for_png(TreeNode& tr); // PNG
void	gui_update_export_options_for_tga(TreeNode& tr); // TGA
void	gui_update_export_options_for_psd(TreeNode& tr); // PSD	
void	gui_update_export_options_for_wmf(TreeNode& tr); // WMF
void	gui_update_export_options_for_ai(TreeNode& tr);  // AI
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH

///------ Folger 11/22/2010 ORG-1544 SUPPORT_IMAGE_ROTATION_IN_DIGITIZER
class ImageObjTransformHelper
{
public:
	ImageObjTransformHelper(GraphObject& img);

	int		Rotate(double rAngle, COLORREF crFill, UINT nFlags = ROTATE_RESAMPLE);

private:
	pBITMAPHANDLE	GetLeadBitmap();
	void			BeforeTransform();
	void			AfterTransform();

private:
	GraphObject			m_Img;
	BITMAPHANDLE		m_LeadBitmap;
};
///------ End SUPPORT_IMAGE_ROTATION_IN_DIGITIZER

int copy_DIB_to_LeadBitmap(pBITMAPHANDLE pTarget, HDIB hSource); 

///------ Folger 04/23/2012 ORG-2289-P1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
bool is_image_availble_in_clipboard();
///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

#endif // _IMAGE_UTILS_H
