/*------------------------------------------------------------------------------*
 * File Name:fft_utils.h 														*
 * Creation: ER 5/15/03															*
 * Purpose: Origin's internal FFT analysis routines								*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Forest 08/16/04 STFT_INTERFACE_UPDATE                                        *
 * Forest 09/21/04 QA70-6227 CHANGE_PROTOTYPE									*
 * ER 05/27/05 CHANGE_FUNCTION_NAME												*
 * Soapy 07/10/05 QA70-7865 ADD_2D_CORRELATION									*
 * Soapy 07/10/05 QA70-5060 ADD_COHERENCE_FUNCTION								*
 * Raine 2006-04-06 ADD_STFT_COMPLEX											*
 * Arvin 2006-5-23 ADD_GET_WINDOW_DATA											*
 * Arvin 2006-5-22 ADD_GET_FREQUENCE_FROM_INTERNAL								*
 * Arvin 2006-5-22 ADD_FFT_NORM_AMP												*
 * Arvin 2006-5-22 ADD_FFT_FACTOR												*
 * ARVIN 2006-5-22 ADD_FFT_SHIFT												*
 * Arvin 2006-5-22 ADD_FFT_UNWRAP_PHASE											*
 * Arvin 2006-5-10 ADD_APPLY_WINDOW_DATA										*
 *------------------------------------------------------------------------------*/

 
#ifndef _FFTEX_UTILS_H
#define _FFTEX_UTILS_H
#include <..\originlab\fft.h>
#include <ReportTree.h>

//enum {     					// STFT Window method
	//Rectangle_Win = 0,
	//Welch_Win,
	//Triangular_Win,
	//Bartlett_Win,
	//Hanning_Win,
	//Hamming_Win,
	//Blackman_Win,
	//Gaussian_Win,
	//Kaiser_Win,
//};

#define STFT_MAX_OUTPUT_MATRIX_COLS 65536

/// Comments last updated by Sandy on 2007-8-21
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_2d_complex_(global_function)
*/
int fft_2d_complex(int nFFTRow, int nFFTCol, matrix<complex>& mSig, FFT_SIGN iSign = FFT_FORWARD);

// Last updated by Leo on 06/28/05
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_2d_real_(global_function)
*/

// int fft_real_2d(int nFFTRow, int nFFTCol, matrixbase& mSig, FFT_SIGN iSign = FFT_FORWARD); 
// ER 05/27/05 CHANGE_FUNCTION_NAME
// Changed name to be compatible with fft_2d_complex
// int fft_2d_real(int nFFTRow, int nFFTCol, matrixbase& mSig, FFT_SIGN iSign = FFT_FORWARD);
// Leo 6/28/05 CHANGE_FUNCTION_PROTOTYPE
int fft_2d_real(int nFFTRow, int nFFTCol, matrix<complex>& mSig, FFT_SIGN iSign = FFT_FORWARD);


// Comments last updated by Frank on 08/09/05
/** >Analysis
		Create a Rectangle Window.
	Parameters:
		vWin= [output]contains the iSize-point Rectangle window.
		nSize=	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//int RectWin(vector &vWindow, int iSize);

// Comments last updated by Frank on 08/09/05
/** >Analysis
		Create a Triangular Window.
	Parameters:
		vWin = [output]contains the iSize-point Triangular window.
		nSize =	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//int TriWin(vector &vWin, int iSize);

// Comments last updated by Frank on 08/09/05
/** >Analysis
		Create a Bartlett Window.
	Parameters:
		vWin = [output]contains the iSize-point Bartlett window.
		nSize =	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//int BartlettWin(vector &vWin, int iSize);

// Comments last updated by Frank on 08/09/05
/** >Analysis
		Create a Hanning Window.
	Parameters:
		vWin = [output]contains the iSize-point Hanning window.
		nSize =	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//int HanningWin(vector &vWin, int iSize);

// Comments last updated by Frank on 08/09/05
/** >Analysis
		Create a Hamming Window.
	Parameters:
		vWin = [output]contains the iSize-point Hanning window.
		nSize =	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//int HammingWin(vector &vWin, int iSize);

// Comments last updated by Frank on 08/09/05
/** >Analysis
		Create a Blackman Window.
	Parameters:
		vWin  = [output]:contains the iSize-point Blackman window.
		nSize =	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//int BlackmanWin(vector &vWin, int iSize);

// Comments last updated by Frank on 08/09/05
/** >Analysis
		Create a Gaussian Window.
	Parameters:
		vWin = [output]contains the iSize-point Gaussian window.
		nSize = size of the window.
		dAlpha = Alpha parameter of Gaussian window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//int GaussWin(vector &vWin, int iSize, double dAlpha);

// Comments last updated by Frank on 08/09/05
/** >Analysis
		Create a Kaiser Window.
	Parameters:
		vWin = [output]contains the nSize-point Kaiser window.
		iSize =	size of the window.
		dBeta =	Beta parameter of Kaiser window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//int KaiserWin(vector &vWin, int iSize, double dBeta);

// Comments last updated by Raine/Leo on 09/03/06
/** >Analysis
		Create a Welch Window.
	Parameters:
		vWin = [output]contains the iSize-point Welch window.
		nSize =	size of the window.
	Return:	
		Returns 0 for success or error codes for failure.
*/
//int WelchWin(vector &vWin, int iSize);

// Comments last updated by Frank on 08/09/05
/** >Analysis
		Performs Short-Time-Fourier-Transform on a 1d signal.
	Example:
	Parameters:
		vbSig  = [input] the input source signal sequence
		stftOp = [input]		the STFT options, it includes:
				stftOp.FFTLength, the number of points in FFT
				stftOp.SamplingFq, the sampling frequency of the signal
				stftOp.OverlapPt,  the overlaping points of adjacent window
				stftOp.WindowMethod, the window method, see fft_type.h for further information
				stftOp.WinLength, number of points in the window function
				stftOp.Alpha, alpha value for Gaussian window
				stftOp.Belta, belta value for Kaiser window
		matRet  = [output] the result STFT spectrum with time arraged in column wise and the amplitude of each frequency row wise.
		fpScale  = [output] the up-right corner of the spectrum graph.
		     fpScale.x: the maximum time of the STFT spectrum, it's also the XMax of matRet
			 fpScale.y: the maximum frequency of the STFT spectrum, it's also the YMax of matRet
	Return:	
		Returns 0 for success or error codes for failure.
*/
//BOOL STFT(vectorbase& vbSig, const STFTOptions& stftOp, matrix& matRet, fpoint& fpScale); ///Forest 07/21/04, Prototype not identical to fft_utils.c
///Forest 08/16/04 STFT_INTERFACE_UPDATE, vWindow is redundant argument
//int stft(vectorbase& vbSig, vector& vWindow, const STFTOptions& stftOp, matrix& matRet, fpoint& fpScale);
//int stft(vectorbase& vbSig, const STFTOptions& stftOp, matrix& matRet, fpoint& fpScale);
///End STFT_INTERFACE_UPDATE

// Comments last updated by Frank on 08/09/05
/** >>Analysis
		Performs Short-Time-Fourier-Transform on a vector with window function predefined..
	Parameters:
		vbSig = [input]	the input source signal sequence
		vecWin  = [input] the window signal sequence
		matSTFT  = [output]	the result STFT spectrum with time arraged in column wise and the amplitude of each frequency row wise.
		nOverlap  = 	the overlaping points of adjacent window
		nFFTPts = the number of points in FFT
		dFs =	the sampling frequency of the signal
		fpScale =[output]  the up-right corner of the spectrum graph.
		     fpScale.x: the maximum time of the STFT spectrum, it's also the XMax of matSTFT when it is Matrix
			 fpScale.y: the maximum frequency of the STFT spectrum, it's also the YMax of matSTFT when it is Matrix
	Return:	
		Returns 0 for success or error codes for failure.
	SeeAlso:
		get_stft_window_data
*/
//int stft(vectorbase& vbSig, vector& vecWin, matrix& matSTFT, int nOverlap, int nFFTPts, double dFs, fpoint& fpScale );
///Raine 2006-04-06 ADD_STFT_COMPLEX
//int stft_complex(vector& vReal, vector& vImag, matrix& matSTFT, const STFTOptions& stftOp, fpoint& fpScale);
///End ADD_STFT_COMPLEX
/// END CENTRALIZE_CODE_FOR_STFT

// Comments last updated by Frank on 08/09/05
/// AW 05/28/04 QA75-6456 v7.05848 CLEANUP_STFT_HANDLE_ERROR_CODES
/** >>Analysis
		handle error codes.
	Parameters:
		nError =			error codes
		lpcstrErrInfo =[input]	more detail error informatrion for the individual case
	Return:	
		Returns error codes.
*/
//int fft_error_handle(int nError = UNKNOWN_ERROR , LPCSTR lpcstrErrInfo = NULL);
/// END CLEANUP_STFT_HANDLE_ERROR_CODES

// Comments last updated by Frank on 08/09/05
///Soapy 07/10/05 QA70-7865 ADD_2D_CORRELATION
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fft_2d_correlation_(global_function)
*/
int fft_2d_correlation(matrixbase& matSignal1, matrixbase& matSignal2, matrix& matCorrelation, bool bNormalize = true, bool bCircular = true);

// Comments last updated by Frank on 08/09/05
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:correlation_2d_shift_accumulate_(global_function)
*/
int correlation_2d_shift_accumulate(matrixbase& matSignal1, matrixbase& matSignal2, matrixbase& matCorrelation, bool bNormalize = true, bool bCircular = true);
///END ADD_2D_CORRELATION

// Comments last updated by Frank on 08/09/05
///Soapy 07/10/05 QA70-5060 ADD_COHERENCE_FUNCTION
/**
	This function calculate the coherence function of the two signals.
Parameters:
	vecSignal1 = [Input] the signals.
	vecSignal2 = [Input] the signals.
	vecCoherence =  [Output] the coherence function.
	nWinSize =  [Input] the length of the applied window. This function will
		divite both signal1 and signal2 into sections of length nWinSize and estimate the 
		coherence function after applying the specified window on each section. By default (nWinSize = -1),
		the length of the window is equal to the size of the signals.
	iWindowType  = [intput] specify the type of the window applied on each section:
		Rectangle_Win,  	Create a Rectangle Window
		Welch_Win,			Create a Welch Window
		Triangular_Win,		Create a Triangular Window
		Bartlett_Win,		Create a Bartlett Window
		Hanning_Win,		Create a Hanning Window
		Hamming_Win,		Create a Hamming Window
		Blackman_Win,		Create a Blackman Window
		Gaussian_Win,		Create a Gaussian Window
		Kaiser_Win,			Create a Kaiser Window
	nOverlap =  [Input] Number of samples by which the sections overlap. The value of nOverlap should be no more than nWinSize.
		By default (nOverlap = 0), the number of overlap samples is set to 0.
	nfft = [Input] specify the length of FFT coherence function uses.  The value of nFFT should be no less than 1. Use the 
		length of the windows (nWinSize) as nfft when nfft = -1 by default. When nfft > nWinSize, the function performs zero padding to 
		each section; and truncates the sections when nfft < nWinSize.	
	dAlpha =			Alpha value for Gaussian window, As Alpha increases, the width of the Gaussian window will decrease
	dBeta =			Belta value for Kaiser window
Return:
	0 for success or error codes.
*/
//int coherence(vector& vecSignal1, vector& vecSignal2, vector& vecCoherence, 
//		int nWinSize = -1, int iWindowType = Hanning_Win, int nOverlap = 0, int nfft = -1, 
//		double dAlpha = 0.0, double dBeta = 0.0);
///END ADD_COHERENCE_FUNCTION


///Arvin 2006-5-19 ADD_MATRIX_ROTATE
// Comments last updated by Arvin on 2006-5-19
/** >>Analysis
		Perform matrix rotate 180 degree
	Parameters:
		matData = [modify] on input, the matrix will be rotated; on output, the matrix after rotate 
	Return:	
		0 for success or error codes.
	See Also:
		
*/
/**
int matrix_rotate(matrix<complex>& matData);
///END ADD_MATRIX_ROTATE

///Arvin 2006-5-19 ADD_FFT_TRANSFER_TO_MATLAB_FORMAT
// Comments last updated by Arvin on 2006-5-19
/** >>Analysis
		transfer fft2 result matrix to the format of matlab fft2 result in order to compare it with matlab 
	Parameters:
		matData = [modify] on input, matrix contains fft2 results; on output, the matrix in matlab fft2 result format
	Return:	
		0 for success or error codes.
	See Also:
		
*/
/*
int fft_transfer_to_matlab_format(matrix<complex>& matData);
///END ADD_FFT_TRANSFER_TO_MATLAB_FORMAT
*/


/*
///Arvin 2006-5-10 ADD_UPDATA_REPORT_DATA_FUNCTION
static void update_report_data(ReportData& outData, int dir, vector& vFreq, vector& vReal, vector& vImag, vector& vAmp, vector& vPhase, vector& vPower);
///END ADD_UPDATA_REPORT_DATA_FUNCTION
*/

// Comments last updated by Sandy on 2006-5-23
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:stft_real_(global_function)
*/
int stft_real(vector& vSignal, vector& vWin, double dSmplIntv, int nOverlap, int nFFTPts , matrix& matSTFT, double& dScaleTime, double& dScaleFreq );

// Comments last updated by Sandy on 2006-5-23
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:stft_complex_(global_function)
*/
///Sandy 2008-3-20 CLEAN_UP_bGetAmp
///Sandy 2006-7-19 CHANGE_STFT_WITH_COMPLEX_OUTPUT
//int stft_complex(vector<complex>& vSignal, vector& vWin, double dSmplFreq, int nOverlap, int nFFTPts ,matrix& matSTFT, double& dScaleX, double& dScaleY );
//int stft_complex(vector<complex>& vSignal, vector& vWin, double dSmplIntv, int nOverlap, int nFFTPts ,matrix<complex>& matSTFT, matrix& matAmp, double& dScaleTime, double& dScaleFreq,  bool bGetAmp = true);
int stft_complex(vector<complex>& vSignal, vector& vWin, double dSmplIntv, int nOverlap, int nFFTPts ,matrix<complex>& matSTFT, matrix& matAmp, double& dScaleTime, double& dScaleFreq);
//static int apply_window_data(vector& vSignal, int nType);

///Sandy  2006-7-17 COMMENT_SEEM_TO_NO_USED_CODE
/////Sandy 7/12/06 MOVE_FFT_RELATIVE_FUNCIONS_BACK_TO_FFT_UTILS 
////declare error here
////#define FFT_ERROR_COULUMN_ROW_NUMBER_NEGATIVE (-1)
////#define FFT_ERROR_SOURCE_MATRIX_EMPTY (-2)
////#define FFT_ERROR_GETSUBMATRIX_FUNCTION_ERROR	(-3)
////#define FFT_ERROR_GETREAL_FUNCTION_FAIL	(-4)
//
//// Comments last updated by LAS on 01/04/2005
///** >Analysis
		//Performs a 2-dimensional Fast Fourier Transform on a source data matrix
		//of type double. If the source data matrix is in integer form, it needs to be transformed
		//to double using the member function of matrixbase "CastToDouble".
	//Keywords:
		//Fast Fourier Transform;FFT;Matrix, FFT;2D FFT;2-dimensional;2 dimension
	//Example1:
		//// This example computes the 2-dimensional fast fourier transform of the matrix mRe.
	    //int FFT2_ex1()
		//{
			//matrix<double> mRe = {{-1.486782,-0.530723,0.139563,-1.018762},
		                       //{-0.831440 ,0.938971,-0.760729,1.620196},
		                       //{- 0.7794,-0.5500 ,0.6640, -0.4333},
		                       //{-2.0366,1.9275,0.3313,1.1098}};
		   	//matrix <complex> mResult;
			//int ii,jj,Err;
			////test function FFT2 for arbitrary source matrix
			//Err = FFT2(mRe, mResult);
			//if ( 0 != Err ) 
			//{
	        	//ASSERT(false);
	        	//printf("two-dimension FFT2 fails\n");
			//}
			//else
			//{
				//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
					//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
					//printf("\n");
				//}
			//}
			//return 0;
		//}
		////The output is the following:
		////(-0.424101, 0.000000i)  (-1.377089, -0.126954i)  (-1.955942, 0.000000i)  (-1.377089, 0.126954i)  
		////(-0.449501, 0.091251i)  (0.328995, -0.725482i)  (-0.166409, -0.147816i)  (-0.420468, -0.423113i)  
		////(-1.573601, 0.000000i)  (-0.157784, -0.058716i)  (2.491026, 0.000000i)  (-0.157784, 0.058716i)  
		////(-0.449501, -0.091251i)  (-0.420468, 0.423113i)  (-0.166409, 0.147816i)  (0.328995, 0.725482i)  
	//Example2:
	    //// This example computes the 2 dimension fast fourier transform of the matrix mRe, where mRe is assigned the values 
	    ////in the Matrix1, Origin matrix window.
		//int FFT2_ex2(string strMatrixName = "Matrix1")
		//{
			//Matrix Mat1(strMatrixName);
			//if( !Mat1.IsValid() )
			//{
				//printf("%s does not exist.\n", strMatrixName);
				//return 1;
			//}
			//matrix<double> mRe = Mat1;
			//matrix <complex> mResult;
			//int ii,jj,Err;
			////test function FFT2 for arbitrary source matrix
			//Err = FFT2(mRe, mResult);
			//if ( 0 != Err ) 
			//{
		    	//ASSERT(false);
		    	//printf("two-dimension FFT2 fails\n");
			//}
			//else
			//{
				//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
					//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
					//printf("\n");
				//}
			//}
			//return 0;
		//}
		//// If "Matrix1" holds the same values as assigned to mRe in Example1, output will be the same as in Example1.
	//Parameters:
		//matSource		= [input]	The data source matrix which needs to be of type double
		//matFFT2Result	= [output]	The matrix containing the 2 dimension FFT results
		//nRowProcess		= [input]	See nColProcess. default is -1.
		//nColProcess		= [input]	The number of rows or columns.  Default value is -1, which specifies that there is no padding
	 								//or truncating. If the value entered is greater than the size of the matrix, the function will pad with zeros to meet the size
									//If less than, it will truncate the data matrix.
	//Return:
		//Returns 0 on successful exit and an error code on failure.
		//Error codes:
		//-1: Provided column number or row number. Must be -1 or positive integer
		//-2: The data source matrix is empty 
		//-3: When calling member function, it fails.
		//-4: When calling GetReal or GetImage member function of matrix class, it failed.
	//SeeAlso:
		 //Matrix::IFFT2, Matrix::IFFT, Matrix::FFT
		 //
//*/
//int FFT2(matrix& matSource, matrix<complex>& matFFT2Result, int nRowProcess  = -1, int nColProcess = -1);
//
//// Comments last updated by LAS on 01/04/2005
///** >Analysis
		//Performs a 2-dimensional Fast Fourier Transform on a source data matrix
		//of type complex. The member function of matrixbase "MakeComplex" can be used to make a 
		//Complex matrix from two Real matrices (which must have the same dimensions).  
	//KeyWords:
		//Fast Fourier Transform;FFT;Matrix, FFT;2D FFT;2-dimensional;2 dimension
	//Example3:
		////This example computes the 2 dimension fast fourier transform of the matrix mSource. 
		//int FFT2_ex3()
		//{
			//matrix<double> mRe = {{-1.486782,-0.530723,0.139563,-1.018762},
		                       //{-0.831440 ,0.938971,-0.760729,1.620196},
		                       //{- 0.7794,-0.5500 ,0.6640, -0.4333},
		                       //{-2.0366,1.9275,0.3313,1.1098}};
		//
			//matrix<double> mIm = {{2.482,3.5723,0.9553,-1.01842},
		                       //{-1.8317 ,4.38271,-1.0729,1.226},
		                       //{0.7724,-0.5540 ,1.540, -1.333},
		                       //{2.0456,-1.935,2.6513,1.2708}};
		         //
			//matrix <complex> mSource, mResult;
			//mSource.MakeComplex(mRe,mIm);
			//int ii,jj,Err;
			////test function FFT2 for arbitrary source matrix
			//Err = FFT2(mSource, mResult);
			//if ( 0 != Err ) 
			//{
	        	//ASSERT(false);
	        	//printf("two-dimension FFT2 fails\n");
			//}
			//else
			//{
				//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
					//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
					//printf("\n");
				//}
			//}
			//return 0;
		//}
		////The output is as following:
		////(-0.424101, 3.288348i)  (-0.046932, -0.278304i)  (-1.955942, 0.482652i)  (-2.707247, -0.024397i)  
		////(-0.781648, 1.482696i)  (1.243650, -1.742534i)  (-3.635011, -0.976811i)  (-1.411672, 1.741090i)  
		////(-1.573601, -0.080057i)  (1.196919, 0.472184i)  (2.491026, 2.058758i)  (-1.512486, 0.589616i)  
		////(-0.117354, 1.300194i)  (0.570738, 2.587315i)  (3.302194, -0.681179i)  (-0.585660, -0.291571i)  
	//Example4:
		////This example computes the 2 dimension fast fourier transform of the matrix mSource, where mSource is made
		////complex from 2 Real Origin Matrices, Matrix1 and Matrix2. 
		//int FFT2_ex4(string strMRe = "Matrix1", string strMIm = "Matrix2")
		//{
			//Matrix MRe(strMRe);
			//Matrix MIm(strMIm);
			//if( !MRe.IsValid()  ||  !MIm.IsValid() )
			//{
				//printf("%s and/or %s do not exist.\n", strMRe, strMIm);
				//return 1;
			//}
			//matrix<double> mRe = MRe;
			//matrix<double> mIm = MIm;
			//matrix <complex> mSource, mResult;
			//mSource.MakeComplex(mRe,mIm);
			//int ii,jj,Err;
			////test function FFT2 for arbitrary source matrix
			//Err = FFT2(mSource, mResult);
			//if ( 0 != Err ) 
			//{
				//ASSERT(false);
				//printf("two-dimension FFT2 fails\n");
			//}
			//else
			//{
				//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
					//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
					//printf("\n");
				//}
			//}
			//return 0;
		//}
		////If "Matrix1" holds the same values as assigned to mRe  and "Matrix2" holds the same values as mIm in Example3, 
		////output will be the same as in Example3.
	//Parameters:
		//matSource		= [input]  The data source matrix which needs to be of type complex
		//matFFT2Result	= [output] The matrix containing the 2 dimension FFT results
		//nRowProcess		= [input]  See nColProcess. default is -1.
		//nColProcess		= [input]  The number of rows or columns user provided. If they are -1(by default), there is no padding
	 							   //or truncating. If they are more than the sizes of the matrix, the function will pad zero to meet the size
								   //If less than, it will truncate the data matrix.
	//Return:
		//Returns 0 on successful exit and an error code on failure.
		//Error codes:
		//-1: Provided column number or row number. Must be -1 or positive integer
		//-2: The data source matrix is empty 
		//-3: When calling member function, it fails.
		//-4: When calling GetReal or GetImage member function of matrix class, it failed.
	//SeeAlso:
		//Matrix::IFFT2, Matrix::IFFT, Matrix::FFT
  //
//*/
//int FFT2(matrix<complex>& matSource, matrix<complex>& matFFT2Result, int nRowProcess  = -1, int nColProcess = -1);
//
//// Comments last updated by LAS on 01/05/2005
///** >Analysis
		//Performs a 2-dimensional inverse Fast Fourier Transform on a source data matrix
		//of type complex.  The member function of matrixbase "MakeComplex" can be used to make a 
		//Complex matrix from two Real matrices (which must have the same dimensions).  
	//KeyWords:
		//Fast Fourier Transform;Fast Fourier Transform, Inverse;FFT;Matrix, FFT;
	//Example1:
		////This example computes the 2-dimensional inverse fast fourier transform of the matrix mSource. 
		//int IFFT2_ex1()
		//{
			//matrix<double> mRe = {{-1.486782,-0.530723,0.139563,-1.018762},
		                       //{-0.831440 ,0.938971,-0.760729,1.620196},
		                       //{- 0.7794,-0.5500 ,0.6640, -0.4333},
		                       //{-2.0366,1.9275,0.3313,1.1098}};
		//
			//matrix<double> mIm = {{2.482,3.5723,0.9553,-1.01842},
		                       //{-1.8317 ,4.38271,-1.0729,1.226},
		                       //{0.7724,-0.5540 ,1.540, -1.333},
		                       //{2.0456,-1.935,2.6513,1.2708}};
		         //
			//matrix <complex> mSource, mResult;
			//mSource.MakeComplex(mRe,mIm);
			//int ii,jj,Err;
			//Err = IFFT2(mSource, mResult);
			//if ( 0 != Err ) 
			//{
				//ASSERT(false);
				//printf("two-dimension IFFT2 fails\n");
			//}
			//else
			//{
				//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
					//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
					//printf("\n");
				//}
			//}
			//return 0;
		//}
		////The output is the following:
		    ////(-0.424101, 3.288348i)  (-2.707247, -0.024397i)  (-1.955942, 0.482652i)  (-0.046932, -0.278304i)  
			////(-0.117354, 1.300194i)  (-0.585660, -0.291571i)  (3.302194, -0.681179i)  (0.570738, 2.587315i)  
			////(-1.573601, -0.080057i)  (-1.512486, 0.589616i)  (2.491026, 2.058758i)  (1.196919, 0.472184i)  
			////(-0.781648, 1.482696i)  (-1.411672, 1.741090i)  (-3.635011, -0.976811i)  (1.243650, -1.742534i)  
	//Example2:
		////This example computes the 2-dimensional inverse fast fourier transform of the matrix mSource, where mSource is made
		////complex from 2 Real Origin Matrices, Matrix1 and Matrix2. 
		//int IFFT2_ex2(string strMRe = "Matrix1", string strMIm = "Matrix2")
		//{
			//Matrix MRe(strMRe);
			//Matrix MIm(strMIm);
			//if( !MRe.IsValid()  ||  !MIm.IsValid() )
			//{
				//printf("%s and/or %s do not exist.\n", strMRe, strMIm);
				//return 1;
			//}
			//matrix<double> mRe = MRe;
			//matrix<double> mIm = MIm;
		    //matrix <complex> mSource, mResult;
			//mSource.MakeComplex(mRe,mIm);
			//int ii,jj,Err;
			////test function FFT2 for arbitrary source matrix
			//Err = IFFT2(mSource, mResult);
			//if ( 0 != Err ) 
			//{
	        	//ASSERT(false);
	        	//printf("two-dimension FFT2 fails\n");
			//}
			//else
			//{
				//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
					//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
					//printf("\n");
				//}
			//}
			//return 0;
		//}
		////If "Matrix1" holds the same values as assigned to mRe  and "Matrix2" holds the same values as as assigned to mIm in Example1, 
		////output will be the same as in Example1.
	//Example3:
		////This example computes the 2-dimensional fast fourier transform of the matrix mSource. It then computes the 2-dimensional inverse 
		////fast fourier transform of the result matrix, mResult1, which holds the results of the 2D FFT.  The Result then of this 2D IFFT is
		////stored in mResult2, which will hold the same values that you started with in mSource.
		//int IFFT2_ex3()
		//{
			//matrix<double> mRe = {{-1.486782,-0.530723,0.139563,-1.018762},
		                       //{-0.831440 ,0.938971,-0.760729,1.620196},
		                       //{- 0.7794,-0.5500 ,0.6640, -0.4333},
		                       //{-2.0366,1.9275,0.3313,1.1098}};
		//
			//matrix<double> mIm = {{2.482,3.5723,0.9553,-1.01842},
		                       //{-1.8317 ,4.38271,-1.0729,1.226},
		                       //{0.7724,-0.5540 ,1.540, -1.333},
		                       //{2.0456,-1.935,2.6513,1.2708}};
		         //
			//matrix <complex> mSource, mResult1, mResult2;
			//mSource.MakeComplex(mRe,mIm);
			//int ii,jj,Err;
			////test function FFT2 for arbitrary source matrix
			//Err = FFT2(mSource, mResult1);
			//Err = IFFT2(mResult1, mResult2);
			//if ( 0 != Err ) 
			//{
				//ASSERT(false);
				//printf("two-dimension IFFT2 fails\n");
			//}
			//else
			//{
				//for(ii = 0; ii < mResult2.GetNumRows();  ii++)
				//{
					//for(jj = 0; jj < mResult2.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult2[ii][jj].m_re,mResult2[ii][jj].m_im);
					//printf("\n");
				//}
			//}
			//return 0;
		//}
		////The output is the following:
			////(-1.486782, 2.482000i)  (-0.530723, 3.572300i)  (0.139563, 0.955300i)  (-1.018762, -1.018420i)  
			////(-0.831440, -1.831700i)  (0.938971, 4.382710i)  (-0.760729, -1.072900i)  (1.620196, 1.226000i)  
			////(-0.779400, 0.772400i)  (-0.550000, -0.554000i)  (0.664000, 1.540000i)  (-0.433300, -1.333000i)  
			////(-2.036600, 2.045600i)  (1.927500, -1.935000i)  (0.331300, 2.651300i)  (1.109800, 1.270800i)
	//Parameters:
			//matSource	   = [input] The data source matrix
			//matIFFT2Result = [output]The matrix containing the 2-dimensional inverse FFT results
			//nRowProcess	   = [input] See nColProcess. default is -1 
			//nColProcess	   = [input] The number of rows or columns user provided. if they are -1(by default), there are no padding
									 //or truncating. if they are larger than the size of the matrix, the function will pad zero to meet
									 //the size. If less than, it will truncate the data matrix.
	//Return:
		//Returns 0 on successful exit and an error code on failure.
		//Error codes:
			//-1: Provided column number or row number. Must be -1 or positive integer
			//-2: The data source matrix is empty 
			//-3: When calling member function, it fails.
			//-4: When calling GetReal or GetImage member function of matrix class, it failed.
	//SeeAlso:
		//Matrix::FFT, Matrix::FFT2, Matrix::IFFT
//*/
//int IFFT2(matrix<complex>& matSource, matrix<complex>& matIFFT2Result, int nRowProcess  = -1, int nColProcess = -1);
//
//// Comments last updated by LAS on 01/05/2005
///** >Analysis
		//Performs 1-dimensional Fast Fourier Transform on each row of a source data matrix of type double.  If the source data matrix 
		//is in integer form, it needs to be transformed to double using the member function of matrixbase "CastToDouble".
	//KeyWords:
		//Fast Fourier Transform;FFT;Matrix, FFT;FFT, 1D
	//Example1:
		////This example computes the 1-dimensional fast fourier transform on each row of the matrix mRe.
		//int FFT_ex1()
		//{
			//matrix <double> mRe = {{1,2.5,3.5,2,1.0,2.3},{3.2,4.1,2.2,1.0,4,2}};
			//int ii , jj;
			//matrix <complex> mResult;
			////test 1d fft function for arbitrary source matrix.//
			//int Err = FFT(mRe, mResult, -1);
			//if ( 0 != Err ) 
			//{
	       		//ASSERT(false);
	       		//printf("one-dimension FFT fails.\n");
			//}
			//else
			//{
				//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
			    	//for(jj = 0; jj < mResult.GetNumCols(); jj++)
						//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
					//printf("\n");		    
				//}
			//}
			//return 0;
		//}
		////The output is the following:
			////(5.021454, 0.000000i)  (-0.347011, -0.954594i)  (-0.673610, 0.813173i)  (-0.530723, 0.000000i)  (-0.673610, -0.813173i)  (-0.347011, 0.954594i)  
    		////(6.736097, 0.000000i)  (0.877734, -0.106066i)  (-0.796084, -1.378858i)  (0.938971, 0.000000i)  (-0.796084, 1.378858i)  (0.877734, 0.106066i)  
    //Example2:
		////This example computes the 1-dimensional fast fourier transform on each row of the matrix mRe, where mRe is assigned the values 
	    ////in the Matrix1, Origin matrix window.
		//int FFT_ex2(string strMatrixName = "Matrix1")
		//{
			//Matrix Mat1(strMatrixName);
			//if( !Mat1.IsValid() )
			//{
				//printf("%s does not exist.\n", strMatrixName);
				//return 1;
			//}
			//matrix<double> mRe = Mat1;
			//int ii , jj;
			//matrix <complex> mResult;
			////test 1d fft function for arbitrary source matrix.//
			//int Err = FFT(mRe, mResult);
			//if ( 0 != Err ) 
			//{
	       		//ASSERT(false);
	       		//printf("one-dimension FFT fails.\n");
			//}
			//else
			//{
				//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
			    	//for(jj = 0; jj < mResult.GetNumCols(); jj++)
						//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
					//printf("\n");		    
				//}
			//}
			//return 0;
		//}
		////If "Matrix1" holds the same values as assigned to mRe in Example1, output will be the same as in Example1.
	//Example3:
		////This example computes the 1-dimensional fast fourier transform on each row of the matrix matSource; it computes
		////it three times: once without padding, once with padding, and once with truncating
		//int FFT_ex3()
		//{
			//matrix matSource = {{1,2,3,4,5},{6,7,8,9,10}};
			//
			//int nRet;
			//matrix<complex> matResult;
			//nRet = FFT(matSource,matResult);
			//if(nRet)
				//return nRet;
			//int nNumCols = matResult.GetNumCols();
			//int nNumRows = matResult.GetNumRows();
			//int ii, jj;
			//for( ii = 0; ii < nNumRows; ii++)
			//{
				//for(jj = 0; jj < nNumCols; jj++)
					//printf("(%f, %fi)  ",matResult[ii][jj].m_re, matResult[ii][jj].m_im);
				//printf("\n");
			//}
			//printf("now do the padding\n");
			//nRet = FFT(matSource,matResult, 6);
			//if(nRet)
				//return nRet;
			////after The padding	
			//nNumCols = matResult.GetNumCols();
			//nNumRows = matResult.GetNumRows();
			//for( ii = 0; ii < nNumRows; ii++)
			//{
				//for(jj = 0; jj < nNumCols; jj++)
					//printf("(%f, %fi)  ",matResult[ii][jj].m_re, matResult[ii][jj].m_im);
				//printf("\n");
			//}
			//printf("now do the truncting\n");
			////after truncting
			//nRet = FFT(matSource,matResult, 4);
			//if(nRet)
				//return nRet;
			//nNumCols = matResult.GetNumCols();
			//nNumRows = matResult.GetNumRows();
			//for( ii = 0; ii < nNumRows; ii++)
			//{
				//for(jj = 0; jj < nNumCols; jj++)
					//printf("(%f, %fi)  ",matResult[ii][jj].m_re, matResult[ii][jj].m_im);
				//printf("\n");
			//}
			//return nRet;
		//}
		////The output is the following:
			////(6.708204, 0.000000i)  (-1.118034, 1.538842i)  (-1.118034, 0.363271i)  (-1.118034, -0.363271i)  (-1.118034, -1.538842i)  
			////(17.888544, 0.000000i)  (-1.118034, 1.538842i)  (-1.118034, 0.363271i)  (-1.118034, -0.363271i)  (-1.118034, -1.538842i)  
			////now do the padding
			////(6.123724, 0.000000i)  (-2.449490, 0.000000i)  (0.000000, -1.414214i)  (1.224745, 0.000000i)  (0.000000, 1.414214i)  (-2.449490, 0.000000i)  
			////(16.329932, 0.000000i)  (-3.470110, -1.767767i)  (1.020621, -3.181981i)  (3.265986, 0.000000i)  (1.020621, 3.181981i)  (-3.470110, 1.767767i)  
			////now do the truncting
			////(5.000000, 0.000000i)  (-1.000000, 1.000000i)  (-1.000000, 0.000000i)  (-1.000000, -1.000000i)  
			////(15.000000, 0.000000i)  (-1.000000, 1.000000i)  (-1.000000, 0.000000i)  (-1.000000, -1.000000i)  
	//Parameters:
		//matSource	 = [input]  The data source matrix
		//matFFTResult = [output] The matrix containing the 1 dimension FFT results
		//nColProcess  = [input]  The number of columns user provided. If it is -1(by default), function will not do any padding
								//or truncating. But if it is larger than the size of the  matrix, it will pad zero to meet the size
								//if less than, it will truncate the data matrix.
	//Return:
		//Returns 0 on successful exit and an error code on failure.
		//Error codes:
			//-1: Provided column number or row number. Must be -1 or positive integer
			//-2: The data source matrix is empty 
			//-3: When calling member function, it fails.
			//-4: When calling GetReal or GetImage member function of matrix class, it failed.
	//SeeAlso:
		//Matrix::FFT2, Matrix::IFFT2, Matrix::IFFT
//*/
//int FFT(matrix& matSource, matrix<complex>& matFFTResult, int nColProcess = -1);
//
//// Comments last updated by LAS on 01/11/2005
///** >Analysis
		//Performs 1-dimensional Fast Fourier Transform on each row of data in a source data matrix of type complex. 
		//If the data matrix is in integer form, need to be first transformed to complex.  The member function of matrixbase 
		//"MakeComplex" can be used to make a Complex matrix from two Real matrices (which must have the same dimensions). 
	//Keywords:
		//Fast Fourier Transform;FFT;Matrix, FFT;FFT, 1D
	//Example4:
		////This example computes the 1-dimensional fast fourier transform on each row of the matrix mSource.
		//int FFT_ex4()
		//{
			//matrix <double> mRe = {{1,2.5,3.5,2,1.0,2.3},{3.2,4.1,2.2,1.0,4,2}};
			//matrix <double> mIm = {{1,0.5,1.0,0.8,3.1,0.3},{2.2,3.2,3.0,1.5,2,2.1}};
			//int ii , jj;
			//matrix <complex> mSource, mResult;
			//mSource.MakeComplex(mRe,mIm);
		   	////test 1d fft function for complex source matrix.//
			//int Err = FFT(mSource, mResult);
			//if ( 0 != Err ) 
			//{
	       		//ASSERT(false);
	       		//printf("one-dimension FFT fails\n");
			//}
			//else
			//{
		    	//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
			    	//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
			    	//printf("\n");
			    //
				//}
			//}
			//return 0;
		//}
		////The output is as following:
		////	(5.021454, 2.735264i)  (-1.018762, -1.546554i)  (0.139563, 0.547811i)  (-0.530723, 1.428869i)  (-1.486782, -1.078534i)  (0.324740, 0.362634i)  
	    ////  (6.736097, 5.715476i)  (1.620196, 0.240945i)  (-0.760729, -1.970818i)  (0.938971, 0.163299i)  (-0.831440, 0.786898i)  (0.135272, 0.453077i)  
	//Example5:
		////This example computes the 1-dimensional fast fourier transform of the matrix mSource, where mSource is made
		////complex from 2 Real Origin Matrices, Matrix1 and Matrix2. 
		//int FFT_ex5(string strMRe = "Matrix1", string strMIm = "Matrix2")
		//{
			//Matrix MRe(strMRe);
			//Matrix MIm(strMIm);
			//if( !MRe.IsValid()  ||  !MIm.IsValid() )
			//{
				//printf("%s and/or %s do not exist.\n", strMRe, strMIm);
				//return 1;
			//}
			//matrix <complex> mSource, mResult;
			//mSource.MakeComplex(MRe,MIm);
			//int ii , jj;
			////test 1d fft function for complex source matrix.//
			//int Err = FFT(mSource, mResult);
			//if ( 0 != Err ) 
			//{
		    	//ASSERT(false);
		       	//printf("one-dimension FFT fails\n");
			//}
			//else
			//{
			   	//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
			    	//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
			    	//printf("\n");
			    //
				//}
			//}
			//return 0;
		//}
		////If "Matrix1" holds the same values as assigned to mRe  and "Matrix2" holds the same values as assigned to mIm in Example3, 
		////output will be the same as in Example3.
	//Parameters:
		//matSource	 = [input]  The data source matrix
		//matFFTResult = [output] The matrix containing the 1 dimension FFT results
		//nColProcess	 = [input]  The number of columns user provided. If it is -1(by default), function will not do any padding
								//or truncating. But if it is larger than the size of the  matrix, it will pad zero to meet the size
								//if less than, it will truncate the data matrix.
	//Return:
		//Returns 0 on successful exit and an error code on failure.
		//Error codes:
			//-1: Provided column number or row number. Must be -1 or positive integer
			//-2: The data source matrix is empty 
			//-3: When calling member function, it fails.
			//-4: When calling GetReal or GetImage member function of matrix class, it failed.
	//SeeAlso:
		//Matrix::FFT2, Matrix::IFFT2, Matrix::IFFT
//*/
//int FFT(matrix<complex>& matSource, matrix<complex>& matFFTResult, int nColProcess = -1);
//
//// Comments last updated by LAS on 01/18/2005
///** >Analysis
		//Performs 1-dimensional Fast Fourier Transform on data in a complex vector.  If the data vector is in integer or double form, 
		//it must be first transformed to a complex vector.  This function in turn calls the matrix-based FFT function.
	//Keywords:
		//Fast Fourier Transform;FFT;Vector, FFT
	//Example6:
		////This example computes the 1-dimensional Fast Fourier Transform on a complex vector
		//void FFT_ex6()
		//{
			//vector vR = { 1,2.5,3.5,2,1.0,2.3 };
			//vector vI = { 1,0.5,1.0,0.8,3.1,0.3 };
			//vector <complex> vC(vR, vI), vResult(vC.GetSize());
			////tedt 1d fft function on data in a complex vector
			//int Err = FFT(vC, vResult);
			//if ( 0 != Err )
			//{
	       		//ASSERT(false);
	       		//printf("one-dimension FFT fails\n");
			//}
			//else
			//{
		    	//for(int ii = 0; ii < vResult.GetSize();  ii++)
		    	//{
				   	//printf("(%f, %fi)  ",vResult[ii].m_re,vResult[ii].m_im);
			    	//printf("\n");
			   	//}
			//}
		//}
		////The output is as following:
			////(5.021454,  2.735264i)  
			////(-1.018762, -1.546554i)  
			////(0.139563,  0.547811i)  
			////(-0.530723, 1.428869i)  
			////(-1.486782, -1.078534i)  
			////(0.324740,  0.362634i)  
	//Parameters:
			//vecSource	 = [input]  The data source vector
			//vecFFTResult = [output] The vector containing the 1-dimensional FFT result
	//Return:
		//Returns 0 on successful exit and an error code on failure.
	//SeeAlso:
		//Matrix::IFFT
//*/
//// ER 01/29/03 QA70_3802	ADD_VECTOR_FFT_IFFT
//int FFT(vector<complex>& vecSource, vector<complex>& vecFFTResult);
//
//// Comments last updated by LAS on 01/14/2005
///** >Analysis
		//Performs 1-dimensional inverse Fast Fourier Transform on each row of data in a matrix of type complex.
		//The member function of matrixbase "MakeComplex" can be used to make a Complex matrix from two Real matrices 
		//(which must have the same dimensions).  
	//Keywords:
		//Inverse Fast Fourier Transform;FFT;Matrix, FFT;Matrix, IFFT
	//Example1:
		//int IFFT_ex1()
		//{
			//matrix <double> mRe = {{1,2.5,3.5,2,1.0,2.3},{3.2,4.1,2.2,1.0,4,2}};
			//matrix <double> mIm = {{1,0.5,1.0,0.8,3.1,0.3},{2.2,3.2,3.0,1.5,2,2.1}};
			//int ii , jj;
			//matrix <complex> mSource, mResult;
			//mSource.MakeComplex(mRe,mIm);
		   	////test 1d fft function for complex source matrix.//
			//int Err = IFFT(mSource, mResult);
			//if ( 0 != Err ) 
			//{
	       		//ASSERT(false);
	       		//printf("one-dimension FFT fails\n");
			//}
			//else
			//{
		    	//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
			    	//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
			    	//printf("\n");
			    //}
			//}
			//return 0;
		//}
		////The output is the following:
			//(5.021454, 2.735264i)  (0.324740, 0.362634i)  (-1.486782, -1.078534i)  (-0.530723, 1.428869i)  (0.139563, 0.547811i)  (-1.018762, -1.546554i)  
			//(6.736097, 5.715476i)  (0.135272, 0.453077i)  (-0.831440, 0.786898i)  (0.938971, 0.163299i)  (-0.760729, -1.970818i)  (1.620196, 0.240945i)  
	//Example2:
		////This example computes the 1-dimensional inverse fast fourier transform of the matrix mSource, where mSource is made
		////complex from 2 Real Origin Matrices, Matrix1 and Matrix2. 
		//int IFFT_ex2(string strMRe = "Matrix1", string strMIm = "Matrix2")
		//{
			//Matrix MRe(strMRe);
			//Matrix MIm(strMIm);
			//if( !MRe.IsValid()  ||  !MIm.IsValid() )
			//{
				//printf("%s and/or %s do not exist.\n", strMRe, strMIm);
				//return 1;
			//}
			//matrix<double> mRe = MRe;
			//matrix<double> mIm = MIm;
		    //matrix <complex> mSource, mResult;
			//mSource.MakeComplex(mRe,mIm);
			//int ii,jj,Err;
		   	////test 1d fft function for complex source matrix.//
			//Err = IFFT(mSource, mResult);
			//if ( 0 != Err ) 
			//{
	       		//ASSERT(false);
	       		//printf("one-dimension FFT fails\n");
			//}
			//else
			//{
		    	//for(ii = 0; ii < mResult.GetNumRows();  ii++)
				//{
			    	//for(jj = 0; jj < mResult.GetNumCols(); jj++)
				    	//printf("(%f, %fi)  ",mResult[ii][jj].m_re,mResult[ii][jj].m_im);
			    	//printf("\n");
			    //
				//}
			//}
			//return 0;
		//}
	//Parameters:
			//matSource	  = [input] The data source matrix
			//matIFFTResult = [output]The matrix containing the 1-dimensional inverse FFT results
			//nColProcess	  = [input] The number of columns user provided. if it is -1(by default), there is no padding
	 								//or truncating. if it is more than the size of the  matrix, it will pad zero to meet the size
									//if less than, it will truncate the data matrix.
	//Return:
		//Returns 0 on successful exit and an error code on failure.
		//Error codes:
			//-1: Provided column number or row number must be -1 or positve integer
			//-2: The data source matrix is empty 
			//-3: When calling member function, it fails.
			//-4: When calling GetReal or GetImage member function of matrix class, it failed.
	//SeeAlso:
		//Matrix::FFT
//*/
//// ER 01/29/03 QA70_3802	ADD_VECTOR_FFT_IFFT
//int IFFT(matrix<complex>& matSource, matrix<complex>& matIFFTResult, int nColProcess = -1);
//
//// Comments last updated by LAS on 01/18/2005
///** >Analysis
		//Performs a 1-dimensional inverse Fast Fourier Transform on data in a complex vector.  If the data vector is in integer 
		//or double form, it should first be transformed or copied to a complex vector.  This function in turn calls the matrix-based FFT function.
	//Keywords:
		//Inverse Fast Fourier Transform;FFT;Vector, FFT;Vector, IFFT
	//Example1:
		//int IFFT_ex3()
		//{
			//vector vR = { 1,2.5,3.5,2,1.0,2.3 };
			//vector vI = { 1,0.5,1.0,0.8,3.1,0.3 };
			//vector <complex> vC(vR, vI), vResult(vC.GetSize());
			////tedt 1d ifft function on data in a complex vector
			//int Err = IFFT(vC, vResult);
			//if ( 0 != Err )
			//{
	       		//ASSERT(false);
	       		//printf("one-dimension IFFT fails\n");
			//}
			//else
			//{
				//for(int ii = 0; ii < vResult.GetSize();  ii++)
				//{
				   	//printf("(%f, %fi)  ",vResult[ii].m_re,vResult[ii].m_im);
			    	//printf("\n");
				//}
			//}
			//return Err;
		//}
		////The output is as following:
			////(5.021454, 2.735264i)  
			////(0.324740, 0.362634i)  
			////(-1.486782, -1.078534i)  
			////(-0.530723, 1.428869i)  
			////(0.139563, 0.547811i)  
			////(-1.018762, -1.546554i)  
	//Parameters:
			//vecSource	  = [input] The data source vector
			//vecIFFTResult = [output]The vector containing the 1-dimensional inverse FFT results
	//Return:
		//Returns 0 on successful exit and an error code on failure.
	//SeeAlso:
		//Matrix::FFT
//*/
//int IFFT(vector<complex>& vecSource, vector<complex>& vecIFFTResult);
//
//// Comments last updated by LAS on 02/25/2005
///** >Analysis
		//These four functions perform the singular value decomposition on a m * n source data matrix. matSource = matU* matS* matV'
	//Keywords:
		//matrix,singular value decomposition; Matrix,singular value decomposition; SVD; singular value decompostion
	//Example1:
		//int Matrix_SVD_ex1()
		//{	
			//matrix matData= { { 2, 2.5, 2.5}, {2.0, 2.5, 2.5}, {1.6, -0.4, 2.8}, {2.0, -0.5, 0.5}, {1.2, -0.3, -2.9} }; 	
			//printf("The source data\n");
			//int nNumCols = matData.GetNumCols();
			//int nNumRows = matData.GetNumRows();
			//int ii, jj;
			//for( ii = 0; ii < nNumRows; ii++)
			//{
				//for(jj = 0; jj < nNumCols; jj++)
					//printf("%f ",matData[ii][jj]);
				//printf("\n");
			//}
			//matrix matS;	
			//printf("Find the singular value\n");
			//int nRet;
			//if(nRet = SVD(matData, matS))
				//return nRet;
			//nNumCols = matS.GetNumCols();
			//nNumRows = matS.GetNumRows();
			//for( ii = 0; ii < nNumRows; ii++)
			//{
				//for(jj = 0; jj < nNumCols; jj++)
					//printf("%f ",matS[ii][jj]);
				//printf("\n");
			//}
			//printf("Find the U and V\n");
			//matrix matU, matV;
			//if(nRet = SVD(matData, matS, matU, matV))
				//return nRet;
			//printf("U is\n");
			//nNumCols = matU.GetNumCols();
			//nNumRows = matU.GetNumRows();
			//for( ii = 0; ii < nNumRows; ii++)
			//{
				//for(jj = 0; jj < nNumCols; jj++)
					//printf("%f ",matU[ii][jj]);
				//printf("\n");
			//}
			//printf("V is \n");
			//nNumCols = matV.GetNumCols();
			//nNumRows = matV.GetNumRows();
			//for( ii = 0; ii < nNumRows; ii++)
			//{
				//for(jj = 0; jj < nNumCols; jj++)
					//printf("%f ",matV[ii][jj]);
				//printf("\n");
			//}
				//return nRet;
		//}
	//Parameters:
		//matSource=[input]The  m * n source data matrix of type complex
		//matS=[output]The min(m, n) diagonal singular matrix
		//matU=[output]The left side  m * m unitary matrix 
		//matV=[output]The right side n* n unitary matrix
	//Return:
		//Returns 0 on successful exit 
	//SeeAlso:
		//Matrix::Trace
//*/
/////end MOVE_FFT_RELATIVE_FUNCIONS_BACK_TO_FFT_UTILS 
///end  2006-7-17 COMMENT_SEEM_TO_NO_USED_CODE



#endif //_FFT_UTILS_H




