/*------------------------------------------------------------------------------*
 * File Name: event_utils.h	 													*
 * Creation: Echo 6/23/06														*
 * Purpose: Events and event-related fucntions used	in X-functions 				*		
 *			and operations														*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 01/09/07 CHECK_ENTIRE_COLUMN_SELECTED								*
 * Jasmine 01/26/07 CHECK_1_CELL_MODIFICATION									*
 *	ML 2/27/2007 FITCOMPARISON_SHOULD_USE_RANGE_TYPES_FOR_INPUT_REPORTS_SO_THAT_AUTOUPDATE_WORKS
 *  Justin 2007-3-22 v8.0587 CHECK_USER_INPUTED_INTERVAL 						*
 *  Justin 2007-3-23 v8.0588 MOVE_BACK_FFTUTILIS_BECAUSE_COMPILE_ERROR			*
 *	Cloud 04/19/2007 ADD_INTERPOLATION_PREPROCESS								*
 *	Jake 05/10/07 ADD_GET_NUMBER_FROM_STRING									*
 *	Jasmine 08/14/07 QA80-10207 REPORT_SHEET_CHECK_CONFLICT						*
 *	Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
 *	Cheney 2007-8-30 QA70-10290-sug4 FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT	*
 *	CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
 *	Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said			*
 *	Max 3/7/08 SHOULD_PASS_WHOLE_STRING_OF_LPCSZRDLABEL_FOR_LOCALIZATION		*
 *	Max 3/19/08 REWRITE_AND_RENAME_GET_SMOOTH_FACTOR							*
 *	Echo 05/28/08 v8.0871 DETECT_BALANCE_DESIGN									*
 *	Kyle 10/31/08 QA80-12452 SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS		*
 *	Max 11/25/08 QA70-12615 v8.0975d SHARE_SAME_FUNC_FOR_NORMALIZE_AND_VNORMALIZE
 *	Iris 11/20/2008 v8.0975d QA80-12591-P4 REMOVE_LOG_DATA_TYPE_WHEN_DATA_FROM_MATRIX
 *	Sophy 11/21/2008 v8.976 QA80-12591-P3 ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT
 *	Sophy 11/24/2008 v8.978c CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME			*
 *	Kyle 11/25/2008 QA80-12051 GET_XYRANGE_DATA_BASE_ON_RULES					*
 *	Folger 11/27/08 QA80-12356 v8.0980 MORE_TOOLS_NEED_TO_HANDLE_INPUTS_WITH_MISSING_VALUE
 *	TD 12-15-2008 QA80-12786  DYNACONTROL_DOUBLES_TO_SUPPORT_DATE_TIME_INCR_FMTS*
 *	Folger 02/09/09 QA80-12786 DATE_TIME_FORMAT_SUPPORT_IN_XF_GETN				*
 *	Folger 03/12/09 QA80-13261 AUTO_SUPPORT_FOR_NUMBER_OF_POINTS_IN_INTERPOLATE_TOOLS
 *	Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END		*
 *	Folger 03/13/09 QA80-13262 CONVERT_OBJECT_VARIABLE_OPTIOANL_TO_NEW_IN_XF_DIALOG
 *	Jasmine 07/02/09 QA80-12786 Y_DATA_TYPE_NEED_UPDATE_DATA_FORMAT				*
 *	Sophy 7/8/2009 v8.1060 CLEAN_CODE_SUPPORT_UPDATE_Y_DATATYPE_BRANCH			*
 *	Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA			*
 *	Kenny 07/23/2009 QA80-13992 NEW_XF_FOR_GENERAL_MULTI_AXES_PLOTTING			*
 *  Iris 7/29/2009 WREPLACE_AND_MREPLACE_XF_FIX_ALWAYS_ASSUME_REPLACE_RANGE_IS_ACTIVE_PAGE
 *	Hong 08/10/09 QA-13673 ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD			*
 *	YuI 08/19/09 QA70-14173 BRANCHED_RANGES_MAY_BE_INPROPERLY_INITIALIZED_IF_EMPTY_STRING*
 *	Sophy 9/2/2009 IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS				*
 *	Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS			*
 *	Sophy 9/17/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE			*
 *	Iris 10/20/2009 ADD_FFT_PREVIEW_FOR_DECIMATE_XF								*
 *	Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES						*
 *	Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT			*
 *	Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
 *	Folger 08/26/2010 ORG-920-P1 ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
 *	Sim 02-09-2011 ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY							*
 *	Sim 2011-2-24 ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX						*
 *	Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
 *	Folger 01/05/2012 ORG-4773-P1 CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
 *  Junon 10/08/2012 ORG-6359 PROBLEMS_WHEN_SHRINKING_MATRIX_SHEET_WITH_MULTIPLE_OBJECTS_AND_OUTPUT_IS_<INPUT>
 *  Philip 08/15/2012 ORG-6114-S1 ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL*
 *	Philip 08/28/2012 ORG-6114-S2 ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS	*
 *------------------------------------------------------------------------------*/

#ifndef _EVENT_UTILS_H
#define _EVENT_UTILS_H

#include <control.h>
#include <GetNBox.h>

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// Define constants, enums, typedefs, and non-localized strings
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

/// Cloud 04/19/2007 ADD_INTERPOLATION_PREPROCESS
#define MIN_BSPLINE_PTS 4
#define MIN_SPLINE_PTS 2
#define MIN_LINEAR_PTS 2
/// End ADD_INTERPOLATION_PREPROCESS

//#define NLFIT_CHECK_LOOSE_DATASET ///Cheney 2007-10-12 IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
// moved to page_utils
/*
enum{
	WKS_ALL = -1,
	WKS_DATA_SHEET,
	WKS_REPORT_TABLE
};
*/
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

#define STR_ALLOW_REPORT_TO_SOURCE_SHEET_ATTRIB	"ReportToSrcSheet" 
#define STR_ALLOW_REPORT_TO_SOURCE_BOOK_ATTRIB	"ReportToSrcBook" 
///FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
#define STR_NLFIT_OUTPUT_NODE_EVENT_ATTRIB	    "NLFitOutputNodeEvent"
#define NLFIT_OUTPUT_NODE_EVENT				1 
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL

#define	STR_OUTPUT_GUI_CLASS_POINTER	"OutputGUIClassPointer"/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

///Cheney 2007-8-30 QA70-10290-sug4 FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT
//----- CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
/*
#define STR_MATFITTING_REPORTOUT_BOOK_COMBO		(STR_NONE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
///Cheney 2007-10-12 IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
#ifdef NLFIT_CHECK_LOOSE_DATASET
#define STR_LOOSEDATASET_XYFITTING_REPORTOUT_BOOK_COMBO		STR_MATFITTING_REPORTOUT_BOOK_COMBO
#define STR_LOOSEDATASET_XYZFITTING_REPORTOUT_BOOK_COMBO	STR_MATFITTING_REPORTOUT_BOOK_COMBO
#endif //NLFIT_CHECK_LOOSE_DATASET
///end IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
*/
// moved to wksOperation.h and modified
//----- end CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE

///Cheney 2007-9-26 QA70-10388 FIX_BUG_OF_REPORT_RESULT_WHEN_FIT_MATRIX
//#define STR_MATFITTING_RESIDUALOUT_SHEET_COMBO	(STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP)
///FIX_BUG_OF_REPORT_RESULT_WHEN_FIT_MATRIX
///end FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT

///Cheney 2007-9-18 IF_FROM_THEME_SHOULD_NOT_UPDATE_CUSTOM_RANGE
#define		FITTING_CUSTOM_RANGE_MIN_VAL_DEFAULT		-600.
#define		FITTING_CUSTOM_RANGE_MAX_VAL_DEFAULT		600.
///end IF_FROM_THEME_SHOULD_NOT_UPDATE_CUSTOM_RANGE

#define _MOVE_FIT_OUTPUT_TO_OC_CLASS   /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

/// move from fft1.oxf
#define STR_DEFAULT_VALUE_FOR_PLOT_SHEET_NODE	"[<input>]<new template:=graph>"	/// Max 3/8/08 ONLY_RESET_PLOT_SHEET_NODE_WHEN_IT_IS_NOT_MANUALLY_MODIFIED
/// move from pa_basecreate.oxf
#define STR_DEFAULT_TEXT_FOR_REPORT_DATA_NODE	"[<input>]<new>"

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// Declare function prototypes
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

/**$
		event for sample size/power functions
	Parameters:
		tr = [input] treenode of sample size/power function		
*/
bool pss_general_event(TreeNode& tr, bool& bOKEnable, string& strErrMsg);

/**$
		Check of error setting in sample size/power functions
	Parameters:		
		nTail = [intput] tail of the test
		dSD = [input] Standard Deviation
		nMoreData = [input] Flag to decide whether get vData from strData or vDataCol
		strData = [input] data string containing sample sizes/powers to compute, only avaiable if nMoreData = 0
		vDataCol = [input] vector containing sample sizes/powers to compute, only avaiable if nMoreData = 1
		nCalcType = [input] input flag to determine whether sample size or power in the data.	
		wout = [input] worksheet to be output in the functions
		vSizePow= [output] the Sample Size/Vector got. 
*/
//void samplesize_check_error_setting(const int nTail, const double dSD, const string strData, const int nMoreData, const vector vDataCol, const int nCalcType, const Worksheet wout, vector& vSizePow);

int pss_check_indata(const double dSD, const double dAlpha, const int nCalcType, const string strData, const int nMoreData = 0, const vector& vDataCol = NULL, vector& vSizePow = NULL);


/**$
	event for ttest functions
*/
bool ttest_event(TreeNode& trGetN,  bool& bOKEnable, string& strErrMsg, LPCSTR lpsczTest);

bool hyt_set_gui(TreeNode& trGetN, LPCSTR lpsczTest);

int hyt_check_input(TreeNode& trGetN);
/**$
		function to get combo box values form a vector
*/
string get_combo_value(const vector& vTokens, const bool bEditable = true);

/**$
		To set censor list in combo box. Censor list in SA fucntions should be 
		unduplicated data of censor column selected in dialog
	Parameters:
		trRange = [input]Treenode to select censor range
		trCensor = [output]Treenode to be set combo list, which should be censor list for user to select.
	Return:
		return true when successful and return false if fail
		
*/
bool set_censor_list(const TreeNode& trRange, TreeNode& trCensor);

/**$
	Confidence level(s) must be a space seperated list of numberic values > 0 AND < 100 
*/
bool check_conf_level(const string strConfLevel);

bool check_conf_level(const double dConfLev);

bool check_conf_level(const TreeNode& trConfLevel);

//bool check_conf_level(TreeNode& trConfLevel, WndContainer& DynaCntrlContainer);


/**$
		Sample size(s) must be a space seperated list of positive integers larger than 1!
	Return:
		Return OE_NOERROR when successful and return common error code if fail
*/
bool check_sample_size(const string strSampleSize);

bool check_sample_size(const vector& vSampleSize);

/**$
		Power value(s) must be a space seperated list of numeric values > 0  and < 1
	Return:
		Return OE_NOERROR when successful and return common error code if fail
*/
bool check_power(const string strPower);

bool check_power(const vector& vPower);

/**$
		Check whether data input in Survival Analysis(s) are correct. 
	Return:
		Return OE_NOERROR when successful and return common error code if fail
*/
int sa_check_data(const TreeNode trRange,  int nThirdRange = SA_GROUP);

int sa_check_data(const DataRange rData,  int nThirdRange = SA_GROUP);

/// YuI 08/19/09 QA70-14173 BRANCHED_RANGES_MAY_BE_INPROPERLY_INITIALIZED_IF_EMPTY_STRING
/**$
	Check whether input range string for Survival Analysis(s) is correct. 
	Return:
		TRUE if correct, FALSE otherwise
*/
BOOL	sa_check_range_string(LPCSTR lpsszRange);
/// end BRANCHED_RANGES_MAY_BE_INPROPERLY_INITIALIZED_IF_EMPTY_STRING

int km_get_data(const DataRange& dr, vector& vTime, vector& vCensor, vector& vGroup, vector& vNumInGroup, vector<string>& vstrGroup);

/**$
		to check if censoring values can be found in censor range	
	Return:
		Return OE_NOERROR when successful and return common error code if fail
*/
int check_valid_censoring(const vector& vCensoring, const vector& vCensor);

int check_valid_censoring(const TreeNode& trGetN);

/**$
	Significant level must be > 0 and < 1
*/
bool check_sig_level(const double dSigLevel);

//bool check_sig_level(const TreeNode& trSigLevel, WndContainer& DynaCntrlContainer);


/**$
	to check if input is correct, input 2 data are in 1 variable, using group variable to group data
*/
int check_2_data_in_group(const TreeNode& trRange, const bool bPair = false);

/**$
	to check if input is correct, input 2 data are in 2 variables
*/
int check_2_data_in_var(const TreeNode& trRange, const bool bPair = false);

int check_1_column(const TreeNode& trRange, const bool bMultiCol = false, const bool bCol = true);///Jasmine 01/09/07 CHECK_ENTIRE_COLUMN_SELECTED	
	
int check_1_column(const Range& rData, const bool bMultiCol = false, const bool bCol = true);	///Jasmine 01/09/07 CHECK_ENTIRE_COLUMN_SELECTED

int check_1_data(const TreeNode& trRange, const bool bMultiCol = false, const bool bText = false, int* nMinSize = NULL, int* nMaxSize = NULL);	

int check_1_data(const Range& rData, const bool bMultiCol = false, const bool bText = false, int* nMinSize = NULL, int* nMaxSize = NULL);

int check_data_in_group(DataRange& rData);

int check_data_in_group(TreeNode& trRange);

///Kyle 10/31/08 QA80-12452  SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS
int check_input_range_indexed_raw(const TreeNode & trRng, int type, string & strErrMsg);
int check_input_range_indexed_raw(const Range& irng, int type, string &strErrMsg);
///End SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS

///Echo 05/28/08 v8.0871 DETECT_BALANCE_DESIGN
//int check_data_in_var(DataRange& rData, int nLevels);
int check_data_in_var(const DataRange& rData, const int nLevels, const bool bBalance = true);
///end DETECT_BALANCE_DESIGN

int anova2_check_data(Range& rRange);

int anova2_check_data(Range& rRange, vector& vData, vector& vFactor, vector& vSubject, vector<string>& vstrFactor);

///Jasmine 01/26/07 CHECK_1_CELL_MODIFICATION 
int check_1_cell(const TreeNode& trRange);	//LPCSTR lpcszRange	//-- Iris 10/26/06 CHECK_IF_ONE_CELL_FOR_INSERTGRAPH_XF
int check_1_cell(const Range& dr);
///End CHECK_1_CELL_MODIFICATION
string ht_set_hypot_type(const string strName, const string strValue);

string ht_set_null_type(const int nTail, const string strHypoVal, const string strTest);

//Alex 08/02/06 add Null Hypothesis for NPH xfs 
bool nph_add_null_event(TreeNode& trGetN);

// For now this function is applicable only when the TreeNode variable is ReportData type
///------ Folger 08/26/2010 ORG-920-P1 ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
//bool tr_set_optional(const int nEventID, LPCSTR lpcszNodeName, TreeNode& trReportData, const bool bEnabled, LPCSTR lpcszRDLabel);
bool tr_set_optional(const int nEventID, LPCSTR lpcszNodeName, TreeNode& trReportData, const bool bEnabled, LPCSTR lpcszRDLabel, LPCSTR lpcszDisableLabel = NULL);
bool tr_set_optional_ex(int nEventID, LPCSTR lpcszNodeName, TreeNode& trReportData, bool bChangeParam, bool bAnyPlot, LPCSTR lpcszRDLabel = STR_DEFAULT_TEXT_FOR_REPORT_DATA_NODE);
///------ End ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA

/// Max 3/7/08 SHOULD_PASS_WHOLE_STRING_OF_LPCSZRDLABEL_FOR_LOCALIZATION
// So we use tr_set_optional() directly instead
//bool rd_set_optional(const int nEventID, const bool& bOKEnable, LPCSTR lpcszNodeName, TreeNode& trReportData, const bool bEnbled, LPCSTR lpcszRDLabel);
/// END SHOULD_PASS_WHOLE_STRING_OF_LPCSZRDLABEL_FOR_LOCALIZATION

int check_input_range(TreeNode& trRange, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);

int check_input_range(Range& rData, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);

/// Max 10/06/06 move from minterp2.oxf
int get_variable_type(TreeNode& trParam);

bool set_value_for_auto_and_unassigned(TreeNode& trParam, double dVal, bool bIsChangingData = false);

bool set_value_for_auto_and_unassigned(TreeNode& trParam, int nVal, bool bIsChangingData = false);
/**$
*/
bool set_value_for_auto_and_unassigned(TreeNode& trParam, LPCSTR lpcszVal, bool bIsChangingData = false);
/*
bool update_xminmax_show(TreeNode& trGetN, bool bIsChangingData  = false);

bool update_xyminmax_show(TreeNode& trGetN, bool bIsChangingData  = false);
*/
/// TD 12-15-2008 QA80-12786  DYNACONTROL_DOUBLES_TO_SUPPORT_DATE_TIME_INCR_FMTS
/**$
*/
///Sophy 1/12/2012 ORG-2878 FREQ_COUNT_SUPPORT_DATETIME_DISPLAY_IN_GUI
//int get_col_data_format(const TreeNode& tnRange, int nAxisType = OKDATAOBJ_DESIGNATION_X);
///Sophy 4/5/2012 ORG-4611-P1 BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
//int get_col_data_format(const TreeNode& tnRange, int nAxisType = OKDATAOBJ_DESIGNATION_X, string* pstrDateTimeFmt = NULL);
int get_col_data_format(const TreeNode& tnRange, int nAxisType = OKDATAOBJ_DESIGNATION_X, ColFmtInfoPtr pColFmtInfo = NULL);
///end BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
///end FREQ_COUNT_SUPPORT_DATETIME_DISPLAY_IN_GUI
/**$
*/
void set_node_appropriate_numeric_format(const TreeNode& tnNumericData, int nDataFormat, BOOL bInterval=FALSE
										 ///------ Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
										 , LPCSTR pFormatDate = "D10"
										 , LPCSTR  pFormatTime = "T2"
										 ///------ End FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
										 , bool bForDateTimePicker = false	///Sophy 4/5/2012 ORG-4611-P1 BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
										 );
/// end DYNACONTROL_DOUBLES_TO_SUPPORT_DATE_TIME_INCR_FMTS

///------ Folger 02/09/09 QA80-12786 DATE_TIME_FORMAT_SUPPORT_IN_XF_GETN
void update_dataformat_start_end_interval(const TreeNode& trRange, TreeNode& tr, LPCSTR lpcszStartNode, LPCSTR lpcszEndNode, LPCSTR lpcszIntervalNode = NULL, int nAxisType = OKDATAOBJ_DESIGNATION_X	///Jasmine 07/02/09 QA80-12786 Y_DATA_TYPE_NEED_UPDATE_DATA_FORMAT
										  ///------ Folger 08/25/10 ORG-897-P2 FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
										  , LPCSTR pFormatDate = "D10"
										  , LPCSTR  pFormatTime = "T2"
										  ///------ End FITNL_X_DATA_TYPE_FOLLOW_SOURCE_X_DATE_TIME_FORMAT
										  );
///------ End DATE_TIME_FORMAT_SUPPORT_IN_XF_GETN

bool get_data_x_scale(const TreeNode& trGetN, double& xmin, double& xmax);

bool get_data_xy_scale(const TreeNode& trGetN, double& xmin, double& ymin, double& xmax, double& ymax);

bool update_xminmax_show(TreeNode& trGetN);

bool update_xyminmax_show(TreeNode& trGetN);

///------ Folger 03/12/09 QA80-13261 AUTO_SUPPORT_FOR_NUMBER_OF_POINTS_IN_INTERPOLATE_TOOLS
bool update_interp_number_points(TreeNode& trNpts, TreeNode& trInput);
///------ End AUTO_SUPPORT_FOR_NUMBER_OF_POINTS_IN_INTERPOLATE_TOOLS

///
/**$
	Minimun value should not be larger than maximum value
*/
bool check_min_max(const double dMin, const double dMax);

/*
	nType = [input]method to determine the bin intervals 
	0 = increment is to be computed
	1 = interval is to be computed
	2 = both interval and increment are computed
	
	bByBinCenter = [input] specify min & max by bin center if true, else min & max are bin ends
*/
///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
//void set_round_limits(const vector& vData, TreeNode& trMin, TreeNode& trMax, TreeNode& trInc = NULL, TreeNode& trInterval = NULL, int nType = 2);
void set_round_limits(const vector& vData, TreeNode& trMin, TreeNode& trMax, TreeNode& trInc = NULL, TreeNode& trInterval = NULL, int nType = 2, bool bByBinCenter = true);
///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END

void get_min_max(const vector& vData,TreeNode& trMin, TreeNode& trMax);

///Kyle 03/12/2009 QA80-13251 ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END
//void freq_update_inc(const double dMin, const double dMax, const int nStepBy, const int nOutLeft, const int nOutRight, TreeNode& trInc, TreeNode& trIntervals);
void freq_update_inc(const double dMin, const double dMax, const int nStepBy, const int nOutLeft, const int nOutRight, TreeNode& trInc, TreeNode& trIntervals, bool bByBinCenter = true);
///End ADD_OPTION_TO_SPECIFY_BIN_BY_CENTER_OR_END

void freq_update_inc(TreeNode& trGetN);

bool check_intervals(const double dIntervals);

bool check_intervals(TreeNode& trIntervals);

bool check_step_size(const double dInc, const double dMin, const double dMax);

bool check_step_size(TreeNode& trInc);

int check_numeric_matrix(string& strMSheet);

///justin 11/03/2006
/**$
*/
int check_input_double_vector(const TreeNode& trInput, int nNeedMinimumSize =1, bool bPermitMissValue = false, vector<double>& vdData = NULL);

int check_input_complex_vector(const TreeNode& trInput, int nNeedMinimumSize =1, bool bPermitMissValue = false, vector<complex>& vData = NULL);

bool get_error_for_input_double_vector(const TreeNode& trX, string& strErrMsg); //return true if no error 

bool get_error_for_input_complex_vector(const TreeNode& trX, string& strErrMsg); //return true if no error

///justin 11/03/2006 UPDATE_ERROR_MESSAGE
//for xf: conv, corr, deconv
bool get_error_for_2_input_double_vector(const TreeNode& trX, const TreeNode& trH, string& strErrMsg);
//end UPDATE_ERROR_MESSAGE

///Justin 2007-3-22 v8.0587 CHECK_USER_INPUTED_INTERVAL
//int auto_compute_sampling_interval_from_InputData(const TreeNode& trInput, TreeNode& trInterval); ///Justin 2007-3-23 v8.0588 MOVE_BACK_FFTUTILIS_BECAUSE_COMPILE_ERROR
int check_interval(TreeNode& trInterval, bool bFailToSetOne = false);
///End CHECK_USER_INPUTED_INTERVAL


//end 
/**$
 Return:
 	0 if no error
*/
int get_graph_input_xyrange(const TreeNode& trXY, DataPlot& dp, XYRange& xy);

///Sandy 2006-11-6
//bool get_error_for_input_xyrange(const TreeNode& trXY, string& strErrMsg,  int& nSize, XYRange& xy = NULL);//---CPY 5/6/09 QA70-13568 STATCK_PLOT_FAILED_FOR_X_COL_OF_ALL_TEXT, added bAllowMissing
bool get_error_for_input_xyrange(const TreeNode& trXY, string& strErrMsg,  int& nSize, XYRange& xy = NULL, bool bAllowMissing=false);
//---- CPY 12/12/06
// return false if trXY is not valid
bool get_output_xyrange_err_info(const TreeNode& trXY, string& strErrMsg, XYRange& xy = NULL);
//----

///Joseph	12/07/06	ADD_MESSAGE_BOX
bool handle_dialog_errmsg(TreeNode&	trGetN, const bool bHaveErrMsg, LPCSTR	lpcszErrMsg, bool bOKEnable = true);
///End	ADD_MESSAGE_BOX

///Echo 12/13/06
//To check whether delimiter of input string is space
bool check_delimiter_space(const string str);

///zachary 12/13/06 GET_SINGLE_XYRANGE_TYPE
// Get XYRange type: PDS_NEW, PDS_OPTIONAL, PDS_USER... , this is useful for an output XYRange.
int get_xyrange_type(TreeNode& trXYRange);
//End GET_SINGLE_XYRANGE_TYPE

BOOL	is_optional_by_dyna_use_checkbox(TreeNode& tr);
///---Sim 2011-2-24 ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX
//BOOL 	has_dyna_use_checkbox(TreeNode& tr);
BOOL 	has_dyna_use_checkbox(TreeNode& tr, int *pnCheck = NULL);
BOOL	set_dyna_use_checkbox(TreeNode& tr, int nCheck);
///---END ORG-2294-S1 SUPPORT_OUTPUT_VIRTUAL_MATRIX
bool fitcmp_get_rt(const string strRT, Tree& trRes, Tree& trGUI);
/// ML 2/27/2007 FITCOMPARISON_SHOULD_USE_RANGE_TYPES_FOR_INPUT_REPORTS_SO_THAT_AUTOUPDATE_WORKS
bool fitcmp_get_rt(Range &rngRT, Tree& trRes, Tree& trGUI);
/// end FITCOMPARISON_SHOULD_USE_RANGE_TYPES_FOR_INPUT_REPORTS_SO_THAT_AUTOUPDATE_WORKS

int fitcmp_event(TreeNode trGetN, bool bSameModel);

///Joseph 04/02/07 ADD_NLSF_ERR_MSG_EVENT
bool check_is_positive_integer(const TreeNode& trInterval);

bool check_margin_value(const TreeNode& trMarginVal);
///End ADD_NLSF_ERR_MSG_EVENT

/// Cloud 04/19/2007 ADD_INTERPOLATION_PREPROCESS
//bool update_xvector_show(TreeNode& trGetN);	/// no need
///Kyle 11/25/2008 QA80-12051 GET_XYRANGE_DATA_BASE_ON_RULES
//int interpolation_preprocess(const vector& xi, const XYRange& yi, vector& vxIn, vector& vyIn, int& npts, vector& vyOut, int method, vector& vcof=NULL);
//------ Folger 11/27/08 QA80-12356 v8.0980 MORE_TOOLS_NEED_TO_HANDLE_INPUTS_WITH_MISSING_VALUE
//int interpolation_preprocess(const vector& xi, const XYRange& yi, vector& vxIn, vector& vyIn, int& npts, vector& vyOut, int method, vector& vcof=NULL, DWORD dwRules = DRR_BAD_WEIGHT_TREATMENT);
int interpolation_preprocess(const vector& xi, const XYRange& yi, vector& vxIn, vector& vyIn, int& npts, vector& vyOut, int method, vector& vcof=NULL, DWORD dwRules = DRR_BAD_WEIGHT_TREATMENT, vector<int> *pvnMissingValsIndices = NULL, bool bSortAndRemoveDuplicates = true
							 ///------ Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
							 , BOOL bGetData = TRUE
							 ///------ End AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
							 );
//------
///End GET_XYRANGE_DATA_BASE_ON_RULES
/// End ADD_INTERPOLATION_PREPROCESS

//----Jake 05/10/07 ADD_GET_NUMBER_FROM_STRING
//bool is_right_string_format(const string& strString);///Jake 06/12/07
//int get_number_from_string(const string& strString, vector<int>& vNums, int nMax);///Jake 06/12/07
bool is_correct_origin_object_index_range(const string& strString);
///------ Folger 01/05/2012 ORG-4773-P1 CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
//int get_indices_from_origin_object_index_range_string(const string& strString, vector<int>& vNums, int nMax);
int get_indices_from_origin_object_index_range_string(const string& strString, vector<int>& vNums, int nMax, string* pstrErrMsg = NULL, int nInvalidIndexErrMsg = XFERR_INVALID_DEST_LAYER);
///------ End CLEANUP_ERR_MSG_FOR_INVALID_INDEX_OF_ORIGIN_OBJECT
//----end ADD_GET_NUMBER_FROM_STRING

/// Max 3/19/08 REWRITE_AND_RENAME_GET_SMOOTH_FACTOR
/// Cloud 07/25/2007 CALCULATE_SMOOTH_FACTOR
//bool get_smooth_factor(TreeNode trGetN);
/// End CALCULATE_SMOOTH_FACTOR
double get_smooth_factor_for_bspline(const TreeNode trInputData);
/// END REWRITE_AND_RENAME_GET_SMOOTH_FACTOR

///Jasmine 08/14/07 QA80-10207 REPORT_SHEET_CHECK_CONFLICT
bool is_same_sheet(TreeNode trRd, TreeNode trRt);
///End REPORT_SHEET_CHECK_CONFLICT

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool update_output_curve_book_setting(TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, string& str2ndPart, LPCSTR lpcszBook = NULL);
//bool update_output_curve_book_option(TreeNode& trGUI, string& str2ndPart, int nCurveBookType, LPCSTR lpcszBook = NULL);
//bool output_curve_book_event(TreeNode& trGUI, LPCSTR lpcszBook = NULL);
#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
bool update_output_curve_book_setting(TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, string& str2ndPart, LPCSTR lpcszBook = NULL, bool bIsNLFitOutputEvent = false);
bool update_output_curve_book_option(TreeNode& trGUI, string& str2ndPart, int nCurveBookType, LPCSTR lpcszBook = NULL, bool bIsNLFitOutputEvent = false);
bool output_curve_book_event(TreeNode& trGUI, LPCSTR lpcszBook = NULL, bool bIsNLFitOutputEvent = false);
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool output_report_book_event(TreeNode& trGUI, LPCSTR lpcszBook = NULL);
bool output_report_book_event(TreeNode& trGUI, LPCSTR lpcszBook = NULL, bool bIsNLFitOutputEvent = false);
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
bool build_report_book_option(TreeNode& trBook, bool bAllowToSource = true, LPCSTR lpcszBook = NULL);

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void build_output_book_sheet_option(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet = false, bool bAllowReportToSrcBook = true, LPCSTR lpcszBook = NULL);
void build_output_book_sheet_option(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet = false, bool bAllowReportToSrcBook = true, LPCSTR lpcszBook = NULL, bool bIsNLFitOutputEvent = false);
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void show_report_column_option(TreeNode& trGUI);
void show_report_column_option(TreeNode& trGUI, bool bIsNLFitOutputEvent = false);
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void check_ask_custom_book_sheet_name(TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL, int nBookSheetType = 0);
void check_ask_custom_book_sheet_name(TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL, int nBookSheetType = 0, bool bIsNLFitOutputEvent = false);
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS

/// Iris 4/01/2008 v8.0834 MOVE_GET_SOURCE_PAGE_NAME_TO_PAGE_UTILS
/*
void get_project_pages_name(vector<string> &vsPagesName, uint nPageType  = EXIST_WKS);

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//string get_source_page_name(TreeNode& trOperation, string *pstrLayerName = NULL);
/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
//string get_source_page_name(TreeNode& trOperation, string *pstrLayerName = NULL, bool bIsNLFitOutputEvent = false);
#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS bIsNLFitOutputEvent used to make diff way to get Input branch, so pass Input branch better
string get_source_page_name(TreeNode& trGUI, string *pstrLayerName = NULL, bool bIsNLFitOutputEvent = false);
#else
string get_source_page_name(TreeNode& trGUI, string *pstrLayerName = NULL, TreeNode& trInput = NULL);
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
*/
string xf_get_source_page_name(TreeNode& trGUI, string *pstrLayerName = NULL);
///end MOVE_GET_SOURCE_PAGE_NAME_TO_PAGE_UTILS

//string get_sheets_in_book(const Page& pg, int nSheetType = WKS_ALL);   ///Sophy, moved to page_utils.h
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
//string get_source_page_name(const DataRange& drInput, string *pstrLayerName=NULL);///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING ///Jasmine 10/15/07 MOVE_TO_PAGE_UTILS
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void	update_output_report_and_curve_setting(TreeNode& trGUI, LPCSTR lpcszSrcPageName); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS bIsNLFitOutputEvent used to make diff way to get Input branch, so pass Input branch better
void	update_output_report_and_curve_setting(TreeNode& trGUI, LPCSTR lpcszSrcPageName, bool bIsNLFitOutputEvent = false); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS
///end  MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
//bool 	update_output_book_sheet_destination(TreeNode& trOutput, LPCSTR lpcszBookList = NULL, LPCSTR lpcszBookDefault = NULL, LPCSTR lpcszSheetList = NULL, LPCSTR lpcszSheetDefault = NULL);
//void	get_selected_book_sheet_name(const TreeNode& trBook = NULL, const TreeNode& trSheet = NULL, string& strSelectedBookName = NULL, string& strSelectedSheetName = NULL);
enum
{
	OP_GENERAL_TOOL 		= -1,
	OP_XY_FITTING_TOOL		= NLFIT_GENERAL_XY_FITTING,
	OP_XYZ_FITTING_TOOL,
	OP_MAT_FITTING_TOOL,
};

#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
bool 	update_output_book_sheet_destination(TreeNode& trOutput, LPCSTR lpcszBookList = NULL, LPCSTR lpcszBookDefault = NULL, LPCSTR lpcszSheetList = NULL, LPCSTR lpcszSheetDefault = NULL, int nOutputType = OPERATION_OUTPUT_GENERAL, int nBookSheetType = IDE_REOPRT_BOOK, int nOPType = OP_GENERAL_TOOL);
void	get_selected_book_sheet_name(const TreeNode& trBook, const TreeNode& trSheet = NULL, int nOutputType = OPERATION_OUTPUT_GENERAL, int nBookSheetType = IDE_REOPRT_BOOK, string& strSelectedBookName = NULL, string& strSelectedSheetName = NULL);
string 	get_output_destination_default_setting(int nBookSheetType = IDE_REOPRT_BOOK, int nOPType = OP_GENERAL_TOOL);
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS
///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX

#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
void get_residual_combo(int nFitType, bool bPlotFitCurve, string& strResidualBookCombo, string& strResidualSheetCombo);
void get_findxy_combo(int nFitType, bool bPlotFitCurve, string& strFindXYBookCombo, string& strFindXYSheetCombo);
///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS

///Echo 9/12/07
int dr_get_col_percent_text(const DataRange& dr, const int nIndex, bool bSkipMissing =  false);

#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
void 	set_report_output_book_name_by_type(TreeNode& trGUI, bool bIsNLFitOutputEvent = false);
void 	set_report_output_sheet_name_by_type(TreeNode& trGUI);
void	set_report_output_book_sheet_name_by_type(TreeNode& trGUI);
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS
///Sophy 4/11/2008 Sophy 4/14/2008 CHECK_REPORT_DATA_BOOK_NAME_DIFFERENT
static bool _is_book_sheet_name_the_same(TreeNode& trReport, TreeNode& trOther);
int check_report_book_curve_book(TreeNode& trGUI, string& strRet);
///end CHECK_REPORT_DATA_BOOK_NAME_DIFFERENT


///Sophy 7/8/2009 v8.1060 CLEAN_CODE_SUPPORT_UPDATE_Y_DATATYPE_BRANCH
///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
//void check_set_datatype(TreeNode& trGUI, bool bCheckX = true);
///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
//void check_set_datatype(TreeNode& trGUI, TreeNode& trInput, bool bCheckX = true);
void check_set_datatype(TreeNode& trGUI, TreeNode& trInput, int nFitType, bool bCheckX = true);
///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
///end NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
///end CLEAN_CODE_SUPPORT_UPDATE_Y_DATATYPE_BRANCH
//----------- Iris 11/20/2008 v8.0975d QA80-12591-P4 REMOVE_LOG_DATA_TYPE_WHEN_DATA_FROM_MATRIX
///Sophy 11/24/2008 v8.978c CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME
//void change_indep_data_type_combo_on_source_page_type(TreeNode& tr);
///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
//void change_indep_data_type_combo_on_source_page_type(TreeNode& tr, bool& bSourceFromGraph = NULL);
///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
//void change_indep_data_type_combo_on_source_page_type(TreeNode& tr, TreeNode& trInput, bool& bSourceFromGraph = NULL);
void change_indep_data_type_combo_on_source_page_type(TreeNode& tr, TreeNode& trInput, int nFitType, bool& bSourceFromGraph = NULL);
///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
///end NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
///end CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME
//-----------
///Sophy 11/24/2008 v8.978c CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME
void check_set_xdatatype_value(TreeNode& tr);
///end CHECK_SET_XDATATYPE_VALUE_ON_APPLY_THEME

///Sophy 11/21/2008 v8.976 QA80-12591-P3 ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT

int	check_input_logx_datatype(TreeNode& trInput, TreeNode& trDataType);

int check_logx_customize_x_range(TreeNode& trDataType);

///end ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT

/// Max 11/25/08 QA70-12615 v8.0975d CENTRALIZE_FOR_NORMALIZE_AND_VNORMALIZE
bool normalize_make_datainfo_tree(TreeNode& tr, LPCSTR lpcszVarName);

bool normalize_set_datainfo(const vector& vData, TreeNode& trDataInfo);

/// Hong 08/10/09 QA-13673 ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD
//string normalize_get_method_string(const int nMethod, const double dValue);
///Sophy 9/2/2009 IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
//string normalize_get_method_string(const int nMethod, const double dValue, int nSubMethod = 0);
enum {
	XF_NORMALIZE	= 0,
	XF_RNORMALIZE	= 1,
	XF_CNORMALIZE	= 2,
};
string normalize_get_method_string(LPCSTR lpcszSrc, const int nMethod, const double dValue, int nSubMethod = 0, const Column& colRef = NULL, int nNormXF = XF_NORMALIZE);
///end IMPROVE_COMMENTS_FOR_NORMALIZE_RESULT_COLUMNS
/// end ADD_COMMENT_FOR_USE_REFERENCE_COLUMN_METHOD
/// ------

///------ Folger 03/13/09 QA80-13262 CONVERT_OBJECT_VARIABLE_OPTIOANL_TO_NEW_IN_XF_DIALOG
void	check_convert_optional_outputs_to_new(TreeNode& trGetN);
///------ End CONVERT_OBJECT_VARIABLE_OPTIOANL_TO_NEW_IN_XF_DIALOG

/// Iris 7/14/2009 QA80-13941 SUPPORT_MORE_OPTIONS_FOR_WREPLACE_AND_MREPLACE_XF
enum
{
	OPTION_LOOK_IN_INVALID			= -100,
	OPTION_ACTIVE_MATRIX_OBJECT		= OPTION_ACTIVE_PAGE - 2,
	OPTION_ACTIVE_SHEET				= OPTION_ACTIVE_PAGE - 1,
};
int get_lookin_options(int nSel, int nPageType);
///end SUPPORT_MORE_OPTIONS_FOR_WREPLACE_AND_MREPLACE_XF

/// Kenny 07/23/2009 QA80-13992 NEW_XF_FOR_GENERAL_MULTI_AXES_PLOTTING, moved from plotstack.OXF
int convert_gui_plot_type(const int nPlot);
/// End QA80-13992 NEW_XF_FOR_GENERAL_MULTI_AXES_PLOTTING

/// Iris 7/29/2009 WREPLACE_AND_MREPLACE_XF_FIX_ALWAYS_ASSUME_REPLACE_RANGE_IS_ACTIVE_PAGE
bool get_page_datasheet_from_range(Range& rng, Page* ppage = NULL, Datasheet* psheet = NULL);
///end WREPLACE_AND_MREPLACE_XF_FIX_ALWAYS_ASSUME_REPLACE_RANGE_IS_ACTIVE_PAGE

/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS, centralize the code in insertuservar and rangebrowser
#define	STR_INSERTMODE				"InsertMode"

enum
{
	INSERT_MODE_NAME	= 0,
	INSERT_MODE_INDEX	= 1,
};

///Sophy 9/17/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
enum {
	SMART_RANGE_VAR	= 0x0001, //when is inserting range variable
	SMART_INFO_VAR	= 0x0002, //when is inserting information variable
	SMART_COL_LABEL	= 0x0004, //when is inserting column label
	SMART_TRIM_CLN	= 0x0008, //remove column long name, when in same book and sheet name has white space, like "She et1"!A"ee", VC level code fail to resolve it, shoud trim column LN ///Sophy 9/18/2009 SMART_PAGE_FAIL_TO_SOLVE_RANGE_WHEN_SHEETNAME_HAS_WHITE_SPACE_AND_COLUMN_HAS_LONGNAME
};
///end SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
#define STR_INSERT_MODE_NAME	_L("Sheet/Column Name")
#define STR_INSERT_MODE_INDEX	_L("Sheet/Column Index")

class ObjNameInfo 
{
public:
	///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	//ObjNameInfo(UINT _nSelectedColUID = 0, int _nInsertMode = INSERT_MODE_NAME, int _nObjLevel = PTL_PAGE, bool _bFullRange = true, DWORD _Ctrl = 0)
	//{
	//	nSelectedColUID	= _nSelectedColUID;
	ObjNameInfo(UINT _nSelectedObjUID = 0, int _nInsertMode = INSERT_MODE_NAME, int _nObjLevel = PTL_PAGE, bool _bFullRange = true, DWORD _Ctrl = 0)
	{
		nSelectedObjUID	= _nSelectedObjUID;
	///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
		nInsertMode		= _nInsertMode;
		nObjLevel		= _nObjLevel;
		bFullRange		= _bFullRange;
		dwSmartCtrl		= _Ctrl;
	}
public:
	///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	/*
	UINT			nSelectedColUID;
	WorksheetPage	wkp;
	Worksheet		wks;
	Column			col;
	*/
	UINT			nSelectedObjUID;
	Page			pg;
	Layer 			layer;//Datasheet		ds;	///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
	DataObject		obj;
	///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	int				nInsertMode;
	int				nObjLevel;
	bool			bFullRange;
	DWORD			dwSmartCtrl;		///Sophy 9/17/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
};

///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
//typedef bool (*PFN_GET_WORKSHEET_OBJ_BY_COL_UID)(const UINT nColUID, WorksheetPage& wkp, Worksheet& wks, Column& col);
//bool get_worksheet_obj_by_col_uid(const UINT nColUID, WorksheetPage& wkp, Worksheet& wks, Column& col);
typedef bool (*PFN_GET_WORKSHEET_OBJ_BY_COL_UID)(const UINT nObjUID, Page& pg, Datasheet& ds, DataObject& obj);
bool	get_worksheet_obj_by_col_uid(const UINT nObjUID, Page& pg, Datasheet& ds, DataObject& obj);
///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES

typedef bool (*PFN_SMART_UPDATE_OBJ_RANGE)(string& strObjName, ObjNameInfo& info);
bool smart_update_obj_range(string& strObjName, ObjNameInfo& info);
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

///---Sim 02-09-2011 ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY
typedef bool (*PFN_CHECK_CALIBRATION_FINDXY_BRANCH)(TreeNode trCalibration, TreeNode trFindXYOutput);
bool check_calibration_findxy_branch(TreeNode trCalibration, TreeNode trFindXYOutput);
///---END ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY

/// Iris 2/15/2011 ORG-402 PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX
#define STR_SURFACE_PLOT_TYPE_IDS_ATTRIB		"SurfacePlotIDs"
int get_surface_plot_id(const TreeNode& trSurfacePlotType);
///End PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX

/// Iris 3/04/2011 ORG-402-S7 NEED_SHOW_SURFACE_PLOT_TYPE_COMBO_IN_OLD_OPJ
bool set_surface_plot_id(TreeNode& trSurfacePlotType, int nPlotID);
///End NEED_SHOW_SURFACE_PLOT_TYPE_COMBO_IN_OLD_OPJ

/// Iris 3/30/2011 ORG-2539-P1 FIX_NLBEGINZ_BAD_FITCURVE_IN_REPORT_GRAPH
void init_surface_plot_id(const TreeNode& trSurfacePlotType, DataRange& drSource);
///End FIX_NLBEGINZ_BAD_FITCURVE_IN_REPORT_GRAPH

bool is_change_parameter(TreeNode& trGUI);
bool report_to_flat_sheet_check_event(TreeNode& trGUI, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg);

///Junon 10/08/2012 ORG-6359 PROBLEMS_WHEN_SHRINKING_MATRIX_SHEET_WITH_MULTIPLE_OBJECTS_AND_OUTPUT_IS_<INPUT>
BOOL xf_is_matrix_obj_output_allowed(TreeNode& trInput, TreeNode& trOutput);
///End PROBLEMS_WHEN_SHRINKING_MATRIX_SHEET_WITH_MULTIPLE_OBJECTS_AND_OUTPUT_IS_<INPUT>

///Philip 08/15/2012 ORG-6114-S1 ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL
bool update_method_int_map(const vector<string>& vsNewIntMap, TreeNode& trGetN);
///end ADD_NORMALIZE2_0_100_OPTION_FOR_NORMALIZE_TOOL

///Philip 08/28/2012 ORG-6114-S2 ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS
#define STR_REF_COL_OLD_VAL			"RefColValue"
#define STR_REF_CELL_OLD_VAL		"RefCellValue"
#define CONST_DISABLE_DROPDOWN_BTN	0x00000400/*ICOPT_NO_DROP_DOWN_BUTTON*/
int normalize_check_err_condition(TreeNode& trGetN, int nNormXF, int method_specify, int method_ref, int method_cell);
double normalize_get_ref_cell_value(const DataRange& drCell, const int nRowIndex = -1);
void normalize_check_reset_ref_range(TreeNode& trRange, int nCurrentMethod, int nCheckMethod, LPCSTR lpcszOldValAttribte);
void normalize_check_update_old_ref_range_attrib(TreeNode& trGetN);
///end ADD_USE_REF_COL_AND_DIV_BY_REF_CELL_OPTIONS





#endif // _EVENT_UTILS_H