/*------------------------------------------------------------------------------*
 * File Name: conio.h															*
 * Creation: AW 10/21/2003														*
 * Purpose: Origin C header	for basic I/O										*
 * Copyright (c) OriginLab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _CONIO_H
#define _CONIO_H



// basic Console I/O
#pragma dll(msvcrt, system)

/** >Basic I/O
Return:
	The functions return the byte, word, or double word read from port. There is no error return.
Parameter:
	port = Port number
Remarks:
	The _inp, _inpw, and _inpd functions read a byte, a word, and a double word, respectively, from
	the specified input port. The input value can be any unsigned short integer in the range 0  65,535.
*/
int _inp( unsigned short port );

/** >Basic I/O
Return:
	The functions return the byte, word, or double word read from port. There is no error return.
Parameter:
	port = Port number
Remarks:
	The _inp, _inpw, and _inpd functions read a byte, a word, and a double word, respectively, from the 
	specified input port. The input value can be any unsigned short integer in the range 0  65,535.
*/
unsigned short _inpw( unsigned short port );

/** >Basic I/O
Return:
	The functions return the byte, word, or double word read from port. There is no error return.
Parameter:
	port = Port number
Remarks:
	The _inp, _inpw, and _inpd functions read a byte, a word, and a double word, respectively, from the
	specified input port. The input value can be any unsigned short integer in the range 0  65,535.
*/
unsigned long _inpd( unsigned short port );

/** >Basic I/O
Return:
	The functions return the data output. There is no error return.
Parameters:
	port = Port number
	databyte = Output values
	dataword = Output values
Remarks:
	The _outp, _outpw, and _outpd functions write a byte, a word, and a double word, respectively, to the
	specified output port. The port argument can be any unsigned integer in the range 0  65,535; databyte
	can be any integer in the range 0  255; and dataword can be any value in the range of an integer, an
	unsigned short integer, and an unsigned long integer, respectively.
*/
int _outp( unsigned short port, int databyte );

/** >Basic I/O
Return:
	The functions return the data output. There is no error return.
Parameters:
	port = Port number
	databyte = Output values
	dataword = Output values
Remarks:
	The _outp, _outpw, and _outpd functions write a byte, a word, and a double word, respectively, to the
	specified output port. The port argument can be any unsigned integer in the range 0  65,535; databyte
	can be any integer in the range 0  255; and dataword can be any value in the range of an integer, an
	unsigned short integer, and an unsigned long integer, respectively.
*/
unsigned short _outpw( unsigned short port, unsigned short dataword );

/** >Basic I/O
Return:
	The functions return the data output. There is no error return.
Parameters:
	port = Port number
	databyte = Output values
	dataword = Output values
Remarks:
	The _outp, _outpw, and _outpd functions write a byte, a word, and a double word, respectively, to the
	specified output port. The port argument can be any unsigned integer in the range 0  65,535; databyte
	can be any integer in the range 0  255; and dataword can be any value in the range of an integer, an
	unsigned short integer, and an unsigned long integer, respectively.
*/
unsigned long _outpd( unsigned short port, unsigned long dataword );

#endif //_CONIO_H
