/*------------------------------------------------------------------------------*
 * File Name: Range.h															*
 * Creation: YuI 02/18/04														*
 * Purpose: Origin C support for a general Range								*
 * Copyright (c) OriginLab Corp.2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *  SY 12/15/2004 QA70-7258 v8.0175 IMPORT_INFO_RESET_AND_DATARANGE_SAVEAS_UID	*
 *	YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS				*
 *	ML 2/28/2005 QA70-7450 MATRICES_IN_DATARANGE								*
 *	ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH							*
 *	RVD 4/15/2005 QA70-7597 v8.0223 MARKER_GROBJ								*
 *	YuI 06/14/05 RANGEBASED_XVAR_ACTIVE_SUPPORT									*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *	RVD 4/27/2006 v8.0382 HIERARCHY_CHECK_ACCESS								*
 *	ML 6/6/2006 EXTRACTING_DATA_FOR_NLFIT										*
 *	ML 10/2/2006 NLFIT_CURVES_CLEANUP											*
 *	ML 1/30/2007 QA70-9318 P1 GETDATA_RETRIEVING_STRING_VALUES					*
 *	ML 3/16/2007 QA70-9499 SETTING_DATA_NONXYETC_COMPLEX						*
 *	ML 4/19/2007 QA70-9643 XOUTPUT_AS_XINPUT_CHECKING							*
 *	ML 5/15/2007 GETTING_SOURCE_ROWS_WHEN_EXTRACTING_DATA						*
 *	ML 8/6/2007 RETURNING_COUNTS_OF_NEGATIVE_MISSING_ERROR_VALUES_WHEN_EXTRACTING_DATA
 *	ML 8/30/2007 REMOVE_COLUMN_FORMULA_OPERATIONS_BY_POLYRANGE					*
 *	Hong 09/08/07 v8.0698b OC_SET_RANGE_NEED_MATRIX_ACCESS						*
 *	YuI 10/10/2007 QA70-10512 CHANGE_PARAM_UNPROTECTS_OUTPUT					*
 *	ML 10/29/2007 QA70-10599 EXTRACTING_AXIS_LIMITS_FROM_DATARANGE				*
 *	Folger 02/03/08 QA80-9941 MASK_UNMASK_RANGE_DATA							*
 *	YuI 09/04/08 QA70-12133 CONVERTING_POLYRANGE_TO_CONTIGUOUS					*
 *	ML 11/21/2008 QA70-12505 GETTING_NAMES_OF_DATASETS_FROM_DATARANGE			*
 *	Hong 12/16/08 QA80-12758 OC_RANGE_SUPPORT_DELETE_DATA						*
 *	Folger 01/20/09 EXPOSE_RANGE_SET_NAME_UNIQUE_CHECKING_FOR_RANGE_RENAME_IN_PA_FITTING
 *	Folger 07/03/09 QA80-13876 FIND_AND_REPLACE_IMPROVEMENT_IN_DATARANGE		*
 *	Folger 10/20/09 QA81-14500 XF_SHOULD_CLEAR_OUTPUT_DATA_BY_DEFAULT_WHEN_TOTALLY_INTERSECTED_WITH_INPUT
 *	Folger 04/14/2011 ORG-2641-P1 IMPROVE_MASK_DATA_IN_LT						*
 *	Folger 06/02/2011 ORG-2858 SUPPORT_DUPLICATE_ANALYSIS_OPERATION				*
 *	Folger 08/18/2011 ORG-3537 OC_NAMED_RANGE_SUPPORT							*
 *	Folger 09/06/2011 ORG-3706-P1 SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
 *	Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT						*
 *	Zech 08/21/2012 ORG-5703-P1 ADD_DWORD_CONTROL_FOR_IGNORE_HIDDEN_TO_RANGE_GETDATA
 *	Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW				*
 *	TD ML CP 08-24-2012 ORG-6632 NON_MEMORY_STRUCT_IN_PCALL_SIMPLIFIED			*
 *------------------------------------------------------------------------------*/

#ifndef	_RANGE_H
#define	_RANGE_H


/// TD ML CP 08-24-2012 ORG-6632 NON_MEMORY_STRUCT_IN_PCALL_SIMPLIFIED
struct STDRGETDATAARGS 
{
	int nIndex;
	DWORD dwRules;
	DWORD dwRules2;
	DWORD *pouidAux;
	string *pstrDescriptive;
	vectorbase *pv;
	vector *pvIndep;
	matrix *pmMultiIndep;
	vector<string> *pstrFactors;
	vector *pvWeights;
	vector *pvErrDep;
	vector *pvErrIndep;
	Worksheet *pwksData;
	vector *pvYIndep;
	vector<int> *pvintRowsInSource;
};
/// end NON_MEMORY_STRUCT_IN_PCALL_SIMPLIFIED


///Comments last updated by Joseph on 08/01/2007
/// CPY 4/13/07 replace all 3 examples above class	
/**+
http://ocwiki.originlab.com/index.php?title=Category:DataRange_(class)
*/
class DataRange	: public OriginObject
{

public:

	// Comments last updated by GZOC on 09/02/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-DataRange
	*/
	DataRange(); // Default constructor for the DataRange class.

	// Comments last updated by GJL on 05/20/2005	
	/**$		
		Destructor for the DataRange class. Explicit calls not needed as DataRange objects are automatically
		destroyed when the declaration scope is exited.
	*/
	~DataRange(); // Destructor for the DataRange class.

public:

	// Comments last updated by GJL on 05/20/2005	
	/**#
			
		Keywords:
			
		Example1:
			
		Parameters:
			lpszAreas=[input]
			nType=[input]
		Return:
			
		SeeAlso:
			
	*/
	//int	AddAreas(LPCSTR lpszAreas, UINT nType); // 

	// Comments last updated by Cloud on 11/16/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Add
	*/
	int		Add(LPCSTR lpcszName, LPCSTR lpcszRange); // Add a new subrange to the DataRange.
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Add
	*/
	int		Add(LPCSTR lpcszName, Datasheet& ds, int nR1, int nC1, int nR2, int nC2); // Add a new subrange to the DataRange.

	// Comments last updated by GZOC on 09/02/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Add
	*/
	//	int		Add(Worksheet& wks = NULL, int nC1 = 0, LPCSTR lpcszName = NULL, int nR1 = 0, int nR2=-1); // Add a new subrange to the DataRange.
	int		Add(Datasheet& ds = NULL, int nC1 = 0, LPCSTR lpcszName = NULL, int nC2 = 0, int nR1 = 0, int nR2=-1); // Add a new subrange to the DataRange.
	// Comments last updated by GZOC on 09/02/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetRange
	*/
	/// Hong 09/08/07 v8.0698b OC_SET_RANGE_NEED_MATRIX_ACCESS
	//BOOL	SetRange(int nIndex, Worksheet& wks, int nR1, int nC1, int nR2, int nC2, LPCSTR lpcszName = NULL); // Set the subrange at the given index.
	BOOL	SetRange(int nIndex, Datasheet& ds, int nR1, int nC1, int nR2, int nC2, LPCSTR lpcszName = NULL); // Set the subrange at the given index.
	/// end OC_SET_RANGE_NEED_MATRIX_ACCESS

	// Comments last updated by Cloud on 11/16/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-AddInput
	*/
	int		AddInput(LPCSTR lpcszIndep, LPCSTR lpcszDep = NULL, LPCSTR lpcszWeight = NULL,
						LPCSTR lpcszFactors = NULL, LPCSTR lpcszErrDep = NULL, LPCSTR lpcszErrIndep = NULL,
						DWORD dwPlotUid = 0, LPCSTR lpcszZDep = NULL, LPCSTR lpcszSubjects = NULL); // Add data to a DataRange object from named columns in a workbook.

	// Comments last updated by GJL on 05/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetFactorsValues
	*/
	int		GetFactorsValues(DWORD dwRules, int nIndex = 0, vector<string> *pstrFactors = NULL); // 

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetNumData
	*/
	int		GetNumData(DWORD dwRules, TreeNode &trAdditionalData = NULL, Worksheet *pwksFirstRange = NULL,vector<int> *pvFactorSizes = NULL, int *pnNumSubRanges = NULL); // 

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetNumData
	*/
	int		GetNumData();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetData
	*/
	BOOL	GetData(vectorbase* pData, int nIndex);
	
	
	// Comments last updated by GJL on 05/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetData
	*/
	/// ML 8/6/2007 RETURNING_COUNTS_OF_NEGATIVE_MISSING_ERROR_VALUES_WHEN_EXTRACTING_DATA
	///// ML 5/15/2007 GETTING_SOURCE_ROWS_WHEN_EXTRACTING_DATA
	/////// ML 1/30/2007 QA70-9318 P1 GETDATA_RETRIEVING_STRING_VALUES
	//////int		GetData(DWORD dwRules, int nIndex, DWORD *pouidAux, string *pstrDescriptive, vector *pv, vector *pvIndep = NULL,
	//////				matrix *pmMultiIndep = NULL, vector<string> *pstrFactors = NULL, vector *pvWeights = NULL,
	//////				vector *pvErrDep = NULL, vector *pvErrIndep = NULL, Worksheet *pwksData = NULL, vector *pvYIndep = NULL); //
	////int		GetData(DWORD dwRules, int nIndex, DWORD *pouidAux, string *pstrDescriptive, vectorbase *pv, vector *pvIndep = NULL,
	////				matrix *pmMultiIndep = NULL, vector<string> *pstrFactors = NULL, vector *pvWeights = NULL,
	////				vector *pvErrDep = NULL, vector *pvErrIndep = NULL, Worksheet *pwksData = NULL, vector *pvYIndep = NULL); //
	/////// end GETDATA_RETRIEVING_STRING_VALUES
	//int		GetData(DWORD dwRules, int nIndex, DWORD *pouidAux, string *pstrDescriptive, vectorbase *pv, vector *pvIndep = NULL,
	//				matrix *pmMultiIndep = NULL, vector<string> *pstrFactors = NULL, vector *pvWeights = NULL,
	//				vector *pvErrDep = NULL, vector *pvErrIndep = NULL, Worksheet *pwksData = NULL, vector *pvYIndep = NULL, vector<int> *pvintRowsInSource = NULL); //
	///// end GETTING_SOURCE_ROWS_WHEN_EXTRACTING_DATA
	int		GetData(DWORD dwRules, int nIndex, DWORD *pouidAux, string *pstrDescriptive, vectorbase *pv, vector *pvIndep = NULL,
					matrix *pmMultiIndep = NULL, vector<string> *pstrFactors = NULL, vector *pvWeights = NULL,
					vector *pvErrDep = NULL, vector *pvErrIndep = NULL, Worksheet *pwksData = NULL, vector *pvYIndep = NULL, vector<int> *pvintRowsInSource = NULL,
					STGETDATAOUTPUTINFO *pstOutInfo = NULL
					/// Zech 08/21/2012 ORG-5703-P1 ADD_DWORD_CONTROL_FOR_IGNORE_HIDDEN_TO_RANGE_GETDATA
					, DWORD dwRules2 = 0
					/// END ADD_DWORD_CONTROL_FOR_IGNORE_HIDDEN_TO_RANGE_GETDATA
					); //
	/// end RETURNING_COUNTS_OF_NEGATIVE_MISSING_ERROR_VALUES_WHEN_EXTRACTING_DATA
	/// TD ML CP 08-24-2012 ORG-6632 NON_MEMORY_STRUCT_IN_PCALL_SIMPLIFIED
	int GetData(STDRGETDATAARGS  & gdInfoOut, STGETDATAOUTPUTINFO *pstOutInfo = NULL);
	/// end NON_MEMORY_STRUCT_IN_PCALL_SIMPLIFIED
	/// ML 6/6/2006 EXTRACTING_DATA_FOR_NLFIT
	/**$	
	*/
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//int	GetNLFitData(DWORD dwRules, int nIndex, DWORD *pouidAux, int numDeps, vector *pvDeps, int numIndeps, vector *pvIndeps, 
					//vector *pvAdditionalDataset, Worksheet *pwksData = NULL, vector<int> *pvintInputRowIndices = NULL);
	int	GetNLFitData(DWORD dwRules, int nIndex, DWORD *pouidAux, int numDeps, vector *pvDeps, int numIndeps, vector *pvIndeps, 
					vector *pvErrWeightDeps = NULL, vector *pvErrWeightIndeps = NULL, Worksheet *pwksData = NULL, vector<int> *pvintInputRowIndices = NULL);
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT

	/**$	
	*/
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//int	GetMaskedOrMissingNLFitData(DWORD dwRules, int nIndex, BOOL bMasked, vector<int> *pvintRows, int numDeps, vector *pvDeps, int numIndeps, vector *pvIndeps,
							//vector *pvAdditionalDataset); // 
	int	GetMaskedOrMissingNLFitData(DWORD dwRules, int nIndex, BOOL bMasked, vector<int> *pvintRows, int numDeps, vector *pvDeps, int numIndeps, vector *pvIndeps,
							vector *pvErrWeightDeps = NULL, vector *pvErrWeightIndeps = NULL);
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	/// end EXTRACTING_DATA_FOR_NLFIT


	// Comments last updated by Cloud on 11/16/2005	
	/**$
			It extracts data as appropriate for the one way repeated measurements ANOVA.
		Parameters:
			dwRules=must be equal to DRR_RM_ANOVA
			nOutcome=[output]it receives one of the values from the RMDATA enumeration pertainiing to the two-way RM ANOVA.
			numFactorVals=[output]it receives the size of the factor (it is the same as the number of columns in the matrix pmatData)
			pmatData=[output]the matrix which receives the extracted data in case of success. The number of rows of the matrix
							is equal to the number of subjects. The number of columns of the matrix is equal to the size of the factor.
			pvstrFactorVals=[output]It receives the values of the factor. It's size is equal to numFactorVals and each element
							corresponds to the value of the factor of the column of matrix pmatData of the same index.
			pwksData=[output,optional]the method attaches it to the worksheet holding the data.
			pouidAux=[output,optional]if supplied, it receives the dataplot UID stored in the DataRange object.
		Return:
			the index of the column in the worksheet holding the data, or a negative number for failure.
		Example:
			// The function uses as a source a workbook with the name "Book1" and a sheet with the name "Data1", with
			// three columns:
			//	"D" column holds the data values
			//	"Subjects" column holds subjects
			//	"Factor" column holds the factor.
			// If the data are inappropriate, the function will display an error and return. Otherwise, it will dump
			// the results, including the extracted matrix.
			void	test_RM_OneWay()
			{
				DWORD		dwRules = DRR_RM_ANOVA;
				string		strDataRange, strSubjectsRange, strFactors;
				strDataRange 		= "[Book1]Data1!D:D";
				strSubjectsRange	= "[Book1]Data1!Subjects:Subjects";
				strFactors			= "[Book1]Data1!Factor:Factor";
			
				DataRange	drInput;
				int			nn = drInput.AddInput(strDataRange, NULL, NULL, strFactors, NULL, NULL, 0, NULL, strSubjectsRange);
				if (nn < 1)
				{
					out_str("Invalid Range!");
					return;
				}
			
				Worksheet	wksFirstRange;
				nn = drInput.GetNumData(dwRules, NULL, &wksFirstRange, NULL, NULL);
				// nn returned from GetNumData() is one of the values from the enumeration RMDATA.
				// If success, it is equal to RMDATA_ONE_WAY.
				if (nn <= 0)
				{
					out_str("Invalid One-Way RM ANOVA data!");
					return;
				}
			
				matrix		matData;
			
				Worksheet	wksData;
				int			nOutcome, numFactorVals;
				vector<string>	vstrFactorVals;
				nn = drInput.GetDataRMOneWayANOVA(dwRules, nOutcome, numFactorVals, &matData, &vstrFactorVals, &wksData);
				// nOutcome is one of the values from the enumeration RMDATA. 
				if (nn < 0 || nOutcome < 0)	
				{
					out_str("Cannot extract RM Two-way ANOVA data!");
					return;
				}
				
				// Dump the results:
				int			nCols = matData.GetNumCols();
				int			nRows = matData.GetNumRows();
				out_int("Number of subjects = ", nRows);
				out_int("The size of the factor = ", nCols);
				out_str("");
				
				string		str;
				for (int col = 0; col < nCols; col++)
				{
					str += "(" + vstrFactorVals[col] + ")\t\t";
				}
				out_str(str);
			
				for (int row = 0; row < nRows; row++)
				{
					str.Empty();
					for (col = 0; col < nCols; col++)
					{
						string		strNumeric;
						strNumeric.Format("%lf\t", matData[row][col]);
						str += strNumeric;
					}
			
					out_str(str);
				}
				
				return;
			
			}
	*/
	int		GetDataRMOneWayANOVA(DWORD dwRules, int &nOutcome, int &numFactorVals, matrix *pmatData, vector<string> *pvstrFactorVals, Worksheet *pwksData = NULL, DWORD *pouidAux = NULL);


	// Comments last updated by Cloud on 11/16/2005	
	/**$
			It extracts data as appropriate for the two way repeated measurements ANOVA.
		Parameters:
			dwRules=must be equal to DRR_RM_ANOVA
			nOutcome=[output]it receives one of the values from the RMDATA enumeration pertainiing to the two-way RM ANOVA.
			numFactorVals1=[output]it receives the size of the first factor
			numFactorVals2=[output]it receives the size of the second factor
			pmatData=[output]the matrix which receives the extracted data in case of success. The number of rows of the matrix
							is equal to the number of subjects. The number of columns of the matrix depends on nOutcome:
								If nOutcome is RMDATA_TWO_WAY_ONLY_FIRST_FACTOR_REPEATED, the number of columns is numFactorVals1.
								If nOutcome is RMDATA_TWO_WAY_ONLY_SECOND_FACTOR_REPEATED, the number of columns is numFactorVals2.
								If nOutcome is RMDATA_TWO_WAY_BOTH_FACTORS_REPEATED, the number of columns is numFactorVals1 * numFactorVals2.
			pvstrRepeatedFactorVals=[output,optional]The vector of strings which receives the values of a repeated factor. Its size is always equal
										to the total number columns of the matrix pmatData, and so it can be used to "label" the columns
										of the matrix.
								If nOutcome is RMDATA_TWO_WAY_BOTH_FACTORS_REPEATED, its size is equal to numFactorVals1 * numFactorVals2, and
									it contains the values of the first factor, such that each element of the vector holds the value of
									the first repeated factor which corresponds to the column of the same index in the matrix pmatData (each
									value of the first factor will be appear numFactorVals2 times).
								Otherwise, its size is equal to the size of the repeated factor,
									and it contains the values of the first factor, each value appearing once.
			pvstrRepeatedOrNonrepeatedFactorVals=[output,optional]vector of strings which receives values of either the second repeated factor (if both
												factors are repeated), or the values of the nonrepeated factor (if only one factor repeated).
								If nOutcome is RMDATA_TWO_WAY_BOTH_FACTORS_REPEATED, the size of the vector is equal to numFactorVals1 * numFactorVals2, and
									it contains the values of the second factor, such that each element of the vector holds the value of
									the second repeated factor which corresponds to the column of the same index in the matrix pmatData (each
									value of the second factor will appear numFactorVals1 times).
								Otherwise, its size is equal to the number of rows of the matrix pmatData (so it can be used to "label" rows of the matrix),
									which means it is equal to the number of subjects. Each element contains the value of the nonrepeated
									factor which corresponds to the row of the output matrix of the same index.
			pwksData=[output,optional]the method attaches it to the worksheet holding the data.
			pouidAux=[output,optional]if supplied, it receives the dataplot UID stored in the DataRange object.
		Returns:
			the index of the column in the worksheet holding the data, or a negative number for failure.
		Example:
			// The example should be run in conjunction with data that has three worksheets: RMByBoth, RMByFirst, RMBySecond
			// All three worksheets should hold data such that:
			//		"Subjects" column should hold subjects
			//		"Factor1" column should hold the first factor values
			//		"Factor2" column should hold the second factor values
			//		"D" column should hold the data.
			// RMByBoth should have data appropriate for RM ANOVA with both factors being repeated.
			// RMByFirst should have data appropriate for RM ANOVA with only the first factor being repeated.
			// RMBySecond should have data appropriate for RM ANOVA with only the second factor being repeated.
			//
			// To run the example type into the Script Window:
			//		test_RM_TwoWay 2
			// or
			//		test_RM_TwoWay 0
			// or
			//		test_RM_TwoWay 1
			// to run RMByBoth, RMByFirst, or RMBySecond, respectively.
			//
			// If the data are inappropriate, the function will display an error and return. Otherwise, it will dump
			// the results, including the extracted matrix.
			void	test_RM_TwoWay(int nRepeatedBy = 2)
			{
				DWORD		dwRules = DRR_RM_ANOVA;
				
				string		strDataRange, strSubjectsRange, strFactor1, strFactor2;
				
				// The three switch cases are used for three different sources of data
				switch (nRepeatedBy)
				{
				case 0:
					//init_two_way_ranges_repeated_by_first_factor(strDataRange, strSubjectsRange, strFactor1, strFactor2);
					strDataRange 		= "[RMByFirst]Data1!D:D";
					strSubjectsRange	= "[RMByFirst]Data1!Subjects:Subjects";
					strFactor1			= "[RMByFirst]Data1!Factor1:Factor1";
					strFactor2			= "[RMByFirst]Data1!Factor2:Factor2";
					break;
					
				case 1:
					//init_two_way_ranges_repeated_by_second_factor(strDataRange, strSubjectsRange, strFactor1, strFactor2);
					strDataRange 		= "[RMBySecond]Data1!D:D";
					strSubjectsRange	= "[RMBySecond]Data1!Subjects:Subjects";
					strFactor1			= "[RMBySecond]Data1!Factor1:Factor1";
					strFactor2			= "[RMBySecond]Data1!Factor2:Factor2";
					break;
					
				case 2:
					//init_two_way_ranges_repeated_by_both_factors(strDataRange, strSubjectsRange, strFactor1, strFactor2);
					strDataRange 		= "[RMByBoth]Data1!D:D";
					strSubjectsRange	= "[RMByBoth]Data1!Subjects:Subjects";
					strFactor1			= "[RMByBoth]Data1!Factor1:Factor1";
					strFactor2			= "[RMByBoth]Data1!Factor2:Factor2";
					break;
			
				default:
					out_str("Invalid argument!");
					return;
				}
				
				string		strFactors = strFactor1 + "," + strFactor2;
				
				DataRange	drInput;
				int			nn = drInput.AddInput(strDataRange, NULL, NULL, strFactors, NULL, NULL, 0, NULL, strSubjectsRange);
				if (nn < 1)
				{
					out_str("Invalid Range!");
					return;
				}
			
				Worksheet	wksFirstRange;
				nn = drInput.GetNumData(dwRules, NULL, &wksFirstRange, NULL, NULL);
				// nn returned from GetNumData() is one of the values from the enumeration RMDATA.
				// If success, it gives one of the three successful values for the two way RM ANOVA data extraction.
				if (nn <= 0)
				{
					out_str("Invalid Two-Way RM ANOVA data!");
					return;
				}
				
				matrix		matData;
			
				Worksheet	wksData;
				int			nOutcome, numFactorVals1, nNumFactorVals2;
				vector<string>	vstrRepeatedFactorVals, vstrRepeatedOrNonrepeatedFactorVals;
				nn = drInput.GetDataRMTwoWayANOVA(dwRules, nOutcome, numFactorVals1, nNumFactorVals2, &matData, &vstrRepeatedFactorVals, &vstrRepeatedOrNonrepeatedFactorVals, &wksData);
				// nOutcome is one of the values from the enumeration RMDATA. 
				if (nn < 0 || nOutcome < 0)	
				{
					out_str("Cannot extract RM Two-way ANOVA data!");
					return;
				}
			
				/////////////////////////////////////////////
				// Dumping the results:
				switch (nOutcome)
				{
				case RMDATA_TWO_WAY_ONLY_FIRST_FACTOR_REPEATED:
					out_str("- Only the first factor is repeated.");
					break;
					
				case RMDATA_TWO_WAY_ONLY_SECOND_FACTOR_REPEATED:
					out_str("- Only the second factor is repeated.");
					break;
					
				case RMDATA_TWO_WAY_BOTH_FACTORS_REPEATED:
					out_str("- Both factors are repeated.");
					break;
			
				default:
					ASSERT(FALSE);
					return;
				}
			
				int			nCols = matData.GetNumCols();
				int			nRows = matData.GetNumRows();
				
				out_int("The number of subjects = ", nRows);
				printf("The size of the first factor = %d\nThe size of the second factor = %d\n\n", numFactorVals1, nNumFactorVals2);
				
				
				// The matrix heading:
				string			str;
				if (RMDATA_TWO_WAY_BOTH_FACTORS_REPEATED == nOutcome)
				{
					ASSERT(vstrRepeatedFactorVals.GetSize() == nCols);
					ASSERT(vstrRepeatedOrNonrepeatedFactorVals.GetSize() == nCols);
					for (int col = 0; col < nCols; col++)
					{
						str += "(" + vstrRepeatedFactorVals[col] + "|" + vstrRepeatedOrNonrepeatedFactorVals[col] + ")\t\t";
					}
					
				}
				else
				{
					ASSERT(vstrRepeatedFactorVals.GetSize() == nCols);
					ASSERT(vstrRepeatedOrNonrepeatedFactorVals.GetSize() == nRows);
					str = "Nonrepeated\r\nFactor\t";
					for (int col = 0; col < nCols; col++)
					{
						str += "(" + vstrRepeatedFactorVals[col] + ")\t\t";
					}
				}
				
				out_str(str);		// heading
			
				for (int row = 0; row < nRows; row++)
				{
					str.Empty();
					if (RMDATA_TWO_WAY_BOTH_FACTORS_REPEATED != nOutcome)
					{
						// Begin each row with the corresponding nonrepeated factor value:
						str += "(" + vstrRepeatedOrNonrepeatedFactorVals[row] + ")" + "\t";
					}
					for (int col = 0; col < nCols; col++)
					{
						string		strNumeric;
						strNumeric.Format("%lf\t", matData[row][col]);
						str += strNumeric;
					}
			
					out_str(str);
				}
				
				return;
			}
	*/
	int		GetDataRMTwoWayANOVA(DWORD dwRules, int &nOutcome, int &numFactorVals1, int &numFactorVals2, matrix *pmatData, vector<string> *pvstrRepeatedFactorVals, vector<string> *pvstrRepeatedOrNonrepeatedFactorVals, Worksheet *pwksData = NULL, DWORD *pouidAux = NULL);

	/**$
	*/
	BOOL	CleanupAuxData();

	// CP Said not to do this one yet - Comments last updated by GJL on 05/20/2005	
	/**$
			
		Keywords:
			
		Example1:
			
		Parameters:
			dwRules=[input]
			nIndex =[input] 
			pstrData=[output]
			parrstrIndeps=[output]
			parrstrFactors=[output]
			pstrWeight=[output]
			pstrErr=[output]
			pstrErrIndep=[output]
			i1=[output]
			i2=[output]
		Return:
			
		SeeAlso:
			DataRange::GetNumData, DataRange::SetData, Curve::Curve, curvebase::AttachX, DataRange::GetMaskedData, DataRange::GetMissingData
	*/
	int		GetData(DWORD dwRules, int nIndex, string* pstrData, vector<string> *parrstrIndeps = NULL,
					vector<string>* parrstrFactors = NULL, string* pstrWeight = NULL, string* pstrErr = NULL,
					string* pstrErrIndep = NULL, int* i1 = NULL, int* i2 = NULL); // 

	// Comments last updated by Zachary on 11/24/2006	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetData
	*/
	///Frank 8/22/05 When passing as reference, should be NULL not 0 as default...
	//int		GetData(DWORD dwRules, int nIndex, vector<int>& vIndicesIn, vector& vMainOut, vector& vIndepOut,
					//vector& vYIndepOut = 0); // 
	int		GetData(DWORD dwRules, int nIndex, vector<int>& vIndicesIn, vector& vMainOut, vector& vIndepOut,
					vector& vYIndepOut = NULL); // 

	/// ML 2/28/2005 QA70-7450 MATRICES_IN_DATARANGE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetData
	*/
	int		GetData(matrixbase &m, DWORD dwRules = 0, int index = 0); // 

	// Comments last updated by Joseph on 08/01/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetData
	*/
	/// ML 3/16/2007 QA70-9499 SETTING_DATA_NONXYETC_COMPLEX
	//BOOL	SetData(const matrixbase &m, int index = 0, BOOL bUndo = FALSE); // 
	BOOL	SetData(const matrixbase &m, int index = 0, BOOL bUndo = FALSE, DWORD dwDRSOpts = 0); // 
	/// end SETTING_DATA_NONXYETC_COMPLEX
	/// end MATRICES_IN_DATARANGE

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetData
	*/
	/// ML 3/16/2007 QA70-9499 SETTING_DATA_NONXYETC_COMPLEX
	//BOOL	SetData(vector& pv, BOOL bUndo = FALSE, int index = 0); //
	BOOL	SetData(vectorbase& pv, BOOL bUndo = FALSE, int index = 0, DWORD dwDRSOpts = 0); //
	/// end SETTING_DATA_NONXYETC_COMPLEX
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetColumnData
	*/
	BOOL	SetColumnData(vector &v, BOOL bUndo = FALSE, int index = 0);

	// Comments last updated by Iris on 04/17/2007	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetData
	*/
	BOOL	SetData(vector *pvY, vector *pvX, BOOL bUndo = FALSE, int index = 0); // 

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetData
	*/
	BOOL	SetData(vector *pvZ, vector *pvY, vector *pvX, BOOL bUndo = FALSE, int index = 0); // 

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetMaskedData
	*/
	int		GetMaskedData(DWORD dwRules, int nIndex, vector<int> *pvintRows, vector *pv, vector *pvIndep = NULL,
							matrix *pmMultiIndep = NULL, vector *pvWeights = NULL, vector *pvYIndep = NULL
							///------ Folger 09/06/2011 ORG-3706-P1 SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
							, vector* pvErrIndep = NULL
							///------ End SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
							/// Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
							, DWORD dwRules2 = 0
							/// END OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
							); // 

	//------ Folger 02/03/08 QA80-9941 MASK_UNMASK_RANGE_DATA
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetMask
	*/
	///------ Folger 04/14/2011 ORG-2641-P1 IMPROVE_MASK_DATA_IN_LT
	//BOOL	SetMask(BOOL bMask = TRUE);
	BOOL	SetMask(BOOL bMask = TRUE, BOOL bUndo = FALSE);
	///------ End IMPROVE_MASK_DATA_IN_LT
	//------
	
	/// Kit 8/09/2010 ORG-748-P1 ADD_FUNC_IsEmpty_IN_OCRANGE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-IsEmpty
	*/
	BOOL	IsEmpty();
	/// End ADD_FUNC_IsEmpty_IN_OCRANGE

	// Comments last updated by Joseph on 08/01/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetMissingData
	*/
	int		GetMissingData(DWORD dwRules, int nIndex, vector<int> *pvintRows, vector *pv = NULL, vector *pvIndep = NULL,
				matrix *pmMultiIndep = NULL, vector *pvWeights = NULL, vector *pvYIndep = NULL, vector<int> *pvintCols = NULL
				///------ Folger 09/06/2011 ORG-3706-P1 SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
				, vector* pvErrIndep = NULL
				///------ End SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
				/// Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
				, DWORD dwRules2 = 0
				/// END OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
				); // 

	// Needs update by DSC - Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetSubRange
	*/
	BOOL	GetSubRange(const vector<uint>& vPath, DataRange& SubRange, BOOL bCol = true); // 

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetSubRange
	*/
	BOOL	GetSubRange(DataRange& SubRange, DWORD dwRules, int indexData = 0);
	
	/// ML 10/2/2006 NLFIT_CURVES_CLEANUP
	/**$	
	*/
	BOOL	GetNLFitSubRange(DataRange& SubRange, DWORD dwRules, int indexData, int iDep, int iIndep);
	/// end NLFIT_CURVES_CLEANUP

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetNumRanges
	*/
	int		GetNumRanges() const; // 

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetRange
	*/
	BOOL	GetRange(int nIndex, int& r1, int& c1, int& r2, int& c2, Datasheet& ds, string* pstrName = NULL) const; // 

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetRange
	*/
	BOOL	GetRange(Datasheet& ds, int& c1, int& c2, int nIndex = 0);
	
	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetRange
	*/
	int		GetRange(LPCTSTR lpcszName, int& r1, int& c1, int& r2, int& c2, Datasheet& ds) const; // 

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetName
	*/
	///------ Folger 01/20/09 EXPOSE_RANGE_SET_NAME_UNIQUE_CHECKING_FOR_RANGE_RENAME_IN_PA_FITTING
	//BOOL	SetName(LPCSTR lpcszName); // 
	BOOL	SetName(LPCSTR lpcszName, BOOL bCheckUnique = TRUE);
	///------ End EXPOSE_RANGE_SET_NAME_UNIQUE_CHECKING_FOR_RANGE_RENAME_IN_PA_FITTING

	///------ Folger 07/03/09 QA80-13876 FIND_AND_REPLACE_IMPROVEMENT_IN_DATARANGE
	#ifdef			__SUPPORT_DATARANGE_FIND_ALL_AND_FIND_NEXT__
	/**$
		Find next cell for numierc value
	Parameter:
		ds=[input]Input datasheet
		nCol=[input&output]Find next starting column index as input, output as next matching column index
		nRow=[input&output]Find next starting row index as input, output as next matching row index
		dThresholdVal=[input]value to find
		wBitwiseOptions=[input]Find options
		nIndex=[input]subrange index to begin finding
		rTolerance=[input]numeric compare tolerance
		pdReplaceVal=[input]used to replace original data if not NULL
		bUndo=[input]undo controller
		pnMatrixObjectIndex=[input&output]if ds is MatrixSheet, pnMatrixObjectIndex means starting matrixobject index to find (nCol & nRow means starting column & row to find inside matrixobject), output as next matching matrixobject index
	Return:
		Enum as DATARANGE_FIND_NEXT_*
	*/
	int		FindNext(Datasheet& ds, int& nCol, int& nRow, double dThresholdVal, uint wBitwiseOptions = WKSREPL_TEST_EQUAL, int nIndex = -1, double rTolerance = 1e-8, double* pdReplaceVal = NULL,  BOOL bUndo = FALSE, int* pnMatrixObjectIndex = NULL);
	/**$
		Find next cell for string value
	Parameters:
		wks=[input]Input worksheet
		nCol=[input&output]Find next starting column index as input, output as next matching column index
		nRow=[input&output]Find next starting row index as input, output as next matching row index
		lpcszOld=[input]value to find
		wBitwiseOptions=[input]Find options
		nIndex=[input]subrange index to begin finding
		lpcszNew=[input]used to replace original data if not NULL
		bUndo=[input]undo controller
	Return:
		Enum as DATARANGE_FIND_NEXT_*
	*/
	int		FindNext(Worksheet& wks, int& nCol, int& nRow, LPCSTR lpcszOld, uint wBitwiseOptions = WKSREPL_TEST_STR_MATCH_WHOLE_WORD, int nIndex = -1, LPCSTR lpcszNew = NULL, BOOL bUndo = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Replace
	*/
	int		Replace(double dThresholdVal, double dReplaceVal, uint wBitwiseOptions = WKSREPL_TEST_EQUAL, int nIndex = 0, double rTolerance = 1e-8, BOOL bUndo = FALSE, int* pnErr = NULL);
	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Replace
	*/
	int		Replace(LPCSTR strOld, LPCSTR strNew, uint wBitwiseOptions = WKSREPL_TEST_STR_MATCH_WHOLE_WORD, int nIndex = 0, BOOL bUndo = FALSE, int* pnErr = NULL);
	#else			/// !__SUPPORT_DATARANGE_FIND_ALL_AND_FIND_NEXT__
	///------ End FIND_AND_REPLACE_IMPROVEMENT_IN_DATARANGE
	/// Arvin 03/12/07 QA70-6368 FIND_AND_REPLACE_OLD_VALUE_BY_NEW_VALUE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Replace
	*/
	BOOL	Replace(double dThresholdVal, double dReplaceVal, uint wBitwiseOptions = WKSREPL_TEST_EQUAL, int nIndex = 0, double rTolerance = 1e-8, BOOL bUndo = FALSE);
	
	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Replace
	*/
	BOOL	Replace(LPCSTR strOld, LPCSTR strNew, uint wBitwiseOptions = WKSREPL_TEST_STR_MATCH_WHOLE_WORD, int nIndex = 0, BOOL bUndo = FALSE);
	/// end  FIND_AND_REPLACE_OLD_VALUE_BY_NEW_VALUE
	///------ Folger 07/03/09 QA80-13876 FIND_AND_REPLACE_IMPROVEMENT_IN_DATARANGE
	#endif			/// !__SUPPORT_DATARANGE_FIND_ALL_AND_FIND_NEXT__
	///------ End FIND_AND_REPLACE_IMPROVEMENT_IN_DATARANGE
	
	/**$
		Makes replica of the DataRange at different location.
		Parameters:
			drDest = destination DataRange
			dw = destination Datasheet
			nR1 = row number of top left corner cell of destination
			nC1 = column number of top left corner cell of destination
			numFactorVals=[output]it receives the size of the factor (it is the same as the number of columns in the matrix pmatData)
		Return:
			TRUE if succesful, FALSE otherwise
	*/
 	BOOL	Replicate(DataRange& drDest, Datasheet& ds, int nR1, int nC1);
 	
	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetName
	*/
	string	GetName(); // 

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetDescription
	*/
	string	GetDescription(DWORD dwCntrl = 0); // 

	// Comments last updated by Joseph on 08/01/2007	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Create
	*/
	int	Create(LPCSTR lpcszRangeStr = NULL, int nXVtype = XVT_DATARANGE, BOOL bCreateTargets = false); // 

	// Comments last updated by Joseph on 08/01/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Create
	*/
	BOOL	Create(TreeNode& tr, BOOL bOneData = TRUE); // 

	// Comments last updated by GJL on 05/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Destroy
	*/
	BOOL	Destroy(DWORD dwCntrl = 0); // 

	// Comments last updated by GJL on 05/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetTree
	*/
	BOOL	GetTree(TreeNode& tr, BOOL bOneData = TRUE); // 

	// Comments last updated by Joseph on 08/01/2007	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetTree
	*/
	/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
	//BOOL	SetTree(TreeNode& tr, BOOL bOneData = TRUE); // 
	BOOL	SetTree(TreeNode& tr, int nOption = DRTREE_DEFAULT); // 
	/// end ANOVA_INPUT_DATA_TO_DATARANGE

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Merge
	*/
	BOOL	Merge(DataRange& range); // 

	// Needs update by DSC - Comments last updated by GJL on 05/20/2005		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-BreakUp
	*/
	BOOL	BreakUp(); // 

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Clone
	*/
	/// YuI 10/10/2007 QA70-10512 CHANGE_PARAM_UNPROTECTS_OUTPUT
	//	BOOL	Clone(DataRange& drDest);
	BOOL	Clone(DataRange& drDest, BOOL bPreserveSecurityDescriptor = FALSE);
	/// end CHANGE_PARAM_UNPROTECTS_OUTPUT

	// Needs update by DSC - Comments last updated by GJL on 05/20/2005		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetPlots
	*/
	int		GetPlots(vector<uint>& vUID); // 

	// Needs update by DSC - Comments last updated by GJL on 05/20/2005		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetVisible
	*/
	BOOL	SetVisible(BOOL bOn = TRUE, BOOL bInvalidate = TRUE); // 

	// Comments last updated by GJL on 05/20/2005	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Reset
	*/
	void	Reset(); // 

	// Needs update by DSC - Comments last updated by GJL on 05/20/2005		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-IsReal
	*/
	BOOL	IsReal(); // 

	// Needs update by DSC - Comments last updated by GJL on 05/20/2005		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-Intersects
	*/
	BOOL	Intersects(DataRange& dr); // 

	/**$
	*/
	///------ Folger 10/20/09 QA81-14500 XF_SHOULD_CLEAR_OUTPUT_DATA_BY_DEFAULT_WHEN_TOTALLY_INTERSECTED_WITH_INPUT
	//BOOL	ClearData(BOOL bUndo = FALSE);
	BOOL	ClearData(BOOL bUndo = FALSE, BOOL bDisregardRowRange = TRUE);
	///------ End XF_SHOULD_CLEAR_OUTPUT_DATA_BY_DEFAULT_WHEN_TOTALLY_INTERSECTED_WITH_INPUT
	/// 	*/
	
	/// Hong 12/16/08 QA80-12758 OC_RANGE_SUPPORT_DELETE_DATA
	/**$
		Delete data in range.	
	Parameters:
		bUndo = [input] Whether to support Undo (TRUE) or not (FALSE)
	Return:
		TRUE if success, otherwise FALSE.
	Example1:
		BOOL TestDeleteDataEx1()
		{
			Worksheet wks;
			wks.Create("Origin");
			if( wks )
			{
				while(wks.Columns(0))
		            wks.DeleteCol(0);
		 
		        wks.AddCol("A");
		        wks.AddCol("B");
		        wks.AddCol("C");
		
				DataRange dr;
				dr.Create();
				dr.Add("X", wks, 5, 0, 15, 1);
				dr.Add("X", wks, 5, 2, 15, 2);
				BOOL bSucess = dr.DeleteData();
				
				return bSucess;
			}
			
			return FALSE;
		}
	*/
	BOOL	DeleteData(BOOL bUndo = FALSE);
	/// end OC_RANGE_SUPPORT_DELETE_DATA

	/// ML 4/19/2007 QA70-9643 XOUTPUT_AS_XINPUT_CHECKING
	/**$
			It checks the 'this' DataRange and the argument datarange supplied either as DataRange object
			or as lpcszDataRange for either identity or for any intersection.
			It compares internal ranges of 'this' with name lpcszThisRangeName and internal ranges
			of the first argument with the name lpcszArgRangeName ONLY.
		Keywords:
			
		Example1:
			
		Parameters:
			dr=[input]the other DataRange to compare 'this' with.
			lpcszDataRange=[input]the other DataRange to compare 'this' with.
			lpcszThisRangeName=[input]the internal range's name inside 'this' DataRange to use in matching, like "X", "Y", if NULL, "X" is assumed
			lpcszArgRangeName=[input]the internal range's name inside the DataRange of the first argument to use in matching, if NULL, assume samed as lpcszThisRangeName
			pwResults[output,optional]if supplied, *pwResults receives the value from the enumeration:
			enum {
				RNGINTSCT_NONE			= 0,
				RNGINTSCT_FULL,					// all exact matches
				RNGINTSCT_PARTIAL,				// some intersect, but not exact matches
			};
		Return:
			TRUE if any intersection of identity detected, otherwise FALSE.
			
		SeeAlso:
			
	*/
	///------ Folger 06/02/2011 ORG-2858 SUPPORT_DUPLICATE_ANALYSIS_OPERATION
	//BOOL	IsIntersect(DataRange &dr, LPCSTR lpcszThisRangeName = NULL, LPCSTR lpcszArgRangeName = NULL, DWORD *pwResults = NULL);
	BOOL	IsIntersect(DataRange &dr, LPCSTR lpcszThisRangeName = NULL, LPCSTR lpcszArgRangeName = NULL, DWORD *pwResults = NULL, DWORD dwOptions = 0);
	///------ End SUPPORT_DUPLICATE_ANALYSIS_OPERATION
	
	/// YuI 09/04/08 QA70-12133 CONVERTING_POLYRANGE_TO_CONTIGUOUS
	/**$
			Converts multipart DataRange into DataRange consiting of one contiguous block if such conversion is possible
		Example:
			BOOL TestConvertToContiguous()
			{
				Worksheet wks;
				wks.Create("Origin");
				if( wks )
				{
					while(wks.Columns(0))
			            wks.DeleteCol(0);
			 
			        wks.AddCol("A");
			        wks.AddCol("B");
			        wks.AddCol("C");
			
					DataRange dr;
					dr.Create();
					dr.Add("X", wks, 5, 0, 15, 1);
					dr.Add("X", wks, 5, 2, 15, 2);
					BOOL bSucess = dr.ConvertToContiguous();
					
					return bSucess;
				}
				
				return FALSE;
			}
			
		Parameters:
		Return:
			TRUE if succsesful.
	*/
	BOOL	ConvertToContiguous();
	/// end CONVERTING_POLYRANGE_TO_CONTIGUOUS
	
	/// Last updated by Sim, 07-29-2008, NOT_ADD_TO_DOC
	/**$
	*/
	///------ Folger 06/02/2011 ORG-2858 SUPPORT_DUPLICATE_ANALYSIS_OPERATION
	//BOOL	IsIntersect(LPCSTR lpcszDataRange, LPCSTR lpcszThisRangeName = NULL, LPCSTR lpcszArgRangeName = NULL, DWORD *pwResults = NULL);
	BOOL	IsIntersect(LPCSTR lpcszDataRange, LPCSTR lpcszThisRangeName = NULL, LPCSTR lpcszArgRangeName = NULL, DWORD *pwResults = NULL, DWORD dwOptions = 0);
	///------ End SUPPORT_DUPLICATE_ANALYSIS_OPERATION
	/// end XOUTPUT_AS_XINPUT_CHECKING

	/// ML 10/29/2007 QA70-10599 EXTRACTING_AXIS_LIMITS_FROM_DATARANGE
	/**$
			It retrieves the smallest plotting scale needed to encompass all data in the DataRange.
		Parameters:
			dwRules=the rules to be used. Either DRR_NLFIT or DRR_GET_DEPENDENT must be present. If z-bounds are needed,
						must pass DRR_GET_Z_DEPENDENT.
			pstScale[output] the structure to receive results.
			nIndexIndep=the index of the independent variable to check in each dataset set. Used only with DRR_NLFIT
			nIndexDep=the index of the dependent variable to check in each dataset set. Used only with DRR_NLFIT
		Return:
			0 if OK.
	*/
	int		GetPlottingScale(DWORD dwRules, DRPLOTTINGSCALE *pstScale, int nIndexIndep = 0, int nIndexDep = 0);
	/// end EXTRACTING_AXIS_LIMITS_FROM_DATARANGE




	/// RVD 4/27/2006 v8.0382 HIERARCHY_CHECK_ACCESS
	///**
	//Locks datarange and disables any data modification
	//*/
	//BOOL	Lock(LPCSTR lpcszPassword);
	//
	///**
	//Unlocks datarange that was previousely locked
	//*/
	//BOOL	Unlock(LPCSTR lpcszPassword);
	/// end HIERARCHY_CHECK_ACCESS

	//----------- CPY FISHER 3/10/2008 QA70-11233 TRI_CONTOUR_LINES_ACCESS_FROM_OC, change to use double for world coordinate points
	//int		GetIndices(vector<int>& vIndicies, vector<float>& vX, vector<float>& vY); //
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetIndices
	*/
	int		GetIndices(vector<int>& vIndicies, const vector& vX, const vector& vY); //
	//----------- end  TRI_CONTOUR_LINES_ACCESS_FROM_OC

	/// ML 1/13/2006 XVARIABLEBASE_TO_VC
	/**$
	*/
	BOOL	InitFromInputWithUID(TreeNode &trInput, uint &uid);

	/**$
	*/
	BOOL	CreateFromActive(DWORD dwDataRules);
	/// end XVARIABLEBASE_TO_VC
	
	
/// YuI 03/19/07 QA70-9503 MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
public:
	// Comments last updated by Iris on 03/13/2007
	/**$
	*/
	bool			InitFromTree();

	// Comments last updated by Iris on 03/13/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetUndoable
	*/
	void			SetUndoable(BOOL bSet = TRUE);
	
	// Comments last updated by Iris on 03/13/2007
	/**$	
	*/
	BOOL			IsUndoable();	
	
	// Comments last updated by Iris on 03/13/2007
	/**$	
	*/
	TreeNode		GetSCTree();
	
	// Comments last updated by Iris on 03/13/2007
	/**$	
	*/
	void			SetSCTree(TreeNode& tr);
	
	// Comments last updated by Iris on 03/13/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetRuntimeDescription
	*/
	BOOL			GetRuntimeDescription(string& strDescription, int nIndex = 0);
	
	// Comments last updated by Iris on 03/13/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetBookSheet
	*/
	BOOL			GetBookSheet(string& strBook, string& strSheet, int nIndex = 0);
	
	// Comments last updated by Iris on 03/13/2007
	/**$	
	*/
	BOOL			NewGetBookDescriptor(string& strDescriptor, int nIndex = 0, LPCSTR lpcszBranch = "X");

	// Comments last updated by Iris on 03/13/2007
	/**$	
	*/
	BOOL			NewGetSheetDescriptor(string& strDescriptor, int nIndex = 0, LPCSTR lpcszBranch = "X");

	// Comments last updated by Iris on 03/13/2007
	/**$	
	*/
	BOOL			NewGetObjectDescriptor(string& strDescriptor, int nIndex = 0, LPCSTR lpcszBranch = "X");
	/// end MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
	/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-SetPlotUID
	*/
	void			SetPlotUID(UINT uid, int nINdex = -1);
	/// end IMPROVED_ANALYSIS_MARKERS
	

	/// ML 8/30/2007 REMOVE_COLUMN_FORMULA_OPERATIONS_BY_POLYRANGE
	/**$
		It removes column formula operations and, optionally, column formulas/scripts themselves from all columns
		intersecting the DataRange.
	Parameters:
		bRemoveFormulaAndScript=[optional]if TRUE, it will also remove column formulas/scripts.
	Returns:
		TRUE if OK.
	*/
	BOOL			RemoveColumnFormulaOperations(BOOL bRemoveFormulaAndScript = TRUE);
	/// end REMOVE_COLUMN_FORMULA_OPERATIONS_BY_POLYRANGE

	/**#
		Sets the output comment when used withing XFunction framework
	Example:
		// XFunction body
		void xfTest(const XYRange& inRange, XYRange& outRange)
		{
			string strComment = outRange.GetOutputComment();
			strComment += "\r\n";
			strComment += "Additional Comment";
			outRange.SetOutputComment("No Comment");
		}
	*/
	void			SetOutputComment(LPCSTR lpcszComment);
	
	/**#
		Gets the output comment when used withing XFunction framework
		XFFramework initializes the comment to XFunction name and description of input
		which may be modified by XF designer inside XFunction body
	Example:
		// XFunction body
		void xfTest(const XYRange& inRange, XYRange& outRange)
		{
			string strComment = outRange.GetOutputComment();
			strComment += "\r\n";
			strComment += "Additional Comment";
			outRange.SetOutputComment("No Comment");
		}

	*/
	string			GetOutputComment();

	/// ML 11/21/2008 QA70-12505 GETTING_NAMES_OF_DATASETS_FROM_DATARANGE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRange-GetNamesOfDatasets
	*/
	int				GetNamesOfDatasets(vector<string> &vsNames, BOOL bAvoidRepetitions = FALSE);
	/// end GETTING_NAMES_OF_DATASETS_FROM_DATARANGE
	/// YuI 10/12/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT
	#ifdef __X_RANGE_POLYRANGE_SUPPORT__
	/**
	*/
	virtual BOOL			SetXRange(double dXFrom, double dXTo, int nDataIndex = 0);
	
	/**
	*/
	virtual BOOL			GetXRange(LPDOUBLE pXFrom, LPDOUBLE pXTo, int nDataIndex = 0);
	
	/**
	*/
	virtual BOOL			SetYRange(double dXFrom, double dXTo, int nDataIndex = 0);
	
	/**
	*/
	virtual BOOL			GetYRange(LPDOUBLE pXFrom, LPDOUBLE pXTo, int nDataIndex = 0);
	#endif // __X_RANGE_POLYRANGE_SUPPORT__

	///------ Folger 08/18/2011 ORG-3537 OC_NAMED_RANGE_SUPPORT
	#ifdef	NEW_NAMED_RANGE_FEATURE
	NamedRange				CreateNamedRange(LPCSTR lpcszName, LPCTSTR lpcszScopeRange = NULL, VSExtractDataRule edr = VSEDR_CONCATENATE_BY_COLUMN, int byDesignation = OKDATAOBJ_DESIGNATION_Y);
	#endif	/// NEW_NAMED_RANGE_FEATURE
	///------ End OC_NAMED_RANGE_SUPPORT

}; // 

/**$
*/
int		get_data_range_UID_in_tree(TreeNode& tr);


/// Sandy 2006-6-16 ADD_FUNCTIONS_ABOUT_RANGE
/**$
*/
void 	get_range_span(DataRange& dr, int Index, int& r1, int& c1, int& r2, int& c2)
{
	Worksheet wksTemp;
	string strRange;
	dr.GetRange(Index, r1, c1, r2, c2, wksTemp, &strRange);
	if(-1 == r2)
		r2 = wksTemp.GetNumRows()-1;
	
	if(-1 == c2)
		c2 = wksTemp.GetNumCols();

}

/**$
*/
bool get_source_worksheet(DataRange& dr, Worksheet& wks)
{
	Worksheet wks1st;
	string strRange;
	int r1, c1, r2, c2;
	dr.GetRange(0, r1, c1, r2, c2, wks1st, &strRange);	
	for(int ii = 0; ii<dr.GetNumRanges(); ii++ )
	{		
		dr.GetRange(ii, r1, c1, r2, c2, wks, &strRange);
		if(wks != wks1st)
			return false;	
	}

	return true;	
}

//end 2006-6-16//

///---Sim 02-14-2007 MORE_RANGE_UTILS
//bool isRelativeRange(const DataRange& dr1, const DataRange& dr2)
//{
	//return false;
//}
///---END MORE_RANGE_UTILS

/// YuI 06/14/05 RANGEBASED_XVAR_ACTIVE_SUPPORT
typedef DataRange	Range;
/// end RANGEBASED_XVAR_ACTIVE_SUPPORT
#endif //_RANGE_H

