/*------------------------------------------------------------------------------*
 * File Name: Project.h															*
 * Creation: CPY 2/1/2002														*
 * Purpose: Origin C Project Class Header										*
 * Copyright (c) OriginLab Corp.2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	TD 8-10-04 QA70-6794 NEW_OBJECT_TYPE_IN_OC									*
 *	ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
 *	RVD 10/25/2005 v8.0323 NON_ACTIVE_SELECTION									*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *	ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE					*
 *	Arvin  03/08/08 ADD_PARAM_INIT_CONTEXT_CLASS as Marko said					*
 *	ML 4/20/2008 QA70-11061 GETTING_CURRENT_FIT_INFO							*
 *	Sim 07-28-2008 CORRECT_WRONG_HEADER_COMMENT									*
 *	ML 9/18/2008 QA70-12199 FASTER_FIT_LABTALK_CALL								*
 *	ML 10/10/2008 QA70-11938 GETTING_COLUMN_HEADINGS_FOR_PS						*
 *	ML 11/20/2008 QA70-12625 TRY_TO_GET_ORIGINAL_OCOPERATION_OBJECT				*
 *	Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
 *	Kyle 06/08/2009 QA70-13423 SUPORT_GET_MENU_TEXT_FROM_OC						*
 *	Kyle 06/11/2009 QA70-13423 CUSTOM_MENU_SWITCH_MENU_MODE_BETWEEN_CNF_AND_OMC	*
 *	Hong 06/16/09 QA80-8061 SIMPE_PROJECT_OPENING_PASSWORD_PROTECTION_SUPPORT	*
 *	Folger 06/18/09 QA80-13802 SUPPORT_FIND_COMPILED_FUNCTION_FROM_OC			*
 *	Hong 06/18/09 QA80-8091-S2 ADD_PROJECT_AUDIT_LOG							*
 *	Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG									*
 *	Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG							*
 *	Kyle 02/26/2010 QA80-15138 KEEP_MENU_TAG_FOR_HIDE_BUILT_IN_MENU_LIST_TO_INDICATE_THE_POPUP_INDICES_IN_OMC
 *	Sophy 12/23/2010 ORG-1846-P2 SPEEDUP_DATA_MANIPULATION_ON_LARGE_DATA		*
 *	Sim 01-06-2010 ORG-1870 SUPPORT_VAR_DLG_SHOW_TEXT_LOOSE_DATASET				*
 *	Folger 01/20/2011 ORG-1962-P8 SUPPORT_GET_DATASET_DEPENDENT_XDENPENDENT_IN_OC
 *	Folger 08/19/2011 ORG-3537 OC_NAMED_RANGE_SUPPORT							*
 *	Folger 02/10/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER							*
 *	Folger 08/15/2012 ORG-6381-S1 DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET		*
 *	Folger 09/29/2012 ORG-7029-P1 OC_FIND_FUNCTION_SUPPORT_OVERLOAD_INDEX		*
 *------------------------------------------------------------------------------*/

#ifndef _PROJECT_H
#define _PROJECT_H

#include <data.h>
#include <Graph.h>
#include <Page.h>
#include <Folder.h>

#if _OC_VER > 0x0703
#include <Settings.h>
#include <OperationManager.h>
#include <GadgetManager.h>		///------ Folger 02/10/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
// #include <Operation.h>
#endif

// Comments last updated by Arvin on 06/09/2006
/**+
http://ocwiki.originlab.com/index.php?title=Category:Project_(class)
*/
/// RVD 10/25/2005 v8.0323 NON_ACTIVE_SELECTION
//class Project
class Project			:	public	OriginObject
/// end NON_ACTIVE_SELECTION
{

public:
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Project
	*/
	Project(); // Default constructor.
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Pages
	*/
	Collection<PageBase> Pages; // Collection of all the pages in the project.
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-WorksheetPages
	*/
	Collection<WorksheetPage> WorksheetPages; // Collection of all the worksheet pages in the project.
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Notes
	*/
	Collection<Note> Notes; // Collection of all the note pages in the project.
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-MatrixPages
	*/
	Collection<MatrixPage> MatrixPages; // Collection of all the matrix pages in the project.
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GraphPages
	*/
	Collection<GraphPage> GraphPages; // Collection of all the graph pages in the project.
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-LayoutPages
	*/
	Collection<LayoutPage> LayoutPages; // Collection of all the layout pages in the project.
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-LooseDatasetNames
	*/
	Collection<string> LooseDatasetNames; // Collection of names of all loose Origin datasets.
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-DatasetNames
	*/
	Collection<string> DatasetNames; // Collection of names of all Origin datasets.

	// Comments last updated by Arvin on 06/09/2006	
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a PageBase object by index.
		Keywords:
			Page;PageBase;Window;Child Window;
		Example1:
			// This example assumes several existing windows in Origin
			int Project_Pages_ex2()
			{
				PageBase pb = Project.Pages(0); // Get the first page
				if( pb.IsValid() )
					out_str(pb.GetName()); // Display the name of the first created page
				pb = Project.Pages(); // Get the active page
				if( pb.IsValid() )
					out_str(pb.GetName()); // Display the name of the active page
				return 0;
			}
		Parameters:
			index=[input]The 0-offset index of the PageBase object in the open project, or
					default -1 for the active page.
		Return:
			Returns a valid PageBase object for the index'th PageBase or the active PageBase or
			an invalid PageBase object.
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	PageBase Pages(int index = -1); // Get a PageBase object by index.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a WorksheetPage object by index.
		Keywords:
			Worksheet;Worksheet Page;Worksheet Window;
		Example1:
			// This example assumes at least one existing worksheet window in Origin
			int Project_WorksheetPages_ex2()
			{
				WorksheetPage wp = Project.WorksheetPages(0); // Get the first worksheet page
				if( wp.IsValid() )
					out_str(wp.GetName()); // Display the name of the first created worksheet page
				return 0;
			}
		Parameters:
			index=[input]The 0-offset index of the WorksheetPage object in the open project.
		Return:
			Returns a valid WorksheetPage object for the index'th WorksheetPage in the project or an invalid
			WorksheetPage object.
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	WorksheetPage WorksheetPages(int index); // Get a WorksheetPage object by index.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a Note window by index.
		Keywords:
			Note;Note Page;Note Window;
		Example1:
			// This example assumes at least one existing note window in Origin
			int Project_Notes_ex2()
			{
				Note nte = Project.Notes(0); // Get the first note page
				if( nte.IsValid() )
					out_str(nte.GetName()); // Display the name of the first created note page
				return 0;
			}
		Parameters:
			index=[input]The 0-offset index of the Note object in the open project, or
					default -1 for the active page.
		Return:
			Returns a valid Note object for the index'th Note object in the project or an invalid
			Note object.
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	Note Notes(int index = -1); // Get a Note window by index.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a Matrix window by index.
		Keywords:
			Matrix;Matrix Page;Matrix Window;
		Example1:
			// This example assumes at least one existing matrix window in Origin
			int Project_MatrixPages_ex2()
			{
				MatrixPage mp = Project.MatrixPages(0); // Get the first matrix page
				if( mp.IsValid() )
					out_str(mp.GetName()); // Display the name of the first created matrix page
				return 0;
			}
		Parameters:
			index=[input]The 0-offset index of the MatrixPage object in the open project.
		Return:
			Returns a valid MatrixPage object for the index'th MatrixPage object in the project or an invalid
			MatrixPage object.
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	MatrixPage MatrixPages(int index); // Get a Matrix window by index.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a graph window by index.
		Keywords:
			Graph;Graph Page;Graph Window;
		Example1:
			// This example assumes at least one existing graph window in Origin
			int Project_GraphPages_ex2()
			{
				GraphPage gp = Project.GraphPages(0); // Get the first graph page
				if( gp.IsValid() )
					out_str(gp.GetName()); // Display the name of the first created graph page
				return 0;
			}
		Parameters:
			index=[input]The 0-offset index of the GraphPage object in the open project.
		Return:
			Returns a valid GraphPage object for the index'th GraphPage object in the project or an invalid
			GraphPage object.
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	GraphPage GraphPages(int index); // Get a graph window by index.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a layout window by index.
		Keywords:
			Layout;Layout Page;Layout Window;
		Example1:
			// This example assumes at least one existing layout window in Origin
			int Project_LayoutPages_ex2()
			{
				LayoutPage lp = Project.LayoutPages(0); // Get the first layout page
				if( lp.IsValid() )
					out_str(lp.GetName()); // Display the name of the first created layout page
				return 0;
			}
		Parameters:
			index=[input]The 0-offset index of the LayoutPage object in open project.
		Return:
			Returns a valid LayoutPage object for the index'th LayoutPage object in the project or an invalid
			LayoutPage object.
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	LayoutPage LayoutPages(int index); // Get a layout window by index.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get the name of the dataset in the open project having the 0-offset index. If index is larger
			than the number of datasets in the project then an Origin C run-time error is generated.
		Keywords:
			Dataset;
		Example1:
			// This example assumes at least one existing dataset in Origin
			int Project_DatasetNames_ex2(int index = 0)
			{
				string strName = Project.DatasetNames(index);
				printf("Dataset(%d) Name: %s\n",index, strName);
				return 0;
			}
		Parameters:
			index=[input]An integer smaller than the number of datasets in the open project. The datasets are
				enumerated by the order in which they are created in the open project file.
		Return:
			Returns the name of the dataset having the 0-offset index.
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	string DatasetNames(int index); // Get the name of Dataset having the 0-offset index. 

	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get the name of the loose dataset (a dataset not attached to a worksheet or a matrix) having the
			0-offset index. If index is larger than the number of loose datasets in the project then an
			Origin C run-time error is generated.
		Keywords:
			Dataset;Loose Dataset;
		Example1:
			// This example assumes at least one existing loose dataset (a dataset not
			// attached to a worksheet or a matrix) in Origin
			int Project_LooseDatasetNames_ex2(int index = 0)
			{
				string strName = Project.LooseDatasetNames(index);
				printf("Loose Dataset(%d) Name: %s\n",index, strName);
				return 0;
			}
		Parameters:
			index=[input]An integer smaller than the number of loose datasets in the open project. The datasets are
				enumerated by the order in which they are created in the open project file.
		Return:
			Returns the name of the loose dataset having the 0-offset index.
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	string LooseDatasetNames(int index); // Get the name of the loose dataset having the 0-offset index.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a PageBase object by short name.
		Keywords:
			Worksheet;Worksheet Page;Worksheet Window;Book;
		Example1:
			// try this from LT, like 
			//test %H
			//test junk
			//test book1
			void test(string strName)
			{
				PageBase pb = Project.Pages(strName); // Get the PageBase for the window in Origin having the short name strName
				if( !pb.IsValid() )
				{
					printf("%s is not a valid window\n", strName);
					return;
				}
				// try to cast into a workbook
				WorksheetPage wp = pb;
				if(!wp)
				{
					printf("%s is not a workbook\n", strName);
					return;
				}
				Worksheet wks = wp.Layers(); // get active sheet
				printf("%s's top sheet has %d columns and %d rows\n", wp.GetName(), wks.GetNumCols(), wks.GetNumRows()); 
			}
		Parameters:
			lpcszName=[input]Short Name of the page in Origin.
		Return:
			Returns a valid PageBase object having the short name lpcszName or an invalid PageBase object. 
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	PageBase Pages(LPCSTR lpcszName); // Get a PageBase object by name.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a WorksheetPage object by name.
		Keywords:
			Worksheet;Worksheet Page;Worksheet Window;
		Example1:
			// This example assumes at least one existing workbook window in Origin
			int Project_WorksheetPages_ex3(string strName = "Book1")
			{
				WorksheetPage wp = Project.WorksheetPages(strName); // Get the WorksheetPage for the worksheet window in Origin having the short name strName
				if( wp.IsValid() ) // If valid...
					out_str(wp.GetName()); // Use the WorksheetPage object to display the name of the window
				return 0;
			}
		Parameters:
			lpcszName=[input]Name of the worksheet page in Origin.
		Return:
			Returns a valid WorksheetPage object having the short name lpcszName or an invalid WorksheetPage object. 
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	WorksheetPage WorksheetPages(LPCSTR lpcszName); // Get a WorksheetPage object by name.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a Note object by name.
		Keywords:
			Note;Note Page;Note Window;
		Example1:
			// This example assumes at least one existing note window in Origin
			int Project_Notes_ex3(string strName = "Notes")
			{
				Note nte = Project.Notes(strName); // Get the Note object for the note window in Origin having the short name strName
				if( nte.IsValid() ) // If valid...
					out_str(nte.GetName()); // Use the Note object to display the name of the window
				return 0;
			}
		Parameters:
			lpcszName=[input]Name of the note page in Origin.
		Return:
			Returns a valid Note object having the short name lpcszName or an invalid Note object. 
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	Note Notes(LPCSTR lpcszName); // Get a Note object by name.
	
	// Comments last updated by Joseph on 09/12/2007
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a MatrixPage object by name.
		Keywords:
			Matrix;Matrix Page;Matrix Window;
		Example1:
			// This example assumes at least one existing matrix window in Origin
			int Project_MatrixPages_ex3(string strName = "MBook1")
			{
				MatrixPage mp = Project.MatrixPages(strName); // Get the MatrixPage for the matrix window in Origin having the short name strName
				if( mp.IsValid() ) // If valid...
					out_str(mp.GetName()); // Use the MatrixPage object to display the name of the window
				return 0;
			}
		Parameters:
			lpcszName=[input]Name of the matrix page in Origin.
		Return:
			Returns a valid MatrixPage object having the short name lpcszName or an invalid MatrixPage object. 
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	MatrixPage MatrixPages(LPCSTR lpcszName); // Get a MatrixPage object by name.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a GraphPage object by name.
		Keywords:
			Graph;Graph Page;Graph Window;
		Example1:
			// This example assumes at least one existing graph window in Origin
			int Project_GraphPages_ex3(string strName = "Graph1")
			{
				GraphPage gp = Project.GraphPages(strName); // Get the GraphPage for the graph window in Origin having the short name strName
				if( gp.IsValid() ) // If valid...
					out_str(gp.GetName()); // Use the GraphPage object to display the name of the window
				return 0;
			}
		Parameters:
			lpcszName=[input]Name of the graph page in Origin.
		Return:
			Returns a valid GraphPage object having the short name lpcszName or an invalid GraphPage object. 
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	GraphPage GraphPages(LPCSTR lpcszName); // Get a GraphPage object by name.
	
	// Comments last updated by Arvin on 06/09/2006
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Remarks:
			Get a LayoutPage object by name.
		Keywords:
			Layout;Layout Page;Layout Window;
		Example1:
			// This example assumes at least one existing layout window in Origin
			int Project_LayoutPages_ex3(string strName = "Layout1")
			{
				LayoutPage lp = Project.LayoutPages(strName); // Get the LayoutPage for the layout window in Origin having the short name strName
				if( lp.IsValid() ) // If valid...
					out_str(lp.GetName()); // Use the LayoutPage object to display the name of the window
				return 0;
			}
		Parameters:
			lpcszName=[input]Name of the layout page in Origin.
		Return:
			Returns a valid LayoutPage object having the short name lpcszName or an invalid LayoutPage object. 
		SeeAlso:
			Project::Pages, Project::WorksheetPages, Project::Notes, Project::MatrixPages, 
			Project::GraphPages, Project::LayoutPages, Project::LooseDatasetNames, Project::DatasetNames
	*/
	LayoutPage LayoutPages(LPCSTR lpcszName); // Get a LayoutPage object by name.
	
	// Comments last updated by Arvin on 06/09/2006	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-ActiveCurve
	*/
	Curve ActiveCurve();

#ifdef 	 _CURVE_BASE
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-ActiveCurveBase
	*/
	curvebase& ActiveCurveBase();
#endif// _CURVE_BASE
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-ActiveLayer
	*/
	Layer ActiveLayer();
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-RootFolder
	*/
	Folder RootFolder;
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-ActiveFolder
	*/
	Folder ActiveFolder();
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetFolderWithPage
	*/
	Folder GetFolderWithPage(LPCSTR lpcszWindowName);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetFolderWithPage
	*/
	Folder GetFolderWithPage(PageBase &page);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-ActivateFolder
	*/
	BOOL ActivateFolder(LPCSTR lpszPath);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetName
	*/
	string GetName(BOOL bAddFileExtension = false);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetPath
	*/
	string GetPath();
	
	/**$
	Parameters:
		lpcszXFName = [input]name of the X-Function requested to be unpacked. 
	Return:
		non-zero if successful, else zero. 
	Remark:
		Unpacks the X-Function that was packed in one of the files opened. 
	*/
	BOOL UnpackXFunction(LPCSTR lpcszXFName);
	
	///---Sim 07-28-2008 CORRECT_WRONG_HEADER_COMMENT
	enum {OPJ_OPEN_NORMAL, OPJ_OPEN_READONLY, OPJ_OPEN_APPEND, OPJ_OPEN_APPEND_NEW_FOLDER};
	///---END CORRECT_WRONG_HEADER_COMMENT
	// Comments last updated by Joseph on 09/12/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Open
	*/
	///DSC 10/03/2005 v8.0114 QA70-8147 PROJECT_APPEND
	// BOOL Open(LPCSTR lpcszFilename = NULL, BOOL bOpenReadOnly = FALSE);
	///---Sim 07-28-2008 CORRECT_WRONG_HEADER_COMMENT
	//enum {OPJ_OPEN_NORMAL, OPJ_OPEN_READONLY, OPJ_OPEN_APPEND, OPJ_OPEN_APPEND_NEW_FOLDER};
	///---END CORRECT_WRONG_HEADER_COMMENT
	BOOL Open(LPCSTR lpcszFilename = NULL, int nOptions = OPJ_OPEN_NORMAL);
	///end PROJECT_APPEND
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Save
	*/
	///DSC 7/23/06 QA70-7230 AUTOSAVE_TO_AUTORECOVER_BACKUP_FILE
	// BOOL Save(LPCSTR lpcszFilename = NULL);
	BOOL Save(LPCSTR lpcszFilename = NULL, BOOL bRename = true);
	/// end AUTOSAVE_TO_AUTORECOVER_BACKUP_FILE
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-IsModified
	*/
	BOOL IsModified();
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-ClearModified
	*/
	void ClearModified();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-RegisterUpdates
	*/
	BOOL RegisterUpdates(BOOL bRegister = FALSE);
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetDragDropInfo
	*/
	BOOL GetDragDropInfo(string &strWinName, int &iWinLayer, int &iFileIndex, int &iFileCount, string &strFileName);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-IsVisible
	*/
	BOOL IsVisible(int nWinID=CWT_PROJECT_EXPLORER);
	
	// Comments last updated by Joseph on 09/12/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-ShowWindow
	*/
	void ShowWindow(int nWinID=CWT_PROJECT_EXPLORER, BOOL bShow=TRUE);  
	
	// Comments last updated by Joseph on 9/04/2006	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetDataObject
	*/
	DataObject& GetDataObject(LPCSTR name);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetDatasetInfo
	*/
	///------ Folger 01/20/2011 ORG-1962-P8 SUPPORT_GET_DATASET_DEPENDENT_XDENPENDENT_IN_OC
	//DWORD GetDatasetInfo(LPCTSTR lpcszDatasetName, BOOL bNeedFolderInfo = FALSE);
	DWORD GetDatasetInfo(LPCTSTR lpcszDatasetName, BOOL bNeedFolderInfo = FALSE, LPDatasetInfoMore pstMore = NULL);
	///------ End SUPPORT_GET_DATASET_DEPENDENT_XDENPENDENT_IN_OC
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetDatasetMasks
	*/
	int GetDatasetMasks(LPCTSTR lpcszDatasetName, vector<uint>& vnMaskIndices, vector<int>& vnMaskValues);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-SetDatasetMasks
	*/
	int SetDatasetMasks(LPCTSTR lpcszDatasetName, const vector<uint>& vnMaskIndices = NULL, const vector<int>& vnMaskValues = NULL);
	///Sophy 12/23/2010 ORG-1846-P2 SPEEDUP_DATA_MANIPULATION_ON_LARGE_DATA
	/**$
	*/
	int SetDatasetMasks(LPCTSTR lpcszDatasetName, const vector<int>* pvnMaskIndices, BOOL bMask = TRUE, BOOL bUndo = FALSE);
	///end SPEEDUP_DATA_MANIPULATION_ON_LARGE_DATA
	
#if _OC_VER > 0x0703
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-FindFunction
	*/
	Function FindFunction(LPCSTR lpcszFunctionName, LPCSTR lpcszFileName = NULL, BOOL bCompileDependents = false, BOOL bSuppressPromptBox = false, BOOL bCheckFileChange = false
		///------ Folger 09/29/2012 ORG-7029-P1 OC_FIND_FUNCTION_SUPPORT_OVERLOAD_INDEX
		, int nOverloadIndex = 0
		///------ End OC_FIND_FUNCTION_SUPPORT_OVERLOAD_INDEX
		);
	
	///------ Folger 06/18/09 QA80-13802 SUPPORT_FIND_COMPILED_FUNCTION_FROM_OC
	/**$
	*/
	Function FindCompiledFunction(LPCSTR lpcszFunctionName);
	///------ End SUPPORT_FIND_COMPILED_FUNCTION_FROM_OC
	
	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			
		Keywords:
			
		Example1:
		
		SeeAlso:
	*/
	OriginSettings Settings;
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Compile
	*/
	BOOL Compile(LPCSTR lpcszFileName, int* lpResult = NULL);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Reset
	*/
	BOOL Reset( BOOL bReduceWksSize = TRUE, BOOL bReduceMatrices = TRUE );
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Run
	*/
	bool Run(UINT uid = 0);
	
	// Comments last updated by Jospeh on 09/12/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetObject
	*/
	///------ Folger 08/15/2012 ORG-6381-S1 DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET
	//OriginObject GetObject(UINT uid, LPCSTR lpcszGUID = NULL);
	OriginObject GetObject(UINT uid, LPCSTR lpcszGUID = NULL, BOOL bCreateInternalClass = FALSE);
	///------ End DATAPLOT_GETDATAPOINT_SUPPORT_NO_Y_OFFSET
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-UndoBlockBegin
	*/
	void UndoBlockBegin();
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-UndoBlockEnd
	*/
	void UndoBlockEnd();
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-UndoBlockId
	*/
	int UndoBlockId();
	
	/// YuI 01/08/09 QA70-12881 UNDO_BLOCK_NAME_ID_EXPOSE_TO_ORIGINC
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-UndoBlockNameId
	*/
	void UndoBlockNameId(int nId);
	/// end UNDO_BLOCK_NAME_ID_EXPOSE_TO_ORIGINC
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Undo
	*/
	int Undo(int nBlockID = 0);
	
	// Comments last updated by Arvin on 06/09/2006
	/**$	
	*/
	Tree CreateNewTheme();
	
	// Comments last updated by Arvin on 06/09/2006
	/**$
	Parameters:
		tn = [input/output] tree node as input/output
	Return:
		TRUE if success, FALSE if failure 
	Remark:
		Updates data plot limits. 
	*/
	BOOL UpdateDataPlotLimits(TreeNode& tn);
	
	// Comments last updated by Arvin on 06/09/2006
	/**$
	Parameters:
		tnDP = [input] tree node as input which has dataplots 
		tnLayer = [input/ouput] tree node as input/ouput has layer settings and rescale property 
	Return:
		TRUE if success, FALSE if failure 
	Remark:
		Updates layer rescale. 
	*/
	BOOL UpdateLayerRescale(TreeNode& tnDP, TreeNode& tnLayer);
	
	// Comments last updated by Joseph on 09/12/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetCommonColumns
	*/
	/// ML 10/10/2008 QA70-11938 GETTING_COLUMN_HEADINGS_FOR_PS
	//BOOL GetCommonColumns(const vector<string> &worksheets, vector<string> &columnNames, vector<string> &columnLabels, DWORD dwMode);
	BOOL GetCommonColumns(const vector<string> &worksheets, vector<string> &columnNames, vector<string> &columnLabels, DWORD dwMode, vector<string> &columnHeadings = NULL);
	/// end GETTING_COLUMN_HEADINGS_FOR_PS
	
	// Comments last updated by Joseph on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetPlotDesignations
	*/
	BOOL GetPlotDesignations(int nPlotType, DWORD dwAuxTypeInfo, LPCTSTR lpcszColPattern, vector<uint> &vplotdesig);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetPlotTypeInfo
	*/
	int GetPlotTypeInfo(int nPlotID, DWORD& dwAuxTypeInfo, DWORD& dwAuxPlotInfo, string& strColPattern);
	
	// Comments last updated by Arvin on 06/09/2006
	/**$
	Parameters:
		tr = [output] the tree to be generated. 
		nPlotType = [input] the plot type 
		dwAuxTypeInfo = [input] auxiliary plot type info 
		dwLTPlotInfo = [input] LabTalk plot type info 
		lpcszColPattern = [input] string in the form of "XY" to indicate the typical plot designation combinations 
		nExVal = [input] extra control info that is used in making a new plot, like to connect data points using spline 
		vpdesig = [input] the array of plot designations (see #4658) 
		vsWksPages = [input] the array of wks. page names
		vsLayers = [input] the array of wks. layer names
		vsCols = [input] the array of column names corresponding to vpdesig
		dwCntrl = [input] bits 
    			  DPEDTVIEW_HIDE_LIMITS prevents calculation of data plot limits 
    			  DPEDTVIEW_COL_LONGNAMES vsCols passed in are column long names
    	pnRngRows = [input,optional]points to two integers for the row range to use 
	Return:
		one of the values from the following enumeration:
		enum {		
		MDPT_SUCCESS = 0,		
		MDPT_INCOMPLETE, // column designations are not finished for the specified plot type. typically when X or Y is missing		
		MDPT_WRONG_ORDER // Example: for bubble plots the column that determines the size of symbols must be after the y-column.		
		}; 
	
	Remark:
		Given a plot type (one of IDM_PLOT_* values), the auxiliary plot type info, a string with col designs,
		an array of integers representing plot designations of columns (for those plot types for which the order 
		of columns is important, see #4658, the array of integers will be in the order of columns in worksheet),
		the arrays of wks. page and layer names, and an array of column names, generate the above tree. 
	*/
	/// ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
	//int MakeDataplotsTree(TreeNode &tr, int nPlotType, DWORD dwAuxTypeInfo, DWORD dwLTPlotInfo,
	//	LPCTSTR lpcszColPattern, uint nExVal, const vector<uint> &vpdesig, const vector<string> &vsWksPages,
	//	const vector<string> &vsLayers, const vector<string> &vsCols, DWORD dwCntrl);
	int MakeDataplotsTree(TreeNode &tr, int nPlotType, DWORD dwAuxTypeInfo, DWORD dwLTPlotInfo,
		LPCTSTR lpcszColPattern, uint nExVal, const vector<uint> &vpdesig, const vector<string> &vsWksPages,
		const vector<string> &vsLayers, const vector<string> &vsCols, DWORD dwCntrl, const int *pnRngRows = NULL);
	/// end QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
#endif // _OC_VER > 0x0703


	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-NewOperation
	*/
	OperationBase* NewOperation(LPCSTR lpcszClassName, LPCSTR lpcszPath, BOOL bAddToOperationList = TRUE);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-DeleteOperation
	*/
	BOOL DeleteOperation(OperationBase* op, BOOL bRemoveFromOperationList = FALSE);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetOperationObject
	*/
	/// ML 11/20/2008 QA70-12625 TRY_TO_GET_ORIGINAL_OCOPERATION_OBJECT
	//OperationBase& GetOperationObject(UINT uid, LPCSTR lpcszGUID = NULL);
	OperationBase& GetOperationObject(UINT uid, LPCSTR lpcszGUID = NULL, BOOL bCheckUseOriginalOC = FALSE);
	/// end TRY_TO_GET_ORIGINAL_OCOPERATION_OBJECT
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-Operations
	*/
	OperationManager Operations;
	
	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			Turn on/off profiling
		Keywords:
		
		Example1:

		Parameters:
			bStart=[input]set internal flag to enable/disable profiling for functions.
			bResetAll=[input]TRUE, to walk all functions to reset profiling info
		Return:
			flag value before call.  
		SeeAlso:
		
		*/
	BOOL Profile(BOOL bStart, BOOL bResetAll = TRUE);
	
	// Comments last updated by Arvin on 06/09/2006	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetProfileData
	*/
	BOOL GetProfileData(vector<string>& vsFuncNames, vector<uint>& vnNumCalls, vector<double>& vdTimes);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-AddDataRange
	*/
	int AddDataRange(DataRange& rg);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetDataRange
	*/
	BOOL GetDataRange(DataRange& rg, LPCSTR lpcszName);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-RemoveDataRange
	*/
	BOOL RemoveDataRange(LPCSTR lpcszName);
	
	// Comments last updated by Arvin on 06/09/2006
	/// YuI 08/29/05 QA70-7958 BETTER_DATA_PROTECTION_FEEDBACK
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-RemoveDataRange
	*/
	BOOL RemoveDataRange(DataRange& dr);
	/// end BETTER_DATA_PROTECTION_FEEDBACK
	
	// Comments last updated by Arvin on 06/09/2006
	/// ML 1/13/2006 XVARIABLEBASE_TO_VC
	/**#
		Remarks:
			It initializes the input tree node for analysis in accordance with the current selection.
		Keywords:
			
		Example1:

		Parameters:
			trInputData=[input]The tree node to be initialized
			dwDataRules=[input]the rule bits according to which the initialization ought to be performed
			pErrCode=[output,optional]*pErrCode recives the error result, if any.
			obj=[input,optional]the reference object.
			pnInputPageType=[output,optional]*pnInputPageType receives the enumerated type of the input page.
		Return:
			TRUE is success.			
		SeeAlso:
	*/
	BOOL	InitInputDataBranchFromSelection(TreeNode &trInputData, DWORD dwDataRules, int *pErrCode, OriginObject& obj, int *pnInputPageType = NULL);
	/// end XVARIABLEBASE_TO_VC



/// ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
#ifdef		__OC_GRID_RLOG
/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			log=[output]
		Return:
			
		SeeAlso:
			
	*/
	void GetResultLog(ResultsLog &log);
/// ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
#else		// !__OC_GRID_RLOG
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-OutStringToResultsLog
	*/
	BOOL	OutStringToResultsLog(LPCSTR lpcszString, BOOL bAddCRLF = TRUE, LPCSTR lpcszName = NULL);
#endif		// !__OC_GRID_RLOG
/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			bEnable=[input]
		Return:
			
		SeeAlso:
			
	*/
	void EnableGUI(BOOL bEnable = TRUE);
	
	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			
		Return:
			
		SeeAlso:
			
	*/
	BOOL IsGUIEnabled();
	
	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			nIndex=[input]
		Return:
			
		SeeAlso:
			
	*/
	ToolBase GetTool(int nIndex);
	
	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			nIndex=[input]
		Return:
			
		SeeAlso:
			
	*/
	BOOL ActivateTool(int nIndex);
	
	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			
		Return:
			
		SeeAlso:
			
	*/
	void ResetTools();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetReportTree
	*/
	BOOL GetReportTree(TreeNode& tr, uint ReportUID, Datasheet& wks = NULL, int nType = GRT_TYPE_RESULTS);

	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			It appends the report tree to the Results log.
		Keywords:
			
		Example1:

		Parameters:
			tr=[input]
			uidOp=[input]
			bTranslate=[input]
		Return:
			
		SeeAlso:
			
	*/
	int SetReportTree(TreeNode &tr, DWORD uidOp, BOOL bTranslate = FALSE);
	
	// Comments last updated by Arvin on 06/09/2006
	/**#
		Remarks:
			It searches the project for all occurences of the string.
		Keywords:
			
		Example1:

		Parameters:
			tr=[output]receives the result of the search
			dwObjectsFilter=[input]filter option for object search need more info added
			lpcszToSearch=[input]the string to search for
			nSearchMode=t[input]he seaech mode. The values come from the enumeration:
			enum {
				OSEARCHMODE_SUBSTRING					= 0,
				OSEARCHMODE_FULL_STRING,
				OSEARCHMODE_WILDCARDED_STRING,
				OSEARCHMODE_BASIC_MODE_MASK				= 0x0000000FUL,

				OSEARCHMODE_STRING_CASE_SENSITIVE		= 0x00010000UL,
			};
		Return:
			0 if OK, otherwise nonzero.
		SeeAlso:
	*/
	int Search(TreeNode &tr, DWORD dwPropertiesFilter, DWORD dwObjectsFilter, LPCTSTR lpcszToSearch, UINT nSearchMode);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-FindClass
	*/
	ClassObject FindClass(LPCSTR lpcszName, LPCSTR lpcszPath = NULL, BOOL bCompileDependents = TRUE);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-CreateClass
	*/
	ClassObject CreateClass(LPCSTR lpcszName, LPCSTR lpcszPath = NULL, BOOL bCompileDependents = TRUE, BOOL bAutoDelete = TRUE);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetDatasetPlotList
	*/
	int GetDatasetPlotList(LPCSTR lpcszDatasetName, vector<string>& vsGraphNames = NULL, vector<int>& vnLayers = NULL, vector<int>& vnPlotDesignations = NULL, BOOL bExcluldeModifiers = false); 
	
	// Comments last updated by Arvin on 06/09/2006
	/**$
	Parameters:
		lpcszCmd = [input]command string, "A" to add a new OPJ, return index of newly added. "C" to close active OPJ, etc 
		dwArg = [input]optional argument for the given command 
	Return:
		-1 for error, otherwise will depend on given command 
	Remark:
		management function for multiple OPJ support 
	*/
	int MultiProjects(LPCSTR lpcszCmd, DWORD dwArg);
	// Comments last updated by Jasmine on 09/08/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-AddTree
	*/
	int AddTree(LPCSTR lpcszName, const TreeNode& tr);
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetTreeNames
	*/
	int GetTreeNames(vector<string>& vsNames);
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-DeleteTree
	*/
	BOOL DeleteTree(LPCSTR lpcszName);
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetTree
	*/
	BOOL GetTree(LPCSTR lpcszName, TreeNode& tr);

	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetLTVars
	*/
	int	GetLTVars(vector<string> &vsNames, vector<double> &vdValues = NULL, BOOL bUserVarsOnly = TRUE, vector<int> &vnTypes = NULL);
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetLTStrVars
	*/
	int	GetLTStrVars(vector<string> &vsNames, vector<string> &vsValues = NULL, BOOL bUserVarsOnly = TRUE);

	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	/**#
	*/
	int	GetSessionLTVars(vector<string> &vsNames, vector<string> &vsValues = NULL, int nType = LTVAR_TYPE_VAR_ALL);
	
	/**#
	*/
	BOOL GetFunction(LPCSTR lpcszFunctionName, string &strPrototype, string &strBody);
	///---END QA81-14106 IMPROVE_ED_DIALOG
	
	///---Sim 09-21-2009 QA81-14106 SECOND_IMPROVE_ED_DIALOG
	/**#
	*/
	BOOL GetSessionTree(LPCSTR lpcszName, TreeNode& tr);
	
	/**#
	*/
	int	GetMacros(vector<string> &vsNames, vector<string> &vsContents = NULL);
	///---END QA81-14106 SECOND_IMPROVE_ED_DIALOG

	///---Sim 01-06-2010 ORG-1870 SUPPORT_VAR_DLG_SHOW_TEXT_LOOSE_DATASET
	/**#
	*/
	BOOL GetSessionLooseDataset(LPCSTR lpcszName, vector<string> &vsData);
	///---END ORG-1870 SUPPORT_VAR_DLG_SHOW_TEXT_LOOSE_DATASET
	
	/// TD 11-17-05 QA70-7835 OC_ACCESS_TO_ATTACHED_FILES 
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-AttachFile
	*/
	BOOL   AttachFile(LPCSTR lpcszPathaName);
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetAttachedFileNames
	*/
	int    GetAttachedFileNames(StringArray &saNames);
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-RemoveAttachedFile
	*/
	BOOL   RemoveAttachedFile(LPCSTR lpcszName);
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-RemoveAllAttachedFiles
	*/
	BOOL   RemoveAllAttachedFiles();
	/// end OC_ACCESS_TO_ATTACHED_FILES 



	// Comments last updated by GRD on 2005.05.16
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetStorage
	*/
	storage		GetStorage(LPCSTR lpcszName, bool bAdd = FALSE); // Access storage areas.


	// Comments last updated by GRD on 2005.05.16
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-GetStorageNames
	*/
	BOOL 		GetStorageNames(vector<string> &vsNames); // Get names of storage class objects
	
	// Comments last updated by Arvin on 06/09/2006
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Project-FindPage
	*/
	Page	FindPage(LPCSTR lpcszName, int nType = EXIST_WKS, int nAlsoCanbeType = EXIST_MATRIX, BOOL bAlsoCanbeLongName = true);

	/// ML 7/17/2006 GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION
	/**$
	*/
	XFExeContext	*GetCurrentXFExeCtxt();
	/// end GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION
	/// Last updated by Sim, 08-01-2008 need # for each method
	/**$
	*/
	///Arvin  03/08/08 ADD_PARAM_INIT_CONTEXT_CLASS as Marko said
	ParamInitContext  *GetParamInitContext(); 
	///end 	ADD_PARAM_INIT_CONTEXT_CLASS
	/// Last updated by Sim, 08-01-2008 need # for each method
	/**$
	*/
	/// ML 4/20/2008 QA70-11061 GETTING_CURRENT_FIT_INFO
	NLFitContext	*GetNLFitContext();
	/// end GETTING_CURRENT_FIT_INFO

	/// ML 9/18/2008 QA70-12199 FASTER_FIT_LABTALK_CALL
	/**$
		It sets up or clears the fast evaluation of the LabTalk's fit() function call.
	Parameters:
		pvInit=[input]pointer to the structure NLFITCURVEEVALINIT with the information
				necessary to initalize the internal object which will subsequently be used
				for fast evalution.
		pFF=[input]the FDF tree of the fitting function to use.
	Returns:
		0 if OK.
	Remarks:
		pass both pvInit and pFF as NULL to clean up the internal object.
	*/
	int				FitCurveEval(void *pvInit = NULL, TreeNode &pFF = NULL);
	/// end FASTER_FIT_LABTALK_CALL

	/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	/**$
		Add or Remove an array of series names to DataChangeMonitor
	  Parameters:
	    vsDataSetNames = [input] names of datasets to add/remove
	    hDlgWnd = [input] NULL to remove, otherwise to add
	  Remark:
	    DataChangeManager will save the hDlgWnd to each Dataset, when a dataset is changed, it will check itself to see if it has such a hDlgWnd and if not NULL, then it will post message to that window with its name.
	*/
	int				DataChangeMonitor(const vector<string>& vsDataSetNames, HWND hDlgWnd);
	/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG

	///Kyle 06/08/2009 QA70-13423 SUPORT_GET_MENU_TEXT_FROM_OC
#ifdef __CUSTOM_MENU_CONSTRUCTION__
	/**$
		get original main menu texts
		Parameters:
	    vsTexts = [output] the menu texts
	    nWndType = [intput] window type, specifying which menu to get the texts from, can be one of EXIST_WKS, EXIST_GRAPH, EXIST_MATRIX
	    nMenuIndex = [input] -1 will get the main popup texts, otherwise will the nMenuIndex-th sub popup(0 offset)
	  Remark:
	  	
	*/
	int				GetMainMenuTexts(vector<string>& vsTexts, int nWndType, int nMenuIndex = -1);

	///Kyle 06/11/2009 QA70-13423 CUSTOM_MENU_SWITCH_MENU_MODE_BETWEEN_CNF_AND_OMC
	BOOL			MenuModifiedFromLT();
	///End CUSTOM_MENU_SWITCH_MENU_MODE_BETWEEN_CNF_AND_OMC

	///Kyle 02/26/2010 QA80-15138 KEEP_MENU_TAG_FOR_HIDE_BUILT_IN_MENU_LIST_TO_INDICATE_THE_POPUP_INDICES_IN_OMC
	BOOL	GetBuiltInMenuTags(vector<string>& vsTexts, int nWndType);
	///End KEEP_MENU_TAG_FOR_HIDE_BUILT_IN_MENU_LIST_TO_INDICATE_THE_POPUP_INDICES_IN_OMC

#endif // __CUSTOM_MENU_CONSTRUCTION__
	///End SUPORT_GET_MENU_TEXT_FROM_OC

	/**$
		Get project audit log
		Parameters:
			strLogMsg = [Output] receive audit log text, in format: UserName|Date/Time|Info|UserName|Date/Time|Info...
		Return:
			return 0 for diable, 1 for enable, 2 for enable with password set.
	*/
	int GetProjAuditLogInfo(string& strLogMsg);
	/// end ADD_PROJECT_AUDIT_LOG
	/**$
		Remarks:
			Starts a Slideshow with the Graphs and Matrices names passed in. 
		Parameters:
			arrPages	= [input] contains names of graph and matix pages in proper order for the slide show.
			nTimeDelay	= [input] time Delay in milliseconds.
			dwOptions	= [input] slide show options, one or more of the bits defined in OC_const.h (SLIDE_SHOW_TERMINATE etc.)
		Return:
			Returns non-zero if successful otherwise FALSE
	*/
	BOOL StartSlideShow(StringArray &arrPages, int nTimeDelay, DWORD dwOptions = 0); 

	///------ Folger 08/19/2011 ORG-3537 OC_NAMED_RANGE_SUPPORT
	#ifdef	NEW_NAMED_RANGE_FEATURE
	/**$
		Create and Replace a named range in the project
	Parameters:
		lpcszName = [input] The name used to define the Named Range
		lpcszRange = [input] The range string to define the range, if owner is at the book level, then sheet portion will be either empty, or is a range of multiple sheets
		lpcszScopeRange = [input] The range string to define the owner range
		edr = [input] Data extraction rule
		nPlotDesig = [input] optional plot designation
		nDimension = [input] dimension of the range, can be 0 for scalor, 1 for vector and 2 for matrix. -1 means auto determine from the given range specified
	Returns:
		return 0 if already existed and updated, 1 if newly created, <0 for errors 
	*/
	int		AddNamedRange(LPCSTR lpcszName, LPCSTR lpcszRange, LPCSTR lpcszScopeRange, VSExtractDataRule edr = VSEDR_CONCATENATE_BY_COLUMN, int nPlotDesig = OKDATAOBJ_DESIGNATION_NONE, int nDimension = -1); 

	/**$
		Get all the named ranges defined in the project
	Parameters:
		vsNames=[output]The actual names assigned to the named range
		vsBookSheet=[output]This contain the owner of the Named Range, one can also obtain this by constructing the NamedRange object
	Returns:
		total number of named ranages returned, <0 for error codes
	*/
	int		GetNamedRangeNames(vector<string>& vsNames = NULL, vector<string>& vsBookSheet = NULL);
	#endif	/// NEW_NAMED_RANGE_FEATURE
	///------ End OC_NAMED_RANGE_SUPPORT

	GadgetManager		Gadgets;			///------ Folger 02/10/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
};




#if _OC_VER > 0x0703

// Comments last updated by Iris on 03/13/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:UndoBlock_(class)
*/
class UndoBlock
{
public:
	// Comments last updated by GJL on 04/11/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:UndoBlock-UndoBlock
	*/
	/// YuI 01/08/09 QA70-12881 UNDO_BLOCK_NAME_ID_EXPOSE_TO_ORIGINC
	//	UndoBlock() {Project.UndoBlockBegin();}
	UndoBlock(int nNameID = 0, BOOL bUndo = TRUE)
	{
		m_bUndo = bUndo;
		if ( m_bUndo )
		{
			Project.UndoBlockBegin();
			if( nNameID != 0 )
				Project.UndoBlockNameId(nNameID);
		}
	}
	/// end UNDO_BLOCK_NAME_ID_EXPOSE_TO_ORIGINC

	// Comments last updated by GJL on 04/11/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:UndoBlock-~UndoBlock
	*/
	~UndoBlock() 
	{
		if ( m_bUndo )
		{
			Project.UndoBlockEnd();
		}
	}

private:
	BOOL	m_bUndo;
};

#if _OC_VER >= 0x0800
struct CompilerOutput
{
	int 	nLineErr;
	string	strErr;
};
// Comments last updated by GJL on 04/11/2005
/**# >Internal Origin Objects
	Remarks:
			
	Keywords:
		
	Example1:	
	
	Parameters:
		
	Return:

	SeeAlso:
		
*/
class CodeBuilder
{
public:

	// Comments last updated by GJL on 04/11/2005
	/**
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			
		Return:
			
		SeeAlso:
			
	*/
	CodeBuilder();
	
	// Comments last updated by Frank on 04/05/2005
	/**
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			lpcszFile=[input]Name of the file with full path.  (file types : OXC and FIT)
			vpStaticBlocks=[input]The passed vector contains data to make only relavant part of the file editable from code builder
			hWndColler=[input]The passed handle to Window is used to Post message on compile, or on save doc from code builder etc.
			
		Return:
			
		SeeAlso:
			
	*/
	BOOL Open(LPCSTR lpcszFile, vector<point>& vpStaticBlocks, HWND hWndColler); 

	// Comments last updated by Frank on 04/05/2005
	/**
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			lpcszFile=[input]Name of the file(with full path) that has custom compile and back dialog buttons (file types : OXC and FIT)
			vpStaticBlocks=[input]The passed vector contains data to make only relavant part of the file editable from code builder
			hWndColler=[input]The passed handle to Window is used to Post message on compile, or on save doc from code builder etc.
		Return:
			non zero if successful otherwise zero
			
		SeeAlso:
			
	*/
	BOOL SetAsStatic(LPCSTR lpcszFile, vector<point>& vpStaticBlocks, HWND hWndColler);

	// Comments last updated by GJL on 04/11/2005
	/**
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			lpcszFile=[input]Name of the file(with full path) that has custom compile and back dialog buttons (file types : OXC and FIT)
			lpcszNewButtonName=[input]The passed string is used to rename the return to dialog button
			
		Return:
			non zero if successful otherwise zero	
		SeeAlso:
			
	*/
	BOOL UpdateButtonName(LPCSTR lpcszFile, LPCSTR lpcszNewButtonName);	

	// Comments last updated by GJL on 04/11/2005
	/**
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			lpcszFile=[input]Name of the file(with full path) that needs post messages to the provided handle to the window on compile,save and document close
			hWndCallback=[input]The passed handle to Window is used to Post message on compile, or on save doc from code builder etc.
		Return:
			non zero if successful otherwise zero
			
		SeeAlso:
			
	*/
	BOOL SetCallbackHwnd(LPCSTR lpcszFile, HWND hWndCallback);

	// Comments last updated by GJL on 04/11/2005
	/**
		Remarks:
			
		Keywords: 
			X-Function
		Example1:

		Parameters:
			lpcszFile=[input]Name of the file(with full path) that needs to be compiled
			hWndCallback=[input]The passed handle to Window is used to Post message on compile, or on save doc from code builder etc.
			output = [output] If not null, will store the errro meessage include the error line and error message
		Return:
			non zero if successful otherwise zero
			
		SeeAlso:
			
	*/
	BOOL Compile(LPCSTR lpcszFile, HWND hWndCallback, CompilerOutput &output = NULL);

	/**
		Remarks:
			
		Keywords: 
			XFunction, XF
			
		Example1:

		Parameters:
			lpcszName=[input]Name of the function
			lpcszDeclaration=[input]String containing declaration of the function lpcszName
		Return:
			non zero if successful otherwise zero
			
		SeeAlso:
			
	*/
	BOOL UpdateXFunction(LPCSTR lpcszName, LPCSTR lpcszDeclaration);


	/**
		Remarks:
		
		Keywords:
			
		Example1:
			
		Parameters:
			lpcszFile=[input]Name of the file(with full path) that needs post messages to the provided handle to the window on compile,save and document close
			lpcszOxf=[input]The passed string lpcszOxf is remembered as the *.OXF file, and used fo saving and retriving  info for the corresponding *.xfc files
		Return:
			non zero if successful otherwise zero
			
	*/
	BOOL SetOxfName(LPCSTR lpcszFile, LPCSTR lpcszOxf);
	

};


// Comments last updated by Joseph on 04/04/2007
/**# >User Interface Controls
	Remarks:
	
	Keywords:
		
	Example1:
		
	SeeAlso:
		
*/
class EnableGUIHelper
{
public:

	// Comments last updated by GJL on 04/11/2005
	/**
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			bEnable=[input]
		Return:
			
		SeeAlso:
			
	*/
	EnableGUIHelper(BOOL bEnable = TRUE)
	{
		m_bPreviouseState = Project.IsGUIEnabled();
		Project.EnableGUI(bEnable);
	}

	// Comments last updated by GJL on 04/11/2005
	/**
		Remarks:
			
		Keywords:
			
		Example1:

		Parameters:
			
		Return:
			
		SeeAlso:
			
	*/
	~EnableGUIHelper()
	{
		Project.EnableGUI(m_bPreviouseState);
	}
	
private:

	// Comments last updated by GJL on 04/11/2005
	/**
		Remarks:
			
		Keywords:
			
		Example1:

		SeeAlso:
			
	*/
	BOOL m_bPreviouseState;
};
#endif //_OC_VER >= 0x0800


#endif // _OC_VER > 0x0703

#endif //_PROJECT_H
