/*------------------------------------------------------------------------------*
 * File Name:Profiler.h															*
 * Creation: AW 6/20/2003														*
 * Purpose: OriginC profiler class for function speed measurement				*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 12/29/08 CHK_ELAPSED_TIME_FOR_OC_DIALOG_TO_OPEN_TOO_SLOWLY				*
 *	Folger 12/31/08 QA80-12878 v8.0992b IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM	*
 *------------------------------------------------------------------------------*/

#ifndef _PROFILER_H
#define _PROFILER_H

//--- CPY 12/29/08 CHK_ELAPSED_TIME_FOR_OC_DIALOG_TO_OPEN_TOO_SLOWLY
#define _SHOW_OC_DLG_OPEN_TIME
//---

#include <sys_utils.h>
#include <tree_utils.h>

/**+
http://ocwiki.originlab.com/index.php?title=Category:Profiler_(class)
*/
class Profiler
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Profiler-Profiler
	*/
	Profiler(int nDisplayNum = 10)
	{
		m_nDisplayNum = nDisplayNum;
		Project.Profile(TRUE, TRUE);
	}

	/**$	
	*/
	~Profiler()
	{
		BOOL bOK = Project.GetProfileData(m_vsFuncNames, m_vnNumCalls, m_vdTimes);
		int nCount = m_vsFuncNames.GetSize();
		if ( nCount > m_nDisplayNum )
		   nCount = m_nDisplayNum;
		if(nCount < 1)
		{
			printf("Insignificant data...\n");
			return; //too few calls
		}
		
		vector<uint> vnIndeces;
		m_vdTimes.Sort(SORT_DESCENDING, TRUE, vnIndeces);
		m_vsFuncNames.Reorder(vnIndeces);
		m_vnNumCalls.Reorder(vnIndeces);
		//int nMaxFunDisplaySize = 40;	// ML 8/22/2008
		int nMaxFunDisplaySize = 80;
		printf("Top %d most time consuming functions:\n", nCount);
		string strFuncNameTitle = "Function Name";
		append_blanks_to_size(strFuncNameTitle, nMaxFunDisplaySize);
		printf("%sTime(sec)\tNum of Calls\n", strFuncNameTitle);
		for ( int ii = 0; ii < nCount; ii++ )
		{
			string str;
			str.Format("<%d> %s", ii+1, m_vsFuncNames[ii]);
			append_blanks_to_size(str, nMaxFunDisplaySize);
			
			printf("%s%f \t%d\n", str, m_vdTimes[ii], m_vnNumCalls[ii]);
		}
	}
   
private:
   int				m_nDisplayNum;
   vector<string>	m_vsFuncNames;
   vector<uint>		m_vnNumCalls;
   vector<double>	m_vdTimes;
};


//--- CPY 12/29/08 CHK_ELAPSED_TIME_FOR_OC_DIALOG_TO_OPEN_TOO_SLOWLY
// please also check NLFitSession.h for NLF_DEBUG to turn on various Profiler dump
#ifdef _SHOW_OC_DLG_OPEN_TIME
	#define _CHK_ELAPSED_TIME_START			LT_execute("type [----- Time counting Start ------];sec -ab;");
	///------ Folger 12/31/08 QA80-12878 v8.0992b IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM
	//#define _CHK_ELAPSED_TIME(_STR)			LT_execute("type [----- " _STR " ------];sec -at v1;type current elapsed time $(v1) sec;type [--------------------------------]");
	#define _CHK_ELAPSED_TIME(_STR) \
		{\
			string __strLT;\
			__strLT.Format("type [----- \" %s \" ------];sec -at v1;type current elapsed time $(v1) sec;type [--------------------------------]", (_STR));\
			LT_execute(__strLT);\
		}
	///------ End IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM
#else
	#define _CHK_ELAPSED_TIME_START
	#define _CHK_ELAPSED_TIME(_STR)
#endif
//--- end CHK_ELAPSED_TIME_FOR_OC_DIALOG_TO_OPEN_TOO_SLOWLY

#endif //_PROFILER_H
