/*------------------------------------------------------------------------------*
 * File Name: OArrayBase	 													*
 * Creation:AW 08/28/03															*
 * Purpose: Base class for OC array												*
 * Copyright (c) Originlab Corporation, 2002, 2003								*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/


#include <origin.h>

#define NICE_REMOVE(__pObj) if ( __pObj ) { \
	delete(__pObj);	\
	__pObj = NULL; }

#define NICE_FREE_DATA(__pData) if( __pData ) { \
	free(__pData); \
	__pData = NULL; }
	

#define ERROR_RETURN ASSERT(FALSE);  \
	return -1;

#define MUST_OVERLOAD_THIS_METHOD  out_str("MUST overload this virtual method"); \
	ASSERT(FALSE);

#define IS_KIND_OF(__obj, __CClass)   //now, it is empty

/**#
*/
class OObject
{
public:
	/**#
	*/
  	OObject() {}
 
  	/**#
	*/
  	~OObject() {}
};

/**#
	OPtrArray class supports arrays of void pointers

*/
class OPtrArray : public OObject
{
public:

	/**#
	*/
  	OPtrArray() 
  	{
  		SetSize(0);
  	}
  	
  	/**#
	*/
  	~OPtrArray() 
  	{	
  		RemoveAll();
  	}
public:
	/**#
	*/
  	int 	GetSize() const;
  	
  	/**#
	*/
  	int 	GetUpperBound() const;

  	/**#
	*/
  	void 	SetSize(int nNewSize, int nGrowBy = -1);

  	/**#
	*/
  	int 	Add(ODWP dwObj);

  	/**#
	*/
  	ODWP 	GetAt(int nIndex) const;

  	/**#
	*/
  	void 	SetAt(int nIndex, ODWP dwObj);

  	/**#
	*/
  	void 	RemoveAt( int nIndex, int nCount = 1 ); 

  	/**#
	*/
  	void 	RemoveAll();

private:

  	/**#
	*/
	vector<ODWP> m_vdPtrs;
};

/**#
*/
int OPtrArray::GetSize() //const
{
	return m_vdPtrs.GetSize();
}

/**#
*/
int OPtrArray::GetUpperBound()	//const
{
	return m_vdPtrs.GetUpperBound();
}

/**#
*/
void OPtrArray::SetSize(int nNewSize, int nGrowBy)
{
	m_vdPtrs.SetSize(nNewSize, nGrowBy); 
}

/**#
*/
int OPtrArray::Add(ODWP dwObj)
{
	if ( dwObj )
	{
		return m_vdPtrs.Add(dwObj);
	}
	ASSERT(FALSE);
	ERROR_RETURN; 
}

/**#
*/
ODWP OPtrArray::GetAt(int nIndex) //const
{
	return m_vdPtrs[nIndex];
}

/**#
*/
void OPtrArray::SetAt(int nIndex, ODWP dwObj)
{
	if ( dwObj )
	{
		m_vdPtrs[nIndex] = dwObj;
	}
	else
	{
		ASSERT(FALSE);
	}
}

/**#
*/
void OPtrArray::RemoveAt( int nIndex, int nCount )
{
	m_vdPtrs.RemoveAt( nIndex, nCount );		
}

/**#
*/
void OPtrArray::RemoveAll() 
{
	 m_vdPtrs.RemoveAll(); //available in next new build
	//m_vdPtrs.SetSize(0);
} 



