/*------------------------------------------------------------------------------*
 * File Name:Nag_utils.h 														*
 * Creation: Arvin 07/26/06														*
 * Purpose: Origin's internal calling nag functions								*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Arvin 07/26/06 ADD_XYZ_GRIDDING_NAG											*
 * Justin 2007-04-04 MODIFY FUCNTION CATEGORY									*
 *------------------------------------------------------------------------------*/
 
#ifndef _NAG_UTILS_H
#define _NAG_UTILS_H
//#include <OC_nag8.h> CPY 7/26/06 removed

enum{
	RANDOM_RENKA_CLINE_METHOD,
	RANDOM_SHEPARD_METHOD,
};
/// Zachary 07/25/06 ADD_GET_INTERPOLATED_XZ_YZ_CURVES_FROM_3D_DATA_FUNCTION
//Category last updated by Iris on 2009-07-07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Get_interpolated_xz_yz_curves_from_3D_data_%28global_function%29
*/
/// Fisher 2008-10-7 QA80-12334 IMPROVE_SPEED_FOR_SURFACE_FITTING
//bool get_interpolated_xz_yz_curves_from_3D_data( Curve& x_curve , Curve& y_curve, const vector& x_data, const vector& y_data, const vector& z_data);
bool get_interpolated_xz_yz_curves_from_3D_data( Curve& x_curve , Curve& y_curve, const vector& x_data, const vector& y_data, const vector& z_data, int bAutoReduceSize=false);
/// End 

///Arvin 07/26/06 ADD_XYZ_GRIDDING_NAG
//Category last updated by Justin on 2007-04-04
/** >Analysis>Interpolation
	Remarks:
	 	To do xyz gridding in renka cline method or shepard method by calling nag functions.
	 Exmaple1:
	 	
	 Parameters:
		vx = [input] X coordinate's datas
		vy = [input] Y coordinate's datas
		vz = [input] Z coordinate's datas
		vxGrid = [input] X gridded datas
		xyGrid = [input] Y gridded datas
		mat = [output] gridding result datas
		nMethod = [input] gridding method, 
						  RANDOM_RENKA_CLINE_METHOD, ranka cline method
						  RANDOM_SHEPARD_METHOD, shepard method
		nq = [input] be used to compute the radii Rq, for RANDOM_SHEPARD_METHOD only
		nw = [input] be used to compute the radii Rw, for RANDOM_SHEPARD_METHOD only
		constraint: 0 < nw < nq 
	Return:
		Returns OE_NOERROR on success and error code on failure.
	Reference:
		nag_2d_scat_interpolant(e01sac), nag_2d_scat_eval(e01sbc), nag manual 		   
*/
int xyz_gridding_nag(const vector& vx, const vector& vy, const vector& vz, const vector& vxGrid, const vector& vyGrid, matrix& mat, const int& nMethod = 0, const int& nq = 0, const int& nw = 0);
///end ADD_XYZ_GRIDDING_NAG
