#ifndef NAG_NAMES
#define  NAG_NAMES                                            

/* <nag_names.h>
 *
 * Copyright 1990 Numerical Algorithms Group
 *
 * Maps longer meaningful names to NAG names.
 *
 * Mark 1, 1990.
 * Mark 1a revised. IER-863 (Oct 1990).
 * Mark 2 revised.
 * Mark 2a revised. IER-968 (Jun 1992).
 * Mark 4 revised. IER-1756 (Aug 1995).
 * Mark 5 revised. IER-2136 (Feb 1998).
 * Mark 6 revised. 
 * Mark 7 revised. 
 * Mark 8 revised. 
 * Mark 9 revised.
 */

#define  nag_implementation_details                     a00aac /*  Mark  1  */ 
#define  nag_licence_query                              a00acc /*  Mark  8  */
#define  nag_implementation_separated_details           a00adc /*  Mark  9  */
#define  nag_complex                                    a02bac /*  Mark  2  */ 
#define  nag_complex_real                               a02bbc /*  Mark  2  */ 
#define  nag_complex_imag                               a02bcc /*  Mark  2  */ 
#define  nag_complex_add                                a02cac /*  Mark  2  */ 
#define  nag_complex_subtract                           a02cbc /*  Mark  2  */ 
#define  nag_complex_multiply                           a02ccc /*  Mark  2  */ 
#define  nag_complex_divide                             a02cdc /*  Mark  2  */ 
#define  nag_complex_negate                             a02cec /*  Mark  2  */ 
#define  nag_complex_conjg                              a02cfc /*  Mark  2  */ 
#define  nag_complex_equal                              a02cgc /*  Mark  2  */ 
#define  nag_complex_not_equal                          a02chc /*  Mark  2  */ 
#define  nag_complex_arg                                a02dac /*  Mark  2  */ 
#define  nag_complex_abs                                a02dbc /*  Mark  2  */ 
#define  nag_complex_sqrt                               a02dcc /*  Mark  2  */ 
#define  nag_complex_i_power                            a02ddc /*  Mark  2  */ 
#define  nag_complex_r_power                            a02dec /*  Mark  2  */ 
#define  nag_complex_c_power                            a02dfc /*  Mark  2  */ 
#define  nag_complex_log                                a02dgc /*  Mark  2  */ 
#define  nag_complex_exp                                a02dhc /*  Mark  2  */ 
#define  nag_complex_sin                                a02djc /*  Mark  2  */ 
#define  nag_complex_cos                                a02dkc /*  Mark  2  */ 
#define  nag_complex_tan                                a02dlc /*  Mark  2  */ 
#define  nag_zeros_complex_poly                         c02afc /*  Mark  2  */ 
#define  nag_zeros_real_poly                            c02agc /*  Mark  2  */ 
#define  nag_cubic_roots                                c02akc /*  Mark  6  */ 
#define  nag_quartic_roots                              c02alc /*  Mark  6  */ 
#define  nag_zero_cont_func_bd                          c05adc /*  Mark  2  */ 
#define  nag_zero_cont_func_brent_bsrch                 c05agc /*  Mark  9  */
#define  nag_interval_zero_cont_func                    c05avc /*  Mark  9  */
#define  nag_zero_cont_func_cntin_rcomm                 c05axc /*  Mark  9  */
#define  nag_zero_cont_func_brent_rcomm                 c05azc /*  Mark  9  */
#define  nag_lambertW                                   c05bac /*  Mark  9  */ 
#define  nag_zero_nonlin_eqns                           c05nbc /*  Mark  2  */ 
#define  nag_zero_nonlin_eqns_deriv                     c05pbc /*  Mark  2  */ 
#define  nag_zero_cont_func_bd_1                        c05sdc /*  Mark  5  */ 
#define  nag_zero_nonlin_eqns_1                         c05tbc /*  Mark  5  */ 
#define  nag_zero_nonlin_eqns_deriv_1                   c05ubc /*  Mark  5  */ 
#define  nag_check_deriv                                c05zbc /*  Mark  2  */ 
#define  nag_check_deriv_1                              c05zcc /*  Mark  5  */ 
#define  nag_fft_real                                   c06eac /*  Mark  1  */ 
#define  nag_fft_hermitian                              c06ebc /*  Mark  1  */ 
#define  nag_fft_complex                                c06ecc /*  Mark  1  */ 
#define  nag_convolution_real                           c06ekc /*  Mark  1  */ 
#define  nag_fft_multiple_real                          c06fpc /*  Mark  1  */ 
#define  nag_fft_multiple_hermitian                     c06fqc /*  Mark  1  */ 
#define  nag_fft_multiple_complex                       c06frc /*  Mark  1  */ 
#define  nag_fft_2d_complex                             c06fuc /*  Mark  1  */ 
#define  nag_conjugate_hermitian                        c06gbc /*  Mark  1  */ 
#define  nag_conjugate_complex                          c06gcc /*  Mark  1  */ 
#define  nag_multiple_conjugate_hermitian               c06gqc /*  Mark  1  */ 
#define  nag_multiple_hermitian_to_complex              c06gsc /*  Mark  1  */ 
#define  nag_fft_init_trig                              c06gzc /*  Mark  1  */ 
#define  nag_fft_multiple_sine                          c06hac /*  Mark  2  */ 
#define  nag_fft_multiple_cosine                        c06hbc /*  Mark  2  */ 
#define  nag_fft_multiple_qtr_sine                      c06hcc /*  Mark  2  */ 
#define  nag_fft_multiple_qtr_cosine                    c06hdc /*  Mark  2  */ 
#define  nag_fft_multid_single                          c06pfc /*  Mark  7  */ 
#define  nag_fft_multid_full                            c06pjc /*  Mark  7  */ 
#define  nag_fft_3d                                     c06pxc /*  Mark  7  */

//#define  nag_wfilt                                      c09aac /*  Mark  9  */
//#define  nag_dwt                                        c09cac /*  Mark  9  */
//#define  nag_idwt                                       c09cbc /*  Mark  9  */
//#define  nag_mldwt                                      c09ccc /*  Mark  9  */
//#define  nag_imldwt                                     c09cdc /*  Mark  9  */

#define  nag_1d_quad_gen                                d01ajc /*  Mark  2  */ 
#define  nag_1d_quad_osc                                d01akc /*  Mark  2  */ 
#define  nag_1d_quad_brkpts                             d01alc /*  Mark  2  */ 
#define  nag_1d_quad_inf                                d01amc /*  Mark  2  */ 
#define  nag_1d_quad_wt_trig                            d01anc /*  Mark  2  */ 
#define  nag_1d_quad_wt_alglog                          d01apc /*  Mark  2  */ 
#define  nag_1d_quad_wt_cauchy                          d01aqc /*  Mark  2  */ 
#define  nag_1d_quad_inf_wt_trig                        d01asc /*  Mark  2  */ 
#define  nag_1d_quad_gauss                              d01bac /*  Mark  2  */ 
#define  nag_multid_quad_adapt                          d01fcc /*  Mark  2  */ 
#define  nag_1d_quad_vals                               d01gac /*  Mark  2  */ 
#define  nag_multid_quad_monte_carlo                    d01gbc /*  Mark  2  */ 
#define  nag_1d_quad_gen_1                              d01sjc /*  Mark  5  */ 
#define  nag_1d_quad_osc_1                              d01skc /*  Mark  5  */ 
#define  nag_1d_quad_brkpts_1                           d01slc /*  Mark  5  */ 
#define  nag_1d_quad_inf_1                              d01smc /*  Mark  5  */ 
#define  nag_1d_quad_wt_trig_1                          d01snc /*  Mark  5  */ 
#define  nag_1d_quad_wt_alglog_1                        d01spc /*  Mark  5  */ 
#define  nag_1d_quad_wt_cauchy_1                        d01sqc /*  Mark  5  */ 
#define  nag_1d_quad_inf_wt_trig_1                      d01ssc /*  Mark  5  */ 
#define  nag_1d_quad_gauss_1                            d01tac /*  Mark  5  */ 
#define  nag_multid_quad_adapt_1                        d01wcc /*  Mark  5  */ 
#define  nag_multid_quad_monte_carlo_1                  d01xbc /*  Mark  5  */ 
#define  nag_ode_ivp_adams_gen                          d02cjc /*  Mark  2  */ 
#define  nag_ode_ivp_bdf_gen                            d02ejc /*  Mark  3  */ 
#define  nag_ode_bvp_fd_nonlin_fixedbc                  d02gac /*  Mark  3  */ 
#define  nag_ode_bvp_fd_lin_gen                         d02gbc /*  Mark  3  */
#define  nag_dae_ivp_dassl_cont                         d02mcc /*  Mark  9  */
#define  nag_dae_ivp_dassl_setup                        d02mwc /*  Mark  9  */
#define  nag_dae_ivp_dassl_gen                          d02nec /*  Mark  9  */ 
#define  nag_dae_ivp_dassl_linalg                       d02npc /*  Mark  9  */ 
#define  nag_ode_ivp_rk_range                           d02pcc /*  Mark  3  */ 
#define  nag_ode_ivp_rk_onestep                         d02pdc /*  Mark  3  */ 
#define  nag_ode_ivp_rk_free                            d02ppc /*  Mark  3  */ 
#define  nag_ode_ivp_rk_setup                           d02pvc /*  Mark  3  */ 
#define  nag_ode_ivp_rk_reset_tend                      d02pwc /*  Mark  3  */ 
#define  nag_ode_ivp_rk_interp                          d02pxc /*  Mark  3  */ 
#define  nag_ode_ivp_rk_errass                          d02pzc /*  Mark  3  */ 
#define  nag_ode_ivp_adams_roots                        d02qfc /*  Mark  2  */ 
#define  nag_ode_ivp_adams_setup                        d02qwc /*  Mark  2  */ 
#define  nag_ode_ivp_adams_free                         d02qyc /*  Mark  2  */ 
#define  nag_ode_ivp_adams_interp                       d02qzc /*  Mark  2  */ 
#define  nag_ode_bvp_fd_nonlin_gen                      d02rac /*  Mark  3  */ 
#define  nag_pde_bs_1d                                  d03ncc /*  Mark  7  */ 
#define  nag_pde_bs_1d_analytic                         d03ndc /*  Mark  7  */ 
#define  nag_pde_bs_1d_means                            d03nec /*  Mark  7  */ 
#define  nag_pde_parab_1d_fd                            d03pcc /*  Mark  7  */ 
#define  nag_pde_parab_1d_coll                          d03pdc /*  Mark  7  */ 
#define  nag_pde_parab_1d_keller                        d03pec /*  Mark  7  */ 
#define  nag_pde_parab_1d_cd                            d03pfc /*  Mark  7  */ 
#define  nag_pde_parab_1d_fd_ode                        d03phc /*  Mark  7  */ 
#define  nag_pde_parab_1d_coll_ode                      d03pjc /*  Mark  7  */ 
#define  nag_pde_parab_1d_keller_ode                    d03pkc /*  Mark  7  */ 
#define  nag_pde_parab_1d_cd_ode                        d03plc /*  Mark  7  */ 
#define  nag_pde_parab_1d_fd_ode_remesh                 d03ppc /*  Mark  7  */ 
#define  nag_pde_parab_1d_keller_ode_remesh             d03prc /*  Mark  7  */ 
#define  nag_pde_parab_1d_cd_ode_remesh                 d03psc /*  Mark  7  */ 
#define  nag_pde_parab_1d_euler_roe                     d03puc /*  Mark  7  */ 
#define  nag_pde_parab_1d_euler_osher                   d03pvc /*  Mark  7  */ 
#define  nag_pde_parab_1d_euler_hll                     d03pwc /*  Mark  7  */ 
#define  nag_pde_parab_1d_euler_exact                   d03pxc /*  Mark  7  */ 
#define  nag_pde_interp_1d_coll                         d03pyc /*  Mark  7  */ 
#define  nag_pde_interp_1d_fd                           d03pzc /*  Mark  7  */ 
#define  nag_mesh2d_inc                                 d06aac /*  Mark  7  */ 
#define  nag_mesh2d_delaunay                            d06abc /*  Mark  7  */ 
#define  nag_mesh2d_front                               d06acc /*  Mark  7  */ 
#define  nag_mesh2d_bound                               d06bac /*  Mark  7  */ 
#define  nag_mesh2d_smooth                              d06cac /*  Mark  7  */ 
#define  nag_mesh2d_sparse                              d06cbc /*  Mark  7  */ 
#define  nag_mesh2d_renum                               d06ccc /*  Mark  7  */ 
#define  nag_mesh2d_trans                               d06dac /*  Mark  7  */ 
#define  nag_mesh2d_join                                d06dbc /*  Mark  7  */ 
#define  nag_1d_cheb_interp                             e01aec /*  Mark  7  */ 
#define  nag_1d_spline_interpolant                      e01bac /*  Mark  2  */ 
#define  nag_monotonic_interpolant                      e01bec /*  Mark  1  */ 
#define  nag_monotonic_evaluate                         e01bfc /*  Mark  1  */ 
#define  nag_monotonic_deriv                            e01bgc /*  Mark  2  */ 
#define  nag_monotonic_intg                             e01bhc /*  Mark  2  */ 
#define  nag_2d_spline_interpolant                      e01dac /*  Mark  2  */ 
#define  nag_1d_ratnl_interp                            e01rac /*  Mark  7  */ 
#define  nag_1d_ratnl_eval                              e01rbc /*  Mark  7  */ 
#define  nag_2d_scat_interpolant                        e01sac /*  Mark  3  */ 
#define  nag_2d_scat_eval                               e01sbc /*  Mark  3  */ 
#define  nag_2d_shep_interp                             e01sgc /*  Mark  8  */ 
#define  nag_2d_shep_eval                               e01shc /*  Mark  8  */ 
#define  nag_2d_triang_interp                           e01sjc /*  Mark  8  */ 
#define  nag_2d_triang_eval                             e01skc /*  Mark  8  */ 
#define  nag_2d_scat_free                               e01szc /*  Mark  3  */ 
#define  nag_3d_shep_interp                             e01tgc /*  Mark  7  */ 
#define  nag_3d_shep_eval                               e01thc /*  Mark  7  */ 
#define  nag_1d_cheb_fit                                e02adc /*  Mark  5  */ 
#define  nag_1d_cheb_eval                               e02aec /*  Mark  5  */ 
#define  nag_1d_cheb_interp_fit                         e02afc /*  Mark  5  */ 
#define  nag_1d_cheb_fit_constr                         e02agc /*  Mark  7  */ 
#define  nag_1d_cheb_deriv                              e02ahc /*  Mark  7  */ 
#define  nag_1d_cheb_intg                               e02ajc /*  Mark  7  */ 
#define  nag_1d_cheb_eval2                              e02akc /*  Mark  7  */ 
#define  nag_1d_spline_fit_knots                        e02bac /*  Mark  2  */ 
#define  nag_1d_spline_evaluate                         e02bbc /*  Mark  2  */ 
#define  nag_1d_spline_deriv                            e02bcc /*  Mark  2  */ 
#define  nag_1d_spline_intg                             e02bdc /*  Mark  2  */ 
#define  nag_1d_spline_fit                              e02bec /*  Mark  2  */ 
#define  nag_2d_spline_fit_panel                        e02dac /*  Mark  8  */ 
#define  nag_2d_cheb_fit_lines                          e02cac /*  Mark  7  */ 
#define  nag_2d_cheb_eval                               e02cbc /*  Mark  7  */ 
#define  nag_2d_spline_fit_grid                         e02dcc /*  Mark  2  */ 
#define  nag_2d_spline_fit_scat                         e02ddc /*  Mark  2  */ 
#define  nag_2d_spline_eval                             e02dec /*  Mark  2  */ 
#define  nag_2d_spline_eval_rect                        e02dfc /*  Mark  2  */ 
#define  nag_lone_fit                                   e02gac /*  Mark  7  */ 
#define  nag_linf_fit                                   e02gcc /*  Mark  7  */ 
#define  nag_1d_pade                                    e02rac /*  Mark  7  */ 
#define  nag_1d_pade_eval                               e02rbc /*  Mark  7  */ 
#define  nag_2d_panel_sort                              e02zac /*  Mark  8  */ 
#define  nag_opt_one_var_no_deriv                       e04abc /*  Mark  5  */ 
#define  nag_opt_one_var_deriv                          e04bbc /*  Mark  5  */ 
#define  nag_opt_simplex_easy                           e04cbc /*  Mark  9  */ 
#define  nag_opt_simplex                                e04ccc /*  Mark  4  */ 
#define  nag_opt_conj_grad                              e04dgc /*  Mark  2  */ 
#define  nag_opt_lsq_no_deriv                           e04fcc /*  Mark  2  */ 
#define  nag_opt_lsq_deriv                              e04gbc /*  Mark  2  */ 
#define  nag_opt_check_deriv                            e04hcc /*  Mark  2  */ 
#define  nag_opt_check_2nd_deriv                        e04hdc /*  Mark  5  */ 
#define  nag_opt_bounds_no_deriv                        e04jbc /*  Mark  2  */ 
#define  nag_opt_bounds_deriv                           e04kbc /*  Mark  2  */ 
#define  nag_opt_bounds_2nd_deriv                       e04lbc /*  Mark  5  */ 
#define  nag_opt_lp                                     e04mfc /*  Mark  2  */ 
#define  nag_opt_sparse_mps_free                        e04myc /*  Mark  5  */ 
#define  nag_opt_sparse_mps_read                        e04mzc /*  Mark  5  */ 
#define  nag_opt_lin_lsq                                e04ncc /*  Mark  5  */ 
#define  nag_opt_qp                                     e04nfc /*  Mark  2  */ 
#define  nag_opt_sparse_convex_qp                       e04nkc /*  Mark  5  */ 
#define  nag_opt_sparse_convex_qp_init                  e04npc /*  Mark  8  */ 
#define  nag_opt_sparse_convex_qp_solve                 e04nqc /*  Mark  8  */ 
#define  nag_opt_sparse_convex_qp_option_set_file       e04nrc /*  Mark  8  */ 
#define  nag_opt_sparse_convex_qp_option_set_string     e04nsc /*  Mark  8  */ 
#define  nag_opt_sparse_convex_qp_option_set_integer    e04ntc /*  Mark  8  */ 
#define  nag_opt_sparse_convex_qp_option_set_double     e04nuc /*  Mark  8  */ 
#define  nag_opt_sparse_convex_qp_option_get_integer    e04nxc /*  Mark  8  */ 
#define  nag_opt_sparse_convex_qp_option_get_double     e04nyc /*  Mark  8  */ 
#define  nag_opt_nlp                                    e04ucc /*  Mark  4  */ 
#define  nag_opt_nlp_sparse                             e04ugc /*  Mark  6  */ 
#define  nag_opt_nlin_lsq                               e04unc /*  Mark  5  */ 
#define  nag_opt_sparse_nlp_init                        e04vgc /*  Mark  8  */ 
#define  nag_opt_sparse_nlp_solve                       e04vhc /*  Mark  8  */ 
#define  nag_opt_sparse_nlp_jacobian                    e04vjc /*  Mark  8  */ 
#define  nag_opt_sparse_nlp_option_set_file             e04vkc /*  Mark  8  */ 
#define  nag_opt_sparse_nlp_option_set_string           e04vlc /*  Mark  8  */ 
#define  nag_opt_sparse_nlp_option_set_integer          e04vmc /*  Mark  8  */ 
#define  nag_opt_sparse_nlp_option_set_double           e04vnc /*  Mark  8  */ 
#define  nag_opt_sparse_nlp_option_get_integer          e04vrc /*  Mark  8  */ 
#define  nag_opt_sparse_nlp_option_get_double           e04vsc /*  Mark  8  */ 
#define  nag_opt_nlp_init                               e04wcc /*  Mark  8  */ 
#define  nag_opt_nlp_solve                              e04wdc /*  Mark  8  */ 
#define  nag_opt_nlp_option_set_file                    e04wec /*  Mark  8  */ 
#define  nag_opt_nlp_option_set_string                  e04wfc /*  Mark  8  */ 
#define  nag_opt_nlp_option_set_integer                 e04wgc /*  Mark  8  */ 
#define  nag_opt_nlp_option_set_double                  e04whc /*  Mark  8  */ 
#define  nag_opt_nlp_option_get_integer                 e04wkc /*  Mark  8  */ 
#define  nag_opt_nlp_option_get_double                  e04wlc /*  Mark  8  */ 
#define  nag_opt_estimate_deriv                         e04xac /*  Mark  5  */ 
#define  nag_opt_init                                   e04xxc /*  Mark  2  */ 
#define  nag_opt_read                                   e04xyc /*  Mark  2  */ 
#define  nag_opt_free                                   e04xzc /*  Mark  2  */ 
#define  nag_opt_lsq_check_deriv                        e04yac /*  Mark  2  */ 
#define  nag_opt_lsq_covariance                         e04ycc /*  Mark  2  */ 
#define  nag_glopt_bnd_mcs_init                         e05jac /*  Mark  9  */ 
#define  nag_glopt_bnd_mcs_solve                        e05jbc /*  Mark  9  */ 
#define  nag_glopt_bnd_mcs_optset_file                  e05jcc /*  Mark  9  */ 
#define  nag_glopt_bnd_mcs_optset_string                e05jdc /*  Mark  9  */ 
#define  nag_glopt_bnd_mcs_optset_char                  e05jec /*  Mark  9  */ 
#define  nag_glopt_bnd_mcs_optset_int                   e05jfc /*  Mark  9  */ 
#define  nag_glopt_bnd_mcs_optset_real                  e05jgc /*  Mark  9  */ 
#define  nag_glopt_bnd_mcs_option_check                 e05jhc /*  Mark  9  */ 
#define  nag_glopt_bnd_mcs_optget_int                   e05jkc /*  Mark  9  */ 
#define  nag_glopt_bnd_mcs_optget_real                  e05jlc /*  Mark  9  */ 
#define  nag_complex_cholesky                           f01bnc /*  Mark  1  */
#define  nag_real_gen_matrix_exp                        f01ecc /*  Mark  9  */
#define  nag_real_symm_matrix_exp                       f01edc /*  Mark  9  */
#define  nag_real_cholesky_skyline                      f01mcc /*  Mark  1  */ 
#define  nag_real_qr                                    f01qcc /*  Mark  1  */ 
#define  nag_real_apply_q                               f01qdc /*  Mark  1  */ 
#define  nag_real_form_q                                f01qec /*  Mark  1  */ 
#define  nag_complex_qr                                 f01rcc /*  Mark  1  */ 
#define  nag_complex_apply_q                            f01rdc /*  Mark  1  */ 
#define  nag_complex_form_q                             f01rec /*  Mark  1  */ 
#define  nag_real_symm_eigenvalues                      f02aac /*  Mark  1  */ 
#define  nag_real_symm_eigensystem                      f02abc /*  Mark  1  */ 
#define  nag_real_symm_general_eigenvalues              f02adc /*  Mark  1  */ 
#define  nag_real_symm_general_eigensystem              f02aec /*  Mark  1  */ 
#define  nag_real_eigenvalues                           f02afc /*  Mark  1  */ 
#define  nag_real_eigensystem                           f02agc /*  Mark  1  */ 
#define  nag_hermitian_eigenvalues                      f02awc /*  Mark  2  */ 
#define  nag_hermitian_eigensystem                      f02axc /*  Mark  2  */ 
#define  nag_real_general_eigensystem                   f02bjc /*  Mark  2  */ 
#define  nag_real_eigensystem_sel                       f02ecc /*  Mark  5  */ 
#define  nag_complex_eigensystem_sel                    f02gcc /*  Mark  5  */ 
#define  nag_real_svd                                   f02wec /*  Mark  1  */ 
#define  nag_real_partial_svd                           f02wgc /*  Mark  9  */ 
#define  nag_complex_svd                                f02xec /*  Mark  1  */ 
#define  nag_real_cholesky                              f03aec /*  Mark  1  */ 
#define  nag_real_lu                                    f03afc /*  Mark  1  */ 
#define  nag_complex_lu                                 f03ahc /*  Mark  1  */ 
#define  nag_complex_lin_eqn_mult_rhs                   f04adc /*  Mark  1  */ 
#define  nag_real_cholesky_solve_mult_rhs               f04agc /*  Mark  1  */ 
#define  nag_real_lu_solve_mult_rhs                     f04ajc /*  Mark  1  */ 
#define  nag_complex_lu_solve_mult_rhs                  f04akc /*  Mark  1  */ 
#define  nag_real_lin_eqn                               f04arc /*  Mark  1  */ 
#define  nag_hermitian_lin_eqn_mult_rhs                 f04awc /*  Mark  1  */ 
#define  nag_real_cholesky_skyline_solve                f04mcc /*  Mark  1  */ 
#define  nag_real_gen_lin_solve                         f04bac /*  Mark  8  */ 
#define  nag_real_band_lin_solve                        f04bbc /*  Mark  8  */ 
#define  nag_real_tridiag_lin_solve                     f04bcc /*  Mark  8  */ 
#define  nag_real_sym_posdef_lin_solve                  f04bdc /*  Mark  8  */ 
#define  nag_real_sym_posdef_packed_lin_solve           f04bec /*  Mark  8  */ 
#define  nag_real_sym_posdef_band_lin_solve             f04bfc /*  Mark  8  */ 
#define  nag_real_sym_posdef_tridiag_lin_solve          f04bgc /*  Mark  8  */ 
#define  nag_real_sym_lin_solve                         f04bhc /*  Mark  8  */ 
#define  nag_real_sym_packed_lin_solve                  f04bjc /*  Mark  8  */ 
#define  nag_complex_gen_lin_solve                      f04cac /*  Mark  8  */ 
#define  nag_complex_band_lin_solve                     f04cbc /*  Mark  8  */ 
#define  nag_complex_tridiag_lin_solve                  f04ccc /*  Mark  8  */ 
#define  nag_herm_posdef_lin_solve                      f04cdc /*  Mark  8  */ 
#define  nag_herm_posdef_packed_lin_solve               f04cec /*  Mark  8  */ 
#define  nag_herm_posdef_band_lin_solve                 f04cfc /*  Mark  8  */ 
#define  nag_herm_posdef_tridiag_lin_solve              f04cgc /*  Mark  8  */ 
#define  nag_herm_lin_solve                             f04chc /*  Mark  8  */ 
#define  nag_herm_packed_lin_solve                      f04cjc /*  Mark  8  */ 
#define  nag_complex_sym_lin_solve                      f04dhc /*  Mark  8  */ 
#define  nag_complex_sym_packed_lin_solve               f04djc /*  Mark  8  */ 
#define  nag_drscl                                      f06fec /*  Mark  8  */ 
#define  nag_zrscl                                      f06kec /*  Mark  8  */ 
/*
 * Mark 7 revised: the BLAS names are reserved (use of Fortran vendor's
 * BLAS, on some machines, the Fortran binding are lower case without the
 * underscore). They should be called with an other name...
 * This is not backward compatible and will need a documentation effort...
 */
#define  old_dgemv                                      f06pac /*  Mark  3  */ 
#define  old_dgbmv                                      f06pbc /*  Mark  3  */ 
#define  old_dsymv                                      f06pcc /*  Mark  3  */ 
#define  old_dsbmv                                      f06pdc /*  Mark  3  */ 
#define  old_dspmv                                      f06pec /*  Mark  3  */ 
#define  old_dtrmv                                      f06pfc /*  Mark  3  */ 
#define  old_dtbmv                                      f06pgc /*  Mark  3  */ 
#define  old_dtpmv                                      f06phc /*  Mark  3  */ 
#define  old_dtrsv                                      f06pjc /*  Mark  3  */ 
#define  old_dtbsv                                      f06pkc /*  Mark  3  */ 
#define  old_dtpsv                                      f06plc /*  Mark  3  */ 
#define  old_dger                                       f06pmc /*  Mark  3  */ 
#define  old_dsyr                                       f06ppc /*  Mark  3  */ 
#define  old_dspr                                       f06pqc /*  Mark  3  */ 
#define  old_dsyr2                                      f06prc /*  Mark  3  */ 
#define  old_dspr2                                      f06psc /*  Mark  3  */ 
#define  old_zgemv                                      f06sac /*  Mark  3  */ 
#define  old_zgbmv                                      f06sbc /*  Mark  3  */ 
#define  old_zhemv                                      f06scc /*  Mark  3  */ 
#define  old_zhbmv                                      f06sdc /*  Mark  3  */ 
#define  old_zhpmv                                      f06sec /*  Mark  3  */ 
#define  old_ztrmv                                      f06sfc /*  Mark  3  */ 
#define  old_ztbmv                                      f06sgc /*  Mark  3  */ 
#define  old_ztpmv                                      f06shc /*  Mark  3  */ 
#define  old_ztrsv                                      f06sjc /*  Mark  3  */ 
#define  old_ztbsv                                      f06skc /*  Mark  3  */ 
#define  old_ztpsv                                      f06slc /*  Mark  3  */ 
#define  old_zgeru                                      f06smc /*  Mark  3  */ 
#define  old_zgerc                                      f06snc /*  Mark  3  */ 
#define  old_zher                                       f06spc /*  Mark  3  */ 
#define  old_zhpr                                       f06sqc /*  Mark  3  */ 
#define  old_zher2                                      f06src /*  Mark  3  */ 
#define  old_zhpr2                                      f06ssc /*  Mark  3  */ 
#define  old_dgemm                                      f06yac /*  Mark  3  */ 
#define  old_dsymm                                      f06ycc /*  Mark  3  */ 
#define  old_dtrmm                                      f06yfc /*  Mark  3  */ 
#define  old_dtrsm                                      f06yjc /*  Mark  3  */ 
#define  old_dsyrk                                      f06ypc /*  Mark  3  */ 
#define  old_dsyr2k                                     f06yrc /*  Mark  3  */ 
#define  old_zgemm                                      f06zac /*  Mark  3  */ 
#define  old_zhemm                                      f06zcc /*  Mark  3  */ 
#define  old_ztrmm                                      f06zfc /*  Mark  3  */ 
#define  old_ztrsm                                      f06zjc /*  Mark  3  */ 
#define  old_zherk                                      f06zpc /*  Mark  3  */ 
#define  old_zher2k                                     f06zrc /*  Mark  3  */ 
#define  old_zsymm                                      f06ztc /*  Mark  3  */ 
#define  old_zsyrk                                      f06zuc /*  Mark  3  */ 
#define  old_zsyr2k                                     f06zwc /*  Mark  3  */ 

#define  nag_zrot                                       f06hmc /*  Mark  9  */
#define  nag_zdrscl                                     f06kec /*  Mark  9  */
#define  nag_zdrot                                      f06kpc /*  Mark  9  */
#define  nag_dlangt                                     f06rnc /*  Mark  9  */
#define  nag_dlanst                                     f06rpc /*  Mark  9  */
#define  nag_zsyr                                       f06tbc /*  Mark  9  */
#define  nag_zspr                                       f06tdc /*  Mark  9  */
#define  nag_zlangt                                     f06unc /*  Mark  9  */
#define  nag_zlanht                                     f06upc /*  Mark  9  */
#define  nag_dgesv                                      f07aac /*  Mark  9  */
#define  nag_dgesvx                                     f07abc /*  Mark  9  */
#define  nag_dsgesv                                     f07acc /*  Mark  9  */
#define  nag_dgetrf                                     f07adc /*  Mark  7  */
#define  nag_dgetrs                                     f07aec /*  Mark  7  */
#define  nag_dgeequ                                     f07afc /*  Mark  9  */
#define  nag_dgecon                                     f07agc /*  Mark  7  */
#define  nag_dgerfs                                     f07ahc /*  Mark  7  */
#define  nag_dgetri                                     f07ajc /*  Mark  7  */
#define  nag_zgesv                                      f07anc /*  Mark  9  */
#define  nag_zgesvx                                     f07apc /*  Mark  9  */
#define  nag_zcgesv                                     f07aqc /*  Mark  9  */
#define  nag_zgetrf                                     f07arc /*  Mark  7  */
#define  nag_zgetrs                                     f07asc /*  Mark  7  */
#define  nag_zgeequ                                     f07atc /*  Mark  9  */
#define  nag_zgecon                                     f07auc /*  Mark  7  */
#define  nag_zgerfs                                     f07avc /*  Mark  7  */
#define  nag_zgetri                                     f07awc /*  Mark  7  */
#define  nag_dgbsv                                      f07bac /*  Mark  9  */
#define  nag_dgbsvx                                     f07bbc /*  Mark  9  */
#define  nag_dgbtrf                                     f07bdc /*  Mark  7  */
#define  nag_dgbtrs                                     f07bec /*  Mark  7  */
#define  nag_dgbcon                                     f07bgc /*  Mark  7  */
#define  nag_dgbrfs                                     f07bhc /*  Mark  7  */
#define  nag_zgbtrf                                     f07brc /*  Mark  7  */
#define  nag_zgbtrs                                     f07bsc /*  Mark  7  */
#define  nag_zgbcon                                     f07buc /*  Mark  7  */
#define  nag_zgbrfs                                     f07bvc /*  Mark  7  */
#define  nag_dpotrf                                     f07fdc /*  Mark  7  */
#define  nag_dpotrs                                     f07fec /*  Mark  7  */
#define  nag_dpocon                                     f07fgc /*  Mark  7  */
#define  nag_dporfs                                     f07fhc /*  Mark  7  */
#define  nag_dpotri                                     f07fjc /*  Mark  7  */
#define  nag_zpotrf                                     f07frc /*  Mark  7  */
#define  nag_zpotrs                                     f07fsc /*  Mark  7  */
#define  nag_zpocon                                     f07fuc /*  Mark  7  */
#define  nag_zporfs                                     f07fvc /*  Mark  7  */
#define  nag_zpotri                                     f07fwc /*  Mark  7  */
#define  nag_dpptrf                                     f07gdc /*  Mark  7  */
#define  nag_dpptrs                                     f07gec /*  Mark  7  */
#define  nag_dppcon                                     f07ggc /*  Mark  7  */
#define  nag_dpprfs                                     f07ghc /*  Mark  7  */
#define  nag_dpptri                                     f07gjc /*  Mark  7  */
#define  nag_zpptrf                                     f07grc /*  Mark  7  */
#define  nag_zpptrs                                     f07gsc /*  Mark  7  */
#define  nag_zppcon                                     f07guc /*  Mark  7  */
#define  nag_zpprfs                                     f07gvc /*  Mark  7  */
#define  nag_zpptri                                     f07gwc /*  Mark  7  */
#define  nag_dpbtrf                                     f07hdc /*  Mark  7  */
#define  nag_dpbtrs                                     f07hec /*  Mark  7  */
#define  nag_dpbcon                                     f07hgc /*  Mark  7  */
#define  nag_dpbrfs                                     f07hhc /*  Mark  7  */
#define  nag_zpbtrf                                     f07hrc /*  Mark  7  */
#define  nag_zpbtrs                                     f07hsc /*  Mark  7  */
#define  nag_zpbcon                                     f07huc /*  Mark  7  */
#define  nag_zpbrfs                                     f07hvc /*  Mark  7  */
#define  nag_dsytrf                                     f07mdc /*  Mark  7  */
#define  nag_dsytrs                                     f07mec /*  Mark  7  */
#define  nag_dsycon                                     f07mgc /*  Mark  7  */
#define  nag_dsyrfs                                     f07mhc /*  Mark  7  */
#define  nag_dsytri                                     f07mjc /*  Mark  7  */
#define  nag_zhetrf                                     f07mrc /*  Mark  7  */
#define  nag_zhetrs                                     f07msc /*  Mark  7  */
#define  nag_zhecon                                     f07muc /*  Mark  7  */
#define  nag_zherfs                                     f07mvc /*  Mark  7  */
#define  nag_zhetri                                     f07mwc /*  Mark  7  */
#define  nag_zsytrf                                     f07nrc /*  Mark  7  */
#define  nag_zsytrs                                     f07nsc /*  Mark  7  */
#define  nag_zsycon                                     f07nuc /*  Mark  7  */
#define  nag_zsyrfs                                     f07nvc /*  Mark  7  */
#define  nag_zsytri                                     f07nwc /*  Mark  7  */
#define  nag_dsptrf                                     f07pdc /*  Mark  7  */
#define  nag_dsptrs                                     f07pec /*  Mark  7  */
#define  nag_dspcon                                     f07pgc /*  Mark  7  */
#define  nag_dsprfs                                     f07phc /*  Mark  7  */
#define  nag_dsptri                                     f07pjc /*  Mark  7  */
#define  nag_zhptrf                                     f07prc /*  Mark  7  */
#define  nag_zhptrs                                     f07psc /*  Mark  7  */
#define  nag_zhpcon                                     f07puc /*  Mark  7  */
#define  nag_zhprfs                                     f07pvc /*  Mark  7  */
#define  nag_zhptri                                     f07pwc /*  Mark  7  */
#define  nag_zsptrf                                     f07qrc /*  Mark  7  */
#define  nag_zsptrs                                     f07qsc /*  Mark  7  */
#define  nag_zspcon                                     f07quc /*  Mark  7  */
#define  nag_zsprfs                                     f07qvc /*  Mark  7  */
#define  nag_zsptri                                     f07qwc /*  Mark  7  */
#define  nag_dtrtrs                                     f07tec /*  Mark  7  */
#define  nag_dtrcon                                     f07tgc /*  Mark  7  */
#define  nag_dtrrfs                                     f07thc /*  Mark  7  */
#define  nag_dtrtri                                     f07tjc /*  Mark  7  */
#define  nag_ztrtrs                                     f07tsc /*  Mark  7  */
#define  nag_ztrcon                                     f07tuc /*  Mark  7  */
#define  nag_ztrrfs                                     f07tvc /*  Mark  7  */
#define  nag_ztrtri                                     f07twc /*  Mark  7  */
#define  nag_dtptrs                                     f07uec /*  Mark  7  */
#define  nag_dtpcon                                     f07ugc /*  Mark  7  */
#define  nag_dtprfs                                     f07uhc /*  Mark  7  */
#define  nag_dtptri                                     f07ujc /*  Mark  7  */
#define  nag_ztptrs                                     f07usc /*  Mark  7  */
#define  nag_ztpcon                                     f07uuc /*  Mark  7  */
#define  nag_ztprfs                                     f07uvc /*  Mark  7  */
#define  nag_ztptri                                     f07uwc /*  Mark  7  */
#define  nag_dtbtrs                                     f07vec /*  Mark  7  */
#define  nag_dtbcon                                     f07vgc /*  Mark  7  */
#define  nag_dtbrfs                                     f07vhc /*  Mark  7  */
#define  nag_ztbtrs                                     f07vsc /*  Mark  7  */
#define  nag_ztbcon                                     f07vuc /*  Mark  7  */
#define  nag_ztbrfs                                     f07vvc /*  Mark  7  */
#define  nag_dgels                                      f08aac /*  Mark  9  */
#define  nag_dgeqrf                                     f08aec /*  Mark  7  */
#define  nag_dorgqr                                     f08afc /*  Mark  7  */
#define  nag_dormqr                                     f08agc /*  Mark  7  */
#define  nag_dgelqf                                     f08ahc /*  Mark  7  */
#define  nag_dorglq                                     f08ajc /*  Mark  7  */
#define  nag_dormlq                                     f08akc /*  Mark  7  */
#define  nag_zgels                                      f08anc /*  Mark  9  */
#define  nag_zgeqrf                                     f08asc /*  Mark  7  */
#define  nag_zungqr                                     f08atc /*  Mark  7  */
#define  nag_zunmqr                                     f08auc /*  Mark  7  */
#define  nag_zgelqf                                     f08avc /*  Mark  7  */
#define  nag_zunglq                                     f08awc /*  Mark  7  */
#define  nag_zunmlq                                     f08axc /*  Mark  7  */
#define  nag_dgelsy                                     f08bac /*  Mark  9  */
#define  nag_dgeqpf                                     f08bec /*  Mark  7  */
#define  nag_dgeqp3                                     f08bfc /*  Mark  9  */
#define  nag_dtzrzf                                     f08bhc /*  Mark  9  */
#define  nag_dormrz                                     f08bkc /*  Mark  9  */
#define  nag_zgelsy                                     f08bnc /*  Mark  9  */
#define  nag_zgeqpf                                     f08bsc /*  Mark  7  */
#define  nag_zgeqp3                                     f08btc /*  Mark  9  */
#define  nag_ztzrzf                                     f08bvc /*  Mark  9  */
#define  nag_zunmrz                                     f08bxc /*  Mark  9  */
#define  nag_dgeqlf                                     f08cec /*  Mark  9  */
#define  nag_dorgql                                     f08cfc /*  Mark  9  */
#define  nag_dormql                                     f08cgc /*  Mark  9  */ 
#define  nag_dgerqf                                     f08chc /*  Mark  9  */
#define  nag_dorgrq                                     f08cjc /*  Mark  9  */
#define  nag_dormrq                                     f08ckc /*  Mark  9  */
#define  nag_zgeqlf                                     f08csc /*  Mark  9  */
#define  nag_zungql                                     f08ctc /*  Mark  9  */
#define  nag_zunmql                                     f08cuc /*  Mark  9  */
#define  nag_zgerqf                                     f08cvc /*  Mark  9  */
#define  nag_zungrq                                     f08cwc /*  Mark  9  */
#define  nag_zunmrq                                     f08cxc /*  Mark  9  */
#define  nag_dsyev                                      f08fac /*  Mark  9  */
#define  nag_dsyevx                                     f08fbc /*  Mark  9  */
#define  nag_dsyevd                                     f08fcc /*  Mark  7  */
#define  nag_dsyevr                                     f08fdc /*  Mark  9  */
#define  nag_dsytrd                                     f08fec /*  Mark  7  */
#define  nag_dorgtr                                     f08ffc /*  Mark  7  */
#define  nag_dormtr                                     f08fgc /*  Mark  7  */
#define  nag_ddisna                                     f08flc /*  Mark  9  */
#define  nag_zheev                                      f08fnc /*  Mark  9  */
#define  nag_zheevx                                     f08fpc /*  Mark  9  */
#define  nag_zheevd                                     f08fqc /*  Mark  7  */
#define  nag_zheevr                                     f08frc /*  Mark  9  */
#define  nag_zhetrd                                     f08fsc /*  Mark  7  */
#define  nag_zungtr                                     f08ftc /*  Mark  7  */
#define  nag_zunmtr                                     f08fuc /*  Mark  7  */
#define  nag_dspev                                      f08gac /*  Mark  9  */
#define  nag_dspevx                                     f08gbc /*  Mark  9  */
#define  nag_dspevd                                     f08gcc /*  Mark  7  */
#define  nag_dsptrd                                     f08gec /*  Mark  7  */
#define  nag_dopgtr                                     f08gfc /*  Mark  7  */
#define  nag_dopmtr                                     f08ggc /*  Mark  7  */
#define  nag_zhpev                                      f08gnc /*  Mark  9  */
#define  nag_zhpevx                                     f08gpc /*  Mark  9  */
#define  nag_zhpevd                                     f08gqc /*  Mark  7  */
#define  nag_zhptrd                                     f08gsc /*  Mark  7  */
#define  nag_zupgtr                                     f08gtc /*  Mark  7  */
#define  nag_zupmtr                                     f08guc /*  Mark  7  */
#define  nag_dsbev                                      f08hac /*  Mark  9  */
#define  nag_dsbevx                                     f08hbc /*  Mark  9  */
#define  nag_dsbevd                                     f08hcc /*  Mark  7  */
#define  nag_dsbtrd                                     f08hec /*  Mark  7  */
#define  nag_zhbev                                      f08hnc /*  Mark  9  */
#define  nag_zhbevx                                     f08hpc /*  Mark  9  */
#define  nag_zhbevd                                     f08hqc /*  Mark  7  */
#define  nag_zhbtrd                                     f08hsc /*  Mark  7  */
#define  nag_dstev                                      f08jac /*  Mark  9  */
#define  nag_dstevx                                     f08jbc /*  Mark  9  */
#define  nag_dstevd                                     f08jcc /*  Mark  7  */
#define  nag_dstevr                                     f08jdc /*  Mark  9  */
#define  nag_dsteqr                                     f08jec /*  Mark  7  */
#define  nag_dsterf                                     f08jfc /*  Mark  7  */
#define  nag_dpteqr                                     f08jgc /*  Mark  7  */
#define  nag_dstedc                                     f08jhc /*  Mark  9  */
#define  nag_dstebz                                     f08jjc /*  Mark  7  */
#define  nag_dstein                                     f08jkc /*  Mark  7  */
#define  nag_dstegr                                     f08jlc /*  Mark  9  */
#define  nag_zsteqr                                     f08jsc /*  Mark  7  */
#define  nag_zpteqr                                     f08juc /*  Mark  7  */
#define  nag_zstedc                                     f08jvc /*  Mark  9  */
#define  nag_zstein                                     f08jxc /*  Mark  7  */
#define  nag_zstegr                                     f08jyc /*  Mark  9  */
#define  nag_dgelss                                     f08kac /*  Mark  9  */
#define  nag_dgesvd                                     f08kbc /*  Mark  9  */
#define  nag_dgelsd                                     f08kcc /*  Mark  9  */
#define  nag_dgesdd                                     f08kdc /*  Mark  9  */
#define  nag_dgebrd                                     f08kec /*  Mark  7  */
#define  nag_dorgbr                                     f08kfc /*  Mark  7  */
#define  nag_dormbr                                     f08kgc /*  Mark  7  */
#define  nag_zgelss                                     f08knc /*  Mark  9  */
#define  nag_zgesvd                                     f08kpc /*  Mark  9  */
#define  nag_zgelsd                                     f08kqc /*  Mark  9  */
#define  nag_zgesdd                                     f08krc /*  Mark  9  */
#define  nag_zgebrd                                     f08ksc /*  Mark  7  */
#define  nag_zungbr                                     f08ktc /*  Mark  7  */
#define  nag_zunmbr                                     f08kuc /*  Mark  7  */
#define  nag_dgbbrd                                     f08lec /*  Mark  7  */
#define  nag_zgbbrd                                     f08lsc /*  Mark  7  */
#define  nag_dbdsdc                                     f08mdc /*  Mark  9  */
#define  nag_dbdsqr                                     f08mec /*  Mark  7  */
#define  nag_zbdsqr                                     f08msc /*  Mark  7  */
#define  nag_dgeev                                      f08nac /*  Mark  9  */
#define  nag_dgeevx                                     f08nbc /*  Mark  9  */
#define  nag_dgehrd                                     f08nec /*  Mark  7  */
#define  nag_dorghr                                     f08nfc /*  Mark  7  */
#define  nag_dormhr                                     f08ngc /*  Mark  7  */
#define  nag_dgebal                                     f08nhc /*  Mark  7  */
#define  nag_dgebak                                     f08njc /*  Mark  7  */
#define  nag_zgeev                                      f08nnc /*  Mark  9  */
#define  nag_zgeevx                                     f08npc /*  Mark  9  */
#define  nag_zgehrd                                     f08nsc /*  Mark  7  */
#define  nag_zunghr                                     f08ntc /*  Mark  7  */
#define  nag_zunmhr                                     f08nuc /*  Mark  7  */
#define  nag_zgebal                                     f08nvc /*  Mark  7  */
#define  nag_zgebak                                     f08nwc /*  Mark  7  */
#define  nag_dgees                                      f08pac /*  Mark  9  */
#define  nag_dgeesx                                     f08pbc /*  Mark  9  */
#define  nag_dhseqr                                     f08pec /*  Mark  7  */
#define  nag_dhsein                                     f08pkc /*  Mark  7  */
#define  nag_zgees                                      f08pnc /*  Mark  9  */
#define  nag_zgeesx                                     f08ppc /*  Mark  9  */
#define  nag_zhseqr                                     f08psc /*  Mark  7  */
#define  nag_zhsein                                     f08pxc /*  Mark  7  */
#define  nag_dtrexc                                     f08qfc /*  Mark  7  */
#define  nag_dtrsen                                     f08qgc /*  Mark  7  */
#define  nag_dtrsyl                                     f08qhc /*  Mark  7  */
#define  nag_dtrevc                                     f08qkc /*  Mark  7  */
#define  nag_dtrsna                                     f08qlc /*  Mark  7  */
#define  nag_ztrexc                                     f08qtc /*  Mark  7  */
#define  nag_ztrsen                                     f08quc /*  Mark  7  */
#define  nag_ztrsyl                                     f08qvc /*  Mark  7  */
#define  nag_ztrevc                                     f08qxc /*  Mark  7  */
#define  nag_ztrsna                                     f08qyc /*  Mark  7  */
#define  nag_dsygv                                      f08sac /*  Mark  9  */
#define  nag_dsygvx                                     f08sbc /*  Mark  9  */
#define  nag_dsygvd                                     f08scc /*  Mark  9  */
#define  nag_dsygst                                     f08sec /*  Mark  7  */
#define  nag_zhegv                                      f08snc /*  Mark  9  */
#define  nag_zhegvx                                     f08spc /*  Mark  9  */
#define  nag_zhegvd                                     f08sqc /*  Mark  9  */
#define  nag_zhegst                                     f08ssc /*  Mark  7  */
#define  nag_dspgv                                      f08tac /*  Mark  9  */
#define  nag_dspgvx                                     f08tbc /*  Mark  9  */
#define  nag_dspgvd                                     f08tcc /*  Mark  9  */
#define  nag_dspgst                                     f08tec /*  Mark  7  */
#define  nag_zhpgv                                      f08tnc /*  Mark  9  */
#define  nag_zhpgvx                                     f08tpc /*  Mark  9  */
#define  nag_zhpgvd                                     f08tqc /*  Mark  9  */
#define  nag_zhpgst                                     f08tsc /*  Mark  7  */
#define  nag_dsbgv                                      f08uac /*  Mark  9  */
#define  nag_dsbgvx                                     f08ubc /*  Mark  9  */
#define  nag_dsbgvd                                     f08ucc /*  Mark  9  */
#define  nag_dsbgst                                     f08uec /*  Mark  7  */
#define  nag_dpbstf                                     f08ufc /*  Mark  7  */
#define  nag_zhbgv                                      f08unc /*  Mark  9  */
#define  nag_zhbgvx                                     f08upc /*  Mark  9  */
#define  nag_zhbgvd                                     f08uqc /*  Mark  9  */
#define  nag_zhbgst                                     f08usc /*  Mark  7  */
#define  nag_zpbstf                                     f08utc /*  Mark  7  */
#define  nag_dggsvd                                     f08vac /*  Mark  9  */
#define  nag_dggsvp                                     f08vec /*  Mark  9  */
#define  nag_zggsvd                                     f08vnc /*  Mark  9  */
#define  nag_zggsvp                                     f08vsc /*  Mark  9  */
#define  nag_dggev                                      f08wac /*  Mark  9  */
#define  nag_dggevx                                     f08wbc /*  Mark  9  */
#define  nag_dgghrd                                     f08wec /*  Mark  7  */
#define  nag_dggbal                                     f08whc /*  Mark  7  */
#define  nag_dggbak                                     f08wjc /*  Mark  7  */
#define  nag_zggev                                      f08wnc /*  Mark  9  */
#define  nag_zggevx                                     f08wpc /*  Mark  9  */
#define  nag_zgghrd                                     f08wsc /*  Mark  7  */
#define  nag_zggbal                                     f08wvc /*  Mark  7  */
#define  nag_zggbak                                     f08wwc /*  Mark  7  */
#define  nag_dgges                                      f08xac /*  Mark  9  */
#define  nag_dggesx                                     f08xbc /*  Mark  9  */
#define  nag_dhgeqz                                     f08xec /*  Mark  7  */
#define  nag_zgges                                      f08xnc /*  Mark  9  */
#define  nag_zggesx                                     f08xpc /*  Mark  9  */
#define  nag_zhgeqz                                     f08xsc /*  Mark  7  */
#define  nag_dtgsja                                     f08yec /*  Mark  9  */
#define  nag_dtgexc                                     f08yfc /*  Mark  9  */
#define  nag_dtgsen                                     f08ygc /*  Mark  9  */
#define  nag_dtgsyl                                     f08yhc /*  Mark  9  */
#define  nag_dtgevc                                     f08ykc /*  Mark  7  */
#define  nag_dtgsna                                     f08ylc /*  Mark  9  */
#define  nag_ztgsja                                     f08ysc /*  Mark  9  */
#define  nag_ztgexc                                     f08ytc /*  Mark  9  */
#define  nag_ztgsen                                     f08yuc /*  Mark  9  */
#define  nag_ztgsyl                                     f08yvc /*  Mark  9  */
#define  nag_ztgevc                                     f08yxc /*  Mark  7  */
#define  nag_ztgsna                                     f08yyc /*  Mark  9  */
#define  nag_dgglse                                     f08zac /*  Mark  9  */
#define  nag_dggglm                                     f08zbc /*  Mark  9  */
#define  nag_dggqrf                                     f08zec /*  Mark  9  */
#define  nag_dggrqf                                     f08zfc /*  Mark  9  */
#define  nag_zgglse                                     f08znc /*  Mark  9  */
#define  nag_zggglm                                     f08zpc /*  Mark  9  */
#define  nag_zggqrf                                     f08zsc /*  Mark  9  */
#define  nag_zggrqf                                     f08ztc /*  Mark  9  */

#define  nag_sparse_nsym_fac                            f11dac /*  Mark  5  */ 
#define  nag_sparse_nsym_fac_sol                        f11dcc /*  Mark  5  */ 
#define  nag_sparse_nsym_sol                            f11dec /*  Mark  5  */ 
#define  nag_sparse_sym_chol_fac                        f11jac /*  Mark  5  */ 
#define  nag_sparse_sym_chol_sol                        f11jcc /*  Mark  5  */ 
#define  nag_sparse_sym_sol                             f11jec /*  Mark  5  */ 
#define  nag_superlu_column_permutation                 f11mdc /*  Mark  8  */ 
#define  nag_superlu_lu_factorize                       f11mec /*  Mark  8  */ 
#define  nag_superlu_solve_lu                           f11mfc /*  Mark  8  */ 
#define  nag_superlu_condition_number_lu                f11mgc /*  Mark  8  */ 
#define  nag_superlu_refine_lu                          f11mhc /*  Mark  8  */ 
#define  nag_superlu_matrix_product                     f11mkc /*  Mark  8  */ 
#define  nag_superlu_matrix_norm                        f11mlc /*  Mark  8  */ 
#define  nag_superlu_diagnostic_lu                      f11mmc /*  Mark  8  */ 
#define  nag_sparse_nsym_sort                           f11zac /*  Mark  5  */ 
#define  nag_sparse_sym_sort                            f11zbc /*  Mark  5  */ 

#define  nag_real_sparse_eigensystem_init               f12aac /*  Mark  8  */ 
#define  nag_real_sparse_eigensystem_iter               f12abc /*  Mark  8  */ 
#define  nag_real_sparse_eigensystem_sol                f12acc /*  Mark  8  */ 
#define  nag_real_sparse_eigensystem_option             f12adc /*  Mark  8  */ 
#define  nag_real_sparse_eigensystem_monit              f12aec /*  Mark  8  */ 
#define  nag_real_banded_sparse_eigensystem_init        f12afc /*  Mark  8  */ 
#define  nag_real_banded_sparse_eigensystem_sol         f12agc /*  Mark  8  */ 
#define  nag_complex_sparse_eigensystem_init            f12anc /*  Mark  8  */ 
#define  nag_complex_sparse_eigensystem_iter            f12apc /*  Mark  8  */ 
#define  nag_complex_sparse_eigensystem_sol             f12aqc /*  Mark  8  */ 
#define  nag_complex_sparse_eigensystem_option          f12arc /*  Mark  8  */ 
#define  nag_complex_sparse_eigensystem_monit           f12asc /*  Mark  8  */ 
#define  nag_real_symm_sparse_eigensystem_init          f12fac /*  Mark  8  */ 
#define  nag_real_symm_sparse_eigensystem_iter          f12fbc /*  Mark  8  */ 
#define  nag_real_symm_sparse_eigensystem_sol           f12fcc /*  Mark  8  */ 
#define  nag_real_symm_sparse_eigensystem_option        f12fdc /*  Mark  8  */ 
#define  nag_real_symm_sparse_eigensystem_monit         f12fec /*  Mark  8  */ 
#define  nag_real_symm_banded_sparse_eigensystem_init   f12ffc /*  Mark  8  */ 
#define  nag_real_symm_banded_sparse_eigensystem_sol    f12fgc /*  Mark  8  */ 

#define  nag_iload                                      f16dbc /*  Mark  7  */ 
#define  nag_isum                                       f16dlc /*  Mark  9  */ 
#define  nag_imax_val                                   f16dnc /*  Mark  9  */ 
#define  nag_imin_val                                   f16dpc /*  Mark  9  */ 
#define  nag_iamax_val                                  f16dqc /*  Mark  9  */ 
#define  nag_iamin_val                                  f16drc /*  Mark  9  */ 
#define  nag_daxpby                                     f16ecc /*  Mark  7  */ 
#define  nag_dwaxpby                                    f16ehc /*  Mark  9  */ 
#define  nag_dsum                                       f16elc /*  Mark  9  */ 
#define  nag_dload                                      f16fbc /*  Mark  7  */ 
#define  nag_zwaxpby                                    f16ghc /*  Mark  9  */ 
#define  nag_zsum                                       f16glc /*  Mark  9  */ 
#define  nag_zload                                      f16hbc /*  Mark  7  */
#define  nag_dmax_val                                   f16jnc /*  Mark  9  */ 
#define  nag_dmin_val                                   f16jpc /*  Mark  9  */ 
#define  nag_damax_val                                  f16jqc /*  Mark  9  */ 
#define  nag_damin_val                                  f16jrc /*  Mark  9  */ 
#define  nag_zamax_val                                  f16jsc /*  Mark  9  */ 
#define  nag_zamin_val                                  f16jtc /*  Mark  9  */ 
#define  nag_dgemv                                      f16pac /*  Mark  8  */ 
#define  nag_dgbmv                                      f16pbc /*  Mark  8  */ 
#define  nag_dsymv                                      f16pcc /*  Mark  8  */ 
#define  nag_dsbmv                                      f16pdc /*  Mark  8  */ 
#define  nag_dspmv                                      f16pec /*  Mark  8  */ 
#define  nag_dtrmv                                      f16pfc /*  Mark  8  */ 
#define  nag_dtbmv                                      f16pgc /*  Mark  8  */ 
#define  nag_dtpmv                                      f16phc /*  Mark  8  */ 
#define  nag_dtrsv                                      f16pjc /*  Mark  7  */ 
#define  nag_dtbsv                                      f16pkc /*  Mark  8  */ 
#define  nag_dtpsv                                      f16plc /*  Mark  8  */ 
#define  nag_dger                                       f16pmc /*  Mark  8  */ 
#define  nag_dsyr                                       f16ppc /*  Mark  8  */ 
#define  nag_dspr                                       f16pqc /*  Mark  8  */ 
#define  nag_dsyr2                                      f16prc /*  Mark  8  */ 
#define  nag_dspr2                                      f16psc /*  Mark  8  */ 
#define  nag_dtr_copy                                   f16qec /*  Mark  7  */ 
#define  nag_dge_copy                                   f16qfc /*  Mark  7  */ 
#define  nag_dtr_load                                   f16qgc /*  Mark  7  */ 
#define  nag_dge_load                                   f16qhc /*  Mark  7  */ 
#define  nag_dge_norm                                   f16rac /*  Mark  7  */ 
#define  nag_dgb_norm                                   f16rbc /*  Mark  7  */ 
#define  nag_dsy_norm                                   f16rcc /*  Mark  7  */ 
#define  nag_dsp_norm                                   f16rdc /*  Mark  7  */ 
#define  nag_dsb_norm                                   f16rec /*  Mark  7  */
#define  nag_zgemv                                      f16sac /*  Mark  8  */ 
#define  nag_zgbmv                                      f16sbc /*  Mark  8  */ 
#define  nag_zhemv                                      f16scc /*  Mark  8  */ 
#define  nag_zhbmv                                      f16sdc /*  Mark  8  */ 
#define  nag_zhpmv                                      f16sec /*  Mark  8  */ 
#define  nag_ztrmv                                      f16sfc /*  Mark  8  */ 
#define  nag_ztbmv                                      f16sgc /*  Mark  8  */ 
#define  nag_ztpmv                                      f16shc /*  Mark  8  */ 
#define  nag_ztrsv                                      f16sjc /*  Mark  7  */ 
#define  nag_ztbsv                                      f16skc /*  Mark  8  */ 
#define  nag_ztpsv                                      f16slc /*  Mark  8  */ 
#define  nag_zger                                       f16smc /*  Mark  8  */ 
#define  nag_zher                                       f16spc /*  Mark  8  */ 
#define  nag_zhpr                                       f16sqc /*  Mark  8  */ 
#define  nag_zher2                                      f16src /*  Mark  8  */ 
#define  nag_zhpr2                                      f16ssc /*  Mark  8  */ 
#define  nag_zsymv                                      f16tac /*  Mark  8  */ 
#define  nag_zspmv                                      f16tcc /*  Mark  8  */ 
#define  nag_ztr_copy                                   f16tec /*  Mark  7  */ 
#define  nag_zge_copy                                   f16tfc /*  Mark  7  */ 
#define  nag_ztr_load                                   f16tgc /*  Mark  7  */ 
#define  nag_zge_load                                   f16thc /*  Mark  7  */ 
#define  nag_zge_norm                                   f16uac /*  Mark  7  */ 
#define  nag_zgb_norm                                   f16ubc /*  Mark  7  */ 
#define  nag_zhe_norm                                   f16ucc /*  Mark  7  */ 
#define  nag_zhp_norm                                   f16udc /*  Mark  7  */ 
#define  nag_zhb_norm                                   f16uec /*  Mark  7  */ 
#define  nag_zsy_norm                                   f16ufc /*  Mark  7  */ 
#define  nag_zsp_norm                                   f16ugc /*  Mark  7  */
#define  nag_dgemm                                      f16yac /*  Mark  8  */ 
#define  nag_dsymm                                      f16ycc /*  Mark  8  */ 
#define  nag_dtrmm                                      f16yfc /*  Mark  8  */  
#define  nag_dtrsm                                      f16yjc /*  Mark  7  */ 
#define  nag_dsyrk                                      f16ypc /*  Mark  8  */ 
#define  nag_dsyr2k                                     f16yrc /*  Mark  8  */ 
#define  nag_zgemm                                      f16zac /*  Mark  8  */ 
#define  nag_zhemm                                      f16zcc /*  Mark  8  */ 
#define  nag_ztrmm                                      f16zfc /*  Mark  8  */  
#define  nag_ztrsm                                      f16zjc /*  Mark  7  */ 
#define  nag_zherk                                      f16zpc /*  Mark  8  */ 
#define  nag_zher2k                                     f16zrc /*  Mark  8  */ 
#define  nag_zsymm                                      f16ztc /*  Mark  8  */ 
#define  nag_zsyrk                                      f16zuc /*  Mark  8  */ 
#define  nag_zsyr2k                                     f16zwc /*  Mark  8  */ 

#define  nag_summary_stats_1var                         g01aac /*  Mark  1  */ 
#define  nag_summary_stats_freq                         g01adc /*  Mark  7  */ 
#define  nag_frequency_table                            g01aec /*  Mark  6  */ 
#define  nag_5pt_summary_stats                          g01alc /*  Mark  4  */
#define  nag_double_quantiles                           g01amc /*  Mark  8  */
#define  nag_binomial_dist                              g01bjc /*  Mark  4  */ 
#define  nag_poisson_dist                               g01bkc /*  Mark  4  */ 
#define  nag_hypergeom_dist                             g01blc /*  Mark  4  */ 
#define  nag_deviates_normal_dist                       g01cec /*  Mark  1  */ 
#define  nag_normal_scores_exact                        g01dac /*  Mark  7  */ 
#define  nag_normal_scores_var                          g01dcc /*  Mark  7  */ 
#define  nag_shapiro_wilk_test                          g01ddc /*  Mark  4  */ 
#define  nag_ranks_and_scores                           g01dhc /*  Mark  4  */ 
#define  nag_prob_normal                                g01eac /*  Mark  4  */ 
#define  nag_prob_students_t                            g01ebc /*  Mark  1  */ 
#define  nag_prob_chi_sq                                g01ecc /*  Mark  1  */ 
#define  nag_prob_f_dist                                g01edc /*  Mark  1  */ 
#define  nag_prob_beta_dist                             g01eec /*  Mark  1  */ 
#define  nag_gamma_dist                                 g01efc /*  Mark  1  */ 
#define  nag_prob_studentized_range                     g01emc /*  Mark  7  */ 
#define  nag_prob_durbin_watson                         g01epc /*  Mark  7  */ 
#define  nag_prob_von_mises                             g01erc /*  Mark  7  */ 
#define  nag_prob_landau                                g01etc /*  Mark  7  */ 
#define  nag_prob_vavilov                               g01euc /*  Mark  7  */ 
#define  nag_prob_1_sample_ks                           g01eyc /*  Mark  7  */ 
#define  nag_prob_2_sample_ks                           g01ezc /*  Mark  7  */ 
#define  nag_deviates_normal                            g01fac /*  Mark  4  */ 
#define  nag_deviates_students_t                        g01fbc /*  Mark  1  */ 
#define  nag_deviates_chi_sq                            g01fcc /*  Mark  1  */ 
#define  nag_deviates_f_dist                            g01fdc /*  Mark  1  */ 
#define  nag_deviates_beta                              g01fec /*  Mark  1  */ 
#define  nag_deviates_gamma_dist                        g01ffc /*  Mark  1  */ 
#define  nag_deviates_studentized_range                 g01fmc /*  Mark  7  */ 
#define  nag_deviates_landau                            g01ftc /*  Mark  7  */ 
#define  nag_prob_non_central_students_t                g01gbc /*  Mark  6  */ 
#define  nag_prob_non_central_chi_sq                    g01gcc /*  Mark  6  */ 
#define  nag_prob_non_central_f_dist                    g01gdc /*  Mark  6  */ 
#define  nag_prob_non_central_beta_dist                 g01gec /*  Mark  6  */ 
#define  nag_bivariate_normal_dist                      g01hac /*  Mark  1  */ 
#define  nag_multi_normal                               g01hbc /*  Mark  6  */ 
#define  nag_prob_lin_non_central_chi_sq                g01jcc /*  Mark  7  */ 
#define  nag_prob_lin_chi_sq                            g01jdc /*  Mark  7  */ 
#define  nag_mills_ratio                                g01mbc /*  Mark  7  */ 
#define  nag_prob_density_landau                        g01mtc /*  Mark  7  */ 
#define  nag_prob_density_vavilov                       g01muc /*  Mark  7  */ 
#define  nag_moments_quad_form                          g01nac /*  Mark  7  */ 
#define  nag_moments_ratio_quad_forms                   g01nbc /*  Mark  7  */ 
#define  nag_moment_1_landau                            g01ptc /*  Mark  7  */ 
#define  nag_moment_2_landau                            g01qtc /*  Mark  7  */ 
#define  nag_prob_der_landau                            g01rtc /*  Mark  7  */ 
#define  nag_init_vavilov                               g01zuc /*  Mark  7  */ 
#define  nag_nearest_correlation                        g02aac /*  Mark  9  */ 
#define  nag_ken_spe_corr_coeff                         g02brc /*  Mark  3  */ 
#define  nag_sum_sqs_update                             g02btc /*  Mark  7  */ 
#define  nag_sum_sqs                                    g02buc /*  Mark  7  */ 
#define  nag_cov_to_corr                                g02bwc /*  Mark  7  */ 
#define  nag_corr_cov                                   g02bxc /*  Mark  3  */ 
#define  nag_partial_corr                               g02byc /*  Mark  6  */ 
#define  nag_simple_linear_regression                   g02cac /*  Mark  3  */ 
#define  nag_regress_confid_interval                    g02cbc /*  Mark  3  */ 
#define  nag_regsn_mult_linear                          g02dac /*  Mark  1  */ 
#define  nag_regsn_mult_linear_addrem_obs               g02dcc /*  Mark  2  */ 
#define  nag_regsn_mult_linear_upd_model                g02ddc /*  Mark  2  */ 
#define  nag_regsn_mult_linear_add_var                  g02dec /*  Mark  2  */ 
#define  nag_regsn_mult_linear_delete_var               g02dfc /*  Mark  2  */ 
#define  nag_regsn_mult_linear_newyvar                  g02dgc /*  Mark  1  */ 
#define  nag_regsn_mult_linear_tran_model               g02dkc /*  Mark  2  */ 
#define  nag_regsn_mult_linear_est_func                 g02dnc /*  Mark  2  */ 
#define  nag_all_regsn                                  g02eac /*  Mark  7  */ 
#define  nag_cp_stat                                    g02ecc /*  Mark  7  */ 
#define  nag_step_regsn                                 g02eec /*  Mark  7  */ 
#define  nag_full_step_regsn                            g02efc /*  Mark  8  */ 
#define  nag_full_step_regsn_monfun                     g02efh /*  Mark  9  */ 
#define  nag_full_step_regsn_monit                      g02ewc /*  Mark  8  */ 
#define  nag_regsn_std_resid_influence                  g02fac /*  Mark  1  */ 
#define  nag_durbin_watson_stat                         g02fcc /*  Mark  7  */ 
#define  nag_glm_normal                                 g02gac /*  Mark  4  */ 
#define  nag_glm_binomial                               g02gbc /*  Mark  4  */ 
#define  nag_glm_poisson                                g02gcc /*  Mark  4  */ 
#define  nag_glm_gamma                                  g02gdc /*  Mark  4  */ 
#define  nag_glm_tran_model                             g02gkc /*  Mark  4  */ 
#define  nag_glm_est_func                               g02gnc /*  Mark  4  */ 
#define  nag_glm_predict                                g02gpc /*  Mark  9  */ 
#define  nag_robust_m_regsn_estim                       g02hac /*  Mark  4  */ 
#define  nag_robust_m_regsn_wts                         g02hbc /*  Mark  7  */ 
#define  nag_robust_m_regsn_user_fn                     g02hdc /*  Mark  7  */ 
#define  nag_robust_m_regsn_param_var                   g02hfc /*  Mark  7  */ 
#define  nag_robust_corr_estim                          g02hkc /*  Mark  4  */ 
#define  nag_robust_m_corr_user_fn                      g02hlc /*  Mark  7  */ 
#define  nag_robust_m_corr_user_fn_no_derr              g02hmc /*  Mark  7  */ 
#define  nag_reml_mixed_regsn                           g02jac /*  Mark  8  */ 
#define  nag_ml_mixed_regsn                             g02jbc /*  Mark  8  */ 
#define  nag_hier_mixed_init                            g02jcc /*  Mark  9  */
#define  nag_reml_hier_mixed_regsn                      g02jdc /*  Mark  9  */
#define  nag_ml_hier_mixed_regsn                        g02jec /*  Mark  9  */
#define  nag_regsn_ridge_opt                            g02kac /*  Mark  9  */ 
#define  nag_regsn_ridge                                g02kbc /*  Mark  9  */ 
#define  nag_pls_orth_scores_svd                        g02lac /*  Mark  9  */ 
#define  nag_pls_orth_scores_wold                       g02lbc /*  Mark  9  */ 
#define  nag_pls_orth_scores_fit                        g02lcc /*  Mark  9  */ 
#define  nag_pls_orth_scores_pred                       g02ldc /*  Mark  9  */ 
#define  nag_mv_prin_comp                               g03aac /*  Mark  5  */ 
#define  nag_mv_canon_var                               g03acc /*  Mark  5  */ 
#define  nag_mv_canon_corr                              g03adc /*  Mark  5  */ 
#define  nag_mv_orthomax                                g03bac /*  Mark  5  */ 
#define  nag_mv_procustes                               g03bcc /*  Mark  5  */ 
#define  nag_mv_promax                                  g03bdc /*  Mark  9  */ 
#define  nag_mv_factor                                  g03cac /*  Mark  5  */ 
#define  nag_mv_fac_score                               g03ccc /*  Mark  5  */ 
#define  nag_mv_discrim                                 g03dac /*  Mark  5  */ 
#define  nag_mv_discrim_mahaldist                       g03dbc /*  Mark  5  */ 
#define  nag_mv_discrim_group                           g03dcc /*  Mark  5  */ 
#define  nag_mv_distance_mat                            g03eac /*  Mark  5  */ 
#define  nag_mv_hierar_cluster_analysis                 g03ecc /*  Mark  5  */ 
#define  nag_mv_kmeans_cluster_analysis                 g03efc /*  Mark  5  */ 
#define  nag_mv_dendrogram                              g03ehc /*  Mark  5  */ 
#define  nag_mv_cluster_indicator                       g03ejc /*  Mark  5  */ 
#define  nag_mv_prin_coord_analysis                     g03fac /*  Mark  5  */ 
#define  nag_mv_ordinal_multidimscale                   g03fcc /*  Mark  5  */ 
#define  nag_mv_dend_free                               g03xzc /*  Mark  5  */ 
#define  nag_mv_z_scores                                g03zac /*  Mark  5  */ 
#define  nag_anova_random                               g04bbc /*  Mark  5  */ 
#define  nag_anova_row_col                              g04bcc /*  Mark  6  */ 
#define  nag_anova_factorial                            g04cac /*  Mark  5  */ 
#define  nag_anova_factorial_free                       g04czc /*  Mark  5  */ 
#define  nag_anova_confid_interval                      g04dbc /*  Mark  6  */ 
#define  nag_dummy_vars                                 g04eac /*  Mark  6  */ 
#define  nag_random_continuous_uniform                  g05cac /*  Mark  1  */ 
#define  nag_random_init_repeatable                     g05cbc /*  Mark  1  */ 
#define  nag_random_init_nonrepeatable                  g05ccc /*  Mark  1  */ 
#define  nag_save_random_state                          g05cfc /*  Mark  1  */ 
#define  nag_restore_random_state                       g05cgc /*  Mark  1  */ 
#define  nag_random_continuous_uniform_ab               g05dac /*  Mark  1  */ 
#define  nag_random_exp                                 g05dbc /*  Mark  1  */ 
#define  nag_random_normal                              g05ddc /*  Mark  1  */ 
#define  nag_random_discrete_uniform                    g05dyc /*  Mark  1  */ 
#define  nag_ref_vec_multi_normal                       g05eac /*  Mark  2  */ 
#define  nag_ref_vec_poisson                            g05ecc /*  Mark  2  */ 
#define  nag_ref_vec_binomial                           g05edc /*  Mark  2  */ 
#define  nag_ran_permut_vec                             g05ehc /*  Mark  3  */ 
#define  nag_ran_sample_vec                             g05ejc /*  Mark  3  */ 
#define  nag_ref_vec_discrete_pdf_cdf                   g05exc /*  Mark  2  */ 
#define  nag_return_discrete                            g05eyc /*  Mark  2  */ 
#define  nag_return_multi_normal                        g05ezc /*  Mark  2  */ 
#define  nag_random_beta                                g05fec /*  Mark  2  */ 
#define  nag_random_gamma                               g05ffc /*  Mark  2  */ 
#define  nag_arma_time_series                           g05hac /*  Mark  3  */ 
#define  nag_generate_agarchI                           g05hkc /*  Mark  6  */ 
#define  nag_generate_agarchII                          g05hlc /*  Mark  6  */ 
#define  nag_generate_garchGJR                          g05hmc /*  Mark  6  */ 
#define  nag_rngs_basic                                 g05kac /*  Mark  7  */ 
#define  nag_rngs_init_repeatable                       g05kbc /*  Mark  7  */ 
#define  nag_rngs_init_nonrepeatable                    g05kcc /*  Mark  7  */ 
#define  nag_rngs_logical                               g05kec /*  Mark  7  */ 
#define  nag_rand_init_repeatable                       g05kfc /*  Mark  9  */ 
#define  nag_rand_init_nonrepeatable                    g05kgc /*  Mark  9  */ 
#define  nag_rand_leap_frog                             g05khc /*  Mark  9  */ 
#define  nag_rand_skip_ahead                            g05kjc /*  Mark  9  */ 
#define  nag_rngs_normal                                g05lac /*  Mark  7  */ 
#define  nag_rngs_students_t                            g05lbc /*  Mark  7  */ 
#define  nag_rngs_chi_sq                                g05lcc /*  Mark  7  */ 
#define  nag_rngs_f                                     g05ldc /*  Mark  7  */ 
#define  nag_rngs_beta                                  g05lec /*  Mark  7  */ 
#define  nag_rngs_gamma                                 g05lfc /*  Mark  7  */ 
#define  nag_rngs_uniform                               g05lgc /*  Mark  7  */ 
#define  nag_rngs_triangular                            g05lhc /*  Mark  7  */ 
#define  nag_rngs_exp                                   g05ljc /*  Mark  7  */ 
#define  nag_rngs_lognormal                             g05lkc /*  Mark  7  */ 
#define  nag_rngs_cauchy                                g05llc /*  Mark  7  */ 
#define  nag_rngs_weibull                               g05lmc /*  Mark  7  */ 
#define  nag_rngs_logistic                              g05lnc /*  Mark  7  */ 
#define  nag_rngs_von_mises                             g05lpc /*  Mark  7  */ 
#define  nag_rngs_exp_mix                               g05lqc /*  Mark  7  */ 
#define  nag_rngs_matrix_multi_students_t               g05lxc /*  Mark  8  */ 
#define  nag_rgsn_matrix_multi_normal                   g05lyc /*  Mark  8  */ 
#define  nag_rngs_multi_normal                          g05lzc /*  Mark  7  */ 
#define  nag_rngs_discrete_uniform                      g05mac /*  Mark  7  */ 
#define  nag_rngs_geom                                  g05mbc /*  Mark  7  */ 
#define  nag_rngs_neg_bin                               g05mcc /*  Mark  7  */ 
#define  nag_rngs_logarithmic                           g05mdc /*  Mark  7  */ 
#define  nag_rngs_compd_poisson                         g05mec /*  Mark  7  */ 
#define  nag_rngs_binomial                              g05mjc /*  Mark  7  */ 
#define  nag_rngs_poisson                               g05mkc /*  Mark  7  */ 
#define  nag_rngs_hypergeometric                        g05mlc /*  Mark  7  */ 
#define  nag_rngs_gen_multinomial                       g05mrc /*  Mark  7  */ 
#define  nag_rngs_gen_discrete                          g05mzc /*  Mark  7  */ 
#define  nag_rngs_permute                               g05nac /*  Mark  7  */ 
#define  nag_rngs_sample                                g05nbc /*  Mark  7  */ 
#define  nag_rand_permute                               g05ncc /*  Mark  9  */ 
#define  nag_rand_sample                                g05ndc /*  Mark  9  */ 
#define  nag_rngs_arma_time_series                      g05pac /*  Mark  7  */ 
#define  nag_rngs_varma_time_series                     g05pcc /*  Mark  7  */ 
#define  nag_rand_agarchI                               g05pdc /*  Mark  9  */ 
#define  nag_rand_agarchII                              g05pec /*  Mark  9  */ 
#define  nag_rand_garchGJR                              g05pfc /*  Mark  9  */ 
#define  nag_rand_egarch                                g05pgc /*  Mark  9  */ 
#define  nag_rand_arma                                  g05phc /*  Mark  9  */
#define  nag_rand_varma                                 g05pjc /*  Mark  9  */ 
#define  nag_rand_exp_smooth                            g05pmc /*  Mark  9  */ 
#define  nag_rand_orthog_matrix                         g05pxc /*  Mark  9  */ 
#define  nag_rand_corr_matrix                           g05pyc /*  Mark  9  */
#define  nag_rand_2_way_table                           g05pzc /*  Mark  9  */
#define  nag_rngs_orthog_matrix                         g05qac /*  Mark  7  */ 
#define  nag_rngs_corr_matrix                           g05qbc /*  Mark  7  */ 
#define  nag_rngs_2_way_table                           g05qdc /*  Mark  7  */ 
#define  nag_rngs_copula_normal                         g05rac /*  Mark  8  */ 
#define  nag_rngs_copula_students_t                     g05rbc /*  Mark  8  */ 
#define  nag_rand_copula_students_t                     g05rcc /*  Mark  9  */ 
#define  nag_rand_copula_normal                         g05rdc /*  Mark  9  */ 
#define  nag_rand_bivariate_copula_clayton              g05rec /*  Mark  9  */ 
#define  nag_rand_bivariate_copula_frank                g05rfc /*  Mark  9  */ 
#define  nag_rand_bivariate_copula_plackett             g05rgc /*  Mark  9  */ 
#define  nag_rand_copula_clayton                        g05rhc /*  Mark  9  */ 
#define  nag_rand_copula_frank                          g05rjc /*  Mark  9  */ 
#define  nag_rand_copula_gumbel                         g05rkc /*  Mark  9  */ 
#define  nag_rand_matrix_multi_students_t               g05ryc /*  Mark  9  */ 
#define  nag_rand_matrix_multi_normal                   g05rzc /*  Mark  9  */ 
#define  nag_rand_basic                                 g05sac /*  Mark  9  */
#define  nag_rand_beta                                  g05sbc /*  Mark  9  */ 
#define  nag_rand_cauchy                                g05scc /*  Mark  9  */ 
#define  nag_rand_chi_sq                                g05sdc /*  Mark  9  */ 
#define  nag_rand_dirichlet                             g05sec /*  Mark  9  */ 
#define  nag_rand_exp                                   g05sfc /*  Mark  9  */ 
#define  nag_rand_exp_mix                               g05sgc /*  Mark  9  */ 
#define  nag_rand_f                                     g05shc /*  Mark  9  */ 
#define  nag_rand_gamma                                 g05sjc /*  Mark  9  */ 
#define  nag_rand_normal                                g05skc /*  Mark  9  */ 
#define  nag_rand_logistic                              g05slc /*  Mark  9  */ 
#define  nag_rand_lognormal                             g05smc /*  Mark  9  */ 
#define  nag_rand_students_t                            g05snc /*  Mark  9  */ 
#define  nag_rand_triangular                            g05spc /*  Mark  9  */
#define  nag_rand_uniform                               g05sqc /*  Mark  9  */ 
#define  nag_rand_von_mises                             g05src /*  Mark  9  */ 
#define  nag_rand_weibull                               g05ssc /*  Mark  9  */ 
#define  nag_rand_binomial                              g05tac /*  Mark  9  */ 
#define  nag_rand_logical                               g05tbc /*  Mark  9  */ 
#define  nag_rand_geom                                  g05tcc /*  Mark  9  */ 
#define  nag_rand_gen_discrete                          g05tdc /*  Mark  9  */ 
#define  nag_rand_hypergeometric                        g05tec /*  Mark  9  */ 
#define  nag_rand_logarithmic                           g05tfc /*  Mark  9  */ 
#define  nag_rand_gen_multinomial                       g05tgc /*  Mark  9  */ 
#define  nag_rand_neg_bin                               g05thc /*  Mark  9  */ 
#define  nag_rand_poisson                               g05tjc /*  Mark  9  */ 
#define  nag_rand_compd_poisson                         g05tkc /*  Mark  9  */ 
#define  nag_rand_discrete_uniform                      g05tlc /*  Mark  9  */ 
#define  nag_quasi_random_uniform                       g05yac /*  Mark  7  */ 
#define  nag_quasi_random_normal                        g05ybc /*  Mark  7  */
#define  nag_quasi_init                                 g05ylc /*  Mark  9  */ 
#define  nag_quasi_rand_normal                          g05yjc /*  Mark  9  */  
#define  nag_quasi_rand_lognormal                       g05ykc /*  Mark  9  */  
#define  nag_quasi_rand_uniform                         g05ymc /*  Mark  9  */  
#define  nag_quasi_init_scrambled                       g05ync /*  Mark  9  */ 
#define  nag_binomial_ci                                g07aac /*  Mark  7  */ 
#define  nag_poisson_ci                                 g07abc /*  Mark  7  */ 
#define  nag_censored_normal                            g07bbc /*  Mark  7  */ 
#define  nag_estim_weibull                              g07bec /*  Mark  7  */ 
#define  nag_estim_gen_pareto                           g07bfc /*  Mark  9  */ 
#define  nag_2_sample_t_test                            g07cac /*  Mark  4  */ 
#define  nag_median_1var                                g07dac /*  Mark  3  */ 
#define  nag_robust_m_estim_1var                        g07dbc /*  Mark  4  */ 
#define  nag_robust_m_estim_1var_usr                    g07dcc /*  Mark  7  */ 
#define  nag_robust_trimmed_1var                        g07ddc /*  Mark  4  */ 
#define  nag_rank_ci_1var                               g07eac /*  Mark  7  */ 
#define  nag_rank_ci_2var                               g07ebc /*  Mark  7  */ 
#define  nag_sign_test                                  g08aac /*  Mark  6  */ 
#define  nag_median_test                                g08acc /*  Mark  6  */ 
#define  nag_friedman_test                              g08aec /*  Mark  6  */ 
#define  nag_kruskal_wallis_test                        g08afc /*  Mark  6  */ 
#define  nag_wilcoxon_test                              g08agc /*  Mark  6  */ 
#define  nag_mann_whitney                               g08amc /*  Mark  6  */ 
#define  nag_1_sample_ks_test                           g08cbc /*  Mark  6  */ 
#define  nag_2_sample_ks_test                           g08cdc /*  Mark  6  */ 
#define  nag_chi_sq_goodness_of_fit_test                g08cgc /*  Mark  6  */ 
#define  nag_runs_test                                  g08eac /*  Mark  6  */ 
#define  nag_pairs_test                                 g08ebc /*  Mark  6  */ 
#define  nag_triplets_test                              g08ecc /*  Mark  6  */ 
#define  nag_gaps_test                                  g08edc /*  Mark  6  */ 
#define  nag_rank_regsn                                 g08rac /*  Mark  7  */ 
#define  nag_rank_regsn_censored                        g08rbc /*  Mark  7  */ 
#define  nag_smooth_spline_fit                          g10abc /*  Mark  6  */ 
#define  nag_smooth_spline_estim                        g10acc /*  Mark  6  */ 
#define  nag_kernel_density_estim                       g10bac /*  Mark  6  */ 
#define  nag_running_median_smoother                    g10cac /*  Mark  3  */ 
#define  nag_order_data                                 g10zac /*  Mark  6  */ 
#define  nag_chi_sq_2_way_table                         g11aac /*  Mark  4  */ 
#define  nag_tabulate_stats                             g11bac /*  Mark  6  */ 
#define  nag_tabulate_percentile                        g11bbc /*  Mark  6  */ 
#define  nag_tabulate_margin                            g11bcc /*  Mark  7  */ 
#define  nag_condl_logistic                             g11cac /*  Mark  7  */ 
#define  nag_binary_factor                              g11sac /*  Mark  7  */ 
#define  nag_binary_factor_service                      g11sbc /*  Mark  7  */ 
#define  nag_prod_limit_surviv_fn                       g12aac /*  Mark  4  */ 
#define  nag_surviv_cox_model                           g12bac /*  Mark  6  */ 
#define  nag_surviv_risk_sets                           g12zac /*  Mark  7  */ 
#define  nag_tsa_diff                                   g13aac /*  Mark  7  */ 
#define  nag_tsa_auto_corr                              g13abc /*  Mark  2  */ 
#define  nag_tsa_auto_corr_part                         g13acc /*  Mark  2  */ 
#define  nag_tsa_exp_smooth                             g13amc /*  Mark  9  */ 
#define  nag_tsa_resid_corr                             g13asc /*  Mark  6  */ 
#define  nag_tsa_mean_range                             g13auc /*  Mark  7  */ 
#define  nag_tsa_arma_filter                            g13bac /*  Mark  7  */ 
#define  nag_tsa_transf_filter                          g13bbc /*  Mark  7  */ 
#define  nag_tsa_cross_corr                             g13bcc /*  Mark  7  */ 
#define  nag_tsa_transf_prelim_fit                      g13bdc /*  Mark  7  */ 
#define  nag_tsa_multi_inp_model_estim                  g13bec /*  Mark  2  */ 
#define  nag_tsa_multi_inp_update                       g13bgc /*  Mark  8  */ 
#define  nag_tsa_multi_inp_model_forecast               g13bjc /*  Mark  2  */ 
#define  nag_tsa_options_init                           g13bxc /*  Mark  2  */ 
#define  nag_tsa_transf_orders                          g13byc /*  Mark  2  */ 
#define  nag_tsa_trans_free                             g13bzc /*  Mark  2  doc,  edited  to  correct  form  3/8/93  */ 
#define  nag_tsa_spectrum_univar_cov                    g13cac /*  Mark  7  */ 
#define  nag_tsa_spectrum_univar                        g13cbc /*  Mark  4  */ 
#define  nag_tsa_spectrum_bivar_cov                     g13ccc /*  Mark  7  */ 
#define  nag_tsa_spectrum_bivar                         g13cdc /*  Mark  4  */ 
#define  nag_tsa_cross_spectrum_bivar                   g13cec /*  Mark  4  */ 
#define  nag_tsa_gain_phase_bivar                       g13cfc /*  Mark  4  */ 
#define  nag_tsa_noise_spectrum_bivar                   g13cgc /*  Mark  4  */ 
#define  nag_tsa_multi_auto_corr_part                   g13dbc /*  Mark  7  */ 
#define  nag_tsa_varma_estimate                         g13ddc /*  Mark  8  */ 
#define  nag_tsa_varma_forecast                         g13djc /*  Mark  8  */ 
#define  nag_tsa_varma_update                           g13dkc /*  Mark  8  */ 
#define  nag_tsa_multi_diff                             g13dlc /*  Mark  7  */ 
#define  nag_tsa_multi_cross_corr                       g13dmc /*  Mark  7  */ 
#define  nag_tsa_multi_part_lag_corr                    g13dnc /*  Mark  7  */ 
#define  nag_tsa_multi_part_regsn                       g13dpc /*  Mark  7  */ 
#define  nag_tsa_varma_diagnostic                       g13dsc /*  Mark  8  */ 
#define  nag_tsa_arma_roots                             g13dxc /*  Mark  7  */ 
#define  nag_kalman_sqrt_filt_cov_var                   g13eac /*  Mark  3  */ 
#define  nag_kalman_sqrt_filt_cov_invar                 g13ebc /*  Mark  3  */ 
#define  nag_kalman_sqrt_filt_info_var                  g13ecc /*  Mark  3  */ 
#define  nag_kalman_sqrt_filt_info_invar                g13edc /*  Mark  3  */ 
#define  nag_trans_hessenberg_observer                  g13ewc /*  Mark  3  */ 
#define  nag_trans_hessenberg_controller                g13exc /*  Mark  3  */ 
#define  nag_estimate_agarchI                           g13fac /*  Mark  6  */ 
#define  nag_forecast_agarchI                           g13fbc /*  Mark  6  */ 
#define  nag_estimate_agarchII                          g13fcc /*  Mark  6  */ 
#define  nag_forecast_agarchII                          g13fdc /*  Mark  6  */ 
#define  nag_estimate_garchGJR                          g13fec /*  Mark  6  */ 
#define  nag_forecast_garchGJR                          g13ffc /*  Mark  6  */ 
#define  nag_tsa_free                                   g13xzc /*  Mark  2  doc,  but  replaced  here  3  August  1993  */ 
#define  nag_ip_bb                                      h02bbc /*  Mark  5  */ 
#define  nag_ip_mps_read                                h02buc /*  Mark  5  */ 
#define  nag_ip_mps_free                                h02bvc /*  Mark  5  */ 
#define  nag_ip_init                                    h02xxc /*  Mark  5  */ 
#define  nag_ip_read                                    h02xyc /*  Mark  5  */ 
#define  nag_ip_free                                    h02xzc /*  Mark  5  */ 
#define  nag_transport                                  h03abc /*  Mark  3  */ 
#define  nag_double_sort                                m01cac /*  Mark  1  */ 
#define  nag_quicksort                                  m01csc /*  Mark  1  */ 
#define  nag_stable_sort                                m01ctc /*  Mark  1  */ 
#define  nag_chain_sort                                 m01cuc /*  Mark  1  */ 
#define  nag_rank_sort                                  m01dsc /*  Mark  1  */ 
#define  nag_reorder_vector                             m01esc /*  Mark  1  */ 
#define  nag_search_vector                              m01fsc /*  Mark  1  */ 
#define  nag_search_double                              m01nac /*  Mark  9  */ 
#define  nag_search_int                                 m01nbc /*  Mark  9  */ 
#define  nag_search_char                                m01ncc /*  Mark  9  */ 
#define  nag_make_indices                               m01zac /*  Mark  1  */ 
#define  nag_shifted_log                                s01bac /*  Mark  7  */ 
#define  nag_tanh                                       s10aac /*  Mark  1  */ 
#define  nag_sinh                                       s10abc /*  Mark  1  */ 
#define  nag_cosh                                       s10acc /*  Mark  1  */ 
#define  nag_arctanh                                    s11aac /*  Mark  1  */ 
#define  nag_arcsinh                                    s11abc /*  Mark  1  */ 
#define  nag_arccosh                                    s11acc /*  Mark  1  */ 
#define  nag_exp_integral                               s13aac /*  Mark  1  */ 
#define  nag_cos_integral                               s13acc /*  Mark  1  */ 
#define  nag_sin_integral                               s13adc /*  Mark  1  */ 
#define  nag_gamma                                      s14aac /*  Mark  1  */ 
#define  nag_log_gamma                                  s14abc /*  Mark  1  */ 
#define  nag_polygamma_fun                              s14acc /*  Mark  7  */ 
#define  nag_polygamma_deriv                            s14adc /*  Mark  7  */ 
#define  nag_real_polygamma                             s14aec /*  Mark  6  */ 
#define  nag_complex_polygamma                          s14afc /*  Mark  6  */ 
#define  nag_complex_log_gamma                          s14agc /*  Mark  7  */ 
#define  nag_scaled_log_gamma                           s14ahc /*  Mark  9  */ 
#define  nag_incomplete_gamma                           s14bac /*  Mark  1  */ 
#define  nag_cumul_normal                               s15abc /*  Mark  1  */ 
#define  nag_cumul_normal_complem                       s15acc /*  Mark  1  */ 
#define  nag_erfc                                       s15adc /*  Mark  1  */ 
#define  nag_erf                                        s15aec /*  Mark  1  */ 
#define  nag_dawson                                     s15afc /*  Mark  7  */ 
#define  nag_erfcx                                      s15agc /*  Mark  9  */ 
#define  nag_complex_erfc                               s15ddc /*  Mark  7  */ 
#define  nag_bessel_y0                                  s17acc /*  Mark  1  */ 
#define  nag_bessel_y1                                  s17adc /*  Mark  1  */ 
#define  nag_bessel_j0                                  s17aec /*  Mark  1  */ 
#define  nag_bessel_j1                                  s17afc /*  Mark  1  */ 
#define  nag_airy_ai                                    s17agc /*  Mark  1  */ 
#define  nag_airy_bi                                    s17ahc /*  Mark  1  */ 
#define  nag_airy_ai_deriv                              s17ajc /*  Mark  1  */ 
#define  nag_airy_bi_deriv                              s17akc /*  Mark  1  */ 
#define  nag_bessel_zeros                               s17alc /*  Mark  6  */ 
#define  nag_complex_bessel_y                           s17dcc /*  Mark  7  */ 
#define  nag_complex_bessel_j                           s17dec /*  Mark  7  */ 
#define  nag_complex_airy_ai                            s17dgc /*  Mark  7  */ 
#define  nag_complex_airy_bi                            s17dhc /*  Mark  7  */ 
#define  nag_complex_hankel                             s17dlc /*  Mark  7  */ 
#define  nag_bessel_k0                                  s18acc /*  Mark  1  */ 
#define  nag_bessel_k1                                  s18adc /*  Mark  1  */ 
#define  nag_bessel_i0                                  s18aec /*  Mark  1  */ 
#define  nag_bessel_i1                                  s18afc /*  Mark  1  */ 
#define  nag_bessel_k0_scaled                           s18ccc /*  Mark  2  */ 
#define  nag_bessel_k1_scaled                           s18cdc /*  Mark  2  */ 
#define  nag_bessel_i0_scaled                           s18cec /*  Mark  2  */ 
#define  nag_bessel_i1_scaled                           s18cfc /*  Mark  2  */ 
#define  nag_complex_bessel_k                           s18dcc /*  Mark  7  */ 
#define  nag_complex_bessel_i                           s18dec /*  Mark  7  */ 
#define  nag_bessel_i_nu_scaled                         s18ecc /*  Mark  6  */ 
#define  nag_bessel_k_nu_scaled                         s18edc /*  Mark  6  */ 
#define  nag_bessel_i_nu                                s18eec /*  Mark  6  */ 
#define  nag_bessel_k_nu                                s18efc /*  Mark  6  */ 
#define  nag_bessel_k_alpha                             s18egc /*  Mark  6  */ 
#define  nag_bessel_k_alpha_scaled                      s18ehc /*  Mark  6  */ 
#define  nag_bessel_i_alpha                             s18ejc /*  Mark  6  */ 
#define  nag_bessel_j_alpha                             s18ekc /*  Mark  6  */ 
#define  nag_complex_bessel_j_seq                       s18gkc /*  Mark  7  */ 
#define  nag_kelvin_ber                                 s19aac /*  Mark  1  */ 
#define  nag_kelvin_bei                                 s19abc /*  Mark  1  */ 
#define  nag_kelvin_ker                                 s19acc /*  Mark  1  */ 
#define  nag_kelvin_kei                                 s19adc /*  Mark  1  */ 
#define  nag_fresnel_s                                  s20acc /*  Mark  1  */ 
#define  nag_fresnel_c                                  s20adc /*  Mark  1  */ 
#define  nag_elliptic_integral_rc                       s21bac /*  Mark  1  */ 
#define  nag_elliptic_integral_rf                       s21bbc /*  Mark  1  */ 
#define  nag_elliptic_integral_rd                       s21bcc /*  Mark  1  */ 
#define  nag_elliptic_integral_rj                       s21bdc /*  Mark  1  */ 
#define  nag_elliptic_integral_F                        s21bec /*  Mark  9  */ 
#define  nag_elliptic_integral_E                        s21bfc /*  Mark  9  */ 
#define  nag_elliptic_integral_pi                       s21bgc /*  Mark  9  */ 
#define  nag_elliptic_integral_complete_K               s21bhc /*  Mark  9  */ 
#define  nag_elliptic_integral_complete_E               s21bjc /*  Mark  9  */ 
#define  nag_real_jacobian_elliptic                     s21cac /*  Mark  7  */ 
#define  nag_jacobian_elliptic                          s21cbc /*  Mark  6  */ 
#define  nag_jacobian_theta                             s21ccc /*  Mark  6  */ 
#define  nag_elliptic_integral_f                        s21dac /*  Mark  6  */ 
#define  nag_legendre_p                                 s22aac /*  Mark  6  */ 
#define  nag_complex_coulomb                            s23aac /*  Mark  99  */ 
#define  nag_bsm_price                                  s30aac /*  Mark 9 */
#define  nag_bsm_greeks                                 s30abc /*  Mark 9 */
#define  nag_lookback_fls_price                         s30bac /*  Mark 9 */
#define  nag_lookback_fls_greeks                        s30bbc /*  Mark 9 */
#define  nag_binary_con_price                           s30cac /*  Mark 9 */
#define  nag_binary_con_greeks                          s30cbc /*  Mark 9 */
#define  nag_binary_aon_price                           s30ccc /*  Mark 9 */
#define  nag_binary_aon_greeks                          s30cdc /*  Mark 9 */
#define  nag_barrier_std_price                          s30fac /*  Mark 9 */
#define  nag_barrier_std_greeks                         s30fbc /*  Mark 9 */
#define  nag_jumpdiff_merton_price                      s30jac /*  Mark 9 */
#define  nag_jumpdiff_merton_greeks                     s30jbc /*  Mark 9 */
#define  nag_heston_price                               s30nac /*  Mark 9 */
#define  nag_amer_bs_price                              s30qcc /*  Mark 9 */
#define  nag_asian_geom_price                           s30sac /*  Mark 9 */
#define  nag_asian_geom_greeks                          s30sbc /*  Mark 9 */
#define  nag_pi                                         X01AAC /*  Mark  1  */ 
#define  nag_euler_constant                             X01ABC /*  Mark  1  */ 
#define  nag_max_sine_argument                          X02AHC /*  Mark  1  */ 
#define  nag_machine_precision                          X02AJC /*  Mark  1  */ 
#define  nag_real_smallest_number                       X02AKC /*  Mark  1  */ 
#define  nag_real_largest_number                        X02ALC /*  Mark  1  */ 
#define  nag_real_safe_small_number                     X02AMC /*  Mark  1  */ 
#define  nag_complex_safe_small_number                  X02ANC /*  Mark  6  */ 
#define  nag_max_integer                                X02BBC /*  Mark  1  */ 
#define  nag_decimal_digits                             X02BEC /*  Mark  1  */ 
#define  nag_real_base                                  X02BHC /*  Mark  1  */ 
#define  nag_real_base_digits                           X02BJC /*  Mark  1  */ 
#define  nag_real_min_exponent                          X02BKC /*  Mark  1  */ 
#define  nag_real_max_exponent                          X02BLC /*  Mark  1  */ 
/* #define  nag_active_set_size                 X02CAC  Mark 1 */ 
#define  nag_underflow_flag                             X02DAC /*  Mark  1  */ 
#define  nag_real_arithmetic_rounds                     X02DJC /*  Mark  1  */
#define  nag_open_file                                  x04acc /*  Mark  8  */
#define  nag_close_file                                 x04adc /*  Mark  8  */ 
#define  nag_write_line                                 x04bac /*  Mark  8  */ 
#define  nag_read_line                                  x04bbc /*  Mark  8  */ 
#define  nag_gen_real_mat_print                         x04cac /*  Mark  7  */ 
#define  nag_gen_real_mat_print_comp                    x04cbc /*  Mark  7  */ 
#define  nag_pack_real_mat_print                        x04ccc /*  Mark  7  */ 
#define  nag_pack_real_mat_print_comp                   x04cdc /*  Mark  7  */ 
#define  nag_band_real_mat_print                        x04cec /*  Mark  7  */ 
#define  nag_band_real_mat_print_comp                   x04cfc /*  Mark  7  */ 
#define  nag_gen_complx_mat_print                       x04dac /*  Mark  7  */ 
#define  nag_gen_complx_mat_print_comp                  x04dbc /*  Mark  7  */ 
#define  nag_pack_complx_mat_print                      x04dcc /*  Mark  7  */ 
#define  nag_pack_complx_mat_print_comp                 x04ddc /*  Mark  7  */ 
#define  nag_band_complx_mat_print                      x04dec /*  Mark  7  */ 
#define  nag_band_complx_mat_print_comp                 x04dfc /*  Mark  7  */ 
#define  nag_enum_name_to_value                         x04nac /*  Mark  8  */
#define  nag_enum_value_to_name                         x04nbc /*  Mark  8  */
#define  nag_error_name_to_code                         x04ncc /*  Mark  8  */
#define  nag_code_to_error_name                         x04ndc /*  Mark  9  */
#define  nag_dgbequ                                     f07bfc /*  Mark  8  */ 
#define  nag_zgbsv                                      f07bnc /*  Mark  8  */ 
#define  nag_zgbsvx                                     f07bpc /*  Mark  8  */ 
#define  nag_zgbequ                                     f07btc /*  Mark  8  */ 
#define  nag_dgtsv                                      f07cac /*  Mark  8  */ 
#define  nag_dgtsvx                                     f07cbc /*  Mark  8  */ 
#define  nag_dgttrf                                     f07cdc /*  Mark  8  */ 
#define  nag_dgttrs                                     f07cec /*  Mark  8  */ 
#define  nag_dgtcon                                     f07cgc /*  Mark  8  */ 
#define  nag_dgtrfs                                     f07chc /*  Mark  8  */ 
#define  nag_zgtsv                                      f07cnc /*  Mark  8  */ 
#define  nag_zgtsvx                                     f07cpc /*  Mark  8  */ 
#define  nag_zgttrf                                     f07crc /*  Mark  8  */ 
#define  nag_zgttrs                                     f07csc /*  Mark  8  */ 
#define  nag_zgtcon                                     f07cuc /*  Mark  8  */ 
#define  nag_zgtrfs                                     f07cvc /*  Mark  8  */ 
#define  nag_dposv                                      f07fac /*  Mark  8  */ 
#define  nag_dposvx                                     f07fbc /*  Mark  8  */ 
#define  nag_dpoequ                                     f07ffc /*  Mark  8  */ 
#define  nag_zposv                                      f07fnc /*  Mark  8  */ 
#define  nag_zposvx                                     f07fpc /*  Mark  8  */ 
#define  nag_zpoequ                                     f07ftc /*  Mark  8  */ 
#define  nag_dppsv                                      f07gac /*  Mark  8  */ 
#define  nag_dppsvx                                     f07gbc /*  Mark  8  */ 
#define  nag_dppequ                                     f07gfc /*  Mark  8  */ 
#define  nag_zppsv                                      f07gnc /*  Mark  8  */ 
#define  nag_zppsvx                                     f07gpc /*  Mark  8  */ 
#define  nag_zppequ                                     f07gtc /*  Mark  8  */ 
#define  nag_dpbsv                                      f07hac /*  Mark  8  */ 
#define  nag_dpbsvx                                     f07hbc /*  Mark  8  */ 
#define  nag_dpbequ                                     f07hfc /*  Mark  8  */ 
#define  nag_zpbsv                                      f07hnc /*  Mark  8  */ 
#define  nag_zpbsvx                                     f07hpc /*  Mark  8  */ 
#define  nag_zpbequ                                     f07htc /*  Mark  8  */ 
#define  nag_dptsv                                      f07jac /*  Mark  8  */ 
#define  nag_dptsvx                                     f07jbc /*  Mark  8  */ 
#define  nag_dpttrf                                     f07jdc /*  Mark  8  */ 
#define  nag_dpttrs                                     f07jec /*  Mark  8  */ 
#define  nag_dptcon                                     f07jgc /*  Mark  8  */ 
#define  nag_dptrfs                                     f07jhc /*  Mark  8  */ 
#define  nag_zptsv                                      f07jnc /*  Mark  8  */ 
#define  nag_zptsvx                                     f07jpc /*  Mark  8  */ 
#define  nag_zpttrf                                     f07jrc /*  Mark  8  */ 
#define  nag_zpttrs                                     f07jsc /*  Mark  8  */ 
#define  nag_zptcon                                     f07juc /*  Mark  8  */ 
#define  nag_zptrfs                                     f07jvc /*  Mark  8  */ 
#define  nag_dsysv                                      f07mac /*  Mark  8  */ 
#define  nag_dsysvx                                     f07mbc /*  Mark  8  */ 
#define  nag_zhesv                                      f07mnc /*  Mark  8  */ 
#define  nag_zhesvx                                     f07mpc /*  Mark  8  */ 
#define  nag_zsysv                                      f07nnc /*  Mark  8  */ 
#define  nag_zsysvx                                     f07npc /*  Mark  8  */ 
#define  nag_dspsv                                      f07pac /*  Mark  8  */ 
#define  nag_dspsvx                                     f07pbc /*  Mark  8  */ 
#define  nag_zhpsv                                      f07pnc /*  Mark  8  */ 
#define  nag_zhpsvx                                     f07ppc /*  Mark  8  */ 
#define  nag_zspsv                                      f07qnc /*  Mark  8  */ 
#define  nag_zspsvx                                     f07qpc /*  Mark  8  */ 
#define  nag_normal_pdf                                 g01kac /*  Mark  9  */
#define  nag_gamma_pdf                                  g01kfc /*  Mark  9  */
#define  nag_code_to_error_name                         x04ndc /*  Mark  9  */
#endif  /* not NAG_NAMES */

