/* <nagx04.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library x04 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2169 (Feb 1998).
 * Mark 6 revised. IER-3059 (July 2000).
 * Mark 6 revised. IER-3120 (September 2000).
 * Mark 7 revised. (August 2001).
 */
#ifndef NAGX04
#define NAGX04
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
#include "nag_stddef.h"	//this include used <name.h>, changed to "name.h"	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#include <stdio.h>

  /* Definitions */
#define MAX_FORMAT 81
#define X04_MAX_LINE 132
#define STD_LINE 80
#define OUTPUT_BUF_LEN (2*X04_MAX_LINE)
#define INTNL_FMT_LEN 15
  /* Length allowed for internally generated
   * format strings 
   */

  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL x04acc(const char *filename, Integer mode, Nag_FileID *fileid,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04adc(Nag_FileID fileid, NagError *fail);

  extern NAG_DLL_EXPIMP FILE * NAG_CALL x04aec(int argc, char *argv[], const char *flag, char **fname);

  extern NAG_DLL_EXPIMP void NAG_CALL x04bac(Nag_FileID fileid, const char *line);


  extern NAG_DLL_EXPIMP void NAG_CALL x04bbc(Nag_FileID fileid, char *line,
                                             Integer linelen, NagError *fail);

  extern NAG_DLL_EXPIMP Pointer NAG_CALL x04bcc(Pointer ptr, size_t newsize);

  extern NAG_DLL_EXPIMP void NAG_CALL x04bdc(Pointer *ptr);

  extern NAG_DLL_EXPIMP Pointer NAG_CALL x04bjc(size_t size);


  extern NAG_DLL_EXPIMP void NAG_CALL x04cac(
	      Nag_OrderType order, Nag_MatrixType Nmatrix, 
	      Nag_DiagType diag, Integer m,
	      Integer n, const double a[], Integer pda, const char *title,
	      const char *outfile, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL x04cbc(
	      Nag_OrderType order, Nag_MatrixType Nmatrix, 
	      Nag_DiagType diag, Integer m,
	      Integer n, const double a[], Integer pda, const char *format, 
	      const char *title, Nag_LabelType labrow, char **rlabs, 
	      Nag_LabelType labcol, char **clabs,
	      Integer ncols, Integer indent, const char *outfile, 
	      NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL x04ccc(
              Nag_OrderType order, Nag_UploType uplo, 
	      Nag_DiagType diag, Integer n, const double a[], 
              const char *title, const char *outfile, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL x04cdc(
              Nag_OrderType order, Nag_UploType uplo, 
              Nag_DiagType diag, Integer n, const double a[], const char *format, 
	      const char *title, Nag_LabelType labrow, char **rlabs, 
	      Nag_LabelType labcol, char **clabs, Integer ncols, 
	      Integer indent, const char *outfile,  NagError *fail);

  
  extern NAG_DLL_EXPIMP void NAG_CALL x04cec(
              Nag_OrderType order, Integer m, Integer n, 
	      Integer kl, Integer ku, const double ab[], 
	      Integer pda, const char *title, const char *outfile, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL x04cfc(
                     Nag_OrderType order, Integer m, Integer n, Integer kl, 
		     Integer ku, const double ab[], Integer pda, 
		     const char *format, const char *title, Nag_LabelType labrow, 
		     char **rlabs, Nag_LabelType labcol, char **clabs, 
		     Integer ncols, Integer indent, const char *outfile, 
                     NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL x04dac(
              Nag_OrderType order, Nag_MatrixType Nmatrix, 
	      Nag_DiagType diag, Integer m,
	      Integer n, const complex a[], Integer pda, const char *title,
	      const char *outfile, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL x04dbc(
              Nag_OrderType order, Nag_MatrixType Nmatrix, 
	      Nag_DiagType diag, Integer m,
	      Integer n, const complex a[], Integer pda, 
	      Nag_ComplexFormType cmplxform,
	      const char *format, const char *title, Nag_LabelType labrow, 
	      char **rlabs, Nag_LabelType labcol, char **clabs,
	      Integer ncols, Integer indent, const char *outfile, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL x04dcc(
            Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, 
	    Integer n, const complex a[], const char *title, 
            const char *outfile,  NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL x04ddc(
            Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, 
	    Integer n, const complex a[], Nag_ComplexFormType cmplxform,
	    const char *format, const char *title, Nag_LabelType labrow, 
	    char **rlabs, Nag_LabelType labcol, char **clabs, Integer ncols, 
	    Integer indent, const char *outfile, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL x04dec(
                     Nag_OrderType order, Integer m, Integer n, 
		     Integer kl, Integer ku, const complex ab[], 
		     Integer pda, const char *title, const char *outfile, 
                     NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL x04dfc(
                     Nag_OrderType order, Integer m, Integer n, Integer kl, 
		     Integer ku, const complex ab[], Integer pda, 
		     Nag_ComplexFormType cmplxform, const char *format, 
		     const char *title, Nag_LabelType labrow, char **rlabs, 
		     Nag_LabelType labcol, char **clabs, 
		     Integer ncols, Integer indent, const char *outfile, 
                     NagError *fail);

  extern NAG_DLL_EXPIMP int NAG_CALL x04mac(const char *enum_string);

  extern NAG_DLL_EXPIMP int NAG_CALL x04mbc(const char *error_name_string);

  extern NAG_DLL_EXPIMP char * NAG_CALL x04mcc(int enum_value, char *enum_string);

  extern NAG_DLL_EXPIMP int NAG_CALL x04nac(const char *enum_string);

  extern NAG_DLL_EXPIMP const char * NAG_CALL x04nbc(int enum_value);

  extern NAG_DLL_EXPIMP int NAG_CALL x04ncc(const char *error_name_string);

  extern NAG_DLL_EXPIMP const char * NAG_CALL x04ndc(int error_value);

#ifdef NAGLIBANDSTINCLUDE
#include <nagx04aux.h>
 #endif


  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGX04 */
