/* <nagm01.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library m01 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2165 (Feb 1998).
 * Mark 6 revised. IER-3053 (July 2000).
 */
#ifndef NAGM01
#define NAGM01
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
#include "nag_stddef.h"	//this include used <name.h>, changed to "name.h"	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#define SIZE_T_MAX 2147483647   /* maximum size_t value */
#define SIZE_T_BITS 32            /* no. of bits in size_t */
#define PTRDIFF_T_MAX (SIZE_T_MAX/2) /* maximum ptrdiff_t value */
#define MAX_LENGTH (PTRDIFF_T_MAX/sizeof(size_t)) /* maximum size of an array */
#define ELEMENT_SPACE 256         /* max. inline scratch element */
#define NAG_MCHAP_ERROR_BUF_LEN 20
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL m01cac(double vec[], size_t n, Nag_SortOrder order, NagError *fail);



  extern NAG_DLL_EXPIMP void NAG_CALL m01csc(Pointer vec, size_t n, size_t size, ptrdiff_t stride,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL m01ctc(Pointer vec, size_t n, size_t size, ptrdiff_t stride,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL m01cuc(Pointer *base, ptrdiff_t offset,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, NagError *fail);



  extern NAG_DLL_EXPIMP void NAG_CALL m01dsc(Pointer vec, size_t n, ptrdiff_t stride,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, size_t *rank, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL m01esc(Pointer vec, size_t n, size_t size, 
                                             ptrdiff_t stride, size_t *indices, NagError *fail);

  extern NAG_DLL_EXPIMP Nag_Boolean NAG_CALL m01fsc(Pointer key, Pointer vec, size_t n, ptrdiff_t stride,
                                                    NAG_M01_FUN compare,
                                                    Nag_SortOrder order, Nag_SearchMatch final, Pointer *match, NagError *fail);

  extern NAG_DLL_EXPIMP Integer NAG_CALL m01nac(Nag_Boolean valid, const double rv[], Integer m1, Integer m2, double item,
                                                    NagError *fail);
  
  extern NAG_DLL_EXPIMP Integer NAG_CALL m01nbc(Nag_Boolean valid, const Integer iv[], Integer m1, Integer m2,
                                                    Integer item, NagError *fail);

  extern NAG_DLL_EXPIMP Integer NAG_CALL m01ncc(Nag_Boolean valid, char *ch[], Integer m1,
                                                    Integer m2, const char * item, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL m01zac(size_t rank[], size_t n, NagError *fail);




#ifdef NAGLIBANDSTINCLUDE
#include <nagm01aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGM01 */
