/* <nagg08.h>
 *
 * Copyright 2000 Numerical Algorithms Group
 *
 * Include file for NAG C Library g05 Chapter
 *
 * Mark 6, 2000.
 */

#ifndef NAGG08
#define NAGG08
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL g08aac(Integer n, const double x[], const double y[], Integer *s,
                     double * p, Integer * non_tied, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08acc(Integer n1, const double x[], Integer n2, const double y[], Integer *above,
                     Integer *below, double *p, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08aec(Integer k, Integer n, const double x[], Integer tdx, 
                     double *fr, double *p, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08afc(Integer k, const Integer l[], const double x[], Integer lx, 
                     double *h, double *p, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08agc(Integer n, const double x[], double xme, Nag_TailProbability tail,
                     Nag_IncSignZeros zeros, double *rs, double *rsnor, double *p,
                     Integer *nz1, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08amc(Integer n1, const double x[], Integer n2, const double y[],
                     Nag_TailProbability tail, Nag_CompProb exact,
                     double *u, double *z, double *p, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08cbc(Integer n, const double x[], Nag_Distributions dist, double par[],
                     Nag_ParaEstimates estima, Nag_TestStatistics ntype, double *d,
                     double *z, double *p, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08cdc(Integer n1, const double x[], Integer n2, const double y[],
                     Nag_TestStatistics ntype, double * d, double * z, double * p,
                     NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08cgc(Integer k2, const Integer ifreq[], const double cint[],
                     Nag_Distributions dist, const double par[], Integer iparam,
                     const double prob[], double * chisq, double * p, Integer * ndf,
                     double eval[], double chisqi[],   NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08eac(Integer n, const double x[], Integer maxr, Integer *nruns, 
                     double *chi, double *df,
                     double *prob, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08ebc(Integer n, const double x[], Integer msize,
                     Integer lag, double *chi, double *df, double *p, 
                     NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08ecc(Integer n, const double x[], Integer msize, double *chi,
                     double *df, double *p, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08edc(Integer n, const double x[], Integer m,
                     Integer k, double rl, double ru, double til,
                     double *chi,
                     double *df, double *prob, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g08rac(Nag_OrderType order, Integer ns, const Integer nv[], const double y[], Integer p, const double x[], Integer nx, Integer idist, Integer nmax, double tol, double parvar[], Integer npvar, Integer irank[], double zin[], double eta[], double vapvec[], double parest[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g08rbc(Nag_OrderType order, Integer ns, const Integer nv[], const double y[], Integer p, const double x[], Integer nx, const Integer icen[], double gamma, Integer nmax, double tol, double parvar[], Integer npvar, Integer irank[], double zin[], double eta[], double vapvec[], double parest[], NagError *fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagg08aux.h>
 #endif
 

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG08 */
