/* <nagg07.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g07 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2158 (Feb 1998).
 * Mark 6 revised. IER-3045 (July 2000).
 */
#ifndef NAGG07
#define NAGG07
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */

  extern  NAG_DLL_EXPIMP void NAG_CALL g07aac(Integer n, Integer k, double clevel, double *pl, double *pu, NagError *fail);
 

  extern  NAG_DLL_EXPIMP void NAG_CALL g07abc(Integer n, double xmean, double clevel, double *tl, double *tu, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g07bbc(Nag_CEMethod method, Integer n, const double x[], const
					   double xc[], const Integer ic[], double *xmu, double *xsig,
					   double tol, Integer maxit, double *sexmu, double *sexsig,
					   double *corr, double *dev, Integer nobs[], Integer *nit,
					   NagError *fail);


  extern  NAG_DLL_EXPIMP void NAG_CALL g07bec(Nag_CestMethod cens, Integer n, const double x[],
					      const Integer ic[], double *beta, double *gamma, double tol,
					      Integer maxit, double *sebeta, double *segam, double *corr,
					      double *dev, Integer *nit, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g07bfc(Integer n, const double y[], Nag_OptimOpt optopt, double *xi, double *beta, double asvc[], double obsvc[], double *ll, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g07cac(Nag_TailProbability tail, Nag_PopVar equal,  Integer nx, Integer ny,
                                             double xmean, double ymean, double xstd,
                                             double ystd, double clevel, double *t, double *df,
                                             double *prob, double *dl, double *du,
                                             NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g07dac(Integer n, double x[], double y[], double *xme,
                                             double *xmd, double *xsd, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g07dbc(Nag_SigmaSimulEst sigma_est, Integer n,  double x[],  Nag_PsiFun psifun,
                                             double c, double h1, double h2, double h3,
                                             double dchi, double *theta, double *sigma,
                                             Integer maxit,  double tol, double rs[],  Integer *nit,
                                             double wrk[],  NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g07dcc(NAG_G07DCC_CHI, NAG_G07DCC_PSI,
                                             Integer isigma, Integer n,
                                             const double x[], double beta,
                                             double *theta, double *sigma,
                                             Integer maxit, double tol,
                                             double rs[], Integer *nit,
                                             Nag_Comm *comm, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g07ddc(Integer n,  double x[],
                                             double alpha, double *tmean,
                                             double *wmean, double *tvar,
                                             double *wvar, Integer *k,
                                             double sx[], NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g07eac(Nag_RCIMethod method, Integer n, const double x[],
			      double clevel, double *theta, double *thetal, double *thetau,
			      double *estcl, double *wlower, double *wupper, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g07ebc(Nag_RCIMethod method, Integer n, const double x[],
					     Integer m, const double y[], double clevel,
					     double *theta, double *thetal, double *thetau,
					     double *estcl, double *ulower, double *uupper, NagError *fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagg07aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG07 */


