/* <nagf07.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f07 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2154 (Feb 1998).
 * Mark 6 revised. IER-3037 (July 2000).
 */
#ifndef NAGF07
#define NAGF07
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */

extern NAG_DLL_EXPIMP void NAG_CALL f07aac(Nag_OrderType order, Integer n, Integer nrhs, double a[], Integer pda, Integer ipiv[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07acc(Nag_OrderType order, Integer n, Integer nrhs, double a[], Integer pda, Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, Integer *iter, NagError *fail); 

  /* Mark 8 additions */

extern NAG_DLL_EXPIMP void NAG_CALL f07adc(Nag_OrderType order, Integer m, Integer n, double a[], Integer pda, Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07aec(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const double a[], Integer pda, const Integer ipiv[], double b[], Integer pdb, NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07agc(Nag_OrderType order, Nag_NormType norm, Integer n, const double a[], Integer pda, double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07ahc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const double a[], Integer pda, const double af[], Integer pdaf, const Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07ajc(Nag_OrderType order, Integer n, double a[], Integer pda, const Integer ipiv[], NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07aqc(Nag_OrderType order, Integer n, Integer nrhs, complex a[], Integer pda, Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer ldx, Integer *iter, NagError *fail); 

extern NAG_DLL_EXPIMP void NAG_CALL f07arc(Nag_OrderType order, Integer m, Integer n, complex a[], Integer pda, Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07asc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const complex a[], Integer pda, const Integer ipiv[], complex b[], Integer pdb, NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07auc(Nag_OrderType order, Nag_NormType norm, Integer n, const complex a[], Integer pda, double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07avc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const complex a[], Integer pda, const complex af[], Integer pdaf, const Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07awc(Nag_OrderType order, Integer n, complex a[], Integer pda, const Integer ipiv[], NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07bdc(Nag_OrderType order, Integer m, Integer n, Integer kl, Integer ku, double ab[], Integer pdab, Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07bec(Nag_OrderType order, Nag_TransType trans, Integer n, Integer kl, Integer ku, Integer nrhs, const double ab[], Integer pdab, const Integer ipiv[], double b[], Integer pdb, NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07bgc(Nag_OrderType order, Nag_NormType norm, Integer n, Integer kl, Integer ku, const double ab[], Integer pdab, const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07bhc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer kl, Integer ku, Integer nrhs, const double ab[], Integer pdab, const double afb[], Integer pdafb, const Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07brc(Nag_OrderType order, Integer m, Integer n, Integer kl, Integer ku, complex ab[], Integer pdab, Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07bsc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer kl, Integer ku, Integer nrhs, const complex ab[], Integer pdab, const Integer ipiv[], complex b[], Integer pdb, NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07buc(Nag_OrderType order, Nag_NormType norm, Integer n, Integer kl, Integer ku, const complex ab[], Integer pdab, const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07bvc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer kl, Integer ku, Integer nrhs, const complex ab[], Integer pdab, const complex afb[], Integer pdafb, const Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07fdc(Nag_OrderType order, Nag_UploType uplo, Integer n, double a[], Integer pda, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fec(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double a[], Integer pda, double b[], Integer pdb, NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07fgc(Nag_OrderType order, Nag_UploType uplo, Integer n, const double a[], Integer pda, double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fhc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double a[], Integer pda, const double af[], Integer pdaf, const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fjc(Nag_OrderType order, Nag_UploType uplo, Integer n, double a[], Integer pda, NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07frc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex a[], Integer pda, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fsc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex a[], Integer pda, complex b[], Integer pdb, NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07fuc(Nag_OrderType order, Nag_UploType uplo, Integer n, const complex a[], Integer pda, double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fvc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex a[], Integer pda, const complex af[], Integer pdaf, const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fwc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex a[], Integer pda, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gdc(Nag_OrderType order, Nag_UploType uplo, Integer n, double ap[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gec(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double ap[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07ggc(Nag_OrderType order, Nag_UploType uplo, Integer n, const double ap[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07ghc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double ap[], const double afp[], const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gjc(Nag_OrderType order, Nag_UploType uplo, Integer n, double ap[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07grc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex ap[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07gsc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex ap[], complex b[], Integer pdb, NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07guc(Nag_OrderType order, Nag_UploType uplo, Integer n, const complex ap[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gvc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex ap[], const complex afp[], const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gwc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex ap[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07hdc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, double ab[], Integer pdab, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hec(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, const double ab[], Integer pdab, double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hgc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, const double ab[], Integer pdab, double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hhc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, const double ab[], Integer pdab, const double afb[], Integer pdafb, const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07hrc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, complex ab[], Integer pdab, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hsc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, const complex ab[], Integer pdab, complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07huc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, const complex ab[], Integer pdab, double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hvc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, const complex ab[], Integer pdab, const complex afb[], Integer pdafb, const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mdc(Nag_OrderType order, Nag_UploType uplo, Integer n, double a[], Integer pda, Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mec(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double a[], Integer pda, const Integer ipiv[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mgc(Nag_OrderType order, Nag_UploType uplo, Integer n, const double a[], Integer pda, const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mhc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double a[], Integer pda, const double af[], Integer pdaf, const Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mjc(Nag_OrderType order, Nag_UploType uplo, Integer n, double a[], Integer pda, const Integer ipiv[], NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07mrc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex a[], Integer pda, Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07msc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex a[], Integer pda, const Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07muc(Nag_OrderType order, Nag_UploType uplo, Integer n, const complex a[], Integer pda, const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mvc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex a[], Integer pda, const complex af[], Integer pdaf, const Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mwc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex a[], Integer pda, const Integer ipiv[], NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07nrc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex a[], Integer pda, Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07nsc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex a[], Integer pda, const Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07nuc(Nag_OrderType order, Nag_UploType uplo, Integer n, const complex a[], Integer pda, const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07nvc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex a[], Integer pda, const complex af[], Integer pdaf, const Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07nwc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex a[], Integer pda, const Integer ipiv[], NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07pdc(Nag_OrderType order, Nag_UploType uplo, Integer n, double ap[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07pec(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double ap[], const Integer ipiv[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07pgc(Nag_OrderType order, Nag_UploType uplo, Integer n, const double ap[], const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07phc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double ap[], const double afp[], const Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07pjc(Nag_OrderType order, Nag_UploType uplo, Integer n, double ap[], const Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07prc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex ap[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07psc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex ap[], const Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07puc(Nag_OrderType order, Nag_UploType uplo, Integer n, const complex ap[], const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07pvc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex ap[], const complex afp[], const Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07pwc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex ap[], const Integer ipiv[], NagError *fail);
 
extern NAG_DLL_EXPIMP void NAG_CALL f07qrc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex ap[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07qsc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex ap[], const Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07quc(Nag_OrderType order, Nag_UploType uplo, Integer n, const complex ap[], const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07qvc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const complex ap[], const complex afp[], const Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07qwc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex ap[], const Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07tec(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const double a[], Integer pda, double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07tgc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Nag_DiagType diag, Integer n, const double a[], Integer pda, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07thc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const double a[], Integer pda, const double b[], Integer pdb, const double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07tjc(Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, Integer n, double a[], Integer pda, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07tsc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const complex a[], Integer pda, complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07tuc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Nag_DiagType diag, Integer n, const complex a[], Integer pda, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07tvc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const complex a[], Integer pda, const complex b[], Integer pdb, const complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07twc(Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, Integer n, complex a[], Integer pda, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07uec(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const double ap[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07ugc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Nag_DiagType diag, Integer n, const double ap[], double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07uhc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const double ap[], const double b[], Integer pdb, const double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07ujc(Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, Integer n, double ap[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07usc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const complex ap[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07uuc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Nag_DiagType diag, Integer n, const complex ap[], double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07uvc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const complex ap[], const complex b[], Integer pdb, const complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07uwc(Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, Integer n, complex ap[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07vec(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer kd, Integer nrhs, const double ab[], Integer pdab, double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07vgc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Nag_DiagType diag, Integer n, Integer kd, const double ab[], Integer pdab, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07vhc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer kd, Integer nrhs, const double ab[], Integer pdab, const double b[], Integer pdb, const double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07vsc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer kd, Integer nrhs, const complex ab[], Integer pdab, complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07vuc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Nag_DiagType diag, Integer n, Integer kd, const complex ab[], Integer pdab, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07vvc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer kd, Integer nrhs, const complex ab[], Integer pdab, const complex b[], Integer pdb, const complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

  /* Mark 9 additions */
extern NAG_DLL_EXPIMP void NAG_CALL f07abc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_TransType trans, Integer n, Integer nrhs, double a[], Integer pda, double af[], Integer pdaf, Integer ipiv[], Nag_EquilibrationType *equed, double r[], double c[], double b[], Integer pdb, double x[], Integer pdx, double *rcond, double ferr[], double berr[], double *recip_growth_factor, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07afc(Nag_OrderType order, Integer m, Integer n, const double a[], Integer pda, double r[], double c[], double *rowcnd, double *colcnd, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07anc(Nag_OrderType order, Integer n, Integer nrhs, complex a[], Integer pda, Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07apc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_TransType trans, Integer n, Integer nrhs, complex a[], Integer pda, complex af[], Integer pdaf, Integer ipiv[], Nag_EquilibrationType *equed, double r[], double c[], complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], double *recip_growth_factor, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07atc(Nag_OrderType order, Integer m, Integer n, const complex a[], Integer pda, double r[], double c[], double *rowcnd, double *colcnd, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07bac(Nag_OrderType order, Integer n, Integer kl, Integer ku, Integer nrhs, double ab[], Integer pdab, Integer ipiv[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07bbc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_TransType trans, Integer n, Integer kl, Integer ku, Integer nrhs, double ab[], Integer pdab, double afb[], Integer pdafb, Integer ipiv[], Nag_EquilibrationType *equed, double r[], double c[], double b[], Integer pdb, double x[], Integer pdx, double *rcond, double ferr[], double berr[], double *recip_growth_factor, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07bfc(Nag_OrderType order, Integer m, Integer n, Integer kl, Integer ku, const double ab[], Integer pdab, double r[], double c[], double *rowcnd, double *colcnd, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07bnc(Nag_OrderType order, Integer n, Integer kl, Integer ku, Integer nrhs, complex ab[], Integer pdab, Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07bpc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_TransType trans, Integer n, Integer kl, Integer ku, Integer nrhs, complex ab[], Integer pdab, complex afb[], Integer pdafb, Integer ipiv[], Nag_EquilibrationType *equed, double r[], double c[], complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], double *recip_growth_factor, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07btc(Nag_OrderType order, Integer m, Integer n, Integer kl, Integer ku, const complex ab[], Integer pdab, double r[], double c[], double *rowcnd, double *colcnd, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cac(Nag_OrderType order, Integer n, Integer nrhs, double dl[], double d[], double du[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cbc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_TransType trans, Integer n, Integer nrhs, const double dl[], const double d[], const double du[], double dlf[], double df[], double duf[], double du2[], Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cdc(Integer n, double dl[], double d[], double du[], double du2[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cdc(Integer n, double dl[], double d[], double du[], double du2[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cec(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const double dl[], const double d[], const double du[], const double du2[], const Integer ipiv[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cdc(Integer n, double dl[], double d[], double du[], double du2[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cgc(Nag_NormType norm, Integer n, const double dl[], const double d[], const double du[], const double du2[], const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cdc(Integer n, double dl[], double d[], double du[], double du2[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cec(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const double dl[], const double d[], const double du[], const double du2[], const Integer ipiv[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07chc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const double dl[], const double d[], const double du[], const double dlf[], const double df[], const double duf[], const double du2[], const Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cnc(Nag_OrderType order, Integer n, Integer nrhs, complex dl[], complex d[], complex du[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cpc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_TransType trans, Integer n, Integer nrhs, const complex dl[], const complex d[], const complex du[], complex dlf[], complex df[], complex duf[], complex du2[], Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07crc(Integer n, complex dl[], complex d[], complex du[], complex du2[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07crc(Integer n, complex dl[], complex d[], complex du[], complex du2[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07csc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const complex dl[], const complex d[], const complex du[], const complex du2[], const Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07crc(Integer n, complex dl[], complex d[], complex du[], complex du2[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cuc(Nag_NormType norm, Integer n, const complex dl[], const complex d[], const complex du[], const complex du2[], const Integer ipiv[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07crc(Integer n, complex dl[], complex d[], complex du[], complex du2[], Integer ipiv[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07csc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const complex dl[], const complex d[], const complex du[], const complex du2[], const Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07cvc(Nag_OrderType order, Nag_TransType trans, Integer n, Integer nrhs, const complex dl[], const complex d[], const complex du[], const complex dlf[], const complex df[], const complex duf[], const complex du2[], const Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fac(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, double a[], Integer pda, double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fbc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, double a[], Integer pda, double af[], Integer pdaf, Nag_EquilibrationType *equed, double s[], double b[], Integer pdb, double x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07ffc(Nag_OrderType order, Integer n, const double a[], Integer pda, double s[], double *scond, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fnc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex a[], Integer pda, complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07fpc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, complex a[], Integer pda, complex af[], Integer pdaf, Nag_EquilibrationType *equed, double s[], complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07ftc(Nag_OrderType order, Integer n, const complex a[], Integer pda, double s[], double *scond, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gac(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, double ap[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gbc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, double ap[], double afp[], Nag_EquilibrationType *equed, double s[], double b[], Integer pdb, double x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gfc(Nag_OrderType order, Nag_UploType uplo, Integer n, const double ap[], double s[], double *scond, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gnc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex ap[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gpc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, complex ap[], complex afp[], Nag_EquilibrationType *equed, double s[], complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07gtc(Nag_OrderType order, Nag_UploType uplo, Integer n, const complex ap[], double s[], double *scond, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hac(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, double ab[], Integer pdab, double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hbc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, double ab[], Integer pdab, double afb[], Integer pdafb, Nag_EquilibrationType *equed, double s[], double b[], Integer pdb, double x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hfc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, const double ab[], Integer pdab, double s[], double *scond, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hnc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, complex ab[], Integer pdab, complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07hpc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, complex ab[], Integer pdab, complex afb[], Integer pdafb, Nag_EquilibrationType *equed, double s[], complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07htc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, const complex ab[], Integer pdab, double s[], double *scond, double *amax, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jac(Nag_OrderType order, Integer n, Integer nrhs, double d[], double e[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jbc(Nag_OrderType order, Nag_FactoredFormType fact, Integer n, Integer nrhs, const double d[], const double e[], double df[], double ef[], const double b[], Integer pdb, double x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jdc(Integer n, double d[], double e[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jdc(Integer n, double d[], double e[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jec(Nag_OrderType order, Integer n, Integer nrhs, const double d[], const double e[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jdc(Integer n, double d[], double e[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jgc(Integer n, const double d[], const double e[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jdc(Integer n, double d[], double e[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jec(Nag_OrderType order, Integer n, Integer nrhs, const double d[], const double e[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jhc(Nag_OrderType order, Integer n, Integer nrhs, const double d[], const double e[], const double df[], const double ef[], const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jnc(Nag_OrderType order, Integer n, Integer nrhs, double d[], complex e[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jpc(Nag_OrderType order, Nag_FactoredFormType fact, Integer n, Integer nrhs, const double d[], const complex e[], double df[], complex ef[], const complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jrc(Integer n, double d[], complex e[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jrc(Integer n, double d[], complex e[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jsc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double d[], const complex e[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jrc(Integer n, double d[], complex e[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07juc(Integer n, const double d[], const complex e[], double anorm, double *rcond, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jrc(Integer n, double d[], complex e[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jsc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double d[], const complex e[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07jvc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, const double d[], const complex e[], const double df[], const complex ef[], const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mac(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, double a[], Integer pda, Integer ipiv[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mbc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, const double a[], Integer pda, double af[], Integer pdaf, Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mnc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex a[], Integer pda, Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07mpc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, const complex a[], Integer pda, complex af[], Integer pdaf, Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07nnc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex a[], Integer pda, Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07npc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, const complex a[], Integer pda, complex af[], Integer pdaf, Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07pac(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, double ap[], Integer ipiv[], double b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07pbc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, const double ap[], double afp[], Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07pnc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex ap[], Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07ppc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, const complex ap[], complex afp[], Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07qnc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex ap[], Integer ipiv[], complex b[], Integer pdb, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f07qpc(Nag_OrderType order, Nag_FactoredFormType fact, Nag_UploType uplo, Integer n, Integer nrhs, const complex ap[], complex afp[], Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, double *rcond, double ferr[], double berr[], NagError *fail);



#ifdef NAGLIBANDSTINCLUDE
#include <nagf07aux.h>
 #endif
 

  /* End Mark 8 additions */
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF07 */
