/* <nagf06.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f06 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2153 (Feb 1998).
 * Mark 6 revised. IER-3036 (July 2000).
 */
#ifndef NAGF06
#define NAGF06
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */










  extern NAG_DLL_EXPIMP double NAG_CALL f06eac(Integer n, const double *x, Integer incx, const double *y, Integer incy);








  extern NAG_DLL_EXPIMP void NAG_CALL f06efc(Integer n, const double *x, Integer incx, double *y, Integer incy);














  extern NAG_DLL_EXPIMP void NAG_CALL f06fdc(Integer n, double alpha, double *x, Integer incx,
                     double *y, Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06fec(Integer n, double alpha, double x[], Integer incx);





























  extern NAG_DLL_EXPIMP void NAG_CALL f06kec(Integer n, double alpha, complex x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06pac(MatrixTranspose Trans, Integer m, Integer n, 
                                             double alpha, const double a[], Integer tda, const double x[],
                                             Integer incx, double beta, double y[], Integer incy);


  extern NAG_DLL_EXPIMP void NAG_CALL f06pbc(MatrixTranspose trans, Integer m, Integer n, Integer kl, 
                                             Integer ku, double alpha, const double a[], Integer tda,
                                             const double x[], Integer incx, double beta, double y[], 
                                             Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06pcc(MatrixTriangle UpperLower, Integer n, double alpha, 
                                             const double a[], Integer tda, const double x[], 
                                             Integer incx, double beta, double y[], Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06pdc(MatrixTriangle uplo, Integer n, Integer k, double alpha, 
                                             const double a[], Integer tda, const double x[], Integer incx,
                                             double beta, double y[], Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06pec(MatrixTriangle UpperLower, Integer n, double alpha, 
                                             const double ap[], const double x[], Integer incx, 
                                             double beta, double y[], Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06pfc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n,
                                             const double a[], Integer tda, double x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06pgc(MatrixTriangle uplo, MatrixTranspose trans, 
                                             MatrixUnitTriangular diag, Integer n, Integer k, 
                                             const double a[], Integer tda, double x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06phc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const double ap[], 
                                             double x[], Integer incx);




  extern NAG_DLL_EXPIMP void NAG_CALL f06pjc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n, const double a[],
                                             Integer tda, double x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06pkc(MatrixTriangle uplo, MatrixTranspose trans,
                                             MatrixUnitTriangular diag, Integer n, Integer k,
                                             const double a[], Integer tda, double x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06plc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const double ap[], 
                                             double x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06pmc(Integer m, Integer n, double alpha, const double x[],
                                             Integer incx, const double y[], Integer incy, 
                                             double a[], Integer tda);

  extern NAG_DLL_EXPIMP void NAG_CALL f06ppc(MatrixTriangle uplo, Integer n, double alpha, const double x[],
                                             Integer incx, double a[], Integer tda);

  extern NAG_DLL_EXPIMP void NAG_CALL f06pqc(MatrixTriangle uplo, Integer n, double alpha,
                                             const double x[], Integer incx, double ap[]);

  extern NAG_DLL_EXPIMP void NAG_CALL f06prc(MatrixTriangle UpperLower, Integer n, double alpha, 
                                             const double x[], Integer incx, const double y[], Integer incy,
                                             double a[], Integer tda);

  extern NAG_DLL_EXPIMP void NAG_CALL f06psc(MatrixTriangle UpperLower, Integer n, double alpha, 
                                             const double x[], Integer incx, const double y[], 
                                             Integer incy, double ap[]);










  extern NAG_DLL_EXPIMP void NAG_CALL f06sac(MatrixTranspose Trans, Integer m, Integer n, 
                                             complex alpha, const complex a[], Integer tda, const complex x[],
                                             Integer incx, complex beta, complex y[], Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06sbc(MatrixTranspose trans, Integer m, Integer n, Integer kl, 
                                             Integer ku, complex alpha, const complex a[], Integer tda,
                                             const complex x[], Integer incx, complex beta, 
                                             complex y[], Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06scc(MatrixTriangle UpperLower, Integer n, complex alpha,
                                             const complex a[], Integer tda, const complex x[], 
                                             Integer incx, complex beta, complex y[], Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06sdc(MatrixTriangle uplo, Integer n, Integer k, complex alpha, 
                                             const complex a[], Integer tda, const complex x[], Integer incx, 
                                             complex beta, complex y[], Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06sec(MatrixTriangle UpperLower, Integer n, complex alpha, 
                                             const complex ap[], const complex x[], Integer incx, 
                                             complex beta, complex y[], Integer incy);

  extern NAG_DLL_EXPIMP void NAG_CALL f06sfc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n, 
                                             const complex a[], Integer tda, complex x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06sgc(MatrixTriangle uplo, MatrixTranspose trans, 
                                             MatrixUnitTriangular diag, Integer n, Integer k, 
                                             const complex a[], Integer tda, complex x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06shc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const complex ap[],
                                             complex x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06sjc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n, 
                                             const complex a[], Integer tda, complex x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06skc(MatrixTriangle uplo, MatrixTranspose trans,
                                             MatrixUnitTriangular diag, Integer n, Integer k,
                                             const complex a[], Integer tda, complex x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06slc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const complex ap[],
                                             complex x[], Integer incx);

  extern NAG_DLL_EXPIMP void NAG_CALL f06smc(Integer m, Integer n, complex alpha, const complex x[], 
                                             Integer incx, const complex y[], Integer incy, 
                                             complex a[], Integer tda);

  extern NAG_DLL_EXPIMP void NAG_CALL f06snc(Integer m, Integer n, complex alpha, const complex x[], 
                                             Integer incx, const complex y[], Integer incy, complex a[],
                                             Integer tda);

  extern NAG_DLL_EXPIMP void NAG_CALL f06spc(MatrixTriangle uplo, Integer n, double alpha, 
                                             const complex x[], Integer incx, complex a[], Integer tda);

  extern NAG_DLL_EXPIMP void NAG_CALL f06sqc(MatrixTriangle uplo, Integer n, double alpha,
                                             const complex x[], Integer incx, complex ap[]);

  extern NAG_DLL_EXPIMP void NAG_CALL f06src(MatrixTriangle UpperLower, Integer n, complex alpha, 
                                             const complex x[], Integer incx, const complex y[],
                                             Integer incy, complex a[], Integer tda);

  extern NAG_DLL_EXPIMP void NAG_CALL f06ssc(MatrixTriangle UpperLower, Integer n, complex alpha, 
                                             const complex x[], Integer incx, const complex y[], 
                                             Integer incy, complex ap[]);







  extern NAG_DLL_EXPIMP void NAG_CALL f06yac(MatrixTranspose transa, MatrixTranspose transb,
                                             Integer m, Integer n,
                                             Integer k, double alpha, const double a[], Integer tda,
                                             const double b[], Integer tdb, double beta,
                                             double c[], Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06ycc(OperationSide side, MatrixTriangle uplo, Integer m, Integer n,
                                             double alpha, const double a[], Integer tda, const double b[],
                                             Integer tdb, double beta, double c[], Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06yfc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, double alpha, 
                                             const double a[], Integer tda, double b[], Integer tdb);

  extern NAG_DLL_EXPIMP void NAG_CALL f06yjc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, double alpha, 
                                             const double a[], Integer tda, double b[], Integer tdb);

  extern NAG_DLL_EXPIMP void NAG_CALL f06ypc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             double alpha, const double a[], Integer tda,
                                             double beta, double c[], Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06yrc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             double alpha, const double a[], Integer tda, const double b[],
                                             Integer tdb, double beta, double c[], Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06zac(MatrixTranspose transa, MatrixTranspose transb,
                                             Integer m, Integer n,
                                             Integer k, complex alpha, const complex a[], Integer tda,
                                             const complex b[], Integer tdb, complex beta,
                                             complex c[], Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06zcc(OperationSide side, MatrixTriangle uplo, Integer m, Integer n,
                                             complex alpha, const complex a[], Integer tda, const complex b[],
                                             Integer tdb, complex beta, complex c[], Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06zfc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, complex alpha, 
                                             const complex a[], Integer tda, complex b[], Integer tdb);

  extern NAG_DLL_EXPIMP void NAG_CALL f06zjc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, complex alpha, 
                                             const complex a[], Integer tda, complex b[], Integer tdb);

  extern NAG_DLL_EXPIMP void NAG_CALL f06zpc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             double alpha, const complex a[], Integer tda,
                                             double beta, complex c[], Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06zrc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             complex alpha, const complex a[], Integer tda, 
                                             const complex b[], Integer tdb, double beta, complex c[], 
                                             Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06ztc(OperationSide side, MatrixTriangle uplo, Integer m, Integer n,
                                             complex alpha, const complex a[], Integer tda, const complex b[],
                                             Integer tdb, complex beta, complex c[], Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06zuc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             complex alpha, const complex a[], Integer tda,
                                             complex beta, complex c[], Integer tdc);

  extern NAG_DLL_EXPIMP void NAG_CALL f06zwc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             complex alpha, const complex a[], Integer tda, 
                                             const complex b[], Integer tdb, complex beta, complex c[], 
                                             Integer tdc);


#ifdef NAGLIBANDSTINCLUDE
#include <nagf06aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF06 */
