/* <nagd02.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library d02 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2145 (Feb 1998).
 * Mark 6 revised. IER-3027 (July 2000).
 */
#ifndef NAGD02
#define NAGD02
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* Note :
   * d02qfg is called only by d02qfv.
   * A subsection of the original d02qfv was placed in
   * this external function to allow compilation on PC's.
   */
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL d02cjc(Integer neq, 
                                             NAG_D02CJC_FUN fcn,
                                             double *t, double y[], double tend,
                                             double tol, Nag_ErrorControl err_c,
                                             NAG_D02CJC_OUTFUN output,
                                             NAG_D02CJC_GFUN g,
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02ejc(Integer neq, NAG_D02EJC_FUN fcn,
                                             NAG_D02EJC_PFUN pederv,
                                             double *t, double y[], double tend, 
                                             double tol, Nag_ErrorControl err_c,
                                             NAG_D02EJC_OUTFUN output, NAG_D02EJC_GFUN g,
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02gac(Integer neq, 
                                             NAG_D02GAC_FUN fcn,
                                             double a, double b, double u[], Integer v[],
                                             Integer mnp, Integer *np, double x[], double y[],
                                             double tol, Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02gbc(Integer neq, 
                                             NAG_D02GBC_FUN fcnf,
                                             NAG_D02GBC_GFUN fcng,
                                             double a, double b, double c[], double d[], double gam[],
                                             Integer mnp, Integer *np, double x[], double y[], double tol,
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02mcc(Integer icom[]);

  extern NAG_DLL_EXPIMP void NAG_CALL d02mwc(Integer neq, Integer maxord, Nag_EvaluateJacobian jceval, 
                                             double hmax, double h0, Nag_Boolean vector_tol, 
                                             Integer icom[], Integer licom, double com[], 
                                             Integer lcom, NagError *fail); 

  /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
  typedef void (NAG_CALL *PFN_d02nec_res)(Integer neq, double t, const double y[], const double ydot[], double r[], Integer *ires, Nag_Comm *comm);
  typedef void (NAG_CALL *PFN_d02nec_jac)(Integer neq, double t, const double y[], const double ydot[], double pd[], double cj, Nag_Comm *comm);
  /// end NAG_HEADERS_OC_COMPILE

  extern NAG_DLL_EXPIMP void NAG_CALL d02nec(Integer neq, double *t, double tout, double y[], double ydot[],
					     double rtol[], double atol[], Integer *itask,
						 /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
					     //void (NAG_CALL *res)(Integer neq, double t, const double y[], const double ydot[], double r[], Integer *ires, Nag_Comm *comm),
					     //void (NAG_CALL *jac)(Integer neq, double t, const double y[], const double ydot[], double pd[], double cj, Nag_Comm *comm),
					     PFN_d02nec_res res, PFN_d02nec_jac jac,
						 /// end NAG_HEADERS_OC_COMPILE
					     Integer icom[], double com[], Integer lcom, Nag_Comm *comm,
					     NagError *fail); 


  extern NAG_DLL_EXPIMP void NAG_CALL d02npc(Integer neq, Integer ml, Integer mu, Integer icom[],
                                             Integer licom, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02pcc(Integer neq, NAG_D02PCC_FUN f, double twant, double *tgot,
                                             double ygot[], double ypgot[], double ymax[], Nag_ODE_RK *opt, 
                                             Nag_User *comm, NagError * fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02pdc(Integer neq,
                                             NAG_D02PCC_FUN f,
                                             double *tnow, double ynow[],
                                             double ypnow[], Nag_ODE_RK *opt, Nag_User *comm,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02ppc(Nag_ODE_RK *opt);

  extern NAG_DLL_EXPIMP void NAG_CALL d02pvc(Integer neq, double tstart, double ystart[],
                                             double tend, double tol, double thres[],
                                             Nag_RK_method method, Nag_RK_task task, Nag_ErrorAssess errass,
                                             double hstart, Nag_ODE_RK *opt, NagError * fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02pwc(double tend_new, Nag_ODE_RK *opt, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02pxc(Integer neq, double twant, Nag_SolDeriv reqest, Integer nwant,
                                             double ywant[], double ypwant[],
                                             NAG_D02PDC_FUN f,
                                             Nag_ODE_RK *opt, Nag_User *comm, NagError *fail);



  extern NAG_DLL_EXPIMP void NAG_CALL d02pzc(Integer neq, double rmserr[], double *errmax, double *terrmx,
                                             Nag_ODE_RK *opt, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02qfc(Integer neqf, 
                                             NAG_D02QFC_FUN fcn,
                                             double *t, double y[], double tout,
                                             NAG_D02QFC_GFUN g,
                                             Nag_User *comm, Nag_ODE_Adams *opt, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02qwc(Nag_Start *state, Integer neqf, Nag_Boolean vectol, double a_tol[],
                                             double rtol[], Nag_Boolean onestp, Nag_Boolean crit, double tcrit,
                                             double hmax, Integer maxstp, Integer neqg, Nag_Boolean *alterg,
                                             Nag_Boolean sophst, Nag_ODE_Adams *opt, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02qyc(Nag_ODE_Adams *opt);

  extern NAG_DLL_EXPIMP void NAG_CALL d02qzc(Integer neqf, double twant, Integer nwant,
                                             double ywant[], double ypwant[], Nag_ODE_Adams *opt,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d02rac(Integer neq, double *deleps,
                                             NAG_D02RAC_FUN fcn,
                                             Integer numbeg, Integer nummix,
                                             NAG_D02RAC_GFUN g,
                                             Nag_MeshSet init, Integer mnp, Integer * np, double x[],
                                             double y[], 
                                             double tol, double abt[],
                                             NAG_D02RAC_JFUN jacobf,
                                             NAG_D02RAC_JGFUN jacobg,            
                                             NAG_D02RAC_JEPSFUN jaceps,
                                             NAG_D02RAC_JGEPSFUN jacgep,
                                             Nag_User *comm,
                                             NagError * fail);




#ifdef NAGLIBANDSTINCLUDE
#include <nagd02aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGD02 */
