/* <nagd01.h>
   *
   * Copyright 1996 Numerical Algorithms Group
   *
   * Include file for NAG C Library d01 Chapter
   *
   * Mark 4, revised, 1996.
   * Mark 5 revised. IER-2144 (Feb 1998).
   * Mark 6 revised. IER-3068 (Aug 2000).
   */
#ifndef NAGD01
#define NAGD01
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL d01ajc(NAG_D01AJC_FUN f , double a, double b, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01akc(NAG_D01AKC_FUN f, double a, double b, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01alc(NAG_D01ALC_FUN f, double a, double b, 
                                             Integer nbrkpts, double brkpts[], double epsabs,
                                             double epsrel, Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01amc(NAG_D01AMC_FUN f, Nag_BoundInterval boundinf, double bound, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01anc(NAG_D01ANC_FUN g, double a, double b, 
                                             double omega, Nag_TrigTransform wt_func, double epsabs,
                                             double epsrel, Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp,  NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01apc(NAG_D01APC_FUN g, double a, double b, 
                                             double alfa, double beta, Nag_QuadWeight  wt_func,
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01aqc(NAG_D01AQC_FUN g, double a, double b, 
                                             double c, double epsabs, double epsrel,
                                             Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01asc(NAG_D01ASC_FUN g, double a, 
                                             double omega, Nag_TrigTransform wt_func,
                                             Integer maxintervals,
                                             Integer maxsubint_per_int,
                                             double epsabs,
                                             double *result, double *abserr,
                                             Nag_QuadSubProgress *qpsub,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL d01bac(Nag_GaussFormulae quadrule, NAG_D01BAC_FUN fun,
                                               double a, double b, Integer npts, NagError *fail);



  extern NAG_DLL_EXPIMP void NAG_CALL d01fcc(Integer ndim, NAG_D01FCC_FUN functn, double a[], 
                                             double b[], Integer *minpts, Integer maxpts,  double eps,
                                             double *finval, double *acc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01gac(Integer n, double x[], double y[], double *ans,
                                             double *er, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01gbc(Integer numvar, NAG_D01GBC_FUN functn, 
                                             Nag_MCMethod method, Nag_Start cont, double a[], double b[],
                                             Integer *minpts, Integer maxpts, double releps, double *finval,
                                             double *relerr, double **wrkstr, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01sjc(NAG_D01SJC_FUN f , double a, double b, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01skc(NAG_D01SKC_FUN f, double a, double b, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01slc(NAG_D01SLC_FUN f, double a, double b, 
                                             Integer nbrkpts, double brkpts[], double epsabs,
                                             double epsrel, Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp, 
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01smc(NAG_D01SMC_FUN f, Nag_BoundInterval boundinf, double bound, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01snc(NAG_D01SNC_FUN g, double a, double b, 
                                             double omega, Nag_TrigTransform wt_func, double epsabs,
                                             double epsrel, Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01spc(NAG_D01SPC_FUN g, double a, double b, 
                                             double alfa, double beta, Nag_QuadWeight  wt_func,
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01sqc(NAG_D01SQC_FUN g, double a, double b, 
                                             double c, double epsabs, double epsrel,
                                             Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp, 
                                             Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01ssc(NAG_D01SSC_FUN g, double a, 
                                             double omega, Nag_TrigTransform wt_func,
                                             Integer maxintervals,
                                             Integer maxsubint_per_int,
                                             double epsabs,
                                             double *result, double *abserr,
                                             Nag_QuadSubProgress *qpsub, Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL d01tac(Nag_GaussFormulae quadrule, NAG_D01TAC_FUN fun,
                                               double a, double b, Integer npts, Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01wcc(Integer ndim, NAG_D01WCC_FUN functn, double a[], 
                                             double b[], Integer *minpts, Integer maxpts,  double eps,
                                             double *finval, double *acc, Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL d01xbc(Integer numvar, NAG_D01XBC_FUN functn, 
                                             Nag_MCMethod method, Nag_Start cont, double a[], double b[],
                                             Integer *minpts, Integer maxpts, double releps, double *finval,
                                             double *relerr, double **wrkstr, 
                                             Nag_User *comm, NagError *fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagd01aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGD01 */
