/* <nagc06.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library c06 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2143 (Feb 1998).
 * Mark 6 revised. IER-3025 (July 2000).
 */
#ifndef NAGC06
#define NAGC06
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* The following defines are for stringents only */
#define NUMFAC 20   /* Limit on number of prime factors in n, used in c06eac,    */
  /* c06ebc, c06ecc, c06ekc. To test error exits in stringents */
  /* NUMFAC may need to be set to a value of 9 or less as      */
  /* array sizes to test n with 20 or more factors may be      */
  /* too large for compiler.                                   */
  /* (n with 20 factors is at least 1048576)                   */
#define C06_STRINGENT_SIZE 1024  /* Array size for stringent programs c06eac,    */
  /* c06ecc, c06ekc. Change for values of n       */
  /* larger than 1024. If set lower than 1024     */
  /* amend data file to remove values of n higher */
  /* than C06_STRINGENT_SIZE.                     */
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL c06eac(Integer pts, double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06ebc(Integer pts, double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06ecc(Integer pts, double x[], double y[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06ekc(Nag_VectorOp Operation, Integer n, double x[], double y[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06fpc(Integer m, Integer n, double x[], double trig[], NagError *fail);



  extern NAG_DLL_EXPIMP void NAG_CALL c06fqc(Integer m, Integer n, double x[], double trig[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06frc(Integer m, Integer n, double x[], double y[], double trig[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06fuc(Integer m, Integer n, double x[], double y[], double trigm[],
                                             double trign[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06gbc(Integer n, double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06gcc(Integer n, double y[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06gqc(Integer m, Integer n, double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06gsc(Integer m, Integer n, double x[], double u[], double v[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06gzc(Integer n, double trig[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06hac(Integer m, Integer n, double x[],
                                             double trig[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06hbc(Integer m, Integer n, double x[],
                                             double trig[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06hcc(Nag_TransformDirection direct, Integer m, Integer n, double x[],
                                             double trig[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06hdc(Nag_TransformDirection direct, Integer m, Integer n, double x[],
                                             double trig[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06pfc(Nag_TransformDirection direct,
                                             Integer ndim, Integer l,
                                             const Integer nd[], Integer n,
                                             complex x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c06pjc(Nag_TransformDirection direct,
                                             Integer ndim, const Integer nd[],
                                             Integer n, complex x[],
                                             NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL c06pxc(Nag_TransformDirection direct,
                                           Integer n1, Integer n2, Integer n3,
                                           complex x[], NagError *fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagc06aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGC06 */
