/* <nag.h>
 *
 * Copyright 1990 Numerical Algorithms Group
 *
 * General include file for all NAG C software.
 *
 * Malcolm Cohen, NAG Ltd., Oxford, U.K., 1990.
 *
 * Mark 1, 1990.
 *
 * Mark 2, revised 
 *    The defined types and error names have been placed into
 *    separate files, nag_types.h and  nag_errlist.h, respectively.
 *    SPD, October 91.
 *    Reworked handling of implementation specifics.  AJS feb92.
 *
 * Purpose : To define a macro that is implementation specific so that
 *           variant code may be easily inserted by implementors and carried
 *           foreward into future releases.
 *           A number of other macros are also defined to indicate the
 *           compliance (or otherwise) to particular common characteristics.
 *           These macros are always set to their default state in the
 *           introduction.  There is a later section where the implementation-
 *           specific macro controls changes to the defaults.
 * Mark 5 revised. IER-2134 (Feb 1998).
 * Mark 6 revised. IER-3010 (July 2000).
 */

#ifndef NAG_H
#define NAG_H

/* The type of system should be defined here.
   It is defined by the "system" and "compiler" components of the NAG product
   code for the library (c.f. a00aact.c).  Some examples are :
       IBPE_NAG_IMP       for Borland PC compiler

   These macros are used in preprocessor directives in other parts of the code
   to introduce the implementation specific variations.  It is only anticipated
   that variations will be required in nag.h , nag_stddef.h , nag_stdlib.h ,
   nag_string.h and x05aact.c.
   */

/*#define IBPE_NAG_IMP  MS/PC-DOS & MS/WINDOWS PCs , Borland compiler */
/*#define IBPA_DLL32_NAG_IMP   MS-Windows 32 bit DLL, Microsoft compiler */
/*#define IBPA_STL32_NAG_IMP MS-Windows 32 bit Static Library, Microsoft compiler */
/*#define IBPE_STL32_NAG_IMP MS-Windows 32 bit Static Library, Borland compiler */
/*#define LINUX_NAG_IMP_32 Linux*/
/*#define DAU_NAG_IMP DEC alpha AXP Digital (OSF1) */
/*#define S06 Sun Solaris 64 bit implementation */
/*#define INTEGER64 64 bit implementations */
/// TD ML 06-10-2011 ORG-2987 UNIFIED_NAG_HEADERS
#ifdef _OWIN64	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#define IBPA_STL64_NAG_IMP
#else //_OWIN64		/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#define IBPA_STL32_NAG_IMP
#endif //_OWIN64	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
/// end UNIFIED_NAG_HEADERS




/* The following sections define the default settings for macros concerned
   with common characteristics that are shared by many compilers. These
   settings are listed below and a macro is defined for each 
   setting. If for a particular compiler, a setting is not appropriate,
   then it should be corrected later, in the implementation specific section
   of this file by undefining the corresponding macro.
   */

/* NAG_PROTO 
   This was used to indicate that the compiler supports function prototypes
   as  specified in the ANSI standard. It is no longer required but has been
   left in case older program source files are used for some reason or if a 
   happens to type in an example program from the manual where there is reference
   to NAG_PROTO.
*/
#define NAG_PROTO

/* NAG_EXIT
   The default action for p01acc is to terminate the program by the use of
   exit.  On some systems it may be more appropriate to terminate with abort,
   perhaps causing a core dump.  However, any parent process (or script)
   may wish to continue after testing the exit status of the program.
   If it is approriate to use abort rather than exit then undefine NAG_EXIT.  */
#define NAG_EXIT

/* NAG_NO_INC_MEMORY_DOT_H
   The functions memcmp , memcpy are normally declared string(s).h. If on
   target system they are declared in memory.h then undefine
   NAG_NO_INC_MEMORY_DOT_H */
#define NAG_NO_INC_MEMORY_DOT_H

/* NAG_NO_BC_MEM_FUN
   The functions memcpy and memcmp are meant to manipulate objects as
   character arrays. Some BSD derived systems provide bcopy and bcmp
   as either additional to or instead of memcpy and memcmp. If it
   is felt that it is desirable to use bcopy and bcmp then undefine
   NAG_NO_BC_MEM_FUN
   */
#define NAG_NO_BC_MEM_FUN

/* NAG_ARRAY_SIZE
   In the stringent test program for c06fuc, a number of large arrays
   are being used. This might prove too large, especially for the PC
   type machines. In this case undefine NAG_ARRAY_SIZE.
   */
#define NAG_ARRAY_SIZE

/* NAG_VOID_STAR
   Newer ANSI based compilers provide the generic pointer void *. If the
   target system  does not allow the  type void *, then undefine NAG_VOID_STAR.
   */
#define NAG_VOID_STAR

/* NAG_YES_MALLOC
   The C dynamic memory allocator, malloc returns size_t whose maximum
   value may not be large enough for practical applications, e.g the
   Microsoft C compiler whose size_t has the maximum value of 65536. In
   this case the compiler may provide an alternative function, such as
   halloc. See nag_stdlib.h for the definition of halloc.
*/
#define NAG_YES_MALLOC

/* NAG_THREAD_SAFE
   If the compiler supports POSIX threads, then this should be defined to
   produce thread safe versions of the routines g05cac, g05cay and g05caz.
*/
#define NAG_THREAD_SAFE

/* NAG_STP_IMPL_DETAILS
   By default the stringent test programs will not print implementation 
   details at Mark 7. If you wish these to be printed define the variable 
   NAG_STP_IMPL_DETAILS */
/*#define NAG_STP_IMPL_DETAILS*/


/****************************************************************************
 * This Section is about BLAS things and what BLAS is available on the
 * implementation.
 ****************************************************************************/

/*
   NAG_ADDUNDERSCORE
   To link with a vendor's provided Fortran legacy BLAS, we need to know
   if Fortran names have underscore added at the end.
   Usually the case. If not this macros should be undefined in implementation
   dependant branches.
*/
#define NAG_ADD_UNDERSCORE


/*
   NAG_C_LEG_int
   In order to link with a vendor's interface to legacy BLAS, we need to
   know which integer type the vendor's C interfaces are expecting.
*/
#define NAG_C_LEG_int int


/*
   NAG_C_BLAS_int
   In order to link with a vendor's C BLAS, we need to
   know which integer type the vendor's C bindings are expecting.
*/
#define NAG_C_BLAS_int int


/*
   NAG_EXTERNAL_LEGACY_BLAS       (Vendor's Fortran BLAS)
   NAG_EXTERNAL_C_LEGACY_BLAS     (Vendor's standard C interface to legacy BLAS)
   NAG_EXTERNAL_C_BLAS            (Vendor's standard C BLAS)

   One (and only one) of the three macros above should be defined to allow
   the use of the available vendor's BLAS (C or Fortran). Otherwise, inefficient
   C sources will be used. Note that the new BLAS routines interfaces provided
   at Mark 7 have been made compatible with the rest of the C library rathar
   than with the new standards from the BLAST Forum (Use of NAG's Integer type
   and use of a NagError structure for the fail parameter).
 */
/* #define NAG_EXTERNAL_LEGACY_BLAS */


/* These are defined to nothing, they are used only for Windows code, 16 and 32 bit */
#define NAG_FPE
#define NAG_FP
#define NAG_FAR
#define NAG_DLL_IMP
#define NAG_DLL_EXP
#define NAG_DLL_EXPIMP
#ifdef _MSC_VER/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#define NAG_CALL
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#else// _MSC_VER
#define NAG_CALL	__stdcall	// that is how NAG has implemented them
#endif// _MSC_VER
/// end NAG_HEADERS_OC_COMPILE

#define NAG_CDECL

/* The following sections override the default settings of the above 14
   macros, where it is necessary for a particular implementation.
*/

#ifdef IBPA_DLL32_NAG_IMP

 #undef NAG_EXIT
 #undef NAG_ARRAY_SIZE
 #undef NAG_CHAR_BOOL
 #define NAG_DLL
 #undef NAG_DLL_EXPIMP
 #undef NAG_CALL
 #undef NAG_CDECL
 #define NAG_CALL __stdcall
 #define NAG_CDECL __cdecl
 #ifdef  NAG_DLL_EXPORT
  #define NAG_DLL_EXPIMP __declspec(dllexport)
 #else
  #define NAG_DLL_EXPIMP __declspec(dllimport)
 #endif
 #undef NAG_THREAD_SAFE
 #define NAG_MICROSOFT_THREAD_SAFE

#else
#if defined(IBPA_STL32_NAG_IMP) || defined(IBPA_STL64_NAG_IMP)

 #undef NAG_EXIT
 #undef NAG_ARRAY_SIZE
 #undef NAG_CHAR_BOOL
 #define NAG_DLL
 #undef NAG_CALL
 #undef NAG_CDECL
 #ifdef IBPA_STL32_NAG_IMP
  #define NAG_CALL __stdcall
  #define NAG_CDECL __cdecl
 #else
  #define NAG_CALL
  #define NAG_CDECL
 #endif
 #undef NAG_THREAD_SAFE
 #define NAG_MICROSOFT_THREAD_SAFE
 /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
 #undef	NAG_DLL_EXPIMP
 #if defined(NAG_DLL_EXPORT) || defined(MIN_OK_VERSION) || !defined(_MSC_VER)
  #define NAG_DLL_EXPIMP
 #else
  #define NAG_DLL_EXPIMP __declspec(dllimport)
 #endif
 /// end NAG_HEADERS_OC_COMPILE
 #ifdef IBPA_STL64_NAG_IMP
/* For 64-bit Windows, we want 32-bit integers so define NAG_INT for nag-types.h.
   But types pointer and size_t will be 64-bit. */
   #define NAG_INT
 #endif
#else
#ifdef IBPE_NAG_IMP

 #undef NAG_ARRAY_SIZE
 #undef NAG_YES_MALLOC
 extern unsigned  _floatconvert;
 #pragma extref _floatconvert

#else
#ifdef IBPE_STL32_NAG_IMP

  #undef NAG_EXIT
  #undef NAG_ARRAY_SIZE
  #undef NAG_CHAR_BOOL
  #define NAG_DLL
  #undef NAG_CALL
  #define NAG_CALL __stdcall
  extern int _floatconvert;
  #pragma extref _floatconvert;

  #undef NAG_THREAD_SAFE

#else

#ifdef LINUX_NAG_IMP_32
#define linux
#endif

#ifdef DAU_NAG_IMP
#undef NAG_THREAD_SAFE
#endif

#endif
#endif
#endif
#endif


/* ****** End of anticipated implementation specifics ***** */


#ifndef NULLFN
#define NULLFN 0
#endif
#ifndef NULLDFN
#define NULLDFN 0
#endif

/*#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif*/


#define NAGERR_DEFAULT (NagError *)0
#define NAGUSER_DEFAULT (Nag_User *)0
#define NAGCOMM_NULL (Nag_Comm *)0
#define NAGMESG_DEFAULT (Nag_Mesg *)0
#define E01_DEFAULT (Nag_E01_Opt *)0
#define E04_DEFAULT (Nag_E04_Opt *)0
#define G13_DEFAULT (Nag_G13_Opt *)0
#define H02_DEFAULT (Nag_H02_Opt *)0
#define TRANSF_ORDER_DEFAULT (Nag_TransfOrder *)0

#define MPS_NAME_LEN 8

#define NAG_ERROR_BUF_LEN 512
#define NAG_FILE_LEN 512

/* Added for stringent test program template (22/03/01) */
#define MAX_ARG_LEN 32
/* End addition (22/03/01) */

/* INIT_FAIL initialises a fail structure with print set to FALSE */
#define INIT_FAIL(E) (E).code = NE_NOERROR, (E).print = Nag_FALSE, \
(E).handler = 0, (E).errnum = 0

/* SET_FAIL initialises a fail structure with print set to TRUE */
#define SET_FAIL(E) (E).code = NE_NOERROR, (E).print = Nag_TRUE, \
(E).handler = 0, (E).errnum = 0

#define INIT_MESG(M) (M).code = NM_NO_MESG, (M).print = Nag_FALSE, \
(M).res_file = (char *)0, (M).name = (char *)0, (M).opt_name = (char *)0, \
(M).print_mesg = 0, (M).init_mesg1 = IDUMMY, (M).init_mesg2 = INIT2DUMMY

#define INIT_STREAM(S) (S).set = Nag_FALSE, (S).st_out = Nag_FALSE, \
(S).st_err = Nag_FALSE, (S).st_in = Nag_FALSE, (S).chapter = (char *)0, \
(S).error = NE_NOERROR



/* d02rac use, define two or four functions as null pointers in the d02rac
 * call. Saves us having to design a limited option setting facility for
 * this routine
 */

#define NULL_4_FUN NULLFN, NULLFN, NULLFN, NULLFN
#define NULL_2_FUN NULLFN, NULLFN

/* Magic numbers to denote initialisation state */
#define RDUMMY -11111.0
#define IDUMMY -11111
#define INIT2DUMMY -23456


#define Vprintf (void)printf
#define Vfprintf (void)fprintf
#define Vsprintf (void)sprintf
#define Vscanf (void)scanf
#define Vfscanf (void)fscanf
#define Vstrcpy (void)strcpy


#define ABS(x) (x>=0 ? x : -(x)) /* Absolute value */

#define FABS(x) fabs(x)

#define SIGN(x,y) (y>=0 ? ABS(x) : -ABS(x)) /* Sign transfer */

#define MAX(x,y) ((x)>=(y) ? (x) : (y)) /* Maximum of two arguments */

#define MIN(x,y) ((x)<(y) ? (x) : (y)) /* Minimum of two arguments */

/* Round real number to nearest integer, returned as a double: valid for all X */
#define DROUND(X) floor((X)+0.5)

/* Round real number to nearest integer: valid for all X below MAXINT */
#define ROUND(X) (Integer)(floor((X)+0.5))

/* Defines for complex Values */

/* Square of the modulus of a complex number */
#define SQZABS(Z) ((Z).re*(Z).re + (Z).im*(Z).im)

/* complex conjugate of itself */
#define CONJ(A) ((A).im = -(A).im)

/* A gets the complex conjugate of B */
#define VCONJ(A,B) ((A).re = (B).re, (A).im = -((B).im))

/* complex multiplication. X = Y*Z */
#define ZMULT(X,Y,Z) { double zz_t; zz_t = (Y).re*(Z).re - (Y).im*(Z).im; \
                                  (X).im = (Y).re*(Z).im + (Y).im*(Z).re, \
                                  (X).re = zz_t; }                  

/* nag_stringize just converts (via the preprocessor) its argument
   into a double quoted string; e.g. nag_stringize(33) returns "33"   */
#define _nag_expand(x) #x
#define nag_stringize(x) _nag_expand(x)

//following three includes used <name.h>, changed to "name.h"	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#include "nag_types.h"
#include "nag_errlist.h"
#include "nag_names.h"

/*#include <nag_f77.h>*/

/* -DOVERRIDE_THREAD_SAFE on the C compile line will create a
   non-thread-safe library after all. This should be used only
   for build testing purposes */
#ifdef OVERRIDE_THREAD_SAFE
#undef NAG_THREAD_SAFE
#undef NAG_MICROSOFT_THREAD_SAFE
#endif

#endif /* not NAG_H */
