/*------------------------------------------------------------------------------*
 * File Name: MsgMap.h							 								*
 * Purpose: Window message map entries											*
 * Copyright (c) OriginLab Corp.		2011									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Kenny 1/11/2011 ORG-1963 BITMAP_RADIO_BUTTON_MISSED_DOUBLE_CLICK_EVENT		*
 *	Folger 11/10/2011 WORKSHEET_QUERY_OPEN_MODELESS_FAILED_TO_GET_FOCUS			*
 *	Kenny 12/08/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS		*
 *	Folger 12/27/2011 ORG-4685-S3 OC_MOUSE_MOVE_ON_PAGE_EVENT					*
 *	Folger 01/18/2012 ORG-4794-P1 OC_MOUSE_LBUTTON_DOWN_AND_UP_EVENT			*
 *	Folger 01/19/2012 ORG-4841-P1 FAILED_TO_SELECT_WORKSHEET_IF_ALREADY_ACTIVE_FROM_INTERATIVE_CONTROL
 *	Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR				*
 *------------------------------------------------------------------------------*/


#pragma PCH //CPY 10/19/2007 QA70-10528 NEED_TO_HIDE_VSFLEX_HEADER
#include <DialogMessages.h>

#ifndef _MSGMAP_H_
#define _MSGMAP_H_

//-----CPY 10/19/2007 QA70-10528 NEED_TO_HIDE_VSFLEX_HEADER
//#include <Common.h>
//#include <String.h>
//-----


/** >User Interface Controls
*/
class Msgmap
{
	/**
	*/
	Msgmap();
	
	/**
	*/
	Msgmap(Msgmap & map);
	
	/**
	*/
	BOOL AddDlgMsg(int nMsg, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_AFTER);    
	
	/**
	*/
	BOOL AddPageMsg(int nMsg,  uint nResID, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_AFTER);    
	
	/**
	*/
	BOOL AddOGSWndMsg(int nMsg, uint nResID, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_AFTER);  
	
	/**
	*/
	BOOL AddDirectWndMsg(int nMsg, uint nResID, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_BEFORE);
	
	/**
	*/
	BOOL AddEventMsg(int nMsg, uint nResID, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_AFTER);
	
	/**
	*/
	BOOL AddOriginMsg(int nMsg, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_NONE);

	/// TD 3-30-05 QA70-7567 HANDLERS_FOR_COMMAND_RANGE
	/**
	*/
	BOOL AddCommandRange(int nCmdBegin, uint nCommandEnd, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_NONE);
	/// end HANDLERS_FOR_COMMAND_RANGE
	/// TD 1-17-06 QA70-8490 CREATE_DIALOG_FROM_TREE
	/**
	*/
	BOOL AddDynaCtrlMsg(int nMsg, uint nNodeId, Function FN, LPCSTR Prototype, DWORD ctrl, uint nRootId);
	/// end CREATE_DIALOG_FROM_TREE

	///Kyle 11/17/2009 QA80-14653 ON_UPDATE_COMMAND_UI_RANGE_IN_OC
	BOOL	AddUIUpdateRange(int nCmdBegin, uint nCommandEnd, Function FN, LPCSTR Prototype, DWORD ctrl = MHO_NONE);
	///End ON_UPDATE_COMMAND_UI_RANGE_IN_OC
};

/// Hong 01/17/11 ORG-1999 OC_RESIZE_NEED_INFO_OF_SIZING_EDGE
enum
{	// see WM_SIZING
	WMSZ_LEFT 		= 1,
	WMSZ_RIGHT,
	WMSZ_TOP,
	WMSZ_TOPLEFT,
	WMSZ_TOPRIGHT,
	WMSZ_BOTTOM,
	WMSZ_BOTTOMLEFT,
	WMSZ_BOTTOMRIGHT,
};
/// end OC_RESIZE_NEED_INFO_OF_SIZING_EDGE

#define TCN_SELCHANGE           -551
	
/*
 * User Button Notification Codes
 *	From Windows WinUser.h
 */
#define BN_CLICKED              0

/// Kenny 1/11/2011 ORG-1963 BITMAP_RADIO_BUTTON_MISSED_DOUBLE_CLICK_EVENT
#define BN_DOUBLECLICKED    	5
/// End ORG-1963 BITMAP_RADIO_BUTTON_MISSED_DOUBLE_CLICK_EVENT

/*
 * Combo Box Notification Codes
 *	From Windows WinUser.h
 */
#define CBN_SELCHANGE       1
#define CBN_KILLFOCUS       4
#define CBN_EDITCHANGE      5
#define CBN_DROPDOWN        7


/*
 * Listbox Notification Codes
 */
#define LBN_SELCHANGE       1
#define LBN_DBLCLK          2 /// Iris 5/31/2011 LISTBOX_NEED_DOUBLE_CLICK_EVENT

/*
 * Edit Control Notification Codes
 *	From Windows WinUser.h
 */
#define EN_SETFOCUS         0x0100
#define EN_KILLFOCUS        0x0200
#define EN_CHANGE           0x0300
#define EN_UPDATE           0x0400
#define EN_ERRSPACE         0x0500
#define EN_MAXTEXT          0x0501
#define EN_HSCROLL          0x0601
#define EN_VSCROLL          0x0602

#define WM_USER					0x0400
#define EM_SETEVENTMASK			(WM_USER + 69)

#define WM_APP					0x8000

/* 
 *	Event notification masks
 */
#define ENM_NONE				0x00000000
#define ENM_CHANGE				0x00000001
#define ENM_UPDATE				0x00000002
#define ENM_SCROLL				0x00000004
#define ENM_KEYEVENTS			0x00010000
#define ENM_MOUSEEVENTS			0x00020000
#define ENM_REQUESTRESIZE		0x00040000
#define ENM_SELCHANGE			0x00080000
#define ENM_DROPFILES			0x00100000
#define ENM_PROTECTED			0x00200000
#define ENM_CORRECTTEXT			0x00400000		/* PenWin specific */
#define ENM_SCROLLEVENTS		0x00000008
#define ENM_DRAGDROPDONE		0x00000010

/*
 * New notifications 
 */
#define EN_MSGFILTER			0x0700
#define EN_REQUESTRESIZE		0x0701
#define EN_SELCHANGE			0x0702
#define EN_DROPFILES			0x0703
#define EN_PROTECTED			0x0704
#define EN_CORRECTTEXT			0x0705			/* PenWin specific */
#define EN_STOPNOUNDO			0x0706
#define EN_IMECHANGE			0x0707			/* Far East specific */
#define EN_SAVECLIPBOARD		0x0708
#define EN_OLEOPFAILED			0x0709
#define EN_OBJECTPOSITIONS		0x070a
#define EN_LINK					0x070b
#define EN_DRAGDROPDONE			0x070c

// void (CCmdUI*)
#define CN_UPDATE_COMMAND_UI    -1    
/*
 * TrackBar Control Notification Codes
 *	From Windows CommCtrl.h
 */
#define TB_LINEUP               0
#define TB_LINEDOWN             1
#define TB_PAGEUP               2
#define TB_PAGEDOWN             3
#define TB_THUMBPOSITION        4
#define TB_THUMBTRACK           5
#define TB_TOP                  6
#define TB_BOTTOM               7
#define TB_ENDTRACK             8

//TD 8-1-05 QA70-7956 ADDITIONAL_MESSAGES_IN_SPLITTER_WINDOW
#define WM_LBUTTONDOWN                  0x0201
#define WM_LBUTTONUP                    0x0202
#define WM_LBUTTONDBLCLK                0x0203
#define WM_RBUTTONDOWN                  0x0204
#define WM_RBUTTONUP                    0x0205
#define WM_RBUTTONDBLCLK                0x0206
#define WM_MBUTTONDOWN                  0x0207
#define WM_MBUTTONUP                    0x0208
#define WM_MBUTTONDBLCLK                0x0209
//end ADDITIONAL_MESSAGES_IN_SPLITTER_WINDOW

/*
 * Window Messages
 *	From Windows WinUser.h
 */
#define WM_DESTROY				0x0002
#define WM_SIZE					0x0005
#define WM_SETFOCUS				0x0007		///------ Folger 11/10/2011 WORKSHEET_QUERY_OPEN_MODELESS_FAILED_TO_GET_FOCUS
#define WM_SETREDRAW			0x000B		//------ Folger 11/19/07 ADD_WM_REDRAW
#define WM_KEYDOWN				0x0100
#define WM_KEYUP				0x0101
#define WM_CHAR					0x0102
#define WM_TIMER				0x0113
#define WM_HSCROLL				0x0114
#define WM_VSCROLL				0x0115
#define WM_CONTEXTMENU          0x007B
#define WM_HELP                 0x0053
#define WM_GETMINMAXINFO        0x0024

#define WM_REDRAW WM_SETREDRAW

/// Kenny 12/08/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
/*
 * Struct pointed to by WM_GETMINMAXINFO lParam
 */
typedef struct tagMINMAXINFO {
    POINT ptReserved;
    POINT ptMaxSize;
    POINT ptMaxPosition;
    POINT ptMinTrackSize;
    POINT ptMaxTrackSize;
} MINMAXINFO, *PMINMAXINFO, *LPMINMAXINFO;
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS

#define	WM_COMMAND				0x111
#define WM_SYSCOMMAND           0x0112


#define SC_MINIMIZE     		0xF020
#define SC_MAXIMIZE     		0xF030
#define SC_RESTORE      		0xF120

#define ID_DLG					0

// event map for general event handlings

#define BEGIN_EVENT_MAP static Msgmap GenerateMsgMap() { Msgmap msgMap;
#define END_EVENT_MAP	return msgMap;}

/// RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME
#define BEGIN_OK_EVENT_MAP static Msgmap _OKEventMsgMap() { static Msgmap msgMap; 
#define END_OK_EVENT_MAP	return msgMap;}
#define ON_OK_EVENT(_nMsg, _ocFunc)										msgMap.AddOriginMsg(_nMsg, _ocFunc, VTS_RORIGINOBJ);
/// end SYSTEM_THEME

//---- CPY 5/8/03 msg map for class
#define EVENTS_BEGIN	BOOL InitMsgMap() { Msgmap msgMap;
#define EVENTS_END		m_msgmap = msgMap; return TRUE;}
//----

///---Sim 03-31-2008 MSG_MAP_FOR_DERIV_CLASS
#define EVENTS_BEGIN_DERIV(_baseClass)	BOOL InitMsgMap() { Msgmap msgMap; _baseClass::InitMsgMap();
#define EVENTS_END_DERIV				m_msgmap += msgMap; return TRUE;}
///---END MSG_MAP_FOR_DERIV_CLASS

/// YuI 8/24/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
#define	DECLARE_MESSAGE_MAP				BOOL	InitMsgMap();
#define	BEGIN_MESSAGE_MAP(_className)	BOOL	_className::InitMsgMap()	{Msgmap msgMap;
#define	END_MESSAGE_MAP					m_msgmap = msgMap; return TRUE;}
/// end NLFITTER_OPERATION_IMPLEMENTATION


/// TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON
#define	BEGIN_MESSAGE_MAP_DERIV(_className, _baseClass)			BOOL	_className::InitMsgMap()	{Msgmap msgMap;  _baseClass::InitMsgMap();
#define	END_MESSAGE_MAP_DERIV									m_msgmap += msgMap; return TRUE;}


#define ON_DC_GENERIC(_fn)						msgMap.AddDirectWndMsg(WM_USER_DYNACTRL_GENERIC_CONTROL_MSG, ID_DLG, _fn, VTS_RORIGINOBJ VTS_OUIP, MHO_BEFORE);		/// TD ML 11-09-2010 NEW_TYPES				
/// end EDITBOX_WITH_BUTTON

#define ON_DLG_EVENT(_nMsg, _ocFunc)									msgMap.AddDlgMsg(_nMsg, _ocFunc, VTS_VOID);
#define ON_EVENT_BEFORE_UPDATE(_evt, _idCntrl, _ocHandler, _argList)	msgMap.AddDirectWndMsg(_evt, _idCntrl, _ocHandler, _argList);		  
#define ON_COMMAND_BEFORE_UPDATE(_evt, _idCntrl, _ocHandler)			msgMap.AddDirectWndMsg(_evt, _idCntrl, _ocHandler, VTS_CTRL);		  
#define ON_NOTIFY_BEFORE_UPDATE(_evt, _idCntrl, _ocHandler)				msgMap.AddDirectWndMsg(_evt, _idCntrl, _ocHandler, VTS_CTRL);		  
#define ON_EVENT(_evt, _idCntrl, _ocHandler)							msgMap.AddOGSWndMsg(_evt, _idCntrl, _ocHandler, VTS_CTRL);
#define ON_EVENT_EX(_evt, _idCntrl, _ocHandler, _argList)				msgMap.AddOGSWndMsg(_evt, _idCntrl, _ocHandler, _argList);
#define ON_ACTIVEX_EVENT(_evt, _idCntrl, _ocFunc, _argList)				msgMap.AddEventMsg(_evt, _idCntrl, _ocFunc, _argList);
#define ON_ACTIVEX_EVENT_CTRL(_evt, _idCntrl, _ocFunc)					msgMap.AddEventMsg(_evt, _idCntrl, _ocFunc, VTS_CTRL);
#define ON_ORIGIN_EVENT(_nMsg, _ocFunc)									msgMap.AddOriginMsg(_nMsg, _ocFunc, VTS_VOID);

/// TD 2-5-05 CMDUI_CLASS_IN_OC
#define ON_CMD_UI_UPDATE(_cmdid, _fn)										msgMap.AddDirectWndMsg(CN_UPDATE_COMMAND_UI, _cmdid, _fn, VTS_CTRL);
/// end CMDUI_CLASS_IN_OC

///Kyle 11/17/2009 QA80-14653 ON_UPDATE_COMMAND_UI_RANGE_IN_OC
#define ON_CMD_UI_UPDATE_RANGE(_cmdidFirst, cmdidLast, _fn)		\
		msgMap.AddUIUpdateRange(_cmdidFirst, cmdidLast, _fn, VTS_CTRL);
///End ON_UPDATE_COMMAND_UI_RANGE_IN_OC

//---- CPY QA70-7860 7/6/05 LOOSE_DATASET_EDIT_UPDATE
//	BOOL	OnLooseDatasetChange(int wParam, int lParam)
#define ON_ORIGIN_MSG(_nMsg, _ocFunc)			msgMap.AddOriginMsg(_nMsg, _ocFunc, VTS_I4 VTS_I4); 
//---- end

//----
// for _nMsg >= SN_COL_CHANGE_FORMAT 
//static BOOL OnColChange(string strWksName, string strColName, int nColNumber)
#define ON_ORIGIN_CHANGE(_nMsg, _ocFunc)							msgMap.AddOriginMsg(_nMsg, _ocFunc, VTS_STR VTS_STR VTS_I4);
/// TD 11-4-04 QA70-7124 GENERAL_EVENTS_FIRED_ON_IMPORT
#if _OC_VER >= 0x0800
#define 	ON_OBJECT_MODIFY(_ocFunc)								msgMap.AddOriginMsg(SN_ON_MODIFY, _ocFunc, VTS_ORIGINOBJ VTS_I4);
#define 	ON_OBJECT_INFO_MODIFY(_ocFunc)							msgMap.AddOriginMsg(SN_ON_MODIFY_INFO, _ocFunc, VTS_ORIGINOBJ VTS_I4);  
#define 	ON_PAGE_ATTACH(_ocFunc)									msgMap.AddOriginMsg(SN_ON_PAGE_CONTROL, _ocFunc, VTS_I4 VTS_I4);
#endif //#if _OC_VER >= 0x0800
/// end GENERAL_EVENTS_FIRED_ON_IMPORT

///---Sim 11-22-2008 QA80-12505 SUPPORT_POST_OC_MESSAGE_TO_SPECIFIED_WINDOW
#define ON_DATA_CHANGE(_fn)		msgMap.AddOriginMsg(SN_ON_DATA_CHANGE, _fn, VTS_STR);
///---END QA80-12505 SUPPORT_POST_OC_MESSAGE_TO_SPECIFIED_WINDOW

// Specialized ON_DLG_EVENT's
#define ON_INIT(_fn)			ON_DLG_EVENT(SN_INIT, _fn)
#define ON_READY(_fn)			ON_DLG_EVENT(SN_ONREADY, _fn)
	
  //static BOOL OnOK()// return TRUE to close, return FALSE will not close dialog
#define ON_OK(_fn)       		ON_DLG_EVENT(SN_OK, _fn)

#define ON_APPLY(_fn)       	ON_DLG_EVENT(SN_APPLY, _fn)
#define ON_FINISH(_fn)       	ON_DLG_EVENT(SN_FINISH, _fn)
#define ON_CANCEL(_fn)       	ON_DLG_EVENT(SN_CANCEL, _fn)
#define ON_CLICK_KEY(_fn) 		msgMap.AddDlgMsg(SN_ONKEY,_fn, VTS_I4, MHO_BEFORE);

// sample handler function BOOL OnInitSize(int &left, int &top, int &right, int  &bottom)
// return FALSE to disbale, always return false is same as DoModal(hWndParent, DLG_NO_DEFAULT_REPOSITION);
#define ON_INIT_SIZE(_fn)			msgMap.AddDlgMsg(SN_ON_INIT_RESIZE,_fn, VTS_RI4 VTS_RI4 VTS_RI4 VTS_RI4, MHO_BEFORE);
/// TD 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
#define ON_RESTORESIZE(_fn)			msgMap.AddDlgMsg(SN_OC_RESIZEINFO, _fn, VTS_OIP, MHO_BEFORE);
/// end DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS

// ON_WINPROC does not interrupt processing irrespective of return value
// Prototype int WindowProc( UINT message, WPARAM wParam, LPARAM lParam ); // For special message handling
#define ON_WINPROC(_ocHandler)	msgMap.AddDlgMsg(SN_WINDOW_PROC,_ocHandler, VTS_I4 VTS_I4 VTS_I4, MHO_BEFORE);


#define ON_IDLE(_fn)				ON_ORIGIN_EVENT(SN_ONIDLE,	_fn)
#define ON_CHANGE_LAYER(_fn)		ON_ORIGIN_EVENT(SN_ACTIVE_LAYER, _fn)
#define ON_CHANGE_PAGE(_fn)			ON_ORIGIN_EVENT(SN_ACTIVE_PAGE, _fn)
#define ON_CHANGE_DATASET(_fn)		ON_ORIGIN_EVENT(SN_ACTIVE_DATASET, _fn)
#define ON_CHANGE_SELECTION(_fn)	ON_ORIGIN_EVENT(SN_ACTIVE_SELECTION, _fn)	

//----- CPY 10/27/2007 QA70-10600 PAGE_CREATE_DESTROY_MSGS
#define ON_PAGE_CREATE(_fn)			msgMap.AddOriginMsg(SN_ON_PAGE_CREATE, _fn, VTS_ORIGINOBJ VTS_I4);
#define ON_PAGE_DESTROY(_fn)		msgMap.AddOriginMsg(SN_ON_PAGE_DESTROY, _fn, VTS_ORIGINOBJ VTS_I4);
//-----

///------ Folger 06/08/09 LAYER_DESTROY_DIALOG_MESSAGE_FOR_OC
#define ON_LAYER_DESTROY(_fn)		msgMap.AddOriginMsg(SN_ON_LAYER_DESTROY, _fn, VTS_ORIGINOBJ VTS_I4);
///------ End LAYER_DESTROY_DIALOG_MESSAGE_FOR_OC

/// TD 5-15-06 QA70-8579 SAVING_OXF_IN_PROJECTS_TEMPALTES_AND_SINGLE_WINDOWS
#define ON_AFTER_LOAD_FILE(_fn)		ON_ORIGIN_EVENT(SN_ON_AFTER_LOAD_FILE, _fn)
/// end SAVING_OXF_IN_PROJECTS_TEMPALTES_AND_SINGLE_WINDOWS
/// YuI 01/30/04 v7.5811 QA70-5908 NOMINAL_CATEGORICAL_MAP_INIT_PROBLEM
#define ON_SELECTION_TRACK(_fn)		ON_ORIGIN_EVENT(SN_ACTIVE_SELECTION_TRACK, _fn)	
#define	ON_DS_SELECTION_CHANGE(_fn)	ON_ORIGIN_EVENT(SN_DS_SELECTION_CHANGE, _fn)	
#define	ON_DS_SELECTION_TRACK(_fn)	ON_ORIGIN_EVENT(SN_DS_SELECTION_TRACK, _fn)	
#define	ON_DS_SELECTION_OK(_fn)		ON_ORIGIN_EVENT(SN_DS_SELECTION_OK, _fn)	
#define	ON_DS_SELECTION_CANCEL(_fn)	ON_ORIGIN_EVENT(SN_DS_SELECTION_CANCEL, _fn)	
/// end NOMINAL_CATEGORICAL_MAP_INIT_PROBLEM

/// YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP
#define	ON_DS_SELECTION_CHANGE_EX(_fn)	msgMap.AddOriginMsg(SN_DS_SELECTION_CHANGE, _fn, VTS_I4 VTS_I4);
#define	ON_DS_SELECTION_TRACK_EX(_fn)	msgMap.AddOriginMsg(SN_DS_SELECTION_TRACK, _fn, VTS_I4 VTS_I4);
#define	ON_DS_SELECTION_OK_EX(_fn)		msgMap.AddOriginMsg(SN_DS_SELECTION_OK, _fn, VTS_I4 VTS_I4);
#define	ON_DS_SELECTION_CANCEL_EX(_fn)	msgMap.AddOriginMsg(SN_DS_SELECTION_CANCEL, _fn, VTS_I4 VTS_I4);
#define	ON_DS_MARKER_CREATE(_fn)		msgMap.AddOriginMsg(SN_DS_MARKER_CREATE, _fn, VTS_I4 VTS_I4);
#define	ON_DS_MARKER_DESTROY(_fn)		msgMap.AddOriginMsg(SN_DS_MARKER_DESTROY, _fn, VTS_I4 VTS_I4);
/// end DATA_MARKERS_REVAMP

#define ON_PAGE_INIT(_nPgID, _fn)		msgMap.AddPageMsg(SN_INIT,  _nPgID, _fn, VTS_VOID); 
#define ON_PAGE_NEXT(_nPgID, _fn)		msgMap.AddPageMsg(SN_NEXT,  _nPgID, _fn, VTS_VOID); 
#define ON_PAGE_BACK(_nPgID, _fn)		msgMap.AddPageMsg(SN_BACK,  _nPgID, _fn, VTS_VOID); 
#define ON_PAGE_FINISH(_nPgID, _fn)		msgMap.AddPageMsg(SN_FINISH,  _nPgID, _fn, VTS_VOID);
#define ON_PAGE_ACTIVE(_nPgID, _fn) 	msgMap.AddPageMsg(SN_ACTIVE, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_KILLACTIVE(_nPgID, _fn) msgMap.AddPageMsg(SN_KILLACTIVE, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_OK(_nPgID, _fn) 		msgMap.AddPageMsg(SN_OK, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_CANCEL(_nPgID, _fn) 	msgMap.AddPageMsg(SN_CANCEL, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_RESET(_nPgID, _fn) 		msgMap.AddPageMsg(SN_RESET, _nPgID, _fn, VTS_VOID);
#define ON_PAGE_IS_SHOW(_nPgID, _fn)	msgMap.AddPageMsg(SN_IS_SHOW_PAGE, _nPgID, _fn, VTS_I4 VTS_I4);

// Event macros for tabbed dialog and wizard pages (GJL added for Tarak)
#define PAGE_ON_INIT(_fn)				msgMap.AddDlgMsg(SN_INIT, _fn, VTS_VOID); 
#define PAGE_ON_NEXT(_fn)				msgMap.AddDlgMsg(SN_NEXT, _fn, VTS_VOID); 
#define PAGE_ON_BACK(_fn)				msgMap.AddDlgMsg(SN_BACK, _fn, VTS_VOID); 
#define PAGE_ON_FINISH(_fn)				msgMap.AddDlgMsg(SN_FINISH, _fn, VTS_VOID);
#define PAGE_ON_ACTIVE(_fn) 			msgMap.AddDlgMsg(SN_ACTIVE, _fn, VTS_VOID);
#define PAGE_ON_KILLACTIVE(_fn) 		msgMap.AddDlgMsg(SN_KILLACTIVE, _fn, VTS_VOID);
#define PAGE_ON_OK(_fn) 				msgMap.AddDlgMsg(SN_OK, _fn, VTS_VOID);
#define PAGE_ON_CANCEL(_fn) 			msgMap.AddDlgMsg(SN_CANCEL, _fn, VTS_VOID);
#define PAGE_ON_RESET(_fn) 				msgMap.AddDlgMsg(SN_RESET, _fn, VTS_VOID);
#define PAGE_ON_IS_SHOW(_fn)			msgMap.AddDlgMsg(SN_IS_SHOW_PAGE, _fn, VTS_I4 VTS_I4);

/*
 * The following macros are to simplify the message map blocks and
 * to make code more compatible with MFC.
 */
// Function prototype fro Toolbar Button clicked: static BOOL OnTBBClick();
#define ON_TOOLBAR_BN_CLICKED(_idCntrl, _ocHandler)	ON_EVENT_EX(BN_CLICKED, _idCntrl, _ocHandler, VTS_VOID)

//static BOOL OnClickBTN( Control ctrl )
#define ON_BN_CLICKED(_idCntrl, _ocHandler)			ON_EVENT(BN_CLICKED, _idCntrl, _ocHandler)

/// Kenny 1/11/2011 ORG-1963 BITMAP_RADIO_BUTTON_MISSED_DOUBLE_CLICK_EVENT
#define ON_BN_DOUBLECLICKED(_idCntrl, _ocHandler)	ON_EVENT(BN_DOUBLECLICKED, _idCntrl, _ocHandler)
/// End ORG-1963 BITMAP_RADIO_BUTTON_MISSED_DOUBLE_CLICK_EVENT

/// SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG
#define ON_CBN_DROPDOWN(_idCntrl, _ocHandler)		ON_EVENT(CBN_DROPDOWN, _idCntrl, _ocHandler)
/// end USING_MULTI_OPEN_FDLOG
#define ON_CBN_SELCHANGE(_idCntrl, _ocHandler)		ON_EVENT(CBN_SELCHANGE, _idCntrl, _ocHandler)
#define ON_CBN_KILLFOCUS(_idCntrl, _ocHandler)		ON_COMMAND_BEFORE_UPDATE(CBN_KILLFOCUS, _idCntrl, _ocHandler)
#define ON_CBN_EDITCHANGE(_idCntrl, _ocHandler)		ON_EVENT(CBN_EDITCHANGE, _idCntrl, _ocHandler)
#define ON_EN_CHANGE(_idCntrl, _ocHandler)			ON_EVENT(EN_CHANGE, _idCntrl, _ocHandler)
#define ON_EN_KILLFOCUS(_idCntrl, _ocHandler)		ON_EVENT(EN_KILLFOCUS, _idCntrl, _ocHandler)
#define ON_KEYDOWN_ENTER(_idCntrl, 	_ocHandler)		ON_EVENT(DDK_DLG_CTRL_MSG_EDITBOX_RETURN, _idCntrl, _ocHandler)
#define ON_LBN_SELCHANGE(_idCntrl, 	_ocHandler) 	ON_EVENT(LBN_SELCHANGE, _idCntrl, _ocHandler)
#define ON_LBN_DBLCLK(_idCntrl, 	_ocHandler) 	ON_EVENT(LBN_DBLCLK, _idCntrl, _ocHandler) /// Iris 5/31/2011 LISTBOX_NEED_DOUBLE_CLICK_EVENT

//return FALSE if not handled, and continue to be processed by standard windows processing of keyboard message
//return TRUE will stop default processing, so message will not be dispatched
// _ocHandler shouldbe prototyped as
//static BOOL OnKeyCmdWindow(Control oCntrl, uint msg, uint wParam, uint lParam)
#define ON_KEY(_idCntrl, 	_ocHandler)				ON_EVENT_BEFORE_UPDATE(OC_NOTIFICATION_KEY, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4 VTS_I4)
/// TD 8-1-05 QA70-7956 ADDITIONAL_MESSAGES_IN_SPLITTER_WINDOW
#define ON_MOUSEMSG(_MSG, _idCntrl, _ocHandler)		ON_EVENT_BEFORE_UPDATE(_MSG, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4 VTS_I4) 
//BOOL _ocHandler(Control ctrl, uint nMsg, int x, int y)
/// end ADDITIONAL_MESSAGES_IN_SPLITTER_WINDOW


//
//Changes  TD 1-3-03
//#define ON_EN_SELCHANGE(_idCntrl, _ocHandler)		ON_EVENT_BEFORE_UPDATE(EN_SELCHANGE, _idCntrl, _ocHandler, VTS_CTRL VTS_I4)
//#define ON_EN_VSCROLL(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(EN_VSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4)
//#define ON_EN_HSCROLL(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(EN_HSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4)


#define ON_TAB_SEL_CHANGE(_ID, _ocHandler)	ON_COMMAND_BEFORE_UPDATE(TCN_SELCHANGE, _ID, _ocHandler)
#define ON_EN_SELCHANGE(_idCntrl, _ocHandler)		ON_NOTIFY_BEFORE_UPDATE(EN_SELCHANGE, _idCntrl, _ocHandler)
#define ON_EN_VSCROLL(_idCntrl, _ocHandler)			ON_COMMAND_BEFORE_UPDATE(EN_VSCROLL, _idCntrl, _ocHandler)
#define ON_EN_HSCROLL(_idCntrl, _ocHandler)			ON_COMMAND_BEFORE_UPDATE(EN_HSCROLL, _idCntrl, _ocHandler)

// static BOOL OnVHScroll(Control cntrl, uint nScrollCode, uint nPos)
// nScrollCode = SB_THUMBPOSITION, SB_THUMBTRACK, SB_ENDSCROLL etc, SB_ENDSCROLL will have nPos = 0, so your code better check nScrollCode !=SB_ENDSCROLL
// before using nPos 
#define ON_WM_HSCROLL_BEFORE(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(WM_HSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4)
#define ON_WM_VSCROLL_BEFORE(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(WM_VSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4)
// static void OnVHScroll(Control cntrl, uint nScrollCode, uint nPos)
#define ON_WM_HSCROLL(_idCntrl, _ocHandler)					ON_EVENT_EX(WM_HSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4)
#define ON_WM_VSCROLL(_idCntrl, _ocHandler)					ON_EVENT_EX(WM_VSCROLL, _idCntrl, _ocHandler, VTS_CTRL VTS_I4 VTS_I4)
// BOOL OnDropOrigin(Control ctrlSrc, PageBase  pbTarget, int x, int y)
// x, and y are the cursor position when dropped in origin Workspace
#define ON_DROP_ORG_WORKSAPCE(_idCntrl, _ocHandler)			ON_EVENT_BEFORE_UPDATE(OC_NOTIFICATION_OLE_DROP, _idCntrl, _ocHandler, VTS_CTRL VTS_ORIGINOBJ VTS_I4 VTS_I4)


// Events for worksheet control
//WKSCTRL_EVENT_TYPE_CHANGE
//WKSCTRL_EVENT_DESI_CHANGE
#define ON_WKSCTRL_EVENT(_event, _ocHandler)		msgMap.AddDirectWndMsg(_event, ID_DLG, _ocHandler, VTS_I4 VTS_I4, MHO_BEFORE);
#define ON_WKSCTRL_CHANGE_COL_TYPE(_ocHandler)		msgMap.AddDirectWndMsg(WKSCTRL_EVENT_TYPE_CHANGE, ID_DLG, _ocHandler, VTS_I4 VTS_I4, MHO_BEFORE);
#define ON_WKSCTRL_CHANGE_COL_DESIG(_ocHandler)		msgMap.AddDirectWndMsg(WKSCTRL_EVENT_DESI_CHANGE, ID_DLG, _ocHandler, VTS_I4 VTS_I4, MHO_BEFORE);

//#define ON_SLIDER_SCROLL(_idCntrl, _ocHandler)		ON_EVENT(WM_HSCROLL, _idCntrl, _ocHandler)
//#define ON_SLIDE(_idCntrl, _ocHandler)				ON_EVENT(WM_HSCROLL, _idCntrl, _ocHandler)
#define ON_SLIDE_BEFORE(_idCntrl, _ocHandler)		ON_WM_HSCROLL_BEFORE(_idCntrl, _ocHandler)
#define ON_SLIDE(_idCntrl, _ocHandler)				ON_WM_HSCROLL(_idCntrl, _ocHandler)
#define ON_VSLIDE_BEFORE(_idCntrl, _ocHandler)		ON_WM_VSCROLL_BEFORE(_idCntrl, _ocHandler)
#define ON_VSLIDE(_idCntrl, _ocHandler)				ON_WM_VSCROLL(_idCntrl, _ocHandler)
#define ON_SIZE(_fn)								msgMap.AddDirectWndMsg(WM_SIZE, ID_DLG, _fn, VTS_I4 VTS_I4 VTS_I4, MHO_BEFORE);
#define ON_DESTROY(_fn)								msgMap.AddDirectWndMsg(WM_DESTROY, ID_DLG, _fn, VTS_VOID, MHO_BEFORE);
#define ON_TIMER(_fn)								msgMap.AddDirectWndMsg(WM_TIMER, ID_DLG, _fn, VTS_OIP, MHO_BEFORE);
// WM_CONTEXTMENU handler Proptotype:  BOOL Fn(UINT nResIDCtrl, int x/*screen*/, int y/*screen*/);
#define ON_CONTEXTMENU(_fn)							msgMap.AddDirectWndMsg(WM_CONTEXTMENU, ID_DLG, _fn, VTS_I4 VTS_I4 VTS_I4,MHO_BEFORE);
// WM_HELP handler Proptotype:  BOOL Fn(int &nHelpID, int nIdCtrlFocus);
// return FALSE if no need for help, of help handled by OC code, return TRUE if default help handling
#define ON_HELPINFO(_fn)							msgMap.AddDirectWndMsg(WM_HELP, ID_DLG, _fn, VTS_RI4 VTS_I4, MHO_BEFORE);
/// Kenny 12/08/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
// WM_GETMINMAXINFO handler Proptotype:  BOOL Fn(int &nMinTrackX, int &nMinTrackY);
//#define ON_GETMINMAXINFO(_fn)						msgMap.AddDirectWndMsg(WM_GETMINMAXINFO, ID_DLG, _fn, VTS_RI4 VTS_RI4, MHO_BEFORE);
// WM_GETMINMAXINFO handler Proptotype:  void Fn(MINMAXINFO* lpMMI);
#define ON_GETMINMAXINFO(_fn)						msgMap.AddDirectWndMsg(WM_GETMINMAXINFO, ID_DLG, _fn, VTS_PI4, MHO_BEFORE);
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS

//static BOOL OnUserMsg(uint wParam, uint lParam);
#define ON_USER_MSG(_msg, _fn)						msgMap.AddDirectWndMsg(_msg, ID_DLG, _fn, VTS_OIP VTS_OIP, MHO_BEFORE);						

// The following is a macro for the arguments sent to a function that
// handles a notifciation message.
#define NOTIFY_ARGS						Control ctrl
//#define EVENT_BEFORE_UPDATE_ARGS		Control ctrl, DWORD lParam
/// TD 3-30-05 QA70-7567 HANDLERS_FOR_COMMAND_RANGE
#define ON_MENU_CMD_RANGE(_idbegin, _idend,  _fn)    msgMap.AddCommandRange(_idbegin, _idend, _fn, VTS_I4);
/// end HANDLERS_FOR_COMMAND_RANGE
/// ML 1/19/2005 MAIN_MENU_DLG_OC_HANDLING
#define ON_MENU_CMD(_cmdid, _fn)					msgMap.AddDirectWndMsg(WM_COMMAND, _cmdid, _fn, VTS_VOID, MHO_BEFORE);
/// end MAIN_MENU_DLG_OC_HANDLING
#define ON_SYSCOMMAND(_fn)							msgMap.AddDirectWndMsg(WM_SYSCOMMAND, ID_DLG, _fn, VTS_I4, MHO_BEFORE);            
#define ON_PAGE_SPLITTER_READY(_fn)					msgMap.AddDlgMsg(SN_PAGE_SPLITTER_READY,_fn, VTS_VOID, MHO_BEFORE);
/// TD 1-17-06 QA70-8490 CREATE_DIALOG_FROM_TREE
#define ON_DYNAMIC_CONTROL(_idNode, _idContainer, _nMsg, _ocHandler)		msgMap.AddDynaCtrlMsg(_nMsg, _idNode, _ocHandler, VTS_RORIGINOBJ, MHO_NONE, _idContainer);
/// end CREATE_DIALOG_FROM_TREE

///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
#define ON_MARKEROBJ_EDIT(_fn)						msgMap.AddOriginMsg(SN_ON_MARKEROBJ_EDIT, _fn, VTS_ORIGINOBJ VTS_I4);
///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

///------ Folger 12/27/2011 ORG-4685-S3 OC_MOUSE_MOVE_ON_PAGE_EVENT
#define ON_PAGE_MOUSE_MOVE(_fn)						msgMap.AddOriginMsg(SN_MOUSE_MOVE_ON_PAGE, _fn, VTS_ORIGINOBJ VTS_PI4);
///------ End OC_MOUSE_MOVE_ON_PAGE_EVENT

///------ Folger 01/18/2012 ORG-4794-P1 OC_MOUSE_LBUTTON_DOWN_AND_UP_EVENT
#define ON_PAGE_LBUTTONDOWN(_fn)					msgMap.AddOriginMsg(SN_LBUTTONDOWN_ON_PAGE, _fn, VTS_ORIGINOBJ VTS_PI4);
#define ON_PAGE_LBUTTONUP(_fn)						msgMap.AddOriginMsg(SN_LBUTTONUP_ON_PAGE, _fn, VTS_ORIGINOBJ VTS_PI4);
///------ End OC_MOUSE_LBUTTON_DOWN_AND_UP_EVENT

///------ Folger 01/19/2012 ORG-4841-P1 FAILED_TO_SELECT_WORKSHEET_IF_ALREADY_ACTIVE_FROM_INTERATIVE_CONTROL
#define ON_PAGE_NCLBUTTONDOWN(_fn)					msgMap.AddOriginMsg(SN_NCLBUTTONDOWN_ON_PAGE, _fn, VTS_ORIGINOBJ VTS_PI4);
///------ End FAILED_TO_SELECT_WORKSHEET_IF_ALREADY_ACTIVE_FROM_INTERATIVE_CONTROL

///------ Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
///Sophy 9/13/2012 ORG-6504-P1 GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
//#define ON_GROBJ_EXECUTE(_fn)						msgMap.AddOriginMsg(SN_ON_GROBJ_EXECUTE, _fn, VTS_ORIGINOBJ VTS_I4);
#define ON_GROBJ_EXECUTE(_fn)						msgMap.AddOriginMsg(SN_ON_GROBJ_EXECUTE, _fn, VTS_ORIGINOBJ VTS_I4 VTS_I4);
///end GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
///------ End LT_GADGET_SUPPORT_VERTICAL_CURSOR

/**#
*/
bool	do_new_operation(const TreeNode& trNode, LPCSTR lpcszName, BOOL bTry = FALSE);

/// YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL
#if	_OC_VER >=0x0800
/**#
*/
void	GenerateInternalEvent(UINT nObjID, UINT nEvent);
#endif //_OC_VER >=0x0800
/// end NEW_DATA_SELECTOR_TOOL


#endif //_MSGMAP_H_