/*------------------------------------------------------------------------------*
 * File Name: GadgetManager.h													*
 * Creation:	Folger Lun														*
 * Purpose: Global Gadget Manager Header										*
 * Copyright (c) OriginLab Corp.2012											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#ifndef __GADGETMANAGER_H__
#define __GADGETMANAGER_H__

class	GadgetManager
{
public:
	GadgetManager();
	
public:
	/**$
	*/
	BOOL	Has(const GraphObject& goGadget);

	/**$
	*/
	BOOL	Add(const GraphObject& goGadget);

	/**$
	*/
	BOOL	Remove(const GraphObject& goGadget);

	/**$
	*/
	BOOL	AddLinkedGraph(const GraphObject& goGadget, const GraphPage& graph);

	/**$
	*/
	BOOL	RemoveLinkedGraph(const GraphObject& goGadget, const GraphPage& graph);

	/**$
	*/
	BOOL	GetLinkedGraphs(const GraphObject& goGadget, vector<OUID>& vnUIDs);

	/**$
	*/
	BOOL	GetLinkedGadgets(const GraphPage& graph, vector<OUID>& vnUIDs);

	/**$
	*/
	BOOL	GetSetting(StringArray& arrSettings);

	/**$
	*/
	BOOL	CreateGadget(LPCSTR lpcszSetting);
};

#endif //__GADGETMANAGER_H__