#ifndef _DIALOG_H
#define _DIALOG_H

#ifdef	 ORIGIN_COM_SUPPORT
#include <Control.h>
//#include <MsgMap.h>
#endif// ORIGIN_COM_SUPPORT
#include <Tree.h>
	/// ML 11/5/2007 PROOPER_MENU_LANGUAGE_WHEN_MENU_COMES_FROM_DLG_RESOURCE
	/// Folger 06/30/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO


/// Comments last updated by Cloud 03/15/2007
/**# >User Interface Controls
	This class is only available to OriginPro users.
*/
class Splitter : public WndContainer
{
public:
	Splitter();

	BOOL	SetGridSize(int nRows, int nCols);
	int		GetDlgCtrlID(int nrow = 0, int ncol = 0);
	BOOL	SetReady();
	BOOL	CreateControl(HWND hWndHolder);
	BOOL	CreateControl(HWND hWndParent, int nID);

	BOOL	CreatePane(Window &wnd, int nRow = 0, int nCol = 0, int nWidth = -1, int nLen = -1, DWORD dwStyle = 0);
	BOOL	CreateActiveXPane(GUID &clsid,  int nRow = 0, int nCol = 0, int nWidth = -1, int nLen = -1, LPCSTR License = NULL, DWORD dwStyle = 0);
	Window	GetPane(int nRow, int nCol);

	BOOL	SetRowSize(int nRow, int nSize, BOOL bPercent = TRUE);
	BOOL	SetColSize(int nCol, int nSize, BOOL bPercent = TRUE);

	BOOL	GetRowSize(int nRow, int &nSize, BOOL bPercent = TRUE);
	BOOL	GetColSize(int nCol, int &nSize, BOOL bPercent = TRUE);

	BOOL	GetRowColInfo(TreeNode &node);
	BOOL	SetRowColInfo(TreeNode &node);
	
	///Sophy 2/14/2011 ORG-2134-S1 OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	BOOL	GetSplitterGap(int& nGap);
	BOOL	SetSplitterGap(int nGap);
	///end OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
};
	
/**+
http://ocwiki.originlab.com/index.php?title=Category:Dialog_(class)
*/
class Dialog : public WndContainer
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-Dialog
	*/
	Dialog(LPCTSTR DlgName, LPCTSTR DllName);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-Dialog
	*/
	Dialog(UINT nDlgID, LPCTSTR DllName);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-Attach
	*/
	BOOL 	Attach(LPCTSTR DlgName, LPCTSTR DllName);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-Attach
	*/
	BOOL 	Attach(UINT nDlgID, LPCTSTR DllName);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-DoModal
	*/
	int  	DoModal(HWND hWndParent=NULL, DWORD dwOptions = 0, LPCSTR OpsName = NULL);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-Create
	*/
	BOOL	Create(HWND hWndParent=NULL, DWORD dwOptions = 0, LPCSTR OpsName = NULL);

	/**$
		Initializes the Object such that it can be Generated Dynamically using CreateFromTree method. 
		The CreateFromTree method itself calls this method, if not called by user.
		However when a message map is used, this function will initialize the object such that a message map 
		be associated prior to the creation of the object similar to GetNTree	
	Return:
		returns non-zero for success and FALSE otherwise	
	*/
	BOOL	SetAsDynamic();
	
	/**$
		creates a Dialog from the supplied TreeNode object(Not from resource), uses Tree Description similar to GetNTree.
	Parameters:
		tr = TreeNode objet which defines the dialog.
		bModal = When this is true, Dialog is a Modal Dialog, that is the call will not return until the dialog s closed
		hWndParent = the desired parent window. If NULL the active top level becomes the parent
		dwOptions = flags to control the dialog.
	Return:
		The Modal version will return the ID of the button clicked to close the dialog box. 
		The non-modal version returns non-zero for success and FALSE otherwise.
	*/
	int	CreateFromTree(TreeNode tr, BOOL bModal = FALSE, HWND hWndParent=NULL, DWORD dwOptions = 0);
	
	/**$	
	*/
	BOOL	IsShiftShow(BOOL bDefault=FALSE);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-SetTimer
	*/
	OUIP SetTimer( OUIP nIDEvent, uint nElapse);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-KillTimer
	*/
	BOOL KillTimer( OUIP nIDEvent );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-Close
	*/
	void Close(int nModalRet = -1);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-GetWindow
	*/
	Window	GetWindow();

	/**$
		This function instantiates OLE drag drop to Origin workspace
		Example:
			class CDragDrop : public Dialog
			{
				
				public:
					
				EVENTS_BEGIN
					ON_GRID_START_DRAG(IDC_VSFLEXGRIDL_DDS, OnStartDrag)
					ON_GRID_DRAG_DROP(IDC_VSFLEXGRIDL_DDT, OnDragDrop)
					ON_DROP_ORG_WORKSAPCE(IDC_VSFLEXGRIDL_DDS, OnDropOrigin)
				EVENTS_END

				CDragDrop():Dialog(IDD_DIALOG_DD, "<DragDropTest.dll>"){}

				int	CreateEx(HWND hParent)
				{
					InitMsgMap();// will be called from internal later
					return  Create(hParent);
				}
				
				BOOL OnDropOrigin(Control ctrlSrc, PageBase  pbTarget, int x, int y)
				{
					//Handle writing data from ctrlSrc to pbTarget
					return TRUE;
				}

				void OnStartDrag(Control cntrl, _VARIANT & vtDispatch, int *pInt)
				{
					int nn = 0;
					SetAsDragInducer(IDC_VSFLEXGRIDL_DDS);
				}
			};
			
		Return:
			Returns non-zero if Successful	else return 0.


		Parameters:
			nID		= The Control ID of the Drag Source
			bSet	= If true, Set the control to receive OC_NOTIFICATION_OLE_DROP notification, false will reset


	*/
	BOOL    SetAsDragInducer(uint nID, BOOL bSet = TRUE);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-SetResizingStyle
	*/
	BOOL	SetResizingStyle(DWORD dwStyle);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-Rollup
	*/
	BOOL Rollup(BOOL bClose = TRUE);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-IsRolledup
	*/
	BOOL IsRolledup();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-HasPreviousSize
	*/
	int HasPreviousSize(LPCSTR lpcszDialogName = NULL);
	
	/// Hong 01/17/11 ORG-1999 OC_RESIZE_NEED_INFO_OF_SIZING_EDGE
	/**$
		The edge of the window that is being sized, can be those WMSZ_*
	*/
	DWORD	GetResizingEdge();
	/// end OC_RESIZE_NEED_INFO_OF_SIZING_EDGE

	
#ifdef	 ORIGIN_COM_SUPPORT

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-GetItem
	*/
	Control GetItem(int ID, int nPageID = 0); 

protected:

	/**
	*/
	//Msgmap	m_msgmap;
	
#endif// ORIGIN_COM_SUPPORT
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-GetToolBar
	*/
	Window GetToolBar();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dialog-AddToolBar
	*/
	BOOL AddToolBar(int nRes, HINSTANCE hInstRes);

	/// ML 11/5/2007 PROOPER_MENU_LANGUAGE_WHEN_MENU_COMES_FROM_DLG_RESOURCE
	/**$
			If a menu has been previously set for the dlg (either via an association with the dlg resource or explcitily),
			it ets proper menu from resource according to the internal language.
	*/
	BOOL	SetLangMenu(uint nResID, HINSTANCE hInstance = NULL);
	/// end PROOPER_MENU_LANGUAGE_WHEN_MENU_COMES_FROM_DLG_RESOURCE

	///---Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED
	/**$
		Enable/Disable default button status
		Parameters:
			bAllow = enable default button if true
			nID = default button id, be used only if bAllow is true
			      0 means according to the property (style) of button in dialog resource file 

		Return:
			TRUE for success.
		Example:
	*/
	BOOL	SetDefaultButton(BOOL bAllow, UINT nID = 0);
	///---END QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED
};


/**+
http://ocwiki.originlab.com/index.php?title=Category:PropertyPage_(class)
*/
class PropertyPage : public WndContainer
{
	
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyPage-PropertyPage
	*/
	PropertyPage(int nID = 0);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyPage-SetID
	*/
	void	SetID(int nID);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyPage-GetID
	*/
	int 	GetID();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyPage-Attach
	*/
	BOOL 	Attach(int nResID, Dialog& dlgParentOwner); 

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyPage-Attach
	*/
	BOOL 	Attach(Dialog& dlgParentOwner);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyPage-OnShowStatus
	*/
	virtual DWORD	OnShowStatus(DWORD InternalStatus);
#ifdef	 ORIGIN_COM_SUPPORT

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyPage-GetItem
	*/
	Control GetItem(int ID); 
#endif// ORIGIN_COM_SUPPORT
	
};

// the following enum will be moved to OC_Const.h later


/**+
http://ocwiki.originlab.com/index.php?title=Category:PropertySheet_(class)
*/
class PropertySheet : public   WndContainer
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-PropertySheet
	*/
	PropertySheet(int nID = 0);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-SetID
	*/
	void	SetID(int nID); 

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-GetID
	*/
	int 	GetID();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-Attach
	*/
	BOOL 	Attach(int nResID, Dialog& dlgParentOwner);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-Create
	*/
	BOOL	Create(int nResID, Dialog& dlgParentOwner);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-AddPage
	*/
	BOOL	AddPage(int nID);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-AddPage
	*/
	BOOL	AddPage(PropertyPage & PropPage, int nID = 0);

	// Not implemented yet
	/**
	*/
	//BOOL	RemovePage(int nID);
	
	/**
	*/
	//BOOL	RemovePage(PropertyPage &Page);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-GetPage
	*/
	PropertyPage *GetPage(int nPage);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-GetActivePage
	*/
	PropertyPage *GetActivePage();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-GetPageCount
	*/
	int		GetPageCount();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-GetActiveIndex
	*/
	int		GetActiveIndex();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-GetPageIndex
	*/
	int		GetPageIndex(int nID);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-GetPageIndex
	*/
	int		GetPageIndex(PropertyPage &PropPage);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-RemovePage
	*/
	BOOL	RemovePage(int nID);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-RemovePage
	*/
	BOOL	RemovePage(PropertyPage &PropPage);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-SetActivePage
	*/
	BOOL	SetActivePage(int nPage);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-SetActivePage
	*/
	BOOL	SetActivePage(PropertyPage &PropPage);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-SetActivePageByID
	*/
	BOOL	SetActivePageByID(int nID);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertySheet-EnableApplyButton
	*/
	BOOL	EnableApplyButton(BOOL bEnable);

	
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:WizardSheet_(class)
*/
class WizardSheet : public 	PropertySheet
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-WizardSheet
	*/
	WizardSheet(int nID = 0);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-SaveSettings
	*/
	BOOL	SaveSettings(LPCSTR FileName);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-AddPathControl
	*/
	BOOL	AddPathControl(int nPercentWidth = 30);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-ShowPathControl
	*/
	BOOL	ShowPathControl(BOOL bShow);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-PageAccessLimit
	*/
	int		PageAccessLimit;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-EnableFinishButton
	*/
	BOOL	EnableFinishButton(BOOL bEnable);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-EnableNextButton
	*/
	BOOL	EnableNextButton(BOOL bEnable);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-EnableBackButton
	*/
	BOOL	EnableBackButton(BOOL bEnable);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-NextPage
	*/
	BOOL	NextPage(BOOL bDelayed = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WizardSheet-PrevPage
	*/
	BOOL	PrevPage(BOOL bDelayed = FALSE);
};



/**+
http://ocwiki.originlab.com/index.php?title=Category:DialogBar_(class)
*/
class DialogBar : public Control
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DialogBar-DialogBar
	*/
	DialogBar();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DialogBar-CreateControl
	*/
	///------ Folger 06/30/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
	//BOOL CreateControl(Dialog & dlg, LPCSTR lpcszName = NULL);
	BOOL CreateControl(Dialog & dlg, LPCSTR lpcszName = NULL, DWORD dwOptions = 0);
	///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DialogBar-Destroy
	*/
	BOOL Destroy();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DialogBar-Float
	*/
	BOOL Float(BOOL bFolat = TRUE);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DialogBar-IsFloating
	*/
 	BOOL IsFloating(); 
};

/**$
*/
class DialogPage : public PageBase
{
public:
	/**$
		Contructor, uses window name to attach to a DialogPage
	*/
	DialogPage(LPCSTR lpcszWindowName);
	
	/**$
		Copy contructor
	*/
	DialogPage(DialogPage &DlgPage);
	
	/**$
	Parameters:
		nOption = Standard Origin window create options including:
			CREATE_VISIBLE - creates a visible Notes page (window)
			CREATE_HIDDEN - creates a hidden Notes page
		dialog = An reference to a Dialog derived object, which is not yet attached to an actual window.
			The system requires the following member functions to create, save and load dialog status
			- BOOL Create(HWND hWndParent);	 //called to create the dialog window
			- BOOL GetSettingsTree(TreeNode &tn); //called to receive a treenode, which is serialized with page,
			- BOOL SetSettingsTree(const TreeNode &tn);	//called to restore settings using a treenode object recd earlier from a call made to GetSettingsTree.
			GetSettingsTree & SetSettingsTree are used to bring back the dialog to the same state it was before the page was saved. Internally pages are saved on hiding.			
	Return:
		return TRUE is successful else false.
	Remark:
		Creates an actula page object and the corresponding window etc.
	*/
	BOOL Create(int nOption, Dialog &dialog); // Create a new DialogPage window.
};

#endif // _DIALOG_H
