/*------------------------------------------------------------------------------*
 * File Name: Array.h															*
 * Creation: TD 2-11-03															*
 * Purpose: Origin C header file for Origin basic Data Vector types				*
 * Copyright (c) OriginLab Corp.	2002 - 2007									*
 * All Rights Reserved															*
 * Modifications:
 *	ML 7/1/2008 QA70-11794 REMOVEAT_METHOD_IN_OC_ARRAY							*
 *------------------------------------------------------------------------------*/


#ifndef _ARRAY_H_
#define	_ARRAY_H_

// Comments last updated by Iris on 03/13/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:Array_(class)
*/
class Array
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-Array
	*/
	Array(BOOL bOwner = FALSE );
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-Add
	*/
	int Add(_TemplType newElement);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-GetAt
	*/
	_TemplType GetAt(int nIndex) const;
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-SetAt
	*/
	BOOL SetAt(int nIndex, _TemplType newElement);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-SetAtGrow
	*/
	BOOL SetAtGrow(int nIndex, _TemplType newElement);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-GetSize
	*/
	int  GetSize();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-SetSize
	*/
	BOOL SetSize(int nNewSize);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-SetAsOwner
	*/
	BOOL	SetAsOwner(BOOL bIsOwner);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-IsOwner
	*/
	BOOL	IsOwner();

	/// ML 7/1/2008 QA70-11794 REMOVEAT_METHOD_IN_OC_ARRAY
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Array-RemoveAt
	*/
	BOOL	RemoveAt(int nIndex);
	/// end REMOVEAT_METHOD_IN_OC_ARRAY

};



#endif// _ARRAY_H_
