/*------------------------------------------------------------------------------*
 * File Name: xfdynadlg_utils.c													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 *	Modification Log:															*
 *	Sim 03-14-2008 ALLOW_DESTROY_ATTACHED_PAGE									*
 *	Folger 12/11/08 QA80-12764 v8.0985 MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK
 *	Kenny 11/23/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG	*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <MsgMap.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.

#include "xfdynadlg_utils.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

bool	xf_dynadlg_storage_control(Page &pg, LPCSTR lpcszNodeName, OIP &nVal, bool bGet) //bGet = true
{
	if ( !pg )
		return false;
	
	Tree tr;
	tree_get_binary_storage(tr, pg, XF_DIALOG_BINARY_STORAGE_NAME);
	TreeNode trNode = tree_get_node_by_tagname(tr, lpcszNodeName, true);
	bool bRet = trNode.IsValid();

	if (bGet)
	{
		if (trNode)
		{
			nVal =trNode.oipVal;
		}
	}
	else
	{
		if (nVal < 0)
		{
			if (trNode)
				trNode.Remove();
		}
		else
		{
			if ( !trNode )
				trNode = tr.AddNode(lpcszNodeName);

			trNode.oipVal = nVal;
		}
		
		bRet = tree_put_binary_storage(tr, pg, XF_DIALOG_BINARY_STORAGE_NAME);
	}
	return bRet;
}

bool	xf_dynadlg_hwnd_control(Page &pg, OIP &nHwnd, bool bGet)	//bGet = true
{
	const char node_name[] = "WindowHandle";
	return xf_dynadlg_storage_control(pg, node_name, nHwnd, bGet);
}

///Sophy 12/1/2011 ORG-145-P4 TEMP_DISABLE_REMINDER_MESSAGAES_FOR_PA
class	ReminderMessageDisabler
{
public:
	ReminderMessageDisabler()
	{
		LT_execute("type -mb");
	}
	~ReminderMessageDisabler()
	{
		LT_execute("type -me");
	}
};
#define	DISABLE_REMINDER_MESSAGE	ReminderMessageDisabler	_remindmessagedisabler
///end TEMP_DISABLE_REMINDER_MESSAGAES_FOR_PA
//------ Folger 12/11/08 QA80-12764 v8.0985 MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK
//bool	xf_dynadlg_shown_control(Page &pg, int &nShow, bool bGet)	//bGet = true
bool	xf_dynadlg_shown_control(Page &pg, int &nShow, bool bGet, bool bMinimizedBeforeHidden/* = false*/)	//bGet = true
//------ End MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK
{
	const char node_name[] = "Shown";
	OIP		oipShow = nShow;
	bool bRet = xf_dynadlg_storage_control(pg, node_name, oipShow, bGet);
	if ( bGet )
		nShow = oipShow;
	if (bRet && !bGet && nShow >= 0)
	{
		OIP nHwnd = 0;
		bRet = xf_dynadlg_hwnd_control(pg, nHwnd);
		HWND hwnd = (HWND) nHwnd;
		Window winDlg(hwnd);
				
		if (!winDlg)
			return false;
		
		int nRedraw = 1;
		xf_dynadlg_redraw_control(pg, nRedraw, true);
		if (nRedraw == 0 && nShow == 0)
		{
			/// Kenny 11/23/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
			//winDlg.SendMessage(WM_SETREDRAW, true);
			winDlg.SetRedraw(TRUE);
			winDlg.RedrawWindow(NULL, NULL, (RDW_FRAME | RDW_ERASE | RDW_INVALIDATE | RDW_ALLCHILDREN));
			/// End REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
		}
		//------ Folger 12/11/08 QA80-12764 v8.0985 MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK
		if ( bMinimizedBeforeHidden )
		{
			DISABLE_REMINDER_MESSAGE;	///Sophy 12/1/2011 ORG-145-P4 TEMP_DISABLE_REMINDER_MESSAGAES_FOR_PA
			bool	bIsRolledup = false;
			WPARAM	dw = (WPARAM)(void*)&bIsRolledup;
			if ( winDlg.SendMessage(WM_USER_IS_DIALOG_ROLLEDUP, dw) )
			{
				if ( nShow && bIsRolledup )
					winDlg.SendMessage(WM_SYSCOMMAND, SC_MAXIMIZE);
				else if ( !nShow && !bIsRolledup )
					winDlg.SendMessage(WM_SYSCOMMAND, SC_MINIMIZE);
			}
		}
		//------ End MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK
		bRet =  winDlg.ShowWindow(nShow ? SW_NORMAL : SW_HIDE);		
		if (nRedraw == 0)
		{
			/// Kenny 11/23/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
			//winDlg.SendMessage(WM_SETREDRAW, false);
			winDlg.SetRedraw(FALSE);
			/// End REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
		}
	}
	return bRet;
}

bool	xf_dynadlg_redraw_control(Page &pg, int &nRedraw, bool bGet)
{
	
	int nShow = 1;
	xf_dynadlg_shown_control(pg, nShow, true);
	
	const char node_name[] = "Redraw";
	OIP nOldRedraw = 1;
	xf_dynadlg_storage_control(pg, node_name, nOldRedraw, true);
	
	OIP	oipRedraw = nRedraw;
	bool bRet = xf_dynadlg_storage_control(pg, node_name, oipRedraw, bGet);
	if ( bGet )
		nRedraw = oipRedraw;
	if (bRet && !bGet && nRedraw >= 0)
	{
		OIP nHwnd = 0;
		bRet = xf_dynadlg_hwnd_control(pg, nHwnd);
		HWND hwnd = (HWND) nHwnd;
		Window winDlg(hwnd);
		
		if (!winDlg)
			return false;

		if ( nShow == 1 )
		{
			if ( nOldRedraw != nRedraw )
			{
				/// Kenny 11/23/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
				//winDlg.SendMessage(WM_SETREDRAW, nRedraw);
				winDlg.SetRedraw(nRedraw);
				if (nRedraw)
					winDlg.RedrawWindow(NULL, NULL, (RDW_FRAME | RDW_ERASE | RDW_INVALIDATE | RDW_ALLCHILDREN));
				/// End REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
			}
		}
	}
	return bRet;
}

/// YuI 04/02/08 WORK_ON_PA
static Window  _get_dynadlg_wnd(Page& pg)
{
	Window wndNull;
	OIP nHwnd = 0;
	if ( !xf_dynadlg_hwnd_control(pg, nHwnd) )
		return wndNull;

	HWND hwnd = (HWND) nHwnd;
	Window winReturn(hwnd);
	return winReturn;
}
bool	xf_dynadlg_post_msg(Page &pg, uint msg, DWORD wParam, DWORD lParam)
{
	Window winDlg = _get_dynadlg_wnd(pg);
	if( !winDlg )
		return false;
	
	return winDlg.PostMessage(msg, wParam, lParam);
}
/// end WORK_ON_PA
///---Sim 12-18-2007 SPECIFY_ACTIVE_PAGE_AFTER_XF_WIZ_FINISH
bool xf_dynadlg_send_msg(Page &pg, uint msg, WPARAM wParam, LPARAM lParam) // = 0, 0
{
	/// YuI 04/02/08 WORK_ON_PA
	/*
	int nHwnd = 0;
	if ( !xf_dynadlg_hwnd_control(pg, nHwnd) )
		return false;
	HWND hwnd = (HWND) nHwnd;
	Window winDlg(hwnd);
	if (!winDlg)
		return false;
	*/
	
	Window winDlg = _get_dynadlg_wnd(pg);
	if( !winDlg )
		return false;
	/// end WORK_ON_PA	
	return winDlg.SendMessage(msg, wParam, lParam);
}
///---END SPECIFY_ACTIVE_PAGE_AFTER_XF_WIZ_FINISH

bool check_xf_dynadlg_open(Page &pg)
{
	OIP nHwnd = 0;
	if (xf_dynadlg_hwnd_control(pg, nHwnd))
	{
		return true;
	}
	return false;
}

//typedef bool (*FUNC_FUNCTION_REF_HWND_REF)(Function funcGetCreateClass, HWND &hWnd);
///---Sim 03-14-2008 ALLOW_DESTROY_ATTACHED_PAGE
//typedef bool (*FUNC_PAGE_REF_FUNCTION_REF_HWND_REF_BOOL_LPCSTR)(Page& pg, Function funcGetCreateClass, HWND &hWnd = NULL, bool bScriptMode = false, LPCSTR lpcszDefaultThemeName = NULL);
typedef bool (*FUNC_PAGE_REF_FUNCTION_REF_HWND_REF_BOOL_LPCSTR)(Page& pg, Function funcGetCreateClass, HWND &hWnd = NULL, bool bScriptMode = false, LPCSTR lpcszDefaultThemeName = NULL, bool bDestroyPageOnClose = false);
///---END ALLOW_DESTROY_ATTACHED_PAGE

///---Sim 03-14-2008 ALLOW_DESTROY_ATTACHED_PAGE
//bool open_xf_wizard_dlg(LPCSTR lpcszFuncNameCreatClass, LPCSTR lpcszFuncFileCreatClass, bool bScriptMode, LPCSTR lpcszDefaultThemeName)// = false, NULL
bool open_xf_wizard_dlg(LPCSTR lpcszFuncNameCreatClass, LPCSTR lpcszFuncFileCreatClass, bool bScriptMode, LPCSTR lpcszDefaultThemeName, bool bDestroyPageOnClose)// = false, NULL, false
///---END ALLOW_DESTROY_ATTACHED_PAGE
{
	Page pg = Project.Pages();
	
	if (check_xf_dynadlg_open(pg))
	{
		warning_msg_box(CER_XF_DLG_ALREADY_OPEN, true);
		return false;
	}
	
	Function funcOpenDialog = Project.FindFunction("OpenXFWizard", "OriginLab\\XFWizardDlg.c");
	FUNC_PAGE_REF_FUNCTION_REF_HWND_REF_BOOL_LPCSTR fn = funcOpenDialog;
	if ( !fn )
		return error_report("Failed to find open xf wizard dialog function!");
	
	Function funcGetCreateClass = Project.FindFunction(lpcszFuncNameCreatClass, lpcszFuncFileCreatClass);
	//if ( !funcGetCreateClass )
		//return error_report("Failed to find create xf wizard class function!");
	HWND hWnd = NULL;
	bool bRet;
	//if ((bRet = fn(funcGetCreateClass, hWnd)))
		//page_set_xf_dynadlg_storage(pg, (int)hWnd, 1, 1);
	///---Sim 03-14-2008 ALLOW_DESTROY_ATTACHED_PAGE
	//bRet = fn(pg, funcGetCreateClass, hWnd, bScriptMode, lpcszDefaultThemeName);
	bRet = fn(pg, funcGetCreateClass, hWnd, bScriptMode, lpcszDefaultThemeName, bDestroyPageOnClose);
	///---END ALLOW_DESTROY_ATTACHED_PAGE
	return bRet;
}

static vector<string> s_vsFuncNames = {
	"create_pfm_wizard_class",
	"create_spfm_wizard_class",
	"create_bp_wizard_class",
	"create_paw_wizard_class" // Sandy 2008-2-4  add for test new design of Wizard
};
static vector<string> s_vsFuncFiles = {
	"OriginLab\\pfmwiz.cpp",
	"OriginLab\\spfmwiz.cpp",
	"OriginLab\\pfmwiz.cpp",
	"OriginLab\\pawiz.cpp" // Sandy 2008-2-4  add for test new design of Wizard
};

//bool open_xf_wizard_dlg(int nWizardDlgType)
///---Sim 03-14-2008 ALLOW_DESTROY_ATTACHED_PAGE
//bool open_xf_wizard_dlg(int nWizardDlgType, bool bScriptMode, LPCSTR lpcszDefaultThemeName)// = false, NULL
bool open_xf_wizard_dlg(int nWizardDlgType, bool bScriptMode, LPCSTR lpcszDefaultThemeName,  bool bDestroyPageOnClose)// = false, NULL, false
///---END ALLOW_DESTROY_ATTACHED_PAGE
{
	///---Sim 03-14-2008 ALLOW_DESTROY_ATTACHED_PAGE
	//return open_xf_wizard_dlg(s_vsFuncNames[nWizardDlgType], s_vsFuncFiles[nWizardDlgType], bScriptMode, lpcszDefaultThemeName);
	return open_xf_wizard_dlg(s_vsFuncNames[nWizardDlgType], s_vsFuncFiles[nWizardDlgType], bScriptMode, lpcszDefaultThemeName, bDestroyPageOnClose);
	///---END ALLOW_DESTROY_ATTACHED_PAGE
}


typedef bool (*FUNC_STR_HWND_REF)(LPCSTR lpcszXFName = NULL, HWND &hWnd = NULL);
//
bool open_xf_independent_dlg(LPCSTR lpcszXFName)
{
	Page pg = Project.Pages();
	
	if (check_xf_dynadlg_open(pg))
	{
		warning_msg_box(CER_XF_DLG_ALREADY_OPEN, true);
		return false;
	}
	
	FUNC_STR_HWND_REF pfn = Project.FindFunction("OpenXFIndep", "OriginLab\\XFIndepDlg.c");
	if (!pfn)
		return error_report("Failed to find open xf wizard dialog function!");
	
	HWND hWnd = NULL;
	bool bRet;
	//if ((bRet = pfn(lpcszXFName, hWnd)))
		//page_set_xf_dynadlg_storage(pg, (int)hWnd, 1, 1);
	bRet = pfn(lpcszXFName, hWnd);
	return bRet;
	
	return false;
}
