/*------------------------------------------------------------------------------*
 * File Name: themes_utils.c			 										*
 * Purpose: functions that are related to Themes and Copy/Paste formats			*
 * Copyright (c)2003 OriginLab Corp.											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 8/12/03 QA70-4999 v7.5656 FILENAME_WITH_DOT_SUPPORT						*
 *	RVD 9/15/2003 QA70-5179 v7.0695 THEME_SPECIAL_CONTEXT_MENU					*
 *  Danice 8/11/04 QA70-6638 v8.0114 MARK_SYSTEM_THEME_WITH_NAME_AND_PATH		*
 *	CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH								*
 *	CPY 9/30/04 SAVE_AS_FACTORY_DEFAULT_FAILED_NO_FOLDER						*
 *  Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME					*
 *	CPY 10/24/04 MORE_CENTRLIZATION_ON_THEME_SAVING								*
 *  SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *	Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE		*
 *	Frank 01/22/05 v8.0185b THEME_CENTERZIER_CODE								*
 *	Frank 1/25/05 THEME_SAVE_AS_DIALOG											*
 *	DSC 2/1/05 v8.0189 CENTRALIZE_PATH_PREFIX_CODES								*
 *	DSC 2/3/05 v8.0189 FIX_LINEARFIT_THEME_LIST									*
 *	DSC 2/4/05 v8.0189 LINEARFIT_SAVEAS											*
 *	DSC 2/15/05 QA70-7301 v8.0194 GET_ORIGIN_PATH								*
 *	RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT							*
 *	DSC 2/19/05 v8.0195 QA70-7416 GET_SYS_THEME_FOR_EACH_THM_TYPE				*
 *	DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME						*
 *	CPY 2/21/05 THEME_SAVE_FORMAT_WKS											*
 *	DSC 2/23/05 v8.0197 QA70-7416 GET_SET_SYS_THEME_FOR_EACH_THM_TYPE			*
 *	DSC 3/1/05 v8.0200 CENTRALIZE_PATH_CATEGORY_NAME_CODES						*
 *	DSC 3/7/05 v8.0201 MOVE_TO_OKUTIL											*
 *  Iris 03/07/05 QA70-7345 ADD_FB_FILTER_THEME									*
 *  Iris 3/22/05 SAVE_SYSTEM_THEME_TO_USER_FOLDER								*
 *	DSC 3/29/05 FIX_LAST_USED													*
 *	Frank 4/13/05 THEME_SUPPORT_SAVE_AS_SYSTEM_THEME							*
 *	Frank 4/15/05 SAVE_AS_SHOULD_FROM_PARENT_DLG								*
 *	DSC 4/19/05 UPDATE_DISCRIPTION_ON_SEL_CHANGE								*
 *	DSC 4/20/2005 ADD_AT_LEAST_FACTORY_DEFAULT									*
 *	DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC									*
 *	RVD 6/10/2005 v8.0249 FIX_CLEAR_SYSTEM_THEME								*
 *	YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT										*
 *	ML 8/25/2005 UPDATING_XF_OPS_THEMES_MENUS									*
 *	Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS						*
 *	Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME						*
 *  DG 9/22/05 v8.0310 XFTREE_TO_GETNTREE_UPDATE_NODE_IN_THEME					*
 *	ML 10/13/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS					*
 *  Iris 11/18/05 LOAD_SETTING_FACTOY_DEFAULT_BEFORE_LOAD_OTHERS				*
 *	DSC 2/1/06 CENTRALIZE_FIND_FILES_CODES										*
 *	CPY 4/15/06 THEME_TREE_NEEDS_IMPROVED_INFO_DISPLAY							*
 *	ML 4/26/2006 BORDERS_MOVED_TO_STYLE_BRANCH									*
 *	DSC 6/8/06 QA75-7518 XF_APPLY_THEME_SUPPORT_SEARCH							*
 *  Joe 7/28/06 THEME_EMPTY_SHOW_NAME											*
 *  Iris 8/01/06 FIX_XF_LAST_USED_NOT_WORK										*
 *  Joe 8/10/06   THEME_SCOPEINDEX_TO_SCOPENAME                                	*
 *  Joe 8/10/06   THEME_ANALYSIS_FILENAME_TO_OPTIONS                            *
 *  Joe 8/11/06 THEME_SCOPENAME_TO_SCOPEINDEX                                   *  
 *  Joseph 09/21/06   SHOW_CATEGORY_ON_SAVEAS									*
 *	ML 9/25/2006 TRANSLATING_ESCAPED_STRINGS_FOR_COPYTABLE						*
 *  SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET						*
 *	Jasmine 10/11/06 GET_CELL_AND_LABEL_HEIGHT									*
 *  Joseph  10/23/06 ADD_MULIXF_THEME											*
 *  Joseph 11/09/06	DESCRIPTOIN_TRIM_MENU										*
 *	Joseph 11/21/06 SHOW_DESCRIPTION_ON_FACTORY_DEFAULT							*
 *  Joseph 12/19/06 SET_THEME_DEFAULT_TO_FACTORY_DEFAULT						*
 *	Cheney 2006-12-27 SHOULD_CHECK_WKS_IF_IS_VALID_BEFORE_ATTACH				*
 *	Joseph 12/29/06 RESET_TREENODE_VARIABLE_ON_THEME_FACTORY_DEFAULT			*
 *	Jasmine 01/09/07 MODIFICATION_GET_CELL_HEIGHT								*
 *	ML 1/22/2007 QA70-9189 MAKING_A_FLAT_SHEET_WITH_LINKS_ONLY_AND_IN_DATA_AS_WELL_AS_LABELS_AREA_OUT_OF_A_WHOLE_SOURCE_TABLE
 *  Joseph 11/21/06 SHOW_DESCRIPTION_ON_FACTORY_DEFAULT							*
 *	Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG								*
 *	Jasmine 02/03/07 MINUS_MAY_BE_LABEL											*
 *	Jasmine 02/26/07 UTILITY_FUNC_FOR_TEXT_FORMAT								*
 *	ML 3/7/2007 QA70-9451 SET_LINKS_TRANSPOSED_ETC								*
 *	Joseph 03/16/07 FIX_BUG_ON_XF_CHANGE_TO_FACTORY_DEFAULT_THEME				*
 *	AW 03/21/07 FIX_MULTI_THEME_ISSUE											*
 *	Jasmine 03/24/07 APPLY_THENE_TO_GRAPH_IN_WKS								*
 *	ML 3/26/2006 MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE							*
 *	Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK								*
 *	Jasmine 03/27/07 MOVE_TO_TEXTFORMAT											*
 *	Jasmine 04/17/07 QA80-9619 APPEND_VECTOR_AND_FILL_DEFAULT_VALUE				*
 *	Joseph 04/29/07 TEMP_NOT_USING_SCOPE										*
 *	Folger 04/26/07 WKS_GET_CELL_HEIGHTS										*
 *	Cheney 2007-5-9 SURFACE_FIT_CAN_NOT_LOAD_FACTORY_DEFAULT_THEME				*
 *	ML 5/14/2007 LOADING_THEME_MUST_UPDATE_RANGES								*
 *	Folger 05/23/07 XF_IS_THEME_APPLIED											*
 *	Jasmine QA70-9837 GRAPHS_IN_WKS_SHOULD_EXCLUDE_SPARKLINES					*
 *	CPY 6/4/2007 QA70-9860 SPECIAL_THEME_NAME_FOR_FACTORY_DEFAULT				*
 *	Folger 06/19/07 ADD_INIT_THEME_LIST											*
 *	CPY 6/27/2007 EXP_GRAPH_SLOWNESS_DUE_TO_MAKE_TREE_CALL_3_TIMES				*
 *	Sim 06-30-2007 XF_IS_THEME_APPLIED											*
 *	Sim 06-30-2007 FIX_FACTORY_DEFAULT_THEME_APPIED_ISSUE						*
 *	Sim 06-30-2007 PUT_OUT_GLOBAL_FUNC											*
 *	Sim 07-20-2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
 *	Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS				*
 *	Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME								*
 *	Folger 08/07/07 MAKE_WKS_SET_CELL_HEIGHT_UNDOABLE							*
 *	Folger 08/07/07 MAKE_WKS_SET_COL_LABEL_HEIGHT_UNDOABLE						*
 *	Jasmine 08/13/07 MAKE_APPLY_UNDOABLE										*
 *	CPY 8/28/2007 QA70-10321 THEME_FROM_FACTORY_DEFAULT_GOT_SAVED				*
 *	CPY 8/30/2007 QA70-10231 ALLOW_THEME_TO_BE_REMEMBER_IF_USER_CHANGED_FROM_DIALOG_BUT_NOT_WHEN_FROM_MRM
 *	Jasmine 09/07/07 QA70-10355 NOT_APPLY_THEME_TO_REPORT_SHEET					*
 *	CPY 9/15/2007 QA70-10382 FACTORY_DEFAULT_SAVING_INTO_REGISTRY				*
 *	CPY 9/22/2007 QA70-10231 WHEN_CURRENT_THEME_SAVED_INSTEAD_OF_LAST_USED		*
 *	Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE									*
 *	Sim 11-05-2007 CLEAN_LOCALIZATION_CODE										*
 *	Sim 11-07-2007 IMPROVE_CHECK_LAST_USED_THEME								*
 *	Sim 11-07-2007 IMPROVE_GET_DISPLAY_THEME_NAME								*
 *	Folger 11/08/07 FIX_BUGS_WHEN_FIND_THEME_NAME_WITH_LOCALIZATION				*
 *	Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM								*
 *	Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO									*
 *	Folger 11/19/07 QA70-10694 CONVERT_KEYWORD_WHEN_THEME_SAVE_AND_LOAD			*
 *	Folger 11/23/07 SHOULD_NOT_SPECIFY_THEME_SELECTION_HERE						*
 *	Folger 11/28/07 ALLOW_COPY_AUTO_ATTRIBUTE									*
 *	Folger 12/18/07 FIXED_BUG_ON_KEYWORD_CONVERSION								*
 *	YuI 01/14/08 QA70-10936 GET_RUNTIME_DESCRIPTION_TWEAK						*
 *	Folger 01/17/08 JUST_CLONE_RUNTIME_TREE_WHEN_RESTORE						*
 *	Folger 02/27/08 QA80-11182WIZARD_THEME_VERSION_MECHANISM					*
 *	Folger 02/28/08 QA80-11182 LOAD_THEME_FAIL_SHOULD_RESET_GETN_TREE_THEME_FILE_NAME
 *	Folger 02/29/08 QA80-11192 SHOW_WARNING_WHEN_THEME_NOT_EXIST				*
 *	CPY 02/29/08 QA80-11192 IMPASC_BETTER_NO_THEME_HANDLING						*
 *	Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU						*
 *	Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
 *	Folger 03/04/08 QA80-11192 UPDATE_GETN_TREE_CLASS_OPTION					*
 *	Folger 03/05/08 QA80-11192 CENTRALIZE_THEME_TREE_SETTING_KNOWLEDGE			*
 *	Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM						*
 *	Folger 03/10/08 QA80-11192 THEME_LIST_SHOULD_INCLUDE_DEFAULT_INSTEAD_OF_FACTORY_DEFAULT
 *	Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM				*
 *	Folger 03/12/08 APPLY_NEW_DEFAULT_THEME_MECHANISM_FOR_GRAPH_EXPORT			*
 *	Folger 03/14/08 QA80-11192 MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC	*
 *	CPY 3/14/2008 QA70-11192-P7 REGISTRY_UPDATE_FROM_DIALOG_THEME_CHANGING_ONLY	*
 *	Folger 03/21/08 QA80-11192 FIX_DEFAULT_AND_SHEET_THEME_DISPLAY				*
 *	Folger 03/21/08 QA80-11267 FIX_FACTORY_DEFAULT_RECALCULATE_MODE				*
 *	RVD 3/24/2008 PRESERVE_USER_COMMENTS										*
 *	Folger 04/15/08 QA80-11192 FIX_FAIL_TO_LOAD_DEFAULT_THEME_IN_PA				*
 *	Folger 04/15/08 QA80-11192 LOAD_XF_WIZARD_DEFAULT_THEME_NEED_VERSION_CHECKING
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Folger 04/17/08 FIX_RESET_THEME_WILL_LOAD_LAST_USED_THEME					*
 *	Folger 04/17/08 NEED_TO_UPDATE_MENU_AFTER_RESET_THEME						*
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Folger 04/18/08 CORRECTLY_ADD_PA_THEME_IN_FLY_OUT_MENU						*
 *	Folger 05/20/08 CORRECT_THE_RETURN_VALUE_OF_IF_ELSE_CONTROL_FLOW			*
 *	Folger 06/16/08 FIX_DEFAULT_THEME_DISPLAY_IN_IMPORT_ASCII_FROM_FILE_IMPORT_MENU
 *	Folger 06/16/08 ERROR_ERPORT_FOR_DUPLICATE_NODE_ID_WHEN_APPLY_THEME			*
 *	Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
 *	Sim 07-04-2008 FIX_APPLY_WIZ_THEME											*
 *  Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
 *	Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER					*
 *	Folger 08/20/08 ADD_F1_CONTEXT_HELP_IN_THEME_SAVE_AS_DIALOG					*
 *	Sim 09-05-2008 QA80-12151 NLFIT_TOO_SLOW_TO_OPEN							*
 *	Sim 09-05-2008 CLEAN_DEFAULT_THEME											*
 *	RVD 9/23/2008 qa80-12200 PASTE_FORMAT_OVERWRITES_SPECIAL_ZOOM_LABELS		*
 *	Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING								*
 *	Sophy 10/24/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5							*
 *	Sim 11-17-2008 FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE					*
 *	Hong 11/19/08 QA80-12558 V8.90875 DESC_STATS_ON_COL_SUPPORT_DATA_FROM_GRAPH	*
 *	Hong QA80-11640 v8.0982b SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING		*
 *	CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS				*
 *	Sim 12-12-2008 IMPROVE_XF_WIZARD_FAILED_LOAD_THEME_ERROR_MESSAGE			*
 *	Sophy 12/18/2008 v8.0988 QA80-12798 CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU*
 *	Hong 12/19/08 QA80-11640 DRAG_AND_DROP_THEME_SHOULD_UPDATE_FLAY_OUT_MENU	*
 *	CPY 12/19/06 QA70-12736 RESTORE_THEME_OC_FUNC_FOR_LT_DIRECT_CALL			*
 *	Sim 01-09-2009 FIX_XF_WIZ_RESET_THEME_AND_THEN_SEL_THEME_RUNTIME_ERROR		*
 *	Sim 01-09-2009 FIX_LOAD_FACTORY_DEFAULT_TWICE_NO_NEED						*
 *	Folger 01/13/09 v8.0995d PA_CREATE_BASELINE_FAILS_TO_APPLY_RANGE_SETTINGS	*
 *	EJP 2009-01-26 QA80-13021 SUPPORT_DASH_IN_THEME_NAME						*
 *	Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5				*
 *	Folger 03/18/09 QA80-13261-P2 NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
 *	Folger 04/15/09 QA80-13454 SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
 *	Folger 04/29/09 SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
 *	Jasmine 07/14/09 NANOSZIER_NEED_DESCRIPTION_TO_REMINDER_USER				*
 *	Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS			*
 *	Sim 08-27-2009 QA81-14222 SHOW_HINT_FOR_BOOK_SHEET_THEME_SAVE_AS			*
 *	Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
 *	Folger 09/23/09 Q8A0-14339-P6 NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
 *	Folger 10/19/09 QA81-14145-S1 FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
 *  Iris 10/26/2009 QA81-14512-P1 FIX_NOT_SHOW_FLATOUT_MENU_FOR_FIT_LINEAR_WITH_XERR
 *  Iris 11/24/2009 QA81-3224-P3 FIX_SYSTEM_DEFAULT_NOT_CORRECTLY_APPLIED_ON_LR_XERR
 *	Folger 12/18/09 QA81-14859 THEME_SETTINGS_SUPPORT_APPLY_FIXED_STATUS_ONLY	*
 *	Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
 *	Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI					*
 *	Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
 *	Folger 04/22/10 QA81-15348 OP_CHANGE_FROM_PA								*
 *	Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *	Kyle 07/05/2010 QA80-13021-P2 theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
 *	Folger 08/04/10 ORG-705 COPY_COLORMAP_FORMAT_CONTEXT_MENU					*
 *	Folger 08/27/2010 ORG-679-P9 COLORMAP_OF_WATERFALL_FAILED_TO_BE_COPIED		*
 *	Kyle 09/25/2010 ORG-1148-P1 RUNTIME_ERROR_WHILE_COPY_TABLE_FOR_EMBEDDED_GRAPH
 *	Kyle 12/07/2010 ORG-731-P1 SUPPORT_COLORMAP_IN_SAVE_FORMAT_AS_THEME_DIALOG	*
 *	Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING		*
 *	Hong 01/19/11 ORG-1750 OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
 *	Folger 02/16/2011 ORG-2237-S2 SUPPORT_MERGE_COMMON_LABELS_AFTER_GENERATE_REPORT_DATA
 *	Folger 05/09/2011 ORG-2801-P3 BETTER_ERROR_MESSAGE_WHEN_THEME_NOT_EXIST		*
 *	Folger 05/09/2011 ORG-2801-P2 REDUNDANT_ERROR_MESSAGE_SHOW_FOR_INVALID_THEME_FILE_NAME
 *	Folger 05/19/2011 ORG-2801-P4 REDUNDANT_MESSAGE_SHOW_WHEN_RESET_SYSTEM_DEFAULT_IN_NLFIT
 *	CPY 7/28/2011 ORG-3350-P1 SHOULD_BE_ABLE_TO_SHIP_BUILT_IN_FUNCTION_THEMES	*
 *	Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT	*
 *	Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT			*
 *	Zech 08/11/2011 ORG-3492-P2 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
 *	Folger 09/07/2011 ORG-3718-P1 DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
 *	Folger 09/15/2011 ORG-3718-P3 PROPER_THEME_NAME_HANDLONG_IN_DATA_DISPLAY_SETTINGS
 *	Zech 10/09/2011 ORG-4011-P1 REFRESH_THE_HEIGHTS_OF_LABELS_WHEN_LABEL_INSERTS*
 *	Kyle 10/11/2011 ORG-3420-P1 WRONG_THEME_TYPE_DETECTING_METHOD				*
 *	Folger 11/03/2011 OC_ASSERT_WHEN_EXECUTE_OPERATION							*
 *	RVD 11/8/2011 ORG-4331 FIX_THEME_APPLY_FORMATS_APPLYTO_ACTIVEGRAPH			*
 *  Iris 4/06/2012 ORG-5438-P1 ADD_FITODR_XF									*
 *	Sim 2012-04-20 ORG-5493 FIX_INPUT_DATA_FOR_XYZ_MAT_FIT						*
 *	Kenny 07/20/2012 ORG-6234-P1 PLOT_ELEMENT_COPY_COLORMAP_FORMAT				*
 *	Zech 09/05/2012 ORG-3591-S1 OC_FUNC_FOR_ACCESS_REPORT_TABLE_CONTEXT_MENU	*
 *------------------------------------------------------------------------------*/
#include <Origin.h>

#pragma labtalk(0) //--- CPY 7/26/05 hide all functions in this file from LT access, as XF should be used instead

//#include <Project.h>
///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///#include <Dialog.h>
//#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
//#include <TreeEditor.h>
#include "theme_utils.h" // some theme related utility functions, will move into separate utils file later
#include <GetNBox.h>	//Forest 10/09/04, call get_operation_GUI_tree
///End REMOVE_DIALOGEX_FROM_THEME_ULTILS	
/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
//#include "XFunctionEx.h" CPY 1/27/06 REMOVE_XF_EX_H_FROM_THEME_UTILS
/// end XF_THEME_SUPPORT
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include "theme_utils.h" // some theme related utility functions, will move into separate utils file later
///	#include <GetNBox.h>	//Forest 10/09/04, call get_operation_GUI_tree
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H

#include "okThemeID.h"
//#include <ocTreeUtils2.h>
#include <okocUtils.h>
#include <ocTreeUtils.h>	///Joseph Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK 
#include <..\Originlab\XFtree.h> 
#include <..\Originlab\XFunction.h>
#include <Operation.h>		/// Zech 09/05/2012 ORG-3591-S1 OC_FUNC_FOR_ACCESS_REPORT_TABLE_CONTEXT_MENU
//////////////////////////////////////////////////////////
/////////// Theme Support Functions //////////////////////
//////////////////////////////////////////////////////////
#define STR_MULTIXF_THEME		"Is_MultiXFuns"   ///Joseph  10/23/06 ADD_MULIXF_THEME 
#define STR_AUTOUPDATE_NODE		"AutoUpdate"	///Joseph 03/16/07 FIX_BUG_ON_XF_CHANGE_TO_FACTORY_DEFAULT_THEME
#define STR_THEME_DLG_DESCRIPTION	_L("Please specify a theme name")	/// Max 11/1/07 CORRECT_LOCALIZATION
#define STR_THEME_NAME			_L("Theme Name")
#define STR_THEME_SAVE_AS		_L("Theme Save as...")
#define STR_SET_AS_SYSTEM_THEME	_L("Set As system theme")
///DSC 3/7/05 MOVE_TO_OKUTIL
/*
string theme_get_system_theme_file_name(int nThemeType)// = THEME_APPLY_LOAD_TEMPLATE);
{
	///DSC 2/28/05 DSC 2/23/05 v8.0197 QA70-7416 GET_SET_SYS_THEME_FOR_EACH_THM_TYPE
	/#
	Tree trTemp;
	trTemp.AddNode("Themes");
	
	// theme_find_all_theme_files(trTemp.FirstNode);
	theme_find_all_theme_files(trTemp.FirstNode, ORIGIN_PATH_UNDEF, nThemeType);///DSC 2/23/05

	TreeNode tn = trTemp.FirstNode;
	tn = tn.FirstNode;
	string str, strFilename, strThemeName;
	
	while(tn)
	{
		int nPathType, nRow;
		tn.GetAttribute(THEME_TYPE_ATTRIBUTE, nPathType);
		
		///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE  nPathType is of type ORIGIN_PATH_TYPE already
		// bool bIsEXEpath = (nPathType == THTYPE_SYSTEM)? true:false;
		///end USE_ENUM_ORIGIN_PATH_TYPE
		
		strThemeName = tn.strVal;

		///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE replaced bIsEXEpath with nPathType below
		// if(theme_system_getset(strThemeName, false, false, nPathType))	///Danice MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
		if(theme_system_getset(strThemeName, false, false, nPathType, nThemeType))///DSC 2/23/05
		{
			///Iris 2/22/05 QA70-7416 UPDATE_THEME_GET_FILENAME	
			//strFilename = theme_get_theme_file_name(strThemeName, nPathType);
			// strFilename = theme_get_theme_file_name(strThemeName, THTYPE_GRAPH, nPathType);
			strFilename = theme_get_theme_file_name(strThemeName, nThemeType, nPathType);
			///end UPDATE_THEME_GET_FILENAME
			break;
		}
		///end USE_ENUM_ORIGIN_PATH_TYPE
		
		tn = tn.NextNode;
	}
	
	return strFilename
	#/
	
	int nPathType;
	string strSysThemeName, strFilename;
	
	//-- get system theme name and path type
	strSysThemeName = str_extract_path_type(theme_get_system_theme(nThemeType), &nPathType);
	
	//-- construct full path
	if(!strSysThemeName.IsEmpty())
		strFilename = theme_get_theme_file_name(strSysThemeName, nThemeType, nPathType);
	
	return strFilename;
	///end GET_SET_SYS_THEME_FOR_EACH_THM_TYPE
}
*/
///end 3/7/05 MOVE_TO_OKUTIL



///DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME
/*
string	theme_get_system_theme()
{
	INIFile ini;
	
	string strThemeSection = THEME_INI_SECTION;
	string strThemeItem = THEME_INI_ITEM;
	string strSysTheme = ini.ReadString(strThemeSection, strThemeItem);

	return strSysTheme;
}
*/

//------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
#define THEME_DEFAULT_SETTING		"Default"		
//------

#define THEME_INI_SECTION	"Display"
#define THEME_INI_ITEM		"SysTheme"
//-- this gets old 7.5 system theme from ini file. I added an argument to get path.
//-- [Display]
//-- SysTheme=Color Publication
//-- Path=Origin
string	theme_get_system_theme(string* pstrPathKeyword) //strPathKeyword=NULL
{
	INIFile ini;
	
	string strSysTheme = ini.ReadString(THEME_INI_SECTION, THEME_INI_ITEM);
	
	if(pstrPathKeyword)
		*pstrPathKeyword = ini.ReadString(THEME_INI_SECTION, THEME_INI_ITEM_PATH);
		
	return strSysTheme;
}
///end CLEANUP_GET_SYSTEM_THEME

///Joseph 04/28/07 ADD_XF_VERSION_FOR_MULITHEME
static bool _theme_tree_set_version(TreeNode& trTheme, const TreeNode& trGetN)
{
	if(!(trGetN && trTheme))
		return false;
	
	string strVersion;
	if(trGetN.GetAttribute(STR_XF_VERSION, strVersion))
	{
		trTheme.SetAttribute(STR_XF_VERSION, strVersion);
	}
	else
		return false;
	return true;
}

//------ Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM
//static int _check_verion_on_loading_theme(const TreeNode& trTheme, const TreeNode& trGetN) // -1, not xf tree, 0, return false; 1, return true;
static int _check_verion_on_loading_theme(const TreeNode& trTheme, const TreeNode& trGetN, LPCSTR lpcszThemeName) // -1, not xf tree, 0, return false; 1, return true;
//------ End WIZARD_THEME_VERSION_MECHANISM
{
	string strXFVersion;
	if(trGetN.GetAttribute(STR_XF_VERSION, strXFVersion))
	{
		string strThemeVersion;
		if(!trTheme.GetAttribute(STR_XF_VERSION, strThemeVersion))
			return -1;
		//------ Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM
		//if(is_integer_part_less_then(strThemeVersion, strXFVersion))
		string strXFName;
		trGetN.GetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, strXFName);
		if ( !theme_check_version_show_warning(strThemeVersion, strXFVersion, lpcszThemeName, "XF " + strXFName) )
		//------ End WIZARD_THEME_VERSION_MECHANISM
			return 0;
		return 1;
	}
	return -1;
}
///End ADD_XF_VERSION_FOR_MULITHEME

///DSC 3/7/05 v8.0201 MOVE_TO_OKUTIL
/*
///DSC 2/19/05 v8.0195 QA70-7416 GET_SYS_THEME_FOR_EACH_THM_TYPE
static string theme_get_system_theme_ini_keyname(int nThemeType)
{
	string strKeyName;
	switch (nThemeType)
	{
	case THTYPE_GRAPH:
		//strKeyName = "GraphNewWindow";
		strKeyName = THEME_INI_ITEM_GRAPH;
		break;
	// case THTYPE_GRAPH_AFTER: 
	// 	strKeyName = THEME_INI_ITEM_GRAPH;
	// 	break;
	case THTYPE_WORKSHEET:
		strKeyName = THEME_INI_ITEM_WKS;
		break;
	case THTYPE_MATRIX:
		strKeyName = "WksNewReport";
		break;
	case THTYPE_ANALYSIS:
		strKeyName = "Analysis";
		break;
	case THTYPE_DIALOG:
		strKeyName = "Dialog";
		break;
	case THTYPE_REPORT_TABLE:
		strKeyName = "Table";
		break;
	default:
		strKeyName = "";
		break;
	};
	
	return strKeyName;
}
*/
///end MOVE_TO_OKUTIL

//-- For 8.0, given a theme type THTYPE_GRAPH etc,
//-- read the associated system theme from USER's ini file and
//-- return in the form  "System : Color Publication".
//-- The ini looks like
//-- [System Themes]
//-- GraphNewWindow = System : Color Publication
//-- GraphNewGraph = System : Color Publication
//-- WksNewSheet = Group : Professional
//-- WksNewReport = System : Simple
//-- MatrixNewSheet = User : My Funky Colors
///DSC 3/7/05 v8.0201 MOVE_TO_OKUTIL
/*
string	theme_get_system_theme(int nThemeType)
{
	string strThemeKeyname = theme_get_system_theme_ini_keyname(nThemeType);
	
	INIFile ini;
	
	string strSysTheme = ini.ReadString(THEME_SYSTEM_THEME_INI_SECTION, strThemeKeyname);
	return strSysTheme;
}
*/
///end MOVE_TO_OKUTIL
///end GET_SYS_THEME_FOR_EACH_THM_TYPE

///DSC 2/15/05 QA70-7301 v8.0194 GET_ORIGIN_PATH rewrote function to use ORIGIN_PATH_TYPE
/*
bool theme_system_getset(string strThemeName, bool bSet, bool bSetAs, bool bIsEXEPath) // = false, = false, =false  if not set, then test
{
	INIFile ini;
	
	string strThemeSection = THEME_INI_SECTION;
	string strThemeItem = THEME_INI_ITEM;
	string strSysTheme = ini.ReadString(strThemeSection, strThemeItem);
	
	///Dancie MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
	string strThemeItemPath = THEME_INI_ITEM_PATH;
	string strSysThemePath = ini.ReadString(strThemeSection, strThemeItemPath);
	bool bIsSysThemeEXEPath = strSysThemePath.CompareNoCase(STR_THEME_TYPE_SYSTEM) == 0 ? true : false;
	
	//if(strSysTheme.CompareNoCase(strThemeName) == 0 && !(bSet && !bSetAs))
		//return true; // nothing to do in any case
	if((bIsSysThemeEXEPath == bIsEXEPath) && strSysTheme.CompareNoCase(strThemeName) == 0 && !(bSet && !bSetAs))
		return true; // nothing to do in any case
	///end
	
	if(bSet)
	{
		if(bSetAs) // don't worry about EXE path for now
		{
			ini.WriteString(strThemeSection, strThemeItem, strThemeName);
			ini.WriteString(strThemeSection, strThemeItemPath, bIsEXEPath ? STR_THEME_TYPE_SYSTEM : STR_THEME_TYPE_USER);	///Dancie MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
		}
		else
			ini.WriteString(strThemeSection, strThemeItem, "");// to Clear it
	
		return true;
	}
	else
		return false;
}
*/
///DSC 2/23/05 v8.0195 QA70-7416 SET_SYS_THEME_FOR_EACH_THM_TYPE
// bool theme_system_getset(string strThemeName, bool bSet, bool bSetAs, int nPathType)
bool theme_system_getset(string strThemeName, bool bSet, bool bSetAs, int nPathType, int nThemeType)
///end SET_SYS_THEME_FOR_EACH_THM_TYPE
{
	///DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME use theme_get_system_theme
	/*
	INIFile ini;// user files ini file
	
	string strThemeSection = THEME_INI_SECTION;//Display
	string strThemeItem = THEME_INI_ITEM;//SysTheme
	string strSysTheme = ini.ReadString(strThemeSection, strThemeItem);
	
	string strThemeItemPath = THEME_INI_ITEM_PATH;//Path, better to call it SysThemePath
	// string strSysThemePathKeyWord = ini.ReadString(strThemeSection, strThemeItemPath);//=ORIGIN bug here, in ini file strSysThemePath is set as Origin, not System
	string strSysThemePathKeyWord = ini.ReadString(THEME_INI_SECTION, THEME_INI_ITEM_PATH);
	*/
	
	///DSC 2/23/05 v8.0195 QA70-7416 GET_SET_SYS_THEME_FOR_EACH_THM_TYPE
	// string strSysTheme, strSysThemePathKeyWord;
	// strSysTheme = theme_get_system_theme(&strSysThemePathKeyWord);
	string strSysTheme;
	strSysTheme = okutil_theme_get_system_theme(nThemeType);
	///end CLEANUP_GET_SYSTEM_THEME
	
	//-- check if ini file data already agrees with runtime info
	///DSC 2/23/05 v8.0195 QA70-7416 GET_SET_SYS_THEME_FOR_EACH_THM_TYPE
	// // if((bIsSysThemeEXEPath == bIsEXEPath) && strSysTheme.CompareNoCase(strThemeName) == 0 && !(bSet && !bSetAs))
	// string strPathKeyword = get_origin_path_keyword(nPathType);
	// if(strSysThemePathKeyWord.CompareNoCase(strPathKeyword)==0 && strSysTheme.CompareNoCase(strThemeName)==0)
	// 	return true;
	///DSC 3/1/05 v8.0200 CENTRALIZE_PATH_CATEGORY_NAME_CODES
	// string strPathPrefixAndFileName = attach_path_prefix_to_filename(nPathType, strThemeName);
	// string strPathPrefixAndFileName = okutil_str_construct_path_category_name(nPathType, NULL, strThemeName);
	string strPathPrefixAndFileName = okutil_composite_name_from_components(nPathType, NULL, strThemeName);
	///end CENTRALIZE_PATH_CATEGORY_NAME_CODES
	
	if(strSysTheme.CompareNoCase(strPathPrefixAndFileName)==0)
	{
		if( !bSet )			/// RVD 6/10/2005 v8.0249 FIX_CLEAR_SYSTEM_THEME
			return true;
	}
	///end GET_SET_SYS_THEME_FOR_EACH_THM_TYPE
	
	
	if(bSet)
	{
		INIFile ini; ///DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME
		
		if(bSetAs)
		{
			///DSC 2/23/05 v8.0195 QA70-7416 GET_SET_SYS_THEME_FOR_EACH_THM_TYPE
			// ini.WriteString(THEME_INI_SECTION, THEME_INI_ITEM, strThemeName);
			//  //ini.WriteString(strThemeSection, strThemeItemPath, bIsEXEPath ? STR_THEME_TYPE_SYSTEM : STR_THEME_TYPE_USER);	///Dancie MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
			// ini.WriteString(THEME_INI_SECTION, THEME_INI_ITEM_PATH, get_origin_path_keyword(nPathType));	///Dancie MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
			// ini.WriteString(THEME_SYSTEM_THEME_INI_SECTION, theme_get_system_theme_ini_keyname(nThemeType), strThemeName);
			ini.WriteString(THEME_SYSTEM_THEME_INI_SECTION, okutil_theme_get_system_theme_ini_keyname(nThemeType), strPathPrefixAndFileName);
			///end GET_SET_SYS_THEME_FOR_EACH_THM_TYPE
		}
		else
		{
			/// RVD 6/10/2005 v8.0249 FIX_CLEAR_SYSTEM_THEME
			//ini.WriteString(THEME_INI_SECTION, THEME_INI_ITEM, "");// to Clear it
			ini.WriteString(THEME_SYSTEM_THEME_INI_SECTION, okutil_theme_get_system_theme_ini_keyname(nThemeType), "");
			/// end FIX_CLEAR_SYSTEM_THEME
		}
	
		return true;
	}
	else
		return false;
}

///end GET_ORIGIN_PATH



///DSC 2/15/05 GET_ORIGIN_PATH
// string theme_get_theme_file_name(string strThemeName, bool bIsEXEpath) //= false
// {
// 	//------ CPY 8/12/03 QA70-4999 v7.5656 FILENAME_WITH_DOT_SUPPORT
// 	//	// make sure there is no dot in file name
// 	//	int nDotPos = strThemeName.ReverseFind('.');
// 	//	if(nDotPos > 0)
// 	//		strThemeName = strThemeName.Left(nDotPos);
// 	//	//
// 	//	return theme_get_path(bIsEXEpath) + strThemeName + "." + THEME_FILE_EXT;
// 	string strFilename = theme_get_path(bIsEXEpath) + strThemeName;
// 	
// 	add_file_extension(strFilename, THEME_FILE_EXT);
// 	return strFilename;
// 	//------
// }
///Iris 2/22/05 QA70-7416 UPDATE_THEME_GET_FILENAME
//string 	theme_get_theme_file_name(string strThemeName, int nPathType)//=ORIGIN_PATH_USER
//{
	//string strFullFilename = theme_get_path(nPathType) + strThemeName;
	//
	//add_file_extension(strFullFilename, THEME_FILE_EXT);
	//
	//return strFullFilename;
//}
///GET_ORIGIN_PATH
///DSC 3/7/05 v8.0201 MOVE_TO_OKUTIL
/*
string 	theme_get_theme_file_name(string strThemeName, int thtype, int nPathType)//=THTYPE_GRAPH, =ORIGIN_PATH_USER
{
	string strFullFilename = theme_get_path(nPathType, thtype) + strThemeName;
	
	//--- CPY 2/24/05 ANALYSIS_THEME_NOT_WORKING_CLEAN_UP 
	//add_file_extension(strFullFilename, theme_get_file_extension(thtype));
	strFullFilename += theme_get_file_extension(thtype); // add_file_extension added extra .
	//---
	return strFullFilename;
}
*/
///end MOVE_TO_OKUTIL
///End UPDATE_THEME_GET_FILENAME

///DSC 2/15/05 GET_ORIGIN_PATH
/*
bool theme_rename(string strThemeName, string strOldName, bool bIsEXEpath)
{
	bool bWasSysemTheme = theme_system_getset(strOldName, false, false, bIsEXEpath)? true : false;	///Danice MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
	string strOldFile = theme_get_theme_file_name(strOldName, bIsEXEpath);
	string strNewFile = theme_get_theme_file_name(strThemeName, bIsEXEpath);
	if(strNewFile.IsFile())
		return false;
	if(bWasSysemTheme)
		theme_system_getset(strThemeName, true, bWasSysemTheme , bIsEXEpath);

	return RenameFile(strNewFile, strOldFile);
}

bool theme_rename(string strThemeName, string strOldName, int nPathType, int nThemeType)
{
	bool bWasSystemTheme = theme_system_getset(strOldName, false, false, nPathType, nThemeType);
	///Iris 2/22/05 QA70-7416 UPDATE_THEME_GET_FILENAME	
	//string strOldFile = theme_get_theme_file_name(strOldName, nPathType);
	//string strNewFile = theme_get_theme_file_name(strThemeName, nPathType);
	string strOldFile = okutil_theme_get_theme_file_name(strOldName, THTYPE_GRAPH, nPathType);
	string strNewFile = okutil_theme_get_theme_file_name(strThemeName, THTYPE_GRAPH, nPathType);
	///end UPDATE_THEME_GET_FILENAME
	if(strNewFile.IsFile())
		return false;
	if(bWasSystemTheme)
		theme_system_getset(strThemeName, true, bWasSystemTheme, nPathType, nThemeType);

	return RenameFile(strNewFile, strOldFile);
}
*/

///end GET_ORIGIN_PATH




///DSC 2/15/05 GET_ORIGIN_PATH
// string theme_get_path(bool bEXEpath)// = false)
// {
// 	string strPath = GetAppPath(bEXEpath);
// 	
// 	strPath += THEME_SUB_FOLDER + "\\";
// 	
// 	return strPath;
// }
///Iris 2/22/05 QA70-7416
//string theme_get_path(int nPathType) // = ORIGIN_PATH_USER
///DSC 3/7/05 v8.0201 MOVE_TO_OKUTIL
/*
string theme_get_path(int nPathType, int thtype, bool bCheckUnique) //= ORIGIN_PATH_USER, = THTYPE_GRAPH = false
{
	//--- CPY 2/24/05
	if(bCheckUnique) // return empty path if check and found same as User path or Path does not exist
	{
		string str = GetOriginPath(nPathType, true);
		if(str.IsEmpty())
			return str;
	}
	//----
		
	///Iris 2/22/05 QA70-7416
	//string strPath = get_origin_path(nPathType, THEME_SUB_FOLDER);
	string strThemeFolder = THEME_SUB_FOLDER  + "\\"; 
	string strSubFolder = _theme_get_sub_special_folder(thtype);
	if( !strSubFolder.IsEmpty() )
		strThemeFolder += strSubFolder + "\\";
	
	string strPath = get_origin_path(nPathType, strThemeFolder);
	
	return strPath;
}
*/
///end MOVE_TO_OKUTIL
///end GET_ORIGIN_PATH

int		theme_count_properties(LPCSTR lpcszThemeFilename, int* lpnSections)// = NULL);
{
	Tree trTheme(lpcszThemeFilename);
	if(trTheme)
		return tree_count_items(trTheme, lpnSections);
	else
		return -1;
}

bool theme_is_in_clipboard()
{
	int nCFStyles = GetOriginClipboardFormat();
	if(nCFStyles == 0 || !OpenClipboard(NULL))
		return FALSE;
	
	if(!IsClipboardFormatAvailable(nCFStyles))
	{
		CloseClipboard();
		return FALSE;
	}
	CloseClipboard();
	return TRUE;
}

///DSC 2/16/05 GET_ORIGIN_PATH
// //add a theme file (fullpath) to given TreeNode
// TreeNode theme_add_one_theme_file(TreeNode& trNode, const string& strFilename, bool bUser)// = true)
// {
// 	string strAttrib = THTYPE_SYSTEM;
// 	if(bUser)
// 		strAttrib = THTYPE_USER;
// 	
// 	TreeNode tnTemp = trNode.AddTextNode(GetFileName(strFilename, TRUE), THEME_FILE_NODE_NAME);
// 	tnTemp.SetAttribute(THEME_TYPE_ATTRIBUTE, strAttrib);
// 	return tnTemp;
// }
//add a theme file (fullpath) to given TreeNode
//should pass strFilename as file name without path			///Kyle 07/05/2010 QA80-13021-P2 theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
TreeNode theme_add_one_theme_file(TreeNode& trNode, const string& strFilename, int nPathType)
{
	if(ORIGIN_PATH_UNDEF==nPathType)
		nPathType = ORIGIN_PATH_USER;
	
	///Kyle 07/05/2010 QA80-13021-P2 theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
	//TreeNode tnTemp = trNode.AddTextNode(GetFileName(strFilename, TRUE), THEME_FILE_NODE_NAME);
	TreeNode tnTemp = trNode.AddTextNode(strFilename, THEME_FILE_NODE_NAME);
	///End theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
	tnTemp.SetAttribute(THEME_TYPE_ATTRIBUTE, nPathType);
	return tnTemp;
}
///end GET_ORIGIN_PATH



///DSC 2/15/05 GET_ORIGIN_PATH re-write below
// uint theme_find_all_theme_files(TreeNode& trNode)
// {
// 	StringArray sa;
// 	
// 	
// 	// string strSysPath = theme_get_path(TRUE);
// 	string strSysPath = theme_get_path(ORIGIN_PATH_SYSTEM);///DSC 2/15/05 GET_ORIGIN_PATH
// 	
// 	
// 	FindFiles(sa, strSysPath, THEME_FILE_EXT);
// 	int ii, jj, kk;
// 	
// 	for(ii = 0; ii < sa.GetSize(); ii++)
// 		theme_add_one_theme_file(trNode, sa[ii], false);
// 
// 	// string strUserPath = theme_get_path(FALSE);
// 	string strUserPath = theme_get_path(ORIGIN_PATH_USER);///DSC 2/15/05 GET_ORIGIN_PATH
// 	
// 	if(strUserPath.CompareNoCase(strSysPath) == 0)
// 		return ii;
// 		
// 	sa.SetSize(0);
// 	FindFiles(sa, strUserPath, THEME_FILE_EXT);
// 
// 	for(jj = 0; jj < sa.GetSize(); jj++)
// 		theme_add_one_theme_file(trNode, sa[jj], true);
// 	
// 	
// 	return ii + jj;
// 
// 	
// }
// **** temp  move to utility class as SearchArray(Vector<type>&, const <type>&)
// returns array of indices where string was found.
static vector<int> SearchStringArray(const StringArray& sa, const string& str)
{
	vector<int> viPositions;

	for(int ii=0; ii<sa.GetSize(); ii++)
	{
		string strInArray = sa[ii];
		if(str.CompareNoCase(strInArray)==0) //found
			viPositions.Add(ii);
	}
	
	return viPositions;
}
// end temp ****

///DSC 2/23/05 v8.0197 QA70-7416 ADD_THEME_TYPES
int theme_get_type_from_page_type(int nPageType)
{
	if(EXIST_PLOT == nPageType)
		return THTYPE_GRAPH; //THTYPE_GRAPH_AFTER;
		
	else if(EXIST_WKS == nPageType)
		return	THTYPE_WORKSHEET;
	
	return	THTYPE_UNDEF;
}
///DSC 3/7/05 v8.0201 MOVE_TO_OKUTIL
/*string theme_get_file_extension(int nThemeType)
{
	string strExt = '.';
	switch(nThemeType)
	{
	case THTYPE_ANALYSIS:
	case THTYPE_DIALOG:
		strExt += ANALYSIS_THEME_FILE_EXT;
		break;
		
	default:
		strExt += THEME_FILE_EXT;
		break;
	}
	
	return strExt;
}
*/
///end MOVE_TO_OKUTIL
///end ADD_THEME_TYPES

///DSC 2/1/06 CENTRALIZE_FIND_FILES_CODES
/*
// uint theme_find_all_theme_files(TreeNode& trNode, int nPathType, int nThemeType)//==ORIGIN_PATH_UNDEF
uint theme_find_all_theme_files(TreeNode& trNode, int nPathType, int nThemeType)//==ORIGIN_PATH_UNDEF, THTYPE_GRAPH ///DSC 2/23/05 v8.0197 QA70-7416 ADD_THEME_TYPES
{
	StringArray saFiles;
	
	if(ORIGIN_PATH_UNDEF==nPathType)
	{
		int nTotNumOfThemes;
		
		///DSC 2/23/05 v8.0197 QA70-7416 ADD_THEME_TYPES add nThemeType below.
		nTotNumOfThemes  = theme_find_all_theme_files(trNode, ORIGIN_PATH_SYSTEM, nThemeType);
		nTotNumOfThemes += theme_find_all_theme_files(trNode, ORIGIN_PATH_GROUP, nThemeType);
		nTotNumOfThemes += theme_find_all_theme_files(trNode, ORIGIN_PATH_USER, nThemeType);
		return nTotNumOfThemes;
	}
	else
	{
		//-- get path
		// string strThemePath = theme_get_path(nPathType);
		string strThemePath = okutil_theme_get_path(nPathType, nThemeType);
	
		//-- find theme files
		// FindFiles(saFiles, strThemePath, THEME_FILE_EXT);
		FindFiles(saFiles, strThemePath, okutil_theme_get_file_extension(nThemeType));
		
		//-- add to theme tree
		int nSize = saFiles.GetSize();
		for(int ii = 0; ii < nSize; ii++)
			theme_add_one_theme_file(trNode, saFiles[ii], nPathType);
		
		return nSize;
	}
}
*/
uint theme_find_all_theme_files(TreeNode& trNode, int nPathType, int nThemeType)//==ORIGIN_PATH_UNDEF, THTYPE_GRAPH ///DSC 2/23/05 v8.0197 QA70-7416 ADD_THEME_TYPES
{
	StringArray saFiles;
	DWORD dwCtrl = 0x0; //finding all, keeping duplicates, not GFL_GET_FIRST_ONLY
	okutil_get_theme_file_list(&saFiles, NULL,  nPathType, nThemeType, dwCtrl);
	
	//-- add to theme tree
	int nSize = saFiles.GetSize();
	int nPathIndex=-1;
	for(int ii = 0; ii < nSize; ii++)
	{	
		nPathIndex = okutil_get_origin_path_type(saFiles[ii]);
		saFiles[ii] = GetFileName(saFiles[ii], TRUE);	
		theme_add_one_theme_file(trNode, saFiles[ii], nPathIndex);
	}
		
	return nSize;

}
///end CENTRALIZE_FIND_FILES_CODES
///end GET_ORIGIN_PATH











/*
bool theme_get_next_file_name(string& strFilename, bool bCheckCreatePath, int nThemeType)//=true, =THTYPE_GRAPH
{
	int nn = 1;
	///DSC 2/15/05 GET_ORIGIN_PATH
	// string strThemePath = theme_get_path();
	// string strThemePath = theme_get_path(ORIGIN_PATH_USER, nThemeType);	
	string strThemePath = okutil_theme_get_path(ORIGIN_PATH_USER, nThemeType, false);
	///end GET_ORIGIN_PATH
	
	if(bCheckCreatePath && !CheckMakePath(strThemePath))
		return false;
		
	do
	{
		strFilename = strThemePath + "Theme" + nn + "." + THEME_FILE_EXT;
		nn++;
	} while (strFilename.IsFile());
	
	return true;
}
*/

//////////////////////////////////////////////////////////
/////////// Copy Format Functions   //////////////////////
//////////////////////////////////////////////////////////
static bool	theme_copy_format(DWORD dwPropertiesFilter = FPB_ALL, DWORD dwObjFilter = FOB_ALL)
{
	if( Selection.Objects.Count() > 0 )
	{
		return Selection.Objects(0).CopyFormat(dwPropertiesFilter, dwObjFilter);
	}
	else
	{
		GraphPage gPage = Project.Pages();
		if( gPage )
			return gPage.CopyFormat(dwPropertiesFilter, dwObjFilter);
	}
	
	return false;
}

//----- CPY 4/15/06 THEME_TREE_NEEDS_IMPROVED_INFO_DISPLAY
static void _set_child_branchs_collasped(TreeNode& tr)
{
	int dwBranch = 0; // not to have GETNBRANCH_OPEN, so should be collapsed
	foreach(TreeNode trNode in tr.Children)
	{
		if(trNode.GetNodeCount() > 0)
		{
			trNode.SetAttribute(STR_ATTRIB_BRANCH, dwBranch);
			_set_child_branchs_collasped(trNode);
		}
	}
}

void theme_update_display_attributes_for_easier_edit(TreeNode& trTheme)
{
	TreeNode trNameStyles;
	bool bRet = octree_theme_tree_get_node_by_id(&trNameStyles, &trTheme, OTID_NAMESTYLES, 3, true);	
			//octree_theme_tree_get_node_by_id(TreeNode* ptrN, TreeNode* ptrRoot, 
			//									int nID, int nStopLevel = -1, bool bRecursive = false);
	int dwBranch = 0; // not to have GETNBRANCH_OPEN, so should be collapsed
	if(trNameStyles)
	{
		foreach(TreeNode trNode in trNameStyles.Children)
		{
			TreeNode trName;
			bRet = octree_theme_tree_get_node_by_id(&trName, &trNode, OTID_NAMESTYLE_NAME, 3, true);
			string strLongName = trName.strVal;//translate(trName.strVal);
			trNode.SetAttribute(STR_LABEL_ATTRIB, strLongName);
			trNode.SetAttribute(STR_ATTRIB_BRANCH, dwBranch);
			_set_child_branchs_collasped(trNode);
		}
	}
	
	TreeNode trRangeStyles;
	octree_theme_tree_get_node_by_id(&trRangeStyles, &trTheme, OTID_RANGESTYLES, 3, true);
	if(trRangeStyles)
	{
		foreach(TreeNode trNode in trRangeStyles.Children)
		{
			int left, top, right, bottom;
			if(octree_theme_tree_get_range_from_range_style(&trNode, &left, &top, &right, &bottom))
			{
				string str;
				str.Format("R%dC%d:R%dC%d", top, left, bottom, right);
				trNode.SetAttribute(STR_LABEL_ATTRIB, str);
				trNode.SetAttribute(STR_ATTRIB_BRANCH, dwBranch);
				_set_child_branchs_collasped(trNode);
			}
		}
	}
}
	


bool	theme_combine_filter_bits(int nType, DWORD& dwProperties, DWORD& dwObjects)
{
	static const DWORD l_arrObjectFilter[] =
	{
		FOB_ALL,									// SAVETHEME_ALL
		FOB_ALL & ~(FOB_DIMENSION|FOB_SCALE),		// SAVETHEME_ALL_STYLES
		FOB_ALL,									// SAVETHEME_COLORS
		FOB_ALL,									// SAVETHEME_FONTS
		FOB_ALL,									// SAVETHEME_DIMS
		FOB_ALL,									// SAVETHEME_SCALES
		FOB_ALL,									// SAVETHEME_TEXT
		FOB_BACKGROUND|FOB_LABELS|FOB_GLOBAL,		// SAVETHEME_BACKGROUND
		FOB_ALL & ~FOB_BACKGROUND					// SAVETHEME_PLOTS
	};
	
	static const DWORD l_arrPropertyFilter[] =
	{
		FPB_ALL,									// SAVETHEME_ALL
		FPB_STYLE|FPB_OTHER|FPB_SHOW,				// SAVETHEME_ALL_STYLES
		FPB_STYLE_COLOR_MASK,						// SAVETHEME_COLORS
		FPB_STYLE_FONT|FPB_STYLE_SIZE,				// SAVETHEME_FONTS
		FPB_DIMENSION,								// SAVETHEME_DIMS
		FPB_SCALE,									// SAVETHEME_SCALES
		FPB_TEXT,									// SAVETHEME_TEXT
		FPB_STYLE_BORDER|FPB_STYLE_COLOR_MASK|FPB_STYLE_LINE|FPB_STYLE_FILL|FPB_OTHER,	// SAVETHEME_BACKGROUND
		FPB_STYLE_SYMBOL_MASK|FPB_STYLE_LIST_MASK|FPB_STYLE_LINE|FPB_STYLE_FILL|FPB_STYLE_SIZE|FPB_STYLE_FONT	// SAVETHEME_PLOTS
	};
	
	if( nType < 0 || nType >= SAVETHEME_TOTAL )
		return false;

	dwProperties |= l_arrPropertyFilter[nType];
	dwObjects |= l_arrObjectFilter[nType];

	return true;
}

////////////////////////////////////////////////////////////
// the following functions cannot be moved to separate DLLs
////////////////////////////////////////////////////////////
static bool _theme_tree_set_hide_rowcol_heading_labels(TreeNode& trHV, vector<int>& vnHides)
{
//	TreeNode tr = trHV.Hide;
//	TreeNode trSize = trHV.Size;
//	vector<int> vnSize;
//	vnSize = trSize.nVals;
	TreeNode tr = trHV.Size;
	
	if(tr)
	{
		int nLabels = 0;
		if(trHV.Lables)
		{
			TreeNodeCollection tnc(trHV.Labels, "Label");
			nLabels = tnc.Count();
		}
		vector<int> vn;
		vn = tr.nVals;
		if(vn.GetSize() >= 1 && vnHides) // else something is wrong
		{
			for(int ii = 0; ii <= nLabels; ii++)
			{
				if(vnHides.GetSize() > ii)
				{
					if(vnHides[ii] > 0)
						vn[ii] = 0;	
				}
			}
			tr.nVals = vn;
			return true;
		}
	}
	return false;
}

/**$
	hide column and row headings and labels
	NULL to show all
	0 = heading, 1,2,3 depends on labels shown
*/
bool wks_set_hide_headings(Worksheet& wks, vector<int>& vnCols, vector<int>& vnRows)
{
	Tree tr;
	if(wks_get_labels_show_theme(wks, tr))
	{
		TreeNode trDim = tr.Root.Dimensions;
		_theme_tree_set_hide_rowcol_heading_labels(trDim.Horizontal, vnCols);
		_theme_tree_set_hide_rowcol_heading_labels(trDim.Vertical, vnRows);
		Grid grid;
		grid.Attach(wks);
		grid.UpdateThemeIDs(tr.Root);
		grid.ApplyFormat(tr, TRUE, TRUE);
		return true;
	}
	return false;
}

bool wks_get_labels_show_theme(const Worksheet& wks, Tree& tr)
{
	DWORD dwPropBits = FPB_DIMENSION| FPB_OTHER;// | FPB_SHOW;// | FPB_DATA | FPB_TEXT  | FPB_RESERVED;//FPB_ALL; //
	DWORD dwObjBits = FOB_DIMENSION | FOB_OTHER;// | FOB_VECTOR;
	return theme_get_from_wks_grid(wks, tr, dwPropBits, dwObjBits);
}


bool theme_get_from_wks_grid(Worksheet& wks, Tree& trTheme, DWORD dwPropFilter, DWORD dwObjFilter, DWORD dwNodeDelBits)// = FPB_ALL, FOB_ALL, 0
{
	///Cheney 2006-12-27 SHOULD_CHECK_WKS_IF_IS_VALID_BEFORE_ATTACH
	if(!wks.IsValid())
		return false;
	///end SHOULD_CHECK_WKS_IF_IS_VALID_BEFORE_ATTACH
	Grid gg;
	gg.Attach(wks);
	if(gg)
	{
		TreeNode tr;
		dwObjFilter &= ~FOB_LINK_STYLE;
		trTheme = gg.GetFormat(dwPropFilter, dwObjFilter, TRUE, TRUE);
		TreeNode trDim = trTheme.Root.Dimensions;
		if(trDim)
		{
			vector<int> vnHideHeader = {1};
			if(dwNodeDelBits & TH_DEL_GRID_COL_HEADING)
				_theme_tree_set_hide_rowcol_heading_labels(trDim.Horizontal, vnHideHeader);
			if(dwNodeDelBits & TH_DEL_GRID_ROW_HEADING)
				_theme_tree_set_hide_rowcol_heading_labels(trDim.Vertical, vnHideHeader);

//			tree_dump_vec_node("get g Horz hide", trDim.Horizontal.Hide);
//			tree_dump_vec_node("get g Horz size", trDim.Horizontal.Size);

		}
		return true;
	}
	return false;
}
//---

bool wks_set_cell_heights(Worksheet& wks, int n1, int n2, int nSize, bool bCol)
{
	Tree tr;
	///Jasmine 02/03/07 MINUS_MAY_BE_LABEL
	//if(n1 < 0) n1 = 0;

	if(wks_get_labels_show_theme(wks, tr))
	{
		TreeNode trDim = tr.Root.Dimensions;
		TreeNode trHV;
		if(bCol)
		{
			trHV = trDim.Horizontal;
			if(n1 >=0 && n2 < 0) n2 = wks.GetNumCols()-1;
		}	
		else
		{
			trHV = trDim.Vertical;
			if(n1 >=0 && n2 < 0) n2 = wks.GetNumRows()-1;
		}

		if(!trHV.IsValid() || !trHV.Size.IsValid())
			return false;
		vector<int> vn;
		vn = trHV.Size.nVals;
		int nLabelOffset;
		///Jasmine 04/17/07 QA80-9619 APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
		//if(bCol)
			//nLabelOffset = vn.GetSize() - wks.GetNumCols();
		//else
			//nLabelOffset = vn.GetSize() - wks.GetNumRows();
		vector<int> vnShowTypes;
		Grid grid;   
		if(grid.Attach(wks))
			//----- CPY 4/18/07 QA70-9644 CHANGE_WKS_IS_LABEL_TYPE_SHOWN_TO_MOVE_COL_TO_DEFAULT_AND_FIX_PARAMS_USER_PARAM_INDEX_BUG
			//grid.GetShowLabels(!bCol, vnShowTypes);
			grid.GetShowLabels(vnShowTypes, !bCol);
			//----
		nLabelOffset = vnShowTypes.GetSize() + 1;//1: header	
		int nRow = nLabelOffset + n2, nCount = vn.GetSize();
		if(nRow >= nCount)
		{
			vector<int> vnAppend;
			vnAppend.SetSize(nRow + 1 - nCount);
			vnAppend = DEFAULT_WKS_ROW_HEIGHT;
			vn.Append(vnAppend);
		}
		///End APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
		for(int ii = n1; ii <= n2; ii++)
			vn[nLabelOffset + ii] = nSize;
		// better use a new tree so we don't reapply many existing properties
		Tree trTemp;
		if(bCol)
			trTemp.Root.Dimensions.Horizontal.Size.nVals = vn;
		else
			trTemp.Root.Dimensions.Vertical.Size.nVals = vn;
		//Grid grid;
		//grid.Attach(wks);
		grid.UpdateThemeIDs(trTemp.Root);
		//------ Folger 08/07/07 MAKE_WKS_SET_CELL_HEIGHT_UNDOABLE
		//grid.ApplyFormat(trTemp, TRUE, TRUE);
		grid.ApplyFormat(trTemp, TRUE, TRUE, TRUE);
		//------ End MAKE_WKS_SET_CELL_HEIGHT_UNDOABLE
		return true;
	}
	return false;
}

/// Zech 10/09/2011 ORG-4011-P1 REFRESH_THE_HEIGHTS_OF_LABELS_WHEN_LABEL_INSERTS
bool get_col_label_heights(Worksheet &wks, vector<int> &vn)
{
	Tree tr;
	if(!wks_get_labels_show_theme(wks, tr))
		return false;
	TreeNode trHV = tr.Root.Dimensions.Vertical;
	if(!trHV.Size)
		return false;
	vn = trHV.Size.nVals;
	return true;
}

bool set_col_label_heights(Worksheet &wks, vector<int> &vn, bool bUndo)
{
	Tree trTemp;
	trTemp.Root.Dimensions.Vertical.Size.nVals = vn;
	Grid grid;
	grid.Attach(wks);
	grid.UpdateThemeIDs(trTemp.Root);
	return grid.ApplyFormat(trTemp, TRUE, TRUE, bUndo);
}
/// END REFRESH_THE_HEIGHTS_OF_LABELS_WHEN_LABEL_INSERTS

/// Hong 11/01/07 v8.0738 SPARKLINES_SHOULD_NOT_HAVE_THEME_UNDOABLE
//bool wks_set_col_label_heights(Worksheet& wks, int nLabelType, int nSize)
bool wks_set_col_label_heights(Worksheet& wks, int nLabelType, int nSize, bool bUndo) // bUndo = 0, 
/// end SPARKLINES_SHOULD_NOT_HAVE_THEME_UNDOABLE
{
	if(nSize > 0 && !wks.IsLabelTypeShown(nLabelType))
		wks.CheckAddLabelByType(nLabelType);
	
	vector<int> vnLabels;	
	wks_get_show_labels(wks, vnLabels);
	int nRow = -1;
	for(int ii = 0; ii < vnLabels.GetSize(); ii++)
	{
		if(vnLabels[ii] == nLabelType)
		{
			nRow = ii + 1;// heading row not counted in labels
			break;
		}
	}
	if(nRow < 0)
		return false;
	
	Tree tr;
	if(wks_get_labels_show_theme(wks, tr))
	{
		/// Zech 10/09/2011 ORG-4011-P1 REFRESH_THE_HEIGHTS_OF_LABELS_WHEN_LABEL_INSERTS
		/*
		TreeNode trHV = tr.Root.Dimensions.Vertical;
		if(!trHV.IsValid() || !trHV.Size.IsValid())
			return false;
		vector<int> vn;
		vn = trHV.Size.nVals;
		*/
		vector<int> vn;
		get_col_label_heights(wks, vn);
		/// END REFRESH_THE_HEIGHTS_OF_LABELS_WHEN_LABEL_INSERTS
		///Jasmine 04/17/07 QA80-9619 APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
		int nCount = vn.GetSize();
		if(nRow >= nCount)
		{
			vector<int> vnAppend;
			vnAppend.SetSize(nRow + 1 - nCount);
			vnAppend = DEFAULT_WKS_ROW_HEIGHT;
			vn.Append(vnAppend);
		}
		///End APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
		vn[nRow] = nSize;
		
		/// Zech 10/09/2011 ORG-4011-P1 REFRESH_THE_HEIGHTS_OF_LABELS_WHEN_LABEL_INSERTS
		/*
		// better use a new tree so we don't reapply many existing properties
		Tree trTemp;
		trTemp.Root.Dimensions.Vertical.Size.nVals = vn;
		Grid grid;
		grid.Attach(wks);
		grid.UpdateThemeIDs(trTemp.Root);
		//------ Folger 08/07/07 MAKE_WKS_SET_COL_LABEL_HEIGHT_UNDOABLE
		//grid.ApplyFormat(trTemp, TRUE, TRUE);
		//grid.ApplyFormat(trTemp, TRUE, TRUE, TRUE);
		grid.ApplyFormat(trTemp, TRUE, TRUE, bUndo); /// Hong 11/01/07 v8.0738 SPARKLINES_SHOULD_NOT_HAVE_THEME_UNDOABLE
		//------ End MAKE_WKS_SET_COL_LABEL_HEIGHT_UNDOABLE
		*/
		set_col_label_heights(wks, vn, bUndo);
		/// END REFRESH_THE_HEIGHTS_OF_LABELS_WHEN_LABEL_INSERTS
		return true;
	}
	return false;
}
///Jasmine 10/11/06 GET_CELL_AND_LABEL_HEIGHT
int wks_get_cell_heights(Worksheet& wks, int n1, int n2, bool bCol, bool bFirst)
{
	Tree tr;
	//if(n1 < 0) n1 = 0;
	if(!wks_get_labels_show_theme(wks, tr))
		return 0;
	TreeNode trDim = tr.Root.Dimensions;
	TreeNode trHV;
	if(bCol)
	{
		trHV = trDim.Horizontal;
		if(n1 >=0 && n2 < 0) n2 = wks.GetNumCols()-1;
	}	
	else
	{
		trHV = trDim.Vertical;
		if(n1 >=0 && n2 < 0) n2 = wks.GetNumRows()-1;
	}
	///End MINUS_MAY_BE_LABEL
	if(!trHV.Size)
		return 0;
	vector<int> vn;
	vn = trHV.Size.nVals;
	int nLabelOffset;
	///Jasmine 04/17/07 QA80-9619 APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
	//if(bCol)
		//nLabelOffset = vn.GetSize() - wks.GetNumCols();
	//else
		//nLabelOffset = vn.GetSize() - wks.GetNumRows();
	//int nSize = vn[nLabelOffset + n1];
	vector<int> vnShowTypes;
	Grid grid;   
	if(grid.Attach(wks))
		//----- CPY 4/18/07 QA70-9644 CHANGE_WKS_IS_LABEL_TYPE_SHOWN_TO_MOVE_COL_TO_DEFAULT_AND_FIX_PARAMS_USER_PARAM_INDEX_BUG
		//grid.GetShowLabels(!bCol, vnShowTypes);
		grid.GetShowLabels(vnShowTypes, !bCol);
		//-----
	nLabelOffset = vnShowTypes.GetSize() + 1;//1: header
	int nSize = DEFAULT_WKS_ROW_HEIGHT, nRow = nLabelOffset + n1, nCount = vn.GetSize();
	///Folger 04/26/07 WKS_GET_CELL_HEIGHTS
	if (bFirst)
	{
		if(nRow < nCount)
			nSize = vn[nRow];
	}
	else
	{
		if (vn.GetSize() - 1 == nRow + n2)
		{
			vector<int> vnData;
			vn.GetSubVector(vnData, nRow, nRow + n2);
			vector<uint> vnIndex;
			vnData.Find(vnIndex, vnData[0]);
			if (vnData.GetSize() == vnIndex.GetSize())
				nSize = vnData[0];
		}
	}
	///End WKS_GET_CELL_HEIGHTS
	///End APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
	///Jasmine 01/09/07 MODIFICATION_GET_CELL_HEIGHT, first value is ok
	//for(int ii = n1 + 1; ii <= n2; ii++)
	//{
		//if(nSize != vn[nLabelOffset + ii])
		//{
			//nSize = 0;
			//break;
		//}
	//}
	///End MODIFICATION_GET_CELL_HEIGHT
	return nSize;		
}
int wks_get_col_label_heights(Worksheet& wks, int nLabelType)
{
	if(!wks.IsLabelTypeShown(nLabelType))
		return 0;	
	vector<int> vnLabels;	
	wks_get_show_labels(wks, vnLabels);
	int nRow = -1;
	for(int ii = 0; ii < vnLabels.GetSize(); ii++)
	{
		if(vnLabels[ii] == nLabelType)
		{
			nRow = ii + 1;// heading row not counted in labels
			break;
		}
	}
	if(nRow < 0)
		return 0;
	
	/// Zech 10/09/2011 ORG-4011-P1 REFRESH_THE_HEIGHTS_OF_LABELS_WHEN_LABEL_INSERTS
	/*
	Tree tr;
	if(!wks_get_labels_show_theme(wks, tr))
		return 0;
	TreeNode trHV = tr.Root.Dimensions.Vertical;
	if(!trHV.Size)
		return 0;
	vector<int> vn;
	vn = trHV.Size.nVals;
	*/
	vector<int> vn;
	get_col_label_heights(wks, vn);
	/// END REFRESH_THE_HEIGHTS_OF_LABELS_WHEN_LABEL_INSERTS
	
	///Jasmine 04/17/07 QA80-9619 APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
	if(nRow >= vn.GetSize())
		return DEFAULT_WKS_ROW_HEIGHT;
	///End APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
	return vn[nRow];
}
///End GET_CELL_AND_LABEL_HEIGHT
//---- CPY 7/11/2006 USER_COMMENTS_ON_GRID_TABLE
static void _row_data_to_str(int nRow, string& str, vector<string>& vsLabels, int nNumRowLabels = 1)
{
	if(nRow != 0)
		str += "\r\n";
	int jj = 0;
	if(nNumRowLabels > 0)
	{
		string str1;
		for(int kk = 0; kk < nNumRowLabels; kk++)
		{
			if(jj++ != 0)
				str += "\t";
			str += str1;
			jj++;
		}
	}
	for(int ii = 0; ii < vsLabels.GetSize(); ii++)
	{
		if(jj++ != 0)
			str += "\t";
		str += vsLabels[ii];
		jj++;
	}
}

/// ML 3/26/2006 MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
//static bool _theme_col_data_to_str(int nRow, const TreeNode& trVs, string& str, LPCSTR lpcszNodeName, vector<string>& vsRowLabels)
static	bool	_theme_col_data_to_str_add_row_label(string& str, vector<string>& vsRowLabels, int index, int &jj)
{
	if(vsRowLabels.GetSize() > 0)
	{
		string str1 = vsRowLabels.GetSize() > index? vsRowLabels[index] : "";
		if(jj++ != 0)
			str += "\t";
		str += str1;
		
		return true;
	}
	
	return false;
}

static bool _theme_col_data_to_str(int nRow, const TreeNode& trVs, string& str, LPCSTR lpcszNodeName,
					vector<string>& vsRowLabels, vector<string>& vsRowLabels2, vector<string>& vsRowLabels3)
/// end MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
{
	TreeNodeCollection tnc(trVs, lpcszNodeName);
	int nNodes = tnc.Count();
	if(nNodes == 0)
		return false;
	
	TreeNode trv1 = tnc.Item(0);
	if(!trv1)
		return false;
	vector<string> vs;
	vs = trv1.Data.strVals;
	int nSize = vs.GetSize();
	if(nSize < 1)
		return false; // empty table
	
//	str = ""; we may be using this to just add to str
	for(int ii = 0; ii < nSize; ii++, nRow++)
	{
		if(nRow != 0)
			str += "\r\n";
		int jj = 0;
		/// ML 3/26/2006 MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
		//if(vsRowLabels.GetSize() > 0)
		//{
		//	string str1 = vsRowLabels.GetSize() > ii? vsRowLabels[ii] : "";
		//	str += str1;
		//	jj++;
		//}
		_theme_col_data_to_str_add_row_label(str, vsRowLabels, ii, jj);
		_theme_col_data_to_str_add_row_label(str, vsRowLabels2, ii, jj);
		_theme_col_data_to_str_add_row_label(str, vsRowLabels3, ii, jj);
		/// end MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
		foreach(TreeNode tn in tnc)
		{
			vs = tn.Data.strVals;
			if(jj++ != 0)
				str += "\t";
			str += vs[ii];
		}
	}
	//out_str(str);
	return true;
}
// this is a temp solution, need to move this to TreeTable's tree_to_str
bool wks_theme_data_to_str(const TreeNode& trRt, string& str)
{
	// Support only one Row header, more will compilcate matters
	TreeNode trRowLabels = trRt.Dimensions.Vertical.Labels;
	/// ML 3/26/2006 MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
	//vector<string> vsRowLabels;
	//if(trRowLabels)
	//	vsRowLabels = trRowLabels.Label1.Data.strVals;
	///
	int			nNumRowLabels = 0;
	vector<string> vsRowLabels, vsRowLabels2, vsRowLabels3;
	if(trRowLabels)
	{
		if( trRowLabels.Label1 )	///Kyle 09/25/2010 ORG-1148-P1 RUNTIME_ERROR_WHILE_COPY_TABLE_FOR_EMBEDDED_GRAPH
		{
			vsRowLabels = trRowLabels.Label1.Data.strVals;
			nNumRowLabels += vsRowLabels.GetSize()>0;
		}
		if (trRowLabels.Label2)
		{
			vsRowLabels2 = trRowLabels.Label2.Data.strVals;
			nNumRowLabels += vsRowLabels2.GetSize()>0;
			if (trRowLabels.Label3)
			{
				vsRowLabels3 = trRowLabels.Label3.Data.strVals;
				nNumRowLabels += vsRowLabels3.GetSize()>0;
			}
		}
	}
	/// end MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
	
	TreeNode trLabels = trRt.Dimensions.Horizontal.Labels;
	int nRow = 0;
	if(trLabels)
	{
		TreeNodeCollection tnc(trLabels, "Label");
		/// ML 3/26/2006 MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
		//int nNumRowLabels = vsRowLabels.GetSize()>0?1:0;
		/// end MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
		foreach(TreeNode tn in tnc)
		{
			vector<string>	vsLabels;
			vsLabels = tn.Data.strVals;
			_row_data_to_str(nRow++, str, vsLabels, nNumRowLabels); 
		}
	}
	/// ML 3/26/2006 MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
	//return _theme_col_data_to_str(nRow, trRt.Vectors, str, "Vector", vsRowLabels);
	return _theme_col_data_to_str(nRow, trRt.Vectors, str, "Vector", vsRowLabels, vsRowLabels2, vsRowLabels3);
	/// end MULTIPLE_COLUMNS_OF_ROW_LABELS_PASTE
}

bool grid_copy_to_clipboard(Grid& gg)
{
	if(!gg)
		return false;
	
	// next we need to get the values into CF_TEXT
	Tree tr;
	DWORD dwObjs = FOB_ALL;
	dwObjs &= ~(FOB_RANGE_STYLE | FOB_NAME_STYLE | FOB_LINK_STYLE);
	
	/// ML 9/25/2006 TRANSLATING_ESCAPED_STRINGS_FOR_COPYTABLE
	//tr = gg.GetFormat(FPB_DATA, dwObjs, TRUE, TRUE);
	tr = gg.GetFormat(FPB_DATA | FPB_TRANSLATE, dwObjs, TRUE, TRUE);
	/// end TRANSLATING_ESCAPED_STRINGS_FOR_COPYTABLE
	string str;
	if(wks_theme_data_to_str(tr.Root, str))
	{
		if(copy_to_clipboard(str, true, false))
		{
			gg.CopyTable(); // this will copy only the links
			return true;
		}
	}
	
	return false;
}

/// ML 1/22/2007 QA70-9189 MAKING_A_FLAT_SHEET_WITH_LINKS_ONLY_AND_IN_DATA_AS_WELL_AS_LABELS_AREA_OUT_OF_A_WHOLE_SOURCE_TABLE
/// ML 3/7/2007 QA70-9451 SET_LINKS_TRANSPOSED_ETC
//bool grid_make_copy_as_flat_sheet(Grid& gg)
bool grid_make_copy_as_flat_sheet(Grid& gg, BOOL bTransposed)
/// end SET_LINKS_TRANSPOSED_ETC
{
	Worksheet		wksSource;
	gg.GetParent(wksSource);
	if ( !wksSource )
		return false;
	
	WorksheetPage	wkpg;
	wksSource.GetParent(wkpg);
	if (!wkpg)
		return false;

	int				nLayer = wkpg.AddLayer("", 0, "Origin");
	if (nLayer < 0)
		return false;
	
	page_set_active_layer(wkpg, nLayer);
	Worksheet		wksDest = wkpg.Layers(nLayer);
	if ( !wksDest )
		return false;
	
	wksDest.SetSize(1, 1);

	/// ML 3/7/2007 QA70-9451 SET_LINKS_TRANSPOSED_ETC
	//return gg.MakeCopyWithLinks(wksDest);
	return gg.MakeCopyWithLinks(wksDest, bTransposed);
	/// end SET_LINKS_TRANSPOSED_ETC
}
/// end MAKING_A_FLAT_SHEET_WITH_LINKS_ONLY_AND_IN_DATA_AS_WELL_AS_LABELS_AREA_OUT_OF_A_WHOLE_SOURCE_TABLE
//------ CPY 2/19/2007 TABLE_COPY_FOOTNOTE_MENU_SHOULD_CHECK_IF_HAS
bool grid_has_footnote(Grid& gg)
{
	Tree trTheme;
	DWORD dwObjBits = FOB_ALL;
	dwObjBits &=~(FOB_LINK_STYLE | FOB_RANGE_STYLE | FOB_NAME_STYLE);
	trTheme = gg.GetFormat(FPB_ALL, dwObjBits, TRUE, TRUE);
	
	/// RVD 3/24/2008 PRESERVE_USER_COMMENTS
	if( !trTheme.Root.Footnote.IsValid() )
		return false;
	/// end PRESERVE_USER_COMMENTS

	string strTemp = trTheme.Root.Footnote.strVal;
	return strTemp.IsEmpty()?false:true;
}
//------


#define _USE_GETN_USER_COMMENTS
/// Zech 09/05/2012 ORG-3591-S1 OC_FUNC_FOR_ACCESS_REPORT_TABLE_CONTEXT_MENU
//bool grid_edit_user_comments(Grid& gg)
bool grid_edit_user_comments(Grid& gg, LPCSTR lpcszComments/*= NULL*/)
/// END OC_FUNC_FOR_ACCESS_REPORT_TABLE_CONTEXT_MENU
{
	if(!gg)
		return false;
	Worksheet wks;
	gg.GetOwner(wks);
	HWND hWnd = NULL;
	if(wks)
		hWnd = wks.GetPage().GetWindow().GetSafeHwnd();
	Tree trTheme;
	DWORD dwObjBits = FOB_ALL;
	dwObjBits &=~(FOB_LINK_STYLE | FOB_RANGE_STYLE | FOB_NAME_STYLE);
	trTheme = gg.GetFormat(FPB_ALL, dwObjBits, TRUE, TRUE);
	TreeNode trRt = trTheme.Root;
	BOOL bWasReport = trRt.HeaderType.nVal == TH_REPORT;
	/// RVD 3/24/2008 PRESERVE_USER_COMMENTS
	//string str1 = trRt.Header.strVal;
	string str1;
	if( trRt.Header.IsValid() )
		str1 = trRt.Header.strVal;
	/// end PRESERVE_USER_COMMENTS
	// \r\n is stored as \n in XML
//	strText.Replace("\n", "\r\n");
//	try {
//		str1 = InputBox(, strText, 6);
//	}
//	catch(int nErr)
//	{
//		//out_str("user cancel");
//		return false;
//	}
	/// Zech 09/05/2012 ORG-3591-S1 OC_FUNC_FOR_ACCESS_REPORT_TABLE_CONTEXT_MENU
	if (lpcszComments)
	{
		str1 = lpcszComments;
	}
	else
	/// END OC_FUNC_FOR_ACCESS_REPORT_TABLE_CONTEXT_MENU
	{

		string strMsg = _L("Add User Comments to Table");
#ifndef _USE_GETN_USER_COMMENTS
	//////////////////////////////////////////////////////////////////
		int nRet = okoc_input_box(&str1, strMsg, NULL, 4, hWnd);
		if(nRet != IDOK)
			return false;
	//////////////////////////////////////////////////////////////////
#else
		GETN_TREE(tr) //GETN_OPTION_MANUAL_RESIZE("200|300|AddUserCommentsDlg")
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	//	GETN_STR(comments, "", strText)
		string strText = str1;
		GETN_MULTILINE_TEXT(comments, "", strText) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
		GETN_EDIT_DISPLAY_WIDTH_RANGE("50-120");
		GETN_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE("5-10");
		if(!GetNBox(tr, _L("User Comments"), strMsg, NULL, NULL, hWnd))
			return false;	
		str1 = tr.comments.strVal;
#endif
	}
	if(str1.IsEmpty())
	{
		trRt.HeaderType.nVal = TH_DEFAULT;
		trRt.Header.strVal = "";
	}
	else
	{
		trRt.HeaderType.nVal = TH_USER;
//		str1.Replace("\n", "\r\n"); // this seems needed, don't know why
		trRt.Header.strVal = str1;
	}

	int nUpdate = gg.UpdateThemeIDs(trRt, "Error", "Unknown tag");	/// RVD 3/24/2008 PRESERVE_USER_COMMENTS

	gg.ApplyFormat(trTheme, true, true);
	return true;
}
//---- end //---- CPY 7/11/2006 USER_COMMENTS_ON_GRID_TABLE


//--- CPY 2/21/05 THEME_SAVE_FORMAT_WKS
// I changed return type to int so we can avoid code to get tyep again later
// return EXIST_WKS, EXIST_GRAPH, or EXIST_NONE
int	theme_copy_format_to_file(LPCSTR lpcszFilename, bool bIgnoreSel, DWORD dwPropertiesFilter, DWORD dwObjFilter)//=FPB_ALL,  = FOB_ALL
{
	//--- CPY 2/21/05 THEME_SAVE_FORMAT_WKS
	Page pg = Project.Pages();
	int nPageType = pg.GetType();		
	if(!pg)
		return EXIST_NONE;
	//---
	
	Tree trTheme;
	if( !bIgnoreSel && Selection.Objects.Count() > 0 )
	{
		trTheme = Selection.Objects(0).GetFormat(dwPropertiesFilter, dwObjFilter);
	}
	else
	{
		//--- CPY 2/21/05 THEME_SAVE_FORMAT_WKS
		//		GraphPage gPage = Project.Pages();
		//if( gPage )
		//	trTheme = gPage.GetFormat(dwPropertiesFilter, dwObjFilter);
		if(nPageType == EXIST_WKS)
		{
			Worksheet wks = pg.Layers();
			if(theme_get_from_wks_grid(wks, trTheme, dwPropertiesFilter, dwObjFilter))
			{
				theme_update_display_attributes_for_easier_edit(trTheme);//----- CPY 4/15/06 THEME_TREE_NEEDS_IMPROVED_INFO_DISPLAY
			}
		}
		else
		{
			if( pg )
				trTheme = pg.GetFormat(dwPropertiesFilter, dwObjFilter);
		}
		//---
	}
	if(trTheme.FirstNode)
	{
		trTheme.Save(lpcszFilename);
		return nPageType;
	}
	return EXIST_NONE;
}

///Kyle 12/07/2010 ORG-731-P1 SUPPORT_COLORMAP_IN_SAVE_FORMAT_AS_THEME_DIALOG
bool theme_copy_colormap_to_file(LPCSTR lpcszFilename)
{
	Tree trColormap;
	if( CopyFormatColormap() && theme_get_from_clipboard(trColormap) )
	{
		if( trColormap.FirstNode )
			return trColormap.Save(lpcszFilename);
	}
	return false;
}
///End SUPPORT_COLORMAP_IN_SAVE_FORMAT_AS_THEME_DIALOG

static bool theme_copy_format_menu(int nType = SAVETHEME_ALL)
{
	DWORD dwObjects = 0;
	DWORD dwProperties = 0;

	return
		theme_combine_filter_bits(nType, dwProperties, dwObjects) &&
		theme_copy_format(dwProperties, dwObjects);
}

static	bool theme_apply_to_layer(Layer layer, const string& strFile)
{
	Worksheet wks = layer;
	
	if( !wks || (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY))	///Jasmine 09/07/07 NOT_APPLY_THEME_TO_REPORT_SHEET
	{
		/// RVD 11/8/2011 ORG-4331 FIX_THEME_APPLY_FORMATS_APPLYTO_ACTIVEGRAPH
		GraphLayer gl = layer;
		if( gl )
			return gl.ApplyFormat(strFile, TRUE, FALSE, TRUE);
		/// end FIX_THEME_APPLY_FORMATS_APPLYTO_ACTIVEGRAPH
		return true;
	}
	
	Grid grid;
	grid.Attach(wks);
	return grid.ApplyFormat(strFile, TRUE, TRUE, TRUE);///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE	
}

static	bool theme_apply_to_page(Page page, const string& strFile)
{
	if( !page )
		return false;
	
	GraphPage gp = page;
	
	if( gp )
	{
		return gp.ApplyFormat(strFile, TRUE, FALSE, TRUE);///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
	}
	
	bool bResult = true;
	
	foreach(Layer layer in page.Layers)
	{
		bResult = theme_apply_to_layer(layer, strFile) && bResult;
	}
	
	return true;
}

bool	theme_apply(int nTo, const string& strFile)
{
	bool bResult = true;

	UndoBlock ub;

	switch( nTo )
	{
	case THEMEAPPLY_SELECTION:
		foreach(OriginObject obj in Selection.Objects)
		{
			bResult = obj.ApplyFormat(strFile, TRUE, FALSE, TRUE) && bResult;	///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
		}
		break;

	case THEMEAPPLY_LAYER:
		bResult = theme_apply_to_layer(Project.ActiveLayer(), strFile);
		break;
		
	case THEMEAPPLY_PAGE:
		bResult = theme_apply_to_page(Project.Pages(), strFile);
		break;

	case THEMEAPPLY_FOLDER:
		foreach(PageBase page in Project.ActiveFolder().Pages)
		{
			bResult = theme_apply_to_page(page, strFile) && bResult;
		}
		break;

	case THEMEAPPLY_PROJECT:
		foreach(PageBase page in Project.Pages)
		{
			bResult = theme_apply_to_page(page, strFile) && bResult;
		}
		break;
	///Jasmine 03/24/07 APPLY_THENE_TO_GRAPH_IN_WKS	
	case THEMEAPPLY_GRAPH_IN_WKS:
		int nCount;
		vector<string> vs;
		Worksheet wks = Project.ActiveLayer();
		if(wks)
			nCount = wks.GetEmbeddedGraphs(vs, GRAPH_IN_WKS_EXCLUDE_BITS);///Jasmine QA70-9837 GRAPHS_IN_WKS_SHOULD_EXCLUDE_SPARKLINES
		for(int nn = 0; nn < nCount; nn++)
		{
			GraphPage page(vs[nn]);
			bResult = theme_apply_to_page(page, strFile) && bResult;
		}
		break;
	///End APPLY_THENE_TO_GRAPH_IN_WKS
	}
	return bResult;
}

bool apply_system_theme(Grid& grid, int nThemeType)
{
	BOOL bRelative = true;
	//--- CPY 8/18/06 REPORT_SHEET_SHOULD_HAVE_DIFF_THEME
	/*
	/// RVD 4/7/2006 QA70-8609 v8.0387 TABLE_GRID_BORDERS
	//string strTemp = okutil_theme_get_system_theme_file_name(THTYPE_WORKSHEET);
	string strTemp = okutil_theme_get_system_theme_file_name(grid.GetSystemThemeType(bRelative));
	/// end TABLE_GRID_BORDERS
	*/
	//int nThemeType = OE_ON_SET_REPORT == nType? THTYPE_REPORT_TABLE : THTYPE_WORKSHEET;
	string strTemp = okutil_theme_get_system_theme_file_name(nThemeType);
	//---
		
	if( !strTemp.IsEmpty() && strTemp.IsFile() )
	{
		Tree tr;
		if(tr.Load(strTemp))
		{
			grid.ApplyFormat(tr, TRUE, bRelative);
			return true;
		}
	}
	return false;
}

//////////////////////////////////////////////////////////
/////////// Theme and TreeEditor related /////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////
///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	
/*
void theme_update_tree_list_view(Dialog& theDlg, int nListViewCheckID, int nTreeID, bool bShowEmpty, bool bShowCollection) //=false,=false
{
	Button btnListView = theDlg.GetItem(nListViewCheckID);//oCntrl;
	
	DWORD dwViewSettings = VIEWFLT_PROPERTY_ALL;
	
	if(btnListView.Check)
		dwViewSettings |= VIEWFLT_FULL_PATHS_IN_LABELS;
	else
	{
		dwViewSettings |= VIEWFLT_BRANCH_NON_COLLECTION;
		if(bShowEmpty)
			dwViewSettings |= VIEWFLT_BRANCH_EMPTY;
		if(bShowCollection)
			dwViewSettings |= VIEWFLT_BRANCH_COLLECTION;
	}
	
	TreeEditor tree = theDlg.GetItem(nTreeID);
	
	tree.View = dwViewSettings;
}

/////////////////////////////////////////////
// if nTreeID given, we assume that lpcszFilename is a temp file that we can save the Theme tree into
// to update it before we do the counting
///This function is operator on dialog, so move back to the dialog file.
void theme_update_size(Dialog& theDlg, LPCSTR lpcszFilename, int nSizeID, int nTreeID) //=0
{
	if(nTreeID)
	{
		TreeEditor tree = theDlg.GetItem(nTreeID);
		tree.Save(lpcszFilename);
	}
	int nCount = 0;
	Tree themeTree(lpcszFilename);
	if(themeTree)
		nCount = tree_count_items(themeTree);
	
	Control cTreeLeafCounts = theDlg.GetItem(nSizeID);
	cTreeLeafCounts.Text = nCount;
}
/////////////////////////////////////////////

typedef bool (* P_THEME_FILTER)(LPCSTR lpcszThemeFilename, HWND hWndParent);
// return true if the Theme Tree specified by nIDTree has been filtered
bool theme_filter_dialog(Dialog& dlgParent, int nIDListView, int nIDTree)
{
	string strTempThemeFile;
	if(!GetTempFileName(strTempThemeFile))
		return false;
	
	bool bRet = false;

	P_THEME_FILTER fnThemeFilter = Project.FindFunction("ThemeFilter");
	if(fnThemeFilter)
	{
		TreeEditor tree = dlgParent.GetItem(nIDTree);
		//if(!tree.IsValid())
		//	return false;
		
		tree.Save(strTempThemeFile);
		if(fnThemeFilter(strTempThemeFile, dlgParent.GetWindow().GetSafeHwnd()))
		{
			tree.Load(strTempThemeFile);
			theme_update_tree_list_view(dlgParent, nIDListView, nIDTree);
			bRet = true;
		}
		if(strTempThemeFile.IsFile())
			DeleteFile(strTempThemeFile);
	}
	return bRet;
}
*/

DWORD theme_update_tree_list_view(bool bListViewCheck, bool bShowCollection, bool bShowEmpty) //=false
{
	DWORD dwViewSettings = VIEWFLT_PROPERTY_ALL;
	
	if(bListViewCheck)
		dwViewSettings |= VIEWFLT_FULL_PATHS_IN_LABELS;
	else
	{
		dwViewSettings |= VIEWFLT_BRANCH_NON_COLLECTION;
		if(bShowEmpty)
			dwViewSettings |= VIEWFLT_BRANCH_EMPTY;
		if(bShowCollection)
			dwViewSettings |= VIEWFLT_BRANCH_COLLECTION;
	}
	return dwViewSettings;
}

typedef bool (* P_THEME_FILTER)(LPCSTR lpcszThemeFilename, HWND hWndParent);
// return true if the Theme Tree specified by nIDTree has been filtered
bool theme_filter_dialog(HWND hWnd, string &strTempThemeFile)
{
	P_THEME_FILTER fnThemeFilter = Project.FindFunction("ThemeFilter");
	if(fnThemeFilter)
	{
		return fnThemeFilter(strTempThemeFile, hWnd);
	}
	return false;
}
///End	REMOVE_DIALOGEX_FROM_THEME_ULTILS	

// set_color_map_z_levels
// returns true/false for success/failure
// dp is a 3-D dataplot object with colormap, e.g. contour plot
// vZs is a vecor containing the desired values for color levels
// bLogScale, when true, will set the color levels to follow a log scale
#define DENOM_MIN 1E-99
bool set_color_map_z_levels(DataPlot &dp, vector& vZs, bool bLogScale)
{
	if(NULL == dp)
		return false;
	vector ZLevels;
	ZLevels = vZs;
	ZLevels.Sort();
    int nLevels = ZLevels.GetSize();
    if(nLevels < 2)
   		return false;
	double dMin = ZLevels[0];
	double dMax = ZLevels[nLevels - 1];
	double dDenom = (dMax - dMin);
	if(dDenom < DENOM_MIN)
		return false;
	ZLevels = ZLevels - dMin;
	ZLevels = ZLevels/dDenom;
	ZLevels = ZLevels*100;
	
   Tree tr; 
   tr = dp.Surface; // get the internal Surface branch of Format
   tr.ColorMap.Details.Remove(); //So we can change nLevels
   tr.ColorMap.Count.nVal = nLevels;
   tr.ColorMap.LogScale.nVal = bLogScale ? 1: 0;
   tr.ColorMap.Min.dVal = dMin;
   tr.ColorMap.Max.dVal = dMax;
   tr.ColorMap.Details.Levels.dVals = ZLevels;
   dp.Surface = tr;
   
   return true; 
}

/*
//////////////////////////////////////////////////////////
/////////// general dialog utilities     /////////////////
//////////////////////////////////////////////////////////
// return the gap between controls that might be used by caller
// for repositioning of other controls
int dlg_resize_buttons_relative_to_main_item(Dialog& dlg, uint nButtonIDs[], uint nMainItemID, int cx, int cy)
{
	Window wndDlg = dlg.GetWindow();
	RECT r1, r2;
	Button btnClose = dlg.GetItem(nButtonIDs[0]);
	btnClose.GetWindowRect(&r1);
	int nBtnWidth = r1.right - r1.left;
	int nBtnHeight= r1.bottom - r1.top;
	wndDlg.ScreenToClient(&r1);
	int nEdge = r1.top;
	
	Control cMainItem = dlg.GetItem(nMainItemID);
	cMainItem.GetWindowRect(&r1);
	wndDlg.ScreenToClient(&r1);
	r1.bottom = cy - nEdge;
	r1.right = cx - nBtnWidth - 2*nEdge;
	
	cMainItem.MoveWindow(&r1);
	
	int ii = 0;
	r2.left = r1.right + nEdge;
	r2.top = nEdge;
	r2.right = r2.left + nBtnWidth;
	r2.bottom = r2.top + nBtnHeight;
	while(nButtonIDs[ii] > 0)
	{
		Button btn = dlg.GetItem(nButtonIDs[ii]);
		if(btn)
		{
			btn.MoveWindow(&r2);
			r2.top += nBtnHeight + nEdge;
			r2.bottom += nBtnHeight + nEdge;
		}
		ii++;
	}
	return nEdge;
}
*/

	

///Iris 2/24/05 QA70-7416 TREE_FILETYPES_REPLACE_ONLY_USER_SYSTEM
//----- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
//static string _theme_file_name_add_prefix(const string& strThemeFile)
static string _theme_file_name_add_prefix(const string& strThemeFile, int nPathType = ORIGIN_PATH_USER)
{
	///Iris 2/24/05 QA70-7416 TREE_FILETYPES_REPLACE_ONLY_USER_SYSTEM
	//string strTemp = THEME_ATTRIB_SYSTEM_PATH_CHAR;
	string strTemp;
	if(ORIGIN_PATH_SYSTEM == nPathType)
		strTemp = THEME_ATTRIB_SYSTEM_PATH_CHAR;
	else if(ORIGIN_PATH_GROUP == nPathType)
		strTemp = THEME_ATTRIB_GROUP_PATH_CHAR;
	else
		return strThemeFile;
	///end TREE_FILETYPES_REPLACE_ONLY_USER_SYSTEM
	
	string strThemeFile1 = strTemp + strThemeFile;
	return strThemeFile1;
}

///Iris 2/23/05 UPDATE_LOAD_THEME_FILE_LIST
// return true and remove leading '*' if present
/*
static bool _theme_file_check_system_path(string& strThemeFile)
{
	if(strThemeFile.GetLength() > 0 && strThemeFile[0] == THEME_ATTRIB_SYSTEM_PATH_CHAR)
	{
		strThemeFile = strThemeFile.Mid(1);
		return true;
	}
	return false;
}
*/

/*
bool theme_load_default_settings(TreeNode& tr, bool* pbSystemPath) //=NULL
{
	if(pbSystemPath)
		*pbSystemPath = false;
	
	string strThemeFile;
	//if(tr.GetAttribute(STR_THEME_FILE_ATTRIB, strThemeFile)) //bCheckSettingBranch is ignore when ThemeFile attribute is present
	//if(theme_get_file_info(tr, strThemeFile))
	if(tree_get_file_name(tr, strThemeFile))///Frank 1/24/05 v8.0185 CENTRALIZE_CODE_OF_FILE_NAME_ATTRIB
	{
		bool bSystemPath = _theme_file_check_system_path(strThemeFile);
		string strPath = bSystemPath? TREE_PROPERTY_SAVE_PATH : TREE_PROPERTY_SAVE_PATH_USER;
		string strFullFileName = strPath + strThemeFile;
		if(pbSystemPath)
			*pbSystemPath = bSystemPath;
		
		return theme_load_settings(tr, strFullFileName);
	}
	return false;
}
*/

static int _theme_file_check_system_path(string& strThemeFile)
{
	if(strThemeFile.IsEmpty())
		return ORIGIN_PATH_UNDEF;
	
	int nPathType;
	switch(strThemeFile[0])
	{
	case THEME_ATTRIB_SYSTEM_PATH_CHAR:
		nPathType = ORIGIN_PATH_SYSTEM;
		break;
	case THEME_ATTRIB_GROUP_PATH_CHAR:
		nPathType = ORIGIN_PATH_GROUP;
		break;
	default:
		return ORIGIN_PATH_USER;
	}
	strThemeFile.Delete(0);
	return nPathType;
}

///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool theme_load_default_settings(TreeNode& tr, int* pnPathType) //=NULL
bool theme_load_default_settings(TreeNode& tr, int* pnPathType, TreeNode& trTheme) //=NULL
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
{
	string strThemeFile;
	//if(tree_get_file_name(tr, strThemeFile))///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
	
	//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
	//if(tree_get_theme_file_name(tr, strThemeFile))
	if ( tree_get_theme_file_name(tr, strThemeFile) && strThemeFile.IsFile() )
	//------
	{
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		// real to load theme file
		////------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
		//if ( strThemeFile == STR_THEME_DEFAULT_SHORT_FORM )
			//return theme_default_setting_management(tr, THEME_DEFAULT_GET, trTheme);
		////------
		///---END CLEAN_DEFAULT_THEME
		
		int 	nPathType = _theme_file_check_system_path(strThemeFile);
		//--- CPY 2/26/05 MORE_THEME_ANALYSIS_COMBO_CLEANUP, not sure why not directly use filename
		//string 	strFullFileName = theme_get_path(nPathType, THTYPE_ANALYSIS) + strThemeFile;
		//---
		if(pnPathType)
			*pnPathType = nPathType;
		///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		//return theme_load_settings(tr, strThemeFile);//strFullFileName);
		return theme_load_settings(tr, strThemeFile, true, trTheme);//strFullFileName);
		///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
	}
	//------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
	else
		return theme_default_setting_management(tr, THEME_DEFAULT_GET, trTheme);
	//------
	
	return error_report("theme_load_default_settings failed getting theme file name");
}
///end UPDATE_LOAD_THEME_FILE_LIST

/*
///STR_THEME_TYPE_SYSTEM, STR_THEME_TYPE_USER, STR_THEME_TYPE_ALL_USER
///enum { UNDEF_FOLDER=-1, SYS_FOLDER=0, USER_FOLDER, ALL_USER_FOLDER };
bool theme_load_default_settings(TreeNode& tr, int* pnPath) //=NULL
{
	if(pnPath)
		*pnPath = ORIGIN_PATH_USER;
	
	string strThemeFile;
	if(tree_get_file_name(tr, strThemeFile))
	{
		bool bSystemPath = _theme_file_check_system_path(strThemeFile);
		string strPath = bSystemPath? GetOriginPath(ORIGIN_PATH_SYSTEM) : GetOriginPath(ORIGIN_PATH_USER);
		string strFullFileName = strPath + strThemeFile;

		
		TREE_PROPERTY_SAVE_PATH				get_origin_path(SYS_FOLDER, "Themes")
		TREE_PROPERTY_SAVE_PATH_USER		get_origin_path(USER_FOLDER, "Themes")
		TREE_PROPERTY_SAVE_PATH_ALL_USER	get_origin_path(ALL_USER_FOLDER, "Themes")
		
		
		
		
		
		string strFullFileName = strPath + strThemeFile;
		if(pnPath)
			*pnPath = ORIGIN_PATH_SYSTEM;
		
		return theme_load_settings(tr, strFullFileName);
	}
	return false;
}
*/




//--- CPY 9/30/04 SAVE_AS_FACTORY_DEFAULT_FAILED_NO_FOLDER
/*
bool theme_save_default_settings(const TreeNode& tr, bool bCheckCreatePath)//=true)
{
	string strThemeFile;
	if( !tr.GetAttribute(STR_THEME_FILE_ATTRIB, strThemeFile) )
		return	false;
	bool bSystemPath = _theme_file_check_system_path(strThemeFile);
	string strPath = bSystemPath? TREE_PROPERTY_SAVE_PATH : TREE_PROPERTY_SAVE_PATH_USER;//CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH, default should be saved into User path
	if(bCheckCreatePath && !CheckMakePath(strPath))
		return false;
	string strFullFileName = strPath + strThemeFile;
	return theme_save_settings(tr, strFullFileName);
}
*/
// further code centralization 

#define JUNK_TEMP_OIS_FILE_NAME "Junk.ois"  //// AW 03/21/07 FIX_MULTI_THEME_ISSUE

///Joseph  10/23/06 ADD_MULIXF_THEME
/// Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
//void create_theme_subtree_when_multi_xf(const TreeNode& trSubNode, Tree& trThemeSubNode)
static void _create_theme_subtree_when_multi_xf(const TreeNode& trSubNode, Tree& trThemeSubNode, TreeNode& trSrc) // = NULL
/// end THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
{
	//// AW 03/21/07 FIX_MULTI_THEME_ISSUE
	/*
	int nIndex;
	vector<int> vnIDs;
	vector<string> vsValues;
	int nRet = tree_get_values_with_ids( trSubNode, vnIDs, vsValues);


	string strThemeDescription;
	strThemeDescription = theme_get_commment_to_gui_tree(trSubNode);
	
	if( 0 == vnIDs.GetSize() || 0 == vsValues.GetSize() )
		return;
	
	if( vnIDs.GetSize() != vsValues.GetSize() )
		return;
	Tree trTemp;
	
	for( nIndex = 0; nIndex < vnIDs.GetSize(); nIndex++ )
	{
		string strTag;
		trTemp = trThemeSubNode.AddTextNode( vsValues[nIndex], strTag, vnIDs[nIndex] );
		trTemp.DataID = vnIDs[nIndex];
	}
	*/
	
	//------ Folger 03/05/08 QA80-11192 CENTRALIZE_THEME_TREE_SETTING_KNOWLEDGE
	//trThemeSubNode = trThemeSubNode.AddTextNode( "Settings", "Settings", 0 );
	trThemeSubNode = trThemeSubNode.AddTextNode( THEME_TREE_SETTINGS, THEME_TREE_SETTINGS, 0 );
	//------

	/// Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS	
	//_theme_save_settings(trSubNode, JUNK_TEMP_OIS_FILE_NAME);
	_theme_save_settings(trSubNode, JUNK_TEMP_OIS_FILE_NAME, trSrc);
	/// end THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
	trThemeSubNode.Load(JUNK_TEMP_OIS_FILE_NAME);
	
	string strLabel;
	strLabel = trSubNode.tagName;
	trThemeSubNode.SetAttribute("XF_NAME", strLabel);
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	//string strThemeDescription;
	////strThemeDescription = theme_get_commment_to_gui_tree(trSubNode);
	//if(strThemeDescription != NULL)
		//trThemeSubNode.SetAttribute( STR_COMMENT_ATTRIB ,strThemeDescription);
	///End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	// FIX_MULTI_THEME_ISSUE
	
}
///End ADD_MULIXF_THEME

//------ Folger 11/19/07 QA70-10694 CONVERT_KEYWORD_WHEN_THEME_SAVE_AND_LOAD
#define KEYWORD_CONVERT_CONTROL
#ifdef KEYWORD_CONVERT_CONTROL
static bool _keyword_convert_control(TreeNode &trTheme, bool bSave = true)
{
	foreach (TreeNode trNode in trTheme.Children)
	{
		if (trNode.FirstNode)
			//------ Folger 12/18/07 FIXED_BUG_ON_KEYWORD_CONVERSION
			//return _keyword_convert_control(trNode, bSave);
			_keyword_convert_control(trNode, bSave);
			//------
		//------ Folger 12/18/07 FIXED_BUG_ON_KEYWORD_CONVERSION
		//if (trNode.strVal.Find('<') >= 0 && trNode.strVal.Find('>') >= 0)
		else if (trNode.strVal.Find('<') >= 0 && trNode.strVal.Find('>') >= 0)
		//------
		{
			string strTmp = trNode.strVal;
			/*
			save : localized to english
			load : english to localized
			*/
			if (okutil_convert_localized_PDS(&strTmp, !bSave))
				trNode.strVal = strTmp;						
		}
	}
	return true;
}
#endif
//------

/// Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
//static bool _theme_save_settings(const TreeNode& tr, LPCSTR lpcszFile)

//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
//static bool _theme_save_settings(const TreeNode& tr, LPCSTR lpcszFile, TreeNode& trSrc = NULL)
static bool _theme_save_settings(const TreeNode& tr, LPCSTR lpcszFile, TreeNode& trSrc = NULL, TreeNode &trThemeOut = NULL)
//------

/// end THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
{
	vector<int> vnIDs;
	vector<string> vsValues;
	///Joseph  10/23/06 ADD_MULIXF_THEME
	//muli xfs theme hasn't a lable
	string strLabel;
	Tree trThemeFile;
	BOOL bIsMultiXF;
	
	if(tr.GetAttribute(STR_MULTIXF_THEME, bIsMultiXF))
	{
		foreach(TreeNode trNode in tr.Children)
		{
			Tree trThemeSubNode;
			/// Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
			//create_theme_subtree_when_multi_xf(trNode , trThemeSubNode);		
			_create_theme_subtree_when_multi_xf(trNode , trThemeSubNode, trSrc);
			/// end THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
			trThemeFile.AddNode(trThemeSubNode);
		}
		//------ Folger 11/19/07 QA70-10694 CONVERT_KEYWORD_WHEN_THEME_SAVE_AND_LOAD
		#ifdef KEYWORD_CONVERT_CONTROL
		_keyword_convert_control(trThemeFile, true);
		#endif
		//------
		trThemeFile.Save( lpcszFile );	
		return true;
	}
	else
	{
	///End ADD_MULIXF_THEME
		/// TD 5-4-07 QA80-9724 THEME_TREE_WITH_LABELS_FOR_READABILITY
		//int nRet = tree_get_values_with_ids( tr, vnIDs, vsValues);
		vector<string> vsLabels;
		int nRet = tree_get_values_with_ids_and_labels( tr, vnIDs, vsValues, vsLabels);
		/// end THEME_TREE_WITH_LABELS_FOR_READABILITY
		///Frank 1/25/05 THEME_SAVE_AS_DIALOG
		//return tree_save_values_with_ids( lpcszFile, vnIDs, vsValues);
		string strThemeDescription;
		//theme_set_commment_to_gui_tree(tr, strThemeDescription);
		
		///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//strThemeDescription = theme_get_commment_to_gui_tree(tr);
		///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
		
		/// Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
		if ( trSrc &&  trSrc.IsValid() )
		{
			vector<int> vnSrcIDs;
			vector<string> vsSrcValues, vsSrcLabels;
			if ( tree_get_values_with_ids_and_labels( trSrc, vnSrcIDs, vsSrcValues, vsSrcLabels) > 0 )
			{
				/// Hong 11/17/07 v8.0750 FIX_THEME_NOT_SAVE_UNCHANGE_LABEL_INCORRECT
				//ocu_remove_unchanged_items_by_id(&vnSrcIDs, &vsSrcValues, &vnIDs, &vsValues); 
				ocu_remove_unchanged_items_by_id(&vnSrcIDs, &vsSrcValues, &vnIDs, &vsValues, &vsLabels); 
				/// end FIX_THEME_NOT_SAVE_UNCHANGE_LABEL_INCORRECT
			}
		}
		/// end THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
		
		///Joseph 02/07/07 XF_THEME_SUPPORT_VERSION
		//return tree_save_values_with_ids( lpcszFile, vnIDs, vsValues , strThemeDescription);
		bool bSaveValues = false;
		/// TD 5-4-07 QA80-9724 THEME_TREE_WITH_LABELS_FOR_READABILITY
		//bSaveValues	= tree_save_values_with_ids( lpcszFile, vnIDs, vsValues , strThemeDescription);
		
		//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
		
		//bSaveValues	= tree_save_values_with_ids( lpcszFile, vnIDs, vsValues , vsLabels, strThemeDescription);
		///// end THEME_TREE_WITH_LABELS_FOR_READABILITY
		//
		/////Joseph 04/28/07 ADD_XF_VERSION_FOR_MULITHEME
		////use central code
		///*
		//string strVerNum;
		//if(tr.GetAttribute(STR_XF_VERSION, strVerNum))
		//{
			//Tree trTemp;
			//trTemp.Load(lpcszFile);
			//trTemp.SetAttribute(STR_XF_VERSION, strVerNum);
			//trTemp.Save(lpcszFile);
		//}
		//*/
		//
		//Tree trTheme;
		//trTheme.Load(lpcszFile);
		//_theme_tree_set_version(trTheme, tr);
		////------ Folger 11/19/07 QA70-10694 CONVERT_KEYWORD_WHEN_THEME_SAVE_AND_LOAD
		//#ifdef KEYWORD_CONVERT_CONTROL
		//_keyword_convert_control(trTheme, true);
		//#endif
		////------
		//trTheme.Save(lpcszFile);
		
		Tree trTheme;
		bSaveValues = octree_save_values_with_ids(&trTheme, &vnIDs, &vsValues, strThemeDescription, &vsLabels);
		if ( bSaveValues )
		{
			_theme_tree_set_version(trTheme, tr);
			#ifdef KEYWORD_CONVERT_CONTROL
			_keyword_convert_control(trTheme, true);
			#endif
			
			if ( trThemeOut )
				trThemeOut = trTheme.Clone(true);
			///Sophy 10/24/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
			//if ( lpcszFile )
				//trTheme.Save(lpcszFile);
			if ( lpcszFile )
			{
				if( !trTheme.Save(lpcszFile) )
				{
					return false;
				}					
			}
			///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
		}
		
		//------ End CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
		
		return bSaveValues;
		///End XF_THEME_SUPPORT_VERSION
		
		///End THEME_SAVE_AS_DIALOG
	}
}

/// Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
//bool theme_save_settings(const TreeNode& tr, LPCSTR lpcszFilename, bool bCheckCreatePath)//=NULL, true)
///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
//bool theme_save_settings(const TreeNode& tr, LPCSTR lpcszFilename, bool bCheckCreatePath, TreeNode& trSrc)//=NULL, true, = NULL)
bool theme_save_settings(const TreeNode& tr, LPCSTR lpcszFilename, bool bCheckCreatePath, TreeNode& trSrc, TreeNode& trThemeOut/* = NULL*/)//=NULL, true, = NULL)
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
/// end THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
{
	bool bSaveAs = true;//------- CPY 5/3/07 QA70-9718 RECENT_IMPORT_EXPORT_WITH_THEME

	/// TD 4-19-06 VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	///Joseph  10/23/06 ADD_MULIXF_THEME
	//return okutil_theme_save_settings(&tr, lpcszFilename, bCheckCreatePath);
	///End ADD_MULIXF_THEME
	/// end VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	string strFullFileName = lpcszFilename;
	string strPath;
	if(strFullFileName.IsEmpty())
	{
		bSaveAs = false;//------- CPY 5/3/07 QA70-9718 RECENT_IMPORT_EXPORT_WITH_THEME
		///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
		//if(!tree_get_file_name(tr, strFullFileName))///Frank 1/24/05 v8.0185 CENTRALIZE_CODE_OF_FILE_NAME_ATTRIB
		if(!tree_get_theme_file_name(tr, strFullFileName))///End SET_AND_GET_THEME_FILE_NAME
			return	false;
		//--- CPY 2/24/05 ANALYSIS_THEME_NOT_WORKING_CLEAN_UP 
		/*
		///Iris 2/23/05 UPDATE_LOAD_THEME_FILE_LIST
		//bool bSystemPath = _theme_file_check_system_path(strThemeFile);
		//strPath = bSystemPath? TREE_PROPERTY_SAVE_PATH : TREE_PROPERTY_SAVE_PATH_USER;//CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH, default should be saved into User path
		int 	nPathType = _theme_file_check_system_path(strThemeFile);
		strPath = theme_get_path(nPathType, THTYPE_ANALYSIS);
		//end UPDATE_LOAD_THEME_FILE_LIST
		if(bCheckCreatePath && !CheckMakePath(strPath))
			return false;
		strFullFileName = strPath + strThemeFile;
		*/
		//--- end 
	}
	///Iris 3/22/05 SAVE_SYSTEM_THEME_TO_USER_FOLDER
	strPath = GetFilePath(strFullFileName);
	if( ORIGIN_PATH_SYSTEM == okutil_get_origin_path_type(strPath))
	{
		strPath = okutil_theme_get_path(ORIGIN_PATH_USER, tree_get_theme_type(tr));		
		strFullFileName = strPath + GetFileName(strFullFileName);
	}
	///end SAVE_SYSTEM_THEME_TO_USER_FOLDER
	
	if(bCheckCreatePath)
	{
		//strPath = GetFilePath(strFullFileName);
		if(!CheckMakePath(strPath))
			return false;
	}
			
	/// ML 8/25/2005 UPDATING_XF_OPS_THEMES_MENUS
	// return _theme_save_settings(tr, strFullFileName);
	/// Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
	//if ( _theme_save_settings(tr, strFullFileName) )
	///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	//if ( _theme_save_settings(tr, strFullFileName, trSrc) )
	if ( _theme_save_settings(tr, strFullFileName, trSrc, trThemeOut) )
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
	/// end THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
	{
		//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
		/*
		string	strClassOption;
		if ( theme_get_class_option(tr, strClassOption) )
		{
			string	strName;
			okutil_theme_separate_class_option(strClassOption, &strName);
			UpdateThemesMenuItems(strName);
			//------- CPY 5/3/07 QA70-9718 RECENT_IMPORT_EXPORT_WITH_THEME
			if(bSaveAs)
			{
				strName = okutil_theme_get_theme_name(strFullFileName);
				on_theme_save_as(tr, strName);
			}
			//-------
		}
		*/
		_update_theme_item_after_save(tr, bSaveAs, strFullFileName);
		//------
		return true;
	}
	
	return false;
	/// end UPDATING_XF_OPS_THEMES_MENUS
}
//--- end SAVE_AS_FACTORY_DEFAULT_FAILED_NO_FOLDER

//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
static	void	_update_theme_item_after_save(TreeNode &tr, bool bSaveAs = false, LPCSTR lpcszFullFileName = NULL)
{
	string	strClassOption;
	if ( theme_get_class_option(tr, strClassOption) )
	{
		string	strName;
		okutil_theme_separate_class_option(strClassOption, &strName);
		UpdateThemesMenuItems(strName);
		
		if ( bSaveAs && lpcszFullFileName )
		{
			strName = okutil_theme_get_theme_name(lpcszFullFileName);
			on_theme_save_as(tr, strName);
		}
	}
}
//------

//----- CPY 4/20/07 XF_VERSION_CHECKING_SHOULD_BE_MORE_STRICT
//will move to global later
// this is mainly for version checking, version can be 4.3 with integer and decimal part
// if decimal part different, we can still apply theme, but if integer part (major version) different, then we cannot apply
BOOL is_integer_part_less_then(LPCSTR lpcsz, LPCSTR lpcszRef)
{
	///---Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
	/*
	double ff = atof(lpcsz);
	double fRef = atof(lpcszRef);
	int nn = ff;
	int nRef = fRef;
	if(nn != nRef)
		return true;

	return false;
	*/
	return is_integer_part_less_then(atof(lpcsz), atof(lpcszRef));
	///---END SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
}
//-----
///---Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
bool is_integer_part_less_then(double dVer, double dVerRef)
{
	int nn = dVer;
	int nRef = dVerRef;
	if(nn != nRef)
		return true;

	return false;
}
///---END SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5

/// Iris 11/18/05 LOAD_SETTING_FACTOY_DEFAULT_BEFORE_LOAD_OTHERS
//some theme files contains incorrect ids or some treenode not include ids, so before normal theme file,
//we need load factory default theme firstly.
///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool theme_load_settings(TreeNode& tr, LPCSTR lpcszFile, bool bLoadFactDefault)
bool theme_load_settings(TreeNode& tr, LPCSTR lpcszFile, bool bLoadFactDefault, TreeNode& trTheme)
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
{
	bool bLoaded = false;
	string strClassOption;
	if(bLoadFactDefault && theme_get_class_option(tr, strClassOption) )
	{
		theme_load_factory_default(strClassOption, tr);
		bLoaded = true;
	}
	if(lpcszFile)
		///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		//return _theme_load_settings(tr, lpcszFile);
		return _theme_load_settings(tr, lpcszFile, trTheme);
		///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
	
	return bLoaded;
}
///End LOAD_SETTING_FACTOY_DEFAULT_BEFORE_LOAD_OTHERS

///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//static bool _theme_load_settings(TreeNode& tr, LPCSTR lpcszFile)
static bool _theme_load_settings(TreeNode& tr, LPCSTR lpcszFile, TreeNode& trThemeOut = NULL)
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
{
	vector<int> vnIDs;
	vector<string> vsValues;
	string strThemeDescription ;
	
	///Joseph 04/28/07 ADD_XF_VERSION_FOR_MULITHEME
	/*
	///Joseph 02/07/07 XF_THEME_SUPPORT_VERSION
	string strXFVersion;
	if(tr.GetAttribute(STR_XF_VERSION, strXFVersion))
	{
		string strThemeVersion;
		Tree trVersionTemp;
		trVersionTemp.Load();
		//----- CPY 4/20/07 XF_VERSION_CHECKING_SHOULD_BE_MORE_STRICT
		//if(trVersionTemp.GetAttribute(XF_VERSION, strThemeVersion))
		//{
		//	if(strThemeVersion.CompareNoCase(strXFVersion))
		if(!trVersionTemp.GetAttribute(STR_XF_VERSION, strThemeVersion) || is_integer_part_less_then(strThemeVersion, strXFVersion))
		//-----
		{
			if(IDOK == MessageBox(GetWindow(), "The theme version don't match XFunction version, do you want to delete the old theme?", "Remainder", MB_YESNO))
			{
				DeleteFile(lpcszFile);
			}
			return false;
		}
	}
	///End	XF_THEME_SUPPORT_VERSION
	*/
	//------ Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM
	string strName, strTool, strScope, strCategory;
	theme_filename_to_options(lpcszFile, strName, strTool, strScope ,strCategory);
	//------
	
	Tree trTheme;
	if(!trTheme.Load(lpcszFile))
	{
		//------ Folger 02/29/08 QA80-11192 SHOW_WARNING_WHEN_THEME_NOT_EXIST
		if ( !strName.IsEmpty() )		//in case that when <sheet> comes in
			theme_show_warning_not_exist(strName);
		//------
		string str;
		str.Format("Fail to loading XML %s", lpcszFile);
		return error_report(str);
	}
	
	//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
	/*
	//------ Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM
	//if(! _check_verion_on_loading_theme(trTheme, tr)
	if ( ! _check_verion_on_loading_theme(trTheme, tr, GetFileName(strName, true)) )
	//------ End WIZARD_THEME_VERSION_MECHANISM
	{
		///Joseph 05/09/07 USING_REMAINDING_MESSAGE_BOX
		//using remainding_msgbox by max suggestion.
		//if(IDOK == MessageBox(GetWindow(), "The theme version don't match XFunction version, do you want to delete the old theme?", "Remainder", MB_YESNO))
		//{
			//DeleteFile(lpcszFile);
		//}
		//------ Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM
		//if(OM_RETURN_OK ==OptionalMessage( "CheckThemeVersion",  MB_OKCANCEL))	///Joseph 05/04/07 v8.0613 ADD_NLSF_LOADING_THEME_REMAINDER_MESSAGE
			//DeleteFile(lpcszFile);
		//------ End WIZARD_THEME_VERSION_MECHANISM
		///End USING_REMAINDING_MESSAGE_BOX
		
		return false;
	}
	///End ADD_XF_VERSION_FOR_MULITHEME
	
	//------ Folger 11/19/07 QA70-10694 CONVERT_KEYWORD_WHEN_THEME_SAVE_AND_LOAD
	#ifdef KEYWORD_CONVERT_CONTROL
	_keyword_convert_control(trTheme, false);
	#endif
	//------
	
	///Frank 1/25/05 THEME_SAVE_AS_DIALOG
	//if( tree_read_values_with_ids(lpcszFile, vnIDs, vsValues) )
	//---- CPY 8/31/2007 QA70-10231 ALLOW_THEME_TO_BE_REMEMBER_IF_USER_CHANGED_FROM_DIALOG
	//if( tree_read_values_with_ids(lpcszFile, vnIDs, vsValues, strThemeDescription) )
	if(octree_get_theme(&trTheme, &vnIDs, &vsValues, &strThemeDescription))
	//----
	{
		///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//theme_set_commment_to_gui_tree(tr, strThemeDescription);
		///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//--- CPY 4/15/05 CHECK_DUPLICATE_IDS_IN_GUI_TREE
		//return tree_set_values_by_ids(tr, vnIDs, vsValues) > 0? true:false;
		int nDupID = 0;
		///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		if(trThemeOut)
			trThemeOut.Replace(trTheme);
		///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		int nn = tree_set_values_by_ids(tr, vnIDs, vsValues, 0, &nDupID);
		if(nDupID > 0)
		{
			printf("theme_load_settings found duplicate ID = %d\nwhen loading %s\n", nDupID, lpcszFile);
			return false;
		}
		
		/// ML 5/14/2007 LOADING_THEME_MUST_UPDATE_RANGES
		if ( nn > 0 )
			okutil_getn_update_ranges(&tr);
		/// end LOADING_THEME_MUST_UPDATE_RANGES
		
		return nn > 0? true:false;
		//---
	}
	///End THEME_SAVE_AS_DIALOG
	return error_report("tree_read_values_with_ids failed");
	*/
	return _theme_load_settings(tr, trTheme, strName, trThemeOut);
	//------ End CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
}

/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
static bool _is_theme_enable_apply_row_range(const vector<int>& vnIDs, const vector<string>& vsValues)
{
	int				nIndex = find_in_list(IDE_XF_DS_PARAM1, vnIDs, false);
	return (-1 != nIndex && O_QUERY_BOOL(atoi(vsValues[nIndex]), DS_BIT_SAVE_ROW_RANGE));
}
/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING

///------ Folger 04/15/09 QA80-13454 SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
//static	DWORD	_get_SETVALUESBYIDS_cntrl(TreeNode& trGetN, TreeNode& trTheme)
static	DWORD	_get_SETVALUESBYIDS_cntrl(TreeNode& trGetN, TreeNode& trTheme, 	bool bEnableApplyRowRange)
/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
{
	/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
	DWORD			dwVal = bEnableApplyRowRange ? SETVALUESBYIDS_CHECK_APPLY_ROW_RANGE_IF_NEEDED : 0;
	/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
	double	rXFversion = 1, rThemeVersion = 1;
	if ( trGetN.GetAttribute(STR_XF_VERSION, rXFversion) && trTheme.GetAttribute(STR_XF_VERSION, rThemeVersion) )
	{
		if ( rXFversion != rThemeVersion )
			/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
			//return SETVALUESBYIDS_RESET_AUTO_IF_NEEDED | SETVALUESBYIDS_ENABLE_DYNAUSECHECK_IF_NEEDED;
			return dwVal | SETVALUESBYIDS_RESET_AUTO_IF_NEEDED | SETVALUESBYIDS_ENABLE_DYNAUSECHECK_IF_NEEDED;
			/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
	}
	/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
	//return 0;
	return dwVal;
	/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
}
///------ End SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP

//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
static	bool	_theme_load_settings(TreeNode& tr, const TreeNode &trTheme, LPCSTR lpcszThemeName, TreeNode& trThemeOut = NULL)
{
	if ( ! _check_verion_on_loading_theme(trTheme, tr, GetFileName(lpcszThemeName, true)) )
		return false;
	
	#ifdef KEYWORD_CONVERT_CONTROL
	_keyword_convert_control(trTheme, false);
	#endif
	
	vector<int> vnIDs;
	vector<string> vsValues;
	string strThemeDescription ;

	
	if(octree_get_theme(&trTheme, &vnIDs, &vsValues, &strThemeDescription))
	{
		int nDupID = 0;
		if(trThemeOut)
			trThemeOut.Replace(trTheme);
		
		BOOL		bEnableApplyRowRange = _is_theme_enable_apply_row_range(vnIDs, vsValues); /// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
		///------ Folger 03/18/09 QA80-13261-P2 NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
		//int nn = tree_set_values_by_ids(tr, vnIDs, vsValues, 0, &nDupID);
		///------ Folger 04/15/09 QA80-13454 SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
		//int nn = tree_set_values_by_ids(tr, vnIDs, vsValues, 0, &nDupID, TRUE);
		/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
		//int nn = tree_set_values_by_ids(tr, vnIDs, vsValues, 0, &nDupID, _get_SETVALUESBYIDS_cntrl(tr, trTheme));
		int nn = tree_set_values_by_ids(tr, vnIDs, vsValues, 0, &nDupID, _get_SETVALUESBYIDS_cntrl(tr, trTheme, bEnableApplyRowRange));
		/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
		///------ End SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
		///------ End NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
		if(nDupID > 0)
		{
			//------ Folger 06/16/08 ERROR_ERPORT_FOR_DUPLICATE_NODE_ID_WHEN_APPLY_THEME
			//printf("theme_load_settings found duplicate ID = %d\nwhen loading %s\n", nDupID, lpcszThemeName);
			//return false;
			string strErr;
			strErr.Format("theme_load_settings found duplicate ID = %d\nwhen loading %s\n", nDupID, lpcszThemeName);
			return error_report(strErr);
			//------
		}
		
		if ( nn > 0 )
			/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
			//okutil_getn_update_ranges(&tr);
			okutil_getn_update_ranges(&tr, bEnableApplyRowRange, &vnIDs, &vsValues);
			/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
		
		return nn > 0? true:false;
	}
	return error_report("tree_read_values_with_ids failed");
}
//------ End CLEAN_UP_THEME_LOAD_SAVE_MECHANISM

//#define TREE_THEME_ORGANIZER_USER_FILE			TREE_PROPERTY_SAVE_PATH_USER + TREE_THEME_ORGANIZER_FILE_NAME //"themeCategories.xml"///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
static string _get_themeorganizer_filename(int nPathType = ORIGIN_PATH_USER)
{
	string strThemeOrganizerFile;
	okutil_make_file_path(strThemeOrganizerFile, ORIGIN_PATH_USER, THEME_SUB_FOLDER, STR_THEME_ORGANIZER_FILE_NAME, NULL, false);
	return strThemeOrganizerFile;
}


///Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME
bool	theme_load_factory_default(LPCSTR lpcszClassNameWithOption, TreeNode& tr)
{
	string	strClassNameWithOption = lpcszClassNameWithOption;
	string	strClassname;
	//int		nOption = theme_separate_class_option(strClassNameWithOption, strClassname);
	int		nOption = okutil_theme_separate_class_option(strClassNameWithOption, &strClassname);

	if(is_xf_gui_getn_tree(tr) )
	{
		///Joseph 12/29/06 RESET_TREENODE_VARIABLE_ON_THEME_FACTORY_DEFAULT
		TreeNode trNode = tr.FindNodeByAttribute(STR_ATTRIB_TEMPORY_TREENODE, true, true);
		if(trNode)
			tree_clear_all_value(trNode);
		///End RESET_TREENODE_VARIABLE_ON_THEME_FACTORY_DEFAULT

		return _load_xftheme_factory_default(strClassname, tr);
	}
	
	Tree	trOpGUI;
	///Cheney 2007-5-9 SURFACE_FIT_CAN_NOT_LOAD_FACTORY_DEFAULT_THEME
	//as fitting machenism, each XF should according to a operation derived class
	//but fitsurface, fitmatrix, fitpeak, fitpeaks, fitsigmoidal and fitexp all don't have it
	//they all share NLFitting Dlg
	//so here I set their's strClassname all be "FitNL"
	//it is not a best solution, just temp fixed
	///---Sim 2012-04-20 ORG-5493 FIX_INPUT_DATA_FOR_XYZ_MAT_FIT
	//if(strClassname.Compare("fitexp") == 0 || strClassname.Compare("fitpeak") == 0
		 //|| strClassname.Compare("FitODR") == 0 /// Iris 4/06/2012 ORG-5438-P1 ADD_FITODR_XF
		 //|| strClassname.Compare("fitsigmoidal") == 0 || strClassname.Compare("fitpeaks") == 0
		 //|| strClassname.Compare("fitsurface") == 0 || strClassname.Compare("fitmatrix") == 0)
	if(strClassname.CompareNoCase("fitexp") == 0 || strClassname.CompareNoCase("fitpeak") == 0
		 || strClassname.CompareNoCase("FitODR") == 0 /// Iris 4/06/2012 ORG-5438-P1 ADD_FITODR_XF
		 || strClassname.CompareNoCase("fitsigmoidal") == 0 || strClassname.CompareNoCase("fitpeaks") == 0
		 || strClassname.CompareNoCase("fitsurface") == 0 || strClassname.CompareNoCase("fitmatrix") == 0)
	///---END ORG-5493 FIX_INPUT_DATA_FOR_XYZ_MAT_FIT
		 {
		 	/// Iris 6/04/2008 v8.0877 FIX_XYZFIT_POINT_OF_X_DATA_TYPEIS_100
		 	/// Iris 8/15/2008 QA80-12025 TO_FIX_DOUBLE_MEANING_FOR_nOption_IN_FITNL
		 	// not change logic just used function get_fit_type to centralized codes
		 	/*
		 	if(strClassname.Compare("FitNL") == 0)
		 		nOption  = NLFIT_GENERAL_XY_FITTING;
		 	if(strClassname.Compare("fitsurface") == 0)
		 		nOption  = NLFIT_XYZ_FITTING;
		 	if(strClassname.Compare("fitmatrix") == 0)
		 		nOption  = NLFIT_MATRIX_FITTING;
		 	*/
		 	nOption = get_fit_type(strClassname);
		 	///end TO_FIX_DOUBLE_MEANING_FOR_nOption_IN_FITNL
		 	///end FIX_XYZFIT_POINT_OF_X_DATA_TYPEIS_100
		 	
		 	strClassname = STR_FITTEROPERATION_CLASS_FITNL;
		 }			 
	///end SURFACE_FIT_CAN_NOT_LOAD_FACTORY_DEFAULT_THEME
	/// Hong 11/19/08 QA80-12558 V8.90875 DESC_STATS_ON_COL_SUPPORT_DATA_FROM_GRAPH
	if ( 0 == strClassname.CompareNoCase("gDescStats") )
		strClassname = "DescStats";
	/// end DESC_STATS_ON_COL_SUPPORT_DATA_FROM_GRAPH
	/// Iris 10/26/2009 QA81-14512-P1 FIX_NOT_SHOW_FLATOUT_MENU_FOR_FIT_LINEAR_WITH_XERR
	if ( 0 == strClassname.CompareNoCase("FitLRXErr") )
	{
		strClassname = STR_FITTEROPERATION_CLASS_FITLINEAR;
		nOption = 1;/// Iris 11/24/2009 QA81-3224-P3 FIX_SYSTEM_DEFAULT_NOT_CORRECTLY_APPLIED_ON_LR_XERR
	}
	///end FIX_NOT_SHOW_FLATOUT_MENU_FOR_FIT_LINEAR_WITH_XERR
	if( get_operation_GUI_tree(strClassname, trOpGUI, false, nOption) )
	///Joseph 11/21/06 SHOW_DESCRIPTION_ON_FACTORY_DEFAULT
	{
		tr.SetAttribute(STR_COMMENT_ATTRIB, strClassname);
	///End SHOW_DESCRIPTION_ON_FACTORY_DEFAULT
		if( 0 < tree_copy_values_by_id(trOpGUI, tr) )	
			return	true;
	}	///Joseph 11/21/06 SHOW_DESCRIPTION_ON_FACTORY_DEFAULT
	return	false;
}
bool	theme_get_class_option(const TreeNode& tr, string& strClassOption)
{
	/// TD 4-19-06 VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	return okutil_theme_get_class_option(&tr, &strClassOption);
	/// end VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	///Frank 01/22/05 v8.0185b THEME_CENTERZIER_CODE
	bool bFoundAttribute = tr.GetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, strClassOption);
	return bFoundAttribute;

}
///End CENTRALIZE_CODE_ON_BRANCH_THEME
///Frank 1/25/05 THEME_SAVE_AS_DIALOG
int theme_get_display_name(const TreeNode& tr,  string& strThemeName)
{
	string strCurrentThemeFile;
	//if(!tree_get_file_name(tr, strCurrentThemeFile))///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
	
	if(!tree_get_theme_file_name(tr, strCurrentThemeFile))
		///---Sim 11-07-2007 CLEAN_CODE hard code
		//return -1;
		return PDS_INVALID;
		///---END CLEAN_CODE
	
	/// AW 10/05/06 QA70-9015 XF_THEME_BOOK_AND_SHEET
	// maybe need move this checking to VC level
	//strThemeName = okutil_theme_file_to_display_name(strCurrentThemeFile);	
	///---Sim 11-07-2007 IMPROVE_GET_DISPLAY_THEME_NAME
	//int nType = cvt_str_to_predefined_type(strCurrentThemeFile);
	int nType;
	if ( is_theme_default(strCurrentThemeFile) )
	{
		//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
		//nType = PDS_FACTORY_DEFAULT;
		//strCurrentThemeFile = THEME_FILENAME_FACTORY_DEFAULT_E;
		nType = PDS_DEFAULT;
		strCurrentThemeFile = STR_DEFAULT_E;
		//------
	}
	else if ( is_theme_last_used(strCurrentThemeFile, true) )
	{
		nType = PDS_LAST_USED;
		strCurrentThemeFile = STR_LAST_USED_E;
	}
	else
		///Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		//nType = cvt_str_to_predefined_type(strCurrentThemeFile);
		nType = str_to_predefined_type(strCurrentThemeFile);
		///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	///---END IMPROVE_GET_DISPLAY_THEME_NAME
	//----- CPY 7/18/2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
	//if( PDS_BOOK == nType || PDS_SHEET == nType )
	if(nType > PDS_USER)
	{
		strThemeName = 	strCurrentThemeFile;
		return nType;
	}
	else
		strThemeName = okutil_theme_file_to_display_name(strCurrentThemeFile);
	/// END XF_THEME_BOOK_AND_SHEET
	return PDS_USER;
}


/// SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
typedef bool (*PFN_ASC_TR) (TreeNode& trnTarget, ASCIMP& aiSource);

// bLoad = TRUE for getting, FALSE for putting
///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool theme_active_book_sheet_storage(TreeNode& tr, LPCSTR lpcszXFName, int npds, BOOL bLoad) // = FALSE
///------ Folger 04/29/09 SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
//bool theme_active_book_sheet_storage(TreeNode& tr, LPCSTR lpcszXFName, int npds, BOOL bLoad, TreeNode& trTheme) // = FALSE
bool theme_active_book_sheet_storage(TreeNode& tr, LPCSTR lpcszXFName, int npds, BOOL bLoad, TreeNode& trTheme, OriginObject* pObjSpecified/* = NULL*/) // = FALSE
///------ End SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
{
	///---Sim 07-20-2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
	//if( PDS_BOOK == npds || PDS_SHEET == npds )
	//------ Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM
	//if( PDS_BOOK == npds || PDS_SHEET == npds || PDS_TEMPLATE == npds )
	if( theme_get_save_type(npds) == THEME_TYPE_SVAE_TO_BOOK )
	//------ End IMPROVE_SAVE_THEME_MECHANISM
	///---END QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
	{
		string str;
		OriginObject activeObj; ///---Sim 07-20-2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE add

		//------ Folger 03/21/08 QA80-11192 FIX_DEFAULT_AND_SHEET_THEME_DISPLAY
		string strXFName = okutil_separate_composite_name(lpcszXFName);
		//------
		
		///------ Folger 04/29/09 SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
		if ( NULL != pObjSpecified )
		{
			activeObj = *pObjSpecified;
		}
		///------ End SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
		
		///---Sim 07-20-2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
		if ( PDS_TEMPLATE == npds )
		{
			//------ Folger 03/21/08 QA80-11192 FIX_DEFAULT_AND_SHEET_THEME_DISPLAY
			//str.Format("XFTemplateTheme_%s", lpcszXFName);
			str.Format("XFTemplateTheme_%s", strXFName);
			//------
			if ( !activeObj )		///------ Folger 04/29/09 SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
				activeObj = (OriginObject)Project.Pages(); // Active page
		}
		else 
		{
		///---END QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
		
			//------ Folger 03/21/08 QA80-11192 FIX_DEFAULT_AND_SHEET_THEME_DISPLAY
			//str.Format("XFTheme_%s", lpcszXFName);
			str.Format("XFTheme_%s", strXFName);			
			//------
			
			//str.MakeUpper(); ///---Sim 07-20-2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE remove
			
			//OriginObject activeObj; ///---Sim 07-20-2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE remove
			if ( !activeObj )		///------ Folger 04/29/09 SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
			{
				if( PDS_BOOK == npds )
					activeObj = (OriginObject)Project.Pages(); // Active page
				else if( PDS_SHEET == npds )
					activeObj = (OriginObject)Project.ActiveLayer();	// Active Layer
				else
					return false;
			}
		}	///---Sim 07-20-2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
		
		str.MakeUpper(); ///---Sim 07-20-2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
		
		if( activeObj && activeObj.IsValid() )
		{	///Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG
			if( bLoad)// && PDS_SHEET == npds )
			{
				/// AW 10/06/06 MORE_XF_THEME_BOOK_AND_SHEET
				/// we must use copy values by IDs, as this is general utils function, we don't know save or load whole GUI, trGUI or trGUI.trOPtions
				//BOOL bRet = tree_get_binary_storage(tr, activeObj, str);
				Tree trSaved;
				BOOL bRet = tree_get_binary_storage(trSaved, activeObj, str);
				/// END MORE_XF_THEME_BOOK_AND_SHEET
				
				if( !bRet) // storaged obj not found
				{
					//----- CPY 02/29/08 QA80-11192 IMPASC_BETTER_NO_THEME_HANDLING
					// if not in storage, there is no need to load default anymore
					/*
					// We have no way to have XF knowledge, as otherwise we need event handler to tell XF that loading theme failed, so we have to do specific
					// handling here, at least as a temp solution. More general solution is to pass a callback function pointer to this function so that each
					// XF or other places can decide how to handle cases of loading default when binary storage not found
					if( 0 == lstrcmpi(lpcszXFName, "ImpASC") )
					{
						Worksheet wks;
						wks = (Worksheet)activeObj;
						ASCIMP ascimp;
						if(wks.IsValid() && wks.GetASCIMP(ascimp) )///Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG
						{
							Function fn = Project.FindFunction("ASCIMPToGetNTree", "AscImpOptions");
							PFN_ASC_TR pfn = fn;
							if( pfn )
								return pfn(tr, ascimp);
						}
					}
					*/
					return false;
					//----- end IMPASC_BETTER_NO_THEME_HANDLING
				}
				///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
				if(trTheme)
					trTheme.Replace(trSaved);
				///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
				
				//------ Folger 02/29/08 QA80-11192 SHOW_WARNING_WHEN_THEME_NOT_EXIST
				///// AW 10/06/06 MORE_XF_THEME_BOOK_AND_SHEET
				////return bRet;
				//if ( tree_copy_values_by_id(trSaved, tr ) > 0 )
					//return true;
				//return false;
				tree_copy_values_by_id(trSaved, tr );
				return bRet;			//it's enough to return state of load book/sheet theme
				/// END MORE_XF_THEME_BOOK_AND_SHEET
				//------
			}
			else
				return tree_put_binary_storage(tr, activeObj, str);
		}
	}
	return false;
}
/// end XF_THEME_BOOK_AND_SHEET

///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
BOOL	theme_is_folder_last_used(LPCSTR lpcszTheme)
{
	return okutil_cvt_str_to_predefined_type(lpcszTheme) == PDS_FOLDER_LAST_USED;
}
///------ End SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS

///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool theme_update_on_new_sel(TreeNode& tr, LPCSTR lpcszSelThemeName)
bool theme_update_on_new_sel(TreeNode& tr, LPCSTR lpcszSelThemeName, TreeNode& trTheme)
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
{
	string strSel = lpcszSelThemeName;
	string strClassOption;//, strThemeNameInTree;
	//theme_get_class_option_and_current_theme(tr, strClassOption, strThemeNameInTree);
	theme_get_class_option(tr, strClassOption);

	///	SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
	///Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	//int nType = cvt_str_to_predefined_type(strSel);
	int nType = str_to_predefined_type(strSel);
	///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	///---Sim 07-20-2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
	//if( PDS_BOOK == nType || PDS_SHEET == nType )
	//------ Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM
	//if( PDS_BOOK == nType || PDS_SHEET == nType || PDS_TEMPLATE == nType )
	if( theme_get_save_type(nType) == THEME_TYPE_SVAE_TO_BOOK )
	//------ End IMPROVE_SAVE_THEME_MECHANISM
	///---END QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
	/// AW 10/05/06 QA70-9015 XF_THEME_BOOK_AND_SHEET
	// return theme_active_book_sheet_storage(tr, strClassOption, nType, true);
	{
		///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		
		//------ Folger 02/29/08 QA80-11192 SHOW_WARNING_WHEN_THEME_NOT_EXIST
		//theme_active_book_sheet_storage(tr, strClassOption, nType, true);
		/////end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		//tree_set_theme_file_name(tr, strSel);
		//return true;
		bool bRet = theme_active_book_sheet_storage(tr, strClassOption, nType, true, trTheme);
		if ( !bRet )
			theme_show_warning_not_exist(strSel);
		tree_set_theme_file_name(tr, strSel);
		return bRet;
		//------
	}
	/// END XF_THEME_BOOK_AND_SHEET
	
	/// end XF_THEME_BOOK_AND_SHEET
	//string strThemeFileFullpath;
	//string strThemeFilename = theme_get_settings_file(strClassOption, strThemeFileFullpath, strSel);
	///Joseph  10/23/06 ADD_MULIXF_THEME
	///OriginStorage is the first Node	
	string strThemeFilename = theme_get_settings_file(lpcszSelThemeName, strClassOption, tree_get_theme_type(tr));


	///End ADD_MULIXF_THEME
	///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
	/*
	if(strThemeFilename.IsEmpty())	//Factory Default
		//tr.SetAttribute(STR_THEME_FILE_ATTRIB, strClassOption);
		//tree_set_file_name(tr, NULL);///Frank 1/24/05 v8.0185 CENTRALIZE_CODE_OF_FILE_NAME_ATTRIB	///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
		///---Sim 06-30-2007 FIX_FACTORY_DEFAULT_THEME_APPIED_ISSUE
		//tree_set_theme_file_name(tr, NULL);
		tree_set_theme_file_name(tr, STR_THEME_DEFAULT_SHORT_FORM);
		///---END FIX_FACTORY_DEFAULT_THEME_APPIED_ISSUE
	else
		//tree_set_file_name(tr, strThemeFilename);///Frank 1/24/05 v8.0185 CENTRALIZE_CODE_OF_FILE_NAME_ATTRIB	///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
		tree_set_theme_file_name(tr, strThemeFilename);
		//tr.SetAttribute(STR_THEME_FILE_ATTRIB, strThemeFilename);
	*/
	tree_set_theme_file_name(tr, strThemeFilename);
	///---END CLEAN_DEFAULT_THEME
	
	
	///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
	/*
	// if( strSel == THEME_FILENAME_FACTORY_DEFAULT )
	///	SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
	///	if(PDS_FACTORY_DEFAULT == cvt_str_to_predefined_type(strSel))
	if( PDS_FACTORY_DEFAULT == nType )
	///	end XF_THEME_BOOK_AND_SHEET
	{
		///Joseph 11/21/06 SHOW_DESCRIPTION_ON_FACTORY_DEFAULT		
		/////dsc 4/19/04 UPDATE_DISCRIPTION_ON_SEL_CHANGE
		//tr.SetAttribute(STR_THEME_COMMENT_ATTRIB, "");
		/////end UPDATE_DISCRIPTION_ON_SEL_CHANGE		
		///End SHOW_DESCRIPTION_ON_FACTORY_DEFAULT
		
		//------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
		if ( theme_default_setting_management(tr, THEME_DEFAULT_GET, trTheme) )
			return true;
		//------
		
		if( theme_load_factory_default(strClassOption, tr) )
			return true;
		else
			return false;
	}
	*/
	///---END CLEAN_DEFAULT_THEME
	
	///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
	if ( theme_is_folder_last_used(strSel) )
	{
		return theme_load_xf_folder_last_used(tr, trTheme);
	}
	///------ End SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
	
	///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
	//if( theme_load_default_settings(tr) )
	if( theme_load_default_settings(tr, NULL, trTheme) )
	///end 	SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		return true;
	
	return false;
}

///Iris 3/09/05 move to tree_utils.c
//static int _theme_get_type(TreeNode& tr)
//{
	//int 	nThemeType;
	//if(tr && tr.GetAttribute(STR_THEME_TYPE_ATTRIB, nThemeType))
		//return nThemeType;
	//
	//return THTYPE_ANALYSIS;
//}

/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
bool	is_xf_gui_getn_tree(TreeNode& tr, string* pstrXFname)
{
	//return tr.tagName == XFGUI_GETN_TAGNAME;
	string strXFName;
	if(tr.GetAttribute(STR_XFUNCTION_NAME_ATTRIB, strXFName))
	{
		if(pstrXFname) *pstrXFname = strXFName;
		return true;
	}
	return false;
}

bool	_load_xftheme_factory_default(LPCSTR lpcszXFName, TreeNode& tr)
{
	//----- CPY 6/27/2007 EXP_GRAPH_SLOWNESS_DUE_TO_MAKE_TREE_CALL_3_TIMES
	//Tree trXF, trTemp;
	Tree trTemp;
	TreeNode trXF; // must not use Tree as we are actually getting the internal tree from XF in the Load call
	//-----
	XFBase xf;
	//----- CPY 6/27/2007 EXP_GRAPH_SLOWNESS_DUE_TO_MAKE_TREE_CALL_3_TIMES
	//if(! xf.Load(lpcszXFName, LTXF_NO_CALL, trXF))
	if(! xf.Load(lpcszXFName, LTXF_NO_CALL | LTXF_USE_FAST_ACCESS, trXF))
	//-----
		return false;

	///Joseph 11/21/06 SHOW_DESCRIPTION_ON_FACTORY_DEFAULT
	string strDescrip,strMenu;
	xf_seperate_description(trXF.xFdescription.strVal, strMenu, strDescrip);
	if(trXF.IsValid())
		tr.SetAttribute(STR_COMMENT_ATTRIB, strDescrip);
	///End SHOW_DESCRIPTION_ON_FACTORY_DEFAULT
	
	///Joseph 01/24/07  THEME_COPY_NODE_VALIDE_IDS
	/*
	//keep some tree status, such as the show settings
	/// ------  AW 10/02/06 MORE_ON_LOAD_THEME_IN_IMPORT
	//if(xfunction_tree_to_getn_tree(trTemp, trXF, false) && tree_copy_values(trTemp, tr, 0))
	if(xfunction_tree_to_getn_tree(trTemp, trXF, false) && tree_copy_values(trTemp, tr, TREE_COPY_SKIP_NONDATAID))
	/// ------ END MORE_ON_LOAD_THEME_IN_IMPORT
		return true;
	*/
	//----- CPY 5/7/2007 PAGE_XFBAR_SHOW_RECALCULATE_ALWAYS_NEED_GENERAL_XF_TO_GETN_CLEANUP
	//if(!xfunction_tree_to_getn_tree(trTemp, trXF, true))
	//	return false;
	TreeNode trGetN;
	if(!xf.GetGUI(trTemp, trGetN))
		return false;
	//------
	vector<int> vnIDs;
	vector<string> vsValues;
	//tree_get_values_with_ids(trTemp, vnIDs, vsValues, true);
	tree_get_values_with_ids(trGetN, vnIDs, vsValues, true);
	
	int nDupID = 0;
	if(tree_set_values_by_ids(tr, vnIDs, vsValues, 0, &nDupID))
	//----CPY 5-8-07 GETNTREE_THEME_APPLICATION_WITH_RANGES
	//	return true;
	{
		okutil_getn_update_ranges(&tr);
		return true;
	}
	//----
	///End  THEME_COPY_NODE_VALIDE_IDS
	
	return false;
}
/// end XF_THEME_SUPPORT

///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
//string theme_ask_save_as_filename(TreeNode& tr, HWND hWndParent)
string theme_ask_save_as_filename(TreeNode& tr, HWND hWndParent, TreeNode& trThemeFilter) //= NULL
///---END QA80-11371 THEME_SAVING_OPTIONS
{
	string strClassOption;//, strThemeNameInTree;
	//theme_get_class_option_and_current_theme(tr, strClassOption, strThemeNameInTree);
	theme_get_class_option(tr, strClassOption);

	string strFullFileName, strThemeFilename;
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	string strDescription;
	/*
	string strDescription = theme_get_commment_to_gui_tree(tr);
	///Joseph 11/09/06 DESCRIPTOIN_TRIM_MENU
	string strFullDescription;
	if(! strDescription.IsEmpty())
		strFullDescription  = strDescription;
	int nIndex = strFullDescription.Find(":");
	int nCount = strFullDescription.GetLength();
	if(nIndex < 0)
		strDescription = strFullDescription;
	else
		strDescription = strFullDescription.Right(nCount - nIndex -1);
	///End DESCRIPTOIN_TRIM_MENU
	*/
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
	///Joseph 04/03/07 ALL_THEME_SHOULD_SUPPORT_CATEGORY
	/*
	/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
	//strFullFileName = theme_ask_save_as_filename(strClassOption, strThemeFilename, hWndParent, &strDescritpion, tree_get_theme_type(tr));
	if( is_xf_gui_getn_tree(tr) )
	{
		string strCategory;
		if( _theme_saveas_box(strThemeFilename, strDescription, THTYPE_ANALYSIS, strClassOption, NULL, strCategory, NULL, hWndParent) )
			strFullFileName = okutil_theme_construct_filename(strThemeFilename, THTYPE_ANALYSIS, ORIGIN_PATH_USER, THTYPESCOPE_ANALYSIS_CLASS, strClassOption, strCategory, NULL);
	}
	else
	{
		strFullFileName = theme_ask_save_as_filename(strClassOption, strThemeFilename, hWndParent, &strDescription, tree_get_theme_type(tr));
	}
	/// end XF_THEME_SUPPORT
	*/
	
	///---Sim 08-27-2009 QA81-14222 SHOW_HINT_FOR_BOOK_SHEET_THEME_SAVE_AS
	tr.GetAttribute(STR_HINT_BOOK_SHEET_THEME, strDescription);
	///---END QA81-14222 SHOW_HINT_FOR_BOOK_SHEET_THEME_SAVE_AS
	
	///Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
	tr.GetAttribute(STR_DEFAULT_THEME_NAME, strThemeFilename);
	///end DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	//strFullFileName = theme_ask_save_as_filename(strClassOption, strThemeFilename, hWndParent, &strDescription, tree_get_theme_type(tr));
	///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
	//strFullFileName = theme_ask_save_as_filename(strClassOption, strThemeFilename, hWndParent, &strDescription, tree_get_theme_type(tr), trThemeFilter);
	string		strCustomMakeTree;
	tr.GetAttribute(STR_THEME_SAVE_AS_CUSTOM_MAKE_TREE_ATTRIB, strCustomMakeTree);
	string		strCustomName;
	tr.GetAttribute(STR_THEME_SAVE_AS_CUSTOM_NAME, strCustomName);
	strFullFileName = theme_ask_save_as_filename(strClassOption, strThemeFilename, hWndParent, &strDescription, tree_get_theme_type(tr), trThemeFilter, strCustomMakeTree, strCustomName);
	///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
	///---END QA80-11371 THEME_SAVING_OPTIONS
	///End ALL_THEME_SHOULD_SUPPORT_CATEGORY
	if(strFullFileName.IsEmpty())
		return	strFullFileName;
	else
	{	
		//tree_set_file_name(tr, strThemeFilename);///Frank 1/24/05 v8.0185 CENTRALIZE_CODE_OF_FILE_NAME_ATTRIB
		//tree_set_file_name(tr, strFullFileName);	///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
		tree_set_theme_file_name(tr, strFullFileName);
	}
		//tr.SetAttribute(STR_THEME_FILE_ATTRIB, strThemeFilename);
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	///Temp solution, I think STR_THEME_COMMENT_ATTRIB can not use here..... wait for good idea.
	//if(!strDescription.IsEmpty())
		//theme_set_commment_to_gui_tree(tr, strDescription);
	//return true;	///Forest 10/25/04, should return string
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	return	strFullFileName;
}
static bool combo_input_box(string& str, LPCSTR lpcszDesc, LPCSTR lpcszTitle, vector<string>& vsCombo)
{
	try
	{
		str = ComboInputBox(&vsCombo, str, lpcszDesc, lpcszTitle);
	}
	catch(int nErr)
	{
		return false;
	}
	return true;
}

///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
#define		STR_THEME_NAME_RESERVED		_L("Theme name is Reserved")
///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS

//string theme_ask_save_as_filename(LPCSTR lpcszClassNameWithOption, string& strThemename, HWND hWndParent, string *pstrDescription, bool bSaveBranchTheme)
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
//string theme_ask_save_as_filename(LPCSTR lpcszClassNameWithOption, string& strThemeName, HWND hWndParent, string *pstrDescription, int nthtype)//=THTYPE_ANALYSIS
string theme_ask_save_as_filename(LPCSTR lpcszClassNameWithOption, string& strThemeName, HWND hWndParent, string *pstrDescription, int nthtype, TreeNode& trThemeFilter
								  ///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
								  , LPCSTR lpcszCustomMakeTree/* = NULL*/
								  , LPCSTR lpcszCustomName/* = NULL*/
								  ///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
								  )//=THTYPE_ANALYSIS, NULL
///---END QA80-11371 THEME_SAVING_OPTIONS
{	
	///Iris 03/04/05 FIX_SOME_THEME_SAVEAS_DLG_BUGS
	//string strFullFileName, strThemeName, strThemeFilePrefix;
	//strThemeFilePrefix = lpcszClassNameWithOption;
	//bool bSystemPath = false;
	//vector<string>	vsFilenames, vsDisplayNames;
	/////Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME
	////int			nCountThemes = theme_get_class_settings(lpcszClassNameWithOption, vsFilenames, vsDisplayNames);
	//string strClassOption = lpcszClassNameWithOption;
	//string strPath = theme_get_path(ORIGIN_PATH_USER, THTYPE_ANALYSIS);//TREE_PROPERTY_SAVE_PATH_USER;	//only show theme files in user folder
	//int nThemeScope;
	//string strCategory;
	//
	//int nCountThemes = _theme_add_class_settings(strClassOption, vsFilenames, vsDisplayNames, strPath, bSaveBranchTheme);
	///End	CENTRALIZE_CODE_ON_BRANCH_THEME
	
	//string strPath = bSystemPath? TREE_PROPERTY_SAVE_PATH : TREE_PROPERTY_SAVE_PATH_USER;
	//----
	
	//string strThemeDisplayPrefix , strDescription; 
	///end FIX_SOME_THEME_SAVEAS_DLG_BUGS
	
	int nThemeScope = THTYPESCOPE_ANALYSIS_CLASS;
	string strFullFileName, strDescription, strCategory, strClassOption(lpcszClassNameWithOption);
	string strMsgNameReserved = STR_THEME_NAME_RESERVED;
	if(pstrDescription)
		strDescription  = *pstrDescription;
	while(1)
	{
		bool bOK;		
		///Iris 03/04/05 FIX_SOME_THEME_SAVEAS_DLG_BUGS
		//if(bSaveBranchTheme)  
			//bOK = combo_input_box(strThemeName, _L("Please specify a Theme name to save"), _L("Analysis Theme"), vsDisplayNames);
		//else
		//{
		// int thtype = THTYPESCOPE_ANALYSIS_CLASS;
		//nThemeScope = THTYPESCOPE_ANALYSIS_CLASS;
				
		//bOK = theme_save_as_box(strFullFileName, THTYPE_ANALYSIS, strThemeName, strDescription, strClassOption, nThemeScope, strCategory);
		//bOK = theme_save_as_box(strFullFileName, nthtype, strThemeName, strDescription, strClassOption, nThemeScope, strCategory);
		///----Frank 4/15/05 SAVE_AS_SHOULD_FROM_PARENT_DLG
		///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
		//bOK = theme_save_as_box(strFullFileName, nthtype, strThemeName, strDescription, strClassOption, nThemeScope, strCategory,NULL,hWndParent);
		///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
		//bOK = theme_save_as_box(strFullFileName, nthtype, strThemeName, strDescription, strClassOption, nThemeScope, strCategory,NULL,hWndParent, trThemeFilter);
		bOK = theme_save_as_box(strFullFileName, nthtype, strThemeName, strDescription, strClassOption, nThemeScope, strCategory,NULL,hWndParent, trThemeFilter, lpcszCustomMakeTree, lpcszCustomName);
		///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
		///---END QA80-11371 THEME_SAVING_OPTIONS
		///----End SAVE_AS_SHOULD_FROM_PARENT_DLG
				
		//}
		///end FIX_SOME_THEME_SAVEAS_DLG_BUGS
		
		///end UPDATE_LOAD_THEME_FILE_LIST
		if(!bOK)
		{
			strFullFileName.Empty();
			return strFullFileName;// return empty str
		}
		
		if(strThemeName.IsEmpty())
		{
			MessageBox(hWndParent, _L("Theme name can't be empty!"));			
			continue;
		}
		else
		{
			//fill argument
			//strThemename = strThemeName;///DSC 3/1/05 v8.0200 CENTRALIZE_PATH_CATEGORY_NAME_CODES			
			string	strClassName;
			//theme_separate_class_option(strClassOption, strClassName);
			okutil_theme_separate_class_option(strClassOption, &strClassName);
			if( strClassName == THEME_FILENAME_NO_CLASS )
			{
				if( !strThemeName.CompareNoCase(THEME_FILENAME_COPY) )
				{
					MessageBox(hWndParent, strMsgNameReserved);
					continue;
				}	
			}
			else
			{
				//if( !strThemeName.CompareNoCase(THEME_FILENAME_FACTORY_DEFAULT) || !strThemeName.CompareNoCase(THEME_FILENAME_LAST_USED) || !strThemeName.CompareNoCase(STR_LAST_USED))
				
				///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
				/////------ Folger 10/19/09 QA81-14145-S1 FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
				//////------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
				//////if( PDS_FACTORY_DEFAULT == cvt_str_to_predefined_type(strThemeName) || PDS_LAST_USED == cvt_str_to_predefined_type(strThemeName) || !strThemeName.CompareNoCase(THEME_FILENAME_LAST_USED) )
				///////Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
				//////if( PDS_FACTORY_DEFAULT == cvt_str_to_predefined_type(strThemeName) || PDS_LAST_USED == cvt_str_to_predefined_type(strThemeName) || !strThemeName.CompareNoCase(THEME_FILENAME_LAST_USED) ||
				//////	!strThemeName.CompareNoCase(THEME_DEFAULT_SETTING) || !strThemeName.CompareNoCase(THEME_FILE_FACTORY_DEFAULT) )
				////if( PDS_FACTORY_DEFAULT == str_to_predefined_type(strThemeName) || PDS_LAST_USED == str_to_predefined_type(strThemeName) || !strThemeName.CompareNoCase(THEME_FILENAME_LAST_USED) ||
					////!strThemeName.CompareNoCase(THEME_DEFAULT_SETTING) || !strThemeName.CompareNoCase(THEME_FILE_FACTORY_DEFAULT) )
				///////end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
				//////------
				//int		nPDSType = str_to_predefined_type(strThemeName);
				//if ( PDS_FACTORY_DEFAULT == nPDSType 
					//|| PDS_DEFAULT == nPDSType
					//|| PDS_LAST_USED == nPDSType
					//|| PDS_FOLDER_LAST_USED == nPDSType
					//|| 0 == strThemeName.CompareNoCase(THEME_FILENAME_LAST_USED)
					//|| 0 == strThemeName.CompareNoCase(THEME_DEFAULT_SETTING)
					//|| 0 == strThemeName.CompareNoCase(THEME_FILE_FACTORY_DEFAULT)
					//)
				/////------ End FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
				//{
					//MessageBox(hWndParent, strMsgNameReserved);
					//continue;
				//}
				////------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
				//else if ( !is_str_valid_for_filename(strThemeName) )
				//{
					//MessageBox(hWndParent, _L("Invalid file name!"));
					//continue;
				//}
				////------
				if ( !theme_is_valid_name_for_save_as(strThemeName, hWndParent) )
					continue;
				///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
			}
		}
		///Iris 03/04/05 FIX_SOME_THEME_SAVEAS_DLG_BUGS
		//if(!strThemeDisplayPrefix.IsEmpty())
		//	strThemeName = strThemeDisplayPrefix + strThemeName ;
		///end FIX_SOME_THEME_SAVEAS_DLG_BUGS
		
		///DSC 3/1/05 v8.0200 CENTRALIZE_PATH_CATEGORY_NAME_CODES
		/*
		//strThemeFilename = theme_get_settings_file(strThemeFilePrefix, strFullFileName, strThemeName, bSaveBranchTheme);
		strFullFileName = theme_get_settings_file(strThemeName, strClassOption);
		if(strFullFileName.IsFile() && IDNO == MessageBox(hWndParent, "File already exist, overwrite it anyhow?", NULL, MB_YESNO))
			continue;
		*/
		string strNameNotUsed;// to compile
		string strTemp = theme_get_settings_file(strThemeName, strClassOption, nthtype, &strNameNotUsed, &nThemeScope, strCategory);
		
		///DSC 6/27/05	CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME
		// should not allow same named themes for scope THTYPESCOPE_ANALYSIS_CATEGORY or THTYPESCOPE_ANALYSIS_COMMON,
		// otherwise display names will be identical even though the paths will not be identical.
		// ex User: (Common) Name, because Class, option, and TableID are not part of the display name, but are part of the path.
		// By insisting on unique names, then the path can be found from the display name (without knowing class, option, table id)
		// For THTYPESCOPE_ANALYSIS_CLASS, the name can be common. Identical display names can occur, but each will be associated 
		// with a different Classname, eg. FitLinear, FitPolynomial, etc, so they will not appear in same list.
		if(nThemeScope>THTYPESCOPE_ANALYSIS_CLASS && strTemp.IsFile())
		{
			string strMsg;
			strMsg.Format(_L("Theme name %s already exists, please choose another name."), strThemeName); 
			IDNO == MessageBox(hWndParent, strMsg, _L("Attention!"), MB_OK);
				continue;
		}
		///end CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME
		
		if(strTemp.IsFile() && IDNO == MessageBox(hWndParent, _L("File already exists, overwrite it anyway?"), NULL, MB_YESNO))
			continue;
		
		break;
	}
	if(pstrDescription != NULL)
		*pstrDescription = strDescription;
	return strFullFileName;
}

///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
BOOL		theme_is_valid_name_for_save_as(LPCSTR lpcszName, HWND hWndParentForMsg/* = NULL*/)
{
	string	strTheme = lpcszName;
	int		nPDSType = str_to_predefined_type(strTheme);
	if ( PDS_FACTORY_DEFAULT == nPDSType 
		|| PDS_DEFAULT == nPDSType
		|| PDS_LAST_USED == nPDSType
		|| PDS_FOLDER_LAST_USED == nPDSType
		|| 0 == strTheme.CompareNoCase(THEME_FILENAME_LAST_USED)
		|| 0 == strTheme.CompareNoCase(THEME_DEFAULT_SETTING)
		|| 0 == strTheme.CompareNoCase(THEME_FILE_FACTORY_DEFAULT)
		)
	{
		if ( hWndParentForMsg )
			MessageBox(hWndParentForMsg, STR_THEME_NAME_RESERVED);
		return FALSE;
	}
	else if ( !is_str_valid_for_filename(strTheme) )
	{
		if ( hWndParentForMsg )
			MessageBox(hWndParentForMsg, _L("Invalid file name!"));
		return FALSE;
	}

	return TRUE;
}
///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS

// return index in vsList or -1 if none selected
int theme_get_list(const TreeNode& tr, vector<string>& vsList, bool bRetZeroIfNotInThemeList, bool bIncludeSystem) // = true, fasle
{
	int nSel = -1;
	string strClassOption, strThemeNameInTree;
	//theme_get_class_option_and_current_theme(tr, strClassOption, strThemeNameInTree);
	theme_get_class_option(tr, strClassOption);
	int nType = theme_get_display_name(tr, strThemeNameInTree);
		
	/// SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
	int nThemeType = 0;
	if( tr )
		tr.GetAttribute(STR_DATA_ATTRIB, nThemeType);
	/// end XF_THEME_BOOK_AND_SHEET
	
	///Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG
	//cp said, dlg theme should include <Factory Default> as well as <sheet> and <book>
	//BOOL bIncludeFactory = nThemeType? false : true;	/// AW 10/04/06 QA80-7953 XF_THEME_SUPPORT
	
	//------ Folger 03/10/08 QA80-11192 THEME_LIST_SHOULD_INCLUDE_DEFAULT_INSTEAD_OF_FACTORY_DEFAULT
	//BOOL bIncludeFactory = true;
	BOOL bIncludeDefault = theme_get_default_settings(strClassOption) ? true : false;
	//------

	///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
	BOOL	bForceLoadFactory = theme_force_load_factory_attribute_access(tr, THEMEFORCELOADFACTORY_GET);
	///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
	
	vector<string> vsFilenames;

//------ CPY 03/08/08 QA80-11192 REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT

	//I think should get rid of <book>/<sheet> theme here
	//because theme_get_list now work for ThemeControlMenu, not theme combo anymore
	
	
	//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
	//add book/sheet string into list if active book/sheet do have theme
	//int nCount = okutil_theme_get_class_settings(strClassOption, &vsFilenames, &vsList, tree_get_theme_type(tr), bIncludeFactory, true, false, nThemeType & THEME_SAVE_TO_BOOK, nThemeType & THEME_SAVE_TO_SHEET);
	Tree trTmp;
	//---- CPY 7/28/2011 ORG-3350-P1 SHOULD_BE_ABLE_TO_SHIP_BUILT_IN_FUNCTION_THEMES
	/*
	int nCount = okutil_theme_get_class_settings(strClassOption, &vsFilenames, &vsList, tree_get_theme_type(tr), bIncludeDefault, true, false,
				(nThemeType & THEME_SAVE_TO_BOOK) && theme_active_book_sheet_storage(trTmp, strClassOption, PDS_BOOK, true),
				(nThemeType & THEME_SAVE_TO_SHEET) && theme_active_book_sheet_storage(trTmp, strClassOption, PDS_SHEET, true));
	*/
	bool bBookTheme = (nThemeType & THEME_SAVE_TO_BOOK) && theme_active_book_sheet_storage(trTmp, strClassOption, PDS_BOOK, true);
	bool bSheetTheme = (nThemeType & THEME_SAVE_TO_SHEET) && theme_active_book_sheet_storage(trTmp, strClassOption, PDS_SHEET, true);
	bool bIncludeFolderLastUsed = false;
	bool bIncludeLastUsed = true;
	bool bIncludeCommon = false;
	int nCount = okutil_theme_get_class_settings(strClassOption, &vsFilenames, &vsList, tree_get_theme_type(tr), bIncludeDefault, bIncludeLastUsed, bIncludeCommon,
												bBookTheme, bSheetTheme, bIncludeFolderLastUsed, bIncludeSystem);
	//---- end SHOULD_BE_ABLE_TO_SHIP_BUILT_IN_FUNCTION_THEMES
	//no need to remove "Default" theme now
	
	////need to remove "Default" theme
	//int nn = vsList.Find(THEME_DEFAULT_SETTING);
	//if ( nn >= 0 )
		//vsList.RemoveAt(nn);
	//------
/*	
	//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
#ifdef NEW_DEFAULT_THEME_MECHANISM
	if ( nCount > 0 && cvt_str_to_predefined_type(vsList[0]) == PDS_FACTORY_DEFAULT )
	{
		tree_node_copy_attribute(tr, trTmp, STR_CLASS_OPTION_NAME_ATTRIB);
		vsList[0] = theme_default_setting_management(tr, THEME_DEFAULT_GET, NULL, false, true) ? STR_NEW_DEFAULT_THEME_L : "";
	}
#endif	
	//------

// I need to restore original code
	// nThemeType has its from XF to decide if book/sheet should be included
	int nCount = okutil_theme_get_class_settings(strClassOption, &vsFilenames, &vsList, tree_get_theme_type(tr), bIncludeFactory, true, false, nThemeType & THEME_SAVE_TO_BOOK, nThemeType & THEME_SAVE_TO_SHEET);
//------ end REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT
*/	
	//-------- CPY 7/18/2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
	if(PDS_TEMPLATE == nType)
	{
		vsList.InsertAt(0, STR_TEMPLATE_THEME);
		return 0;
	}
	//-------- end XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
	//------ Folger 11/08/07 FIX_BUGS_WHEN_FIND_THEME_NAME_WITH_LOCALIZATION
	//nSel = vsList.Find(strThemeNameInTree);	
	nSel = nType > PDS_USER ? theme_find_predefined_type_index(vsList, strThemeNameInTree) : vsList.Find(strThemeNameInTree);
	//------ End FIX_BUGS_WHEN_FIND_THEME_NAME_WITH_LOCALIZATION
	
	//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
	///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
	//if ( !bIncludeDefault )
	if ( !bIncludeDefault || bForceLoadFactory )
	///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
	{
		vsList.InsertAt(0, STR_THEME_NONE);
		if ( nSel >= 0 )
			++nSel;
	}
	//------
	
	if(bRetZeroIfNotInThemeList && nSel < 0) // not in list
	{
		nSel = 0;
		//------ Folger 02/28/08 QA80-11182 LOAD_THEME_FAIL_SHOULD_RESET_GETN_TREE_THEME_FILE_NAME
		//------ CPY 03/08/08 QA80-11192 REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT
		//tree_set_theme_file_name(tr, STR_THEME_FACTORY_DEFAULT);
		tree_set_theme_file_name(tr, STR_THEME_NONE);
		//------
		//------
	}
	
	///---Sim 11-07-2007 CLEAN_LOCALIZATION_CODE
	for ( int ii = 0; ii < vsList.GetSize(); ii++ )
	{
		///Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		//if ( PDS_USER < cvt_str_to_predefined_type(vsList[ii]) )
		if ( PDS_USER < str_to_predefined_type(vsList[ii]) )
		///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
			vsList[ii] = GetLocalized(vsList[ii]);			
	}
	///---END CLEAN_LOCALIZATION_CODE	
	
	return nSel;
}

//---- end MORE_CENTRLIZATION_ON_THEME_SAVING

///Iris 2/21/05 QA70-7416 ADD_THEME_SAVE_AS_BOX
/////Frank 1/25/05 THEME_SAVE_AS_DIALOG
////---- CPY 2/5/05 THEME_SAVING_DIALOG_CLEAN_UP
//// cannot have code like this
//// 	if(tr.Scope.strVal.Compare("Analysis in Specified Category") == 0)
//// I have rewritten all relavent codes related to this to make use of the following enum
//enum {THEME_SCOPE_CURRENT, THEME_SCOPE_CATEGORY, THEME_SCOPE_ALL};
////----
///End ADD_THEME_SAVE_AS_BOX
///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
//no used again
/*
static bool theme_ask_name_on_change_scope(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg)
{
	///Iris 2/21/05 QA70-7416 ADD_THEME_SAVE_AS_BOX
	//if(tr.Scope.nVal == THEME_SCOPE_CATEGORY)
	if(tr.Scope.nVal == THTYPESCOPE_ANALYSIS_CATEGORY)
		tr.Category.Show = true;
	else
		tr.Category.Show = false;
	return true;
}

static bool theme_ask_name_on_change_category(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg)
{
	if(tr.Category.strVal.Compare(STR_NEW + STR_THREE_DOTS) == 0)
	{
		///DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
		// vector<string> vsDisplayNames;// = {"1234", "5678"};
		// theme_find_class_categories(NULL, vsDisplayNames);
		StringArray saDisplayNames;// = {"1234", "5678"};
		okutil_theme_find_class_categories(NULL, &saDisplayNames);
		///end MOVE_GET_CLASS_SETTINGS_TO_VC
		
		string strCategoryName;
		int nComboReturn=0;
		string strCombo;
		while(1)
		{
			try
			{
				//strCategoryName = ComboInputBox(&vsDisplayNames, "", _L("Please specify a category name that current theme applies to"), _L("Category Name"));
				strCategoryName = ComboInputBox(&saDisplayNames, "", _L("Please specify a category name that current theme applies to"), _L("Category Name"));
			}
			catch(int nErr )
			{
				nComboReturn = nErr;
				//return false;
			}
			if(strCategoryName.Find(':') >=0 || strCategoryName.Find('-') >=0 || strCategoryName.Find('(') >=0 || strCategoryName.Find(')') >=0 || strCategoryName.Find('/') >=0 || strCategoryName.Find('\\') >=0 || strCategoryName.Find('|') >=0 )
			{
				MessageBox(GetWindow(), _L("A file name cannot contain any of the following characters:\n \/:*?<>|()-!"));
			}
			else
				break;
		}
		
		tr.Category.GetAttribute(STR_COMBO_ATTRIB, strCombo);
		if(nComboReturn == 0 && !strCategoryName.IsEmpty())
		{
			insert_str_to_str_list(strCategoryName, strCombo);
			tr.Category.SetAttribute(STR_COMBO_ATTRIB, strCombo);
		}
		else
			strCategoryName = get_str_from_str_list(strCombo,'|', 0);
		
		tr.Category.strVal = strCategoryName;

	}
	return	true;
}
*/
///---END CLEAN_LOCALIZATION_CODE
/*
static bool theme_ask_save_as_class_filename(LPCSTR lpcszClassNameWithOption, string& strThemename, string &strDescription, string &strThemeDisplayPrefix, HWND hWndParent)
{
	GETN_TREE(tr)
	GETN_OPTION_GRIDLINE(flexGridFlatVert)

	vector<string>	vsFilenames, vsDisplayNames;
	string strClassOption = lpcszClassNameWithOption;
	string strPath = TREE_PROPERTY_SAVE_PATH_USER;	//only show theme files in user folder
	int nCountThemes = theme_add_class_settings(strClassOption, vsFilenames, vsDisplayNames, strPath);
	string	strThemesInUserFolder = STR_TOKEN_SEP;
	strThemesInUserFolder += rollback_string_tokens(vsDisplayNames, '|');
	GETN_STRLIST(ThemeName, "Theme Name", "Untitled", strThemesInUserFolder)
	GETN_STR(ThemeDesc, "Theme Description", "")
	///Iris 2/21/05 QA70-7416 ADD_THEME_SAVE_AS_BOX
	//GETN_LIST(Scope, "Theme Scope", THEME_SCOPE_CURRENT, "Current Analysis|Analysis Category|All Analyses")	
	GETN_LIST(Scope, "Theme Scope", THTYPESCOPE_ANALYSIS_CLASS, "Current Analysis|Analysis Category|All Analyses")
	GETN_OPTION_EVENT(theme_ask_name_on_change_scope)
	vector<string> vsCategory ;//= {"@Fit", "@Custom", "FFT", "User"};
	
	theme_find_class_categories(strClassOption, vsCategory);

	vsCategory.Add(STR_NEW + STR_THREE_DOTS);
	string str = rollback_string_tokens(vsCategory, '|');
	GETN_STRLIST(Category, "Category", "", str)
	GETN_OPTION_EVENT(theme_ask_name_on_change_category)
	if(!GetNBox( tr, "Analysis Theme", "Please specify theme name and description", NULL, NULL, hWndParent))
		return false;
	
	string strCategoryName;

	if(tr.Category.Show)
	{
		strCategoryName = tr.Category.strVal;
		theme_update_category_to_themeorganizer(strCategoryName , strClassOption);
	}
	else
		if(tr.Scope.nVal == THTYPESCOPE_ANALYSES_COMMON)//if(tr.Scope.nVal == THEME_SCOPE_ALL)
			strCategoryName = "Common";
	if(!strCategoryName.IsEmpty())
		strThemeDisplayPrefix = "("+ strCategoryName +")";
	
	strDescription = tr.ThemeDesc.strVal;
	strThemename = tr.ThemeName.strVal;
	return true;
}
*/
bool theme_update_category_to_themeorganizer(const string &strCategoryName,const string &strClassNameWithOption)
{	
	Tree tr;
	TreeNode trThemeOrganizer = tr.AddNode("ThemeOrganizer");
	
	_load_themeorganizer(trThemeOrganizer);

	TreeNode trCategory = trThemeOrganizer.FindNodeByAttribute(STR_LABEL_ATTRIB, strCategoryName, false, true);
	if(!trCategory)	//check add
	{
		trCategory = trThemeOrganizer.AddNode("Category" + (trThemeOrganizer.GetNodeCount() + 1));		
		trCategory.SetAttribute(STR_LABEL_ATTRIB, strCategoryName);
	}
	
	TreeNode trClass = trCategory.FindNodeByAttribute(STR_LABEL_ATTRIB, strClassNameWithOption, false, true);
	if(!trClass)	//check add
	{
		trClass = trCategory.AddNode("Class" + (trCategory.GetNodeCount() + 1));		
		trClass.SetAttribute(STR_LABEL_ATTRIB, strClassNameWithOption);
		trClass.strVal = strClassNameWithOption;
	}
	
	theme_save_themeorganizer(trThemeOrganizer);
	return true;
}
//--- CPY 10/17/05 ANALYSIS_THEME_USE_CENTRLIZED_FUNC
/*
bool theme_load_themeorganizer(TreeNode &trThemeorganizer)
{
	string strThemeSubPath = THEME_SUB_FOLDER;
	string strThemeOrganizerFile;
	Tree tr;
	if(!okutil_make_file_path(strThemeOrganizerFile, ORIGIN_PATH_USER, strThemeSubPath, STR_THEME_ORGANIZER_FILE_NAME))
	{
		if(!okutil_make_file_path(strThemeOrganizerFile, ORIGIN_PATH_GROUP, strThemeSubPath, STR_THEME_ORGANIZER_FILE_NAME))
		{
			if(!okutil_make_file_path(strThemeOrganizerFile, ORIGIN_PATH_SYSTEM, strThemeSubPath, STR_THEME_ORGANIZER_FILE_NAME))
				return false;
		}
	}
	tr.Load(strThemeOrganizerFile);
	if(tr)
	{
		trThemeorganizer = tr.Clone();
		return true;
	}
	return false;
}
*/
static bool _load_themeorganizer(TreeNode &trThemeorganizer)
{
	Tree tr;
	if(theme_load(tr, STR_THEME_ORGANIZER_FILE_NAME))
	{
		trThemeorganizer = tr.Clone();
		return true;
	}
	return false;
}

bool theme_load(Tree& trTheme, LPCSTR lpcszThemeFileWithExt, LPCSTR lpcszSubPath)
{
	string strThemeSubPath = THEME_SUB_FOLDER;
	if(lpcszSubPath)
	{
		string strTemp = "\\";
		strThemeSubPath += strTemp + lpcszSubPath;
	}
		
	string strThemeFile;
	if(!okutil_make_file_path(strThemeFile, ORIGIN_PATH_USER, strThemeSubPath, lpcszThemeFileWithExt))
	{
		if(!okutil_make_file_path(strThemeFile, ORIGIN_PATH_GROUP, strThemeSubPath, lpcszThemeFileWithExt))
		{
			if(!okutil_make_file_path(strThemeFile, ORIGIN_PATH_SYSTEM, strThemeSubPath, lpcszThemeFileWithExt))
				return false;
		}
	}
	return trTheme.Load(strThemeFile);
}
//---- end ANALYSIS_THEME_USE_CENTRLIZED_FUNC;

bool theme_save_themeorganizer(const TreeNode &trThemeorganizer )
{
	if(!trThemeorganizer)
		return false;
	Tree tr;
	tr = trThemeorganizer;
	
	return tr.Save(_get_themeorganizer_filename());
}

bool theme_set_commment_to_gui_tree(TreeNode &tr, LPCSTR lpcszComment)
{
	return 	tr.SetAttribute(STR_THEME_COMMENT_ATTRIB, lpcszComment);
}

string theme_get_commment_to_gui_tree(const TreeNode &tr)
{
	/// TD 4-19-06 VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	return okutil_theme_get_commment_to_gui_tree(&tr);
	/// end VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	string strThemeComment;
	tr.GetAttribute(STR_THEME_COMMENT_ATTRIB, strThemeComment);
	return strThemeComment;
}

///End THEME_SAVE_AS_DIALOG
///Jasmine 07/20/2011 ORG-3106-S3-2-7 GENERAL_COPY_GRID_VALUE, move to sys_utils
////---- CPY 7/11/2006 USER_COMMENTS_ON_GRID_TABLE
//bool copy_to_clipboard(const string& str, bool bEmptyFirst = true, bool bUseOriginFormat = true)
//{
	//bool bRet = false;
	//HGLOBAL hData = GlobalAlloc(GHND, str.GetLength()+1);	
	//if( hData )
	//{
		//LPSTR lpsz = (LPSTR) GlobalLock(hData);		
		//if( lpsz )
		//{
			//strcpy(lpsz, str);	
			//GlobalUnlock(hData);	
			//if( OpenClipboard(NULL) )
			//{
				//if(!bEmptyFirst || EmptyClipboard() )
				//{
					//uint nCFStyles = CF_TEXT;
					//if(bUseOriginFormat)
						//nCFStyles = GetOriginClipboardFormat();
						//
					//if( NULL != SetClipboardData(nCFStyles, hData) )
					//{
						//hData = NULL;
						//bRet = true;
					//}
				//}	
				//CloseClipboard();
			//}
		//}
		//if( hData )
			//GlobalFree(hData);
	//}
	//
	//return bRet;
//}
////----
///End GENERAL_COPY_GRID_VALUE
/// RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT
bool theme_copy_to_clipboard(const TreeNode& tr)
{
	bool bRet = false;
	string str = tr.XML;
	return copy_to_clipboard(str);
}
//CPY
bool theme_get_from_clipboard(Tree& tr)
{
	int nCFStyles = GetOriginClipboardFormat();
	if(nCFStyles == 0 || !OpenClipboard(NULL))
		return false;
	bool bRet = false;
	string strXML;
	if( IsClipboardFormatAvailable( nCFStyles ) )
	{
		HANDLE hData = GetClipboardData( nCFStyles );
		if( hData )
		{
			LPCSTR lpData = (LPCSTR) GlobalLock( hData );
			if( lpData )
			{
				strXML = lpData;
				tr.XML = strXML;
				bRet = true;
				GlobalUnlock( hData );
			}
		}
	}
	CloseClipboard();
	return bRet;
}
/// end WKS_THEME_SUPPORT

///Iris 2/21/05 QA70-7416 ADD_THEME_SAVE_AS_BOX
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
//static bool _theme_saveas_box(string& strThemeName, string& strDescription, int thtype, \
		LPCSTR lpcszClassOption = NULL, int& thScopeType = NULL, string& strCategory = NULL, int* pnAllTables = NULL, HWND hWndParent = NULL)
static bool _theme_saveas_box(string& strThemeName, string& strDescription, int thtype, \
		LPCSTR lpcszClassOption = NULL, int& thScopeType = NULL, string& strCategory = NULL, int* pnAllTables = NULL, HWND hWndParent = NULL, TreeNode& trThemeFilter = NULL
		///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
		, LPCSTR lpcszCustomMakeTree = NULL
		, LPCSTR lpcszCustomName = NULL
		///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
		)
///---END QA80-11371 THEME_SAVING_OPTIONS
{		
	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_OPTION_GRIDLINE(flexGridFlatVert)
	
	//GETN_STR(ThemeName, "Theme Name", strThemeName)
	vector<string> vsFilenames, vsDisplayNames;
	///Iris 03/07/05 QA70-7345 ADD_FB_FILTER_THEME	
	//theme_get_class_settings(lpcszClassOption, vsFilenames, vsDisplayNames, thtype);
	/////Iris 3/03/05 FIX_SOME_THEME_SAVEAS_DLG_BUGS
	//int index = vsDisplayNames.Find(THEME_FILENAME_LAST_USED);
	//if(-1 != index)
		//vsDisplayNames.RemoveAt(index);
	/////end FIX_SOME_THEME_SAVEAS_DLG_BUGS
	
	/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
	// theme_get_class_settings(lpcszClassOption, vsFilenames, vsDisplayNames, thtype);
	///------ Folger 10/19/09 QA81-14145-S1 FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
	//okutil_theme_get_class_settings(lpcszClassOption, &vsFilenames, &vsDisplayNames, thtype);
	okutil_theme_get_class_settings(lpcszClassOption, &vsFilenames, &vsDisplayNames, thtype, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE);
	///------ End FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
	/// end MOVE_GET_CLASS_SETTINGS_TO_VC
	
	///end ADD_FB_FILTER_THEME
	
	///Joe 2006/7/28 THEME_EMPTY_SHOW_NAME
	string	strNames;
	if(vsDisplayNames.GetSize()>0)  
	///End THEME_EMPTY_SHOW_NAME
		strNames = "|" + rollback_string_tokens(vsDisplayNames, '|');

		
	//GETN_STRLIST(ThemeName, "Theme Name", "", strNames)
	///Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
	//GETN_STRLIST(ThemeName, STR_THEME_NAME, "", strNames)
	GETN_STRLIST(ThemeName, STR_THEME_NAME, strThemeName, strNames)
	///end DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
	///end DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
	GETN_EDIT_DISPLAY_WIDTH_RANGE( "30-30" )
	
	//GETN_STR(ThemeDesc, "Theme Description", strDescription)
	///---Sim 08-27-2009 QA81-14222 SHOW_HINT_FOR_BOOK_SHEET_THEME_SAVE_AS
	GETN_STR(ThemeHint, strDescription, "")	GETN_HINT
	if( strDescription.IsEmpty() )
		tr.ThemeHint.Show = false;
	///---END QA81-14222 SHOW_HINT_FOR_BOOK_SHEET_THEME_SAVE_AS
	///Jasmine 07/14/09 NANOSZIER_NEED_DESCRIPTION_TO_REMINDER_USER
	string strThemeDesc;
	if(trThemeFilter)
		trThemeFilter.GetAttribute(STR_TIPS_ATTRIB, strThemeDesc);
	GETN_STR(ThemeDesc, strThemeDesc, "")	GETN_HINT
	if( strThemeDesc.IsEmpty() )
		tr.ThemeDesc.Show = false;
	///End NANOSZIER_NEED_DESCRIPTION_TO_REMINDER_USER
	
	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	GETN_BEGIN_BRANCH(ThemeFilter, STR_LABEL_THEME_FILTER_SETTING) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_BRANCH(ThemeFilter) 
	
	if ( trThemeFilter && !trThemeFilter.IsEmpty() )
	//------ Folger 08/20/08 ADD_F1_CONTEXT_HELP_IN_THEME_SAVE_AS_DIALOG
	{
	//------
		tr.ThemeFilter.Replace(trThemeFilter, true, true, true);
		//------ Folger 08/20/08 ADD_F1_CONTEXT_HELP_IN_THEME_SAVE_AS_DIALOG
		int		nHelpID;
		if ( trThemeFilter.GetAttribute(STR_HELPID_ATTRIB, nHelpID) )
			tr.SetAttribute(STR_HELPID_ATTRIB, nHelpID);
		//------ End ADD_F1_CONTEXT_HELP_IN_THEME_SAVE_AS_DIALOG
	}
	else
		tr.ThemeFilter.Show = 0;
	///---END QA80-11371 THEME_SAVING_OPTIONS

	///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
	if ( NULL != lpcszCustomMakeTree && '\0' != *lpcszCustomMakeTree )
	{
		PFN_THEME_SAVE_AS_CUSTOM_MAKE_TREE		pfn = Project.FindCompiledFunction(lpcszCustomMakeTree);
		if ( pfn )
			pfn(tr);
	}
	///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
	
	///Joseph 04/29/07 TEMP_NOT_USING_SCOPE
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE	
	//if(!GetNBox( tr, "Theme Save as...", "Please specify theme name and description", NULL, NULL, hWndParent))
		//return FALSE;
	//if(!GetNBox( tr, "Theme Save as...", "Please specify theme name", NULL, NULL, hWndParent))
	if(!GetNBox( tr, STR_THEME_SAVE_AS, STR_THEME_DLG_DESCRIPTION, NULL, NULL, hWndParent))
		return FALSE;
	strThemeName = tr.ThemeName.strVal;	
	strThemeName = okutil_separate_composite_name(strThemeName);
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	if ( trThemeFilter )
	{
		tree_copy_values_by_id(tr.ThemeFilter, trThemeFilter);
	}
	///---END QA80-11371 THEME_SAVING_OPTIONS
	///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
	if ( NULL != lpcszCustomName && '\0' != *lpcszCustomName )
	{
		PFN_THEME_SAVE_AS_CUSTOM_NAME		pfn = Project.FindCompiledFunction(lpcszCustomName);
		if ( pfn )
		{
			pfn(strThemeName, tr);
		}
	}
	///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
	/*
	//Scope list
	if(NULL != thScopeType)
	{
		GETN_LIST(Scope, "Theme Scope", thScopeType, "Current Analysis|Analysis Category|All Analyses")
		GETN_OPTION_EVENT(theme_ask_name_on_change_scope)
		
		//Category list
		///DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
		// vector<string>  vsCategory;	
		// theme_find_class_categories(lpcszClassOption, vsCategory);
		// vsCategory.Add(STR_NEW + STR_THREE_DOTS);	
		// GETN_STRLIST(Category, "Category", strCategory,  rollback_string_tokens(vsCategory, '|'))	
		// GETN_OPTION_EVENT(theme_ask_name_on_change_category)
		///Joseph 09/21/06   SHOW_CATEGORY_ON_SAVEAS  
		//StringArray  saCategory;
		//okutil_theme_find_class_categories(lpcszClassOption, &saCategory);
		//
		//saCategory.Add(STR_NEW + STR_THREE_DOTS);	
		//GETN_STRLIST(Category, "Category", strCategory,  rollback_string_tokens(saCategory, '|'))	
		//GETN_OPTION_EVENT(theme_ask_name_on_change_category)
		XFunction xf; 
	    xf.Load(NULL, lpcszClassOption , LTXF_LIST);
	    TreeNode trXF = xf.GetTree(); 
	    string strCategory = xf_get_category_name(trXF);
	    GETN_STR(Category, "Category", strCategory)
	    GETN_READ_ONLY
	    ///End SHOW_CATEGORY_ON_SAVEAS
		///end MOVE_GET_CLASS_SETTINGS_TO_VC
	}		
	
	if( NULL != pnAllTables && THTYPE_REPORT_TABLE == thtype )
	{
		GETN_LIST(Tables, "Tables", *pnAllTables==0?0:1, "All Tables|This Table")
	}
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE	
	//if(!GetNBox( tr, "Theme Save as...", "Please specify theme name and description", NULL, NULL, hWndParent))
		//return FALSE;
	if(!GetNBox( tr, "Theme Save as...", "Please specify theme name", NULL, NULL, hWndParent))
		return FALSE;
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	strThemeName = tr.ThemeName.strVal;	
	strThemeName = okutil_separate_composite_name(strThemeName);

	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	//strDescription = tr.ThemeDesc.strVal;	
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	if(NULL != thScopeType)
	{
		///Iris 03/03/05 FIX_SOME_THEME_SAVEAS_DLG_BUGS
		//thScopeType = _theme_extract_scope_from_display_name(strThemeName);
		//if(-1 == thScopeType)
		///End FIX_SOME_THEME_SAVEAS_DLG_BUGS
		thScopeType = tr.Scope.nVal;
		if(NULL != strCategory && THTYPESCOPE_ANALYSIS_CATEGORY == thScopeType)
		{
			strCategory = tr.Category.strVal;
			theme_update_category_to_themeorganizer(strCategory, lpcszClassOption);
		}
		else if(NULL == strCategory)
			error_report("strCategory  cannot be NULL when thScopetype is not -1");			
	}
	
	if( NULL != pnAllTables && THTYPE_REPORT_TABLE == thtype && 0 == tr.Tables.nVal && 0 != *pnAllTables )
		*pnAllTables = 0;
	*/
	///End TEMP_NOT_USING_SCOPE
	return true;	
}

///Iris 3/04/05 FIX_SOME_THEME_SAVEAS_DLG_BUGS
///---Frank 4/13/05 THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
//static bool _theme_simple_saveas_box(string& strThemeName, string& strDescription, int thtype, LPCSTR lpcszClassOption = NULL, int* pnAllTables = NULL)
///----Frank 4/15/05 SAVE_AS_SHOULD_FROM_PARENT_DLG
//static bool _theme_simple_saveas_box(string& strThemeName, string& strDescription, int thtype, LPCSTR lpcszClassOption = NULL, int* pnAllTables = NULL, bool &bSaveThemeAsSystem = false)
static bool _theme_simple_saveas_box(string& strThemeName, string& strDescription, int thtype, LPCSTR lpcszClassOption = NULL, int* pnAllTables = NULL, bool &bSaveThemeAsSystem = false, HWND hWndParent = NULL)
///----End SAVE_AS_SHOULD_FROM_PARENT_DLG
///---End THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
{	
	vector<string> vsFilenames, vsDisplayNames;
	
	/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
	// theme_get_class_settings(lpcszClassOption, vsFilenames, vsDisplayNames, thtype);
	///------ Folger 10/19/09 QA81-14145-S1 FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
	//okutil_theme_get_class_settings(lpcszClassOption, &vsFilenames, &vsDisplayNames, thtype);
	okutil_theme_get_class_settings(lpcszClassOption, &vsFilenames, &vsDisplayNames, thtype, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE);
	///------ End FOLDER_LAST_USED_THEME_SHOULD_NOT_SHOW_IN_THEME_SAVEAS_DIALOG
	/// end MOVE_GET_CLASS_SETTINGS_TO_VC
	
	///Iris 3/09/05 add description edit box
	//if (!combo_input_box(strThemeName, _L("Please specify a Theme name to save"), _L("Analysis Theme"), vsDisplayNames))
	//	return false;	
	string strNames;
	if(vsDisplayNames.GetSize()>0)
		strNames = "|" + rollback_string_tokens(vsDisplayNames, '|');
	
	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_OPTION_GRIDLINE(flexGridFlatVert) //--- 1. divider line
	/// Max 11/1/07 CORRECT_LOCALIZATION
	//GETN_STRLIST(ThemeName, "Theme Name", "", strNames)	
	GETN_STRLIST(ThemeName, STR_THEME_NAME, "", strNames)
	/// END CORRECT_LOCALIZATION
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	//by max suggestion, CP said.
	//delete the editbox line
	//GETN_STR(ThemeDesc, "Theme Description", strDescription)
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
	///---Frank 4/13/05 THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
	/// Max 11/1/07 CORRECT_LOCALIZATION
	//GETN_CHECK(SetAsSystem, "Set As system theme", 0)
	GETN_CHECK(SetAsSystem, STR_SET_AS_SYSTEM_THEME, 0)
	/// END CORRECT_LOCALIZATION
	///---End THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	//change titile
	//if(!GetNBox( tr, "Theme Save as...", "Please specify theme name and description", NULL, NULL, hWndParent))
		//return false;
	/// Max 11/1/07 CORRECT_LOCALIZATION
	//if(!GetNBox( tr, "Theme Save as...", "Please specify theme name", NULL, NULL, hWndParent))
	if(!GetNBox( tr, STR_THEME_SAVE_AS, STR_THEME_DLG_DESCRIPTION, NULL, NULL, hWndParent))
	/// END CORRECT_LOCALIZATION
		return false;
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE

	strThemeName = tr.ThemeName.strVal;	
	strThemeName = okutil_separate_composite_name(strThemeName);
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	//not use disciption any more
	//strDescription = tr.ThemeDesc.strVal;
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
	///---Frank 4/13/05 THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
	if(tr.SetAsSystem.nVal == 1)
		bSaveThemeAsSystem = true;
	///---End THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
	
	return true;
}
///end FIX_SOME_THEME_SAVEAS_DLG_BUGS
///---Frank 4/13/05 THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
void 	_set_as_system_theme(LPCSTR lpcszClassOption,  LPCSTR lpcszSysThemePath = NULL )
{
	string strCustomTableName = "Custom table";
	string strReportName = "Report";
	string strThemeItem = "Theme";
	string strSysThemeKey = "System theme";
	
	string strRegPath =  strThemeItem + '\\'+ strReportName + '\\' + strCustomTableName + '\\'+ strSysThemeKey;
	
	set_reg_value(strRegPath, lpcszClassOption, lpcszSysThemePath);
}
string 	_get_as_system_theme(LPCSTR lpcszClassOption )
{
	string strCustomTableName = "Custom table";
	string strReportName = "Report";
	string strThemeItem = "Theme";
	string strSysThemeKey = "System theme";
	
	string strRegPath =  strThemeItem + '\\'+ strReportName + '\\' + strCustomTableName + '\\'+ strSysThemeKey;
	
	return get_reg_value(strRegPath, lpcszClassOption);
}
///---End THEME_SUPPORT_SAVE_AS_SYSTEM_THEME

///----Frank 4/15/05 SAVE_AS_SHOULD_FROM_PARENT_DLG
//bool    theme_save_as_box(string &strPathName, int thtype, string& strThemeName, string& strDescription, 
       //LPCSTR lpcszClassOption, int& thScopeType, string& strCategory, int* pnAllTables)
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
//bool    theme_save_as_box(string &strPathName, int thtype, string& strThemeName, string& strDescription, \
       LPCSTR lpcszClassOption, int& thScopeType, string& strCategory, int* pnAllTables, HWND hWndParent)
bool    theme_save_as_box(string &strPathName, int thtype, string& strThemeName, string& strDescription, \
       LPCSTR lpcszClassOption, int& thScopeType, string& strCategory, int* pnAllTables, HWND hWndParent, TreeNode& trThemeFilter
	   ///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
	   , LPCSTR lpcszCustomMakeTree/* = NULL*/
	   , LPCSTR lpcszCustomName/* = NULL*/
	   ///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
	   )
///---END QA80-11371 THEME_SAVING_OPTIONS
///----End SAVE_AS_SHOULD_FROM_PARENT_DLG
{
	bool bSaveAsSysTheme = false;	///---Frank 4/13/05 THEME_SUPPORT_SAVE_AS_SYSTEM_THEME

	/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
	//	if(THTYPE_ANALYSIS == thtype)
	if(THTYPE_ANALYSIS == thtype || THTYPE_XFUNCTION == thtype )
	/// end XF_THEME_SUPPORT
	{
		///----Frank 4/15/05 SAVE_AS_SHOULD_FROM_PARENT_DLG
		//if( !_theme_saveas_box(strThemeName, strDescription, thtype, lpcszClassOption, 
				//thScopeType, strCategory, pnAllTables) )
		///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
		//if( !_theme_saveas_box(strThemeName, strDescription, thtype, lpcszClassOption, \
				thScopeType, strCategory, pnAllTables, hWndParent) )
		if( !_theme_saveas_box(strThemeName, strDescription, thtype, lpcszClassOption, \
				thScopeType, strCategory, pnAllTables, hWndParent, trThemeFilter
				///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
				, lpcszCustomMakeTree
				, lpcszCustomName
				///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
				) )
		///---END QA80-11371 THEME_SAVING_OPTIONS
		///----End SAVE_AS_SHOULD_FROM_PARENT_DLG
			return false;
	}
	///Iris 3/04/05 FIX_SOME_THEME_SAVEAS_DLG_BUGS
	else
	{
		///---Frank 4/13/05 THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
		//if( !_theme_simple_saveas_box(strThemeName, strDescription, thtype, lpcszClassOption, pnAllTables))
			//return false;
		///----Frank 4/15/05 SAVE_AS_SHOULD_FROM_PARENT_DLG
		//if( !_theme_simple_saveas_box(strThemeName, strDescription, thtype, lpcszClassOption, pnAllTables, bSaveAsSysTheme))
			//return false;
		if( !_theme_simple_saveas_box(strThemeName, strDescription, thtype, lpcszClassOption, pnAllTables, bSaveAsSysTheme, hWndParent))
			return false;
		///----End SAVE_AS_SHOULD_FROM_PARENT_DLG
		///---End THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
	}
	///end FIX_SOME_THEME_SAVEAS_DLG_BUGS

	///DSC 3/11/05 QA70-7479 MOVE_TO_VC_FIX_ARGUMENTS
	///convert int& to int, string& to LPCSTR
	///strPathName = okutil_theme_construct_filename(strThemeName, thtype, ORIGIN_PATH_USER, thScopeType, lpcszClassOption, strCategory, pnAllTables);
	int nScope;
	if(NULL==thScopeType)
		nScope = THTYPESCOPE_UNDEF;
	else
		nScope=thScopeType;
	
	string strCat;
	if(NULL==strCategory)// null reference
		strCat="";
	else
		strCat=strCategory;
	
	strPathName = okutil_theme_construct_filename(strThemeName, thtype, ORIGIN_PATH_USER, nScope, lpcszClassOption, strCat, pnAllTables);
	///end MOVE_TO_VC_FIX_ARGUMENTS
	
	///---Frank 4/13/05 THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
	if(bSaveAsSysTheme)
		_set_as_system_theme(lpcszClassOption, strPathName);
	///---End THEME_SUPPORT_SAVE_AS_SYSTEM_THEME
	
	return true;
}
/*
string theme_construct_filename(string strThemeName, int thtype, int nPathType, int nScope, 
						LPCSTR lpcszClassOption, LPCSTR lpcszCategory, int* pnTableID)//=ORIGIN_PATH_USER, =0,=NULL,=NULL,= NULL
{
	string strFilename, strPathName;
	_theme_construct_filename(strFilename, strThemeName, nScope, lpcszClassOption, lpcszCategory, pnTableID);

	//--- CPY 2/24/05 ANALYSIS_THEME_NOT_WORKING_CLEAN_UP, inconsistency between theme_get_file_extension and add_file_extension resulted in double ..ext
	//if( add_file_extension(strFilename, theme_get_file_extension(thtype)) )
	strPathName = okutil_theme_get_path(nPathType, thtype) + strFilename + okutil_theme_get_file_extension(thtype);
	//---
	return strPathName;
}
*/
///Iris 2/24/05 duplicate function as theme_get_file_extension
/*
static string _theme_get_file_ext(int nthtype)
{
	string strExt;
	switch(nthtype)
	{
    case THTYPE_ANALYSIS:
    case THTYPE_DIALOG:
    	strExt = "OIS";
    	break;
	default:
		strExt = THEME_FILE_EXT;
		break;
	}
	return strExt;
}
*/
///DSC 3/7/05 v8.0201 MOVE_TO_OKUTIL
/*
static string _theme_get_sub_special_folder(int nthtype)
{
	string strFolder;
	switch(nthtype)
	{
	case THTYPE_GRAPH:
		strFolder = "Graph";
		break;
	case THTYPE_WORKSHEET:
		strFolder = "Worksheet";
		break;
	case THTYPE_MATRIX:
		strFolder = "Matrix";
		break;
    case THTYPE_ANALYSIS:
	case THTYPE_REPORT_TABLE:
		strFolder = "AnalysisAndReportTable";	
		break;
    case THTYPE_DIALOG:
    	strFolder = "Dialog";	
    	break;
	}	
	return strFolder;
}
*/
///end MOVE_TO_OKUTIL

bool    theme_save(Tree &tr, LPCSTR lpcszName, int thtype, int thScope, LPCSTR lpczClassOption, LPCSTR lpcszCategory, uint nTableID)
{
	string strPath = okutil_theme_construct_filename(lpcszName, thtype, ORIGIN_PATH_USER, thScope, lpczClassOption, lpcszCategory, &nTableID);
	return tr.Save(strPath);
}

bool    theme_load(Tree &tr, LPCSTR lpcszName, int nPathType, int thtype, int thScope, LPCSTR lpczClassOption, LPCSTR lpcszCategory, uint nTableID)
{
	string strPath = okutil_theme_construct_filename(lpcszName, thtype, nPathType, thScope, lpczClassOption, lpcszCategory, &nTableID);
	return tr.Load(strPath);
}
///End ADD_THEME_SAVE_AS_BOX


// return fullpath theme filename
// or
// return "" if factory default should be used
// DSC 3/1/05 v8.0200 CENTRALIZE_PATH_CATEGORY_NAME_CODES
// string theme_get_settings_file(LPCSTR lpcszThemeDisplayName, LPCSTR lpcszClassNameWithOption, string* pstrThemeName)
string theme_get_settings_file(LPCSTR lpcszThemeDisplayName, LPCSTR lpcszClassNameWithOption, int nThemeType, string* pstrThemeName, int* pnScope, LPCSTR lpcszCategory)// =THTYPE_ANALYSIS, =NULL, =NULL, =NULL, =NULL
// end CENTRALIZE_PATH_CATEGORY_NAME_CODES
{
	//------ Folger 04/17/08 FIX_RESET_THEME_WILL_LOAD_LAST_USED_THEME
	if ( lstrlen(lpcszThemeDisplayName) == 0 )
		return "";
	//------
	
	return okutil_theme_get_settings_file(lpcszThemeDisplayName, lpcszClassNameWithOption, nThemeType, pstrThemeName, pnScope, lpcszCategory);
}

bool theme_rename(string strThemeName, string strOldName, int nPathType, int nThemeType)
{
	bool bWasSystemTheme = theme_system_getset(strOldName, false, false, nPathType, nThemeType);
	///Iris 2/22/05 QA70-7416 UPDATE_THEME_GET_FILENAME	
	//string strOldFile = theme_get_theme_file_name(strOldName, nPathType);
	//string strNewFile = theme_get_theme_file_name(strThemeName, nPathType);
	
	///Iris 3/22/05 UPDATE_FOR_EACH_THEME_TYPE
	//string strOldFile = okutil_theme_get_theme_file_name(strOldName, THTYPE_GRAPH, nPathType);
	//string strNewFile = okutil_theme_get_theme_file_name(strThemeName, THTYPE_GRAPH, nPathType);
	string strOldFile = okutil_theme_get_theme_file_name(strOldName, nThemeType, nPathType);
	string strNewFile = okutil_theme_get_theme_file_name(strThemeName, nThemeType, nPathType);
	///end UPDATE_FOR_EACH_THEME_TYPE
	///end UPDATE_THEME_GET_FILENAME
	if(strNewFile.IsFile())
		return false;
	if(bWasSystemTheme)
		theme_system_getset(strThemeName, true, bWasSystemTheme, nPathType, nThemeType);

	return RenameFile(strNewFile, strOldFile);
}

bool theme_get_next_file_name(string& strFilename, bool bCheckCreatePath, int nThemeType)//=true, =THTYPE_GRAPH
{
	int nn = 1;
	///DSC 2/15/05 GET_ORIGIN_PATH
	// string strThemePath = theme_get_path();
	// string strThemePath = theme_get_path(ORIGIN_PATH_USER, nThemeType);	
	string strThemePath = okutil_theme_get_path(ORIGIN_PATH_USER, nThemeType, false);
	///end GET_ORIGIN_PATH
	
	if(bCheckCreatePath && !CheckMakePath(strThemePath))
		return false;
		
	do
	{
		strFilename = strThemePath + "Theme" + nn + "." + THEME_FILE_EXT;
		nn++;
	} while (strFilename.IsFile());
	
	return true;
}

//------ CPY 03/08/08 QA80-11192 REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT
//bool is_theme_factory_default(LPCSTR lpcszName)
bool is_theme_default(LPCSTR lpcszName)
{
	///---Sim 09-05-2008 QA80-12151 NLFIT_TOO_SLOW_TO_OPEN
	//if(NULL == lpcszName || *lpcszName == '\0')
		//return false;
	//
	//if(lstrcmp(lpcszName, STR_THEME_DEFAULT_SHORT_FORM)==0)
		//return true;
	//int nn;
	//if((nn=okutil_cvt_str_to_predefined_type(lpcszName)) == PDS_FACTORY_DEFAULT || PDS_DEFAULT == nn)
		//return true;
	//
	//return false;
	if ( 0 == lstrcmp(lpcszName, STR_THEME_DEFAULT_SHORT_FORM) )
		return true;
	return ( PDS_DEFAULT == okutil_cvt_str_to_predefined_type(lpcszName) );
	///---END QA80-12151 NLFIT_TOO_SLOW_TO_OPEN
}
//------


//----- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
// apply theme and update STR_THEME_FILE_ATTRIB attribute 
///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool theme_apply_and_set_attribute(TreeNode& trGUI, LPCSTR lpcszSelectedThemeName, const string& strClassOption , bool bShowAdvanded, bool bLoadFactDefault)
///------ Folger 05/09/2011 ORG-2801-P3 BETTER_ERROR_MESSAGE_WHEN_THEME_NOT_EXIST
//bool theme_apply_and_set_attribute(TreeNode& trGUI, LPCSTR lpcszSelectedThemeName, const string& strClassOption , bool bShowAdvanded, bool bLoadFactDefault, TreeNode& trTheme)
bool theme_apply_and_set_attribute(TreeNode& trGUI, LPCSTR lpcszSelectedThemeName, const string& strClassOption , bool bShowAdvanded, bool bLoadFactDefault, TreeNode& trTheme, DWORD dwCntrl/* = 0*/)
///------ End BETTER_ERROR_MESSAGE_WHEN_THEME_NOT_EXIST
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
{
	///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
	if ( theme_is_folder_last_used(lpcszSelectedThemeName) )
	{
		return theme_load_xf_folder_last_used(trGUI, trTheme);
	}
	///------ End SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
	
	//---- CPY 6/4/2007 QA70-9860 SPECIAL_THEME_NAME_FOR_FACTORY_DEFAULT
	// if lpcszSelectedThemeName == "1"
	///---Sim 06-30-2007 PUT_OUT_GLOBAL_FUNC
	//if(_is_theme_default(lpcszSelectedThemeName))
	if(is_theme_default(lpcszSelectedThemeName))
	///---END PUT_OUT_GLOBAL_FUNC
	{
		//theme_load_default_settings(trGUI);
		///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		//theme_load_settings(trGUI, NULL, true);
		
		//------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
		//theme_load_settings(trGUI, NULL, true, trTheme);
		//theme_default_setting_management(trGUI, THEME_DEFAULT_GET, trTheme);
		//------
		
		///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		//tree_set_theme_file_name(trGUI, STR_THEME_DEFAULT_SHORT_FORM);
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		//tree_set_theme_file_name(trGUI, theme_default_setting_management(trGUI, THEME_DEFAULT_GET, trTheme) ? STR_THEME_DEFAULT_SHORT_FORM : STR_THEME_NONE);
		//return true;
		return theme_default_setting_management(trGUI, THEME_DEFAULT_GET, trTheme);
		///---END CLEAN_DEFAULT_THEME
	}
	//----
	///DSC 6/8/06 QA75-7518 XF_APPLY_THEME_SUPPORT_SEARCH
	// xf.ApplyTheme(strTheme, trInput);
	// If user did not specify a path as in >>smooth -t themename, 
	// then assume user wants to search for "themename" in order User; Group; System
	int nPathType = ORIGIN_PATH_UNDEF;
	bool bFoundTheme=FALSE;
	string strThemeName = okutil_separate_composite_name(lpcszSelectedThemeName, &nPathType, NULL, ORIGIN_PATH_UNDEF);
	if(ORIGIN_PATH_UNDEF == nPathType)
	{
		/// AW 10/05/06 QA70-9015 XF_THEME_BOOK_AND_SHEET
		///Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		//int nType = cvt_str_to_predefined_type(strThemeName);
		int nType = str_to_predefined_type(strThemeName);
		///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		//------ Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM
		//if( PDS_BOOK == nType || PDS_SHEET == nType )
		if( theme_get_save_type(nType) == THEME_TYPE_SVAE_TO_BOOK )
		//------ End IMPROVE_SAVE_THEME_MECHANISM
		{
			//------ Folger 02/29/08 QA80-11192 SHOW_WARNING_WHEN_THEME_NOT_EXIST
			//bFoundTheme=TRUE;
			/////Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
			////theme_active_book_sheet_storage(trGUI, strClassOption, nType, true);
			//theme_active_book_sheet_storage(trGUI, strClassOption, nType, true, trTheme);
			/////end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
			if ( !(bFoundTheme = theme_active_book_sheet_storage(trGUI, strClassOption, nType, true, trTheme)) )
				theme_show_warning_not_exist(strThemeName);
			//------
			tree_set_theme_file_name(trGUI, strThemeName);
		}
		///------ Folger 05/09/2011 ORG-2801-P2 REDUNDANT_ERROR_MESSAGE_SHOW_FOR_INVALID_THEME_FILE_NAME
		//else
		else if ( is_str_valid_for_filename(strThemeName) )
		///------ End REDUNDANT_ERROR_MESSAGE_SHOW_FOR_INVALID_THEME_FILE_NAME
		{
		/// END XF_THEME_BOOK_AND_SHEET

		string strThemeWithPath;
		for(int nPath=ORIGIN_PATH_USER; nPath<=ORIGIN_PATH_SYSTEM; nPath++)
		{
			//_append_path()
			strThemeWithPath = okutil_composite_name_from_components( nPath, NULL, strThemeName );
			
			string strThemeFile = theme_get_settings_file(strThemeWithPath, strClassOption, tree_get_theme_type(trGUI));

			if( strThemeFile.IsFile() )
			{
				bFoundTheme=TRUE;
				tree_set_theme_file_name(trGUI, strThemeFile);
				///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
				//theme_load_settings(trGUI, strThemeFile, bLoadFactDefault);
				theme_load_settings(trGUI, strThemeFile, bLoadFactDefault, trTheme);
				///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
				
				break;
			}
		}
		}	/// END XF_THEME_BOOK_AND_SHEET
	}
	else
	{
		string strThemeFile = theme_get_settings_file(lpcszSelectedThemeName, strClassOption, tree_get_theme_type(trGUI));
		if( strThemeFile.IsFile() )
		{
			bFoundTheme=TRUE;
			tree_set_theme_file_name(trGUI, strThemeFile);
			///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
			//theme_load_settings(trGUI, strThemeFile, bLoadFactDefault);
			theme_load_settings(trGUI, strThemeFile, bLoadFactDefault, trTheme);
			///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
		}
	}
	
	if(!bFoundTheme)// maybe better to report error instead of apply default?
	{
		///------ Folger 05/09/2011 ORG-2801-P3 BETTER_ERROR_MESSAGE_WHEN_THEME_NOT_EXIST
		///------ Folger 05/19/2011 ORG-2801-P4 REDUNDANT_MESSAGE_SHOW_WHEN_RESET_SYSTEM_DEFAULT_IN_NLFIT
		//if ( O_QUERY_BOOL(dwCntrl, APPLYANALYSISTHEME_SHOW_ERROR_IF_THEME_NOT_FOUND) )
		if ( O_QUERY_BOOL(dwCntrl, APPLYANALYSISTHEME_SHOW_ERROR_IF_THEME_NOT_FOUND) && !theme_is_factory_default(strThemeName) )
		///------ End REDUNDANT_MESSAGE_SHOW_WHEN_RESET_SYSTEM_DEFAULT_IN_NLFIT
		{
			theme_load_settings(trGUI
							, theme_get_settings_file(okutil_composite_name_from_components(ORIGIN_PATH_USER, NULL, strThemeName)
							, strClassOption, tree_get_theme_type(trGUI)), bLoadFactDefault, trTheme);
			/// fall through
		}
		///------ End BETTER_ERROR_MESSAGE_WHEN_THEME_NOT_EXIST
		//------ Folger 06/16/08 FIX_DEFAULT_THEME_DISPLAY_IN_IMPORT_ASCII_FROM_FILE_IMPORT_MENU
		tree_set_theme_file_name(trGUI, STR_THEME_NONE);
		//------
		
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		//theme_load_default_settings(trGUI, NULL, trTheme);
		///---END CLEAN_DEFAULT_THEME
		
		//tree_set_file_name(trGUI, strClassOption);///Frank 1/24/05 v8.0185 CENTRALIZE_CODE_OF_FILE_NAME_ATTRIB
		///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
		//tree_set_file_name(trGUI, NULL);//--- CPY 2/24/05 ANALYSIS_THEME_NOT_WORKING_CLEAN_UP, not sure why putting class name into filename attrib, seems better to clean it
		//tree_set_theme_file_name(trGUI, NULL);
		
		//------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
		//return false;
		string strClassOption;
		theme_get_class_option(trGUI, strClassOption);
		
		//------ Folger 03/21/08 QA80-11267 FIX_FACTORY_DEFAULT_RECALCULATE_MODE
		//return theme_get_default_settings(strClassOption);	//if <Default> exist, need to load theme
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		//return true;
		return theme_load_factory_default(strClassOption, trGUI);
		///---END CLEAN_DEFAULT_THEME
		//------
		
		//------
	}	
	tree_set_or_remove_attribute(trGUI, STR_SHOW_ADVANCED_ATTRIB,  bShowAdvanded);
	return bFoundTheme;
}

/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC	
/* 
//static void _theme_construct_filename(string& strFilename, LPCSTR lpcszThemeName, int nScope= THTYPESCOPE_ANALYSIS_CLASS, 
//					LPCSTR lpcszClassOption=NULL, LPCSTR lpcszCategory=NULL, int* pnTableID = NULL)
static void _theme_construct_filename(string* pstrFilename, LPCSTR lpcszThemeName, int nScope= THTYPESCOPE_ANALYSIS_CLASS, 
					LPCSTR lpcszClassOption=NULL, LPCSTR lpcszCategory=NULL, int* pnTableID = NULL)
{
	string strMid = "-";
	string strUnderScore = "_";
	string strFilenamePrefix;
	
	if(THTYPESCOPE_UNDEF != nScope)///DSC 3/11/05 QA70-7479 MOVE_TO_VC_FIX_ARGUMENTS
	{	
	if(THTYPESCOPE_ANALYSIS_CATEGORY == nScope)
	{
		string strCategory(lpcszCategory);		
		if(NULL == lpcszCategory || strCategory.IsEmpty())
			strCategory = STR_CLASS_OPTION_NULL;
		strFilenamePrefix = strCategory + strMid;
	}
	else
		strFilenamePrefix = (string)nScope + strMid;
	}
	
	// string strClassOption(lpcszClassOption);
	if(lpcszClassOption)
	{
	string strClassOption(lpcszClassOption);
	///Iris 3/03/05 FIX_SOME_THEME_SAVEAS_DLG_BUGS
	//if(NULL == lpcszClassOption || strClassOption.IsEmpty())
		//strClassOption = STR_CLASS_OPTION_NULL;
	///End FIX_SOME_THEME_SAVEAS_DLG_BUGS
	strFilenamePrefix += strClassOption;
	}
	
	if(NULL != pnTableID && *pnTableID>0 )
	{
		string strID;
		strID.Format("%d", *pnTableID);
		strFilenamePrefix +=  strUnderScore + strUnderScore + strID;
	}
	
	///DSC 3/11/05 QA70-7479 MOVE_TO_VC_FIX_ARGUMENTS
	if(!strFilenamePrefix.IsEmpty())
		strFilenamePrefix += strMid;
	///end MOVE_TO_VC_FIX_ARGUMENTS
	
	string strThemeName = lpcszThemeName;
	if(strThemeName.IsEmpty())
	{
		if(lpcszThemeName) // ""
			strThemeName = STR_THEME_NAME_NULL;
		// else leave it as empty
	}		
	
	///DSC 3/11/05 QA70-7479 MOVE_TO_VC_FIX_ARGUMENTS
	//strFilename = strFilenamePrefix + strMid + strThemeName;
	*pstrFilename = strFilenamePrefix + strThemeName;
	///end MOVE_TO_VC_FIX_ARGUMENTS
	
	///Iris 3/03/05 FIX_SOME_THEME_SAVEAS_DLG_BUGS
	//strFilename.TrimLeft(strUnderScore);
	//strFilename.TrimRight(strUnderScore);
	//strFilename.TrimLeft(strMid);
	//strFilename.TrimRight(strMid);
	///end FIX_SOME_THEME_SAVEAS_DLG_BUGS
		
}
*/
/// end MOVE_GET_CLASS_SETTINGS_TO_VC

/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
/*
string okutil_theme_construct_filename(LPCSTR lpcszThemeName, int thtype, int nPathType, int nScope, 
						LPCSTR lpcszClassOption, LPCSTR lpcszCategory, int* pnTableID)//=ORIGIN_PATH_USER, =0,=NULL,=NULL,= NULL
{
	string strFilename, strPathName;
	_theme_construct_filename(strFilename, lpcszThemeName, nScope, lpcszClassOption, lpcszCategory, pnTableID);

	//--- CPY 2/24/05 ANALYSIS_THEME_NOT_WORKING_CLEAN_UP, inconsistency between theme_get_file_extension and add_file_extension resulted in double ..ext
	//if( add_file_extension(strFilename, theme_get_file_extension(thtype)) )
	strPathName = okutil_theme_get_path(nPathType, thtype) + strFilename + okutil_theme_get_file_extension(thtype);
	//---
	return strPathName;
}
*/
/// end MOVE_GET_CLASS_SETTINGS_TO_VC


/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
bool 	theme_get_registry_settings(LPCSTR lpcszClassName, LPCSTR lpcszKey, DWORD& dwVal)
{
	Registry reg(HKEY_CURRENT_USER);
	string strKey = GetRegKey() + "\\Classes\\" + lpcszClassName;
	string strValueName = lpcszKey;
	if(strValueName.IsEmpty())
		strValueName = "GUI"; 
		
	dwVal = 0;
	if(reg.GetValue(strKey, strValueName, dwVal))
		return true;
		
	return false;
}

bool 	theme_get_registry_settings(LPCSTR lpcszClassName, LPCSTR lpcszKey, string& strVal)
{
	Registry reg(HKEY_CURRENT_USER);
	string strKey = GetRegKey() + "\\Classes\\" + lpcszClassName;
	string strValueName = lpcszKey;
	if(strValueName.IsEmpty())
		strValueName = "Theme"; 
		
	strVal = "";
	if(reg.GetValue(strKey, strValueName, strVal))
	{
		//------ CPY 03/08/08 QA80-11192 REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		//if(okutil_cvt_str_to_predefined_type(strVal) == PDS_FACTORY_DEFAULT)
		if ( theme_is_factory_default(strVal) )
		///---END CLEAN_DEFAULT_THEME
			strVal = STR_DEFAULT_E;
		//------
		return true;
	}
	
	return false;
}

void 	theme_set_registry_settings(LPCSTR lpcszClassName, LPCSTR lpcszKey, LPCSTR lpcszVal)
{
	/// TD 4-19-06 VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	okutil_theme_set_registry_settings(lpcszClassName, lpcszKey, lpcszVal);
	return;
	/// end VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	Registry reg(HKEY_CURRENT_USER);
	string strKey = GetRegKey() + "\\Classes\\" + lpcszClassName;
	string strValueName = lpcszKey;
	if(strValueName.IsEmpty())
		strValueName = "Theme"; 
		
	reg.SetValue(strKey, strValueName, lpcszVal);
}
//----- CPY 8/24/2007 QA70-10231 ALLOW_THEME_TO_BE_REMEMBER_IF_USER_CHANGED_FROM_DIALOG
/*
///---Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK
//void	theme_update_last_used(LPCSTR lpcszClassName, TreeNode& tr)
//void	theme_update_last_used(LPCSTR lpcszClassName, TreeNode& trGetN, TreeNode& trThemes) // = NULL
///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME
//void	theme_update_last_used(LPCSTR lpcszClassName, TreeNode& tr, bool bThemesTree)// = false
void	theme_update_last_used(LPCSTR lpcszClassName, TreeNode& tr, bool bThemesTree, TreeNode& trSrc)// = false, NULL
///end CORRECT_LOGIC_OF_LOADING_THEME
///---END IMPROVE_MULTI_THEME_FRAME_WORK
{
	/// TD 4-19-06 VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	///Joseph  10/23/06 ADD_MULIXF_THEME
	//okutil_theme_update_last_used(lpcszClassName, &tr);
	//return;
	///End ADD_MULIXF_THEME
	/// end VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
	string strThemeFileLastUsed = theme_get_settings_file(NULL, lpcszClassName, tree_get_theme_type(tr));
	string strThemeFile;
	//tree_get_file_name(tr, strThemeFile);///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
	tree_get_theme_file_name(tr, strThemeFile);
	///Joseph  10/23/06 ADD_MULIXF_THEME
	//if(strThemeFile.IsEmpty())
	///End ADD_MULIXF_THEME
		strThemeFile = strThemeFileLastUsed;
	string strThemeName = okutil_theme_file_to_display_name(strThemeFile);
	theme_set_registry_settings(lpcszClassName, NULL, strThemeName);

	
	string strShowAdvanced;
	if ( !bThemesTree ) ///---Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK
		tr.GetAttribute(STR_SHOW_ADVANCED_ATTRIB, strShowAdvanced);
	theme_set_registry_settings(lpcszClassName, STR_SHOW_ADVANCED, strShowAdvanced);
	//tree_set_file_name(tr, strThemeFileLastUsed);///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
	tree_set_theme_file_name(tr, strThemeFileLastUsed);
	///---Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK
	//if( !theme_save_settings(tr) )
	bool bRet;
	if ( !bThemesTree ) // GetN tree
	{	
		///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME
		//bRet = theme_save_settings(tr);
		bRet = theme_save_settings(tr, NULL, true, trSrc);
		///end CORRECT_LOGIC_OF_LOADING_THEME
	}
	else // Theme tree
	{
		bRet = themes_tree_to_file(tr);
	}
	
	if ( !bRet )
		error_report("saving to Last Used settings file failed");
	///---END IMPROVE_MULTI_THEME_FRAME_WORK
}
*/
void	theme_update_last_used(LPCSTR lpcszClassName, TreeNode& tr, bool bThemesTree, TreeNode& trSrc, DWORD dwCntrlFromXF)// = false, NULL
{
	string strThemeFile;
	tree_get_theme_file_name(tr, strThemeFile);
	//----- CPY 8/28/2007 QA70-10321 THEME_FROM_FACTORY_DEFAULT_GOT_SAVED
	///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
	//BOOL bDefaultTheme = strThemeFile == STR_THEME_DEFAULT_SHORT_FORM? true:false;
	BOOL bDefaultTheme = ( theme_is_factory_default(strThemeFile) || is_theme_default(strThemeFile) );
	///---END CLEAN_DEFAULT_THEME
	int nn = okutil_cvt_str_to_predefined_type(strThemeFile);
	///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
	//if(!bDefaultTheme && PDS_FACTORY_DEFAULT == nn || PDS_DEFAULT == nn )
		//bDefaultTheme = true;
	///---END CLEAN_DEFAULT_THEME
	//-----
	//------ Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM
	//BOOL bBookSheetTheme=(PDS_BOOK == nn || PDS_SHEET == nn)? true:false;
	BOOL bBookSheetTheme= (theme_get_save_type(nn) == THEME_TYPE_SVAE_TO_BOOK)? true:false;
	//------ End IMPROVE_SAVE_THEME_MECHANISM
	string strThemeName; 
	//----- CPY 8/28/2007 QA70-10321 THEME_FROM_FACTORY_DEFAULT_GOT_SAVED
	//if(bBookSheetTheme)
	//{
	//	strThemeName = strThemeFile;
	//	strThemeFile = THEME_FILENAME_LAST_USED;
	//}
	if(bBookSheetTheme || bDefaultTheme)
	{
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		//if(bDefaultTheme)
			//strThemeName = STR_THEME_DEFAULT_SHORT_FORM;
		//else
			//strThemeName = strThemeFile;
		strThemeName = strThemeFile;
		///---END CLEAN_DEFAULT_THEME
		strThemeFile = THEME_FILENAME_LAST_USED;
	}
	//-----
	//---- CPY 9/22/2007 QA70-10231 WHEN_CURRENT_THEME_SAVED_INSTEAD_OF_LAST_USED
	/*
	string strThemeFileLastUsed = strThemeFile;
	if(!is_str_has_path(strThemeFile))
		strThemeFileLastUsed = theme_get_settings_file(strThemeFile, lpcszClassName, tree_get_theme_type(tr));
	if(strThemeName.IsEmpty())
		strThemeName = okutil_theme_file_to_display_name(strThemeFileLastUsed);
	*/
	string strThemeFileLastUsed, strThemeFileCurrent = strThemeFile;
	if(!is_str_has_path(strThemeFile))
		strThemeFileCurrent = theme_get_settings_file(strThemeFile, lpcszClassName, tree_get_theme_type(tr));
	if(strThemeName.IsEmpty())
		strThemeName = okutil_theme_file_to_display_name(strThemeFileCurrent);
	strThemeFileLastUsed = theme_get_settings_file(THEME_FILENAME_LAST_USED, lpcszClassName, tree_get_theme_type(tr));
	//----- end WHEN_CURRENT_THEME_SAVED_INSTEAD_OF_LAST_USED
	//------------- CPY 3/14/2008 QA70-11192-P7 REGISTRY_UPDATE_FROM_DIALOG_THEME_CHANGING_ONLY
	/*
	//--- CPY 8/30/2007 QA70-10231 ALLOW_THEME_TO_BE_REMEMBER_IF_USER_CHANGED_FROM_DIALOG_BUT_NOT_WHEN_FROM_MRM
	if(!(dwCntrlFromXF & LTXF_FROM_MRU_MENU))
	//---
	//------ CPY 9/15/2007 QA70-10382 FACTORY_DEFAULT_SAVING_INTO_REGISTRY
	//theme_set_registry_settings(lpcszClassName, NULL, strThemeName);
	{
		if(is_theme_default(strThemeName)) // if dialog first time, we will save it as last used
		{
			string strCurrentTheme;
			if(!theme_get_registry_settings(lpcszClassName, NULL, strCurrentTheme))
				strThemeName = STR_LAST_USED;
		}
		theme_set_registry_settings(lpcszClassName, NULL, strThemeName);
	}
	*/
	//------------- end REGISTRY_UPDATE_FROM_DIALOG_THEME_CHANGING_ONLY
	//------	
	string strShowAdvanced;
	if ( !bThemesTree ) ///---Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK
		tr.GetAttribute(STR_SHOW_ADVANCED_ATTRIB, strShowAdvanced);
	theme_set_registry_settings(lpcszClassName, STR_SHOW_ADVANCED, strShowAdvanced);
	tree_set_theme_file_name(tr, strThemeFileLastUsed);
	//----- CPY 8/28/2007 QA70-10321 THEME_FROM_FACTORY_DEFAULT_GOT_SAVED
	if(!is_str_has_path(strThemeFileLastUsed))
	{
		error_report("trying to save a theme without actual file name");
		return; // not really theme file to be saved
	}
	//-----
	bool bRet;
	if ( !bThemesTree ) // GetN tree
	{	
		bRet = theme_save_settings(tr, NULL, true, trSrc);
	}
	else // Theme tree
	{
		bRet = themes_tree_to_file(tr);
	}
#ifdef		_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
	///Sophy 12/18/2008 v8.0988 QA80-12798 CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU
	tr.SetAttribute(STR_THEME_NAME_ATTRIB, strThemeName);
	///end CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU
#endif		//_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
	
	if ( !bRet )
		error_report("saving to Last Used settings file failed");
}
//----- end ALLOW_THEME_TO_BE_REMEMBER_IF_USER_CHANGED_FROM_DIALOG

//---- CPY 4/19/07 XF_APPLY_THEME_SHOULD_NOT_GET_FACTORY_DEFAULT_FIRST, added bLoadFactDefault
// loading factor default slows things down, when XF is just loaded, it is already factory default
///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool	theme_apply_analysis_theme(LPCSTR lpcszClassName, TreeNode& tr, LPCSTR lpcszThemeName, bool bLoadFactDefault)
///------ Folger 05/09/2011 ORG-2801-P3 BETTER_ERROR_MESSAGE_WHEN_THEME_NOT_EXIST
//bool	theme_apply_analysis_theme(LPCSTR lpcszClassName, TreeNode& tr, LPCSTR lpcszThemeName, bool bLoadFactDefault, TreeNode& trTheme)
bool	theme_apply_analysis_theme(LPCSTR lpcszClassName, TreeNode& tr, LPCSTR lpcszThemeName, bool bLoadFactDefault, TreeNode& trTheme, DWORD dwCntrl/* = 0*/)
///------ End BETTER_ERROR_MESSAGE_WHEN_THEME_NOT_EXIST
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
{
	//----- CPY 2/27/07 THEME_AUTOUPDATE_CLEAN_UP
	//if(!lpcszThemeName)
	//	return;
	//-----
	string strThemeName = lpcszThemeName;
	if( strThemeName.IsEmpty() )
		theme_get_registry_settings(lpcszClassName, NULL, strThemeName);
	
	//------ Folger 03/04/08 QA80-11192 UPDATE_GETN_TREE_CLASS_OPTION
	string strClassOption;
	if ( !theme_get_class_option(tr, strClassOption) )
		tr.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, lpcszClassName);
	//------

	string strShowAdvanced;
	theme_get_registry_settings(lpcszClassName, STR_SHOW_ADVANCED, strShowAdvanced);
	///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
	//return theme_apply_and_set_attribute(tr, strThemeName, lpcszClassName, strShowAdvanced.IsEmpty() ? false : true, bLoadFactDefault); 
	///------ Folger 05/09/2011 ORG-2801-P3 BETTER_ERROR_MESSAGE_WHEN_THEME_NOT_EXIST
	//return theme_apply_and_set_attribute(tr, strThemeName, lpcszClassName, strShowAdvanced.IsEmpty() ? false : true, bLoadFactDefault, trTheme); 
	return theme_apply_and_set_attribute(tr, strThemeName, lpcszClassName, strShowAdvanced.IsEmpty() ? false : true, bLoadFactDefault, trTheme, dwCntrl); 
	///------ End BETTER_ERROR_MESSAGE_WHEN_THEME_NOT_EXIST
	///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
}
//----- CPY 3/1/07 THEME_AUTOUPDATE_CLEAN_UP
// I have rewritten this function
//int	theme_is_autoupdate(LPCSTR lpcszClassName, LPCSTR lpcszThemeName)
// return true if theme is used, regardless of having AutoUpdate node
bool	theme_get_recalculate(int& nRecalculate, LPCSTR lpcszClassName, LPCSTR lpcszThemeFileName, bool bEmptyFileToUseRegSettings)
{
	string strThemeName = lpcszThemeFileName;
	// Yuri original code "simplest way - create little tree, apply theme to it and check value"
	Tree tr;
	TreeNode trAuto = tr.AddNumericNode(FALSE, STR_AUTOUPDATE_NODE, TRGP_CHECK);
	trAuto.DataID = IDE_AUTO_UPDATE; /// YuI 11/17/06 AUTOUPDATE_AND_THEMES_FOR_XF_WORK
	//----- CPY 6/5/2007 RECALCULATE_SHOULD_FOLLOW_FACTORY_DEFAULT_NONE_IF_NOT_IN_THEME
	//tr.AutoUpdate.nVal = AU_ON_COMMAND; /// YuI 11/21/06 by CP's request chaning default to ON_COMMAND
	//nRecalculate = AU_ON_COMMAND; 	///Joseph 03/16/07 FIX_BUG_ON_XF_CHANGE_TO_FACTORY_DEFAULT_THEME
	tr.AutoUpdate.nVal = -1;
	//------ CPY 6/5/2007 QA70-9803 SHIFT_SELECT_SHOULD_FORCE_DIALOG_TO_OPEN
	tr.SetAttribute(STR_XFUNCTION_NAME_ATTRIB, lpcszClassName);
	tr.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, lpcszClassName);
	//-----
	if(theme_apply_analysis_theme(lpcszClassName, tr, strThemeName, false))
	{
		//----- CPY 6/5/2007 RECALCULATE_SHOULD_FOLLOW_FACTORY_DEFAULT_NONE_IF_NOT_IN_THEME
		if(tr.AutoUpdate.nVal >= AU_NONE)
		//-----
			nRecalculate = tr.AutoUpdate.nVal;
		return true;
	}
	return false;
}
/// end XF_THEME_SUPPORT




/// ML 10/13/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS
static	void				table_style_set_repeat_dir(TreeNode &tr, int nPeriod = -1, int nOffset= - 1, int nCount = -1)
{
	tr.Period.nVal = nPeriod;
	tr.Offset.nVal = nOffset;
	tr.Count.nVal = nCount;
}


static	TreeNode			table_theme_add_border(TreeNode &trBorders, LPCSTR lpcszName, int nShow, int nColor = 0, int nBorderWidth = 2)
{
	TreeNode		trBorder = tree_check_get_node(trBorders, lpcszName);
	///------ Folger 11/03/2011 OC_ASSERT_WHEN_EXECUTE_OPERATION
	/// I saw Roman commented out "Show" attribute for Grid Border Style(/// RVD 3/6/2008 v8.0819 THEME_BORDERS_IMPROVE), so this node will never work
	/// assert failed always happen in BOOL	WksReportOperation::setThemeToResultsCurveSheet(Worksheet &wksFitCurves, DWORD dwResultCurvesReportID)
	//TreeNode		trShow = trBorder.AddNumericNode(nShow, "Show");	// must do like this because "Show" is also a recognized att.
	///------ End OC_ASSERT_WHEN_EXECUTE_OPERATION
	if (0 < nShow)
	{
		trBorder.Color.nVal = nColor;
		//trBorder.Width.nVal = 2;
		trBorder.Width.nVal = nBorderWidth;
		trBorder.Style.nVal = 0;
	}
	
	return trBorder;
}



// bckColor = -1 means don't set it. Otherwise it is OCOLOR.
void	table_theme_setup_style(TreeNode &trStyle, bool *pbBold, int bckColor,
				DWORD dwBorders, int nPeriodRowwise, int nPeriodColwise, int nBorderColor, int nMerging, int nBorderWidth)
{
	if ( pbBold )
		trStyle.Style.Font.Bold.nVal = *pbBold ? 1 : 0;
	
	if ( bckColor != -1 )
		trStyle.Style.Fill.FillColor.nVal = bckColor;
	
	if (dwBorders)
	{
		/// ML 4/26/2006 BORDERS_MOVED_TO_STYLE_BRANCH
		//TreeNode	trBorders = trStyle.AddNode("Borders");
		TreeNode	trStyleStyle = tree_check_get_node(trStyle, "Style"); 
		TreeNode	trBorders = trStyleStyle.AddNode("Borders");
		/// end BORDERS_MOVED_TO_STYLE_BRANCH
		table_theme_add_border(trBorders, "Left", (dwBorders & BORSTY_LEFT) != 0, nBorderColor, nBorderWidth);
		table_theme_add_border(trBorders, "Right", (dwBorders & BORSTY_RIGHT) != 0, nBorderColor, nBorderWidth);
		table_theme_add_border(trBorders, "Top", (dwBorders & BORSTY_TOP) != 0, nBorderColor, nBorderWidth);
		table_theme_add_border(trBorders, "Bottom", (dwBorders & BORSTY_BOTTOM) != 0, nBorderColor, nBorderWidth);
		table_theme_add_border(trBorders, "InsideVertical", (dwBorders & BORSTY_INSIDE_VERT) != 0, nBorderColor, nBorderWidth);
		table_theme_add_border(trBorders, "InsideHorizontal", (dwBorders & BORSTY_INSIDE_HORIZ) != 0, nBorderColor, nBorderWidth);
	}
	
	if (nPeriodRowwise || nPeriodColwise)
	{
		/// ML 4/26/2006 BORDERS_MOVED_TO_STYLE_BRANCH
		/*
		TreeNode	trRepeatInfos = tree_check_get_node(trStyle, "RepeatInfos");
		if (nPeriodColwise)
		{
			TreeNode	trRepeatInfo = tree_check_get_node(trStyle, "Horizontal");
			table_style_set_repeat_dir(trRepeatInfo, nPeriodColwise);
		}
		if (nPeriodRowwise)
		{
			TreeNode	trRepeatInfo = tree_check_get_node(trStyle, "Vertical");
			table_style_set_repeat_dir(trRepeatInfo, nPeriodRowwise);
		}
		*/
		TreeNode	trStyleStyle = tree_check_get_node(trStyle, "Style"); 
		TreeNode	trRepeatInfos = tree_check_get_node(trStyleStyle, "RepeatInfos");
		if (nPeriodColwise)
		{
			TreeNode	trRepeatInfo = tree_check_get_node(trRepeatInfos, "Horizontal");
			table_style_set_repeat_dir(trRepeatInfo, nPeriodColwise);
		}
		if (nPeriodRowwise)
		{
			TreeNode	trRepeatInfo = tree_check_get_node(trRepeatInfos, "Vertical");
			table_style_set_repeat_dir(trRepeatInfo, nPeriodRowwise);
		}
		/// end BORDERS_MOVED_TO_STYLE_BRANCH
	}
	
	if ( 0 <= nMerging )
	{
		trStyle.Style.Merge.nVal = nMerging;
	}
}

static	TreeNode	table_theme_add_named_style(TreeNode &tr, int index, LPCSTR lpcszName, bool *pbBold = NULL, int bckColor = -1,
				DWORD dwBorders = 0, int nPeriodRowwise = 0, int nPeriodColwise = 0, int nBorderColor = 0, int nMerging = -1, int nBorderWidth = 2)
{
	string			strNodeName;
	strNodeName.Format("NameStyle%d", index + 1);
	TreeNode		trNamedStyles = tree_check_get_node(tr, "NameStyles");
	TreeNode		trNamedStyle = tree_check_get_node(trNamedStyles, strNodeName);
	
	trNamedStyle.Name.strVal = lpcszName;
	
	table_theme_setup_style(trNamedStyle, pbBold, bckColor, dwBorders, nPeriodRowwise, nPeriodColwise, nBorderColor, nMerging, nBorderWidth);
	
	return trNamedStyle;
}


BOOL	make_result_curves_sheet_theme(TreeNode &treeTh, DWORD dwResultCurvesReportID)
{
	TreeNode		trRoot = treeTh.AddNode("Root");
	trRoot.ID = 1;
	
	string			strStyleName;
	// Maske the first part of the name (all tables):
	okutil_set_spec_tbl_range_name(&strStyleName, dwResultCurvesReportID, TRUE, -1, FALSE, IDL_LABELS_AND_DATA, IDL_LABELS_AND_DATA);
	
	// Append the relative offsets part, such that down columns (the result curves flat sheet table is actually transposed, so
	// the first dimension is columns):
	okutil_make_linkedstyle_offset_string(true, &strStyleName, LNKSTLREF_LABEL_AND_DATA, 0, -1, LNKSTLREF_DATA_ONLY, 0, -1);
	
	// Finally create and add the style to the theme (only right borders):
	table_theme_add_named_style(trRoot, 0, strStyleName, NULL, -1, BORSTY_RIGHT, 0, 0, 0, -1);
	
	return TRUE;
}
/// end SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS

///Joe 8/10/06 THEME_SCOPEINDEX_TO_SCOPENAME
void theme_scopeindex_to_scopename(int nScopeIndex, string& strScopeName)
{
	switch(nScopeIndex)
	{
	case THTYPESCOPE_ANALYSIS_CLASS:
		strScopeName = "Current Analysis";
		break;
	case THTYPESCOPE_ANALYSIS_CATEGORY:
		strScopeName = "Analysis Category";
		break;
	case THTYPESCOPE_ANALYSES_COMMON:
		strScopeName = "All Analysis";
		break;
	}
}
///End THEME_SCOPEINDEX_TO_SCOPENAME

///Joe 8/11/06 THEME_SCOPENAME_TO_SCOPEINDEX
int theme_scopename_to_scopeindex(LPCSTR strScopeName)
{
	string strName(strScopeName);
	if(!strName.Compare("Current Analysis"))
		return 0;
	if(!strName.Compare("Analysis Category"))
		return 1;
	if(!strName.Compare("All Analysis"))
		return 2;
	return -1;
}
///End THEME_SCOPENAME_TO_SCOPEINDEX		
	
///Joe 8/10/06   THEME_ANALYSIS_FILENAME_TO_OPTIONS
bool theme_filename_to_options(LPCSTR lpFileName, string& strName, string& strTool, string& strScope, string& strCategory )
{
	string strFileName(lpFileName);

	/// EJP 2009-01-26 QA80-13021 SUPPORT_DASH_IN_THEME_NAME
	///strName = strFileName.GetToken( 2, '-' );
	// OIS file name syntax is "<#>-<XFuncName>-<ThemeName>.ois"
	// Theme name is everything after 2nd dash including any dashes.
	strName.Empty(); // empty target
	int nDashIndex = strFileName.Find('-');
	if( nDashIndex >= 0 ) // If found 1st dash
	{
		nDashIndex = strFileName.Find('-', nDashIndex + 1);
		if( nDashIndex >= 0 ) // If found 2nd dash
			strName = strFileName.Mid(nDashIndex + 1);
	}
	/// end SUPPORT_DASH_IN_THEME_NAME

	if(strName.IsEmpty())
		return false;
	//if(strName = strFileName.GetToken( 2, '-' ))
		//return false; //the file name  "scope-tool-name"
	strTool = strFileName.GetToken( 1, '-' );
	///Joseph 01/12/06 FIX_BUG_ON_DIGLOG_THEME_DELETE 
	//if(strTool.IsEmpty())
		//return false;
	///End FIX_BUG_ON_DIGLOG_THEME_DELETE
	strScope = strFileName.GetToken( 0, '-' );
	if(strScope.IsEmpty())
		return false;
	if(strScope.Compare("0") && strScope.Compare("1"))
	{
		strCategory = strScope;
		strScope = "Analysis Category";
	}
	else	
	{
		int nScopeIndex = atoi(strScope);
		theme_scopeindex_to_scopename(nScopeIndex, strScope);
	}	
	if(strTool.Find("DescStats") >= 0)
	{
		if(strTool.Find('_') >= 0)
			strTool.Replace("_1","(Row)");
		else
			strTool += "(Col)";
	}
	return true;
}
///End THEME_ANALYSIS_FILENAME_TO_OPTIONS

/// Iris 10/12/06 MOVE_IS_INCREMENT_THEME_INTO_UTILS_FILE
bool theme_is_increment_theme(LPCSTR lpcszThemeFilename)
{
	Tree trTemp(lpcszThemeFilename);
	/// TD 8-10-03 
	if(!trTemp)
	{
		string strName = GetFileName(lpcszThemeFilename);
		return error_report("Fail to load XML " + strName);
	}
	/// end -------TD 8-10-03 
	int nObjBits = 0;
	int nStyleBits = 0;
	if(trTemp.GetAttribute(THEME_PROPERTY_BITS_NAME, nStyleBits))
	{
		trTemp.GetAttribute(THEME_OBJECT_BITS_NAME, nObjBits);
		uint dwBits  = nStyleBits;
		uint dwOtherStyleBits = ~FPB_STYLE_LIST_MASK & dwBits;
		if((dwBits & FPB_STYLE_LIST_MASK) && dwOtherStyleBits == 0 && nObjBits == FOB_GLOBAL)
			return true;
	}
	return false;
}
///end MOVE_IS_INCREMENT_THEME_INTO_UTILS_FILE

///Jasmine 03/27/07 MOVE_TO_TEXTFORMAT	
/////Jasmine 02/26/07 UTILITY_FUNC_FOR_TEXT_FORMAT
//bool construct_text_format_tree(TreeNode& tr)
//{
	//if(!tr.IsValid())
		//return error_report("tr is invalid");
	//GETN_USE(tr)
		//GETN_CHECK(WrapText, "Wrap Text", FALSE)					GETN_ID(OTID_STYLE_WRAP)
		//GETN_CHECK(Float, "Float", 1)								GETN_ID(OTID_STYLE_FLOAT)
		//GETN_CHECK(Flood, "Flood", 1)								GETN_ID(OTID_STYLE_FLOOD)
		//GETN_STR(Format, "Format", ".5")							GETN_ID(OTID_STYLE_FORMAT)
		//GETN_LIST(Merge, "Merge", GMC_NONE, "None|Horizontal|Vertical|Both") GETN_ID(OTID_STYLE_MERGE)
		//GETN_CHECK(BlankMissing, "Show Missing as Blank", TRUE)		GETN_ID(OTID_STYLE_SHOWMISSINGBLANK)
		//GETN_CHECK(AllowEnter, "Allow Enter", 1)					GETN_ID(OTID_STYLE_ALLOW_ENTER)
	//
	//return true;
//}
//
//bool get_text_format(const OriginObject& obj, TreeNode& tr, LPCSTR lpcszTagName)
//{
	//if(!obj.IsValid() || !tr.IsValid())
		//return error_report("obj or tr is invalid");
	//Tree trFmt;
	//trFmt = obj.GetFormat(FPB_ALL, FOB_ALL & ~(FOB_LINK_STYLE|FOB_RANGE_STYLE), TRUE, TRUE);
	//TreeNode trProp = trFmt;
	//string strTagName = lpcszTagName;
	//if(-1 < strTagName.Find("."))
	//{
		//trProp = tree_get_node_by_tagname(trProp, strTagName.GetToken(0, '.'), true);		
		//strTagName = strTagName.GetToken(1, '.');
	//}
    //trProp = tree_get_node_by_tagname(trProp, strTagName, true);		
	//if(!trProp.IsValid())
    	//return false;
    //if(trProp.Borders)
    	//trProp.Borders.Remove();
    ////make sure trFmt has these nodes, and set default value
    //if(!trProp.WrapText)
    	//trProp.WrapText.nVal = TRUE;
    //if(!trProp.AllowEnter)
    	//trProp.AllowEnter.nVal = TRUE;
    //if(!trProp.Float)
    	//trProp.Float.nVal = TRUE;
    //if(!trProp.Flood)
    	//trProp.Flood.nVal = FALSE;
    //if(!trProp.Merge)
    	//trProp.Merge.nVal = GMC_NONE;
    //if(!trProp.BlankMissing)
    	//trProp.BlankMissing.nVal = FALSE;
    //if(!trProp.Format)
    	//trProp.Format.strVal = ".5";
    //int iRet = obj.UpdateThemeIDs(trFmt.Root, "Error", "Unknown tag");
    //octree_copy_values_by_id(&trProp, &tr, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
	//return true;
//}
/////End UTILITY_FUNC_FOR_TEXT_FORMAT


///---Sim 03-26-2007 TEMPORARY_FUNCTION_FOR_THEME_UTILS
///Joseph 03-26-2007 TEMPORARY_FUNCTION_FOR_THEME_UTILS
/// Hong 01/19/11 ORG-1750 OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
//bool theme_tree_to_getn_tree(const TreeNode& trTheme, TreeNode& trGetN, bool bSupportRunTime) //,, false
bool theme_tree_to_getn_tree(const TreeNode& trTheme, TreeNode& trGetN, bool bSupportRunTime, bool bEnableApplyRowRange) //,, false, false
/// end OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
{
	if(!trTheme || !trGetN)
		return false;
	
	int nn;
	TreeNode trNode;
	//get theme tree
	///---Sim 07-04-2008 FIX_APPLY_WIZ_THEME
	//if(! bSupportRunTime)
	trNode = trTheme.GetNode(STR_XFBAR_MULITIMODE_RUNTIME_INFO_TREE);
	if ( bSupportRunTime && trNode )
	{
		return trGetN.Replace(trNode.Clone(), true, true);
	}
	else
	///---END FIX_APPLY_WIZ_THEME
	{		
		trNode = tree_check_get_node(trTheme, STR_XFBAR_MULITIMODE_THEME_TREE);
		
		//------ Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM
		/////Joseph 04/28/07 ADD_XF_VERSION_FOR_MULITHEME
		//if(!_check_verion_on_loading_theme(trNode, trGetN))
		//{
			////if(MessageBox(GetWindow(), _L("The theme version don't match X-Function version, then the theme will not be applied in wizard mode."), "Reminder", MB_OK))
			////{
				////return true;
			////}
			//return false;
		//}
		/////End 	ADD_XF_VERSION_FOR_MULITHEME
		TreeNode trParent = trTheme.Parent();
		string strThemeFile, strName;
		if ( trParent )
		{
			tree_get_theme_file_name(trParent, strThemeFile);
			string strTool, strScope, strCategory;
			theme_filename_to_options(strThemeFile, strName, strTool, strScope ,strCategory);
		}
		if ( !_check_verion_on_loading_theme(trNode, trGetN, GetFileName(strName, true)) )
			return false;
		//------ End WIZARD_THEME_VERSION_MECHANISM
		
		vector<int> vnIDs;
		vector<string> vsValues;
		string strComment;
		if(!trNode)
			return false;
		
		//STR_XF_VERSION
		octree_get_theme(&trNode, &vnIDs, &vsValues, &strComment);
		
		/// Hong 01/19/11 ORG-1750 OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
		//BOOL		bEnableApplyRowRange = _is_theme_enable_apply_row_range(vnIDs, vsValues); /// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
		/// end OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
		
		///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//theme_set_commment_to_gui_tree(trGetN, strComment);
		///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
		
		int nDupID = 0;
		///------ Folger 03/18/09 QA80-13261-P2 NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
		//nn = tree_set_values_by_ids(trGetN, vnIDs, vsValues, 0, &nDupID);
		///------ Folger 04/15/09 QA80-13454 SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
		//nn = tree_set_values_by_ids(trGetN, vnIDs, vsValues, 0, &nDupID, TRUE);
		/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
		//nn = tree_set_values_by_ids(trGetN, vnIDs, vsValues, 0, &nDupID, _get_SETVALUESBYIDS_cntrl(trGetN, trTheme));
		nn = tree_set_values_by_ids(trGetN, vnIDs, vsValues, 0, &nDupID, _get_SETVALUESBYIDS_cntrl(trGetN, trTheme, bEnableApplyRowRange));
		/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
		///------ End SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
		///------ End NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
		if(nDupID > 0)
		{
			printf("theme_load_settings found duplicate ID = %d\n", nDupID);
			return false;
		}
		
		///------ Folger 01/13/09 v8.0995d PA_CREATE_BASELINE_FAILS_TO_APPLY_RANGE_SETTINGS
		//return nn > 0? true:false; ///---Sim 07-04-2008 FIX_APPLY_WIZ_THEME
		bool	bRet = nn > 0;
		
		if ( bRet )
			/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
			//okutil_getn_update_ranges(&trGetN);
			okutil_getn_update_ranges(&trGetN, bEnableApplyRowRange, &vnIDs, &vsValues);
			/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
			
		return bRet;
		///------ eND PA_CREATE_BASELINE_FAILS_TO_APPLY_RANGE_SETTINGS
	}
	///---Sim 07-04-2008 FIX_APPLY_WIZ_THEME
	/*
	//get runtime info tree
	else
	{
		trNode = tree_check_get_node(trTheme, STR_XFBAR_MULITIMODE_RUNTIME_INFO_TREE);
		if(!trNode)
			return false;
		//------ Folger 11/28/07 ALLOW_COPY_AUTO_ATTRIBUTE
		//nn = tree_copy_values(trNode, trGetN, TREE_COPY_ATTRIB_ENABLE);
		/// YuI 01/14/08 QA70-10936 GET_RUNTIME_DESCRIPTION_TWEAK
		//	nn = tree_copy_values(trNode, trGetN, TREE_COPY_ATTRIB_ENABLE | TREE_COPY_ATTRIB_AUTO);
		//------ Folger 01/17/08 JUST_CLONE_RUNTIME_TREE_WHEN_RESTORE
		//nn = tree_copy_values(trNode, trGetN, TREE_COPY_ATTRIB_ENABLE | TREE_COPY_ATTRIB_AUTO | TREE_RESOVE_COMPOSITE_RANGE_STRUCTURE_CONFLICT);
		
		//------ Folger 05/20/08 CORRECT_THE_RETURN_VALUE_OF_IF_ELSE_CONTROL_FLOW
		
		////The code below will not modify nn, that means false will always be returned, totally break the original logic.
		////Should take care of the return value when clean up code !!!
		
		//trGetN.Replace(trNode.Clone(), true, true);
		return trGetN.Replace(trNode.Clone(), true, true);
		
		//------ End CORRECT_THE_RETURN_VALUE_OF_IF_ELSE_CONTROL_FLOW
		
		//------
		/// end GET_RUNTIME_DESCRIPTION_TWEAK
		//------
	}
	
	return nn > 0? true:false;
	*/
	return false;
	///---END FIX_APPLY_WIZ_THEME
}
bool theme_tree_from_getn_tree(TreeNode& trTheme, const TreeNode& trGetN, bool bSupportRunTime)//, , false
{
	if(!trTheme || !trGetN)
		return false;
	
	TreeNode trThemeTree, trRunTimeInfo;
	//construct theme tree
	trThemeTree = tree_check_get_node(trTheme, STR_XFBAR_MULITIMODE_THEME_TREE);
	if(!trThemeTree)
		return false;
	
	vector<int> vnIDs;
	vector<string> vsValues;
	string strComment, strXFNameAttrib;
	
	tree_get_values_with_ids(trGetN, vnIDs, vsValues);
	if(trGetN.GetAttribute(STR_THEME_COMMENT_ATTRIB, strComment))
		trThemeTree.SetAttribute(STR_THEME_COMMENT_ATTRIB, strComment);
	
	trTheme.GetAttribute(STR_XF_NAME_ATTRIB, strXFNameAttrib); //when trTheme = new node, then the attribute will be removed.
	
	Tree trTemp;
	octree_set_theme(&trTemp, &vnIDs, &vsValues, strComment);
	trThemeTree.Replace(trTemp, true, true);
	if(strXFNameAttrib.GetLength() > 0)
		trThemeTree.SetAttribute(STR_XF_NAME_ATTRIB, strXFNameAttrib);
	
	_theme_tree_set_version(trThemeTree, trGetN);	///Joseph 04/28/07 ADD_XF_VERSION_FOR_MULITHEME
	
	//construct runtimeinfo tree
	if(bSupportRunTime)
	{
		trRunTimeInfo = trTheme.GetNode(STR_XFBAR_MULITIMODE_RUNTIME_INFO_TREE);
		if( !trRunTimeInfo )
		{
			trRunTimeInfo = trTheme.AddNode(STR_XFBAR_MULITIMODE_RUNTIME_INFO_TREE);
			if(! trRunTimeInfo)
				return false;
		}
		
		trRunTimeInfo.Replace(trGetN.Clone(), true, true);
	}

	return true;
}
///End TEMPORARY_FUNCTION_FOR_THEME_UTILS

///---Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO
bool get_theme_tree_execution_value(const TreeNode& trTheme, TreeNode& trGetNExecution)
{
	if(!trTheme || !trGetNExecution)
		return false;
	
	TreeNode trExecVals;
	trExecVals = trTheme.GetNode(STR_XFBAR_MULITIMODE_EXEC_VALUE_TREE);
	if ( !trExecVals )
		return false;
	
	return trGetNExecution.Replace(trExecVals, true, true);
}

bool set_theme_tree_execution_value(TreeNode& trTheme, const TreeNode& trGetNExecution)
{
	if(!trTheme || !trGetNExecution)
		return false;
	
	TreeNode trExecVals;
	trExecVals = trTheme.GetNode(STR_XFBAR_MULITIMODE_EXEC_VALUE_TREE);
	if ( !trExecVals )
	{
		trExecVals = trTheme.AddNode(STR_XFBAR_MULITIMODE_EXEC_VALUE_TREE);
		if ( !trExecVals )
			return false;
	}
	
	return trExecVals.Replace(trGetNExecution, true, true);
}
///---END GET_CREATED_OUTPUT_PAGE_INFO

bool themes_tree_to_file(Tree& trTheme, LPCSTR lpcszFileName)// = "" )
{
	if(!trTheme)
		return false;
	
	string strFileName(lpcszFileName);
	if ( strFileName.IsEmpty() )
	{
		//trTheme.GetAttribute(STR_XF_NAME_ATTRIB, strFileName);
		tree_get_theme_file_name(trTheme, strFileName);
		if ( strFileName.IsEmpty() )
			return false;
	}
	else
		//trTheme.SetAttribute(STR_XF_NAME_ATTRIB, strFileName);
		tree_set_theme_file_name(trTheme, strFileName);
		
	///Joseph 03-26-2007 TEMPORARY_FUNCTION_FOR_THEME_UTILS	
	string strPath;	
	strPath = okutil_theme_get_path(ORIGIN_PATH_USER, tree_get_theme_type(trTheme.FirstNode));		
	if(!CheckMakePath(strPath))
		return false;
	///End TEMPORARY_FUNCTION_FOR_THEME_UTILS
	
	Tree trTempTheme;
	
	//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
	/*
	trTempTheme = trTheme;//.Clone(true);
	
	foreach(TreeNode trNode in trTempTheme.Children)
	{
		trNode.RemoveChild(STR_XFBAR_MULITIMODE_RUNTIME_INFO_TREE);
		trNode.RemoveChild(STR_XFBAR_MULITIMODE_EXEC_VALUE_TREE); ///---Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO
	}
	
	//------ Folger 11/19/07 QA70-10694 CONVERT_KEYWORD_WHEN_THEME_SAVE_AND_LOAD
	#ifdef KEYWORD_CONVERT_CONTROL
	_keyword_convert_control(trTempTheme, true);
	#endif
	//------
	
	*/
	_save_themes_tree(trTempTheme, trTheme);
	//------
	
	//------ Folger 04/18/08 CORRECTLY_ADD_PA_THEME_IN_FLY_OUT_MENU
	//return trTempTheme.Save(strFileName);
	bool bRet = trTempTheme.Save(strFileName);
	if ( bRet )
	{
		_update_theme_item_after_save(trTheme);
	}
	return bRet;
	//------
}

//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
static	bool	_save_themes_tree(TreeNode &trDes, const TreeNode &trThemes)
{
	if ( !trDes || !trThemes )
		return false;
	
	trDes = trThemes.Clone(true);
	foreach(TreeNode trNode in trDes.Children)
	{
		trNode.RemoveChild(STR_XFBAR_MULITIMODE_RUNTIME_INFO_TREE);
		trNode.RemoveChild(STR_XFBAR_MULITIMODE_EXEC_VALUE_TREE); ///---Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO
	}
	
	///---Sim 11-17-2008 FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
	//trDes.RemoveChild(STR_XF_WIZ_THEME_SHARED); ///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	///---END FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
	
	#ifdef KEYWORD_CONVERT_CONTROL
	_keyword_convert_control(trDes, true);
	#endif
	
	return true;
}
//------

bool themes_tree_from_file(Tree& trTheme, LPCSTR lpcszFileName)// = "" )
{	
	if(!trTheme)
		return false;
	
	string	strFileName(lpcszFileName);
	Tree	trTemp;
	bool	bRet;
	if ( strFileName.IsEmpty() )
	{
		//trTheme.GetAttribute(STR_XF_NAME_ATTRIB, strFileName);
		tree_get_theme_file_name(trTheme, strFileName);
		if ( strFileName.IsEmpty() )
			return false;
	}		
	else
		//trTheme.SetAttribute(STR_XF_NAME_ATTRIB, strFileName);
		tree_set_theme_file_name(trTheme, strFileName);
		
	bRet = trTemp.Load(strFileName);
	//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
	/*
	if(trTemp)
	{
		trTheme.Replace(trTemp);		
		//------ Folger 11/19/07 QA70-10694 CONVERT_KEYWORD_WHEN_THEME_SAVE_AND_LOAD
		#ifdef KEYWORD_CONVERT_CONTROL
		_keyword_convert_control(trTheme, false);
		#endif
		//------
	}
	*/
	bRet &= _load_themes_tree(trTheme, trTemp);
	//------
	return bRet;
}

//------ Folger 03/11/08 QA80-11192 CLEAN_UP_THEME_LOAD_SAVE_MECHANISM
static	bool	_load_themes_tree(TreeNode &trThemes, const TreeNode &trSrc)
{
	if ( !trThemes || !trSrc )
		return false;
	
	//------ Folger 04/15/08 QA80-11192 FIX_FAIL_TO_LOAD_DEFAULT_THEME_IN_PA
	//trThemes.Replace(trSrc);
	trThemes.Replace(trSrc.Clone());
	//------
	
	#ifdef KEYWORD_CONVERT_CONTROL
	_keyword_convert_control(trThemes, false);
	#endif
	
	return true;
}
//------

///---END TEMPORARY_FUNCTION_FOR_THEME_UTILS
///Folger 05/23/07 XF_IS_THEME_APPLIED
///---Sim 06-30-2007 XF_IS_THEME_APPLIED
//bool xf_is_theme_applied(const TreeNode &trGetN)
int xf_is_theme_applied(const TreeNode &trGetN)
///---END XF_IS_THEME_APPLIED
{
	string strTheme;
	if (trGetN.GetAttribute(STR_THEME_FILE_ATTRIB, strTheme))
	///---Sim 06-30-2007 XF_IS_THEME_APPLIED
		//return true;
	//return false;
	{
		if ( is_theme_default(strTheme) )
			///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
			//return THEME_FACTORY_DEFAULT;
			return THEME_DEFAULT;
			///---END CLEAN_DEFAULT_THEME
		
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//if ( STR_SHEET == strTheme )
		if ( PDS_SHEET == cvt_str_to_predefined_type(strTheme) )
		///---END CLEAN_LOCALIZATION_CODE
			return THEME_SHEET;
		
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//if ( STR_BOOK == strTheme )
		if ( PDS_BOOK == cvt_str_to_predefined_type(strTheme) )
		///---END CLEAN_LOCALIZATION_CODE
			return THEME_BOOK;
			
		//------ Folger 03/12/08 APPLY_NEW_DEFAULT_THEME_MECHANISM_FOR_GRAPH_EXPORT
		//------ Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
		//if ( strTheme.IsEmpty() )
		if ( theme_is_factory_default(strTheme) )
		//------
			return THEME_NONE;
		//------
			
		return THEME_APPLIED;
	}
	return THEME_NONE;
	///---END XF_IS_THEME_APPLIED
}
///End XF_IS_THEME_APPLIED



///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///Folger 06/19/07 ADD_INIT_THEME_LIST
bool init_theme_list(TreeNode &trTheme, int nThemeType, bool bTrim)
{
	if(trTheme)
	{
		string 			strCombo;
		vector<string> 	vsThemeFiles;
		vector<string> 	vsThemeNames;
		okutil_get_theme_file_list(&vsThemeFiles, NULL, ORIGIN_PATH_UNDEF, nThemeType);
		if (bTrim)
		{
			for(int ii=0; ii<vsThemeFiles.GetSize(); ii++)
			{
				if(!theme_is_increment_theme(vsThemeFiles[ii]))
					vsThemeNames.Add( GetFileName(vsThemeFiles[ii], true) );
			}
		}
		else
		{
			for(int ii=0; ii<vsThemeFiles.GetSize(); ii++)
			{
				vsThemeNames.Add( GetFileName(vsThemeFiles[ii], true) );
			}
		}
//		vsThemeNames.InsertAt(0, "<Original>");
		strCombo.SetTokens(vsThemeNames, '|');
		strCombo += '|';					///Folger 06/21/07 MODIFY_INIT_THEME_LIST
		trTheme.SetAttribute(STR_COMBO_ATTRIB, strCombo);
		//------ Folger 11/23/07 SHOULD_NOT_SPECIFY_THEME_SELECTION_HERE
		/////Folger 06/21/07 MODIFY_INIT_THEME_LIST
		////if (vsThemeNames.GetSize())
			////trTheme.strVal = vsThemeNames[0];
		/////End MODIFY_INIT_THEME_LIST
		//------
	}
	return true;
}
///End ADD_INIT_THEME_LIST

//------ Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE
// '<' and '>' are centralized here, not a common knowledge
///---Sim 11-07-2007 IMPROVE_CHECK_LAST_USED_THEME
//bool is_theme_last_used(LPCSTR lpcszName)
bool is_theme_last_used(LPCSTR lpcszName, bool bSupportFileName) // = false
///---END IMPROVE_CHECK_LAST_USED_THEME
{
	if(NULL == lpcszName || *lpcszName == '\0')
		return false;
	
	///---Sim 11-07-2007 IMPROVE_CHECK_LAST_USED_THEME
	/*
	string strName = lpcszName;
	if (strName[0] != '<')
		strName.Insert(0, '<');
	if (strName[strName.GetLength()-1] != '>')
		strName += '>';
	
	return cvt_str_to_predefined_type(strName) == PDS_LAST_USED;
	*/
	///---Sim 11-07-2007 IMPROVE_CHECK_LAST_USED_THEME
	string strName = lpcszName;
	if ( bSupportFileName )
	{
		if ( strName.IsFile() )	
			strName = okutil_theme_file_to_display_name(lpcszName);
	}
	///Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	//return ( PDS_LAST_USED == cvt_str_to_predefined_type(strName) || !strName.CompareNoCase(THEME_FILENAME_LAST_USED) );	
	return ( PDS_LAST_USED == str_to_predefined_type(strName) || !strName.CompareNoCase(THEME_FILENAME_LAST_USED) );
	///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	///---END IMPROVE_CHECK_LAST_USED_THEME
}
//------ End CORRECT_THEME_TYPE_COMPARE

//------ Folger 11/08/07 FIX_BUGS_WHEN_FIND_THEME_NAME_WITH_LOCALIZATION
int theme_find_predefined_type_index(const vector<string> &vsList, LPCSTR lpcszTypeName)
{
	///Sohy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	//int nType = cvt_str_to_predefined_type(lpcszTypeName);
	int nType = str_to_predefined_type(lpcszTypeName);
	///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	for (int ii=0; ii<vsList.GetSize(); ++ii)
	{
		if (nType == cvt_str_to_predefined_type(vsList[ii]))
			return ii;
	}
	return -1;
}
//------ End FIX_BUGS_WHEN_FIND_THEME_NAME_WITH_LOCALIZATION

//------ Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM
int theme_get_save_type(int nThemeType)			//exclude last used theme, which considered invalid
{
	if (nThemeType == PDS_BOOK || nThemeType == PDS_SHEET || nThemeType == PDS_TEMPLATE)
		return THEME_TYPE_SVAE_TO_BOOK;
	if (nThemeType == PDS_USER)
		return THEME_TYPE_SVAE_TO_FILE;
	return THEME_TYPE_SVAE_INVALID;
}
//------ End IMPROVE_SAVE_THEME_MECHANISM

//------ Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM
BOOL theme_check_version_show_warning(LPCSTR lpcsz, LPCSTR lpcszRef, LPCSTR lpcszThemeName, LPCSTR lpcszName)
{
	if ( is_integer_part_less_then(lpcsz, lpcszRef) )
	{
		string strErr;
		strErr.Format(_L("%s has been updated.\nOld version theme \"%s\" becomes out-of-date and will not apply."), lpcszName, lpcszThemeName);
		MessageBox(GetWindow(), strErr, _L("Reminder"), MB_OK);
		return FALSE;
	}
	return TRUE;
}
//------ End WIZARD_THEME_VERSION_MECHANISM

//------ Folger 02/29/08 QA80-11192 SHOW_WARNING_WHEN_THEME_NOT_EXIST
void theme_show_warning_not_exist(LPCSTR lpcszTheme)
{
	string strErr;
	ocu_load_msg_str(XFERR_THEME_NOT_EXIST, &strErr, lpcszTheme);
	MessageBox(GetWindow(), strErr, _L("Reminder"), MB_OK);
}
//------

///Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE moved to theme_utils.h as to use it in DynaDlg.h
/// Iris 03/04/2008 v8.0816 ACCESS_DEFAULTS_XML
//#define STR_DEFAULT_SETTINGS_FILENAME GetAppPath() + "Defaults.XML"
///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE

//------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
bool	theme_default_setting_management(TreeNode &tr, int nOp, TreeNode &trTheme, bool bGroupTheme)		// = THEME_DEFAULT_GET, = NULL, = false
{
	string strClassOption;
	theme_get_class_option(tr, strClassOption);
	string strThemeFile = theme_get_settings_file(THEME_DEFAULT_SETTING, strClassOption, tree_get_theme_type(tr));
	if ( strThemeFile.IsFile() )	//not to overwrite a "Default" theme file
		strThemeFile += '_';
	
	bool bRet = false;
	///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
	BOOL	bForceLoadFactory = theme_force_load_factory_attribute_access(tr, THEMEFORCELOADFACTORY_GET);
	///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
	
	switch ( nOp )
	{
	case THEME_DEFAULT_GET:
		{
			Tree trXML;
			///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
			//if ( theme_get_default_settings(strClassOption, trXML) )
			if ( !bForceLoadFactory && theme_get_default_settings(strClassOption, trXML) )
			///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
			{
				if ( bGroupTheme )
				{
					//------ Folger 04/15/08 QA80-11192 LOAD_XF_WIZARD_DEFAULT_THEME_NEED_VERSION_CHECKING
					string strWizardVersion, strThemeVersion;
					tr.GetAttribute(STR_WIZARD_VERSION, strWizardVersion);
					trXML.GetAttribute(STR_WIZARD_VERSION, strThemeVersion);
					///---Sim 12-12-2008 IMPROVE_XF_WIZARD_FAILED_LOAD_THEME_ERROR_MESSAGE
					//if ( !theme_check_version_show_warning(strThemeVersion, strWizardVersion, STR_DEFAULT, _L("Wizard version")) )
					if ( !theme_check_version_show_warning(strThemeVersion, strWizardVersion, STR_DEFAULT, theme_get_full_xf_wizard_name(strClassOption)) )
					///---END IMPROVE_XF_WIZARD_FAILED_LOAD_THEME_ERROR_MESSAGE
						return false;
					//------
					
					bRet = _load_themes_tree(tr, trXML);
				}
				else
				{
					//------ Folger 04/15/08 QA80-11192 LOAD_XF_WIZARD_DEFAULT_THEME_NEED_VERSION_CHECKING
					if ( !_check_verion_on_loading_theme(trXML, tr, STR_DEFAULT) )
						return false;
					//------
					bRet = _theme_load_settings(tr, trXML, STR_DEFAULT, trTheme);
				}
				tree_set_theme_file_name(tr, STR_DEFAULT);
			}
			else
			{
				//------ Folger 03/21/08 QA80-11267 FIX_FACTORY_DEFAULT_RECALCULATE_MODE
				if ( !bGroupTheme )
					bRet = theme_load_settings(tr, NULL, true, trTheme);
				//------
				tree_set_theme_file_name(tr, STR_THEME_NONE);
			}
		}
		break;
		
	case THEME_DEFAULT_SET:
		Tree trXML;
		if ( bGroupTheme )
		{
			bRet = _save_themes_tree(trXML, tr);
		}
		else
		{
			bRet = _theme_save_settings(tr, NULL, NULL, trXML);
		}
		if ( bRet )
		{
			bRet = theme_set_default_settings(strClassOption, trXML);
			///Sophy 10/24/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
			if( !bRet )
			{
				return false;
			}
			///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
			tree_set_theme_file_name(tr, STR_DEFAULT);
			_update_theme_item_after_save(tr);			
		}
		break;
		
	case THEME_DEFAULT_RESET:
		///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
		if ( !bForceLoadFactory )
		///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
		{
			theme_reset_default_settings(strClassOption);
			_update_theme_item_after_save(tr);
		}
		//------ Folger 04/17/08 NEED_TO_UPDATE_MENU_AFTER_RESET_THEME
		//refresh_origin_main_menu();
		//------
		
		//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
		//tree_set_theme_file_name(tr, STR_THEME_DEFAULT_SHORT_FORM);
		tree_set_theme_file_name(tr, STR_THEME_NONE);
		//------
		///---Sim 01-09-2009 FIX_LOAD_FACTORY_DEFAULT_TWICE_NO_NEED
		// just need to reset theme name, and later dyna dialog will reload default theme
		/*
		if ( bGroupTheme )
		{
			///---Sim 01-09-2009 FIX_XF_WIZ_RESET_THEME_AND_THEN_SEL_THEME_RUNTIME_ERROR
			// need to improve dyna dialog, here tr should be trTheme tree, isn't trGetN
			// even if it is trTheme here, that isn't right time to reset(clear) all setting here. XF Wizard class keep all knowledge inside.
			//tr.Reset();
			///---END FIX_XF_WIZ_RESET_THEME_AND_THEN_SEL_THEME_RUNTIME_ERROR
			return true;
		}
		else
			return theme_load_factory_default(strClassOption, tr);
		*/
		return true;
		///---END FIX_LOAD_FACTORY_DEFAULT_TWICE_NO_NEED
		
	default:
		break;
	}
	
	return bRet;
}
//------



static string _get_origin_version()
{
	double dd;
	LT_get_var("@V", &dd);
	string strVersion = dd;
	strVersion = strVersion.Left(3);
	if('0' == strVersion.GetAt(2))
		strVersion = strVersion.GetAt(0);
	return strVersion;
}
//------ Folger 03/14/08 QA80-11192 MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC
/*
static TreeNode _get_class_node(LPCSTR lpcszClassOption, TreeNode& tr, bool bCreateIfNot = false)
{
	string strClass(lpcszClassOption);
	strClass.MakeValidCName();
	
	TreeNode trClass;
	if(bCreateIfNot)
	{
		TreeNode trOriginlab =  tree_check_get_node(tr, "Originlab");
		
		TreeNode trOrigin = tree_check_get_node(trOriginlab, "Origin"+_get_origin_version() );
		
		TreeNode trInter = tree_check_get_node(trOrigin, "International");
		
		TreeNode trClasses = tree_check_get_node(trInter, "Classes");
	
		trClass = tree_check_get_node(trClasses, strClass);
	}
	else
	{
		if(!tr.Originlab)
			return trClass;
		
		TreeNode trOrigin = tr.Originlab.GetNode("Origin"+_get_origin_version());
		if(!trOrigin)
			return trClass;
		
		TreeNode trClasses = trOrigin.International.Classes;
		if(!trClasses)
			return trClass;
		
		trClass = trClasses.GetNode(strClass);				
	}
	return trClass;
}
*/
//------ End MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC
bool theme_set_default_settings(LPCSTR lpcszClassOption, const TreeNode& trSettings)
{
	//------ Folger 03/14/08 QA80-11192 MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC
	/*
	Tree tr;
	TreeNode trClass;
	
	string strFilename = STR_DEFAULT_SETTINGS_FILENAME;
	if(strFilename.IsFile())
	{
		if( !tr.Load(strFilename) )
		{
			error_report("Fail to load " + strFilename);
			return false;
		}		
	}
	
	trClass = _get_class_node(lpcszClassOption, tr, true);	
	
	//------ Folger 03/05/08 QA80-11192 CENTRALIZE_THEME_TREE_SETTING_KNOWLEDGE
	//TreeNode trDefaults = trClass.AddNode("Defaults");
	TreeNode trDefaults = tree_check_get_node(trClass, THEME_TREE_SETTINGS);
	//------
	trDefaults.Replace(trSettings.Clone(), true, true);
	
	return tr.Save(strFilename);
	*/
	return okutil_access_default_theme(lpcszClassOption, &trSettings, THEME_DEFAULT_SET);
	//------ End MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC
}


bool theme_get_default_settings(LPCSTR lpcszClassOption, TreeNode& trSettings)
{
	//------ Folger 03/14/08 QA80-11192 MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC
	/*
	string strFilename = STR_DEFAULT_SETTINGS_FILENAME;
	if(!strFilename.IsFile())
		return false;

	Tree tr;
	if( !tr.Load(strFilename) )
		return false;
	
	TreeNode trClass = _get_class_node(lpcszClassOption, tr, false);
	if( !trClass )
		return false;
	
	//------ Folger 03/05/08 QA80-11192 CENTRALIZE_THEME_TREE_SETTING_KNOWLEDGE
	//trSettings.Replace(trClass.Clone());	
	TreeNode trDefaults = tree_get_node_by_tagname(trClass, THEME_TREE_SETTINGS, true);
	if ( !trDefaults )
		return false;
	if(trSettings)
		trSettings.Replace(trDefaults.Clone());
	//------
	
	return true;
	*/
	TreeNode *ptrSettings = NULL;
	if ( trSettings )
		ptrSettings = &trSettings;
	return okutil_access_default_theme(lpcszClassOption, ptrSettings, THEME_DEFAULT_GET);
	//------ End MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC
}

bool theme_reset_default_settings(LPCSTR lpcszClassOption)
{
	//------ Folger 03/14/08 QA80-11192 MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC
	/*
	string strFilename = STR_DEFAULT_SETTINGS_FILENAME;
	if(!strFilename.IsFile())
		return false;

	Tree tr;
	if( !tr.Load(strFilename) )
		return false;
	
	TreeNode trClass = _get_class_node(lpcszClassOption, tr, false);
	if( !trClass )
		return false;
	
	//------ Iris 03/05/08 QA80-11192 CENTRALIZE_THEME_TREE_SETTING_KNOWLEDGE
	//trClass.Remove();
	TreeNode trSettings = tree_get_node_by_tagname(trClass, THEME_TREE_SETTINGS, true);
	if ( !trSettings )
		return false;
	trSettings.Remove();
	//------
	
	return tr.Save(strFilename);	
	*/
	return okutil_access_default_theme(lpcszClassOption, NULL, THEME_DEFAULT_RESET);
	//------ End MOVE_DEFAULT_THEME_ACCESS_UTILITY_FUNCTION_TO_VC
}
///end ACCESS_DEFAULTS_XML

//------ Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
/*
//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
bool theme_is_factory_default_for_new_mechanism(const string &strTheme)
{
	return compare_string_localization(strTheme, STR_THEME_DEFAULT_SHORT_FORM) || strTheme.IsEmpty();
}
//------
*/
///---Sim 09-05-2008 QA80-12151 NLFIT_TOO_SLOW_TO_OPEN
//bool theme_is_factory_default(const string &strTheme)
//{
	//return compare_string_localization(strTheme, STR_THEME_NONE);
//}
bool theme_is_factory_default(LPCSTR lpcszTheme)
{
	return ( NULL == lpcszTheme || compare_string_localization(lpcszTheme, STR_THEME_NONE) || PDS_FACTORY_DEFAULT == okutil_cvt_str_to_predefined_type(lpcszTheme) );
}
///---END QA80-12151 NLFIT_TOO_SLOW_TO_OPEN
//------ End CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME

///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
static void _go_through_parent_to_allow_apply(TreeNode& tr, const TreeNode& trRoot)
{
	TreeNode trParent = tr;
	while( trParent.tagName != trRoot.tagName )
	{
		trParent = trParent.Parent();
		if ( !trParent )
			return;
		trParent.SetAttribute(STR_XVARIABLE_THEME_APPLICABILITY_ATTRIB, 0); // allow apply
	}
}

static void _set_apply_attribute(TreeNode& trRoot, int nDestNodeID, bool bApply, bool bDoApplyKeeyAttr = false)
{
	TreeNode trDest;
	if ( nDestNodeID < 0 )
		return;
	else if ( 0 == nDestNodeID )
		trDest = trRoot;
	else
		trDest = tree_get_node_by_id(trRoot, nDestNodeID, true);
	if ( !trDest )
		return;
	
	int n = (bApply) ? 0 : XVTA_DO_NOT_APPLY_VALUE|XVTA_DO_NOT_APPLY_ATTRIBUTES;
	string str = n;

	if ( !(bDoApplyKeeyAttr && bApply) )
		tree_set_attribute_to_all_nodes(trDest, STR_XVARIABLE_THEME_APPLICABILITY_ATTRIB, str);
	
	if ( bApply )
		_go_through_parent_to_allow_apply(trDest, trRoot);
}

static void _set_apply_attribute(TreeNode& trRoot, int nDestNodeID, const TreeNode& trThemeFilter, int nSettingNodeID, bool bDoApplyKeeyAttr = false)
{
	if ( !trThemeFilter || !trRoot )
		return;

	///------ Folger 12/18/09 QA81-14859 THEME_SETTINGS_SUPPORT_APPLY_FIXED_STATUS_ONLY
	//TreeNode trSetting = tree_get_node_by_id(trThemeFilter, nSettingNodeID, true);
	//if ( !trSetting )
		//return;
	//
	//bool bApply = trSetting.nVal;
	TreeNode trSetting1 = tree_get_node_by_id(trThemeFilter, LOWORD(nSettingNodeID), true);
	TreeNode trSetting2 = tree_get_node_by_id(trThemeFilter, HIWORD(nSettingNodeID), true);
	ASSERT(trSetting1 || trSetting2);
	bool	bApply = trSetting1 && trSetting1.nVal || trSetting2 && trSetting2.nVal;
	///------ End THEME_SETTINGS_SUPPORT_APPLY_FIXED_STATUS_ONLY
	
	_set_apply_attribute(trRoot, nDestNodeID, bApply, bDoApplyKeeyAttr);
}

bool theme_setup_theme_filter_setting(TreeNode& trGUI, const TreeNode& trThemeFilter, const vector<int>& vnGUIID, const vector<int>& vnThemeFilterID)
{
	// other options must be dealt first
	_set_apply_attribute(trGUI, 0, 						trThemeFilter, IDE_THEME_FILTER_OTHER, true);
	
	// separater options will overwirte trGUI again
	/*
	_set_apply_attribute(trGUI, IDE_NLSF_FUNCTION,			trThemeFilter, IDE_NL_THEME_FILTER_FUNC);
	_set_apply_attribute(trGUI, IDE_NLSF_CATEGORY,			trThemeFilter, IDE_NL_THEME_FILTER_FUNC);
	_set_apply_attribute(trGUI, IDE_NL_PARAMS_VALUE_BASE,	trThemeFilter, IDE_NL_THEME_FILTER_PARAMS);
	_set_apply_attribute(trGUI, IDE_NL_PARAMS_FIXED_BASE,	trThemeFilter, IDE_NL_THEME_FILTER_FIXED);
	_set_apply_attribute(trGUI, IDE_NL_PARAMS_SHARE_BASE,	trThemeFilter, IDE_NL_THEME_FILTER_SHARE);
	_set_apply_attribute(trGUI, IDE_NL_PARAMS_LOWER_BOUNDS_BASE,	trThemeFilter, IDE_NL_THEME_FILTER_ULB);
	_set_apply_attribute(trGUI, IDE_NL_PARAMS_UPPER_BOUNDS_BASE,	trThemeFilter, IDE_NL_THEME_FILTER_ULB);
	_set_apply_attribute(trGUI, IDE_NLSF_CODES_CONSTRAINTS,	trThemeFilter, IDE_NL_THEME_FILTER_CONSTRAINTS);
	_set_apply_attribute(trGUI, IDE_NLSF_CODES_AFTERFIT,	trThemeFilter, IDE_NL_THEME_FILTER_SCRIPT);
	_set_apply_attribute(trGUI, IDE_NL_PARAMS_AUTO_INIT,	trThemeFilter, IDE_NL_THEME_FILTER_AUTO_PARAM_INIT);
	_set_apply_attribute(trGUI, IDE_NL_LINEAR_CONSTRAINTS,	trThemeFilter, IDE_NL_THEME_FILTER_ENABLE_LINEAR_CONSTRAINTS);
	*/
	ASSERT(vnGUIID.GetSize() == vnThemeFilterID.GetSize());
	for ( int ii = 0; ii < vnThemeFilterID.GetSize(); ii++ )
	{
		_set_apply_attribute(trGUI, vnGUIID[ii], trThemeFilter, vnThemeFilterID[ii]);
	}
	
	_set_apply_attribute(trGUI, IDE_DS_THEME_FILTER, true); // theme setting should always been kept
	return true;
}
///---END QA80-11371 THEME_SAVING_OPTIONS

///------ Folger 09/23/09 Q8A0-14339-P6 NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
int		theme_get_list_filter_last_used(const TreeNode& tr, vector<string>& vsList, bool bRetZeroIfNotInThemeList/* = true*/)
{
	int                 nSel = theme_get_list(tr, vsList);

	vector<int>			vnBuiltinTypesSkip = { PDS_LAST_USED
		, PDS_FOLDER_LAST_USED
	};

	for ( int kk=vsList.GetSize()-1; kk>=0; --kk )
	{
		vector<uint>	vn;
		if ( vnBuiltinTypesSkip.Find(vn, okutil_cvt_str_to_predefined_type(vsList[kk])) > 0 )
		{
			if ( kk <= nSel )
				--nSel;
			vsList.RemoveAt(kk);
		}
	}

	return nSel;
}
///------ End NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG

///------ Folger 09/07/2011 ORG-3718-P1 DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
void	theme_show_delete_msg(LPCSTR lpcszClassOption)
{
	OptionalMessage("ThemeFolderOfDelEx", MB_OK);
	UpdateThemesMenuItems(lpcszClassOption);
}
///------ End DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME

//------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
/// Iris 7/18/2011 TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
//void		theme_delete_settings(const TreeNode &tr, HWND hWnd)
///------ Folger 09/07/2011 ORG-3718-P1 DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
//bool		theme_delete_settings(const TreeNode &tr, HWND hWnd)
bool		theme_delete_settings(const TreeNode &tr, HWND hWnd, THEMEDELETESETTINGS_CUSTOMIZED* pCustomized/* = NULL*/)
///------ End DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
///End TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
{
    vector<string>      vsThemes;
	///------ Folger 09/23/09 Q8A0-14339-P6 NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
    //int                 nSel = theme_get_list(tr, vsThemes);
	///------ Folger 09/07/2011 ORG-3718-P1 DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
	int					nSel = pCustomized ? pCustomized->nSel : theme_get_list_filter_last_used(tr, vsThemes);
	if ( pCustomized )
		vsThemes = pCustomized->vsThemes;
	///------ End DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
	///------ End NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG

    string              strClassOption;
    theme_get_class_option(tr, strClassOption);

    if ( vsThemes.GetSize() == 0 )
    {
        ASSERT(false);
        /// Iris 7/18/2011 TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
        //return;
        return false;
        ///End TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
    }

    if ( theme_is_factory_default(vsThemes[0]) )
    {
        vsThemes.RemoveAt(0);
		--nSel;
    }

    string      strThemeTagName = "Theme";
    GETN_TREE(trGUI)
    GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
    for ( int ii=0; ii<vsThemes.GetSize(); ++ii )
    {
        TreeNode trCheck = trGUI.AddNumericNode(0, strThemeTagName + ii, TRGP_CHECK);
        ///Sophy 3/8/2012 ORG-5161-P1 AMP_TRANSLATED_IN_DELETE_THEME_GETNBOX
        //trCheck.SetAttribute(STR_LABEL_ATTRIB, vsThemes[ii]);
        string strThemeName = vsThemes[ii];
        okutil_ampersand_string_for_display(&strThemeName, TRUE);
        trCheck.SetAttribute(STR_LABEL_ATTRIB, strThemeName);
        ///end AMP_TRANSLATED_IN_DELETE_THEME_GETNBOX
        
        //if ( ii == nSel )
        	//trCheck.Enable = 0;
    }
    if( GetNBox(trGUI, _L("Delete Theme"), _L("Check the checkboxes to delete the themes"), NULL, NULL, hWnd) )
    {
		bool	bDoDelete = false;

		//------ Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER
		/// Iris 7/18/2011 ORG-3273 SAVE_THEME_WITH_CORRECT_NAME_AND_FOLDER
		//string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, THTYPE_ANALYSIS);
		int nThemeType = tree_get_theme_type(tr);
		string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, nThemeType);
		///End SAVE_THEME_WITH_CORRECT_NAME_AND_FOLDER
		strPath += THEME_FILE_DELETED_FOLDER;
		CheckMakePath(strPath);
		//------
		
        for ( ii=0; ii<vsThemes.GetSize(); ++ii )
        {
            if ( trGUI.Children.Item(ii).nVal == 0 )
                continue;

			bDoDelete = true;
			///------ Folger 09/15/2011 ORG-3718-P3 PROPER_THEME_NAME_HANDLONG_IN_DATA_DISPLAY_SETTINGS
			if ( nSel == ii )
				tree_set_theme_file_name(tr, STR_THEME_NONE);
			///------ End PROPER_THEME_NAME_HANDLONG_IN_DATA_DISPLAY_SETTINGS
            if ( okutil_cvt_str_to_predefined_type(vsThemes[ii]) == PDS_SHEET )
            {
                string strStorage = "XFTHEME_" + strClassOption;
                strStorage.MakeUpper();
                Layer lay = Project.ActiveLayer();
                if ( !lay )
                {
                    ASSERT(false);
                    continue;
                }
                lay.SetMemory(strStorage, NULL);
            }
			///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
            //else if ( okutil_cvt_str_to_predefined_type(vsThemes[ii]) == PDS_DEFAULT )
            else if ( is_theme_default(vsThemes[ii]) )
			///---END CLEAN_DEFAULT_THEME
            {
                theme_reset_default_settings(strClassOption);
            }
            ///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
            else if ( theme_is_folder_last_used(vsThemes[ii]) )
            {
            	theme_remove_xf_folder_last_used(strClassOption);
            }
            ///------ End SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
            else
            {
				///------ Folger 09/07/2011 ORG-3718-P1 DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
				if ( pCustomized )
				{
					bDoDelete = FALSE;

					pCustomized->vsThemesToDelete.Add(vsThemes[ii]);
					pCustomized->strBackupPath = strPath;
					continue;
				}
				///------ End DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME

                if ( okutil_cvt_str_to_predefined_type(vsThemes[ii]) == PDS_LAST_USED )
                    vsThemes[ii] = THEME_FILENAME_LAST_USED;
                /// Iris 7/18/2011 ORG-3273 SAVE_THEME_WITH_CORRECT_NAME_AND_FOLDER
                //string strThemeFile = okutil_theme_get_settings_file(vsThemes[ii], strClassOption);
                string strThemeFile = okutil_theme_get_settings_file(vsThemes[ii], strClassOption, nThemeType);
                ///End SAVE_THEME_WITH_CORRECT_NAME_AND_FOLDER
				if ( strThemeFile.IsFile() )
				{
					copyfile(strThemeFile, strPath + GetFileName(strThemeFile));	//------ Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER
					okutil_delete_file(strThemeFile);
				}
            }
        }
		if ( bDoDelete )
		{
			///------ Folger 09/07/2011 ORG-3718-P1 DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
			//OptionalMessage("ThemeFolderOfDelEx", MB_OK);	//------ Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER
			//UpdateThemesMenuItems(strClassOption);
			theme_show_delete_msg(strClassOption);
			///------ End DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
		}
		/// Iris 7/18/2011 TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
		return true;
		///End TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
    }
    /// Iris 7/18/2011 TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
    return false; // user clicked Calcel button
    ///End TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
}

//------ End SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
///Sophy 10/22/2008 QA80-12422 SUPPORT_SAVE_SHEET_THEME_FOR_EXCEL_CSV_IMPORT need to use it in impCSV.OXF, move from impASC.OXF, rename it
//----- CPY 9/1/2007 QA70-10231 SHOW_THEME_IN_FILE_DIALOG
///Sophy 10/22/2008 QA80-12422 SUPPORT_SAVE_SHEET_THEME_FOR_EXCEL_CSV_IMPORT 
//static string _get_show_options_label(const TreeNode& trGetN)
string	get_show_options_label(const TreeNode& trGetN)
///end SUPPORT_SAVE_SHEET_THEME_FOR_EXCEL_CSV_IMPORT
{
	string str = STR_SHOW_OPT_DLG;
	string strTheme;
	int themeType = theme_get_display_name(trGetN, strTheme);
	if(themeType >= PDS_USER)
	///---Sim 11-07-2007 CLEAN_LOCALIZATION_CODE
		//str += ": " + strTheme;	
	{
		if ( themeType > PDS_USER )
			strTheme = GetLocalized(strTheme);
		str += ": " + strTheme;
	}
	///---END CLEAN_LOCALIZATION_CODE
	return str;
}
//-----
///end SUPPORT_SAVE_SHEET_THEME_FOR_EXCEL_CSV_IMPORT

///---Sim 12-12-2008 IMPROVE_XF_WIZARD_FAILED_LOAD_THEME_ERROR_MESSAGE
string theme_get_full_xf_wizard_name(LPCSTR lpcszClassOption)
{
	string str = _L("XF Wizard");
	str += " ";
	str += lpcszClassOption;
	return str;
}
///---END IMPROVE_XF_WIZARD_FAILED_LOAD_THEME_ERROR_MESSAGE


//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
// Begin OC functions to be used from LabTalk directly
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//---- CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS
//#pragma labtalk(1) //--- CPY 7/26/05 hide all functions in this file from LT access, as XF should be used instead
#pragma labtalk(2)	// the following can be used from LT only inside the "run -oc cmd" syntax, or "run -oc {val=func(arg)}" syntax.
//----

/// Hong QA80-11640 v8.0982b SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING
// This function can only distinguish worksheet/graph theme file
int get_page_theme_type(string strFileName)
{
	if ( !strFileName.IsFile() )
		return -1;
	string		strExt;
	if ( !separate_file_name_ext(strFileName, NULL, &strExt) || 0 != strExt.CompareNoCase(THEME_FILE_EXT) )
		return -2;
	
	Tree		tr;
	if ( !tr.Load(strFileName) )
		return -3;
	
	///Kyle 10/11/2011 ORG-3420-P1 WRONG_THEME_TYPE_DETECTING_METHOD
//	TreeNode	trRoot = tree_get_node_by_id(tr, OTID_ROOT);
//	if ( !trRoot )
//		return -4;
//	
//	if ( tree_get_node_by_id(trRoot, OTID_PAGE) && tree_get_node_by_id(trRoot, OTID_GLOBAL) )
//		return THTYPE_GRAPH;
//	
//	return THTYPE_WORKSHEET;
	int nObjs = 0;
	tr.GetAttribute(THEME_OBJECT_BITS_NAME, nObjs);

	if( nObjs & FOB_WKS_MASK )
		return THTYPE_WORKSHEET;
	return THTYPE_GRAPH;
	///End WRONG_THEME_TYPE_DETECTING_METHOD
}

int	install_theme(string strFileName, int nThemeType)
{
	if ( !strFileName.IsFile() )
		return -1; // Invalid full filename
	
	string strThemeFile = okutil_theme_get_theme_file_name(GetFileName(strFileName, TRUE), nThemeType);
	string strPathOnly = GetFilePath(strThemeFile);
	if ( CheckMakePath(strPathOnly) )
	{		
		if ( strThemeFile.IsFile() && MessageBox(NULL, STR_SAVE_THEME_ASK_REPLACE, _L("Install theme"), MB_OKCANCEL) == IDCANCEL )
		{
			return 1; // user cancel
		}
		
		if( !CopyFile(strFileName, strThemeFile) )
		{
			popup_errmsg_save_readonly_file( strThemeFile, NULL );
			return -2; // fail to repace readonly file
		}
		/// Hong 12/19/08 QA80-11640 DRAG_AND_DROP_THEME_SHOULD_UPDATE_FLAY_OUT_MENU
		string				strName, strTool, strScope, strCategory;
		if ( theme_filename_to_options(strThemeFile, strName, strTool, strScope, strCategory) )
			UpdateThemesMenuItems(strTool);
		/// end DRAG_AND_DROP_THEME_SHOULD_UPDATE_FLAY_OUT_MENU
		
		return 0; // success	
	}
	return -3; // fail create path
}
/// end SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING


//---- CPY 12/19/06 QA70-12736 RESTORE_THEME_OC_FUNC_FOR_LT_DIRECT_CALL
#pragma labtalk(1, Theme)
//----
/// RVD 9/23/2008 qa80-12200 PASTE_FORMAT_OVERWRITES_SPECIAL_ZOOM_LABELS
bool	CopyZoomFormat()
{
	return theme_copy_format(FPB_STYLE|FPB_OTHER, FOB_ALL & ~(FOB_OBJECT|FOB_DIMENSION|FOB_SCALE|FOB_GLOBAL|FOB_WKS_MASK));
}
/// end PASTE_FORMAT_OVERWRITES_SPECIAL_ZOOM_LABELS

bool	CopyFormat()
{
	return theme_copy_format_menu(SAVETHEME_ALL); 
}

bool	CopyFormatAllStyles()
{
	return theme_copy_format_menu(SAVETHEME_ALL_STYLES); 
}

bool	CopyFormatColors()
{
	return theme_copy_format_menu(SAVETHEME_COLORS); 
}

bool	CopyFormatFonts()
{
	return theme_copy_format_menu(SAVETHEME_FONTS); 
}

bool	CopyFormatScales()
{
	return theme_copy_format_menu(SAVETHEME_SCALES); 
}

bool	CopyFormatDimensions()
{
	return theme_copy_format_menu(SAVETHEME_DIMS); 
}

bool	CopyFormatText()
{
	return theme_copy_format_menu(SAVETHEME_TEXT); 
}

bool	CopyFormatBackground()
{
	return theme_copy_format_menu(SAVETHEME_BACKGROUND); 
}

bool	CopyFormatPlot()
{
	return theme_copy_format_menu(SAVETHEME_PLOTS); 
}

///------ Folger 08/04/10 ORG-705 COPY_COLORMAP_FORMAT_CONTEXT_MENU
bool	CopyFormatColormap()
{
	if( Selection.Objects.Count() <= 0 )
		return false;

	DataPlot	dp;
	dp = (DataPlot)Selection.Objects(0);
	if ( !dp )
	///------ Folger 08/27/2010 ORG-679-P9 COLORMAP_OF_WATERFALL_FAILED_TO_BE_COPIED
		//return false;
	{
		/// Kenny 07/20/2012 ORG-6234-P1 PLOT_ELEMENT_COPY_COLORMAP_FORMAT
		PlotElement pe;
		pe = (PlotElement)Selection.Objects(0);
		if (pe)
		{
			dp = pe.GetDataPlot();
		}
		if ( !dp )
		/// End PLOT_ELEMENT_COPY_COLORMAP_FORMAT
		{
			GroupPlot	gp;
			gp = (GroupPlot)Selection.Objects(0);
			if ( !gp )
				return false;
			dp = gp.GetDataPlot(0);
		}
	}
	///------ End COLORMAP_OF_WATERFALL_FAILED_TO_BE_COPIED

	return dp.CopyColormapFormat();
}
///------ End COPY_COLORMAP_FORMAT_CONTEXT_MENU

/// RVD 9/15/2003 QA70-5179 v7.0695 THEME_SPECIAL_CONTEXT_MENU
bool	CopyFormatSpecial(int nIndex)
{
	return theme_copy_format(FPB_NONE, nIndex & FOB_SPECIAL);
}
/// end THEME_SPECIAL_CONTEXT_MENU

///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
class	XFFolderLastUsedThemeUpdater
{
public:
	XFFolderLastUsedThemeUpdater(TreeNode& trXF = NULL);
	
	BOOL	IsSupported();	
	BOOL	Load(TreeNode& trGetN, TreeNode& trThemeOut = NULL);	
	BOOL	Save(TreeNode& trGetN);
	BOOL	Remove(LPCSTR lpcsClassOption);
	
private:	
	string	GetClassOption(TreeNode& trGetN);

private:
	TreeNode		m_trXF;
};

XFFolderLastUsedThemeUpdater::XFFolderLastUsedThemeUpdater(TreeNode& trXF)
{
	if ( trXF )
		m_trXF = trXF;
}

BOOL	XFFolderLastUsedThemeUpdater::IsSupported()
{
	TreeNode	trSupported = tree_get_node_by_tagname(m_trXF, "SupportFolderLastUsed", TRUE);
	return 		trSupported ? trSupported.nVal : TRUE;
}

BOOL	XFFolderLastUsedThemeUpdater::Load(TreeNode& trGetN, TreeNode& trThemeOut/* = NULL*/)
{
	if ( !IsSupported() )
	{
		ASSERT(FALSE);
		return FALSE;
	}
	
	Tree tr;
	if ( okutil_access_folder_last_used_theme(GetClassOption(trGetN), &tr) )
	{
		BOOL	bRet = _theme_load_settings(trGetN, tr, STR_FOLDER_LAST_USED, trThemeOut);
		tree_set_theme_file_name(trGetN, STR_FOLDER_LAST_USED);
		return bRet;
	}
	
	return FALSE;
}

BOOL	XFFolderLastUsedThemeUpdater::Save(TreeNode& trGetN)
{
	if ( !IsSupported() )
		return FALSE;
	
	Tree tr;
	if ( _theme_save_settings(trGetN, NULL, NULL, tr) )
	{
		BOOL	bRet = okutil_access_folder_last_used_theme(GetClassOption(trGetN), &tr, THEME_FOLDER_LAST_USED_SET);
		tree_set_theme_file_name(trGetN, STR_FOLDER_LAST_USED);
		_update_theme_item_after_save(trGetN);
		return bRet;
	}
	
	return FALSE;
}

BOOL	XFFolderLastUsedThemeUpdater::Remove(LPCSTR lpcsClassOption)
{
	if ( !IsSupported() )
	{
		ASSERT(FALSE);
		return FALSE;
	}
	
	return okutil_access_folder_last_used_theme(lpcsClassOption, NULL, THEME_FOLDER_LAST_USED_REMOVE);
}

string	XFFolderLastUsedThemeUpdater::GetClassOption(TreeNode& trGetN)
{
	string strClassOption;
	theme_get_class_option(trGetN, strClassOption);
	return strClassOption;
}

BOOL	theme_update_xf_folder_last_used(TreeNode& trGetN, TreeNode& trXF)
{
	XFFolderLastUsedThemeUpdater	clUpdater(trXF);
	return clUpdater.Save(trGetN);
}

BOOL	theme_load_xf_folder_last_used(TreeNode& trGetN, TreeNode& trThemeOut/* = NULL*/)
{
	XFFolderLastUsedThemeUpdater	clUpdater;
	return clUpdater.Load(trGetN, trThemeOut);
}

BOOL	theme_remove_xf_folder_last_used(LPCSTR lpcszClassOption)
{
	XFFolderLastUsedThemeUpdater	clUpdater;
	return clUpdater.Remove(lpcszClassOption);
}
///------ End SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS

///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
BOOL	theme_force_load_factory_attribute_access(TreeNode& tr, int nOption)
{
	LPCSTR	lpcszForceLoadFactory = "ThemeForceLoadFactory";

	int		nn = 0;
	switch ( nOption )
	{
	case THEMEFORCELOADFACTORY_GET:
		return tr.GetAttribute(lpcszForceLoadFactory, nn);

	case THEMEFORCELOADFACTORY_SET:
		return tr.SetAttribute(lpcszForceLoadFactory, 1);

	case THEMEFORCELOADFACTORY_RESET:
		return tr.RemoveAttribute(lpcszForceLoadFactory);

	default:
		ASSERT(FALSE);
		break;
	}
	
	return FALSE;
}
///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT

///------ Folger 04/22/10 QA81-15348 OP_CHANGE_FROM_PA
BOOL	WizOperationChangeHelper::Convert(TreeNode& tr, BOOL bThemeToGetN)
{
	TreeNode	trWiz = Wiz(tr);
	if ( !trWiz )
		return FALSE;
	
	foreach ( TreeNode trNode in trWiz.Children )
	{
		if ( !IsStep(trNode) )
			continue;
		
		TreeNode	trXF = XF(trNode);
		if ( !trXF )
			return FALSE;
		
		if ( bThemeToGetN )
		{
			if ( !ThemeToGetN(trXF, trNode.tagName) )
				return FALSE;
		}
		else
		{
			if ( !GetNToTheme(trXF) )
				return FALSE;
		}
	}
	
	return TRUE;
}
	
BOOL	WizOperationChangeHelper::ThemeToGetN(TreeNode& tr, LPCSTR lpcszXFName)
{
	XFBase		xf(lpcszXFName);
	if ( !xf )
		return FALSE;
	
	Tree		trTmp;
	TreeNode	trGetN;
	if ( !xf.GetGUI(trTmp, trGetN) )
		return FALSE;
	
	if ( !_theme_load_settings(trGetN, tr, "") )
		return FALSE;
	
	CustomGetN(trGetN);
	return tr.Replace(trGetN, TRUE, TRUE);
}

BOOL	WizOperationChangeHelper::GetNToTheme(TreeNode& tr)
{
	Tree	trTheme;
	if ( !_theme_save_settings(tr, NULL, NULL, trTheme) )
		return FALSE;
	
	return tr.Replace(trTheme, TRUE, TRUE);
}

TreeNode	WizOperationChangeHelper::Wiz(TreeNode& tr)
{
	return tr.wizExtern.wizTheme;
}

TreeNode	WizOperationChangeHelper::XF(TreeNode& trNode)
{
	return trNode.ThemeTree;
}

BOOL		WizOperationChangeHelper::IsStep(TreeNode& tr)
{
	static	vector<string>	l_vs = { "pa_"
		, "spfm"
	};
	
	for ( int ii=0; ii<l_vs.GetSize(); ++ii )
	{
		if ( tr.tagName.Find(l_vs[ii]) == 0 )
			return TRUE;
	}
	
	return FALSE;
}

void		WizOperationChangeHelper::CustomGetN(TreeNode& trGetN)
{
	string		strXFName;
	trGetN.GetAttribute(STR_XFUNCTION_NAME_ATTRIB, strXFName);
	if ( strXFName.Find("fit") > 0 )
	{
		octree_set_attribute_to_all_nodes(&trGetN, STR_SHOW_ATTRIB, "1", true);
	}
}
///------ End OP_CHANGE_FROM_PA

///------ Folger 02/16/2011 ORG-2237-S2 SUPPORT_MERGE_COMMON_LABELS_AFTER_GENERATE_REPORT_DATA
BOOL	theme_set_label_merge(Worksheet& wks, int nLabelType, int nMode)
{
	if ( !wks )
		return FALSE;
	
	string strName;
	switch ( nLabelType )
	{
	case RCLT_LONG_NAME:
		strName = STR_NAMESTYLE_LONG_NAME;
		break;

	case RCLT_UNIT:
		strName = STR_NAMESTYLE_UNITS;
		break;

	case RCLT_COMMENT:
		strName = STR_NAMESTYLE_COMMENTS;
		break;

	case RCLT_SAMPLE_RATE:
		strName = STR_NAMESTYLE_SAMPLE_RATE;
		break;

	///------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	case RCLT_REPLICATES:
		strName = STR_NAMESTYLE_REPLICATES;
		break;
	///------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT

	default:
		if ( nLabelType >= RCLT_PARAM && nLabelType < RCLT_PARAM + PARAMS_MAX_NUM )
		{
			strName = STR_NAMESTYLE_PARAM;
			break;
		}
		if ( nLabelType >= RCLT_UDL && nLabelType < RCLT_UDL + UDL_MAX_NUM )
		{
			strName = STR_NAMESTYLE_UDL;
			break;
		}

		return FALSE;
	}
	
	Grid grid;
	grid.Attach(wks);

	Tree tr;
	tr.Root.NameStyles.NameStyle1.Name.strVal = strName;
	tr.Root.NameStyles.NameStyle1.Style.Merge.nVal = nMode;

	return 0 == grid.UpdateThemeIDs(tr.Root) && grid.ApplyFormat(tr, TRUE, TRUE);
}
///------ End SUPPORT_MERGE_COMMON_LABELS_AFTER_GENERATE_REPORT_DATA

/// Iris 3/08/2011 ORG-402-S8 IMPROVE_SURFACE_FIT_REPORT_DATA_LABEL
BOOL	theme_set_range_alignment(Worksheet& wks, const RECT& rng, int nMode)
{
	if ( !wks )
		return FALSE;
	
	Grid grid;
	grid.Attach(wks);
	
	Tree tr;
	tr.Root.RangeStyles.RangeStyle1.Style.Alignment.Horizontal.nVal = nMode;
	tr.Root.RangeStyles.RangeStyle1.Left.nVal = rng.left;
	tr.Root.RangeStyles.RangeStyle1.Top.nVal = rng.top;
	tr.Root.RangeStyles.RangeStyle1.Right.nVal = rng.right;
	tr.Root.RangeStyles.RangeStyle1.Bottom.nVal = rng.bottom;

	return 0 == grid.UpdateThemeIDs(tr.Root) && grid.ApplyFormat(tr, TRUE, TRUE);	
}
///End IMPROVE_SURFACE_FIT_REPORT_DATA_LABEL

///------ Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
BOOL	theme_copy_settings(TreeNode& trGetN)
{
	Tree	tr;
	if ( !_theme_save_settings(trGetN, NULL, NULL, tr) )
		return FALSE;

	octree_node_copy_attribute(&trGetN, &tr, STR_CLASS_OPTION_NAME_ATTRIB);
	
	string	strXML;
	if ( !tr.GetString(strXML) )
		return FALSE;

	return copy_to_clipboard(strXML, true, false);
}

BOOL	theme_paste_settings(TreeNode& trGetN)
{
	Tree	tr;
	if ( !theme_can_paste_settings(trGetN, &tr) )
		return FALSE;

	return _theme_load_settings(trGetN, tr, NULL);
}

BOOL	theme_can_paste_settings(TreeNode& trGetN, TreeNode* ptrPasted/* = NULL*/)
{
	string		strXML;
	if ( !GetClipboardText(strXML) )
		return FALSE;

	Tree		tr;
	if ( !tr.SetString(strXML) )
		return FALSE;

	if ( ptrPasted )
		*ptrPasted = tr.Clone();

	string		strClassOption1, strClassOption2;
	theme_get_class_option(trGetN, strClassOption1);
	theme_get_class_option(tr, strClassOption2);
	return strClassOption1.Compare(strClassOption2) == 0;
}
///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT

/// Zech 08/11/2011 ORG-3492-P2 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
BOOL	theme_can_save(LPCSTR lpcstrThemeName)
{
	bool bEnable = true;
	int nPathType;
	okutil_separate_composite_name(lpcstrThemeName, &nPathType, NULL, ORIGIN_PATH_USER);				
	
#ifndef NEW_DEFAULT_THEME_MECHANISM

	if( PDS_LAST_USED == cvt_str_to_predefined_type(lpcstrThemeName) || PDS_FACTORY_DEFAULT == cvt_str_to_predefined_type(lpcstrThemeName) || ORIGIN_PATH_SYSTEM == nPathType)
#else
	if( PDS_LAST_USED == cvt_str_to_predefined_type(lpcstrThemeName) || theme_is_factory_default(lpcstrThemeName) || ORIGIN_PATH_SYSTEM == nPathType)
#endif
	bEnable = false;
	return bEnable;
}

/// END DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED

/// Zech 09/05/2012 ORG-3591-S1 OC_FUNC_FOR_ACCESS_REPORT_TABLE_CONTEXT_MENU
static Operation* _get_operation(Grid& grid)
{
	Worksheet wks;
	grid.GetOwner(wks);

	if ( wks )
	{
		Operation& op = (Operation&)wks.GetSrcOperation();
		if ( op )
			return &op;
	}

	return NULL;
}

//////////////////////////////////////////////////////////////////////////
///		ReportTableOperationHelper
//////////////////////////////////////////////////////////////////////////

ReportTableOperationHelper::ReportTableOperationHelper(Worksheet &wks, UINT nNID)
{
	m_grid.Attach(wks, nNID, TRUE);
}

ReportTableOperationHelper::ReportTableOperationHelper(Grid	&grid)
{
	m_grid = grid;
}

ReportTableOperationHelper::~ReportTableOperationHelper()
{
}

void	ReportTableOperationHelper::EditTableHeader(LPCSTR lpcszComments)
{
	grid_edit_user_comments(m_grid, lpcszComments);
}

void	ReportTableOperationHelper::CopyTable()
{
	grid_copy_to_clipboard(m_grid);
}

void	ReportTableOperationHelper::MakeCopyAsFlatSheet()
{
	grid_make_copy_as_flat_sheet(m_grid);
}

void	ReportTableOperationHelper::MakeCopyAsFlatSheetTransposed()
{
	grid_make_copy_as_flat_sheet(m_grid, TRUE);
}

void	ReportTableOperationHelper::CopyFootnote()
{
	m_grid.CopyFootnote();
}

void	ReportTableOperationHelper::Replot()
{
	Worksheet wks;
	m_grid.GetOwner(wks);
	Operation*		op = _get_operation(m_grid);
	if( !op )
		return;

	/// Folger, This line is needed for prevent grid keep refreshing.
	/// No idea how it works, just a workaround, need to improve.
	wks.Invalidate(FALSE);
	op->ReplotReportGraphs();
}

bool	ReportTableOperationHelper::ChangeDataIdentifiers(LPCSTR lpcszID)
{
	Operation* op = _get_operation(m_grid);
	if (!op)
		return false;

	return op->ChangeDataIdentifiers(lpcszID);
}

void	ReportTableOperationHelper::RearrangeSameTypePlots()
{
	Worksheet wks;
	m_grid.GetOwner(wks);

	Operation* op = _get_operation(m_grid);
	if ( !op )
		return;
	op->RearrangeReportPlots(wks);
}
/// END OC_FUNC_FOR_ACCESS_REPORT_TABLE_CONTEXT_MENU



//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
///// end OC function used from LT ///////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////

